/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Manager.h"
#include "net/connman/ManagerDBus.h"
#include "net/connman/ManagerJson.h"
#include "net/connman/ManagerProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Manager {

DEFINE_CLASS_LOGGER("/net/Connman/net/connman/Manager", ManagerProxy);

class ManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ManagerProxy >& proxyShared = ::boost::static_pointer_cast< ManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_TechnologyAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TechnologyAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TechnologyAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<TechnologyAddedSignal> payload = ::boost::static_pointer_cast<TechnologyAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((TechnologyAddedCallbackIF*) _callback)->onTechnologyAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_TechnologyRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TechnologyRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TechnologyRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<TechnologyRemovedSignal> payload = ::boost::static_pointer_cast<TechnologyRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((TechnologyRemovedCallbackIF*) _callback)->onTechnologyRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_PropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PropertyChangedSignal> payload = ::boost::static_pointer_cast<PropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ServicesChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ServicesChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ServicesChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ServicesChangedSignal> payload = ::boost::static_pointer_cast<ServicesChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ServicesChangedCallbackIF*) _callback)->onServicesChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetTechnologies:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetTechnologiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTechnologies", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetTechnologiesError> payload = ::boost::static_pointer_cast<GetTechnologiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetTechnologiesCallbackIF*) _callback)->onGetTechnologiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetTechnologiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTechnologies", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetTechnologiesResponse> payload = ::boost::static_pointer_cast<GetTechnologiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetTechnologiesCallbackIF*) _callback)->onGetTechnologiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetServices:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetServicesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetServices", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetServicesError> payload = ::boost::static_pointer_cast<GetServicesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetServicesCallbackIF*) _callback)->onGetServicesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetServicesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetServices", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetServicesResponse> payload = ::boost::static_pointer_cast<GetServicesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetServicesCallbackIF*) _callback)->onGetServicesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RegisterAgent:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterAgentError> payload = ::boost::static_pointer_cast<RegisterAgentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterAgentResponse> payload = ::boost::static_pointer_cast<RegisterAgentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnregisterAgent:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterAgentError> payload = ::boost::static_pointer_cast<UnregisterAgentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterAgentResponse> payload = ::boost::static_pointer_cast<UnregisterAgentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CreateSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CreateSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateSessionError> payload = ::boost::static_pointer_cast<CreateSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateSessionCallbackIF*) _callback)->onCreateSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateSessionResponse> payload = ::boost::static_pointer_cast<CreateSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateSessionCallbackIF*) _callback)->onCreateSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DestroySession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DestroySessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DestroySession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestroySessionError> payload = ::boost::static_pointer_cast<DestroySessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DestroySessionCallbackIF*) _callback)->onDestroySessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestroySessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DestroySession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestroySessionResponse> payload = ::boost::static_pointer_cast<DestroySessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DestroySessionCallbackIF*) _callback)->onDestroySessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_TechnologyAdded: {
                ::boost::shared_ptr< TechnologyAddedError > payload = ::boost::shared_ptr< TechnologyAddedError >
                (new TechnologyAddedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TechnologyAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TechnologyAddedCallbackIF*) _callback)->onTechnologyAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TechnologyRemoved: {
                ::boost::shared_ptr< TechnologyRemovedError > payload = ::boost::shared_ptr< TechnologyRemovedError >
                (new TechnologyRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TechnologyRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TechnologyRemovedCallbackIF*) _callback)->onTechnologyRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PropertyChanged: {
                ::boost::shared_ptr< PropertyChangedError > payload = ::boost::shared_ptr< PropertyChangedError >
                (new PropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ServicesChanged: {
                ::boost::shared_ptr< ServicesChangedError > payload = ::boost::shared_ptr< ServicesChangedError >
                (new ServicesChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ServicesChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ServicesChangedCallbackIF*) _callback)->onServicesChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetTechnologies: {
                ::boost::shared_ptr< GetTechnologiesError > payload = ::boost::shared_ptr< GetTechnologiesError >
                (new GetTechnologiesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetTechnologies", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetTechnologiesCallbackIF*) _callback)->onGetTechnologiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetServices: {
                ::boost::shared_ptr< GetServicesError > payload = ::boost::shared_ptr< GetServicesError >
                (new GetServicesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetServices", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetServicesCallbackIF*) _callback)->onGetServicesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RegisterAgent: {
                ::boost::shared_ptr< RegisterAgentError > payload = ::boost::shared_ptr< RegisterAgentError >
                (new RegisterAgentError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnregisterAgent: {
                ::boost::shared_ptr< UnregisterAgentError > payload = ::boost::shared_ptr< UnregisterAgentError >
                (new UnregisterAgentError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CreateSession: {
                ::boost::shared_ptr< CreateSessionError > payload = ::boost::shared_ptr< CreateSessionError >
                (new CreateSessionError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CreateSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CreateSessionCallbackIF*) _callback)->onCreateSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DestroySession: {
                ::boost::shared_ptr< DestroySessionError > payload = ::boost::shared_ptr< DestroySessionError >
                (new DestroySessionError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DestroySession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DestroySessionCallbackIF*) _callback)->onDestroySessionError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ManagerProxyCallback::_logger (ManagerProxy::_logger);

ManagerProxy::ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "net.connman.Manager", serviceAvailable, _logger) {
}

ManagerProxy::~ManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ManagerProxy > ManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t ManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ManagerProxyCallback* callback = new ManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ManagerProxyCallback* callback = new ManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void ManagerProxy::sendDeregisterAll () const
{
    sendTechnologyAddedDeregisterAll();
    sendTechnologyRemovedDeregisterAll();
    sendPropertyChangedDeregisterAll();
    sendServicesChangedDeregisterAll();
}

act_t ManagerProxy::sendTechnologyAddedRegister(TechnologyAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "TechnologyAdded");
    act_t act = addSignalCallback(ID_TechnologyAdded, "TechnologyAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TechnologyAdded", &cb, act);
    return act;
}

bool ManagerProxy::sendTechnologyAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TechnologyAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TechnologyAdded", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendTechnologyAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TechnologyAdded");
    _dbusProxyDelegate->deregisterSignalCallback("TechnologyAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendTechnologyRemovedRegister(TechnologyRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "TechnologyRemoved");
    act_t act = addSignalCallback(ID_TechnologyRemoved, "TechnologyRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TechnologyRemoved", &cb, act);
    return act;
}

bool ManagerProxy::sendTechnologyRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TechnologyRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TechnologyRemoved", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendTechnologyRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TechnologyRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("TechnologyRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PropertyChanged");
    act_t act = addSignalCallback(ID_PropertyChanged, "PropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PropertyChanged", &cb, act);
    return act;
}

bool ManagerProxy::sendPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("PropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendServicesChangedRegister(ServicesChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ServicesChanged");
    act_t act = addSignalCallback(ID_ServicesChanged, "ServicesChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ServicesChanged", &cb, act);
    return act;
}

bool ManagerProxy::sendServicesChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ServicesChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ServicesChanged", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendServicesChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ServicesChanged");
    _dbusProxyDelegate->deregisterSignalCallback("ServicesChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendGetTechnologiesRequest(GetTechnologiesCallbackIF& cb) const {
    GetTechnologiesRequest* payload = new GetTechnologiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetTechnologies", GetTechnologiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetTechnologies, dbusMessage.getUniqueSerial(), "GetTechnologies", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetTechnologies", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendGetServicesRequest(GetServicesCallbackIF& cb) const {
    GetServicesRequest* payload = new GetServicesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetServices", GetServicesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetServices, dbusMessage.getUniqueSerial(), "GetServices", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetServices", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendRegisterAgentRequest(RegisterAgentCallbackIF& cb, const ::std::string& path) const {
    RegisterAgentRequest* payload = new RegisterAgentRequest();
    CHECK_ALLOCATION(payload);
    payload->setPath(path);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterAgent", RegisterAgentRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterAgent, dbusMessage.getUniqueSerial(), "RegisterAgent", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterAgent", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendUnregisterAgentRequest(UnregisterAgentCallbackIF& cb, const ::std::string& path) const {
    UnregisterAgentRequest* payload = new UnregisterAgentRequest();
    CHECK_ALLOCATION(payload);
    payload->setPath(path);
    DBUS_MESSAGE_CALL(dbusMessage, "UnregisterAgent", UnregisterAgentRequest, payload, true)
    act_t act = addMethodCallback(ID_UnregisterAgent, dbusMessage.getUniqueSerial(), "UnregisterAgent", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnregisterAgent", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendCreateSessionRequest(CreateSessionCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings, const ::std::string& notifier) const {
    CreateSessionRequest* payload = new CreateSessionRequest();
    CHECK_ALLOCATION(payload);
    payload->setSettings(settings);
    payload->setNotifier(notifier);
    DBUS_MESSAGE_CALL(dbusMessage, "CreateSession", CreateSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_CreateSession, dbusMessage.getUniqueSerial(), "CreateSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CreateSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendDestroySessionRequest(DestroySessionCallbackIF& cb, const ::std::string& session) const {
    DestroySessionRequest* payload = new DestroySessionRequest();
    CHECK_ALLOCATION(payload);
    payload->setSession(session);
    DBUS_MESSAGE_CALL(dbusMessage, "DestroySession", DestroySessionRequest, payload, true)
    act_t act = addMethodCallback(ID_DestroySession, dbusMessage.getUniqueSerial(), "DestroySession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DestroySession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Manager
} // namespace connman
} // namespace net
