#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_MANAGER_H
#define NET_CONNMAN_MANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "Manager" isn't clear, then there should be a description here.
 */

namespace net {
namespace connman {
namespace Manager {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_GetTechnologies = 1;
static const uint16 ID_GetServices = 2;
static const uint16 ID_RegisterAgent = 3;
static const uint16 ID_UnregisterAgent = 4;
static const uint16 ID_CreateSession = 5;
static const uint16 ID_DestroySession = 6;

// signal IDs
static const uint16 ID_TechnologyAdded = 7;
static const uint16 ID_TechnologyRemoved = 8;
static const uint16 ID_PropertyChanged = 9;
static const uint16 ID_ServicesChanged = 10;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetPropertiesResponse;

class GetTechnologiesResponseTechnologiesStruct;

class GetTechnologiesResponse;

class GetServicesResponseServicesStruct;

class GetServicesResponse;

class RegisterAgentRequest;

class UnregisterAgentRequest;

class CreateSessionRequest;

class CreateSessionResponse;

class DestroySessionRequest;

class TechnologyAddedSignal;

class TechnologyRemovedSignal;

class PropertyChangedSignal;

class ServicesChangedSignalChangedStruct;

class ServicesChangedSignal;

// type definitions
/**
 * If the meaning of "GetPropertiesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * If the meaning of "GetTechnologiesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetTechnologiesRequest;

/**
 * If the meaning of "GetTechnologiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetTechnologiesError;

/**
 * If the meaning of "GetServicesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetServicesRequest;

/**
 * If the meaning of "GetServicesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetServicesError;

/**
 * If the meaning of "RegisterAgentResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RegisterAgentResponse;

/**
 * If the meaning of "RegisterAgentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterAgentError;

/**
 * If the meaning of "UnregisterAgentResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnregisterAgentResponse;

/**
 * If the meaning of "UnregisterAgentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnregisterAgentError;

/**
 * If the meaning of "CreateSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CreateSessionError;

/**
 * If the meaning of "DestroySessionResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DestroySessionResponse;

/**
 * If the meaning of "DestroySessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DestroySessionError;

/**
 * If the meaning of "TechnologyAddedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TechnologyAddedError;

/**
 * If the meaning of "TechnologyRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TechnologyRemovedError;

/**
 * If the meaning of "PropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PropertyChangedError;

/**
 * If the meaning of "ServicesChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ServicesChangedError;


/**
 * If the meaning of "GetPropertiesResponse" isn't clear, then there should be a description here.
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "properties"

    static const int kProperties = 0;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "GetTechnologiesResponseTechnologiesStruct" isn't clear, then there should be a description here.
 */
class GetTechnologiesResponseTechnologiesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetTechnologiesResponseTechnologiesStruct ();

    /**
     * Copy constructor
     */
    inline  GetTechnologiesResponseTechnologiesStruct (const GetTechnologiesResponseTechnologiesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetTechnologiesResponseTechnologiesStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~GetTechnologiesResponseTechnologiesStruct();

    /**
     * Assignment operator
     */
    inline GetTechnologiesResponseTechnologiesStruct& operator = (const GetTechnologiesResponseTechnologiesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTechnologiesResponseTechnologiesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTechnologiesResponseTechnologiesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTechnologiesResponseTechnologiesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTechnologiesResponseTechnologiesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const GetTechnologiesResponseTechnologiesStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "GetTechnologiesResponse" isn't clear, then there should be a description here.
 */
class GetTechnologiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTechnologiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetTechnologiesResponse (const GetTechnologiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetTechnologiesResponse (const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& technologies_);

    /**
     * Destructor
     */
    inline virtual  ~GetTechnologiesResponse();

    /**
     * Assignment operator
     */
    inline GetTechnologiesResponse& operator = (const GetTechnologiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTechnologiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTechnologiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTechnologiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTechnologiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "technologies"

    static const int kTechnologies = 0;

    /**
     * Clears the field "technologies".
     *
     * The field will be set to its default value. The hasTechnologies()
     * method will return false.
     */
    inline void clearTechnologies();

    /**
     * Checks whether the field "technologies" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTechnologies()). Otherwise it will return false.
     */
    inline bool hasTechnologies () const;

    /**
     * Returns the value of the member "technologies".
     *
     * If the meaning of "technologies" isn't clear, then there should be a description here.
     *
     * @return The value of the field "technologies"
     */
    inline const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& getTechnologies () const;

    /**
     * Retrieves the value of the field "technologies" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "technologies".
     */
    inline ::std::vector< GetTechnologiesResponseTechnologiesStruct >& getTechnologiesMutable ();

    /**
     * Sets the value of the member "technologies".
     *
     * If the meaning of "technologies" isn't clear, then there should be a description here.
     *
     * @param technologies The value which will be set
     */
    inline void setTechnologies (const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& technologies_);

    static const GetTechnologiesResponse &getDefaultInstance();

private:

    static const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& getGetTechnologiesResponseTechnologiesStructList_DefaultInstance ();

    inline void set_has_technologies ();

    inline void clear_has_technologies ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< GetTechnologiesResponseTechnologiesStruct > _technologies;

};

/**
 * If the meaning of "GetServicesResponseServicesStruct" isn't clear, then there should be a description here.
 */
class GetServicesResponseServicesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetServicesResponseServicesStruct ();

    /**
     * Copy constructor
     */
    inline  GetServicesResponseServicesStruct (const GetServicesResponseServicesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetServicesResponseServicesStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~GetServicesResponseServicesStruct();

    /**
     * Assignment operator
     */
    inline GetServicesResponseServicesStruct& operator = (const GetServicesResponseServicesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetServicesResponseServicesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetServicesResponseServicesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetServicesResponseServicesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetServicesResponseServicesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const GetServicesResponseServicesStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "GetServicesResponse" isn't clear, then there should be a description here.
 */
class GetServicesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetServicesResponse ();

    /**
     * Copy constructor
     */
    inline  GetServicesResponse (const GetServicesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetServicesResponse (const ::std::vector< GetServicesResponseServicesStruct >& services_);

    /**
     * Destructor
     */
    inline virtual  ~GetServicesResponse();

    /**
     * Assignment operator
     */
    inline GetServicesResponse& operator = (const GetServicesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetServicesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetServicesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetServicesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetServicesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "services"

    static const int kServices = 0;

    /**
     * Clears the field "services".
     *
     * The field will be set to its default value. The hasServices()
     * method will return false.
     */
    inline void clearServices();

    /**
     * Checks whether the field "services" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServices()). Otherwise it will return false.
     */
    inline bool hasServices () const;

    /**
     * Returns the value of the member "services".
     *
     * If the meaning of "services" isn't clear, then there should be a description here.
     *
     * @return The value of the field "services"
     */
    inline const ::std::vector< GetServicesResponseServicesStruct >& getServices () const;

    /**
     * Retrieves the value of the field "services" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "services".
     */
    inline ::std::vector< GetServicesResponseServicesStruct >& getServicesMutable ();

    /**
     * Sets the value of the member "services".
     *
     * If the meaning of "services" isn't clear, then there should be a description here.
     *
     * @param services The value which will be set
     */
    inline void setServices (const ::std::vector< GetServicesResponseServicesStruct >& services_);

    static const GetServicesResponse &getDefaultInstance();

private:

    static const ::std::vector< GetServicesResponseServicesStruct >& getGetServicesResponseServicesStructList_DefaultInstance ();

    inline void set_has_services ();

    inline void clear_has_services ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< GetServicesResponseServicesStruct > _services;

};

/**
 * If the meaning of "RegisterAgentRequest" isn't clear, then there should be a description here.
 */
class RegisterAgentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterAgentRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterAgentRequest (const RegisterAgentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterAgentRequest (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterAgentRequest();

    /**
     * Assignment operator
     */
    inline RegisterAgentRequest& operator = (const RegisterAgentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterAgentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterAgentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterAgentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterAgentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const RegisterAgentRequest &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "UnregisterAgentRequest" isn't clear, then there should be a description here.
 */
class UnregisterAgentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnregisterAgentRequest ();

    /**
     * Copy constructor
     */
    inline  UnregisterAgentRequest (const UnregisterAgentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnregisterAgentRequest (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~UnregisterAgentRequest();

    /**
     * Assignment operator
     */
    inline UnregisterAgentRequest& operator = (const UnregisterAgentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnregisterAgentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnregisterAgentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnregisterAgentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnregisterAgentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const UnregisterAgentRequest &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "CreateSessionRequest" isn't clear, then there should be a description here.
 */
class CreateSessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSessionRequest ();

    /**
     * Copy constructor
     */
    inline  CreateSessionRequest (const CreateSessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSessionRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings_, const ::std::string& notifier_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSessionRequest();

    /**
     * Assignment operator
     */
    inline CreateSessionRequest& operator = (const CreateSessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "settings"

    static const int kSettings = 0;

    /**
     * Clears the field "settings".
     *
     * The field will be set to its default value. The hasSettings()
     * method will return false.
     */
    inline void clearSettings();

    /**
     * Checks whether the field "settings" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettings()). Otherwise it will return false.
     */
    inline bool hasSettings () const;

    /**
     * Returns the value of the member "settings".
     *
     * If the meaning of "settings" isn't clear, then there should be a description here.
     *
     * @return The value of the field "settings"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getSettings () const;

    /**
     * Retrieves the value of the field "settings" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "settings".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getSettingsMutable ();

    /**
     * Sets the value of the member "settings".
     *
     * If the meaning of "settings" isn't clear, then there should be a description here.
     *
     * @param settings The value which will be set
     */
    inline void setSettings (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings_);

    // API of field "notifier"

    static const int kNotifier = 1;

    /**
     * Clears the field "notifier".
     *
     * The field will be set to its default value. The hasNotifier()
     * method will return false.
     */
    inline void clearNotifier();

    /**
     * Checks whether the field "notifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotifier()). Otherwise it will return false.
     */
    inline bool hasNotifier () const;

    /**
     * Returns the value of the member "notifier".
     *
     * If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @return The value of the field "notifier"
     */
    inline const ::std::string& getNotifier () const;

    /**
     * Retrieves the value of the field "notifier" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "notifier".
     */
    inline ::std::string& getNotifierMutable ();

    /**
     * Sets the value of the member "notifier".
     *
     * If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @param notifier The value which will be set
     */
    inline void setNotifier (const ::std::string& notifier_);

    /**
     * Sets the value of the member "notifier".
     *
     * If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @param notifier The value which will be set
     */
    inline void setNotifier (const char* notifier_);

    /**
     * Sets the value of the member "notifier".
     *
     * If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @param notifier The value which will be set
     */
    inline void setNotifier (const char* value, size_t size);

    static const CreateSessionRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_settings ();

    inline void clear_has_settings ();

    inline void set_has_notifier ();

    inline void clear_has_notifier ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _settings;

    ::std::string _notifier;

};

/**
 * If the meaning of "CreateSessionResponse" isn't clear, then there should be a description here.
 */
class CreateSessionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSessionResponse ();

    /**
     * Copy constructor
     */
    inline  CreateSessionResponse (const CreateSessionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSessionResponse (const ::std::string& session_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSessionResponse();

    /**
     * Assignment operator
     */
    inline CreateSessionResponse& operator = (const CreateSessionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSessionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSessionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSessionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSessionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "session"

    static const int kSession = 0;

    /**
     * Clears the field "session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const ::std::string& session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    static const CreateSessionResponse &getDefaultInstance();

private:

    inline void set_has_session ();

    inline void clear_has_session ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _session;

};

/**
 * If the meaning of "DestroySessionRequest" isn't clear, then there should be a description here.
 */
class DestroySessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DestroySessionRequest ();

    /**
     * Copy constructor
     */
    inline  DestroySessionRequest (const DestroySessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DestroySessionRequest (const ::std::string& session_);

    /**
     * Destructor
     */
    inline virtual  ~DestroySessionRequest();

    /**
     * Assignment operator
     */
    inline DestroySessionRequest& operator = (const DestroySessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestroySessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestroySessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestroySessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestroySessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "session"

    static const int kSession = 0;

    /**
     * Clears the field "session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const ::std::string& session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    static const DestroySessionRequest &getDefaultInstance();

private:

    inline void set_has_session ();

    inline void clear_has_session ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _session;

};

/**
 * If the meaning of "TechnologyAddedSignal" isn't clear, then there should be a description here.
 */
class TechnologyAddedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TechnologyAddedSignal ();

    /**
     * Copy constructor
     */
    inline  TechnologyAddedSignal (const TechnologyAddedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  TechnologyAddedSignal (const ::std::string& path_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~TechnologyAddedSignal();

    /**
     * Assignment operator
     */
    inline TechnologyAddedSignal& operator = (const TechnologyAddedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TechnologyAddedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TechnologyAddedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TechnologyAddedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TechnologyAddedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    // API of field "properties"

    static const int kProperties = 1;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const TechnologyAddedSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_path ();

    inline void clear_has_path ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _path;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "TechnologyRemovedSignal" isn't clear, then there should be a description here.
 */
class TechnologyRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TechnologyRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  TechnologyRemovedSignal (const TechnologyRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  TechnologyRemovedSignal (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~TechnologyRemovedSignal();

    /**
     * Assignment operator
     */
    inline TechnologyRemovedSignal& operator = (const TechnologyRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TechnologyRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TechnologyRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TechnologyRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TechnologyRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const TechnologyRemovedSignal &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "PropertyChangedSignal" isn't clear, then there should be a description here.
 */
class PropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  PropertyChangedSignal (const PropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PropertyChangedSignal (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~PropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline PropertyChangedSignal& operator = (const PropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const PropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::asf::dbus::DBusVariant _value;

};

/**
 * If the meaning of "ServicesChangedSignalChangedStruct" isn't clear, then there should be a description here.
 */
class ServicesChangedSignalChangedStruct {
public:

    /**
     * Default constructor
     */
    inline  ServicesChangedSignalChangedStruct ();

    /**
     * Copy constructor
     */
    inline  ServicesChangedSignalChangedStruct (const ServicesChangedSignalChangedStruct &rhs);

    /**
     * All fields constructor
     */
    inline  ServicesChangedSignalChangedStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~ServicesChangedSignalChangedStruct();

    /**
     * Assignment operator
     */
    inline ServicesChangedSignalChangedStruct& operator = (const ServicesChangedSignalChangedStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServicesChangedSignalChangedStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServicesChangedSignalChangedStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServicesChangedSignalChangedStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServicesChangedSignalChangedStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const ServicesChangedSignalChangedStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "ServicesChangedSignal" isn't clear, then there should be a description here.
 */
class ServicesChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ServicesChangedSignal ();

    /**
     * Copy constructor
     */
    inline  ServicesChangedSignal (const ServicesChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ServicesChangedSignal (const ::std::vector< ServicesChangedSignalChangedStruct >& changed_, const ::std::vector< ::std::string >& removed_);

    /**
     * Destructor
     */
    inline virtual  ~ServicesChangedSignal();

    /**
     * Assignment operator
     */
    inline ServicesChangedSignal& operator = (const ServicesChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServicesChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServicesChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServicesChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServicesChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changed"

    static const int kChanged = 0;

    /**
     * Clears the field "changed".
     *
     * The field will be set to its default value. The hasChanged()
     * method will return false.
     */
    inline void clearChanged();

    /**
     * Checks whether the field "changed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanged()). Otherwise it will return false.
     */
    inline bool hasChanged () const;

    /**
     * Returns the value of the member "changed".
     *
     * If the meaning of "changed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changed"
     */
    inline const ::std::vector< ServicesChangedSignalChangedStruct >& getChanged () const;

    /**
     * Retrieves the value of the field "changed" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changed".
     */
    inline ::std::vector< ServicesChangedSignalChangedStruct >& getChangedMutable ();

    /**
     * Sets the value of the member "changed".
     *
     * If the meaning of "changed" isn't clear, then there should be a description here.
     *
     * @param changed The value which will be set
     */
    inline void setChanged (const ::std::vector< ServicesChangedSignalChangedStruct >& changed_);

    // API of field "removed"

    static const int kRemoved = 1;

    /**
     * Clears the field "removed".
     *
     * The field will be set to its default value. The hasRemoved()
     * method will return false.
     */
    inline void clearRemoved();

    /**
     * Checks whether the field "removed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemoved()). Otherwise it will return false.
     */
    inline bool hasRemoved () const;

    /**
     * Returns the value of the member "removed".
     *
     * If the meaning of "removed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "removed"
     */
    inline const ::std::vector< ::std::string >& getRemoved () const;

    /**
     * Retrieves the value of the field "removed" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "removed".
     */
    inline ::std::vector< ::std::string >& getRemovedMutable ();

    /**
     * Sets the value of the member "removed".
     *
     * If the meaning of "removed" isn't clear, then there should be a description here.
     *
     * @param removed The value which will be set
     */
    inline void setRemoved (const ::std::vector< ::std::string >& removed_);

    static const ServicesChangedSignal &getDefaultInstance();

private:

    static const ::std::vector< ServicesChangedSignalChangedStruct >& getServicesChangedSignalChangedStructList_DefaultInstance ();

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_changed ();

    inline void clear_has_changed ();

    inline void set_has_removed ();

    inline void clear_has_removed ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ServicesChangedSignalChangedStruct > _changed;

    ::std::vector< ::std::string > _removed;

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _properties (properties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearProperties();
}

inline void GetPropertiesResponse::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool GetPropertiesResponse::hasProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void GetPropertiesResponse::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void GetPropertiesResponse::set_has_properties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetTechnologiesResponseTechnologiesStruct::GetTechnologiesResponseTechnologiesStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTechnologiesResponseTechnologiesStruct::GetTechnologiesResponseTechnologiesStruct (const GetTechnologiesResponseTechnologiesStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTechnologiesResponseTechnologiesStruct::GetTechnologiesResponseTechnologiesStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTechnologiesResponseTechnologiesStruct::~GetTechnologiesResponseTechnologiesStruct() {
}

inline GetTechnologiesResponseTechnologiesStruct& GetTechnologiesResponseTechnologiesStruct::operator = (const GetTechnologiesResponseTechnologiesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetTechnologiesResponseTechnologiesStruct::operator == (const GetTechnologiesResponseTechnologiesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetTechnologiesResponseTechnologiesStruct::operator != (const GetTechnologiesResponseTechnologiesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTechnologiesResponseTechnologiesStruct::operator < (const GetTechnologiesResponseTechnologiesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetTechnologiesResponseTechnologiesStruct::operator > (const GetTechnologiesResponseTechnologiesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTechnologiesResponseTechnologiesStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetTechnologiesResponseTechnologiesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool GetTechnologiesResponseTechnologiesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetTechnologiesResponseTechnologiesStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& GetTechnologiesResponseTechnologiesStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void GetTechnologiesResponseTechnologiesStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetTechnologiesResponseTechnologiesStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void GetTechnologiesResponseTechnologiesStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void GetTechnologiesResponseTechnologiesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetTechnologiesResponseTechnologiesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetTechnologiesResponseTechnologiesStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetTechnologiesResponseTechnologiesStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetTechnologiesResponseTechnologiesStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetTechnologiesResponseTechnologiesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTechnologiesResponseTechnologiesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTechnologiesResponseTechnologiesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTechnologiesResponseTechnologiesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetTechnologiesResponse::GetTechnologiesResponse ()  :
    _technologies ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTechnologiesResponse::GetTechnologiesResponse (const GetTechnologiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _technologies ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTechnologiesResponse::GetTechnologiesResponse (const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& technologies_)  :
    _technologies (technologies_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTechnologiesResponse::~GetTechnologiesResponse() {
}

inline GetTechnologiesResponse& GetTechnologiesResponse::operator = (const GetTechnologiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTechnologies()) {
            setTechnologies(rhs.getTechnologies());
        } else {
            clearTechnologies();
        }
    }
    return *this;
}

inline bool GetTechnologiesResponse::operator == (const GetTechnologiesResponse& rhs) const {
    return (((!hasTechnologies() && !rhs.hasTechnologies()) || getTechnologies() == rhs.getTechnologies()));
}

inline bool GetTechnologiesResponse::operator != (const GetTechnologiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTechnologiesResponse::operator < (const GetTechnologiesResponse& rhs) const {
    if (hasTechnologies() || rhs.hasTechnologies()) {
        if (getTechnologies() < rhs.getTechnologies()) return true;
        if (getTechnologies() > rhs.getTechnologies()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTechnologiesResponse::clone() {
    return new GetTechnologiesResponse(*this);
}

inline bool GetTechnologiesResponse::operator > (const GetTechnologiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTechnologiesResponse::clear() {
    clearTechnologies();
}

inline void GetTechnologiesResponse::clearTechnologies() {
    if (hasTechnologies()) {
         clear_has_technologies();
        _technologies.clear();
     }
}

inline bool GetTechnologiesResponse::hasTechnologies () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& GetTechnologiesResponse::getTechnologies () const {
    return _technologies;
}

inline ::std::vector< GetTechnologiesResponseTechnologiesStruct >& GetTechnologiesResponse::getTechnologiesMutable () {
    set_has_technologies();
    return _technologies;
}

inline void GetTechnologiesResponse::setTechnologies (const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& technologies_) {
    set_has_technologies();
    this->_technologies = technologies_;
}

inline void GetTechnologiesResponse::set_has_technologies () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTechnologiesResponse::clear_has_technologies () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetServicesResponseServicesStruct::GetServicesResponseServicesStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetServicesResponseServicesStruct::GetServicesResponseServicesStruct (const GetServicesResponseServicesStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetServicesResponseServicesStruct::GetServicesResponseServicesStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetServicesResponseServicesStruct::~GetServicesResponseServicesStruct() {
}

inline GetServicesResponseServicesStruct& GetServicesResponseServicesStruct::operator = (const GetServicesResponseServicesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetServicesResponseServicesStruct::operator == (const GetServicesResponseServicesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetServicesResponseServicesStruct::operator != (const GetServicesResponseServicesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetServicesResponseServicesStruct::operator < (const GetServicesResponseServicesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetServicesResponseServicesStruct::operator > (const GetServicesResponseServicesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetServicesResponseServicesStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetServicesResponseServicesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool GetServicesResponseServicesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetServicesResponseServicesStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& GetServicesResponseServicesStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void GetServicesResponseServicesStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetServicesResponseServicesStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void GetServicesResponseServicesStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void GetServicesResponseServicesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetServicesResponseServicesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetServicesResponseServicesStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetServicesResponseServicesStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetServicesResponseServicesStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetServicesResponseServicesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetServicesResponseServicesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetServicesResponseServicesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetServicesResponseServicesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetServicesResponse::GetServicesResponse ()  :
    _services ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetServicesResponse::GetServicesResponse (const GetServicesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _services ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetServicesResponse::GetServicesResponse (const ::std::vector< GetServicesResponseServicesStruct >& services_)  :
    _services (services_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetServicesResponse::~GetServicesResponse() {
}

inline GetServicesResponse& GetServicesResponse::operator = (const GetServicesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasServices()) {
            setServices(rhs.getServices());
        } else {
            clearServices();
        }
    }
    return *this;
}

inline bool GetServicesResponse::operator == (const GetServicesResponse& rhs) const {
    return (((!hasServices() && !rhs.hasServices()) || getServices() == rhs.getServices()));
}

inline bool GetServicesResponse::operator != (const GetServicesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetServicesResponse::operator < (const GetServicesResponse& rhs) const {
    if (hasServices() || rhs.hasServices()) {
        if (getServices() < rhs.getServices()) return true;
        if (getServices() > rhs.getServices()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetServicesResponse::clone() {
    return new GetServicesResponse(*this);
}

inline bool GetServicesResponse::operator > (const GetServicesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetServicesResponse::clear() {
    clearServices();
}

inline void GetServicesResponse::clearServices() {
    if (hasServices()) {
         clear_has_services();
        _services.clear();
     }
}

inline bool GetServicesResponse::hasServices () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GetServicesResponseServicesStruct >& GetServicesResponse::getServices () const {
    return _services;
}

inline ::std::vector< GetServicesResponseServicesStruct >& GetServicesResponse::getServicesMutable () {
    set_has_services();
    return _services;
}

inline void GetServicesResponse::setServices (const ::std::vector< GetServicesResponseServicesStruct >& services_) {
    set_has_services();
    this->_services = services_;
}

inline void GetServicesResponse::set_has_services () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetServicesResponse::clear_has_services () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RegisterAgentRequest::RegisterAgentRequest ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterAgentRequest::RegisterAgentRequest (const RegisterAgentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterAgentRequest::RegisterAgentRequest (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterAgentRequest::~RegisterAgentRequest() {
}

inline RegisterAgentRequest& RegisterAgentRequest::operator = (const RegisterAgentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool RegisterAgentRequest::operator == (const RegisterAgentRequest& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool RegisterAgentRequest::operator != (const RegisterAgentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterAgentRequest::operator < (const RegisterAgentRequest& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterAgentRequest::clone() {
    return new RegisterAgentRequest(*this);
}

inline bool RegisterAgentRequest::operator > (const RegisterAgentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterAgentRequest::clear() {
    clearPath();
}

inline void RegisterAgentRequest::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool RegisterAgentRequest::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterAgentRequest::getPath () const {
    return _path;
}

inline ::std::string& RegisterAgentRequest::getPathMutable () {
    set_has_path();
    return _path;
}

inline void RegisterAgentRequest::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void RegisterAgentRequest::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void RegisterAgentRequest::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void RegisterAgentRequest::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterAgentRequest::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnregisterAgentRequest::UnregisterAgentRequest ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnregisterAgentRequest::UnregisterAgentRequest (const UnregisterAgentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnregisterAgentRequest::UnregisterAgentRequest (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnregisterAgentRequest::~UnregisterAgentRequest() {
}

inline UnregisterAgentRequest& UnregisterAgentRequest::operator = (const UnregisterAgentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool UnregisterAgentRequest::operator == (const UnregisterAgentRequest& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool UnregisterAgentRequest::operator != (const UnregisterAgentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnregisterAgentRequest::operator < (const UnregisterAgentRequest& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnregisterAgentRequest::clone() {
    return new UnregisterAgentRequest(*this);
}

inline bool UnregisterAgentRequest::operator > (const UnregisterAgentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnregisterAgentRequest::clear() {
    clearPath();
}

inline void UnregisterAgentRequest::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool UnregisterAgentRequest::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnregisterAgentRequest::getPath () const {
    return _path;
}

inline ::std::string& UnregisterAgentRequest::getPathMutable () {
    set_has_path();
    return _path;
}

inline void UnregisterAgentRequest::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void UnregisterAgentRequest::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void UnregisterAgentRequest::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void UnregisterAgentRequest::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnregisterAgentRequest::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CreateSessionRequest::CreateSessionRequest ()  :
    _settings (),
    _notifier ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateSessionRequest::CreateSessionRequest (const CreateSessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _settings (),
    _notifier ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateSessionRequest::CreateSessionRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings_, const ::std::string& notifier_)  :
    _settings (settings_),
    _notifier (notifier_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (notifier_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateSessionRequest::~CreateSessionRequest() {
}

inline CreateSessionRequest& CreateSessionRequest::operator = (const CreateSessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSettings()) {
            setSettings(rhs.getSettings());
        } else {
            clearSettings();
        }
        if (rhs.hasNotifier()) {
            setNotifier(rhs.getNotifier());
        } else {
            clearNotifier();
        }
    }
    return *this;
}

inline bool CreateSessionRequest::operator == (const CreateSessionRequest& rhs) const {
    return (((!hasSettings() && !rhs.hasSettings()) || getSettings() == rhs.getSettings()) &&
        ((!hasNotifier() && !rhs.hasNotifier()) || getNotifier() == rhs.getNotifier()));
}

inline bool CreateSessionRequest::operator != (const CreateSessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateSessionRequest::operator < (const CreateSessionRequest& rhs) const {
    if (hasSettings() || rhs.hasSettings()) {
        if (getSettings() < rhs.getSettings()) return true;
        if (getSettings() > rhs.getSettings()) return false;
    }
    if (hasNotifier() || rhs.hasNotifier()) {
        if (getNotifier() < rhs.getNotifier()) return true;
        if (getNotifier() > rhs.getNotifier()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateSessionRequest::clone() {
    return new CreateSessionRequest(*this);
}

inline bool CreateSessionRequest::operator > (const CreateSessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateSessionRequest::clear() {
    clearSettings();
    clearNotifier();
}

inline void CreateSessionRequest::clearSettings() {
    if (hasSettings()) {
         clear_has_settings();
        _settings.clear();
     }
}

inline bool CreateSessionRequest::hasSettings () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CreateSessionRequest::getSettings () const {
    return _settings;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CreateSessionRequest::getSettingsMutable () {
    set_has_settings();
    return _settings;
}

inline void CreateSessionRequest::setSettings (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings_) {
    set_has_settings();
    this->_settings = settings_;
}

inline void CreateSessionRequest::clearNotifier() {
    if (hasNotifier()) {
         clear_has_notifier();
        _notifier.clear();
     }
}

inline bool CreateSessionRequest::hasNotifier () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CreateSessionRequest::getNotifier () const {
    return _notifier;
}

inline ::std::string& CreateSessionRequest::getNotifierMutable () {
    set_has_notifier();
    return _notifier;
}

inline void CreateSessionRequest::setNotifier (const ::std::string& notifier_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (notifier_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_notifier();
    this->_notifier = notifier_;
}

inline void CreateSessionRequest::setNotifier (const char* notifier_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (notifier_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_notifier();
    this->_notifier.assign(notifier_);
}

inline void CreateSessionRequest::setNotifier (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_notifier();
    this->_notifier.assign(value, size);
}

inline void CreateSessionRequest::set_has_settings () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateSessionRequest::clear_has_settings () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CreateSessionRequest::set_has_notifier () {
    _has_bits_[0] |= 1u << 1;
}

inline void CreateSessionRequest::clear_has_notifier () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CreateSessionResponse::CreateSessionResponse ()  :
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateSessionResponse::CreateSessionResponse (const CreateSessionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateSessionResponse::CreateSessionResponse (const ::std::string& session_)  :
    _session (session_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateSessionResponse::~CreateSessionResponse() {
}

inline CreateSessionResponse& CreateSessionResponse::operator = (const CreateSessionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
    }
    return *this;
}

inline bool CreateSessionResponse::operator == (const CreateSessionResponse& rhs) const {
    return (((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()));
}

inline bool CreateSessionResponse::operator != (const CreateSessionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateSessionResponse::operator < (const CreateSessionResponse& rhs) const {
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateSessionResponse::clone() {
    return new CreateSessionResponse(*this);
}

inline bool CreateSessionResponse::operator > (const CreateSessionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateSessionResponse::clear() {
    clearSession();
}

inline void CreateSessionResponse::clearSession() {
    if (hasSession()) {
         clear_has_session();
        _session.clear();
     }
}

inline bool CreateSessionResponse::hasSession () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CreateSessionResponse::getSession () const {
    return _session;
}

inline ::std::string& CreateSessionResponse::getSessionMutable () {
    set_has_session();
    return _session;
}

inline void CreateSessionResponse::setSession (const ::std::string& session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session = session_;
}

inline void CreateSessionResponse::setSession (const char* session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(session_);
}

inline void CreateSessionResponse::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(value, size);
}

inline void CreateSessionResponse::set_has_session () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateSessionResponse::clear_has_session () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DestroySessionRequest::DestroySessionRequest ()  :
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DestroySessionRequest::DestroySessionRequest (const DestroySessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DestroySessionRequest::DestroySessionRequest (const ::std::string& session_)  :
    _session (session_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DestroySessionRequest::~DestroySessionRequest() {
}

inline DestroySessionRequest& DestroySessionRequest::operator = (const DestroySessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
    }
    return *this;
}

inline bool DestroySessionRequest::operator == (const DestroySessionRequest& rhs) const {
    return (((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()));
}

inline bool DestroySessionRequest::operator != (const DestroySessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DestroySessionRequest::operator < (const DestroySessionRequest& rhs) const {
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DestroySessionRequest::clone() {
    return new DestroySessionRequest(*this);
}

inline bool DestroySessionRequest::operator > (const DestroySessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DestroySessionRequest::clear() {
    clearSession();
}

inline void DestroySessionRequest::clearSession() {
    if (hasSession()) {
         clear_has_session();
        _session.clear();
     }
}

inline bool DestroySessionRequest::hasSession () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DestroySessionRequest::getSession () const {
    return _session;
}

inline ::std::string& DestroySessionRequest::getSessionMutable () {
    set_has_session();
    return _session;
}

inline void DestroySessionRequest::setSession (const ::std::string& session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session = session_;
}

inline void DestroySessionRequest::setSession (const char* session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(session_);
}

inline void DestroySessionRequest::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(value, size);
}

inline void DestroySessionRequest::set_has_session () {
    _has_bits_[0] |= 1u << 0;
}

inline void DestroySessionRequest::clear_has_session () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TechnologyAddedSignal::TechnologyAddedSignal ()  :
    _path (),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TechnologyAddedSignal::TechnologyAddedSignal (const TechnologyAddedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _path (),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TechnologyAddedSignal::TechnologyAddedSignal (const ::std::string& path_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _path (path_),
    _properties (properties_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TechnologyAddedSignal::~TechnologyAddedSignal() {
}

inline TechnologyAddedSignal& TechnologyAddedSignal::operator = (const TechnologyAddedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool TechnologyAddedSignal::operator == (const TechnologyAddedSignal& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()) &&
        ((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool TechnologyAddedSignal::operator != (const TechnologyAddedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool TechnologyAddedSignal::operator < (const TechnologyAddedSignal& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TechnologyAddedSignal::clone() {
    return new TechnologyAddedSignal(*this);
}

inline bool TechnologyAddedSignal::operator > (const TechnologyAddedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TechnologyAddedSignal::clear() {
    clearPath();
    clearProperties();
}

inline void TechnologyAddedSignal::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool TechnologyAddedSignal::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TechnologyAddedSignal::getPath () const {
    return _path;
}

inline ::std::string& TechnologyAddedSignal::getPathMutable () {
    set_has_path();
    return _path;
}

inline void TechnologyAddedSignal::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void TechnologyAddedSignal::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void TechnologyAddedSignal::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void TechnologyAddedSignal::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool TechnologyAddedSignal::hasProperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& TechnologyAddedSignal::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& TechnologyAddedSignal::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void TechnologyAddedSignal::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void TechnologyAddedSignal::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void TechnologyAddedSignal::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TechnologyAddedSignal::set_has_properties () {
    _has_bits_[0] |= 1u << 1;
}

inline void TechnologyAddedSignal::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  TechnologyRemovedSignal::TechnologyRemovedSignal ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TechnologyRemovedSignal::TechnologyRemovedSignal (const TechnologyRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TechnologyRemovedSignal::TechnologyRemovedSignal (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TechnologyRemovedSignal::~TechnologyRemovedSignal() {
}

inline TechnologyRemovedSignal& TechnologyRemovedSignal::operator = (const TechnologyRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool TechnologyRemovedSignal::operator == (const TechnologyRemovedSignal& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool TechnologyRemovedSignal::operator != (const TechnologyRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool TechnologyRemovedSignal::operator < (const TechnologyRemovedSignal& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TechnologyRemovedSignal::clone() {
    return new TechnologyRemovedSignal(*this);
}

inline bool TechnologyRemovedSignal::operator > (const TechnologyRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TechnologyRemovedSignal::clear() {
    clearPath();
}

inline void TechnologyRemovedSignal::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool TechnologyRemovedSignal::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TechnologyRemovedSignal::getPath () const {
    return _path;
}

inline ::std::string& TechnologyRemovedSignal::getPathMutable () {
    set_has_path();
    return _path;
}

inline void TechnologyRemovedSignal::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void TechnologyRemovedSignal::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void TechnologyRemovedSignal::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void TechnologyRemovedSignal::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void TechnologyRemovedSignal::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PropertyChangedSignal::PropertyChangedSignal ()  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::PropertyChangedSignal (const PropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PropertyChangedSignal::PropertyChangedSignal (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::~PropertyChangedSignal() {
}

inline PropertyChangedSignal& PropertyChangedSignal::operator = (const PropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool PropertyChangedSignal::operator == (const PropertyChangedSignal& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool PropertyChangedSignal::operator != (const PropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PropertyChangedSignal::operator < (const PropertyChangedSignal& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PropertyChangedSignal::clone() {
    return new PropertyChangedSignal(*this);
}

inline bool PropertyChangedSignal::operator > (const PropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PropertyChangedSignal::clear() {
    clearName();
    clearValue();
}

inline void PropertyChangedSignal::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool PropertyChangedSignal::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PropertyChangedSignal::getName () const {
    return _name;
}

inline ::std::string& PropertyChangedSignal::getNameMutable () {
    set_has_name();
    return _name;
}

inline void PropertyChangedSignal::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void PropertyChangedSignal::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void PropertyChangedSignal::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void PropertyChangedSignal::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool PropertyChangedSignal::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& PropertyChangedSignal::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& PropertyChangedSignal::getValueMutable () {
    set_has_value();
    return _value;
}

inline void PropertyChangedSignal::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void PropertyChangedSignal::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void PropertyChangedSignal::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PropertyChangedSignal::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void PropertyChangedSignal::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ServicesChangedSignalChangedStruct::ServicesChangedSignalChangedStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServicesChangedSignalChangedStruct::ServicesChangedSignalChangedStruct (const ServicesChangedSignalChangedStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServicesChangedSignalChangedStruct::ServicesChangedSignalChangedStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServicesChangedSignalChangedStruct::~ServicesChangedSignalChangedStruct() {
}

inline ServicesChangedSignalChangedStruct& ServicesChangedSignalChangedStruct::operator = (const ServicesChangedSignalChangedStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool ServicesChangedSignalChangedStruct::operator == (const ServicesChangedSignalChangedStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool ServicesChangedSignalChangedStruct::operator != (const ServicesChangedSignalChangedStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool ServicesChangedSignalChangedStruct::operator < (const ServicesChangedSignalChangedStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool ServicesChangedSignalChangedStruct::operator > (const ServicesChangedSignalChangedStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServicesChangedSignalChangedStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void ServicesChangedSignalChangedStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool ServicesChangedSignalChangedStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ServicesChangedSignalChangedStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& ServicesChangedSignalChangedStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void ServicesChangedSignalChangedStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void ServicesChangedSignalChangedStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void ServicesChangedSignalChangedStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void ServicesChangedSignalChangedStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool ServicesChangedSignalChangedStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ServicesChangedSignalChangedStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ServicesChangedSignalChangedStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void ServicesChangedSignalChangedStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void ServicesChangedSignalChangedStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServicesChangedSignalChangedStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServicesChangedSignalChangedStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServicesChangedSignalChangedStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ServicesChangedSignal::ServicesChangedSignal ()  :
    _changed (),
    _removed ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServicesChangedSignal::ServicesChangedSignal (const ServicesChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _changed (),
    _removed ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServicesChangedSignal::ServicesChangedSignal (const ::std::vector< ServicesChangedSignalChangedStruct >& changed_, const ::std::vector< ::std::string >& removed_)  :
    _changed (changed_),
    _removed (removed_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServicesChangedSignal::~ServicesChangedSignal() {
}

inline ServicesChangedSignal& ServicesChangedSignal::operator = (const ServicesChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChanged()) {
            setChanged(rhs.getChanged());
        } else {
            clearChanged();
        }
        if (rhs.hasRemoved()) {
            setRemoved(rhs.getRemoved());
        } else {
            clearRemoved();
        }
    }
    return *this;
}

inline bool ServicesChangedSignal::operator == (const ServicesChangedSignal& rhs) const {
    return (((!hasChanged() && !rhs.hasChanged()) || getChanged() == rhs.getChanged()) &&
        ((!hasRemoved() && !rhs.hasRemoved()) || getRemoved() == rhs.getRemoved()));
}

inline bool ServicesChangedSignal::operator != (const ServicesChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ServicesChangedSignal::operator < (const ServicesChangedSignal& rhs) const {
    if (hasChanged() || rhs.hasChanged()) {
        if (getChanged() < rhs.getChanged()) return true;
        if (getChanged() > rhs.getChanged()) return false;
    }
    if (hasRemoved() || rhs.hasRemoved()) {
        if (getRemoved() < rhs.getRemoved()) return true;
        if (getRemoved() > rhs.getRemoved()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ServicesChangedSignal::clone() {
    return new ServicesChangedSignal(*this);
}

inline bool ServicesChangedSignal::operator > (const ServicesChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServicesChangedSignal::clear() {
    clearChanged();
    clearRemoved();
}

inline void ServicesChangedSignal::clearChanged() {
    if (hasChanged()) {
         clear_has_changed();
        _changed.clear();
     }
}

inline bool ServicesChangedSignal::hasChanged () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ServicesChangedSignalChangedStruct >& ServicesChangedSignal::getChanged () const {
    return _changed;
}

inline ::std::vector< ServicesChangedSignalChangedStruct >& ServicesChangedSignal::getChangedMutable () {
    set_has_changed();
    return _changed;
}

inline void ServicesChangedSignal::setChanged (const ::std::vector< ServicesChangedSignalChangedStruct >& changed_) {
    set_has_changed();
    this->_changed = changed_;
}

inline void ServicesChangedSignal::clearRemoved() {
    if (hasRemoved()) {
         clear_has_removed();
        _removed.clear();
     }
}

inline bool ServicesChangedSignal::hasRemoved () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& ServicesChangedSignal::getRemoved () const {
    return _removed;
}

inline ::std::vector< ::std::string >& ServicesChangedSignal::getRemovedMutable () {
    set_has_removed();
    return _removed;
}

inline void ServicesChangedSignal::setRemoved (const ::std::vector< ::std::string >& removed_) {
    set_has_removed();
    this->_removed = removed_;
}

inline void ServicesChangedSignal::set_has_changed () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServicesChangedSignal::clear_has_changed () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServicesChangedSignal::set_has_removed () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServicesChangedSignal::clear_has_removed () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Manager
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_MANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
