/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Agent.h"
#include "net/connman/AgentDBus.h"
#include "net/connman/AgentJson.h"
#include "net/connman/AgentProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Agent {

DEFINE_CLASS_LOGGER("/net/Connman/net/connman/Agent", AgentProxy);

class AgentProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    AgentProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< AgentProxy >& proxyShared = ::boost::static_pointer_cast< AgentProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_RequestInput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestInputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestInputError> payload = ::boost::static_pointer_cast<RequestInputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestInputCallbackIF*) _callback)->onRequestInputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestInputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestInputResponse> payload = ::boost::static_pointer_cast<RequestInputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestInputCallbackIF*) _callback)->onRequestInputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReportError:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReportErrorError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReportError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReportErrorError> payload = ::boost::static_pointer_cast<ReportErrorError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReportErrorCallbackIF*) _callback)->onReportErrorError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReportErrorResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReportError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReportErrorResponse> payload = ::boost::static_pointer_cast<ReportErrorResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReportErrorCallbackIF*) _callback)->onReportErrorResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Cancel:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Cancel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelError> payload = ::boost::static_pointer_cast<CancelError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelCallbackIF*) _callback)->onCancelError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Cancel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelResponse> payload = ::boost::static_pointer_cast<CancelResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelCallbackIF*) _callback)->onCancelResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestBrowser:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestBrowserError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestBrowser", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestBrowserError> payload = ::boost::static_pointer_cast<RequestBrowserError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestBrowserCallbackIF*) _callback)->onRequestBrowserError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestBrowserResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestBrowser", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestBrowserResponse> payload = ::boost::static_pointer_cast<RequestBrowserResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestBrowserCallbackIF*) _callback)->onRequestBrowserResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_RequestInput: {
                ::boost::shared_ptr< RequestInputError > payload = ::boost::shared_ptr< RequestInputError >
                (new RequestInputError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestInputCallbackIF*) _callback)->onRequestInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReportError: {
                ::boost::shared_ptr< ReportErrorError > payload = ::boost::shared_ptr< ReportErrorError >
                (new ReportErrorError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReportError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReportErrorCallbackIF*) _callback)->onReportErrorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Cancel: {
                ::boost::shared_ptr< CancelError > payload = ::boost::shared_ptr< CancelError >
                (new CancelError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Cancel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelCallbackIF*) _callback)->onCancelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestBrowser: {
                ::boost::shared_ptr< RequestBrowserError > payload = ::boost::shared_ptr< RequestBrowserError >
                (new RequestBrowserError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestBrowser", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestBrowserCallbackIF*) _callback)->onRequestBrowserError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& AgentProxyCallback::_logger (AgentProxy::_logger);

AgentProxy::AgentProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "net.connman.Agent", serviceAvailable, _logger) {
}

AgentProxy::~AgentProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< AgentProxy > AgentProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<AgentProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< AgentProxy > proxyNew(new AgentProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t AgentProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    AgentProxyCallback* callback = new AgentProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t AgentProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    AgentProxyCallback* callback = new AgentProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t AgentProxy::sendRequestInputRequest(RequestInputCallbackIF& cb, const ::std::string& service, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields) const {
    RequestInputRequest* payload = new RequestInputRequest();
    CHECK_ALLOCATION(payload);
    payload->setService(service);
    payload->setFields(fields);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestInput", RequestInputRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestInput, dbusMessage.getUniqueSerial(), "RequestInput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestInput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendReportErrorRequest(ReportErrorCallbackIF& cb, const ::std::string& service, const ::std::string& error) const {
    ReportErrorRequest* payload = new ReportErrorRequest();
    CHECK_ALLOCATION(payload);
    payload->setService(service);
    payload->setError(error);
    DBUS_MESSAGE_CALL(dbusMessage, "ReportError", ReportErrorRequest, payload, true)
    act_t act = addMethodCallback(ID_ReportError, dbusMessage.getUniqueSerial(), "ReportError", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReportError", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendCancelRequest(CancelCallbackIF& cb) const {
    CancelRequest* payload = new CancelRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Cancel", CancelRequest, payload, true)
    act_t act = addMethodCallback(ID_Cancel, dbusMessage.getUniqueSerial(), "Cancel", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Cancel", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendRequestBrowserRequest(RequestBrowserCallbackIF& cb, const ::std::string& service, const ::std::string& url) const {
    RequestBrowserRequest* payload = new RequestBrowserRequest();
    CHECK_ALLOCATION(payload);
    payload->setService(service);
    payload->setUrl(url);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestBrowser", RequestBrowserRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestBrowser, dbusMessage.getUniqueSerial(), "RequestBrowser", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestBrowser", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Agent
} // namespace connman
} // namespace net
