#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_AGENT_H
#define NET_CONNMAN_AGENT_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>

/**
 * If the meaning of "Agent" isn't clear, then there should be a description here.
 */

namespace net {
namespace connman {
namespace Agent {

// method IDs
static const uint16 ID_RequestInput = 0;
static const uint16 ID_ReportError = 1;
static const uint16 ID_Cancel = 2;
static const uint16 ID_RequestBrowser = 3;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class RequestInputRequest;

class RequestInputResponse;

class ReportErrorRequest;

class RequestBrowserRequest;

// type definitions
/**
 * If the meaning of "RequestInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestInputError;

/**
 * If the meaning of "ReportErrorResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReportErrorResponse;

/**
 * If the meaning of "ReportErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReportErrorError;

/**
 * If the meaning of "CancelRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelRequest;

/**
 * If the meaning of "CancelResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelResponse;

/**
 * If the meaning of "CancelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelError;

/**
 * If the meaning of "RequestBrowserResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestBrowserResponse;

/**
 * If the meaning of "RequestBrowserError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestBrowserError;


/**
 * If the meaning of "RequestInputRequest" isn't clear, then there should be a description here.
 */
class RequestInputRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestInputRequest ();

    /**
     * Copy constructor
     */
    inline  RequestInputRequest (const RequestInputRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestInputRequest (const ::std::string& service_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields_);

    /**
     * Destructor
     */
    inline virtual  ~RequestInputRequest();

    /**
     * Assignment operator
     */
    inline RequestInputRequest& operator = (const RequestInputRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestInputRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestInputRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestInputRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestInputRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "service"

    static const int kService = 0;

    /**
     * Clears the field "service".
     *
     * The field will be set to its default value. The hasService()
     * method will return false.
     */
    inline void clearService();

    /**
     * Checks whether the field "service" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setService()). Otherwise it will return false.
     */
    inline bool hasService () const;

    /**
     * Returns the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @return The value of the field "service"
     */
    inline const ::std::string& getService () const;

    /**
     * Retrieves the value of the field "service" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "service".
     */
    inline ::std::string& getServiceMutable ();

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const ::std::string& service_);

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const char* service_);

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const char* value, size_t size);

    // API of field "fields"

    static const int kFields = 1;

    /**
     * Clears the field "fields".
     *
     * The field will be set to its default value. The hasFields()
     * method will return false.
     */
    inline void clearFields();

    /**
     * Checks whether the field "fields" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFields()). Otherwise it will return false.
     */
    inline bool hasFields () const;

    /**
     * Returns the value of the member "fields".
     *
     * If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @return The value of the field "fields"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFields () const;

    /**
     * Retrieves the value of the field "fields" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "fields".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFieldsMutable ();

    /**
     * Sets the value of the member "fields".
     *
     * If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @param fields The value which will be set
     */
    inline void setFields (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields_);

    static const RequestInputRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_service ();

    inline void clear_has_service ();

    inline void set_has_fields ();

    inline void clear_has_fields ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _service;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _fields;

};

/**
 * If the meaning of "RequestInputResponse" isn't clear, then there should be a description here.
 */
class RequestInputResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestInputResponse ();

    /**
     * Copy constructor
     */
    inline  RequestInputResponse (const RequestInputResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestInputResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields_);

    /**
     * Destructor
     */
    inline virtual  ~RequestInputResponse();

    /**
     * Assignment operator
     */
    inline RequestInputResponse& operator = (const RequestInputResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestInputResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestInputResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestInputResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestInputResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "fields"

    static const int kFields = 0;

    /**
     * Clears the field "fields".
     *
     * The field will be set to its default value. The hasFields()
     * method will return false.
     */
    inline void clearFields();

    /**
     * Checks whether the field "fields" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFields()). Otherwise it will return false.
     */
    inline bool hasFields () const;

    /**
     * Returns the value of the member "fields".
     *
     * If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @return The value of the field "fields"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFields () const;

    /**
     * Retrieves the value of the field "fields" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "fields".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFieldsMutable ();

    /**
     * Sets the value of the member "fields".
     *
     * If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @param fields The value which will be set
     */
    inline void setFields (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields_);

    static const RequestInputResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_fields ();

    inline void clear_has_fields ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _fields;

};

/**
 * If the meaning of "ReportErrorRequest" isn't clear, then there should be a description here.
 */
class ReportErrorRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportErrorRequest ();

    /**
     * Copy constructor
     */
    inline  ReportErrorRequest (const ReportErrorRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReportErrorRequest (const ::std::string& service_, const ::std::string& error_);

    /**
     * Destructor
     */
    inline virtual  ~ReportErrorRequest();

    /**
     * Assignment operator
     */
    inline ReportErrorRequest& operator = (const ReportErrorRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportErrorRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportErrorRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportErrorRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportErrorRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "service"

    static const int kService = 0;

    /**
     * Clears the field "service".
     *
     * The field will be set to its default value. The hasService()
     * method will return false.
     */
    inline void clearService();

    /**
     * Checks whether the field "service" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setService()). Otherwise it will return false.
     */
    inline bool hasService () const;

    /**
     * Returns the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @return The value of the field "service"
     */
    inline const ::std::string& getService () const;

    /**
     * Retrieves the value of the field "service" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "service".
     */
    inline ::std::string& getServiceMutable ();

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const ::std::string& service_);

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const char* service_);

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const char* value, size_t size);

    // API of field "error"

    static const int kError = 1;

    /**
     * Clears the field "error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "error".
     *
     * If the meaning of "error" isn't clear, then there should be a description here.
     *
     * @return The value of the field "error"
     */
    inline const ::std::string& getError () const;

    /**
     * Retrieves the value of the field "error" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "error".
     */
    inline ::std::string& getErrorMutable ();

    /**
     * Sets the value of the member "error".
     *
     * If the meaning of "error" isn't clear, then there should be a description here.
     *
     * @param error The value which will be set
     */
    inline void setError (const ::std::string& error_);

    /**
     * Sets the value of the member "error".
     *
     * If the meaning of "error" isn't clear, then there should be a description here.
     *
     * @param error The value which will be set
     */
    inline void setError (const char* error_);

    /**
     * Sets the value of the member "error".
     *
     * If the meaning of "error" isn't clear, then there should be a description here.
     *
     * @param error The value which will be set
     */
    inline void setError (const char* value, size_t size);

    static const ReportErrorRequest &getDefaultInstance();

private:

    inline void set_has_service ();

    inline void clear_has_service ();

    inline void set_has_error ();

    inline void clear_has_error ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _service;

    ::std::string _error;

};

/**
 * If the meaning of "RequestBrowserRequest" isn't clear, then there should be a description here.
 */
class RequestBrowserRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestBrowserRequest ();

    /**
     * Copy constructor
     */
    inline  RequestBrowserRequest (const RequestBrowserRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestBrowserRequest (const ::std::string& service_, const ::std::string& url_);

    /**
     * Destructor
     */
    inline virtual  ~RequestBrowserRequest();

    /**
     * Assignment operator
     */
    inline RequestBrowserRequest& operator = (const RequestBrowserRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestBrowserRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestBrowserRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestBrowserRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestBrowserRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "service"

    static const int kService = 0;

    /**
     * Clears the field "service".
     *
     * The field will be set to its default value. The hasService()
     * method will return false.
     */
    inline void clearService();

    /**
     * Checks whether the field "service" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setService()). Otherwise it will return false.
     */
    inline bool hasService () const;

    /**
     * Returns the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @return The value of the field "service"
     */
    inline const ::std::string& getService () const;

    /**
     * Retrieves the value of the field "service" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "service".
     */
    inline ::std::string& getServiceMutable ();

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const ::std::string& service_);

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const char* service_);

    /**
     * Sets the value of the member "service".
     *
     * If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param service The value which will be set
     */
    inline void setService (const char* value, size_t size);

    // API of field "url"

    static const int kUrl = 1;

    /**
     * Clears the field "url".
     *
     * The field will be set to its default value. The hasUrl()
     * method will return false.
     */
    inline void clearUrl();

    /**
     * Checks whether the field "url" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUrl()). Otherwise it will return false.
     */
    inline bool hasUrl () const;

    /**
     * Returns the value of the member "url".
     *
     * If the meaning of "url" isn't clear, then there should be a description here.
     *
     * @return The value of the field "url"
     */
    inline const ::std::string& getUrl () const;

    /**
     * Retrieves the value of the field "url" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "url".
     */
    inline ::std::string& getUrlMutable ();

    /**
     * Sets the value of the member "url".
     *
     * If the meaning of "url" isn't clear, then there should be a description here.
     *
     * @param url The value which will be set
     */
    inline void setUrl (const ::std::string& url_);

    /**
     * Sets the value of the member "url".
     *
     * If the meaning of "url" isn't clear, then there should be a description here.
     *
     * @param url The value which will be set
     */
    inline void setUrl (const char* url_);

    /**
     * Sets the value of the member "url".
     *
     * If the meaning of "url" isn't clear, then there should be a description here.
     *
     * @param url The value which will be set
     */
    inline void setUrl (const char* value, size_t size);

    static const RequestBrowserRequest &getDefaultInstance();

private:

    inline void set_has_service ();

    inline void clear_has_service ();

    inline void set_has_url ();

    inline void clear_has_url ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _service;

    ::std::string _url;

};

inline  RequestInputRequest::RequestInputRequest ()  :
    _service (),
    _fields ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestInputRequest::RequestInputRequest (const RequestInputRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _service (),
    _fields ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestInputRequest::RequestInputRequest (const ::std::string& service_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields_)  :
    _service (service_),
    _fields (fields_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestInputRequest::~RequestInputRequest() {
}

inline RequestInputRequest& RequestInputRequest::operator = (const RequestInputRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasService()) {
            setService(rhs.getService());
        } else {
            clearService();
        }
        if (rhs.hasFields()) {
            setFields(rhs.getFields());
        } else {
            clearFields();
        }
    }
    return *this;
}

inline bool RequestInputRequest::operator == (const RequestInputRequest& rhs) const {
    return (((!hasService() && !rhs.hasService()) || getService() == rhs.getService()) &&
        ((!hasFields() && !rhs.hasFields()) || getFields() == rhs.getFields()));
}

inline bool RequestInputRequest::operator != (const RequestInputRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestInputRequest::operator < (const RequestInputRequest& rhs) const {
    if (hasService() || rhs.hasService()) {
        if (getService() < rhs.getService()) return true;
        if (getService() > rhs.getService()) return false;
    }
    if (hasFields() || rhs.hasFields()) {
        if (getFields() < rhs.getFields()) return true;
        if (getFields() > rhs.getFields()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestInputRequest::clone() {
    return new RequestInputRequest(*this);
}

inline bool RequestInputRequest::operator > (const RequestInputRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestInputRequest::clear() {
    clearService();
    clearFields();
}

inline void RequestInputRequest::clearService() {
    if (hasService()) {
         clear_has_service();
        _service.clear();
     }
}

inline bool RequestInputRequest::hasService () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestInputRequest::getService () const {
    return _service;
}

inline ::std::string& RequestInputRequest::getServiceMutable () {
    set_has_service();
    return _service;
}

inline void RequestInputRequest::setService (const ::std::string& service_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service = service_;
}

inline void RequestInputRequest::setService (const char* service_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service.assign(service_);
}

inline void RequestInputRequest::setService (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service.assign(value, size);
}

inline void RequestInputRequest::clearFields() {
    if (hasFields()) {
         clear_has_fields();
        _fields.clear();
     }
}

inline bool RequestInputRequest::hasFields () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& RequestInputRequest::getFields () const {
    return _fields;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& RequestInputRequest::getFieldsMutable () {
    set_has_fields();
    return _fields;
}

inline void RequestInputRequest::setFields (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields_) {
    set_has_fields();
    this->_fields = fields_;
}

inline void RequestInputRequest::set_has_service () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestInputRequest::clear_has_service () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestInputRequest::set_has_fields () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestInputRequest::clear_has_fields () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestInputResponse::RequestInputResponse ()  :
    _fields ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestInputResponse::RequestInputResponse (const RequestInputResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _fields ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestInputResponse::RequestInputResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields_)  :
    _fields (fields_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestInputResponse::~RequestInputResponse() {
}

inline RequestInputResponse& RequestInputResponse::operator = (const RequestInputResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFields()) {
            setFields(rhs.getFields());
        } else {
            clearFields();
        }
    }
    return *this;
}

inline bool RequestInputResponse::operator == (const RequestInputResponse& rhs) const {
    return (((!hasFields() && !rhs.hasFields()) || getFields() == rhs.getFields()));
}

inline bool RequestInputResponse::operator != (const RequestInputResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestInputResponse::operator < (const RequestInputResponse& rhs) const {
    if (hasFields() || rhs.hasFields()) {
        if (getFields() < rhs.getFields()) return true;
        if (getFields() > rhs.getFields()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestInputResponse::clone() {
    return new RequestInputResponse(*this);
}

inline bool RequestInputResponse::operator > (const RequestInputResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestInputResponse::clear() {
    clearFields();
}

inline void RequestInputResponse::clearFields() {
    if (hasFields()) {
         clear_has_fields();
        _fields.clear();
     }
}

inline bool RequestInputResponse::hasFields () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& RequestInputResponse::getFields () const {
    return _fields;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& RequestInputResponse::getFieldsMutable () {
    set_has_fields();
    return _fields;
}

inline void RequestInputResponse::setFields (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields_) {
    set_has_fields();
    this->_fields = fields_;
}

inline void RequestInputResponse::set_has_fields () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestInputResponse::clear_has_fields () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReportErrorRequest::ReportErrorRequest ()  :
    _service (),
    _error ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportErrorRequest::ReportErrorRequest (const ReportErrorRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _service (),
    _error ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportErrorRequest::ReportErrorRequest (const ::std::string& service_, const ::std::string& error_)  :
    _service (service_),
    _error (error_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (error_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportErrorRequest::~ReportErrorRequest() {
}

inline ReportErrorRequest& ReportErrorRequest::operator = (const ReportErrorRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasService()) {
            setService(rhs.getService());
        } else {
            clearService();
        }
        if (rhs.hasError()) {
            setError(rhs.getError());
        } else {
            clearError();
        }
    }
    return *this;
}

inline bool ReportErrorRequest::operator == (const ReportErrorRequest& rhs) const {
    return (((!hasService() && !rhs.hasService()) || getService() == rhs.getService()) &&
        ((!hasError() && !rhs.hasError()) || getError() == rhs.getError()));
}

inline bool ReportErrorRequest::operator != (const ReportErrorRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportErrorRequest::operator < (const ReportErrorRequest& rhs) const {
    if (hasService() || rhs.hasService()) {
        if (getService() < rhs.getService()) return true;
        if (getService() > rhs.getService()) return false;
    }
    if (hasError() || rhs.hasError()) {
        if (getError() < rhs.getError()) return true;
        if (getError() > rhs.getError()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportErrorRequest::clone() {
    return new ReportErrorRequest(*this);
}

inline bool ReportErrorRequest::operator > (const ReportErrorRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportErrorRequest::clear() {
    clearService();
    clearError();
}

inline void ReportErrorRequest::clearService() {
    if (hasService()) {
         clear_has_service();
        _service.clear();
     }
}

inline bool ReportErrorRequest::hasService () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReportErrorRequest::getService () const {
    return _service;
}

inline ::std::string& ReportErrorRequest::getServiceMutable () {
    set_has_service();
    return _service;
}

inline void ReportErrorRequest::setService (const ::std::string& service_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service = service_;
}

inline void ReportErrorRequest::setService (const char* service_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service.assign(service_);
}

inline void ReportErrorRequest::setService (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service.assign(value, size);
}

inline void ReportErrorRequest::clearError() {
    if (hasError()) {
         clear_has_error();
        _error.clear();
     }
}

inline bool ReportErrorRequest::hasError () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ReportErrorRequest::getError () const {
    return _error;
}

inline ::std::string& ReportErrorRequest::getErrorMutable () {
    set_has_error();
    return _error;
}

inline void ReportErrorRequest::setError (const ::std::string& error_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (error_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_error();
    this->_error = error_;
}

inline void ReportErrorRequest::setError (const char* error_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (error_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_error();
    this->_error.assign(error_);
}

inline void ReportErrorRequest::setError (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_error();
    this->_error.assign(value, size);
}

inline void ReportErrorRequest::set_has_service () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportErrorRequest::clear_has_service () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReportErrorRequest::set_has_error () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReportErrorRequest::clear_has_error () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestBrowserRequest::RequestBrowserRequest ()  :
    _service (),
    _url ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestBrowserRequest::RequestBrowserRequest (const RequestBrowserRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _service (),
    _url ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestBrowserRequest::RequestBrowserRequest (const ::std::string& service_, const ::std::string& url_)  :
    _service (service_),
    _url (url_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (url_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestBrowserRequest::~RequestBrowserRequest() {
}

inline RequestBrowserRequest& RequestBrowserRequest::operator = (const RequestBrowserRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasService()) {
            setService(rhs.getService());
        } else {
            clearService();
        }
        if (rhs.hasUrl()) {
            setUrl(rhs.getUrl());
        } else {
            clearUrl();
        }
    }
    return *this;
}

inline bool RequestBrowserRequest::operator == (const RequestBrowserRequest& rhs) const {
    return (((!hasService() && !rhs.hasService()) || getService() == rhs.getService()) &&
        ((!hasUrl() && !rhs.hasUrl()) || getUrl() == rhs.getUrl()));
}

inline bool RequestBrowserRequest::operator != (const RequestBrowserRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestBrowserRequest::operator < (const RequestBrowserRequest& rhs) const {
    if (hasService() || rhs.hasService()) {
        if (getService() < rhs.getService()) return true;
        if (getService() > rhs.getService()) return false;
    }
    if (hasUrl() || rhs.hasUrl()) {
        if (getUrl() < rhs.getUrl()) return true;
        if (getUrl() > rhs.getUrl()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestBrowserRequest::clone() {
    return new RequestBrowserRequest(*this);
}

inline bool RequestBrowserRequest::operator > (const RequestBrowserRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestBrowserRequest::clear() {
    clearService();
    clearUrl();
}

inline void RequestBrowserRequest::clearService() {
    if (hasService()) {
         clear_has_service();
        _service.clear();
     }
}

inline bool RequestBrowserRequest::hasService () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestBrowserRequest::getService () const {
    return _service;
}

inline ::std::string& RequestBrowserRequest::getServiceMutable () {
    set_has_service();
    return _service;
}

inline void RequestBrowserRequest::setService (const ::std::string& service_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service = service_;
}

inline void RequestBrowserRequest::setService (const char* service_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (service_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service.assign(service_);
}

inline void RequestBrowserRequest::setService (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_service();
    this->_service.assign(value, size);
}

inline void RequestBrowserRequest::clearUrl() {
    if (hasUrl()) {
         clear_has_url();
        _url.clear();
     }
}

inline bool RequestBrowserRequest::hasUrl () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RequestBrowserRequest::getUrl () const {
    return _url;
}

inline ::std::string& RequestBrowserRequest::getUrlMutable () {
    set_has_url();
    return _url;
}

inline void RequestBrowserRequest::setUrl (const ::std::string& url_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (url_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_url();
    this->_url = url_;
}

inline void RequestBrowserRequest::setUrl (const char* url_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (url_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_url();
    this->_url.assign(url_);
}

inline void RequestBrowserRequest::setUrl (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_url();
    this->_url.assign(value, size);
}

inline void RequestBrowserRequest::set_has_service () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestBrowserRequest::clear_has_service () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestBrowserRequest::set_has_url () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestBrowserRequest::clear_has_url () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Agent
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_AGENT_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
