/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef CLOCK_MAIN_FIPROXY_H
#define CLOCK_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "clock_main_fi.h"
#include "clock_main_fi_typesConst.h"
#include "diagnostics_main_fi_typesConst.h"
#include <map>

namespace clock_main_fi {

class Clock_main_fiProxy;

class Auto_TimeZoneOffsetCallbackIF {
public:
    virtual ~Auto_TimeZoneOffsetCallbackIF() {}

    virtual void onAuto_TimeZoneOffsetError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< Auto_TimeZoneOffsetError >& error) = 0;

    virtual void onAuto_TimeZoneOffsetStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< Auto_TimeZoneOffsetStatus >& status) = 0;
};

class ClockSourceStatusCallbackIF {
public:
    virtual ~ClockSourceStatusCallbackIF() {}

    virtual void onClockSourceStatusError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< ClockSourceStatusError >& error) = 0;

    virtual void onClockSourceStatusStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< ClockSourceStatusStatus >& status) = 0;
};

class ConnectionCallbackIF {
public:
    virtual ~ConnectionCallbackIF() {}

    virtual void onConnectionError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< ConnectionError >& error) = 0;

    virtual void onConnectionStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< ConnectionStatus >& status) = 0;
};

class DateFormatCallbackIF {
public:
    virtual ~DateFormatCallbackIF() {}

    virtual void onDateFormatError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< DateFormatError >& error) = 0;

    virtual void onDateFormatStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< DateFormatStatus >& status) = 0;
};

class DaylightSavingTimeCallbackIF {
public:
    virtual ~DaylightSavingTimeCallbackIF() {}

    virtual void onDaylightSavingTimeError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< DaylightSavingTimeError >& error) = 0;

    virtual void onDaylightSavingTimeStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< DaylightSavingTimeStatus >& status) = 0;
};

class DebugMode_TimeDateCallbackIF {
public:
    virtual ~DebugMode_TimeDateCallbackIF() {}

    virtual void onDebugMode_TimeDateError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< DebugMode_TimeDateError >& error) = 0;

    virtual void onDebugMode_TimeDateStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< DebugMode_TimeDateStatus >& status) = 0;
};

class FID_S_DIAG_CONFIGURATIONCallbackIF {
public:
    virtual ~FID_S_DIAG_CONFIGURATIONCallbackIF() {}

    virtual void onFID_S_DIAG_CONFIGURATIONError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< FID_S_DIAG_CONFIGURATIONError >& error) = 0;

    virtual void onFID_S_DIAG_CONFIGURATIONResult(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< FID_S_DIAG_CONFIGURATIONResult >& result) = 0;
};

class FormatSourceStatusCallbackIF {
public:
    virtual ~FormatSourceStatusCallbackIF() {}

    virtual void onFormatSourceStatusError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< FormatSourceStatusError >& error) = 0;

    virtual void onFormatSourceStatusStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< FormatSourceStatusStatus >& status) = 0;
};

class GPS_AutoSyncCallbackIF {
public:
    virtual ~GPS_AutoSyncCallbackIF() {}

    virtual void onGPS_AutoSyncError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GPS_AutoSyncError >& error) = 0;

    virtual void onGPS_AutoSyncStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GPS_AutoSyncStatus >& status) = 0;
};

class GPS_WeekEpochCallbackIF {
public:
    virtual ~GPS_WeekEpochCallbackIF() {}

    virtual void onGPS_WeekEpochError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GPS_WeekEpochError >& error) = 0;

    virtual void onGPS_WeekEpochStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GPS_WeekEpochStatus >& status) = 0;
};

class GetAvailableTimeZonesCallbackIF {
public:
    virtual ~GetAvailableTimeZonesCallbackIF() {}

    virtual void onGetAvailableTimeZonesError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAvailableTimeZonesError >& error) = 0;

    virtual void onGetAvailableTimeZonesResult(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAvailableTimeZonesResult >& result) = 0;
};

class GetDaysPerMonthCallbackIF {
public:
    virtual ~GetDaysPerMonthCallbackIF() {}

    virtual void onGetDaysPerMonthError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDaysPerMonthError >& error) = 0;

    virtual void onGetDaysPerMonthResult(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDaysPerMonthResult >& result) = 0;
};

class GetTimeDateFromValueCallbackIF {
public:
    virtual ~GetTimeDateFromValueCallbackIF() {}

    virtual void onGetTimeDateFromValueError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTimeDateFromValueError >& error) = 0;

    virtual void onGetTimeDateFromValueResult(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTimeDateFromValueResult >& result) = 0;
};

class HUD_ActivationCallbackIF {
public:
    virtual ~HUD_ActivationCallbackIF() {}

    virtual void onHUD_ActivationError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< HUD_ActivationError >& error) = 0;

    virtual void onHUD_ActivationStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< HUD_ActivationStatus >& status) = 0;
};

class HUD_PostitionCallbackIF {
public:
    virtual ~HUD_PostitionCallbackIF() {}

    virtual void onHUD_PostitionError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< HUD_PostitionError >& error) = 0;

    virtual void onHUD_PostitionStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< HUD_PostitionStatus >& status) = 0;
};

class HardwareVersionCallbackIF {
public:
    virtual ~HardwareVersionCallbackIF() {}

    virtual void onHardwareVersionError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< HardwareVersionError >& error) = 0;

    virtual void onHardwareVersionStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< HardwareVersionStatus >& status) = 0;
};

class LocalTimeDateCallbackIF {
public:
    virtual ~LocalTimeDateCallbackIF() {}

    virtual void onLocalTimeDateError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< LocalTimeDateError >& error) = 0;

    virtual void onLocalTimeDateStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< LocalTimeDateStatus >& status) = 0;
};

class LocalTimeDate_MinuteUpdateCallbackIF {
public:
    virtual ~LocalTimeDate_MinuteUpdateCallbackIF() {}

    virtual void onLocalTimeDate_MinuteUpdateError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< LocalTimeDate_MinuteUpdateError >& error) = 0;

    virtual void onLocalTimeDate_MinuteUpdateStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< LocalTimeDate_MinuteUpdateStatus >& status) = 0;
};

class LocalTimeOffsetCallbackIF {
public:
    virtual ~LocalTimeOffsetCallbackIF() {}

    virtual void onLocalTimeOffsetError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< LocalTimeOffsetError >& error) = 0;

    virtual void onLocalTimeOffsetStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< LocalTimeOffsetStatus >& status) = 0;
};

class NewDateFormatCallbackIF {
public:
    virtual ~NewDateFormatCallbackIF() {}

    virtual void onNewDateFormatError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< NewDateFormatError >& error) = 0;

    virtual void onNewDateFormatStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< NewDateFormatStatus >& status) = 0;
};

class Region_TimeZoneCallbackIF {
public:
    virtual ~Region_TimeZoneCallbackIF() {}

    virtual void onRegion_TimeZoneError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< Region_TimeZoneError >& error) = 0;

    virtual void onRegion_TimeZoneStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< Region_TimeZoneStatus >& status) = 0;
};

class ResetHistoryCallbackIF {
public:
    virtual ~ResetHistoryCallbackIF() {}

    virtual void onResetHistoryError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< ResetHistoryError >& error) = 0;

    virtual void onResetHistoryResult(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< ResetHistoryResult >& result) = 0;
};

class SoftwareVersionCallbackIF {
public:
    virtual ~SoftwareVersionCallbackIF() {}

    virtual void onSoftwareVersionError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< SoftwareVersionError >& error) = 0;

    virtual void onSoftwareVersionStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< SoftwareVersionStatus >& status) = 0;
};

class SyncModeCallbackIF {
public:
    virtual ~SyncModeCallbackIF() {}

    virtual void onSyncModeError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< SyncModeError >& error) = 0;

    virtual void onSyncModeStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< SyncModeStatus >& status) = 0;
};

class TimeFormatCallbackIF {
public:
    virtual ~TimeFormatCallbackIF() {}

    virtual void onTimeFormatError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< TimeFormatError >& error) = 0;

    virtual void onTimeFormatStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< TimeFormatStatus >& status) = 0;
};

class TimeZoneCallbackIF {
public:
    virtual ~TimeZoneCallbackIF() {}

    virtual void onTimeZoneError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< TimeZoneError >& error) = 0;

    virtual void onTimeZoneStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< TimeZoneStatus >& status) = 0;
};

class TimeZone_DSTAvailabilityCallbackIF {
public:
    virtual ~TimeZone_DSTAvailabilityCallbackIF() {}

    virtual void onTimeZone_DSTAvailabilityError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< TimeZone_DSTAvailabilityError >& error) = 0;

    virtual void onTimeZone_DSTAvailabilityStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< TimeZone_DSTAvailabilityStatus >& status) = 0;
};

class UTC_TimeDateUpdateCallbackIF {
public:
    virtual ~UTC_TimeDateUpdateCallbackIF() {}

    virtual void onUTC_TimeDateUpdateError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< UTC_TimeDateUpdateError >& error) = 0;

    virtual void onUTC_TimeDateUpdateStatus(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< UTC_TimeDateUpdateStatus >& status) = 0;
};

class VersionInfoCallbackIF {
public:
    virtual ~VersionInfoCallbackIF() {}

    virtual void onVersionInfoError(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< VersionInfoError >& error) = 0;

    virtual void onVersionInfoResult(const ::boost::shared_ptr< Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< VersionInfoResult >& result) = 0;
};

class Clock_main_fiProxyCallback;

/**
 * Clock_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'clock_main_fi' (specified in file
 * clock_main_fi.xml).
 *
 * CCA Functional Interface 'clock_main_fi'
 *
 * Fullname: VD Clock Service, Application Functional Interface
 *
 * Version: $Revision:   1.8  $
 *
 * Author: Selvakumar
 *
 * Date: $Date:  21.04.2015  $
 *
 * Department:
 *
 * Title: clock_main_fi
 *
 * <b>Description of 'clock_main_fi':</b>
 *
 * Virtual device to provide date and time information
 */
class Clock_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Clock_main_fiProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Clock_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Clock_main_fiProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Clock_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Clock_main_fiProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< Clock_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Clock_main_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Clock_main_fiProxy();

    // Method 'GetAvailableTimeZones'

    /**
     * Call the method 'GetAvailableTimeZones'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetAvailableTimeZones'</b>:
     *
     * Returns a list of available time zones for a given region
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAvailableTimeZonesStart(GetAvailableTimeZonesCallbackIF& cb);

    // Method 'GetTimeDateFromValue'

    /**
     * Call the method 'GetTimeDateFromValue'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetTimeDateFromValue'</b>:
     *
     * utility to transform a scalar date/time value
     * (seconds elapsed since begin of century)
     * into date and time fields (year, month, day, hours, minutes, seconds and weekday of current date)
     * (to be used e. g. to calculate estimated time of arrival).
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32TimeDateValue seconds elapsed since begin of century
     * valid:
     * 00000000h ... BC19137Fh (normal), spanning 100 years, beginnng 2000-1-1, 0:00
     * BC191380h ... CEE90B00h (overflow), spanning first decade of 2100 century
     * ED33FD00h ... FFFFFFFFh (underflow), interpreted negative, spanning last decade of 1900 century
     * invalid due to ambivalence:
     * CEE90B01h ... ED33FCFFh
     *
     * @param u8SourceDomain Domain (local or UTC/system RTC) of the given scalar time/date value
     * (optional, used for calculation across domains; if identical to enTargetDomain no conversion takes place)
     * 0 = UTC/system RTC, 1= Local time;
     * defaults to Local time
     *
     * @param u8TargetDomain Domain (local or UTC/system RTC) of the expected result
     * (optional, used for calculation across domains;
     * if identical to enSourceDomain no conversion takes place)
     * 0 = UTC/system RTC, 1= Local time;
     * defaults to Local time
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTimeDateFromValueStart(GetTimeDateFromValueCallbackIF& cb, uint32 u32TimeDateValue, uint8 u8SourceDomain = 1, uint8 u8TargetDomain = 1);

    // Method 'GetDaysPerMonth'

    /**
     * Call the method 'GetDaysPerMonth'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetDaysPerMonth'</b>:
     *
     * Calculates the number of days for a given month in a given year.
     * - takes into account leap years based on gregorian calendar.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param s16Year The year fraction of date according to standard gregorian calendar.
     * (between 2000 and 2100)
     *
     * @param u8Month The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDaysPerMonthStart(GetDaysPerMonthCallbackIF& cb, int16 s16Year, uint8 u8Month);

    // Method 'FID_S_DIAG_CONFIGURATION'

    /**
     * Call the method 'FID_S_DIAG_CONFIGURATION'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'FID_S_DIAG_CONFIGURATION'</b>:
     *
     * With this method the diagnosis component tells the CLOCK component
     * that it has to set its internal settings to its default values or that
     * it has to react on an update of the coding value or calibration items
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DefSetStateGroup Identifier of the Default Setting Group.
     *
     * @param DefSetStateMode TEF (production), USER (HMI), CODING or CALIBRATION
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_S_DIAG_CONFIGURATIONStart(FID_S_DIAG_CONFIGURATIONCallbackIF& cb, ::diagnostics_main_fi_types::T_e8_DefSetGroups defSetStateGroup, ::diagnostics_main_fi_types::T_e8_DefSetMode defSetStateMode);

    // Method 'ResetHistory'

    /**
     * Call the method 'ResetHistory'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'ResetHistory'</b>:
     *
     * This method is used to Clear History in Meter
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetHistoryStart(ResetHistoryCallbackIF& cb);

    // Method 'VersionInfo'

    /**
     * Call the method 'VersionInfo'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'VersionInfo'</b>:
     *
     * Send INC message request to MCAN to get version
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionInfoStart(VersionInfoCallbackIF& cb);

    // Property 'TimeZone'

    /**
     * Notify on the property 'TimeZone'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'TimeZone'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeZoneUpReg(TimeZoneCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TimeZone'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TimeZone'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendTimeZoneUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTimeZoneRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TimeZone'.
     */
    void sendTimeZoneRelUpRegAll ();

    /**
     * Returns the current value of the property 'TimeZone' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTimeZone()
     * returns true.
     *
     * @return the previously received value of the property 'TimeZone'.
     */
    const TimeZoneStatus& getTimeZone() const;

    /**
     * Determines whether a status message for the property 'TimeZone' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTimeZone() const;

    /**
     * Request the value of the property 'TimeZone' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TimeZone'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeZoneGet(TimeZoneCallbackIF& cb);

    /**
     * Set the value of the property 'TimeZone'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'TimeZone'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param u16Index <p>use values obtained from method</p>
     * <p>GetAvailableTimeZones</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeZoneSet(TimeZoneCallbackIF& cb, uint16 u16Index);

    // Property 'DaylightSavingTime'

    /**
     * Notify on the property 'DaylightSavingTime'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DaylightSavingTime'</b>:
     *
     * <p>Property, indicating (or modifying), whether daylight saving time</p>
     * <p>(summer time) is On or Off</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDaylightSavingTimeUpReg(DaylightSavingTimeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DaylightSavingTime'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DaylightSavingTime'</b>:
     *
     * <p>Property, indicating (or modifying), whether daylight saving time</p>
     * <p>(summer time) is On or Off</p>
     *
     * @param act The act which was previously returned by the
     * sendDaylightSavingTimeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDaylightSavingTimeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DaylightSavingTime'.
     */
    void sendDaylightSavingTimeRelUpRegAll ();

    /**
     * Returns the current value of the property 'DaylightSavingTime' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDaylightSavingTime() returns true.
     *
     * @return the previously received value of the property 'DaylightSavingTime'.
     */
    const DaylightSavingTimeStatus& getDaylightSavingTime() const;

    /**
     * Determines whether a status message for the property 'DaylightSavingTime' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDaylightSavingTime() const;

    /**
     * Request the value of the property 'DaylightSavingTime' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DaylightSavingTime'</b>:
     *
     * <p>Property, indicating (or modifying), whether daylight saving time</p>
     * <p>(summer time) is On or Off</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDaylightSavingTimeGet(DaylightSavingTimeCallbackIF& cb);

    /**
     * Set the value of the property 'DaylightSavingTime'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'DaylightSavingTime'</b>:
     *
     * <p>Property, indicating (or modifying), whether daylight saving time</p>
     * <p>(summer time) is On or Off</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param enDST_Setting <p></p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDaylightSavingTimeSet(DaylightSavingTimeCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Setting);

    // Property 'GPS_AutoSync'

    /**
     * Notify on the property 'GPS_AutoSync'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'GPS_AutoSync'</b>:
     *
     * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
     * <p>if GPS-signal is available. This property controls, whether it is</p>
     * <p>transparently visible to the user ( = Enabled) or compensated by</p>
     * <p>internal offset shifting ( = Disabled).</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGPS_AutoSyncUpReg(GPS_AutoSyncCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GPS_AutoSync'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GPS_AutoSync'</b>:
     *
     * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
     * <p>if GPS-signal is available. This property controls, whether it is</p>
     * <p>transparently visible to the user ( = Enabled) or compensated by</p>
     * <p>internal offset shifting ( = Disabled).</p>
     *
     * @param act The act which was previously returned by the
     * sendGPS_AutoSyncUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGPS_AutoSyncRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GPS_AutoSync'.
     */
    void sendGPS_AutoSyncRelUpRegAll ();

    /**
     * Returns the current value of the property 'GPS_AutoSync' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasGPS_AutoSync() returns true.
     *
     * @return the previously received value of the property 'GPS_AutoSync'.
     */
    const GPS_AutoSyncStatus& getGPS_AutoSync() const;

    /**
     * Determines whether a status message for the property 'GPS_AutoSync' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGPS_AutoSync() const;

    /**
     * Request the value of the property 'GPS_AutoSync' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'GPS_AutoSync'</b>:
     *
     * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
     * <p>if GPS-signal is available. This property controls, whether it is</p>
     * <p>transparently visible to the user ( = Enabled) or compensated by</p>
     * <p>internal offset shifting ( = Disabled).</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGPS_AutoSyncGet(GPS_AutoSyncCallbackIF& cb);

    /**
     * Set the value of the property 'GPS_AutoSync'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'GPS_AutoSync'</b>:
     *
     * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
     * <p>if GPS-signal is available. This property controls, whether it is</p>
     * <p>transparently visible to the user ( = Enabled) or compensated by</p>
     * <p>internal offset shifting ( = Disabled).</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param bEnabled <p>TRUE  = enable</p>
     * <p>FALSE = disable (free run or controlled by IC)</p>
     *
     * @param bPositionBased <p>TRUE  = enable</p>
     * <p>FALSE = disable (no automatic GPS time zone setting)</p>
     * <p>This will not be set because manual time zone or</p>
     * <p>or manual time is active</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGPS_AutoSyncSet(GPS_AutoSyncCallbackIF& cb, bool bEnabled, bool bPositionBased);

    // Property 'SyncMode'

    /**
     * Notify on the property 'SyncMode'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'SyncMode'</b>:
     *
     * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
     * <p>if GPS-signal is available. This property controls the source of local time:</p>
     * <p>GPS: UTC is transparently visible to the user</p>
     * <p>Manual: Compensated by internal offset shifting.</p>
     * <p>Auto: Set via received time on CAN.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSyncModeUpReg(SyncModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SyncMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SyncMode'</b>:
     *
     * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
     * <p>if GPS-signal is available. This property controls the source of local time:</p>
     * <p>GPS: UTC is transparently visible to the user</p>
     * <p>Manual: Compensated by internal offset shifting.</p>
     * <p>Auto: Set via received time on CAN.</p>
     *
     * @param act The act which was previously returned by the
     * sendSyncModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSyncModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SyncMode'.
     */
    void sendSyncModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SyncMode' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSyncMode()
     * returns true.
     *
     * @return the previously received value of the property 'SyncMode'.
     */
    const SyncModeStatus& getSyncMode() const;

    /**
     * Determines whether a status message for the property 'SyncMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSyncMode() const;

    /**
     * Request the value of the property 'SyncMode' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SyncMode'</b>:
     *
     * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
     * <p>if GPS-signal is available. This property controls the source of local time:</p>
     * <p>GPS: UTC is transparently visible to the user</p>
     * <p>Manual: Compensated by internal offset shifting.</p>
     * <p>Auto: Set via received time on CAN.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSyncModeGet(SyncModeCallbackIF& cb);

    /**
     * Set the value of the property 'SyncMode'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SyncMode'</b>:
     *
     * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
     * <p>if GPS-signal is available. This property controls the source of local time:</p>
     * <p>GPS: UTC is transparently visible to the user</p>
     * <p>Manual: Compensated by internal offset shifting.</p>
     * <p>Auto: Set via received time on CAN.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param enMode
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSyncModeSet(SyncModeCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_SyncMode enMode);

    // Property 'GPS_WeekEpoch'

    /**
     * Notify on the property 'GPS_WeekEpoch'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'GPS_WeekEpoch'</b>:
     *
     * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
     * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
     * <p>To avoid the clock to be resetted to last date when an overflow</p>
     * <p>has been arrived this property indicates the current</p>
     * <p>epoch which has been reached until today.</p>
     * <p>This property can be set by Nissan garage via service menu.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGPS_WeekEpochUpReg(GPS_WeekEpochCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GPS_WeekEpoch'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GPS_WeekEpoch'</b>:
     *
     * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
     * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
     * <p>To avoid the clock to be resetted to last date when an overflow</p>
     * <p>has been arrived this property indicates the current</p>
     * <p>epoch which has been reached until today.</p>
     * <p>This property can be set by Nissan garage via service menu.</p>
     *
     * @param act The act which was previously returned by the
     * sendGPS_WeekEpochUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGPS_WeekEpochRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GPS_WeekEpoch'.
     */
    void sendGPS_WeekEpochRelUpRegAll ();

    /**
     * Returns the current value of the property 'GPS_WeekEpoch' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasGPS_WeekEpoch() returns true.
     *
     * @return the previously received value of the property 'GPS_WeekEpoch'.
     */
    const GPS_WeekEpochStatus& getGPS_WeekEpoch() const;

    /**
     * Determines whether a status message for the property 'GPS_WeekEpoch' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGPS_WeekEpoch() const;

    /**
     * Request the value of the property 'GPS_WeekEpoch' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'GPS_WeekEpoch'</b>:
     *
     * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
     * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
     * <p>To avoid the clock to be resetted to last date when an overflow</p>
     * <p>has been arrived this property indicates the current</p>
     * <p>epoch which has been reached until today.</p>
     * <p>This property can be set by Nissan garage via service menu.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGPS_WeekEpochGet(GPS_WeekEpochCallbackIF& cb);

    /**
     * Set the value of the property 'GPS_WeekEpoch'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'GPS_WeekEpoch'</b>:
     *
     * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
     * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
     * <p>To avoid the clock to be resetted to last date when an overflow</p>
     * <p>has been arrived this property indicates the current</p>
     * <p>epoch which has been reached until today.</p>
     * <p>This property can be set by Nissan garage via service menu.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param GPSepoch <p>set value of current GPS week cycle</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGPS_WeekEpochSet(GPS_WeekEpochCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH gPSepoch);

    // Property 'LocalTimeOffset'

    /**
     * Notify on the property 'LocalTimeOffset'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeOffset'</b>:
     *
     * Provides Offset value to calculate the localtime from the System(UTC) time.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeOffsetUpReg(LocalTimeOffsetCallbackIF& cb);

    /**
     * Remove the notifcation on property 'LocalTimeOffset'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeOffset'</b>:
     *
     * Provides Offset value to calculate the localtime from the System(UTC) time.
     *
     * @param act The act which was previously returned by the
     * sendLocalTimeOffsetUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendLocalTimeOffsetRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'LocalTimeOffset'.
     */
    void sendLocalTimeOffsetRelUpRegAll ();

    /**
     * Returns the current value of the property 'LocalTimeOffset' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasLocalTimeOffset() returns true.
     *
     * @return the previously received value of the property 'LocalTimeOffset'.
     */
    const LocalTimeOffsetStatus& getLocalTimeOffset() const;

    /**
     * Determines whether a status message for the property 'LocalTimeOffset' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLocalTimeOffset() const;

    /**
     * Request the value of the property 'LocalTimeOffset' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeOffset'</b>:
     *
     * Provides Offset value to calculate the localtime from the System(UTC) time.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeOffsetGet(LocalTimeOffsetCallbackIF& cb);

    /**
     * Set the value of the property 'LocalTimeOffset'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeOffset'</b>:
     *
     * Provides Offset value to calculate the localtime from the System(UTC) time.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeOffsetSet(LocalTimeOffsetCallbackIF& cb);

    // Property 'LocalTimeDate'

    /**
     * Notify on the property 'LocalTimeDate'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeDate'</b>:
     *
     * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
     * The HMI application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     * @param u8UpdatePeriod This parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
     * Specify period of update notification (1=1/sec, 2=1/min, 3=1/h)
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeDateUpReg(LocalTimeDateCallbackIF& cb, uint8 u8UpdatePeriod);

    /**
     * Remove the notifcation on property 'LocalTimeDate'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeDate'</b>:
     *
     * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
     * The HMI application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendLocalTimeDateUpReg() method.
     *
     * @param u8UpdatePeriod This parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
     * Specify period of update notification (1=1/sec, 2=1/min, 3=1/h)
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendLocalTimeDateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'LocalTimeDate'.
     */
    void sendLocalTimeDateRelUpRegAll ();

    /**
     * Returns the current value of the property 'LocalTimeDate' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasLocalTimeDate(uint8 u8UpdatePeriod) returns true.
     *
     * @return the previously received value of the property 'LocalTimeDate'.
     */
    const LocalTimeDateStatus& getLocalTimeDate(uint8 u8UpdatePeriod) const;

    /**
     * Determines whether a status message for the property 'LocalTimeDate'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLocalTimeDate(uint8 u8UpdatePeriod) const;

    /**
     * Request the value of the property 'LocalTimeDate' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeDate'</b>:
     *
     * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
     * The HMI application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeDateGet(LocalTimeDateCallbackIF& cb);

    /**
     * Set the value of the property 'LocalTimeDate'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeDate'</b>:
     *
     * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
     * The HMI application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param s16Year The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @param u8Month The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Day The day fraction [1 .. month length] of date.
     *
     * @param u8Hours The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @param u8Minutes The minutes fraction [0-59] of time.
     *
     * @param u8Seconds The seconds fraction [0-59] of time.
     *
     * @param u8Weekday The weekday fraction [1-7] of time.
     *
     * @param u8ChangeMask mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeDateSet(LocalTimeDateCallbackIF& cb, int16 s16Year, uint8 u8Month, uint8 u8Day, uint8 u8Hours, uint8 u8Minutes, uint8 u8Seconds, uint8 u8Weekday, uint8 u8ChangeMask);

    // Property 'TimeFormat'

    /**
     * Notify on the property 'TimeFormat'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'TimeFormat'</b>:
     *
     * European (24h) or American (12h a.m./p.m.) time format for use in HMI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeFormatUpReg(TimeFormatCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TimeFormat'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TimeFormat'</b>:
     *
     * European (24h) or American (12h a.m./p.m.) time format for use in HMI
     *
     * @param act The act which was previously returned by the
     * sendTimeFormatUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTimeFormatRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TimeFormat'.
     */
    void sendTimeFormatRelUpRegAll ();

    /**
     * Returns the current value of the property 'TimeFormat' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasTimeFormat() returns true.
     *
     * @return the previously received value of the property 'TimeFormat'.
     */
    const TimeFormatStatus& getTimeFormat() const;

    /**
     * Determines whether a status message for the property 'TimeFormat' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTimeFormat() const;

    /**
     * Request the value of the property 'TimeFormat' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TimeFormat'</b>:
     *
     * European (24h) or American (12h a.m./p.m.) time format for use in HMI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeFormatGet(TimeFormatCallbackIF& cb);

    /**
     * Set the value of the property 'TimeFormat'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'TimeFormat'</b>:
     *
     * European (24h) or American (12h a.m./p.m.) time format for use in HMI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param enTimeFormat
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeFormatSet(TimeFormatCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat);

    // Property 'DateFormat'

    /**
     * Notify on the property 'DateFormat'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'DateFormat'</b>:
     *
     * switch between date formats (for use by HMI):
     * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDateFormatUpReg(DateFormatCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DateFormat'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DateFormat'</b>:
     *
     * switch between date formats (for use by HMI):
     * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
     *
     * @param act The act which was previously returned by the
     * sendDateFormatUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDateFormatRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DateFormat'.
     */
    void sendDateFormatRelUpRegAll ();

    /**
     * Returns the current value of the property 'DateFormat' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasDateFormat() returns true.
     *
     * @return the previously received value of the property 'DateFormat'.
     */
    const DateFormatStatus& getDateFormat() const;

    /**
     * Determines whether a status message for the property 'DateFormat' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDateFormat() const;

    /**
     * Request the value of the property 'DateFormat' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DateFormat'</b>:
     *
     * switch between date formats (for use by HMI):
     * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDateFormatGet(DateFormatCallbackIF& cb);

    /**
     * Set the value of the property 'DateFormat'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'DateFormat'</b>:
     *
     * switch between date formats (for use by HMI):
     * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param enDateFormat
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDateFormatSet(DateFormatCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat);

    // Property 'ClockSourceStatus'

    /**
     * Notify on the property 'ClockSourceStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ClockSourceStatus'</b>:
     *
     * Status of different clock sources (system, master, GPS; read only).
     * Used by HMI to determine whether manual setting shall be enabled
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClockSourceStatusUpReg(ClockSourceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ClockSourceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ClockSourceStatus'</b>:
     *
     * Status of different clock sources (system, master, GPS; read only).
     * Used by HMI to determine whether manual setting shall be enabled
     *
     * @param act The act which was previously returned by the
     * sendClockSourceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendClockSourceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ClockSourceStatus'.
     */
    void sendClockSourceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'ClockSourceStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasClockSourceStatus() returns true.
     *
     * @return the previously received value of the property 'ClockSourceStatus'.
     */
    const ClockSourceStatusStatus& getClockSourceStatus() const;

    /**
     * Determines whether a status message for the property 'ClockSourceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasClockSourceStatus() const;

    /**
     * Request the value of the property 'ClockSourceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ClockSourceStatus'</b>:
     *
     * Status of different clock sources (system, master, GPS; read only).
     * Used by HMI to determine whether manual setting shall be enabled
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClockSourceStatusGet(ClockSourceStatusCallbackIF& cb);

    // Property 'FormatSourceStatus'

    /**
     * Notify on the property 'FormatSourceStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'FormatSourceStatus'</b>:
     *
     * Status of master signal dictating date and time format (read only).
     * Used by HMI to determine whether manual setting shall be enabled
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFormatSourceStatusUpReg(FormatSourceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FormatSourceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FormatSourceStatus'</b>:
     *
     * Status of master signal dictating date and time format (read only).
     * Used by HMI to determine whether manual setting shall be enabled
     *
     * @param act The act which was previously returned by the
     * sendFormatSourceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFormatSourceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FormatSourceStatus'.
     */
    void sendFormatSourceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'FormatSourceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasFormatSourceStatus() returns true.
     *
     * @return the previously received value of the property 'FormatSourceStatus'.
     */
    const FormatSourceStatusStatus& getFormatSourceStatus() const;

    /**
     * Determines whether a status message for the property 'FormatSourceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFormatSourceStatus() const;

    /**
     * Request the value of the property 'FormatSourceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'FormatSourceStatus'</b>:
     *
     * Status of master signal dictating date and time format (read only).
     * Used by HMI to determine whether manual setting shall be enabled
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFormatSourceStatusGet(FormatSourceStatusCallbackIF& cb);

    // Property 'LocalTimeDate_MinuteUpdate'

    /**
     * Notify on the property 'LocalTimeDate_MinuteUpdate'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeDate_MinuteUpdate'</b>:
     *
     * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeDate_MinuteUpdateUpReg(LocalTimeDate_MinuteUpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'LocalTimeDate_MinuteUpdate'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeDate_MinuteUpdate'</b>:
     *
     * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendLocalTimeDate_MinuteUpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendLocalTimeDate_MinuteUpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'LocalTimeDate_MinuteUpdate'.
     */
    void sendLocalTimeDate_MinuteUpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'LocalTimeDate_MinuteUpdate'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasLocalTimeDate_MinuteUpdate() returns true.
     *
     * @return the previously received value of the property 'LocalTimeDate_MinuteUpdate'.
     */
    const LocalTimeDate_MinuteUpdateStatus& getLocalTimeDate_MinuteUpdate() const;

    /**
     * Determines whether a status message for the property 'LocalTimeDate_MinuteUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLocalTimeDate_MinuteUpdate() const;

    /**
     * Request the value of the property 'LocalTimeDate_MinuteUpdate' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeDate_MinuteUpdate'</b>:
     *
     * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeDate_MinuteUpdateGet(LocalTimeDate_MinuteUpdateCallbackIF& cb);

    /**
     * Set the value of the property 'LocalTimeDate_MinuteUpdate'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'LocalTimeDate_MinuteUpdate'</b>:
     *
     * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param s16Year The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @param u8Month The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Day The day fraction [1 .. month length] of date.
     *
     * @param u8Hours The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @param u8Minutes The minutes fraction [0-59] of time.
     *
     * @param u8Seconds The seconds fraction [0-59] of time.
     *
     * @param u8Weekday The weekday fraction [1-7] of time.
     *
     * @param u8ChangeMask mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLocalTimeDate_MinuteUpdateSet(LocalTimeDate_MinuteUpdateCallbackIF& cb, int16 s16Year, uint8 u8Month, uint8 u8Day, uint8 u8Hours, uint8 u8Minutes, uint8 u8Seconds, uint8 u8Weekday, uint8 u8ChangeMask);

    // Property 'Region_TimeZone'

    /**
     * Notify on the property 'Region_TimeZone'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Region_TimeZone'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegion_TimeZoneUpReg(Region_TimeZoneCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Region_TimeZone'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Region_TimeZone'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendRegion_TimeZoneUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRegion_TimeZoneRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Region_TimeZone'.
     */
    void sendRegion_TimeZoneRelUpRegAll ();

    /**
     * Returns the current value of the property 'Region_TimeZone' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRegion_TimeZone() returns true.
     *
     * @return the previously received value of the property 'Region_TimeZone'.
     */
    const Region_TimeZoneStatus& getRegion_TimeZone() const;

    /**
     * Determines whether a status message for the property 'Region_TimeZone' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRegion_TimeZone() const;

    /**
     * Request the value of the property 'Region_TimeZone' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Region_TimeZone'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegion_TimeZoneGet(Region_TimeZoneCallbackIF& cb);

    /**
     * Set the value of the property 'Region_TimeZone'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'Region_TimeZone'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param enTIMEZONE_Settings <p>use values obtained from method</p>
     * <p>GetAvailableTimeZones</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegion_TimeZoneSet(Region_TimeZoneCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings);

    // Property 'Auto_TimeZoneOffset'

    /**
     * Notify on the property 'Auto_TimeZoneOffset'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Auto_TimeZoneOffset'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAuto_TimeZoneOffsetUpReg(Auto_TimeZoneOffsetCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Auto_TimeZoneOffset'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Auto_TimeZoneOffset'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendAuto_TimeZoneOffsetUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAuto_TimeZoneOffsetRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Auto_TimeZoneOffset'.
     */
    void sendAuto_TimeZoneOffsetRelUpRegAll ();

    /**
     * Returns the current value of the property 'Auto_TimeZoneOffset' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAuto_TimeZoneOffset() returns true.
     *
     * @return the previously received value of the property 'Auto_TimeZoneOffset'.
     */
    const Auto_TimeZoneOffsetStatus& getAuto_TimeZoneOffset() const;

    /**
     * Determines whether a status message for the property 'Auto_TimeZoneOffset' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAuto_TimeZoneOffset() const;

    /**
     * Request the value of the property 'Auto_TimeZoneOffset' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Auto_TimeZoneOffset'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAuto_TimeZoneOffsetGet(Auto_TimeZoneOffsetCallbackIF& cb);

    /**
     * Set the value of the property 'Auto_TimeZoneOffset'. This method sends
     * a Set message to the CCA server.
     *
     * <b>Documentation of 'Auto_TimeZoneOffset'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param s8Offset_Hour Provides the offsetseconds in number of hours. [-12to +12]
     *
     * @param s8Offset_Minute Provides the offsetseconds in number of minutes. [-59to +59]
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAuto_TimeZoneOffsetSet(Auto_TimeZoneOffsetCallbackIF& cb, int8 s8Offset_Hour, int8 s8Offset_Minute);

    // Property 'NewDateFormat'

    /**
     * Notify on the property 'NewDateFormat'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'NewDateFormat'</b>:
     *
     * switch between date formats (for use by HMI):
     * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewDateFormatUpReg(NewDateFormatCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NewDateFormat'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NewDateFormat'</b>:
     *
     * switch between date formats (for use by HMI):
     * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
     *
     * @param act The act which was previously returned by the
     * sendNewDateFormatUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNewDateFormatRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NewDateFormat'.
     */
    void sendNewDateFormatRelUpRegAll ();

    /**
     * Returns the current value of the property 'NewDateFormat' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNewDateFormat() returns true.
     *
     * @return the previously received value of the property 'NewDateFormat'.
     */
    const NewDateFormatStatus& getNewDateFormat() const;

    /**
     * Determines whether a status message for the property 'NewDateFormat' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNewDateFormat() const;

    /**
     * Request the value of the property 'NewDateFormat' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'NewDateFormat'</b>:
     *
     * switch between date formats (for use by HMI):
     * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewDateFormatGet(NewDateFormatCallbackIF& cb);

    /**
     * Set the value of the property 'NewDateFormat'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'NewDateFormat'</b>:
     *
     * switch between date formats (for use by HMI):
     * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param enDateFormat
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewDateFormatSet(NewDateFormatCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat);

    // Property 'Connection'

    /**
     * Notify on the property 'Connection'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'Connection'</b>:
     *
     * This property gives information about the connection status to the various MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectionUpReg(ConnectionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Connection'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Connection'</b>:
     *
     * This property gives information about the connection status to the various MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendConnectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendConnectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Connection'.
     */
    void sendConnectionRelUpRegAll ();

    /**
     * Returns the current value of the property 'Connection' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasConnection() returns true.
     *
     * @return the previously received value of the property 'Connection'.
     */
    const ConnectionStatus& getConnection() const;

    /**
     * Determines whether a status message for the property 'Connection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnection() const;

    /**
     * Request the value of the property 'Connection' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Connection'</b>:
     *
     * This property gives information about the connection status to the various MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectionGet(ConnectionCallbackIF& cb);

    // Property 'TimeZone_DSTAvailability'

    /**
     * Notify on the property 'TimeZone_DSTAvailability'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'TimeZone_DSTAvailability'</b>:
     *
     * This property gives information about the availability of timezones and DST for specific regions.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeZone_DSTAvailabilityUpReg(TimeZone_DSTAvailabilityCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TimeZone_DSTAvailability'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TimeZone_DSTAvailability'</b>:
     *
     * This property gives information about the availability of timezones and DST for specific regions.
     *
     * @param act The act which was previously returned by the
     * sendTimeZone_DSTAvailabilityUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTimeZone_DSTAvailabilityRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TimeZone_DSTAvailability'.
     */
    void sendTimeZone_DSTAvailabilityRelUpRegAll ();

    /**
     * Returns the current value of the property 'TimeZone_DSTAvailability'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasTimeZone_DSTAvailability() returns true.
     *
     * @return the previously received value of the property 'TimeZone_DSTAvailability'.
     */
    const TimeZone_DSTAvailabilityStatus& getTimeZone_DSTAvailability() const;

    /**
     * Determines whether a status message for the property 'TimeZone_DSTAvailability' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTimeZone_DSTAvailability() const;

    /**
     * Request the value of the property 'TimeZone_DSTAvailability' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TimeZone_DSTAvailability'</b>:
     *
     * This property gives information about the availability of timezones and DST for specific regions.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeZone_DSTAvailabilityGet(TimeZone_DSTAvailabilityCallbackIF& cb);

    // Property 'HardwareVersion'

    /**
     * Notify on the property 'HardwareVersion'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHardwareVersionUpReg(HardwareVersionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'HardwareVersion'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendHardwareVersionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendHardwareVersionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'HardwareVersion'.
     */
    void sendHardwareVersionRelUpRegAll ();

    /**
     * Returns the current value of the property 'HardwareVersion' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasHardwareVersion() returns true.
     *
     * @return the previously received value of the property 'HardwareVersion'.
     */
    const HardwareVersionStatus& getHardwareVersion() const;

    /**
     * Determines whether a status message for the property 'HardwareVersion' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasHardwareVersion() const;

    /**
     * Request the value of the property 'HardwareVersion' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHardwareVersionGet(HardwareVersionCallbackIF& cb);

    // Property 'SoftwareVersion'

    /**
     * Notify on the property 'SoftwareVersion'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSoftwareVersionUpReg(SoftwareVersionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SoftwareVersion'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendSoftwareVersionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSoftwareVersionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SoftwareVersion'.
     */
    void sendSoftwareVersionRelUpRegAll ();

    /**
     * Returns the current value of the property 'SoftwareVersion' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSoftwareVersion() returns true.
     *
     * @return the previously received value of the property 'SoftwareVersion'.
     */
    const SoftwareVersionStatus& getSoftwareVersion() const;

    /**
     * Determines whether a status message for the property 'SoftwareVersion' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSoftwareVersion() const;

    /**
     * Request the value of the property 'SoftwareVersion' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSoftwareVersionGet(SoftwareVersionCallbackIF& cb);

    // Property 'DebugMode_TimeDate'

    /**
     * Notify on the property 'DebugMode_TimeDate'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DebugMode_TimeDate'</b>:
     *
     * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDebugMode_TimeDateUpReg(DebugMode_TimeDateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DebugMode_TimeDate'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DebugMode_TimeDate'</b>:
     *
     * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendDebugMode_TimeDateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDebugMode_TimeDateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DebugMode_TimeDate'.
     */
    void sendDebugMode_TimeDateRelUpRegAll ();

    /**
     * Returns the current value of the property 'DebugMode_TimeDate' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDebugMode_TimeDate() returns true.
     *
     * @return the previously received value of the property 'DebugMode_TimeDate'.
     */
    const DebugMode_TimeDateStatus& getDebugMode_TimeDate() const;

    /**
     * Determines whether a status message for the property 'DebugMode_TimeDate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDebugMode_TimeDate() const;

    /**
     * Request the value of the property 'DebugMode_TimeDate' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DebugMode_TimeDate'</b>:
     *
     * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDebugMode_TimeDateGet(DebugMode_TimeDateCallbackIF& cb);

    /**
     * Set the value of the property 'DebugMode_TimeDate'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'DebugMode_TimeDate'</b>:
     *
     * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param s16Year The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @param u8Month The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Day The day fraction [1 .. month length] of date.
     *
     * @param u8Hours The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @param u8Minutes The minutes fraction [0-59] of time.
     *
     * @param u8Seconds The seconds fraction [0-59] of time.
     *
     * @param u8Weekday The weekday fraction [1-7] of time.
     *
     * @param bdebugMode The weekday fraction [1-7] of time.
     *
     * @param u8ChangeMask mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDebugMode_TimeDateSet(DebugMode_TimeDateCallbackIF& cb, int16 s16Year, uint8 u8Month, uint8 u8Day, uint8 u8Hours, uint8 u8Minutes, uint8 u8Seconds, uint8 u8Weekday, bool bdebugMode, uint8 u8ChangeMask);

    // Property 'UTC_TimeDateUpdate'

    /**
     * Notify on the property 'UTC_TimeDateUpdate'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'UTC_TimeDateUpdate'</b>:
     *
     * Current date and time. This is updated every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUTC_TimeDateUpdateUpReg(UTC_TimeDateUpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'UTC_TimeDateUpdate'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'UTC_TimeDateUpdate'</b>:
     *
     * Current date and time. This is updated every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendUTC_TimeDateUpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendUTC_TimeDateUpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'UTC_TimeDateUpdate'.
     */
    void sendUTC_TimeDateUpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'UTC_TimeDateUpdate' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasUTC_TimeDateUpdate() returns true.
     *
     * @return the previously received value of the property 'UTC_TimeDateUpdate'.
     */
    const UTC_TimeDateUpdateStatus& getUTC_TimeDateUpdate() const;

    /**
     * Determines whether a status message for the property 'UTC_TimeDateUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUTC_TimeDateUpdate() const;

    /**
     * Request the value of the property 'UTC_TimeDateUpdate' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'UTC_TimeDateUpdate'</b>:
     *
     * Current date and time. This is updated every second.
     * The client application should use the following parameters:
     * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
     * SERVICEID = CCA_C_U16_SRV_CLOCK,
     * APPID     = CCA_C_U16_APP_VD_CLOCK,
     * TARGETID    = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUTC_TimeDateUpdateGet(UTC_TimeDateUpdateCallbackIF& cb);

    // Property 'HUD_Activation'

    /**
     * Notify on the property 'HUD_Activation'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'HUD_Activation'</b>:
     *
     * <p>Property, indicating (or modifying), HUD activation</p>
     * <p>(summer time) is On or Off</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHUD_ActivationUpReg(HUD_ActivationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'HUD_Activation'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'HUD_Activation'</b>:
     *
     * <p>Property, indicating (or modifying), HUD activation</p>
     * <p>(summer time) is On or Off</p>
     *
     * @param act The act which was previously returned by the
     * sendHUD_ActivationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendHUD_ActivationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'HUD_Activation'.
     */
    void sendHUD_ActivationRelUpRegAll ();

    /**
     * Returns the current value of the property 'HUD_Activation' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasHUD_Activation() returns true.
     *
     * @return the previously received value of the property 'HUD_Activation'.
     */
    const HUD_ActivationStatus& getHUD_Activation() const;

    /**
     * Determines whether a status message for the property 'HUD_Activation' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasHUD_Activation() const;

    /**
     * Request the value of the property 'HUD_Activation' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'HUD_Activation'</b>:
     *
     * <p>Property, indicating (or modifying), HUD activation</p>
     * <p>(summer time) is On or Off</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHUD_ActivationGet(HUD_ActivationCallbackIF& cb);

    /**
     * Set the value of the property 'HUD_Activation'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'HUD_Activation'</b>:
     *
     * <p>Property, indicating (or modifying), HUD activation</p>
     * <p>(summer time) is On or Off</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param enHUD_Setting <p></p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHUD_ActivationSet(HUD_ActivationCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings enHUD_Setting);

    // Property 'HUD_Postition'

    /**
     * Notify on the property 'HUD_Postition'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'HUD_Postition'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHUD_PostitionUpReg(HUD_PostitionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'HUD_Postition'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'HUD_Postition'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendHUD_PostitionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendHUD_PostitionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'HUD_Postition'.
     */
    void sendHUD_PostitionRelUpRegAll ();

    /**
     * Returns the current value of the property 'HUD_Postition' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasHUD_Postition() returns true.
     *
     * @return the previously received value of the property 'HUD_Postition'.
     */
    const HUD_PostitionStatus& getHUD_Postition() const;

    /**
     * Determines whether a status message for the property 'HUD_Postition' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasHUD_Postition() const;

    /**
     * Request the value of the property 'HUD_Postition' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'HUD_Postition'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHUD_PostitionGet(HUD_PostitionCallbackIF& cb);

    /**
     * Set the value of the property 'HUD_Postition'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'HUD_Postition'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param u8Up_Position Sets scalar value of the position of HUD in the upward movement
     *
     * @param u8Down_Position Sets scalar value of the position of HUD in the downward movement
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHUD_PostitionSet(HUD_PostitionCallbackIF& cb, uint8 u8Up_Position, uint8 u8Down_Position);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Clock_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'TimeZone'

    ::asf::core::nullable< TimeZoneStatus > _timeZone;

    // Property 'DaylightSavingTime'

    ::asf::core::nullable< DaylightSavingTimeStatus > _daylightSavingTime;

    // Property 'GPS_AutoSync'

    ::asf::core::nullable< GPS_AutoSyncStatus > _gPS_AutoSync;

    // Property 'SyncMode'

    ::asf::core::nullable< SyncModeStatus > _syncMode;

    // Property 'GPS_WeekEpoch'

    ::asf::core::nullable< GPS_WeekEpochStatus > _gPS_WeekEpoch;

    // Property 'LocalTimeOffset'

    ::asf::core::nullable< LocalTimeOffsetStatus > _localTimeOffset;

    // Property 'LocalTimeDate'

    typedef std::map<LocalTimeDateRelUpReg, LocalTimeDateStatus > LocalTimeDateMap;
    LocalTimeDateMap _localTimeDateMap;

    // Property 'TimeFormat'

    ::asf::core::nullable< TimeFormatStatus > _timeFormat;

    // Property 'DateFormat'

    ::asf::core::nullable< DateFormatStatus > _dateFormat;

    // Property 'ClockSourceStatus'

    ::asf::core::nullable< ClockSourceStatusStatus > _clockSourceStatus;

    // Property 'FormatSourceStatus'

    ::asf::core::nullable< FormatSourceStatusStatus > _formatSourceStatus;

    // Property 'LocalTimeDate_MinuteUpdate'

    ::asf::core::nullable< LocalTimeDate_MinuteUpdateStatus > _localTimeDate_MinuteUpdate;

    // Property 'Region_TimeZone'

    ::asf::core::nullable< Region_TimeZoneStatus > _region_TimeZone;

    // Property 'Auto_TimeZoneOffset'

    ::asf::core::nullable< Auto_TimeZoneOffsetStatus > _auto_TimeZoneOffset;

    // Property 'NewDateFormat'

    ::asf::core::nullable< NewDateFormatStatus > _newDateFormat;

    // Property 'Connection'

    ::asf::core::nullable< ConnectionStatus > _connection;

    // Property 'TimeZone_DSTAvailability'

    ::asf::core::nullable< TimeZone_DSTAvailabilityStatus > _timeZone_DSTAvailability;

    // Property 'HardwareVersion'

    ::asf::core::nullable< HardwareVersionStatus > _hardwareVersion;

    // Property 'SoftwareVersion'

    ::asf::core::nullable< SoftwareVersionStatus > _softwareVersion;

    // Property 'DebugMode_TimeDate'

    ::asf::core::nullable< DebugMode_TimeDateStatus > _debugMode_TimeDate;

    // Property 'UTC_TimeDateUpdate'

    ::asf::core::nullable< UTC_TimeDateUpdateStatus > _uTC_TimeDateUpdate;

    // Property 'HUD_Activation'

    ::asf::core::nullable< HUD_ActivationStatus > _hUD_Activation;

    // Property 'HUD_Postition'

    ::asf::core::nullable< HUD_PostitionStatus > _hUD_Postition;

    DECLARE_CLASS_LOGGER();

    friend class Clock_main_fiProxyCallback;
};

} // namespace clock_main_fi

#endif // CLOCK_MAIN_FIPROXY_H
