/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "clock_main_fiCca.h"
#include "clock_main_fiJson.h"
#include "clock_main_fiProxy.h"
#include "clock_main_fi_typesConst.h"
#include "diagnostics_main_fi_typesConst.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace clock_main_fi {

/*static*/ ::asf::core::Logger Clock_main_fiProxy::_logger ("/clock_main_fi/Clock_main_fiProxy");


class Clock_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Clock_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Clock_main_fiProxy> proxy = ::boost::static_pointer_cast<Clock_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_GetAvailableTimeZones: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GetAvailableTimeZonesResult);
                                setActAndLogResult(message, "GetAvailableTimeZones", reinterpret_cast<act_t>(this), _logger);
                                ((GetAvailableTimeZonesCallbackIF*) _callback)->onGetAvailableTimeZonesResult (proxy, ::boost::static_pointer_cast<GetAvailableTimeZonesResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GetAvailableTimeZonesError);
                                setActAndLogError(message, "GetAvailableTimeZones", reinterpret_cast<act_t>(this), _logger);
                                ((GetAvailableTimeZonesCallbackIF*) _callback)->onGetAvailableTimeZonesError (proxy, ::boost::static_pointer_cast<GetAvailableTimeZonesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetTimeDateFromValue: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GetTimeDateFromValueResult);
                                setActAndLogResult(message, "GetTimeDateFromValue", reinterpret_cast<act_t>(this), _logger);
                                ((GetTimeDateFromValueCallbackIF*) _callback)->onGetTimeDateFromValueResult (proxy, ::boost::static_pointer_cast<GetTimeDateFromValueResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GetTimeDateFromValueError);
                                setActAndLogError(message, "GetTimeDateFromValue", reinterpret_cast<act_t>(this), _logger);
                                ((GetTimeDateFromValueCallbackIF*) _callback)->onGetTimeDateFromValueError (proxy, ::boost::static_pointer_cast<GetTimeDateFromValueError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetDaysPerMonth: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GetDaysPerMonthResult);
                                setActAndLogResult(message, "GetDaysPerMonth", reinterpret_cast<act_t>(this), _logger);
                                ((GetDaysPerMonthCallbackIF*) _callback)->onGetDaysPerMonthResult (proxy, ::boost::static_pointer_cast<GetDaysPerMonthResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GetDaysPerMonthError);
                                setActAndLogError(message, "GetDaysPerMonth", reinterpret_cast<act_t>(this), _logger);
                                ((GetDaysPerMonthCallbackIF*) _callback)->onGetDaysPerMonthError (proxy, ::boost::static_pointer_cast<GetDaysPerMonthError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FID_S_DIAG_CONFIGURATION: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::FID_S_DIAG_CONFIGURATIONResult);
                                setActAndLogResult(message, "FID_S_DIAG_CONFIGURATION", reinterpret_cast<act_t>(this), _logger);
                                ((FID_S_DIAG_CONFIGURATIONCallbackIF*) _callback)->onFID_S_DIAG_CONFIGURATIONResult (proxy, ::boost::static_pointer_cast<FID_S_DIAG_CONFIGURATIONResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::FID_S_DIAG_CONFIGURATIONError);
                                setActAndLogError(message, "FID_S_DIAG_CONFIGURATION", reinterpret_cast<act_t>(this), _logger);
                                ((FID_S_DIAG_CONFIGURATIONCallbackIF*) _callback)->onFID_S_DIAG_CONFIGURATIONError (proxy, ::boost::static_pointer_cast<FID_S_DIAG_CONFIGURATIONError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ResetHistory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::ResetHistoryResult);
                                setActAndLogResult(message, "ResetHistory", reinterpret_cast<act_t>(this), _logger);
                                ((ResetHistoryCallbackIF*) _callback)->onResetHistoryResult (proxy, ::boost::static_pointer_cast<ResetHistoryResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::ResetHistoryError);
                                setActAndLogError(message, "ResetHistory", reinterpret_cast<act_t>(this), _logger);
                                ((ResetHistoryCallbackIF*) _callback)->onResetHistoryError (proxy, ::boost::static_pointer_cast<ResetHistoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VersionInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::VersionInfoResult);
                                setActAndLogResult(message, "VersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ((VersionInfoCallbackIF*) _callback)->onVersionInfoResult (proxy, ::boost::static_pointer_cast<VersionInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::VersionInfoError);
                                setActAndLogError(message, "VersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ((VersionInfoCallbackIF*) _callback)->onVersionInfoError (proxy, ::boost::static_pointer_cast<VersionInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TimeZone: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::TimeZoneStatus);
                                setActAndLogStatus(message, "TimeZone", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TimeZoneStatus> payload = ::boost::static_pointer_cast<TimeZoneStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TimeZoneStatus >& refNullableStatus = proxy->_timeZone;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TimeZoneCallbackIF*) _callback)->onTimeZoneStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TimeZoneCallbackIF*) _callback)->onTimeZoneStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::TimeZoneError);
                                setActAndLogError(message, "TimeZone", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TimeZoneCallbackIF*) _callback)->onTimeZoneError(proxy, ::boost::static_pointer_cast<TimeZoneError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DaylightSavingTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::DaylightSavingTimeStatus);
                                setActAndLogStatus(message, "DaylightSavingTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DaylightSavingTimeStatus> payload = ::boost::static_pointer_cast<DaylightSavingTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DaylightSavingTimeStatus >& refNullableStatus = proxy->_daylightSavingTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DaylightSavingTimeCallbackIF*) _callback)->onDaylightSavingTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DaylightSavingTimeCallbackIF*) _callback)->onDaylightSavingTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::DaylightSavingTimeError);
                                setActAndLogError(message, "DaylightSavingTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DaylightSavingTimeCallbackIF*) _callback)->onDaylightSavingTimeError(proxy, ::boost::static_pointer_cast<DaylightSavingTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GPS_AutoSync: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GPS_AutoSyncStatus);
                                setActAndLogStatus(message, "GPS_AutoSync", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GPS_AutoSyncStatus> payload = ::boost::static_pointer_cast<GPS_AutoSyncStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GPS_AutoSyncStatus >& refNullableStatus = proxy->_gPS_AutoSync;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GPS_AutoSyncCallbackIF*) _callback)->onGPS_AutoSyncStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GPS_AutoSyncCallbackIF*) _callback)->onGPS_AutoSyncStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GPS_AutoSyncError);
                                setActAndLogError(message, "GPS_AutoSync", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GPS_AutoSyncCallbackIF*) _callback)->onGPS_AutoSyncError(proxy, ::boost::static_pointer_cast<GPS_AutoSyncError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SyncMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::SyncModeStatus);
                                setActAndLogStatus(message, "SyncMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SyncModeStatus> payload = ::boost::static_pointer_cast<SyncModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SyncModeStatus >& refNullableStatus = proxy->_syncMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SyncModeCallbackIF*) _callback)->onSyncModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SyncModeCallbackIF*) _callback)->onSyncModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::SyncModeError);
                                setActAndLogError(message, "SyncMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SyncModeCallbackIF*) _callback)->onSyncModeError(proxy, ::boost::static_pointer_cast<SyncModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GPS_WeekEpoch: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GPS_WeekEpochStatus);
                                setActAndLogStatus(message, "GPS_WeekEpoch", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GPS_WeekEpochStatus> payload = ::boost::static_pointer_cast<GPS_WeekEpochStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GPS_WeekEpochStatus >& refNullableStatus = proxy->_gPS_WeekEpoch;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GPS_WeekEpochCallbackIF*) _callback)->onGPS_WeekEpochStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GPS_WeekEpochCallbackIF*) _callback)->onGPS_WeekEpochStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::GPS_WeekEpochError);
                                setActAndLogError(message, "GPS_WeekEpoch", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GPS_WeekEpochCallbackIF*) _callback)->onGPS_WeekEpochError(proxy, ::boost::static_pointer_cast<GPS_WeekEpochError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_LocalTimeOffset: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::LocalTimeOffsetStatus);
                                setActAndLogStatus(message, "LocalTimeOffset", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<LocalTimeOffsetStatus> payload = ::boost::static_pointer_cast<LocalTimeOffsetStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< LocalTimeOffsetStatus >& refNullableStatus = proxy->_localTimeOffset;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((LocalTimeOffsetCallbackIF*) _callback)->onLocalTimeOffsetStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((LocalTimeOffsetCallbackIF*) _callback)->onLocalTimeOffsetStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::LocalTimeOffsetError);
                                setActAndLogError(message, "LocalTimeOffset", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((LocalTimeOffsetCallbackIF*) _callback)->onLocalTimeOffsetError(proxy, ::boost::static_pointer_cast<LocalTimeOffsetError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_LocalTimeDate: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::LocalTimeDateStatus);
                                setActAndLogStatus(message, "LocalTimeDate", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<LocalTimeDateStatus> payload = ::boost::static_pointer_cast<LocalTimeDateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::boost::shared_ptr<LocalTimeDateRelUpReg> relUpRegPara = ::boost::static_pointer_cast<LocalTimeDateRelUpReg>(_message->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        Clock_main_fiProxy::LocalTimeDateMap& refStatusMap = proxy->_localTimeDateMap;
                                        Clock_main_fiProxy::LocalTimeDateMap::iterator it = refStatusMap.find(*relUpRegPara);
                                        if (it == refStatusMap.end()) {
                                            ((LocalTimeDateCallbackIF*) _callback)->onLocalTimeDateStatus(proxy, payload);
                                            refStatusMap[*relUpRegPara] = *payload.get();
                                        }
                                        else if (message.isLoopBack() == false || (*it).second == *payload.get()) {
                                            ((LocalTimeDateCallbackIF*) _callback)->onLocalTimeDateStatus(proxy, payload);
                                            (*it).second = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((LocalTimeDateCallbackIF*) _callback)->onLocalTimeDateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::LocalTimeDateError);
                                setActAndLogError(message, "LocalTimeDate", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((LocalTimeDateCallbackIF*) _callback)->onLocalTimeDateError(proxy, ::boost::static_pointer_cast<LocalTimeDateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TimeFormat: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::TimeFormatStatus);
                                setActAndLogStatus(message, "TimeFormat", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TimeFormatStatus> payload = ::boost::static_pointer_cast<TimeFormatStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TimeFormatStatus >& refNullableStatus = proxy->_timeFormat;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TimeFormatCallbackIF*) _callback)->onTimeFormatStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TimeFormatCallbackIF*) _callback)->onTimeFormatStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::TimeFormatError);
                                setActAndLogError(message, "TimeFormat", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TimeFormatCallbackIF*) _callback)->onTimeFormatError(proxy, ::boost::static_pointer_cast<TimeFormatError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DateFormat: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::DateFormatStatus);
                                setActAndLogStatus(message, "DateFormat", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DateFormatStatus> payload = ::boost::static_pointer_cast<DateFormatStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DateFormatStatus >& refNullableStatus = proxy->_dateFormat;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DateFormatCallbackIF*) _callback)->onDateFormatStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DateFormatCallbackIF*) _callback)->onDateFormatStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::DateFormatError);
                                setActAndLogError(message, "DateFormat", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DateFormatCallbackIF*) _callback)->onDateFormatError(proxy, ::boost::static_pointer_cast<DateFormatError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ClockSourceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::ClockSourceStatusStatus);
                                setActAndLogStatus(message, "ClockSourceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ClockSourceStatusStatus> payload = ::boost::static_pointer_cast<ClockSourceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ClockSourceStatusStatus >& refNullableStatus = proxy->_clockSourceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ClockSourceStatusCallbackIF*) _callback)->onClockSourceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ClockSourceStatusCallbackIF*) _callback)->onClockSourceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::ClockSourceStatusError);
                                setActAndLogError(message, "ClockSourceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ClockSourceStatusCallbackIF*) _callback)->onClockSourceStatusError(proxy, ::boost::static_pointer_cast<ClockSourceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FormatSourceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::FormatSourceStatusStatus);
                                setActAndLogStatus(message, "FormatSourceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FormatSourceStatusStatus> payload = ::boost::static_pointer_cast<FormatSourceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FormatSourceStatusStatus >& refNullableStatus = proxy->_formatSourceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FormatSourceStatusCallbackIF*) _callback)->onFormatSourceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FormatSourceStatusCallbackIF*) _callback)->onFormatSourceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::FormatSourceStatusError);
                                setActAndLogError(message, "FormatSourceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FormatSourceStatusCallbackIF*) _callback)->onFormatSourceStatusError(proxy, ::boost::static_pointer_cast<FormatSourceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_LocalTimeDate_MinuteUpdate: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::LocalTimeDate_MinuteUpdateStatus);
                                setActAndLogStatus(message, "LocalTimeDate_MinuteUpdate", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<LocalTimeDate_MinuteUpdateStatus> payload = ::boost::static_pointer_cast<LocalTimeDate_MinuteUpdateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< LocalTimeDate_MinuteUpdateStatus >& refNullableStatus = proxy->_localTimeDate_MinuteUpdate;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((LocalTimeDate_MinuteUpdateCallbackIF*) _callback)->onLocalTimeDate_MinuteUpdateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((LocalTimeDate_MinuteUpdateCallbackIF*) _callback)->onLocalTimeDate_MinuteUpdateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::LocalTimeDate_MinuteUpdateError);
                                setActAndLogError(message, "LocalTimeDate_MinuteUpdate", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((LocalTimeDate_MinuteUpdateCallbackIF*) _callback)->onLocalTimeDate_MinuteUpdateError(proxy, ::boost::static_pointer_cast<LocalTimeDate_MinuteUpdateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Region_TimeZone: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::Region_TimeZoneStatus);
                                setActAndLogStatus(message, "Region_TimeZone", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Region_TimeZoneStatus> payload = ::boost::static_pointer_cast<Region_TimeZoneStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Region_TimeZoneStatus >& refNullableStatus = proxy->_region_TimeZone;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Region_TimeZoneCallbackIF*) _callback)->onRegion_TimeZoneStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((Region_TimeZoneCallbackIF*) _callback)->onRegion_TimeZoneStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::Region_TimeZoneError);
                                setActAndLogError(message, "Region_TimeZone", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((Region_TimeZoneCallbackIF*) _callback)->onRegion_TimeZoneError(proxy, ::boost::static_pointer_cast<Region_TimeZoneError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Auto_TimeZoneOffset: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::Auto_TimeZoneOffsetStatus);
                                setActAndLogStatus(message, "Auto_TimeZoneOffset", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Auto_TimeZoneOffsetStatus> payload = ::boost::static_pointer_cast<Auto_TimeZoneOffsetStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Auto_TimeZoneOffsetStatus >& refNullableStatus = proxy->_auto_TimeZoneOffset;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Auto_TimeZoneOffsetCallbackIF*) _callback)->onAuto_TimeZoneOffsetStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((Auto_TimeZoneOffsetCallbackIF*) _callback)->onAuto_TimeZoneOffsetStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::Auto_TimeZoneOffsetError);
                                setActAndLogError(message, "Auto_TimeZoneOffset", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((Auto_TimeZoneOffsetCallbackIF*) _callback)->onAuto_TimeZoneOffsetError(proxy, ::boost::static_pointer_cast<Auto_TimeZoneOffsetError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_NewDateFormat: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::NewDateFormatStatus);
                                setActAndLogStatus(message, "NewDateFormat", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<NewDateFormatStatus> payload = ::boost::static_pointer_cast<NewDateFormatStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< NewDateFormatStatus >& refNullableStatus = proxy->_newDateFormat;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((NewDateFormatCallbackIF*) _callback)->onNewDateFormatStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((NewDateFormatCallbackIF*) _callback)->onNewDateFormatStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::NewDateFormatError);
                                setActAndLogError(message, "NewDateFormat", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((NewDateFormatCallbackIF*) _callback)->onNewDateFormatError(proxy, ::boost::static_pointer_cast<NewDateFormatError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Connection: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::ConnectionStatus);
                                setActAndLogStatus(message, "Connection", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ConnectionStatus> payload = ::boost::static_pointer_cast<ConnectionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ConnectionStatus >& refNullableStatus = proxy->_connection;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ConnectionCallbackIF*) _callback)->onConnectionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ConnectionCallbackIF*) _callback)->onConnectionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::ConnectionError);
                                setActAndLogError(message, "Connection", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ConnectionCallbackIF*) _callback)->onConnectionError(proxy, ::boost::static_pointer_cast<ConnectionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TimeZone_DSTAvailability: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::TimeZone_DSTAvailabilityStatus);
                                setActAndLogStatus(message, "TimeZone_DSTAvailability", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TimeZone_DSTAvailabilityStatus> payload = ::boost::static_pointer_cast<TimeZone_DSTAvailabilityStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TimeZone_DSTAvailabilityStatus >& refNullableStatus = proxy->_timeZone_DSTAvailability;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TimeZone_DSTAvailabilityCallbackIF*) _callback)->onTimeZone_DSTAvailabilityStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TimeZone_DSTAvailabilityCallbackIF*) _callback)->onTimeZone_DSTAvailabilityStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::TimeZone_DSTAvailabilityError);
                                setActAndLogError(message, "TimeZone_DSTAvailability", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TimeZone_DSTAvailabilityCallbackIF*) _callback)->onTimeZone_DSTAvailabilityError(proxy, ::boost::static_pointer_cast<TimeZone_DSTAvailabilityError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_HardwareVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::HardwareVersionStatus);
                                setActAndLogStatus(message, "HardwareVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<HardwareVersionStatus> payload = ::boost::static_pointer_cast<HardwareVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< HardwareVersionStatus >& refNullableStatus = proxy->_hardwareVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((HardwareVersionCallbackIF*) _callback)->onHardwareVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((HardwareVersionCallbackIF*) _callback)->onHardwareVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::HardwareVersionError);
                                setActAndLogError(message, "HardwareVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((HardwareVersionCallbackIF*) _callback)->onHardwareVersionError(proxy, ::boost::static_pointer_cast<HardwareVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SoftwareVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::SoftwareVersionStatus);
                                setActAndLogStatus(message, "SoftwareVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SoftwareVersionStatus> payload = ::boost::static_pointer_cast<SoftwareVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SoftwareVersionStatus >& refNullableStatus = proxy->_softwareVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SoftwareVersionCallbackIF*) _callback)->onSoftwareVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SoftwareVersionCallbackIF*) _callback)->onSoftwareVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::SoftwareVersionError);
                                setActAndLogError(message, "SoftwareVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SoftwareVersionCallbackIF*) _callback)->onSoftwareVersionError(proxy, ::boost::static_pointer_cast<SoftwareVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DebugMode_TimeDate: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::DebugMode_TimeDateStatus);
                                setActAndLogStatus(message, "DebugMode_TimeDate", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DebugMode_TimeDateStatus> payload = ::boost::static_pointer_cast<DebugMode_TimeDateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DebugMode_TimeDateStatus >& refNullableStatus = proxy->_debugMode_TimeDate;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DebugMode_TimeDateCallbackIF*) _callback)->onDebugMode_TimeDateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DebugMode_TimeDateCallbackIF*) _callback)->onDebugMode_TimeDateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::DebugMode_TimeDateError);
                                setActAndLogError(message, "DebugMode_TimeDate", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DebugMode_TimeDateCallbackIF*) _callback)->onDebugMode_TimeDateError(proxy, ::boost::static_pointer_cast<DebugMode_TimeDateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UTC_TimeDateUpdate: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::UTC_TimeDateUpdateStatus);
                                setActAndLogStatus(message, "UTC_TimeDateUpdate", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<UTC_TimeDateUpdateStatus> payload = ::boost::static_pointer_cast<UTC_TimeDateUpdateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< UTC_TimeDateUpdateStatus >& refNullableStatus = proxy->_uTC_TimeDateUpdate;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((UTC_TimeDateUpdateCallbackIF*) _callback)->onUTC_TimeDateUpdateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((UTC_TimeDateUpdateCallbackIF*) _callback)->onUTC_TimeDateUpdateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::UTC_TimeDateUpdateError);
                                setActAndLogError(message, "UTC_TimeDateUpdate", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((UTC_TimeDateUpdateCallbackIF*) _callback)->onUTC_TimeDateUpdateError(proxy, ::boost::static_pointer_cast<UTC_TimeDateUpdateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_HUD_Activation: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::HUD_ActivationStatus);
                                setActAndLogStatus(message, "HUD_Activation", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<HUD_ActivationStatus> payload = ::boost::static_pointer_cast<HUD_ActivationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< HUD_ActivationStatus >& refNullableStatus = proxy->_hUD_Activation;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((HUD_ActivationCallbackIF*) _callback)->onHUD_ActivationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((HUD_ActivationCallbackIF*) _callback)->onHUD_ActivationStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::HUD_ActivationError);
                                setActAndLogError(message, "HUD_Activation", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((HUD_ActivationCallbackIF*) _callback)->onHUD_ActivationError(proxy, ::boost::static_pointer_cast<HUD_ActivationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_HUD_Postition: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::HUD_PostitionStatus);
                                setActAndLogStatus(message, "HUD_Postition", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<HUD_PostitionStatus> payload = ::boost::static_pointer_cast<HUD_PostitionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< HUD_PostitionStatus >& refNullableStatus = proxy->_hUD_Postition;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((HUD_PostitionCallbackIF*) _callback)->onHUD_PostitionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((HUD_PostitionCallbackIF*) _callback)->onHUD_PostitionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::clock_main_fi::HUD_PostitionError);
                                setActAndLogError(message, "HUD_Postition", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((HUD_PostitionCallbackIF*) _callback)->onHUD_PostitionError(proxy, ::boost::static_pointer_cast<HUD_PostitionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Clock_main_fiProxy> proxy = ::boost::static_pointer_cast<Clock_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_GetAvailableTimeZones: {
                ::boost::shared_ptr< GetAvailableTimeZonesError > payload (new GetAvailableTimeZonesError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAvailableTimeZones", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetAvailableTimeZonesCallbackIF*) _callback)->onGetAvailableTimeZonesError (proxy, payload);
                return true;
            }
            case FID_GetTimeDateFromValue: {
                ::boost::shared_ptr< GetTimeDateFromValueError > payload (new GetTimeDateFromValueError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTimeDateFromValue", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetTimeDateFromValueCallbackIF*) _callback)->onGetTimeDateFromValueError (proxy, payload);
                return true;
            }
            case FID_GetDaysPerMonth: {
                ::boost::shared_ptr< GetDaysPerMonthError > payload (new GetDaysPerMonthError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDaysPerMonth", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetDaysPerMonthCallbackIF*) _callback)->onGetDaysPerMonthError (proxy, payload);
                return true;
            }
            case FID_FID_S_DIAG_CONFIGURATION: {
                ::boost::shared_ptr< FID_S_DIAG_CONFIGURATIONError > payload (new FID_S_DIAG_CONFIGURATIONError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_S_DIAG_CONFIGURATION", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((FID_S_DIAG_CONFIGURATIONCallbackIF*) _callback)->onFID_S_DIAG_CONFIGURATIONError (proxy, payload);
                return true;
            }
            case FID_ResetHistory: {
                ::boost::shared_ptr< ResetHistoryError > payload (new ResetHistoryError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetHistory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ResetHistoryCallbackIF*) _callback)->onResetHistoryError (proxy, payload);
                return true;
            }
            case FID_VersionInfo: {
                ::boost::shared_ptr< VersionInfoError > payload (new VersionInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VersionInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((VersionInfoCallbackIF*) _callback)->onVersionInfoError (proxy, payload);
                return true;
            }
            case FID_TimeZone: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< TimeZoneError > payload (new TimeZoneError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TimeZone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TimeZoneCallbackIF*) _callback)->onTimeZoneError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DaylightSavingTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DaylightSavingTimeError > payload (new DaylightSavingTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DaylightSavingTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DaylightSavingTimeCallbackIF*) _callback)->onDaylightSavingTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GPS_AutoSync: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< GPS_AutoSyncError > payload (new GPS_AutoSyncError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GPS_AutoSync", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GPS_AutoSyncCallbackIF*) _callback)->onGPS_AutoSyncError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SyncMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SyncModeError > payload (new SyncModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SyncMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SyncModeCallbackIF*) _callback)->onSyncModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GPS_WeekEpoch: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< GPS_WeekEpochError > payload (new GPS_WeekEpochError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GPS_WeekEpoch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GPS_WeekEpochCallbackIF*) _callback)->onGPS_WeekEpochError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_LocalTimeOffset: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< LocalTimeOffsetError > payload (new LocalTimeOffsetError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LocalTimeOffset", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((LocalTimeOffsetCallbackIF*) _callback)->onLocalTimeOffsetError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_LocalTimeDate: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< LocalTimeDateError > payload (new LocalTimeDateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LocalTimeDate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((LocalTimeDateCallbackIF*) _callback)->onLocalTimeDateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TimeFormat: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< TimeFormatError > payload (new TimeFormatError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TimeFormat", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TimeFormatCallbackIF*) _callback)->onTimeFormatError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DateFormat: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DateFormatError > payload (new DateFormatError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DateFormat", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DateFormatCallbackIF*) _callback)->onDateFormatError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ClockSourceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ClockSourceStatusError > payload (new ClockSourceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClockSourceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ClockSourceStatusCallbackIF*) _callback)->onClockSourceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FormatSourceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< FormatSourceStatusError > payload (new FormatSourceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FormatSourceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FormatSourceStatusCallbackIF*) _callback)->onFormatSourceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_LocalTimeDate_MinuteUpdate: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< LocalTimeDate_MinuteUpdateError > payload (new LocalTimeDate_MinuteUpdateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LocalTimeDate_MinuteUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((LocalTimeDate_MinuteUpdateCallbackIF*) _callback)->onLocalTimeDate_MinuteUpdateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Region_TimeZone: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< Region_TimeZoneError > payload (new Region_TimeZoneError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Region_TimeZone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Region_TimeZoneCallbackIF*) _callback)->onRegion_TimeZoneError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Auto_TimeZoneOffset: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< Auto_TimeZoneOffsetError > payload (new Auto_TimeZoneOffsetError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Auto_TimeZoneOffset", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Auto_TimeZoneOffsetCallbackIF*) _callback)->onAuto_TimeZoneOffsetError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_NewDateFormat: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< NewDateFormatError > payload (new NewDateFormatError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "NewDateFormat", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((NewDateFormatCallbackIF*) _callback)->onNewDateFormatError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Connection: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ConnectionError > payload (new ConnectionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Connection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ConnectionCallbackIF*) _callback)->onConnectionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TimeZone_DSTAvailability: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< TimeZone_DSTAvailabilityError > payload (new TimeZone_DSTAvailabilityError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TimeZone_DSTAvailability", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TimeZone_DSTAvailabilityCallbackIF*) _callback)->onTimeZone_DSTAvailabilityError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_HardwareVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< HardwareVersionError > payload (new HardwareVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HardwareVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((HardwareVersionCallbackIF*) _callback)->onHardwareVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SoftwareVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SoftwareVersionError > payload (new SoftwareVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SoftwareVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SoftwareVersionCallbackIF*) _callback)->onSoftwareVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DebugMode_TimeDate: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DebugMode_TimeDateError > payload (new DebugMode_TimeDateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DebugMode_TimeDate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DebugMode_TimeDateCallbackIF*) _callback)->onDebugMode_TimeDateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_UTC_TimeDateUpdate: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< UTC_TimeDateUpdateError > payload (new UTC_TimeDateUpdateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UTC_TimeDateUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((UTC_TimeDateUpdateCallbackIF*) _callback)->onUTC_TimeDateUpdateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_HUD_Activation: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< HUD_ActivationError > payload (new HUD_ActivationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HUD_Activation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((HUD_ActivationCallbackIF*) _callback)->onHUD_ActivationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_HUD_Postition: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< HUD_PostitionError > payload (new HUD_PostitionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HUD_Postition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((HUD_PostitionCallbackIF*) _callback)->onHUD_PostitionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Clock_main_fiProxyCallback::_logger (Clock_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Clock_main_fiProxy > Clock_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Clock_main_fiProxy >  proxyNew(new Clock_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Clock_main_fiProxy > Clock_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Clock_main_fiProxy >  proxyNew(new Clock_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Clock_main_fiProxy > Clock_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Clock_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Clock_main_fiProxy >  proxyNew(new Clock_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Clock_main_fiProxy::Clock_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Clock_main_fiProxy::~Clock_main_fiProxy()
{
    LOG_INFO ("Entering ~Clock_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Clock_main_fiProxy::sendGetAvailableTimeZonesStart(GetAvailableTimeZonesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetAvailableTimeZones);
        ::boost::shared_ptr< GetAvailableTimeZonesStart > payload (new GetAvailableTimeZonesStart());
        CCA_MESSAGE(ccaMessage,header,GetAvailableTimeZonesStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetAvailableTimeZones", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetAvailableTimeZones);
        ::boost::shared_ptr< GetAvailableTimeZonesError > payload (new GetAvailableTimeZonesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetAvailableTimeZonesError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetAvailableTimeZones", &cb);
    }
}

act_t Clock_main_fiProxy::sendGetTimeDateFromValueStart(GetTimeDateFromValueCallbackIF& cb, uint32 u32TimeDateValue, uint8 u8SourceDomain, uint8 u8TargetDomain) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetTimeDateFromValue);
        ::boost::shared_ptr< GetTimeDateFromValueStart > payload (new GetTimeDateFromValueStart());
        payload->setU32TimeDateValue(u32TimeDateValue);
        payload->setU8SourceDomain(u8SourceDomain);
        payload->setU8TargetDomain(u8TargetDomain);
        CCA_MESSAGE(ccaMessage,header,GetTimeDateFromValueStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetTimeDateFromValue", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetTimeDateFromValue);
        ::boost::shared_ptr< GetTimeDateFromValueError > payload (new GetTimeDateFromValueError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetTimeDateFromValueError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetTimeDateFromValue", &cb);
    }
}

act_t Clock_main_fiProxy::sendGetDaysPerMonthStart(GetDaysPerMonthCallbackIF& cb, int16 s16Year, uint8 u8Month) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetDaysPerMonth);
        ::boost::shared_ptr< GetDaysPerMonthStart > payload (new GetDaysPerMonthStart());
        payload->setS16Year(s16Year);
        payload->setU8Month(u8Month);
        CCA_MESSAGE(ccaMessage,header,GetDaysPerMonthStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetDaysPerMonth", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetDaysPerMonth);
        ::boost::shared_ptr< GetDaysPerMonthError > payload (new GetDaysPerMonthError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetDaysPerMonthError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetDaysPerMonth", &cb);
    }
}

act_t Clock_main_fiProxy::sendFID_S_DIAG_CONFIGURATIONStart(FID_S_DIAG_CONFIGURATIONCallbackIF& cb, ::diagnostics_main_fi_types::T_e8_DefSetGroups defSetStateGroup, ::diagnostics_main_fi_types::T_e8_DefSetMode defSetStateMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_FID_S_DIAG_CONFIGURATION);
        ::boost::shared_ptr< FID_S_DIAG_CONFIGURATIONStart > payload (new FID_S_DIAG_CONFIGURATIONStart());
        payload->setDefSetStateGroup(defSetStateGroup);
        payload->setDefSetStateMode(defSetStateMode);
        CCA_MESSAGE(ccaMessage,header,FID_S_DIAG_CONFIGURATIONStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "FID_S_DIAG_CONFIGURATION", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FID_S_DIAG_CONFIGURATION);
        ::boost::shared_ptr< FID_S_DIAG_CONFIGURATIONError > payload (new FID_S_DIAG_CONFIGURATIONError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FID_S_DIAG_CONFIGURATIONError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "FID_S_DIAG_CONFIGURATION", &cb);
    }
}

act_t Clock_main_fiProxy::sendResetHistoryStart(ResetHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryStart > payload (new ResetHistoryStart());
        CCA_MESSAGE(ccaMessage,header,ResetHistoryStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ResetHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryError > payload (new ResetHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ResetHistory", &cb);
    }
}

act_t Clock_main_fiProxy::sendVersionInfoStart(VersionInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_VersionInfo);
        ::boost::shared_ptr< VersionInfoStart > payload (new VersionInfoStart());
        CCA_MESSAGE(ccaMessage,header,VersionInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "VersionInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VersionInfo);
        ::boost::shared_ptr< VersionInfoError > payload (new VersionInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VersionInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "VersionInfo", &cb);
    }
}

act_t Clock_main_fiProxy::sendTimeZoneUpReg(TimeZoneCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TimeZone);
        ::boost::shared_ptr< TimeZoneUpReg > payload (new TimeZoneUpReg());
        CCA_MESSAGE(ccaMessage,header,TimeZoneUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TimeZoneRelUpReg > payloadRelUpRegHeap (new TimeZoneRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TimeZone, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::TimeZoneRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TimeZone, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TimeZone", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TimeZone", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTimeZone()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TimeZone, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TimeZoneStatus > payloadLoopback (new TimeZoneStatus(getTimeZone()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TimeZoneStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TimeZone);
        ::boost::shared_ptr< TimeZoneError > payload (new TimeZoneError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TimeZoneError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TimeZone", &cb);
    }
}

bool Clock_main_fiProxy::sendTimeZoneRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TimeZone,"TimeZone");
}

void Clock_main_fiProxy::sendTimeZoneRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TimeZone);
}

const TimeZoneStatus& Clock_main_fiProxy::getTimeZone() const {
    return _timeZone.get();
}

bool Clock_main_fiProxy::hasTimeZone() const {
    return _timeZone.hasValue();
}

act_t Clock_main_fiProxy::sendTimeZoneGet(TimeZoneCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TimeZone);
        ::boost::shared_ptr< TimeZoneGet > payload (new TimeZoneGet());
        CCA_MESSAGE(ccaMessage,header,TimeZoneGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TimeZone", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TimeZone);
        ::boost::shared_ptr< TimeZoneError > payload (new TimeZoneError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TimeZoneError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TimeZone", &cb);
    }
}

act_t Clock_main_fiProxy::sendTimeZoneSet(TimeZoneCallbackIF& cb, uint16 u16Index) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_TimeZone);
        ::boost::shared_ptr< TimeZoneSet > payload (new TimeZoneSet());
        payload->setU16Index(u16Index);
        CCA_MESSAGE(ccaMessage,header,TimeZoneSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "TimeZone", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TimeZone);
        ::boost::shared_ptr< TimeZoneError > payload (new TimeZoneError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TimeZoneError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "TimeZone", &cb);
    }
}

act_t Clock_main_fiProxy::sendDaylightSavingTimeUpReg(DaylightSavingTimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DaylightSavingTime);
        ::boost::shared_ptr< DaylightSavingTimeUpReg > payload (new DaylightSavingTimeUpReg());
        CCA_MESSAGE(ccaMessage,header,DaylightSavingTimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DaylightSavingTimeRelUpReg > payloadRelUpRegHeap (new DaylightSavingTimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DaylightSavingTime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::DaylightSavingTimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DaylightSavingTime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DaylightSavingTime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DaylightSavingTime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDaylightSavingTime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DaylightSavingTime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DaylightSavingTimeStatus > payloadLoopback (new DaylightSavingTimeStatus(getDaylightSavingTime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DaylightSavingTimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DaylightSavingTime);
        ::boost::shared_ptr< DaylightSavingTimeError > payload (new DaylightSavingTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DaylightSavingTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DaylightSavingTime", &cb);
    }
}

bool Clock_main_fiProxy::sendDaylightSavingTimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DaylightSavingTime,"DaylightSavingTime");
}

void Clock_main_fiProxy::sendDaylightSavingTimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DaylightSavingTime);
}

const DaylightSavingTimeStatus& Clock_main_fiProxy::getDaylightSavingTime() const {
    return _daylightSavingTime.get();
}

bool Clock_main_fiProxy::hasDaylightSavingTime() const {
    return _daylightSavingTime.hasValue();
}

act_t Clock_main_fiProxy::sendDaylightSavingTimeGet(DaylightSavingTimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DaylightSavingTime);
        ::boost::shared_ptr< DaylightSavingTimeGet > payload (new DaylightSavingTimeGet());
        CCA_MESSAGE(ccaMessage,header,DaylightSavingTimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DaylightSavingTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DaylightSavingTime);
        ::boost::shared_ptr< DaylightSavingTimeError > payload (new DaylightSavingTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DaylightSavingTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DaylightSavingTime", &cb);
    }
}

act_t Clock_main_fiProxy::sendDaylightSavingTimeSet(DaylightSavingTimeCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Setting) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DaylightSavingTime);
        ::boost::shared_ptr< DaylightSavingTimeSet > payload (new DaylightSavingTimeSet());
        payload->setEnDST_Setting(enDST_Setting);
        CCA_MESSAGE(ccaMessage,header,DaylightSavingTimeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DaylightSavingTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DaylightSavingTime);
        ::boost::shared_ptr< DaylightSavingTimeError > payload (new DaylightSavingTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DaylightSavingTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DaylightSavingTime", &cb);
    }
}

act_t Clock_main_fiProxy::sendGPS_AutoSyncUpReg(GPS_AutoSyncCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GPS_AutoSync);
        ::boost::shared_ptr< GPS_AutoSyncUpReg > payload (new GPS_AutoSyncUpReg());
        CCA_MESSAGE(ccaMessage,header,GPS_AutoSyncUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GPS_AutoSyncRelUpReg > payloadRelUpRegHeap (new GPS_AutoSyncRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GPS_AutoSync, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::GPS_AutoSyncRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GPS_AutoSync, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GPS_AutoSync", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GPS_AutoSync", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGPS_AutoSync()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GPS_AutoSync, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GPS_AutoSyncStatus > payloadLoopback (new GPS_AutoSyncStatus(getGPS_AutoSync()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GPS_AutoSyncStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GPS_AutoSync);
        ::boost::shared_ptr< GPS_AutoSyncError > payload (new GPS_AutoSyncError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GPS_AutoSyncError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GPS_AutoSync", &cb);
    }
}

bool Clock_main_fiProxy::sendGPS_AutoSyncRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GPS_AutoSync,"GPS_AutoSync");
}

void Clock_main_fiProxy::sendGPS_AutoSyncRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GPS_AutoSync);
}

const GPS_AutoSyncStatus& Clock_main_fiProxy::getGPS_AutoSync() const {
    return _gPS_AutoSync.get();
}

bool Clock_main_fiProxy::hasGPS_AutoSync() const {
    return _gPS_AutoSync.hasValue();
}

act_t Clock_main_fiProxy::sendGPS_AutoSyncGet(GPS_AutoSyncCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_GPS_AutoSync);
        ::boost::shared_ptr< GPS_AutoSyncGet > payload (new GPS_AutoSyncGet());
        CCA_MESSAGE(ccaMessage,header,GPS_AutoSyncGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "GPS_AutoSync", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GPS_AutoSync);
        ::boost::shared_ptr< GPS_AutoSyncError > payload (new GPS_AutoSyncError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GPS_AutoSyncError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "GPS_AutoSync", &cb);
    }
}

act_t Clock_main_fiProxy::sendGPS_AutoSyncSet(GPS_AutoSyncCallbackIF& cb, bool bEnabled, bool bPositionBased) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_GPS_AutoSync);
        ::boost::shared_ptr< GPS_AutoSyncSet > payload (new GPS_AutoSyncSet());
        payload->setBEnabled(bEnabled);
        payload->setBPositionBased(bPositionBased);
        CCA_MESSAGE(ccaMessage,header,GPS_AutoSyncSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "GPS_AutoSync", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GPS_AutoSync);
        ::boost::shared_ptr< GPS_AutoSyncError > payload (new GPS_AutoSyncError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GPS_AutoSyncError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "GPS_AutoSync", &cb);
    }
}

act_t Clock_main_fiProxy::sendSyncModeUpReg(SyncModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SyncMode);
        ::boost::shared_ptr< SyncModeUpReg > payload (new SyncModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SyncModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SyncModeRelUpReg > payloadRelUpRegHeap (new SyncModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SyncMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::SyncModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SyncMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SyncMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SyncMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSyncMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SyncMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SyncModeStatus > payloadLoopback (new SyncModeStatus(getSyncMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SyncModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SyncMode);
        ::boost::shared_ptr< SyncModeError > payload (new SyncModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SyncModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SyncMode", &cb);
    }
}

bool Clock_main_fiProxy::sendSyncModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SyncMode,"SyncMode");
}

void Clock_main_fiProxy::sendSyncModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SyncMode);
}

const SyncModeStatus& Clock_main_fiProxy::getSyncMode() const {
    return _syncMode.get();
}

bool Clock_main_fiProxy::hasSyncMode() const {
    return _syncMode.hasValue();
}

act_t Clock_main_fiProxy::sendSyncModeGet(SyncModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SyncMode);
        ::boost::shared_ptr< SyncModeGet > payload (new SyncModeGet());
        CCA_MESSAGE(ccaMessage,header,SyncModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SyncMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SyncMode);
        ::boost::shared_ptr< SyncModeError > payload (new SyncModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SyncModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SyncMode", &cb);
    }
}

act_t Clock_main_fiProxy::sendSyncModeSet(SyncModeCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_SyncMode enMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SyncMode);
        ::boost::shared_ptr< SyncModeSet > payload (new SyncModeSet());
        payload->setEnMode(enMode);
        CCA_MESSAGE(ccaMessage,header,SyncModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SyncMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SyncMode);
        ::boost::shared_ptr< SyncModeError > payload (new SyncModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SyncModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SyncMode", &cb);
    }
}

act_t Clock_main_fiProxy::sendGPS_WeekEpochUpReg(GPS_WeekEpochCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GPS_WeekEpoch);
        ::boost::shared_ptr< GPS_WeekEpochUpReg > payload (new GPS_WeekEpochUpReg());
        CCA_MESSAGE(ccaMessage,header,GPS_WeekEpochUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GPS_WeekEpochRelUpReg > payloadRelUpRegHeap (new GPS_WeekEpochRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GPS_WeekEpoch, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::GPS_WeekEpochRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GPS_WeekEpoch, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GPS_WeekEpoch", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GPS_WeekEpoch", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGPS_WeekEpoch()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GPS_WeekEpoch, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GPS_WeekEpochStatus > payloadLoopback (new GPS_WeekEpochStatus(getGPS_WeekEpoch()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GPS_WeekEpochStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GPS_WeekEpoch);
        ::boost::shared_ptr< GPS_WeekEpochError > payload (new GPS_WeekEpochError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GPS_WeekEpochError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GPS_WeekEpoch", &cb);
    }
}

bool Clock_main_fiProxy::sendGPS_WeekEpochRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GPS_WeekEpoch,"GPS_WeekEpoch");
}

void Clock_main_fiProxy::sendGPS_WeekEpochRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GPS_WeekEpoch);
}

const GPS_WeekEpochStatus& Clock_main_fiProxy::getGPS_WeekEpoch() const {
    return _gPS_WeekEpoch.get();
}

bool Clock_main_fiProxy::hasGPS_WeekEpoch() const {
    return _gPS_WeekEpoch.hasValue();
}

act_t Clock_main_fiProxy::sendGPS_WeekEpochGet(GPS_WeekEpochCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_GPS_WeekEpoch);
        ::boost::shared_ptr< GPS_WeekEpochGet > payload (new GPS_WeekEpochGet());
        CCA_MESSAGE(ccaMessage,header,GPS_WeekEpochGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "GPS_WeekEpoch", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GPS_WeekEpoch);
        ::boost::shared_ptr< GPS_WeekEpochError > payload (new GPS_WeekEpochError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GPS_WeekEpochError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "GPS_WeekEpoch", &cb);
    }
}

act_t Clock_main_fiProxy::sendGPS_WeekEpochSet(GPS_WeekEpochCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH gPSepoch) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_GPS_WeekEpoch);
        ::boost::shared_ptr< GPS_WeekEpochSet > payload (new GPS_WeekEpochSet());
        payload->setGPSepoch(gPSepoch);
        CCA_MESSAGE(ccaMessage,header,GPS_WeekEpochSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "GPS_WeekEpoch", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GPS_WeekEpoch);
        ::boost::shared_ptr< GPS_WeekEpochError > payload (new GPS_WeekEpochError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GPS_WeekEpochError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "GPS_WeekEpoch", &cb);
    }
}

act_t Clock_main_fiProxy::sendLocalTimeOffsetUpReg(LocalTimeOffsetCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_LocalTimeOffset);
        ::boost::shared_ptr< LocalTimeOffsetUpReg > payload (new LocalTimeOffsetUpReg());
        CCA_MESSAGE(ccaMessage,header,LocalTimeOffsetUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< LocalTimeOffsetRelUpReg > payloadRelUpRegHeap (new LocalTimeOffsetRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_LocalTimeOffset, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::LocalTimeOffsetRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_LocalTimeOffset, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "LocalTimeOffset", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "LocalTimeOffset", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasLocalTimeOffset()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_LocalTimeOffset, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< LocalTimeOffsetStatus > payloadLoopback (new LocalTimeOffsetStatus(getLocalTimeOffset()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,LocalTimeOffsetStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeOffset);
        ::boost::shared_ptr< LocalTimeOffsetError > payload (new LocalTimeOffsetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeOffsetError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "LocalTimeOffset", &cb);
    }
}

bool Clock_main_fiProxy::sendLocalTimeOffsetRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_LocalTimeOffset,"LocalTimeOffset");
}

void Clock_main_fiProxy::sendLocalTimeOffsetRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_LocalTimeOffset);
}

const LocalTimeOffsetStatus& Clock_main_fiProxy::getLocalTimeOffset() const {
    return _localTimeOffset.get();
}

bool Clock_main_fiProxy::hasLocalTimeOffset() const {
    return _localTimeOffset.hasValue();
}

act_t Clock_main_fiProxy::sendLocalTimeOffsetGet(LocalTimeOffsetCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_LocalTimeOffset);
        ::boost::shared_ptr< LocalTimeOffsetGet > payload (new LocalTimeOffsetGet());
        CCA_MESSAGE(ccaMessage,header,LocalTimeOffsetGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "LocalTimeOffset", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeOffset);
        ::boost::shared_ptr< LocalTimeOffsetError > payload (new LocalTimeOffsetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeOffsetError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "LocalTimeOffset", &cb);
    }
}

act_t Clock_main_fiProxy::sendLocalTimeOffsetSet(LocalTimeOffsetCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_LocalTimeOffset);
        ::boost::shared_ptr< LocalTimeOffsetSet > payload (new LocalTimeOffsetSet());
        CCA_MESSAGE(ccaMessage,header,LocalTimeOffsetSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "LocalTimeOffset", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeOffset);
        ::boost::shared_ptr< LocalTimeOffsetError > payload (new LocalTimeOffsetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeOffsetError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "LocalTimeOffset", &cb);
    }
}

act_t Clock_main_fiProxy::sendLocalTimeDateUpReg(LocalTimeDateCallbackIF& cb, uint8 u8UpdatePeriod) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_LocalTimeDate);
        ::boost::shared_ptr< LocalTimeDateUpReg > payload (new LocalTimeDateUpReg());
        payload->setU8UpdatePeriod(u8UpdatePeriod);
        CCA_MESSAGE(ccaMessage,header,LocalTimeDateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< LocalTimeDateRelUpReg > payloadRelUpRegHeap (new LocalTimeDateRelUpReg());
        payloadRelUpRegHeap->setU8UpdatePeriod(u8UpdatePeriod);
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_LocalTimeDate, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::LocalTimeDateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_LocalTimeDate, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "LocalTimeDate", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "LocalTimeDate", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasLocalTimeDate(u8UpdatePeriod)) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_LocalTimeDate, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< LocalTimeDateStatus > payloadLoopback (new LocalTimeDateStatus(getLocalTimeDate(u8UpdatePeriod)));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,LocalTimeDateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeDate);
        ::boost::shared_ptr< LocalTimeDateError > payload (new LocalTimeDateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeDateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "LocalTimeDate", &cb);
    }
}

bool Clock_main_fiProxy::sendLocalTimeDateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_LocalTimeDate,"LocalTimeDate");
}

void Clock_main_fiProxy::sendLocalTimeDateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_LocalTimeDate);
}

const LocalTimeDateStatus& Clock_main_fiProxy::getLocalTimeDate(uint8 u8UpdatePeriod) const {
    LocalTimeDateRelUpReg payload(u8UpdatePeriod);
    LocalTimeDateMap::const_iterator it = _localTimeDateMap.find(payload);
    if (it != _localTimeDateMap.end()) {
        return it->second;
    } else {
        std::string s;
        serializeJson (payload,s);
        LOG_FATAL("get%s(): No status object available which belongs to the passed parameter: %s", "LocalTimeDate", s.c_str());
    }
}

bool Clock_main_fiProxy::hasLocalTimeDate(uint8 u8UpdatePeriod) const {
    LocalTimeDateMap::const_iterator it = _localTimeDateMap.find(LocalTimeDateRelUpReg(u8UpdatePeriod));
    return ( it != _localTimeDateMap.end() );
}

act_t Clock_main_fiProxy::sendLocalTimeDateGet(LocalTimeDateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_LocalTimeDate);
        ::boost::shared_ptr< LocalTimeDateGet > payload (new LocalTimeDateGet());
        CCA_MESSAGE(ccaMessage,header,LocalTimeDateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "LocalTimeDate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeDate);
        ::boost::shared_ptr< LocalTimeDateError > payload (new LocalTimeDateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeDateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "LocalTimeDate", &cb);
    }
}

act_t Clock_main_fiProxy::sendLocalTimeDateSet(LocalTimeDateCallbackIF& cb, int16 s16Year, uint8 u8Month, uint8 u8Day, uint8 u8Hours, uint8 u8Minutes, uint8 u8Seconds, uint8 u8Weekday, uint8 u8ChangeMask) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_LocalTimeDate);
        ::boost::shared_ptr< LocalTimeDateSet > payload (new LocalTimeDateSet());
        payload->setS16Year(s16Year);
        payload->setU8Month(u8Month);
        payload->setU8Day(u8Day);
        payload->setU8Hours(u8Hours);
        payload->setU8Minutes(u8Minutes);
        payload->setU8Seconds(u8Seconds);
        payload->setU8Weekday(u8Weekday);
        payload->setU8ChangeMask(u8ChangeMask);
        CCA_MESSAGE(ccaMessage,header,LocalTimeDateSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "LocalTimeDate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeDate);
        ::boost::shared_ptr< LocalTimeDateError > payload (new LocalTimeDateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeDateError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "LocalTimeDate", &cb);
    }
}

act_t Clock_main_fiProxy::sendTimeFormatUpReg(TimeFormatCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TimeFormat);
        ::boost::shared_ptr< TimeFormatUpReg > payload (new TimeFormatUpReg());
        CCA_MESSAGE(ccaMessage,header,TimeFormatUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TimeFormatRelUpReg > payloadRelUpRegHeap (new TimeFormatRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TimeFormat, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::TimeFormatRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TimeFormat, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TimeFormat", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TimeFormat", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTimeFormat()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TimeFormat, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TimeFormatStatus > payloadLoopback (new TimeFormatStatus(getTimeFormat()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TimeFormatStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TimeFormat);
        ::boost::shared_ptr< TimeFormatError > payload (new TimeFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TimeFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TimeFormat", &cb);
    }
}

bool Clock_main_fiProxy::sendTimeFormatRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TimeFormat,"TimeFormat");
}

void Clock_main_fiProxy::sendTimeFormatRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TimeFormat);
}

const TimeFormatStatus& Clock_main_fiProxy::getTimeFormat() const {
    return _timeFormat.get();
}

bool Clock_main_fiProxy::hasTimeFormat() const {
    return _timeFormat.hasValue();
}

act_t Clock_main_fiProxy::sendTimeFormatGet(TimeFormatCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TimeFormat);
        ::boost::shared_ptr< TimeFormatGet > payload (new TimeFormatGet());
        CCA_MESSAGE(ccaMessage,header,TimeFormatGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TimeFormat", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TimeFormat);
        ::boost::shared_ptr< TimeFormatError > payload (new TimeFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TimeFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TimeFormat", &cb);
    }
}

act_t Clock_main_fiProxy::sendTimeFormatSet(TimeFormatCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_TimeFormat);
        ::boost::shared_ptr< TimeFormatSet > payload (new TimeFormatSet());
        payload->setEnTimeFormat(enTimeFormat);
        CCA_MESSAGE(ccaMessage,header,TimeFormatSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "TimeFormat", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TimeFormat);
        ::boost::shared_ptr< TimeFormatError > payload (new TimeFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TimeFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "TimeFormat", &cb);
    }
}

act_t Clock_main_fiProxy::sendDateFormatUpReg(DateFormatCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DateFormat);
        ::boost::shared_ptr< DateFormatUpReg > payload (new DateFormatUpReg());
        CCA_MESSAGE(ccaMessage,header,DateFormatUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DateFormatRelUpReg > payloadRelUpRegHeap (new DateFormatRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DateFormat, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::DateFormatRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DateFormat, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DateFormat", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DateFormat", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDateFormat()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DateFormat, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DateFormatStatus > payloadLoopback (new DateFormatStatus(getDateFormat()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DateFormatStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DateFormat);
        ::boost::shared_ptr< DateFormatError > payload (new DateFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DateFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DateFormat", &cb);
    }
}

bool Clock_main_fiProxy::sendDateFormatRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DateFormat,"DateFormat");
}

void Clock_main_fiProxy::sendDateFormatRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DateFormat);
}

const DateFormatStatus& Clock_main_fiProxy::getDateFormat() const {
    return _dateFormat.get();
}

bool Clock_main_fiProxy::hasDateFormat() const {
    return _dateFormat.hasValue();
}

act_t Clock_main_fiProxy::sendDateFormatGet(DateFormatCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DateFormat);
        ::boost::shared_ptr< DateFormatGet > payload (new DateFormatGet());
        CCA_MESSAGE(ccaMessage,header,DateFormatGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DateFormat", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DateFormat);
        ::boost::shared_ptr< DateFormatError > payload (new DateFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DateFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DateFormat", &cb);
    }
}

act_t Clock_main_fiProxy::sendDateFormatSet(DateFormatCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DateFormat);
        ::boost::shared_ptr< DateFormatSet > payload (new DateFormatSet());
        payload->setEnDateFormat(enDateFormat);
        CCA_MESSAGE(ccaMessage,header,DateFormatSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DateFormat", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DateFormat);
        ::boost::shared_ptr< DateFormatError > payload (new DateFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DateFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DateFormat", &cb);
    }
}

act_t Clock_main_fiProxy::sendClockSourceStatusUpReg(ClockSourceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ClockSourceStatus);
        ::boost::shared_ptr< ClockSourceStatusUpReg > payload (new ClockSourceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,ClockSourceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ClockSourceStatusRelUpReg > payloadRelUpRegHeap (new ClockSourceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ClockSourceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::ClockSourceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ClockSourceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ClockSourceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ClockSourceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasClockSourceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ClockSourceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ClockSourceStatusStatus > payloadLoopback (new ClockSourceStatusStatus(getClockSourceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ClockSourceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClockSourceStatus);
        ::boost::shared_ptr< ClockSourceStatusError > payload (new ClockSourceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClockSourceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ClockSourceStatus", &cb);
    }
}

bool Clock_main_fiProxy::sendClockSourceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ClockSourceStatus,"ClockSourceStatus");
}

void Clock_main_fiProxy::sendClockSourceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ClockSourceStatus);
}

const ClockSourceStatusStatus& Clock_main_fiProxy::getClockSourceStatus() const {
    return _clockSourceStatus.get();
}

bool Clock_main_fiProxy::hasClockSourceStatus() const {
    return _clockSourceStatus.hasValue();
}

act_t Clock_main_fiProxy::sendClockSourceStatusGet(ClockSourceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ClockSourceStatus);
        ::boost::shared_ptr< ClockSourceStatusGet > payload (new ClockSourceStatusGet());
        CCA_MESSAGE(ccaMessage,header,ClockSourceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ClockSourceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClockSourceStatus);
        ::boost::shared_ptr< ClockSourceStatusError > payload (new ClockSourceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClockSourceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ClockSourceStatus", &cb);
    }
}

act_t Clock_main_fiProxy::sendFormatSourceStatusUpReg(FormatSourceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FormatSourceStatus);
        ::boost::shared_ptr< FormatSourceStatusUpReg > payload (new FormatSourceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,FormatSourceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FormatSourceStatusRelUpReg > payloadRelUpRegHeap (new FormatSourceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FormatSourceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::FormatSourceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FormatSourceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FormatSourceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FormatSourceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFormatSourceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FormatSourceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FormatSourceStatusStatus > payloadLoopback (new FormatSourceStatusStatus(getFormatSourceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FormatSourceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FormatSourceStatus);
        ::boost::shared_ptr< FormatSourceStatusError > payload (new FormatSourceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FormatSourceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FormatSourceStatus", &cb);
    }
}

bool Clock_main_fiProxy::sendFormatSourceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FormatSourceStatus,"FormatSourceStatus");
}

void Clock_main_fiProxy::sendFormatSourceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FormatSourceStatus);
}

const FormatSourceStatusStatus& Clock_main_fiProxy::getFormatSourceStatus() const {
    return _formatSourceStatus.get();
}

bool Clock_main_fiProxy::hasFormatSourceStatus() const {
    return _formatSourceStatus.hasValue();
}

act_t Clock_main_fiProxy::sendFormatSourceStatusGet(FormatSourceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_FormatSourceStatus);
        ::boost::shared_ptr< FormatSourceStatusGet > payload (new FormatSourceStatusGet());
        CCA_MESSAGE(ccaMessage,header,FormatSourceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "FormatSourceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FormatSourceStatus);
        ::boost::shared_ptr< FormatSourceStatusError > payload (new FormatSourceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FormatSourceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "FormatSourceStatus", &cb);
    }
}

act_t Clock_main_fiProxy::sendLocalTimeDate_MinuteUpdateUpReg(LocalTimeDate_MinuteUpdateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_LocalTimeDate_MinuteUpdate);
        ::boost::shared_ptr< LocalTimeDate_MinuteUpdateUpReg > payload (new LocalTimeDate_MinuteUpdateUpReg());
        CCA_MESSAGE(ccaMessage,header,LocalTimeDate_MinuteUpdateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< LocalTimeDate_MinuteUpdateRelUpReg > payloadRelUpRegHeap (new LocalTimeDate_MinuteUpdateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_LocalTimeDate_MinuteUpdate, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::LocalTimeDate_MinuteUpdateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_LocalTimeDate_MinuteUpdate, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "LocalTimeDate_MinuteUpdate", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "LocalTimeDate_MinuteUpdate", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasLocalTimeDate_MinuteUpdate()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_LocalTimeDate_MinuteUpdate, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< LocalTimeDate_MinuteUpdateStatus > payloadLoopback (new LocalTimeDate_MinuteUpdateStatus(getLocalTimeDate_MinuteUpdate()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,LocalTimeDate_MinuteUpdateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeDate_MinuteUpdate);
        ::boost::shared_ptr< LocalTimeDate_MinuteUpdateError > payload (new LocalTimeDate_MinuteUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeDate_MinuteUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "LocalTimeDate_MinuteUpdate", &cb);
    }
}

bool Clock_main_fiProxy::sendLocalTimeDate_MinuteUpdateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_LocalTimeDate_MinuteUpdate,"LocalTimeDate_MinuteUpdate");
}

void Clock_main_fiProxy::sendLocalTimeDate_MinuteUpdateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_LocalTimeDate_MinuteUpdate);
}

const LocalTimeDate_MinuteUpdateStatus& Clock_main_fiProxy::getLocalTimeDate_MinuteUpdate() const {
    return _localTimeDate_MinuteUpdate.get();
}

bool Clock_main_fiProxy::hasLocalTimeDate_MinuteUpdate() const {
    return _localTimeDate_MinuteUpdate.hasValue();
}

act_t Clock_main_fiProxy::sendLocalTimeDate_MinuteUpdateGet(LocalTimeDate_MinuteUpdateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_LocalTimeDate_MinuteUpdate);
        ::boost::shared_ptr< LocalTimeDate_MinuteUpdateGet > payload (new LocalTimeDate_MinuteUpdateGet());
        CCA_MESSAGE(ccaMessage,header,LocalTimeDate_MinuteUpdateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "LocalTimeDate_MinuteUpdate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeDate_MinuteUpdate);
        ::boost::shared_ptr< LocalTimeDate_MinuteUpdateError > payload (new LocalTimeDate_MinuteUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeDate_MinuteUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "LocalTimeDate_MinuteUpdate", &cb);
    }
}

act_t Clock_main_fiProxy::sendLocalTimeDate_MinuteUpdateSet(LocalTimeDate_MinuteUpdateCallbackIF& cb, int16 s16Year, uint8 u8Month, uint8 u8Day, uint8 u8Hours, uint8 u8Minutes, uint8 u8Seconds, uint8 u8Weekday, uint8 u8ChangeMask) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_LocalTimeDate_MinuteUpdate);
        ::boost::shared_ptr< LocalTimeDate_MinuteUpdateSet > payload (new LocalTimeDate_MinuteUpdateSet());
        payload->setS16Year(s16Year);
        payload->setU8Month(u8Month);
        payload->setU8Day(u8Day);
        payload->setU8Hours(u8Hours);
        payload->setU8Minutes(u8Minutes);
        payload->setU8Seconds(u8Seconds);
        payload->setU8Weekday(u8Weekday);
        payload->setU8ChangeMask(u8ChangeMask);
        CCA_MESSAGE(ccaMessage,header,LocalTimeDate_MinuteUpdateSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "LocalTimeDate_MinuteUpdate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LocalTimeDate_MinuteUpdate);
        ::boost::shared_ptr< LocalTimeDate_MinuteUpdateError > payload (new LocalTimeDate_MinuteUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LocalTimeDate_MinuteUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "LocalTimeDate_MinuteUpdate", &cb);
    }
}

act_t Clock_main_fiProxy::sendRegion_TimeZoneUpReg(Region_TimeZoneCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Region_TimeZone);
        ::boost::shared_ptr< Region_TimeZoneUpReg > payload (new Region_TimeZoneUpReg());
        CCA_MESSAGE(ccaMessage,header,Region_TimeZoneUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Region_TimeZoneRelUpReg > payloadRelUpRegHeap (new Region_TimeZoneRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Region_TimeZone, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::Region_TimeZoneRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Region_TimeZone, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Region_TimeZone", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Region_TimeZone", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRegion_TimeZone()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Region_TimeZone, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Region_TimeZoneStatus > payloadLoopback (new Region_TimeZoneStatus(getRegion_TimeZone()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Region_TimeZoneStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Region_TimeZone);
        ::boost::shared_ptr< Region_TimeZoneError > payload (new Region_TimeZoneError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Region_TimeZoneError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Region_TimeZone", &cb);
    }
}

bool Clock_main_fiProxy::sendRegion_TimeZoneRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Region_TimeZone,"Region_TimeZone");
}

void Clock_main_fiProxy::sendRegion_TimeZoneRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Region_TimeZone);
}

const Region_TimeZoneStatus& Clock_main_fiProxy::getRegion_TimeZone() const {
    return _region_TimeZone.get();
}

bool Clock_main_fiProxy::hasRegion_TimeZone() const {
    return _region_TimeZone.hasValue();
}

act_t Clock_main_fiProxy::sendRegion_TimeZoneGet(Region_TimeZoneCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Region_TimeZone);
        ::boost::shared_ptr< Region_TimeZoneGet > payload (new Region_TimeZoneGet());
        CCA_MESSAGE(ccaMessage,header,Region_TimeZoneGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Region_TimeZone", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Region_TimeZone);
        ::boost::shared_ptr< Region_TimeZoneError > payload (new Region_TimeZoneError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Region_TimeZoneError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Region_TimeZone", &cb);
    }
}

act_t Clock_main_fiProxy::sendRegion_TimeZoneSet(Region_TimeZoneCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Region_TimeZone);
        ::boost::shared_ptr< Region_TimeZoneSet > payload (new Region_TimeZoneSet());
        payload->setEnTIMEZONE_Settings(enTIMEZONE_Settings);
        CCA_MESSAGE(ccaMessage,header,Region_TimeZoneSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Region_TimeZone", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Region_TimeZone);
        ::boost::shared_ptr< Region_TimeZoneError > payload (new Region_TimeZoneError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Region_TimeZoneError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Region_TimeZone", &cb);
    }
}

act_t Clock_main_fiProxy::sendAuto_TimeZoneOffsetUpReg(Auto_TimeZoneOffsetCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Auto_TimeZoneOffset);
        ::boost::shared_ptr< Auto_TimeZoneOffsetUpReg > payload (new Auto_TimeZoneOffsetUpReg());
        CCA_MESSAGE(ccaMessage,header,Auto_TimeZoneOffsetUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Auto_TimeZoneOffsetRelUpReg > payloadRelUpRegHeap (new Auto_TimeZoneOffsetRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Auto_TimeZoneOffset, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::Auto_TimeZoneOffsetRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Auto_TimeZoneOffset, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Auto_TimeZoneOffset", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Auto_TimeZoneOffset", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAuto_TimeZoneOffset()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Auto_TimeZoneOffset, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Auto_TimeZoneOffsetStatus > payloadLoopback (new Auto_TimeZoneOffsetStatus(getAuto_TimeZoneOffset()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Auto_TimeZoneOffsetStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Auto_TimeZoneOffset);
        ::boost::shared_ptr< Auto_TimeZoneOffsetError > payload (new Auto_TimeZoneOffsetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Auto_TimeZoneOffsetError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Auto_TimeZoneOffset", &cb);
    }
}

bool Clock_main_fiProxy::sendAuto_TimeZoneOffsetRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Auto_TimeZoneOffset,"Auto_TimeZoneOffset");
}

void Clock_main_fiProxy::sendAuto_TimeZoneOffsetRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Auto_TimeZoneOffset);
}

const Auto_TimeZoneOffsetStatus& Clock_main_fiProxy::getAuto_TimeZoneOffset() const {
    return _auto_TimeZoneOffset.get();
}

bool Clock_main_fiProxy::hasAuto_TimeZoneOffset() const {
    return _auto_TimeZoneOffset.hasValue();
}

act_t Clock_main_fiProxy::sendAuto_TimeZoneOffsetGet(Auto_TimeZoneOffsetCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Auto_TimeZoneOffset);
        ::boost::shared_ptr< Auto_TimeZoneOffsetGet > payload (new Auto_TimeZoneOffsetGet());
        CCA_MESSAGE(ccaMessage,header,Auto_TimeZoneOffsetGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Auto_TimeZoneOffset", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Auto_TimeZoneOffset);
        ::boost::shared_ptr< Auto_TimeZoneOffsetError > payload (new Auto_TimeZoneOffsetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Auto_TimeZoneOffsetError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Auto_TimeZoneOffset", &cb);
    }
}

act_t Clock_main_fiProxy::sendAuto_TimeZoneOffsetSet(Auto_TimeZoneOffsetCallbackIF& cb, int8 s8Offset_Hour, int8 s8Offset_Minute) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Auto_TimeZoneOffset);
        ::boost::shared_ptr< Auto_TimeZoneOffsetSet > payload (new Auto_TimeZoneOffsetSet());
        payload->setS8Offset_Hour(s8Offset_Hour);
        payload->setS8Offset_Minute(s8Offset_Minute);
        CCA_MESSAGE(ccaMessage,header,Auto_TimeZoneOffsetSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Auto_TimeZoneOffset", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Auto_TimeZoneOffset);
        ::boost::shared_ptr< Auto_TimeZoneOffsetError > payload (new Auto_TimeZoneOffsetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Auto_TimeZoneOffsetError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Auto_TimeZoneOffset", &cb);
    }
}

act_t Clock_main_fiProxy::sendNewDateFormatUpReg(NewDateFormatCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_NewDateFormat);
        ::boost::shared_ptr< NewDateFormatUpReg > payload (new NewDateFormatUpReg());
        CCA_MESSAGE(ccaMessage,header,NewDateFormatUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< NewDateFormatRelUpReg > payloadRelUpRegHeap (new NewDateFormatRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_NewDateFormat, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::NewDateFormatRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_NewDateFormat, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "NewDateFormat", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "NewDateFormat", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasNewDateFormat()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_NewDateFormat, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< NewDateFormatStatus > payloadLoopback (new NewDateFormatStatus(getNewDateFormat()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,NewDateFormatStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NewDateFormat);
        ::boost::shared_ptr< NewDateFormatError > payload (new NewDateFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NewDateFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "NewDateFormat", &cb);
    }
}

bool Clock_main_fiProxy::sendNewDateFormatRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_NewDateFormat,"NewDateFormat");
}

void Clock_main_fiProxy::sendNewDateFormatRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_NewDateFormat);
}

const NewDateFormatStatus& Clock_main_fiProxy::getNewDateFormat() const {
    return _newDateFormat.get();
}

bool Clock_main_fiProxy::hasNewDateFormat() const {
    return _newDateFormat.hasValue();
}

act_t Clock_main_fiProxy::sendNewDateFormatGet(NewDateFormatCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_NewDateFormat);
        ::boost::shared_ptr< NewDateFormatGet > payload (new NewDateFormatGet());
        CCA_MESSAGE(ccaMessage,header,NewDateFormatGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "NewDateFormat", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NewDateFormat);
        ::boost::shared_ptr< NewDateFormatError > payload (new NewDateFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NewDateFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "NewDateFormat", &cb);
    }
}

act_t Clock_main_fiProxy::sendNewDateFormatSet(NewDateFormatCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_NewDateFormat);
        ::boost::shared_ptr< NewDateFormatSet > payload (new NewDateFormatSet());
        payload->setEnDateFormat(enDateFormat);
        CCA_MESSAGE(ccaMessage,header,NewDateFormatSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "NewDateFormat", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NewDateFormat);
        ::boost::shared_ptr< NewDateFormatError > payload (new NewDateFormatError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NewDateFormatError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "NewDateFormat", &cb);
    }
}

act_t Clock_main_fiProxy::sendConnectionUpReg(ConnectionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Connection);
        ::boost::shared_ptr< ConnectionUpReg > payload (new ConnectionUpReg());
        CCA_MESSAGE(ccaMessage,header,ConnectionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ConnectionRelUpReg > payloadRelUpRegHeap (new ConnectionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Connection, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::ConnectionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Connection, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Connection", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Connection", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasConnection()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Connection, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ConnectionStatus > payloadLoopback (new ConnectionStatus(getConnection()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ConnectionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Connection);
        ::boost::shared_ptr< ConnectionError > payload (new ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Connection", &cb);
    }
}

bool Clock_main_fiProxy::sendConnectionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Connection,"Connection");
}

void Clock_main_fiProxy::sendConnectionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Connection);
}

const ConnectionStatus& Clock_main_fiProxy::getConnection() const {
    return _connection.get();
}

bool Clock_main_fiProxy::hasConnection() const {
    return _connection.hasValue();
}

act_t Clock_main_fiProxy::sendConnectionGet(ConnectionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Connection);
        ::boost::shared_ptr< ConnectionGet > payload (new ConnectionGet());
        CCA_MESSAGE(ccaMessage,header,ConnectionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Connection", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Connection);
        ::boost::shared_ptr< ConnectionError > payload (new ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Connection", &cb);
    }
}

act_t Clock_main_fiProxy::sendTimeZone_DSTAvailabilityUpReg(TimeZone_DSTAvailabilityCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TimeZone_DSTAvailability);
        ::boost::shared_ptr< TimeZone_DSTAvailabilityUpReg > payload (new TimeZone_DSTAvailabilityUpReg());
        CCA_MESSAGE(ccaMessage,header,TimeZone_DSTAvailabilityUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TimeZone_DSTAvailabilityRelUpReg > payloadRelUpRegHeap (new TimeZone_DSTAvailabilityRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TimeZone_DSTAvailability, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::TimeZone_DSTAvailabilityRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TimeZone_DSTAvailability, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TimeZone_DSTAvailability", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TimeZone_DSTAvailability", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTimeZone_DSTAvailability()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TimeZone_DSTAvailability, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TimeZone_DSTAvailabilityStatus > payloadLoopback (new TimeZone_DSTAvailabilityStatus(getTimeZone_DSTAvailability()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TimeZone_DSTAvailabilityStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TimeZone_DSTAvailability);
        ::boost::shared_ptr< TimeZone_DSTAvailabilityError > payload (new TimeZone_DSTAvailabilityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TimeZone_DSTAvailabilityError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TimeZone_DSTAvailability", &cb);
    }
}

bool Clock_main_fiProxy::sendTimeZone_DSTAvailabilityRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TimeZone_DSTAvailability,"TimeZone_DSTAvailability");
}

void Clock_main_fiProxy::sendTimeZone_DSTAvailabilityRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TimeZone_DSTAvailability);
}

const TimeZone_DSTAvailabilityStatus& Clock_main_fiProxy::getTimeZone_DSTAvailability() const {
    return _timeZone_DSTAvailability.get();
}

bool Clock_main_fiProxy::hasTimeZone_DSTAvailability() const {
    return _timeZone_DSTAvailability.hasValue();
}

act_t Clock_main_fiProxy::sendTimeZone_DSTAvailabilityGet(TimeZone_DSTAvailabilityCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TimeZone_DSTAvailability);
        ::boost::shared_ptr< TimeZone_DSTAvailabilityGet > payload (new TimeZone_DSTAvailabilityGet());
        CCA_MESSAGE(ccaMessage,header,TimeZone_DSTAvailabilityGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TimeZone_DSTAvailability", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TimeZone_DSTAvailability);
        ::boost::shared_ptr< TimeZone_DSTAvailabilityError > payload (new TimeZone_DSTAvailabilityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TimeZone_DSTAvailabilityError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TimeZone_DSTAvailability", &cb);
    }
}

act_t Clock_main_fiProxy::sendHardwareVersionUpReg(HardwareVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_HardwareVersion);
        ::boost::shared_ptr< HardwareVersionUpReg > payload (new HardwareVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,HardwareVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< HardwareVersionRelUpReg > payloadRelUpRegHeap (new HardwareVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_HardwareVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::HardwareVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_HardwareVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "HardwareVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "HardwareVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasHardwareVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_HardwareVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< HardwareVersionStatus > payloadLoopback (new HardwareVersionStatus(getHardwareVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,HardwareVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HardwareVersion);
        ::boost::shared_ptr< HardwareVersionError > payload (new HardwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HardwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "HardwareVersion", &cb);
    }
}

bool Clock_main_fiProxy::sendHardwareVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_HardwareVersion,"HardwareVersion");
}

void Clock_main_fiProxy::sendHardwareVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_HardwareVersion);
}

const HardwareVersionStatus& Clock_main_fiProxy::getHardwareVersion() const {
    return _hardwareVersion.get();
}

bool Clock_main_fiProxy::hasHardwareVersion() const {
    return _hardwareVersion.hasValue();
}

act_t Clock_main_fiProxy::sendHardwareVersionGet(HardwareVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_HardwareVersion);
        ::boost::shared_ptr< HardwareVersionGet > payload (new HardwareVersionGet());
        CCA_MESSAGE(ccaMessage,header,HardwareVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "HardwareVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HardwareVersion);
        ::boost::shared_ptr< HardwareVersionError > payload (new HardwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HardwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "HardwareVersion", &cb);
    }
}

act_t Clock_main_fiProxy::sendSoftwareVersionUpReg(SoftwareVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SoftwareVersion);
        ::boost::shared_ptr< SoftwareVersionUpReg > payload (new SoftwareVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,SoftwareVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SoftwareVersionRelUpReg > payloadRelUpRegHeap (new SoftwareVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SoftwareVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::SoftwareVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SoftwareVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SoftwareVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SoftwareVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSoftwareVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SoftwareVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SoftwareVersionStatus > payloadLoopback (new SoftwareVersionStatus(getSoftwareVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SoftwareVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SoftwareVersion);
        ::boost::shared_ptr< SoftwareVersionError > payload (new SoftwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SoftwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SoftwareVersion", &cb);
    }
}

bool Clock_main_fiProxy::sendSoftwareVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SoftwareVersion,"SoftwareVersion");
}

void Clock_main_fiProxy::sendSoftwareVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SoftwareVersion);
}

const SoftwareVersionStatus& Clock_main_fiProxy::getSoftwareVersion() const {
    return _softwareVersion.get();
}

bool Clock_main_fiProxy::hasSoftwareVersion() const {
    return _softwareVersion.hasValue();
}

act_t Clock_main_fiProxy::sendSoftwareVersionGet(SoftwareVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SoftwareVersion);
        ::boost::shared_ptr< SoftwareVersionGet > payload (new SoftwareVersionGet());
        CCA_MESSAGE(ccaMessage,header,SoftwareVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SoftwareVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SoftwareVersion);
        ::boost::shared_ptr< SoftwareVersionError > payload (new SoftwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SoftwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SoftwareVersion", &cb);
    }
}

act_t Clock_main_fiProxy::sendDebugMode_TimeDateUpReg(DebugMode_TimeDateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DebugMode_TimeDate);
        ::boost::shared_ptr< DebugMode_TimeDateUpReg > payload (new DebugMode_TimeDateUpReg());
        CCA_MESSAGE(ccaMessage,header,DebugMode_TimeDateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DebugMode_TimeDateRelUpReg > payloadRelUpRegHeap (new DebugMode_TimeDateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DebugMode_TimeDate, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::DebugMode_TimeDateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DebugMode_TimeDate, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DebugMode_TimeDate", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DebugMode_TimeDate", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDebugMode_TimeDate()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DebugMode_TimeDate, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DebugMode_TimeDateStatus > payloadLoopback (new DebugMode_TimeDateStatus(getDebugMode_TimeDate()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DebugMode_TimeDateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DebugMode_TimeDate);
        ::boost::shared_ptr< DebugMode_TimeDateError > payload (new DebugMode_TimeDateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DebugMode_TimeDateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DebugMode_TimeDate", &cb);
    }
}

bool Clock_main_fiProxy::sendDebugMode_TimeDateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DebugMode_TimeDate,"DebugMode_TimeDate");
}

void Clock_main_fiProxy::sendDebugMode_TimeDateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DebugMode_TimeDate);
}

const DebugMode_TimeDateStatus& Clock_main_fiProxy::getDebugMode_TimeDate() const {
    return _debugMode_TimeDate.get();
}

bool Clock_main_fiProxy::hasDebugMode_TimeDate() const {
    return _debugMode_TimeDate.hasValue();
}

act_t Clock_main_fiProxy::sendDebugMode_TimeDateGet(DebugMode_TimeDateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DebugMode_TimeDate);
        ::boost::shared_ptr< DebugMode_TimeDateGet > payload (new DebugMode_TimeDateGet());
        CCA_MESSAGE(ccaMessage,header,DebugMode_TimeDateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DebugMode_TimeDate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DebugMode_TimeDate);
        ::boost::shared_ptr< DebugMode_TimeDateError > payload (new DebugMode_TimeDateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DebugMode_TimeDateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DebugMode_TimeDate", &cb);
    }
}

act_t Clock_main_fiProxy::sendDebugMode_TimeDateSet(DebugMode_TimeDateCallbackIF& cb, int16 s16Year, uint8 u8Month, uint8 u8Day, uint8 u8Hours, uint8 u8Minutes, uint8 u8Seconds, uint8 u8Weekday, bool bdebugMode, uint8 u8ChangeMask) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DebugMode_TimeDate);
        ::boost::shared_ptr< DebugMode_TimeDateSet > payload (new DebugMode_TimeDateSet());
        payload->setS16Year(s16Year);
        payload->setU8Month(u8Month);
        payload->setU8Day(u8Day);
        payload->setU8Hours(u8Hours);
        payload->setU8Minutes(u8Minutes);
        payload->setU8Seconds(u8Seconds);
        payload->setU8Weekday(u8Weekday);
        payload->setBdebugMode(bdebugMode);
        payload->setU8ChangeMask(u8ChangeMask);
        CCA_MESSAGE(ccaMessage,header,DebugMode_TimeDateSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DebugMode_TimeDate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DebugMode_TimeDate);
        ::boost::shared_ptr< DebugMode_TimeDateError > payload (new DebugMode_TimeDateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DebugMode_TimeDateError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DebugMode_TimeDate", &cb);
    }
}

act_t Clock_main_fiProxy::sendUTC_TimeDateUpdateUpReg(UTC_TimeDateUpdateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_UTC_TimeDateUpdate);
        ::boost::shared_ptr< UTC_TimeDateUpdateUpReg > payload (new UTC_TimeDateUpdateUpReg());
        CCA_MESSAGE(ccaMessage,header,UTC_TimeDateUpdateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< UTC_TimeDateUpdateRelUpReg > payloadRelUpRegHeap (new UTC_TimeDateUpdateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_UTC_TimeDateUpdate, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::UTC_TimeDateUpdateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_UTC_TimeDateUpdate, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "UTC_TimeDateUpdate", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "UTC_TimeDateUpdate", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasUTC_TimeDateUpdate()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_UTC_TimeDateUpdate, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< UTC_TimeDateUpdateStatus > payloadLoopback (new UTC_TimeDateUpdateStatus(getUTC_TimeDateUpdate()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,UTC_TimeDateUpdateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UTC_TimeDateUpdate);
        ::boost::shared_ptr< UTC_TimeDateUpdateError > payload (new UTC_TimeDateUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UTC_TimeDateUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "UTC_TimeDateUpdate", &cb);
    }
}

bool Clock_main_fiProxy::sendUTC_TimeDateUpdateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_UTC_TimeDateUpdate,"UTC_TimeDateUpdate");
}

void Clock_main_fiProxy::sendUTC_TimeDateUpdateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_UTC_TimeDateUpdate);
}

const UTC_TimeDateUpdateStatus& Clock_main_fiProxy::getUTC_TimeDateUpdate() const {
    return _uTC_TimeDateUpdate.get();
}

bool Clock_main_fiProxy::hasUTC_TimeDateUpdate() const {
    return _uTC_TimeDateUpdate.hasValue();
}

act_t Clock_main_fiProxy::sendUTC_TimeDateUpdateGet(UTC_TimeDateUpdateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_UTC_TimeDateUpdate);
        ::boost::shared_ptr< UTC_TimeDateUpdateGet > payload (new UTC_TimeDateUpdateGet());
        CCA_MESSAGE(ccaMessage,header,UTC_TimeDateUpdateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "UTC_TimeDateUpdate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UTC_TimeDateUpdate);
        ::boost::shared_ptr< UTC_TimeDateUpdateError > payload (new UTC_TimeDateUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UTC_TimeDateUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "UTC_TimeDateUpdate", &cb);
    }
}

act_t Clock_main_fiProxy::sendHUD_ActivationUpReg(HUD_ActivationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_HUD_Activation);
        ::boost::shared_ptr< HUD_ActivationUpReg > payload (new HUD_ActivationUpReg());
        CCA_MESSAGE(ccaMessage,header,HUD_ActivationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< HUD_ActivationRelUpReg > payloadRelUpRegHeap (new HUD_ActivationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_HUD_Activation, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::HUD_ActivationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_HUD_Activation, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "HUD_Activation", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "HUD_Activation", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasHUD_Activation()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_HUD_Activation, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< HUD_ActivationStatus > payloadLoopback (new HUD_ActivationStatus(getHUD_Activation()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,HUD_ActivationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HUD_Activation);
        ::boost::shared_ptr< HUD_ActivationError > payload (new HUD_ActivationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HUD_ActivationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "HUD_Activation", &cb);
    }
}

bool Clock_main_fiProxy::sendHUD_ActivationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_HUD_Activation,"HUD_Activation");
}

void Clock_main_fiProxy::sendHUD_ActivationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_HUD_Activation);
}

const HUD_ActivationStatus& Clock_main_fiProxy::getHUD_Activation() const {
    return _hUD_Activation.get();
}

bool Clock_main_fiProxy::hasHUD_Activation() const {
    return _hUD_Activation.hasValue();
}

act_t Clock_main_fiProxy::sendHUD_ActivationGet(HUD_ActivationCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_HUD_Activation);
        ::boost::shared_ptr< HUD_ActivationGet > payload (new HUD_ActivationGet());
        CCA_MESSAGE(ccaMessage,header,HUD_ActivationGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "HUD_Activation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HUD_Activation);
        ::boost::shared_ptr< HUD_ActivationError > payload (new HUD_ActivationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HUD_ActivationError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "HUD_Activation", &cb);
    }
}

act_t Clock_main_fiProxy::sendHUD_ActivationSet(HUD_ActivationCallbackIF& cb, ::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings enHUD_Setting) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_HUD_Activation);
        ::boost::shared_ptr< HUD_ActivationSet > payload (new HUD_ActivationSet());
        payload->setEnHUD_Setting(enHUD_Setting);
        CCA_MESSAGE(ccaMessage,header,HUD_ActivationSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "HUD_Activation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HUD_Activation);
        ::boost::shared_ptr< HUD_ActivationError > payload (new HUD_ActivationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HUD_ActivationError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "HUD_Activation", &cb);
    }
}

act_t Clock_main_fiProxy::sendHUD_PostitionUpReg(HUD_PostitionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_HUD_Postition);
        ::boost::shared_ptr< HUD_PostitionUpReg > payload (new HUD_PostitionUpReg());
        CCA_MESSAGE(ccaMessage,header,HUD_PostitionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< HUD_PostitionRelUpReg > payloadRelUpRegHeap (new HUD_PostitionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_HUD_Postition, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::clock_main_fi::HUD_PostitionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_HUD_Postition, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "HUD_Postition", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "HUD_Postition", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasHUD_Postition()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_HUD_Postition, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< HUD_PostitionStatus > payloadLoopback (new HUD_PostitionStatus(getHUD_Postition()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,HUD_PostitionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HUD_Postition);
        ::boost::shared_ptr< HUD_PostitionError > payload (new HUD_PostitionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HUD_PostitionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "HUD_Postition", &cb);
    }
}

bool Clock_main_fiProxy::sendHUD_PostitionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_HUD_Postition,"HUD_Postition");
}

void Clock_main_fiProxy::sendHUD_PostitionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_HUD_Postition);
}

const HUD_PostitionStatus& Clock_main_fiProxy::getHUD_Postition() const {
    return _hUD_Postition.get();
}

bool Clock_main_fiProxy::hasHUD_Postition() const {
    return _hUD_Postition.hasValue();
}

act_t Clock_main_fiProxy::sendHUD_PostitionGet(HUD_PostitionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_HUD_Postition);
        ::boost::shared_ptr< HUD_PostitionGet > payload (new HUD_PostitionGet());
        CCA_MESSAGE(ccaMessage,header,HUD_PostitionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "HUD_Postition", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HUD_Postition);
        ::boost::shared_ptr< HUD_PostitionError > payload (new HUD_PostitionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HUD_PostitionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "HUD_Postition", &cb);
    }
}

act_t Clock_main_fiProxy::sendHUD_PostitionSet(HUD_PostitionCallbackIF& cb, uint8 u8Up_Position, uint8 u8Down_Position) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_HUD_Postition);
        ::boost::shared_ptr< HUD_PostitionSet > payload (new HUD_PostitionSet());
        payload->setU8Up_Position(u8Up_Position);
        payload->setU8Down_Position(u8Down_Position);
        CCA_MESSAGE(ccaMessage,header,HUD_PostitionSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "HUD_Postition", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HUD_Postition);
        ::boost::shared_ptr< HUD_PostitionError > payload (new HUD_PostitionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HUD_PostitionError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "HUD_Postition", &cb);
    }
}


void Clock_main_fiProxy::clearAllProperties ()
{
    _timeZone = ::asf::core::nullable<TimeZoneStatus>();
    _daylightSavingTime = ::asf::core::nullable<DaylightSavingTimeStatus>();
    _gPS_AutoSync = ::asf::core::nullable<GPS_AutoSyncStatus>();
    _syncMode = ::asf::core::nullable<SyncModeStatus>();
    _gPS_WeekEpoch = ::asf::core::nullable<GPS_WeekEpochStatus>();
    _localTimeOffset = ::asf::core::nullable<LocalTimeOffsetStatus>();
    _localTimeDateMap.clear();
    _timeFormat = ::asf::core::nullable<TimeFormatStatus>();
    _dateFormat = ::asf::core::nullable<DateFormatStatus>();
    _clockSourceStatus = ::asf::core::nullable<ClockSourceStatusStatus>();
    _formatSourceStatus = ::asf::core::nullable<FormatSourceStatusStatus>();
    _localTimeDate_MinuteUpdate = ::asf::core::nullable<LocalTimeDate_MinuteUpdateStatus>();
    _region_TimeZone = ::asf::core::nullable<Region_TimeZoneStatus>();
    _auto_TimeZoneOffset = ::asf::core::nullable<Auto_TimeZoneOffsetStatus>();
    _newDateFormat = ::asf::core::nullable<NewDateFormatStatus>();
    _connection = ::asf::core::nullable<ConnectionStatus>();
    _timeZone_DSTAvailability = ::asf::core::nullable<TimeZone_DSTAvailabilityStatus>();
    _hardwareVersion = ::asf::core::nullable<HardwareVersionStatus>();
    _softwareVersion = ::asf::core::nullable<SoftwareVersionStatus>();
    _debugMode_TimeDate = ::asf::core::nullable<DebugMode_TimeDateStatus>();
    _uTC_TimeDateUpdate = ::asf::core::nullable<UTC_TimeDateUpdateStatus>();
    _hUD_Activation = ::asf::core::nullable<HUD_ActivationStatus>();
    _hUD_Postition = ::asf::core::nullable<HUD_PostitionStatus>();
}

void Clock_main_fiProxy::sendRelUpRegAll()
{
    sendTimeZoneRelUpRegAll();
    sendDaylightSavingTimeRelUpRegAll();
    sendGPS_AutoSyncRelUpRegAll();
    sendSyncModeRelUpRegAll();
    sendGPS_WeekEpochRelUpRegAll();
    sendLocalTimeOffsetRelUpRegAll();
    sendLocalTimeDateRelUpRegAll();
    sendTimeFormatRelUpRegAll();
    sendDateFormatRelUpRegAll();
    sendClockSourceStatusRelUpRegAll();
    sendFormatSourceStatusRelUpRegAll();
    sendLocalTimeDate_MinuteUpdateRelUpRegAll();
    sendRegion_TimeZoneRelUpRegAll();
    sendAuto_TimeZoneOffsetRelUpRegAll();
    sendNewDateFormatRelUpRegAll();
    sendConnectionRelUpRegAll();
    sendTimeZone_DSTAvailabilityRelUpRegAll();
    sendHardwareVersionRelUpRegAll();
    sendSoftwareVersionRelUpRegAll();
    sendDebugMode_TimeDateRelUpRegAll();
    sendUTC_TimeDateUpdateRelUpRegAll();
    sendHUD_ActivationRelUpRegAll();
    sendHUD_PostitionRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Clock_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Clock_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace clock_main_fi
