#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_DAB_MIDW_EXT_DABTUNER_FI_TYPES_H
#define COM_DAB_MIDW_EXT_DABTUNER_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "com/dab/midw_ext_dabtuner_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types midw_ext_dabtuner_fi_types
 */

namespace com {
namespace dab {
namespace midw_ext_dabtuner_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_DAB_Label;

class T_b8_DAB_MTC_SetMode;

class T_b16_DAB_AnnouncementType;

class T_DAB_Frequency;

class T_b16_DAB_TunerStatusFlags;

class T_DAB_TunerStatus;

class T_DAB_RadioText;

class T_DAB_RadioTextPlus;

class T_DAB_EnsembleInfo;

class T_b8_DAB_ServiceInfoFlags;

class T_DAB_ServiceInfo;

class T_DAB_ChannelInfo;

class T_DAB_ComponentInfo;

class T_DAB_AnnoConfig;

class T_DAB_AnnoElement;

class T_DAB_AnnoStatus;

class T_DAB_ADRMsg;

class T_DAB_LogoElement;

class T_DAB_ContentID;

class T_DAB_TuneParam;

class T_DAB_LearnParam;

class T_b32_DAB_SetupMask;

class T_b32_DAB_SetupFlags;

class T_b8_DAB_LinkingSetupMask;

class T_b8_DAB_ExtServFollowingFlags;

class T_DAB_PresetListElement;

class T_DAB_ChnListElement;

class T_DAB_ListElementAvailInfo;

class T_DAB_TIIListElement;

class T_b8_DAB_TestMode_Flags;

class T_b8_DAB_ALT_FM_Valid_Flags;

class T_DAB_LinkListElem;

class T_DAB_AltFreqInfo;

class T_DAB_TestModeData;

class T_DAB_BG_TestModeData;

class T_DAB_Time;

class T_DAB_TMC_TPEG_TestModeData;

class T_DAB_RdbId;

class T_DAB_TmcData;

class T_DAB_Encryption;

class T_DAB_MsgSource;

class T_DAB_TmcInfo;

class T_DAB_EnsembleTmcInfo;

class T_DAB_TpegUriChannel;

// type definitions
/**
 * If the meaning of "T_DAB_TpegInfo" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_DAB_TpegInfo;


/**
 * DAB label used for ensemble, service and component labels .
 */
class T_DAB_Label {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_Label ();

    /**
     * Copy constructor
     */
    inline  T_DAB_Label (const T_DAB_Label &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_Label (const ::std::string& sLabel_, const ::std::string& sLabelShort_, uint16 u16LabelMask_);

    /**
     * Destructor
     */
    inline  ~T_DAB_Label();

    /**
     * Assignment operator
     */
    inline T_DAB_Label& operator = (const T_DAB_Label& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_Label& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_Label& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_Label& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_Label& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sLabel"

    static const int kSLabel = 0;

    /**
     * Clears the field "sLabel".
     *
     * The field will be set to its default value. The hasSLabel()
     * method will return false.
     */
    inline void clearSLabel();

    /**
     * Checks whether the field "sLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLabel()). Otherwise it will return false.
     */
    inline bool hasSLabel () const;

    /**
     * Returns the value of the member "sLabel".
     *
     * Content of the label in UTF8 format. Max 16 characters.
     *
     * @return The value of the field "sLabel"
     */
    inline const ::std::string& getSLabel () const;

    /**
     * Retrieves the value of the field "sLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLabel".
     */
    inline ::std::string& getSLabelMutable ();

    /**
     * Sets the value of the member "sLabel".
     *
     * Content of the label in UTF8 format. Max 16 characters.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const ::std::string& sLabel_);

    /**
     * Sets the value of the member "sLabel".
     *
     * Content of the label in UTF8 format. Max 16 characters.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const char* sLabel_);

    /**
     * Sets the value of the member "sLabel".
     *
     * Content of the label in UTF8 format. Max 16 characters.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const char* value, size_t size);

    // API of field "sLabelShort"

    static const int kSLabelShort = 1;

    /**
     * Clears the field "sLabelShort".
     *
     * The field will be set to its default value. The hasSLabelShort()
     * method will return false.
     */
    inline void clearSLabelShort();

    /**
     * Checks whether the field "sLabelShort" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLabelShort()). Otherwise it will return false.
     */
    inline bool hasSLabelShort () const;

    /**
     * Returns the value of the member "sLabelShort".
     *
     * Content of the label in UTF8 format. Max  8 characters.
     *
     * @return The value of the field "sLabelShort"
     */
    inline const ::std::string& getSLabelShort () const;

    /**
     * Retrieves the value of the field "sLabelShort" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLabelShort".
     */
    inline ::std::string& getSLabelShortMutable ();

    /**
     * Sets the value of the member "sLabelShort".
     *
     * Content of the label in UTF8 format. Max  8 characters.
     *
     * @param sLabelShort The value which will be set
     */
    inline void setSLabelShort (const ::std::string& sLabelShort_);

    /**
     * Sets the value of the member "sLabelShort".
     *
     * Content of the label in UTF8 format. Max  8 characters.
     *
     * @param sLabelShort The value which will be set
     */
    inline void setSLabelShort (const char* sLabelShort_);

    /**
     * Sets the value of the member "sLabelShort".
     *
     * Content of the label in UTF8 format. Max  8 characters.
     *
     * @param sLabelShort The value which will be set
     */
    inline void setSLabelShort (const char* value, size_t size);

    // API of field "u16LabelMask"

    static const int kU16LabelMask = 2;

    /**
     * Clears the field "u16LabelMask".
     *
     * The field will be set to its default value. The hasU16LabelMask()
     * method will return false.
     */
    inline void clearU16LabelMask();

    /**
     * Checks whether the field "u16LabelMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LabelMask()). Otherwise it will return false.
     */
    inline bool hasU16LabelMask () const;

    /**
     * Returns the value of the member "u16LabelMask".
     *
     * Label Mask to get short label
     *
     * @return The value of the field "u16LabelMask"
     */
    inline uint16 getU16LabelMask () const;

    /**
     * Sets the value of the member "u16LabelMask".
     *
     * Label Mask to get short label
     *
     * @param u16LabelMask The value which will be set
     */
    inline void setU16LabelMask (uint16 u16LabelMask_);

    static const T_DAB_Label &getDefaultInstance();

private:

    inline void set_has_sLabel ();

    inline void clear_has_sLabel ();

    inline void set_has_sLabelShort ();

    inline void clear_has_sLabelShort ();

    inline void set_has_u16LabelMask ();

    inline void clear_has_u16LabelMask ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sLabel;

    ::std::string _sLabelShort;

    uint16 _u16LabelMask;

};

/**
 * Enum for Service switching. Sets the mode for service switching.
 */
class T_b8_DAB_MTC_SetMode {
public:

    /**
     * Default constructor
     */
    inline  T_b8_DAB_MTC_SetMode ();

    /**
     * Copy constructor
     */
    inline  T_b8_DAB_MTC_SetMode (const T_b8_DAB_MTC_SetMode &c);

    /**
     * Field constructor
     */
    inline  T_b8_DAB_MTC_SetMode (bool DAB_SERVICELINKING_FM, bool FM_SERVICELINKING_DAB);

    /**
     * Assignment operator
     */
    inline T_b8_DAB_MTC_SetMode& operator = (const T_b8_DAB_MTC_SetMode& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_DAB_MTC_SetMode& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_DAB_MTC_SetMode& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_DAB_MTC_SetMode& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_DAB_MTC_SetMode& rhs) const;

    /**
     * Sets the value of the member "DAB_SERVICELINKING_FM".
     *
     * If the meaning of "DAB_SERVICELINKING_FM" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICELINKING_FM The value which will be set
     */
    inline void setDAB_SERVICELINKING_FM (bool DAB_SERVICELINKING_FM);

    /**
     * Returns the value of the member "DAB_SERVICELINKING_FM".
     *
     * If the meaning of "DAB_SERVICELINKING_FM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICELINKING_FM"
     */
    inline bool getDAB_SERVICELINKING_FM () const;

    /**
     * Sets the value of the member "FM_SERVICELINKING_DAB".
     *
     * If the meaning of "FM_SERVICELINKING_DAB" isn't clear, then there should be a description here.
     *
     * @param FM_SERVICELINKING_DAB The value which will be set
     */
    inline void setFM_SERVICELINKING_DAB (bool FM_SERVICELINKING_DAB);

    /**
     * Returns the value of the member "FM_SERVICELINKING_DAB".
     *
     * If the meaning of "FM_SERVICELINKING_DAB" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FM_SERVICELINKING_DAB"
     */
    inline bool getFM_SERVICELINKING_DAB () const;

    static const T_b8_DAB_MTC_SetMode &getDefaultInstance();

private:

    bool _DAB_SERVICELINKING_FM:1;

    bool _FM_SERVICELINKING_DAB:1;

};

/**
 * Announcement type
 */
class T_b16_DAB_AnnouncementType {
public:

    /**
     * Default constructor
     */
    inline  T_b16_DAB_AnnouncementType ();

    /**
     * Copy constructor
     */
    inline  T_b16_DAB_AnnouncementType (const T_b16_DAB_AnnouncementType &c);

    /**
     * Field constructor
     */
    inline  T_b16_DAB_AnnouncementType (bool DAB_ANNOTYPE_ALARM, bool DAB_ANNOTYPE_TA, bool DAB_ANNOTYPE_TRANSPORT, bool DAB_ANNOTYPE_WARNING, bool DAB_ANNOTYPE_NEWS, bool DAB_ANNOTYPE_WEATHER, bool DAB_ANNOTYPE_EVENT, bool DAB_ANNOTYPE_SPECIALEVENT, bool DAB_ANNOTYPE_PROGRAMME, bool DAB_ANNOTYPE_SPORTS, bool DAB_ANNOTYPE_FINANCE, bool DAB_ANNOTYPE_b11_reserved, bool DAB_ANNOTYPE_b12_reserved, bool DAB_ANNOTYPE_b13_reserved, bool DAB_ANNOTYPE_b14_reserved, bool DAB_ANNOTYPE_b15_reserved);

    /**
     * Assignment operator
     */
    inline T_b16_DAB_AnnouncementType& operator = (const T_b16_DAB_AnnouncementType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b16_DAB_AnnouncementType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b16_DAB_AnnouncementType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b16_DAB_AnnouncementType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b16_DAB_AnnouncementType& rhs) const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_ALARM".
     *
     * If the meaning of "DAB_ANNOTYPE_ALARM" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_ALARM The value which will be set
     */
    inline void setDAB_ANNOTYPE_ALARM (bool DAB_ANNOTYPE_ALARM);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_ALARM".
     *
     * If the meaning of "DAB_ANNOTYPE_ALARM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_ALARM"
     */
    inline bool getDAB_ANNOTYPE_ALARM () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_TA".
     *
     * If the meaning of "DAB_ANNOTYPE_TA" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_TA The value which will be set
     */
    inline void setDAB_ANNOTYPE_TA (bool DAB_ANNOTYPE_TA);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_TA".
     *
     * If the meaning of "DAB_ANNOTYPE_TA" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_TA"
     */
    inline bool getDAB_ANNOTYPE_TA () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_TRANSPORT".
     *
     * If the meaning of "DAB_ANNOTYPE_TRANSPORT" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_TRANSPORT The value which will be set
     */
    inline void setDAB_ANNOTYPE_TRANSPORT (bool DAB_ANNOTYPE_TRANSPORT);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_TRANSPORT".
     *
     * If the meaning of "DAB_ANNOTYPE_TRANSPORT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_TRANSPORT"
     */
    inline bool getDAB_ANNOTYPE_TRANSPORT () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_WARNING".
     *
     * If the meaning of "DAB_ANNOTYPE_WARNING" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_WARNING The value which will be set
     */
    inline void setDAB_ANNOTYPE_WARNING (bool DAB_ANNOTYPE_WARNING);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_WARNING".
     *
     * If the meaning of "DAB_ANNOTYPE_WARNING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_WARNING"
     */
    inline bool getDAB_ANNOTYPE_WARNING () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_NEWS".
     *
     * If the meaning of "DAB_ANNOTYPE_NEWS" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_NEWS The value which will be set
     */
    inline void setDAB_ANNOTYPE_NEWS (bool DAB_ANNOTYPE_NEWS);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_NEWS".
     *
     * If the meaning of "DAB_ANNOTYPE_NEWS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_NEWS"
     */
    inline bool getDAB_ANNOTYPE_NEWS () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_WEATHER".
     *
     * If the meaning of "DAB_ANNOTYPE_WEATHER" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_WEATHER The value which will be set
     */
    inline void setDAB_ANNOTYPE_WEATHER (bool DAB_ANNOTYPE_WEATHER);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_WEATHER".
     *
     * If the meaning of "DAB_ANNOTYPE_WEATHER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_WEATHER"
     */
    inline bool getDAB_ANNOTYPE_WEATHER () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_EVENT".
     *
     * If the meaning of "DAB_ANNOTYPE_EVENT" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_EVENT The value which will be set
     */
    inline void setDAB_ANNOTYPE_EVENT (bool DAB_ANNOTYPE_EVENT);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_EVENT".
     *
     * If the meaning of "DAB_ANNOTYPE_EVENT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_EVENT"
     */
    inline bool getDAB_ANNOTYPE_EVENT () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_SPECIALEVENT".
     *
     * If the meaning of "DAB_ANNOTYPE_SPECIALEVENT" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_SPECIALEVENT The value which will be set
     */
    inline void setDAB_ANNOTYPE_SPECIALEVENT (bool DAB_ANNOTYPE_SPECIALEVENT);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_SPECIALEVENT".
     *
     * If the meaning of "DAB_ANNOTYPE_SPECIALEVENT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_SPECIALEVENT"
     */
    inline bool getDAB_ANNOTYPE_SPECIALEVENT () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_PROGRAMME".
     *
     * If the meaning of "DAB_ANNOTYPE_PROGRAMME" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_PROGRAMME The value which will be set
     */
    inline void setDAB_ANNOTYPE_PROGRAMME (bool DAB_ANNOTYPE_PROGRAMME);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_PROGRAMME".
     *
     * If the meaning of "DAB_ANNOTYPE_PROGRAMME" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_PROGRAMME"
     */
    inline bool getDAB_ANNOTYPE_PROGRAMME () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_SPORTS".
     *
     * If the meaning of "DAB_ANNOTYPE_SPORTS" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_SPORTS The value which will be set
     */
    inline void setDAB_ANNOTYPE_SPORTS (bool DAB_ANNOTYPE_SPORTS);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_SPORTS".
     *
     * If the meaning of "DAB_ANNOTYPE_SPORTS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_SPORTS"
     */
    inline bool getDAB_ANNOTYPE_SPORTS () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_FINANCE".
     *
     * If the meaning of "DAB_ANNOTYPE_FINANCE" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_FINANCE The value which will be set
     */
    inline void setDAB_ANNOTYPE_FINANCE (bool DAB_ANNOTYPE_FINANCE);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_FINANCE".
     *
     * If the meaning of "DAB_ANNOTYPE_FINANCE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_FINANCE"
     */
    inline bool getDAB_ANNOTYPE_FINANCE () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_b11_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b11_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_b11_reserved The value which will be set
     */
    inline void setDAB_ANNOTYPE_b11_reserved (bool DAB_ANNOTYPE_b11_reserved);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_b11_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b11_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_b11_reserved"
     */
    inline bool getDAB_ANNOTYPE_b11_reserved () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_b12_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b12_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_b12_reserved The value which will be set
     */
    inline void setDAB_ANNOTYPE_b12_reserved (bool DAB_ANNOTYPE_b12_reserved);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_b12_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b12_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_b12_reserved"
     */
    inline bool getDAB_ANNOTYPE_b12_reserved () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_b13_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b13_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_b13_reserved The value which will be set
     */
    inline void setDAB_ANNOTYPE_b13_reserved (bool DAB_ANNOTYPE_b13_reserved);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_b13_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b13_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_b13_reserved"
     */
    inline bool getDAB_ANNOTYPE_b13_reserved () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_b14_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b14_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_b14_reserved The value which will be set
     */
    inline void setDAB_ANNOTYPE_b14_reserved (bool DAB_ANNOTYPE_b14_reserved);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_b14_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b14_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_b14_reserved"
     */
    inline bool getDAB_ANNOTYPE_b14_reserved () const;

    /**
     * Sets the value of the member "DAB_ANNOTYPE_b15_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b15_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_ANNOTYPE_b15_reserved The value which will be set
     */
    inline void setDAB_ANNOTYPE_b15_reserved (bool DAB_ANNOTYPE_b15_reserved);

    /**
     * Returns the value of the member "DAB_ANNOTYPE_b15_reserved".
     *
     * If the meaning of "DAB_ANNOTYPE_b15_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_ANNOTYPE_b15_reserved"
     */
    inline bool getDAB_ANNOTYPE_b15_reserved () const;

    static const T_b16_DAB_AnnouncementType &getDefaultInstance();

private:

    bool _DAB_ANNOTYPE_ALARM:1;

    bool _DAB_ANNOTYPE_TA:1;

    bool _DAB_ANNOTYPE_TRANSPORT:1;

    bool _DAB_ANNOTYPE_WARNING:1;

    bool _DAB_ANNOTYPE_NEWS:1;

    bool _DAB_ANNOTYPE_WEATHER:1;

    bool _DAB_ANNOTYPE_EVENT:1;

    bool _DAB_ANNOTYPE_SPECIALEVENT:1;

    bool _DAB_ANNOTYPE_PROGRAMME:1;

    bool _DAB_ANNOTYPE_SPORTS:1;

    bool _DAB_ANNOTYPE_FINANCE:1;

    bool _DAB_ANNOTYPE_b11_reserved:1;

    bool _DAB_ANNOTYPE_b12_reserved:1;

    bool _DAB_ANNOTYPE_b13_reserved:1;

    bool _DAB_ANNOTYPE_b14_reserved:1;

    bool _DAB_ANNOTYPE_b15_reserved:1;

};

/**
 * Information about which frequency is currently tuned by the DAB Module.
 */
class T_DAB_Frequency {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_Frequency ();

    /**
     * Copy constructor
     */
    inline  T_DAB_Frequency (const T_DAB_Frequency &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_Frequency (uint32 u32Frequency_, const ::std::string& sFreqLabel_);

    /**
     * Destructor
     */
    inline  ~T_DAB_Frequency();

    /**
     * Assignment operator
     */
    inline T_DAB_Frequency& operator = (const T_DAB_Frequency& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_Frequency& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_Frequency& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_Frequency& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_Frequency& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Frequency"

    static const int kU32Frequency = 0;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Tuned frequency. Its value is 0 if the tuned frequency is not available
     * (no communication to the DAB module).
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Tuned frequency. Its value is 0 if the tuned frequency is not available
     * (no communication to the DAB module).
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "sFreqLabel"

    static const int kSFreqLabel = 1;

    /**
     * Clears the field "sFreqLabel".
     *
     * The field will be set to its default value. The hasSFreqLabel()
     * method will return false.
     */
    inline void clearSFreqLabel();

    /**
     * Checks whether the field "sFreqLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFreqLabel()). Otherwise it will return false.
     */
    inline bool hasSFreqLabel () const;

    /**
     * Returns the value of the member "sFreqLabel".
     *
     * Label of the tuned frequency. Max characters: 3. It contains an empty string if
     * its value is not available (no communication to the DAB module).
     *
     * @return The value of the field "sFreqLabel"
     */
    inline const ::std::string& getSFreqLabel () const;

    /**
     * Retrieves the value of the field "sFreqLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFreqLabel".
     */
    inline ::std::string& getSFreqLabelMutable ();

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Label of the tuned frequency. Max characters: 3. It contains an empty string if
     * its value is not available (no communication to the DAB module).
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const ::std::string& sFreqLabel_);

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Label of the tuned frequency. Max characters: 3. It contains an empty string if
     * its value is not available (no communication to the DAB module).
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const char* sFreqLabel_);

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Label of the tuned frequency. Max characters: 3. It contains an empty string if
     * its value is not available (no communication to the DAB module).
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const char* value, size_t size);

    static const T_DAB_Frequency &getDefaultInstance();

private:

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_sFreqLabel ();

    inline void clear_has_sFreqLabel ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32Frequency;

    ::std::string _sFreqLabel;

};

/**
 * Tuner Status Flags.
 */
class T_b16_DAB_TunerStatusFlags {
public:

    /**
     * Default constructor
     */
    inline  T_b16_DAB_TunerStatusFlags ();

    /**
     * Copy constructor
     */
    inline  T_b16_DAB_TunerStatusFlags (const T_b16_DAB_TunerStatusFlags &c);

    /**
     * Field constructor
     */
    inline  T_b16_DAB_TunerStatusFlags (bool DAB_TUNERSTATUSFLAGS_SYNC, bool DAB_TUNERSTATUSFLAGS_ENS_VALID, bool DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID, bool DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID, bool DAB_TUNERSTATUSFLAGS_MUTE, bool DAB_TUNERSTATUSFLAGS_TUNING, bool DAB_TUNERSTATUSFLAGS_b6_reserved, bool DAB_TUNERSTATUSFLAGS_b7_reserved, bool DAB_TUNERSTATUSFLAGS_LEARN, bool DAB_TUNERSTATUSFLAGS_b9_reserved, bool DAB_TUNERSTATUSFLAGS_b10_reserved, bool DAB_TUNERSTATUSFLAGS_b11_reserved, bool DAB_TUNERSTATUSFLAGS_b12_reserved, bool DAB_TUNERSTATUSFLAGS_b13_reserved, bool DAB_TUNERSTATUSFLAGS_b14_reserved, bool DAB_TUNERSTATUSFLAGS_b15_reserved);

    /**
     * Assignment operator
     */
    inline T_b16_DAB_TunerStatusFlags& operator = (const T_b16_DAB_TunerStatusFlags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b16_DAB_TunerStatusFlags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b16_DAB_TunerStatusFlags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b16_DAB_TunerStatusFlags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b16_DAB_TunerStatusFlags& rhs) const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_SYNC".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_SYNC" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_SYNC The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_SYNC (bool DAB_TUNERSTATUSFLAGS_SYNC);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_SYNC".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_SYNC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_SYNC"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_SYNC () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_ENS_VALID".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_ENS_VALID" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_ENS_VALID The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_ENS_VALID (bool DAB_TUNERSTATUSFLAGS_ENS_VALID);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_ENS_VALID".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_ENS_VALID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_ENS_VALID"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_ENS_VALID () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID (bool DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID (bool DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_MUTE".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_MUTE" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_MUTE The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_MUTE (bool DAB_TUNERSTATUSFLAGS_MUTE);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_MUTE".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_MUTE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_MUTE"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_MUTE () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_TUNING".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_TUNING" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_TUNING The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_TUNING (bool DAB_TUNERSTATUSFLAGS_TUNING);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_TUNING".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_TUNING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_TUNING"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_TUNING () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b6_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b6_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b6_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b6_reserved (bool DAB_TUNERSTATUSFLAGS_b6_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b6_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b6_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b6_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b6_reserved () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b7_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b7_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b7_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b7_reserved (bool DAB_TUNERSTATUSFLAGS_b7_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b7_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b7_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b7_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b7_reserved () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_LEARN".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_LEARN" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_LEARN The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_LEARN (bool DAB_TUNERSTATUSFLAGS_LEARN);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_LEARN".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_LEARN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_LEARN"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_LEARN () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b9_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b9_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b9_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b9_reserved (bool DAB_TUNERSTATUSFLAGS_b9_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b9_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b9_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b9_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b9_reserved () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b10_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b10_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b10_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b10_reserved (bool DAB_TUNERSTATUSFLAGS_b10_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b10_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b10_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b10_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b10_reserved () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b11_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b11_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b11_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b11_reserved (bool DAB_TUNERSTATUSFLAGS_b11_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b11_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b11_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b11_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b11_reserved () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b12_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b12_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b12_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b12_reserved (bool DAB_TUNERSTATUSFLAGS_b12_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b12_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b12_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b12_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b12_reserved () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b13_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b13_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b13_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b13_reserved (bool DAB_TUNERSTATUSFLAGS_b13_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b13_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b13_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b13_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b13_reserved () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b14_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b14_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b14_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b14_reserved (bool DAB_TUNERSTATUSFLAGS_b14_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b14_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b14_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b14_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b14_reserved () const;

    /**
     * Sets the value of the member "DAB_TUNERSTATUSFLAGS_b15_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b15_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TUNERSTATUSFLAGS_b15_reserved The value which will be set
     */
    inline void setDAB_TUNERSTATUSFLAGS_b15_reserved (bool DAB_TUNERSTATUSFLAGS_b15_reserved);

    /**
     * Returns the value of the member "DAB_TUNERSTATUSFLAGS_b15_reserved".
     *
     * If the meaning of "DAB_TUNERSTATUSFLAGS_b15_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TUNERSTATUSFLAGS_b15_reserved"
     */
    inline bool getDAB_TUNERSTATUSFLAGS_b15_reserved () const;

    static const T_b16_DAB_TunerStatusFlags &getDefaultInstance();

private:

    bool _DAB_TUNERSTATUSFLAGS_SYNC:1;

    bool _DAB_TUNERSTATUSFLAGS_ENS_VALID:1;

    bool _DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID:1;

    bool _DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID:1;

    bool _DAB_TUNERSTATUSFLAGS_MUTE:1;

    bool _DAB_TUNERSTATUSFLAGS_TUNING:1;

    bool _DAB_TUNERSTATUSFLAGS_b6_reserved:1;

    bool _DAB_TUNERSTATUSFLAGS_b7_reserved:1;

    bool _DAB_TUNERSTATUSFLAGS_LEARN:1;

    bool _DAB_TUNERSTATUSFLAGS_b9_reserved:1;

    bool _DAB_TUNERSTATUSFLAGS_b10_reserved:1;

    bool _DAB_TUNERSTATUSFLAGS_b11_reserved:1;

    bool _DAB_TUNERSTATUSFLAGS_b12_reserved:1;

    bool _DAB_TUNERSTATUSFLAGS_b13_reserved:1;

    bool _DAB_TUNERSTATUSFLAGS_b14_reserved:1;

    bool _DAB_TUNERSTATUSFLAGS_b15_reserved:1;

};

/**
 * DAB Tuner status is contained in this structure .
 */
class T_DAB_TunerStatus {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_TunerStatus ();

    /**
     * Copy constructor
     */
    inline  T_DAB_TunerStatus (const T_DAB_TunerStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_TunerStatus (T_e8_DAB_TunerActivityType e8TunerActivityType_, const T_DAB_Frequency& FreqTuned_, const ::std::string& sFrequencyTable_, const T_b16_DAB_TunerStatusFlags& b16Flags_, uint8 u8SignalQuality_, uint8 u8AudioQuality_, uint32 u32CurrentEnsembleId_, uint32 u32CurrentServiceId_, uint16 u16CurrentSCIDI_);

    /**
     * Destructor
     */
    inline  ~T_DAB_TunerStatus();

    /**
     * Assignment operator
     */
    inline T_DAB_TunerStatus& operator = (const T_DAB_TunerStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_TunerStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_TunerStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_TunerStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_TunerStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TunerActivityType"

    static const int kE8TunerActivityType = 0;

    /**
     * Clears the field "e8TunerActivityType".
     *
     * The field will be set to its default value. The hasE8TunerActivityType()
     * method will return false.
     */
    inline void clearE8TunerActivityType();

    /**
     * Checks whether the field "e8TunerActivityType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TunerActivityType()). Otherwise it will return false.
     */
    inline bool hasE8TunerActivityType () const;

    /**
     * Returns the value of the member "e8TunerActivityType".
     *
     * Returns the current activity type of the DAB Tuner, like normal, scanning, seeking, etc.
     * Its value is only valid if bIsDABAvailable is TRUE.
     *
     * @return The value of the field "e8TunerActivityType"
     */
    inline T_e8_DAB_TunerActivityType getE8TunerActivityType () const;

    /**
     * Sets the value of the member "e8TunerActivityType".
     *
     * Returns the current activity type of the DAB Tuner, like normal, scanning, seeking, etc.
     * Its value is only valid if bIsDABAvailable is TRUE.
     *
     * @param e8TunerActivityType The value which will be set
     */
    inline void setE8TunerActivityType (T_e8_DAB_TunerActivityType e8TunerActivityType_);

    // API of field "FreqTuned"

    static const int kFreqTuned = 1;

    /**
     * Clears the field "FreqTuned".
     *
     * The field will be set to its default value. The hasFreqTuned()
     * method will return false.
     */
    inline void clearFreqTuned();

    /**
     * Checks whether the field "FreqTuned" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFreqTuned()). Otherwise it will return false.
     */
    inline bool hasFreqTuned () const;

    /**
     * Returns the value of the member "FreqTuned".
     *
     * Returns the current tuned frequency. Its value is only valid if bIsDABAvailable is TRUE
     * and u8TunerActivityType is not DAB_ACTTYPE_INVALID.
     *
     * @return The value of the field "FreqTuned"
     */
    inline const T_DAB_Frequency& getFreqTuned () const;

    /**
     * Retrieves the value of the field "FreqTuned" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FreqTuned".
     */
    inline T_DAB_Frequency& getFreqTunedMutable ();

    /**
     * Sets the value of the member "FreqTuned".
     *
     * Returns the current tuned frequency. Its value is only valid if bIsDABAvailable is TRUE
     * and u8TunerActivityType is not DAB_ACTTYPE_INVALID.
     *
     * @param FreqTuned The value which will be set
     */
    inline void setFreqTuned (const T_DAB_Frequency& FreqTuned_);

    // API of field "sFrequencyTable"

    static const int kSFrequencyTable = 2;

    /**
     * Clears the field "sFrequencyTable".
     *
     * The field will be set to its default value. The hasSFrequencyTable()
     * method will return false.
     */
    inline void clearSFrequencyTable();

    /**
     * Checks whether the field "sFrequencyTable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFrequencyTable()). Otherwise it will return false.
     */
    inline bool hasSFrequencyTable () const;

    /**
     * Returns the value of the member "sFrequencyTable".
     *
     * Returns the current frequency table as string.
     *
     * @return The value of the field "sFrequencyTable"
     */
    inline const ::std::string& getSFrequencyTable () const;

    /**
     * Retrieves the value of the field "sFrequencyTable" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFrequencyTable".
     */
    inline ::std::string& getSFrequencyTableMutable ();

    /**
     * Sets the value of the member "sFrequencyTable".
     *
     * Returns the current frequency table as string.
     *
     * @param sFrequencyTable The value which will be set
     */
    inline void setSFrequencyTable (const ::std::string& sFrequencyTable_);

    /**
     * Sets the value of the member "sFrequencyTable".
     *
     * Returns the current frequency table as string.
     *
     * @param sFrequencyTable The value which will be set
     */
    inline void setSFrequencyTable (const char* sFrequencyTable_);

    /**
     * Sets the value of the member "sFrequencyTable".
     *
     * Returns the current frequency table as string.
     *
     * @param sFrequencyTable The value which will be set
     */
    inline void setSFrequencyTable (const char* value, size_t size);

    // API of field "b16Flags"

    static const int kB16Flags = 3;

    /**
     * Clears the field "b16Flags".
     *
     * The field will be set to its default value. The hasB16Flags()
     * method will return false.
     */
    inline void clearB16Flags();

    /**
     * Checks whether the field "b16Flags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB16Flags()). Otherwise it will return false.
     */
    inline bool hasB16Flags () const;

    /**
     * Returns the value of the member "b16Flags".
     *
     * Flags indicating the DAB module status.
     *
     * @return The value of the field "b16Flags"
     */
    inline const T_b16_DAB_TunerStatusFlags& getB16Flags () const;

    /**
     * Retrieves the value of the field "b16Flags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b16Flags".
     */
    inline T_b16_DAB_TunerStatusFlags& getB16FlagsMutable ();

    /**
     * Sets the value of the member "b16Flags".
     *
     * Flags indicating the DAB module status.
     *
     * @param b16Flags The value which will be set
     */
    inline void setB16Flags (const T_b16_DAB_TunerStatusFlags& b16Flags_);

    // API of field "u8SignalQuality"

    static const int kU8SignalQuality = 4;

    /**
     * Clears the field "u8SignalQuality".
     *
     * The field will be set to its default value. The hasU8SignalQuality()
     * method will return false.
     */
    inline void clearU8SignalQuality();

    /**
     * Checks whether the field "u8SignalQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SignalQuality()). Otherwise it will return false.
     */
    inline bool hasU8SignalQuality () const;

    /**
     * Returns the value of the member "u8SignalQuality".
     *
     * Current reception quality.
     *
     * @return The value of the field "u8SignalQuality"
     */
    inline uint8 getU8SignalQuality () const;

    /**
     * Sets the value of the member "u8SignalQuality".
     *
     * Current reception quality.
     *
     * @param u8SignalQuality The value which will be set
     */
    inline void setU8SignalQuality (uint8 u8SignalQuality_);

    // API of field "u8AudioQuality"

    static const int kU8AudioQuality = 5;

    /**
     * Clears the field "u8AudioQuality".
     *
     * The field will be set to its default value. The hasU8AudioQuality()
     * method will return false.
     */
    inline void clearU8AudioQuality();

    /**
     * Checks whether the field "u8AudioQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioQuality()). Otherwise it will return false.
     */
    inline bool hasU8AudioQuality () const;

    /**
     * Returns the value of the member "u8AudioQuality".
     *
     * Audio quality of the current service.
     *
     * @return The value of the field "u8AudioQuality"
     */
    inline uint8 getU8AudioQuality () const;

    /**
     * Sets the value of the member "u8AudioQuality".
     *
     * Audio quality of the current service.
     *
     * @param u8AudioQuality The value which will be set
     */
    inline void setU8AudioQuality (uint8 u8AudioQuality_);

    // API of field "u32CurrentEnsembleId"

    static const int kU32CurrentEnsembleId = 6;

    /**
     * Clears the field "u32CurrentEnsembleId".
     *
     * The field will be set to its default value. The hasU32CurrentEnsembleId()
     * method will return false.
     */
    inline void clearU32CurrentEnsembleId();

    /**
     * Checks whether the field "u32CurrentEnsembleId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32CurrentEnsembleId()). Otherwise it will return false.
     */
    inline bool hasU32CurrentEnsembleId () const;

    /**
     * Returns the value of the member "u32CurrentEnsembleId".
     *
     * Current Ensemble Id.
     *
     * @return The value of the field "u32CurrentEnsembleId"
     */
    inline uint32 getU32CurrentEnsembleId () const;

    /**
     * Sets the value of the member "u32CurrentEnsembleId".
     *
     * Current Ensemble Id.
     *
     * @param u32CurrentEnsembleId The value which will be set
     */
    inline void setU32CurrentEnsembleId (uint32 u32CurrentEnsembleId_);

    // API of field "u32CurrentServiceId"

    static const int kU32CurrentServiceId = 7;

    /**
     * Clears the field "u32CurrentServiceId".
     *
     * The field will be set to its default value. The hasU32CurrentServiceId()
     * method will return false.
     */
    inline void clearU32CurrentServiceId();

    /**
     * Checks whether the field "u32CurrentServiceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32CurrentServiceId()). Otherwise it will return false.
     */
    inline bool hasU32CurrentServiceId () const;

    /**
     * Returns the value of the member "u32CurrentServiceId".
     *
     * Current Audio Service Id.
     *
     * @return The value of the field "u32CurrentServiceId"
     */
    inline uint32 getU32CurrentServiceId () const;

    /**
     * Sets the value of the member "u32CurrentServiceId".
     *
     * Current Audio Service Id.
     *
     * @param u32CurrentServiceId The value which will be set
     */
    inline void setU32CurrentServiceId (uint32 u32CurrentServiceId_);

    // API of field "u16CurrentSCIDI"

    static const int kU16CurrentSCIDI = 8;

    /**
     * Clears the field "u16CurrentSCIDI".
     *
     * The field will be set to its default value. The hasU16CurrentSCIDI()
     * method will return false.
     */
    inline void clearU16CurrentSCIDI();

    /**
     * Checks whether the field "u16CurrentSCIDI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CurrentSCIDI()). Otherwise it will return false.
     */
    inline bool hasU16CurrentSCIDI () const;

    /**
     * Returns the value of the member "u16CurrentSCIDI".
     *
     * Current service component id.
     *
     * @return The value of the field "u16CurrentSCIDI"
     */
    inline uint16 getU16CurrentSCIDI () const;

    /**
     * Sets the value of the member "u16CurrentSCIDI".
     *
     * Current service component id.
     *
     * @param u16CurrentSCIDI The value which will be set
     */
    inline void setU16CurrentSCIDI (uint16 u16CurrentSCIDI_);

    static const T_DAB_TunerStatus &getDefaultInstance();

private:

    inline void set_has_e8TunerActivityType ();

    inline void clear_has_e8TunerActivityType ();

    inline void set_has_FreqTuned ();

    inline void clear_has_FreqTuned ();

    inline void set_has_sFrequencyTable ();

    inline void clear_has_sFrequencyTable ();

    inline void set_has_b16Flags ();

    inline void clear_has_b16Flags ();

    inline void set_has_u8SignalQuality ();

    inline void clear_has_u8SignalQuality ();

    inline void set_has_u8AudioQuality ();

    inline void clear_has_u8AudioQuality ();

    inline void set_has_u32CurrentEnsembleId ();

    inline void clear_has_u32CurrentEnsembleId ();

    inline void set_has_u32CurrentServiceId ();

    inline void clear_has_u32CurrentServiceId ();

    inline void set_has_u16CurrentSCIDI ();

    inline void clear_has_u16CurrentSCIDI ();

    uint32 _has_bits_[ (9 + 31) / 32];

    T_e8_DAB_TunerActivityType _e8TunerActivityType;

    T_DAB_Frequency _FreqTuned;

    ::std::string _sFrequencyTable;

    T_b16_DAB_TunerStatusFlags _b16Flags;

    uint8 _u8SignalQuality;

    uint8 _u8AudioQuality;

    uint32 _u32CurrentEnsembleId;

    uint32 _u32CurrentServiceId;

    uint16 _u16CurrentSCIDI;

};

/**
 * DAB Radio Text data is contained in this structure .
 */
class T_DAB_RadioText {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_RadioText ();

    /**
     * Copy constructor
     */
    inline  T_DAB_RadioText (const T_DAB_RadioText &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_RadioText (const ::std::string& sRadioTextData_, bool bValid_, uint8 u8CharSet_);

    /**
     * Destructor
     */
    inline  ~T_DAB_RadioText();

    /**
     * Assignment operator
     */
    inline T_DAB_RadioText& operator = (const T_DAB_RadioText& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_RadioText& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_RadioText& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_RadioText& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_RadioText& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sRadioTextData"

    static const int kSRadioTextData = 0;

    /**
     * Clears the field "sRadioTextData".
     *
     * The field will be set to its default value. The hasSRadioTextData()
     * method will return false.
     */
    inline void clearSRadioTextData();

    /**
     * Checks whether the field "sRadioTextData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRadioTextData()). Otherwise it will return false.
     */
    inline bool hasSRadioTextData () const;

    /**
     * Returns the value of the member "sRadioTextData".
     *
     * Radio Text data in UTF8 Format. Max characters: 128.
     *
     * @return The value of the field "sRadioTextData"
     */
    inline const ::std::string& getSRadioTextData () const;

    /**
     * Retrieves the value of the field "sRadioTextData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRadioTextData".
     */
    inline ::std::string& getSRadioTextDataMutable ();

    /**
     * Sets the value of the member "sRadioTextData".
     *
     * Radio Text data in UTF8 Format. Max characters: 128.
     *
     * @param sRadioTextData The value which will be set
     */
    inline void setSRadioTextData (const ::std::string& sRadioTextData_);

    /**
     * Sets the value of the member "sRadioTextData".
     *
     * Radio Text data in UTF8 Format. Max characters: 128.
     *
     * @param sRadioTextData The value which will be set
     */
    inline void setSRadioTextData (const char* sRadioTextData_);

    /**
     * Sets the value of the member "sRadioTextData".
     *
     * Radio Text data in UTF8 Format. Max characters: 128.
     *
     * @param sRadioTextData The value which will be set
     */
    inline void setSRadioTextData (const char* value, size_t size);

    // API of field "bValid"

    static const int kBValid = 1;

    /**
     * Clears the field "bValid".
     *
     * The field will be set to its default value. The hasBValid()
     * method will return false.
     */
    inline void clearBValid();

    /**
     * Checks whether the field "bValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBValid()). Otherwise it will return false.
     */
    inline bool hasBValid () const;

    /**
     * Returns the value of the member "bValid".
     *
     * TRUE means that the Radio Text contained in sRadioTextData is valid.
     * FALSE means that the content of sRadioTextData is not valid and
     * the HMI should remove the displayed radiotext string.
     *
     * @return The value of the field "bValid"
     */
    inline bool getBValid () const;

    /**
     * Sets the value of the member "bValid".
     *
     * TRUE means that the Radio Text contained in sRadioTextData is valid.
     * FALSE means that the content of sRadioTextData is not valid and
     * the HMI should remove the displayed radiotext string.
     *
     * @param bValid The value which will be set
     */
    inline void setBValid (bool bValid_);

    // API of field "u8CharSet"

    static const int kU8CharSet = 2;

    /**
     * Clears the field "u8CharSet".
     *
     * The field will be set to its default value. The hasU8CharSet()
     * method will return false.
     */
    inline void clearU8CharSet();

    /**
     * Checks whether the field "u8CharSet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CharSet()). Otherwise it will return false.
     */
    inline bool hasU8CharSet () const;

    /**
     * Returns the value of the member "u8CharSet".
     *
     * Types of character set are EBU_LATIN=0x00,EBU_LATIN_CYR_GREEK=0x01,EBU_LATIN_ARAB_HEBREW_CYR_GREEK=0x02,ISO_LATIN_2=0x03
     *
     * @return The value of the field "u8CharSet"
     */
    inline uint8 getU8CharSet () const;

    /**
     * Sets the value of the member "u8CharSet".
     *
     * Types of character set are EBU_LATIN=0x00,EBU_LATIN_CYR_GREEK=0x01,EBU_LATIN_ARAB_HEBREW_CYR_GREEK=0x02,ISO_LATIN_2=0x03
     *
     * @param u8CharSet The value which will be set
     */
    inline void setU8CharSet (uint8 u8CharSet_);

    static const T_DAB_RadioText &getDefaultInstance();

private:

    inline void set_has_sRadioTextData ();

    inline void clear_has_sRadioTextData ();

    inline void set_has_bValid ();

    inline void clear_has_bValid ();

    inline void set_has_u8CharSet ();

    inline void clear_has_u8CharSet ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sRadioTextData;

    bool _bValid;

    uint8 _u8CharSet;

};

/**
 * DAB Radio Text Plus data is contained in this structure .
 */
class T_DAB_RadioTextPlus {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_RadioTextPlus ();

    /**
     * Copy constructor
     */
    inline  T_DAB_RadioTextPlus (const T_DAB_RadioTextPlus &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_RadioTextPlus (uint8 u8ContentType_, const T_DAB_RadioText& Content_);

    /**
     * Destructor
     */
    inline  ~T_DAB_RadioTextPlus();

    /**
     * Assignment operator
     */
    inline T_DAB_RadioTextPlus& operator = (const T_DAB_RadioTextPlus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_RadioTextPlus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_RadioTextPlus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_RadioTextPlus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_RadioTextPlus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8ContentType"

    static const int kU8ContentType = 0;

    /**
     * Clears the field "u8ContentType".
     *
     * The field will be set to its default value. The hasU8ContentType()
     * method will return false.
     */
    inline void clearU8ContentType();

    /**
     * Checks whether the field "u8ContentType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ContentType()). Otherwise it will return false.
     */
    inline bool hasU8ContentType () const;

    /**
     * Returns the value of the member "u8ContentType".
     *
     * Content Type of the DL Plus data.
     * 1=TITLE,2=ALBUM,3=TRACKNUMBER,4=ARTIST,5=COMPOSITION,6=MOVEMENT,7=CONDUCTOR,8=COMPOSER,9=BAND,10=COMMENT,
     * 11=GENRE,12=NEWS,13=NEWS.LOCAL,14=STOCKMARKET,15=SPORT,16=LOTTERY,17=HOROSCOPE,18=DAILY_DIVERSION,19=HEALTH,20=EVENT,
     * 21=SCENE,22=CINEMA,23=TV,24=DATE_TIME,25=WEATHER,26=TRAFFIC,27=ALARM,28=ADVERTISEMENT,29=URL,30=INFO.OTHER,
     * 31=STATIONNAME.SHORT,32=STATIONNAME.LONG,33=PROGRAMME.NOW,34=PROGRAMME.NEXT,35=PROGRAMME.PART,36=PROGRAMME.HOST,
     * 37=PROGRAMME.EDITORIAL_STAFF,38=PROGRAMME.FREQUENCY,39=PROGRAMME.HOMEPAGE,40=PROGRAMME.SUBCHANNEL,41=PHONE.HOTLINE,
     * 42=PHONE.STUDIO,43=PHONE.OTHER,44=SMS.STUDIO,45=SMS.OTHER,46=EMAIL.HOTLINE,47=EMAIL.STUDIO,48=EMAIL.OTHER,49=MMS.OTHER,
     * 50=CHAT,51=CHAT.CENTER,52=VOTE.QUESTION,53=VOTE.CENTRE,59=DESCRIPTOR.PLACE,60=DESCRIPTOR.APPOINTMENT,61=DESCRIPTOR.IDENTIFIER,
     * 62=DESCRIPTOR.PURCHASE,63=DESCRIPTOR.GET_DATA
     *
     * @return The value of the field "u8ContentType"
     */
    inline uint8 getU8ContentType () const;

    /**
     * Sets the value of the member "u8ContentType".
     *
     * Content Type of the DL Plus data.
     * 1=TITLE,2=ALBUM,3=TRACKNUMBER,4=ARTIST,5=COMPOSITION,6=MOVEMENT,7=CONDUCTOR,8=COMPOSER,9=BAND,10=COMMENT,
     * 11=GENRE,12=NEWS,13=NEWS.LOCAL,14=STOCKMARKET,15=SPORT,16=LOTTERY,17=HOROSCOPE,18=DAILY_DIVERSION,19=HEALTH,20=EVENT,
     * 21=SCENE,22=CINEMA,23=TV,24=DATE_TIME,25=WEATHER,26=TRAFFIC,27=ALARM,28=ADVERTISEMENT,29=URL,30=INFO.OTHER,
     * 31=STATIONNAME.SHORT,32=STATIONNAME.LONG,33=PROGRAMME.NOW,34=PROGRAMME.NEXT,35=PROGRAMME.PART,36=PROGRAMME.HOST,
     * 37=PROGRAMME.EDITORIAL_STAFF,38=PROGRAMME.FREQUENCY,39=PROGRAMME.HOMEPAGE,40=PROGRAMME.SUBCHANNEL,41=PHONE.HOTLINE,
     * 42=PHONE.STUDIO,43=PHONE.OTHER,44=SMS.STUDIO,45=SMS.OTHER,46=EMAIL.HOTLINE,47=EMAIL.STUDIO,48=EMAIL.OTHER,49=MMS.OTHER,
     * 50=CHAT,51=CHAT.CENTER,52=VOTE.QUESTION,53=VOTE.CENTRE,59=DESCRIPTOR.PLACE,60=DESCRIPTOR.APPOINTMENT,61=DESCRIPTOR.IDENTIFIER,
     * 62=DESCRIPTOR.PURCHASE,63=DESCRIPTOR.GET_DATA
     *
     * @param u8ContentType The value which will be set
     */
    inline void setU8ContentType (uint8 u8ContentType_);

    // API of field "Content"

    static const int kContent = 1;

    /**
     * Clears the field "Content".
     *
     * The field will be set to its default value. The hasContent()
     * method will return false.
     */
    inline void clearContent();

    /**
     * Checks whether the field "Content" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContent()). Otherwise it will return false.
     */
    inline bool hasContent () const;

    /**
     * Returns the value of the member "Content".
     *
     * The content of the DL Plus, depending on the content type.
     *
     * @return The value of the field "Content"
     */
    inline const T_DAB_RadioText& getContent () const;

    /**
     * Retrieves the value of the field "Content" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Content".
     */
    inline T_DAB_RadioText& getContentMutable ();

    /**
     * Sets the value of the member "Content".
     *
     * The content of the DL Plus, depending on the content type.
     *
     * @param Content The value which will be set
     */
    inline void setContent (const T_DAB_RadioText& Content_);

    static const T_DAB_RadioTextPlus &getDefaultInstance();

private:

    inline void set_has_u8ContentType ();

    inline void clear_has_u8ContentType ();

    inline void set_has_Content ();

    inline void clear_has_Content ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8ContentType;

    T_DAB_RadioText _Content;

};

/**
 * DAB current ensemble information is contained in this structure .
 */
class T_DAB_EnsembleInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_EnsembleInfo ();

    /**
     * Copy constructor
     */
    inline  T_DAB_EnsembleInfo (const T_DAB_EnsembleInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_EnsembleInfo (uint32 u32EnsembleId_, const T_DAB_Label& EnsembleLabel_, uint32 u32Frequency_, uint8 u8NumberOfAudioServices_, uint8 u8NumberOfDataServices_, uint8 u8NumberOfAudioServiceComponents_, uint8 u8NumberOfDataServiceComponents_, uint8 u8ReceptionQuality_, uint8 u8NumberOfEnsembles_, uint8 u8ListElementId_, bool bReception_);

    /**
     * Destructor
     */
    inline  ~T_DAB_EnsembleInfo();

    /**
     * Assignment operator
     */
    inline T_DAB_EnsembleInfo& operator = (const T_DAB_EnsembleInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_EnsembleInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_EnsembleInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_EnsembleInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_EnsembleInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32EnsembleId"

    static const int kU32EnsembleId = 0;

    /**
     * Clears the field "u32EnsembleId".
     *
     * The field will be set to its default value. The hasU32EnsembleId()
     * method will return false.
     */
    inline void clearU32EnsembleId();

    /**
     * Checks whether the field "u32EnsembleId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EnsembleId()). Otherwise it will return false.
     */
    inline bool hasU32EnsembleId () const;

    /**
     * Returns the value of the member "u32EnsembleId".
     *
     * Ensemble Id.
     *
     * @return The value of the field "u32EnsembleId"
     */
    inline uint32 getU32EnsembleId () const;

    /**
     * Sets the value of the member "u32EnsembleId".
     *
     * Ensemble Id.
     *
     * @param u32EnsembleId The value which will be set
     */
    inline void setU32EnsembleId (uint32 u32EnsembleId_);

    // API of field "EnsembleLabel"

    static const int kEnsembleLabel = 1;

    /**
     * Clears the field "EnsembleLabel".
     *
     * The field will be set to its default value. The hasEnsembleLabel()
     * method will return false.
     */
    inline void clearEnsembleLabel();

    /**
     * Checks whether the field "EnsembleLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnsembleLabel()). Otherwise it will return false.
     */
    inline bool hasEnsembleLabel () const;

    /**
     * Returns the value of the member "EnsembleLabel".
     *
     * Ensemble label.
     *
     * @return The value of the field "EnsembleLabel"
     */
    inline const T_DAB_Label& getEnsembleLabel () const;

    /**
     * Retrieves the value of the field "EnsembleLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnsembleLabel".
     */
    inline T_DAB_Label& getEnsembleLabelMutable ();

    /**
     * Sets the value of the member "EnsembleLabel".
     *
     * Ensemble label.
     *
     * @param EnsembleLabel The value which will be set
     */
    inline void setEnsembleLabel (const T_DAB_Label& EnsembleLabel_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 2;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * The frequency.
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * The frequency.
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u8NumberOfAudioServices"

    static const int kU8NumberOfAudioServices = 3;

    /**
     * Clears the field "u8NumberOfAudioServices".
     *
     * The field will be set to its default value. The hasU8NumberOfAudioServices()
     * method will return false.
     */
    inline void clearU8NumberOfAudioServices();

    /**
     * Checks whether the field "u8NumberOfAudioServices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfAudioServices()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfAudioServices () const;

    /**
     * Returns the value of the member "u8NumberOfAudioServices".
     *
     * The number of audio services in the ensemble (an audio service contains an audio service component as its primary
     * service component).
     *
     * @return The value of the field "u8NumberOfAudioServices"
     */
    inline uint8 getU8NumberOfAudioServices () const;

    /**
     * Sets the value of the member "u8NumberOfAudioServices".
     *
     * The number of audio services in the ensemble (an audio service contains an audio service component as its primary
     * service component).
     *
     * @param u8NumberOfAudioServices The value which will be set
     */
    inline void setU8NumberOfAudioServices (uint8 u8NumberOfAudioServices_);

    // API of field "u8NumberOfDataServices"

    static const int kU8NumberOfDataServices = 4;

    /**
     * Clears the field "u8NumberOfDataServices".
     *
     * The field will be set to its default value. The hasU8NumberOfDataServices()
     * method will return false.
     */
    inline void clearU8NumberOfDataServices();

    /**
     * Checks whether the field "u8NumberOfDataServices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfDataServices()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfDataServices () const;

    /**
     * Returns the value of the member "u8NumberOfDataServices".
     *
     * The number of data services in the ensemble (a data service contains a data service component as its primary
     * service component).
     *
     * @return The value of the field "u8NumberOfDataServices"
     */
    inline uint8 getU8NumberOfDataServices () const;

    /**
     * Sets the value of the member "u8NumberOfDataServices".
     *
     * The number of data services in the ensemble (a data service contains a data service component as its primary
     * service component).
     *
     * @param u8NumberOfDataServices The value which will be set
     */
    inline void setU8NumberOfDataServices (uint8 u8NumberOfDataServices_);

    // API of field "u8NumberOfAudioServiceComponents"

    static const int kU8NumberOfAudioServiceComponents = 5;

    /**
     * Clears the field "u8NumberOfAudioServiceComponents".
     *
     * The field will be set to its default value. The hasU8NumberOfAudioServiceComponents()
     * method will return false.
     */
    inline void clearU8NumberOfAudioServiceComponents();

    /**
     * Checks whether the field "u8NumberOfAudioServiceComponents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfAudioServiceComponents()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfAudioServiceComponents () const;

    /**
     * Returns the value of the member "u8NumberOfAudioServiceComponents".
     *
     * The number of audio service component (Services contains service components (audio and/or data or only one of both)).
     *
     * @return The value of the field "u8NumberOfAudioServiceComponents"
     */
    inline uint8 getU8NumberOfAudioServiceComponents () const;

    /**
     * Sets the value of the member "u8NumberOfAudioServiceComponents".
     *
     * The number of audio service component (Services contains service components (audio and/or data or only one of both)).
     *
     * @param u8NumberOfAudioServiceComponents The value which will be set
     */
    inline void setU8NumberOfAudioServiceComponents (uint8 u8NumberOfAudioServiceComponents_);

    // API of field "u8NumberOfDataServiceComponents"

    static const int kU8NumberOfDataServiceComponents = 6;

    /**
     * Clears the field "u8NumberOfDataServiceComponents".
     *
     * The field will be set to its default value. The hasU8NumberOfDataServiceComponents()
     * method will return false.
     */
    inline void clearU8NumberOfDataServiceComponents();

    /**
     * Checks whether the field "u8NumberOfDataServiceComponents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfDataServiceComponents()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfDataServiceComponents () const;

    /**
     * Returns the value of the member "u8NumberOfDataServiceComponents".
     *
     * The number of data service components (Services contains service components (audio and/or data or only one of both)).
     *
     * @return The value of the field "u8NumberOfDataServiceComponents"
     */
    inline uint8 getU8NumberOfDataServiceComponents () const;

    /**
     * Sets the value of the member "u8NumberOfDataServiceComponents".
     *
     * The number of data service components (Services contains service components (audio and/or data or only one of both)).
     *
     * @param u8NumberOfDataServiceComponents The value which will be set
     */
    inline void setU8NumberOfDataServiceComponents (uint8 u8NumberOfDataServiceComponents_);

    // API of field "u8ReceptionQuality"

    static const int kU8ReceptionQuality = 7;

    /**
     * Clears the field "u8ReceptionQuality".
     *
     * The field will be set to its default value. The hasU8ReceptionQuality()
     * method will return false.
     */
    inline void clearU8ReceptionQuality();

    /**
     * Checks whether the field "u8ReceptionQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ReceptionQuality()). Otherwise it will return false.
     */
    inline bool hasU8ReceptionQuality () const;

    /**
     * Returns the value of the member "u8ReceptionQuality".
     *
     * Reception quality
     *
     * @return The value of the field "u8ReceptionQuality"
     */
    inline uint8 getU8ReceptionQuality () const;

    /**
     * Sets the value of the member "u8ReceptionQuality".
     *
     * Reception quality
     *
     * @param u8ReceptionQuality The value which will be set
     */
    inline void setU8ReceptionQuality (uint8 u8ReceptionQuality_);

    // API of field "u8NumberOfEnsembles"

    static const int kU8NumberOfEnsembles = 8;

    /**
     * Clears the field "u8NumberOfEnsembles".
     *
     * The field will be set to its default value. The hasU8NumberOfEnsembles()
     * method will return false.
     */
    inline void clearU8NumberOfEnsembles();

    /**
     * Checks whether the field "u8NumberOfEnsembles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfEnsembles()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfEnsembles () const;

    /**
     * Returns the value of the member "u8NumberOfEnsembles".
     *
     * The number of ensemble available in the adr database.
     *
     * @return The value of the field "u8NumberOfEnsembles"
     */
    inline uint8 getU8NumberOfEnsembles () const;

    /**
     * Sets the value of the member "u8NumberOfEnsembles".
     *
     * The number of ensemble available in the adr database.
     *
     * @param u8NumberOfEnsembles The value which will be set
     */
    inline void setU8NumberOfEnsembles (uint8 u8NumberOfEnsembles_);

    // API of field "u8ListElementId"

    static const int kU8ListElementId = 9;

    /**
     * Clears the field "u8ListElementId".
     *
     * The field will be set to its default value. The hasU8ListElementId()
     * method will return false.
     */
    inline void clearU8ListElementId();

    /**
     * Checks whether the field "u8ListElementId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ListElementId()). Otherwise it will return false.
     */
    inline bool hasU8ListElementId () const;

    /**
     * Returns the value of the member "u8ListElementId".
     *
     * The id/index of current ensemble in the frozen list.
     *
     * @return The value of the field "u8ListElementId"
     */
    inline uint8 getU8ListElementId () const;

    /**
     * Sets the value of the member "u8ListElementId".
     *
     * The id/index of current ensemble in the frozen list.
     *
     * @param u8ListElementId The value which will be set
     */
    inline void setU8ListElementId (uint8 u8ListElementId_);

    // API of field "bReception"

    static const int kBReception = 10;

    /**
     * Clears the field "bReception".
     *
     * The field will be set to its default value. The hasBReception()
     * method will return false.
     */
    inline void clearBReception();

    /**
     * Checks whether the field "bReception" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReception()). Otherwise it will return false.
     */
    inline bool hasBReception () const;

    /**
     * Returns the value of the member "bReception".
     *
     * TRUE if reception is expected to be OK
     *
     * @return The value of the field "bReception"
     */
    inline bool getBReception () const;

    /**
     * Sets the value of the member "bReception".
     *
     * TRUE if reception is expected to be OK
     *
     * @param bReception The value which will be set
     */
    inline void setBReception (bool bReception_);

    static const T_DAB_EnsembleInfo &getDefaultInstance();

private:

    inline void set_has_u32EnsembleId ();

    inline void clear_has_u32EnsembleId ();

    inline void set_has_EnsembleLabel ();

    inline void clear_has_EnsembleLabel ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u8NumberOfAudioServices ();

    inline void clear_has_u8NumberOfAudioServices ();

    inline void set_has_u8NumberOfDataServices ();

    inline void clear_has_u8NumberOfDataServices ();

    inline void set_has_u8NumberOfAudioServiceComponents ();

    inline void clear_has_u8NumberOfAudioServiceComponents ();

    inline void set_has_u8NumberOfDataServiceComponents ();

    inline void clear_has_u8NumberOfDataServiceComponents ();

    inline void set_has_u8ReceptionQuality ();

    inline void clear_has_u8ReceptionQuality ();

    inline void set_has_u8NumberOfEnsembles ();

    inline void clear_has_u8NumberOfEnsembles ();

    inline void set_has_u8ListElementId ();

    inline void clear_has_u8ListElementId ();

    inline void set_has_bReception ();

    inline void clear_has_bReception ();

    uint32 _has_bits_[ (11 + 31) / 32];

    uint32 _u32EnsembleId;

    T_DAB_Label _EnsembleLabel;

    uint32 _u32Frequency;

    uint8 _u8NumberOfAudioServices;

    uint8 _u8NumberOfDataServices;

    uint8 _u8NumberOfAudioServiceComponents;

    uint8 _u8NumberOfDataServiceComponents;

    uint8 _u8ReceptionQuality;

    uint8 _u8NumberOfEnsembles;

    uint8 _u8ListElementId;

    bool _bReception;

};

/**
 * Flags related to service data
 */
class T_b8_DAB_ServiceInfoFlags {
public:

    /**
     * Default constructor
     */
    inline  T_b8_DAB_ServiceInfoFlags ();

    /**
     * Copy constructor
     */
    inline  T_b8_DAB_ServiceInfoFlags (const T_b8_DAB_ServiceInfoFlags &c);

    /**
     * Field constructor
     */
    inline  T_b8_DAB_ServiceInfoFlags (bool DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT, bool DAB_SERVICEINFO_TMC_COMPONENT, bool DAB_SERVICEINFO_DRC, bool DAB_SERVICEINFO_b3_reserved, bool DAB_SERVICEINFO_b4_reserved, bool DAB_SERVICEINFO_b5_reserved, bool DAB_SERVICEINFO_b6_reserved, bool DAB_SERVICEINFO_b7_reserved);

    /**
     * Assignment operator
     */
    inline T_b8_DAB_ServiceInfoFlags& operator = (const T_b8_DAB_ServiceInfoFlags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_DAB_ServiceInfoFlags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_DAB_ServiceInfoFlags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_DAB_ServiceInfoFlags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_DAB_ServiceInfoFlags& rhs) const;

    /**
     * Sets the value of the member "DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT".
     *
     * If the meaning of "DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT The value which will be set
     */
    inline void setDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT (bool DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT);

    /**
     * Returns the value of the member "DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT".
     *
     * If the meaning of "DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT"
     */
    inline bool getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT () const;

    /**
     * Sets the value of the member "DAB_SERVICEINFO_TMC_COMPONENT".
     *
     * If the meaning of "DAB_SERVICEINFO_TMC_COMPONENT" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICEINFO_TMC_COMPONENT The value which will be set
     */
    inline void setDAB_SERVICEINFO_TMC_COMPONENT (bool DAB_SERVICEINFO_TMC_COMPONENT);

    /**
     * Returns the value of the member "DAB_SERVICEINFO_TMC_COMPONENT".
     *
     * If the meaning of "DAB_SERVICEINFO_TMC_COMPONENT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICEINFO_TMC_COMPONENT"
     */
    inline bool getDAB_SERVICEINFO_TMC_COMPONENT () const;

    /**
     * Sets the value of the member "DAB_SERVICEINFO_DRC".
     *
     * If the meaning of "DAB_SERVICEINFO_DRC" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICEINFO_DRC The value which will be set
     */
    inline void setDAB_SERVICEINFO_DRC (bool DAB_SERVICEINFO_DRC);

    /**
     * Returns the value of the member "DAB_SERVICEINFO_DRC".
     *
     * If the meaning of "DAB_SERVICEINFO_DRC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICEINFO_DRC"
     */
    inline bool getDAB_SERVICEINFO_DRC () const;

    /**
     * Sets the value of the member "DAB_SERVICEINFO_b3_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b3_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICEINFO_b3_reserved The value which will be set
     */
    inline void setDAB_SERVICEINFO_b3_reserved (bool DAB_SERVICEINFO_b3_reserved);

    /**
     * Returns the value of the member "DAB_SERVICEINFO_b3_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b3_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICEINFO_b3_reserved"
     */
    inline bool getDAB_SERVICEINFO_b3_reserved () const;

    /**
     * Sets the value of the member "DAB_SERVICEINFO_b4_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b4_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICEINFO_b4_reserved The value which will be set
     */
    inline void setDAB_SERVICEINFO_b4_reserved (bool DAB_SERVICEINFO_b4_reserved);

    /**
     * Returns the value of the member "DAB_SERVICEINFO_b4_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b4_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICEINFO_b4_reserved"
     */
    inline bool getDAB_SERVICEINFO_b4_reserved () const;

    /**
     * Sets the value of the member "DAB_SERVICEINFO_b5_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b5_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICEINFO_b5_reserved The value which will be set
     */
    inline void setDAB_SERVICEINFO_b5_reserved (bool DAB_SERVICEINFO_b5_reserved);

    /**
     * Returns the value of the member "DAB_SERVICEINFO_b5_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b5_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICEINFO_b5_reserved"
     */
    inline bool getDAB_SERVICEINFO_b5_reserved () const;

    /**
     * Sets the value of the member "DAB_SERVICEINFO_b6_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b6_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICEINFO_b6_reserved The value which will be set
     */
    inline void setDAB_SERVICEINFO_b6_reserved (bool DAB_SERVICEINFO_b6_reserved);

    /**
     * Returns the value of the member "DAB_SERVICEINFO_b6_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b6_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICEINFO_b6_reserved"
     */
    inline bool getDAB_SERVICEINFO_b6_reserved () const;

    /**
     * Sets the value of the member "DAB_SERVICEINFO_b7_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b7_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SERVICEINFO_b7_reserved The value which will be set
     */
    inline void setDAB_SERVICEINFO_b7_reserved (bool DAB_SERVICEINFO_b7_reserved);

    /**
     * Returns the value of the member "DAB_SERVICEINFO_b7_reserved".
     *
     * If the meaning of "DAB_SERVICEINFO_b7_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SERVICEINFO_b7_reserved"
     */
    inline bool getDAB_SERVICEINFO_b7_reserved () const;

    static const T_b8_DAB_ServiceInfoFlags &getDefaultInstance();

private:

    bool _DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT:1;

    bool _DAB_SERVICEINFO_TMC_COMPONENT:1;

    bool _DAB_SERVICEINFO_DRC:1;

    bool _DAB_SERVICEINFO_b3_reserved:1;

    bool _DAB_SERVICEINFO_b4_reserved:1;

    bool _DAB_SERVICEINFO_b5_reserved:1;

    bool _DAB_SERVICEINFO_b6_reserved:1;

    bool _DAB_SERVICEINFO_b7_reserved:1;

};

/**
 * DAB current service information is contained in this structure .
 */
class T_DAB_ServiceInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_ServiceInfo ();

    /**
     * Copy constructor
     */
    inline  T_DAB_ServiceInfo (const T_DAB_ServiceInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_ServiceInfo (uint32 u32ServId_, const T_DAB_Label& ServiceLabel_, T_e8_DAB_ServiceType e8ServiceType_, uint8 u8NumberOfAudioComponents_, uint8 u8NumberOfDataComponents_, const T_b16_DAB_AnnouncementType& b16AvailableAnnoTypesMask_, uint8 u8SampleRate_, uint16 u16BitRate_, const ::std::string& sAudioMode_, const ::std::string& sAdvancedAudioCodec_, const ::std::string& sAudioCodec_, const T_b8_DAB_ServiceInfoFlags& b8Flags_, uint8 u8PresetListElementID_, uint16 u16ServiceIndex_, uint8 u8PTYCode_, T_e8_DAB_Encoding e8EncodingType_);

    /**
     * Destructor
     */
    inline  ~T_DAB_ServiceInfo();

    /**
     * Assignment operator
     */
    inline T_DAB_ServiceInfo& operator = (const T_DAB_ServiceInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_ServiceInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_ServiceInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_ServiceInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_ServiceInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ServId"

    static const int kU32ServId = 0;

    /**
     * Clears the field "u32ServId".
     *
     * The field will be set to its default value. The hasU32ServId()
     * method will return false.
     */
    inline void clearU32ServId();

    /**
     * Checks whether the field "u32ServId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ServId()). Otherwise it will return false.
     */
    inline bool hasU32ServId () const;

    /**
     * Returns the value of the member "u32ServId".
     *
     * Service Id.
     *
     * @return The value of the field "u32ServId"
     */
    inline uint32 getU32ServId () const;

    /**
     * Sets the value of the member "u32ServId".
     *
     * Service Id.
     *
     * @param u32ServId The value which will be set
     */
    inline void setU32ServId (uint32 u32ServId_);

    // API of field "ServiceLabel"

    static const int kServiceLabel = 1;

    /**
     * Clears the field "ServiceLabel".
     *
     * The field will be set to its default value. The hasServiceLabel()
     * method will return false.
     */
    inline void clearServiceLabel();

    /**
     * Checks whether the field "ServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceLabel()). Otherwise it will return false.
     */
    inline bool hasServiceLabel () const;

    /**
     * Returns the value of the member "ServiceLabel".
     *
     * Service label.
     *
     * @return The value of the field "ServiceLabel"
     */
    inline const T_DAB_Label& getServiceLabel () const;

    /**
     * Retrieves the value of the field "ServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ServiceLabel".
     */
    inline T_DAB_Label& getServiceLabelMutable ();

    /**
     * Sets the value of the member "ServiceLabel".
     *
     * Service label.
     *
     * @param ServiceLabel The value which will be set
     */
    inline void setServiceLabel (const T_DAB_Label& ServiceLabel_);

    // API of field "e8ServiceType"

    static const int kE8ServiceType = 2;

    /**
     * Clears the field "e8ServiceType".
     *
     * The field will be set to its default value. The hasE8ServiceType()
     * method will return false.
     */
    inline void clearE8ServiceType();

    /**
     * Checks whether the field "e8ServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceType()). Otherwise it will return false.
     */
    inline bool hasE8ServiceType () const;

    /**
     * Returns the value of the member "e8ServiceType".
     *
     * Service type.
     *
     * @return The value of the field "e8ServiceType"
     */
    inline T_e8_DAB_ServiceType getE8ServiceType () const;

    /**
     * Sets the value of the member "e8ServiceType".
     *
     * Service type.
     *
     * @param e8ServiceType The value which will be set
     */
    inline void setE8ServiceType (T_e8_DAB_ServiceType e8ServiceType_);

    // API of field "u8NumberOfAudioComponents"

    static const int kU8NumberOfAudioComponents = 3;

    /**
     * Clears the field "u8NumberOfAudioComponents".
     *
     * The field will be set to its default value. The hasU8NumberOfAudioComponents()
     * method will return false.
     */
    inline void clearU8NumberOfAudioComponents();

    /**
     * Checks whether the field "u8NumberOfAudioComponents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfAudioComponents()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfAudioComponents () const;

    /**
     * Returns the value of the member "u8NumberOfAudioComponents".
     *
     * The number of audio components in the service. If u8NumberOfAudioComponents>1 this service has
     * secondary components.
     *
     * @return The value of the field "u8NumberOfAudioComponents"
     */
    inline uint8 getU8NumberOfAudioComponents () const;

    /**
     * Sets the value of the member "u8NumberOfAudioComponents".
     *
     * The number of audio components in the service. If u8NumberOfAudioComponents>1 this service has
     * secondary components.
     *
     * @param u8NumberOfAudioComponents The value which will be set
     */
    inline void setU8NumberOfAudioComponents (uint8 u8NumberOfAudioComponents_);

    // API of field "u8NumberOfDataComponents"

    static const int kU8NumberOfDataComponents = 4;

    /**
     * Clears the field "u8NumberOfDataComponents".
     *
     * The field will be set to its default value. The hasU8NumberOfDataComponents()
     * method will return false.
     */
    inline void clearU8NumberOfDataComponents();

    /**
     * Checks whether the field "u8NumberOfDataComponents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfDataComponents()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfDataComponents () const;

    /**
     * Returns the value of the member "u8NumberOfDataComponents".
     *
     * The number of data components in the service.
     *
     * @return The value of the field "u8NumberOfDataComponents"
     */
    inline uint8 getU8NumberOfDataComponents () const;

    /**
     * Sets the value of the member "u8NumberOfDataComponents".
     *
     * The number of data components in the service.
     *
     * @param u8NumberOfDataComponents The value which will be set
     */
    inline void setU8NumberOfDataComponents (uint8 u8NumberOfDataComponents_);

    // API of field "b16AvailableAnnoTypesMask"

    static const int kB16AvailableAnnoTypesMask = 5;

    /**
     * Clears the field "b16AvailableAnnoTypesMask".
     *
     * The field will be set to its default value. The hasB16AvailableAnnoTypesMask()
     * method will return false.
     */
    inline void clearB16AvailableAnnoTypesMask();

    /**
     * Checks whether the field "b16AvailableAnnoTypesMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB16AvailableAnnoTypesMask()). Otherwise it will return false.
     */
    inline bool hasB16AvailableAnnoTypesMask () const;

    /**
     * Returns the value of the member "b16AvailableAnnoTypesMask".
     *
     * Supported announcements for this service. The announcement types are coded bitwise.
     *
     * @return The value of the field "b16AvailableAnnoTypesMask"
     */
    inline const T_b16_DAB_AnnouncementType& getB16AvailableAnnoTypesMask () const;

    /**
     * Retrieves the value of the field "b16AvailableAnnoTypesMask" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b16AvailableAnnoTypesMask".
     */
    inline T_b16_DAB_AnnouncementType& getB16AvailableAnnoTypesMaskMutable ();

    /**
     * Sets the value of the member "b16AvailableAnnoTypesMask".
     *
     * Supported announcements for this service. The announcement types are coded bitwise.
     *
     * @param b16AvailableAnnoTypesMask The value which will be set
     */
    inline void setB16AvailableAnnoTypesMask (const T_b16_DAB_AnnouncementType& b16AvailableAnnoTypesMask_);

    // API of field "u8SampleRate"

    static const int kU8SampleRate = 6;

    /**
     * Clears the field "u8SampleRate".
     *
     * The field will be set to its default value. The hasU8SampleRate()
     * method will return false.
     */
    inline void clearU8SampleRate();

    /**
     * Checks whether the field "u8SampleRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SampleRate()). Otherwise it will return false.
     */
    inline bool hasU8SampleRate () const;

    /**
     * Returns the value of the member "u8SampleRate".
     *
     * Sample rate. Value in kHz.
     *
     * @return The value of the field "u8SampleRate"
     */
    inline uint8 getU8SampleRate () const;

    /**
     * Sets the value of the member "u8SampleRate".
     *
     * Sample rate. Value in kHz.
     *
     * @param u8SampleRate The value which will be set
     */
    inline void setU8SampleRate (uint8 u8SampleRate_);

    // API of field "u16BitRate"

    static const int kU16BitRate = 7;

    /**
     * Clears the field "u16BitRate".
     *
     * The field will be set to its default value. The hasU16BitRate()
     * method will return false.
     */
    inline void clearU16BitRate();

    /**
     * Checks whether the field "u16BitRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16BitRate()). Otherwise it will return false.
     */
    inline bool hasU16BitRate () const;

    /**
     * Returns the value of the member "u16BitRate".
     *
     * Bit rate. Value in kBits/s.
     *
     * @return The value of the field "u16BitRate"
     */
    inline uint16 getU16BitRate () const;

    /**
     * Sets the value of the member "u16BitRate".
     *
     * Bit rate. Value in kBits/s.
     *
     * @param u16BitRate The value which will be set
     */
    inline void setU16BitRate (uint16 u16BitRate_);

    // API of field "sAudioMode"

    static const int kSAudioMode = 8;

    /**
     * Clears the field "sAudioMode".
     *
     * The field will be set to its default value. The hasSAudioMode()
     * method will return false.
     */
    inline void clearSAudioMode();

    /**
     * Checks whether the field "sAudioMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAudioMode()). Otherwise it will return false.
     */
    inline bool hasSAudioMode () const;

    /**
     * Returns the value of the member "sAudioMode".
     *
     * Audio mode. for example ST(Stereo), JT(Joint Stereo), DC(Dual Stereo) and SC(Single Channel)
     *
     * @return The value of the field "sAudioMode"
     */
    inline const ::std::string& getSAudioMode () const;

    /**
     * Retrieves the value of the field "sAudioMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAudioMode".
     */
    inline ::std::string& getSAudioModeMutable ();

    /**
     * Sets the value of the member "sAudioMode".
     *
     * Audio mode. for example ST(Stereo), JT(Joint Stereo), DC(Dual Stereo) and SC(Single Channel)
     *
     * @param sAudioMode The value which will be set
     */
    inline void setSAudioMode (const ::std::string& sAudioMode_);

    /**
     * Sets the value of the member "sAudioMode".
     *
     * Audio mode. for example ST(Stereo), JT(Joint Stereo), DC(Dual Stereo) and SC(Single Channel)
     *
     * @param sAudioMode The value which will be set
     */
    inline void setSAudioMode (const char* sAudioMode_);

    /**
     * Sets the value of the member "sAudioMode".
     *
     * Audio mode. for example ST(Stereo), JT(Joint Stereo), DC(Dual Stereo) and SC(Single Channel)
     *
     * @param sAudioMode The value which will be set
     */
    inline void setSAudioMode (const char* value, size_t size);

    // API of field "sAdvancedAudioCodec"

    static const int kSAdvancedAudioCodec = 9;

    /**
     * Clears the field "sAdvancedAudioCodec".
     *
     * The field will be set to its default value. The hasSAdvancedAudioCodec()
     * method will return false.
     */
    inline void clearSAdvancedAudioCodec();

    /**
     * Checks whether the field "sAdvancedAudioCodec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAdvancedAudioCodec()). Otherwise it will return false.
     */
    inline bool hasSAdvancedAudioCodec () const;

    /**
     * Returns the value of the member "sAdvancedAudioCodec".
     *
     * Audio mode. for example SBR(Spectral Band Replication, PS(Parametric stereo) or none (--).
     *
     * @return The value of the field "sAdvancedAudioCodec"
     */
    inline const ::std::string& getSAdvancedAudioCodec () const;

    /**
     * Retrieves the value of the field "sAdvancedAudioCodec" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAdvancedAudioCodec".
     */
    inline ::std::string& getSAdvancedAudioCodecMutable ();

    /**
     * Sets the value of the member "sAdvancedAudioCodec".
     *
     * Audio mode. for example SBR(Spectral Band Replication, PS(Parametric stereo) or none (--).
     *
     * @param sAdvancedAudioCodec The value which will be set
     */
    inline void setSAdvancedAudioCodec (const ::std::string& sAdvancedAudioCodec_);

    /**
     * Sets the value of the member "sAdvancedAudioCodec".
     *
     * Audio mode. for example SBR(Spectral Band Replication, PS(Parametric stereo) or none (--).
     *
     * @param sAdvancedAudioCodec The value which will be set
     */
    inline void setSAdvancedAudioCodec (const char* sAdvancedAudioCodec_);

    /**
     * Sets the value of the member "sAdvancedAudioCodec".
     *
     * Audio mode. for example SBR(Spectral Band Replication, PS(Parametric stereo) or none (--).
     *
     * @param sAdvancedAudioCodec The value which will be set
     */
    inline void setSAdvancedAudioCodec (const char* value, size_t size);

    // API of field "sAudioCodec"

    static const int kSAudioCodec = 10;

    /**
     * Clears the field "sAudioCodec".
     *
     * The field will be set to its default value. The hasSAudioCodec()
     * method will return false.
     */
    inline void clearSAudioCodec();

    /**
     * Checks whether the field "sAudioCodec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAudioCodec()). Otherwise it will return false.
     */
    inline bool hasSAudioCodec () const;

    /**
     * Returns the value of the member "sAudioCodec".
     *
     * Audio codec. maximum string length is 5. For example MPEG, DAB+, DMBA, DMBV and NR (not recognized)
     *
     * @return The value of the field "sAudioCodec"
     */
    inline const ::std::string& getSAudioCodec () const;

    /**
     * Retrieves the value of the field "sAudioCodec" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAudioCodec".
     */
    inline ::std::string& getSAudioCodecMutable ();

    /**
     * Sets the value of the member "sAudioCodec".
     *
     * Audio codec. maximum string length is 5. For example MPEG, DAB+, DMBA, DMBV and NR (not recognized)
     *
     * @param sAudioCodec The value which will be set
     */
    inline void setSAudioCodec (const ::std::string& sAudioCodec_);

    /**
     * Sets the value of the member "sAudioCodec".
     *
     * Audio codec. maximum string length is 5. For example MPEG, DAB+, DMBA, DMBV and NR (not recognized)
     *
     * @param sAudioCodec The value which will be set
     */
    inline void setSAudioCodec (const char* sAudioCodec_);

    /**
     * Sets the value of the member "sAudioCodec".
     *
     * Audio codec. maximum string length is 5. For example MPEG, DAB+, DMBA, DMBV and NR (not recognized)
     *
     * @param sAudioCodec The value which will be set
     */
    inline void setSAudioCodec (const char* value, size_t size);

    // API of field "b8Flags"

    static const int kB8Flags = 11;

    /**
     * Clears the field "b8Flags".
     *
     * The field will be set to its default value. The hasB8Flags()
     * method will return false.
     */
    inline void clearB8Flags();

    /**
     * Checks whether the field "b8Flags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8Flags()). Otherwise it will return false.
     */
    inline bool hasB8Flags () const;

    /**
     * Returns the value of the member "b8Flags".
     *
     * The flags indicating the properties of the service
     *
     * @return The value of the field "b8Flags"
     */
    inline const T_b8_DAB_ServiceInfoFlags& getB8Flags () const;

    /**
     * Retrieves the value of the field "b8Flags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8Flags".
     */
    inline T_b8_DAB_ServiceInfoFlags& getB8FlagsMutable ();

    /**
     * Sets the value of the member "b8Flags".
     *
     * The flags indicating the properties of the service
     *
     * @param b8Flags The value which will be set
     */
    inline void setB8Flags (const T_b8_DAB_ServiceInfoFlags& b8Flags_);

    // API of field "u8PresetListElementID"

    static const int kU8PresetListElementID = 12;

    /**
     * Clears the field "u8PresetListElementID".
     *
     * The field will be set to its default value. The hasU8PresetListElementID()
     * method will return false.
     */
    inline void clearU8PresetListElementID();

    /**
     * Checks whether the field "u8PresetListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PresetListElementID()). Otherwise it will return false.
     */
    inline bool hasU8PresetListElementID () const;

    /**
     * Returns the value of the member "u8PresetListElementID".
     *
     * If the current service is available as preset the first matching preset will be delivered.
     * Otherwise the value will be zero. If the last action was a preset activation, the
     * activated preset ID will be returned.
     *
     * @return The value of the field "u8PresetListElementID"
     */
    inline uint8 getU8PresetListElementID () const;

    /**
     * Sets the value of the member "u8PresetListElementID".
     *
     * If the current service is available as preset the first matching preset will be delivered.
     * Otherwise the value will be zero. If the last action was a preset activation, the
     * activated preset ID will be returned.
     *
     * @param u8PresetListElementID The value which will be set
     */
    inline void setU8PresetListElementID (uint8 u8PresetListElementID_);

    // API of field "u16ServiceIndex"

    static const int kU16ServiceIndex = 13;

    /**
     * Clears the field "u16ServiceIndex".
     *
     * The field will be set to its default value. The hasU16ServiceIndex()
     * method will return false.
     */
    inline void clearU16ServiceIndex();

    /**
     * Checks whether the field "u16ServiceIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ServiceIndex()). Otherwise it will return false.
     */
    inline bool hasU16ServiceIndex () const;

    /**
     * Returns the value of the member "u16ServiceIndex".
     *
     * Holds the index of the current service.
     *
     * @return The value of the field "u16ServiceIndex"
     */
    inline uint16 getU16ServiceIndex () const;

    /**
     * Sets the value of the member "u16ServiceIndex".
     *
     * Holds the index of the current service.
     *
     * @param u16ServiceIndex The value which will be set
     */
    inline void setU16ServiceIndex (uint16 u16ServiceIndex_);

    // API of field "u8PTYCode"

    static const int kU8PTYCode = 14;

    /**
     * Clears the field "u8PTYCode".
     *
     * The field will be set to its default value. The hasU8PTYCode()
     * method will return false.
     */
    inline void clearU8PTYCode();

    /**
     * Checks whether the field "u8PTYCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PTYCode()). Otherwise it will return false.
     */
    inline bool hasU8PTYCode () const;

    /**
     * Returns the value of the member "u8PTYCode".
     *
     * Holds the PTY Code of the current service.
     *
     * @return The value of the field "u8PTYCode"
     */
    inline uint8 getU8PTYCode () const;

    /**
     * Sets the value of the member "u8PTYCode".
     *
     * Holds the PTY Code of the current service.
     *
     * @param u8PTYCode The value which will be set
     */
    inline void setU8PTYCode (uint8 u8PTYCode_);

    // API of field "e8EncodingType"

    static const int kE8EncodingType = 15;

    /**
     * Clears the field "e8EncodingType".
     *
     * The field will be set to its default value. The hasE8EncodingType()
     * method will return false.
     */
    inline void clearE8EncodingType();

    /**
     * Checks whether the field "e8EncodingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EncodingType()). Otherwise it will return false.
     */
    inline bool hasE8EncodingType () const;

    /**
     * Returns the value of the member "e8EncodingType".
     *
     * gives teh encoding type
     *
     * @return The value of the field "e8EncodingType"
     */
    inline T_e8_DAB_Encoding getE8EncodingType () const;

    /**
     * Sets the value of the member "e8EncodingType".
     *
     * gives teh encoding type
     *
     * @param e8EncodingType The value which will be set
     */
    inline void setE8EncodingType (T_e8_DAB_Encoding e8EncodingType_);

    static const T_DAB_ServiceInfo &getDefaultInstance();

private:

    inline void set_has_u32ServId ();

    inline void clear_has_u32ServId ();

    inline void set_has_ServiceLabel ();

    inline void clear_has_ServiceLabel ();

    inline void set_has_e8ServiceType ();

    inline void clear_has_e8ServiceType ();

    inline void set_has_u8NumberOfAudioComponents ();

    inline void clear_has_u8NumberOfAudioComponents ();

    inline void set_has_u8NumberOfDataComponents ();

    inline void clear_has_u8NumberOfDataComponents ();

    inline void set_has_b16AvailableAnnoTypesMask ();

    inline void clear_has_b16AvailableAnnoTypesMask ();

    inline void set_has_u8SampleRate ();

    inline void clear_has_u8SampleRate ();

    inline void set_has_u16BitRate ();

    inline void clear_has_u16BitRate ();

    inline void set_has_sAudioMode ();

    inline void clear_has_sAudioMode ();

    inline void set_has_sAdvancedAudioCodec ();

    inline void clear_has_sAdvancedAudioCodec ();

    inline void set_has_sAudioCodec ();

    inline void clear_has_sAudioCodec ();

    inline void set_has_b8Flags ();

    inline void clear_has_b8Flags ();

    inline void set_has_u8PresetListElementID ();

    inline void clear_has_u8PresetListElementID ();

    inline void set_has_u16ServiceIndex ();

    inline void clear_has_u16ServiceIndex ();

    inline void set_has_u8PTYCode ();

    inline void clear_has_u8PTYCode ();

    inline void set_has_e8EncodingType ();

    inline void clear_has_e8EncodingType ();

    uint32 _has_bits_[ (16 + 31) / 32];

    uint32 _u32ServId;

    T_DAB_Label _ServiceLabel;

    T_e8_DAB_ServiceType _e8ServiceType;

    uint8 _u8NumberOfAudioComponents;

    uint8 _u8NumberOfDataComponents;

    T_b16_DAB_AnnouncementType _b16AvailableAnnoTypesMask;

    uint8 _u8SampleRate;

    uint16 _u16BitRate;

    ::std::string _sAudioMode;

    ::std::string _sAdvancedAudioCodec;

    ::std::string _sAudioCodec;

    T_b8_DAB_ServiceInfoFlags _b8Flags;

    uint8 _u8PresetListElementID;

    uint16 _u16ServiceIndex;

    uint8 _u8PTYCode;

    T_e8_DAB_Encoding _e8EncodingType;

};

/**
 * DAB service information for main-sceen .
 */
class T_DAB_ChannelInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_ChannelInfo ();

    /**
     * Copy constructor
     */
    inline  T_DAB_ChannelInfo (const T_DAB_ChannelInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_ChannelInfo (uint32 u32ServId_, T_e8_DAB_ChannelInfoState enState_, const T_DAB_Label& ServiceLabel_, uint8 u8NumberOfAudioComponents_, const T_b16_DAB_AnnouncementType& b16AvailableAnnoTypesMask_, uint8 u8PresetListElementID_, bool bComponentMode_, bool bFmServiceFollowActive_, uint16 u16FrozenListElementID_, const T_DAB_RadioText& rRadioText_, uint8 u8NumberOfDLPElements_, const ::std::vector< T_DAB_RadioTextPlus >& DLPlusList_, bool bMuted_, bool bAFAvailable_, const ::std::string& sLogoLink_, uint8 u8ScidsValue_);

    /**
     * Destructor
     */
    inline  ~T_DAB_ChannelInfo();

    /**
     * Assignment operator
     */
    inline T_DAB_ChannelInfo& operator = (const T_DAB_ChannelInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_ChannelInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_ChannelInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_ChannelInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_ChannelInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ServId"

    static const int kU32ServId = 0;

    /**
     * Clears the field "u32ServId".
     *
     * The field will be set to its default value. The hasU32ServId()
     * method will return false.
     */
    inline void clearU32ServId();

    /**
     * Checks whether the field "u32ServId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ServId()). Otherwise it will return false.
     */
    inline bool hasU32ServId () const;

    /**
     * Returns the value of the member "u32ServId".
     *
     * Service Id.
     *
     * @return The value of the field "u32ServId"
     */
    inline uint32 getU32ServId () const;

    /**
     * Sets the value of the member "u32ServId".
     *
     * Service Id.
     *
     * @param u32ServId The value which will be set
     */
    inline void setU32ServId (uint32 u32ServId_);

    // API of field "enState"

    static const int kEnState = 1;

    /**
     * Clears the field "enState".
     *
     * The field will be set to its default value. The hasEnState()
     * method will return false.
     */
    inline void clearEnState();

    /**
     * Checks whether the field "enState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnState()). Otherwise it will return false.
     */
    inline bool hasEnState () const;

    /**
     * Returns the value of the member "enState".
     *
     * The current state of the channel, see definition of DAB_ChannelInfoState
     *
     * @return The value of the field "enState"
     */
    inline T_e8_DAB_ChannelInfoState getEnState () const;

    /**
     * Sets the value of the member "enState".
     *
     * The current state of the channel, see definition of DAB_ChannelInfoState
     *
     * @param enState The value which will be set
     */
    inline void setEnState (T_e8_DAB_ChannelInfoState enState_);

    // API of field "ServiceLabel"

    static const int kServiceLabel = 2;

    /**
     * Clears the field "ServiceLabel".
     *
     * The field will be set to its default value. The hasServiceLabel()
     * method will return false.
     */
    inline void clearServiceLabel();

    /**
     * Checks whether the field "ServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceLabel()). Otherwise it will return false.
     */
    inline bool hasServiceLabel () const;

    /**
     * Returns the value of the member "ServiceLabel".
     *
     * Service label.
     *
     * @return The value of the field "ServiceLabel"
     */
    inline const T_DAB_Label& getServiceLabel () const;

    /**
     * Retrieves the value of the field "ServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ServiceLabel".
     */
    inline T_DAB_Label& getServiceLabelMutable ();

    /**
     * Sets the value of the member "ServiceLabel".
     *
     * Service label.
     *
     * @param ServiceLabel The value which will be set
     */
    inline void setServiceLabel (const T_DAB_Label& ServiceLabel_);

    // API of field "u8NumberOfAudioComponents"

    static const int kU8NumberOfAudioComponents = 3;

    /**
     * Clears the field "u8NumberOfAudioComponents".
     *
     * The field will be set to its default value. The hasU8NumberOfAudioComponents()
     * method will return false.
     */
    inline void clearU8NumberOfAudioComponents();

    /**
     * Checks whether the field "u8NumberOfAudioComponents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfAudioComponents()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfAudioComponents () const;

    /**
     * Returns the value of the member "u8NumberOfAudioComponents".
     *
     * The number of audio components in the service. If u8NumberOfAudioComponents>1 this service has
     * secondary components.
     *
     * @return The value of the field "u8NumberOfAudioComponents"
     */
    inline uint8 getU8NumberOfAudioComponents () const;

    /**
     * Sets the value of the member "u8NumberOfAudioComponents".
     *
     * The number of audio components in the service. If u8NumberOfAudioComponents>1 this service has
     * secondary components.
     *
     * @param u8NumberOfAudioComponents The value which will be set
     */
    inline void setU8NumberOfAudioComponents (uint8 u8NumberOfAudioComponents_);

    // API of field "b16AvailableAnnoTypesMask"

    static const int kB16AvailableAnnoTypesMask = 4;

    /**
     * Clears the field "b16AvailableAnnoTypesMask".
     *
     * The field will be set to its default value. The hasB16AvailableAnnoTypesMask()
     * method will return false.
     */
    inline void clearB16AvailableAnnoTypesMask();

    /**
     * Checks whether the field "b16AvailableAnnoTypesMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB16AvailableAnnoTypesMask()). Otherwise it will return false.
     */
    inline bool hasB16AvailableAnnoTypesMask () const;

    /**
     * Returns the value of the member "b16AvailableAnnoTypesMask".
     *
     * Supported announcements for this service. The announcement types are coded bitwise.
     *
     * @return The value of the field "b16AvailableAnnoTypesMask"
     */
    inline const T_b16_DAB_AnnouncementType& getB16AvailableAnnoTypesMask () const;

    /**
     * Retrieves the value of the field "b16AvailableAnnoTypesMask" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b16AvailableAnnoTypesMask".
     */
    inline T_b16_DAB_AnnouncementType& getB16AvailableAnnoTypesMaskMutable ();

    /**
     * Sets the value of the member "b16AvailableAnnoTypesMask".
     *
     * Supported announcements for this service. The announcement types are coded bitwise.
     *
     * @param b16AvailableAnnoTypesMask The value which will be set
     */
    inline void setB16AvailableAnnoTypesMask (const T_b16_DAB_AnnouncementType& b16AvailableAnnoTypesMask_);

    // API of field "u8PresetListElementID"

    static const int kU8PresetListElementID = 5;

    /**
     * Clears the field "u8PresetListElementID".
     *
     * The field will be set to its default value. The hasU8PresetListElementID()
     * method will return false.
     */
    inline void clearU8PresetListElementID();

    /**
     * Checks whether the field "u8PresetListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PresetListElementID()). Otherwise it will return false.
     */
    inline bool hasU8PresetListElementID () const;

    /**
     * Returns the value of the member "u8PresetListElementID".
     *
     * If the current service is available as preset the first matching preset will be delivered.
     * Otherwise the value will be zero. If the last action was a preset activation, the
     * activated preset ID will be returned.
     *
     * @return The value of the field "u8PresetListElementID"
     */
    inline uint8 getU8PresetListElementID () const;

    /**
     * Sets the value of the member "u8PresetListElementID".
     *
     * If the current service is available as preset the first matching preset will be delivered.
     * Otherwise the value will be zero. If the last action was a preset activation, the
     * activated preset ID will be returned.
     *
     * @param u8PresetListElementID The value which will be set
     */
    inline void setU8PresetListElementID (uint8 u8PresetListElementID_);

    // API of field "bComponentMode"

    static const int kBComponentMode = 6;

    /**
     * Clears the field "bComponentMode".
     *
     * The field will be set to its default value. The hasBComponentMode()
     * method will return false.
     */
    inline void clearBComponentMode();

    /**
     * Checks whether the field "bComponentMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBComponentMode()). Otherwise it will return false.
     */
    inline bool hasBComponentMode () const;

    /**
     * Returns the value of the member "bComponentMode".
     *
     * TRUE if actual info is for a service-component.
     *
     * @return The value of the field "bComponentMode"
     */
    inline bool getBComponentMode () const;

    /**
     * Sets the value of the member "bComponentMode".
     *
     * TRUE if actual info is for a service-component.
     *
     * @param bComponentMode The value which will be set
     */
    inline void setBComponentMode (bool bComponentMode_);

    // API of field "bFmServiceFollowActive"

    static const int kBFmServiceFollowActive = 7;

    /**
     * Clears the field "bFmServiceFollowActive".
     *
     * The field will be set to its default value. The hasBFmServiceFollowActive()
     * method will return false.
     */
    inline void clearBFmServiceFollowActive();

    /**
     * Checks whether the field "bFmServiceFollowActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFmServiceFollowActive()). Otherwise it will return false.
     */
    inline bool hasBFmServiceFollowActive () const;

    /**
     * Returns the value of the member "bFmServiceFollowActive".
     *
     * TRUE if the actual channel is received via FM service following.
     *
     * @return The value of the field "bFmServiceFollowActive"
     */
    inline bool getBFmServiceFollowActive () const;

    /**
     * Sets the value of the member "bFmServiceFollowActive".
     *
     * TRUE if the actual channel is received via FM service following.
     *
     * @param bFmServiceFollowActive The value which will be set
     */
    inline void setBFmServiceFollowActive (bool bFmServiceFollowActive_);

    // API of field "u16FrozenListElementID"

    static const int kU16FrozenListElementID = 8;

    /**
     * Clears the field "u16FrozenListElementID".
     *
     * The field will be set to its default value. The hasU16FrozenListElementID()
     * method will return false.
     */
    inline void clearU16FrozenListElementID();

    /**
     * Checks whether the field "u16FrozenListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FrozenListElementID()). Otherwise it will return false.
     */
    inline bool hasU16FrozenListElementID () const;

    /**
     * Returns the value of the member "u16FrozenListElementID".
     *
     * If the service list of the current ensemble is active, the element id of the selected service will be
     * delivered. Otherwise the value will be zero.
     *
     * @return The value of the field "u16FrozenListElementID"
     */
    inline uint16 getU16FrozenListElementID () const;

    /**
     * Sets the value of the member "u16FrozenListElementID".
     *
     * If the service list of the current ensemble is active, the element id of the selected service will be
     * delivered. Otherwise the value will be zero.
     *
     * @param u16FrozenListElementID The value which will be set
     */
    inline void setU16FrozenListElementID (uint16 u16FrozenListElementID_);

    // API of field "rRadioText"

    static const int kRRadioText = 9;

    /**
     * Clears the field "rRadioText".
     *
     * The field will be set to its default value. The hasRRadioText()
     * method will return false.
     */
    inline void clearRRadioText();

    /**
     * Checks whether the field "rRadioText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRRadioText()). Otherwise it will return false.
     */
    inline bool hasRRadioText () const;

    /**
     * Returns the value of the member "rRadioText".
     *
     * The radio-text belonging to the service.
     *
     * @return The value of the field "rRadioText"
     */
    inline const T_DAB_RadioText& getRRadioText () const;

    /**
     * Retrieves the value of the field "rRadioText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rRadioText".
     */
    inline T_DAB_RadioText& getRRadioTextMutable ();

    /**
     * Sets the value of the member "rRadioText".
     *
     * The radio-text belonging to the service.
     *
     * @param rRadioText The value which will be set
     */
    inline void setRRadioText (const T_DAB_RadioText& rRadioText_);

    // API of field "u8NumberOfDLPElements"

    static const int kU8NumberOfDLPElements = 10;

    /**
     * Clears the field "u8NumberOfDLPElements".
     *
     * The field will be set to its default value. The hasU8NumberOfDLPElements()
     * method will return false.
     */
    inline void clearU8NumberOfDLPElements();

    /**
     * Checks whether the field "u8NumberOfDLPElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfDLPElements()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfDLPElements () const;

    /**
     * Returns the value of the member "u8NumberOfDLPElements".
     *
     * The total number of Radio Text Plus Elements.
     *
     * @return The value of the field "u8NumberOfDLPElements"
     */
    inline uint8 getU8NumberOfDLPElements () const;

    /**
     * Sets the value of the member "u8NumberOfDLPElements".
     *
     * The total number of Radio Text Plus Elements.
     *
     * @param u8NumberOfDLPElements The value which will be set
     */
    inline void setU8NumberOfDLPElements (uint8 u8NumberOfDLPElements_);

    // API of field "DLPlusList"

    static const int kDLPlusList = 11;

    /**
     * Clears the field "DLPlusList".
     *
     * The field will be set to its default value. The hasDLPlusList()
     * method will return false.
     */
    inline void clearDLPlusList();

    /**
     * Checks whether the field "DLPlusList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDLPlusList()). Otherwise it will return false.
     */
    inline bool hasDLPlusList () const;

    /**
     * Returns the value of the member "DLPlusList".
     *
     * List containing information of all available DL Plus data
     *
     * @return The value of the field "DLPlusList"
     */
    inline const ::std::vector< T_DAB_RadioTextPlus >& getDLPlusList () const;

    /**
     * Retrieves the value of the field "DLPlusList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DLPlusList".
     */
    inline ::std::vector< T_DAB_RadioTextPlus >& getDLPlusListMutable ();

    /**
     * Sets the value of the member "DLPlusList".
     *
     * List containing information of all available DL Plus data
     *
     * @param DLPlusList The value which will be set
     */
    inline void setDLPlusList (const ::std::vector< T_DAB_RadioTextPlus >& DLPlusList_);

    // API of field "bMuted"

    static const int kBMuted = 12;

    /**
     * Clears the field "bMuted".
     *
     * The field will be set to its default value. The hasBMuted()
     * method will return false.
     */
    inline void clearBMuted();

    /**
     * Checks whether the field "bMuted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMuted()). Otherwise it will return false.
     */
    inline bool hasBMuted () const;

    /**
     * Returns the value of the member "bMuted".
     *
     * TRUE if DAB is muted.
     *
     * @return The value of the field "bMuted"
     */
    inline bool getBMuted () const;

    /**
     * Sets the value of the member "bMuted".
     *
     * TRUE if DAB is muted.
     *
     * @param bMuted The value which will be set
     */
    inline void setBMuted (bool bMuted_);

    // API of field "bAFAvailable"

    static const int kBAFAvailable = 13;

    /**
     * Clears the field "bAFAvailable".
     *
     * The field will be set to its default value. The hasBAFAvailable()
     * method will return false.
     */
    inline void clearBAFAvailable();

    /**
     * Checks whether the field "bAFAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAFAvailable()). Otherwise it will return false.
     */
    inline bool hasBAFAvailable () const;

    /**
     * Returns the value of the member "bAFAvailable".
     *
     * TRUE if AF are availble and FALSE if AF are not available.
     *
     * @return The value of the field "bAFAvailable"
     */
    inline bool getBAFAvailable () const;

    /**
     * Sets the value of the member "bAFAvailable".
     *
     * TRUE if AF are availble and FALSE if AF are not available.
     *
     * @param bAFAvailable The value which will be set
     */
    inline void setBAFAvailable (bool bAFAvailable_);

    // API of field "sLogoLink"

    static const int kSLogoLink = 14;

    /**
     * Clears the field "sLogoLink".
     *
     * The field will be set to its default value. The hasSLogoLink()
     * method will return false.
     */
    inline void clearSLogoLink();

    /**
     * Checks whether the field "sLogoLink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLogoLink()). Otherwise it will return false.
     */
    inline bool hasSLogoLink () const;

    /**
     * Returns the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @return The value of the field "sLogoLink"
     */
    inline const ::std::string& getSLogoLink () const;

    /**
     * Retrieves the value of the field "sLogoLink" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLogoLink".
     */
    inline ::std::string& getSLogoLinkMutable ();

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const ::std::string& sLogoLink_);

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const char* sLogoLink_);

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const char* value, size_t size);

    // API of field "u8ScidsValue"

    static const int kU8ScidsValue = 15;

    /**
     * Clears the field "u8ScidsValue".
     *
     * The field will be set to its default value. The hasU8ScidsValue()
     * method will return false.
     */
    inline void clearU8ScidsValue();

    /**
     * Checks whether the field "u8ScidsValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ScidsValue()). Otherwise it will return false.
     */
    inline bool hasU8ScidsValue () const;

    /**
     * Returns the value of the member "u8ScidsValue".
     *
     * Secondary componenet scids value, 0 incase of primary component.
     *
     * @return The value of the field "u8ScidsValue"
     */
    inline uint8 getU8ScidsValue () const;

    /**
     * Sets the value of the member "u8ScidsValue".
     *
     * Secondary componenet scids value, 0 incase of primary component.
     *
     * @param u8ScidsValue The value which will be set
     */
    inline void setU8ScidsValue (uint8 u8ScidsValue_);

    static const T_DAB_ChannelInfo &getDefaultInstance();

private:

    static const ::std::vector< T_DAB_RadioTextPlus >& getT_DAB_RadioTextPlusList_DefaultInstance ();

    inline void set_has_u32ServId ();

    inline void clear_has_u32ServId ();

    inline void set_has_enState ();

    inline void clear_has_enState ();

    inline void set_has_ServiceLabel ();

    inline void clear_has_ServiceLabel ();

    inline void set_has_u8NumberOfAudioComponents ();

    inline void clear_has_u8NumberOfAudioComponents ();

    inline void set_has_b16AvailableAnnoTypesMask ();

    inline void clear_has_b16AvailableAnnoTypesMask ();

    inline void set_has_u8PresetListElementID ();

    inline void clear_has_u8PresetListElementID ();

    inline void set_has_bComponentMode ();

    inline void clear_has_bComponentMode ();

    inline void set_has_bFmServiceFollowActive ();

    inline void clear_has_bFmServiceFollowActive ();

    inline void set_has_u16FrozenListElementID ();

    inline void clear_has_u16FrozenListElementID ();

    inline void set_has_rRadioText ();

    inline void clear_has_rRadioText ();

    inline void set_has_u8NumberOfDLPElements ();

    inline void clear_has_u8NumberOfDLPElements ();

    inline void set_has_DLPlusList ();

    inline void clear_has_DLPlusList ();

    inline void set_has_bMuted ();

    inline void clear_has_bMuted ();

    inline void set_has_bAFAvailable ();

    inline void clear_has_bAFAvailable ();

    inline void set_has_sLogoLink ();

    inline void clear_has_sLogoLink ();

    inline void set_has_u8ScidsValue ();

    inline void clear_has_u8ScidsValue ();

    uint32 _has_bits_[ (16 + 31) / 32];

    uint32 _u32ServId;

    T_e8_DAB_ChannelInfoState _enState;

    T_DAB_Label _ServiceLabel;

    uint8 _u8NumberOfAudioComponents;

    T_b16_DAB_AnnouncementType _b16AvailableAnnoTypesMask;

    uint8 _u8PresetListElementID;

    bool _bComponentMode;

    bool _bFmServiceFollowActive;

    uint16 _u16FrozenListElementID;

    T_DAB_RadioText _rRadioText;

    uint8 _u8NumberOfDLPElements;

    ::std::vector< T_DAB_RadioTextPlus > _DLPlusList;

    bool _bMuted;

    bool _bAFAvailable;

    ::std::string _sLogoLink;

    uint8 _u8ScidsValue;

};

/**
 * DAB current service component information is contained in this structure .
 */
class T_DAB_ComponentInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_ComponentInfo ();

    /**
     * Copy constructor
     */
    inline  T_DAB_ComponentInfo (const T_DAB_ComponentInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_ComponentInfo (uint8 u8ComponentId_, const T_DAB_Label& ComponentLabel_, uint16 u16SCIDI_, uint8 u8Subchannel_, uint8 u8SCIDS_, T_e8_DAB_ComponentType e8ComponentType_, T_e8_DAB_ServiceType e8ServiceType_, T_e8_DAB_TMIdType e8TMIdType_, uint8 u8AudioDataServiceComponentType_, uint16 u16ComponentIndex_);

    /**
     * Destructor
     */
    inline  ~T_DAB_ComponentInfo();

    /**
     * Assignment operator
     */
    inline T_DAB_ComponentInfo& operator = (const T_DAB_ComponentInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_ComponentInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_ComponentInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_ComponentInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_ComponentInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8ComponentId"

    static const int kU8ComponentId = 0;

    /**
     * Clears the field "u8ComponentId".
     *
     * The field will be set to its default value. The hasU8ComponentId()
     * method will return false.
     */
    inline void clearU8ComponentId();

    /**
     * Checks whether the field "u8ComponentId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ComponentId()). Otherwise it will return false.
     */
    inline bool hasU8ComponentId () const;

    /**
     * Returns the value of the member "u8ComponentId".
     *
     * Component Id.
     *
     * @return The value of the field "u8ComponentId"
     */
    inline uint8 getU8ComponentId () const;

    /**
     * Sets the value of the member "u8ComponentId".
     *
     * Component Id.
     *
     * @param u8ComponentId The value which will be set
     */
    inline void setU8ComponentId (uint8 u8ComponentId_);

    // API of field "ComponentLabel"

    static const int kComponentLabel = 1;

    /**
     * Clears the field "ComponentLabel".
     *
     * The field will be set to its default value. The hasComponentLabel()
     * method will return false.
     */
    inline void clearComponentLabel();

    /**
     * Checks whether the field "ComponentLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComponentLabel()). Otherwise it will return false.
     */
    inline bool hasComponentLabel () const;

    /**
     * Returns the value of the member "ComponentLabel".
     *
     * Component label.
     *
     * @return The value of the field "ComponentLabel"
     */
    inline const T_DAB_Label& getComponentLabel () const;

    /**
     * Retrieves the value of the field "ComponentLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ComponentLabel".
     */
    inline T_DAB_Label& getComponentLabelMutable ();

    /**
     * Sets the value of the member "ComponentLabel".
     *
     * Component label.
     *
     * @param ComponentLabel The value which will be set
     */
    inline void setComponentLabel (const T_DAB_Label& ComponentLabel_);

    // API of field "u16SCIDI"

    static const int kU16SCIDI = 2;

    /**
     * Clears the field "u16SCIDI".
     *
     * The field will be set to its default value. The hasU16SCIDI()
     * method will return false.
     */
    inline void clearU16SCIDI();

    /**
     * Checks whether the field "u16SCIDI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SCIDI()). Otherwise it will return false.
     */
    inline bool hasU16SCIDI () const;

    /**
     * Returns the value of the member "u16SCIDI".
     *
     * Service component Id internal.
     *
     * @return The value of the field "u16SCIDI"
     */
    inline uint16 getU16SCIDI () const;

    /**
     * Sets the value of the member "u16SCIDI".
     *
     * Service component Id internal.
     *
     * @param u16SCIDI The value which will be set
     */
    inline void setU16SCIDI (uint16 u16SCIDI_);

    // API of field "u8Subchannel"

    static const int kU8Subchannel = 3;

    /**
     * Clears the field "u8Subchannel".
     *
     * The field will be set to its default value. The hasU8Subchannel()
     * method will return false.
     */
    inline void clearU8Subchannel();

    /**
     * Checks whether the field "u8Subchannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Subchannel()). Otherwise it will return false.
     */
    inline bool hasU8Subchannel () const;

    /**
     * Returns the value of the member "u8Subchannel".
     *
     * Subchannel number.
     *
     * @return The value of the field "u8Subchannel"
     */
    inline uint8 getU8Subchannel () const;

    /**
     * Sets the value of the member "u8Subchannel".
     *
     * Subchannel number.
     *
     * @param u8Subchannel The value which will be set
     */
    inline void setU8Subchannel (uint8 u8Subchannel_);

    // API of field "u8SCIDS"

    static const int kU8SCIDS = 4;

    /**
     * Clears the field "u8SCIDS".
     *
     * The field will be set to its default value. The hasU8SCIDS()
     * method will return false.
     */
    inline void clearU8SCIDS();

    /**
     * Checks whether the field "u8SCIDS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SCIDS()). Otherwise it will return false.
     */
    inline bool hasU8SCIDS () const;

    /**
     * Returns the value of the member "u8SCIDS".
     *
     * Service Component Identifier within a Service.If the SCIDS isnï¿½t available it is set to 0xff.
     *
     * @return The value of the field "u8SCIDS"
     */
    inline uint8 getU8SCIDS () const;

    /**
     * Sets the value of the member "u8SCIDS".
     *
     * Service Component Identifier within a Service.If the SCIDS isnï¿½t available it is set to 0xff.
     *
     * @param u8SCIDS The value which will be set
     */
    inline void setU8SCIDS (uint8 u8SCIDS_);

    // API of field "e8ComponentType"

    static const int kE8ComponentType = 5;

    /**
     * Clears the field "e8ComponentType".
     *
     * The field will be set to its default value. The hasE8ComponentType()
     * method will return false.
     */
    inline void clearE8ComponentType();

    /**
     * Checks whether the field "e8ComponentType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ComponentType()). Otherwise it will return false.
     */
    inline bool hasE8ComponentType () const;

    /**
     * Returns the value of the member "e8ComponentType".
     *
     *
     *
     * @return The value of the field "e8ComponentType"
     */
    inline T_e8_DAB_ComponentType getE8ComponentType () const;

    /**
     * Sets the value of the member "e8ComponentType".
     *
     *
     *
     * @param e8ComponentType The value which will be set
     */
    inline void setE8ComponentType (T_e8_DAB_ComponentType e8ComponentType_);

    // API of field "e8ServiceType"

    static const int kE8ServiceType = 6;

    /**
     * Clears the field "e8ServiceType".
     *
     * The field will be set to its default value. The hasE8ServiceType()
     * method will return false.
     */
    inline void clearE8ServiceType();

    /**
     * Checks whether the field "e8ServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceType()). Otherwise it will return false.
     */
    inline bool hasE8ServiceType () const;

    /**
     * Returns the value of the member "e8ServiceType".
     *
     *
     *
     * @return The value of the field "e8ServiceType"
     */
    inline T_e8_DAB_ServiceType getE8ServiceType () const;

    /**
     * Sets the value of the member "e8ServiceType".
     *
     *
     *
     * @param e8ServiceType The value which will be set
     */
    inline void setE8ServiceType (T_e8_DAB_ServiceType e8ServiceType_);

    // API of field "e8TMIdType"

    static const int kE8TMIdType = 7;

    /**
     * Clears the field "e8TMIdType".
     *
     * The field will be set to its default value. The hasE8TMIdType()
     * method will return false.
     */
    inline void clearE8TMIdType();

    /**
     * Checks whether the field "e8TMIdType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TMIdType()). Otherwise it will return false.
     */
    inline bool hasE8TMIdType () const;

    /**
     * Returns the value of the member "e8TMIdType".
     *
     * Transport Mechanism Identifier
     *
     * @return The value of the field "e8TMIdType"
     */
    inline T_e8_DAB_TMIdType getE8TMIdType () const;

    /**
     * Sets the value of the member "e8TMIdType".
     *
     * Transport Mechanism Identifier
     *
     * @param e8TMIdType The value which will be set
     */
    inline void setE8TMIdType (T_e8_DAB_TMIdType e8TMIdType_);

    // API of field "u8AudioDataServiceComponentType"

    static const int kU8AudioDataServiceComponentType = 8;

    /**
     * Clears the field "u8AudioDataServiceComponentType".
     *
     * The field will be set to its default value. The hasU8AudioDataServiceComponentType()
     * method will return false.
     */
    inline void clearU8AudioDataServiceComponentType();

    /**
     * Checks whether the field "u8AudioDataServiceComponentType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioDataServiceComponentType()). Otherwise it will return false.
     */
    inline bool hasU8AudioDataServiceComponentType () const;

    /**
     * Returns the value of the member "u8AudioDataServiceComponentType".
     *
     * depends on e8ServiceType are these values different to interpret.
     * T_e8_DAB_AudioServiceComponentType or T_e8_DAB_DataServiceComponentType
     *
     * @return The value of the field "u8AudioDataServiceComponentType"
     */
    inline uint8 getU8AudioDataServiceComponentType () const;

    /**
     * Sets the value of the member "u8AudioDataServiceComponentType".
     *
     * depends on e8ServiceType are these values different to interpret.
     * T_e8_DAB_AudioServiceComponentType or T_e8_DAB_DataServiceComponentType
     *
     * @param u8AudioDataServiceComponentType The value which will be set
     */
    inline void setU8AudioDataServiceComponentType (uint8 u8AudioDataServiceComponentType_);

    // API of field "u16ComponentIndex"

    static const int kU16ComponentIndex = 9;

    /**
     * Clears the field "u16ComponentIndex".
     *
     * The field will be set to its default value. The hasU16ComponentIndex()
     * method will return false.
     */
    inline void clearU16ComponentIndex();

    /**
     * Checks whether the field "u16ComponentIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ComponentIndex()). Otherwise it will return false.
     */
    inline bool hasU16ComponentIndex () const;

    /**
     * Returns the value of the member "u16ComponentIndex".
     *
     * Holds the index of the current component.
     *
     * @return The value of the field "u16ComponentIndex"
     */
    inline uint16 getU16ComponentIndex () const;

    /**
     * Sets the value of the member "u16ComponentIndex".
     *
     * Holds the index of the current component.
     *
     * @param u16ComponentIndex The value which will be set
     */
    inline void setU16ComponentIndex (uint16 u16ComponentIndex_);

    static const T_DAB_ComponentInfo &getDefaultInstance();

private:

    inline void set_has_u8ComponentId ();

    inline void clear_has_u8ComponentId ();

    inline void set_has_ComponentLabel ();

    inline void clear_has_ComponentLabel ();

    inline void set_has_u16SCIDI ();

    inline void clear_has_u16SCIDI ();

    inline void set_has_u8Subchannel ();

    inline void clear_has_u8Subchannel ();

    inline void set_has_u8SCIDS ();

    inline void clear_has_u8SCIDS ();

    inline void set_has_e8ComponentType ();

    inline void clear_has_e8ComponentType ();

    inline void set_has_e8ServiceType ();

    inline void clear_has_e8ServiceType ();

    inline void set_has_e8TMIdType ();

    inline void clear_has_e8TMIdType ();

    inline void set_has_u8AudioDataServiceComponentType ();

    inline void clear_has_u8AudioDataServiceComponentType ();

    inline void set_has_u16ComponentIndex ();

    inline void clear_has_u16ComponentIndex ();

    uint32 _has_bits_[ (10 + 31) / 32];

    uint8 _u8ComponentId;

    T_DAB_Label _ComponentLabel;

    uint16 _u16SCIDI;

    uint8 _u8Subchannel;

    uint8 _u8SCIDS;

    T_e8_DAB_ComponentType _e8ComponentType;

    T_e8_DAB_ServiceType _e8ServiceType;

    T_e8_DAB_TMIdType _e8TMIdType;

    uint8 _u8AudioDataServiceComponentType;

    uint16 _u16ComponentIndex;

};

/**
 * DAB current announcement status information is contained in this structure .
 */
class T_DAB_AnnoConfig {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_AnnoConfig ();

    /**
     * Copy constructor
     */
    inline  T_DAB_AnnoConfig (const T_DAB_AnnoConfig &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_AnnoConfig (const T_b16_DAB_AnnouncementType& AnnoConfigTypes_, bool bEnable_, T_e8_DAB_AnnouncementSource AnnoConfigSource_);

    /**
     * Destructor
     */
    inline  ~T_DAB_AnnoConfig();

    /**
     * Assignment operator
     */
    inline T_DAB_AnnoConfig& operator = (const T_DAB_AnnoConfig& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_AnnoConfig& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_AnnoConfig& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_AnnoConfig& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_AnnoConfig& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AnnoConfigTypes"

    static const int kAnnoConfigTypes = 0;

    /**
     * Clears the field "AnnoConfigTypes".
     *
     * The field will be set to its default value. The hasAnnoConfigTypes()
     * method will return false.
     */
    inline void clearAnnoConfigTypes();

    /**
     * Checks whether the field "AnnoConfigTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoConfigTypes()). Otherwise it will return false.
     */
    inline bool hasAnnoConfigTypes () const;

    /**
     * Returns the value of the member "AnnoConfigTypes".
     *
     * Bitfield. Types of announcments to be selected.
     *
     * @return The value of the field "AnnoConfigTypes"
     */
    inline const T_b16_DAB_AnnouncementType& getAnnoConfigTypes () const;

    /**
     * Retrieves the value of the field "AnnoConfigTypes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoConfigTypes".
     */
    inline T_b16_DAB_AnnouncementType& getAnnoConfigTypesMutable ();

    /**
     * Sets the value of the member "AnnoConfigTypes".
     *
     * Bitfield. Types of announcments to be selected.
     *
     * @param AnnoConfigTypes The value which will be set
     */
    inline void setAnnoConfigTypes (const T_b16_DAB_AnnouncementType& AnnoConfigTypes_);

    // API of field "bEnable"

    static const int kBEnable = 1;

    /**
     * Clears the field "bEnable".
     *
     * The field will be set to its default value. The hasBEnable()
     * method will return false.
     */
    inline void clearBEnable();

    /**
     * Checks whether the field "bEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnable()). Otherwise it will return false.
     */
    inline bool hasBEnable () const;

    /**
     * Returns the value of the member "bEnable".
     *
     * Indicates if the selected announcement type is enabled or disabled.
     * 1=Enable, 0=Disable
     *
     * @return The value of the field "bEnable"
     */
    inline bool getBEnable () const;

    /**
     * Sets the value of the member "bEnable".
     *
     * Indicates if the selected announcement type is enabled or disabled.
     * 1=Enable, 0=Disable
     *
     * @param bEnable The value which will be set
     */
    inline void setBEnable (bool bEnable_);

    // API of field "AnnoConfigSource"

    static const int kAnnoConfigSource = 2;

    /**
     * Clears the field "AnnoConfigSource".
     *
     * The field will be set to its default value. The hasAnnoConfigSource()
     * method will return false.
     */
    inline void clearAnnoConfigSource();

    /**
     * Checks whether the field "AnnoConfigSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoConfigSource()). Otherwise it will return false.
     */
    inline bool hasAnnoConfigSource () const;

    /**
     * Returns the value of the member "AnnoConfigSource".
     *
     * Announcement source that shall be selected
     *
     * @return The value of the field "AnnoConfigSource"
     */
    inline T_e8_DAB_AnnouncementSource getAnnoConfigSource () const;

    /**
     * Sets the value of the member "AnnoConfigSource".
     *
     * Announcement source that shall be selected
     *
     * @param AnnoConfigSource The value which will be set
     */
    inline void setAnnoConfigSource (T_e8_DAB_AnnouncementSource AnnoConfigSource_);

    static const T_DAB_AnnoConfig &getDefaultInstance();

private:

    inline void set_has_AnnoConfigTypes ();

    inline void clear_has_AnnoConfigTypes ();

    inline void set_has_bEnable ();

    inline void clear_has_bEnable ();

    inline void set_has_AnnoConfigSource ();

    inline void clear_has_AnnoConfigSource ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_b16_DAB_AnnouncementType _AnnoConfigTypes;

    bool _bEnable;

    T_e8_DAB_AnnouncementSource _AnnoConfigSource;

};

/**
 * DAB announcement related information is contained in this structure .
 */
class T_DAB_AnnoElement {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_AnnoElement ();

    /**
     * Copy constructor
     */
    inline  T_DAB_AnnoElement (const T_DAB_AnnoElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_AnnoElement (uint16 u16AnnoType_, T_e8_DAB_AnnouncementStatus AnnoState_);

    /**
     * Destructor
     */
    inline  ~T_DAB_AnnoElement();

    /**
     * Assignment operator
     */
    inline T_DAB_AnnoElement& operator = (const T_DAB_AnnoElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_AnnoElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_AnnoElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_AnnoElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_AnnoElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AnnoType"

    static const int kU16AnnoType = 0;

    /**
     * Clears the field "u16AnnoType".
     *
     * The field will be set to its default value. The hasU16AnnoType()
     * method will return false.
     */
    inline void clearU16AnnoType();

    /**
     * Checks whether the field "u16AnnoType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AnnoType()). Otherwise it will return false.
     */
    inline bool hasU16AnnoType () const;

    /**
     * Returns the value of the member "u16AnnoType".
     *
     * Type of Announcement ie 1- Alarm, 2- Road_traffic , 4-Transport,8-Warning, 16-News,32-Weather,64-Event,128-Specialevent
     * 256-ProgrammeInformation,512-Sport report,1024-Financial report
     *
     * @return The value of the field "u16AnnoType"
     */
    inline uint16 getU16AnnoType () const;

    /**
     * Sets the value of the member "u16AnnoType".
     *
     * Type of Announcement ie 1- Alarm, 2- Road_traffic , 4-Transport,8-Warning, 16-News,32-Weather,64-Event,128-Specialevent
     * 256-ProgrammeInformation,512-Sport report,1024-Financial report
     *
     * @param u16AnnoType The value which will be set
     */
    inline void setU16AnnoType (uint16 u16AnnoType_);

    // API of field "AnnoState"

    static const int kAnnoState = 1;

    /**
     * Clears the field "AnnoState".
     *
     * The field will be set to its default value. The hasAnnoState()
     * method will return false.
     */
    inline void clearAnnoState();

    /**
     * Checks whether the field "AnnoState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoState()). Otherwise it will return false.
     */
    inline bool hasAnnoState () const;

    /**
     * Returns the value of the member "AnnoState".
     *
     * State of announcement in the DAB-Module (start, end, escaped, switched).
     *
     * @return The value of the field "AnnoState"
     */
    inline T_e8_DAB_AnnouncementStatus getAnnoState () const;

    /**
     * Sets the value of the member "AnnoState".
     *
     * State of announcement in the DAB-Module (start, end, escaped, switched).
     *
     * @param AnnoState The value which will be set
     */
    inline void setAnnoState (T_e8_DAB_AnnouncementStatus AnnoState_);

    static const T_DAB_AnnoElement &getDefaultInstance();

private:

    inline void set_has_u16AnnoType ();

    inline void clear_has_u16AnnoType ();

    inline void set_has_AnnoState ();

    inline void clear_has_AnnoState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16AnnoType;

    T_e8_DAB_AnnouncementStatus _AnnoState;

};

/**
 * DAB current announcement status information is contained in this structure .
 */
class T_DAB_AnnoStatus {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_AnnoStatus ();

    /**
     * Copy constructor
     */
    inline  T_DAB_AnnoStatus (const T_DAB_AnnoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_AnnoStatus (const T_b16_DAB_AnnouncementType& AnnoConfigTypes_, T_e8_DAB_AnnouncementSource AnnoConfigSource_, const T_b16_DAB_AnnouncementType& AnnoSupportedTypes_, const T_b16_DAB_AnnouncementType& AnnoActiveTypes_, T_e8_DAB_AnnouncementSource AnnoActiveSource_, T_e8_DAB_AnnouncementStatus AnnoActiveState_, T_e8_DAB_AnnouncementSelectState AnnoSelectState_, const T_b16_DAB_AnnouncementType& AnnoSelectedTypes_, const T_DAB_Label& AnnoServiceLabel_, const ::std::vector< T_DAB_AnnoElement >& AnnouncementList_);

    /**
     * Destructor
     */
    inline  ~T_DAB_AnnoStatus();

    /**
     * Assignment operator
     */
    inline T_DAB_AnnoStatus& operator = (const T_DAB_AnnoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_AnnoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_AnnoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_AnnoStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_AnnoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AnnoConfigTypes"

    static const int kAnnoConfigTypes = 0;

    /**
     * Clears the field "AnnoConfigTypes".
     *
     * The field will be set to its default value. The hasAnnoConfigTypes()
     * method will return false.
     */
    inline void clearAnnoConfigTypes();

    /**
     * Checks whether the field "AnnoConfigTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoConfigTypes()). Otherwise it will return false.
     */
    inline bool hasAnnoConfigTypes () const;

    /**
     * Returns the value of the member "AnnoConfigTypes".
     *
     * Bitfield. Configured Announcement types. default: TA.
     * Unsetting all bits will deactivate announcement-handling.
     *
     * @return The value of the field "AnnoConfigTypes"
     */
    inline const T_b16_DAB_AnnouncementType& getAnnoConfigTypes () const;

    /**
     * Retrieves the value of the field "AnnoConfigTypes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoConfigTypes".
     */
    inline T_b16_DAB_AnnouncementType& getAnnoConfigTypesMutable ();

    /**
     * Sets the value of the member "AnnoConfigTypes".
     *
     * Bitfield. Configured Announcement types. default: TA.
     * Unsetting all bits will deactivate announcement-handling.
     *
     * @param AnnoConfigTypes The value which will be set
     */
    inline void setAnnoConfigTypes (const T_b16_DAB_AnnouncementType& AnnoConfigTypes_);

    // API of field "AnnoConfigSource"

    static const int kAnnoConfigSource = 1;

    /**
     * Clears the field "AnnoConfigSource".
     *
     * The field will be set to its default value. The hasAnnoConfigSource()
     * method will return false.
     */
    inline void clearAnnoConfigSource();

    /**
     * Checks whether the field "AnnoConfigSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoConfigSource()). Otherwise it will return false.
     */
    inline bool hasAnnoConfigSource () const;

    /**
     * Returns the value of the member "AnnoConfigSource".
     *
     * Bitfield. Configured announcement source.
     * Shall be ignored by current implementation for LCN2
     *
     * @return The value of the field "AnnoConfigSource"
     */
    inline T_e8_DAB_AnnouncementSource getAnnoConfigSource () const;

    /**
     * Sets the value of the member "AnnoConfigSource".
     *
     * Bitfield. Configured announcement source.
     * Shall be ignored by current implementation for LCN2
     *
     * @param AnnoConfigSource The value which will be set
     */
    inline void setAnnoConfigSource (T_e8_DAB_AnnouncementSource AnnoConfigSource_);

    // API of field "AnnoSupportedTypes"

    static const int kAnnoSupportedTypes = 2;

    /**
     * Clears the field "AnnoSupportedTypes".
     *
     * The field will be set to its default value. The hasAnnoSupportedTypes()
     * method will return false.
     */
    inline void clearAnnoSupportedTypes();

    /**
     * Checks whether the field "AnnoSupportedTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoSupportedTypes()). Otherwise it will return false.
     */
    inline bool hasAnnoSupportedTypes () const;

    /**
     * Returns the value of the member "AnnoSupportedTypes".
     *
     * Bitfield. Supported announcements of current service.
     * Can be used to check, if the currently tuned station provides the
     * required announcements.
     *
     * @return The value of the field "AnnoSupportedTypes"
     */
    inline const T_b16_DAB_AnnouncementType& getAnnoSupportedTypes () const;

    /**
     * Retrieves the value of the field "AnnoSupportedTypes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoSupportedTypes".
     */
    inline T_b16_DAB_AnnouncementType& getAnnoSupportedTypesMutable ();

    /**
     * Sets the value of the member "AnnoSupportedTypes".
     *
     * Bitfield. Supported announcements of current service.
     * Can be used to check, if the currently tuned station provides the
     * required announcements.
     *
     * @param AnnoSupportedTypes The value which will be set
     */
    inline void setAnnoSupportedTypes (const T_b16_DAB_AnnouncementType& AnnoSupportedTypes_);

    // API of field "AnnoActiveTypes"

    static const int kAnnoActiveTypes = 3;

    /**
     * Clears the field "AnnoActiveTypes".
     *
     * The field will be set to its default value. The hasAnnoActiveTypes()
     * method will return false.
     */
    inline void clearAnnoActiveTypes();

    /**
     * Checks whether the field "AnnoActiveTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoActiveTypes()). Otherwise it will return false.
     */
    inline bool hasAnnoActiveTypes () const;

    /**
     * Returns the value of the member "AnnoActiveTypes".
     *
     * Bitfield. Active Announcement-types.
     * Active announcments of current service that match AnnoConfigTypes.
     * Shall be ignored by current implementation for LCN2.
     *
     * @return The value of the field "AnnoActiveTypes"
     */
    inline const T_b16_DAB_AnnouncementType& getAnnoActiveTypes () const;

    /**
     * Retrieves the value of the field "AnnoActiveTypes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoActiveTypes".
     */
    inline T_b16_DAB_AnnouncementType& getAnnoActiveTypesMutable ();

    /**
     * Sets the value of the member "AnnoActiveTypes".
     *
     * Bitfield. Active Announcement-types.
     * Active announcments of current service that match AnnoConfigTypes.
     * Shall be ignored by current implementation for LCN2.
     *
     * @param AnnoActiveTypes The value which will be set
     */
    inline void setAnnoActiveTypes (const T_b16_DAB_AnnouncementType& AnnoActiveTypes_);

    // API of field "AnnoActiveSource"

    static const int kAnnoActiveSource = 4;

    /**
     * Clears the field "AnnoActiveSource".
     *
     * The field will be set to its default value. The hasAnnoActiveSource()
     * method will return false.
     */
    inline void clearAnnoActiveSource();

    /**
     * Checks whether the field "AnnoActiveSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoActiveSource()). Otherwise it will return false.
     */
    inline bool hasAnnoActiveSource () const;

    /**
     * Returns the value of the member "AnnoActiveSource".
     *
     * Active announcement source.
     * Shall be ignored by current implementation for LCN2.
     *
     * @return The value of the field "AnnoActiveSource"
     */
    inline T_e8_DAB_AnnouncementSource getAnnoActiveSource () const;

    /**
     * Sets the value of the member "AnnoActiveSource".
     *
     * Active announcement source.
     * Shall be ignored by current implementation for LCN2.
     *
     * @param AnnoActiveSource The value which will be set
     */
    inline void setAnnoActiveSource (T_e8_DAB_AnnouncementSource AnnoActiveSource_);

    // API of field "AnnoActiveState"

    static const int kAnnoActiveState = 5;

    /**
     * Clears the field "AnnoActiveState".
     *
     * The field will be set to its default value. The hasAnnoActiveState()
     * method will return false.
     */
    inline void clearAnnoActiveState();

    /**
     * Checks whether the field "AnnoActiveState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoActiveState()). Otherwise it will return false.
     */
    inline bool hasAnnoActiveState () const;

    /**
     * Returns the value of the member "AnnoActiveState".
     *
     * State of active announcement in the DAB-Module (start, end, escaped, switched).
     * Shall be ignored by current implementation for LCN2.
     *
     * @return The value of the field "AnnoActiveState"
     */
    inline T_e8_DAB_AnnouncementStatus getAnnoActiveState () const;

    /**
     * Sets the value of the member "AnnoActiveState".
     *
     * State of active announcement in the DAB-Module (start, end, escaped, switched).
     * Shall be ignored by current implementation for LCN2.
     *
     * @param AnnoActiveState The value which will be set
     */
    inline void setAnnoActiveState (T_e8_DAB_AnnouncementStatus AnnoActiveState_);

    // API of field "AnnoSelectState"

    static const int kAnnoSelectState = 6;

    /**
     * Clears the field "AnnoSelectState".
     *
     * The field will be set to its default value. The hasAnnoSelectState()
     * method will return false.
     */
    inline void clearAnnoSelectState();

    /**
     * Checks whether the field "AnnoSelectState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoSelectState()). Otherwise it will return false.
     */
    inline bool hasAnnoSelectState () const;

    /**
     * Returns the value of the member "AnnoSelectState".
     *
     * State Of the announcement.
     * If the state is PENDING the announcment may be selected by entering the souce-state DAB_FOREGROUND_TA.
     * When the announcment is selected, is will become SELECTING and then SELECTED.
     * When the announcement has ended or is interrupted (by changing of source-state), the state will become DESELECTING and the IDLE.
     *
     * @return The value of the field "AnnoSelectState"
     */
    inline T_e8_DAB_AnnouncementSelectState getAnnoSelectState () const;

    /**
     * Sets the value of the member "AnnoSelectState".
     *
     * State Of the announcement.
     * If the state is PENDING the announcment may be selected by entering the souce-state DAB_FOREGROUND_TA.
     * When the announcment is selected, is will become SELECTING and then SELECTED.
     * When the announcement has ended or is interrupted (by changing of source-state), the state will become DESELECTING and the IDLE.
     *
     * @param AnnoSelectState The value which will be set
     */
    inline void setAnnoSelectState (T_e8_DAB_AnnouncementSelectState AnnoSelectState_);

    // API of field "AnnoSelectedTypes"

    static const int kAnnoSelectedTypes = 7;

    /**
     * Clears the field "AnnoSelectedTypes".
     *
     * The field will be set to its default value. The hasAnnoSelectedTypes()
     * method will return false.
     */
    inline void clearAnnoSelectedTypes();

    /**
     * Checks whether the field "AnnoSelectedTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoSelectedTypes()). Otherwise it will return false.
     */
    inline bool hasAnnoSelectedTypes () const;

    /**
     * Returns the value of the member "AnnoSelectedTypes".
     *
     * Bitfield. Currently playing Announcement-types.
     * Shall be ignored by current implementation for LCN2.
     *
     * @return The value of the field "AnnoSelectedTypes"
     */
    inline const T_b16_DAB_AnnouncementType& getAnnoSelectedTypes () const;

    /**
     * Retrieves the value of the field "AnnoSelectedTypes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoSelectedTypes".
     */
    inline T_b16_DAB_AnnouncementType& getAnnoSelectedTypesMutable ();

    /**
     * Sets the value of the member "AnnoSelectedTypes".
     *
     * Bitfield. Currently playing Announcement-types.
     * Shall be ignored by current implementation for LCN2.
     *
     * @param AnnoSelectedTypes The value which will be set
     */
    inline void setAnnoSelectedTypes (const T_b16_DAB_AnnouncementType& AnnoSelectedTypes_);

    // API of field "AnnoServiceLabel"

    static const int kAnnoServiceLabel = 8;

    /**
     * Clears the field "AnnoServiceLabel".
     *
     * The field will be set to its default value. The hasAnnoServiceLabel()
     * method will return false.
     */
    inline void clearAnnoServiceLabel();

    /**
     * Checks whether the field "AnnoServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoServiceLabel()). Otherwise it will return false.
     */
    inline bool hasAnnoServiceLabel () const;

    /**
     * Returns the value of the member "AnnoServiceLabel".
     *
     * Service label of the DAB Anno element.
     *
     * @return The value of the field "AnnoServiceLabel"
     */
    inline const T_DAB_Label& getAnnoServiceLabel () const;

    /**
     * Retrieves the value of the field "AnnoServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoServiceLabel".
     */
    inline T_DAB_Label& getAnnoServiceLabelMutable ();

    /**
     * Sets the value of the member "AnnoServiceLabel".
     *
     * Service label of the DAB Anno element.
     *
     * @param AnnoServiceLabel The value which will be set
     */
    inline void setAnnoServiceLabel (const T_DAB_Label& AnnoServiceLabel_);

    // API of field "AnnouncementList"

    static const int kAnnouncementList = 9;

    /**
     * Clears the field "AnnouncementList".
     *
     * The field will be set to its default value. The hasAnnouncementList()
     * method will return false.
     */
    inline void clearAnnouncementList();

    /**
     * Checks whether the field "AnnouncementList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnouncementList()). Otherwise it will return false.
     */
    inline bool hasAnnouncementList () const;

    /**
     * Returns the value of the member "AnnouncementList".
     *
     * List containing information for each announcement ie anno type and anno state
     *
     * @return The value of the field "AnnouncementList"
     */
    inline const ::std::vector< T_DAB_AnnoElement >& getAnnouncementList () const;

    /**
     * Retrieves the value of the field "AnnouncementList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnouncementList".
     */
    inline ::std::vector< T_DAB_AnnoElement >& getAnnouncementListMutable ();

    /**
     * Sets the value of the member "AnnouncementList".
     *
     * List containing information for each announcement ie anno type and anno state
     *
     * @param AnnouncementList The value which will be set
     */
    inline void setAnnouncementList (const ::std::vector< T_DAB_AnnoElement >& AnnouncementList_);

    static const T_DAB_AnnoStatus &getDefaultInstance();

private:

    static const ::std::vector< T_DAB_AnnoElement >& getT_DAB_AnnoElementList_DefaultInstance ();

    inline void set_has_AnnoConfigTypes ();

    inline void clear_has_AnnoConfigTypes ();

    inline void set_has_AnnoConfigSource ();

    inline void clear_has_AnnoConfigSource ();

    inline void set_has_AnnoSupportedTypes ();

    inline void clear_has_AnnoSupportedTypes ();

    inline void set_has_AnnoActiveTypes ();

    inline void clear_has_AnnoActiveTypes ();

    inline void set_has_AnnoActiveSource ();

    inline void clear_has_AnnoActiveSource ();

    inline void set_has_AnnoActiveState ();

    inline void clear_has_AnnoActiveState ();

    inline void set_has_AnnoSelectState ();

    inline void clear_has_AnnoSelectState ();

    inline void set_has_AnnoSelectedTypes ();

    inline void clear_has_AnnoSelectedTypes ();

    inline void set_has_AnnoServiceLabel ();

    inline void clear_has_AnnoServiceLabel ();

    inline void set_has_AnnouncementList ();

    inline void clear_has_AnnouncementList ();

    uint32 _has_bits_[ (10 + 31) / 32];

    T_b16_DAB_AnnouncementType _AnnoConfigTypes;

    T_e8_DAB_AnnouncementSource _AnnoConfigSource;

    T_b16_DAB_AnnouncementType _AnnoSupportedTypes;

    T_b16_DAB_AnnouncementType _AnnoActiveTypes;

    T_e8_DAB_AnnouncementSource _AnnoActiveSource;

    T_e8_DAB_AnnouncementStatus _AnnoActiveState;

    T_e8_DAB_AnnouncementSelectState _AnnoSelectState;

    T_b16_DAB_AnnouncementType _AnnoSelectedTypes;

    T_DAB_Label _AnnoServiceLabel;

    ::std::vector< T_DAB_AnnoElement > _AnnouncementList;

};

/**
 * DAB ADR msg data contained in this structure.
 */
class T_DAB_ADRMsg {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_ADRMsg ();

    /**
     * Copy constructor
     */
    inline  T_DAB_ADRMsg (const T_DAB_ADRMsg &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_ADRMsg (uint16 u16FktID_, const ::std::vector< uint8 >& MsgData_);

    /**
     * Destructor
     */
    inline  ~T_DAB_ADRMsg();

    /**
     * Assignment operator
     */
    inline T_DAB_ADRMsg& operator = (const T_DAB_ADRMsg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_ADRMsg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_ADRMsg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_ADRMsg& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_ADRMsg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16FktID"

    static const int kU16FktID = 0;

    /**
     * Clears the field "u16FktID".
     *
     * The field will be set to its default value. The hasU16FktID()
     * method will return false.
     */
    inline void clearU16FktID();

    /**
     * Checks whether the field "u16FktID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FktID()). Otherwise it will return false.
     */
    inline bool hasU16FktID () const;

    /**
     * Returns the value of the member "u16FktID".
     *
     * Function id of the message
     *
     * @return The value of the field "u16FktID"
     */
    inline uint16 getU16FktID () const;

    /**
     * Sets the value of the member "u16FktID".
     *
     * Function id of the message
     *
     * @param u16FktID The value which will be set
     */
    inline void setU16FktID (uint16 u16FktID_);

    // API of field "MsgData"

    static const int kMsgData = 1;

    /**
     * Clears the field "MsgData".
     *
     * The field will be set to its default value. The hasMsgData()
     * method will return false.
     */
    inline void clearMsgData();

    /**
     * Checks whether the field "MsgData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsgData()). Otherwise it will return false.
     */
    inline bool hasMsgData () const;

    /**
     * Returns the value of the member "MsgData".
     *
     * List containing ADR data
     *
     * @return The value of the field "MsgData"
     */
    inline const ::std::vector< uint8 >& getMsgData () const;

    /**
     * Retrieves the value of the field "MsgData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MsgData".
     */
    inline ::std::vector< uint8 >& getMsgDataMutable ();

    /**
     * Sets the value of the member "MsgData".
     *
     * List containing ADR data
     *
     * @param MsgData The value which will be set
     */
    inline void setMsgData (const ::std::vector< uint8 >& MsgData_);

    static const T_DAB_ADRMsg &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u16FktID ();

    inline void clear_has_u16FktID ();

    inline void set_has_MsgData ();

    inline void clear_has_MsgData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16FktID;

    ::std::vector< uint8 > _MsgData;

};

/**
 * Logo Element data contained in this structure
 */
class T_DAB_LogoElement {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_LogoElement ();

    /**
     * Copy constructor
     */
    inline  T_DAB_LogoElement (const T_DAB_LogoElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_LogoElement (uint32 u32ServiceID_, const ::std::string& sLogoLink_);

    /**
     * Destructor
     */
    inline  ~T_DAB_LogoElement();

    /**
     * Assignment operator
     */
    inline T_DAB_LogoElement& operator = (const T_DAB_LogoElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_LogoElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_LogoElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_LogoElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_LogoElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ServiceID"

    static const int kU32ServiceID = 0;

    /**
     * Clears the field "u32ServiceID".
     *
     * The field will be set to its default value. The hasU32ServiceID()
     * method will return false.
     */
    inline void clearU32ServiceID();

    /**
     * Checks whether the field "u32ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ServiceID()). Otherwise it will return false.
     */
    inline bool hasU32ServiceID () const;

    /**
     * Returns the value of the member "u32ServiceID".
     *
     * Serviceid of this logo
     *
     * @return The value of the field "u32ServiceID"
     */
    inline uint32 getU32ServiceID () const;

    /**
     * Sets the value of the member "u32ServiceID".
     *
     * Serviceid of this logo
     *
     * @param u32ServiceID The value which will be set
     */
    inline void setU32ServiceID (uint32 u32ServiceID_);

    // API of field "sLogoLink"

    static const int kSLogoLink = 1;

    /**
     * Clears the field "sLogoLink".
     *
     * The field will be set to its default value. The hasSLogoLink()
     * method will return false.
     */
    inline void clearSLogoLink();

    /**
     * Checks whether the field "sLogoLink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLogoLink()). Otherwise it will return false.
     */
    inline bool hasSLogoLink () const;

    /**
     * Returns the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @return The value of the field "sLogoLink"
     */
    inline const ::std::string& getSLogoLink () const;

    /**
     * Retrieves the value of the field "sLogoLink" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLogoLink".
     */
    inline ::std::string& getSLogoLinkMutable ();

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const ::std::string& sLogoLink_);

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const char* sLogoLink_);

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const char* value, size_t size);

    static const T_DAB_LogoElement &getDefaultInstance();

private:

    inline void set_has_u32ServiceID ();

    inline void clear_has_u32ServiceID ();

    inline void set_has_sLogoLink ();

    inline void clear_has_sLogoLink ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ServiceID;

    ::std::string _sLogoLink;

};

/**
 * ContentID structure
 */
class T_DAB_ContentID {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_ContentID ();

    /**
     * Copy constructor
     */
    inline  T_DAB_ContentID (const T_DAB_ContentID &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_ContentID (uint32 u32ServiceID_, uint8 u8Scid_);

    /**
     * Destructor
     */
    inline  ~T_DAB_ContentID();

    /**
     * Assignment operator
     */
    inline T_DAB_ContentID& operator = (const T_DAB_ContentID& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_ContentID& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_ContentID& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_ContentID& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_ContentID& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ServiceID"

    static const int kU32ServiceID = 0;

    /**
     * Clears the field "u32ServiceID".
     *
     * The field will be set to its default value. The hasU32ServiceID()
     * method will return false.
     */
    inline void clearU32ServiceID();

    /**
     * Checks whether the field "u32ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ServiceID()). Otherwise it will return false.
     */
    inline bool hasU32ServiceID () const;

    /**
     * Returns the value of the member "u32ServiceID".
     *
     * Serviceid
     *
     * @return The value of the field "u32ServiceID"
     */
    inline uint32 getU32ServiceID () const;

    /**
     * Sets the value of the member "u32ServiceID".
     *
     * Serviceid
     *
     * @param u32ServiceID The value which will be set
     */
    inline void setU32ServiceID (uint32 u32ServiceID_);

    // API of field "u8Scid"

    static const int kU8Scid = 1;

    /**
     * Clears the field "u8Scid".
     *
     * The field will be set to its default value. The hasU8Scid()
     * method will return false.
     */
    inline void clearU8Scid();

    /**
     * Checks whether the field "u8Scid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Scid()). Otherwise it will return false.
     */
    inline bool hasU8Scid () const;

    /**
     * Returns the value of the member "u8Scid".
     *
     * Secondary service id
     *
     * @return The value of the field "u8Scid"
     */
    inline uint8 getU8Scid () const;

    /**
     * Sets the value of the member "u8Scid".
     *
     * Secondary service id
     *
     * @param u8Scid The value which will be set
     */
    inline void setU8Scid (uint8 u8Scid_);

    static const T_DAB_ContentID &getDefaultInstance();

private:

    inline void set_has_u32ServiceID ();

    inline void clear_has_u32ServiceID ();

    inline void set_has_u8Scid ();

    inline void clear_has_u8Scid ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ServiceID;

    uint8 _u8Scid;

};

/**
 * Parameters for the Tune command.
 */
class T_DAB_TuneParam {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_TuneParam ();

    /**
     * Copy constructor
     */
    inline  T_DAB_TuneParam (const T_DAB_TuneParam &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_TuneParam (T_e8_DAB_TuneType e8TuneType_, uint32 u32Value_);

    /**
     * Destructor
     */
    inline  ~T_DAB_TuneParam();

    /**
     * Assignment operator
     */
    inline T_DAB_TuneParam& operator = (const T_DAB_TuneParam& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_TuneParam& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_TuneParam& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_TuneParam& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_TuneParam& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TuneType"

    static const int kE8TuneType = 0;

    /**
     * Clears the field "e8TuneType".
     *
     * The field will be set to its default value. The hasE8TuneType()
     * method will return false.
     */
    inline void clearE8TuneType();

    /**
     * Checks whether the field "e8TuneType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TuneType()). Otherwise it will return false.
     */
    inline bool hasE8TuneType () const;

    /**
     * Returns the value of the member "e8TuneType".
     *
     * DAB Tune type.
     *
     * @return The value of the field "e8TuneType"
     */
    inline T_e8_DAB_TuneType getE8TuneType () const;

    /**
     * Sets the value of the member "e8TuneType".
     *
     * DAB Tune type.
     *
     * @param e8TuneType The value which will be set
     */
    inline void setE8TuneType (T_e8_DAB_TuneType e8TuneType_);

    // API of field "u32Value"

    static const int kU32Value = 1;

    /**
     * Clears the field "u32Value".
     *
     * The field will be set to its default value. The hasU32Value()
     * method will return false.
     */
    inline void clearU32Value();

    /**
     * Checks whether the field "u32Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Value()). Otherwise it will return false.
     */
    inline bool hasU32Value () const;

    /**
     * Returns the value of the member "u32Value".
     *
     * Depends on tune-type.
     *
     * @return The value of the field "u32Value"
     */
    inline uint32 getU32Value () const;

    /**
     * Sets the value of the member "u32Value".
     *
     * Depends on tune-type.
     *
     * @param u32Value The value which will be set
     */
    inline void setU32Value (uint32 u32Value_);

    static const T_DAB_TuneParam &getDefaultInstance();

private:

    inline void set_has_e8TuneType ();

    inline void clear_has_e8TuneType ();

    inline void set_has_u32Value ();

    inline void clear_has_u32Value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_DAB_TuneType _e8TuneType;

    uint32 _u32Value;

};

/**
 * Parameters for the Learn command.
 */
class T_DAB_LearnParam {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_LearnParam ();

    /**
     * Copy constructor
     */
    inline  T_DAB_LearnParam (const T_DAB_LearnParam &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_LearnParam (T_e8_DAB_LearnType e8LearnType_, bool bRollback_);

    /**
     * Destructor
     */
    inline  ~T_DAB_LearnParam();

    /**
     * Assignment operator
     */
    inline T_DAB_LearnParam& operator = (const T_DAB_LearnParam& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_LearnParam& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_LearnParam& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_LearnParam& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_LearnParam& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LearnType"

    static const int kE8LearnType = 0;

    /**
     * Clears the field "e8LearnType".
     *
     * The field will be set to its default value. The hasE8LearnType()
     * method will return false.
     */
    inline void clearE8LearnType();

    /**
     * Checks whether the field "e8LearnType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LearnType()). Otherwise it will return false.
     */
    inline bool hasE8LearnType () const;

    /**
     * Returns the value of the member "e8LearnType".
     *
     * DAB Learn type.
     *
     * @return The value of the field "e8LearnType"
     */
    inline T_e8_DAB_LearnType getE8LearnType () const;

    /**
     * Sets the value of the member "e8LearnType".
     *
     * DAB Learn type.
     *
     * @param e8LearnType The value which will be set
     */
    inline void setE8LearnType (T_e8_DAB_LearnType e8LearnType_);

    // API of field "bRollback"

    static const int kBRollback = 1;

    /**
     * Clears the field "bRollback".
     *
     * The field will be set to its default value. The hasBRollback()
     * method will return false.
     */
    inline void clearBRollback();

    /**
     * Checks whether the field "bRollback" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRollback()). Otherwise it will return false.
     */
    inline bool hasBRollback () const;

    /**
     * Returns the value of the member "bRollback".
     *
     * If this parameter is set to TRUE the complete learn memory is stored before starting the learn.
     * This way, in case that the learn procedure is stopped, the previous content of the learn memory is recovered.
     * Its value is only needed when e8LearnType == DAB_LEARNTYPE_VIRGIN.
     *
     * @return The value of the field "bRollback"
     */
    inline bool getBRollback () const;

    /**
     * Sets the value of the member "bRollback".
     *
     * If this parameter is set to TRUE the complete learn memory is stored before starting the learn.
     * This way, in case that the learn procedure is stopped, the previous content of the learn memory is recovered.
     * Its value is only needed when e8LearnType == DAB_LEARNTYPE_VIRGIN.
     *
     * @param bRollback The value which will be set
     */
    inline void setBRollback (bool bRollback_);

    static const T_DAB_LearnParam &getDefaultInstance();

private:

    inline void set_has_e8LearnType ();

    inline void clear_has_e8LearnType ();

    inline void set_has_bRollback ();

    inline void clear_has_bRollback ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_DAB_LearnType _e8LearnType;

    bool _bRollback;

};

/**
 * Setup Mask
 */
class T_b32_DAB_SetupMask {
public:

    /**
     * Default constructor
     */
    inline  T_b32_DAB_SetupMask ();

    /**
     * Copy constructor
     */
    inline  T_b32_DAB_SetupMask (const T_b32_DAB_SetupMask &c);

    /**
     * Field constructor
     */
    inline  T_b32_DAB_SetupMask (bool DAB_SETUPOPERATIONMASK_b0_reserved, bool DAB_SETUPOPERATIONMASK_b1_reserved);

    /**
     * Assignment operator
     */
    inline T_b32_DAB_SetupMask& operator = (const T_b32_DAB_SetupMask& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_DAB_SetupMask& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_DAB_SetupMask& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_DAB_SetupMask& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_DAB_SetupMask& rhs) const;

    /**
     * Sets the value of the member "DAB_SETUPOPERATIONMASK_b0_reserved".
     *
     * If the meaning of "DAB_SETUPOPERATIONMASK_b0_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPOPERATIONMASK_b0_reserved The value which will be set
     */
    inline void setDAB_SETUPOPERATIONMASK_b0_reserved (bool DAB_SETUPOPERATIONMASK_b0_reserved);

    /**
     * Returns the value of the member "DAB_SETUPOPERATIONMASK_b0_reserved".
     *
     * If the meaning of "DAB_SETUPOPERATIONMASK_b0_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPOPERATIONMASK_b0_reserved"
     */
    inline bool getDAB_SETUPOPERATIONMASK_b0_reserved () const;

    /**
     * Sets the value of the member "DAB_SETUPOPERATIONMASK_b1_reserved".
     *
     * If the meaning of "DAB_SETUPOPERATIONMASK_b1_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPOPERATIONMASK_b1_reserved The value which will be set
     */
    inline void setDAB_SETUPOPERATIONMASK_b1_reserved (bool DAB_SETUPOPERATIONMASK_b1_reserved);

    /**
     * Returns the value of the member "DAB_SETUPOPERATIONMASK_b1_reserved".
     *
     * If the meaning of "DAB_SETUPOPERATIONMASK_b1_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPOPERATIONMASK_b1_reserved"
     */
    inline bool getDAB_SETUPOPERATIONMASK_b1_reserved () const;

    static const T_b32_DAB_SetupMask &getDefaultInstance();

private:

    bool _DAB_SETUPOPERATIONMASK_b0_reserved:1;

    bool _DAB_SETUPOPERATIONMASK_b1_reserved:1;

};

/**
 * Setup Flags
 */
class T_b32_DAB_SetupFlags {
public:

    /**
     * Default constructor
     */
    inline  T_b32_DAB_SetupFlags ();

    /**
     * Copy constructor
     */
    inline  T_b32_DAB_SetupFlags (const T_b32_DAB_SetupFlags &c);

    /**
     * Field constructor
     */
    inline  T_b32_DAB_SetupFlags (bool DAB_SETUPOPERATION_SWITCHON_b0_reserved, bool DAB_SETUPOPERATION_SWITCHON_b1_reserved);

    /**
     * Assignment operator
     */
    inline T_b32_DAB_SetupFlags& operator = (const T_b32_DAB_SetupFlags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_DAB_SetupFlags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_DAB_SetupFlags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_DAB_SetupFlags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_DAB_SetupFlags& rhs) const;

    /**
     * Sets the value of the member "DAB_SETUPOPERATION_SWITCHON_b0_reserved".
     *
     * If the meaning of "DAB_SETUPOPERATION_SWITCHON_b0_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPOPERATION_SWITCHON_b0_reserved The value which will be set
     */
    inline void setDAB_SETUPOPERATION_SWITCHON_b0_reserved (bool DAB_SETUPOPERATION_SWITCHON_b0_reserved);

    /**
     * Returns the value of the member "DAB_SETUPOPERATION_SWITCHON_b0_reserved".
     *
     * If the meaning of "DAB_SETUPOPERATION_SWITCHON_b0_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPOPERATION_SWITCHON_b0_reserved"
     */
    inline bool getDAB_SETUPOPERATION_SWITCHON_b0_reserved () const;

    /**
     * Sets the value of the member "DAB_SETUPOPERATION_SWITCHON_b1_reserved".
     *
     * If the meaning of "DAB_SETUPOPERATION_SWITCHON_b1_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPOPERATION_SWITCHON_b1_reserved The value which will be set
     */
    inline void setDAB_SETUPOPERATION_SWITCHON_b1_reserved (bool DAB_SETUPOPERATION_SWITCHON_b1_reserved);

    /**
     * Returns the value of the member "DAB_SETUPOPERATION_SWITCHON_b1_reserved".
     *
     * If the meaning of "DAB_SETUPOPERATION_SWITCHON_b1_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPOPERATION_SWITCHON_b1_reserved"
     */
    inline bool getDAB_SETUPOPERATION_SWITCHON_b1_reserved () const;

    static const T_b32_DAB_SetupFlags &getDefaultInstance();

private:

    bool _DAB_SETUPOPERATION_SWITCHON_b0_reserved:1;

    bool _DAB_SETUPOPERATION_SWITCHON_b1_reserved:1;

};

/**
 * Setup Mask for linking thresholds
 */
class T_b8_DAB_LinkingSetupMask {
public:

    /**
     * Default constructor
     */
    inline  T_b8_DAB_LinkingSetupMask ();

    /**
     * Copy constructor
     */
    inline  T_b8_DAB_LinkingSetupMask (const T_b8_DAB_LinkingSetupMask &c);

    /**
     * Field constructor
     */
    inline  T_b8_DAB_LinkingSetupMask (bool DAB_SETUPLINKING_TH_NONE, bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH, bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH, bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME, bool DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY);

    /**
     * Assignment operator
     */
    inline T_b8_DAB_LinkingSetupMask& operator = (const T_b8_DAB_LinkingSetupMask& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_DAB_LinkingSetupMask& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_DAB_LinkingSetupMask& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_DAB_LinkingSetupMask& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_DAB_LinkingSetupMask& rhs) const;

    /**
     * Sets the value of the member "DAB_SETUPLINKING_TH_NONE".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_NONE" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPLINKING_TH_NONE The value which will be set
     */
    inline void setDAB_SETUPLINKING_TH_NONE (bool DAB_SETUPLINKING_TH_NONE);

    /**
     * Returns the value of the member "DAB_SETUPLINKING_TH_NONE".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_NONE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPLINKING_TH_NONE"
     */
    inline bool getDAB_SETUPLINKING_TH_NONE () const;

    /**
     * Sets the value of the member "DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH The value which will be set
     */
    inline void setDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH (bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH);

    /**
     * Returns the value of the member "DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH"
     */
    inline bool getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH () const;

    /**
     * Sets the value of the member "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH The value which will be set
     */
    inline void setDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH (bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH);

    /**
     * Returns the value of the member "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH"
     */
    inline bool getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH () const;

    /**
     * Sets the value of the member "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME The value which will be set
     */
    inline void setDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME (bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME);

    /**
     * Returns the value of the member "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME"
     */
    inline bool getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME () const;

    /**
     * Sets the value of the member "DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY" isn't clear, then there should be a description here.
     *
     * @param DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY The value which will be set
     */
    inline void setDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY (bool DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY);

    /**
     * Returns the value of the member "DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY".
     *
     * If the meaning of "DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY"
     */
    inline bool getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY () const;

    static const T_b8_DAB_LinkingSetupMask &getDefaultInstance();

private:

    bool _DAB_SETUPLINKING_TH_NONE:1;

    bool _DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH:1;

    bool _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH:1;

    bool _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME:1;

    bool _DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY:1;

};

/**
 * Status of external service following (DAB-FM).
 */
class T_b8_DAB_ExtServFollowingFlags {
public:

    /**
     * Default constructor
     */
    inline  T_b8_DAB_ExtServFollowingFlags ();

    /**
     * Copy constructor
     */
    inline  T_b8_DAB_ExtServFollowingFlags (const T_b8_DAB_ExtServFollowingFlags &c);

    /**
     * Field constructor
     */
    inline  T_b8_DAB_ExtServFollowingFlags (bool DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION, bool DAB_EXTSERVFOLLOWING_SWITCH_DONE, bool DAB_EXTSERVFOLLOWING_SWITCH_REJECTED);

    /**
     * Assignment operator
     */
    inline T_b8_DAB_ExtServFollowingFlags& operator = (const T_b8_DAB_ExtServFollowingFlags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_DAB_ExtServFollowingFlags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_DAB_ExtServFollowingFlags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_DAB_ExtServFollowingFlags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_DAB_ExtServFollowingFlags& rhs) const;

    /**
     * Sets the value of the member "DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION".
     *
     * If the meaning of "DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION" isn't clear, then there should be a description here.
     *
     * @param DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION The value which will be set
     */
    inline void setDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION (bool DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION);

    /**
     * Returns the value of the member "DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION".
     *
     * If the meaning of "DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION"
     */
    inline bool getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION () const;

    /**
     * Sets the value of the member "DAB_EXTSERVFOLLOWING_SWITCH_DONE".
     *
     * If the meaning of "DAB_EXTSERVFOLLOWING_SWITCH_DONE" isn't clear, then there should be a description here.
     *
     * @param DAB_EXTSERVFOLLOWING_SWITCH_DONE The value which will be set
     */
    inline void setDAB_EXTSERVFOLLOWING_SWITCH_DONE (bool DAB_EXTSERVFOLLOWING_SWITCH_DONE);

    /**
     * Returns the value of the member "DAB_EXTSERVFOLLOWING_SWITCH_DONE".
     *
     * If the meaning of "DAB_EXTSERVFOLLOWING_SWITCH_DONE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_EXTSERVFOLLOWING_SWITCH_DONE"
     */
    inline bool getDAB_EXTSERVFOLLOWING_SWITCH_DONE () const;

    /**
     * Sets the value of the member "DAB_EXTSERVFOLLOWING_SWITCH_REJECTED".
     *
     * If the meaning of "DAB_EXTSERVFOLLOWING_SWITCH_REJECTED" isn't clear, then there should be a description here.
     *
     * @param DAB_EXTSERVFOLLOWING_SWITCH_REJECTED The value which will be set
     */
    inline void setDAB_EXTSERVFOLLOWING_SWITCH_REJECTED (bool DAB_EXTSERVFOLLOWING_SWITCH_REJECTED);

    /**
     * Returns the value of the member "DAB_EXTSERVFOLLOWING_SWITCH_REJECTED".
     *
     * If the meaning of "DAB_EXTSERVFOLLOWING_SWITCH_REJECTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_EXTSERVFOLLOWING_SWITCH_REJECTED"
     */
    inline bool getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED () const;

    static const T_b8_DAB_ExtServFollowingFlags &getDefaultInstance();

private:

    bool _DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION:1;

    bool _DAB_EXTSERVFOLLOWING_SWITCH_DONE:1;

    bool _DAB_EXTSERVFOLLOWING_SWITCH_REJECTED:1;

};

/**
 * DAB Tuner preset list elements are contained in this structure.
 */
class T_DAB_PresetListElement {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_PresetListElement ();

    /**
     * Copy constructor
     */
    inline  T_DAB_PresetListElement (const T_DAB_PresetListElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_PresetListElement (uint8 u8PresetElementID_, uint32 u32ServiceID_, const T_DAB_Label& ServiceLabel_, uint32 u32Frequency_, uint8 u8Scid_, const T_DAB_Label& ComponentLabel_, uint32 u32EnsembleId_, const T_DAB_Label& EnsembleLabel_, const ::std::string& sLogoLink_);

    /**
     * Destructor
     */
    inline  ~T_DAB_PresetListElement();

    /**
     * Assignment operator
     */
    inline T_DAB_PresetListElement& operator = (const T_DAB_PresetListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_PresetListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_PresetListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_PresetListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_PresetListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8PresetElementID"

    static const int kU8PresetElementID = 0;

    /**
     * Clears the field "u8PresetElementID".
     *
     * The field will be set to its default value. The hasU8PresetElementID()
     * method will return false.
     */
    inline void clearU8PresetElementID();

    /**
     * Checks whether the field "u8PresetElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PresetElementID()). Otherwise it will return false.
     */
    inline bool hasU8PresetElementID () const;

    /**
     * Returns the value of the member "u8PresetElementID".
     *
     * Element ID of the DAB preset element transmitted.
     *
     * @return The value of the field "u8PresetElementID"
     */
    inline uint8 getU8PresetElementID () const;

    /**
     * Sets the value of the member "u8PresetElementID".
     *
     * Element ID of the DAB preset element transmitted.
     *
     * @param u8PresetElementID The value which will be set
     */
    inline void setU8PresetElementID (uint8 u8PresetElementID_);

    // API of field "u32ServiceID"

    static const int kU32ServiceID = 1;

    /**
     * Clears the field "u32ServiceID".
     *
     * The field will be set to its default value. The hasU32ServiceID()
     * method will return false.
     */
    inline void clearU32ServiceID();

    /**
     * Checks whether the field "u32ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ServiceID()). Otherwise it will return false.
     */
    inline bool hasU32ServiceID () const;

    /**
     * Returns the value of the member "u32ServiceID".
     *
     * ServiceID
     *
     * @return The value of the field "u32ServiceID"
     */
    inline uint32 getU32ServiceID () const;

    /**
     * Sets the value of the member "u32ServiceID".
     *
     * ServiceID
     *
     * @param u32ServiceID The value which will be set
     */
    inline void setU32ServiceID (uint32 u32ServiceID_);

    // API of field "ServiceLabel"

    static const int kServiceLabel = 2;

    /**
     * Clears the field "ServiceLabel".
     *
     * The field will be set to its default value. The hasServiceLabel()
     * method will return false.
     */
    inline void clearServiceLabel();

    /**
     * Checks whether the field "ServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceLabel()). Otherwise it will return false.
     */
    inline bool hasServiceLabel () const;

    /**
     * Returns the value of the member "ServiceLabel".
     *
     * Service label of the DAB preset element.
     *
     * @return The value of the field "ServiceLabel"
     */
    inline const T_DAB_Label& getServiceLabel () const;

    /**
     * Retrieves the value of the field "ServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ServiceLabel".
     */
    inline T_DAB_Label& getServiceLabelMutable ();

    /**
     * Sets the value of the member "ServiceLabel".
     *
     * Service label of the DAB preset element.
     *
     * @param ServiceLabel The value which will be set
     */
    inline void setServiceLabel (const T_DAB_Label& ServiceLabel_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 3;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Freqeuncy of current ensemble
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Freqeuncy of current ensemble
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u8Scid"

    static const int kU8Scid = 4;

    /**
     * Clears the field "u8Scid".
     *
     * The field will be set to its default value. The hasU8Scid()
     * method will return false.
     */
    inline void clearU8Scid();

    /**
     * Checks whether the field "u8Scid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Scid()). Otherwise it will return false.
     */
    inline bool hasU8Scid () const;

    /**
     * Returns the value of the member "u8Scid".
     *
     * Secondary service id
     *
     * @return The value of the field "u8Scid"
     */
    inline uint8 getU8Scid () const;

    /**
     * Sets the value of the member "u8Scid".
     *
     * Secondary service id
     *
     * @param u8Scid The value which will be set
     */
    inline void setU8Scid (uint8 u8Scid_);

    // API of field "ComponentLabel"

    static const int kComponentLabel = 5;

    /**
     * Clears the field "ComponentLabel".
     *
     * The field will be set to its default value. The hasComponentLabel()
     * method will return false.
     */
    inline void clearComponentLabel();

    /**
     * Checks whether the field "ComponentLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComponentLabel()). Otherwise it will return false.
     */
    inline bool hasComponentLabel () const;

    /**
     * Returns the value of the member "ComponentLabel".
     *
     * Component label
     *
     * @return The value of the field "ComponentLabel"
     */
    inline const T_DAB_Label& getComponentLabel () const;

    /**
     * Retrieves the value of the field "ComponentLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ComponentLabel".
     */
    inline T_DAB_Label& getComponentLabelMutable ();

    /**
     * Sets the value of the member "ComponentLabel".
     *
     * Component label
     *
     * @param ComponentLabel The value which will be set
     */
    inline void setComponentLabel (const T_DAB_Label& ComponentLabel_);

    // API of field "u32EnsembleId"

    static const int kU32EnsembleId = 6;

    /**
     * Clears the field "u32EnsembleId".
     *
     * The field will be set to its default value. The hasU32EnsembleId()
     * method will return false.
     */
    inline void clearU32EnsembleId();

    /**
     * Checks whether the field "u32EnsembleId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EnsembleId()). Otherwise it will return false.
     */
    inline bool hasU32EnsembleId () const;

    /**
     * Returns the value of the member "u32EnsembleId".
     *
     * Ensemble id
     *
     * @return The value of the field "u32EnsembleId"
     */
    inline uint32 getU32EnsembleId () const;

    /**
     * Sets the value of the member "u32EnsembleId".
     *
     * Ensemble id
     *
     * @param u32EnsembleId The value which will be set
     */
    inline void setU32EnsembleId (uint32 u32EnsembleId_);

    // API of field "EnsembleLabel"

    static const int kEnsembleLabel = 7;

    /**
     * Clears the field "EnsembleLabel".
     *
     * The field will be set to its default value. The hasEnsembleLabel()
     * method will return false.
     */
    inline void clearEnsembleLabel();

    /**
     * Checks whether the field "EnsembleLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnsembleLabel()). Otherwise it will return false.
     */
    inline bool hasEnsembleLabel () const;

    /**
     * Returns the value of the member "EnsembleLabel".
     *
     * Ensemble label
     *
     * @return The value of the field "EnsembleLabel"
     */
    inline const T_DAB_Label& getEnsembleLabel () const;

    /**
     * Retrieves the value of the field "EnsembleLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnsembleLabel".
     */
    inline T_DAB_Label& getEnsembleLabelMutable ();

    /**
     * Sets the value of the member "EnsembleLabel".
     *
     * Ensemble label
     *
     * @param EnsembleLabel The value which will be set
     */
    inline void setEnsembleLabel (const T_DAB_Label& EnsembleLabel_);

    // API of field "sLogoLink"

    static const int kSLogoLink = 8;

    /**
     * Clears the field "sLogoLink".
     *
     * The field will be set to its default value. The hasSLogoLink()
     * method will return false.
     */
    inline void clearSLogoLink();

    /**
     * Checks whether the field "sLogoLink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLogoLink()). Otherwise it will return false.
     */
    inline bool hasSLogoLink () const;

    /**
     * Returns the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @return The value of the field "sLogoLink"
     */
    inline const ::std::string& getSLogoLink () const;

    /**
     * Retrieves the value of the field "sLogoLink" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLogoLink".
     */
    inline ::std::string& getSLogoLinkMutable ();

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const ::std::string& sLogoLink_);

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const char* sLogoLink_);

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const char* value, size_t size);

    static const T_DAB_PresetListElement &getDefaultInstance();

private:

    inline void set_has_u8PresetElementID ();

    inline void clear_has_u8PresetElementID ();

    inline void set_has_u32ServiceID ();

    inline void clear_has_u32ServiceID ();

    inline void set_has_ServiceLabel ();

    inline void clear_has_ServiceLabel ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u8Scid ();

    inline void clear_has_u8Scid ();

    inline void set_has_ComponentLabel ();

    inline void clear_has_ComponentLabel ();

    inline void set_has_u32EnsembleId ();

    inline void clear_has_u32EnsembleId ();

    inline void set_has_EnsembleLabel ();

    inline void clear_has_EnsembleLabel ();

    inline void set_has_sLogoLink ();

    inline void clear_has_sLogoLink ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint8 _u8PresetElementID;

    uint32 _u32ServiceID;

    T_DAB_Label _ServiceLabel;

    uint32 _u32Frequency;

    uint8 _u8Scid;

    T_DAB_Label _ComponentLabel;

    uint32 _u32EnsembleId;

    T_DAB_Label _EnsembleLabel;

    ::std::string _sLogoLink;

};

/**
 * The list elements (service or component) are contained in this structure.
 */
class T_DAB_ChnListElement {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_ChnListElement ();

    /**
     * Copy constructor
     */
    inline  T_DAB_ChnListElement (const T_DAB_ChnListElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_ChnListElement (uint16 u16ListElementID_, uint32 u32DABId_, uint8 u8CompScids_, const T_DAB_Label& Label_, const T_DAB_Label& EnsembleLabel_, const ::std::string& sFreqLabel_, uint8 u8PresetListElemId_, uint8 u8PTY_, uint16 u16ASU_, bool bReception_, uint8 u8NumberOfComponents_, uint8 u8ServiceLinkMode_, const ::std::string& sLogoLink_, uint8 bEPGSupport_);

    /**
     * Destructor
     */
    inline  ~T_DAB_ChnListElement();

    /**
     * Assignment operator
     */
    inline T_DAB_ChnListElement& operator = (const T_DAB_ChnListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_ChnListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_ChnListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_ChnListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_ChnListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListElementID"

    static const int kU16ListElementID = 0;

    /**
     * Clears the field "u16ListElementID".
     *
     * The field will be set to its default value. The hasU16ListElementID()
     * method will return false.
     */
    inline void clearU16ListElementID();

    /**
     * Checks whether the field "u16ListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListElementID()). Otherwise it will return false.
     */
    inline bool hasU16ListElementID () const;

    /**
     * Returns the value of the member "u16ListElementID".
     *
     * Element ID of the element transmitted.
     *
     * @return The value of the field "u16ListElementID"
     */
    inline uint16 getU16ListElementID () const;

    /**
     * Sets the value of the member "u16ListElementID".
     *
     * Element ID of the element transmitted.
     *
     * @param u16ListElementID The value which will be set
     */
    inline void setU16ListElementID (uint16 u16ListElementID_);

    // API of field "u32DABId"

    static const int kU32DABId = 1;

    /**
     * Clears the field "u32DABId".
     *
     * The field will be set to its default value. The hasU32DABId()
     * method will return false.
     */
    inline void clearU32DABId();

    /**
     * Checks whether the field "u32DABId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DABId()). Otherwise it will return false.
     */
    inline bool hasU32DABId () const;

    /**
     * Returns the value of the member "u32DABId".
     *
     * ServiceId or ComponentId, depending on the value of e8ListType.
     *
     * @return The value of the field "u32DABId"
     */
    inline uint32 getU32DABId () const;

    /**
     * Sets the value of the member "u32DABId".
     *
     * ServiceId or ComponentId, depending on the value of e8ListType.
     *
     * @param u32DABId The value which will be set
     */
    inline void setU32DABId (uint32 u32DABId_);

    // API of field "u8CompScids"

    static const int kU8CompScids = 2;

    /**
     * Clears the field "u8CompScids".
     *
     * The field will be set to its default value. The hasU8CompScids()
     * method will return false.
     */
    inline void clearU8CompScids();

    /**
     * Checks whether the field "u8CompScids" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CompScids()). Otherwise it will return false.
     */
    inline bool hasU8CompScids () const;

    /**
     * Returns the value of the member "u8CompScids".
     *
     * Secondary ComponentID, it will be zero for Primary Service and non-zero for Secondary Service
     *
     * @return The value of the field "u8CompScids"
     */
    inline uint8 getU8CompScids () const;

    /**
     * Sets the value of the member "u8CompScids".
     *
     * Secondary ComponentID, it will be zero for Primary Service and non-zero for Secondary Service
     *
     * @param u8CompScids The value which will be set
     */
    inline void setU8CompScids (uint8 u8CompScids_);

    // API of field "Label"

    static const int kLabel = 3;

    /**
     * Clears the field "Label".
     *
     * The field will be set to its default value. The hasLabel()
     * method will return false.
     */
    inline void clearLabel();

    /**
     * Checks whether the field "Label" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLabel()). Otherwise it will return false.
     */
    inline bool hasLabel () const;

    /**
     * Returns the value of the member "Label".
     *
     * Service label or component label of the list element.
     *
     * @return The value of the field "Label"
     */
    inline const T_DAB_Label& getLabel () const;

    /**
     * Retrieves the value of the field "Label" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Label".
     */
    inline T_DAB_Label& getLabelMutable ();

    /**
     * Sets the value of the member "Label".
     *
     * Service label or component label of the list element.
     *
     * @param Label The value which will be set
     */
    inline void setLabel (const T_DAB_Label& Label_);

    // API of field "EnsembleLabel"

    static const int kEnsembleLabel = 4;

    /**
     * Clears the field "EnsembleLabel".
     *
     * The field will be set to its default value. The hasEnsembleLabel()
     * method will return false.
     */
    inline void clearEnsembleLabel();

    /**
     * Checks whether the field "EnsembleLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnsembleLabel()). Otherwise it will return false.
     */
    inline bool hasEnsembleLabel () const;

    /**
     * Returns the value of the member "EnsembleLabel".
     *
     * Ensemble Label
     *
     * @return The value of the field "EnsembleLabel"
     */
    inline const T_DAB_Label& getEnsembleLabel () const;

    /**
     * Retrieves the value of the field "EnsembleLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnsembleLabel".
     */
    inline T_DAB_Label& getEnsembleLabelMutable ();

    /**
     * Sets the value of the member "EnsembleLabel".
     *
     * Ensemble Label
     *
     * @param EnsembleLabel The value which will be set
     */
    inline void setEnsembleLabel (const T_DAB_Label& EnsembleLabel_);

    // API of field "sFreqLabel"

    static const int kSFreqLabel = 5;

    /**
     * Clears the field "sFreqLabel".
     *
     * The field will be set to its default value. The hasSFreqLabel()
     * method will return false.
     */
    inline void clearSFreqLabel();

    /**
     * Checks whether the field "sFreqLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFreqLabel()). Otherwise it will return false.
     */
    inline bool hasSFreqLabel () const;

    /**
     * Returns the value of the member "sFreqLabel".
     *
     * Frequency Label
     *
     * @return The value of the field "sFreqLabel"
     */
    inline const ::std::string& getSFreqLabel () const;

    /**
     * Retrieves the value of the field "sFreqLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFreqLabel".
     */
    inline ::std::string& getSFreqLabelMutable ();

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Frequency Label
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const ::std::string& sFreqLabel_);

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Frequency Label
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const char* sFreqLabel_);

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Frequency Label
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const char* value, size_t size);

    // API of field "u8PresetListElemId"

    static const int kU8PresetListElemId = 6;

    /**
     * Clears the field "u8PresetListElemId".
     *
     * The field will be set to its default value. The hasU8PresetListElemId()
     * method will return false.
     */
    inline void clearU8PresetListElemId();

    /**
     * Checks whether the field "u8PresetListElemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PresetListElemId()). Otherwise it will return false.
     */
    inline bool hasU8PresetListElemId () const;

    /**
     * Returns the value of the member "u8PresetListElemId".
     *
     * Matching preset list element, only supported for service list. If no matching is
     * available, the value will be 0.
     *
     * @return The value of the field "u8PresetListElemId"
     */
    inline uint8 getU8PresetListElemId () const;

    /**
     * Sets the value of the member "u8PresetListElemId".
     *
     * Matching preset list element, only supported for service list. If no matching is
     * available, the value will be 0.
     *
     * @param u8PresetListElemId The value which will be set
     */
    inline void setU8PresetListElemId (uint8 u8PresetListElemId_);

    // API of field "u8PTY"

    static const int kU8PTY = 7;

    /**
     * Clears the field "u8PTY".
     *
     * The field will be set to its default value. The hasU8PTY()
     * method will return false.
     */
    inline void clearU8PTY();

    /**
     * Checks whether the field "u8PTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PTY()). Otherwise it will return false.
     */
    inline bool hasU8PTY () const;

    /**
     * Returns the value of the member "u8PTY".
     *
     * PTY of list element.
     *
     * @return The value of the field "u8PTY"
     */
    inline uint8 getU8PTY () const;

    /**
     * Sets the value of the member "u8PTY".
     *
     * PTY of list element.
     *
     * @param u8PTY The value which will be set
     */
    inline void setU8PTY (uint8 u8PTY_);

    // API of field "u16ASU"

    static const int kU16ASU = 8;

    /**
     * Clears the field "u16ASU".
     *
     * The field will be set to its default value. The hasU16ASU()
     * method will return false.
     */
    inline void clearU16ASU();

    /**
     * Checks whether the field "u16ASU" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ASU()). Otherwise it will return false.
     */
    inline bool hasU16ASU () const;

    /**
     * Returns the value of the member "u16ASU".
     *
     * Supported announcements by list element.
     *
     * @return The value of the field "u16ASU"
     */
    inline uint16 getU16ASU () const;

    /**
     * Sets the value of the member "u16ASU".
     *
     * Supported announcements by list element.
     *
     * @param u16ASU The value which will be set
     */
    inline void setU16ASU (uint16 u16ASU_);

    // API of field "bReception"

    static const int kBReception = 9;

    /**
     * Clears the field "bReception".
     *
     * The field will be set to its default value. The hasBReception()
     * method will return false.
     */
    inline void clearBReception();

    /**
     * Checks whether the field "bReception" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReception()). Otherwise it will return false.
     */
    inline bool hasBReception () const;

    /**
     * Returns the value of the member "bReception".
     *
     * TRUE if reception is expected to be OK
     *
     * @return The value of the field "bReception"
     */
    inline bool getBReception () const;

    /**
     * Sets the value of the member "bReception".
     *
     * TRUE if reception is expected to be OK
     *
     * @param bReception The value which will be set
     */
    inline void setBReception (bool bReception_);

    // API of field "u8NumberOfComponents"

    static const int kU8NumberOfComponents = 10;

    /**
     * Clears the field "u8NumberOfComponents".
     *
     * The field will be set to its default value. The hasU8NumberOfComponents()
     * method will return false.
     */
    inline void clearU8NumberOfComponents();

    /**
     * Checks whether the field "u8NumberOfComponents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfComponents()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfComponents () const;

    /**
     * Returns the value of the member "u8NumberOfComponents".
     *
     * Number Of service components
     *
     * @return The value of the field "u8NumberOfComponents"
     */
    inline uint8 getU8NumberOfComponents () const;

    /**
     * Sets the value of the member "u8NumberOfComponents".
     *
     * Number Of service components
     *
     * @param u8NumberOfComponents The value which will be set
     */
    inline void setU8NumberOfComponents (uint8 u8NumberOfComponents_);

    // API of field "u8ServiceLinkMode"

    static const int kU8ServiceLinkMode = 11;

    /**
     * Clears the field "u8ServiceLinkMode".
     *
     * The field will be set to its default value. The hasU8ServiceLinkMode()
     * method will return false.
     */
    inline void clearU8ServiceLinkMode();

    /**
     * Checks whether the field "u8ServiceLinkMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ServiceLinkMode()). Otherwise it will return false.
     */
    inline bool hasU8ServiceLinkMode () const;

    /**
     * Returns the value of the member "u8ServiceLinkMode".
     *
     * Status of Service Linking
     *
     * @return The value of the field "u8ServiceLinkMode"
     */
    inline uint8 getU8ServiceLinkMode () const;

    /**
     * Sets the value of the member "u8ServiceLinkMode".
     *
     * Status of Service Linking
     *
     * @param u8ServiceLinkMode The value which will be set
     */
    inline void setU8ServiceLinkMode (uint8 u8ServiceLinkMode_);

    // API of field "sLogoLink"

    static const int kSLogoLink = 12;

    /**
     * Clears the field "sLogoLink".
     *
     * The field will be set to its default value. The hasSLogoLink()
     * method will return false.
     */
    inline void clearSLogoLink();

    /**
     * Checks whether the field "sLogoLink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLogoLink()). Otherwise it will return false.
     */
    inline bool hasSLogoLink () const;

    /**
     * Returns the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @return The value of the field "sLogoLink"
     */
    inline const ::std::string& getSLogoLink () const;

    /**
     * Retrieves the value of the field "sLogoLink" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLogoLink".
     */
    inline ::std::string& getSLogoLinkMutable ();

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const ::std::string& sLogoLink_);

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const char* sLogoLink_);

    /**
     * Sets the value of the member "sLogoLink".
     *
     * link to logo path
     *
     * @param sLogoLink The value which will be set
     */
    inline void setSLogoLink (const char* value, size_t size);

    // API of field "bEPGSupport"

    static const int kBEPGSupport = 13;

    /**
     * Clears the field "bEPGSupport".
     *
     * The field will be set to its default value. The hasBEPGSupport()
     * method will return false.
     */
    inline void clearBEPGSupport();

    /**
     * Checks whether the field "bEPGSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEPGSupport()). Otherwise it will return false.
     */
    inline bool hasBEPGSupport () const;

    /**
     * Returns the value of the member "bEPGSupport".
     *
     * supports EPG or not
     *
     * @return The value of the field "bEPGSupport"
     */
    inline uint8 getBEPGSupport () const;

    /**
     * Sets the value of the member "bEPGSupport".
     *
     * supports EPG or not
     *
     * @param bEPGSupport The value which will be set
     */
    inline void setBEPGSupport (uint8 bEPGSupport_);

    static const T_DAB_ChnListElement &getDefaultInstance();

private:

    inline void set_has_u16ListElementID ();

    inline void clear_has_u16ListElementID ();

    inline void set_has_u32DABId ();

    inline void clear_has_u32DABId ();

    inline void set_has_u8CompScids ();

    inline void clear_has_u8CompScids ();

    inline void set_has_Label ();

    inline void clear_has_Label ();

    inline void set_has_EnsembleLabel ();

    inline void clear_has_EnsembleLabel ();

    inline void set_has_sFreqLabel ();

    inline void clear_has_sFreqLabel ();

    inline void set_has_u8PresetListElemId ();

    inline void clear_has_u8PresetListElemId ();

    inline void set_has_u8PTY ();

    inline void clear_has_u8PTY ();

    inline void set_has_u16ASU ();

    inline void clear_has_u16ASU ();

    inline void set_has_bReception ();

    inline void clear_has_bReception ();

    inline void set_has_u8NumberOfComponents ();

    inline void clear_has_u8NumberOfComponents ();

    inline void set_has_u8ServiceLinkMode ();

    inline void clear_has_u8ServiceLinkMode ();

    inline void set_has_sLogoLink ();

    inline void clear_has_sLogoLink ();

    inline void set_has_bEPGSupport ();

    inline void clear_has_bEPGSupport ();

    uint32 _has_bits_[ (14 + 31) / 32];

    uint16 _u16ListElementID;

    uint32 _u32DABId;

    uint8 _u8CompScids;

    T_DAB_Label _Label;

    T_DAB_Label _EnsembleLabel;

    ::std::string _sFreqLabel;

    uint8 _u8PresetListElemId;

    uint8 _u8PTY;

    uint16 _u16ASU;

    bool _bReception;

    uint8 _u8NumberOfComponents;

    uint8 _u8ServiceLinkMode;

    ::std::string _sLogoLink;

    uint8 _bEPGSupport;

};

/**
 * The list elements (service or component) are contained in this structure.
 */
class T_DAB_ListElementAvailInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_ListElementAvailInfo ();

    /**
     * Copy constructor
     */
    inline  T_DAB_ListElementAvailInfo (const T_DAB_ListElementAvailInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_ListElementAvailInfo (uint16 u16ListElementID_, bool bAvailable_);

    /**
     * Destructor
     */
    inline  ~T_DAB_ListElementAvailInfo();

    /**
     * Assignment operator
     */
    inline T_DAB_ListElementAvailInfo& operator = (const T_DAB_ListElementAvailInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_ListElementAvailInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_ListElementAvailInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_ListElementAvailInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_ListElementAvailInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListElementID"

    static const int kU16ListElementID = 0;

    /**
     * Clears the field "u16ListElementID".
     *
     * The field will be set to its default value. The hasU16ListElementID()
     * method will return false.
     */
    inline void clearU16ListElementID();

    /**
     * Checks whether the field "u16ListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListElementID()). Otherwise it will return false.
     */
    inline bool hasU16ListElementID () const;

    /**
     * Returns the value of the member "u16ListElementID".
     *
     * Element ID of the element.
     *
     * @return The value of the field "u16ListElementID"
     */
    inline uint16 getU16ListElementID () const;

    /**
     * Sets the value of the member "u16ListElementID".
     *
     * Element ID of the element.
     *
     * @param u16ListElementID The value which will be set
     */
    inline void setU16ListElementID (uint16 u16ListElementID_);

    // API of field "bAvailable"

    static const int kBAvailable = 1;

    /**
     * Clears the field "bAvailable".
     *
     * The field will be set to its default value. The hasBAvailable()
     * method will return false.
     */
    inline void clearBAvailable();

    /**
     * Checks whether the field "bAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAvailable()). Otherwise it will return false.
     */
    inline bool hasBAvailable () const;

    /**
     * Returns the value of the member "bAvailable".
     *
     * Availability of the list element, TRUE=Available.
     *
     * @return The value of the field "bAvailable"
     */
    inline bool getBAvailable () const;

    /**
     * Sets the value of the member "bAvailable".
     *
     * Availability of the list element, TRUE=Available.
     *
     * @param bAvailable The value which will be set
     */
    inline void setBAvailable (bool bAvailable_);

    static const T_DAB_ListElementAvailInfo &getDefaultInstance();

private:

    inline void set_has_u16ListElementID ();

    inline void clear_has_u16ListElementID ();

    inline void set_has_bAvailable ();

    inline void clear_has_bAvailable ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16ListElementID;

    bool _bAvailable;

};

/**
 * The TII list elements are contained in this structure.
 */
class T_DAB_TIIListElement {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_TIIListElement ();

    /**
     * Copy constructor
     */
    inline  T_DAB_TIIListElement (const T_DAB_TIIListElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_TIIListElement (uint8 u8MainId_, uint8 u8SubId_, uint32 u32Latitude_, uint32 u32Longitude_);

    /**
     * Destructor
     */
    inline  ~T_DAB_TIIListElement();

    /**
     * Assignment operator
     */
    inline T_DAB_TIIListElement& operator = (const T_DAB_TIIListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_TIIListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_TIIListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_TIIListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_TIIListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8MainId"

    static const int kU8MainId = 0;

    /**
     * Clears the field "u8MainId".
     *
     * The field will be set to its default value. The hasU8MainId()
     * method will return false.
     */
    inline void clearU8MainId();

    /**
     * Checks whether the field "u8MainId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MainId()). Otherwise it will return false.
     */
    inline bool hasU8MainId () const;

    /**
     * Returns the value of the member "u8MainId".
     *
     * Main id of teh transmitter
     *
     * @return The value of the field "u8MainId"
     */
    inline uint8 getU8MainId () const;

    /**
     * Sets the value of the member "u8MainId".
     *
     * Main id of teh transmitter
     *
     * @param u8MainId The value which will be set
     */
    inline void setU8MainId (uint8 u8MainId_);

    // API of field "u8SubId"

    static const int kU8SubId = 1;

    /**
     * Clears the field "u8SubId".
     *
     * The field will be set to its default value. The hasU8SubId()
     * method will return false.
     */
    inline void clearU8SubId();

    /**
     * Checks whether the field "u8SubId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SubId()). Otherwise it will return false.
     */
    inline bool hasU8SubId () const;

    /**
     * Returns the value of the member "u8SubId".
     *
     * Sub id of the transmitter
     *
     * @return The value of the field "u8SubId"
     */
    inline uint8 getU8SubId () const;

    /**
     * Sets the value of the member "u8SubId".
     *
     * Sub id of the transmitter
     *
     * @param u8SubId The value which will be set
     */
    inline void setU8SubId (uint8 u8SubId_);

    // API of field "u32Latitude"

    static const int kU32Latitude = 2;

    /**
     * Clears the field "u32Latitude".
     *
     * The field will be set to its default value. The hasU32Latitude()
     * method will return false.
     */
    inline void clearU32Latitude();

    /**
     * Checks whether the field "u32Latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Latitude()). Otherwise it will return false.
     */
    inline bool hasU32Latitude () const;

    /**
     * Returns the value of the member "u32Latitude".
     *
     * Positive (negative) latitudes indicate a position north (south) of the equator
     *
     * @return The value of the field "u32Latitude"
     */
    inline uint32 getU32Latitude () const;

    /**
     * Sets the value of the member "u32Latitude".
     *
     * Positive (negative) latitudes indicate a position north (south) of the equator
     *
     * @param u32Latitude The value which will be set
     */
    inline void setU32Latitude (uint32 u32Latitude_);

    // API of field "u32Longitude"

    static const int kU32Longitude = 3;

    /**
     * Clears the field "u32Longitude".
     *
     * The field will be set to its default value. The hasU32Longitude()
     * method will return false.
     */
    inline void clearU32Longitude();

    /**
     * Checks whether the field "u32Longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Longitude()). Otherwise it will return false.
     */
    inline bool hasU32Longitude () const;

    /**
     * Returns the value of the member "u32Longitude".
     *
     * Positive (negative)longitudes indicate positions east (west) of Greenwich.
     *
     * @return The value of the field "u32Longitude"
     */
    inline uint32 getU32Longitude () const;

    /**
     * Sets the value of the member "u32Longitude".
     *
     * Positive (negative)longitudes indicate positions east (west) of Greenwich.
     *
     * @param u32Longitude The value which will be set
     */
    inline void setU32Longitude (uint32 u32Longitude_);

    static const T_DAB_TIIListElement &getDefaultInstance();

private:

    inline void set_has_u8MainId ();

    inline void clear_has_u8MainId ();

    inline void set_has_u8SubId ();

    inline void clear_has_u8SubId ();

    inline void set_has_u32Latitude ();

    inline void clear_has_u32Latitude ();

    inline void set_has_u32Longitude ();

    inline void clear_has_u32Longitude ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8MainId;

    uint8 _u8SubId;

    uint32 _u32Latitude;

    uint32 _u32Longitude;

};

class T_b8_DAB_TestMode_Flags {
public:

    /**
     * Default constructor
     */
    inline  T_b8_DAB_TestMode_Flags ();

    /**
     * Copy constructor
     */
    inline  T_b8_DAB_TestMode_Flags (const T_b8_DAB_TestMode_Flags &c);

    /**
     * Field constructor
     */
    inline  T_b8_DAB_TestMode_Flags (bool DAB_TESTMODE_FLAGS_AUDIOSOURCE, bool DAB_TESTMODE_FLAGS_SFINT, bool DAB_TESTMODE_FLAGS_b2_reserved, bool DAB_TESTMODE_FLAGS_b3_reserved, bool DAB_TESTMODE_FLAGS_b4_reserved, bool DAB_TESTMODE_FLAGS_b5_reserved, bool DAB_TESTMODE_FLAGS_b6_reserved, bool DAB_TESTMODE_FLAGS_b7_reserved);

    /**
     * Assignment operator
     */
    inline T_b8_DAB_TestMode_Flags& operator = (const T_b8_DAB_TestMode_Flags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_DAB_TestMode_Flags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_DAB_TestMode_Flags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_DAB_TestMode_Flags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_DAB_TestMode_Flags& rhs) const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_AUDIOSOURCE".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_AUDIOSOURCE" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_AUDIOSOURCE The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_AUDIOSOURCE (bool DAB_TESTMODE_FLAGS_AUDIOSOURCE);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_AUDIOSOURCE".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_AUDIOSOURCE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_AUDIOSOURCE"
     */
    inline bool getDAB_TESTMODE_FLAGS_AUDIOSOURCE () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_SFINT".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_SFINT" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_SFINT The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_SFINT (bool DAB_TESTMODE_FLAGS_SFINT);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_SFINT".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_SFINT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_SFINT"
     */
    inline bool getDAB_TESTMODE_FLAGS_SFINT () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b2_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b2_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b2_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b2_reserved (bool DAB_TESTMODE_FLAGS_b2_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b2_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b2_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b2_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b2_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b3_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b3_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b3_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b3_reserved (bool DAB_TESTMODE_FLAGS_b3_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b3_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b3_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b3_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b3_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b4_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b4_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b4_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b4_reserved (bool DAB_TESTMODE_FLAGS_b4_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b4_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b4_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b4_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b4_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b5_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b5_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b5_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b5_reserved (bool DAB_TESTMODE_FLAGS_b5_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b5_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b5_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b5_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b5_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b6_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b6_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b6_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b6_reserved (bool DAB_TESTMODE_FLAGS_b6_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b6_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b6_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b6_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b6_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b7_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b7_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b7_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b7_reserved (bool DAB_TESTMODE_FLAGS_b7_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b7_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b7_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b7_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b7_reserved () const;

    static const T_b8_DAB_TestMode_Flags &getDefaultInstance();

private:

    bool _DAB_TESTMODE_FLAGS_AUDIOSOURCE:1;

    bool _DAB_TESTMODE_FLAGS_SFINT:1;

    bool _DAB_TESTMODE_FLAGS_b2_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b3_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b4_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b5_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b6_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b7_reserved:1;

};

class T_b8_DAB_ALT_FM_Valid_Flags {
public:

    /**
     * Default constructor
     */
    inline  T_b8_DAB_ALT_FM_Valid_Flags ();

    /**
     * Copy constructor
     */
    inline  T_b8_DAB_ALT_FM_Valid_Flags (const T_b8_DAB_ALT_FM_Valid_Flags &c);

    /**
     * Field constructor
     */
    inline  T_b8_DAB_ALT_FM_Valid_Flags (bool DAB_FM_ALT_FM_PI_VALID_FLAG, bool DAB_FM_ALT_FM_FREQ_VALID_FLAG, bool DAB_FM_ALT_FM_QUALITY_VALID_FLAG, bool DAB_TESTMODE_FLAGS_b3_reserved, bool DAB_TESTMODE_FLAGS_b4_reserved, bool DAB_TESTMODE_FLAGS_b5_reserved, bool DAB_TESTMODE_FLAGS_b6_reserved, bool DAB_TESTMODE_FLAGS_b7_reserved);

    /**
     * Assignment operator
     */
    inline T_b8_DAB_ALT_FM_Valid_Flags& operator = (const T_b8_DAB_ALT_FM_Valid_Flags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) const;

    /**
     * Sets the value of the member "DAB_FM_ALT_FM_PI_VALID_FLAG".
     *
     * If the meaning of "DAB_FM_ALT_FM_PI_VALID_FLAG" isn't clear, then there should be a description here.
     *
     * @param DAB_FM_ALT_FM_PI_VALID_FLAG The value which will be set
     */
    inline void setDAB_FM_ALT_FM_PI_VALID_FLAG (bool DAB_FM_ALT_FM_PI_VALID_FLAG);

    /**
     * Returns the value of the member "DAB_FM_ALT_FM_PI_VALID_FLAG".
     *
     * If the meaning of "DAB_FM_ALT_FM_PI_VALID_FLAG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_FM_ALT_FM_PI_VALID_FLAG"
     */
    inline bool getDAB_FM_ALT_FM_PI_VALID_FLAG () const;

    /**
     * Sets the value of the member "DAB_FM_ALT_FM_FREQ_VALID_FLAG".
     *
     * If the meaning of "DAB_FM_ALT_FM_FREQ_VALID_FLAG" isn't clear, then there should be a description here.
     *
     * @param DAB_FM_ALT_FM_FREQ_VALID_FLAG The value which will be set
     */
    inline void setDAB_FM_ALT_FM_FREQ_VALID_FLAG (bool DAB_FM_ALT_FM_FREQ_VALID_FLAG);

    /**
     * Returns the value of the member "DAB_FM_ALT_FM_FREQ_VALID_FLAG".
     *
     * If the meaning of "DAB_FM_ALT_FM_FREQ_VALID_FLAG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_FM_ALT_FM_FREQ_VALID_FLAG"
     */
    inline bool getDAB_FM_ALT_FM_FREQ_VALID_FLAG () const;

    /**
     * Sets the value of the member "DAB_FM_ALT_FM_QUALITY_VALID_FLAG".
     *
     * If the meaning of "DAB_FM_ALT_FM_QUALITY_VALID_FLAG" isn't clear, then there should be a description here.
     *
     * @param DAB_FM_ALT_FM_QUALITY_VALID_FLAG The value which will be set
     */
    inline void setDAB_FM_ALT_FM_QUALITY_VALID_FLAG (bool DAB_FM_ALT_FM_QUALITY_VALID_FLAG);

    /**
     * Returns the value of the member "DAB_FM_ALT_FM_QUALITY_VALID_FLAG".
     *
     * If the meaning of "DAB_FM_ALT_FM_QUALITY_VALID_FLAG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_FM_ALT_FM_QUALITY_VALID_FLAG"
     */
    inline bool getDAB_FM_ALT_FM_QUALITY_VALID_FLAG () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b3_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b3_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b3_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b3_reserved (bool DAB_TESTMODE_FLAGS_b3_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b3_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b3_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b3_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b3_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b4_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b4_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b4_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b4_reserved (bool DAB_TESTMODE_FLAGS_b4_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b4_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b4_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b4_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b4_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b5_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b5_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b5_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b5_reserved (bool DAB_TESTMODE_FLAGS_b5_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b5_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b5_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b5_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b5_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b6_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b6_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b6_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b6_reserved (bool DAB_TESTMODE_FLAGS_b6_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b6_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b6_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b6_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b6_reserved () const;

    /**
     * Sets the value of the member "DAB_TESTMODE_FLAGS_b7_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b7_reserved" isn't clear, then there should be a description here.
     *
     * @param DAB_TESTMODE_FLAGS_b7_reserved The value which will be set
     */
    inline void setDAB_TESTMODE_FLAGS_b7_reserved (bool DAB_TESTMODE_FLAGS_b7_reserved);

    /**
     * Returns the value of the member "DAB_TESTMODE_FLAGS_b7_reserved".
     *
     * If the meaning of "DAB_TESTMODE_FLAGS_b7_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB_TESTMODE_FLAGS_b7_reserved"
     */
    inline bool getDAB_TESTMODE_FLAGS_b7_reserved () const;

    static const T_b8_DAB_ALT_FM_Valid_Flags &getDefaultInstance();

private:

    bool _DAB_FM_ALT_FM_PI_VALID_FLAG:1;

    bool _DAB_FM_ALT_FM_FREQ_VALID_FLAG:1;

    bool _DAB_FM_ALT_FM_QUALITY_VALID_FLAG:1;

    bool _DAB_TESTMODE_FLAGS_b3_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b4_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b5_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b6_reserved:1;

    bool _DAB_TESTMODE_FLAGS_b7_reserved:1;

};

/**
 * DAB Link List Element parameters are contained in this structure.
 */
class T_DAB_LinkListElem {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_LinkListElem ();

    /**
     * Copy constructor
     */
    inline  T_DAB_LinkListElem (const T_DAB_LinkListElem &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_LinkListElem (T_e8_DAB_LinkType e8LinkType_, const ::std::string& sFreqLabel_, uint32 u32ID_, uint32 u32EnsembleId_, uint8 u8Quality_);

    /**
     * Destructor
     */
    inline  ~T_DAB_LinkListElem();

    /**
     * Assignment operator
     */
    inline T_DAB_LinkListElem& operator = (const T_DAB_LinkListElem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_LinkListElem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_LinkListElem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_LinkListElem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_LinkListElem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LinkType"

    static const int kE8LinkType = 0;

    /**
     * Clears the field "e8LinkType".
     *
     * The field will be set to its default value. The hasE8LinkType()
     * method will return false.
     */
    inline void clearE8LinkType();

    /**
     * Checks whether the field "e8LinkType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LinkType()). Otherwise it will return false.
     */
    inline bool hasE8LinkType () const;

    /**
     * Returns the value of the member "e8LinkType".
     *
     *
     *
     * @return The value of the field "e8LinkType"
     */
    inline T_e8_DAB_LinkType getE8LinkType () const;

    /**
     * Sets the value of the member "e8LinkType".
     *
     *
     *
     * @param e8LinkType The value which will be set
     */
    inline void setE8LinkType (T_e8_DAB_LinkType e8LinkType_);

    // API of field "sFreqLabel"

    static const int kSFreqLabel = 1;

    /**
     * Clears the field "sFreqLabel".
     *
     * The field will be set to its default value. The hasSFreqLabel()
     * method will return false.
     */
    inline void clearSFreqLabel();

    /**
     * Checks whether the field "sFreqLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFreqLabel()). Otherwise it will return false.
     */
    inline bool hasSFreqLabel () const;

    /**
     * Returns the value of the member "sFreqLabel".
     *
     * Label of the service linking frequency. Max characters: 3. In case of link type LINKTYPE_FM_NOLINK,
     * the corresponding FM Frequency is not known to the DAB tuner and will contain an empty string.
     *
     * @return The value of the field "sFreqLabel"
     */
    inline const ::std::string& getSFreqLabel () const;

    /**
     * Retrieves the value of the field "sFreqLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFreqLabel".
     */
    inline ::std::string& getSFreqLabelMutable ();

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Label of the service linking frequency. Max characters: 3. In case of link type LINKTYPE_FM_NOLINK,
     * the corresponding FM Frequency is not known to the DAB tuner and will contain an empty string.
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const ::std::string& sFreqLabel_);

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Label of the service linking frequency. Max characters: 3. In case of link type LINKTYPE_FM_NOLINK,
     * the corresponding FM Frequency is not known to the DAB tuner and will contain an empty string.
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const char* sFreqLabel_);

    /**
     * Sets the value of the member "sFreqLabel".
     *
     * Label of the service linking frequency. Max characters: 3. In case of link type LINKTYPE_FM_NOLINK,
     * the corresponding FM Frequency is not known to the DAB tuner and will contain an empty string.
     *
     * @param sFreqLabel The value which will be set
     */
    inline void setSFreqLabel (const char* value, size_t size);

    // API of field "u32ID"

    static const int kU32ID = 2;

    /**
     * Clears the field "u32ID".
     *
     * The field will be set to its default value. The hasU32ID()
     * method will return false.
     */
    inline void clearU32ID();

    /**
     * Checks whether the field "u32ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ID()). Otherwise it will return false.
     */
    inline bool hasU32ID () const;

    /**
     * Returns the value of the member "u32ID".
     *
     * DAB ServiceId or FM PI.
     *
     * @return The value of the field "u32ID"
     */
    inline uint32 getU32ID () const;

    /**
     * Sets the value of the member "u32ID".
     *
     * DAB ServiceId or FM PI.
     *
     * @param u32ID The value which will be set
     */
    inline void setU32ID (uint32 u32ID_);

    // API of field "u32EnsembleId"

    static const int kU32EnsembleId = 3;

    /**
     * Clears the field "u32EnsembleId".
     *
     * The field will be set to its default value. The hasU32EnsembleId()
     * method will return false.
     */
    inline void clearU32EnsembleId();

    /**
     * Checks whether the field "u32EnsembleId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EnsembleId()). Otherwise it will return false.
     */
    inline bool hasU32EnsembleId () const;

    /**
     * Returns the value of the member "u32EnsembleId".
     *
     *
     *
     * @return The value of the field "u32EnsembleId"
     */
    inline uint32 getU32EnsembleId () const;

    /**
     * Sets the value of the member "u32EnsembleId".
     *
     *
     *
     * @param u32EnsembleId The value which will be set
     */
    inline void setU32EnsembleId (uint32 u32EnsembleId_);

    // API of field "u8Quality"

    static const int kU8Quality = 4;

    /**
     * Clears the field "u8Quality".
     *
     * The field will be set to its default value. The hasU8Quality()
     * method will return false.
     */
    inline void clearU8Quality();

    /**
     * Checks whether the field "u8Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Quality()). Otherwise it will return false.
     */
    inline bool hasU8Quality () const;

    /**
     * Returns the value of the member "u8Quality".
     *
     * .
     *
     * @return The value of the field "u8Quality"
     */
    inline uint8 getU8Quality () const;

    /**
     * Sets the value of the member "u8Quality".
     *
     * .
     *
     * @param u8Quality The value which will be set
     */
    inline void setU8Quality (uint8 u8Quality_);

    static const T_DAB_LinkListElem &getDefaultInstance();

private:

    inline void set_has_e8LinkType ();

    inline void clear_has_e8LinkType ();

    inline void set_has_sFreqLabel ();

    inline void clear_has_sFreqLabel ();

    inline void set_has_u32ID ();

    inline void clear_has_u32ID ();

    inline void set_has_u32EnsembleId ();

    inline void clear_has_u32EnsembleId ();

    inline void set_has_u8Quality ();

    inline void clear_has_u8Quality ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_DAB_LinkType _e8LinkType;

    ::std::string _sFreqLabel;

    uint32 _u32ID;

    uint32 _u32EnsembleId;

    uint8 _u8Quality;

};

/**
 * DAB Link List Element parameters are contained in this structure.
 */
class T_DAB_AltFreqInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_AltFreqInfo ();

    /**
     * Copy constructor
     */
    inline  T_DAB_AltFreqInfo (const T_DAB_AltFreqInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_AltFreqInfo (uint32 u32Frequency_, int8 s8FieldStrength_, uint8 u8Quality_);

    /**
     * Destructor
     */
    inline  ~T_DAB_AltFreqInfo();

    /**
     * Assignment operator
     */
    inline T_DAB_AltFreqInfo& operator = (const T_DAB_AltFreqInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_AltFreqInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_AltFreqInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_AltFreqInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_AltFreqInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Frequency"

    static const int kU32Frequency = 0;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Frequency
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Frequency
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "s8FieldStrength"

    static const int kS8FieldStrength = 1;

    /**
     * Clears the field "s8FieldStrength".
     *
     * The field will be set to its default value. The hasS8FieldStrength()
     * method will return false.
     */
    inline void clearS8FieldStrength();

    /**
     * Checks whether the field "s8FieldStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8FieldStrength()). Otherwise it will return false.
     */
    inline bool hasS8FieldStrength () const;

    /**
     * Returns the value of the member "s8FieldStrength".
     *
     * Field Strength
     *
     * @return The value of the field "s8FieldStrength"
     */
    inline int8 getS8FieldStrength () const;

    /**
     * Sets the value of the member "s8FieldStrength".
     *
     * Field Strength
     *
     * @param s8FieldStrength The value which will be set
     */
    inline void setS8FieldStrength (int8 s8FieldStrength_);

    // API of field "u8Quality"

    static const int kU8Quality = 2;

    /**
     * Clears the field "u8Quality".
     *
     * The field will be set to its default value. The hasU8Quality()
     * method will return false.
     */
    inline void clearU8Quality();

    /**
     * Checks whether the field "u8Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Quality()). Otherwise it will return false.
     */
    inline bool hasU8Quality () const;

    /**
     * Returns the value of the member "u8Quality".
     *
     * Quality of signal
     *
     * @return The value of the field "u8Quality"
     */
    inline uint8 getU8Quality () const;

    /**
     * Sets the value of the member "u8Quality".
     *
     * Quality of signal
     *
     * @param u8Quality The value which will be set
     */
    inline void setU8Quality (uint8 u8Quality_);

    static const T_DAB_AltFreqInfo &getDefaultInstance();

private:

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_s8FieldStrength ();

    inline void clear_has_s8FieldStrength ();

    inline void set_has_u8Quality ();

    inline void clear_has_u8Quality ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32Frequency;

    int8 _s8FieldStrength;

    uint8 _u8Quality;

};

/**
 * DAB Test Mode data parameters are contained in this structure.
 */
class T_DAB_TestModeData {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_TestModeData ();

    /**
     * Copy constructor
     */
    inline  T_DAB_TestModeData (const T_DAB_TestModeData &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_TestModeData (uint32 u32CurrentServID_, uint32 u32MSCBER_, uint32 u32FICBER_, uint32 u32NETBER_, uint8 u8RSFEC_, uint8 u8DABMode_, uint8 u8ProtectionLevel_, uint8 u8ConcealmentLevel_, T_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode_, const T_b8_DAB_ALT_FM_Valid_Flags& b8ValidFMValues_, uint16 u16AltFMPI_, uint32 u32AltFMFrequency_, uint8 u8AltFMQuality_, const T_b8_DAB_TestMode_Flags& b8Flags_, int8 s8FieldStrength_, uint16 u16TotalNumberLinks_, uint8 u8ECC_, uint16 u16CountryLabel_, uint16 u16ActivatedLink_, const ::std::vector< T_DAB_LinkListElem >& LinkList_, const ::std::vector< T_DAB_AltFreqInfo >& DAB_DMB_AltFreqInfo_, bool bSync_);

    /**
     * Destructor
     */
    inline  ~T_DAB_TestModeData();

    /**
     * Assignment operator
     */
    inline T_DAB_TestModeData& operator = (const T_DAB_TestModeData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_TestModeData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_TestModeData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_TestModeData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_TestModeData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32CurrentServID"

    static const int kU32CurrentServID = 0;

    /**
     * Clears the field "u32CurrentServID".
     *
     * The field will be set to its default value. The hasU32CurrentServID()
     * method will return false.
     */
    inline void clearU32CurrentServID();

    /**
     * Checks whether the field "u32CurrentServID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32CurrentServID()). Otherwise it will return false.
     */
    inline bool hasU32CurrentServID () const;

    /**
     * Returns the value of the member "u32CurrentServID".
     *
     * ServiceID
     *
     * @return The value of the field "u32CurrentServID"
     */
    inline uint32 getU32CurrentServID () const;

    /**
     * Sets the value of the member "u32CurrentServID".
     *
     * ServiceID
     *
     * @param u32CurrentServID The value which will be set
     */
    inline void setU32CurrentServID (uint32 u32CurrentServID_);

    // API of field "u32MSCBER"

    static const int kU32MSCBER = 1;

    /**
     * Clears the field "u32MSCBER".
     *
     * The field will be set to its default value. The hasU32MSCBER()
     * method will return false.
     */
    inline void clearU32MSCBER();

    /**
     * Checks whether the field "u32MSCBER" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MSCBER()). Otherwise it will return false.
     */
    inline bool hasU32MSCBER () const;

    /**
     * Returns the value of the member "u32MSCBER".
     *
     * Bit Error Rate of the current audio subchannel.
     *
     * @return The value of the field "u32MSCBER"
     */
    inline uint32 getU32MSCBER () const;

    /**
     * Sets the value of the member "u32MSCBER".
     *
     * Bit Error Rate of the current audio subchannel.
     *
     * @param u32MSCBER The value which will be set
     */
    inline void setU32MSCBER (uint32 u32MSCBER_);

    // API of field "u32FICBER"

    static const int kU32FICBER = 2;

    /**
     * Clears the field "u32FICBER".
     *
     * The field will be set to its default value. The hasU32FICBER()
     * method will return false.
     */
    inline void clearU32FICBER();

    /**
     * Checks whether the field "u32FICBER" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FICBER()). Otherwise it will return false.
     */
    inline bool hasU32FICBER () const;

    /**
     * Returns the value of the member "u32FICBER".
     *
     * Bit Error Rate of the Fast Information Channel.
     *
     * @return The value of the field "u32FICBER"
     */
    inline uint32 getU32FICBER () const;

    /**
     * Sets the value of the member "u32FICBER".
     *
     * Bit Error Rate of the Fast Information Channel.
     *
     * @param u32FICBER The value which will be set
     */
    inline void setU32FICBER (uint32 u32FICBER_);

    // API of field "u32NETBER"

    static const int kU32NETBER = 3;

    /**
     * Clears the field "u32NETBER".
     *
     * The field will be set to its default value. The hasU32NETBER()
     * method will return false.
     */
    inline void clearU32NETBER();

    /**
     * Checks whether the field "u32NETBER" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NETBER()). Otherwise it will return false.
     */
    inline bool hasU32NETBER () const;

    /**
     * Returns the value of the member "u32NETBER".
     *
     * Net Bit Error Rate
     *
     * @return The value of the field "u32NETBER"
     */
    inline uint32 getU32NETBER () const;

    /**
     * Sets the value of the member "u32NETBER".
     *
     * Net Bit Error Rate
     *
     * @param u32NETBER The value which will be set
     */
    inline void setU32NETBER (uint32 u32NETBER_);

    // API of field "u8RSFEC"

    static const int kU8RSFEC = 4;

    /**
     * Clears the field "u8RSFEC".
     *
     * The field will be set to its default value. The hasU8RSFEC()
     * method will return false.
     */
    inline void clearU8RSFEC();

    /**
     * Checks whether the field "u8RSFEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RSFEC()). Otherwise it will return false.
     */
    inline bool hasU8RSFEC () const;

    /**
     * Returns the value of the member "u8RSFEC".
     *
     * Forward Error Correction(FEC) for Reed-Soloman coding.
     *
     * @return The value of the field "u8RSFEC"
     */
    inline uint8 getU8RSFEC () const;

    /**
     * Sets the value of the member "u8RSFEC".
     *
     * Forward Error Correction(FEC) for Reed-Soloman coding.
     *
     * @param u8RSFEC The value which will be set
     */
    inline void setU8RSFEC (uint8 u8RSFEC_);

    // API of field "u8DABMode"

    static const int kU8DABMode = 5;

    /**
     * Clears the field "u8DABMode".
     *
     * The field will be set to its default value. The hasU8DABMode()
     * method will return false.
     */
    inline void clearU8DABMode();

    /**
     * Checks whether the field "u8DABMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABMode()). Otherwise it will return false.
     */
    inline bool hasU8DABMode () const;

    /**
     * Returns the value of the member "u8DABMode".
     *
     * DAB transmission mode is a parameter of channel-decoding range 1..4 .
     *
     * @return The value of the field "u8DABMode"
     */
    inline uint8 getU8DABMode () const;

    /**
     * Sets the value of the member "u8DABMode".
     *
     * DAB transmission mode is a parameter of channel-decoding range 1..4 .
     *
     * @param u8DABMode The value which will be set
     */
    inline void setU8DABMode (uint8 u8DABMode_);

    // API of field "u8ProtectionLevel"

    static const int kU8ProtectionLevel = 6;

    /**
     * Clears the field "u8ProtectionLevel".
     *
     * The field will be set to its default value. The hasU8ProtectionLevel()
     * method will return false.
     */
    inline void clearU8ProtectionLevel();

    /**
     * Checks whether the field "u8ProtectionLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ProtectionLevel()). Otherwise it will return false.
     */
    inline bool hasU8ProtectionLevel () const;

    /**
     * Returns the value of the member "u8ProtectionLevel".
     *
     * An ensemble has a maximum bit rate that can be carried, but this depends on which error protection level is used
     *
     * @return The value of the field "u8ProtectionLevel"
     */
    inline uint8 getU8ProtectionLevel () const;

    /**
     * Sets the value of the member "u8ProtectionLevel".
     *
     * An ensemble has a maximum bit rate that can be carried, but this depends on which error protection level is used
     *
     * @param u8ProtectionLevel The value which will be set
     */
    inline void setU8ProtectionLevel (uint8 u8ProtectionLevel_);

    // API of field "u8ConcealmentLevel"

    static const int kU8ConcealmentLevel = 7;

    /**
     * Clears the field "u8ConcealmentLevel".
     *
     * The field will be set to its default value. The hasU8ConcealmentLevel()
     * method will return false.
     */
    inline void clearU8ConcealmentLevel();

    /**
     * Checks whether the field "u8ConcealmentLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ConcealmentLevel()). Otherwise it will return false.
     */
    inline bool hasU8ConcealmentLevel () const;

    /**
     * Returns the value of the member "u8ConcealmentLevel".
     *
     *
     *
     * @return The value of the field "u8ConcealmentLevel"
     */
    inline uint8 getU8ConcealmentLevel () const;

    /**
     * Sets the value of the member "u8ConcealmentLevel".
     *
     *
     *
     * @param u8ConcealmentLevel The value which will be set
     */
    inline void setU8ConcealmentLevel (uint8 u8ConcealmentLevel_);

    // API of field "e8ServiceLinkingMode"

    static const int kE8ServiceLinkingMode = 8;

    /**
     * Clears the field "e8ServiceLinkingMode".
     *
     * The field will be set to its default value. The hasE8ServiceLinkingMode()
     * method will return false.
     */
    inline void clearE8ServiceLinkingMode();

    /**
     * Checks whether the field "e8ServiceLinkingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceLinkingMode()). Otherwise it will return false.
     */
    inline bool hasE8ServiceLinkingMode () const;

    /**
     * Returns the value of the member "e8ServiceLinkingMode".
     *
     *
     *
     * @return The value of the field "e8ServiceLinkingMode"
     */
    inline T_e8_DAB_ServiceLinkingMode getE8ServiceLinkingMode () const;

    /**
     * Sets the value of the member "e8ServiceLinkingMode".
     *
     *
     *
     * @param e8ServiceLinkingMode The value which will be set
     */
    inline void setE8ServiceLinkingMode (T_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode_);

    // API of field "b8ValidFMValues"

    static const int kB8ValidFMValues = 9;

    /**
     * Clears the field "b8ValidFMValues".
     *
     * The field will be set to its default value. The hasB8ValidFMValues()
     * method will return false.
     */
    inline void clearB8ValidFMValues();

    /**
     * Checks whether the field "b8ValidFMValues" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8ValidFMValues()). Otherwise it will return false.
     */
    inline bool hasB8ValidFMValues () const;

    /**
     * Returns the value of the member "b8ValidFMValues".
     *
     * indicates which values form alternative FM are valid.
     *
     * @return The value of the field "b8ValidFMValues"
     */
    inline const T_b8_DAB_ALT_FM_Valid_Flags& getB8ValidFMValues () const;

    /**
     * Retrieves the value of the field "b8ValidFMValues" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8ValidFMValues".
     */
    inline T_b8_DAB_ALT_FM_Valid_Flags& getB8ValidFMValuesMutable ();

    /**
     * Sets the value of the member "b8ValidFMValues".
     *
     * indicates which values form alternative FM are valid.
     *
     * @param b8ValidFMValues The value which will be set
     */
    inline void setB8ValidFMValues (const T_b8_DAB_ALT_FM_Valid_Flags& b8ValidFMValues_);

    // API of field "u16AltFMPI"

    static const int kU16AltFMPI = 10;

    /**
     * Clears the field "u16AltFMPI".
     *
     * The field will be set to its default value. The hasU16AltFMPI()
     * method will return false.
     */
    inline void clearU16AltFMPI();

    /**
     * Checks whether the field "u16AltFMPI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AltFMPI()). Otherwise it will return false.
     */
    inline bool hasU16AltFMPI () const;

    /**
     * Returns the value of the member "u16AltFMPI".
     *
     * Programme identification of the tuned FM programme.
     *
     * @return The value of the field "u16AltFMPI"
     */
    inline uint16 getU16AltFMPI () const;

    /**
     * Sets the value of the member "u16AltFMPI".
     *
     * Programme identification of the tuned FM programme.
     *
     * @param u16AltFMPI The value which will be set
     */
    inline void setU16AltFMPI (uint16 u16AltFMPI_);

    // API of field "u32AltFMFrequency"

    static const int kU32AltFMFrequency = 11;

    /**
     * Clears the field "u32AltFMFrequency".
     *
     * The field will be set to its default value. The hasU32AltFMFrequency()
     * method will return false.
     */
    inline void clearU32AltFMFrequency();

    /**
     * Checks whether the field "u32AltFMFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AltFMFrequency()). Otherwise it will return false.
     */
    inline bool hasU32AltFMFrequency () const;

    /**
     * Returns the value of the member "u32AltFMFrequency".
     *
     * FM frequency for FMLinking in kHz.
     *
     * @return The value of the field "u32AltFMFrequency"
     */
    inline uint32 getU32AltFMFrequency () const;

    /**
     * Sets the value of the member "u32AltFMFrequency".
     *
     * FM frequency for FMLinking in kHz.
     *
     * @param u32AltFMFrequency The value which will be set
     */
    inline void setU32AltFMFrequency (uint32 u32AltFMFrequency_);

    // API of field "u8AltFMQuality"

    static const int kU8AltFMQuality = 12;

    /**
     * Clears the field "u8AltFMQuality".
     *
     * The field will be set to its default value. The hasU8AltFMQuality()
     * method will return false.
     */
    inline void clearU8AltFMQuality();

    /**
     * Checks whether the field "u8AltFMQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AltFMQuality()). Otherwise it will return false.
     */
    inline bool hasU8AltFMQuality () const;

    /**
     * Returns the value of the member "u8AltFMQuality".
     *
     * Quality of the tuned FM programme. (range 0..99)
     *
     * @return The value of the field "u8AltFMQuality"
     */
    inline uint8 getU8AltFMQuality () const;

    /**
     * Sets the value of the member "u8AltFMQuality".
     *
     * Quality of the tuned FM programme. (range 0..99)
     *
     * @param u8AltFMQuality The value which will be set
     */
    inline void setU8AltFMQuality (uint8 u8AltFMQuality_);

    // API of field "b8Flags"

    static const int kB8Flags = 13;

    /**
     * Clears the field "b8Flags".
     *
     * The field will be set to its default value. The hasB8Flags()
     * method will return false.
     */
    inline void clearB8Flags();

    /**
     * Checks whether the field "b8Flags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8Flags()). Otherwise it will return false.
     */
    inline bool hasB8Flags () const;

    /**
     * Returns the value of the member "b8Flags".
     *
     * Status flags for Testmode
     *
     * @return The value of the field "b8Flags"
     */
    inline const T_b8_DAB_TestMode_Flags& getB8Flags () const;

    /**
     * Retrieves the value of the field "b8Flags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8Flags".
     */
    inline T_b8_DAB_TestMode_Flags& getB8FlagsMutable ();

    /**
     * Sets the value of the member "b8Flags".
     *
     * Status flags for Testmode
     *
     * @param b8Flags The value which will be set
     */
    inline void setB8Flags (const T_b8_DAB_TestMode_Flags& b8Flags_);

    // API of field "s8FieldStrength"

    static const int kS8FieldStrength = 14;

    /**
     * Clears the field "s8FieldStrength".
     *
     * The field will be set to its default value. The hasS8FieldStrength()
     * method will return false.
     */
    inline void clearS8FieldStrength();

    /**
     * Checks whether the field "s8FieldStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8FieldStrength()). Otherwise it will return false.
     */
    inline bool hasS8FieldStrength () const;

    /**
     * Returns the value of the member "s8FieldStrength".
     *
     * Field strength in dBm.
     *
     * @return The value of the field "s8FieldStrength"
     */
    inline int8 getS8FieldStrength () const;

    /**
     * Sets the value of the member "s8FieldStrength".
     *
     * Field strength in dBm.
     *
     * @param s8FieldStrength The value which will be set
     */
    inline void setS8FieldStrength (int8 s8FieldStrength_);

    // API of field "u16TotalNumberLinks"

    static const int kU16TotalNumberLinks = 15;

    /**
     * Clears the field "u16TotalNumberLinks".
     *
     * The field will be set to its default value. The hasU16TotalNumberLinks()
     * method will return false.
     */
    inline void clearU16TotalNumberLinks();

    /**
     * Checks whether the field "u16TotalNumberLinks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TotalNumberLinks()). Otherwise it will return false.
     */
    inline bool hasU16TotalNumberLinks () const;

    /**
     * Returns the value of the member "u16TotalNumberLinks".
     *
     * Total Number of elements in the active list.
     *
     * @return The value of the field "u16TotalNumberLinks"
     */
    inline uint16 getU16TotalNumberLinks () const;

    /**
     * Sets the value of the member "u16TotalNumberLinks".
     *
     * Total Number of elements in the active list.
     *
     * @param u16TotalNumberLinks The value which will be set
     */
    inline void setU16TotalNumberLinks (uint16 u16TotalNumberLinks_);

    // API of field "u8ECC"

    static const int kU8ECC = 16;

    /**
     * Clears the field "u8ECC".
     *
     * The field will be set to its default value. The hasU8ECC()
     * method will return false.
     */
    inline void clearU8ECC();

    /**
     * Checks whether the field "u8ECC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ECC()). Otherwise it will return false.
     */
    inline bool hasU8ECC () const;

    /**
     * Returns the value of the member "u8ECC".
     *
     * Extended Country Code
     *
     * @return The value of the field "u8ECC"
     */
    inline uint8 getU8ECC () const;

    /**
     * Sets the value of the member "u8ECC".
     *
     * Extended Country Code
     *
     * @param u8ECC The value which will be set
     */
    inline void setU8ECC (uint8 u8ECC_);

    // API of field "u16CountryLabel"

    static const int kU16CountryLabel = 17;

    /**
     * Clears the field "u16CountryLabel".
     *
     * The field will be set to its default value. The hasU16CountryLabel()
     * method will return false.
     */
    inline void clearU16CountryLabel();

    /**
     * Checks whether the field "u16CountryLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CountryLabel()). Otherwise it will return false.
     */
    inline bool hasU16CountryLabel () const;

    /**
     * Returns the value of the member "u16CountryLabel".
     *
     * Country Label of all ITU regions
     *
     * @return The value of the field "u16CountryLabel"
     */
    inline uint16 getU16CountryLabel () const;

    /**
     * Sets the value of the member "u16CountryLabel".
     *
     * Country Label of all ITU regions
     *
     * @param u16CountryLabel The value which will be set
     */
    inline void setU16CountryLabel (uint16 u16CountryLabel_);

    // API of field "u16ActivatedLink"

    static const int kU16ActivatedLink = 18;

    /**
     * Clears the field "u16ActivatedLink".
     *
     * The field will be set to its default value. The hasU16ActivatedLink()
     * method will return false.
     */
    inline void clearU16ActivatedLink();

    /**
     * Checks whether the field "u16ActivatedLink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ActivatedLink()). Otherwise it will return false.
     */
    inline bool hasU16ActivatedLink () const;

    /**
     * Returns the value of the member "u16ActivatedLink".
     *
     * The currently used link. First element of list has index 1.
     * 0 means that no link is used.
     *
     * @return The value of the field "u16ActivatedLink"
     */
    inline uint16 getU16ActivatedLink () const;

    /**
     * Sets the value of the member "u16ActivatedLink".
     *
     * The currently used link. First element of list has index 1.
     * 0 means that no link is used.
     *
     * @param u16ActivatedLink The value which will be set
     */
    inline void setU16ActivatedLink (uint16 u16ActivatedLink_);

    // API of field "LinkList"

    static const int kLinkList = 19;

    /**
     * Clears the field "LinkList".
     *
     * The field will be set to its default value. The hasLinkList()
     * method will return false.
     */
    inline void clearLinkList();

    /**
     * Checks whether the field "LinkList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLinkList()). Otherwise it will return false.
     */
    inline bool hasLinkList () const;

    /**
     * Returns the value of the member "LinkList".
     *
     * List containing information for each link
     *
     * @return The value of the field "LinkList"
     */
    inline const ::std::vector< T_DAB_LinkListElem >& getLinkList () const;

    /**
     * Retrieves the value of the field "LinkList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LinkList".
     */
    inline ::std::vector< T_DAB_LinkListElem >& getLinkListMutable ();

    /**
     * Sets the value of the member "LinkList".
     *
     * List containing information for each link
     *
     * @param LinkList The value which will be set
     */
    inline void setLinkList (const ::std::vector< T_DAB_LinkListElem >& LinkList_);

    // API of field "DAB_DMB_AltFreqInfo"

    static const int kDAB_DMB_AltFreqInfo = 20;

    /**
     * Clears the field "DAB_DMB_AltFreqInfo".
     *
     * The field will be set to its default value. The hasDAB_DMB_AltFreqInfo()
     * method will return false.
     */
    inline void clearDAB_DMB_AltFreqInfo();

    /**
     * Checks whether the field "DAB_DMB_AltFreqInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDAB_DMB_AltFreqInfo()). Otherwise it will return false.
     */
    inline bool hasDAB_DMB_AltFreqInfo () const;

    /**
     * Returns the value of the member "DAB_DMB_AltFreqInfo".
     *
     * List of alternative frequencies (AF) of the DAB/DMB stations with the field strength and quality of the signal for each freq.
     *
     * @return The value of the field "DAB_DMB_AltFreqInfo"
     */
    inline const ::std::vector< T_DAB_AltFreqInfo >& getDAB_DMB_AltFreqInfo () const;

    /**
     * Retrieves the value of the field "DAB_DMB_AltFreqInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DAB_DMB_AltFreqInfo".
     */
    inline ::std::vector< T_DAB_AltFreqInfo >& getDAB_DMB_AltFreqInfoMutable ();

    /**
     * Sets the value of the member "DAB_DMB_AltFreqInfo".
     *
     * List of alternative frequencies (AF) of the DAB/DMB stations with the field strength and quality of the signal for each freq.
     *
     * @param DAB_DMB_AltFreqInfo The value which will be set
     */
    inline void setDAB_DMB_AltFreqInfo (const ::std::vector< T_DAB_AltFreqInfo >& DAB_DMB_AltFreqInfo_);

    // API of field "bSync"

    static const int kBSync = 21;

    /**
     * Clears the field "bSync".
     *
     * The field will be set to its default value. The hasBSync()
     * method will return false.
     */
    inline void clearBSync();

    /**
     * Checks whether the field "bSync" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSync()). Otherwise it will return false.
     */
    inline bool hasBSync () const;

    /**
     * Returns the value of the member "bSync".
     *
     * TRUE means that DAB signal is detected.
     * FALSE means that no DAB signal is present.
     *
     * @return The value of the field "bSync"
     */
    inline bool getBSync () const;

    /**
     * Sets the value of the member "bSync".
     *
     * TRUE means that DAB signal is detected.
     * FALSE means that no DAB signal is present.
     *
     * @param bSync The value which will be set
     */
    inline void setBSync (bool bSync_);

    static const T_DAB_TestModeData &getDefaultInstance();

private:

    static const ::std::vector< T_DAB_LinkListElem >& getT_DAB_LinkListElemList_DefaultInstance ();

    static const ::std::vector< T_DAB_AltFreqInfo >& getT_DAB_AltFreqInfoList_DefaultInstance ();

    inline void set_has_u32CurrentServID ();

    inline void clear_has_u32CurrentServID ();

    inline void set_has_u32MSCBER ();

    inline void clear_has_u32MSCBER ();

    inline void set_has_u32FICBER ();

    inline void clear_has_u32FICBER ();

    inline void set_has_u32NETBER ();

    inline void clear_has_u32NETBER ();

    inline void set_has_u8RSFEC ();

    inline void clear_has_u8RSFEC ();

    inline void set_has_u8DABMode ();

    inline void clear_has_u8DABMode ();

    inline void set_has_u8ProtectionLevel ();

    inline void clear_has_u8ProtectionLevel ();

    inline void set_has_u8ConcealmentLevel ();

    inline void clear_has_u8ConcealmentLevel ();

    inline void set_has_e8ServiceLinkingMode ();

    inline void clear_has_e8ServiceLinkingMode ();

    inline void set_has_b8ValidFMValues ();

    inline void clear_has_b8ValidFMValues ();

    inline void set_has_u16AltFMPI ();

    inline void clear_has_u16AltFMPI ();

    inline void set_has_u32AltFMFrequency ();

    inline void clear_has_u32AltFMFrequency ();

    inline void set_has_u8AltFMQuality ();

    inline void clear_has_u8AltFMQuality ();

    inline void set_has_b8Flags ();

    inline void clear_has_b8Flags ();

    inline void set_has_s8FieldStrength ();

    inline void clear_has_s8FieldStrength ();

    inline void set_has_u16TotalNumberLinks ();

    inline void clear_has_u16TotalNumberLinks ();

    inline void set_has_u8ECC ();

    inline void clear_has_u8ECC ();

    inline void set_has_u16CountryLabel ();

    inline void clear_has_u16CountryLabel ();

    inline void set_has_u16ActivatedLink ();

    inline void clear_has_u16ActivatedLink ();

    inline void set_has_LinkList ();

    inline void clear_has_LinkList ();

    inline void set_has_DAB_DMB_AltFreqInfo ();

    inline void clear_has_DAB_DMB_AltFreqInfo ();

    inline void set_has_bSync ();

    inline void clear_has_bSync ();

    uint32 _has_bits_[ (22 + 31) / 32];

    uint32 _u32CurrentServID;

    uint32 _u32MSCBER;

    uint32 _u32FICBER;

    uint32 _u32NETBER;

    uint8 _u8RSFEC;

    uint8 _u8DABMode;

    uint8 _u8ProtectionLevel;

    uint8 _u8ConcealmentLevel;

    T_e8_DAB_ServiceLinkingMode _e8ServiceLinkingMode;

    T_b8_DAB_ALT_FM_Valid_Flags _b8ValidFMValues;

    uint16 _u16AltFMPI;

    uint32 _u32AltFMFrequency;

    uint8 _u8AltFMQuality;

    T_b8_DAB_TestMode_Flags _b8Flags;

    int8 _s8FieldStrength;

    uint16 _u16TotalNumberLinks;

    uint8 _u8ECC;

    uint16 _u16CountryLabel;

    uint16 _u16ActivatedLink;

    ::std::vector< T_DAB_LinkListElem > _LinkList;

    ::std::vector< T_DAB_AltFreqInfo > _DAB_DMB_AltFreqInfo;

    bool _bSync;

};

/**
 * DAB Test Mode data parameters for dab background tuner information are contained in this structure.
 */
class T_DAB_BG_TestModeData {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_BG_TestModeData ();

    /**
     * Copy constructor
     */
    inline  T_DAB_BG_TestModeData (const T_DAB_BG_TestModeData &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_BG_TestModeData (uint32 u32BgFrequency_, uint32 u32BgCurrentEnsID_, uint32 u32BgFICBER_, const T_b16_DAB_TunerStatusFlags& b16BgFlags_, const ::std::string& sBgDabMode_);

    /**
     * Destructor
     */
    inline  ~T_DAB_BG_TestModeData();

    /**
     * Assignment operator
     */
    inline T_DAB_BG_TestModeData& operator = (const T_DAB_BG_TestModeData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_BG_TestModeData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_BG_TestModeData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_BG_TestModeData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_BG_TestModeData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32BgFrequency"

    static const int kU32BgFrequency = 0;

    /**
     * Clears the field "u32BgFrequency".
     *
     * The field will be set to its default value. The hasU32BgFrequency()
     * method will return false.
     */
    inline void clearU32BgFrequency();

    /**
     * Checks whether the field "u32BgFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32BgFrequency()). Otherwise it will return false.
     */
    inline bool hasU32BgFrequency () const;

    /**
     * Returns the value of the member "u32BgFrequency".
     *
     * ensemble frequency of background dab tuner.
     *
     * @return The value of the field "u32BgFrequency"
     */
    inline uint32 getU32BgFrequency () const;

    /**
     * Sets the value of the member "u32BgFrequency".
     *
     * ensemble frequency of background dab tuner.
     *
     * @param u32BgFrequency The value which will be set
     */
    inline void setU32BgFrequency (uint32 u32BgFrequency_);

    // API of field "u32BgCurrentEnsID"

    static const int kU32BgCurrentEnsID = 1;

    /**
     * Clears the field "u32BgCurrentEnsID".
     *
     * The field will be set to its default value. The hasU32BgCurrentEnsID()
     * method will return false.
     */
    inline void clearU32BgCurrentEnsID();

    /**
     * Checks whether the field "u32BgCurrentEnsID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32BgCurrentEnsID()). Otherwise it will return false.
     */
    inline bool hasU32BgCurrentEnsID () const;

    /**
     * Returns the value of the member "u32BgCurrentEnsID".
     *
     * background EnsembleID
     *
     * @return The value of the field "u32BgCurrentEnsID"
     */
    inline uint32 getU32BgCurrentEnsID () const;

    /**
     * Sets the value of the member "u32BgCurrentEnsID".
     *
     * background EnsembleID
     *
     * @param u32BgCurrentEnsID The value which will be set
     */
    inline void setU32BgCurrentEnsID (uint32 u32BgCurrentEnsID_);

    // API of field "u32BgFICBER"

    static const int kU32BgFICBER = 2;

    /**
     * Clears the field "u32BgFICBER".
     *
     * The field will be set to its default value. The hasU32BgFICBER()
     * method will return false.
     */
    inline void clearU32BgFICBER();

    /**
     * Checks whether the field "u32BgFICBER" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32BgFICBER()). Otherwise it will return false.
     */
    inline bool hasU32BgFICBER () const;

    /**
     * Returns the value of the member "u32BgFICBER".
     *
     * background Bit Error Rate of the Fast Information Channel.
     *
     * @return The value of the field "u32BgFICBER"
     */
    inline uint32 getU32BgFICBER () const;

    /**
     * Sets the value of the member "u32BgFICBER".
     *
     * background Bit Error Rate of the Fast Information Channel.
     *
     * @param u32BgFICBER The value which will be set
     */
    inline void setU32BgFICBER (uint32 u32BgFICBER_);

    // API of field "b16BgFlags"

    static const int kB16BgFlags = 3;

    /**
     * Clears the field "b16BgFlags".
     *
     * The field will be set to its default value. The hasB16BgFlags()
     * method will return false.
     */
    inline void clearB16BgFlags();

    /**
     * Checks whether the field "b16BgFlags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB16BgFlags()). Otherwise it will return false.
     */
    inline bool hasB16BgFlags () const;

    /**
     * Returns the value of the member "b16BgFlags".
     *
     * Flags indicating the Background DAB module status.
     * NissanLcn2kai: only sync flag is handled by now
     *
     * @return The value of the field "b16BgFlags"
     */
    inline const T_b16_DAB_TunerStatusFlags& getB16BgFlags () const;

    /**
     * Retrieves the value of the field "b16BgFlags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b16BgFlags".
     */
    inline T_b16_DAB_TunerStatusFlags& getB16BgFlagsMutable ();

    /**
     * Sets the value of the member "b16BgFlags".
     *
     * Flags indicating the Background DAB module status.
     * NissanLcn2kai: only sync flag is handled by now
     *
     * @param b16BgFlags The value which will be set
     */
    inline void setB16BgFlags (const T_b16_DAB_TunerStatusFlags& b16BgFlags_);

    // API of field "sBgDabMode"

    static const int kSBgDabMode = 4;

    /**
     * Clears the field "sBgDabMode".
     *
     * The field will be set to its default value. The hasSBgDabMode()
     * method will return false.
     */
    inline void clearSBgDabMode();

    /**
     * Checks whether the field "sBgDabMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBgDabMode()). Otherwise it will return false.
     */
    inline bool hasSBgDabMode () const;

    /**
     * Returns the value of the member "sBgDabMode".
     *
     * dab background activity.if it is not known to the DAB tuner this will be an empty string.
     *
     * @return The value of the field "sBgDabMode"
     */
    inline const ::std::string& getSBgDabMode () const;

    /**
     * Retrieves the value of the field "sBgDabMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBgDabMode".
     */
    inline ::std::string& getSBgDabModeMutable ();

    /**
     * Sets the value of the member "sBgDabMode".
     *
     * dab background activity.if it is not known to the DAB tuner this will be an empty string.
     *
     * @param sBgDabMode The value which will be set
     */
    inline void setSBgDabMode (const ::std::string& sBgDabMode_);

    /**
     * Sets the value of the member "sBgDabMode".
     *
     * dab background activity.if it is not known to the DAB tuner this will be an empty string.
     *
     * @param sBgDabMode The value which will be set
     */
    inline void setSBgDabMode (const char* sBgDabMode_);

    /**
     * Sets the value of the member "sBgDabMode".
     *
     * dab background activity.if it is not known to the DAB tuner this will be an empty string.
     *
     * @param sBgDabMode The value which will be set
     */
    inline void setSBgDabMode (const char* value, size_t size);

    static const T_DAB_BG_TestModeData &getDefaultInstance();

private:

    inline void set_has_u32BgFrequency ();

    inline void clear_has_u32BgFrequency ();

    inline void set_has_u32BgCurrentEnsID ();

    inline void clear_has_u32BgCurrentEnsID ();

    inline void set_has_u32BgFICBER ();

    inline void clear_has_u32BgFICBER ();

    inline void set_has_b16BgFlags ();

    inline void clear_has_b16BgFlags ();

    inline void set_has_sBgDabMode ();

    inline void clear_has_sBgDabMode ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _u32BgFrequency;

    uint32 _u32BgCurrentEnsID;

    uint32 _u32BgFICBER;

    T_b16_DAB_TunerStatusFlags _b16BgFlags;

    ::std::string _sBgDabMode;

};

/**
 * DAB time.
 */
class T_DAB_Time {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_Time ();

    /**
     * Copy constructor
     */
    inline  T_DAB_Time (const T_DAB_Time &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_Time (uint32 u32DabSec_, uint32 u32DabMin_, uint32 u32DabHour_, uint32 u32DabMday_, uint32 u32DabMon_, uint32 u32DabYear_, uint32 u32DabWday_, uint32 u32DabYday_, uint32 u32DabUtcOff_);

    /**
     * Destructor
     */
    inline  ~T_DAB_Time();

    /**
     * Assignment operator
     */
    inline T_DAB_Time& operator = (const T_DAB_Time& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_Time& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_Time& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_Time& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_Time& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DabSec"

    static const int kU32DabSec = 0;

    /**
     * Clears the field "u32DabSec".
     *
     * The field will be set to its default value. The hasU32DabSec()
     * method will return false.
     */
    inline void clearU32DabSec();

    /**
     * Checks whether the field "u32DabSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabSec()). Otherwise it will return false.
     */
    inline bool hasU32DabSec () const;

    /**
     * Returns the value of the member "u32DabSec".
     *
     * seconds
     *
     * @return The value of the field "u32DabSec"
     */
    inline uint32 getU32DabSec () const;

    /**
     * Sets the value of the member "u32DabSec".
     *
     * seconds
     *
     * @param u32DabSec The value which will be set
     */
    inline void setU32DabSec (uint32 u32DabSec_);

    // API of field "u32DabMin"

    static const int kU32DabMin = 1;

    /**
     * Clears the field "u32DabMin".
     *
     * The field will be set to its default value. The hasU32DabMin()
     * method will return false.
     */
    inline void clearU32DabMin();

    /**
     * Checks whether the field "u32DabMin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabMin()). Otherwise it will return false.
     */
    inline bool hasU32DabMin () const;

    /**
     * Returns the value of the member "u32DabMin".
     *
     * minutes
     *
     * @return The value of the field "u32DabMin"
     */
    inline uint32 getU32DabMin () const;

    /**
     * Sets the value of the member "u32DabMin".
     *
     * minutes
     *
     * @param u32DabMin The value which will be set
     */
    inline void setU32DabMin (uint32 u32DabMin_);

    // API of field "u32DabHour"

    static const int kU32DabHour = 2;

    /**
     * Clears the field "u32DabHour".
     *
     * The field will be set to its default value. The hasU32DabHour()
     * method will return false.
     */
    inline void clearU32DabHour();

    /**
     * Checks whether the field "u32DabHour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabHour()). Otherwise it will return false.
     */
    inline bool hasU32DabHour () const;

    /**
     * Returns the value of the member "u32DabHour".
     *
     * hours
     *
     * @return The value of the field "u32DabHour"
     */
    inline uint32 getU32DabHour () const;

    /**
     * Sets the value of the member "u32DabHour".
     *
     * hours
     *
     * @param u32DabHour The value which will be set
     */
    inline void setU32DabHour (uint32 u32DabHour_);

    // API of field "u32DabMday"

    static const int kU32DabMday = 3;

    /**
     * Clears the field "u32DabMday".
     *
     * The field will be set to its default value. The hasU32DabMday()
     * method will return false.
     */
    inline void clearU32DabMday();

    /**
     * Checks whether the field "u32DabMday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabMday()). Otherwise it will return false.
     */
    inline bool hasU32DabMday () const;

    /**
     * Returns the value of the member "u32DabMday".
     *
     * day of the month
     *
     * @return The value of the field "u32DabMday"
     */
    inline uint32 getU32DabMday () const;

    /**
     * Sets the value of the member "u32DabMday".
     *
     * day of the month
     *
     * @param u32DabMday The value which will be set
     */
    inline void setU32DabMday (uint32 u32DabMday_);

    // API of field "u32DabMon"

    static const int kU32DabMon = 4;

    /**
     * Clears the field "u32DabMon".
     *
     * The field will be set to its default value. The hasU32DabMon()
     * method will return false.
     */
    inline void clearU32DabMon();

    /**
     * Checks whether the field "u32DabMon" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabMon()). Otherwise it will return false.
     */
    inline bool hasU32DabMon () const;

    /**
     * Returns the value of the member "u32DabMon".
     *
     * month
     *
     * @return The value of the field "u32DabMon"
     */
    inline uint32 getU32DabMon () const;

    /**
     * Sets the value of the member "u32DabMon".
     *
     * month
     *
     * @param u32DabMon The value which will be set
     */
    inline void setU32DabMon (uint32 u32DabMon_);

    // API of field "u32DabYear"

    static const int kU32DabYear = 5;

    /**
     * Clears the field "u32DabYear".
     *
     * The field will be set to its default value. The hasU32DabYear()
     * method will return false.
     */
    inline void clearU32DabYear();

    /**
     * Checks whether the field "u32DabYear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabYear()). Otherwise it will return false.
     */
    inline bool hasU32DabYear () const;

    /**
     * Returns the value of the member "u32DabYear".
     *
     * year.
     *
     * @return The value of the field "u32DabYear"
     */
    inline uint32 getU32DabYear () const;

    /**
     * Sets the value of the member "u32DabYear".
     *
     * year.
     *
     * @param u32DabYear The value which will be set
     */
    inline void setU32DabYear (uint32 u32DabYear_);

    // API of field "u32DabWday"

    static const int kU32DabWday = 6;

    /**
     * Clears the field "u32DabWday".
     *
     * The field will be set to its default value. The hasU32DabWday()
     * method will return false.
     */
    inline void clearU32DabWday();

    /**
     * Checks whether the field "u32DabWday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabWday()). Otherwise it will return false.
     */
    inline bool hasU32DabWday () const;

    /**
     * Returns the value of the member "u32DabWday".
     *
     * day of the week.
     *
     * @return The value of the field "u32DabWday"
     */
    inline uint32 getU32DabWday () const;

    /**
     * Sets the value of the member "u32DabWday".
     *
     * day of the week.
     *
     * @param u32DabWday The value which will be set
     */
    inline void setU32DabWday (uint32 u32DabWday_);

    // API of field "u32DabYday"

    static const int kU32DabYday = 7;

    /**
     * Clears the field "u32DabYday".
     *
     * The field will be set to its default value. The hasU32DabYday()
     * method will return false.
     */
    inline void clearU32DabYday();

    /**
     * Checks whether the field "u32DabYday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabYday()). Otherwise it will return false.
     */
    inline bool hasU32DabYday () const;

    /**
     * Returns the value of the member "u32DabYday".
     *
     * day in the year.
     *
     * @return The value of the field "u32DabYday"
     */
    inline uint32 getU32DabYday () const;

    /**
     * Sets the value of the member "u32DabYday".
     *
     * day in the year.
     *
     * @param u32DabYday The value which will be set
     */
    inline void setU32DabYday (uint32 u32DabYday_);

    // API of field "u32DabUtcOff"

    static const int kU32DabUtcOff = 8;

    /**
     * Clears the field "u32DabUtcOff".
     *
     * The field will be set to its default value. The hasU32DabUtcOff()
     * method will return false.
     */
    inline void clearU32DabUtcOff();

    /**
     * Checks whether the field "u32DabUtcOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DabUtcOff()). Otherwise it will return false.
     */
    inline bool hasU32DabUtcOff () const;

    /**
     * Returns the value of the member "u32DabUtcOff".
     *
     * difference between UTC and local time.
     *
     * @return The value of the field "u32DabUtcOff"
     */
    inline uint32 getU32DabUtcOff () const;

    /**
     * Sets the value of the member "u32DabUtcOff".
     *
     * difference between UTC and local time.
     *
     * @param u32DabUtcOff The value which will be set
     */
    inline void setU32DabUtcOff (uint32 u32DabUtcOff_);

    static const T_DAB_Time &getDefaultInstance();

private:

    inline void set_has_u32DabSec ();

    inline void clear_has_u32DabSec ();

    inline void set_has_u32DabMin ();

    inline void clear_has_u32DabMin ();

    inline void set_has_u32DabHour ();

    inline void clear_has_u32DabHour ();

    inline void set_has_u32DabMday ();

    inline void clear_has_u32DabMday ();

    inline void set_has_u32DabMon ();

    inline void clear_has_u32DabMon ();

    inline void set_has_u32DabYear ();

    inline void clear_has_u32DabYear ();

    inline void set_has_u32DabWday ();

    inline void clear_has_u32DabWday ();

    inline void set_has_u32DabYday ();

    inline void clear_has_u32DabYday ();

    inline void set_has_u32DabUtcOff ();

    inline void clear_has_u32DabUtcOff ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint32 _u32DabSec;

    uint32 _u32DabMin;

    uint32 _u32DabHour;

    uint32 _u32DabMday;

    uint32 _u32DabMon;

    uint32 _u32DabYear;

    uint32 _u32DabWday;

    uint32 _u32DabYday;

    uint32 _u32DabUtcOff;

};

/**
 * DAB Test Mode data parameters for dab tmc and tpeg tuner information are contained in this structure.
 */
class T_DAB_TMC_TPEG_TestModeData {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_TMC_TPEG_TestModeData ();

    /**
     * Copy constructor
     */
    inline  T_DAB_TMC_TPEG_TestModeData (const T_DAB_TMC_TPEG_TestModeData &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_TMC_TPEG_TestModeData (uint32 u32NumTmcServices_, uint32 u32NumTpegServices_, uint32 u32RcvTmcMsgs_, uint32 u32RcvTpegMsgs_, const T_DAB_Time& DabTime_);

    /**
     * Destructor
     */
    inline  ~T_DAB_TMC_TPEG_TestModeData();

    /**
     * Assignment operator
     */
    inline T_DAB_TMC_TPEG_TestModeData& operator = (const T_DAB_TMC_TPEG_TestModeData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_TMC_TPEG_TestModeData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_TMC_TPEG_TestModeData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_TMC_TPEG_TestModeData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_TMC_TPEG_TestModeData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32NumTmcServices"

    static const int kU32NumTmcServices = 0;

    /**
     * Clears the field "u32NumTmcServices".
     *
     * The field will be set to its default value. The hasU32NumTmcServices()
     * method will return false.
     */
    inline void clearU32NumTmcServices();

    /**
     * Checks whether the field "u32NumTmcServices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumTmcServices()). Otherwise it will return false.
     */
    inline bool hasU32NumTmcServices () const;

    /**
     * Returns the value of the member "u32NumTmcServices".
     *
     * number of available tmc services.
     *
     * @return The value of the field "u32NumTmcServices"
     */
    inline uint32 getU32NumTmcServices () const;

    /**
     * Sets the value of the member "u32NumTmcServices".
     *
     * number of available tmc services.
     *
     * @param u32NumTmcServices The value which will be set
     */
    inline void setU32NumTmcServices (uint32 u32NumTmcServices_);

    // API of field "u32NumTpegServices"

    static const int kU32NumTpegServices = 1;

    /**
     * Clears the field "u32NumTpegServices".
     *
     * The field will be set to its default value. The hasU32NumTpegServices()
     * method will return false.
     */
    inline void clearU32NumTpegServices();

    /**
     * Checks whether the field "u32NumTpegServices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumTpegServices()). Otherwise it will return false.
     */
    inline bool hasU32NumTpegServices () const;

    /**
     * Returns the value of the member "u32NumTpegServices".
     *
     * number of available tpeg services.
     *
     * @return The value of the field "u32NumTpegServices"
     */
    inline uint32 getU32NumTpegServices () const;

    /**
     * Sets the value of the member "u32NumTpegServices".
     *
     * number of available tpeg services.
     *
     * @param u32NumTpegServices The value which will be set
     */
    inline void setU32NumTpegServices (uint32 u32NumTpegServices_);

    // API of field "u32RcvTmcMsgs"

    static const int kU32RcvTmcMsgs = 2;

    /**
     * Clears the field "u32RcvTmcMsgs".
     *
     * The field will be set to its default value. The hasU32RcvTmcMsgs()
     * method will return false.
     */
    inline void clearU32RcvTmcMsgs();

    /**
     * Checks whether the field "u32RcvTmcMsgs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32RcvTmcMsgs()). Otherwise it will return false.
     */
    inline bool hasU32RcvTmcMsgs () const;

    /**
     * Returns the value of the member "u32RcvTmcMsgs".
     *
     * number of received tmc-messages.
     *
     * @return The value of the field "u32RcvTmcMsgs"
     */
    inline uint32 getU32RcvTmcMsgs () const;

    /**
     * Sets the value of the member "u32RcvTmcMsgs".
     *
     * number of received tmc-messages.
     *
     * @param u32RcvTmcMsgs The value which will be set
     */
    inline void setU32RcvTmcMsgs (uint32 u32RcvTmcMsgs_);

    // API of field "u32RcvTpegMsgs"

    static const int kU32RcvTpegMsgs = 3;

    /**
     * Clears the field "u32RcvTpegMsgs".
     *
     * The field will be set to its default value. The hasU32RcvTpegMsgs()
     * method will return false.
     */
    inline void clearU32RcvTpegMsgs();

    /**
     * Checks whether the field "u32RcvTpegMsgs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32RcvTpegMsgs()). Otherwise it will return false.
     */
    inline bool hasU32RcvTpegMsgs () const;

    /**
     * Returns the value of the member "u32RcvTpegMsgs".
     *
     * number of received tpeg-messages.
     *
     * @return The value of the field "u32RcvTpegMsgs"
     */
    inline uint32 getU32RcvTpegMsgs () const;

    /**
     * Sets the value of the member "u32RcvTpegMsgs".
     *
     * number of received tpeg-messages.
     *
     * @param u32RcvTpegMsgs The value which will be set
     */
    inline void setU32RcvTpegMsgs (uint32 u32RcvTpegMsgs_);

    // API of field "DabTime"

    static const int kDabTime = 4;

    /**
     * Clears the field "DabTime".
     *
     * The field will be set to its default value. The hasDabTime()
     * method will return false.
     */
    inline void clearDabTime();

    /**
     * Checks whether the field "DabTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDabTime()). Otherwise it will return false.
     */
    inline bool hasDabTime () const;

    /**
     * Returns the value of the member "DabTime".
     *
     * date/time of last received tpeg-messages.
     *
     * @return The value of the field "DabTime"
     */
    inline const T_DAB_Time& getDabTime () const;

    /**
     * Retrieves the value of the field "DabTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DabTime".
     */
    inline T_DAB_Time& getDabTimeMutable ();

    /**
     * Sets the value of the member "DabTime".
     *
     * date/time of last received tpeg-messages.
     *
     * @param DabTime The value which will be set
     */
    inline void setDabTime (const T_DAB_Time& DabTime_);

    static const T_DAB_TMC_TPEG_TestModeData &getDefaultInstance();

private:

    inline void set_has_u32NumTmcServices ();

    inline void clear_has_u32NumTmcServices ();

    inline void set_has_u32NumTpegServices ();

    inline void clear_has_u32NumTpegServices ();

    inline void set_has_u32RcvTmcMsgs ();

    inline void clear_has_u32RcvTmcMsgs ();

    inline void set_has_u32RcvTpegMsgs ();

    inline void clear_has_u32RcvTpegMsgs ();

    inline void set_has_DabTime ();

    inline void clear_has_DabTime ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _u32NumTmcServices;

    uint32 _u32NumTpegServices;

    uint32 _u32RcvTmcMsgs;

    uint32 _u32RcvTpegMsgs;

    T_DAB_Time _DabTime;

};

/**
 * DAB RdbId parameters are contained in this structure.
 */
class T_DAB_RdbId {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_RdbId ();

    /**
     * Copy constructor
     */
    inline  T_DAB_RdbId (const T_DAB_RdbId &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_RdbId (uint8 u8Cc_, uint8 u8Ltn_, uint8 u8Bsa_, uint16 u16Bsa_, uint8 u8Sid_, bool bEncrypted_);

    /**
     * Destructor
     */
    inline  ~T_DAB_RdbId();

    /**
     * Assignment operator
     */
    inline T_DAB_RdbId& operator = (const T_DAB_RdbId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_RdbId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_RdbId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_RdbId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_RdbId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Cc"

    static const int kU8Cc = 0;

    /**
     * Clears the field "u8Cc".
     *
     * The field will be set to its default value. The hasU8Cc()
     * method will return false.
     */
    inline void clearU8Cc();

    /**
     * Checks whether the field "u8Cc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Cc()). Otherwise it will return false.
     */
    inline bool hasU8Cc () const;

    /**
     * Returns the value of the member "u8Cc".
     *
     * country code of this tmc data
     *
     * @return The value of the field "u8Cc"
     */
    inline uint8 getU8Cc () const;

    /**
     * Sets the value of the member "u8Cc".
     *
     * country code of this tmc data
     *
     * @param u8Cc The value which will be set
     */
    inline void setU8Cc (uint8 u8Cc_);

    // API of field "u8Ltn"

    static const int kU8Ltn = 1;

    /**
     * Clears the field "u8Ltn".
     *
     * The field will be set to its default value. The hasU8Ltn()
     * method will return false.
     */
    inline void clearU8Ltn();

    /**
     * Checks whether the field "u8Ltn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Ltn()). Otherwise it will return false.
     */
    inline bool hasU8Ltn () const;

    /**
     * Returns the value of the member "u8Ltn".
     *
     * location table number of this tmc data
     *
     * @return The value of the field "u8Ltn"
     */
    inline uint8 getU8Ltn () const;

    /**
     * Sets the value of the member "u8Ltn".
     *
     * location table number of this tmc data
     *
     * @param u8Ltn The value which will be set
     */
    inline void setU8Ltn (uint8 u8Ltn_);

    // API of field "u8Bsa"

    static const int kU8Bsa = 2;

    /**
     * Clears the field "u8Bsa".
     *
     * The field will be set to its default value. The hasU8Bsa()
     * method will return false.
     */
    inline void clearU8Bsa();

    /**
     * Checks whether the field "u8Bsa" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Bsa()). Otherwise it will return false.
     */
    inline bool hasU8Bsa () const;

    /**
     * Returns the value of the member "u8Bsa".
     *
     * todo : needs to be removed next time
     *
     * @return The value of the field "u8Bsa"
     */
    inline uint8 getU8Bsa () const;

    /**
     * Sets the value of the member "u8Bsa".
     *
     * todo : needs to be removed next time
     *
     * @param u8Bsa The value which will be set
     */
    inline void setU8Bsa (uint8 u8Bsa_);

    // API of field "u16Bsa"

    static const int kU16Bsa = 3;

    /**
     * Clears the field "u16Bsa".
     *
     * The field will be set to its default value. The hasU16Bsa()
     * method will return false.
     */
    inline void clearU16Bsa();

    /**
     * Checks whether the field "u16Bsa" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Bsa()). Otherwise it will return false.
     */
    inline bool hasU16Bsa () const;

    /**
     * Returns the value of the member "u16Bsa".
     *
     * broadcast service area of this tmc data
     *
     * @return The value of the field "u16Bsa"
     */
    inline uint16 getU16Bsa () const;

    /**
     * Sets the value of the member "u16Bsa".
     *
     * broadcast service area of this tmc data
     *
     * @param u16Bsa The value which will be set
     */
    inline void setU16Bsa (uint16 u16Bsa_);

    // API of field "u8Sid"

    static const int kU8Sid = 4;

    /**
     * Clears the field "u8Sid".
     *
     * The field will be set to its default value. The hasU8Sid()
     * method will return false.
     */
    inline void clearU8Sid();

    /**
     * Checks whether the field "u8Sid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Sid()). Otherwise it will return false.
     */
    inline bool hasU8Sid () const;

    /**
     * Returns the value of the member "u8Sid".
     *
     * Program ID of the dab - service
     *
     * @return The value of the field "u8Sid"
     */
    inline uint8 getU8Sid () const;

    /**
     * Sets the value of the member "u8Sid".
     *
     * Program ID of the dab - service
     *
     * @param u8Sid The value which will be set
     */
    inline void setU8Sid (uint8 u8Sid_);

    // API of field "bEncrypted"

    static const int kBEncrypted = 5;

    /**
     * Clears the field "bEncrypted".
     *
     * The field will be set to its default value. The hasBEncrypted()
     * method will return false.
     */
    inline void clearBEncrypted();

    /**
     * Checks whether the field "bEncrypted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEncrypted()). Otherwise it will return false.
     */
    inline bool hasBEncrypted () const;

    /**
     * Returns the value of the member "bEncrypted".
     *
     * This identifies as service as encrypted.
     *
     * @return The value of the field "bEncrypted"
     */
    inline bool getBEncrypted () const;

    /**
     * Sets the value of the member "bEncrypted".
     *
     * This identifies as service as encrypted.
     *
     * @param bEncrypted The value which will be set
     */
    inline void setBEncrypted (bool bEncrypted_);

    static const T_DAB_RdbId &getDefaultInstance();

private:

    inline void set_has_u8Cc ();

    inline void clear_has_u8Cc ();

    inline void set_has_u8Ltn ();

    inline void clear_has_u8Ltn ();

    inline void set_has_u8Bsa ();

    inline void clear_has_u8Bsa ();

    inline void set_has_u16Bsa ();

    inline void clear_has_u16Bsa ();

    inline void set_has_u8Sid ();

    inline void clear_has_u8Sid ();

    inline void set_has_bEncrypted ();

    inline void clear_has_bEncrypted ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _u8Cc;

    uint8 _u8Ltn;

    uint8 _u8Bsa;

    uint16 _u16Bsa;

    uint8 _u8Sid;

    bool _bEncrypted;

};

/**
 * .
 */
class T_DAB_TmcData {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_TmcData ();

    /**
     * Copy constructor
     */
    inline  T_DAB_TmcData (const T_DAB_TmcData &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_TmcData (uint8 u8TmcData1_, uint8 u8TmcData2_, uint8 u8TmcData3_, uint8 u8TmcData4_, uint8 u8TmcData5_);

    /**
     * Destructor
     */
    inline  ~T_DAB_TmcData();

    /**
     * Assignment operator
     */
    inline T_DAB_TmcData& operator = (const T_DAB_TmcData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_TmcData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_TmcData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_TmcData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_TmcData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TmcData1"

    static const int kU8TmcData1 = 0;

    /**
     * Clears the field "u8TmcData1".
     *
     * The field will be set to its default value. The hasU8TmcData1()
     * method will return false.
     */
    inline void clearU8TmcData1();

    /**
     * Checks whether the field "u8TmcData1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TmcData1()). Otherwise it will return false.
     */
    inline bool hasU8TmcData1 () const;

    /**
     * Returns the value of the member "u8TmcData1".
     *
     *
     *
     * @return The value of the field "u8TmcData1"
     */
    inline uint8 getU8TmcData1 () const;

    /**
     * Sets the value of the member "u8TmcData1".
     *
     *
     *
     * @param u8TmcData1 The value which will be set
     */
    inline void setU8TmcData1 (uint8 u8TmcData1_);

    // API of field "u8TmcData2"

    static const int kU8TmcData2 = 1;

    /**
     * Clears the field "u8TmcData2".
     *
     * The field will be set to its default value. The hasU8TmcData2()
     * method will return false.
     */
    inline void clearU8TmcData2();

    /**
     * Checks whether the field "u8TmcData2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TmcData2()). Otherwise it will return false.
     */
    inline bool hasU8TmcData2 () const;

    /**
     * Returns the value of the member "u8TmcData2".
     *
     *
     *
     * @return The value of the field "u8TmcData2"
     */
    inline uint8 getU8TmcData2 () const;

    /**
     * Sets the value of the member "u8TmcData2".
     *
     *
     *
     * @param u8TmcData2 The value which will be set
     */
    inline void setU8TmcData2 (uint8 u8TmcData2_);

    // API of field "u8TmcData3"

    static const int kU8TmcData3 = 2;

    /**
     * Clears the field "u8TmcData3".
     *
     * The field will be set to its default value. The hasU8TmcData3()
     * method will return false.
     */
    inline void clearU8TmcData3();

    /**
     * Checks whether the field "u8TmcData3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TmcData3()). Otherwise it will return false.
     */
    inline bool hasU8TmcData3 () const;

    /**
     * Returns the value of the member "u8TmcData3".
     *
     *
     *
     * @return The value of the field "u8TmcData3"
     */
    inline uint8 getU8TmcData3 () const;

    /**
     * Sets the value of the member "u8TmcData3".
     *
     *
     *
     * @param u8TmcData3 The value which will be set
     */
    inline void setU8TmcData3 (uint8 u8TmcData3_);

    // API of field "u8TmcData4"

    static const int kU8TmcData4 = 3;

    /**
     * Clears the field "u8TmcData4".
     *
     * The field will be set to its default value. The hasU8TmcData4()
     * method will return false.
     */
    inline void clearU8TmcData4();

    /**
     * Checks whether the field "u8TmcData4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TmcData4()). Otherwise it will return false.
     */
    inline bool hasU8TmcData4 () const;

    /**
     * Returns the value of the member "u8TmcData4".
     *
     *
     *
     * @return The value of the field "u8TmcData4"
     */
    inline uint8 getU8TmcData4 () const;

    /**
     * Sets the value of the member "u8TmcData4".
     *
     *
     *
     * @param u8TmcData4 The value which will be set
     */
    inline void setU8TmcData4 (uint8 u8TmcData4_);

    // API of field "u8TmcData5"

    static const int kU8TmcData5 = 4;

    /**
     * Clears the field "u8TmcData5".
     *
     * The field will be set to its default value. The hasU8TmcData5()
     * method will return false.
     */
    inline void clearU8TmcData5();

    /**
     * Checks whether the field "u8TmcData5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TmcData5()). Otherwise it will return false.
     */
    inline bool hasU8TmcData5 () const;

    /**
     * Returns the value of the member "u8TmcData5".
     *
     *
     *
     * @return The value of the field "u8TmcData5"
     */
    inline uint8 getU8TmcData5 () const;

    /**
     * Sets the value of the member "u8TmcData5".
     *
     *
     *
     * @param u8TmcData5 The value which will be set
     */
    inline void setU8TmcData5 (uint8 u8TmcData5_);

    static const T_DAB_TmcData &getDefaultInstance();

private:

    inline void set_has_u8TmcData1 ();

    inline void clear_has_u8TmcData1 ();

    inline void set_has_u8TmcData2 ();

    inline void clear_has_u8TmcData2 ();

    inline void set_has_u8TmcData3 ();

    inline void clear_has_u8TmcData3 ();

    inline void set_has_u8TmcData4 ();

    inline void clear_has_u8TmcData4 ();

    inline void set_has_u8TmcData5 ();

    inline void clear_has_u8TmcData5 ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _u8TmcData1;

    uint8 _u8TmcData2;

    uint8 _u8TmcData3;

    uint8 _u8TmcData4;

    uint8 _u8TmcData5;

};

/**
 * Type identifying the encryption type and values of a TMC message.
 */
class T_DAB_Encryption {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_Encryption ();

    /**
     * Copy constructor
     */
    inline  T_DAB_Encryption (const T_DAB_Encryption &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_Encryption (bool bEncrypted_, uint8 u8EncId_, uint8 u8TestBits_);

    /**
     * Destructor
     */
    inline  ~T_DAB_Encryption();

    /**
     * Assignment operator
     */
    inline T_DAB_Encryption& operator = (const T_DAB_Encryption& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_Encryption& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_Encryption& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_Encryption& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_Encryption& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEncrypted"

    static const int kBEncrypted = 0;

    /**
     * Clears the field "bEncrypted".
     *
     * The field will be set to its default value. The hasBEncrypted()
     * method will return false.
     */
    inline void clearBEncrypted();

    /**
     * Checks whether the field "bEncrypted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEncrypted()). Otherwise it will return false.
     */
    inline bool hasBEncrypted () const;

    /**
     * Returns the value of the member "bEncrypted".
     *
     * FALSE = Msg not encrypted, TRUE: Msg encrypted
     *
     * @return The value of the field "bEncrypted"
     */
    inline bool getBEncrypted () const;

    /**
     * Sets the value of the member "bEncrypted".
     *
     * FALSE = Msg not encrypted, TRUE: Msg encrypted
     *
     * @param bEncrypted The value which will be set
     */
    inline void setBEncrypted (bool bEncrypted_);

    // API of field "u8EncId"

    static const int kU8EncId = 1;

    /**
     * Clears the field "u8EncId".
     *
     * The field will be set to its default value. The hasU8EncId()
     * method will return false.
     */
    inline void clearU8EncId();

    /**
     * Checks whether the field "u8EncId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8EncId()). Otherwise it will return false.
     */
    inline bool hasU8EncId () const;

    /**
     * Returns the value of the member "u8EncId".
     *
     * Identifying the index of the encrypted value in the used
     * service key table (EPVS), 0 means not encrypted
     *
     * @return The value of the field "u8EncId"
     */
    inline uint8 getU8EncId () const;

    /**
     * Sets the value of the member "u8EncId".
     *
     * Identifying the index of the encrypted value in the used
     * service key table (EPVS), 0 means not encrypted
     *
     * @param u8EncId The value which will be set
     */
    inline void setU8EncId (uint8 u8EncId_);

    // API of field "u8TestBits"

    static const int kU8TestBits = 2;

    /**
     * Clears the field "u8TestBits".
     *
     * The field will be set to its default value. The hasU8TestBits()
     * method will return false.
     */
    inline void clearU8TestBits();

    /**
     * Checks whether the field "u8TestBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TestBits()). Otherwise it will return false.
     */
    inline bool hasU8TestBits () const;

    /**
     * Returns the value of the member "u8TestBits".
     *
     * Test bits for encrypted messages, 0 means if msg not encrypted
     *
     * @return The value of the field "u8TestBits"
     */
    inline uint8 getU8TestBits () const;

    /**
     * Sets the value of the member "u8TestBits".
     *
     * Test bits for encrypted messages, 0 means if msg not encrypted
     *
     * @param u8TestBits The value which will be set
     */
    inline void setU8TestBits (uint8 u8TestBits_);

    static const T_DAB_Encryption &getDefaultInstance();

private:

    inline void set_has_bEncrypted ();

    inline void clear_has_bEncrypted ();

    inline void set_has_u8EncId ();

    inline void clear_has_u8EncId ();

    inline void set_has_u8TestBits ();

    inline void clear_has_u8TestBits ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bEncrypted;

    uint8 _u8EncId;

    uint8 _u8TestBits;

};

/**
 * Type identifying the (tuner) source of a TMC message.
 */
class T_DAB_MsgSource {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_MsgSource ();

    /**
     * Copy constructor
     */
    inline  T_DAB_MsgSource (const T_DAB_MsgSource &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_MsgSource (T_e8_DAB_TmcMediumType DabMediumTypeId_, uint8 u8Number_);

    /**
     * Destructor
     */
    inline  ~T_DAB_MsgSource();

    /**
     * Assignment operator
     */
    inline T_DAB_MsgSource& operator = (const T_DAB_MsgSource& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_MsgSource& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_MsgSource& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_MsgSource& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_MsgSource& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DabMediumTypeId"

    static const int kDabMediumTypeId = 0;

    /**
     * Clears the field "DabMediumTypeId".
     *
     * The field will be set to its default value. The hasDabMediumTypeId()
     * method will return false.
     */
    inline void clearDabMediumTypeId();

    /**
     * Checks whether the field "DabMediumTypeId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDabMediumTypeId()). Otherwise it will return false.
     */
    inline bool hasDabMediumTypeId () const;

    /**
     * Returns the value of the member "DabMediumTypeId".
     *
     * unique Id specifying the medium the message was transmitted with
     *
     * @return The value of the field "DabMediumTypeId"
     */
    inline T_e8_DAB_TmcMediumType getDabMediumTypeId () const;

    /**
     * Sets the value of the member "DabMediumTypeId".
     *
     * unique Id specifying the medium the message was transmitted with
     *
     * @param DabMediumTypeId The value which will be set
     */
    inline void setDabMediumTypeId (T_e8_DAB_TmcMediumType DabMediumTypeId_);

    // API of field "u8Number"

    static const int kU8Number = 1;

    /**
     * Clears the field "u8Number".
     *
     * The field will be set to its default value. The hasU8Number()
     * method will return false.
     */
    inline void clearU8Number();

    /**
     * Checks whether the field "u8Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Number()). Otherwise it will return false.
     */
    inline bool hasU8Number () const;

    /**
     * Returns the value of the member "u8Number".
     *
     * identifies one of n sources of the same medium type
     *
     * @return The value of the field "u8Number"
     */
    inline uint8 getU8Number () const;

    /**
     * Sets the value of the member "u8Number".
     *
     * identifies one of n sources of the same medium type
     *
     * @param u8Number The value which will be set
     */
    inline void setU8Number (uint8 u8Number_);

    static const T_DAB_MsgSource &getDefaultInstance();

private:

    inline void set_has_DabMediumTypeId ();

    inline void clear_has_DabMediumTypeId ();

    inline void set_has_u8Number ();

    inline void clear_has_u8Number ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_DAB_TmcMediumType _DabMediumTypeId;

    uint8 _u8Number;

};

/**
 * DAB Tmc data parameters are contained in this structure.
 */
class T_DAB_TmcInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_TmcInfo ();

    /**
     * Copy constructor
     */
    inline  T_DAB_TmcInfo (const T_DAB_TmcInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_TmcInfo (const T_DAB_RdbId& RdbId_, int16 s16Ecc_, uint16 u16Aid_, const ::std::vector< uint8 >& TmcData_, uint16 u16ProgramId_, const T_DAB_Encryption& DabEncryption_, const T_DAB_MsgSource& DabMsgSource_, const ::std::string& sProgramServiceName_, const ::std::string& sServiceProviderName_);

    /**
     * Destructor
     */
    inline  ~T_DAB_TmcInfo();

    /**
     * Assignment operator
     */
    inline T_DAB_TmcInfo& operator = (const T_DAB_TmcInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_TmcInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_TmcInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_TmcInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_TmcInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RdbId"

    static const int kRdbId = 0;

    /**
     * Clears the field "RdbId".
     *
     * The field will be set to its default value. The hasRdbId()
     * method will return false.
     */
    inline void clearRdbId();

    /**
     * Checks whether the field "RdbId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRdbId()). Otherwise it will return false.
     */
    inline bool hasRdbId () const;

    /**
     * Returns the value of the member "RdbId".
     *
     * RdbId of this message includes CC, LTN and SID
     *
     * @return The value of the field "RdbId"
     */
    inline const T_DAB_RdbId& getRdbId () const;

    /**
     * Retrieves the value of the field "RdbId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RdbId".
     */
    inline T_DAB_RdbId& getRdbIdMutable ();

    /**
     * Sets the value of the member "RdbId".
     *
     * RdbId of this message includes CC, LTN and SID
     *
     * @param RdbId The value which will be set
     */
    inline void setRdbId (const T_DAB_RdbId& RdbId_);

    // API of field "s16Ecc"

    static const int kS16Ecc = 1;

    /**
     * Clears the field "s16Ecc".
     *
     * The field will be set to its default value. The hasS16Ecc()
     * method will return false.
     */
    inline void clearS16Ecc();

    /**
     * Checks whether the field "s16Ecc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Ecc()). Otherwise it will return false.
     */
    inline bool hasS16Ecc () const;

    /**
     * Returns the value of the member "s16Ecc".
     *
     * extended country code of this tmc data
     *
     * @return The value of the field "s16Ecc"
     */
    inline int16 getS16Ecc () const;

    /**
     * Sets the value of the member "s16Ecc".
     *
     * extended country code of this tmc data
     *
     * @param s16Ecc The value which will be set
     */
    inline void setS16Ecc (int16 s16Ecc_);

    // API of field "u16Aid"

    static const int kU16Aid = 2;

    /**
     * Clears the field "u16Aid".
     *
     * The field will be set to its default value. The hasU16Aid()
     * method will return false.
     */
    inline void clearU16Aid();

    /**
     * Checks whether the field "u16Aid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Aid()). Otherwise it will return false.
     */
    inline bool hasU16Aid () const;

    /**
     * Returns the value of the member "u16Aid".
     *
     * extended country code of this tmc data
     *
     * @return The value of the field "u16Aid"
     */
    inline uint16 getU16Aid () const;

    /**
     * Sets the value of the member "u16Aid".
     *
     * extended country code of this tmc data
     *
     * @param u16Aid The value which will be set
     */
    inline void setU16Aid (uint16 u16Aid_);

    // API of field "TmcData"

    static const int kTmcData = 3;

    /**
     * Clears the field "TmcData".
     *
     * The field will be set to its default value. The hasTmcData()
     * method will return false.
     */
    inline void clearTmcData();

    /**
     * Checks whether the field "TmcData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTmcData()). Otherwise it will return false.
     */
    inline bool hasTmcData () const;

    /**
     * Returns the value of the member "TmcData".
     *
     * List containing tmc information
     *
     * @return The value of the field "TmcData"
     */
    inline const ::std::vector< uint8 >& getTmcData () const;

    /**
     * Retrieves the value of the field "TmcData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TmcData".
     */
    inline ::std::vector< uint8 >& getTmcDataMutable ();

    /**
     * Sets the value of the member "TmcData".
     *
     * List containing tmc information
     *
     * @param TmcData The value which will be set
     */
    inline void setTmcData (const ::std::vector< uint8 >& TmcData_);

    // API of field "u16ProgramId"

    static const int kU16ProgramId = 4;

    /**
     * Clears the field "u16ProgramId".
     *
     * The field will be set to its default value. The hasU16ProgramId()
     * method will return false.
     */
    inline void clearU16ProgramId();

    /**
     * Checks whether the field "u16ProgramId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ProgramId()). Otherwise it will return false.
     */
    inline bool hasU16ProgramId () const;

    /**
     * Returns the value of the member "u16ProgramId".
     *
     * Program ID of the dab - service
     *
     * @return The value of the field "u16ProgramId"
     */
    inline uint16 getU16ProgramId () const;

    /**
     * Sets the value of the member "u16ProgramId".
     *
     * Program ID of the dab - service
     *
     * @param u16ProgramId The value which will be set
     */
    inline void setU16ProgramId (uint16 u16ProgramId_);

    // API of field "DabEncryption"

    static const int kDabEncryption = 5;

    /**
     * Clears the field "DabEncryption".
     *
     * The field will be set to its default value. The hasDabEncryption()
     * method will return false.
     */
    inline void clearDabEncryption();

    /**
     * Checks whether the field "DabEncryption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDabEncryption()). Otherwise it will return false.
     */
    inline bool hasDabEncryption () const;

    /**
     * Returns the value of the member "DabEncryption".
     *
     * Identifying the encryption type and values of this message
     *
     * @return The value of the field "DabEncryption"
     */
    inline const T_DAB_Encryption& getDabEncryption () const;

    /**
     * Retrieves the value of the field "DabEncryption" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DabEncryption".
     */
    inline T_DAB_Encryption& getDabEncryptionMutable ();

    /**
     * Sets the value of the member "DabEncryption".
     *
     * Identifying the encryption type and values of this message
     *
     * @param DabEncryption The value which will be set
     */
    inline void setDabEncryption (const T_DAB_Encryption& DabEncryption_);

    // API of field "DabMsgSource"

    static const int kDabMsgSource = 6;

    /**
     * Clears the field "DabMsgSource".
     *
     * The field will be set to its default value. The hasDabMsgSource()
     * method will return false.
     */
    inline void clearDabMsgSource();

    /**
     * Checks whether the field "DabMsgSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDabMsgSource()). Otherwise it will return false.
     */
    inline bool hasDabMsgSource () const;

    /**
     * Returns the value of the member "DabMsgSource".
     *
     * Identifying the tuner source of the message
     *
     * @return The value of the field "DabMsgSource"
     */
    inline const T_DAB_MsgSource& getDabMsgSource () const;

    /**
     * Retrieves the value of the field "DabMsgSource" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DabMsgSource".
     */
    inline T_DAB_MsgSource& getDabMsgSourceMutable ();

    /**
     * Sets the value of the member "DabMsgSource".
     *
     * Identifying the tuner source of the message
     *
     * @param DabMsgSource The value which will be set
     */
    inline void setDabMsgSource (const T_DAB_MsgSource& DabMsgSource_);

    // API of field "sProgramServiceName"

    static const int kSProgramServiceName = 7;

    /**
     * Clears the field "sProgramServiceName".
     *
     * The field will be set to its default value. The hasSProgramServiceName()
     * method will return false.
     */
    inline void clearSProgramServiceName();

    /**
     * Checks whether the field "sProgramServiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSProgramServiceName()). Otherwise it will return false.
     */
    inline bool hasSProgramServiceName () const;

    /**
     * Returns the value of the member "sProgramServiceName".
     *
     * Name of the Program Service Name
     *
     * @return The value of the field "sProgramServiceName"
     */
    inline const ::std::string& getSProgramServiceName () const;

    /**
     * Retrieves the value of the field "sProgramServiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sProgramServiceName".
     */
    inline ::std::string& getSProgramServiceNameMutable ();

    /**
     * Sets the value of the member "sProgramServiceName".
     *
     * Name of the Program Service Name
     *
     * @param sProgramServiceName The value which will be set
     */
    inline void setSProgramServiceName (const ::std::string& sProgramServiceName_);

    /**
     * Sets the value of the member "sProgramServiceName".
     *
     * Name of the Program Service Name
     *
     * @param sProgramServiceName The value which will be set
     */
    inline void setSProgramServiceName (const char* sProgramServiceName_);

    /**
     * Sets the value of the member "sProgramServiceName".
     *
     * Name of the Program Service Name
     *
     * @param sProgramServiceName The value which will be set
     */
    inline void setSProgramServiceName (const char* value, size_t size);

    // API of field "sServiceProviderName"

    static const int kSServiceProviderName = 8;

    /**
     * Clears the field "sServiceProviderName".
     *
     * The field will be set to its default value. The hasSServiceProviderName()
     * method will return false.
     */
    inline void clearSServiceProviderName();

    /**
     * Checks whether the field "sServiceProviderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSServiceProviderName()). Otherwise it will return false.
     */
    inline bool hasSServiceProviderName () const;

    /**
     * Returns the value of the member "sServiceProviderName".
     *
     * Name of the Service Provider Name
     *
     * @return The value of the field "sServiceProviderName"
     */
    inline const ::std::string& getSServiceProviderName () const;

    /**
     * Retrieves the value of the field "sServiceProviderName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sServiceProviderName".
     */
    inline ::std::string& getSServiceProviderNameMutable ();

    /**
     * Sets the value of the member "sServiceProviderName".
     *
     * Name of the Service Provider Name
     *
     * @param sServiceProviderName The value which will be set
     */
    inline void setSServiceProviderName (const ::std::string& sServiceProviderName_);

    /**
     * Sets the value of the member "sServiceProviderName".
     *
     * Name of the Service Provider Name
     *
     * @param sServiceProviderName The value which will be set
     */
    inline void setSServiceProviderName (const char* sServiceProviderName_);

    /**
     * Sets the value of the member "sServiceProviderName".
     *
     * Name of the Service Provider Name
     *
     * @param sServiceProviderName The value which will be set
     */
    inline void setSServiceProviderName (const char* value, size_t size);

    static const T_DAB_TmcInfo &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_RdbId ();

    inline void clear_has_RdbId ();

    inline void set_has_s16Ecc ();

    inline void clear_has_s16Ecc ();

    inline void set_has_u16Aid ();

    inline void clear_has_u16Aid ();

    inline void set_has_TmcData ();

    inline void clear_has_TmcData ();

    inline void set_has_u16ProgramId ();

    inline void clear_has_u16ProgramId ();

    inline void set_has_DabEncryption ();

    inline void clear_has_DabEncryption ();

    inline void set_has_DabMsgSource ();

    inline void clear_has_DabMsgSource ();

    inline void set_has_sProgramServiceName ();

    inline void clear_has_sProgramServiceName ();

    inline void set_has_sServiceProviderName ();

    inline void clear_has_sServiceProviderName ();

    uint32 _has_bits_[ (9 + 31) / 32];

    T_DAB_RdbId _RdbId;

    int16 _s16Ecc;

    uint16 _u16Aid;

    ::std::vector< uint8 > _TmcData;

    uint16 _u16ProgramId;

    T_DAB_Encryption _DabEncryption;

    T_DAB_MsgSource _DabMsgSource;

    ::std::string _sProgramServiceName;

    ::std::string _sServiceProviderName;

};

/**
 * .
 */
class T_DAB_EnsembleTmcInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_EnsembleTmcInfo ();

    /**
     * Copy constructor
     */
    inline  T_DAB_EnsembleTmcInfo (const T_DAB_EnsembleTmcInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_EnsembleTmcInfo (uint32 u32EnsembleId_, uint8 u8Quality_, uint8 u8NumberOfRdbIds_, const ::std::vector< T_DAB_RdbId >& RdbIdList_);

    /**
     * Destructor
     */
    inline  ~T_DAB_EnsembleTmcInfo();

    /**
     * Assignment operator
     */
    inline T_DAB_EnsembleTmcInfo& operator = (const T_DAB_EnsembleTmcInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_EnsembleTmcInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_EnsembleTmcInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_EnsembleTmcInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_EnsembleTmcInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32EnsembleId"

    static const int kU32EnsembleId = 0;

    /**
     * Clears the field "u32EnsembleId".
     *
     * The field will be set to its default value. The hasU32EnsembleId()
     * method will return false.
     */
    inline void clearU32EnsembleId();

    /**
     * Checks whether the field "u32EnsembleId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EnsembleId()). Otherwise it will return false.
     */
    inline bool hasU32EnsembleId () const;

    /**
     * Returns the value of the member "u32EnsembleId".
     *
     * Id of this ensemble
     *
     * @return The value of the field "u32EnsembleId"
     */
    inline uint32 getU32EnsembleId () const;

    /**
     * Sets the value of the member "u32EnsembleId".
     *
     * Id of this ensemble
     *
     * @param u32EnsembleId The value which will be set
     */
    inline void setU32EnsembleId (uint32 u32EnsembleId_);

    // API of field "u8Quality"

    static const int kU8Quality = 1;

    /**
     * Clears the field "u8Quality".
     *
     * The field will be set to its default value. The hasU8Quality()
     * method will return false.
     */
    inline void clearU8Quality();

    /**
     * Checks whether the field "u8Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Quality()). Otherwise it will return false.
     */
    inline bool hasU8Quality () const;

    /**
     * Returns the value of the member "u8Quality".
     *
     * Reception-Quality of ensemble, 7=best, 0=no reception
     * Only ensembles with a minimum reception of 5 will be provided.
     * Further clarification due to DAB 1.2. needed!!!
     *
     * @return The value of the field "u8Quality"
     */
    inline uint8 getU8Quality () const;

    /**
     * Sets the value of the member "u8Quality".
     *
     * Reception-Quality of ensemble, 7=best, 0=no reception
     * Only ensembles with a minimum reception of 5 will be provided.
     * Further clarification due to DAB 1.2. needed!!!
     *
     * @param u8Quality The value which will be set
     */
    inline void setU8Quality (uint8 u8Quality_);

    // API of field "u8NumberOfRdbIds"

    static const int kU8NumberOfRdbIds = 2;

    /**
     * Clears the field "u8NumberOfRdbIds".
     *
     * The field will be set to its default value. The hasU8NumberOfRdbIds()
     * method will return false.
     */
    inline void clearU8NumberOfRdbIds();

    /**
     * Checks whether the field "u8NumberOfRdbIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfRdbIds()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfRdbIds () const;

    /**
     * Returns the value of the member "u8NumberOfRdbIds".
     *
     * Total Number of elements in the RdbId list.
     *
     * @return The value of the field "u8NumberOfRdbIds"
     */
    inline uint8 getU8NumberOfRdbIds () const;

    /**
     * Sets the value of the member "u8NumberOfRdbIds".
     *
     * Total Number of elements in the RdbId list.
     *
     * @param u8NumberOfRdbIds The value which will be set
     */
    inline void setU8NumberOfRdbIds (uint8 u8NumberOfRdbIds_);

    // API of field "RdbIdList"

    static const int kRdbIdList = 3;

    /**
     * Clears the field "RdbIdList".
     *
     * The field will be set to its default value. The hasRdbIdList()
     * method will return false.
     */
    inline void clearRdbIdList();

    /**
     * Checks whether the field "RdbIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRdbIdList()). Otherwise it will return false.
     */
    inline bool hasRdbIdList () const;

    /**
     * Returns the value of the member "RdbIdList".
     *
     * List of rdbIds provided by this ensemble
     *
     * @return The value of the field "RdbIdList"
     */
    inline const ::std::vector< T_DAB_RdbId >& getRdbIdList () const;

    /**
     * Retrieves the value of the field "RdbIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RdbIdList".
     */
    inline ::std::vector< T_DAB_RdbId >& getRdbIdListMutable ();

    /**
     * Sets the value of the member "RdbIdList".
     *
     * List of rdbIds provided by this ensemble
     *
     * @param RdbIdList The value which will be set
     */
    inline void setRdbIdList (const ::std::vector< T_DAB_RdbId >& RdbIdList_);

    static const T_DAB_EnsembleTmcInfo &getDefaultInstance();

private:

    static const ::std::vector< T_DAB_RdbId >& getT_DAB_RdbIdList_DefaultInstance ();

    inline void set_has_u32EnsembleId ();

    inline void clear_has_u32EnsembleId ();

    inline void set_has_u8Quality ();

    inline void clear_has_u8Quality ();

    inline void set_has_u8NumberOfRdbIds ();

    inline void clear_has_u8NumberOfRdbIds ();

    inline void set_has_RdbIdList ();

    inline void clear_has_RdbIdList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32EnsembleId;

    uint8 _u8Quality;

    uint8 _u8NumberOfRdbIds;

    ::std::vector< T_DAB_RdbId > _RdbIdList;

};

/**
 * DAB TPEG URI element.
 */
class T_DAB_TpegUriChannel {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_TpegUriChannel ();

    /**
     * Copy constructor
     */
    inline  T_DAB_TpegUriChannel (const T_DAB_TpegUriChannel &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_TpegUriChannel (const ::std::string& sTpegUriChn_, T_e8_DAB_UriSelectState DabUriSelectState_, bool bActive_);

    /**
     * Destructor
     */
    inline  ~T_DAB_TpegUriChannel();

    /**
     * Assignment operator
     */
    inline T_DAB_TpegUriChannel& operator = (const T_DAB_TpegUriChannel& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_TpegUriChannel& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_TpegUriChannel& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_TpegUriChannel& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_TpegUriChannel& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sTpegUriChn"

    static const int kSTpegUriChn = 0;

    /**
     * Clears the field "sTpegUriChn".
     *
     * The field will be set to its default value. The hasSTpegUriChn()
     * method will return false.
     */
    inline void clearSTpegUriChn();

    /**
     * Checks whether the field "sTpegUriChn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTpegUriChn()). Otherwise it will return false.
     */
    inline bool hasSTpegUriChn () const;

    /**
     * Returns the value of the member "sTpegUriChn".
     *
     * For TPEG URI channel selection this string is needed.
     *
     * @return The value of the field "sTpegUriChn"
     */
    inline const ::std::string& getSTpegUriChn () const;

    /**
     * Retrieves the value of the field "sTpegUriChn" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTpegUriChn".
     */
    inline ::std::string& getSTpegUriChnMutable ();

    /**
     * Sets the value of the member "sTpegUriChn".
     *
     * For TPEG URI channel selection this string is needed.
     *
     * @param sTpegUriChn The value which will be set
     */
    inline void setSTpegUriChn (const ::std::string& sTpegUriChn_);

    /**
     * Sets the value of the member "sTpegUriChn".
     *
     * For TPEG URI channel selection this string is needed.
     *
     * @param sTpegUriChn The value which will be set
     */
    inline void setSTpegUriChn (const char* sTpegUriChn_);

    /**
     * Sets the value of the member "sTpegUriChn".
     *
     * For TPEG URI channel selection this string is needed.
     *
     * @param sTpegUriChn The value which will be set
     */
    inline void setSTpegUriChn (const char* value, size_t size);

    // API of field "DabUriSelectState"

    static const int kDabUriSelectState = 1;

    /**
     * Clears the field "DabUriSelectState".
     *
     * The field will be set to its default value. The hasDabUriSelectState()
     * method will return false.
     */
    inline void clearDabUriSelectState();

    /**
     * Checks whether the field "DabUriSelectState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDabUriSelectState()). Otherwise it will return false.
     */
    inline bool hasDabUriSelectState () const;

    /**
     * Returns the value of the member "DabUriSelectState".
     *
     * Indicates in which state the adr is. If tpeg stream is active or interupted by scheduler
     *
     * @return The value of the field "DabUriSelectState"
     */
    inline T_e8_DAB_UriSelectState getDabUriSelectState () const;

    /**
     * Sets the value of the member "DabUriSelectState".
     *
     * Indicates in which state the adr is. If tpeg stream is active or interupted by scheduler
     *
     * @param DabUriSelectState The value which will be set
     */
    inline void setDabUriSelectState (T_e8_DAB_UriSelectState DabUriSelectState_);

    // API of field "bActive"

    static const int kBActive = 2;

    /**
     * Clears the field "bActive".
     *
     * The field will be set to its default value. The hasBActive()
     * method will return false.
     */
    inline void clearBActive();

    /**
     * Checks whether the field "bActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActive()). Otherwise it will return false.
     */
    inline bool hasBActive () const;

    /**
     * Returns the value of the member "bActive".
     *
     * Indicates whether the uri service is activated/de-activated
     *
     * @return The value of the field "bActive"
     */
    inline bool getBActive () const;

    /**
     * Sets the value of the member "bActive".
     *
     * Indicates whether the uri service is activated/de-activated
     *
     * @param bActive The value which will be set
     */
    inline void setBActive (bool bActive_);

    static const T_DAB_TpegUriChannel &getDefaultInstance();

private:

    inline void set_has_sTpegUriChn ();

    inline void clear_has_sTpegUriChn ();

    inline void set_has_DabUriSelectState ();

    inline void clear_has_DabUriSelectState ();

    inline void set_has_bActive ();

    inline void clear_has_bActive ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sTpegUriChn;

    T_e8_DAB_UriSelectState _DabUriSelectState;

    bool _bActive;

};

inline  T_DAB_Label::T_DAB_Label ()  :
    _sLabel (),
    _sLabelShort (),
    _u16LabelMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_Label::T_DAB_Label (const T_DAB_Label &rhs)  :
    _sLabel (),
    _sLabelShort (),
    _u16LabelMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_Label::T_DAB_Label (const ::std::string& sLabel_, const ::std::string& sLabelShort_, uint16 u16LabelMask_)  :
    _sLabel (sLabel_),
    _sLabelShort (sLabelShort_),
    _u16LabelMask (u16LabelMask_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabelShort_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_Label::~T_DAB_Label() {
}

inline T_DAB_Label& T_DAB_Label::operator = (const T_DAB_Label& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSLabel()) {
            setSLabel(rhs.getSLabel());
        } else {
            clearSLabel();
        }
        if (rhs.hasSLabelShort()) {
            setSLabelShort(rhs.getSLabelShort());
        } else {
            clearSLabelShort();
        }
        if (rhs.hasU16LabelMask()) {
            setU16LabelMask(rhs.getU16LabelMask());
        } else {
            clearU16LabelMask();
        }
    }
    return *this;
}

inline bool T_DAB_Label::operator == (const T_DAB_Label& rhs) const {
    return (((!hasSLabel() && !rhs.hasSLabel()) || getSLabel() == rhs.getSLabel()) &&
        ((!hasSLabelShort() && !rhs.hasSLabelShort()) || getSLabelShort() == rhs.getSLabelShort()) &&
        ((!hasU16LabelMask() && !rhs.hasU16LabelMask()) || getU16LabelMask() == rhs.getU16LabelMask()));
}

inline bool T_DAB_Label::operator != (const T_DAB_Label& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_Label::operator < (const T_DAB_Label& rhs) const {
    if (hasSLabel() || rhs.hasSLabel()) {
        if (getSLabel() < rhs.getSLabel()) return true;
        if (getSLabel() > rhs.getSLabel()) return false;
    }
    if (hasSLabelShort() || rhs.hasSLabelShort()) {
        if (getSLabelShort() < rhs.getSLabelShort()) return true;
        if (getSLabelShort() > rhs.getSLabelShort()) return false;
    }
    if (hasU16LabelMask() || rhs.hasU16LabelMask()) {
        if (getU16LabelMask() < rhs.getU16LabelMask()) return true;
        if (getU16LabelMask() > rhs.getU16LabelMask()) return false;
    }
    return false;
}

inline bool T_DAB_Label::operator > (const T_DAB_Label& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_Label::clear() {
    clearSLabel();
    clearSLabelShort();
    clearU16LabelMask();
}

inline void T_DAB_Label::clearSLabel() {
    if (hasSLabel()) {
         clear_has_sLabel();
        _sLabel.clear();
     }
}

inline bool T_DAB_Label::hasSLabel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_DAB_Label::getSLabel () const {
    return _sLabel;
}

inline ::std::string& T_DAB_Label::getSLabelMutable () {
    set_has_sLabel();
    return _sLabel;
}

inline void T_DAB_Label::setSLabel (const ::std::string& sLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    this->_sLabel = sLabel_;
}

inline void T_DAB_Label::setSLabel (const char* sLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    this->_sLabel.assign(sLabel_);
}

inline void T_DAB_Label::setSLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    this->_sLabel.assign(value, size);
}

inline void T_DAB_Label::clearSLabelShort() {
    if (hasSLabelShort()) {
         clear_has_sLabelShort();
        _sLabelShort.clear();
     }
}

inline bool T_DAB_Label::hasSLabelShort () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DAB_Label::getSLabelShort () const {
    return _sLabelShort;
}

inline ::std::string& T_DAB_Label::getSLabelShortMutable () {
    set_has_sLabelShort();
    return _sLabelShort;
}

inline void T_DAB_Label::setSLabelShort (const ::std::string& sLabelShort_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabelShort_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabelShort();
    this->_sLabelShort = sLabelShort_;
}

inline void T_DAB_Label::setSLabelShort (const char* sLabelShort_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabelShort_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabelShort();
    this->_sLabelShort.assign(sLabelShort_);
}

inline void T_DAB_Label::setSLabelShort (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabelShort();
    this->_sLabelShort.assign(value, size);
}

inline void T_DAB_Label::clearU16LabelMask() {
    if (hasU16LabelMask()) {
         clear_has_u16LabelMask();
        _u16LabelMask = 0u;
     }
}

inline bool T_DAB_Label::hasU16LabelMask () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_DAB_Label::getU16LabelMask () const {
    return _u16LabelMask;
}

inline void T_DAB_Label::setU16LabelMask (uint16 u16LabelMask_) {
    set_has_u16LabelMask();
    this->_u16LabelMask = u16LabelMask_;
}

inline void T_DAB_Label::set_has_sLabel () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_Label::clear_has_sLabel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_Label::set_has_sLabelShort () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_Label::clear_has_sLabelShort () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_Label::set_has_u16LabelMask () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_Label::clear_has_u16LabelMask () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_b8_DAB_MTC_SetMode::T_b8_DAB_MTC_SetMode ()  :
    _DAB_SERVICELINKING_FM (false),
    _FM_SERVICELINKING_DAB (false)
{
}

inline  T_b8_DAB_MTC_SetMode::T_b8_DAB_MTC_SetMode (const T_b8_DAB_MTC_SetMode &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_DAB_MTC_SetMode::T_b8_DAB_MTC_SetMode (bool DAB_SERVICELINKING_FM, bool FM_SERVICELINKING_DAB) :
    _DAB_SERVICELINKING_FM (DAB_SERVICELINKING_FM),
    _FM_SERVICELINKING_DAB (FM_SERVICELINKING_DAB)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_DAB_MTC_SetMode& T_b8_DAB_MTC_SetMode::operator = (const T_b8_DAB_MTC_SetMode& rhs) {
    if( this != &rhs ) {
        _DAB_SERVICELINKING_FM = rhs._DAB_SERVICELINKING_FM;
        _FM_SERVICELINKING_DAB = rhs._FM_SERVICELINKING_DAB;
    }
    return *this;
}

inline bool T_b8_DAB_MTC_SetMode::operator == (const T_b8_DAB_MTC_SetMode& rhs) const {
    return (_DAB_SERVICELINKING_FM == rhs._DAB_SERVICELINKING_FM &&
        _FM_SERVICELINKING_DAB == rhs._FM_SERVICELINKING_DAB);
}

inline bool T_b8_DAB_MTC_SetMode::operator != (const T_b8_DAB_MTC_SetMode& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_DAB_MTC_SetMode::operator < (const T_b8_DAB_MTC_SetMode& rhs) const {
    if (getDAB_SERVICELINKING_FM() < rhs.getDAB_SERVICELINKING_FM()) return true;
    if (getDAB_SERVICELINKING_FM() > rhs.getDAB_SERVICELINKING_FM()) return false;

    if (getFM_SERVICELINKING_DAB() < rhs.getFM_SERVICELINKING_DAB()) return true;
    if (getFM_SERVICELINKING_DAB() > rhs.getFM_SERVICELINKING_DAB()) return false;

    return false;
}

inline bool T_b8_DAB_MTC_SetMode::operator > (const T_b8_DAB_MTC_SetMode& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_DAB_MTC_SetMode::setDAB_SERVICELINKING_FM (bool DAB_SERVICELINKING_FM) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICELINKING_FM = DAB_SERVICELINKING_FM;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_MTC_SetMode::getDAB_SERVICELINKING_FM () const {
    return _DAB_SERVICELINKING_FM;
}

inline void T_b8_DAB_MTC_SetMode::setFM_SERVICELINKING_DAB (bool FM_SERVICELINKING_DAB) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_FM_SERVICELINKING_DAB = FM_SERVICELINKING_DAB;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_MTC_SetMode::getFM_SERVICELINKING_DAB () const {
    return _FM_SERVICELINKING_DAB;
}

inline  T_b16_DAB_AnnouncementType::T_b16_DAB_AnnouncementType ()  :
    _DAB_ANNOTYPE_ALARM (false),
    _DAB_ANNOTYPE_TA (false),
    _DAB_ANNOTYPE_TRANSPORT (false),
    _DAB_ANNOTYPE_WARNING (false),
    _DAB_ANNOTYPE_NEWS (false),
    _DAB_ANNOTYPE_WEATHER (false),
    _DAB_ANNOTYPE_EVENT (false),
    _DAB_ANNOTYPE_SPECIALEVENT (false),
    _DAB_ANNOTYPE_PROGRAMME (false),
    _DAB_ANNOTYPE_SPORTS (false),
    _DAB_ANNOTYPE_FINANCE (false),
    _DAB_ANNOTYPE_b11_reserved (false),
    _DAB_ANNOTYPE_b12_reserved (false),
    _DAB_ANNOTYPE_b13_reserved (false),
    _DAB_ANNOTYPE_b14_reserved (false),
    _DAB_ANNOTYPE_b15_reserved (false)
{
}

inline  T_b16_DAB_AnnouncementType::T_b16_DAB_AnnouncementType (const T_b16_DAB_AnnouncementType &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b16_DAB_AnnouncementType::T_b16_DAB_AnnouncementType (bool DAB_ANNOTYPE_ALARM, bool DAB_ANNOTYPE_TA, bool DAB_ANNOTYPE_TRANSPORT, bool DAB_ANNOTYPE_WARNING, bool DAB_ANNOTYPE_NEWS, bool DAB_ANNOTYPE_WEATHER, bool DAB_ANNOTYPE_EVENT, bool DAB_ANNOTYPE_SPECIALEVENT, bool DAB_ANNOTYPE_PROGRAMME, bool DAB_ANNOTYPE_SPORTS, bool DAB_ANNOTYPE_FINANCE, bool DAB_ANNOTYPE_b11_reserved, bool DAB_ANNOTYPE_b12_reserved, bool DAB_ANNOTYPE_b13_reserved, bool DAB_ANNOTYPE_b14_reserved, bool DAB_ANNOTYPE_b15_reserved) :
    _DAB_ANNOTYPE_ALARM (DAB_ANNOTYPE_ALARM),
    _DAB_ANNOTYPE_TA (DAB_ANNOTYPE_TA),
    _DAB_ANNOTYPE_TRANSPORT (DAB_ANNOTYPE_TRANSPORT),
    _DAB_ANNOTYPE_WARNING (DAB_ANNOTYPE_WARNING),
    _DAB_ANNOTYPE_NEWS (DAB_ANNOTYPE_NEWS),
    _DAB_ANNOTYPE_WEATHER (DAB_ANNOTYPE_WEATHER),
    _DAB_ANNOTYPE_EVENT (DAB_ANNOTYPE_EVENT),
    _DAB_ANNOTYPE_SPECIALEVENT (DAB_ANNOTYPE_SPECIALEVENT),
    _DAB_ANNOTYPE_PROGRAMME (DAB_ANNOTYPE_PROGRAMME),
    _DAB_ANNOTYPE_SPORTS (DAB_ANNOTYPE_SPORTS),
    _DAB_ANNOTYPE_FINANCE (DAB_ANNOTYPE_FINANCE),
    _DAB_ANNOTYPE_b11_reserved (DAB_ANNOTYPE_b11_reserved),
    _DAB_ANNOTYPE_b12_reserved (DAB_ANNOTYPE_b12_reserved),
    _DAB_ANNOTYPE_b13_reserved (DAB_ANNOTYPE_b13_reserved),
    _DAB_ANNOTYPE_b14_reserved (DAB_ANNOTYPE_b14_reserved),
    _DAB_ANNOTYPE_b15_reserved (DAB_ANNOTYPE_b15_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b16_DAB_AnnouncementType& T_b16_DAB_AnnouncementType::operator = (const T_b16_DAB_AnnouncementType& rhs) {
    if( this != &rhs ) {
        _DAB_ANNOTYPE_ALARM = rhs._DAB_ANNOTYPE_ALARM;
        _DAB_ANNOTYPE_TA = rhs._DAB_ANNOTYPE_TA;
        _DAB_ANNOTYPE_TRANSPORT = rhs._DAB_ANNOTYPE_TRANSPORT;
        _DAB_ANNOTYPE_WARNING = rhs._DAB_ANNOTYPE_WARNING;
        _DAB_ANNOTYPE_NEWS = rhs._DAB_ANNOTYPE_NEWS;
        _DAB_ANNOTYPE_WEATHER = rhs._DAB_ANNOTYPE_WEATHER;
        _DAB_ANNOTYPE_EVENT = rhs._DAB_ANNOTYPE_EVENT;
        _DAB_ANNOTYPE_SPECIALEVENT = rhs._DAB_ANNOTYPE_SPECIALEVENT;
        _DAB_ANNOTYPE_PROGRAMME = rhs._DAB_ANNOTYPE_PROGRAMME;
        _DAB_ANNOTYPE_SPORTS = rhs._DAB_ANNOTYPE_SPORTS;
        _DAB_ANNOTYPE_FINANCE = rhs._DAB_ANNOTYPE_FINANCE;
        _DAB_ANNOTYPE_b11_reserved = rhs._DAB_ANNOTYPE_b11_reserved;
        _DAB_ANNOTYPE_b12_reserved = rhs._DAB_ANNOTYPE_b12_reserved;
        _DAB_ANNOTYPE_b13_reserved = rhs._DAB_ANNOTYPE_b13_reserved;
        _DAB_ANNOTYPE_b14_reserved = rhs._DAB_ANNOTYPE_b14_reserved;
        _DAB_ANNOTYPE_b15_reserved = rhs._DAB_ANNOTYPE_b15_reserved;
    }
    return *this;
}

inline bool T_b16_DAB_AnnouncementType::operator == (const T_b16_DAB_AnnouncementType& rhs) const {
    return (_DAB_ANNOTYPE_ALARM == rhs._DAB_ANNOTYPE_ALARM &&
        _DAB_ANNOTYPE_TA == rhs._DAB_ANNOTYPE_TA &&
        _DAB_ANNOTYPE_TRANSPORT == rhs._DAB_ANNOTYPE_TRANSPORT &&
        _DAB_ANNOTYPE_WARNING == rhs._DAB_ANNOTYPE_WARNING &&
        _DAB_ANNOTYPE_NEWS == rhs._DAB_ANNOTYPE_NEWS &&
        _DAB_ANNOTYPE_WEATHER == rhs._DAB_ANNOTYPE_WEATHER &&
        _DAB_ANNOTYPE_EVENT == rhs._DAB_ANNOTYPE_EVENT &&
        _DAB_ANNOTYPE_SPECIALEVENT == rhs._DAB_ANNOTYPE_SPECIALEVENT &&
        _DAB_ANNOTYPE_PROGRAMME == rhs._DAB_ANNOTYPE_PROGRAMME &&
        _DAB_ANNOTYPE_SPORTS == rhs._DAB_ANNOTYPE_SPORTS &&
        _DAB_ANNOTYPE_FINANCE == rhs._DAB_ANNOTYPE_FINANCE &&
        _DAB_ANNOTYPE_b11_reserved == rhs._DAB_ANNOTYPE_b11_reserved &&
        _DAB_ANNOTYPE_b12_reserved == rhs._DAB_ANNOTYPE_b12_reserved &&
        _DAB_ANNOTYPE_b13_reserved == rhs._DAB_ANNOTYPE_b13_reserved &&
        _DAB_ANNOTYPE_b14_reserved == rhs._DAB_ANNOTYPE_b14_reserved &&
        _DAB_ANNOTYPE_b15_reserved == rhs._DAB_ANNOTYPE_b15_reserved);
}

inline bool T_b16_DAB_AnnouncementType::operator != (const T_b16_DAB_AnnouncementType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b16_DAB_AnnouncementType::operator < (const T_b16_DAB_AnnouncementType& rhs) const {
    if (getDAB_ANNOTYPE_ALARM() < rhs.getDAB_ANNOTYPE_ALARM()) return true;
    if (getDAB_ANNOTYPE_ALARM() > rhs.getDAB_ANNOTYPE_ALARM()) return false;

    if (getDAB_ANNOTYPE_TA() < rhs.getDAB_ANNOTYPE_TA()) return true;
    if (getDAB_ANNOTYPE_TA() > rhs.getDAB_ANNOTYPE_TA()) return false;

    if (getDAB_ANNOTYPE_TRANSPORT() < rhs.getDAB_ANNOTYPE_TRANSPORT()) return true;
    if (getDAB_ANNOTYPE_TRANSPORT() > rhs.getDAB_ANNOTYPE_TRANSPORT()) return false;

    if (getDAB_ANNOTYPE_WARNING() < rhs.getDAB_ANNOTYPE_WARNING()) return true;
    if (getDAB_ANNOTYPE_WARNING() > rhs.getDAB_ANNOTYPE_WARNING()) return false;

    if (getDAB_ANNOTYPE_NEWS() < rhs.getDAB_ANNOTYPE_NEWS()) return true;
    if (getDAB_ANNOTYPE_NEWS() > rhs.getDAB_ANNOTYPE_NEWS()) return false;

    if (getDAB_ANNOTYPE_WEATHER() < rhs.getDAB_ANNOTYPE_WEATHER()) return true;
    if (getDAB_ANNOTYPE_WEATHER() > rhs.getDAB_ANNOTYPE_WEATHER()) return false;

    if (getDAB_ANNOTYPE_EVENT() < rhs.getDAB_ANNOTYPE_EVENT()) return true;
    if (getDAB_ANNOTYPE_EVENT() > rhs.getDAB_ANNOTYPE_EVENT()) return false;

    if (getDAB_ANNOTYPE_SPECIALEVENT() < rhs.getDAB_ANNOTYPE_SPECIALEVENT()) return true;
    if (getDAB_ANNOTYPE_SPECIALEVENT() > rhs.getDAB_ANNOTYPE_SPECIALEVENT()) return false;

    if (getDAB_ANNOTYPE_PROGRAMME() < rhs.getDAB_ANNOTYPE_PROGRAMME()) return true;
    if (getDAB_ANNOTYPE_PROGRAMME() > rhs.getDAB_ANNOTYPE_PROGRAMME()) return false;

    if (getDAB_ANNOTYPE_SPORTS() < rhs.getDAB_ANNOTYPE_SPORTS()) return true;
    if (getDAB_ANNOTYPE_SPORTS() > rhs.getDAB_ANNOTYPE_SPORTS()) return false;

    if (getDAB_ANNOTYPE_FINANCE() < rhs.getDAB_ANNOTYPE_FINANCE()) return true;
    if (getDAB_ANNOTYPE_FINANCE() > rhs.getDAB_ANNOTYPE_FINANCE()) return false;

    if (getDAB_ANNOTYPE_b11_reserved() < rhs.getDAB_ANNOTYPE_b11_reserved()) return true;
    if (getDAB_ANNOTYPE_b11_reserved() > rhs.getDAB_ANNOTYPE_b11_reserved()) return false;

    if (getDAB_ANNOTYPE_b12_reserved() < rhs.getDAB_ANNOTYPE_b12_reserved()) return true;
    if (getDAB_ANNOTYPE_b12_reserved() > rhs.getDAB_ANNOTYPE_b12_reserved()) return false;

    if (getDAB_ANNOTYPE_b13_reserved() < rhs.getDAB_ANNOTYPE_b13_reserved()) return true;
    if (getDAB_ANNOTYPE_b13_reserved() > rhs.getDAB_ANNOTYPE_b13_reserved()) return false;

    if (getDAB_ANNOTYPE_b14_reserved() < rhs.getDAB_ANNOTYPE_b14_reserved()) return true;
    if (getDAB_ANNOTYPE_b14_reserved() > rhs.getDAB_ANNOTYPE_b14_reserved()) return false;

    if (getDAB_ANNOTYPE_b15_reserved() < rhs.getDAB_ANNOTYPE_b15_reserved()) return true;
    if (getDAB_ANNOTYPE_b15_reserved() > rhs.getDAB_ANNOTYPE_b15_reserved()) return false;

    return false;
}

inline bool T_b16_DAB_AnnouncementType::operator > (const T_b16_DAB_AnnouncementType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_ALARM (bool DAB_ANNOTYPE_ALARM) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_ALARM = DAB_ANNOTYPE_ALARM;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_ALARM () const {
    return _DAB_ANNOTYPE_ALARM;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_TA (bool DAB_ANNOTYPE_TA) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_TA = DAB_ANNOTYPE_TA;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_TA () const {
    return _DAB_ANNOTYPE_TA;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_TRANSPORT (bool DAB_ANNOTYPE_TRANSPORT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_TRANSPORT = DAB_ANNOTYPE_TRANSPORT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_TRANSPORT () const {
    return _DAB_ANNOTYPE_TRANSPORT;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_WARNING (bool DAB_ANNOTYPE_WARNING) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_WARNING = DAB_ANNOTYPE_WARNING;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_WARNING () const {
    return _DAB_ANNOTYPE_WARNING;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_NEWS (bool DAB_ANNOTYPE_NEWS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_NEWS = DAB_ANNOTYPE_NEWS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_NEWS () const {
    return _DAB_ANNOTYPE_NEWS;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_WEATHER (bool DAB_ANNOTYPE_WEATHER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_WEATHER = DAB_ANNOTYPE_WEATHER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_WEATHER () const {
    return _DAB_ANNOTYPE_WEATHER;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_EVENT (bool DAB_ANNOTYPE_EVENT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_EVENT = DAB_ANNOTYPE_EVENT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_EVENT () const {
    return _DAB_ANNOTYPE_EVENT;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_SPECIALEVENT (bool DAB_ANNOTYPE_SPECIALEVENT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_SPECIALEVENT = DAB_ANNOTYPE_SPECIALEVENT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_SPECIALEVENT () const {
    return _DAB_ANNOTYPE_SPECIALEVENT;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_PROGRAMME (bool DAB_ANNOTYPE_PROGRAMME) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_PROGRAMME = DAB_ANNOTYPE_PROGRAMME;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_PROGRAMME () const {
    return _DAB_ANNOTYPE_PROGRAMME;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_SPORTS (bool DAB_ANNOTYPE_SPORTS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_SPORTS = DAB_ANNOTYPE_SPORTS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_SPORTS () const {
    return _DAB_ANNOTYPE_SPORTS;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_FINANCE (bool DAB_ANNOTYPE_FINANCE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_FINANCE = DAB_ANNOTYPE_FINANCE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_FINANCE () const {
    return _DAB_ANNOTYPE_FINANCE;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_b11_reserved (bool DAB_ANNOTYPE_b11_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_b11_reserved = DAB_ANNOTYPE_b11_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_b11_reserved () const {
    return _DAB_ANNOTYPE_b11_reserved;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_b12_reserved (bool DAB_ANNOTYPE_b12_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_b12_reserved = DAB_ANNOTYPE_b12_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_b12_reserved () const {
    return _DAB_ANNOTYPE_b12_reserved;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_b13_reserved (bool DAB_ANNOTYPE_b13_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_b13_reserved = DAB_ANNOTYPE_b13_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_b13_reserved () const {
    return _DAB_ANNOTYPE_b13_reserved;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_b14_reserved (bool DAB_ANNOTYPE_b14_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_b14_reserved = DAB_ANNOTYPE_b14_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_b14_reserved () const {
    return _DAB_ANNOTYPE_b14_reserved;
}

inline void T_b16_DAB_AnnouncementType::setDAB_ANNOTYPE_b15_reserved (bool DAB_ANNOTYPE_b15_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_ANNOTYPE_b15_reserved = DAB_ANNOTYPE_b15_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_AnnouncementType::getDAB_ANNOTYPE_b15_reserved () const {
    return _DAB_ANNOTYPE_b15_reserved;
}

inline  T_DAB_Frequency::T_DAB_Frequency ()  :
    _u32Frequency (0u),
    _sFreqLabel ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_Frequency::T_DAB_Frequency (const T_DAB_Frequency &rhs)  :
    _u32Frequency (0u),
    _sFreqLabel ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_Frequency::T_DAB_Frequency (uint32 u32Frequency_, const ::std::string& sFreqLabel_)  :
    _u32Frequency (u32Frequency_),
    _sFreqLabel (sFreqLabel_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_Frequency::~T_DAB_Frequency() {
}

inline T_DAB_Frequency& T_DAB_Frequency::operator = (const T_DAB_Frequency& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
        if (rhs.hasSFreqLabel()) {
            setSFreqLabel(rhs.getSFreqLabel());
        } else {
            clearSFreqLabel();
        }
    }
    return *this;
}

inline bool T_DAB_Frequency::operator == (const T_DAB_Frequency& rhs) const {
    return (((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()) &&
        ((!hasSFreqLabel() && !rhs.hasSFreqLabel()) || getSFreqLabel() == rhs.getSFreqLabel()));
}

inline bool T_DAB_Frequency::operator != (const T_DAB_Frequency& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_Frequency::operator < (const T_DAB_Frequency& rhs) const {
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    if (hasSFreqLabel() || rhs.hasSFreqLabel()) {
        if (getSFreqLabel() < rhs.getSFreqLabel()) return true;
        if (getSFreqLabel() > rhs.getSFreqLabel()) return false;
    }
    return false;
}

inline bool T_DAB_Frequency::operator > (const T_DAB_Frequency& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_Frequency::clear() {
    clearU32Frequency();
    clearSFreqLabel();
}

inline void T_DAB_Frequency::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool T_DAB_Frequency::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_Frequency::getU32Frequency () const {
    return _u32Frequency;
}

inline void T_DAB_Frequency::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void T_DAB_Frequency::clearSFreqLabel() {
    if (hasSFreqLabel()) {
         clear_has_sFreqLabel();
        _sFreqLabel.clear();
     }
}

inline bool T_DAB_Frequency::hasSFreqLabel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DAB_Frequency::getSFreqLabel () const {
    return _sFreqLabel;
}

inline ::std::string& T_DAB_Frequency::getSFreqLabelMutable () {
    set_has_sFreqLabel();
    return _sFreqLabel;
}

inline void T_DAB_Frequency::setSFreqLabel (const ::std::string& sFreqLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel = sFreqLabel_;
}

inline void T_DAB_Frequency::setSFreqLabel (const char* sFreqLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel.assign(sFreqLabel_);
}

inline void T_DAB_Frequency::setSFreqLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel.assign(value, size);
}

inline void T_DAB_Frequency::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_Frequency::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_Frequency::set_has_sFreqLabel () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_Frequency::clear_has_sFreqLabel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b16_DAB_TunerStatusFlags::T_b16_DAB_TunerStatusFlags ()  :
    _DAB_TUNERSTATUSFLAGS_SYNC (false),
    _DAB_TUNERSTATUSFLAGS_ENS_VALID (false),
    _DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID (false),
    _DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID (false),
    _DAB_TUNERSTATUSFLAGS_MUTE (false),
    _DAB_TUNERSTATUSFLAGS_TUNING (false),
    _DAB_TUNERSTATUSFLAGS_b6_reserved (false),
    _DAB_TUNERSTATUSFLAGS_b7_reserved (false),
    _DAB_TUNERSTATUSFLAGS_LEARN (false),
    _DAB_TUNERSTATUSFLAGS_b9_reserved (false),
    _DAB_TUNERSTATUSFLAGS_b10_reserved (false),
    _DAB_TUNERSTATUSFLAGS_b11_reserved (false),
    _DAB_TUNERSTATUSFLAGS_b12_reserved (false),
    _DAB_TUNERSTATUSFLAGS_b13_reserved (false),
    _DAB_TUNERSTATUSFLAGS_b14_reserved (false),
    _DAB_TUNERSTATUSFLAGS_b15_reserved (false)
{
}

inline  T_b16_DAB_TunerStatusFlags::T_b16_DAB_TunerStatusFlags (const T_b16_DAB_TunerStatusFlags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b16_DAB_TunerStatusFlags::T_b16_DAB_TunerStatusFlags (bool DAB_TUNERSTATUSFLAGS_SYNC, bool DAB_TUNERSTATUSFLAGS_ENS_VALID, bool DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID, bool DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID, bool DAB_TUNERSTATUSFLAGS_MUTE, bool DAB_TUNERSTATUSFLAGS_TUNING, bool DAB_TUNERSTATUSFLAGS_b6_reserved, bool DAB_TUNERSTATUSFLAGS_b7_reserved, bool DAB_TUNERSTATUSFLAGS_LEARN, bool DAB_TUNERSTATUSFLAGS_b9_reserved, bool DAB_TUNERSTATUSFLAGS_b10_reserved, bool DAB_TUNERSTATUSFLAGS_b11_reserved, bool DAB_TUNERSTATUSFLAGS_b12_reserved, bool DAB_TUNERSTATUSFLAGS_b13_reserved, bool DAB_TUNERSTATUSFLAGS_b14_reserved, bool DAB_TUNERSTATUSFLAGS_b15_reserved) :
    _DAB_TUNERSTATUSFLAGS_SYNC (DAB_TUNERSTATUSFLAGS_SYNC),
    _DAB_TUNERSTATUSFLAGS_ENS_VALID (DAB_TUNERSTATUSFLAGS_ENS_VALID),
    _DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID (DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID),
    _DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID (DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID),
    _DAB_TUNERSTATUSFLAGS_MUTE (DAB_TUNERSTATUSFLAGS_MUTE),
    _DAB_TUNERSTATUSFLAGS_TUNING (DAB_TUNERSTATUSFLAGS_TUNING),
    _DAB_TUNERSTATUSFLAGS_b6_reserved (DAB_TUNERSTATUSFLAGS_b6_reserved),
    _DAB_TUNERSTATUSFLAGS_b7_reserved (DAB_TUNERSTATUSFLAGS_b7_reserved),
    _DAB_TUNERSTATUSFLAGS_LEARN (DAB_TUNERSTATUSFLAGS_LEARN),
    _DAB_TUNERSTATUSFLAGS_b9_reserved (DAB_TUNERSTATUSFLAGS_b9_reserved),
    _DAB_TUNERSTATUSFLAGS_b10_reserved (DAB_TUNERSTATUSFLAGS_b10_reserved),
    _DAB_TUNERSTATUSFLAGS_b11_reserved (DAB_TUNERSTATUSFLAGS_b11_reserved),
    _DAB_TUNERSTATUSFLAGS_b12_reserved (DAB_TUNERSTATUSFLAGS_b12_reserved),
    _DAB_TUNERSTATUSFLAGS_b13_reserved (DAB_TUNERSTATUSFLAGS_b13_reserved),
    _DAB_TUNERSTATUSFLAGS_b14_reserved (DAB_TUNERSTATUSFLAGS_b14_reserved),
    _DAB_TUNERSTATUSFLAGS_b15_reserved (DAB_TUNERSTATUSFLAGS_b15_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b16_DAB_TunerStatusFlags& T_b16_DAB_TunerStatusFlags::operator = (const T_b16_DAB_TunerStatusFlags& rhs) {
    if( this != &rhs ) {
        _DAB_TUNERSTATUSFLAGS_SYNC = rhs._DAB_TUNERSTATUSFLAGS_SYNC;
        _DAB_TUNERSTATUSFLAGS_ENS_VALID = rhs._DAB_TUNERSTATUSFLAGS_ENS_VALID;
        _DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID = rhs._DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID;
        _DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID = rhs._DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID;
        _DAB_TUNERSTATUSFLAGS_MUTE = rhs._DAB_TUNERSTATUSFLAGS_MUTE;
        _DAB_TUNERSTATUSFLAGS_TUNING = rhs._DAB_TUNERSTATUSFLAGS_TUNING;
        _DAB_TUNERSTATUSFLAGS_b6_reserved = rhs._DAB_TUNERSTATUSFLAGS_b6_reserved;
        _DAB_TUNERSTATUSFLAGS_b7_reserved = rhs._DAB_TUNERSTATUSFLAGS_b7_reserved;
        _DAB_TUNERSTATUSFLAGS_LEARN = rhs._DAB_TUNERSTATUSFLAGS_LEARN;
        _DAB_TUNERSTATUSFLAGS_b9_reserved = rhs._DAB_TUNERSTATUSFLAGS_b9_reserved;
        _DAB_TUNERSTATUSFLAGS_b10_reserved = rhs._DAB_TUNERSTATUSFLAGS_b10_reserved;
        _DAB_TUNERSTATUSFLAGS_b11_reserved = rhs._DAB_TUNERSTATUSFLAGS_b11_reserved;
        _DAB_TUNERSTATUSFLAGS_b12_reserved = rhs._DAB_TUNERSTATUSFLAGS_b12_reserved;
        _DAB_TUNERSTATUSFLAGS_b13_reserved = rhs._DAB_TUNERSTATUSFLAGS_b13_reserved;
        _DAB_TUNERSTATUSFLAGS_b14_reserved = rhs._DAB_TUNERSTATUSFLAGS_b14_reserved;
        _DAB_TUNERSTATUSFLAGS_b15_reserved = rhs._DAB_TUNERSTATUSFLAGS_b15_reserved;
    }
    return *this;
}

inline bool T_b16_DAB_TunerStatusFlags::operator == (const T_b16_DAB_TunerStatusFlags& rhs) const {
    return (_DAB_TUNERSTATUSFLAGS_SYNC == rhs._DAB_TUNERSTATUSFLAGS_SYNC &&
        _DAB_TUNERSTATUSFLAGS_ENS_VALID == rhs._DAB_TUNERSTATUSFLAGS_ENS_VALID &&
        _DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID == rhs._DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID &&
        _DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID == rhs._DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID &&
        _DAB_TUNERSTATUSFLAGS_MUTE == rhs._DAB_TUNERSTATUSFLAGS_MUTE &&
        _DAB_TUNERSTATUSFLAGS_TUNING == rhs._DAB_TUNERSTATUSFLAGS_TUNING &&
        _DAB_TUNERSTATUSFLAGS_b6_reserved == rhs._DAB_TUNERSTATUSFLAGS_b6_reserved &&
        _DAB_TUNERSTATUSFLAGS_b7_reserved == rhs._DAB_TUNERSTATUSFLAGS_b7_reserved &&
        _DAB_TUNERSTATUSFLAGS_LEARN == rhs._DAB_TUNERSTATUSFLAGS_LEARN &&
        _DAB_TUNERSTATUSFLAGS_b9_reserved == rhs._DAB_TUNERSTATUSFLAGS_b9_reserved &&
        _DAB_TUNERSTATUSFLAGS_b10_reserved == rhs._DAB_TUNERSTATUSFLAGS_b10_reserved &&
        _DAB_TUNERSTATUSFLAGS_b11_reserved == rhs._DAB_TUNERSTATUSFLAGS_b11_reserved &&
        _DAB_TUNERSTATUSFLAGS_b12_reserved == rhs._DAB_TUNERSTATUSFLAGS_b12_reserved &&
        _DAB_TUNERSTATUSFLAGS_b13_reserved == rhs._DAB_TUNERSTATUSFLAGS_b13_reserved &&
        _DAB_TUNERSTATUSFLAGS_b14_reserved == rhs._DAB_TUNERSTATUSFLAGS_b14_reserved &&
        _DAB_TUNERSTATUSFLAGS_b15_reserved == rhs._DAB_TUNERSTATUSFLAGS_b15_reserved);
}

inline bool T_b16_DAB_TunerStatusFlags::operator != (const T_b16_DAB_TunerStatusFlags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b16_DAB_TunerStatusFlags::operator < (const T_b16_DAB_TunerStatusFlags& rhs) const {
    if (getDAB_TUNERSTATUSFLAGS_SYNC() < rhs.getDAB_TUNERSTATUSFLAGS_SYNC()) return true;
    if (getDAB_TUNERSTATUSFLAGS_SYNC() > rhs.getDAB_TUNERSTATUSFLAGS_SYNC()) return false;

    if (getDAB_TUNERSTATUSFLAGS_ENS_VALID() < rhs.getDAB_TUNERSTATUSFLAGS_ENS_VALID()) return true;
    if (getDAB_TUNERSTATUSFLAGS_ENS_VALID() > rhs.getDAB_TUNERSTATUSFLAGS_ENS_VALID()) return false;

    if (getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID() < rhs.getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID()) return true;
    if (getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID() > rhs.getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID()) return false;

    if (getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID() < rhs.getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID()) return true;
    if (getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID() > rhs.getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID()) return false;

    if (getDAB_TUNERSTATUSFLAGS_MUTE() < rhs.getDAB_TUNERSTATUSFLAGS_MUTE()) return true;
    if (getDAB_TUNERSTATUSFLAGS_MUTE() > rhs.getDAB_TUNERSTATUSFLAGS_MUTE()) return false;

    if (getDAB_TUNERSTATUSFLAGS_TUNING() < rhs.getDAB_TUNERSTATUSFLAGS_TUNING()) return true;
    if (getDAB_TUNERSTATUSFLAGS_TUNING() > rhs.getDAB_TUNERSTATUSFLAGS_TUNING()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b6_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b6_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b6_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b6_reserved()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b7_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b7_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b7_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b7_reserved()) return false;

    if (getDAB_TUNERSTATUSFLAGS_LEARN() < rhs.getDAB_TUNERSTATUSFLAGS_LEARN()) return true;
    if (getDAB_TUNERSTATUSFLAGS_LEARN() > rhs.getDAB_TUNERSTATUSFLAGS_LEARN()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b9_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b9_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b9_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b9_reserved()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b10_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b10_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b10_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b10_reserved()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b11_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b11_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b11_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b11_reserved()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b12_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b12_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b12_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b12_reserved()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b13_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b13_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b13_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b13_reserved()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b14_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b14_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b14_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b14_reserved()) return false;

    if (getDAB_TUNERSTATUSFLAGS_b15_reserved() < rhs.getDAB_TUNERSTATUSFLAGS_b15_reserved()) return true;
    if (getDAB_TUNERSTATUSFLAGS_b15_reserved() > rhs.getDAB_TUNERSTATUSFLAGS_b15_reserved()) return false;

    return false;
}

inline bool T_b16_DAB_TunerStatusFlags::operator > (const T_b16_DAB_TunerStatusFlags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_SYNC (bool DAB_TUNERSTATUSFLAGS_SYNC) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_SYNC = DAB_TUNERSTATUSFLAGS_SYNC;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_SYNC () const {
    return _DAB_TUNERSTATUSFLAGS_SYNC;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_ENS_VALID (bool DAB_TUNERSTATUSFLAGS_ENS_VALID) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_ENS_VALID = DAB_TUNERSTATUSFLAGS_ENS_VALID;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_ENS_VALID () const {
    return _DAB_TUNERSTATUSFLAGS_ENS_VALID;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID (bool DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID = DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID () const {
    return _DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID (bool DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID = DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID () const {
    return _DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_MUTE (bool DAB_TUNERSTATUSFLAGS_MUTE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_MUTE = DAB_TUNERSTATUSFLAGS_MUTE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_MUTE () const {
    return _DAB_TUNERSTATUSFLAGS_MUTE;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_TUNING (bool DAB_TUNERSTATUSFLAGS_TUNING) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_TUNING = DAB_TUNERSTATUSFLAGS_TUNING;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_TUNING () const {
    return _DAB_TUNERSTATUSFLAGS_TUNING;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b6_reserved (bool DAB_TUNERSTATUSFLAGS_b6_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b6_reserved = DAB_TUNERSTATUSFLAGS_b6_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b6_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b6_reserved;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b7_reserved (bool DAB_TUNERSTATUSFLAGS_b7_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b7_reserved = DAB_TUNERSTATUSFLAGS_b7_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b7_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b7_reserved;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_LEARN (bool DAB_TUNERSTATUSFLAGS_LEARN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_LEARN = DAB_TUNERSTATUSFLAGS_LEARN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_LEARN () const {
    return _DAB_TUNERSTATUSFLAGS_LEARN;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b9_reserved (bool DAB_TUNERSTATUSFLAGS_b9_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b9_reserved = DAB_TUNERSTATUSFLAGS_b9_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b9_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b9_reserved;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b10_reserved (bool DAB_TUNERSTATUSFLAGS_b10_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b10_reserved = DAB_TUNERSTATUSFLAGS_b10_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b10_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b10_reserved;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b11_reserved (bool DAB_TUNERSTATUSFLAGS_b11_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b11_reserved = DAB_TUNERSTATUSFLAGS_b11_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b11_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b11_reserved;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b12_reserved (bool DAB_TUNERSTATUSFLAGS_b12_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b12_reserved = DAB_TUNERSTATUSFLAGS_b12_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b12_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b12_reserved;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b13_reserved (bool DAB_TUNERSTATUSFLAGS_b13_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b13_reserved = DAB_TUNERSTATUSFLAGS_b13_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b13_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b13_reserved;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b14_reserved (bool DAB_TUNERSTATUSFLAGS_b14_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b14_reserved = DAB_TUNERSTATUSFLAGS_b14_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b14_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b14_reserved;
}

inline void T_b16_DAB_TunerStatusFlags::setDAB_TUNERSTATUSFLAGS_b15_reserved (bool DAB_TUNERSTATUSFLAGS_b15_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TUNERSTATUSFLAGS_b15_reserved = DAB_TUNERSTATUSFLAGS_b15_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_DAB_TunerStatusFlags::getDAB_TUNERSTATUSFLAGS_b15_reserved () const {
    return _DAB_TUNERSTATUSFLAGS_b15_reserved;
}

inline  T_DAB_TunerStatus::T_DAB_TunerStatus ()  :
    _e8TunerActivityType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_NORMAL),
    _FreqTuned (),
    _sFrequencyTable (),
    _b16Flags (),
    _u8SignalQuality (0u),
    _u8AudioQuality (0u),
    _u32CurrentEnsembleId (0u),
    _u32CurrentServiceId (0u),
    _u16CurrentSCIDI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_TunerStatus::T_DAB_TunerStatus (const T_DAB_TunerStatus &rhs)  :
    _e8TunerActivityType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_NORMAL),
    _FreqTuned (),
    _sFrequencyTable (),
    _b16Flags (),
    _u8SignalQuality (0u),
    _u8AudioQuality (0u),
    _u32CurrentEnsembleId (0u),
    _u32CurrentServiceId (0u),
    _u16CurrentSCIDI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_TunerStatus::T_DAB_TunerStatus (T_e8_DAB_TunerActivityType e8TunerActivityType_, const T_DAB_Frequency& FreqTuned_, const ::std::string& sFrequencyTable_, const T_b16_DAB_TunerStatusFlags& b16Flags_, uint8 u8SignalQuality_, uint8 u8AudioQuality_, uint32 u32CurrentEnsembleId_, uint32 u32CurrentServiceId_, uint16 u16CurrentSCIDI_)  :
    _e8TunerActivityType (e8TunerActivityType_),
    _FreqTuned (FreqTuned_),
    _sFrequencyTable (sFrequencyTable_),
    _b16Flags (b16Flags_),
    _u8SignalQuality (u8SignalQuality_),
    _u8AudioQuality (u8AudioQuality_),
    _u32CurrentEnsembleId (u32CurrentEnsembleId_),
    _u32CurrentServiceId (u32CurrentServiceId_),
    _u16CurrentSCIDI (u16CurrentSCIDI_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_TunerActivityType_IsValid(e8TunerActivityType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TunerActivityType_, "T_e8_DAB_TunerActivityType", "e8TunerActivityType", "T_DAB_TunerStatus");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFrequencyTable_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_TunerStatus::~T_DAB_TunerStatus() {
}

inline T_DAB_TunerStatus& T_DAB_TunerStatus::operator = (const T_DAB_TunerStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8TunerActivityType()) {
            setE8TunerActivityType(rhs.getE8TunerActivityType());
        } else {
            clearE8TunerActivityType();
        }
        if (rhs.hasFreqTuned()) {
            setFreqTuned(rhs.getFreqTuned());
        } else {
            clearFreqTuned();
        }
        if (rhs.hasSFrequencyTable()) {
            setSFrequencyTable(rhs.getSFrequencyTable());
        } else {
            clearSFrequencyTable();
        }
        if (rhs.hasB16Flags()) {
            setB16Flags(rhs.getB16Flags());
        } else {
            clearB16Flags();
        }
        if (rhs.hasU8SignalQuality()) {
            setU8SignalQuality(rhs.getU8SignalQuality());
        } else {
            clearU8SignalQuality();
        }
        if (rhs.hasU8AudioQuality()) {
            setU8AudioQuality(rhs.getU8AudioQuality());
        } else {
            clearU8AudioQuality();
        }
        if (rhs.hasU32CurrentEnsembleId()) {
            setU32CurrentEnsembleId(rhs.getU32CurrentEnsembleId());
        } else {
            clearU32CurrentEnsembleId();
        }
        if (rhs.hasU32CurrentServiceId()) {
            setU32CurrentServiceId(rhs.getU32CurrentServiceId());
        } else {
            clearU32CurrentServiceId();
        }
        if (rhs.hasU16CurrentSCIDI()) {
            setU16CurrentSCIDI(rhs.getU16CurrentSCIDI());
        } else {
            clearU16CurrentSCIDI();
        }
    }
    return *this;
}

inline bool T_DAB_TunerStatus::operator == (const T_DAB_TunerStatus& rhs) const {
    return (((!hasE8TunerActivityType() && !rhs.hasE8TunerActivityType()) || getE8TunerActivityType() == rhs.getE8TunerActivityType()) &&
        ((!hasFreqTuned() && !rhs.hasFreqTuned()) || getFreqTuned() == rhs.getFreqTuned()) &&
        ((!hasSFrequencyTable() && !rhs.hasSFrequencyTable()) || getSFrequencyTable() == rhs.getSFrequencyTable()) &&
        ((!hasB16Flags() && !rhs.hasB16Flags()) || getB16Flags() == rhs.getB16Flags()) &&
        ((!hasU8SignalQuality() && !rhs.hasU8SignalQuality()) || getU8SignalQuality() == rhs.getU8SignalQuality()) &&
        ((!hasU8AudioQuality() && !rhs.hasU8AudioQuality()) || getU8AudioQuality() == rhs.getU8AudioQuality()) &&
        ((!hasU32CurrentEnsembleId() && !rhs.hasU32CurrentEnsembleId()) || getU32CurrentEnsembleId() == rhs.getU32CurrentEnsembleId()) &&
        ((!hasU32CurrentServiceId() && !rhs.hasU32CurrentServiceId()) || getU32CurrentServiceId() == rhs.getU32CurrentServiceId()) &&
        ((!hasU16CurrentSCIDI() && !rhs.hasU16CurrentSCIDI()) || getU16CurrentSCIDI() == rhs.getU16CurrentSCIDI()));
}

inline bool T_DAB_TunerStatus::operator != (const T_DAB_TunerStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_TunerStatus::operator < (const T_DAB_TunerStatus& rhs) const {
    if (hasE8TunerActivityType() || rhs.hasE8TunerActivityType()) {
        if ((uint32)getE8TunerActivityType() < (uint32)rhs.getE8TunerActivityType()) return true;
        if ((uint32)getE8TunerActivityType() > (uint32)rhs.getE8TunerActivityType()) return false;
    }
    if (hasFreqTuned() || rhs.hasFreqTuned()) {
        if (getFreqTuned() < rhs.getFreqTuned()) return true;
        if (getFreqTuned() > rhs.getFreqTuned()) return false;
    }
    if (hasSFrequencyTable() || rhs.hasSFrequencyTable()) {
        if (getSFrequencyTable() < rhs.getSFrequencyTable()) return true;
        if (getSFrequencyTable() > rhs.getSFrequencyTable()) return false;
    }
    if (hasB16Flags() || rhs.hasB16Flags()) {
        if (getB16Flags() < rhs.getB16Flags()) return true;
        if (getB16Flags() > rhs.getB16Flags()) return false;
    }
    if (hasU8SignalQuality() || rhs.hasU8SignalQuality()) {
        if (getU8SignalQuality() < rhs.getU8SignalQuality()) return true;
        if (getU8SignalQuality() > rhs.getU8SignalQuality()) return false;
    }
    if (hasU8AudioQuality() || rhs.hasU8AudioQuality()) {
        if (getU8AudioQuality() < rhs.getU8AudioQuality()) return true;
        if (getU8AudioQuality() > rhs.getU8AudioQuality()) return false;
    }
    if (hasU32CurrentEnsembleId() || rhs.hasU32CurrentEnsembleId()) {
        if (getU32CurrentEnsembleId() < rhs.getU32CurrentEnsembleId()) return true;
        if (getU32CurrentEnsembleId() > rhs.getU32CurrentEnsembleId()) return false;
    }
    if (hasU32CurrentServiceId() || rhs.hasU32CurrentServiceId()) {
        if (getU32CurrentServiceId() < rhs.getU32CurrentServiceId()) return true;
        if (getU32CurrentServiceId() > rhs.getU32CurrentServiceId()) return false;
    }
    if (hasU16CurrentSCIDI() || rhs.hasU16CurrentSCIDI()) {
        if (getU16CurrentSCIDI() < rhs.getU16CurrentSCIDI()) return true;
        if (getU16CurrentSCIDI() > rhs.getU16CurrentSCIDI()) return false;
    }
    return false;
}

inline bool T_DAB_TunerStatus::operator > (const T_DAB_TunerStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_TunerStatus::clear() {
    clearE8TunerActivityType();
    clearFreqTuned();
    clearSFrequencyTable();
    clearB16Flags();
    clearU8SignalQuality();
    clearU8AudioQuality();
    clearU32CurrentEnsembleId();
    clearU32CurrentServiceId();
    clearU16CurrentSCIDI();
}

inline void T_DAB_TunerStatus::clearE8TunerActivityType() {
    if (hasE8TunerActivityType()) {
         clear_has_e8TunerActivityType();
        _e8TunerActivityType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_NORMAL;
     }
}

inline bool T_DAB_TunerStatus::hasE8TunerActivityType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_DAB_TunerActivityType T_DAB_TunerStatus::getE8TunerActivityType () const {
    return _e8TunerActivityType;
}

inline void T_DAB_TunerStatus::setE8TunerActivityType (T_e8_DAB_TunerActivityType e8TunerActivityType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_TunerActivityType_IsValid(e8TunerActivityType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TunerActivityType_, "T_e8_DAB_TunerActivityType", "e8TunerActivityType", "T_DAB_TunerStatus");
    }
    set_has_e8TunerActivityType();
    this->_e8TunerActivityType = e8TunerActivityType_;
}

inline void T_DAB_TunerStatus::clearFreqTuned() {
    if (hasFreqTuned()) {
         clear_has_FreqTuned();
        _FreqTuned.clear();
     }
}

inline bool T_DAB_TunerStatus::hasFreqTuned () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_DAB_Frequency& T_DAB_TunerStatus::getFreqTuned () const {
    return _FreqTuned;
}

inline T_DAB_Frequency& T_DAB_TunerStatus::getFreqTunedMutable () {
    set_has_FreqTuned();
    return _FreqTuned;
}

inline void T_DAB_TunerStatus::setFreqTuned (const T_DAB_Frequency& FreqTuned_) {
    set_has_FreqTuned();
    this->_FreqTuned = FreqTuned_;
}

inline void T_DAB_TunerStatus::clearSFrequencyTable() {
    if (hasSFrequencyTable()) {
         clear_has_sFrequencyTable();
        _sFrequencyTable.clear();
     }
}

inline bool T_DAB_TunerStatus::hasSFrequencyTable () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_DAB_TunerStatus::getSFrequencyTable () const {
    return _sFrequencyTable;
}

inline ::std::string& T_DAB_TunerStatus::getSFrequencyTableMutable () {
    set_has_sFrequencyTable();
    return _sFrequencyTable;
}

inline void T_DAB_TunerStatus::setSFrequencyTable (const ::std::string& sFrequencyTable_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFrequencyTable_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFrequencyTable();
    this->_sFrequencyTable = sFrequencyTable_;
}

inline void T_DAB_TunerStatus::setSFrequencyTable (const char* sFrequencyTable_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFrequencyTable_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFrequencyTable();
    this->_sFrequencyTable.assign(sFrequencyTable_);
}

inline void T_DAB_TunerStatus::setSFrequencyTable (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFrequencyTable();
    this->_sFrequencyTable.assign(value, size);
}

inline void T_DAB_TunerStatus::clearB16Flags() {
    if (hasB16Flags()) {
         clear_has_b16Flags();
        _b16Flags = T_b16_DAB_TunerStatusFlags ();
     }
}

inline bool T_DAB_TunerStatus::hasB16Flags () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_b16_DAB_TunerStatusFlags& T_DAB_TunerStatus::getB16Flags () const {
    return _b16Flags;
}

inline T_b16_DAB_TunerStatusFlags& T_DAB_TunerStatus::getB16FlagsMutable () {
    set_has_b16Flags();
    return _b16Flags;
}

inline void T_DAB_TunerStatus::setB16Flags (const T_b16_DAB_TunerStatusFlags& b16Flags_) {
    set_has_b16Flags();
    this->_b16Flags = b16Flags_;
}

inline void T_DAB_TunerStatus::clearU8SignalQuality() {
    if (hasU8SignalQuality()) {
         clear_has_u8SignalQuality();
        _u8SignalQuality = 0u;
     }
}

inline bool T_DAB_TunerStatus::hasU8SignalQuality () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_TunerStatus::getU8SignalQuality () const {
    return _u8SignalQuality;
}

inline void T_DAB_TunerStatus::setU8SignalQuality (uint8 u8SignalQuality_) {
    set_has_u8SignalQuality();
    this->_u8SignalQuality = u8SignalQuality_;
}

inline void T_DAB_TunerStatus::clearU8AudioQuality() {
    if (hasU8AudioQuality()) {
         clear_has_u8AudioQuality();
        _u8AudioQuality = 0u;
     }
}

inline bool T_DAB_TunerStatus::hasU8AudioQuality () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_DAB_TunerStatus::getU8AudioQuality () const {
    return _u8AudioQuality;
}

inline void T_DAB_TunerStatus::setU8AudioQuality (uint8 u8AudioQuality_) {
    set_has_u8AudioQuality();
    this->_u8AudioQuality = u8AudioQuality_;
}

inline void T_DAB_TunerStatus::clearU32CurrentEnsembleId() {
    if (hasU32CurrentEnsembleId()) {
         clear_has_u32CurrentEnsembleId();
        _u32CurrentEnsembleId = 0u;
     }
}

inline bool T_DAB_TunerStatus::hasU32CurrentEnsembleId () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_DAB_TunerStatus::getU32CurrentEnsembleId () const {
    return _u32CurrentEnsembleId;
}

inline void T_DAB_TunerStatus::setU32CurrentEnsembleId (uint32 u32CurrentEnsembleId_) {
    set_has_u32CurrentEnsembleId();
    this->_u32CurrentEnsembleId = u32CurrentEnsembleId_;
}

inline void T_DAB_TunerStatus::clearU32CurrentServiceId() {
    if (hasU32CurrentServiceId()) {
         clear_has_u32CurrentServiceId();
        _u32CurrentServiceId = 0u;
     }
}

inline bool T_DAB_TunerStatus::hasU32CurrentServiceId () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_DAB_TunerStatus::getU32CurrentServiceId () const {
    return _u32CurrentServiceId;
}

inline void T_DAB_TunerStatus::setU32CurrentServiceId (uint32 u32CurrentServiceId_) {
    set_has_u32CurrentServiceId();
    this->_u32CurrentServiceId = u32CurrentServiceId_;
}

inline void T_DAB_TunerStatus::clearU16CurrentSCIDI() {
    if (hasU16CurrentSCIDI()) {
         clear_has_u16CurrentSCIDI();
        _u16CurrentSCIDI = 0u;
     }
}

inline bool T_DAB_TunerStatus::hasU16CurrentSCIDI () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint16 T_DAB_TunerStatus::getU16CurrentSCIDI () const {
    return _u16CurrentSCIDI;
}

inline void T_DAB_TunerStatus::setU16CurrentSCIDI (uint16 u16CurrentSCIDI_) {
    set_has_u16CurrentSCIDI();
    this->_u16CurrentSCIDI = u16CurrentSCIDI_;
}

inline void T_DAB_TunerStatus::set_has_e8TunerActivityType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_TunerStatus::clear_has_e8TunerActivityType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_TunerStatus::set_has_FreqTuned () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_TunerStatus::clear_has_FreqTuned () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_TunerStatus::set_has_sFrequencyTable () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_TunerStatus::clear_has_sFrequencyTable () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_TunerStatus::set_has_b16Flags () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_TunerStatus::clear_has_b16Flags () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_TunerStatus::set_has_u8SignalQuality () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_TunerStatus::clear_has_u8SignalQuality () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_TunerStatus::set_has_u8AudioQuality () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_TunerStatus::clear_has_u8AudioQuality () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_TunerStatus::set_has_u32CurrentEnsembleId () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_TunerStatus::clear_has_u32CurrentEnsembleId () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_TunerStatus::set_has_u32CurrentServiceId () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_TunerStatus::clear_has_u32CurrentServiceId () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_TunerStatus::set_has_u16CurrentSCIDI () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_TunerStatus::clear_has_u16CurrentSCIDI () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_DAB_RadioText::T_DAB_RadioText ()  :
    _sRadioTextData (),
    _bValid (false),
    _u8CharSet (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_RadioText::T_DAB_RadioText (const T_DAB_RadioText &rhs)  :
    _sRadioTextData (),
    _bValid (false),
    _u8CharSet (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_RadioText::T_DAB_RadioText (const ::std::string& sRadioTextData_, bool bValid_, uint8 u8CharSet_)  :
    _sRadioTextData (sRadioTextData_),
    _bValid (bValid_),
    _u8CharSet (u8CharSet_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRadioTextData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_RadioText::~T_DAB_RadioText() {
}

inline T_DAB_RadioText& T_DAB_RadioText::operator = (const T_DAB_RadioText& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSRadioTextData()) {
            setSRadioTextData(rhs.getSRadioTextData());
        } else {
            clearSRadioTextData();
        }
        if (rhs.hasBValid()) {
            setBValid(rhs.getBValid());
        } else {
            clearBValid();
        }
        if (rhs.hasU8CharSet()) {
            setU8CharSet(rhs.getU8CharSet());
        } else {
            clearU8CharSet();
        }
    }
    return *this;
}

inline bool T_DAB_RadioText::operator == (const T_DAB_RadioText& rhs) const {
    return (((!hasSRadioTextData() && !rhs.hasSRadioTextData()) || getSRadioTextData() == rhs.getSRadioTextData()) &&
        ((!hasBValid() && !rhs.hasBValid()) || getBValid() == rhs.getBValid()) &&
        ((!hasU8CharSet() && !rhs.hasU8CharSet()) || getU8CharSet() == rhs.getU8CharSet()));
}

inline bool T_DAB_RadioText::operator != (const T_DAB_RadioText& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_RadioText::operator < (const T_DAB_RadioText& rhs) const {
    if (hasSRadioTextData() || rhs.hasSRadioTextData()) {
        if (getSRadioTextData() < rhs.getSRadioTextData()) return true;
        if (getSRadioTextData() > rhs.getSRadioTextData()) return false;
    }
    if (hasBValid() || rhs.hasBValid()) {
        if (getBValid() < rhs.getBValid()) return true;
        if (getBValid() > rhs.getBValid()) return false;
    }
    if (hasU8CharSet() || rhs.hasU8CharSet()) {
        if (getU8CharSet() < rhs.getU8CharSet()) return true;
        if (getU8CharSet() > rhs.getU8CharSet()) return false;
    }
    return false;
}

inline bool T_DAB_RadioText::operator > (const T_DAB_RadioText& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_RadioText::clear() {
    clearSRadioTextData();
    clearBValid();
    clearU8CharSet();
}

inline void T_DAB_RadioText::clearSRadioTextData() {
    if (hasSRadioTextData()) {
         clear_has_sRadioTextData();
        _sRadioTextData.clear();
     }
}

inline bool T_DAB_RadioText::hasSRadioTextData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_DAB_RadioText::getSRadioTextData () const {
    return _sRadioTextData;
}

inline ::std::string& T_DAB_RadioText::getSRadioTextDataMutable () {
    set_has_sRadioTextData();
    return _sRadioTextData;
}

inline void T_DAB_RadioText::setSRadioTextData (const ::std::string& sRadioTextData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRadioTextData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRadioTextData();
    this->_sRadioTextData = sRadioTextData_;
}

inline void T_DAB_RadioText::setSRadioTextData (const char* sRadioTextData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRadioTextData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRadioTextData();
    this->_sRadioTextData.assign(sRadioTextData_);
}

inline void T_DAB_RadioText::setSRadioTextData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRadioTextData();
    this->_sRadioTextData.assign(value, size);
}

inline void T_DAB_RadioText::clearBValid() {
    if (hasBValid()) {
         clear_has_bValid();
        _bValid = false;
     }
}

inline bool T_DAB_RadioText::hasBValid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_DAB_RadioText::getBValid () const {
    return _bValid;
}

inline void T_DAB_RadioText::setBValid (bool bValid_) {
    set_has_bValid();
    this->_bValid = bValid_;
}

inline void T_DAB_RadioText::clearU8CharSet() {
    if (hasU8CharSet()) {
         clear_has_u8CharSet();
        _u8CharSet = 0u;
     }
}

inline bool T_DAB_RadioText::hasU8CharSet () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_DAB_RadioText::getU8CharSet () const {
    return _u8CharSet;
}

inline void T_DAB_RadioText::setU8CharSet (uint8 u8CharSet_) {
    set_has_u8CharSet();
    this->_u8CharSet = u8CharSet_;
}

inline void T_DAB_RadioText::set_has_sRadioTextData () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_RadioText::clear_has_sRadioTextData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_RadioText::set_has_bValid () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_RadioText::clear_has_bValid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_RadioText::set_has_u8CharSet () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_RadioText::clear_has_u8CharSet () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_DAB_RadioTextPlus::T_DAB_RadioTextPlus ()  :
    _u8ContentType (0u),
    _Content ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_RadioTextPlus::T_DAB_RadioTextPlus (const T_DAB_RadioTextPlus &rhs)  :
    _u8ContentType (0u),
    _Content ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_RadioTextPlus::T_DAB_RadioTextPlus (uint8 u8ContentType_, const T_DAB_RadioText& Content_)  :
    _u8ContentType (u8ContentType_),
    _Content (Content_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_RadioTextPlus::~T_DAB_RadioTextPlus() {
}

inline T_DAB_RadioTextPlus& T_DAB_RadioTextPlus::operator = (const T_DAB_RadioTextPlus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8ContentType()) {
            setU8ContentType(rhs.getU8ContentType());
        } else {
            clearU8ContentType();
        }
        if (rhs.hasContent()) {
            setContent(rhs.getContent());
        } else {
            clearContent();
        }
    }
    return *this;
}

inline bool T_DAB_RadioTextPlus::operator == (const T_DAB_RadioTextPlus& rhs) const {
    return (((!hasU8ContentType() && !rhs.hasU8ContentType()) || getU8ContentType() == rhs.getU8ContentType()) &&
        ((!hasContent() && !rhs.hasContent()) || getContent() == rhs.getContent()));
}

inline bool T_DAB_RadioTextPlus::operator != (const T_DAB_RadioTextPlus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_RadioTextPlus::operator < (const T_DAB_RadioTextPlus& rhs) const {
    if (hasU8ContentType() || rhs.hasU8ContentType()) {
        if (getU8ContentType() < rhs.getU8ContentType()) return true;
        if (getU8ContentType() > rhs.getU8ContentType()) return false;
    }
    if (hasContent() || rhs.hasContent()) {
        if (getContent() < rhs.getContent()) return true;
        if (getContent() > rhs.getContent()) return false;
    }
    return false;
}

inline bool T_DAB_RadioTextPlus::operator > (const T_DAB_RadioTextPlus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_RadioTextPlus::clear() {
    clearU8ContentType();
    clearContent();
}

inline void T_DAB_RadioTextPlus::clearU8ContentType() {
    if (hasU8ContentType()) {
         clear_has_u8ContentType();
        _u8ContentType = 0u;
     }
}

inline bool T_DAB_RadioTextPlus::hasU8ContentType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_DAB_RadioTextPlus::getU8ContentType () const {
    return _u8ContentType;
}

inline void T_DAB_RadioTextPlus::setU8ContentType (uint8 u8ContentType_) {
    set_has_u8ContentType();
    this->_u8ContentType = u8ContentType_;
}

inline void T_DAB_RadioTextPlus::clearContent() {
    if (hasContent()) {
         clear_has_Content();
        _Content.clear();
     }
}

inline bool T_DAB_RadioTextPlus::hasContent () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_DAB_RadioText& T_DAB_RadioTextPlus::getContent () const {
    return _Content;
}

inline T_DAB_RadioText& T_DAB_RadioTextPlus::getContentMutable () {
    set_has_Content();
    return _Content;
}

inline void T_DAB_RadioTextPlus::setContent (const T_DAB_RadioText& Content_) {
    set_has_Content();
    this->_Content = Content_;
}

inline void T_DAB_RadioTextPlus::set_has_u8ContentType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_RadioTextPlus::clear_has_u8ContentType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_RadioTextPlus::set_has_Content () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_RadioTextPlus::clear_has_Content () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DAB_EnsembleInfo::T_DAB_EnsembleInfo ()  :
    _u32EnsembleId (0u),
    _EnsembleLabel (),
    _u32Frequency (0u),
    _u8NumberOfAudioServices (0u),
    _u8NumberOfDataServices (0u),
    _u8NumberOfAudioServiceComponents (0u),
    _u8NumberOfDataServiceComponents (0u),
    _u8ReceptionQuality (0u),
    _u8NumberOfEnsembles (0u),
    _u8ListElementId (0u),
    _bReception (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_EnsembleInfo::T_DAB_EnsembleInfo (const T_DAB_EnsembleInfo &rhs)  :
    _u32EnsembleId (0u),
    _EnsembleLabel (),
    _u32Frequency (0u),
    _u8NumberOfAudioServices (0u),
    _u8NumberOfDataServices (0u),
    _u8NumberOfAudioServiceComponents (0u),
    _u8NumberOfDataServiceComponents (0u),
    _u8ReceptionQuality (0u),
    _u8NumberOfEnsembles (0u),
    _u8ListElementId (0u),
    _bReception (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_EnsembleInfo::T_DAB_EnsembleInfo (uint32 u32EnsembleId_, const T_DAB_Label& EnsembleLabel_, uint32 u32Frequency_, uint8 u8NumberOfAudioServices_, uint8 u8NumberOfDataServices_, uint8 u8NumberOfAudioServiceComponents_, uint8 u8NumberOfDataServiceComponents_, uint8 u8ReceptionQuality_, uint8 u8NumberOfEnsembles_, uint8 u8ListElementId_, bool bReception_)  :
    _u32EnsembleId (u32EnsembleId_),
    _EnsembleLabel (EnsembleLabel_),
    _u32Frequency (u32Frequency_),
    _u8NumberOfAudioServices (u8NumberOfAudioServices_),
    _u8NumberOfDataServices (u8NumberOfDataServices_),
    _u8NumberOfAudioServiceComponents (u8NumberOfAudioServiceComponents_),
    _u8NumberOfDataServiceComponents (u8NumberOfDataServiceComponents_),
    _u8ReceptionQuality (u8ReceptionQuality_),
    _u8NumberOfEnsembles (u8NumberOfEnsembles_),
    _u8ListElementId (u8ListElementId_),
    _bReception (bReception_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_EnsembleInfo::~T_DAB_EnsembleInfo() {
}

inline T_DAB_EnsembleInfo& T_DAB_EnsembleInfo::operator = (const T_DAB_EnsembleInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32EnsembleId()) {
            setU32EnsembleId(rhs.getU32EnsembleId());
        } else {
            clearU32EnsembleId();
        }
        if (rhs.hasEnsembleLabel()) {
            setEnsembleLabel(rhs.getEnsembleLabel());
        } else {
            clearEnsembleLabel();
        }
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
        if (rhs.hasU8NumberOfAudioServices()) {
            setU8NumberOfAudioServices(rhs.getU8NumberOfAudioServices());
        } else {
            clearU8NumberOfAudioServices();
        }
        if (rhs.hasU8NumberOfDataServices()) {
            setU8NumberOfDataServices(rhs.getU8NumberOfDataServices());
        } else {
            clearU8NumberOfDataServices();
        }
        if (rhs.hasU8NumberOfAudioServiceComponents()) {
            setU8NumberOfAudioServiceComponents(rhs.getU8NumberOfAudioServiceComponents());
        } else {
            clearU8NumberOfAudioServiceComponents();
        }
        if (rhs.hasU8NumberOfDataServiceComponents()) {
            setU8NumberOfDataServiceComponents(rhs.getU8NumberOfDataServiceComponents());
        } else {
            clearU8NumberOfDataServiceComponents();
        }
        if (rhs.hasU8ReceptionQuality()) {
            setU8ReceptionQuality(rhs.getU8ReceptionQuality());
        } else {
            clearU8ReceptionQuality();
        }
        if (rhs.hasU8NumberOfEnsembles()) {
            setU8NumberOfEnsembles(rhs.getU8NumberOfEnsembles());
        } else {
            clearU8NumberOfEnsembles();
        }
        if (rhs.hasU8ListElementId()) {
            setU8ListElementId(rhs.getU8ListElementId());
        } else {
            clearU8ListElementId();
        }
        if (rhs.hasBReception()) {
            setBReception(rhs.getBReception());
        } else {
            clearBReception();
        }
    }
    return *this;
}

inline bool T_DAB_EnsembleInfo::operator == (const T_DAB_EnsembleInfo& rhs) const {
    return (((!hasU32EnsembleId() && !rhs.hasU32EnsembleId()) || getU32EnsembleId() == rhs.getU32EnsembleId()) &&
        ((!hasEnsembleLabel() && !rhs.hasEnsembleLabel()) || getEnsembleLabel() == rhs.getEnsembleLabel()) &&
        ((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()) &&
        ((!hasU8NumberOfAudioServices() && !rhs.hasU8NumberOfAudioServices()) || getU8NumberOfAudioServices() == rhs.getU8NumberOfAudioServices()) &&
        ((!hasU8NumberOfDataServices() && !rhs.hasU8NumberOfDataServices()) || getU8NumberOfDataServices() == rhs.getU8NumberOfDataServices()) &&
        ((!hasU8NumberOfAudioServiceComponents() && !rhs.hasU8NumberOfAudioServiceComponents()) || getU8NumberOfAudioServiceComponents() == rhs.getU8NumberOfAudioServiceComponents()) &&
        ((!hasU8NumberOfDataServiceComponents() && !rhs.hasU8NumberOfDataServiceComponents()) || getU8NumberOfDataServiceComponents() == rhs.getU8NumberOfDataServiceComponents()) &&
        ((!hasU8ReceptionQuality() && !rhs.hasU8ReceptionQuality()) || getU8ReceptionQuality() == rhs.getU8ReceptionQuality()) &&
        ((!hasU8NumberOfEnsembles() && !rhs.hasU8NumberOfEnsembles()) || getU8NumberOfEnsembles() == rhs.getU8NumberOfEnsembles()) &&
        ((!hasU8ListElementId() && !rhs.hasU8ListElementId()) || getU8ListElementId() == rhs.getU8ListElementId()) &&
        ((!hasBReception() && !rhs.hasBReception()) || getBReception() == rhs.getBReception()));
}

inline bool T_DAB_EnsembleInfo::operator != (const T_DAB_EnsembleInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_EnsembleInfo::operator < (const T_DAB_EnsembleInfo& rhs) const {
    if (hasU32EnsembleId() || rhs.hasU32EnsembleId()) {
        if (getU32EnsembleId() < rhs.getU32EnsembleId()) return true;
        if (getU32EnsembleId() > rhs.getU32EnsembleId()) return false;
    }
    if (hasEnsembleLabel() || rhs.hasEnsembleLabel()) {
        if (getEnsembleLabel() < rhs.getEnsembleLabel()) return true;
        if (getEnsembleLabel() > rhs.getEnsembleLabel()) return false;
    }
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    if (hasU8NumberOfAudioServices() || rhs.hasU8NumberOfAudioServices()) {
        if (getU8NumberOfAudioServices() < rhs.getU8NumberOfAudioServices()) return true;
        if (getU8NumberOfAudioServices() > rhs.getU8NumberOfAudioServices()) return false;
    }
    if (hasU8NumberOfDataServices() || rhs.hasU8NumberOfDataServices()) {
        if (getU8NumberOfDataServices() < rhs.getU8NumberOfDataServices()) return true;
        if (getU8NumberOfDataServices() > rhs.getU8NumberOfDataServices()) return false;
    }
    if (hasU8NumberOfAudioServiceComponents() || rhs.hasU8NumberOfAudioServiceComponents()) {
        if (getU8NumberOfAudioServiceComponents() < rhs.getU8NumberOfAudioServiceComponents()) return true;
        if (getU8NumberOfAudioServiceComponents() > rhs.getU8NumberOfAudioServiceComponents()) return false;
    }
    if (hasU8NumberOfDataServiceComponents() || rhs.hasU8NumberOfDataServiceComponents()) {
        if (getU8NumberOfDataServiceComponents() < rhs.getU8NumberOfDataServiceComponents()) return true;
        if (getU8NumberOfDataServiceComponents() > rhs.getU8NumberOfDataServiceComponents()) return false;
    }
    if (hasU8ReceptionQuality() || rhs.hasU8ReceptionQuality()) {
        if (getU8ReceptionQuality() < rhs.getU8ReceptionQuality()) return true;
        if (getU8ReceptionQuality() > rhs.getU8ReceptionQuality()) return false;
    }
    if (hasU8NumberOfEnsembles() || rhs.hasU8NumberOfEnsembles()) {
        if (getU8NumberOfEnsembles() < rhs.getU8NumberOfEnsembles()) return true;
        if (getU8NumberOfEnsembles() > rhs.getU8NumberOfEnsembles()) return false;
    }
    if (hasU8ListElementId() || rhs.hasU8ListElementId()) {
        if (getU8ListElementId() < rhs.getU8ListElementId()) return true;
        if (getU8ListElementId() > rhs.getU8ListElementId()) return false;
    }
    if (hasBReception() || rhs.hasBReception()) {
        if (getBReception() < rhs.getBReception()) return true;
        if (getBReception() > rhs.getBReception()) return false;
    }
    return false;
}

inline bool T_DAB_EnsembleInfo::operator > (const T_DAB_EnsembleInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_EnsembleInfo::clear() {
    clearU32EnsembleId();
    clearEnsembleLabel();
    clearU32Frequency();
    clearU8NumberOfAudioServices();
    clearU8NumberOfDataServices();
    clearU8NumberOfAudioServiceComponents();
    clearU8NumberOfDataServiceComponents();
    clearU8ReceptionQuality();
    clearU8NumberOfEnsembles();
    clearU8ListElementId();
    clearBReception();
}

inline void T_DAB_EnsembleInfo::clearU32EnsembleId() {
    if (hasU32EnsembleId()) {
         clear_has_u32EnsembleId();
        _u32EnsembleId = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU32EnsembleId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_EnsembleInfo::getU32EnsembleId () const {
    return _u32EnsembleId;
}

inline void T_DAB_EnsembleInfo::setU32EnsembleId (uint32 u32EnsembleId_) {
    set_has_u32EnsembleId();
    this->_u32EnsembleId = u32EnsembleId_;
}

inline void T_DAB_EnsembleInfo::clearEnsembleLabel() {
    if (hasEnsembleLabel()) {
         clear_has_EnsembleLabel();
        _EnsembleLabel.clear();
     }
}

inline bool T_DAB_EnsembleInfo::hasEnsembleLabel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_DAB_Label& T_DAB_EnsembleInfo::getEnsembleLabel () const {
    return _EnsembleLabel;
}

inline T_DAB_Label& T_DAB_EnsembleInfo::getEnsembleLabelMutable () {
    set_has_EnsembleLabel();
    return _EnsembleLabel;
}

inline void T_DAB_EnsembleInfo::setEnsembleLabel (const T_DAB_Label& EnsembleLabel_) {
    set_has_EnsembleLabel();
    this->_EnsembleLabel = EnsembleLabel_;
}

inline void T_DAB_EnsembleInfo::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_DAB_EnsembleInfo::getU32Frequency () const {
    return _u32Frequency;
}

inline void T_DAB_EnsembleInfo::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void T_DAB_EnsembleInfo::clearU8NumberOfAudioServices() {
    if (hasU8NumberOfAudioServices()) {
         clear_has_u8NumberOfAudioServices();
        _u8NumberOfAudioServices = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU8NumberOfAudioServices () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_DAB_EnsembleInfo::getU8NumberOfAudioServices () const {
    return _u8NumberOfAudioServices;
}

inline void T_DAB_EnsembleInfo::setU8NumberOfAudioServices (uint8 u8NumberOfAudioServices_) {
    set_has_u8NumberOfAudioServices();
    this->_u8NumberOfAudioServices = u8NumberOfAudioServices_;
}

inline void T_DAB_EnsembleInfo::clearU8NumberOfDataServices() {
    if (hasU8NumberOfDataServices()) {
         clear_has_u8NumberOfDataServices();
        _u8NumberOfDataServices = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU8NumberOfDataServices () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_EnsembleInfo::getU8NumberOfDataServices () const {
    return _u8NumberOfDataServices;
}

inline void T_DAB_EnsembleInfo::setU8NumberOfDataServices (uint8 u8NumberOfDataServices_) {
    set_has_u8NumberOfDataServices();
    this->_u8NumberOfDataServices = u8NumberOfDataServices_;
}

inline void T_DAB_EnsembleInfo::clearU8NumberOfAudioServiceComponents() {
    if (hasU8NumberOfAudioServiceComponents()) {
         clear_has_u8NumberOfAudioServiceComponents();
        _u8NumberOfAudioServiceComponents = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU8NumberOfAudioServiceComponents () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_DAB_EnsembleInfo::getU8NumberOfAudioServiceComponents () const {
    return _u8NumberOfAudioServiceComponents;
}

inline void T_DAB_EnsembleInfo::setU8NumberOfAudioServiceComponents (uint8 u8NumberOfAudioServiceComponents_) {
    set_has_u8NumberOfAudioServiceComponents();
    this->_u8NumberOfAudioServiceComponents = u8NumberOfAudioServiceComponents_;
}

inline void T_DAB_EnsembleInfo::clearU8NumberOfDataServiceComponents() {
    if (hasU8NumberOfDataServiceComponents()) {
         clear_has_u8NumberOfDataServiceComponents();
        _u8NumberOfDataServiceComponents = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU8NumberOfDataServiceComponents () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_DAB_EnsembleInfo::getU8NumberOfDataServiceComponents () const {
    return _u8NumberOfDataServiceComponents;
}

inline void T_DAB_EnsembleInfo::setU8NumberOfDataServiceComponents (uint8 u8NumberOfDataServiceComponents_) {
    set_has_u8NumberOfDataServiceComponents();
    this->_u8NumberOfDataServiceComponents = u8NumberOfDataServiceComponents_;
}

inline void T_DAB_EnsembleInfo::clearU8ReceptionQuality() {
    if (hasU8ReceptionQuality()) {
         clear_has_u8ReceptionQuality();
        _u8ReceptionQuality = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU8ReceptionQuality () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_DAB_EnsembleInfo::getU8ReceptionQuality () const {
    return _u8ReceptionQuality;
}

inline void T_DAB_EnsembleInfo::setU8ReceptionQuality (uint8 u8ReceptionQuality_) {
    set_has_u8ReceptionQuality();
    this->_u8ReceptionQuality = u8ReceptionQuality_;
}

inline void T_DAB_EnsembleInfo::clearU8NumberOfEnsembles() {
    if (hasU8NumberOfEnsembles()) {
         clear_has_u8NumberOfEnsembles();
        _u8NumberOfEnsembles = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU8NumberOfEnsembles () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_DAB_EnsembleInfo::getU8NumberOfEnsembles () const {
    return _u8NumberOfEnsembles;
}

inline void T_DAB_EnsembleInfo::setU8NumberOfEnsembles (uint8 u8NumberOfEnsembles_) {
    set_has_u8NumberOfEnsembles();
    this->_u8NumberOfEnsembles = u8NumberOfEnsembles_;
}

inline void T_DAB_EnsembleInfo::clearU8ListElementId() {
    if (hasU8ListElementId()) {
         clear_has_u8ListElementId();
        _u8ListElementId = 0u;
     }
}

inline bool T_DAB_EnsembleInfo::hasU8ListElementId () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint8 T_DAB_EnsembleInfo::getU8ListElementId () const {
    return _u8ListElementId;
}

inline void T_DAB_EnsembleInfo::setU8ListElementId (uint8 u8ListElementId_) {
    set_has_u8ListElementId();
    this->_u8ListElementId = u8ListElementId_;
}

inline void T_DAB_EnsembleInfo::clearBReception() {
    if (hasBReception()) {
         clear_has_bReception();
        _bReception = false;
     }
}

inline bool T_DAB_EnsembleInfo::hasBReception () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_DAB_EnsembleInfo::getBReception () const {
    return _bReception;
}

inline void T_DAB_EnsembleInfo::setBReception (bool bReception_) {
    set_has_bReception();
    this->_bReception = bReception_;
}

inline void T_DAB_EnsembleInfo::set_has_u32EnsembleId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_EnsembleInfo::clear_has_u32EnsembleId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_EnsembleInfo::set_has_EnsembleLabel () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_EnsembleInfo::clear_has_EnsembleLabel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_EnsembleInfo::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_EnsembleInfo::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_EnsembleInfo::set_has_u8NumberOfAudioServices () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_EnsembleInfo::clear_has_u8NumberOfAudioServices () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_EnsembleInfo::set_has_u8NumberOfDataServices () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_EnsembleInfo::clear_has_u8NumberOfDataServices () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_EnsembleInfo::set_has_u8NumberOfAudioServiceComponents () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_EnsembleInfo::clear_has_u8NumberOfAudioServiceComponents () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_EnsembleInfo::set_has_u8NumberOfDataServiceComponents () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_EnsembleInfo::clear_has_u8NumberOfDataServiceComponents () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_EnsembleInfo::set_has_u8ReceptionQuality () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_EnsembleInfo::clear_has_u8ReceptionQuality () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_EnsembleInfo::set_has_u8NumberOfEnsembles () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_EnsembleInfo::clear_has_u8NumberOfEnsembles () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DAB_EnsembleInfo::set_has_u8ListElementId () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DAB_EnsembleInfo::clear_has_u8ListElementId () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DAB_EnsembleInfo::set_has_bReception () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DAB_EnsembleInfo::clear_has_bReception () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline  T_b8_DAB_ServiceInfoFlags::T_b8_DAB_ServiceInfoFlags ()  :
    _DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT (false),
    _DAB_SERVICEINFO_TMC_COMPONENT (false),
    _DAB_SERVICEINFO_DRC (false),
    _DAB_SERVICEINFO_b3_reserved (false),
    _DAB_SERVICEINFO_b4_reserved (false),
    _DAB_SERVICEINFO_b5_reserved (false),
    _DAB_SERVICEINFO_b6_reserved (false),
    _DAB_SERVICEINFO_b7_reserved (false)
{
}

inline  T_b8_DAB_ServiceInfoFlags::T_b8_DAB_ServiceInfoFlags (const T_b8_DAB_ServiceInfoFlags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_DAB_ServiceInfoFlags::T_b8_DAB_ServiceInfoFlags (bool DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT, bool DAB_SERVICEINFO_TMC_COMPONENT, bool DAB_SERVICEINFO_DRC, bool DAB_SERVICEINFO_b3_reserved, bool DAB_SERVICEINFO_b4_reserved, bool DAB_SERVICEINFO_b5_reserved, bool DAB_SERVICEINFO_b6_reserved, bool DAB_SERVICEINFO_b7_reserved) :
    _DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT (DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT),
    _DAB_SERVICEINFO_TMC_COMPONENT (DAB_SERVICEINFO_TMC_COMPONENT),
    _DAB_SERVICEINFO_DRC (DAB_SERVICEINFO_DRC),
    _DAB_SERVICEINFO_b3_reserved (DAB_SERVICEINFO_b3_reserved),
    _DAB_SERVICEINFO_b4_reserved (DAB_SERVICEINFO_b4_reserved),
    _DAB_SERVICEINFO_b5_reserved (DAB_SERVICEINFO_b5_reserved),
    _DAB_SERVICEINFO_b6_reserved (DAB_SERVICEINFO_b6_reserved),
    _DAB_SERVICEINFO_b7_reserved (DAB_SERVICEINFO_b7_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_DAB_ServiceInfoFlags& T_b8_DAB_ServiceInfoFlags::operator = (const T_b8_DAB_ServiceInfoFlags& rhs) {
    if( this != &rhs ) {
        _DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT = rhs._DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT;
        _DAB_SERVICEINFO_TMC_COMPONENT = rhs._DAB_SERVICEINFO_TMC_COMPONENT;
        _DAB_SERVICEINFO_DRC = rhs._DAB_SERVICEINFO_DRC;
        _DAB_SERVICEINFO_b3_reserved = rhs._DAB_SERVICEINFO_b3_reserved;
        _DAB_SERVICEINFO_b4_reserved = rhs._DAB_SERVICEINFO_b4_reserved;
        _DAB_SERVICEINFO_b5_reserved = rhs._DAB_SERVICEINFO_b5_reserved;
        _DAB_SERVICEINFO_b6_reserved = rhs._DAB_SERVICEINFO_b6_reserved;
        _DAB_SERVICEINFO_b7_reserved = rhs._DAB_SERVICEINFO_b7_reserved;
    }
    return *this;
}

inline bool T_b8_DAB_ServiceInfoFlags::operator == (const T_b8_DAB_ServiceInfoFlags& rhs) const {
    return (_DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT == rhs._DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT &&
        _DAB_SERVICEINFO_TMC_COMPONENT == rhs._DAB_SERVICEINFO_TMC_COMPONENT &&
        _DAB_SERVICEINFO_DRC == rhs._DAB_SERVICEINFO_DRC &&
        _DAB_SERVICEINFO_b3_reserved == rhs._DAB_SERVICEINFO_b3_reserved &&
        _DAB_SERVICEINFO_b4_reserved == rhs._DAB_SERVICEINFO_b4_reserved &&
        _DAB_SERVICEINFO_b5_reserved == rhs._DAB_SERVICEINFO_b5_reserved &&
        _DAB_SERVICEINFO_b6_reserved == rhs._DAB_SERVICEINFO_b6_reserved &&
        _DAB_SERVICEINFO_b7_reserved == rhs._DAB_SERVICEINFO_b7_reserved);
}

inline bool T_b8_DAB_ServiceInfoFlags::operator != (const T_b8_DAB_ServiceInfoFlags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_DAB_ServiceInfoFlags::operator < (const T_b8_DAB_ServiceInfoFlags& rhs) const {
    if (getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT() < rhs.getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT()) return true;
    if (getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT() > rhs.getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT()) return false;

    if (getDAB_SERVICEINFO_TMC_COMPONENT() < rhs.getDAB_SERVICEINFO_TMC_COMPONENT()) return true;
    if (getDAB_SERVICEINFO_TMC_COMPONENT() > rhs.getDAB_SERVICEINFO_TMC_COMPONENT()) return false;

    if (getDAB_SERVICEINFO_DRC() < rhs.getDAB_SERVICEINFO_DRC()) return true;
    if (getDAB_SERVICEINFO_DRC() > rhs.getDAB_SERVICEINFO_DRC()) return false;

    if (getDAB_SERVICEINFO_b3_reserved() < rhs.getDAB_SERVICEINFO_b3_reserved()) return true;
    if (getDAB_SERVICEINFO_b3_reserved() > rhs.getDAB_SERVICEINFO_b3_reserved()) return false;

    if (getDAB_SERVICEINFO_b4_reserved() < rhs.getDAB_SERVICEINFO_b4_reserved()) return true;
    if (getDAB_SERVICEINFO_b4_reserved() > rhs.getDAB_SERVICEINFO_b4_reserved()) return false;

    if (getDAB_SERVICEINFO_b5_reserved() < rhs.getDAB_SERVICEINFO_b5_reserved()) return true;
    if (getDAB_SERVICEINFO_b5_reserved() > rhs.getDAB_SERVICEINFO_b5_reserved()) return false;

    if (getDAB_SERVICEINFO_b6_reserved() < rhs.getDAB_SERVICEINFO_b6_reserved()) return true;
    if (getDAB_SERVICEINFO_b6_reserved() > rhs.getDAB_SERVICEINFO_b6_reserved()) return false;

    if (getDAB_SERVICEINFO_b7_reserved() < rhs.getDAB_SERVICEINFO_b7_reserved()) return true;
    if (getDAB_SERVICEINFO_b7_reserved() > rhs.getDAB_SERVICEINFO_b7_reserved()) return false;

    return false;
}

inline bool T_b8_DAB_ServiceInfoFlags::operator > (const T_b8_DAB_ServiceInfoFlags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_DAB_ServiceInfoFlags::setDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT (bool DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT = DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ServiceInfoFlags::getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT () const {
    return _DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT;
}

inline void T_b8_DAB_ServiceInfoFlags::setDAB_SERVICEINFO_TMC_COMPONENT (bool DAB_SERVICEINFO_TMC_COMPONENT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICEINFO_TMC_COMPONENT = DAB_SERVICEINFO_TMC_COMPONENT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ServiceInfoFlags::getDAB_SERVICEINFO_TMC_COMPONENT () const {
    return _DAB_SERVICEINFO_TMC_COMPONENT;
}

inline void T_b8_DAB_ServiceInfoFlags::setDAB_SERVICEINFO_DRC (bool DAB_SERVICEINFO_DRC) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICEINFO_DRC = DAB_SERVICEINFO_DRC;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ServiceInfoFlags::getDAB_SERVICEINFO_DRC () const {
    return _DAB_SERVICEINFO_DRC;
}

inline void T_b8_DAB_ServiceInfoFlags::setDAB_SERVICEINFO_b3_reserved (bool DAB_SERVICEINFO_b3_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICEINFO_b3_reserved = DAB_SERVICEINFO_b3_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ServiceInfoFlags::getDAB_SERVICEINFO_b3_reserved () const {
    return _DAB_SERVICEINFO_b3_reserved;
}

inline void T_b8_DAB_ServiceInfoFlags::setDAB_SERVICEINFO_b4_reserved (bool DAB_SERVICEINFO_b4_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICEINFO_b4_reserved = DAB_SERVICEINFO_b4_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ServiceInfoFlags::getDAB_SERVICEINFO_b4_reserved () const {
    return _DAB_SERVICEINFO_b4_reserved;
}

inline void T_b8_DAB_ServiceInfoFlags::setDAB_SERVICEINFO_b5_reserved (bool DAB_SERVICEINFO_b5_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICEINFO_b5_reserved = DAB_SERVICEINFO_b5_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ServiceInfoFlags::getDAB_SERVICEINFO_b5_reserved () const {
    return _DAB_SERVICEINFO_b5_reserved;
}

inline void T_b8_DAB_ServiceInfoFlags::setDAB_SERVICEINFO_b6_reserved (bool DAB_SERVICEINFO_b6_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICEINFO_b6_reserved = DAB_SERVICEINFO_b6_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ServiceInfoFlags::getDAB_SERVICEINFO_b6_reserved () const {
    return _DAB_SERVICEINFO_b6_reserved;
}

inline void T_b8_DAB_ServiceInfoFlags::setDAB_SERVICEINFO_b7_reserved (bool DAB_SERVICEINFO_b7_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SERVICEINFO_b7_reserved = DAB_SERVICEINFO_b7_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ServiceInfoFlags::getDAB_SERVICEINFO_b7_reserved () const {
    return _DAB_SERVICEINFO_b7_reserved;
}

inline  T_DAB_ServiceInfo::T_DAB_ServiceInfo ()  :
    _u32ServId (0u),
    _ServiceLabel (),
    _e8ServiceType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType__DAB_SERVICETYPE_UNKNOWN),
    _u8NumberOfAudioComponents (0u),
    _u8NumberOfDataComponents (0u),
    _b16AvailableAnnoTypesMask (),
    _u8SampleRate (0u),
    _u16BitRate (0u),
    _sAudioMode (),
    _sAdvancedAudioCodec (),
    _sAudioCodec (),
    _b8Flags (),
    _u8PresetListElementID (0u),
    _u16ServiceIndex (0u),
    _u8PTYCode (0u),
    _e8EncodingType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_Encoding__DAB_ENCODING_MPEG1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_ServiceInfo::T_DAB_ServiceInfo (const T_DAB_ServiceInfo &rhs)  :
    _u32ServId (0u),
    _ServiceLabel (),
    _e8ServiceType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType__DAB_SERVICETYPE_UNKNOWN),
    _u8NumberOfAudioComponents (0u),
    _u8NumberOfDataComponents (0u),
    _b16AvailableAnnoTypesMask (),
    _u8SampleRate (0u),
    _u16BitRate (0u),
    _sAudioMode (),
    _sAdvancedAudioCodec (),
    _sAudioCodec (),
    _b8Flags (),
    _u8PresetListElementID (0u),
    _u16ServiceIndex (0u),
    _u8PTYCode (0u),
    _e8EncodingType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_Encoding__DAB_ENCODING_MPEG1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_ServiceInfo::T_DAB_ServiceInfo (uint32 u32ServId_, const T_DAB_Label& ServiceLabel_, T_e8_DAB_ServiceType e8ServiceType_, uint8 u8NumberOfAudioComponents_, uint8 u8NumberOfDataComponents_, const T_b16_DAB_AnnouncementType& b16AvailableAnnoTypesMask_, uint8 u8SampleRate_, uint16 u16BitRate_, const ::std::string& sAudioMode_, const ::std::string& sAdvancedAudioCodec_, const ::std::string& sAudioCodec_, const T_b8_DAB_ServiceInfoFlags& b8Flags_, uint8 u8PresetListElementID_, uint16 u16ServiceIndex_, uint8 u8PTYCode_, T_e8_DAB_Encoding e8EncodingType_)  :
    _u32ServId (u32ServId_),
    _ServiceLabel (ServiceLabel_),
    _e8ServiceType (e8ServiceType_),
    _u8NumberOfAudioComponents (u8NumberOfAudioComponents_),
    _u8NumberOfDataComponents (u8NumberOfDataComponents_),
    _b16AvailableAnnoTypesMask (b16AvailableAnnoTypesMask_),
    _u8SampleRate (u8SampleRate_),
    _u16BitRate (u16BitRate_),
    _sAudioMode (sAudioMode_),
    _sAdvancedAudioCodec (sAdvancedAudioCodec_),
    _sAudioCodec (sAudioCodec_),
    _b8Flags (b8Flags_),
    _u8PresetListElementID (u8PresetListElementID_),
    _u16ServiceIndex (u16ServiceIndex_),
    _u8PTYCode (u8PTYCode_),
    _e8EncodingType (e8EncodingType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ServiceType_IsValid(e8ServiceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ServiceType_, "T_e8_DAB_ServiceType", "e8ServiceType", "T_DAB_ServiceInfo");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAudioMode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAdvancedAudioCodec_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAudioCodec_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_Encoding_IsValid(e8EncodingType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8EncodingType_, "T_e8_DAB_Encoding", "e8EncodingType", "T_DAB_ServiceInfo");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_ServiceInfo::~T_DAB_ServiceInfo() {
}

inline T_DAB_ServiceInfo& T_DAB_ServiceInfo::operator = (const T_DAB_ServiceInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32ServId()) {
            setU32ServId(rhs.getU32ServId());
        } else {
            clearU32ServId();
        }
        if (rhs.hasServiceLabel()) {
            setServiceLabel(rhs.getServiceLabel());
        } else {
            clearServiceLabel();
        }
        if (rhs.hasE8ServiceType()) {
            setE8ServiceType(rhs.getE8ServiceType());
        } else {
            clearE8ServiceType();
        }
        if (rhs.hasU8NumberOfAudioComponents()) {
            setU8NumberOfAudioComponents(rhs.getU8NumberOfAudioComponents());
        } else {
            clearU8NumberOfAudioComponents();
        }
        if (rhs.hasU8NumberOfDataComponents()) {
            setU8NumberOfDataComponents(rhs.getU8NumberOfDataComponents());
        } else {
            clearU8NumberOfDataComponents();
        }
        if (rhs.hasB16AvailableAnnoTypesMask()) {
            setB16AvailableAnnoTypesMask(rhs.getB16AvailableAnnoTypesMask());
        } else {
            clearB16AvailableAnnoTypesMask();
        }
        if (rhs.hasU8SampleRate()) {
            setU8SampleRate(rhs.getU8SampleRate());
        } else {
            clearU8SampleRate();
        }
        if (rhs.hasU16BitRate()) {
            setU16BitRate(rhs.getU16BitRate());
        } else {
            clearU16BitRate();
        }
        if (rhs.hasSAudioMode()) {
            setSAudioMode(rhs.getSAudioMode());
        } else {
            clearSAudioMode();
        }
        if (rhs.hasSAdvancedAudioCodec()) {
            setSAdvancedAudioCodec(rhs.getSAdvancedAudioCodec());
        } else {
            clearSAdvancedAudioCodec();
        }
        if (rhs.hasSAudioCodec()) {
            setSAudioCodec(rhs.getSAudioCodec());
        } else {
            clearSAudioCodec();
        }
        if (rhs.hasB8Flags()) {
            setB8Flags(rhs.getB8Flags());
        } else {
            clearB8Flags();
        }
        if (rhs.hasU8PresetListElementID()) {
            setU8PresetListElementID(rhs.getU8PresetListElementID());
        } else {
            clearU8PresetListElementID();
        }
        if (rhs.hasU16ServiceIndex()) {
            setU16ServiceIndex(rhs.getU16ServiceIndex());
        } else {
            clearU16ServiceIndex();
        }
        if (rhs.hasU8PTYCode()) {
            setU8PTYCode(rhs.getU8PTYCode());
        } else {
            clearU8PTYCode();
        }
        if (rhs.hasE8EncodingType()) {
            setE8EncodingType(rhs.getE8EncodingType());
        } else {
            clearE8EncodingType();
        }
    }
    return *this;
}

inline bool T_DAB_ServiceInfo::operator == (const T_DAB_ServiceInfo& rhs) const {
    return (((!hasU32ServId() && !rhs.hasU32ServId()) || getU32ServId() == rhs.getU32ServId()) &&
        ((!hasServiceLabel() && !rhs.hasServiceLabel()) || getServiceLabel() == rhs.getServiceLabel()) &&
        ((!hasE8ServiceType() && !rhs.hasE8ServiceType()) || getE8ServiceType() == rhs.getE8ServiceType()) &&
        ((!hasU8NumberOfAudioComponents() && !rhs.hasU8NumberOfAudioComponents()) || getU8NumberOfAudioComponents() == rhs.getU8NumberOfAudioComponents()) &&
        ((!hasU8NumberOfDataComponents() && !rhs.hasU8NumberOfDataComponents()) || getU8NumberOfDataComponents() == rhs.getU8NumberOfDataComponents()) &&
        ((!hasB16AvailableAnnoTypesMask() && !rhs.hasB16AvailableAnnoTypesMask()) || getB16AvailableAnnoTypesMask() == rhs.getB16AvailableAnnoTypesMask()) &&
        ((!hasU8SampleRate() && !rhs.hasU8SampleRate()) || getU8SampleRate() == rhs.getU8SampleRate()) &&
        ((!hasU16BitRate() && !rhs.hasU16BitRate()) || getU16BitRate() == rhs.getU16BitRate()) &&
        ((!hasSAudioMode() && !rhs.hasSAudioMode()) || getSAudioMode() == rhs.getSAudioMode()) &&
        ((!hasSAdvancedAudioCodec() && !rhs.hasSAdvancedAudioCodec()) || getSAdvancedAudioCodec() == rhs.getSAdvancedAudioCodec()) &&
        ((!hasSAudioCodec() && !rhs.hasSAudioCodec()) || getSAudioCodec() == rhs.getSAudioCodec()) &&
        ((!hasB8Flags() && !rhs.hasB8Flags()) || getB8Flags() == rhs.getB8Flags()) &&
        ((!hasU8PresetListElementID() && !rhs.hasU8PresetListElementID()) || getU8PresetListElementID() == rhs.getU8PresetListElementID()) &&
        ((!hasU16ServiceIndex() && !rhs.hasU16ServiceIndex()) || getU16ServiceIndex() == rhs.getU16ServiceIndex()) &&
        ((!hasU8PTYCode() && !rhs.hasU8PTYCode()) || getU8PTYCode() == rhs.getU8PTYCode()) &&
        ((!hasE8EncodingType() && !rhs.hasE8EncodingType()) || getE8EncodingType() == rhs.getE8EncodingType()));
}

inline bool T_DAB_ServiceInfo::operator != (const T_DAB_ServiceInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_ServiceInfo::operator < (const T_DAB_ServiceInfo& rhs) const {
    if (hasU32ServId() || rhs.hasU32ServId()) {
        if (getU32ServId() < rhs.getU32ServId()) return true;
        if (getU32ServId() > rhs.getU32ServId()) return false;
    }
    if (hasServiceLabel() || rhs.hasServiceLabel()) {
        if (getServiceLabel() < rhs.getServiceLabel()) return true;
        if (getServiceLabel() > rhs.getServiceLabel()) return false;
    }
    if (hasE8ServiceType() || rhs.hasE8ServiceType()) {
        if ((uint32)getE8ServiceType() < (uint32)rhs.getE8ServiceType()) return true;
        if ((uint32)getE8ServiceType() > (uint32)rhs.getE8ServiceType()) return false;
    }
    if (hasU8NumberOfAudioComponents() || rhs.hasU8NumberOfAudioComponents()) {
        if (getU8NumberOfAudioComponents() < rhs.getU8NumberOfAudioComponents()) return true;
        if (getU8NumberOfAudioComponents() > rhs.getU8NumberOfAudioComponents()) return false;
    }
    if (hasU8NumberOfDataComponents() || rhs.hasU8NumberOfDataComponents()) {
        if (getU8NumberOfDataComponents() < rhs.getU8NumberOfDataComponents()) return true;
        if (getU8NumberOfDataComponents() > rhs.getU8NumberOfDataComponents()) return false;
    }
    if (hasB16AvailableAnnoTypesMask() || rhs.hasB16AvailableAnnoTypesMask()) {
        if (getB16AvailableAnnoTypesMask() < rhs.getB16AvailableAnnoTypesMask()) return true;
        if (getB16AvailableAnnoTypesMask() > rhs.getB16AvailableAnnoTypesMask()) return false;
    }
    if (hasU8SampleRate() || rhs.hasU8SampleRate()) {
        if (getU8SampleRate() < rhs.getU8SampleRate()) return true;
        if (getU8SampleRate() > rhs.getU8SampleRate()) return false;
    }
    if (hasU16BitRate() || rhs.hasU16BitRate()) {
        if (getU16BitRate() < rhs.getU16BitRate()) return true;
        if (getU16BitRate() > rhs.getU16BitRate()) return false;
    }
    if (hasSAudioMode() || rhs.hasSAudioMode()) {
        if (getSAudioMode() < rhs.getSAudioMode()) return true;
        if (getSAudioMode() > rhs.getSAudioMode()) return false;
    }
    if (hasSAdvancedAudioCodec() || rhs.hasSAdvancedAudioCodec()) {
        if (getSAdvancedAudioCodec() < rhs.getSAdvancedAudioCodec()) return true;
        if (getSAdvancedAudioCodec() > rhs.getSAdvancedAudioCodec()) return false;
    }
    if (hasSAudioCodec() || rhs.hasSAudioCodec()) {
        if (getSAudioCodec() < rhs.getSAudioCodec()) return true;
        if (getSAudioCodec() > rhs.getSAudioCodec()) return false;
    }
    if (hasB8Flags() || rhs.hasB8Flags()) {
        if (getB8Flags() < rhs.getB8Flags()) return true;
        if (getB8Flags() > rhs.getB8Flags()) return false;
    }
    if (hasU8PresetListElementID() || rhs.hasU8PresetListElementID()) {
        if (getU8PresetListElementID() < rhs.getU8PresetListElementID()) return true;
        if (getU8PresetListElementID() > rhs.getU8PresetListElementID()) return false;
    }
    if (hasU16ServiceIndex() || rhs.hasU16ServiceIndex()) {
        if (getU16ServiceIndex() < rhs.getU16ServiceIndex()) return true;
        if (getU16ServiceIndex() > rhs.getU16ServiceIndex()) return false;
    }
    if (hasU8PTYCode() || rhs.hasU8PTYCode()) {
        if (getU8PTYCode() < rhs.getU8PTYCode()) return true;
        if (getU8PTYCode() > rhs.getU8PTYCode()) return false;
    }
    if (hasE8EncodingType() || rhs.hasE8EncodingType()) {
        if ((uint32)getE8EncodingType() < (uint32)rhs.getE8EncodingType()) return true;
        if ((uint32)getE8EncodingType() > (uint32)rhs.getE8EncodingType()) return false;
    }
    return false;
}

inline bool T_DAB_ServiceInfo::operator > (const T_DAB_ServiceInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_ServiceInfo::clear() {
    clearU32ServId();
    clearServiceLabel();
    clearE8ServiceType();
    clearU8NumberOfAudioComponents();
    clearU8NumberOfDataComponents();
    clearB16AvailableAnnoTypesMask();
    clearU8SampleRate();
    clearU16BitRate();
    clearSAudioMode();
    clearSAdvancedAudioCodec();
    clearSAudioCodec();
    clearB8Flags();
    clearU8PresetListElementID();
    clearU16ServiceIndex();
    clearU8PTYCode();
    clearE8EncodingType();
}

inline void T_DAB_ServiceInfo::clearU32ServId() {
    if (hasU32ServId()) {
         clear_has_u32ServId();
        _u32ServId = 0u;
     }
}

inline bool T_DAB_ServiceInfo::hasU32ServId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_ServiceInfo::getU32ServId () const {
    return _u32ServId;
}

inline void T_DAB_ServiceInfo::setU32ServId (uint32 u32ServId_) {
    set_has_u32ServId();
    this->_u32ServId = u32ServId_;
}

inline void T_DAB_ServiceInfo::clearServiceLabel() {
    if (hasServiceLabel()) {
         clear_has_ServiceLabel();
        _ServiceLabel.clear();
     }
}

inline bool T_DAB_ServiceInfo::hasServiceLabel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_DAB_Label& T_DAB_ServiceInfo::getServiceLabel () const {
    return _ServiceLabel;
}

inline T_DAB_Label& T_DAB_ServiceInfo::getServiceLabelMutable () {
    set_has_ServiceLabel();
    return _ServiceLabel;
}

inline void T_DAB_ServiceInfo::setServiceLabel (const T_DAB_Label& ServiceLabel_) {
    set_has_ServiceLabel();
    this->_ServiceLabel = ServiceLabel_;
}

inline void T_DAB_ServiceInfo::clearE8ServiceType() {
    if (hasE8ServiceType()) {
         clear_has_e8ServiceType();
        _e8ServiceType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType__DAB_SERVICETYPE_UNKNOWN;
     }
}

inline bool T_DAB_ServiceInfo::hasE8ServiceType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_DAB_ServiceType T_DAB_ServiceInfo::getE8ServiceType () const {
    return _e8ServiceType;
}

inline void T_DAB_ServiceInfo::setE8ServiceType (T_e8_DAB_ServiceType e8ServiceType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ServiceType_IsValid(e8ServiceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ServiceType_, "T_e8_DAB_ServiceType", "e8ServiceType", "T_DAB_ServiceInfo");
    }
    set_has_e8ServiceType();
    this->_e8ServiceType = e8ServiceType_;
}

inline void T_DAB_ServiceInfo::clearU8NumberOfAudioComponents() {
    if (hasU8NumberOfAudioComponents()) {
         clear_has_u8NumberOfAudioComponents();
        _u8NumberOfAudioComponents = 0u;
     }
}

inline bool T_DAB_ServiceInfo::hasU8NumberOfAudioComponents () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_DAB_ServiceInfo::getU8NumberOfAudioComponents () const {
    return _u8NumberOfAudioComponents;
}

inline void T_DAB_ServiceInfo::setU8NumberOfAudioComponents (uint8 u8NumberOfAudioComponents_) {
    set_has_u8NumberOfAudioComponents();
    this->_u8NumberOfAudioComponents = u8NumberOfAudioComponents_;
}

inline void T_DAB_ServiceInfo::clearU8NumberOfDataComponents() {
    if (hasU8NumberOfDataComponents()) {
         clear_has_u8NumberOfDataComponents();
        _u8NumberOfDataComponents = 0u;
     }
}

inline bool T_DAB_ServiceInfo::hasU8NumberOfDataComponents () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_ServiceInfo::getU8NumberOfDataComponents () const {
    return _u8NumberOfDataComponents;
}

inline void T_DAB_ServiceInfo::setU8NumberOfDataComponents (uint8 u8NumberOfDataComponents_) {
    set_has_u8NumberOfDataComponents();
    this->_u8NumberOfDataComponents = u8NumberOfDataComponents_;
}

inline void T_DAB_ServiceInfo::clearB16AvailableAnnoTypesMask() {
    if (hasB16AvailableAnnoTypesMask()) {
         clear_has_b16AvailableAnnoTypesMask();
        _b16AvailableAnnoTypesMask = T_b16_DAB_AnnouncementType ();
     }
}

inline bool T_DAB_ServiceInfo::hasB16AvailableAnnoTypesMask () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_b16_DAB_AnnouncementType& T_DAB_ServiceInfo::getB16AvailableAnnoTypesMask () const {
    return _b16AvailableAnnoTypesMask;
}

inline T_b16_DAB_AnnouncementType& T_DAB_ServiceInfo::getB16AvailableAnnoTypesMaskMutable () {
    set_has_b16AvailableAnnoTypesMask();
    return _b16AvailableAnnoTypesMask;
}

inline void T_DAB_ServiceInfo::setB16AvailableAnnoTypesMask (const T_b16_DAB_AnnouncementType& b16AvailableAnnoTypesMask_) {
    set_has_b16AvailableAnnoTypesMask();
    this->_b16AvailableAnnoTypesMask = b16AvailableAnnoTypesMask_;
}

inline void T_DAB_ServiceInfo::clearU8SampleRate() {
    if (hasU8SampleRate()) {
         clear_has_u8SampleRate();
        _u8SampleRate = 0u;
     }
}

inline bool T_DAB_ServiceInfo::hasU8SampleRate () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_DAB_ServiceInfo::getU8SampleRate () const {
    return _u8SampleRate;
}

inline void T_DAB_ServiceInfo::setU8SampleRate (uint8 u8SampleRate_) {
    set_has_u8SampleRate();
    this->_u8SampleRate = u8SampleRate_;
}

inline void T_DAB_ServiceInfo::clearU16BitRate() {
    if (hasU16BitRate()) {
         clear_has_u16BitRate();
        _u16BitRate = 0u;
     }
}

inline bool T_DAB_ServiceInfo::hasU16BitRate () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint16 T_DAB_ServiceInfo::getU16BitRate () const {
    return _u16BitRate;
}

inline void T_DAB_ServiceInfo::setU16BitRate (uint16 u16BitRate_) {
    set_has_u16BitRate();
    this->_u16BitRate = u16BitRate_;
}

inline void T_DAB_ServiceInfo::clearSAudioMode() {
    if (hasSAudioMode()) {
         clear_has_sAudioMode();
        _sAudioMode.clear();
     }
}

inline bool T_DAB_ServiceInfo::hasSAudioMode () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_DAB_ServiceInfo::getSAudioMode () const {
    return _sAudioMode;
}

inline ::std::string& T_DAB_ServiceInfo::getSAudioModeMutable () {
    set_has_sAudioMode();
    return _sAudioMode;
}

inline void T_DAB_ServiceInfo::setSAudioMode (const ::std::string& sAudioMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAudioMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAudioMode();
    this->_sAudioMode = sAudioMode_;
}

inline void T_DAB_ServiceInfo::setSAudioMode (const char* sAudioMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAudioMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAudioMode();
    this->_sAudioMode.assign(sAudioMode_);
}

inline void T_DAB_ServiceInfo::setSAudioMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAudioMode();
    this->_sAudioMode.assign(value, size);
}

inline void T_DAB_ServiceInfo::clearSAdvancedAudioCodec() {
    if (hasSAdvancedAudioCodec()) {
         clear_has_sAdvancedAudioCodec();
        _sAdvancedAudioCodec.clear();
     }
}

inline bool T_DAB_ServiceInfo::hasSAdvancedAudioCodec () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_DAB_ServiceInfo::getSAdvancedAudioCodec () const {
    return _sAdvancedAudioCodec;
}

inline ::std::string& T_DAB_ServiceInfo::getSAdvancedAudioCodecMutable () {
    set_has_sAdvancedAudioCodec();
    return _sAdvancedAudioCodec;
}

inline void T_DAB_ServiceInfo::setSAdvancedAudioCodec (const ::std::string& sAdvancedAudioCodec_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAdvancedAudioCodec_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAdvancedAudioCodec();
    this->_sAdvancedAudioCodec = sAdvancedAudioCodec_;
}

inline void T_DAB_ServiceInfo::setSAdvancedAudioCodec (const char* sAdvancedAudioCodec_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAdvancedAudioCodec_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAdvancedAudioCodec();
    this->_sAdvancedAudioCodec.assign(sAdvancedAudioCodec_);
}

inline void T_DAB_ServiceInfo::setSAdvancedAudioCodec (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAdvancedAudioCodec();
    this->_sAdvancedAudioCodec.assign(value, size);
}

inline void T_DAB_ServiceInfo::clearSAudioCodec() {
    if (hasSAudioCodec()) {
         clear_has_sAudioCodec();
        _sAudioCodec.clear();
     }
}

inline bool T_DAB_ServiceInfo::hasSAudioCodec () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_DAB_ServiceInfo::getSAudioCodec () const {
    return _sAudioCodec;
}

inline ::std::string& T_DAB_ServiceInfo::getSAudioCodecMutable () {
    set_has_sAudioCodec();
    return _sAudioCodec;
}

inline void T_DAB_ServiceInfo::setSAudioCodec (const ::std::string& sAudioCodec_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAudioCodec_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAudioCodec();
    this->_sAudioCodec = sAudioCodec_;
}

inline void T_DAB_ServiceInfo::setSAudioCodec (const char* sAudioCodec_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAudioCodec_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAudioCodec();
    this->_sAudioCodec.assign(sAudioCodec_);
}

inline void T_DAB_ServiceInfo::setSAudioCodec (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAudioCodec();
    this->_sAudioCodec.assign(value, size);
}

inline void T_DAB_ServiceInfo::clearB8Flags() {
    if (hasB8Flags()) {
         clear_has_b8Flags();
        _b8Flags = T_b8_DAB_ServiceInfoFlags ();
     }
}

inline bool T_DAB_ServiceInfo::hasB8Flags () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const T_b8_DAB_ServiceInfoFlags& T_DAB_ServiceInfo::getB8Flags () const {
    return _b8Flags;
}

inline T_b8_DAB_ServiceInfoFlags& T_DAB_ServiceInfo::getB8FlagsMutable () {
    set_has_b8Flags();
    return _b8Flags;
}

inline void T_DAB_ServiceInfo::setB8Flags (const T_b8_DAB_ServiceInfoFlags& b8Flags_) {
    set_has_b8Flags();
    this->_b8Flags = b8Flags_;
}

inline void T_DAB_ServiceInfo::clearU8PresetListElementID() {
    if (hasU8PresetListElementID()) {
         clear_has_u8PresetListElementID();
        _u8PresetListElementID = 0u;
     }
}

inline bool T_DAB_ServiceInfo::hasU8PresetListElementID () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint8 T_DAB_ServiceInfo::getU8PresetListElementID () const {
    return _u8PresetListElementID;
}

inline void T_DAB_ServiceInfo::setU8PresetListElementID (uint8 u8PresetListElementID_) {
    set_has_u8PresetListElementID();
    this->_u8PresetListElementID = u8PresetListElementID_;
}

inline void T_DAB_ServiceInfo::clearU16ServiceIndex() {
    if (hasU16ServiceIndex()) {
         clear_has_u16ServiceIndex();
        _u16ServiceIndex = 0u;
     }
}

inline bool T_DAB_ServiceInfo::hasU16ServiceIndex () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint16 T_DAB_ServiceInfo::getU16ServiceIndex () const {
    return _u16ServiceIndex;
}

inline void T_DAB_ServiceInfo::setU16ServiceIndex (uint16 u16ServiceIndex_) {
    set_has_u16ServiceIndex();
    this->_u16ServiceIndex = u16ServiceIndex_;
}

inline void T_DAB_ServiceInfo::clearU8PTYCode() {
    if (hasU8PTYCode()) {
         clear_has_u8PTYCode();
        _u8PTYCode = 0u;
     }
}

inline bool T_DAB_ServiceInfo::hasU8PTYCode () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint8 T_DAB_ServiceInfo::getU8PTYCode () const {
    return _u8PTYCode;
}

inline void T_DAB_ServiceInfo::setU8PTYCode (uint8 u8PTYCode_) {
    set_has_u8PTYCode();
    this->_u8PTYCode = u8PTYCode_;
}

inline void T_DAB_ServiceInfo::clearE8EncodingType() {
    if (hasE8EncodingType()) {
         clear_has_e8EncodingType();
        _e8EncodingType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_Encoding__DAB_ENCODING_MPEG1;
     }
}

inline bool T_DAB_ServiceInfo::hasE8EncodingType () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline T_e8_DAB_Encoding T_DAB_ServiceInfo::getE8EncodingType () const {
    return _e8EncodingType;
}

inline void T_DAB_ServiceInfo::setE8EncodingType (T_e8_DAB_Encoding e8EncodingType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_Encoding_IsValid(e8EncodingType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8EncodingType_, "T_e8_DAB_Encoding", "e8EncodingType", "T_DAB_ServiceInfo");
    }
    set_has_e8EncodingType();
    this->_e8EncodingType = e8EncodingType_;
}

inline void T_DAB_ServiceInfo::set_has_u32ServId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_ServiceInfo::clear_has_u32ServId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_ServiceInfo::set_has_ServiceLabel () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_ServiceInfo::clear_has_ServiceLabel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_ServiceInfo::set_has_e8ServiceType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_ServiceInfo::clear_has_e8ServiceType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_ServiceInfo::set_has_u8NumberOfAudioComponents () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_ServiceInfo::clear_has_u8NumberOfAudioComponents () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_ServiceInfo::set_has_u8NumberOfDataComponents () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_ServiceInfo::clear_has_u8NumberOfDataComponents () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_ServiceInfo::set_has_b16AvailableAnnoTypesMask () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_ServiceInfo::clear_has_b16AvailableAnnoTypesMask () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_ServiceInfo::set_has_u8SampleRate () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_ServiceInfo::clear_has_u8SampleRate () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_ServiceInfo::set_has_u16BitRate () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_ServiceInfo::clear_has_u16BitRate () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_ServiceInfo::set_has_sAudioMode () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_ServiceInfo::clear_has_sAudioMode () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DAB_ServiceInfo::set_has_sAdvancedAudioCodec () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DAB_ServiceInfo::clear_has_sAdvancedAudioCodec () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DAB_ServiceInfo::set_has_sAudioCodec () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DAB_ServiceInfo::clear_has_sAudioCodec () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DAB_ServiceInfo::set_has_b8Flags () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DAB_ServiceInfo::clear_has_b8Flags () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_DAB_ServiceInfo::set_has_u8PresetListElementID () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_DAB_ServiceInfo::clear_has_u8PresetListElementID () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_DAB_ServiceInfo::set_has_u16ServiceIndex () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_DAB_ServiceInfo::clear_has_u16ServiceIndex () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_DAB_ServiceInfo::set_has_u8PTYCode () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_DAB_ServiceInfo::clear_has_u8PTYCode () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_DAB_ServiceInfo::set_has_e8EncodingType () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_DAB_ServiceInfo::clear_has_e8EncodingType () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline  T_DAB_ChannelInfo::T_DAB_ChannelInfo ()  :
    _u32ServId (0u),
    _enState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ChannelInfoState__DAB_STABLE),
    _ServiceLabel (),
    _u8NumberOfAudioComponents (0u),
    _b16AvailableAnnoTypesMask (),
    _u8PresetListElementID (0u),
    _bComponentMode (false),
    _bFmServiceFollowActive (false),
    _u16FrozenListElementID (0u),
    _rRadioText (),
    _u8NumberOfDLPElements (0u),
    _DLPlusList (),
    _bMuted (false),
    _bAFAvailable (false),
    _sLogoLink (),
    _u8ScidsValue (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_ChannelInfo::T_DAB_ChannelInfo (const T_DAB_ChannelInfo &rhs)  :
    _u32ServId (0u),
    _enState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ChannelInfoState__DAB_STABLE),
    _ServiceLabel (),
    _u8NumberOfAudioComponents (0u),
    _b16AvailableAnnoTypesMask (),
    _u8PresetListElementID (0u),
    _bComponentMode (false),
    _bFmServiceFollowActive (false),
    _u16FrozenListElementID (0u),
    _rRadioText (),
    _u8NumberOfDLPElements (0u),
    _DLPlusList (),
    _bMuted (false),
    _bAFAvailable (false),
    _sLogoLink (),
    _u8ScidsValue (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_ChannelInfo::T_DAB_ChannelInfo (uint32 u32ServId_, T_e8_DAB_ChannelInfoState enState_, const T_DAB_Label& ServiceLabel_, uint8 u8NumberOfAudioComponents_, const T_b16_DAB_AnnouncementType& b16AvailableAnnoTypesMask_, uint8 u8PresetListElementID_, bool bComponentMode_, bool bFmServiceFollowActive_, uint16 u16FrozenListElementID_, const T_DAB_RadioText& rRadioText_, uint8 u8NumberOfDLPElements_, const ::std::vector< T_DAB_RadioTextPlus >& DLPlusList_, bool bMuted_, bool bAFAvailable_, const ::std::string& sLogoLink_, uint8 u8ScidsValue_)  :
    _u32ServId (u32ServId_),
    _enState (enState_),
    _ServiceLabel (ServiceLabel_),
    _u8NumberOfAudioComponents (u8NumberOfAudioComponents_),
    _b16AvailableAnnoTypesMask (b16AvailableAnnoTypesMask_),
    _u8PresetListElementID (u8PresetListElementID_),
    _bComponentMode (bComponentMode_),
    _bFmServiceFollowActive (bFmServiceFollowActive_),
    _u16FrozenListElementID (u16FrozenListElementID_),
    _rRadioText (rRadioText_),
    _u8NumberOfDLPElements (u8NumberOfDLPElements_),
    _DLPlusList (DLPlusList_),
    _bMuted (bMuted_),
    _bAFAvailable (bAFAvailable_),
    _sLogoLink (sLogoLink_),
    _u8ScidsValue (u8ScidsValue_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ChannelInfoState_IsValid(enState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enState_, "T_e8_DAB_ChannelInfoState", "enState", "T_DAB_ChannelInfo");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_ChannelInfo::~T_DAB_ChannelInfo() {
}

inline T_DAB_ChannelInfo& T_DAB_ChannelInfo::operator = (const T_DAB_ChannelInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32ServId()) {
            setU32ServId(rhs.getU32ServId());
        } else {
            clearU32ServId();
        }
        if (rhs.hasEnState()) {
            setEnState(rhs.getEnState());
        } else {
            clearEnState();
        }
        if (rhs.hasServiceLabel()) {
            setServiceLabel(rhs.getServiceLabel());
        } else {
            clearServiceLabel();
        }
        if (rhs.hasU8NumberOfAudioComponents()) {
            setU8NumberOfAudioComponents(rhs.getU8NumberOfAudioComponents());
        } else {
            clearU8NumberOfAudioComponents();
        }
        if (rhs.hasB16AvailableAnnoTypesMask()) {
            setB16AvailableAnnoTypesMask(rhs.getB16AvailableAnnoTypesMask());
        } else {
            clearB16AvailableAnnoTypesMask();
        }
        if (rhs.hasU8PresetListElementID()) {
            setU8PresetListElementID(rhs.getU8PresetListElementID());
        } else {
            clearU8PresetListElementID();
        }
        if (rhs.hasBComponentMode()) {
            setBComponentMode(rhs.getBComponentMode());
        } else {
            clearBComponentMode();
        }
        if (rhs.hasBFmServiceFollowActive()) {
            setBFmServiceFollowActive(rhs.getBFmServiceFollowActive());
        } else {
            clearBFmServiceFollowActive();
        }
        if (rhs.hasU16FrozenListElementID()) {
            setU16FrozenListElementID(rhs.getU16FrozenListElementID());
        } else {
            clearU16FrozenListElementID();
        }
        if (rhs.hasRRadioText()) {
            setRRadioText(rhs.getRRadioText());
        } else {
            clearRRadioText();
        }
        if (rhs.hasU8NumberOfDLPElements()) {
            setU8NumberOfDLPElements(rhs.getU8NumberOfDLPElements());
        } else {
            clearU8NumberOfDLPElements();
        }
        if (rhs.hasDLPlusList()) {
            setDLPlusList(rhs.getDLPlusList());
        } else {
            clearDLPlusList();
        }
        if (rhs.hasBMuted()) {
            setBMuted(rhs.getBMuted());
        } else {
            clearBMuted();
        }
        if (rhs.hasBAFAvailable()) {
            setBAFAvailable(rhs.getBAFAvailable());
        } else {
            clearBAFAvailable();
        }
        if (rhs.hasSLogoLink()) {
            setSLogoLink(rhs.getSLogoLink());
        } else {
            clearSLogoLink();
        }
        if (rhs.hasU8ScidsValue()) {
            setU8ScidsValue(rhs.getU8ScidsValue());
        } else {
            clearU8ScidsValue();
        }
    }
    return *this;
}

inline bool T_DAB_ChannelInfo::operator == (const T_DAB_ChannelInfo& rhs) const {
    return (((!hasU32ServId() && !rhs.hasU32ServId()) || getU32ServId() == rhs.getU32ServId()) &&
        ((!hasEnState() && !rhs.hasEnState()) || getEnState() == rhs.getEnState()) &&
        ((!hasServiceLabel() && !rhs.hasServiceLabel()) || getServiceLabel() == rhs.getServiceLabel()) &&
        ((!hasU8NumberOfAudioComponents() && !rhs.hasU8NumberOfAudioComponents()) || getU8NumberOfAudioComponents() == rhs.getU8NumberOfAudioComponents()) &&
        ((!hasB16AvailableAnnoTypesMask() && !rhs.hasB16AvailableAnnoTypesMask()) || getB16AvailableAnnoTypesMask() == rhs.getB16AvailableAnnoTypesMask()) &&
        ((!hasU8PresetListElementID() && !rhs.hasU8PresetListElementID()) || getU8PresetListElementID() == rhs.getU8PresetListElementID()) &&
        ((!hasBComponentMode() && !rhs.hasBComponentMode()) || getBComponentMode() == rhs.getBComponentMode()) &&
        ((!hasBFmServiceFollowActive() && !rhs.hasBFmServiceFollowActive()) || getBFmServiceFollowActive() == rhs.getBFmServiceFollowActive()) &&
        ((!hasU16FrozenListElementID() && !rhs.hasU16FrozenListElementID()) || getU16FrozenListElementID() == rhs.getU16FrozenListElementID()) &&
        ((!hasRRadioText() && !rhs.hasRRadioText()) || getRRadioText() == rhs.getRRadioText()) &&
        ((!hasU8NumberOfDLPElements() && !rhs.hasU8NumberOfDLPElements()) || getU8NumberOfDLPElements() == rhs.getU8NumberOfDLPElements()) &&
        ((!hasDLPlusList() && !rhs.hasDLPlusList()) || getDLPlusList() == rhs.getDLPlusList()) &&
        ((!hasBMuted() && !rhs.hasBMuted()) || getBMuted() == rhs.getBMuted()) &&
        ((!hasBAFAvailable() && !rhs.hasBAFAvailable()) || getBAFAvailable() == rhs.getBAFAvailable()) &&
        ((!hasSLogoLink() && !rhs.hasSLogoLink()) || getSLogoLink() == rhs.getSLogoLink()) &&
        ((!hasU8ScidsValue() && !rhs.hasU8ScidsValue()) || getU8ScidsValue() == rhs.getU8ScidsValue()));
}

inline bool T_DAB_ChannelInfo::operator != (const T_DAB_ChannelInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_ChannelInfo::operator < (const T_DAB_ChannelInfo& rhs) const {
    if (hasU32ServId() || rhs.hasU32ServId()) {
        if (getU32ServId() < rhs.getU32ServId()) return true;
        if (getU32ServId() > rhs.getU32ServId()) return false;
    }
    if (hasEnState() || rhs.hasEnState()) {
        if ((uint32)getEnState() < (uint32)rhs.getEnState()) return true;
        if ((uint32)getEnState() > (uint32)rhs.getEnState()) return false;
    }
    if (hasServiceLabel() || rhs.hasServiceLabel()) {
        if (getServiceLabel() < rhs.getServiceLabel()) return true;
        if (getServiceLabel() > rhs.getServiceLabel()) return false;
    }
    if (hasU8NumberOfAudioComponents() || rhs.hasU8NumberOfAudioComponents()) {
        if (getU8NumberOfAudioComponents() < rhs.getU8NumberOfAudioComponents()) return true;
        if (getU8NumberOfAudioComponents() > rhs.getU8NumberOfAudioComponents()) return false;
    }
    if (hasB16AvailableAnnoTypesMask() || rhs.hasB16AvailableAnnoTypesMask()) {
        if (getB16AvailableAnnoTypesMask() < rhs.getB16AvailableAnnoTypesMask()) return true;
        if (getB16AvailableAnnoTypesMask() > rhs.getB16AvailableAnnoTypesMask()) return false;
    }
    if (hasU8PresetListElementID() || rhs.hasU8PresetListElementID()) {
        if (getU8PresetListElementID() < rhs.getU8PresetListElementID()) return true;
        if (getU8PresetListElementID() > rhs.getU8PresetListElementID()) return false;
    }
    if (hasBComponentMode() || rhs.hasBComponentMode()) {
        if (getBComponentMode() < rhs.getBComponentMode()) return true;
        if (getBComponentMode() > rhs.getBComponentMode()) return false;
    }
    if (hasBFmServiceFollowActive() || rhs.hasBFmServiceFollowActive()) {
        if (getBFmServiceFollowActive() < rhs.getBFmServiceFollowActive()) return true;
        if (getBFmServiceFollowActive() > rhs.getBFmServiceFollowActive()) return false;
    }
    if (hasU16FrozenListElementID() || rhs.hasU16FrozenListElementID()) {
        if (getU16FrozenListElementID() < rhs.getU16FrozenListElementID()) return true;
        if (getU16FrozenListElementID() > rhs.getU16FrozenListElementID()) return false;
    }
    if (hasRRadioText() || rhs.hasRRadioText()) {
        if (getRRadioText() < rhs.getRRadioText()) return true;
        if (getRRadioText() > rhs.getRRadioText()) return false;
    }
    if (hasU8NumberOfDLPElements() || rhs.hasU8NumberOfDLPElements()) {
        if (getU8NumberOfDLPElements() < rhs.getU8NumberOfDLPElements()) return true;
        if (getU8NumberOfDLPElements() > rhs.getU8NumberOfDLPElements()) return false;
    }
    if (hasDLPlusList() || rhs.hasDLPlusList()) {
        if (getDLPlusList() < rhs.getDLPlusList()) return true;
        if (getDLPlusList() > rhs.getDLPlusList()) return false;
    }
    if (hasBMuted() || rhs.hasBMuted()) {
        if (getBMuted() < rhs.getBMuted()) return true;
        if (getBMuted() > rhs.getBMuted()) return false;
    }
    if (hasBAFAvailable() || rhs.hasBAFAvailable()) {
        if (getBAFAvailable() < rhs.getBAFAvailable()) return true;
        if (getBAFAvailable() > rhs.getBAFAvailable()) return false;
    }
    if (hasSLogoLink() || rhs.hasSLogoLink()) {
        if (getSLogoLink() < rhs.getSLogoLink()) return true;
        if (getSLogoLink() > rhs.getSLogoLink()) return false;
    }
    if (hasU8ScidsValue() || rhs.hasU8ScidsValue()) {
        if (getU8ScidsValue() < rhs.getU8ScidsValue()) return true;
        if (getU8ScidsValue() > rhs.getU8ScidsValue()) return false;
    }
    return false;
}

inline bool T_DAB_ChannelInfo::operator > (const T_DAB_ChannelInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_ChannelInfo::clear() {
    clearU32ServId();
    clearEnState();
    clearServiceLabel();
    clearU8NumberOfAudioComponents();
    clearB16AvailableAnnoTypesMask();
    clearU8PresetListElementID();
    clearBComponentMode();
    clearBFmServiceFollowActive();
    clearU16FrozenListElementID();
    clearRRadioText();
    clearU8NumberOfDLPElements();
    clearDLPlusList();
    clearBMuted();
    clearBAFAvailable();
    clearSLogoLink();
    clearU8ScidsValue();
}

inline void T_DAB_ChannelInfo::clearU32ServId() {
    if (hasU32ServId()) {
         clear_has_u32ServId();
        _u32ServId = 0u;
     }
}

inline bool T_DAB_ChannelInfo::hasU32ServId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_ChannelInfo::getU32ServId () const {
    return _u32ServId;
}

inline void T_DAB_ChannelInfo::setU32ServId (uint32 u32ServId_) {
    set_has_u32ServId();
    this->_u32ServId = u32ServId_;
}

inline void T_DAB_ChannelInfo::clearEnState() {
    if (hasEnState()) {
         clear_has_enState();
        _enState = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ChannelInfoState__DAB_STABLE;
     }
}

inline bool T_DAB_ChannelInfo::hasEnState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_DAB_ChannelInfoState T_DAB_ChannelInfo::getEnState () const {
    return _enState;
}

inline void T_DAB_ChannelInfo::setEnState (T_e8_DAB_ChannelInfoState enState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ChannelInfoState_IsValid(enState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enState_, "T_e8_DAB_ChannelInfoState", "enState", "T_DAB_ChannelInfo");
    }
    set_has_enState();
    this->_enState = enState_;
}

inline void T_DAB_ChannelInfo::clearServiceLabel() {
    if (hasServiceLabel()) {
         clear_has_ServiceLabel();
        _ServiceLabel.clear();
     }
}

inline bool T_DAB_ChannelInfo::hasServiceLabel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_DAB_Label& T_DAB_ChannelInfo::getServiceLabel () const {
    return _ServiceLabel;
}

inline T_DAB_Label& T_DAB_ChannelInfo::getServiceLabelMutable () {
    set_has_ServiceLabel();
    return _ServiceLabel;
}

inline void T_DAB_ChannelInfo::setServiceLabel (const T_DAB_Label& ServiceLabel_) {
    set_has_ServiceLabel();
    this->_ServiceLabel = ServiceLabel_;
}

inline void T_DAB_ChannelInfo::clearU8NumberOfAudioComponents() {
    if (hasU8NumberOfAudioComponents()) {
         clear_has_u8NumberOfAudioComponents();
        _u8NumberOfAudioComponents = 0u;
     }
}

inline bool T_DAB_ChannelInfo::hasU8NumberOfAudioComponents () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_DAB_ChannelInfo::getU8NumberOfAudioComponents () const {
    return _u8NumberOfAudioComponents;
}

inline void T_DAB_ChannelInfo::setU8NumberOfAudioComponents (uint8 u8NumberOfAudioComponents_) {
    set_has_u8NumberOfAudioComponents();
    this->_u8NumberOfAudioComponents = u8NumberOfAudioComponents_;
}

inline void T_DAB_ChannelInfo::clearB16AvailableAnnoTypesMask() {
    if (hasB16AvailableAnnoTypesMask()) {
         clear_has_b16AvailableAnnoTypesMask();
        _b16AvailableAnnoTypesMask = T_b16_DAB_AnnouncementType ();
     }
}

inline bool T_DAB_ChannelInfo::hasB16AvailableAnnoTypesMask () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_b16_DAB_AnnouncementType& T_DAB_ChannelInfo::getB16AvailableAnnoTypesMask () const {
    return _b16AvailableAnnoTypesMask;
}

inline T_b16_DAB_AnnouncementType& T_DAB_ChannelInfo::getB16AvailableAnnoTypesMaskMutable () {
    set_has_b16AvailableAnnoTypesMask();
    return _b16AvailableAnnoTypesMask;
}

inline void T_DAB_ChannelInfo::setB16AvailableAnnoTypesMask (const T_b16_DAB_AnnouncementType& b16AvailableAnnoTypesMask_) {
    set_has_b16AvailableAnnoTypesMask();
    this->_b16AvailableAnnoTypesMask = b16AvailableAnnoTypesMask_;
}

inline void T_DAB_ChannelInfo::clearU8PresetListElementID() {
    if (hasU8PresetListElementID()) {
         clear_has_u8PresetListElementID();
        _u8PresetListElementID = 0u;
     }
}

inline bool T_DAB_ChannelInfo::hasU8PresetListElementID () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_DAB_ChannelInfo::getU8PresetListElementID () const {
    return _u8PresetListElementID;
}

inline void T_DAB_ChannelInfo::setU8PresetListElementID (uint8 u8PresetListElementID_) {
    set_has_u8PresetListElementID();
    this->_u8PresetListElementID = u8PresetListElementID_;
}

inline void T_DAB_ChannelInfo::clearBComponentMode() {
    if (hasBComponentMode()) {
         clear_has_bComponentMode();
        _bComponentMode = false;
     }
}

inline bool T_DAB_ChannelInfo::hasBComponentMode () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_DAB_ChannelInfo::getBComponentMode () const {
    return _bComponentMode;
}

inline void T_DAB_ChannelInfo::setBComponentMode (bool bComponentMode_) {
    set_has_bComponentMode();
    this->_bComponentMode = bComponentMode_;
}

inline void T_DAB_ChannelInfo::clearBFmServiceFollowActive() {
    if (hasBFmServiceFollowActive()) {
         clear_has_bFmServiceFollowActive();
        _bFmServiceFollowActive = false;
     }
}

inline bool T_DAB_ChannelInfo::hasBFmServiceFollowActive () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_DAB_ChannelInfo::getBFmServiceFollowActive () const {
    return _bFmServiceFollowActive;
}

inline void T_DAB_ChannelInfo::setBFmServiceFollowActive (bool bFmServiceFollowActive_) {
    set_has_bFmServiceFollowActive();
    this->_bFmServiceFollowActive = bFmServiceFollowActive_;
}

inline void T_DAB_ChannelInfo::clearU16FrozenListElementID() {
    if (hasU16FrozenListElementID()) {
         clear_has_u16FrozenListElementID();
        _u16FrozenListElementID = 0u;
     }
}

inline bool T_DAB_ChannelInfo::hasU16FrozenListElementID () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint16 T_DAB_ChannelInfo::getU16FrozenListElementID () const {
    return _u16FrozenListElementID;
}

inline void T_DAB_ChannelInfo::setU16FrozenListElementID (uint16 u16FrozenListElementID_) {
    set_has_u16FrozenListElementID();
    this->_u16FrozenListElementID = u16FrozenListElementID_;
}

inline void T_DAB_ChannelInfo::clearRRadioText() {
    if (hasRRadioText()) {
         clear_has_rRadioText();
        _rRadioText.clear();
     }
}

inline bool T_DAB_ChannelInfo::hasRRadioText () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const T_DAB_RadioText& T_DAB_ChannelInfo::getRRadioText () const {
    return _rRadioText;
}

inline T_DAB_RadioText& T_DAB_ChannelInfo::getRRadioTextMutable () {
    set_has_rRadioText();
    return _rRadioText;
}

inline void T_DAB_ChannelInfo::setRRadioText (const T_DAB_RadioText& rRadioText_) {
    set_has_rRadioText();
    this->_rRadioText = rRadioText_;
}

inline void T_DAB_ChannelInfo::clearU8NumberOfDLPElements() {
    if (hasU8NumberOfDLPElements()) {
         clear_has_u8NumberOfDLPElements();
        _u8NumberOfDLPElements = 0u;
     }
}

inline bool T_DAB_ChannelInfo::hasU8NumberOfDLPElements () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 T_DAB_ChannelInfo::getU8NumberOfDLPElements () const {
    return _u8NumberOfDLPElements;
}

inline void T_DAB_ChannelInfo::setU8NumberOfDLPElements (uint8 u8NumberOfDLPElements_) {
    set_has_u8NumberOfDLPElements();
    this->_u8NumberOfDLPElements = u8NumberOfDLPElements_;
}

inline void T_DAB_ChannelInfo::clearDLPlusList() {
    if (hasDLPlusList()) {
         clear_has_DLPlusList();
        _DLPlusList.clear();
     }
}

inline bool T_DAB_ChannelInfo::hasDLPlusList () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::vector< T_DAB_RadioTextPlus >& T_DAB_ChannelInfo::getDLPlusList () const {
    return _DLPlusList;
}

inline ::std::vector< T_DAB_RadioTextPlus >& T_DAB_ChannelInfo::getDLPlusListMutable () {
    set_has_DLPlusList();
    return _DLPlusList;
}

inline void T_DAB_ChannelInfo::setDLPlusList (const ::std::vector< T_DAB_RadioTextPlus >& DLPlusList_) {
    set_has_DLPlusList();
    this->_DLPlusList = DLPlusList_;
}

inline void T_DAB_ChannelInfo::clearBMuted() {
    if (hasBMuted()) {
         clear_has_bMuted();
        _bMuted = false;
     }
}

inline bool T_DAB_ChannelInfo::hasBMuted () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline bool T_DAB_ChannelInfo::getBMuted () const {
    return _bMuted;
}

inline void T_DAB_ChannelInfo::setBMuted (bool bMuted_) {
    set_has_bMuted();
    this->_bMuted = bMuted_;
}

inline void T_DAB_ChannelInfo::clearBAFAvailable() {
    if (hasBAFAvailable()) {
         clear_has_bAFAvailable();
        _bAFAvailable = false;
     }
}

inline bool T_DAB_ChannelInfo::hasBAFAvailable () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline bool T_DAB_ChannelInfo::getBAFAvailable () const {
    return _bAFAvailable;
}

inline void T_DAB_ChannelInfo::setBAFAvailable (bool bAFAvailable_) {
    set_has_bAFAvailable();
    this->_bAFAvailable = bAFAvailable_;
}

inline void T_DAB_ChannelInfo::clearSLogoLink() {
    if (hasSLogoLink()) {
         clear_has_sLogoLink();
        _sLogoLink.clear();
     }
}

inline bool T_DAB_ChannelInfo::hasSLogoLink () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& T_DAB_ChannelInfo::getSLogoLink () const {
    return _sLogoLink;
}

inline ::std::string& T_DAB_ChannelInfo::getSLogoLinkMutable () {
    set_has_sLogoLink();
    return _sLogoLink;
}

inline void T_DAB_ChannelInfo::setSLogoLink (const ::std::string& sLogoLink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink = sLogoLink_;
}

inline void T_DAB_ChannelInfo::setSLogoLink (const char* sLogoLink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink.assign(sLogoLink_);
}

inline void T_DAB_ChannelInfo::setSLogoLink (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink.assign(value, size);
}

inline void T_DAB_ChannelInfo::clearU8ScidsValue() {
    if (hasU8ScidsValue()) {
         clear_has_u8ScidsValue();
        _u8ScidsValue = 0u;
     }
}

inline bool T_DAB_ChannelInfo::hasU8ScidsValue () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint8 T_DAB_ChannelInfo::getU8ScidsValue () const {
    return _u8ScidsValue;
}

inline void T_DAB_ChannelInfo::setU8ScidsValue (uint8 u8ScidsValue_) {
    set_has_u8ScidsValue();
    this->_u8ScidsValue = u8ScidsValue_;
}

inline void T_DAB_ChannelInfo::set_has_u32ServId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_ChannelInfo::clear_has_u32ServId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_ChannelInfo::set_has_enState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_ChannelInfo::clear_has_enState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_ChannelInfo::set_has_ServiceLabel () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_ChannelInfo::clear_has_ServiceLabel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_ChannelInfo::set_has_u8NumberOfAudioComponents () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_ChannelInfo::clear_has_u8NumberOfAudioComponents () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_ChannelInfo::set_has_b16AvailableAnnoTypesMask () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_ChannelInfo::clear_has_b16AvailableAnnoTypesMask () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_ChannelInfo::set_has_u8PresetListElementID () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_ChannelInfo::clear_has_u8PresetListElementID () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_ChannelInfo::set_has_bComponentMode () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_ChannelInfo::clear_has_bComponentMode () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_ChannelInfo::set_has_bFmServiceFollowActive () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_ChannelInfo::clear_has_bFmServiceFollowActive () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_ChannelInfo::set_has_u16FrozenListElementID () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_ChannelInfo::clear_has_u16FrozenListElementID () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DAB_ChannelInfo::set_has_rRadioText () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DAB_ChannelInfo::clear_has_rRadioText () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DAB_ChannelInfo::set_has_u8NumberOfDLPElements () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DAB_ChannelInfo::clear_has_u8NumberOfDLPElements () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DAB_ChannelInfo::set_has_DLPlusList () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DAB_ChannelInfo::clear_has_DLPlusList () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_DAB_ChannelInfo::set_has_bMuted () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_DAB_ChannelInfo::clear_has_bMuted () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_DAB_ChannelInfo::set_has_bAFAvailable () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_DAB_ChannelInfo::clear_has_bAFAvailable () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_DAB_ChannelInfo::set_has_sLogoLink () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_DAB_ChannelInfo::clear_has_sLogoLink () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_DAB_ChannelInfo::set_has_u8ScidsValue () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_DAB_ChannelInfo::clear_has_u8ScidsValue () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline  T_DAB_ComponentInfo::T_DAB_ComponentInfo ()  :
    _u8ComponentId (0u),
    _ComponentLabel (),
    _u16SCIDI (0u),
    _u8Subchannel (0u),
    _u8SCIDS (0u),
    _e8ComponentType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ComponentType__DAB_COMPONENTTYPE_PRIMARY),
    _e8ServiceType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType__DAB_SERVICETYPE_UNKNOWN),
    _e8TMIdType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_AUDIO_STREAM),
    _u8AudioDataServiceComponentType (0u),
    _u16ComponentIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_ComponentInfo::T_DAB_ComponentInfo (const T_DAB_ComponentInfo &rhs)  :
    _u8ComponentId (0u),
    _ComponentLabel (),
    _u16SCIDI (0u),
    _u8Subchannel (0u),
    _u8SCIDS (0u),
    _e8ComponentType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ComponentType__DAB_COMPONENTTYPE_PRIMARY),
    _e8ServiceType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType__DAB_SERVICETYPE_UNKNOWN),
    _e8TMIdType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_AUDIO_STREAM),
    _u8AudioDataServiceComponentType (0u),
    _u16ComponentIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_ComponentInfo::T_DAB_ComponentInfo (uint8 u8ComponentId_, const T_DAB_Label& ComponentLabel_, uint16 u16SCIDI_, uint8 u8Subchannel_, uint8 u8SCIDS_, T_e8_DAB_ComponentType e8ComponentType_, T_e8_DAB_ServiceType e8ServiceType_, T_e8_DAB_TMIdType e8TMIdType_, uint8 u8AudioDataServiceComponentType_, uint16 u16ComponentIndex_)  :
    _u8ComponentId (u8ComponentId_),
    _ComponentLabel (ComponentLabel_),
    _u16SCIDI (u16SCIDI_),
    _u8Subchannel (u8Subchannel_),
    _u8SCIDS (u8SCIDS_),
    _e8ComponentType (e8ComponentType_),
    _e8ServiceType (e8ServiceType_),
    _e8TMIdType (e8TMIdType_),
    _u8AudioDataServiceComponentType (u8AudioDataServiceComponentType_),
    _u16ComponentIndex (u16ComponentIndex_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ComponentType_IsValid(e8ComponentType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ComponentType_, "T_e8_DAB_ComponentType", "e8ComponentType", "T_DAB_ComponentInfo");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ServiceType_IsValid(e8ServiceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ServiceType_, "T_e8_DAB_ServiceType", "e8ServiceType", "T_DAB_ComponentInfo");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_TMIdType_IsValid(e8TMIdType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TMIdType_, "T_e8_DAB_TMIdType", "e8TMIdType", "T_DAB_ComponentInfo");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_ComponentInfo::~T_DAB_ComponentInfo() {
}

inline T_DAB_ComponentInfo& T_DAB_ComponentInfo::operator = (const T_DAB_ComponentInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8ComponentId()) {
            setU8ComponentId(rhs.getU8ComponentId());
        } else {
            clearU8ComponentId();
        }
        if (rhs.hasComponentLabel()) {
            setComponentLabel(rhs.getComponentLabel());
        } else {
            clearComponentLabel();
        }
        if (rhs.hasU16SCIDI()) {
            setU16SCIDI(rhs.getU16SCIDI());
        } else {
            clearU16SCIDI();
        }
        if (rhs.hasU8Subchannel()) {
            setU8Subchannel(rhs.getU8Subchannel());
        } else {
            clearU8Subchannel();
        }
        if (rhs.hasU8SCIDS()) {
            setU8SCIDS(rhs.getU8SCIDS());
        } else {
            clearU8SCIDS();
        }
        if (rhs.hasE8ComponentType()) {
            setE8ComponentType(rhs.getE8ComponentType());
        } else {
            clearE8ComponentType();
        }
        if (rhs.hasE8ServiceType()) {
            setE8ServiceType(rhs.getE8ServiceType());
        } else {
            clearE8ServiceType();
        }
        if (rhs.hasE8TMIdType()) {
            setE8TMIdType(rhs.getE8TMIdType());
        } else {
            clearE8TMIdType();
        }
        if (rhs.hasU8AudioDataServiceComponentType()) {
            setU8AudioDataServiceComponentType(rhs.getU8AudioDataServiceComponentType());
        } else {
            clearU8AudioDataServiceComponentType();
        }
        if (rhs.hasU16ComponentIndex()) {
            setU16ComponentIndex(rhs.getU16ComponentIndex());
        } else {
            clearU16ComponentIndex();
        }
    }
    return *this;
}

inline bool T_DAB_ComponentInfo::operator == (const T_DAB_ComponentInfo& rhs) const {
    return (((!hasU8ComponentId() && !rhs.hasU8ComponentId()) || getU8ComponentId() == rhs.getU8ComponentId()) &&
        ((!hasComponentLabel() && !rhs.hasComponentLabel()) || getComponentLabel() == rhs.getComponentLabel()) &&
        ((!hasU16SCIDI() && !rhs.hasU16SCIDI()) || getU16SCIDI() == rhs.getU16SCIDI()) &&
        ((!hasU8Subchannel() && !rhs.hasU8Subchannel()) || getU8Subchannel() == rhs.getU8Subchannel()) &&
        ((!hasU8SCIDS() && !rhs.hasU8SCIDS()) || getU8SCIDS() == rhs.getU8SCIDS()) &&
        ((!hasE8ComponentType() && !rhs.hasE8ComponentType()) || getE8ComponentType() == rhs.getE8ComponentType()) &&
        ((!hasE8ServiceType() && !rhs.hasE8ServiceType()) || getE8ServiceType() == rhs.getE8ServiceType()) &&
        ((!hasE8TMIdType() && !rhs.hasE8TMIdType()) || getE8TMIdType() == rhs.getE8TMIdType()) &&
        ((!hasU8AudioDataServiceComponentType() && !rhs.hasU8AudioDataServiceComponentType()) || getU8AudioDataServiceComponentType() == rhs.getU8AudioDataServiceComponentType()) &&
        ((!hasU16ComponentIndex() && !rhs.hasU16ComponentIndex()) || getU16ComponentIndex() == rhs.getU16ComponentIndex()));
}

inline bool T_DAB_ComponentInfo::operator != (const T_DAB_ComponentInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_ComponentInfo::operator < (const T_DAB_ComponentInfo& rhs) const {
    if (hasU8ComponentId() || rhs.hasU8ComponentId()) {
        if (getU8ComponentId() < rhs.getU8ComponentId()) return true;
        if (getU8ComponentId() > rhs.getU8ComponentId()) return false;
    }
    if (hasComponentLabel() || rhs.hasComponentLabel()) {
        if (getComponentLabel() < rhs.getComponentLabel()) return true;
        if (getComponentLabel() > rhs.getComponentLabel()) return false;
    }
    if (hasU16SCIDI() || rhs.hasU16SCIDI()) {
        if (getU16SCIDI() < rhs.getU16SCIDI()) return true;
        if (getU16SCIDI() > rhs.getU16SCIDI()) return false;
    }
    if (hasU8Subchannel() || rhs.hasU8Subchannel()) {
        if (getU8Subchannel() < rhs.getU8Subchannel()) return true;
        if (getU8Subchannel() > rhs.getU8Subchannel()) return false;
    }
    if (hasU8SCIDS() || rhs.hasU8SCIDS()) {
        if (getU8SCIDS() < rhs.getU8SCIDS()) return true;
        if (getU8SCIDS() > rhs.getU8SCIDS()) return false;
    }
    if (hasE8ComponentType() || rhs.hasE8ComponentType()) {
        if ((uint32)getE8ComponentType() < (uint32)rhs.getE8ComponentType()) return true;
        if ((uint32)getE8ComponentType() > (uint32)rhs.getE8ComponentType()) return false;
    }
    if (hasE8ServiceType() || rhs.hasE8ServiceType()) {
        if ((uint32)getE8ServiceType() < (uint32)rhs.getE8ServiceType()) return true;
        if ((uint32)getE8ServiceType() > (uint32)rhs.getE8ServiceType()) return false;
    }
    if (hasE8TMIdType() || rhs.hasE8TMIdType()) {
        if ((uint32)getE8TMIdType() < (uint32)rhs.getE8TMIdType()) return true;
        if ((uint32)getE8TMIdType() > (uint32)rhs.getE8TMIdType()) return false;
    }
    if (hasU8AudioDataServiceComponentType() || rhs.hasU8AudioDataServiceComponentType()) {
        if (getU8AudioDataServiceComponentType() < rhs.getU8AudioDataServiceComponentType()) return true;
        if (getU8AudioDataServiceComponentType() > rhs.getU8AudioDataServiceComponentType()) return false;
    }
    if (hasU16ComponentIndex() || rhs.hasU16ComponentIndex()) {
        if (getU16ComponentIndex() < rhs.getU16ComponentIndex()) return true;
        if (getU16ComponentIndex() > rhs.getU16ComponentIndex()) return false;
    }
    return false;
}

inline bool T_DAB_ComponentInfo::operator > (const T_DAB_ComponentInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_ComponentInfo::clear() {
    clearU8ComponentId();
    clearComponentLabel();
    clearU16SCIDI();
    clearU8Subchannel();
    clearU8SCIDS();
    clearE8ComponentType();
    clearE8ServiceType();
    clearE8TMIdType();
    clearU8AudioDataServiceComponentType();
    clearU16ComponentIndex();
}

inline void T_DAB_ComponentInfo::clearU8ComponentId() {
    if (hasU8ComponentId()) {
         clear_has_u8ComponentId();
        _u8ComponentId = 0u;
     }
}

inline bool T_DAB_ComponentInfo::hasU8ComponentId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_DAB_ComponentInfo::getU8ComponentId () const {
    return _u8ComponentId;
}

inline void T_DAB_ComponentInfo::setU8ComponentId (uint8 u8ComponentId_) {
    set_has_u8ComponentId();
    this->_u8ComponentId = u8ComponentId_;
}

inline void T_DAB_ComponentInfo::clearComponentLabel() {
    if (hasComponentLabel()) {
         clear_has_ComponentLabel();
        _ComponentLabel.clear();
     }
}

inline bool T_DAB_ComponentInfo::hasComponentLabel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_DAB_Label& T_DAB_ComponentInfo::getComponentLabel () const {
    return _ComponentLabel;
}

inline T_DAB_Label& T_DAB_ComponentInfo::getComponentLabelMutable () {
    set_has_ComponentLabel();
    return _ComponentLabel;
}

inline void T_DAB_ComponentInfo::setComponentLabel (const T_DAB_Label& ComponentLabel_) {
    set_has_ComponentLabel();
    this->_ComponentLabel = ComponentLabel_;
}

inline void T_DAB_ComponentInfo::clearU16SCIDI() {
    if (hasU16SCIDI()) {
         clear_has_u16SCIDI();
        _u16SCIDI = 0u;
     }
}

inline bool T_DAB_ComponentInfo::hasU16SCIDI () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_DAB_ComponentInfo::getU16SCIDI () const {
    return _u16SCIDI;
}

inline void T_DAB_ComponentInfo::setU16SCIDI (uint16 u16SCIDI_) {
    set_has_u16SCIDI();
    this->_u16SCIDI = u16SCIDI_;
}

inline void T_DAB_ComponentInfo::clearU8Subchannel() {
    if (hasU8Subchannel()) {
         clear_has_u8Subchannel();
        _u8Subchannel = 0u;
     }
}

inline bool T_DAB_ComponentInfo::hasU8Subchannel () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_DAB_ComponentInfo::getU8Subchannel () const {
    return _u8Subchannel;
}

inline void T_DAB_ComponentInfo::setU8Subchannel (uint8 u8Subchannel_) {
    set_has_u8Subchannel();
    this->_u8Subchannel = u8Subchannel_;
}

inline void T_DAB_ComponentInfo::clearU8SCIDS() {
    if (hasU8SCIDS()) {
         clear_has_u8SCIDS();
        _u8SCIDS = 0u;
     }
}

inline bool T_DAB_ComponentInfo::hasU8SCIDS () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_ComponentInfo::getU8SCIDS () const {
    return _u8SCIDS;
}

inline void T_DAB_ComponentInfo::setU8SCIDS (uint8 u8SCIDS_) {
    set_has_u8SCIDS();
    this->_u8SCIDS = u8SCIDS_;
}

inline void T_DAB_ComponentInfo::clearE8ComponentType() {
    if (hasE8ComponentType()) {
         clear_has_e8ComponentType();
        _e8ComponentType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ComponentType__DAB_COMPONENTTYPE_PRIMARY;
     }
}

inline bool T_DAB_ComponentInfo::hasE8ComponentType () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_DAB_ComponentType T_DAB_ComponentInfo::getE8ComponentType () const {
    return _e8ComponentType;
}

inline void T_DAB_ComponentInfo::setE8ComponentType (T_e8_DAB_ComponentType e8ComponentType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ComponentType_IsValid(e8ComponentType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ComponentType_, "T_e8_DAB_ComponentType", "e8ComponentType", "T_DAB_ComponentInfo");
    }
    set_has_e8ComponentType();
    this->_e8ComponentType = e8ComponentType_;
}

inline void T_DAB_ComponentInfo::clearE8ServiceType() {
    if (hasE8ServiceType()) {
         clear_has_e8ServiceType();
        _e8ServiceType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType__DAB_SERVICETYPE_UNKNOWN;
     }
}

inline bool T_DAB_ComponentInfo::hasE8ServiceType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_DAB_ServiceType T_DAB_ComponentInfo::getE8ServiceType () const {
    return _e8ServiceType;
}

inline void T_DAB_ComponentInfo::setE8ServiceType (T_e8_DAB_ServiceType e8ServiceType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ServiceType_IsValid(e8ServiceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ServiceType_, "T_e8_DAB_ServiceType", "e8ServiceType", "T_DAB_ComponentInfo");
    }
    set_has_e8ServiceType();
    this->_e8ServiceType = e8ServiceType_;
}

inline void T_DAB_ComponentInfo::clearE8TMIdType() {
    if (hasE8TMIdType()) {
         clear_has_e8TMIdType();
        _e8TMIdType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_AUDIO_STREAM;
     }
}

inline bool T_DAB_ComponentInfo::hasE8TMIdType () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_DAB_TMIdType T_DAB_ComponentInfo::getE8TMIdType () const {
    return _e8TMIdType;
}

inline void T_DAB_ComponentInfo::setE8TMIdType (T_e8_DAB_TMIdType e8TMIdType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_TMIdType_IsValid(e8TMIdType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TMIdType_, "T_e8_DAB_TMIdType", "e8TMIdType", "T_DAB_ComponentInfo");
    }
    set_has_e8TMIdType();
    this->_e8TMIdType = e8TMIdType_;
}

inline void T_DAB_ComponentInfo::clearU8AudioDataServiceComponentType() {
    if (hasU8AudioDataServiceComponentType()) {
         clear_has_u8AudioDataServiceComponentType();
        _u8AudioDataServiceComponentType = 0u;
     }
}

inline bool T_DAB_ComponentInfo::hasU8AudioDataServiceComponentType () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_DAB_ComponentInfo::getU8AudioDataServiceComponentType () const {
    return _u8AudioDataServiceComponentType;
}

inline void T_DAB_ComponentInfo::setU8AudioDataServiceComponentType (uint8 u8AudioDataServiceComponentType_) {
    set_has_u8AudioDataServiceComponentType();
    this->_u8AudioDataServiceComponentType = u8AudioDataServiceComponentType_;
}

inline void T_DAB_ComponentInfo::clearU16ComponentIndex() {
    if (hasU16ComponentIndex()) {
         clear_has_u16ComponentIndex();
        _u16ComponentIndex = 0u;
     }
}

inline bool T_DAB_ComponentInfo::hasU16ComponentIndex () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint16 T_DAB_ComponentInfo::getU16ComponentIndex () const {
    return _u16ComponentIndex;
}

inline void T_DAB_ComponentInfo::setU16ComponentIndex (uint16 u16ComponentIndex_) {
    set_has_u16ComponentIndex();
    this->_u16ComponentIndex = u16ComponentIndex_;
}

inline void T_DAB_ComponentInfo::set_has_u8ComponentId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_ComponentInfo::clear_has_u8ComponentId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_ComponentInfo::set_has_ComponentLabel () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_ComponentInfo::clear_has_ComponentLabel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_ComponentInfo::set_has_u16SCIDI () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_ComponentInfo::clear_has_u16SCIDI () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_ComponentInfo::set_has_u8Subchannel () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_ComponentInfo::clear_has_u8Subchannel () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_ComponentInfo::set_has_u8SCIDS () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_ComponentInfo::clear_has_u8SCIDS () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_ComponentInfo::set_has_e8ComponentType () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_ComponentInfo::clear_has_e8ComponentType () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_ComponentInfo::set_has_e8ServiceType () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_ComponentInfo::clear_has_e8ServiceType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_ComponentInfo::set_has_e8TMIdType () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_ComponentInfo::clear_has_e8TMIdType () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_ComponentInfo::set_has_u8AudioDataServiceComponentType () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_ComponentInfo::clear_has_u8AudioDataServiceComponentType () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DAB_ComponentInfo::set_has_u16ComponentIndex () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DAB_ComponentInfo::clear_has_u16ComponentIndex () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  T_DAB_AnnoConfig::T_DAB_AnnoConfig ()  :
    _AnnoConfigTypes (),
    _bEnable (false),
    _AnnoConfigSource (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_AnnoConfig::T_DAB_AnnoConfig (const T_DAB_AnnoConfig &rhs)  :
    _AnnoConfigTypes (),
    _bEnable (false),
    _AnnoConfigSource (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_AnnoConfig::T_DAB_AnnoConfig (const T_b16_DAB_AnnouncementType& AnnoConfigTypes_, bool bEnable_, T_e8_DAB_AnnouncementSource AnnoConfigSource_)  :
    _AnnoConfigTypes (AnnoConfigTypes_),
    _bEnable (bEnable_),
    _AnnoConfigSource (AnnoConfigSource_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementSource_IsValid(AnnoConfigSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoConfigSource_, "T_e8_DAB_AnnouncementSource", "AnnoConfigSource", "T_DAB_AnnoConfig");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_AnnoConfig::~T_DAB_AnnoConfig() {
}

inline T_DAB_AnnoConfig& T_DAB_AnnoConfig::operator = (const T_DAB_AnnoConfig& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAnnoConfigTypes()) {
            setAnnoConfigTypes(rhs.getAnnoConfigTypes());
        } else {
            clearAnnoConfigTypes();
        }
        if (rhs.hasBEnable()) {
            setBEnable(rhs.getBEnable());
        } else {
            clearBEnable();
        }
        if (rhs.hasAnnoConfigSource()) {
            setAnnoConfigSource(rhs.getAnnoConfigSource());
        } else {
            clearAnnoConfigSource();
        }
    }
    return *this;
}

inline bool T_DAB_AnnoConfig::operator == (const T_DAB_AnnoConfig& rhs) const {
    return (((!hasAnnoConfigTypes() && !rhs.hasAnnoConfigTypes()) || getAnnoConfigTypes() == rhs.getAnnoConfigTypes()) &&
        ((!hasBEnable() && !rhs.hasBEnable()) || getBEnable() == rhs.getBEnable()) &&
        ((!hasAnnoConfigSource() && !rhs.hasAnnoConfigSource()) || getAnnoConfigSource() == rhs.getAnnoConfigSource()));
}

inline bool T_DAB_AnnoConfig::operator != (const T_DAB_AnnoConfig& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_AnnoConfig::operator < (const T_DAB_AnnoConfig& rhs) const {
    if (hasAnnoConfigTypes() || rhs.hasAnnoConfigTypes()) {
        if (getAnnoConfigTypes() < rhs.getAnnoConfigTypes()) return true;
        if (getAnnoConfigTypes() > rhs.getAnnoConfigTypes()) return false;
    }
    if (hasBEnable() || rhs.hasBEnable()) {
        if (getBEnable() < rhs.getBEnable()) return true;
        if (getBEnable() > rhs.getBEnable()) return false;
    }
    if (hasAnnoConfigSource() || rhs.hasAnnoConfigSource()) {
        if ((uint32)getAnnoConfigSource() < (uint32)rhs.getAnnoConfigSource()) return true;
        if ((uint32)getAnnoConfigSource() > (uint32)rhs.getAnnoConfigSource()) return false;
    }
    return false;
}

inline bool T_DAB_AnnoConfig::operator > (const T_DAB_AnnoConfig& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_AnnoConfig::clear() {
    clearAnnoConfigTypes();
    clearBEnable();
    clearAnnoConfigSource();
}

inline void T_DAB_AnnoConfig::clearAnnoConfigTypes() {
    if (hasAnnoConfigTypes()) {
         clear_has_AnnoConfigTypes();
        _AnnoConfigTypes = T_b16_DAB_AnnouncementType ();
     }
}

inline bool T_DAB_AnnoConfig::hasAnnoConfigTypes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_b16_DAB_AnnouncementType& T_DAB_AnnoConfig::getAnnoConfigTypes () const {
    return _AnnoConfigTypes;
}

inline T_b16_DAB_AnnouncementType& T_DAB_AnnoConfig::getAnnoConfigTypesMutable () {
    set_has_AnnoConfigTypes();
    return _AnnoConfigTypes;
}

inline void T_DAB_AnnoConfig::setAnnoConfigTypes (const T_b16_DAB_AnnouncementType& AnnoConfigTypes_) {
    set_has_AnnoConfigTypes();
    this->_AnnoConfigTypes = AnnoConfigTypes_;
}

inline void T_DAB_AnnoConfig::clearBEnable() {
    if (hasBEnable()) {
         clear_has_bEnable();
        _bEnable = false;
     }
}

inline bool T_DAB_AnnoConfig::hasBEnable () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_DAB_AnnoConfig::getBEnable () const {
    return _bEnable;
}

inline void T_DAB_AnnoConfig::setBEnable (bool bEnable_) {
    set_has_bEnable();
    this->_bEnable = bEnable_;
}

inline void T_DAB_AnnoConfig::clearAnnoConfigSource() {
    if (hasAnnoConfigSource()) {
         clear_has_AnnoConfigSource();
        _AnnoConfigSource = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE;
     }
}

inline bool T_DAB_AnnoConfig::hasAnnoConfigSource () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_DAB_AnnouncementSource T_DAB_AnnoConfig::getAnnoConfigSource () const {
    return _AnnoConfigSource;
}

inline void T_DAB_AnnoConfig::setAnnoConfigSource (T_e8_DAB_AnnouncementSource AnnoConfigSource_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementSource_IsValid(AnnoConfigSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoConfigSource_, "T_e8_DAB_AnnouncementSource", "AnnoConfigSource", "T_DAB_AnnoConfig");
    }
    set_has_AnnoConfigSource();
    this->_AnnoConfigSource = AnnoConfigSource_;
}

inline void T_DAB_AnnoConfig::set_has_AnnoConfigTypes () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_AnnoConfig::clear_has_AnnoConfigTypes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_AnnoConfig::set_has_bEnable () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_AnnoConfig::clear_has_bEnable () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_AnnoConfig::set_has_AnnoConfigSource () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_AnnoConfig::clear_has_AnnoConfigSource () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_DAB_AnnoElement::T_DAB_AnnoElement ()  :
    _u16AnnoType (0u),
    _AnnoState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus__START)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_AnnoElement::T_DAB_AnnoElement (const T_DAB_AnnoElement &rhs)  :
    _u16AnnoType (0u),
    _AnnoState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus__START)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_AnnoElement::T_DAB_AnnoElement (uint16 u16AnnoType_, T_e8_DAB_AnnouncementStatus AnnoState_)  :
    _u16AnnoType (u16AnnoType_),
    _AnnoState (AnnoState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementStatus_IsValid(AnnoState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoState_, "T_e8_DAB_AnnouncementStatus", "AnnoState", "T_DAB_AnnoElement");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_AnnoElement::~T_DAB_AnnoElement() {
}

inline T_DAB_AnnoElement& T_DAB_AnnoElement::operator = (const T_DAB_AnnoElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16AnnoType()) {
            setU16AnnoType(rhs.getU16AnnoType());
        } else {
            clearU16AnnoType();
        }
        if (rhs.hasAnnoState()) {
            setAnnoState(rhs.getAnnoState());
        } else {
            clearAnnoState();
        }
    }
    return *this;
}

inline bool T_DAB_AnnoElement::operator == (const T_DAB_AnnoElement& rhs) const {
    return (((!hasU16AnnoType() && !rhs.hasU16AnnoType()) || getU16AnnoType() == rhs.getU16AnnoType()) &&
        ((!hasAnnoState() && !rhs.hasAnnoState()) || getAnnoState() == rhs.getAnnoState()));
}

inline bool T_DAB_AnnoElement::operator != (const T_DAB_AnnoElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_AnnoElement::operator < (const T_DAB_AnnoElement& rhs) const {
    if (hasU16AnnoType() || rhs.hasU16AnnoType()) {
        if (getU16AnnoType() < rhs.getU16AnnoType()) return true;
        if (getU16AnnoType() > rhs.getU16AnnoType()) return false;
    }
    if (hasAnnoState() || rhs.hasAnnoState()) {
        if ((uint32)getAnnoState() < (uint32)rhs.getAnnoState()) return true;
        if ((uint32)getAnnoState() > (uint32)rhs.getAnnoState()) return false;
    }
    return false;
}

inline bool T_DAB_AnnoElement::operator > (const T_DAB_AnnoElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_AnnoElement::clear() {
    clearU16AnnoType();
    clearAnnoState();
}

inline void T_DAB_AnnoElement::clearU16AnnoType() {
    if (hasU16AnnoType()) {
         clear_has_u16AnnoType();
        _u16AnnoType = 0u;
     }
}

inline bool T_DAB_AnnoElement::hasU16AnnoType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_DAB_AnnoElement::getU16AnnoType () const {
    return _u16AnnoType;
}

inline void T_DAB_AnnoElement::setU16AnnoType (uint16 u16AnnoType_) {
    set_has_u16AnnoType();
    this->_u16AnnoType = u16AnnoType_;
}

inline void T_DAB_AnnoElement::clearAnnoState() {
    if (hasAnnoState()) {
         clear_has_AnnoState();
        _AnnoState = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus__START;
     }
}

inline bool T_DAB_AnnoElement::hasAnnoState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_DAB_AnnouncementStatus T_DAB_AnnoElement::getAnnoState () const {
    return _AnnoState;
}

inline void T_DAB_AnnoElement::setAnnoState (T_e8_DAB_AnnouncementStatus AnnoState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementStatus_IsValid(AnnoState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoState_, "T_e8_DAB_AnnouncementStatus", "AnnoState", "T_DAB_AnnoElement");
    }
    set_has_AnnoState();
    this->_AnnoState = AnnoState_;
}

inline void T_DAB_AnnoElement::set_has_u16AnnoType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_AnnoElement::clear_has_u16AnnoType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_AnnoElement::set_has_AnnoState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_AnnoElement::clear_has_AnnoState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DAB_AnnoStatus::T_DAB_AnnoStatus ()  :
    _AnnoConfigTypes (),
    _AnnoConfigSource (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE),
    _AnnoSupportedTypes (),
    _AnnoActiveTypes (),
    _AnnoActiveSource (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE),
    _AnnoActiveState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus__START),
    _AnnoSelectState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSelectState__IDLE),
    _AnnoSelectedTypes (),
    _AnnoServiceLabel (),
    _AnnouncementList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_AnnoStatus::T_DAB_AnnoStatus (const T_DAB_AnnoStatus &rhs)  :
    _AnnoConfigTypes (),
    _AnnoConfigSource (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE),
    _AnnoSupportedTypes (),
    _AnnoActiveTypes (),
    _AnnoActiveSource (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE),
    _AnnoActiveState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus__START),
    _AnnoSelectState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSelectState__IDLE),
    _AnnoSelectedTypes (),
    _AnnoServiceLabel (),
    _AnnouncementList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_AnnoStatus::T_DAB_AnnoStatus (const T_b16_DAB_AnnouncementType& AnnoConfigTypes_, T_e8_DAB_AnnouncementSource AnnoConfigSource_, const T_b16_DAB_AnnouncementType& AnnoSupportedTypes_, const T_b16_DAB_AnnouncementType& AnnoActiveTypes_, T_e8_DAB_AnnouncementSource AnnoActiveSource_, T_e8_DAB_AnnouncementStatus AnnoActiveState_, T_e8_DAB_AnnouncementSelectState AnnoSelectState_, const T_b16_DAB_AnnouncementType& AnnoSelectedTypes_, const T_DAB_Label& AnnoServiceLabel_, const ::std::vector< T_DAB_AnnoElement >& AnnouncementList_)  :
    _AnnoConfigTypes (AnnoConfigTypes_),
    _AnnoConfigSource (AnnoConfigSource_),
    _AnnoSupportedTypes (AnnoSupportedTypes_),
    _AnnoActiveTypes (AnnoActiveTypes_),
    _AnnoActiveSource (AnnoActiveSource_),
    _AnnoActiveState (AnnoActiveState_),
    _AnnoSelectState (AnnoSelectState_),
    _AnnoSelectedTypes (AnnoSelectedTypes_),
    _AnnoServiceLabel (AnnoServiceLabel_),
    _AnnouncementList (AnnouncementList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementSource_IsValid(AnnoConfigSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoConfigSource_, "T_e8_DAB_AnnouncementSource", "AnnoConfigSource", "T_DAB_AnnoStatus");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementSource_IsValid(AnnoActiveSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoActiveSource_, "T_e8_DAB_AnnouncementSource", "AnnoActiveSource", "T_DAB_AnnoStatus");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementStatus_IsValid(AnnoActiveState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoActiveState_, "T_e8_DAB_AnnouncementStatus", "AnnoActiveState", "T_DAB_AnnoStatus");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementSelectState_IsValid(AnnoSelectState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoSelectState_, "T_e8_DAB_AnnouncementSelectState", "AnnoSelectState", "T_DAB_AnnoStatus");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_AnnoStatus::~T_DAB_AnnoStatus() {
}

inline T_DAB_AnnoStatus& T_DAB_AnnoStatus::operator = (const T_DAB_AnnoStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAnnoConfigTypes()) {
            setAnnoConfigTypes(rhs.getAnnoConfigTypes());
        } else {
            clearAnnoConfigTypes();
        }
        if (rhs.hasAnnoConfigSource()) {
            setAnnoConfigSource(rhs.getAnnoConfigSource());
        } else {
            clearAnnoConfigSource();
        }
        if (rhs.hasAnnoSupportedTypes()) {
            setAnnoSupportedTypes(rhs.getAnnoSupportedTypes());
        } else {
            clearAnnoSupportedTypes();
        }
        if (rhs.hasAnnoActiveTypes()) {
            setAnnoActiveTypes(rhs.getAnnoActiveTypes());
        } else {
            clearAnnoActiveTypes();
        }
        if (rhs.hasAnnoActiveSource()) {
            setAnnoActiveSource(rhs.getAnnoActiveSource());
        } else {
            clearAnnoActiveSource();
        }
        if (rhs.hasAnnoActiveState()) {
            setAnnoActiveState(rhs.getAnnoActiveState());
        } else {
            clearAnnoActiveState();
        }
        if (rhs.hasAnnoSelectState()) {
            setAnnoSelectState(rhs.getAnnoSelectState());
        } else {
            clearAnnoSelectState();
        }
        if (rhs.hasAnnoSelectedTypes()) {
            setAnnoSelectedTypes(rhs.getAnnoSelectedTypes());
        } else {
            clearAnnoSelectedTypes();
        }
        if (rhs.hasAnnoServiceLabel()) {
            setAnnoServiceLabel(rhs.getAnnoServiceLabel());
        } else {
            clearAnnoServiceLabel();
        }
        if (rhs.hasAnnouncementList()) {
            setAnnouncementList(rhs.getAnnouncementList());
        } else {
            clearAnnouncementList();
        }
    }
    return *this;
}

inline bool T_DAB_AnnoStatus::operator == (const T_DAB_AnnoStatus& rhs) const {
    return (((!hasAnnoConfigTypes() && !rhs.hasAnnoConfigTypes()) || getAnnoConfigTypes() == rhs.getAnnoConfigTypes()) &&
        ((!hasAnnoConfigSource() && !rhs.hasAnnoConfigSource()) || getAnnoConfigSource() == rhs.getAnnoConfigSource()) &&
        ((!hasAnnoSupportedTypes() && !rhs.hasAnnoSupportedTypes()) || getAnnoSupportedTypes() == rhs.getAnnoSupportedTypes()) &&
        ((!hasAnnoActiveTypes() && !rhs.hasAnnoActiveTypes()) || getAnnoActiveTypes() == rhs.getAnnoActiveTypes()) &&
        ((!hasAnnoActiveSource() && !rhs.hasAnnoActiveSource()) || getAnnoActiveSource() == rhs.getAnnoActiveSource()) &&
        ((!hasAnnoActiveState() && !rhs.hasAnnoActiveState()) || getAnnoActiveState() == rhs.getAnnoActiveState()) &&
        ((!hasAnnoSelectState() && !rhs.hasAnnoSelectState()) || getAnnoSelectState() == rhs.getAnnoSelectState()) &&
        ((!hasAnnoSelectedTypes() && !rhs.hasAnnoSelectedTypes()) || getAnnoSelectedTypes() == rhs.getAnnoSelectedTypes()) &&
        ((!hasAnnoServiceLabel() && !rhs.hasAnnoServiceLabel()) || getAnnoServiceLabel() == rhs.getAnnoServiceLabel()) &&
        ((!hasAnnouncementList() && !rhs.hasAnnouncementList()) || getAnnouncementList() == rhs.getAnnouncementList()));
}

inline bool T_DAB_AnnoStatus::operator != (const T_DAB_AnnoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_AnnoStatus::operator < (const T_DAB_AnnoStatus& rhs) const {
    if (hasAnnoConfigTypes() || rhs.hasAnnoConfigTypes()) {
        if (getAnnoConfigTypes() < rhs.getAnnoConfigTypes()) return true;
        if (getAnnoConfigTypes() > rhs.getAnnoConfigTypes()) return false;
    }
    if (hasAnnoConfigSource() || rhs.hasAnnoConfigSource()) {
        if ((uint32)getAnnoConfigSource() < (uint32)rhs.getAnnoConfigSource()) return true;
        if ((uint32)getAnnoConfigSource() > (uint32)rhs.getAnnoConfigSource()) return false;
    }
    if (hasAnnoSupportedTypes() || rhs.hasAnnoSupportedTypes()) {
        if (getAnnoSupportedTypes() < rhs.getAnnoSupportedTypes()) return true;
        if (getAnnoSupportedTypes() > rhs.getAnnoSupportedTypes()) return false;
    }
    if (hasAnnoActiveTypes() || rhs.hasAnnoActiveTypes()) {
        if (getAnnoActiveTypes() < rhs.getAnnoActiveTypes()) return true;
        if (getAnnoActiveTypes() > rhs.getAnnoActiveTypes()) return false;
    }
    if (hasAnnoActiveSource() || rhs.hasAnnoActiveSource()) {
        if ((uint32)getAnnoActiveSource() < (uint32)rhs.getAnnoActiveSource()) return true;
        if ((uint32)getAnnoActiveSource() > (uint32)rhs.getAnnoActiveSource()) return false;
    }
    if (hasAnnoActiveState() || rhs.hasAnnoActiveState()) {
        if ((uint32)getAnnoActiveState() < (uint32)rhs.getAnnoActiveState()) return true;
        if ((uint32)getAnnoActiveState() > (uint32)rhs.getAnnoActiveState()) return false;
    }
    if (hasAnnoSelectState() || rhs.hasAnnoSelectState()) {
        if ((uint32)getAnnoSelectState() < (uint32)rhs.getAnnoSelectState()) return true;
        if ((uint32)getAnnoSelectState() > (uint32)rhs.getAnnoSelectState()) return false;
    }
    if (hasAnnoSelectedTypes() || rhs.hasAnnoSelectedTypes()) {
        if (getAnnoSelectedTypes() < rhs.getAnnoSelectedTypes()) return true;
        if (getAnnoSelectedTypes() > rhs.getAnnoSelectedTypes()) return false;
    }
    if (hasAnnoServiceLabel() || rhs.hasAnnoServiceLabel()) {
        if (getAnnoServiceLabel() < rhs.getAnnoServiceLabel()) return true;
        if (getAnnoServiceLabel() > rhs.getAnnoServiceLabel()) return false;
    }
    if (hasAnnouncementList() || rhs.hasAnnouncementList()) {
        if (getAnnouncementList() < rhs.getAnnouncementList()) return true;
        if (getAnnouncementList() > rhs.getAnnouncementList()) return false;
    }
    return false;
}

inline bool T_DAB_AnnoStatus::operator > (const T_DAB_AnnoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_AnnoStatus::clear() {
    clearAnnoConfigTypes();
    clearAnnoConfigSource();
    clearAnnoSupportedTypes();
    clearAnnoActiveTypes();
    clearAnnoActiveSource();
    clearAnnoActiveState();
    clearAnnoSelectState();
    clearAnnoSelectedTypes();
    clearAnnoServiceLabel();
    clearAnnouncementList();
}

inline void T_DAB_AnnoStatus::clearAnnoConfigTypes() {
    if (hasAnnoConfigTypes()) {
         clear_has_AnnoConfigTypes();
        _AnnoConfigTypes = T_b16_DAB_AnnouncementType ();
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoConfigTypes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_b16_DAB_AnnouncementType& T_DAB_AnnoStatus::getAnnoConfigTypes () const {
    return _AnnoConfigTypes;
}

inline T_b16_DAB_AnnouncementType& T_DAB_AnnoStatus::getAnnoConfigTypesMutable () {
    set_has_AnnoConfigTypes();
    return _AnnoConfigTypes;
}

inline void T_DAB_AnnoStatus::setAnnoConfigTypes (const T_b16_DAB_AnnouncementType& AnnoConfigTypes_) {
    set_has_AnnoConfigTypes();
    this->_AnnoConfigTypes = AnnoConfigTypes_;
}

inline void T_DAB_AnnoStatus::clearAnnoConfigSource() {
    if (hasAnnoConfigSource()) {
         clear_has_AnnoConfigSource();
        _AnnoConfigSource = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE;
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoConfigSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_DAB_AnnouncementSource T_DAB_AnnoStatus::getAnnoConfigSource () const {
    return _AnnoConfigSource;
}

inline void T_DAB_AnnoStatus::setAnnoConfigSource (T_e8_DAB_AnnouncementSource AnnoConfigSource_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementSource_IsValid(AnnoConfigSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoConfigSource_, "T_e8_DAB_AnnouncementSource", "AnnoConfigSource", "T_DAB_AnnoStatus");
    }
    set_has_AnnoConfigSource();
    this->_AnnoConfigSource = AnnoConfigSource_;
}

inline void T_DAB_AnnoStatus::clearAnnoSupportedTypes() {
    if (hasAnnoSupportedTypes()) {
         clear_has_AnnoSupportedTypes();
        _AnnoSupportedTypes = T_b16_DAB_AnnouncementType ();
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoSupportedTypes () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_b16_DAB_AnnouncementType& T_DAB_AnnoStatus::getAnnoSupportedTypes () const {
    return _AnnoSupportedTypes;
}

inline T_b16_DAB_AnnouncementType& T_DAB_AnnoStatus::getAnnoSupportedTypesMutable () {
    set_has_AnnoSupportedTypes();
    return _AnnoSupportedTypes;
}

inline void T_DAB_AnnoStatus::setAnnoSupportedTypes (const T_b16_DAB_AnnouncementType& AnnoSupportedTypes_) {
    set_has_AnnoSupportedTypes();
    this->_AnnoSupportedTypes = AnnoSupportedTypes_;
}

inline void T_DAB_AnnoStatus::clearAnnoActiveTypes() {
    if (hasAnnoActiveTypes()) {
         clear_has_AnnoActiveTypes();
        _AnnoActiveTypes = T_b16_DAB_AnnouncementType ();
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoActiveTypes () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_b16_DAB_AnnouncementType& T_DAB_AnnoStatus::getAnnoActiveTypes () const {
    return _AnnoActiveTypes;
}

inline T_b16_DAB_AnnouncementType& T_DAB_AnnoStatus::getAnnoActiveTypesMutable () {
    set_has_AnnoActiveTypes();
    return _AnnoActiveTypes;
}

inline void T_DAB_AnnoStatus::setAnnoActiveTypes (const T_b16_DAB_AnnouncementType& AnnoActiveTypes_) {
    set_has_AnnoActiveTypes();
    this->_AnnoActiveTypes = AnnoActiveTypes_;
}

inline void T_DAB_AnnoStatus::clearAnnoActiveSource() {
    if (hasAnnoActiveSource()) {
         clear_has_AnnoActiveSource();
        _AnnoActiveSource = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE;
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoActiveSource () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_DAB_AnnouncementSource T_DAB_AnnoStatus::getAnnoActiveSource () const {
    return _AnnoActiveSource;
}

inline void T_DAB_AnnoStatus::setAnnoActiveSource (T_e8_DAB_AnnouncementSource AnnoActiveSource_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementSource_IsValid(AnnoActiveSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoActiveSource_, "T_e8_DAB_AnnouncementSource", "AnnoActiveSource", "T_DAB_AnnoStatus");
    }
    set_has_AnnoActiveSource();
    this->_AnnoActiveSource = AnnoActiveSource_;
}

inline void T_DAB_AnnoStatus::clearAnnoActiveState() {
    if (hasAnnoActiveState()) {
         clear_has_AnnoActiveState();
        _AnnoActiveState = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus__START;
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoActiveState () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_DAB_AnnouncementStatus T_DAB_AnnoStatus::getAnnoActiveState () const {
    return _AnnoActiveState;
}

inline void T_DAB_AnnoStatus::setAnnoActiveState (T_e8_DAB_AnnouncementStatus AnnoActiveState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementStatus_IsValid(AnnoActiveState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoActiveState_, "T_e8_DAB_AnnouncementStatus", "AnnoActiveState", "T_DAB_AnnoStatus");
    }
    set_has_AnnoActiveState();
    this->_AnnoActiveState = AnnoActiveState_;
}

inline void T_DAB_AnnoStatus::clearAnnoSelectState() {
    if (hasAnnoSelectState()) {
         clear_has_AnnoSelectState();
        _AnnoSelectState = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSelectState__IDLE;
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoSelectState () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_DAB_AnnouncementSelectState T_DAB_AnnoStatus::getAnnoSelectState () const {
    return _AnnoSelectState;
}

inline void T_DAB_AnnoStatus::setAnnoSelectState (T_e8_DAB_AnnouncementSelectState AnnoSelectState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_AnnouncementSelectState_IsValid(AnnoSelectState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnoSelectState_, "T_e8_DAB_AnnouncementSelectState", "AnnoSelectState", "T_DAB_AnnoStatus");
    }
    set_has_AnnoSelectState();
    this->_AnnoSelectState = AnnoSelectState_;
}

inline void T_DAB_AnnoStatus::clearAnnoSelectedTypes() {
    if (hasAnnoSelectedTypes()) {
         clear_has_AnnoSelectedTypes();
        _AnnoSelectedTypes = T_b16_DAB_AnnouncementType ();
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoSelectedTypes () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const T_b16_DAB_AnnouncementType& T_DAB_AnnoStatus::getAnnoSelectedTypes () const {
    return _AnnoSelectedTypes;
}

inline T_b16_DAB_AnnouncementType& T_DAB_AnnoStatus::getAnnoSelectedTypesMutable () {
    set_has_AnnoSelectedTypes();
    return _AnnoSelectedTypes;
}

inline void T_DAB_AnnoStatus::setAnnoSelectedTypes (const T_b16_DAB_AnnouncementType& AnnoSelectedTypes_) {
    set_has_AnnoSelectedTypes();
    this->_AnnoSelectedTypes = AnnoSelectedTypes_;
}

inline void T_DAB_AnnoStatus::clearAnnoServiceLabel() {
    if (hasAnnoServiceLabel()) {
         clear_has_AnnoServiceLabel();
        _AnnoServiceLabel.clear();
     }
}

inline bool T_DAB_AnnoStatus::hasAnnoServiceLabel () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const T_DAB_Label& T_DAB_AnnoStatus::getAnnoServiceLabel () const {
    return _AnnoServiceLabel;
}

inline T_DAB_Label& T_DAB_AnnoStatus::getAnnoServiceLabelMutable () {
    set_has_AnnoServiceLabel();
    return _AnnoServiceLabel;
}

inline void T_DAB_AnnoStatus::setAnnoServiceLabel (const T_DAB_Label& AnnoServiceLabel_) {
    set_has_AnnoServiceLabel();
    this->_AnnoServiceLabel = AnnoServiceLabel_;
}

inline void T_DAB_AnnoStatus::clearAnnouncementList() {
    if (hasAnnouncementList()) {
         clear_has_AnnouncementList();
        _AnnouncementList.clear();
     }
}

inline bool T_DAB_AnnoStatus::hasAnnouncementList () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::vector< T_DAB_AnnoElement >& T_DAB_AnnoStatus::getAnnouncementList () const {
    return _AnnouncementList;
}

inline ::std::vector< T_DAB_AnnoElement >& T_DAB_AnnoStatus::getAnnouncementListMutable () {
    set_has_AnnouncementList();
    return _AnnouncementList;
}

inline void T_DAB_AnnoStatus::setAnnouncementList (const ::std::vector< T_DAB_AnnoElement >& AnnouncementList_) {
    set_has_AnnouncementList();
    this->_AnnouncementList = AnnouncementList_;
}

inline void T_DAB_AnnoStatus::set_has_AnnoConfigTypes () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoConfigTypes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_AnnoStatus::set_has_AnnoConfigSource () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoConfigSource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_AnnoStatus::set_has_AnnoSupportedTypes () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoSupportedTypes () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_AnnoStatus::set_has_AnnoActiveTypes () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoActiveTypes () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_AnnoStatus::set_has_AnnoActiveSource () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoActiveSource () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_AnnoStatus::set_has_AnnoActiveState () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoActiveState () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_AnnoStatus::set_has_AnnoSelectState () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoSelectState () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_AnnoStatus::set_has_AnnoSelectedTypes () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoSelectedTypes () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_AnnoStatus::set_has_AnnoServiceLabel () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_AnnoStatus::clear_has_AnnoServiceLabel () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DAB_AnnoStatus::set_has_AnnouncementList () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DAB_AnnoStatus::clear_has_AnnouncementList () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  T_DAB_ADRMsg::T_DAB_ADRMsg ()  :
    _u16FktID (0u),
    _MsgData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_ADRMsg::T_DAB_ADRMsg (const T_DAB_ADRMsg &rhs)  :
    _u16FktID (0u),
    _MsgData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_ADRMsg::T_DAB_ADRMsg (uint16 u16FktID_, const ::std::vector< uint8 >& MsgData_)  :
    _u16FktID (u16FktID_),
    _MsgData (MsgData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_ADRMsg::~T_DAB_ADRMsg() {
}

inline T_DAB_ADRMsg& T_DAB_ADRMsg::operator = (const T_DAB_ADRMsg& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16FktID()) {
            setU16FktID(rhs.getU16FktID());
        } else {
            clearU16FktID();
        }
        if (rhs.hasMsgData()) {
            setMsgData(rhs.getMsgData());
        } else {
            clearMsgData();
        }
    }
    return *this;
}

inline bool T_DAB_ADRMsg::operator == (const T_DAB_ADRMsg& rhs) const {
    return (((!hasU16FktID() && !rhs.hasU16FktID()) || getU16FktID() == rhs.getU16FktID()) &&
        ((!hasMsgData() && !rhs.hasMsgData()) || getMsgData() == rhs.getMsgData()));
}

inline bool T_DAB_ADRMsg::operator != (const T_DAB_ADRMsg& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_ADRMsg::operator < (const T_DAB_ADRMsg& rhs) const {
    if (hasU16FktID() || rhs.hasU16FktID()) {
        if (getU16FktID() < rhs.getU16FktID()) return true;
        if (getU16FktID() > rhs.getU16FktID()) return false;
    }
    if (hasMsgData() || rhs.hasMsgData()) {
        if (getMsgData() < rhs.getMsgData()) return true;
        if (getMsgData() > rhs.getMsgData()) return false;
    }
    return false;
}

inline bool T_DAB_ADRMsg::operator > (const T_DAB_ADRMsg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_ADRMsg::clear() {
    clearU16FktID();
    clearMsgData();
}

inline void T_DAB_ADRMsg::clearU16FktID() {
    if (hasU16FktID()) {
         clear_has_u16FktID();
        _u16FktID = 0u;
     }
}

inline bool T_DAB_ADRMsg::hasU16FktID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_DAB_ADRMsg::getU16FktID () const {
    return _u16FktID;
}

inline void T_DAB_ADRMsg::setU16FktID (uint16 u16FktID_) {
    set_has_u16FktID();
    this->_u16FktID = u16FktID_;
}

inline void T_DAB_ADRMsg::clearMsgData() {
    if (hasMsgData()) {
         clear_has_MsgData();
        _MsgData.clear();
     }
}

inline bool T_DAB_ADRMsg::hasMsgData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& T_DAB_ADRMsg::getMsgData () const {
    return _MsgData;
}

inline ::std::vector< uint8 >& T_DAB_ADRMsg::getMsgDataMutable () {
    set_has_MsgData();
    return _MsgData;
}

inline void T_DAB_ADRMsg::setMsgData (const ::std::vector< uint8 >& MsgData_) {
    set_has_MsgData();
    this->_MsgData = MsgData_;
}

inline void T_DAB_ADRMsg::set_has_u16FktID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_ADRMsg::clear_has_u16FktID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_ADRMsg::set_has_MsgData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_ADRMsg::clear_has_MsgData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DAB_LogoElement::T_DAB_LogoElement ()  :
    _u32ServiceID (0u),
    _sLogoLink ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_LogoElement::T_DAB_LogoElement (const T_DAB_LogoElement &rhs)  :
    _u32ServiceID (0u),
    _sLogoLink ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_LogoElement::T_DAB_LogoElement (uint32 u32ServiceID_, const ::std::string& sLogoLink_)  :
    _u32ServiceID (u32ServiceID_),
    _sLogoLink (sLogoLink_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_LogoElement::~T_DAB_LogoElement() {
}

inline T_DAB_LogoElement& T_DAB_LogoElement::operator = (const T_DAB_LogoElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32ServiceID()) {
            setU32ServiceID(rhs.getU32ServiceID());
        } else {
            clearU32ServiceID();
        }
        if (rhs.hasSLogoLink()) {
            setSLogoLink(rhs.getSLogoLink());
        } else {
            clearSLogoLink();
        }
    }
    return *this;
}

inline bool T_DAB_LogoElement::operator == (const T_DAB_LogoElement& rhs) const {
    return (((!hasU32ServiceID() && !rhs.hasU32ServiceID()) || getU32ServiceID() == rhs.getU32ServiceID()) &&
        ((!hasSLogoLink() && !rhs.hasSLogoLink()) || getSLogoLink() == rhs.getSLogoLink()));
}

inline bool T_DAB_LogoElement::operator != (const T_DAB_LogoElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_LogoElement::operator < (const T_DAB_LogoElement& rhs) const {
    if (hasU32ServiceID() || rhs.hasU32ServiceID()) {
        if (getU32ServiceID() < rhs.getU32ServiceID()) return true;
        if (getU32ServiceID() > rhs.getU32ServiceID()) return false;
    }
    if (hasSLogoLink() || rhs.hasSLogoLink()) {
        if (getSLogoLink() < rhs.getSLogoLink()) return true;
        if (getSLogoLink() > rhs.getSLogoLink()) return false;
    }
    return false;
}

inline bool T_DAB_LogoElement::operator > (const T_DAB_LogoElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_LogoElement::clear() {
    clearU32ServiceID();
    clearSLogoLink();
}

inline void T_DAB_LogoElement::clearU32ServiceID() {
    if (hasU32ServiceID()) {
         clear_has_u32ServiceID();
        _u32ServiceID = 0u;
     }
}

inline bool T_DAB_LogoElement::hasU32ServiceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_LogoElement::getU32ServiceID () const {
    return _u32ServiceID;
}

inline void T_DAB_LogoElement::setU32ServiceID (uint32 u32ServiceID_) {
    set_has_u32ServiceID();
    this->_u32ServiceID = u32ServiceID_;
}

inline void T_DAB_LogoElement::clearSLogoLink() {
    if (hasSLogoLink()) {
         clear_has_sLogoLink();
        _sLogoLink.clear();
     }
}

inline bool T_DAB_LogoElement::hasSLogoLink () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DAB_LogoElement::getSLogoLink () const {
    return _sLogoLink;
}

inline ::std::string& T_DAB_LogoElement::getSLogoLinkMutable () {
    set_has_sLogoLink();
    return _sLogoLink;
}

inline void T_DAB_LogoElement::setSLogoLink (const ::std::string& sLogoLink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink = sLogoLink_;
}

inline void T_DAB_LogoElement::setSLogoLink (const char* sLogoLink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink.assign(sLogoLink_);
}

inline void T_DAB_LogoElement::setSLogoLink (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink.assign(value, size);
}

inline void T_DAB_LogoElement::set_has_u32ServiceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_LogoElement::clear_has_u32ServiceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_LogoElement::set_has_sLogoLink () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_LogoElement::clear_has_sLogoLink () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DAB_ContentID::T_DAB_ContentID ()  :
    _u32ServiceID (0u),
    _u8Scid (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_ContentID::T_DAB_ContentID (const T_DAB_ContentID &rhs)  :
    _u32ServiceID (0u),
    _u8Scid (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_ContentID::T_DAB_ContentID (uint32 u32ServiceID_, uint8 u8Scid_)  :
    _u32ServiceID (u32ServiceID_),
    _u8Scid (u8Scid_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_ContentID::~T_DAB_ContentID() {
}

inline T_DAB_ContentID& T_DAB_ContentID::operator = (const T_DAB_ContentID& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32ServiceID()) {
            setU32ServiceID(rhs.getU32ServiceID());
        } else {
            clearU32ServiceID();
        }
        if (rhs.hasU8Scid()) {
            setU8Scid(rhs.getU8Scid());
        } else {
            clearU8Scid();
        }
    }
    return *this;
}

inline bool T_DAB_ContentID::operator == (const T_DAB_ContentID& rhs) const {
    return (((!hasU32ServiceID() && !rhs.hasU32ServiceID()) || getU32ServiceID() == rhs.getU32ServiceID()) &&
        ((!hasU8Scid() && !rhs.hasU8Scid()) || getU8Scid() == rhs.getU8Scid()));
}

inline bool T_DAB_ContentID::operator != (const T_DAB_ContentID& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_ContentID::operator < (const T_DAB_ContentID& rhs) const {
    if (hasU32ServiceID() || rhs.hasU32ServiceID()) {
        if (getU32ServiceID() < rhs.getU32ServiceID()) return true;
        if (getU32ServiceID() > rhs.getU32ServiceID()) return false;
    }
    if (hasU8Scid() || rhs.hasU8Scid()) {
        if (getU8Scid() < rhs.getU8Scid()) return true;
        if (getU8Scid() > rhs.getU8Scid()) return false;
    }
    return false;
}

inline bool T_DAB_ContentID::operator > (const T_DAB_ContentID& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_ContentID::clear() {
    clearU32ServiceID();
    clearU8Scid();
}

inline void T_DAB_ContentID::clearU32ServiceID() {
    if (hasU32ServiceID()) {
         clear_has_u32ServiceID();
        _u32ServiceID = 0u;
     }
}

inline bool T_DAB_ContentID::hasU32ServiceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_ContentID::getU32ServiceID () const {
    return _u32ServiceID;
}

inline void T_DAB_ContentID::setU32ServiceID (uint32 u32ServiceID_) {
    set_has_u32ServiceID();
    this->_u32ServiceID = u32ServiceID_;
}

inline void T_DAB_ContentID::clearU8Scid() {
    if (hasU8Scid()) {
         clear_has_u8Scid();
        _u8Scid = 0u;
     }
}

inline bool T_DAB_ContentID::hasU8Scid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_DAB_ContentID::getU8Scid () const {
    return _u8Scid;
}

inline void T_DAB_ContentID::setU8Scid (uint8 u8Scid_) {
    set_has_u8Scid();
    this->_u8Scid = u8Scid_;
}

inline void T_DAB_ContentID::set_has_u32ServiceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_ContentID::clear_has_u32ServiceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_ContentID::set_has_u8Scid () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_ContentID::clear_has_u8Scid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DAB_TuneParam::T_DAB_TuneParam ()  :
    _e8TuneType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TuneType__DAB_TUNETYPE_OFF),
    _u32Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_TuneParam::T_DAB_TuneParam (const T_DAB_TuneParam &rhs)  :
    _e8TuneType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TuneType__DAB_TUNETYPE_OFF),
    _u32Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_TuneParam::T_DAB_TuneParam (T_e8_DAB_TuneType e8TuneType_, uint32 u32Value_)  :
    _e8TuneType (e8TuneType_),
    _u32Value (u32Value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_TuneType_IsValid(e8TuneType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TuneType_, "T_e8_DAB_TuneType", "e8TuneType", "T_DAB_TuneParam");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_TuneParam::~T_DAB_TuneParam() {
}

inline T_DAB_TuneParam& T_DAB_TuneParam::operator = (const T_DAB_TuneParam& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8TuneType()) {
            setE8TuneType(rhs.getE8TuneType());
        } else {
            clearE8TuneType();
        }
        if (rhs.hasU32Value()) {
            setU32Value(rhs.getU32Value());
        } else {
            clearU32Value();
        }
    }
    return *this;
}

inline bool T_DAB_TuneParam::operator == (const T_DAB_TuneParam& rhs) const {
    return (((!hasE8TuneType() && !rhs.hasE8TuneType()) || getE8TuneType() == rhs.getE8TuneType()) &&
        ((!hasU32Value() && !rhs.hasU32Value()) || getU32Value() == rhs.getU32Value()));
}

inline bool T_DAB_TuneParam::operator != (const T_DAB_TuneParam& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_TuneParam::operator < (const T_DAB_TuneParam& rhs) const {
    if (hasE8TuneType() || rhs.hasE8TuneType()) {
        if ((uint32)getE8TuneType() < (uint32)rhs.getE8TuneType()) return true;
        if ((uint32)getE8TuneType() > (uint32)rhs.getE8TuneType()) return false;
    }
    if (hasU32Value() || rhs.hasU32Value()) {
        if (getU32Value() < rhs.getU32Value()) return true;
        if (getU32Value() > rhs.getU32Value()) return false;
    }
    return false;
}

inline bool T_DAB_TuneParam::operator > (const T_DAB_TuneParam& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_TuneParam::clear() {
    clearE8TuneType();
    clearU32Value();
}

inline void T_DAB_TuneParam::clearE8TuneType() {
    if (hasE8TuneType()) {
         clear_has_e8TuneType();
        _e8TuneType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TuneType__DAB_TUNETYPE_OFF;
     }
}

inline bool T_DAB_TuneParam::hasE8TuneType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_DAB_TuneType T_DAB_TuneParam::getE8TuneType () const {
    return _e8TuneType;
}

inline void T_DAB_TuneParam::setE8TuneType (T_e8_DAB_TuneType e8TuneType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_TuneType_IsValid(e8TuneType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TuneType_, "T_e8_DAB_TuneType", "e8TuneType", "T_DAB_TuneParam");
    }
    set_has_e8TuneType();
    this->_e8TuneType = e8TuneType_;
}

inline void T_DAB_TuneParam::clearU32Value() {
    if (hasU32Value()) {
         clear_has_u32Value();
        _u32Value = 0u;
     }
}

inline bool T_DAB_TuneParam::hasU32Value () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_DAB_TuneParam::getU32Value () const {
    return _u32Value;
}

inline void T_DAB_TuneParam::setU32Value (uint32 u32Value_) {
    set_has_u32Value();
    this->_u32Value = u32Value_;
}

inline void T_DAB_TuneParam::set_has_e8TuneType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_TuneParam::clear_has_e8TuneType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_TuneParam::set_has_u32Value () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_TuneParam::clear_has_u32Value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DAB_LearnParam::T_DAB_LearnParam ()  :
    _e8LearnType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_LearnType__DAB_LEARNTYPE_OFF),
    _bRollback (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_LearnParam::T_DAB_LearnParam (const T_DAB_LearnParam &rhs)  :
    _e8LearnType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_LearnType__DAB_LEARNTYPE_OFF),
    _bRollback (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_LearnParam::T_DAB_LearnParam (T_e8_DAB_LearnType e8LearnType_, bool bRollback_)  :
    _e8LearnType (e8LearnType_),
    _bRollback (bRollback_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_LearnType_IsValid(e8LearnType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LearnType_, "T_e8_DAB_LearnType", "e8LearnType", "T_DAB_LearnParam");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_LearnParam::~T_DAB_LearnParam() {
}

inline T_DAB_LearnParam& T_DAB_LearnParam::operator = (const T_DAB_LearnParam& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8LearnType()) {
            setE8LearnType(rhs.getE8LearnType());
        } else {
            clearE8LearnType();
        }
        if (rhs.hasBRollback()) {
            setBRollback(rhs.getBRollback());
        } else {
            clearBRollback();
        }
    }
    return *this;
}

inline bool T_DAB_LearnParam::operator == (const T_DAB_LearnParam& rhs) const {
    return (((!hasE8LearnType() && !rhs.hasE8LearnType()) || getE8LearnType() == rhs.getE8LearnType()) &&
        ((!hasBRollback() && !rhs.hasBRollback()) || getBRollback() == rhs.getBRollback()));
}

inline bool T_DAB_LearnParam::operator != (const T_DAB_LearnParam& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_LearnParam::operator < (const T_DAB_LearnParam& rhs) const {
    if (hasE8LearnType() || rhs.hasE8LearnType()) {
        if ((uint32)getE8LearnType() < (uint32)rhs.getE8LearnType()) return true;
        if ((uint32)getE8LearnType() > (uint32)rhs.getE8LearnType()) return false;
    }
    if (hasBRollback() || rhs.hasBRollback()) {
        if (getBRollback() < rhs.getBRollback()) return true;
        if (getBRollback() > rhs.getBRollback()) return false;
    }
    return false;
}

inline bool T_DAB_LearnParam::operator > (const T_DAB_LearnParam& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_LearnParam::clear() {
    clearE8LearnType();
    clearBRollback();
}

inline void T_DAB_LearnParam::clearE8LearnType() {
    if (hasE8LearnType()) {
         clear_has_e8LearnType();
        _e8LearnType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_LearnType__DAB_LEARNTYPE_OFF;
     }
}

inline bool T_DAB_LearnParam::hasE8LearnType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_DAB_LearnType T_DAB_LearnParam::getE8LearnType () const {
    return _e8LearnType;
}

inline void T_DAB_LearnParam::setE8LearnType (T_e8_DAB_LearnType e8LearnType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_LearnType_IsValid(e8LearnType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LearnType_, "T_e8_DAB_LearnType", "e8LearnType", "T_DAB_LearnParam");
    }
    set_has_e8LearnType();
    this->_e8LearnType = e8LearnType_;
}

inline void T_DAB_LearnParam::clearBRollback() {
    if (hasBRollback()) {
         clear_has_bRollback();
        _bRollback = false;
     }
}

inline bool T_DAB_LearnParam::hasBRollback () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_DAB_LearnParam::getBRollback () const {
    return _bRollback;
}

inline void T_DAB_LearnParam::setBRollback (bool bRollback_) {
    set_has_bRollback();
    this->_bRollback = bRollback_;
}

inline void T_DAB_LearnParam::set_has_e8LearnType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_LearnParam::clear_has_e8LearnType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_LearnParam::set_has_bRollback () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_LearnParam::clear_has_bRollback () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b32_DAB_SetupMask::T_b32_DAB_SetupMask ()  :
    _DAB_SETUPOPERATIONMASK_b0_reserved (false),
    _DAB_SETUPOPERATIONMASK_b1_reserved (false)
{
}

inline  T_b32_DAB_SetupMask::T_b32_DAB_SetupMask (const T_b32_DAB_SetupMask &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_DAB_SetupMask::T_b32_DAB_SetupMask (bool DAB_SETUPOPERATIONMASK_b0_reserved, bool DAB_SETUPOPERATIONMASK_b1_reserved) :
    _DAB_SETUPOPERATIONMASK_b0_reserved (DAB_SETUPOPERATIONMASK_b0_reserved),
    _DAB_SETUPOPERATIONMASK_b1_reserved (DAB_SETUPOPERATIONMASK_b1_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_DAB_SetupMask& T_b32_DAB_SetupMask::operator = (const T_b32_DAB_SetupMask& rhs) {
    if( this != &rhs ) {
        _DAB_SETUPOPERATIONMASK_b0_reserved = rhs._DAB_SETUPOPERATIONMASK_b0_reserved;
        _DAB_SETUPOPERATIONMASK_b1_reserved = rhs._DAB_SETUPOPERATIONMASK_b1_reserved;
    }
    return *this;
}

inline bool T_b32_DAB_SetupMask::operator == (const T_b32_DAB_SetupMask& rhs) const {
    return (_DAB_SETUPOPERATIONMASK_b0_reserved == rhs._DAB_SETUPOPERATIONMASK_b0_reserved &&
        _DAB_SETUPOPERATIONMASK_b1_reserved == rhs._DAB_SETUPOPERATIONMASK_b1_reserved);
}

inline bool T_b32_DAB_SetupMask::operator != (const T_b32_DAB_SetupMask& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_DAB_SetupMask::operator < (const T_b32_DAB_SetupMask& rhs) const {
    if (getDAB_SETUPOPERATIONMASK_b0_reserved() < rhs.getDAB_SETUPOPERATIONMASK_b0_reserved()) return true;
    if (getDAB_SETUPOPERATIONMASK_b0_reserved() > rhs.getDAB_SETUPOPERATIONMASK_b0_reserved()) return false;

    if (getDAB_SETUPOPERATIONMASK_b1_reserved() < rhs.getDAB_SETUPOPERATIONMASK_b1_reserved()) return true;
    if (getDAB_SETUPOPERATIONMASK_b1_reserved() > rhs.getDAB_SETUPOPERATIONMASK_b1_reserved()) return false;

    return false;
}

inline bool T_b32_DAB_SetupMask::operator > (const T_b32_DAB_SetupMask& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_DAB_SetupMask::setDAB_SETUPOPERATIONMASK_b0_reserved (bool DAB_SETUPOPERATIONMASK_b0_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPOPERATIONMASK_b0_reserved = DAB_SETUPOPERATIONMASK_b0_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_DAB_SetupMask::getDAB_SETUPOPERATIONMASK_b0_reserved () const {
    return _DAB_SETUPOPERATIONMASK_b0_reserved;
}

inline void T_b32_DAB_SetupMask::setDAB_SETUPOPERATIONMASK_b1_reserved (bool DAB_SETUPOPERATIONMASK_b1_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPOPERATIONMASK_b1_reserved = DAB_SETUPOPERATIONMASK_b1_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_DAB_SetupMask::getDAB_SETUPOPERATIONMASK_b1_reserved () const {
    return _DAB_SETUPOPERATIONMASK_b1_reserved;
}

inline  T_b32_DAB_SetupFlags::T_b32_DAB_SetupFlags ()  :
    _DAB_SETUPOPERATION_SWITCHON_b0_reserved (false),
    _DAB_SETUPOPERATION_SWITCHON_b1_reserved (false)
{
}

inline  T_b32_DAB_SetupFlags::T_b32_DAB_SetupFlags (const T_b32_DAB_SetupFlags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_DAB_SetupFlags::T_b32_DAB_SetupFlags (bool DAB_SETUPOPERATION_SWITCHON_b0_reserved, bool DAB_SETUPOPERATION_SWITCHON_b1_reserved) :
    _DAB_SETUPOPERATION_SWITCHON_b0_reserved (DAB_SETUPOPERATION_SWITCHON_b0_reserved),
    _DAB_SETUPOPERATION_SWITCHON_b1_reserved (DAB_SETUPOPERATION_SWITCHON_b1_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_DAB_SetupFlags& T_b32_DAB_SetupFlags::operator = (const T_b32_DAB_SetupFlags& rhs) {
    if( this != &rhs ) {
        _DAB_SETUPOPERATION_SWITCHON_b0_reserved = rhs._DAB_SETUPOPERATION_SWITCHON_b0_reserved;
        _DAB_SETUPOPERATION_SWITCHON_b1_reserved = rhs._DAB_SETUPOPERATION_SWITCHON_b1_reserved;
    }
    return *this;
}

inline bool T_b32_DAB_SetupFlags::operator == (const T_b32_DAB_SetupFlags& rhs) const {
    return (_DAB_SETUPOPERATION_SWITCHON_b0_reserved == rhs._DAB_SETUPOPERATION_SWITCHON_b0_reserved &&
        _DAB_SETUPOPERATION_SWITCHON_b1_reserved == rhs._DAB_SETUPOPERATION_SWITCHON_b1_reserved);
}

inline bool T_b32_DAB_SetupFlags::operator != (const T_b32_DAB_SetupFlags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_DAB_SetupFlags::operator < (const T_b32_DAB_SetupFlags& rhs) const {
    if (getDAB_SETUPOPERATION_SWITCHON_b0_reserved() < rhs.getDAB_SETUPOPERATION_SWITCHON_b0_reserved()) return true;
    if (getDAB_SETUPOPERATION_SWITCHON_b0_reserved() > rhs.getDAB_SETUPOPERATION_SWITCHON_b0_reserved()) return false;

    if (getDAB_SETUPOPERATION_SWITCHON_b1_reserved() < rhs.getDAB_SETUPOPERATION_SWITCHON_b1_reserved()) return true;
    if (getDAB_SETUPOPERATION_SWITCHON_b1_reserved() > rhs.getDAB_SETUPOPERATION_SWITCHON_b1_reserved()) return false;

    return false;
}

inline bool T_b32_DAB_SetupFlags::operator > (const T_b32_DAB_SetupFlags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_DAB_SetupFlags::setDAB_SETUPOPERATION_SWITCHON_b0_reserved (bool DAB_SETUPOPERATION_SWITCHON_b0_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPOPERATION_SWITCHON_b0_reserved = DAB_SETUPOPERATION_SWITCHON_b0_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_DAB_SetupFlags::getDAB_SETUPOPERATION_SWITCHON_b0_reserved () const {
    return _DAB_SETUPOPERATION_SWITCHON_b0_reserved;
}

inline void T_b32_DAB_SetupFlags::setDAB_SETUPOPERATION_SWITCHON_b1_reserved (bool DAB_SETUPOPERATION_SWITCHON_b1_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPOPERATION_SWITCHON_b1_reserved = DAB_SETUPOPERATION_SWITCHON_b1_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_DAB_SetupFlags::getDAB_SETUPOPERATION_SWITCHON_b1_reserved () const {
    return _DAB_SETUPOPERATION_SWITCHON_b1_reserved;
}

inline  T_b8_DAB_LinkingSetupMask::T_b8_DAB_LinkingSetupMask ()  :
    _DAB_SETUPLINKING_TH_NONE (false),
    _DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH (false),
    _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH (false),
    _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME (false),
    _DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY (false)
{
}

inline  T_b8_DAB_LinkingSetupMask::T_b8_DAB_LinkingSetupMask (const T_b8_DAB_LinkingSetupMask &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_DAB_LinkingSetupMask::T_b8_DAB_LinkingSetupMask (bool DAB_SETUPLINKING_TH_NONE, bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH, bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH, bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME, bool DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY) :
    _DAB_SETUPLINKING_TH_NONE (DAB_SETUPLINKING_TH_NONE),
    _DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH (DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH),
    _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH (DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH),
    _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME (DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME),
    _DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY (DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_DAB_LinkingSetupMask& T_b8_DAB_LinkingSetupMask::operator = (const T_b8_DAB_LinkingSetupMask& rhs) {
    if( this != &rhs ) {
        _DAB_SETUPLINKING_TH_NONE = rhs._DAB_SETUPLINKING_TH_NONE;
        _DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH = rhs._DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH;
        _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH = rhs._DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH;
        _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME = rhs._DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME;
        _DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY = rhs._DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY;
    }
    return *this;
}

inline bool T_b8_DAB_LinkingSetupMask::operator == (const T_b8_DAB_LinkingSetupMask& rhs) const {
    return (_DAB_SETUPLINKING_TH_NONE == rhs._DAB_SETUPLINKING_TH_NONE &&
        _DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH == rhs._DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH &&
        _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH == rhs._DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH &&
        _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME == rhs._DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME &&
        _DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY == rhs._DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY);
}

inline bool T_b8_DAB_LinkingSetupMask::operator != (const T_b8_DAB_LinkingSetupMask& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_DAB_LinkingSetupMask::operator < (const T_b8_DAB_LinkingSetupMask& rhs) const {
    if (getDAB_SETUPLINKING_TH_NONE() < rhs.getDAB_SETUPLINKING_TH_NONE()) return true;
    if (getDAB_SETUPLINKING_TH_NONE() > rhs.getDAB_SETUPLINKING_TH_NONE()) return false;

    if (getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH() < rhs.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH()) return true;
    if (getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH() > rhs.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH()) return false;

    if (getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH() < rhs.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH()) return true;
    if (getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH() > rhs.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH()) return false;

    if (getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME() < rhs.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME()) return true;
    if (getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME() > rhs.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME()) return false;

    if (getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY() < rhs.getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY()) return true;
    if (getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY() > rhs.getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY()) return false;

    return false;
}

inline bool T_b8_DAB_LinkingSetupMask::operator > (const T_b8_DAB_LinkingSetupMask& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_DAB_LinkingSetupMask::setDAB_SETUPLINKING_TH_NONE (bool DAB_SETUPLINKING_TH_NONE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPLINKING_TH_NONE = DAB_SETUPLINKING_TH_NONE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_LinkingSetupMask::getDAB_SETUPLINKING_TH_NONE () const {
    return _DAB_SETUPLINKING_TH_NONE;
}

inline void T_b8_DAB_LinkingSetupMask::setDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH (bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH = DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_LinkingSetupMask::getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH () const {
    return _DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH;
}

inline void T_b8_DAB_LinkingSetupMask::setDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH (bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH = DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_LinkingSetupMask::getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH () const {
    return _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH;
}

inline void T_b8_DAB_LinkingSetupMask::setDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME (bool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME = DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_LinkingSetupMask::getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME () const {
    return _DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME;
}

inline void T_b8_DAB_LinkingSetupMask::setDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY (bool DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY = DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_LinkingSetupMask::getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY () const {
    return _DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY;
}

inline  T_b8_DAB_ExtServFollowingFlags::T_b8_DAB_ExtServFollowingFlags ()  :
    _DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION (false),
    _DAB_EXTSERVFOLLOWING_SWITCH_DONE (false),
    _DAB_EXTSERVFOLLOWING_SWITCH_REJECTED (false)
{
}

inline  T_b8_DAB_ExtServFollowingFlags::T_b8_DAB_ExtServFollowingFlags (const T_b8_DAB_ExtServFollowingFlags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_DAB_ExtServFollowingFlags::T_b8_DAB_ExtServFollowingFlags (bool DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION, bool DAB_EXTSERVFOLLOWING_SWITCH_DONE, bool DAB_EXTSERVFOLLOWING_SWITCH_REJECTED) :
    _DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION (DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION),
    _DAB_EXTSERVFOLLOWING_SWITCH_DONE (DAB_EXTSERVFOLLOWING_SWITCH_DONE),
    _DAB_EXTSERVFOLLOWING_SWITCH_REJECTED (DAB_EXTSERVFOLLOWING_SWITCH_REJECTED)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_DAB_ExtServFollowingFlags& T_b8_DAB_ExtServFollowingFlags::operator = (const T_b8_DAB_ExtServFollowingFlags& rhs) {
    if( this != &rhs ) {
        _DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION = rhs._DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION;
        _DAB_EXTSERVFOLLOWING_SWITCH_DONE = rhs._DAB_EXTSERVFOLLOWING_SWITCH_DONE;
        _DAB_EXTSERVFOLLOWING_SWITCH_REJECTED = rhs._DAB_EXTSERVFOLLOWING_SWITCH_REJECTED;
    }
    return *this;
}

inline bool T_b8_DAB_ExtServFollowingFlags::operator == (const T_b8_DAB_ExtServFollowingFlags& rhs) const {
    return (_DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION == rhs._DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION &&
        _DAB_EXTSERVFOLLOWING_SWITCH_DONE == rhs._DAB_EXTSERVFOLLOWING_SWITCH_DONE &&
        _DAB_EXTSERVFOLLOWING_SWITCH_REJECTED == rhs._DAB_EXTSERVFOLLOWING_SWITCH_REJECTED);
}

inline bool T_b8_DAB_ExtServFollowingFlags::operator != (const T_b8_DAB_ExtServFollowingFlags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_DAB_ExtServFollowingFlags::operator < (const T_b8_DAB_ExtServFollowingFlags& rhs) const {
    if (getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION() < rhs.getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION()) return true;
    if (getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION() > rhs.getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION()) return false;

    if (getDAB_EXTSERVFOLLOWING_SWITCH_DONE() < rhs.getDAB_EXTSERVFOLLOWING_SWITCH_DONE()) return true;
    if (getDAB_EXTSERVFOLLOWING_SWITCH_DONE() > rhs.getDAB_EXTSERVFOLLOWING_SWITCH_DONE()) return false;

    if (getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED() < rhs.getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED()) return true;
    if (getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED() > rhs.getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED()) return false;

    return false;
}

inline bool T_b8_DAB_ExtServFollowingFlags::operator > (const T_b8_DAB_ExtServFollowingFlags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_DAB_ExtServFollowingFlags::setDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION (bool DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION = DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ExtServFollowingFlags::getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION () const {
    return _DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION;
}

inline void T_b8_DAB_ExtServFollowingFlags::setDAB_EXTSERVFOLLOWING_SWITCH_DONE (bool DAB_EXTSERVFOLLOWING_SWITCH_DONE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_EXTSERVFOLLOWING_SWITCH_DONE = DAB_EXTSERVFOLLOWING_SWITCH_DONE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ExtServFollowingFlags::getDAB_EXTSERVFOLLOWING_SWITCH_DONE () const {
    return _DAB_EXTSERVFOLLOWING_SWITCH_DONE;
}

inline void T_b8_DAB_ExtServFollowingFlags::setDAB_EXTSERVFOLLOWING_SWITCH_REJECTED (bool DAB_EXTSERVFOLLOWING_SWITCH_REJECTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_EXTSERVFOLLOWING_SWITCH_REJECTED = DAB_EXTSERVFOLLOWING_SWITCH_REJECTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ExtServFollowingFlags::getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED () const {
    return _DAB_EXTSERVFOLLOWING_SWITCH_REJECTED;
}

inline  T_DAB_PresetListElement::T_DAB_PresetListElement ()  :
    _u8PresetElementID (0u),
    _u32ServiceID (0u),
    _ServiceLabel (),
    _u32Frequency (0u),
    _u8Scid (0u),
    _ComponentLabel (),
    _u32EnsembleId (0u),
    _EnsembleLabel (),
    _sLogoLink ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_PresetListElement::T_DAB_PresetListElement (const T_DAB_PresetListElement &rhs)  :
    _u8PresetElementID (0u),
    _u32ServiceID (0u),
    _ServiceLabel (),
    _u32Frequency (0u),
    _u8Scid (0u),
    _ComponentLabel (),
    _u32EnsembleId (0u),
    _EnsembleLabel (),
    _sLogoLink ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_PresetListElement::T_DAB_PresetListElement (uint8 u8PresetElementID_, uint32 u32ServiceID_, const T_DAB_Label& ServiceLabel_, uint32 u32Frequency_, uint8 u8Scid_, const T_DAB_Label& ComponentLabel_, uint32 u32EnsembleId_, const T_DAB_Label& EnsembleLabel_, const ::std::string& sLogoLink_)  :
    _u8PresetElementID (u8PresetElementID_),
    _u32ServiceID (u32ServiceID_),
    _ServiceLabel (ServiceLabel_),
    _u32Frequency (u32Frequency_),
    _u8Scid (u8Scid_),
    _ComponentLabel (ComponentLabel_),
    _u32EnsembleId (u32EnsembleId_),
    _EnsembleLabel (EnsembleLabel_),
    _sLogoLink (sLogoLink_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_PresetListElement::~T_DAB_PresetListElement() {
}

inline T_DAB_PresetListElement& T_DAB_PresetListElement::operator = (const T_DAB_PresetListElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8PresetElementID()) {
            setU8PresetElementID(rhs.getU8PresetElementID());
        } else {
            clearU8PresetElementID();
        }
        if (rhs.hasU32ServiceID()) {
            setU32ServiceID(rhs.getU32ServiceID());
        } else {
            clearU32ServiceID();
        }
        if (rhs.hasServiceLabel()) {
            setServiceLabel(rhs.getServiceLabel());
        } else {
            clearServiceLabel();
        }
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
        if (rhs.hasU8Scid()) {
            setU8Scid(rhs.getU8Scid());
        } else {
            clearU8Scid();
        }
        if (rhs.hasComponentLabel()) {
            setComponentLabel(rhs.getComponentLabel());
        } else {
            clearComponentLabel();
        }
        if (rhs.hasU32EnsembleId()) {
            setU32EnsembleId(rhs.getU32EnsembleId());
        } else {
            clearU32EnsembleId();
        }
        if (rhs.hasEnsembleLabel()) {
            setEnsembleLabel(rhs.getEnsembleLabel());
        } else {
            clearEnsembleLabel();
        }
        if (rhs.hasSLogoLink()) {
            setSLogoLink(rhs.getSLogoLink());
        } else {
            clearSLogoLink();
        }
    }
    return *this;
}

inline bool T_DAB_PresetListElement::operator == (const T_DAB_PresetListElement& rhs) const {
    return (((!hasU8PresetElementID() && !rhs.hasU8PresetElementID()) || getU8PresetElementID() == rhs.getU8PresetElementID()) &&
        ((!hasU32ServiceID() && !rhs.hasU32ServiceID()) || getU32ServiceID() == rhs.getU32ServiceID()) &&
        ((!hasServiceLabel() && !rhs.hasServiceLabel()) || getServiceLabel() == rhs.getServiceLabel()) &&
        ((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()) &&
        ((!hasU8Scid() && !rhs.hasU8Scid()) || getU8Scid() == rhs.getU8Scid()) &&
        ((!hasComponentLabel() && !rhs.hasComponentLabel()) || getComponentLabel() == rhs.getComponentLabel()) &&
        ((!hasU32EnsembleId() && !rhs.hasU32EnsembleId()) || getU32EnsembleId() == rhs.getU32EnsembleId()) &&
        ((!hasEnsembleLabel() && !rhs.hasEnsembleLabel()) || getEnsembleLabel() == rhs.getEnsembleLabel()) &&
        ((!hasSLogoLink() && !rhs.hasSLogoLink()) || getSLogoLink() == rhs.getSLogoLink()));
}

inline bool T_DAB_PresetListElement::operator != (const T_DAB_PresetListElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_PresetListElement::operator < (const T_DAB_PresetListElement& rhs) const {
    if (hasU8PresetElementID() || rhs.hasU8PresetElementID()) {
        if (getU8PresetElementID() < rhs.getU8PresetElementID()) return true;
        if (getU8PresetElementID() > rhs.getU8PresetElementID()) return false;
    }
    if (hasU32ServiceID() || rhs.hasU32ServiceID()) {
        if (getU32ServiceID() < rhs.getU32ServiceID()) return true;
        if (getU32ServiceID() > rhs.getU32ServiceID()) return false;
    }
    if (hasServiceLabel() || rhs.hasServiceLabel()) {
        if (getServiceLabel() < rhs.getServiceLabel()) return true;
        if (getServiceLabel() > rhs.getServiceLabel()) return false;
    }
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    if (hasU8Scid() || rhs.hasU8Scid()) {
        if (getU8Scid() < rhs.getU8Scid()) return true;
        if (getU8Scid() > rhs.getU8Scid()) return false;
    }
    if (hasComponentLabel() || rhs.hasComponentLabel()) {
        if (getComponentLabel() < rhs.getComponentLabel()) return true;
        if (getComponentLabel() > rhs.getComponentLabel()) return false;
    }
    if (hasU32EnsembleId() || rhs.hasU32EnsembleId()) {
        if (getU32EnsembleId() < rhs.getU32EnsembleId()) return true;
        if (getU32EnsembleId() > rhs.getU32EnsembleId()) return false;
    }
    if (hasEnsembleLabel() || rhs.hasEnsembleLabel()) {
        if (getEnsembleLabel() < rhs.getEnsembleLabel()) return true;
        if (getEnsembleLabel() > rhs.getEnsembleLabel()) return false;
    }
    if (hasSLogoLink() || rhs.hasSLogoLink()) {
        if (getSLogoLink() < rhs.getSLogoLink()) return true;
        if (getSLogoLink() > rhs.getSLogoLink()) return false;
    }
    return false;
}

inline bool T_DAB_PresetListElement::operator > (const T_DAB_PresetListElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_PresetListElement::clear() {
    clearU8PresetElementID();
    clearU32ServiceID();
    clearServiceLabel();
    clearU32Frequency();
    clearU8Scid();
    clearComponentLabel();
    clearU32EnsembleId();
    clearEnsembleLabel();
    clearSLogoLink();
}

inline void T_DAB_PresetListElement::clearU8PresetElementID() {
    if (hasU8PresetElementID()) {
         clear_has_u8PresetElementID();
        _u8PresetElementID = 0u;
     }
}

inline bool T_DAB_PresetListElement::hasU8PresetElementID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_DAB_PresetListElement::getU8PresetElementID () const {
    return _u8PresetElementID;
}

inline void T_DAB_PresetListElement::setU8PresetElementID (uint8 u8PresetElementID_) {
    set_has_u8PresetElementID();
    this->_u8PresetElementID = u8PresetElementID_;
}

inline void T_DAB_PresetListElement::clearU32ServiceID() {
    if (hasU32ServiceID()) {
         clear_has_u32ServiceID();
        _u32ServiceID = 0u;
     }
}

inline bool T_DAB_PresetListElement::hasU32ServiceID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_DAB_PresetListElement::getU32ServiceID () const {
    return _u32ServiceID;
}

inline void T_DAB_PresetListElement::setU32ServiceID (uint32 u32ServiceID_) {
    set_has_u32ServiceID();
    this->_u32ServiceID = u32ServiceID_;
}

inline void T_DAB_PresetListElement::clearServiceLabel() {
    if (hasServiceLabel()) {
         clear_has_ServiceLabel();
        _ServiceLabel.clear();
     }
}

inline bool T_DAB_PresetListElement::hasServiceLabel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_DAB_Label& T_DAB_PresetListElement::getServiceLabel () const {
    return _ServiceLabel;
}

inline T_DAB_Label& T_DAB_PresetListElement::getServiceLabelMutable () {
    set_has_ServiceLabel();
    return _ServiceLabel;
}

inline void T_DAB_PresetListElement::setServiceLabel (const T_DAB_Label& ServiceLabel_) {
    set_has_ServiceLabel();
    this->_ServiceLabel = ServiceLabel_;
}

inline void T_DAB_PresetListElement::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool T_DAB_PresetListElement::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_DAB_PresetListElement::getU32Frequency () const {
    return _u32Frequency;
}

inline void T_DAB_PresetListElement::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void T_DAB_PresetListElement::clearU8Scid() {
    if (hasU8Scid()) {
         clear_has_u8Scid();
        _u8Scid = 0u;
     }
}

inline bool T_DAB_PresetListElement::hasU8Scid () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_PresetListElement::getU8Scid () const {
    return _u8Scid;
}

inline void T_DAB_PresetListElement::setU8Scid (uint8 u8Scid_) {
    set_has_u8Scid();
    this->_u8Scid = u8Scid_;
}

inline void T_DAB_PresetListElement::clearComponentLabel() {
    if (hasComponentLabel()) {
         clear_has_ComponentLabel();
        _ComponentLabel.clear();
     }
}

inline bool T_DAB_PresetListElement::hasComponentLabel () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_DAB_Label& T_DAB_PresetListElement::getComponentLabel () const {
    return _ComponentLabel;
}

inline T_DAB_Label& T_DAB_PresetListElement::getComponentLabelMutable () {
    set_has_ComponentLabel();
    return _ComponentLabel;
}

inline void T_DAB_PresetListElement::setComponentLabel (const T_DAB_Label& ComponentLabel_) {
    set_has_ComponentLabel();
    this->_ComponentLabel = ComponentLabel_;
}

inline void T_DAB_PresetListElement::clearU32EnsembleId() {
    if (hasU32EnsembleId()) {
         clear_has_u32EnsembleId();
        _u32EnsembleId = 0u;
     }
}

inline bool T_DAB_PresetListElement::hasU32EnsembleId () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_DAB_PresetListElement::getU32EnsembleId () const {
    return _u32EnsembleId;
}

inline void T_DAB_PresetListElement::setU32EnsembleId (uint32 u32EnsembleId_) {
    set_has_u32EnsembleId();
    this->_u32EnsembleId = u32EnsembleId_;
}

inline void T_DAB_PresetListElement::clearEnsembleLabel() {
    if (hasEnsembleLabel()) {
         clear_has_EnsembleLabel();
        _EnsembleLabel.clear();
     }
}

inline bool T_DAB_PresetListElement::hasEnsembleLabel () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const T_DAB_Label& T_DAB_PresetListElement::getEnsembleLabel () const {
    return _EnsembleLabel;
}

inline T_DAB_Label& T_DAB_PresetListElement::getEnsembleLabelMutable () {
    set_has_EnsembleLabel();
    return _EnsembleLabel;
}

inline void T_DAB_PresetListElement::setEnsembleLabel (const T_DAB_Label& EnsembleLabel_) {
    set_has_EnsembleLabel();
    this->_EnsembleLabel = EnsembleLabel_;
}

inline void T_DAB_PresetListElement::clearSLogoLink() {
    if (hasSLogoLink()) {
         clear_has_sLogoLink();
        _sLogoLink.clear();
     }
}

inline bool T_DAB_PresetListElement::hasSLogoLink () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_DAB_PresetListElement::getSLogoLink () const {
    return _sLogoLink;
}

inline ::std::string& T_DAB_PresetListElement::getSLogoLinkMutable () {
    set_has_sLogoLink();
    return _sLogoLink;
}

inline void T_DAB_PresetListElement::setSLogoLink (const ::std::string& sLogoLink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink = sLogoLink_;
}

inline void T_DAB_PresetListElement::setSLogoLink (const char* sLogoLink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink.assign(sLogoLink_);
}

inline void T_DAB_PresetListElement::setSLogoLink (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink.assign(value, size);
}

inline void T_DAB_PresetListElement::set_has_u8PresetElementID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_PresetListElement::clear_has_u8PresetElementID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_PresetListElement::set_has_u32ServiceID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_PresetListElement::clear_has_u32ServiceID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_PresetListElement::set_has_ServiceLabel () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_PresetListElement::clear_has_ServiceLabel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_PresetListElement::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_PresetListElement::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_PresetListElement::set_has_u8Scid () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_PresetListElement::clear_has_u8Scid () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_PresetListElement::set_has_ComponentLabel () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_PresetListElement::clear_has_ComponentLabel () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_PresetListElement::set_has_u32EnsembleId () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_PresetListElement::clear_has_u32EnsembleId () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_PresetListElement::set_has_EnsembleLabel () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_PresetListElement::clear_has_EnsembleLabel () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_PresetListElement::set_has_sLogoLink () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_PresetListElement::clear_has_sLogoLink () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_DAB_ChnListElement::T_DAB_ChnListElement ()  :
    _u16ListElementID (0u),
    _u32DABId (0u),
    _u8CompScids (0u),
    _Label (),
    _EnsembleLabel (),
    _sFreqLabel (),
    _u8PresetListElemId (0u),
    _u8PTY (0u),
    _u16ASU (0u),
    _bReception (false),
    _u8NumberOfComponents (0u),
    _u8ServiceLinkMode (0u),
    _sLogoLink (),
    _bEPGSupport (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_ChnListElement::T_DAB_ChnListElement (const T_DAB_ChnListElement &rhs)  :
    _u16ListElementID (0u),
    _u32DABId (0u),
    _u8CompScids (0u),
    _Label (),
    _EnsembleLabel (),
    _sFreqLabel (),
    _u8PresetListElemId (0u),
    _u8PTY (0u),
    _u16ASU (0u),
    _bReception (false),
    _u8NumberOfComponents (0u),
    _u8ServiceLinkMode (0u),
    _sLogoLink (),
    _bEPGSupport (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_ChnListElement::T_DAB_ChnListElement (uint16 u16ListElementID_, uint32 u32DABId_, uint8 u8CompScids_, const T_DAB_Label& Label_, const T_DAB_Label& EnsembleLabel_, const ::std::string& sFreqLabel_, uint8 u8PresetListElemId_, uint8 u8PTY_, uint16 u16ASU_, bool bReception_, uint8 u8NumberOfComponents_, uint8 u8ServiceLinkMode_, const ::std::string& sLogoLink_, uint8 bEPGSupport_)  :
    _u16ListElementID (u16ListElementID_),
    _u32DABId (u32DABId_),
    _u8CompScids (u8CompScids_),
    _Label (Label_),
    _EnsembleLabel (EnsembleLabel_),
    _sFreqLabel (sFreqLabel_),
    _u8PresetListElemId (u8PresetListElemId_),
    _u8PTY (u8PTY_),
    _u16ASU (u16ASU_),
    _bReception (bReception_),
    _u8NumberOfComponents (u8NumberOfComponents_),
    _u8ServiceLinkMode (u8ServiceLinkMode_),
    _sLogoLink (sLogoLink_),
    _bEPGSupport (bEPGSupport_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_ChnListElement::~T_DAB_ChnListElement() {
}

inline T_DAB_ChnListElement& T_DAB_ChnListElement::operator = (const T_DAB_ChnListElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ListElementID()) {
            setU16ListElementID(rhs.getU16ListElementID());
        } else {
            clearU16ListElementID();
        }
        if (rhs.hasU32DABId()) {
            setU32DABId(rhs.getU32DABId());
        } else {
            clearU32DABId();
        }
        if (rhs.hasU8CompScids()) {
            setU8CompScids(rhs.getU8CompScids());
        } else {
            clearU8CompScids();
        }
        if (rhs.hasLabel()) {
            setLabel(rhs.getLabel());
        } else {
            clearLabel();
        }
        if (rhs.hasEnsembleLabel()) {
            setEnsembleLabel(rhs.getEnsembleLabel());
        } else {
            clearEnsembleLabel();
        }
        if (rhs.hasSFreqLabel()) {
            setSFreqLabel(rhs.getSFreqLabel());
        } else {
            clearSFreqLabel();
        }
        if (rhs.hasU8PresetListElemId()) {
            setU8PresetListElemId(rhs.getU8PresetListElemId());
        } else {
            clearU8PresetListElemId();
        }
        if (rhs.hasU8PTY()) {
            setU8PTY(rhs.getU8PTY());
        } else {
            clearU8PTY();
        }
        if (rhs.hasU16ASU()) {
            setU16ASU(rhs.getU16ASU());
        } else {
            clearU16ASU();
        }
        if (rhs.hasBReception()) {
            setBReception(rhs.getBReception());
        } else {
            clearBReception();
        }
        if (rhs.hasU8NumberOfComponents()) {
            setU8NumberOfComponents(rhs.getU8NumberOfComponents());
        } else {
            clearU8NumberOfComponents();
        }
        if (rhs.hasU8ServiceLinkMode()) {
            setU8ServiceLinkMode(rhs.getU8ServiceLinkMode());
        } else {
            clearU8ServiceLinkMode();
        }
        if (rhs.hasSLogoLink()) {
            setSLogoLink(rhs.getSLogoLink());
        } else {
            clearSLogoLink();
        }
        if (rhs.hasBEPGSupport()) {
            setBEPGSupport(rhs.getBEPGSupport());
        } else {
            clearBEPGSupport();
        }
    }
    return *this;
}

inline bool T_DAB_ChnListElement::operator == (const T_DAB_ChnListElement& rhs) const {
    return (((!hasU16ListElementID() && !rhs.hasU16ListElementID()) || getU16ListElementID() == rhs.getU16ListElementID()) &&
        ((!hasU32DABId() && !rhs.hasU32DABId()) || getU32DABId() == rhs.getU32DABId()) &&
        ((!hasU8CompScids() && !rhs.hasU8CompScids()) || getU8CompScids() == rhs.getU8CompScids()) &&
        ((!hasLabel() && !rhs.hasLabel()) || getLabel() == rhs.getLabel()) &&
        ((!hasEnsembleLabel() && !rhs.hasEnsembleLabel()) || getEnsembleLabel() == rhs.getEnsembleLabel()) &&
        ((!hasSFreqLabel() && !rhs.hasSFreqLabel()) || getSFreqLabel() == rhs.getSFreqLabel()) &&
        ((!hasU8PresetListElemId() && !rhs.hasU8PresetListElemId()) || getU8PresetListElemId() == rhs.getU8PresetListElemId()) &&
        ((!hasU8PTY() && !rhs.hasU8PTY()) || getU8PTY() == rhs.getU8PTY()) &&
        ((!hasU16ASU() && !rhs.hasU16ASU()) || getU16ASU() == rhs.getU16ASU()) &&
        ((!hasBReception() && !rhs.hasBReception()) || getBReception() == rhs.getBReception()) &&
        ((!hasU8NumberOfComponents() && !rhs.hasU8NumberOfComponents()) || getU8NumberOfComponents() == rhs.getU8NumberOfComponents()) &&
        ((!hasU8ServiceLinkMode() && !rhs.hasU8ServiceLinkMode()) || getU8ServiceLinkMode() == rhs.getU8ServiceLinkMode()) &&
        ((!hasSLogoLink() && !rhs.hasSLogoLink()) || getSLogoLink() == rhs.getSLogoLink()) &&
        ((!hasBEPGSupport() && !rhs.hasBEPGSupport()) || getBEPGSupport() == rhs.getBEPGSupport()));
}

inline bool T_DAB_ChnListElement::operator != (const T_DAB_ChnListElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_ChnListElement::operator < (const T_DAB_ChnListElement& rhs) const {
    if (hasU16ListElementID() || rhs.hasU16ListElementID()) {
        if (getU16ListElementID() < rhs.getU16ListElementID()) return true;
        if (getU16ListElementID() > rhs.getU16ListElementID()) return false;
    }
    if (hasU32DABId() || rhs.hasU32DABId()) {
        if (getU32DABId() < rhs.getU32DABId()) return true;
        if (getU32DABId() > rhs.getU32DABId()) return false;
    }
    if (hasU8CompScids() || rhs.hasU8CompScids()) {
        if (getU8CompScids() < rhs.getU8CompScids()) return true;
        if (getU8CompScids() > rhs.getU8CompScids()) return false;
    }
    if (hasLabel() || rhs.hasLabel()) {
        if (getLabel() < rhs.getLabel()) return true;
        if (getLabel() > rhs.getLabel()) return false;
    }
    if (hasEnsembleLabel() || rhs.hasEnsembleLabel()) {
        if (getEnsembleLabel() < rhs.getEnsembleLabel()) return true;
        if (getEnsembleLabel() > rhs.getEnsembleLabel()) return false;
    }
    if (hasSFreqLabel() || rhs.hasSFreqLabel()) {
        if (getSFreqLabel() < rhs.getSFreqLabel()) return true;
        if (getSFreqLabel() > rhs.getSFreqLabel()) return false;
    }
    if (hasU8PresetListElemId() || rhs.hasU8PresetListElemId()) {
        if (getU8PresetListElemId() < rhs.getU8PresetListElemId()) return true;
        if (getU8PresetListElemId() > rhs.getU8PresetListElemId()) return false;
    }
    if (hasU8PTY() || rhs.hasU8PTY()) {
        if (getU8PTY() < rhs.getU8PTY()) return true;
        if (getU8PTY() > rhs.getU8PTY()) return false;
    }
    if (hasU16ASU() || rhs.hasU16ASU()) {
        if (getU16ASU() < rhs.getU16ASU()) return true;
        if (getU16ASU() > rhs.getU16ASU()) return false;
    }
    if (hasBReception() || rhs.hasBReception()) {
        if (getBReception() < rhs.getBReception()) return true;
        if (getBReception() > rhs.getBReception()) return false;
    }
    if (hasU8NumberOfComponents() || rhs.hasU8NumberOfComponents()) {
        if (getU8NumberOfComponents() < rhs.getU8NumberOfComponents()) return true;
        if (getU8NumberOfComponents() > rhs.getU8NumberOfComponents()) return false;
    }
    if (hasU8ServiceLinkMode() || rhs.hasU8ServiceLinkMode()) {
        if (getU8ServiceLinkMode() < rhs.getU8ServiceLinkMode()) return true;
        if (getU8ServiceLinkMode() > rhs.getU8ServiceLinkMode()) return false;
    }
    if (hasSLogoLink() || rhs.hasSLogoLink()) {
        if (getSLogoLink() < rhs.getSLogoLink()) return true;
        if (getSLogoLink() > rhs.getSLogoLink()) return false;
    }
    if (hasBEPGSupport() || rhs.hasBEPGSupport()) {
        if (getBEPGSupport() < rhs.getBEPGSupport()) return true;
        if (getBEPGSupport() > rhs.getBEPGSupport()) return false;
    }
    return false;
}

inline bool T_DAB_ChnListElement::operator > (const T_DAB_ChnListElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_ChnListElement::clear() {
    clearU16ListElementID();
    clearU32DABId();
    clearU8CompScids();
    clearLabel();
    clearEnsembleLabel();
    clearSFreqLabel();
    clearU8PresetListElemId();
    clearU8PTY();
    clearU16ASU();
    clearBReception();
    clearU8NumberOfComponents();
    clearU8ServiceLinkMode();
    clearSLogoLink();
    clearBEPGSupport();
}

inline void T_DAB_ChnListElement::clearU16ListElementID() {
    if (hasU16ListElementID()) {
         clear_has_u16ListElementID();
        _u16ListElementID = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasU16ListElementID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_DAB_ChnListElement::getU16ListElementID () const {
    return _u16ListElementID;
}

inline void T_DAB_ChnListElement::setU16ListElementID (uint16 u16ListElementID_) {
    set_has_u16ListElementID();
    this->_u16ListElementID = u16ListElementID_;
}

inline void T_DAB_ChnListElement::clearU32DABId() {
    if (hasU32DABId()) {
         clear_has_u32DABId();
        _u32DABId = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasU32DABId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_DAB_ChnListElement::getU32DABId () const {
    return _u32DABId;
}

inline void T_DAB_ChnListElement::setU32DABId (uint32 u32DABId_) {
    set_has_u32DABId();
    this->_u32DABId = u32DABId_;
}

inline void T_DAB_ChnListElement::clearU8CompScids() {
    if (hasU8CompScids()) {
         clear_has_u8CompScids();
        _u8CompScids = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasU8CompScids () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_DAB_ChnListElement::getU8CompScids () const {
    return _u8CompScids;
}

inline void T_DAB_ChnListElement::setU8CompScids (uint8 u8CompScids_) {
    set_has_u8CompScids();
    this->_u8CompScids = u8CompScids_;
}

inline void T_DAB_ChnListElement::clearLabel() {
    if (hasLabel()) {
         clear_has_Label();
        _Label.clear();
     }
}

inline bool T_DAB_ChnListElement::hasLabel () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_DAB_Label& T_DAB_ChnListElement::getLabel () const {
    return _Label;
}

inline T_DAB_Label& T_DAB_ChnListElement::getLabelMutable () {
    set_has_Label();
    return _Label;
}

inline void T_DAB_ChnListElement::setLabel (const T_DAB_Label& Label_) {
    set_has_Label();
    this->_Label = Label_;
}

inline void T_DAB_ChnListElement::clearEnsembleLabel() {
    if (hasEnsembleLabel()) {
         clear_has_EnsembleLabel();
        _EnsembleLabel.clear();
     }
}

inline bool T_DAB_ChnListElement::hasEnsembleLabel () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_DAB_Label& T_DAB_ChnListElement::getEnsembleLabel () const {
    return _EnsembleLabel;
}

inline T_DAB_Label& T_DAB_ChnListElement::getEnsembleLabelMutable () {
    set_has_EnsembleLabel();
    return _EnsembleLabel;
}

inline void T_DAB_ChnListElement::setEnsembleLabel (const T_DAB_Label& EnsembleLabel_) {
    set_has_EnsembleLabel();
    this->_EnsembleLabel = EnsembleLabel_;
}

inline void T_DAB_ChnListElement::clearSFreqLabel() {
    if (hasSFreqLabel()) {
         clear_has_sFreqLabel();
        _sFreqLabel.clear();
     }
}

inline bool T_DAB_ChnListElement::hasSFreqLabel () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_DAB_ChnListElement::getSFreqLabel () const {
    return _sFreqLabel;
}

inline ::std::string& T_DAB_ChnListElement::getSFreqLabelMutable () {
    set_has_sFreqLabel();
    return _sFreqLabel;
}

inline void T_DAB_ChnListElement::setSFreqLabel (const ::std::string& sFreqLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel = sFreqLabel_;
}

inline void T_DAB_ChnListElement::setSFreqLabel (const char* sFreqLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel.assign(sFreqLabel_);
}

inline void T_DAB_ChnListElement::setSFreqLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel.assign(value, size);
}

inline void T_DAB_ChnListElement::clearU8PresetListElemId() {
    if (hasU8PresetListElemId()) {
         clear_has_u8PresetListElemId();
        _u8PresetListElemId = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasU8PresetListElemId () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_DAB_ChnListElement::getU8PresetListElemId () const {
    return _u8PresetListElemId;
}

inline void T_DAB_ChnListElement::setU8PresetListElemId (uint8 u8PresetListElemId_) {
    set_has_u8PresetListElemId();
    this->_u8PresetListElemId = u8PresetListElemId_;
}

inline void T_DAB_ChnListElement::clearU8PTY() {
    if (hasU8PTY()) {
         clear_has_u8PTY();
        _u8PTY = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasU8PTY () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_DAB_ChnListElement::getU8PTY () const {
    return _u8PTY;
}

inline void T_DAB_ChnListElement::setU8PTY (uint8 u8PTY_) {
    set_has_u8PTY();
    this->_u8PTY = u8PTY_;
}

inline void T_DAB_ChnListElement::clearU16ASU() {
    if (hasU16ASU()) {
         clear_has_u16ASU();
        _u16ASU = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasU16ASU () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint16 T_DAB_ChnListElement::getU16ASU () const {
    return _u16ASU;
}

inline void T_DAB_ChnListElement::setU16ASU (uint16 u16ASU_) {
    set_has_u16ASU();
    this->_u16ASU = u16ASU_;
}

inline void T_DAB_ChnListElement::clearBReception() {
    if (hasBReception()) {
         clear_has_bReception();
        _bReception = false;
     }
}

inline bool T_DAB_ChnListElement::hasBReception () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_DAB_ChnListElement::getBReception () const {
    return _bReception;
}

inline void T_DAB_ChnListElement::setBReception (bool bReception_) {
    set_has_bReception();
    this->_bReception = bReception_;
}

inline void T_DAB_ChnListElement::clearU8NumberOfComponents() {
    if (hasU8NumberOfComponents()) {
         clear_has_u8NumberOfComponents();
        _u8NumberOfComponents = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasU8NumberOfComponents () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 T_DAB_ChnListElement::getU8NumberOfComponents () const {
    return _u8NumberOfComponents;
}

inline void T_DAB_ChnListElement::setU8NumberOfComponents (uint8 u8NumberOfComponents_) {
    set_has_u8NumberOfComponents();
    this->_u8NumberOfComponents = u8NumberOfComponents_;
}

inline void T_DAB_ChnListElement::clearU8ServiceLinkMode() {
    if (hasU8ServiceLinkMode()) {
         clear_has_u8ServiceLinkMode();
        _u8ServiceLinkMode = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasU8ServiceLinkMode () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint8 T_DAB_ChnListElement::getU8ServiceLinkMode () const {
    return _u8ServiceLinkMode;
}

inline void T_DAB_ChnListElement::setU8ServiceLinkMode (uint8 u8ServiceLinkMode_) {
    set_has_u8ServiceLinkMode();
    this->_u8ServiceLinkMode = u8ServiceLinkMode_;
}

inline void T_DAB_ChnListElement::clearSLogoLink() {
    if (hasSLogoLink()) {
         clear_has_sLogoLink();
        _sLogoLink.clear();
     }
}

inline bool T_DAB_ChnListElement::hasSLogoLink () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_DAB_ChnListElement::getSLogoLink () const {
    return _sLogoLink;
}

inline ::std::string& T_DAB_ChnListElement::getSLogoLinkMutable () {
    set_has_sLogoLink();
    return _sLogoLink;
}

inline void T_DAB_ChnListElement::setSLogoLink (const ::std::string& sLogoLink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink = sLogoLink_;
}

inline void T_DAB_ChnListElement::setSLogoLink (const char* sLogoLink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLogoLink_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink.assign(sLogoLink_);
}

inline void T_DAB_ChnListElement::setSLogoLink (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLogoLink();
    this->_sLogoLink.assign(value, size);
}

inline void T_DAB_ChnListElement::clearBEPGSupport() {
    if (hasBEPGSupport()) {
         clear_has_bEPGSupport();
        _bEPGSupport = 0u;
     }
}

inline bool T_DAB_ChnListElement::hasBEPGSupport () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint8 T_DAB_ChnListElement::getBEPGSupport () const {
    return _bEPGSupport;
}

inline void T_DAB_ChnListElement::setBEPGSupport (uint8 bEPGSupport_) {
    set_has_bEPGSupport();
    this->_bEPGSupport = bEPGSupport_;
}

inline void T_DAB_ChnListElement::set_has_u16ListElementID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_ChnListElement::clear_has_u16ListElementID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_ChnListElement::set_has_u32DABId () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_ChnListElement::clear_has_u32DABId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_ChnListElement::set_has_u8CompScids () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_ChnListElement::clear_has_u8CompScids () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_ChnListElement::set_has_Label () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_ChnListElement::clear_has_Label () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_ChnListElement::set_has_EnsembleLabel () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_ChnListElement::clear_has_EnsembleLabel () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_ChnListElement::set_has_sFreqLabel () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_ChnListElement::clear_has_sFreqLabel () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_ChnListElement::set_has_u8PresetListElemId () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_ChnListElement::clear_has_u8PresetListElemId () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_ChnListElement::set_has_u8PTY () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_ChnListElement::clear_has_u8PTY () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_ChnListElement::set_has_u16ASU () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_ChnListElement::clear_has_u16ASU () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DAB_ChnListElement::set_has_bReception () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DAB_ChnListElement::clear_has_bReception () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DAB_ChnListElement::set_has_u8NumberOfComponents () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DAB_ChnListElement::clear_has_u8NumberOfComponents () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DAB_ChnListElement::set_has_u8ServiceLinkMode () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DAB_ChnListElement::clear_has_u8ServiceLinkMode () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_DAB_ChnListElement::set_has_sLogoLink () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_DAB_ChnListElement::clear_has_sLogoLink () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_DAB_ChnListElement::set_has_bEPGSupport () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_DAB_ChnListElement::clear_has_bEPGSupport () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline  T_DAB_ListElementAvailInfo::T_DAB_ListElementAvailInfo ()  :
    _u16ListElementID (0u),
    _bAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_ListElementAvailInfo::T_DAB_ListElementAvailInfo (const T_DAB_ListElementAvailInfo &rhs)  :
    _u16ListElementID (0u),
    _bAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_ListElementAvailInfo::T_DAB_ListElementAvailInfo (uint16 u16ListElementID_, bool bAvailable_)  :
    _u16ListElementID (u16ListElementID_),
    _bAvailable (bAvailable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_ListElementAvailInfo::~T_DAB_ListElementAvailInfo() {
}

inline T_DAB_ListElementAvailInfo& T_DAB_ListElementAvailInfo::operator = (const T_DAB_ListElementAvailInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ListElementID()) {
            setU16ListElementID(rhs.getU16ListElementID());
        } else {
            clearU16ListElementID();
        }
        if (rhs.hasBAvailable()) {
            setBAvailable(rhs.getBAvailable());
        } else {
            clearBAvailable();
        }
    }
    return *this;
}

inline bool T_DAB_ListElementAvailInfo::operator == (const T_DAB_ListElementAvailInfo& rhs) const {
    return (((!hasU16ListElementID() && !rhs.hasU16ListElementID()) || getU16ListElementID() == rhs.getU16ListElementID()) &&
        ((!hasBAvailable() && !rhs.hasBAvailable()) || getBAvailable() == rhs.getBAvailable()));
}

inline bool T_DAB_ListElementAvailInfo::operator != (const T_DAB_ListElementAvailInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_ListElementAvailInfo::operator < (const T_DAB_ListElementAvailInfo& rhs) const {
    if (hasU16ListElementID() || rhs.hasU16ListElementID()) {
        if (getU16ListElementID() < rhs.getU16ListElementID()) return true;
        if (getU16ListElementID() > rhs.getU16ListElementID()) return false;
    }
    if (hasBAvailable() || rhs.hasBAvailable()) {
        if (getBAvailable() < rhs.getBAvailable()) return true;
        if (getBAvailable() > rhs.getBAvailable()) return false;
    }
    return false;
}

inline bool T_DAB_ListElementAvailInfo::operator > (const T_DAB_ListElementAvailInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_ListElementAvailInfo::clear() {
    clearU16ListElementID();
    clearBAvailable();
}

inline void T_DAB_ListElementAvailInfo::clearU16ListElementID() {
    if (hasU16ListElementID()) {
         clear_has_u16ListElementID();
        _u16ListElementID = 0u;
     }
}

inline bool T_DAB_ListElementAvailInfo::hasU16ListElementID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_DAB_ListElementAvailInfo::getU16ListElementID () const {
    return _u16ListElementID;
}

inline void T_DAB_ListElementAvailInfo::setU16ListElementID (uint16 u16ListElementID_) {
    set_has_u16ListElementID();
    this->_u16ListElementID = u16ListElementID_;
}

inline void T_DAB_ListElementAvailInfo::clearBAvailable() {
    if (hasBAvailable()) {
         clear_has_bAvailable();
        _bAvailable = false;
     }
}

inline bool T_DAB_ListElementAvailInfo::hasBAvailable () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_DAB_ListElementAvailInfo::getBAvailable () const {
    return _bAvailable;
}

inline void T_DAB_ListElementAvailInfo::setBAvailable (bool bAvailable_) {
    set_has_bAvailable();
    this->_bAvailable = bAvailable_;
}

inline void T_DAB_ListElementAvailInfo::set_has_u16ListElementID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_ListElementAvailInfo::clear_has_u16ListElementID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_ListElementAvailInfo::set_has_bAvailable () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_ListElementAvailInfo::clear_has_bAvailable () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DAB_TIIListElement::T_DAB_TIIListElement ()  :
    _u8MainId (0u),
    _u8SubId (0u),
    _u32Latitude (0u),
    _u32Longitude (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_TIIListElement::T_DAB_TIIListElement (const T_DAB_TIIListElement &rhs)  :
    _u8MainId (0u),
    _u8SubId (0u),
    _u32Latitude (0u),
    _u32Longitude (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_TIIListElement::T_DAB_TIIListElement (uint8 u8MainId_, uint8 u8SubId_, uint32 u32Latitude_, uint32 u32Longitude_)  :
    _u8MainId (u8MainId_),
    _u8SubId (u8SubId_),
    _u32Latitude (u32Latitude_),
    _u32Longitude (u32Longitude_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_TIIListElement::~T_DAB_TIIListElement() {
}

inline T_DAB_TIIListElement& T_DAB_TIIListElement::operator = (const T_DAB_TIIListElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8MainId()) {
            setU8MainId(rhs.getU8MainId());
        } else {
            clearU8MainId();
        }
        if (rhs.hasU8SubId()) {
            setU8SubId(rhs.getU8SubId());
        } else {
            clearU8SubId();
        }
        if (rhs.hasU32Latitude()) {
            setU32Latitude(rhs.getU32Latitude());
        } else {
            clearU32Latitude();
        }
        if (rhs.hasU32Longitude()) {
            setU32Longitude(rhs.getU32Longitude());
        } else {
            clearU32Longitude();
        }
    }
    return *this;
}

inline bool T_DAB_TIIListElement::operator == (const T_DAB_TIIListElement& rhs) const {
    return (((!hasU8MainId() && !rhs.hasU8MainId()) || getU8MainId() == rhs.getU8MainId()) &&
        ((!hasU8SubId() && !rhs.hasU8SubId()) || getU8SubId() == rhs.getU8SubId()) &&
        ((!hasU32Latitude() && !rhs.hasU32Latitude()) || getU32Latitude() == rhs.getU32Latitude()) &&
        ((!hasU32Longitude() && !rhs.hasU32Longitude()) || getU32Longitude() == rhs.getU32Longitude()));
}

inline bool T_DAB_TIIListElement::operator != (const T_DAB_TIIListElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_TIIListElement::operator < (const T_DAB_TIIListElement& rhs) const {
    if (hasU8MainId() || rhs.hasU8MainId()) {
        if (getU8MainId() < rhs.getU8MainId()) return true;
        if (getU8MainId() > rhs.getU8MainId()) return false;
    }
    if (hasU8SubId() || rhs.hasU8SubId()) {
        if (getU8SubId() < rhs.getU8SubId()) return true;
        if (getU8SubId() > rhs.getU8SubId()) return false;
    }
    if (hasU32Latitude() || rhs.hasU32Latitude()) {
        if (getU32Latitude() < rhs.getU32Latitude()) return true;
        if (getU32Latitude() > rhs.getU32Latitude()) return false;
    }
    if (hasU32Longitude() || rhs.hasU32Longitude()) {
        if (getU32Longitude() < rhs.getU32Longitude()) return true;
        if (getU32Longitude() > rhs.getU32Longitude()) return false;
    }
    return false;
}

inline bool T_DAB_TIIListElement::operator > (const T_DAB_TIIListElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_TIIListElement::clear() {
    clearU8MainId();
    clearU8SubId();
    clearU32Latitude();
    clearU32Longitude();
}

inline void T_DAB_TIIListElement::clearU8MainId() {
    if (hasU8MainId()) {
         clear_has_u8MainId();
        _u8MainId = 0u;
     }
}

inline bool T_DAB_TIIListElement::hasU8MainId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_DAB_TIIListElement::getU8MainId () const {
    return _u8MainId;
}

inline void T_DAB_TIIListElement::setU8MainId (uint8 u8MainId_) {
    set_has_u8MainId();
    this->_u8MainId = u8MainId_;
}

inline void T_DAB_TIIListElement::clearU8SubId() {
    if (hasU8SubId()) {
         clear_has_u8SubId();
        _u8SubId = 0u;
     }
}

inline bool T_DAB_TIIListElement::hasU8SubId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_DAB_TIIListElement::getU8SubId () const {
    return _u8SubId;
}

inline void T_DAB_TIIListElement::setU8SubId (uint8 u8SubId_) {
    set_has_u8SubId();
    this->_u8SubId = u8SubId_;
}

inline void T_DAB_TIIListElement::clearU32Latitude() {
    if (hasU32Latitude()) {
         clear_has_u32Latitude();
        _u32Latitude = 0u;
     }
}

inline bool T_DAB_TIIListElement::hasU32Latitude () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_DAB_TIIListElement::getU32Latitude () const {
    return _u32Latitude;
}

inline void T_DAB_TIIListElement::setU32Latitude (uint32 u32Latitude_) {
    set_has_u32Latitude();
    this->_u32Latitude = u32Latitude_;
}

inline void T_DAB_TIIListElement::clearU32Longitude() {
    if (hasU32Longitude()) {
         clear_has_u32Longitude();
        _u32Longitude = 0u;
     }
}

inline bool T_DAB_TIIListElement::hasU32Longitude () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_DAB_TIIListElement::getU32Longitude () const {
    return _u32Longitude;
}

inline void T_DAB_TIIListElement::setU32Longitude (uint32 u32Longitude_) {
    set_has_u32Longitude();
    this->_u32Longitude = u32Longitude_;
}

inline void T_DAB_TIIListElement::set_has_u8MainId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_TIIListElement::clear_has_u8MainId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_TIIListElement::set_has_u8SubId () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_TIIListElement::clear_has_u8SubId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_TIIListElement::set_has_u32Latitude () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_TIIListElement::clear_has_u32Latitude () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_TIIListElement::set_has_u32Longitude () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_TIIListElement::clear_has_u32Longitude () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_b8_DAB_TestMode_Flags::T_b8_DAB_TestMode_Flags ()  :
    _DAB_TESTMODE_FLAGS_AUDIOSOURCE (false),
    _DAB_TESTMODE_FLAGS_SFINT (false),
    _DAB_TESTMODE_FLAGS_b2_reserved (false),
    _DAB_TESTMODE_FLAGS_b3_reserved (false),
    _DAB_TESTMODE_FLAGS_b4_reserved (false),
    _DAB_TESTMODE_FLAGS_b5_reserved (false),
    _DAB_TESTMODE_FLAGS_b6_reserved (false),
    _DAB_TESTMODE_FLAGS_b7_reserved (false)
{
}

inline  T_b8_DAB_TestMode_Flags::T_b8_DAB_TestMode_Flags (const T_b8_DAB_TestMode_Flags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_DAB_TestMode_Flags::T_b8_DAB_TestMode_Flags (bool DAB_TESTMODE_FLAGS_AUDIOSOURCE, bool DAB_TESTMODE_FLAGS_SFINT, bool DAB_TESTMODE_FLAGS_b2_reserved, bool DAB_TESTMODE_FLAGS_b3_reserved, bool DAB_TESTMODE_FLAGS_b4_reserved, bool DAB_TESTMODE_FLAGS_b5_reserved, bool DAB_TESTMODE_FLAGS_b6_reserved, bool DAB_TESTMODE_FLAGS_b7_reserved) :
    _DAB_TESTMODE_FLAGS_AUDIOSOURCE (DAB_TESTMODE_FLAGS_AUDIOSOURCE),
    _DAB_TESTMODE_FLAGS_SFINT (DAB_TESTMODE_FLAGS_SFINT),
    _DAB_TESTMODE_FLAGS_b2_reserved (DAB_TESTMODE_FLAGS_b2_reserved),
    _DAB_TESTMODE_FLAGS_b3_reserved (DAB_TESTMODE_FLAGS_b3_reserved),
    _DAB_TESTMODE_FLAGS_b4_reserved (DAB_TESTMODE_FLAGS_b4_reserved),
    _DAB_TESTMODE_FLAGS_b5_reserved (DAB_TESTMODE_FLAGS_b5_reserved),
    _DAB_TESTMODE_FLAGS_b6_reserved (DAB_TESTMODE_FLAGS_b6_reserved),
    _DAB_TESTMODE_FLAGS_b7_reserved (DAB_TESTMODE_FLAGS_b7_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_DAB_TestMode_Flags& T_b8_DAB_TestMode_Flags::operator = (const T_b8_DAB_TestMode_Flags& rhs) {
    if( this != &rhs ) {
        _DAB_TESTMODE_FLAGS_AUDIOSOURCE = rhs._DAB_TESTMODE_FLAGS_AUDIOSOURCE;
        _DAB_TESTMODE_FLAGS_SFINT = rhs._DAB_TESTMODE_FLAGS_SFINT;
        _DAB_TESTMODE_FLAGS_b2_reserved = rhs._DAB_TESTMODE_FLAGS_b2_reserved;
        _DAB_TESTMODE_FLAGS_b3_reserved = rhs._DAB_TESTMODE_FLAGS_b3_reserved;
        _DAB_TESTMODE_FLAGS_b4_reserved = rhs._DAB_TESTMODE_FLAGS_b4_reserved;
        _DAB_TESTMODE_FLAGS_b5_reserved = rhs._DAB_TESTMODE_FLAGS_b5_reserved;
        _DAB_TESTMODE_FLAGS_b6_reserved = rhs._DAB_TESTMODE_FLAGS_b6_reserved;
        _DAB_TESTMODE_FLAGS_b7_reserved = rhs._DAB_TESTMODE_FLAGS_b7_reserved;
    }
    return *this;
}

inline bool T_b8_DAB_TestMode_Flags::operator == (const T_b8_DAB_TestMode_Flags& rhs) const {
    return (_DAB_TESTMODE_FLAGS_AUDIOSOURCE == rhs._DAB_TESTMODE_FLAGS_AUDIOSOURCE &&
        _DAB_TESTMODE_FLAGS_SFINT == rhs._DAB_TESTMODE_FLAGS_SFINT &&
        _DAB_TESTMODE_FLAGS_b2_reserved == rhs._DAB_TESTMODE_FLAGS_b2_reserved &&
        _DAB_TESTMODE_FLAGS_b3_reserved == rhs._DAB_TESTMODE_FLAGS_b3_reserved &&
        _DAB_TESTMODE_FLAGS_b4_reserved == rhs._DAB_TESTMODE_FLAGS_b4_reserved &&
        _DAB_TESTMODE_FLAGS_b5_reserved == rhs._DAB_TESTMODE_FLAGS_b5_reserved &&
        _DAB_TESTMODE_FLAGS_b6_reserved == rhs._DAB_TESTMODE_FLAGS_b6_reserved &&
        _DAB_TESTMODE_FLAGS_b7_reserved == rhs._DAB_TESTMODE_FLAGS_b7_reserved);
}

inline bool T_b8_DAB_TestMode_Flags::operator != (const T_b8_DAB_TestMode_Flags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_DAB_TestMode_Flags::operator < (const T_b8_DAB_TestMode_Flags& rhs) const {
    if (getDAB_TESTMODE_FLAGS_AUDIOSOURCE() < rhs.getDAB_TESTMODE_FLAGS_AUDIOSOURCE()) return true;
    if (getDAB_TESTMODE_FLAGS_AUDIOSOURCE() > rhs.getDAB_TESTMODE_FLAGS_AUDIOSOURCE()) return false;

    if (getDAB_TESTMODE_FLAGS_SFINT() < rhs.getDAB_TESTMODE_FLAGS_SFINT()) return true;
    if (getDAB_TESTMODE_FLAGS_SFINT() > rhs.getDAB_TESTMODE_FLAGS_SFINT()) return false;

    if (getDAB_TESTMODE_FLAGS_b2_reserved() < rhs.getDAB_TESTMODE_FLAGS_b2_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b2_reserved() > rhs.getDAB_TESTMODE_FLAGS_b2_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b3_reserved() < rhs.getDAB_TESTMODE_FLAGS_b3_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b3_reserved() > rhs.getDAB_TESTMODE_FLAGS_b3_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b4_reserved() < rhs.getDAB_TESTMODE_FLAGS_b4_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b4_reserved() > rhs.getDAB_TESTMODE_FLAGS_b4_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b5_reserved() < rhs.getDAB_TESTMODE_FLAGS_b5_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b5_reserved() > rhs.getDAB_TESTMODE_FLAGS_b5_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b6_reserved() < rhs.getDAB_TESTMODE_FLAGS_b6_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b6_reserved() > rhs.getDAB_TESTMODE_FLAGS_b6_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b7_reserved() < rhs.getDAB_TESTMODE_FLAGS_b7_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b7_reserved() > rhs.getDAB_TESTMODE_FLAGS_b7_reserved()) return false;

    return false;
}

inline bool T_b8_DAB_TestMode_Flags::operator > (const T_b8_DAB_TestMode_Flags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_DAB_TestMode_Flags::setDAB_TESTMODE_FLAGS_AUDIOSOURCE (bool DAB_TESTMODE_FLAGS_AUDIOSOURCE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_AUDIOSOURCE = DAB_TESTMODE_FLAGS_AUDIOSOURCE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_TestMode_Flags::getDAB_TESTMODE_FLAGS_AUDIOSOURCE () const {
    return _DAB_TESTMODE_FLAGS_AUDIOSOURCE;
}

inline void T_b8_DAB_TestMode_Flags::setDAB_TESTMODE_FLAGS_SFINT (bool DAB_TESTMODE_FLAGS_SFINT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_SFINT = DAB_TESTMODE_FLAGS_SFINT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_TestMode_Flags::getDAB_TESTMODE_FLAGS_SFINT () const {
    return _DAB_TESTMODE_FLAGS_SFINT;
}

inline void T_b8_DAB_TestMode_Flags::setDAB_TESTMODE_FLAGS_b2_reserved (bool DAB_TESTMODE_FLAGS_b2_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b2_reserved = DAB_TESTMODE_FLAGS_b2_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_TestMode_Flags::getDAB_TESTMODE_FLAGS_b2_reserved () const {
    return _DAB_TESTMODE_FLAGS_b2_reserved;
}

inline void T_b8_DAB_TestMode_Flags::setDAB_TESTMODE_FLAGS_b3_reserved (bool DAB_TESTMODE_FLAGS_b3_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b3_reserved = DAB_TESTMODE_FLAGS_b3_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_TestMode_Flags::getDAB_TESTMODE_FLAGS_b3_reserved () const {
    return _DAB_TESTMODE_FLAGS_b3_reserved;
}

inline void T_b8_DAB_TestMode_Flags::setDAB_TESTMODE_FLAGS_b4_reserved (bool DAB_TESTMODE_FLAGS_b4_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b4_reserved = DAB_TESTMODE_FLAGS_b4_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_TestMode_Flags::getDAB_TESTMODE_FLAGS_b4_reserved () const {
    return _DAB_TESTMODE_FLAGS_b4_reserved;
}

inline void T_b8_DAB_TestMode_Flags::setDAB_TESTMODE_FLAGS_b5_reserved (bool DAB_TESTMODE_FLAGS_b5_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b5_reserved = DAB_TESTMODE_FLAGS_b5_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_TestMode_Flags::getDAB_TESTMODE_FLAGS_b5_reserved () const {
    return _DAB_TESTMODE_FLAGS_b5_reserved;
}

inline void T_b8_DAB_TestMode_Flags::setDAB_TESTMODE_FLAGS_b6_reserved (bool DAB_TESTMODE_FLAGS_b6_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b6_reserved = DAB_TESTMODE_FLAGS_b6_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_TestMode_Flags::getDAB_TESTMODE_FLAGS_b6_reserved () const {
    return _DAB_TESTMODE_FLAGS_b6_reserved;
}

inline void T_b8_DAB_TestMode_Flags::setDAB_TESTMODE_FLAGS_b7_reserved (bool DAB_TESTMODE_FLAGS_b7_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b7_reserved = DAB_TESTMODE_FLAGS_b7_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_TestMode_Flags::getDAB_TESTMODE_FLAGS_b7_reserved () const {
    return _DAB_TESTMODE_FLAGS_b7_reserved;
}

inline  T_b8_DAB_ALT_FM_Valid_Flags::T_b8_DAB_ALT_FM_Valid_Flags ()  :
    _DAB_FM_ALT_FM_PI_VALID_FLAG (false),
    _DAB_FM_ALT_FM_FREQ_VALID_FLAG (false),
    _DAB_FM_ALT_FM_QUALITY_VALID_FLAG (false),
    _DAB_TESTMODE_FLAGS_b3_reserved (false),
    _DAB_TESTMODE_FLAGS_b4_reserved (false),
    _DAB_TESTMODE_FLAGS_b5_reserved (false),
    _DAB_TESTMODE_FLAGS_b6_reserved (false),
    _DAB_TESTMODE_FLAGS_b7_reserved (false)
{
}

inline  T_b8_DAB_ALT_FM_Valid_Flags::T_b8_DAB_ALT_FM_Valid_Flags (const T_b8_DAB_ALT_FM_Valid_Flags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_DAB_ALT_FM_Valid_Flags::T_b8_DAB_ALT_FM_Valid_Flags (bool DAB_FM_ALT_FM_PI_VALID_FLAG, bool DAB_FM_ALT_FM_FREQ_VALID_FLAG, bool DAB_FM_ALT_FM_QUALITY_VALID_FLAG, bool DAB_TESTMODE_FLAGS_b3_reserved, bool DAB_TESTMODE_FLAGS_b4_reserved, bool DAB_TESTMODE_FLAGS_b5_reserved, bool DAB_TESTMODE_FLAGS_b6_reserved, bool DAB_TESTMODE_FLAGS_b7_reserved) :
    _DAB_FM_ALT_FM_PI_VALID_FLAG (DAB_FM_ALT_FM_PI_VALID_FLAG),
    _DAB_FM_ALT_FM_FREQ_VALID_FLAG (DAB_FM_ALT_FM_FREQ_VALID_FLAG),
    _DAB_FM_ALT_FM_QUALITY_VALID_FLAG (DAB_FM_ALT_FM_QUALITY_VALID_FLAG),
    _DAB_TESTMODE_FLAGS_b3_reserved (DAB_TESTMODE_FLAGS_b3_reserved),
    _DAB_TESTMODE_FLAGS_b4_reserved (DAB_TESTMODE_FLAGS_b4_reserved),
    _DAB_TESTMODE_FLAGS_b5_reserved (DAB_TESTMODE_FLAGS_b5_reserved),
    _DAB_TESTMODE_FLAGS_b6_reserved (DAB_TESTMODE_FLAGS_b6_reserved),
    _DAB_TESTMODE_FLAGS_b7_reserved (DAB_TESTMODE_FLAGS_b7_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_DAB_ALT_FM_Valid_Flags& T_b8_DAB_ALT_FM_Valid_Flags::operator = (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) {
    if( this != &rhs ) {
        _DAB_FM_ALT_FM_PI_VALID_FLAG = rhs._DAB_FM_ALT_FM_PI_VALID_FLAG;
        _DAB_FM_ALT_FM_FREQ_VALID_FLAG = rhs._DAB_FM_ALT_FM_FREQ_VALID_FLAG;
        _DAB_FM_ALT_FM_QUALITY_VALID_FLAG = rhs._DAB_FM_ALT_FM_QUALITY_VALID_FLAG;
        _DAB_TESTMODE_FLAGS_b3_reserved = rhs._DAB_TESTMODE_FLAGS_b3_reserved;
        _DAB_TESTMODE_FLAGS_b4_reserved = rhs._DAB_TESTMODE_FLAGS_b4_reserved;
        _DAB_TESTMODE_FLAGS_b5_reserved = rhs._DAB_TESTMODE_FLAGS_b5_reserved;
        _DAB_TESTMODE_FLAGS_b6_reserved = rhs._DAB_TESTMODE_FLAGS_b6_reserved;
        _DAB_TESTMODE_FLAGS_b7_reserved = rhs._DAB_TESTMODE_FLAGS_b7_reserved;
    }
    return *this;
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::operator == (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) const {
    return (_DAB_FM_ALT_FM_PI_VALID_FLAG == rhs._DAB_FM_ALT_FM_PI_VALID_FLAG &&
        _DAB_FM_ALT_FM_FREQ_VALID_FLAG == rhs._DAB_FM_ALT_FM_FREQ_VALID_FLAG &&
        _DAB_FM_ALT_FM_QUALITY_VALID_FLAG == rhs._DAB_FM_ALT_FM_QUALITY_VALID_FLAG &&
        _DAB_TESTMODE_FLAGS_b3_reserved == rhs._DAB_TESTMODE_FLAGS_b3_reserved &&
        _DAB_TESTMODE_FLAGS_b4_reserved == rhs._DAB_TESTMODE_FLAGS_b4_reserved &&
        _DAB_TESTMODE_FLAGS_b5_reserved == rhs._DAB_TESTMODE_FLAGS_b5_reserved &&
        _DAB_TESTMODE_FLAGS_b6_reserved == rhs._DAB_TESTMODE_FLAGS_b6_reserved &&
        _DAB_TESTMODE_FLAGS_b7_reserved == rhs._DAB_TESTMODE_FLAGS_b7_reserved);
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::operator != (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::operator < (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) const {
    if (getDAB_FM_ALT_FM_PI_VALID_FLAG() < rhs.getDAB_FM_ALT_FM_PI_VALID_FLAG()) return true;
    if (getDAB_FM_ALT_FM_PI_VALID_FLAG() > rhs.getDAB_FM_ALT_FM_PI_VALID_FLAG()) return false;

    if (getDAB_FM_ALT_FM_FREQ_VALID_FLAG() < rhs.getDAB_FM_ALT_FM_FREQ_VALID_FLAG()) return true;
    if (getDAB_FM_ALT_FM_FREQ_VALID_FLAG() > rhs.getDAB_FM_ALT_FM_FREQ_VALID_FLAG()) return false;

    if (getDAB_FM_ALT_FM_QUALITY_VALID_FLAG() < rhs.getDAB_FM_ALT_FM_QUALITY_VALID_FLAG()) return true;
    if (getDAB_FM_ALT_FM_QUALITY_VALID_FLAG() > rhs.getDAB_FM_ALT_FM_QUALITY_VALID_FLAG()) return false;

    if (getDAB_TESTMODE_FLAGS_b3_reserved() < rhs.getDAB_TESTMODE_FLAGS_b3_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b3_reserved() > rhs.getDAB_TESTMODE_FLAGS_b3_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b4_reserved() < rhs.getDAB_TESTMODE_FLAGS_b4_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b4_reserved() > rhs.getDAB_TESTMODE_FLAGS_b4_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b5_reserved() < rhs.getDAB_TESTMODE_FLAGS_b5_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b5_reserved() > rhs.getDAB_TESTMODE_FLAGS_b5_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b6_reserved() < rhs.getDAB_TESTMODE_FLAGS_b6_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b6_reserved() > rhs.getDAB_TESTMODE_FLAGS_b6_reserved()) return false;

    if (getDAB_TESTMODE_FLAGS_b7_reserved() < rhs.getDAB_TESTMODE_FLAGS_b7_reserved()) return true;
    if (getDAB_TESTMODE_FLAGS_b7_reserved() > rhs.getDAB_TESTMODE_FLAGS_b7_reserved()) return false;

    return false;
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::operator > (const T_b8_DAB_ALT_FM_Valid_Flags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_DAB_ALT_FM_Valid_Flags::setDAB_FM_ALT_FM_PI_VALID_FLAG (bool DAB_FM_ALT_FM_PI_VALID_FLAG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_FM_ALT_FM_PI_VALID_FLAG = DAB_FM_ALT_FM_PI_VALID_FLAG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::getDAB_FM_ALT_FM_PI_VALID_FLAG () const {
    return _DAB_FM_ALT_FM_PI_VALID_FLAG;
}

inline void T_b8_DAB_ALT_FM_Valid_Flags::setDAB_FM_ALT_FM_FREQ_VALID_FLAG (bool DAB_FM_ALT_FM_FREQ_VALID_FLAG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_FM_ALT_FM_FREQ_VALID_FLAG = DAB_FM_ALT_FM_FREQ_VALID_FLAG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::getDAB_FM_ALT_FM_FREQ_VALID_FLAG () const {
    return _DAB_FM_ALT_FM_FREQ_VALID_FLAG;
}

inline void T_b8_DAB_ALT_FM_Valid_Flags::setDAB_FM_ALT_FM_QUALITY_VALID_FLAG (bool DAB_FM_ALT_FM_QUALITY_VALID_FLAG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_FM_ALT_FM_QUALITY_VALID_FLAG = DAB_FM_ALT_FM_QUALITY_VALID_FLAG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::getDAB_FM_ALT_FM_QUALITY_VALID_FLAG () const {
    return _DAB_FM_ALT_FM_QUALITY_VALID_FLAG;
}

inline void T_b8_DAB_ALT_FM_Valid_Flags::setDAB_TESTMODE_FLAGS_b3_reserved (bool DAB_TESTMODE_FLAGS_b3_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b3_reserved = DAB_TESTMODE_FLAGS_b3_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::getDAB_TESTMODE_FLAGS_b3_reserved () const {
    return _DAB_TESTMODE_FLAGS_b3_reserved;
}

inline void T_b8_DAB_ALT_FM_Valid_Flags::setDAB_TESTMODE_FLAGS_b4_reserved (bool DAB_TESTMODE_FLAGS_b4_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b4_reserved = DAB_TESTMODE_FLAGS_b4_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::getDAB_TESTMODE_FLAGS_b4_reserved () const {
    return _DAB_TESTMODE_FLAGS_b4_reserved;
}

inline void T_b8_DAB_ALT_FM_Valid_Flags::setDAB_TESTMODE_FLAGS_b5_reserved (bool DAB_TESTMODE_FLAGS_b5_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b5_reserved = DAB_TESTMODE_FLAGS_b5_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::getDAB_TESTMODE_FLAGS_b5_reserved () const {
    return _DAB_TESTMODE_FLAGS_b5_reserved;
}

inline void T_b8_DAB_ALT_FM_Valid_Flags::setDAB_TESTMODE_FLAGS_b6_reserved (bool DAB_TESTMODE_FLAGS_b6_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b6_reserved = DAB_TESTMODE_FLAGS_b6_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::getDAB_TESTMODE_FLAGS_b6_reserved () const {
    return _DAB_TESTMODE_FLAGS_b6_reserved;
}

inline void T_b8_DAB_ALT_FM_Valid_Flags::setDAB_TESTMODE_FLAGS_b7_reserved (bool DAB_TESTMODE_FLAGS_b7_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB_TESTMODE_FLAGS_b7_reserved = DAB_TESTMODE_FLAGS_b7_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DAB_ALT_FM_Valid_Flags::getDAB_TESTMODE_FLAGS_b7_reserved () const {
    return _DAB_TESTMODE_FLAGS_b7_reserved;
}

inline  T_DAB_LinkListElem::T_DAB_LinkListElem ()  :
    _e8LinkType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_LinkType__LINKTYPE_DAB_HARDLINK),
    _sFreqLabel (),
    _u32ID (0u),
    _u32EnsembleId (0u),
    _u8Quality (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_LinkListElem::T_DAB_LinkListElem (const T_DAB_LinkListElem &rhs)  :
    _e8LinkType (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_LinkType__LINKTYPE_DAB_HARDLINK),
    _sFreqLabel (),
    _u32ID (0u),
    _u32EnsembleId (0u),
    _u8Quality (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_LinkListElem::T_DAB_LinkListElem (T_e8_DAB_LinkType e8LinkType_, const ::std::string& sFreqLabel_, uint32 u32ID_, uint32 u32EnsembleId_, uint8 u8Quality_)  :
    _e8LinkType (e8LinkType_),
    _sFreqLabel (sFreqLabel_),
    _u32ID (u32ID_),
    _u32EnsembleId (u32EnsembleId_),
    _u8Quality (u8Quality_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_LinkType_IsValid(e8LinkType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LinkType_, "T_e8_DAB_LinkType", "e8LinkType", "T_DAB_LinkListElem");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_LinkListElem::~T_DAB_LinkListElem() {
}

inline T_DAB_LinkListElem& T_DAB_LinkListElem::operator = (const T_DAB_LinkListElem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8LinkType()) {
            setE8LinkType(rhs.getE8LinkType());
        } else {
            clearE8LinkType();
        }
        if (rhs.hasSFreqLabel()) {
            setSFreqLabel(rhs.getSFreqLabel());
        } else {
            clearSFreqLabel();
        }
        if (rhs.hasU32ID()) {
            setU32ID(rhs.getU32ID());
        } else {
            clearU32ID();
        }
        if (rhs.hasU32EnsembleId()) {
            setU32EnsembleId(rhs.getU32EnsembleId());
        } else {
            clearU32EnsembleId();
        }
        if (rhs.hasU8Quality()) {
            setU8Quality(rhs.getU8Quality());
        } else {
            clearU8Quality();
        }
    }
    return *this;
}

inline bool T_DAB_LinkListElem::operator == (const T_DAB_LinkListElem& rhs) const {
    return (((!hasE8LinkType() && !rhs.hasE8LinkType()) || getE8LinkType() == rhs.getE8LinkType()) &&
        ((!hasSFreqLabel() && !rhs.hasSFreqLabel()) || getSFreqLabel() == rhs.getSFreqLabel()) &&
        ((!hasU32ID() && !rhs.hasU32ID()) || getU32ID() == rhs.getU32ID()) &&
        ((!hasU32EnsembleId() && !rhs.hasU32EnsembleId()) || getU32EnsembleId() == rhs.getU32EnsembleId()) &&
        ((!hasU8Quality() && !rhs.hasU8Quality()) || getU8Quality() == rhs.getU8Quality()));
}

inline bool T_DAB_LinkListElem::operator != (const T_DAB_LinkListElem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_LinkListElem::operator < (const T_DAB_LinkListElem& rhs) const {
    if (hasE8LinkType() || rhs.hasE8LinkType()) {
        if ((uint32)getE8LinkType() < (uint32)rhs.getE8LinkType()) return true;
        if ((uint32)getE8LinkType() > (uint32)rhs.getE8LinkType()) return false;
    }
    if (hasSFreqLabel() || rhs.hasSFreqLabel()) {
        if (getSFreqLabel() < rhs.getSFreqLabel()) return true;
        if (getSFreqLabel() > rhs.getSFreqLabel()) return false;
    }
    if (hasU32ID() || rhs.hasU32ID()) {
        if (getU32ID() < rhs.getU32ID()) return true;
        if (getU32ID() > rhs.getU32ID()) return false;
    }
    if (hasU32EnsembleId() || rhs.hasU32EnsembleId()) {
        if (getU32EnsembleId() < rhs.getU32EnsembleId()) return true;
        if (getU32EnsembleId() > rhs.getU32EnsembleId()) return false;
    }
    if (hasU8Quality() || rhs.hasU8Quality()) {
        if (getU8Quality() < rhs.getU8Quality()) return true;
        if (getU8Quality() > rhs.getU8Quality()) return false;
    }
    return false;
}

inline bool T_DAB_LinkListElem::operator > (const T_DAB_LinkListElem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_LinkListElem::clear() {
    clearE8LinkType();
    clearSFreqLabel();
    clearU32ID();
    clearU32EnsembleId();
    clearU8Quality();
}

inline void T_DAB_LinkListElem::clearE8LinkType() {
    if (hasE8LinkType()) {
         clear_has_e8LinkType();
        _e8LinkType = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_LinkType__LINKTYPE_DAB_HARDLINK;
     }
}

inline bool T_DAB_LinkListElem::hasE8LinkType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_DAB_LinkType T_DAB_LinkListElem::getE8LinkType () const {
    return _e8LinkType;
}

inline void T_DAB_LinkListElem::setE8LinkType (T_e8_DAB_LinkType e8LinkType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_LinkType_IsValid(e8LinkType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LinkType_, "T_e8_DAB_LinkType", "e8LinkType", "T_DAB_LinkListElem");
    }
    set_has_e8LinkType();
    this->_e8LinkType = e8LinkType_;
}

inline void T_DAB_LinkListElem::clearSFreqLabel() {
    if (hasSFreqLabel()) {
         clear_has_sFreqLabel();
        _sFreqLabel.clear();
     }
}

inline bool T_DAB_LinkListElem::hasSFreqLabel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DAB_LinkListElem::getSFreqLabel () const {
    return _sFreqLabel;
}

inline ::std::string& T_DAB_LinkListElem::getSFreqLabelMutable () {
    set_has_sFreqLabel();
    return _sFreqLabel;
}

inline void T_DAB_LinkListElem::setSFreqLabel (const ::std::string& sFreqLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel = sFreqLabel_;
}

inline void T_DAB_LinkListElem::setSFreqLabel (const char* sFreqLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFreqLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel.assign(sFreqLabel_);
}

inline void T_DAB_LinkListElem::setSFreqLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFreqLabel();
    this->_sFreqLabel.assign(value, size);
}

inline void T_DAB_LinkListElem::clearU32ID() {
    if (hasU32ID()) {
         clear_has_u32ID();
        _u32ID = 0u;
     }
}

inline bool T_DAB_LinkListElem::hasU32ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_DAB_LinkListElem::getU32ID () const {
    return _u32ID;
}

inline void T_DAB_LinkListElem::setU32ID (uint32 u32ID_) {
    set_has_u32ID();
    this->_u32ID = u32ID_;
}

inline void T_DAB_LinkListElem::clearU32EnsembleId() {
    if (hasU32EnsembleId()) {
         clear_has_u32EnsembleId();
        _u32EnsembleId = 0u;
     }
}

inline bool T_DAB_LinkListElem::hasU32EnsembleId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_DAB_LinkListElem::getU32EnsembleId () const {
    return _u32EnsembleId;
}

inline void T_DAB_LinkListElem::setU32EnsembleId (uint32 u32EnsembleId_) {
    set_has_u32EnsembleId();
    this->_u32EnsembleId = u32EnsembleId_;
}

inline void T_DAB_LinkListElem::clearU8Quality() {
    if (hasU8Quality()) {
         clear_has_u8Quality();
        _u8Quality = 0u;
     }
}

inline bool T_DAB_LinkListElem::hasU8Quality () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_LinkListElem::getU8Quality () const {
    return _u8Quality;
}

inline void T_DAB_LinkListElem::setU8Quality (uint8 u8Quality_) {
    set_has_u8Quality();
    this->_u8Quality = u8Quality_;
}

inline void T_DAB_LinkListElem::set_has_e8LinkType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_LinkListElem::clear_has_e8LinkType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_LinkListElem::set_has_sFreqLabel () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_LinkListElem::clear_has_sFreqLabel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_LinkListElem::set_has_u32ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_LinkListElem::clear_has_u32ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_LinkListElem::set_has_u32EnsembleId () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_LinkListElem::clear_has_u32EnsembleId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_LinkListElem::set_has_u8Quality () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_LinkListElem::clear_has_u8Quality () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_DAB_AltFreqInfo::T_DAB_AltFreqInfo ()  :
    _u32Frequency (0u),
    _s8FieldStrength (0),
    _u8Quality (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_AltFreqInfo::T_DAB_AltFreqInfo (const T_DAB_AltFreqInfo &rhs)  :
    _u32Frequency (0u),
    _s8FieldStrength (0),
    _u8Quality (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_AltFreqInfo::T_DAB_AltFreqInfo (uint32 u32Frequency_, int8 s8FieldStrength_, uint8 u8Quality_)  :
    _u32Frequency (u32Frequency_),
    _s8FieldStrength (s8FieldStrength_),
    _u8Quality (u8Quality_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_AltFreqInfo::~T_DAB_AltFreqInfo() {
}

inline T_DAB_AltFreqInfo& T_DAB_AltFreqInfo::operator = (const T_DAB_AltFreqInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
        if (rhs.hasS8FieldStrength()) {
            setS8FieldStrength(rhs.getS8FieldStrength());
        } else {
            clearS8FieldStrength();
        }
        if (rhs.hasU8Quality()) {
            setU8Quality(rhs.getU8Quality());
        } else {
            clearU8Quality();
        }
    }
    return *this;
}

inline bool T_DAB_AltFreqInfo::operator == (const T_DAB_AltFreqInfo& rhs) const {
    return (((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()) &&
        ((!hasS8FieldStrength() && !rhs.hasS8FieldStrength()) || getS8FieldStrength() == rhs.getS8FieldStrength()) &&
        ((!hasU8Quality() && !rhs.hasU8Quality()) || getU8Quality() == rhs.getU8Quality()));
}

inline bool T_DAB_AltFreqInfo::operator != (const T_DAB_AltFreqInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_AltFreqInfo::operator < (const T_DAB_AltFreqInfo& rhs) const {
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    if (hasS8FieldStrength() || rhs.hasS8FieldStrength()) {
        if (getS8FieldStrength() < rhs.getS8FieldStrength()) return true;
        if (getS8FieldStrength() > rhs.getS8FieldStrength()) return false;
    }
    if (hasU8Quality() || rhs.hasU8Quality()) {
        if (getU8Quality() < rhs.getU8Quality()) return true;
        if (getU8Quality() > rhs.getU8Quality()) return false;
    }
    return false;
}

inline bool T_DAB_AltFreqInfo::operator > (const T_DAB_AltFreqInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_AltFreqInfo::clear() {
    clearU32Frequency();
    clearS8FieldStrength();
    clearU8Quality();
}

inline void T_DAB_AltFreqInfo::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool T_DAB_AltFreqInfo::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_AltFreqInfo::getU32Frequency () const {
    return _u32Frequency;
}

inline void T_DAB_AltFreqInfo::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void T_DAB_AltFreqInfo::clearS8FieldStrength() {
    if (hasS8FieldStrength()) {
         clear_has_s8FieldStrength();
        _s8FieldStrength = 0;
     }
}

inline bool T_DAB_AltFreqInfo::hasS8FieldStrength () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int8 T_DAB_AltFreqInfo::getS8FieldStrength () const {
    return _s8FieldStrength;
}

inline void T_DAB_AltFreqInfo::setS8FieldStrength (int8 s8FieldStrength_) {
    set_has_s8FieldStrength();
    this->_s8FieldStrength = s8FieldStrength_;
}

inline void T_DAB_AltFreqInfo::clearU8Quality() {
    if (hasU8Quality()) {
         clear_has_u8Quality();
        _u8Quality = 0u;
     }
}

inline bool T_DAB_AltFreqInfo::hasU8Quality () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_DAB_AltFreqInfo::getU8Quality () const {
    return _u8Quality;
}

inline void T_DAB_AltFreqInfo::setU8Quality (uint8 u8Quality_) {
    set_has_u8Quality();
    this->_u8Quality = u8Quality_;
}

inline void T_DAB_AltFreqInfo::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_AltFreqInfo::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_AltFreqInfo::set_has_s8FieldStrength () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_AltFreqInfo::clear_has_s8FieldStrength () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_AltFreqInfo::set_has_u8Quality () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_AltFreqInfo::clear_has_u8Quality () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_DAB_TestModeData::T_DAB_TestModeData ()  :
    _u32CurrentServID (0u),
    _u32MSCBER (0u),
    _u32FICBER (0u),
    _u32NETBER (0u),
    _u8RSFEC (0u),
    _u8DABMode (0u),
    _u8ProtectionLevel (0u),
    _u8ConcealmentLevel (0u),
    _e8ServiceLinkingMode (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_OFF),
    _b8ValidFMValues (),
    _u16AltFMPI (0u),
    _u32AltFMFrequency (0u),
    _u8AltFMQuality (0u),
    _b8Flags (),
    _s8FieldStrength (0),
    _u16TotalNumberLinks (0u),
    _u8ECC (0u),
    _u16CountryLabel (0u),
    _u16ActivatedLink (0u),
    _LinkList (),
    _DAB_DMB_AltFreqInfo (),
    _bSync (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_TestModeData::T_DAB_TestModeData (const T_DAB_TestModeData &rhs)  :
    _u32CurrentServID (0u),
    _u32MSCBER (0u),
    _u32FICBER (0u),
    _u32NETBER (0u),
    _u8RSFEC (0u),
    _u8DABMode (0u),
    _u8ProtectionLevel (0u),
    _u8ConcealmentLevel (0u),
    _e8ServiceLinkingMode (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_OFF),
    _b8ValidFMValues (),
    _u16AltFMPI (0u),
    _u32AltFMFrequency (0u),
    _u8AltFMQuality (0u),
    _b8Flags (),
    _s8FieldStrength (0),
    _u16TotalNumberLinks (0u),
    _u8ECC (0u),
    _u16CountryLabel (0u),
    _u16ActivatedLink (0u),
    _LinkList (),
    _DAB_DMB_AltFreqInfo (),
    _bSync (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_TestModeData::T_DAB_TestModeData (uint32 u32CurrentServID_, uint32 u32MSCBER_, uint32 u32FICBER_, uint32 u32NETBER_, uint8 u8RSFEC_, uint8 u8DABMode_, uint8 u8ProtectionLevel_, uint8 u8ConcealmentLevel_, T_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode_, const T_b8_DAB_ALT_FM_Valid_Flags& b8ValidFMValues_, uint16 u16AltFMPI_, uint32 u32AltFMFrequency_, uint8 u8AltFMQuality_, const T_b8_DAB_TestMode_Flags& b8Flags_, int8 s8FieldStrength_, uint16 u16TotalNumberLinks_, uint8 u8ECC_, uint16 u16CountryLabel_, uint16 u16ActivatedLink_, const ::std::vector< T_DAB_LinkListElem >& LinkList_, const ::std::vector< T_DAB_AltFreqInfo >& DAB_DMB_AltFreqInfo_, bool bSync_)  :
    _u32CurrentServID (u32CurrentServID_),
    _u32MSCBER (u32MSCBER_),
    _u32FICBER (u32FICBER_),
    _u32NETBER (u32NETBER_),
    _u8RSFEC (u8RSFEC_),
    _u8DABMode (u8DABMode_),
    _u8ProtectionLevel (u8ProtectionLevel_),
    _u8ConcealmentLevel (u8ConcealmentLevel_),
    _e8ServiceLinkingMode (e8ServiceLinkingMode_),
    _b8ValidFMValues (b8ValidFMValues_),
    _u16AltFMPI (u16AltFMPI_),
    _u32AltFMFrequency (u32AltFMFrequency_),
    _u8AltFMQuality (u8AltFMQuality_),
    _b8Flags (b8Flags_),
    _s8FieldStrength (s8FieldStrength_),
    _u16TotalNumberLinks (u16TotalNumberLinks_),
    _u8ECC (u8ECC_),
    _u16CountryLabel (u16CountryLabel_),
    _u16ActivatedLink (u16ActivatedLink_),
    _LinkList (LinkList_),
    _DAB_DMB_AltFreqInfo (DAB_DMB_AltFreqInfo_),
    _bSync (bSync_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ServiceLinkingMode_IsValid(e8ServiceLinkingMode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ServiceLinkingMode_, "T_e8_DAB_ServiceLinkingMode", "e8ServiceLinkingMode", "T_DAB_TestModeData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_TestModeData::~T_DAB_TestModeData() {
}

inline T_DAB_TestModeData& T_DAB_TestModeData::operator = (const T_DAB_TestModeData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32CurrentServID()) {
            setU32CurrentServID(rhs.getU32CurrentServID());
        } else {
            clearU32CurrentServID();
        }
        if (rhs.hasU32MSCBER()) {
            setU32MSCBER(rhs.getU32MSCBER());
        } else {
            clearU32MSCBER();
        }
        if (rhs.hasU32FICBER()) {
            setU32FICBER(rhs.getU32FICBER());
        } else {
            clearU32FICBER();
        }
        if (rhs.hasU32NETBER()) {
            setU32NETBER(rhs.getU32NETBER());
        } else {
            clearU32NETBER();
        }
        if (rhs.hasU8RSFEC()) {
            setU8RSFEC(rhs.getU8RSFEC());
        } else {
            clearU8RSFEC();
        }
        if (rhs.hasU8DABMode()) {
            setU8DABMode(rhs.getU8DABMode());
        } else {
            clearU8DABMode();
        }
        if (rhs.hasU8ProtectionLevel()) {
            setU8ProtectionLevel(rhs.getU8ProtectionLevel());
        } else {
            clearU8ProtectionLevel();
        }
        if (rhs.hasU8ConcealmentLevel()) {
            setU8ConcealmentLevel(rhs.getU8ConcealmentLevel());
        } else {
            clearU8ConcealmentLevel();
        }
        if (rhs.hasE8ServiceLinkingMode()) {
            setE8ServiceLinkingMode(rhs.getE8ServiceLinkingMode());
        } else {
            clearE8ServiceLinkingMode();
        }
        if (rhs.hasB8ValidFMValues()) {
            setB8ValidFMValues(rhs.getB8ValidFMValues());
        } else {
            clearB8ValidFMValues();
        }
        if (rhs.hasU16AltFMPI()) {
            setU16AltFMPI(rhs.getU16AltFMPI());
        } else {
            clearU16AltFMPI();
        }
        if (rhs.hasU32AltFMFrequency()) {
            setU32AltFMFrequency(rhs.getU32AltFMFrequency());
        } else {
            clearU32AltFMFrequency();
        }
        if (rhs.hasU8AltFMQuality()) {
            setU8AltFMQuality(rhs.getU8AltFMQuality());
        } else {
            clearU8AltFMQuality();
        }
        if (rhs.hasB8Flags()) {
            setB8Flags(rhs.getB8Flags());
        } else {
            clearB8Flags();
        }
        if (rhs.hasS8FieldStrength()) {
            setS8FieldStrength(rhs.getS8FieldStrength());
        } else {
            clearS8FieldStrength();
        }
        if (rhs.hasU16TotalNumberLinks()) {
            setU16TotalNumberLinks(rhs.getU16TotalNumberLinks());
        } else {
            clearU16TotalNumberLinks();
        }
        if (rhs.hasU8ECC()) {
            setU8ECC(rhs.getU8ECC());
        } else {
            clearU8ECC();
        }
        if (rhs.hasU16CountryLabel()) {
            setU16CountryLabel(rhs.getU16CountryLabel());
        } else {
            clearU16CountryLabel();
        }
        if (rhs.hasU16ActivatedLink()) {
            setU16ActivatedLink(rhs.getU16ActivatedLink());
        } else {
            clearU16ActivatedLink();
        }
        if (rhs.hasLinkList()) {
            setLinkList(rhs.getLinkList());
        } else {
            clearLinkList();
        }
        if (rhs.hasDAB_DMB_AltFreqInfo()) {
            setDAB_DMB_AltFreqInfo(rhs.getDAB_DMB_AltFreqInfo());
        } else {
            clearDAB_DMB_AltFreqInfo();
        }
        if (rhs.hasBSync()) {
            setBSync(rhs.getBSync());
        } else {
            clearBSync();
        }
    }
    return *this;
}

inline bool T_DAB_TestModeData::operator == (const T_DAB_TestModeData& rhs) const {
    return (((!hasU32CurrentServID() && !rhs.hasU32CurrentServID()) || getU32CurrentServID() == rhs.getU32CurrentServID()) &&
        ((!hasU32MSCBER() && !rhs.hasU32MSCBER()) || getU32MSCBER() == rhs.getU32MSCBER()) &&
        ((!hasU32FICBER() && !rhs.hasU32FICBER()) || getU32FICBER() == rhs.getU32FICBER()) &&
        ((!hasU32NETBER() && !rhs.hasU32NETBER()) || getU32NETBER() == rhs.getU32NETBER()) &&
        ((!hasU8RSFEC() && !rhs.hasU8RSFEC()) || getU8RSFEC() == rhs.getU8RSFEC()) &&
        ((!hasU8DABMode() && !rhs.hasU8DABMode()) || getU8DABMode() == rhs.getU8DABMode()) &&
        ((!hasU8ProtectionLevel() && !rhs.hasU8ProtectionLevel()) || getU8ProtectionLevel() == rhs.getU8ProtectionLevel()) &&
        ((!hasU8ConcealmentLevel() && !rhs.hasU8ConcealmentLevel()) || getU8ConcealmentLevel() == rhs.getU8ConcealmentLevel()) &&
        ((!hasE8ServiceLinkingMode() && !rhs.hasE8ServiceLinkingMode()) || getE8ServiceLinkingMode() == rhs.getE8ServiceLinkingMode()) &&
        ((!hasB8ValidFMValues() && !rhs.hasB8ValidFMValues()) || getB8ValidFMValues() == rhs.getB8ValidFMValues()) &&
        ((!hasU16AltFMPI() && !rhs.hasU16AltFMPI()) || getU16AltFMPI() == rhs.getU16AltFMPI()) &&
        ((!hasU32AltFMFrequency() && !rhs.hasU32AltFMFrequency()) || getU32AltFMFrequency() == rhs.getU32AltFMFrequency()) &&
        ((!hasU8AltFMQuality() && !rhs.hasU8AltFMQuality()) || getU8AltFMQuality() == rhs.getU8AltFMQuality()) &&
        ((!hasB8Flags() && !rhs.hasB8Flags()) || getB8Flags() == rhs.getB8Flags()) &&
        ((!hasS8FieldStrength() && !rhs.hasS8FieldStrength()) || getS8FieldStrength() == rhs.getS8FieldStrength()) &&
        ((!hasU16TotalNumberLinks() && !rhs.hasU16TotalNumberLinks()) || getU16TotalNumberLinks() == rhs.getU16TotalNumberLinks()) &&
        ((!hasU8ECC() && !rhs.hasU8ECC()) || getU8ECC() == rhs.getU8ECC()) &&
        ((!hasU16CountryLabel() && !rhs.hasU16CountryLabel()) || getU16CountryLabel() == rhs.getU16CountryLabel()) &&
        ((!hasU16ActivatedLink() && !rhs.hasU16ActivatedLink()) || getU16ActivatedLink() == rhs.getU16ActivatedLink()) &&
        ((!hasLinkList() && !rhs.hasLinkList()) || getLinkList() == rhs.getLinkList()) &&
        ((!hasDAB_DMB_AltFreqInfo() && !rhs.hasDAB_DMB_AltFreqInfo()) || getDAB_DMB_AltFreqInfo() == rhs.getDAB_DMB_AltFreqInfo()) &&
        ((!hasBSync() && !rhs.hasBSync()) || getBSync() == rhs.getBSync()));
}

inline bool T_DAB_TestModeData::operator != (const T_DAB_TestModeData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_TestModeData::operator < (const T_DAB_TestModeData& rhs) const {
    if (hasU32CurrentServID() || rhs.hasU32CurrentServID()) {
        if (getU32CurrentServID() < rhs.getU32CurrentServID()) return true;
        if (getU32CurrentServID() > rhs.getU32CurrentServID()) return false;
    }
    if (hasU32MSCBER() || rhs.hasU32MSCBER()) {
        if (getU32MSCBER() < rhs.getU32MSCBER()) return true;
        if (getU32MSCBER() > rhs.getU32MSCBER()) return false;
    }
    if (hasU32FICBER() || rhs.hasU32FICBER()) {
        if (getU32FICBER() < rhs.getU32FICBER()) return true;
        if (getU32FICBER() > rhs.getU32FICBER()) return false;
    }
    if (hasU32NETBER() || rhs.hasU32NETBER()) {
        if (getU32NETBER() < rhs.getU32NETBER()) return true;
        if (getU32NETBER() > rhs.getU32NETBER()) return false;
    }
    if (hasU8RSFEC() || rhs.hasU8RSFEC()) {
        if (getU8RSFEC() < rhs.getU8RSFEC()) return true;
        if (getU8RSFEC() > rhs.getU8RSFEC()) return false;
    }
    if (hasU8DABMode() || rhs.hasU8DABMode()) {
        if (getU8DABMode() < rhs.getU8DABMode()) return true;
        if (getU8DABMode() > rhs.getU8DABMode()) return false;
    }
    if (hasU8ProtectionLevel() || rhs.hasU8ProtectionLevel()) {
        if (getU8ProtectionLevel() < rhs.getU8ProtectionLevel()) return true;
        if (getU8ProtectionLevel() > rhs.getU8ProtectionLevel()) return false;
    }
    if (hasU8ConcealmentLevel() || rhs.hasU8ConcealmentLevel()) {
        if (getU8ConcealmentLevel() < rhs.getU8ConcealmentLevel()) return true;
        if (getU8ConcealmentLevel() > rhs.getU8ConcealmentLevel()) return false;
    }
    if (hasE8ServiceLinkingMode() || rhs.hasE8ServiceLinkingMode()) {
        if ((uint32)getE8ServiceLinkingMode() < (uint32)rhs.getE8ServiceLinkingMode()) return true;
        if ((uint32)getE8ServiceLinkingMode() > (uint32)rhs.getE8ServiceLinkingMode()) return false;
    }
    if (hasB8ValidFMValues() || rhs.hasB8ValidFMValues()) {
        if (getB8ValidFMValues() < rhs.getB8ValidFMValues()) return true;
        if (getB8ValidFMValues() > rhs.getB8ValidFMValues()) return false;
    }
    if (hasU16AltFMPI() || rhs.hasU16AltFMPI()) {
        if (getU16AltFMPI() < rhs.getU16AltFMPI()) return true;
        if (getU16AltFMPI() > rhs.getU16AltFMPI()) return false;
    }
    if (hasU32AltFMFrequency() || rhs.hasU32AltFMFrequency()) {
        if (getU32AltFMFrequency() < rhs.getU32AltFMFrequency()) return true;
        if (getU32AltFMFrequency() > rhs.getU32AltFMFrequency()) return false;
    }
    if (hasU8AltFMQuality() || rhs.hasU8AltFMQuality()) {
        if (getU8AltFMQuality() < rhs.getU8AltFMQuality()) return true;
        if (getU8AltFMQuality() > rhs.getU8AltFMQuality()) return false;
    }
    if (hasB8Flags() || rhs.hasB8Flags()) {
        if (getB8Flags() < rhs.getB8Flags()) return true;
        if (getB8Flags() > rhs.getB8Flags()) return false;
    }
    if (hasS8FieldStrength() || rhs.hasS8FieldStrength()) {
        if (getS8FieldStrength() < rhs.getS8FieldStrength()) return true;
        if (getS8FieldStrength() > rhs.getS8FieldStrength()) return false;
    }
    if (hasU16TotalNumberLinks() || rhs.hasU16TotalNumberLinks()) {
        if (getU16TotalNumberLinks() < rhs.getU16TotalNumberLinks()) return true;
        if (getU16TotalNumberLinks() > rhs.getU16TotalNumberLinks()) return false;
    }
    if (hasU8ECC() || rhs.hasU8ECC()) {
        if (getU8ECC() < rhs.getU8ECC()) return true;
        if (getU8ECC() > rhs.getU8ECC()) return false;
    }
    if (hasU16CountryLabel() || rhs.hasU16CountryLabel()) {
        if (getU16CountryLabel() < rhs.getU16CountryLabel()) return true;
        if (getU16CountryLabel() > rhs.getU16CountryLabel()) return false;
    }
    if (hasU16ActivatedLink() || rhs.hasU16ActivatedLink()) {
        if (getU16ActivatedLink() < rhs.getU16ActivatedLink()) return true;
        if (getU16ActivatedLink() > rhs.getU16ActivatedLink()) return false;
    }
    if (hasLinkList() || rhs.hasLinkList()) {
        if (getLinkList() < rhs.getLinkList()) return true;
        if (getLinkList() > rhs.getLinkList()) return false;
    }
    if (hasDAB_DMB_AltFreqInfo() || rhs.hasDAB_DMB_AltFreqInfo()) {
        if (getDAB_DMB_AltFreqInfo() < rhs.getDAB_DMB_AltFreqInfo()) return true;
        if (getDAB_DMB_AltFreqInfo() > rhs.getDAB_DMB_AltFreqInfo()) return false;
    }
    if (hasBSync() || rhs.hasBSync()) {
        if (getBSync() < rhs.getBSync()) return true;
        if (getBSync() > rhs.getBSync()) return false;
    }
    return false;
}

inline bool T_DAB_TestModeData::operator > (const T_DAB_TestModeData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_TestModeData::clear() {
    clearU32CurrentServID();
    clearU32MSCBER();
    clearU32FICBER();
    clearU32NETBER();
    clearU8RSFEC();
    clearU8DABMode();
    clearU8ProtectionLevel();
    clearU8ConcealmentLevel();
    clearE8ServiceLinkingMode();
    clearB8ValidFMValues();
    clearU16AltFMPI();
    clearU32AltFMFrequency();
    clearU8AltFMQuality();
    clearB8Flags();
    clearS8FieldStrength();
    clearU16TotalNumberLinks();
    clearU8ECC();
    clearU16CountryLabel();
    clearU16ActivatedLink();
    clearLinkList();
    clearDAB_DMB_AltFreqInfo();
    clearBSync();
}

inline void T_DAB_TestModeData::clearU32CurrentServID() {
    if (hasU32CurrentServID()) {
         clear_has_u32CurrentServID();
        _u32CurrentServID = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU32CurrentServID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_TestModeData::getU32CurrentServID () const {
    return _u32CurrentServID;
}

inline void T_DAB_TestModeData::setU32CurrentServID (uint32 u32CurrentServID_) {
    set_has_u32CurrentServID();
    this->_u32CurrentServID = u32CurrentServID_;
}

inline void T_DAB_TestModeData::clearU32MSCBER() {
    if (hasU32MSCBER()) {
         clear_has_u32MSCBER();
        _u32MSCBER = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU32MSCBER () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_DAB_TestModeData::getU32MSCBER () const {
    return _u32MSCBER;
}

inline void T_DAB_TestModeData::setU32MSCBER (uint32 u32MSCBER_) {
    set_has_u32MSCBER();
    this->_u32MSCBER = u32MSCBER_;
}

inline void T_DAB_TestModeData::clearU32FICBER() {
    if (hasU32FICBER()) {
         clear_has_u32FICBER();
        _u32FICBER = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU32FICBER () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_DAB_TestModeData::getU32FICBER () const {
    return _u32FICBER;
}

inline void T_DAB_TestModeData::setU32FICBER (uint32 u32FICBER_) {
    set_has_u32FICBER();
    this->_u32FICBER = u32FICBER_;
}

inline void T_DAB_TestModeData::clearU32NETBER() {
    if (hasU32NETBER()) {
         clear_has_u32NETBER();
        _u32NETBER = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU32NETBER () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_DAB_TestModeData::getU32NETBER () const {
    return _u32NETBER;
}

inline void T_DAB_TestModeData::setU32NETBER (uint32 u32NETBER_) {
    set_has_u32NETBER();
    this->_u32NETBER = u32NETBER_;
}

inline void T_DAB_TestModeData::clearU8RSFEC() {
    if (hasU8RSFEC()) {
         clear_has_u8RSFEC();
        _u8RSFEC = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU8RSFEC () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_TestModeData::getU8RSFEC () const {
    return _u8RSFEC;
}

inline void T_DAB_TestModeData::setU8RSFEC (uint8 u8RSFEC_) {
    set_has_u8RSFEC();
    this->_u8RSFEC = u8RSFEC_;
}

inline void T_DAB_TestModeData::clearU8DABMode() {
    if (hasU8DABMode()) {
         clear_has_u8DABMode();
        _u8DABMode = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU8DABMode () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_DAB_TestModeData::getU8DABMode () const {
    return _u8DABMode;
}

inline void T_DAB_TestModeData::setU8DABMode (uint8 u8DABMode_) {
    set_has_u8DABMode();
    this->_u8DABMode = u8DABMode_;
}

inline void T_DAB_TestModeData::clearU8ProtectionLevel() {
    if (hasU8ProtectionLevel()) {
         clear_has_u8ProtectionLevel();
        _u8ProtectionLevel = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU8ProtectionLevel () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_DAB_TestModeData::getU8ProtectionLevel () const {
    return _u8ProtectionLevel;
}

inline void T_DAB_TestModeData::setU8ProtectionLevel (uint8 u8ProtectionLevel_) {
    set_has_u8ProtectionLevel();
    this->_u8ProtectionLevel = u8ProtectionLevel_;
}

inline void T_DAB_TestModeData::clearU8ConcealmentLevel() {
    if (hasU8ConcealmentLevel()) {
         clear_has_u8ConcealmentLevel();
        _u8ConcealmentLevel = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU8ConcealmentLevel () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_DAB_TestModeData::getU8ConcealmentLevel () const {
    return _u8ConcealmentLevel;
}

inline void T_DAB_TestModeData::setU8ConcealmentLevel (uint8 u8ConcealmentLevel_) {
    set_has_u8ConcealmentLevel();
    this->_u8ConcealmentLevel = u8ConcealmentLevel_;
}

inline void T_DAB_TestModeData::clearE8ServiceLinkingMode() {
    if (hasE8ServiceLinkingMode()) {
         clear_has_e8ServiceLinkingMode();
        _e8ServiceLinkingMode = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_OFF;
     }
}

inline bool T_DAB_TestModeData::hasE8ServiceLinkingMode () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline T_e8_DAB_ServiceLinkingMode T_DAB_TestModeData::getE8ServiceLinkingMode () const {
    return _e8ServiceLinkingMode;
}

inline void T_DAB_TestModeData::setE8ServiceLinkingMode (T_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_ServiceLinkingMode_IsValid(e8ServiceLinkingMode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ServiceLinkingMode_, "T_e8_DAB_ServiceLinkingMode", "e8ServiceLinkingMode", "T_DAB_TestModeData");
    }
    set_has_e8ServiceLinkingMode();
    this->_e8ServiceLinkingMode = e8ServiceLinkingMode_;
}

inline void T_DAB_TestModeData::clearB8ValidFMValues() {
    if (hasB8ValidFMValues()) {
         clear_has_b8ValidFMValues();
        _b8ValidFMValues = T_b8_DAB_ALT_FM_Valid_Flags ();
     }
}

inline bool T_DAB_TestModeData::hasB8ValidFMValues () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const T_b8_DAB_ALT_FM_Valid_Flags& T_DAB_TestModeData::getB8ValidFMValues () const {
    return _b8ValidFMValues;
}

inline T_b8_DAB_ALT_FM_Valid_Flags& T_DAB_TestModeData::getB8ValidFMValuesMutable () {
    set_has_b8ValidFMValues();
    return _b8ValidFMValues;
}

inline void T_DAB_TestModeData::setB8ValidFMValues (const T_b8_DAB_ALT_FM_Valid_Flags& b8ValidFMValues_) {
    set_has_b8ValidFMValues();
    this->_b8ValidFMValues = b8ValidFMValues_;
}

inline void T_DAB_TestModeData::clearU16AltFMPI() {
    if (hasU16AltFMPI()) {
         clear_has_u16AltFMPI();
        _u16AltFMPI = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU16AltFMPI () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint16 T_DAB_TestModeData::getU16AltFMPI () const {
    return _u16AltFMPI;
}

inline void T_DAB_TestModeData::setU16AltFMPI (uint16 u16AltFMPI_) {
    set_has_u16AltFMPI();
    this->_u16AltFMPI = u16AltFMPI_;
}

inline void T_DAB_TestModeData::clearU32AltFMFrequency() {
    if (hasU32AltFMFrequency()) {
         clear_has_u32AltFMFrequency();
        _u32AltFMFrequency = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU32AltFMFrequency () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint32 T_DAB_TestModeData::getU32AltFMFrequency () const {
    return _u32AltFMFrequency;
}

inline void T_DAB_TestModeData::setU32AltFMFrequency (uint32 u32AltFMFrequency_) {
    set_has_u32AltFMFrequency();
    this->_u32AltFMFrequency = u32AltFMFrequency_;
}

inline void T_DAB_TestModeData::clearU8AltFMQuality() {
    if (hasU8AltFMQuality()) {
         clear_has_u8AltFMQuality();
        _u8AltFMQuality = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU8AltFMQuality () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint8 T_DAB_TestModeData::getU8AltFMQuality () const {
    return _u8AltFMQuality;
}

inline void T_DAB_TestModeData::setU8AltFMQuality (uint8 u8AltFMQuality_) {
    set_has_u8AltFMQuality();
    this->_u8AltFMQuality = u8AltFMQuality_;
}

inline void T_DAB_TestModeData::clearB8Flags() {
    if (hasB8Flags()) {
         clear_has_b8Flags();
        _b8Flags = T_b8_DAB_TestMode_Flags ();
     }
}

inline bool T_DAB_TestModeData::hasB8Flags () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const T_b8_DAB_TestMode_Flags& T_DAB_TestModeData::getB8Flags () const {
    return _b8Flags;
}

inline T_b8_DAB_TestMode_Flags& T_DAB_TestModeData::getB8FlagsMutable () {
    set_has_b8Flags();
    return _b8Flags;
}

inline void T_DAB_TestModeData::setB8Flags (const T_b8_DAB_TestMode_Flags& b8Flags_) {
    set_has_b8Flags();
    this->_b8Flags = b8Flags_;
}

inline void T_DAB_TestModeData::clearS8FieldStrength() {
    if (hasS8FieldStrength()) {
         clear_has_s8FieldStrength();
        _s8FieldStrength = 0;
     }
}

inline bool T_DAB_TestModeData::hasS8FieldStrength () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline int8 T_DAB_TestModeData::getS8FieldStrength () const {
    return _s8FieldStrength;
}

inline void T_DAB_TestModeData::setS8FieldStrength (int8 s8FieldStrength_) {
    set_has_s8FieldStrength();
    this->_s8FieldStrength = s8FieldStrength_;
}

inline void T_DAB_TestModeData::clearU16TotalNumberLinks() {
    if (hasU16TotalNumberLinks()) {
         clear_has_u16TotalNumberLinks();
        _u16TotalNumberLinks = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU16TotalNumberLinks () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint16 T_DAB_TestModeData::getU16TotalNumberLinks () const {
    return _u16TotalNumberLinks;
}

inline void T_DAB_TestModeData::setU16TotalNumberLinks (uint16 u16TotalNumberLinks_) {
    set_has_u16TotalNumberLinks();
    this->_u16TotalNumberLinks = u16TotalNumberLinks_;
}

inline void T_DAB_TestModeData::clearU8ECC() {
    if (hasU8ECC()) {
         clear_has_u8ECC();
        _u8ECC = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU8ECC () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint8 T_DAB_TestModeData::getU8ECC () const {
    return _u8ECC;
}

inline void T_DAB_TestModeData::setU8ECC (uint8 u8ECC_) {
    set_has_u8ECC();
    this->_u8ECC = u8ECC_;
}

inline void T_DAB_TestModeData::clearU16CountryLabel() {
    if (hasU16CountryLabel()) {
         clear_has_u16CountryLabel();
        _u16CountryLabel = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU16CountryLabel () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint16 T_DAB_TestModeData::getU16CountryLabel () const {
    return _u16CountryLabel;
}

inline void T_DAB_TestModeData::setU16CountryLabel (uint16 u16CountryLabel_) {
    set_has_u16CountryLabel();
    this->_u16CountryLabel = u16CountryLabel_;
}

inline void T_DAB_TestModeData::clearU16ActivatedLink() {
    if (hasU16ActivatedLink()) {
         clear_has_u16ActivatedLink();
        _u16ActivatedLink = 0u;
     }
}

inline bool T_DAB_TestModeData::hasU16ActivatedLink () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint16 T_DAB_TestModeData::getU16ActivatedLink () const {
    return _u16ActivatedLink;
}

inline void T_DAB_TestModeData::setU16ActivatedLink (uint16 u16ActivatedLink_) {
    set_has_u16ActivatedLink();
    this->_u16ActivatedLink = u16ActivatedLink_;
}

inline void T_DAB_TestModeData::clearLinkList() {
    if (hasLinkList()) {
         clear_has_LinkList();
        _LinkList.clear();
     }
}

inline bool T_DAB_TestModeData::hasLinkList () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline const ::std::vector< T_DAB_LinkListElem >& T_DAB_TestModeData::getLinkList () const {
    return _LinkList;
}

inline ::std::vector< T_DAB_LinkListElem >& T_DAB_TestModeData::getLinkListMutable () {
    set_has_LinkList();
    return _LinkList;
}

inline void T_DAB_TestModeData::setLinkList (const ::std::vector< T_DAB_LinkListElem >& LinkList_) {
    set_has_LinkList();
    this->_LinkList = LinkList_;
}

inline void T_DAB_TestModeData::clearDAB_DMB_AltFreqInfo() {
    if (hasDAB_DMB_AltFreqInfo()) {
         clear_has_DAB_DMB_AltFreqInfo();
        _DAB_DMB_AltFreqInfo.clear();
     }
}

inline bool T_DAB_TestModeData::hasDAB_DMB_AltFreqInfo () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline const ::std::vector< T_DAB_AltFreqInfo >& T_DAB_TestModeData::getDAB_DMB_AltFreqInfo () const {
    return _DAB_DMB_AltFreqInfo;
}

inline ::std::vector< T_DAB_AltFreqInfo >& T_DAB_TestModeData::getDAB_DMB_AltFreqInfoMutable () {
    set_has_DAB_DMB_AltFreqInfo();
    return _DAB_DMB_AltFreqInfo;
}

inline void T_DAB_TestModeData::setDAB_DMB_AltFreqInfo (const ::std::vector< T_DAB_AltFreqInfo >& DAB_DMB_AltFreqInfo_) {
    set_has_DAB_DMB_AltFreqInfo();
    this->_DAB_DMB_AltFreqInfo = DAB_DMB_AltFreqInfo_;
}

inline void T_DAB_TestModeData::clearBSync() {
    if (hasBSync()) {
         clear_has_bSync();
        _bSync = false;
     }
}

inline bool T_DAB_TestModeData::hasBSync () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline bool T_DAB_TestModeData::getBSync () const {
    return _bSync;
}

inline void T_DAB_TestModeData::setBSync (bool bSync_) {
    set_has_bSync();
    this->_bSync = bSync_;
}

inline void T_DAB_TestModeData::set_has_u32CurrentServID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_TestModeData::clear_has_u32CurrentServID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_TestModeData::set_has_u32MSCBER () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_TestModeData::clear_has_u32MSCBER () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_TestModeData::set_has_u32FICBER () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_TestModeData::clear_has_u32FICBER () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_TestModeData::set_has_u32NETBER () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_TestModeData::clear_has_u32NETBER () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_TestModeData::set_has_u8RSFEC () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_TestModeData::clear_has_u8RSFEC () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_TestModeData::set_has_u8DABMode () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_TestModeData::clear_has_u8DABMode () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_TestModeData::set_has_u8ProtectionLevel () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_TestModeData::clear_has_u8ProtectionLevel () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_TestModeData::set_has_u8ConcealmentLevel () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_TestModeData::clear_has_u8ConcealmentLevel () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_TestModeData::set_has_e8ServiceLinkingMode () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_TestModeData::clear_has_e8ServiceLinkingMode () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DAB_TestModeData::set_has_b8ValidFMValues () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DAB_TestModeData::clear_has_b8ValidFMValues () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DAB_TestModeData::set_has_u16AltFMPI () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DAB_TestModeData::clear_has_u16AltFMPI () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DAB_TestModeData::set_has_u32AltFMFrequency () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DAB_TestModeData::clear_has_u32AltFMFrequency () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_DAB_TestModeData::set_has_u8AltFMQuality () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_DAB_TestModeData::clear_has_u8AltFMQuality () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_DAB_TestModeData::set_has_b8Flags () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_DAB_TestModeData::clear_has_b8Flags () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_DAB_TestModeData::set_has_s8FieldStrength () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_DAB_TestModeData::clear_has_s8FieldStrength () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_DAB_TestModeData::set_has_u16TotalNumberLinks () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_DAB_TestModeData::clear_has_u16TotalNumberLinks () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_DAB_TestModeData::set_has_u8ECC () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_DAB_TestModeData::clear_has_u8ECC () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_DAB_TestModeData::set_has_u16CountryLabel () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_DAB_TestModeData::clear_has_u16CountryLabel () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_DAB_TestModeData::set_has_u16ActivatedLink () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_DAB_TestModeData::clear_has_u16ActivatedLink () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_DAB_TestModeData::set_has_LinkList () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_DAB_TestModeData::clear_has_LinkList () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_DAB_TestModeData::set_has_DAB_DMB_AltFreqInfo () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_DAB_TestModeData::clear_has_DAB_DMB_AltFreqInfo () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_DAB_TestModeData::set_has_bSync () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_DAB_TestModeData::clear_has_bSync () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline  T_DAB_BG_TestModeData::T_DAB_BG_TestModeData ()  :
    _u32BgFrequency (0u),
    _u32BgCurrentEnsID (0u),
    _u32BgFICBER (0u),
    _b16BgFlags (),
    _sBgDabMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_BG_TestModeData::T_DAB_BG_TestModeData (const T_DAB_BG_TestModeData &rhs)  :
    _u32BgFrequency (0u),
    _u32BgCurrentEnsID (0u),
    _u32BgFICBER (0u),
    _b16BgFlags (),
    _sBgDabMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_BG_TestModeData::T_DAB_BG_TestModeData (uint32 u32BgFrequency_, uint32 u32BgCurrentEnsID_, uint32 u32BgFICBER_, const T_b16_DAB_TunerStatusFlags& b16BgFlags_, const ::std::string& sBgDabMode_)  :
    _u32BgFrequency (u32BgFrequency_),
    _u32BgCurrentEnsID (u32BgCurrentEnsID_),
    _u32BgFICBER (u32BgFICBER_),
    _b16BgFlags (b16BgFlags_),
    _sBgDabMode (sBgDabMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBgDabMode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_BG_TestModeData::~T_DAB_BG_TestModeData() {
}

inline T_DAB_BG_TestModeData& T_DAB_BG_TestModeData::operator = (const T_DAB_BG_TestModeData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32BgFrequency()) {
            setU32BgFrequency(rhs.getU32BgFrequency());
        } else {
            clearU32BgFrequency();
        }
        if (rhs.hasU32BgCurrentEnsID()) {
            setU32BgCurrentEnsID(rhs.getU32BgCurrentEnsID());
        } else {
            clearU32BgCurrentEnsID();
        }
        if (rhs.hasU32BgFICBER()) {
            setU32BgFICBER(rhs.getU32BgFICBER());
        } else {
            clearU32BgFICBER();
        }
        if (rhs.hasB16BgFlags()) {
            setB16BgFlags(rhs.getB16BgFlags());
        } else {
            clearB16BgFlags();
        }
        if (rhs.hasSBgDabMode()) {
            setSBgDabMode(rhs.getSBgDabMode());
        } else {
            clearSBgDabMode();
        }
    }
    return *this;
}

inline bool T_DAB_BG_TestModeData::operator == (const T_DAB_BG_TestModeData& rhs) const {
    return (((!hasU32BgFrequency() && !rhs.hasU32BgFrequency()) || getU32BgFrequency() == rhs.getU32BgFrequency()) &&
        ((!hasU32BgCurrentEnsID() && !rhs.hasU32BgCurrentEnsID()) || getU32BgCurrentEnsID() == rhs.getU32BgCurrentEnsID()) &&
        ((!hasU32BgFICBER() && !rhs.hasU32BgFICBER()) || getU32BgFICBER() == rhs.getU32BgFICBER()) &&
        ((!hasB16BgFlags() && !rhs.hasB16BgFlags()) || getB16BgFlags() == rhs.getB16BgFlags()) &&
        ((!hasSBgDabMode() && !rhs.hasSBgDabMode()) || getSBgDabMode() == rhs.getSBgDabMode()));
}

inline bool T_DAB_BG_TestModeData::operator != (const T_DAB_BG_TestModeData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_BG_TestModeData::operator < (const T_DAB_BG_TestModeData& rhs) const {
    if (hasU32BgFrequency() || rhs.hasU32BgFrequency()) {
        if (getU32BgFrequency() < rhs.getU32BgFrequency()) return true;
        if (getU32BgFrequency() > rhs.getU32BgFrequency()) return false;
    }
    if (hasU32BgCurrentEnsID() || rhs.hasU32BgCurrentEnsID()) {
        if (getU32BgCurrentEnsID() < rhs.getU32BgCurrentEnsID()) return true;
        if (getU32BgCurrentEnsID() > rhs.getU32BgCurrentEnsID()) return false;
    }
    if (hasU32BgFICBER() || rhs.hasU32BgFICBER()) {
        if (getU32BgFICBER() < rhs.getU32BgFICBER()) return true;
        if (getU32BgFICBER() > rhs.getU32BgFICBER()) return false;
    }
    if (hasB16BgFlags() || rhs.hasB16BgFlags()) {
        if (getB16BgFlags() < rhs.getB16BgFlags()) return true;
        if (getB16BgFlags() > rhs.getB16BgFlags()) return false;
    }
    if (hasSBgDabMode() || rhs.hasSBgDabMode()) {
        if (getSBgDabMode() < rhs.getSBgDabMode()) return true;
        if (getSBgDabMode() > rhs.getSBgDabMode()) return false;
    }
    return false;
}

inline bool T_DAB_BG_TestModeData::operator > (const T_DAB_BG_TestModeData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_BG_TestModeData::clear() {
    clearU32BgFrequency();
    clearU32BgCurrentEnsID();
    clearU32BgFICBER();
    clearB16BgFlags();
    clearSBgDabMode();
}

inline void T_DAB_BG_TestModeData::clearU32BgFrequency() {
    if (hasU32BgFrequency()) {
         clear_has_u32BgFrequency();
        _u32BgFrequency = 0u;
     }
}

inline bool T_DAB_BG_TestModeData::hasU32BgFrequency () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_BG_TestModeData::getU32BgFrequency () const {
    return _u32BgFrequency;
}

inline void T_DAB_BG_TestModeData::setU32BgFrequency (uint32 u32BgFrequency_) {
    set_has_u32BgFrequency();
    this->_u32BgFrequency = u32BgFrequency_;
}

inline void T_DAB_BG_TestModeData::clearU32BgCurrentEnsID() {
    if (hasU32BgCurrentEnsID()) {
         clear_has_u32BgCurrentEnsID();
        _u32BgCurrentEnsID = 0u;
     }
}

inline bool T_DAB_BG_TestModeData::hasU32BgCurrentEnsID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_DAB_BG_TestModeData::getU32BgCurrentEnsID () const {
    return _u32BgCurrentEnsID;
}

inline void T_DAB_BG_TestModeData::setU32BgCurrentEnsID (uint32 u32BgCurrentEnsID_) {
    set_has_u32BgCurrentEnsID();
    this->_u32BgCurrentEnsID = u32BgCurrentEnsID_;
}

inline void T_DAB_BG_TestModeData::clearU32BgFICBER() {
    if (hasU32BgFICBER()) {
         clear_has_u32BgFICBER();
        _u32BgFICBER = 0u;
     }
}

inline bool T_DAB_BG_TestModeData::hasU32BgFICBER () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_DAB_BG_TestModeData::getU32BgFICBER () const {
    return _u32BgFICBER;
}

inline void T_DAB_BG_TestModeData::setU32BgFICBER (uint32 u32BgFICBER_) {
    set_has_u32BgFICBER();
    this->_u32BgFICBER = u32BgFICBER_;
}

inline void T_DAB_BG_TestModeData::clearB16BgFlags() {
    if (hasB16BgFlags()) {
         clear_has_b16BgFlags();
        _b16BgFlags = T_b16_DAB_TunerStatusFlags ();
     }
}

inline bool T_DAB_BG_TestModeData::hasB16BgFlags () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_b16_DAB_TunerStatusFlags& T_DAB_BG_TestModeData::getB16BgFlags () const {
    return _b16BgFlags;
}

inline T_b16_DAB_TunerStatusFlags& T_DAB_BG_TestModeData::getB16BgFlagsMutable () {
    set_has_b16BgFlags();
    return _b16BgFlags;
}

inline void T_DAB_BG_TestModeData::setB16BgFlags (const T_b16_DAB_TunerStatusFlags& b16BgFlags_) {
    set_has_b16BgFlags();
    this->_b16BgFlags = b16BgFlags_;
}

inline void T_DAB_BG_TestModeData::clearSBgDabMode() {
    if (hasSBgDabMode()) {
         clear_has_sBgDabMode();
        _sBgDabMode.clear();
     }
}

inline bool T_DAB_BG_TestModeData::hasSBgDabMode () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_DAB_BG_TestModeData::getSBgDabMode () const {
    return _sBgDabMode;
}

inline ::std::string& T_DAB_BG_TestModeData::getSBgDabModeMutable () {
    set_has_sBgDabMode();
    return _sBgDabMode;
}

inline void T_DAB_BG_TestModeData::setSBgDabMode (const ::std::string& sBgDabMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBgDabMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBgDabMode();
    this->_sBgDabMode = sBgDabMode_;
}

inline void T_DAB_BG_TestModeData::setSBgDabMode (const char* sBgDabMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBgDabMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBgDabMode();
    this->_sBgDabMode.assign(sBgDabMode_);
}

inline void T_DAB_BG_TestModeData::setSBgDabMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBgDabMode();
    this->_sBgDabMode.assign(value, size);
}

inline void T_DAB_BG_TestModeData::set_has_u32BgFrequency () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_BG_TestModeData::clear_has_u32BgFrequency () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_BG_TestModeData::set_has_u32BgCurrentEnsID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_BG_TestModeData::clear_has_u32BgCurrentEnsID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_BG_TestModeData::set_has_u32BgFICBER () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_BG_TestModeData::clear_has_u32BgFICBER () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_BG_TestModeData::set_has_b16BgFlags () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_BG_TestModeData::clear_has_b16BgFlags () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_BG_TestModeData::set_has_sBgDabMode () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_BG_TestModeData::clear_has_sBgDabMode () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_DAB_Time::T_DAB_Time ()  :
    _u32DabSec (0u),
    _u32DabMin (0u),
    _u32DabHour (0u),
    _u32DabMday (0u),
    _u32DabMon (0u),
    _u32DabYear (0u),
    _u32DabWday (0u),
    _u32DabYday (0u),
    _u32DabUtcOff (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_Time::T_DAB_Time (const T_DAB_Time &rhs)  :
    _u32DabSec (0u),
    _u32DabMin (0u),
    _u32DabHour (0u),
    _u32DabMday (0u),
    _u32DabMon (0u),
    _u32DabYear (0u),
    _u32DabWday (0u),
    _u32DabYday (0u),
    _u32DabUtcOff (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_Time::T_DAB_Time (uint32 u32DabSec_, uint32 u32DabMin_, uint32 u32DabHour_, uint32 u32DabMday_, uint32 u32DabMon_, uint32 u32DabYear_, uint32 u32DabWday_, uint32 u32DabYday_, uint32 u32DabUtcOff_)  :
    _u32DabSec (u32DabSec_),
    _u32DabMin (u32DabMin_),
    _u32DabHour (u32DabHour_),
    _u32DabMday (u32DabMday_),
    _u32DabMon (u32DabMon_),
    _u32DabYear (u32DabYear_),
    _u32DabWday (u32DabWday_),
    _u32DabYday (u32DabYday_),
    _u32DabUtcOff (u32DabUtcOff_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_Time::~T_DAB_Time() {
}

inline T_DAB_Time& T_DAB_Time::operator = (const T_DAB_Time& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32DabSec()) {
            setU32DabSec(rhs.getU32DabSec());
        } else {
            clearU32DabSec();
        }
        if (rhs.hasU32DabMin()) {
            setU32DabMin(rhs.getU32DabMin());
        } else {
            clearU32DabMin();
        }
        if (rhs.hasU32DabHour()) {
            setU32DabHour(rhs.getU32DabHour());
        } else {
            clearU32DabHour();
        }
        if (rhs.hasU32DabMday()) {
            setU32DabMday(rhs.getU32DabMday());
        } else {
            clearU32DabMday();
        }
        if (rhs.hasU32DabMon()) {
            setU32DabMon(rhs.getU32DabMon());
        } else {
            clearU32DabMon();
        }
        if (rhs.hasU32DabYear()) {
            setU32DabYear(rhs.getU32DabYear());
        } else {
            clearU32DabYear();
        }
        if (rhs.hasU32DabWday()) {
            setU32DabWday(rhs.getU32DabWday());
        } else {
            clearU32DabWday();
        }
        if (rhs.hasU32DabYday()) {
            setU32DabYday(rhs.getU32DabYday());
        } else {
            clearU32DabYday();
        }
        if (rhs.hasU32DabUtcOff()) {
            setU32DabUtcOff(rhs.getU32DabUtcOff());
        } else {
            clearU32DabUtcOff();
        }
    }
    return *this;
}

inline bool T_DAB_Time::operator == (const T_DAB_Time& rhs) const {
    return (((!hasU32DabSec() && !rhs.hasU32DabSec()) || getU32DabSec() == rhs.getU32DabSec()) &&
        ((!hasU32DabMin() && !rhs.hasU32DabMin()) || getU32DabMin() == rhs.getU32DabMin()) &&
        ((!hasU32DabHour() && !rhs.hasU32DabHour()) || getU32DabHour() == rhs.getU32DabHour()) &&
        ((!hasU32DabMday() && !rhs.hasU32DabMday()) || getU32DabMday() == rhs.getU32DabMday()) &&
        ((!hasU32DabMon() && !rhs.hasU32DabMon()) || getU32DabMon() == rhs.getU32DabMon()) &&
        ((!hasU32DabYear() && !rhs.hasU32DabYear()) || getU32DabYear() == rhs.getU32DabYear()) &&
        ((!hasU32DabWday() && !rhs.hasU32DabWday()) || getU32DabWday() == rhs.getU32DabWday()) &&
        ((!hasU32DabYday() && !rhs.hasU32DabYday()) || getU32DabYday() == rhs.getU32DabYday()) &&
        ((!hasU32DabUtcOff() && !rhs.hasU32DabUtcOff()) || getU32DabUtcOff() == rhs.getU32DabUtcOff()));
}

inline bool T_DAB_Time::operator != (const T_DAB_Time& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_Time::operator < (const T_DAB_Time& rhs) const {
    if (hasU32DabSec() || rhs.hasU32DabSec()) {
        if (getU32DabSec() < rhs.getU32DabSec()) return true;
        if (getU32DabSec() > rhs.getU32DabSec()) return false;
    }
    if (hasU32DabMin() || rhs.hasU32DabMin()) {
        if (getU32DabMin() < rhs.getU32DabMin()) return true;
        if (getU32DabMin() > rhs.getU32DabMin()) return false;
    }
    if (hasU32DabHour() || rhs.hasU32DabHour()) {
        if (getU32DabHour() < rhs.getU32DabHour()) return true;
        if (getU32DabHour() > rhs.getU32DabHour()) return false;
    }
    if (hasU32DabMday() || rhs.hasU32DabMday()) {
        if (getU32DabMday() < rhs.getU32DabMday()) return true;
        if (getU32DabMday() > rhs.getU32DabMday()) return false;
    }
    if (hasU32DabMon() || rhs.hasU32DabMon()) {
        if (getU32DabMon() < rhs.getU32DabMon()) return true;
        if (getU32DabMon() > rhs.getU32DabMon()) return false;
    }
    if (hasU32DabYear() || rhs.hasU32DabYear()) {
        if (getU32DabYear() < rhs.getU32DabYear()) return true;
        if (getU32DabYear() > rhs.getU32DabYear()) return false;
    }
    if (hasU32DabWday() || rhs.hasU32DabWday()) {
        if (getU32DabWday() < rhs.getU32DabWday()) return true;
        if (getU32DabWday() > rhs.getU32DabWday()) return false;
    }
    if (hasU32DabYday() || rhs.hasU32DabYday()) {
        if (getU32DabYday() < rhs.getU32DabYday()) return true;
        if (getU32DabYday() > rhs.getU32DabYday()) return false;
    }
    if (hasU32DabUtcOff() || rhs.hasU32DabUtcOff()) {
        if (getU32DabUtcOff() < rhs.getU32DabUtcOff()) return true;
        if (getU32DabUtcOff() > rhs.getU32DabUtcOff()) return false;
    }
    return false;
}

inline bool T_DAB_Time::operator > (const T_DAB_Time& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_Time::clear() {
    clearU32DabSec();
    clearU32DabMin();
    clearU32DabHour();
    clearU32DabMday();
    clearU32DabMon();
    clearU32DabYear();
    clearU32DabWday();
    clearU32DabYday();
    clearU32DabUtcOff();
}

inline void T_DAB_Time::clearU32DabSec() {
    if (hasU32DabSec()) {
         clear_has_u32DabSec();
        _u32DabSec = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabSec () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_Time::getU32DabSec () const {
    return _u32DabSec;
}

inline void T_DAB_Time::setU32DabSec (uint32 u32DabSec_) {
    set_has_u32DabSec();
    this->_u32DabSec = u32DabSec_;
}

inline void T_DAB_Time::clearU32DabMin() {
    if (hasU32DabMin()) {
         clear_has_u32DabMin();
        _u32DabMin = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabMin () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_DAB_Time::getU32DabMin () const {
    return _u32DabMin;
}

inline void T_DAB_Time::setU32DabMin (uint32 u32DabMin_) {
    set_has_u32DabMin();
    this->_u32DabMin = u32DabMin_;
}

inline void T_DAB_Time::clearU32DabHour() {
    if (hasU32DabHour()) {
         clear_has_u32DabHour();
        _u32DabHour = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabHour () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_DAB_Time::getU32DabHour () const {
    return _u32DabHour;
}

inline void T_DAB_Time::setU32DabHour (uint32 u32DabHour_) {
    set_has_u32DabHour();
    this->_u32DabHour = u32DabHour_;
}

inline void T_DAB_Time::clearU32DabMday() {
    if (hasU32DabMday()) {
         clear_has_u32DabMday();
        _u32DabMday = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabMday () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_DAB_Time::getU32DabMday () const {
    return _u32DabMday;
}

inline void T_DAB_Time::setU32DabMday (uint32 u32DabMday_) {
    set_has_u32DabMday();
    this->_u32DabMday = u32DabMday_;
}

inline void T_DAB_Time::clearU32DabMon() {
    if (hasU32DabMon()) {
         clear_has_u32DabMon();
        _u32DabMon = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabMon () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_DAB_Time::getU32DabMon () const {
    return _u32DabMon;
}

inline void T_DAB_Time::setU32DabMon (uint32 u32DabMon_) {
    set_has_u32DabMon();
    this->_u32DabMon = u32DabMon_;
}

inline void T_DAB_Time::clearU32DabYear() {
    if (hasU32DabYear()) {
         clear_has_u32DabYear();
        _u32DabYear = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabYear () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_DAB_Time::getU32DabYear () const {
    return _u32DabYear;
}

inline void T_DAB_Time::setU32DabYear (uint32 u32DabYear_) {
    set_has_u32DabYear();
    this->_u32DabYear = u32DabYear_;
}

inline void T_DAB_Time::clearU32DabWday() {
    if (hasU32DabWday()) {
         clear_has_u32DabWday();
        _u32DabWday = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabWday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_DAB_Time::getU32DabWday () const {
    return _u32DabWday;
}

inline void T_DAB_Time::setU32DabWday (uint32 u32DabWday_) {
    set_has_u32DabWday();
    this->_u32DabWday = u32DabWday_;
}

inline void T_DAB_Time::clearU32DabYday() {
    if (hasU32DabYday()) {
         clear_has_u32DabYday();
        _u32DabYday = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabYday () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_DAB_Time::getU32DabYday () const {
    return _u32DabYday;
}

inline void T_DAB_Time::setU32DabYday (uint32 u32DabYday_) {
    set_has_u32DabYday();
    this->_u32DabYday = u32DabYday_;
}

inline void T_DAB_Time::clearU32DabUtcOff() {
    if (hasU32DabUtcOff()) {
         clear_has_u32DabUtcOff();
        _u32DabUtcOff = 0u;
     }
}

inline bool T_DAB_Time::hasU32DabUtcOff () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_DAB_Time::getU32DabUtcOff () const {
    return _u32DabUtcOff;
}

inline void T_DAB_Time::setU32DabUtcOff (uint32 u32DabUtcOff_) {
    set_has_u32DabUtcOff();
    this->_u32DabUtcOff = u32DabUtcOff_;
}

inline void T_DAB_Time::set_has_u32DabSec () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_Time::clear_has_u32DabSec () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_Time::set_has_u32DabMin () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_Time::clear_has_u32DabMin () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_Time::set_has_u32DabHour () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_Time::clear_has_u32DabHour () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_Time::set_has_u32DabMday () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_Time::clear_has_u32DabMday () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_Time::set_has_u32DabMon () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_Time::clear_has_u32DabMon () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_Time::set_has_u32DabYear () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_Time::clear_has_u32DabYear () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_Time::set_has_u32DabWday () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_Time::clear_has_u32DabWday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_Time::set_has_u32DabYday () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_Time::clear_has_u32DabYday () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_Time::set_has_u32DabUtcOff () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_Time::clear_has_u32DabUtcOff () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_DAB_TMC_TPEG_TestModeData::T_DAB_TMC_TPEG_TestModeData ()  :
    _u32NumTmcServices (0u),
    _u32NumTpegServices (0u),
    _u32RcvTmcMsgs (0u),
    _u32RcvTpegMsgs (0u),
    _DabTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_TMC_TPEG_TestModeData::T_DAB_TMC_TPEG_TestModeData (const T_DAB_TMC_TPEG_TestModeData &rhs)  :
    _u32NumTmcServices (0u),
    _u32NumTpegServices (0u),
    _u32RcvTmcMsgs (0u),
    _u32RcvTpegMsgs (0u),
    _DabTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_TMC_TPEG_TestModeData::T_DAB_TMC_TPEG_TestModeData (uint32 u32NumTmcServices_, uint32 u32NumTpegServices_, uint32 u32RcvTmcMsgs_, uint32 u32RcvTpegMsgs_, const T_DAB_Time& DabTime_)  :
    _u32NumTmcServices (u32NumTmcServices_),
    _u32NumTpegServices (u32NumTpegServices_),
    _u32RcvTmcMsgs (u32RcvTmcMsgs_),
    _u32RcvTpegMsgs (u32RcvTpegMsgs_),
    _DabTime (DabTime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_TMC_TPEG_TestModeData::~T_DAB_TMC_TPEG_TestModeData() {
}

inline T_DAB_TMC_TPEG_TestModeData& T_DAB_TMC_TPEG_TestModeData::operator = (const T_DAB_TMC_TPEG_TestModeData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32NumTmcServices()) {
            setU32NumTmcServices(rhs.getU32NumTmcServices());
        } else {
            clearU32NumTmcServices();
        }
        if (rhs.hasU32NumTpegServices()) {
            setU32NumTpegServices(rhs.getU32NumTpegServices());
        } else {
            clearU32NumTpegServices();
        }
        if (rhs.hasU32RcvTmcMsgs()) {
            setU32RcvTmcMsgs(rhs.getU32RcvTmcMsgs());
        } else {
            clearU32RcvTmcMsgs();
        }
        if (rhs.hasU32RcvTpegMsgs()) {
            setU32RcvTpegMsgs(rhs.getU32RcvTpegMsgs());
        } else {
            clearU32RcvTpegMsgs();
        }
        if (rhs.hasDabTime()) {
            setDabTime(rhs.getDabTime());
        } else {
            clearDabTime();
        }
    }
    return *this;
}

inline bool T_DAB_TMC_TPEG_TestModeData::operator == (const T_DAB_TMC_TPEG_TestModeData& rhs) const {
    return (((!hasU32NumTmcServices() && !rhs.hasU32NumTmcServices()) || getU32NumTmcServices() == rhs.getU32NumTmcServices()) &&
        ((!hasU32NumTpegServices() && !rhs.hasU32NumTpegServices()) || getU32NumTpegServices() == rhs.getU32NumTpegServices()) &&
        ((!hasU32RcvTmcMsgs() && !rhs.hasU32RcvTmcMsgs()) || getU32RcvTmcMsgs() == rhs.getU32RcvTmcMsgs()) &&
        ((!hasU32RcvTpegMsgs() && !rhs.hasU32RcvTpegMsgs()) || getU32RcvTpegMsgs() == rhs.getU32RcvTpegMsgs()) &&
        ((!hasDabTime() && !rhs.hasDabTime()) || getDabTime() == rhs.getDabTime()));
}

inline bool T_DAB_TMC_TPEG_TestModeData::operator != (const T_DAB_TMC_TPEG_TestModeData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_TMC_TPEG_TestModeData::operator < (const T_DAB_TMC_TPEG_TestModeData& rhs) const {
    if (hasU32NumTmcServices() || rhs.hasU32NumTmcServices()) {
        if (getU32NumTmcServices() < rhs.getU32NumTmcServices()) return true;
        if (getU32NumTmcServices() > rhs.getU32NumTmcServices()) return false;
    }
    if (hasU32NumTpegServices() || rhs.hasU32NumTpegServices()) {
        if (getU32NumTpegServices() < rhs.getU32NumTpegServices()) return true;
        if (getU32NumTpegServices() > rhs.getU32NumTpegServices()) return false;
    }
    if (hasU32RcvTmcMsgs() || rhs.hasU32RcvTmcMsgs()) {
        if (getU32RcvTmcMsgs() < rhs.getU32RcvTmcMsgs()) return true;
        if (getU32RcvTmcMsgs() > rhs.getU32RcvTmcMsgs()) return false;
    }
    if (hasU32RcvTpegMsgs() || rhs.hasU32RcvTpegMsgs()) {
        if (getU32RcvTpegMsgs() < rhs.getU32RcvTpegMsgs()) return true;
        if (getU32RcvTpegMsgs() > rhs.getU32RcvTpegMsgs()) return false;
    }
    if (hasDabTime() || rhs.hasDabTime()) {
        if (getDabTime() < rhs.getDabTime()) return true;
        if (getDabTime() > rhs.getDabTime()) return false;
    }
    return false;
}

inline bool T_DAB_TMC_TPEG_TestModeData::operator > (const T_DAB_TMC_TPEG_TestModeData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_TMC_TPEG_TestModeData::clear() {
    clearU32NumTmcServices();
    clearU32NumTpegServices();
    clearU32RcvTmcMsgs();
    clearU32RcvTpegMsgs();
    clearDabTime();
}

inline void T_DAB_TMC_TPEG_TestModeData::clearU32NumTmcServices() {
    if (hasU32NumTmcServices()) {
         clear_has_u32NumTmcServices();
        _u32NumTmcServices = 0u;
     }
}

inline bool T_DAB_TMC_TPEG_TestModeData::hasU32NumTmcServices () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_TMC_TPEG_TestModeData::getU32NumTmcServices () const {
    return _u32NumTmcServices;
}

inline void T_DAB_TMC_TPEG_TestModeData::setU32NumTmcServices (uint32 u32NumTmcServices_) {
    set_has_u32NumTmcServices();
    this->_u32NumTmcServices = u32NumTmcServices_;
}

inline void T_DAB_TMC_TPEG_TestModeData::clearU32NumTpegServices() {
    if (hasU32NumTpegServices()) {
         clear_has_u32NumTpegServices();
        _u32NumTpegServices = 0u;
     }
}

inline bool T_DAB_TMC_TPEG_TestModeData::hasU32NumTpegServices () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_DAB_TMC_TPEG_TestModeData::getU32NumTpegServices () const {
    return _u32NumTpegServices;
}

inline void T_DAB_TMC_TPEG_TestModeData::setU32NumTpegServices (uint32 u32NumTpegServices_) {
    set_has_u32NumTpegServices();
    this->_u32NumTpegServices = u32NumTpegServices_;
}

inline void T_DAB_TMC_TPEG_TestModeData::clearU32RcvTmcMsgs() {
    if (hasU32RcvTmcMsgs()) {
         clear_has_u32RcvTmcMsgs();
        _u32RcvTmcMsgs = 0u;
     }
}

inline bool T_DAB_TMC_TPEG_TestModeData::hasU32RcvTmcMsgs () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_DAB_TMC_TPEG_TestModeData::getU32RcvTmcMsgs () const {
    return _u32RcvTmcMsgs;
}

inline void T_DAB_TMC_TPEG_TestModeData::setU32RcvTmcMsgs (uint32 u32RcvTmcMsgs_) {
    set_has_u32RcvTmcMsgs();
    this->_u32RcvTmcMsgs = u32RcvTmcMsgs_;
}

inline void T_DAB_TMC_TPEG_TestModeData::clearU32RcvTpegMsgs() {
    if (hasU32RcvTpegMsgs()) {
         clear_has_u32RcvTpegMsgs();
        _u32RcvTpegMsgs = 0u;
     }
}

inline bool T_DAB_TMC_TPEG_TestModeData::hasU32RcvTpegMsgs () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_DAB_TMC_TPEG_TestModeData::getU32RcvTpegMsgs () const {
    return _u32RcvTpegMsgs;
}

inline void T_DAB_TMC_TPEG_TestModeData::setU32RcvTpegMsgs (uint32 u32RcvTpegMsgs_) {
    set_has_u32RcvTpegMsgs();
    this->_u32RcvTpegMsgs = u32RcvTpegMsgs_;
}

inline void T_DAB_TMC_TPEG_TestModeData::clearDabTime() {
    if (hasDabTime()) {
         clear_has_DabTime();
        _DabTime.clear();
     }
}

inline bool T_DAB_TMC_TPEG_TestModeData::hasDabTime () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_DAB_Time& T_DAB_TMC_TPEG_TestModeData::getDabTime () const {
    return _DabTime;
}

inline T_DAB_Time& T_DAB_TMC_TPEG_TestModeData::getDabTimeMutable () {
    set_has_DabTime();
    return _DabTime;
}

inline void T_DAB_TMC_TPEG_TestModeData::setDabTime (const T_DAB_Time& DabTime_) {
    set_has_DabTime();
    this->_DabTime = DabTime_;
}

inline void T_DAB_TMC_TPEG_TestModeData::set_has_u32NumTmcServices () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_TMC_TPEG_TestModeData::clear_has_u32NumTmcServices () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_TMC_TPEG_TestModeData::set_has_u32NumTpegServices () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_TMC_TPEG_TestModeData::clear_has_u32NumTpegServices () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_TMC_TPEG_TestModeData::set_has_u32RcvTmcMsgs () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_TMC_TPEG_TestModeData::clear_has_u32RcvTmcMsgs () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_TMC_TPEG_TestModeData::set_has_u32RcvTpegMsgs () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_TMC_TPEG_TestModeData::clear_has_u32RcvTpegMsgs () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_TMC_TPEG_TestModeData::set_has_DabTime () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_TMC_TPEG_TestModeData::clear_has_DabTime () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_DAB_RdbId::T_DAB_RdbId ()  :
    _u8Cc (0u),
    _u8Ltn (0u),
    _u8Bsa (0u),
    _u16Bsa (0u),
    _u8Sid (0u),
    _bEncrypted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_RdbId::T_DAB_RdbId (const T_DAB_RdbId &rhs)  :
    _u8Cc (0u),
    _u8Ltn (0u),
    _u8Bsa (0u),
    _u16Bsa (0u),
    _u8Sid (0u),
    _bEncrypted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_RdbId::T_DAB_RdbId (uint8 u8Cc_, uint8 u8Ltn_, uint8 u8Bsa_, uint16 u16Bsa_, uint8 u8Sid_, bool bEncrypted_)  :
    _u8Cc (u8Cc_),
    _u8Ltn (u8Ltn_),
    _u8Bsa (u8Bsa_),
    _u16Bsa (u16Bsa_),
    _u8Sid (u8Sid_),
    _bEncrypted (bEncrypted_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_RdbId::~T_DAB_RdbId() {
}

inline T_DAB_RdbId& T_DAB_RdbId::operator = (const T_DAB_RdbId& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Cc()) {
            setU8Cc(rhs.getU8Cc());
        } else {
            clearU8Cc();
        }
        if (rhs.hasU8Ltn()) {
            setU8Ltn(rhs.getU8Ltn());
        } else {
            clearU8Ltn();
        }
        if (rhs.hasU8Bsa()) {
            setU8Bsa(rhs.getU8Bsa());
        } else {
            clearU8Bsa();
        }
        if (rhs.hasU16Bsa()) {
            setU16Bsa(rhs.getU16Bsa());
        } else {
            clearU16Bsa();
        }
        if (rhs.hasU8Sid()) {
            setU8Sid(rhs.getU8Sid());
        } else {
            clearU8Sid();
        }
        if (rhs.hasBEncrypted()) {
            setBEncrypted(rhs.getBEncrypted());
        } else {
            clearBEncrypted();
        }
    }
    return *this;
}

inline bool T_DAB_RdbId::operator == (const T_DAB_RdbId& rhs) const {
    return (((!hasU8Cc() && !rhs.hasU8Cc()) || getU8Cc() == rhs.getU8Cc()) &&
        ((!hasU8Ltn() && !rhs.hasU8Ltn()) || getU8Ltn() == rhs.getU8Ltn()) &&
        ((!hasU8Bsa() && !rhs.hasU8Bsa()) || getU8Bsa() == rhs.getU8Bsa()) &&
        ((!hasU16Bsa() && !rhs.hasU16Bsa()) || getU16Bsa() == rhs.getU16Bsa()) &&
        ((!hasU8Sid() && !rhs.hasU8Sid()) || getU8Sid() == rhs.getU8Sid()) &&
        ((!hasBEncrypted() && !rhs.hasBEncrypted()) || getBEncrypted() == rhs.getBEncrypted()));
}

inline bool T_DAB_RdbId::operator != (const T_DAB_RdbId& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_RdbId::operator < (const T_DAB_RdbId& rhs) const {
    if (hasU8Cc() || rhs.hasU8Cc()) {
        if (getU8Cc() < rhs.getU8Cc()) return true;
        if (getU8Cc() > rhs.getU8Cc()) return false;
    }
    if (hasU8Ltn() || rhs.hasU8Ltn()) {
        if (getU8Ltn() < rhs.getU8Ltn()) return true;
        if (getU8Ltn() > rhs.getU8Ltn()) return false;
    }
    if (hasU8Bsa() || rhs.hasU8Bsa()) {
        if (getU8Bsa() < rhs.getU8Bsa()) return true;
        if (getU8Bsa() > rhs.getU8Bsa()) return false;
    }
    if (hasU16Bsa() || rhs.hasU16Bsa()) {
        if (getU16Bsa() < rhs.getU16Bsa()) return true;
        if (getU16Bsa() > rhs.getU16Bsa()) return false;
    }
    if (hasU8Sid() || rhs.hasU8Sid()) {
        if (getU8Sid() < rhs.getU8Sid()) return true;
        if (getU8Sid() > rhs.getU8Sid()) return false;
    }
    if (hasBEncrypted() || rhs.hasBEncrypted()) {
        if (getBEncrypted() < rhs.getBEncrypted()) return true;
        if (getBEncrypted() > rhs.getBEncrypted()) return false;
    }
    return false;
}

inline bool T_DAB_RdbId::operator > (const T_DAB_RdbId& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_RdbId::clear() {
    clearU8Cc();
    clearU8Ltn();
    clearU8Bsa();
    clearU16Bsa();
    clearU8Sid();
    clearBEncrypted();
}

inline void T_DAB_RdbId::clearU8Cc() {
    if (hasU8Cc()) {
         clear_has_u8Cc();
        _u8Cc = 0u;
     }
}

inline bool T_DAB_RdbId::hasU8Cc () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_DAB_RdbId::getU8Cc () const {
    return _u8Cc;
}

inline void T_DAB_RdbId::setU8Cc (uint8 u8Cc_) {
    set_has_u8Cc();
    this->_u8Cc = u8Cc_;
}

inline void T_DAB_RdbId::clearU8Ltn() {
    if (hasU8Ltn()) {
         clear_has_u8Ltn();
        _u8Ltn = 0u;
     }
}

inline bool T_DAB_RdbId::hasU8Ltn () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_DAB_RdbId::getU8Ltn () const {
    return _u8Ltn;
}

inline void T_DAB_RdbId::setU8Ltn (uint8 u8Ltn_) {
    set_has_u8Ltn();
    this->_u8Ltn = u8Ltn_;
}

inline void T_DAB_RdbId::clearU8Bsa() {
    if (hasU8Bsa()) {
         clear_has_u8Bsa();
        _u8Bsa = 0u;
     }
}

inline bool T_DAB_RdbId::hasU8Bsa () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_DAB_RdbId::getU8Bsa () const {
    return _u8Bsa;
}

inline void T_DAB_RdbId::setU8Bsa (uint8 u8Bsa_) {
    set_has_u8Bsa();
    this->_u8Bsa = u8Bsa_;
}

inline void T_DAB_RdbId::clearU16Bsa() {
    if (hasU16Bsa()) {
         clear_has_u16Bsa();
        _u16Bsa = 0u;
     }
}

inline bool T_DAB_RdbId::hasU16Bsa () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_DAB_RdbId::getU16Bsa () const {
    return _u16Bsa;
}

inline void T_DAB_RdbId::setU16Bsa (uint16 u16Bsa_) {
    set_has_u16Bsa();
    this->_u16Bsa = u16Bsa_;
}

inline void T_DAB_RdbId::clearU8Sid() {
    if (hasU8Sid()) {
         clear_has_u8Sid();
        _u8Sid = 0u;
     }
}

inline bool T_DAB_RdbId::hasU8Sid () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_RdbId::getU8Sid () const {
    return _u8Sid;
}

inline void T_DAB_RdbId::setU8Sid (uint8 u8Sid_) {
    set_has_u8Sid();
    this->_u8Sid = u8Sid_;
}

inline void T_DAB_RdbId::clearBEncrypted() {
    if (hasBEncrypted()) {
         clear_has_bEncrypted();
        _bEncrypted = false;
     }
}

inline bool T_DAB_RdbId::hasBEncrypted () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_DAB_RdbId::getBEncrypted () const {
    return _bEncrypted;
}

inline void T_DAB_RdbId::setBEncrypted (bool bEncrypted_) {
    set_has_bEncrypted();
    this->_bEncrypted = bEncrypted_;
}

inline void T_DAB_RdbId::set_has_u8Cc () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_RdbId::clear_has_u8Cc () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_RdbId::set_has_u8Ltn () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_RdbId::clear_has_u8Ltn () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_RdbId::set_has_u8Bsa () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_RdbId::clear_has_u8Bsa () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_RdbId::set_has_u16Bsa () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_RdbId::clear_has_u16Bsa () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_RdbId::set_has_u8Sid () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_RdbId::clear_has_u8Sid () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_RdbId::set_has_bEncrypted () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_RdbId::clear_has_bEncrypted () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_DAB_TmcData::T_DAB_TmcData ()  :
    _u8TmcData1 (0u),
    _u8TmcData2 (0u),
    _u8TmcData3 (0u),
    _u8TmcData4 (0u),
    _u8TmcData5 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_TmcData::T_DAB_TmcData (const T_DAB_TmcData &rhs)  :
    _u8TmcData1 (0u),
    _u8TmcData2 (0u),
    _u8TmcData3 (0u),
    _u8TmcData4 (0u),
    _u8TmcData5 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_TmcData::T_DAB_TmcData (uint8 u8TmcData1_, uint8 u8TmcData2_, uint8 u8TmcData3_, uint8 u8TmcData4_, uint8 u8TmcData5_)  :
    _u8TmcData1 (u8TmcData1_),
    _u8TmcData2 (u8TmcData2_),
    _u8TmcData3 (u8TmcData3_),
    _u8TmcData4 (u8TmcData4_),
    _u8TmcData5 (u8TmcData5_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_TmcData::~T_DAB_TmcData() {
}

inline T_DAB_TmcData& T_DAB_TmcData::operator = (const T_DAB_TmcData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8TmcData1()) {
            setU8TmcData1(rhs.getU8TmcData1());
        } else {
            clearU8TmcData1();
        }
        if (rhs.hasU8TmcData2()) {
            setU8TmcData2(rhs.getU8TmcData2());
        } else {
            clearU8TmcData2();
        }
        if (rhs.hasU8TmcData3()) {
            setU8TmcData3(rhs.getU8TmcData3());
        } else {
            clearU8TmcData3();
        }
        if (rhs.hasU8TmcData4()) {
            setU8TmcData4(rhs.getU8TmcData4());
        } else {
            clearU8TmcData4();
        }
        if (rhs.hasU8TmcData5()) {
            setU8TmcData5(rhs.getU8TmcData5());
        } else {
            clearU8TmcData5();
        }
    }
    return *this;
}

inline bool T_DAB_TmcData::operator == (const T_DAB_TmcData& rhs) const {
    return (((!hasU8TmcData1() && !rhs.hasU8TmcData1()) || getU8TmcData1() == rhs.getU8TmcData1()) &&
        ((!hasU8TmcData2() && !rhs.hasU8TmcData2()) || getU8TmcData2() == rhs.getU8TmcData2()) &&
        ((!hasU8TmcData3() && !rhs.hasU8TmcData3()) || getU8TmcData3() == rhs.getU8TmcData3()) &&
        ((!hasU8TmcData4() && !rhs.hasU8TmcData4()) || getU8TmcData4() == rhs.getU8TmcData4()) &&
        ((!hasU8TmcData5() && !rhs.hasU8TmcData5()) || getU8TmcData5() == rhs.getU8TmcData5()));
}

inline bool T_DAB_TmcData::operator != (const T_DAB_TmcData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_TmcData::operator < (const T_DAB_TmcData& rhs) const {
    if (hasU8TmcData1() || rhs.hasU8TmcData1()) {
        if (getU8TmcData1() < rhs.getU8TmcData1()) return true;
        if (getU8TmcData1() > rhs.getU8TmcData1()) return false;
    }
    if (hasU8TmcData2() || rhs.hasU8TmcData2()) {
        if (getU8TmcData2() < rhs.getU8TmcData2()) return true;
        if (getU8TmcData2() > rhs.getU8TmcData2()) return false;
    }
    if (hasU8TmcData3() || rhs.hasU8TmcData3()) {
        if (getU8TmcData3() < rhs.getU8TmcData3()) return true;
        if (getU8TmcData3() > rhs.getU8TmcData3()) return false;
    }
    if (hasU8TmcData4() || rhs.hasU8TmcData4()) {
        if (getU8TmcData4() < rhs.getU8TmcData4()) return true;
        if (getU8TmcData4() > rhs.getU8TmcData4()) return false;
    }
    if (hasU8TmcData5() || rhs.hasU8TmcData5()) {
        if (getU8TmcData5() < rhs.getU8TmcData5()) return true;
        if (getU8TmcData5() > rhs.getU8TmcData5()) return false;
    }
    return false;
}

inline bool T_DAB_TmcData::operator > (const T_DAB_TmcData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_TmcData::clear() {
    clearU8TmcData1();
    clearU8TmcData2();
    clearU8TmcData3();
    clearU8TmcData4();
    clearU8TmcData5();
}

inline void T_DAB_TmcData::clearU8TmcData1() {
    if (hasU8TmcData1()) {
         clear_has_u8TmcData1();
        _u8TmcData1 = 0u;
     }
}

inline bool T_DAB_TmcData::hasU8TmcData1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_DAB_TmcData::getU8TmcData1 () const {
    return _u8TmcData1;
}

inline void T_DAB_TmcData::setU8TmcData1 (uint8 u8TmcData1_) {
    set_has_u8TmcData1();
    this->_u8TmcData1 = u8TmcData1_;
}

inline void T_DAB_TmcData::clearU8TmcData2() {
    if (hasU8TmcData2()) {
         clear_has_u8TmcData2();
        _u8TmcData2 = 0u;
     }
}

inline bool T_DAB_TmcData::hasU8TmcData2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_DAB_TmcData::getU8TmcData2 () const {
    return _u8TmcData2;
}

inline void T_DAB_TmcData::setU8TmcData2 (uint8 u8TmcData2_) {
    set_has_u8TmcData2();
    this->_u8TmcData2 = u8TmcData2_;
}

inline void T_DAB_TmcData::clearU8TmcData3() {
    if (hasU8TmcData3()) {
         clear_has_u8TmcData3();
        _u8TmcData3 = 0u;
     }
}

inline bool T_DAB_TmcData::hasU8TmcData3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_DAB_TmcData::getU8TmcData3 () const {
    return _u8TmcData3;
}

inline void T_DAB_TmcData::setU8TmcData3 (uint8 u8TmcData3_) {
    set_has_u8TmcData3();
    this->_u8TmcData3 = u8TmcData3_;
}

inline void T_DAB_TmcData::clearU8TmcData4() {
    if (hasU8TmcData4()) {
         clear_has_u8TmcData4();
        _u8TmcData4 = 0u;
     }
}

inline bool T_DAB_TmcData::hasU8TmcData4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_DAB_TmcData::getU8TmcData4 () const {
    return _u8TmcData4;
}

inline void T_DAB_TmcData::setU8TmcData4 (uint8 u8TmcData4_) {
    set_has_u8TmcData4();
    this->_u8TmcData4 = u8TmcData4_;
}

inline void T_DAB_TmcData::clearU8TmcData5() {
    if (hasU8TmcData5()) {
         clear_has_u8TmcData5();
        _u8TmcData5 = 0u;
     }
}

inline bool T_DAB_TmcData::hasU8TmcData5 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_DAB_TmcData::getU8TmcData5 () const {
    return _u8TmcData5;
}

inline void T_DAB_TmcData::setU8TmcData5 (uint8 u8TmcData5_) {
    set_has_u8TmcData5();
    this->_u8TmcData5 = u8TmcData5_;
}

inline void T_DAB_TmcData::set_has_u8TmcData1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_TmcData::clear_has_u8TmcData1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_TmcData::set_has_u8TmcData2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_TmcData::clear_has_u8TmcData2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_TmcData::set_has_u8TmcData3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_TmcData::clear_has_u8TmcData3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_TmcData::set_has_u8TmcData4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_TmcData::clear_has_u8TmcData4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_TmcData::set_has_u8TmcData5 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_TmcData::clear_has_u8TmcData5 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_DAB_Encryption::T_DAB_Encryption ()  :
    _bEncrypted (false),
    _u8EncId (0u),
    _u8TestBits (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_Encryption::T_DAB_Encryption (const T_DAB_Encryption &rhs)  :
    _bEncrypted (false),
    _u8EncId (0u),
    _u8TestBits (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_Encryption::T_DAB_Encryption (bool bEncrypted_, uint8 u8EncId_, uint8 u8TestBits_)  :
    _bEncrypted (bEncrypted_),
    _u8EncId (u8EncId_),
    _u8TestBits (u8TestBits_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_Encryption::~T_DAB_Encryption() {
}

inline T_DAB_Encryption& T_DAB_Encryption::operator = (const T_DAB_Encryption& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBEncrypted()) {
            setBEncrypted(rhs.getBEncrypted());
        } else {
            clearBEncrypted();
        }
        if (rhs.hasU8EncId()) {
            setU8EncId(rhs.getU8EncId());
        } else {
            clearU8EncId();
        }
        if (rhs.hasU8TestBits()) {
            setU8TestBits(rhs.getU8TestBits());
        } else {
            clearU8TestBits();
        }
    }
    return *this;
}

inline bool T_DAB_Encryption::operator == (const T_DAB_Encryption& rhs) const {
    return (((!hasBEncrypted() && !rhs.hasBEncrypted()) || getBEncrypted() == rhs.getBEncrypted()) &&
        ((!hasU8EncId() && !rhs.hasU8EncId()) || getU8EncId() == rhs.getU8EncId()) &&
        ((!hasU8TestBits() && !rhs.hasU8TestBits()) || getU8TestBits() == rhs.getU8TestBits()));
}

inline bool T_DAB_Encryption::operator != (const T_DAB_Encryption& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_Encryption::operator < (const T_DAB_Encryption& rhs) const {
    if (hasBEncrypted() || rhs.hasBEncrypted()) {
        if (getBEncrypted() < rhs.getBEncrypted()) return true;
        if (getBEncrypted() > rhs.getBEncrypted()) return false;
    }
    if (hasU8EncId() || rhs.hasU8EncId()) {
        if (getU8EncId() < rhs.getU8EncId()) return true;
        if (getU8EncId() > rhs.getU8EncId()) return false;
    }
    if (hasU8TestBits() || rhs.hasU8TestBits()) {
        if (getU8TestBits() < rhs.getU8TestBits()) return true;
        if (getU8TestBits() > rhs.getU8TestBits()) return false;
    }
    return false;
}

inline bool T_DAB_Encryption::operator > (const T_DAB_Encryption& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_Encryption::clear() {
    clearBEncrypted();
    clearU8EncId();
    clearU8TestBits();
}

inline void T_DAB_Encryption::clearBEncrypted() {
    if (hasBEncrypted()) {
         clear_has_bEncrypted();
        _bEncrypted = false;
     }
}

inline bool T_DAB_Encryption::hasBEncrypted () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_DAB_Encryption::getBEncrypted () const {
    return _bEncrypted;
}

inline void T_DAB_Encryption::setBEncrypted (bool bEncrypted_) {
    set_has_bEncrypted();
    this->_bEncrypted = bEncrypted_;
}

inline void T_DAB_Encryption::clearU8EncId() {
    if (hasU8EncId()) {
         clear_has_u8EncId();
        _u8EncId = 0u;
     }
}

inline bool T_DAB_Encryption::hasU8EncId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_DAB_Encryption::getU8EncId () const {
    return _u8EncId;
}

inline void T_DAB_Encryption::setU8EncId (uint8 u8EncId_) {
    set_has_u8EncId();
    this->_u8EncId = u8EncId_;
}

inline void T_DAB_Encryption::clearU8TestBits() {
    if (hasU8TestBits()) {
         clear_has_u8TestBits();
        _u8TestBits = 0u;
     }
}

inline bool T_DAB_Encryption::hasU8TestBits () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_DAB_Encryption::getU8TestBits () const {
    return _u8TestBits;
}

inline void T_DAB_Encryption::setU8TestBits (uint8 u8TestBits_) {
    set_has_u8TestBits();
    this->_u8TestBits = u8TestBits_;
}

inline void T_DAB_Encryption::set_has_bEncrypted () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_Encryption::clear_has_bEncrypted () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_Encryption::set_has_u8EncId () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_Encryption::clear_has_u8EncId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_Encryption::set_has_u8TestBits () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_Encryption::clear_has_u8TestBits () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_DAB_MsgSource::T_DAB_MsgSource ()  :
    _DabMediumTypeId (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_RESERVED),
    _u8Number (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_MsgSource::T_DAB_MsgSource (const T_DAB_MsgSource &rhs)  :
    _DabMediumTypeId (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_RESERVED),
    _u8Number (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_MsgSource::T_DAB_MsgSource (T_e8_DAB_TmcMediumType DabMediumTypeId_, uint8 u8Number_)  :
    _DabMediumTypeId (DabMediumTypeId_),
    _u8Number (u8Number_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_TmcMediumType_IsValid(DabMediumTypeId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DabMediumTypeId_, "T_e8_DAB_TmcMediumType", "DabMediumTypeId", "T_DAB_MsgSource");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_MsgSource::~T_DAB_MsgSource() {
}

inline T_DAB_MsgSource& T_DAB_MsgSource::operator = (const T_DAB_MsgSource& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDabMediumTypeId()) {
            setDabMediumTypeId(rhs.getDabMediumTypeId());
        } else {
            clearDabMediumTypeId();
        }
        if (rhs.hasU8Number()) {
            setU8Number(rhs.getU8Number());
        } else {
            clearU8Number();
        }
    }
    return *this;
}

inline bool T_DAB_MsgSource::operator == (const T_DAB_MsgSource& rhs) const {
    return (((!hasDabMediumTypeId() && !rhs.hasDabMediumTypeId()) || getDabMediumTypeId() == rhs.getDabMediumTypeId()) &&
        ((!hasU8Number() && !rhs.hasU8Number()) || getU8Number() == rhs.getU8Number()));
}

inline bool T_DAB_MsgSource::operator != (const T_DAB_MsgSource& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_MsgSource::operator < (const T_DAB_MsgSource& rhs) const {
    if (hasDabMediumTypeId() || rhs.hasDabMediumTypeId()) {
        if ((uint32)getDabMediumTypeId() < (uint32)rhs.getDabMediumTypeId()) return true;
        if ((uint32)getDabMediumTypeId() > (uint32)rhs.getDabMediumTypeId()) return false;
    }
    if (hasU8Number() || rhs.hasU8Number()) {
        if (getU8Number() < rhs.getU8Number()) return true;
        if (getU8Number() > rhs.getU8Number()) return false;
    }
    return false;
}

inline bool T_DAB_MsgSource::operator > (const T_DAB_MsgSource& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_MsgSource::clear() {
    clearDabMediumTypeId();
    clearU8Number();
}

inline void T_DAB_MsgSource::clearDabMediumTypeId() {
    if (hasDabMediumTypeId()) {
         clear_has_DabMediumTypeId();
        _DabMediumTypeId = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_RESERVED;
     }
}

inline bool T_DAB_MsgSource::hasDabMediumTypeId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_DAB_TmcMediumType T_DAB_MsgSource::getDabMediumTypeId () const {
    return _DabMediumTypeId;
}

inline void T_DAB_MsgSource::setDabMediumTypeId (T_e8_DAB_TmcMediumType DabMediumTypeId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_TmcMediumType_IsValid(DabMediumTypeId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DabMediumTypeId_, "T_e8_DAB_TmcMediumType", "DabMediumTypeId", "T_DAB_MsgSource");
    }
    set_has_DabMediumTypeId();
    this->_DabMediumTypeId = DabMediumTypeId_;
}

inline void T_DAB_MsgSource::clearU8Number() {
    if (hasU8Number()) {
         clear_has_u8Number();
        _u8Number = 0u;
     }
}

inline bool T_DAB_MsgSource::hasU8Number () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_DAB_MsgSource::getU8Number () const {
    return _u8Number;
}

inline void T_DAB_MsgSource::setU8Number (uint8 u8Number_) {
    set_has_u8Number();
    this->_u8Number = u8Number_;
}

inline void T_DAB_MsgSource::set_has_DabMediumTypeId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_MsgSource::clear_has_DabMediumTypeId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_MsgSource::set_has_u8Number () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_MsgSource::clear_has_u8Number () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DAB_TmcInfo::T_DAB_TmcInfo ()  :
    _RdbId (),
    _s16Ecc (0),
    _u16Aid (0u),
    _TmcData (),
    _u16ProgramId (0u),
    _DabEncryption (),
    _DabMsgSource (),
    _sProgramServiceName (),
    _sServiceProviderName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_TmcInfo::T_DAB_TmcInfo (const T_DAB_TmcInfo &rhs)  :
    _RdbId (),
    _s16Ecc (0),
    _u16Aid (0u),
    _TmcData (),
    _u16ProgramId (0u),
    _DabEncryption (),
    _DabMsgSource (),
    _sProgramServiceName (),
    _sServiceProviderName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_TmcInfo::T_DAB_TmcInfo (const T_DAB_RdbId& RdbId_, int16 s16Ecc_, uint16 u16Aid_, const ::std::vector< uint8 >& TmcData_, uint16 u16ProgramId_, const T_DAB_Encryption& DabEncryption_, const T_DAB_MsgSource& DabMsgSource_, const ::std::string& sProgramServiceName_, const ::std::string& sServiceProviderName_)  :
    _RdbId (RdbId_),
    _s16Ecc (s16Ecc_),
    _u16Aid (u16Aid_),
    _TmcData (TmcData_),
    _u16ProgramId (u16ProgramId_),
    _DabEncryption (DabEncryption_),
    _DabMsgSource (DabMsgSource_),
    _sProgramServiceName (sProgramServiceName_),
    _sServiceProviderName (sServiceProviderName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sProgramServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sServiceProviderName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_TmcInfo::~T_DAB_TmcInfo() {
}

inline T_DAB_TmcInfo& T_DAB_TmcInfo::operator = (const T_DAB_TmcInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRdbId()) {
            setRdbId(rhs.getRdbId());
        } else {
            clearRdbId();
        }
        if (rhs.hasS16Ecc()) {
            setS16Ecc(rhs.getS16Ecc());
        } else {
            clearS16Ecc();
        }
        if (rhs.hasU16Aid()) {
            setU16Aid(rhs.getU16Aid());
        } else {
            clearU16Aid();
        }
        if (rhs.hasTmcData()) {
            setTmcData(rhs.getTmcData());
        } else {
            clearTmcData();
        }
        if (rhs.hasU16ProgramId()) {
            setU16ProgramId(rhs.getU16ProgramId());
        } else {
            clearU16ProgramId();
        }
        if (rhs.hasDabEncryption()) {
            setDabEncryption(rhs.getDabEncryption());
        } else {
            clearDabEncryption();
        }
        if (rhs.hasDabMsgSource()) {
            setDabMsgSource(rhs.getDabMsgSource());
        } else {
            clearDabMsgSource();
        }
        if (rhs.hasSProgramServiceName()) {
            setSProgramServiceName(rhs.getSProgramServiceName());
        } else {
            clearSProgramServiceName();
        }
        if (rhs.hasSServiceProviderName()) {
            setSServiceProviderName(rhs.getSServiceProviderName());
        } else {
            clearSServiceProviderName();
        }
    }
    return *this;
}

inline bool T_DAB_TmcInfo::operator == (const T_DAB_TmcInfo& rhs) const {
    return (((!hasRdbId() && !rhs.hasRdbId()) || getRdbId() == rhs.getRdbId()) &&
        ((!hasS16Ecc() && !rhs.hasS16Ecc()) || getS16Ecc() == rhs.getS16Ecc()) &&
        ((!hasU16Aid() && !rhs.hasU16Aid()) || getU16Aid() == rhs.getU16Aid()) &&
        ((!hasTmcData() && !rhs.hasTmcData()) || getTmcData() == rhs.getTmcData()) &&
        ((!hasU16ProgramId() && !rhs.hasU16ProgramId()) || getU16ProgramId() == rhs.getU16ProgramId()) &&
        ((!hasDabEncryption() && !rhs.hasDabEncryption()) || getDabEncryption() == rhs.getDabEncryption()) &&
        ((!hasDabMsgSource() && !rhs.hasDabMsgSource()) || getDabMsgSource() == rhs.getDabMsgSource()) &&
        ((!hasSProgramServiceName() && !rhs.hasSProgramServiceName()) || getSProgramServiceName() == rhs.getSProgramServiceName()) &&
        ((!hasSServiceProviderName() && !rhs.hasSServiceProviderName()) || getSServiceProviderName() == rhs.getSServiceProviderName()));
}

inline bool T_DAB_TmcInfo::operator != (const T_DAB_TmcInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_TmcInfo::operator < (const T_DAB_TmcInfo& rhs) const {
    if (hasRdbId() || rhs.hasRdbId()) {
        if (getRdbId() < rhs.getRdbId()) return true;
        if (getRdbId() > rhs.getRdbId()) return false;
    }
    if (hasS16Ecc() || rhs.hasS16Ecc()) {
        if (getS16Ecc() < rhs.getS16Ecc()) return true;
        if (getS16Ecc() > rhs.getS16Ecc()) return false;
    }
    if (hasU16Aid() || rhs.hasU16Aid()) {
        if (getU16Aid() < rhs.getU16Aid()) return true;
        if (getU16Aid() > rhs.getU16Aid()) return false;
    }
    if (hasTmcData() || rhs.hasTmcData()) {
        if (getTmcData() < rhs.getTmcData()) return true;
        if (getTmcData() > rhs.getTmcData()) return false;
    }
    if (hasU16ProgramId() || rhs.hasU16ProgramId()) {
        if (getU16ProgramId() < rhs.getU16ProgramId()) return true;
        if (getU16ProgramId() > rhs.getU16ProgramId()) return false;
    }
    if (hasDabEncryption() || rhs.hasDabEncryption()) {
        if (getDabEncryption() < rhs.getDabEncryption()) return true;
        if (getDabEncryption() > rhs.getDabEncryption()) return false;
    }
    if (hasDabMsgSource() || rhs.hasDabMsgSource()) {
        if (getDabMsgSource() < rhs.getDabMsgSource()) return true;
        if (getDabMsgSource() > rhs.getDabMsgSource()) return false;
    }
    if (hasSProgramServiceName() || rhs.hasSProgramServiceName()) {
        if (getSProgramServiceName() < rhs.getSProgramServiceName()) return true;
        if (getSProgramServiceName() > rhs.getSProgramServiceName()) return false;
    }
    if (hasSServiceProviderName() || rhs.hasSServiceProviderName()) {
        if (getSServiceProviderName() < rhs.getSServiceProviderName()) return true;
        if (getSServiceProviderName() > rhs.getSServiceProviderName()) return false;
    }
    return false;
}

inline bool T_DAB_TmcInfo::operator > (const T_DAB_TmcInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_TmcInfo::clear() {
    clearRdbId();
    clearS16Ecc();
    clearU16Aid();
    clearTmcData();
    clearU16ProgramId();
    clearDabEncryption();
    clearDabMsgSource();
    clearSProgramServiceName();
    clearSServiceProviderName();
}

inline void T_DAB_TmcInfo::clearRdbId() {
    if (hasRdbId()) {
         clear_has_RdbId();
        _RdbId.clear();
     }
}

inline bool T_DAB_TmcInfo::hasRdbId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_DAB_RdbId& T_DAB_TmcInfo::getRdbId () const {
    return _RdbId;
}

inline T_DAB_RdbId& T_DAB_TmcInfo::getRdbIdMutable () {
    set_has_RdbId();
    return _RdbId;
}

inline void T_DAB_TmcInfo::setRdbId (const T_DAB_RdbId& RdbId_) {
    set_has_RdbId();
    this->_RdbId = RdbId_;
}

inline void T_DAB_TmcInfo::clearS16Ecc() {
    if (hasS16Ecc()) {
         clear_has_s16Ecc();
        _s16Ecc = 0;
     }
}

inline bool T_DAB_TmcInfo::hasS16Ecc () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 T_DAB_TmcInfo::getS16Ecc () const {
    return _s16Ecc;
}

inline void T_DAB_TmcInfo::setS16Ecc (int16 s16Ecc_) {
    set_has_s16Ecc();
    this->_s16Ecc = s16Ecc_;
}

inline void T_DAB_TmcInfo::clearU16Aid() {
    if (hasU16Aid()) {
         clear_has_u16Aid();
        _u16Aid = 0u;
     }
}

inline bool T_DAB_TmcInfo::hasU16Aid () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_DAB_TmcInfo::getU16Aid () const {
    return _u16Aid;
}

inline void T_DAB_TmcInfo::setU16Aid (uint16 u16Aid_) {
    set_has_u16Aid();
    this->_u16Aid = u16Aid_;
}

inline void T_DAB_TmcInfo::clearTmcData() {
    if (hasTmcData()) {
         clear_has_TmcData();
        _TmcData.clear();
     }
}

inline bool T_DAB_TmcInfo::hasTmcData () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< uint8 >& T_DAB_TmcInfo::getTmcData () const {
    return _TmcData;
}

inline ::std::vector< uint8 >& T_DAB_TmcInfo::getTmcDataMutable () {
    set_has_TmcData();
    return _TmcData;
}

inline void T_DAB_TmcInfo::setTmcData (const ::std::vector< uint8 >& TmcData_) {
    set_has_TmcData();
    this->_TmcData = TmcData_;
}

inline void T_DAB_TmcInfo::clearU16ProgramId() {
    if (hasU16ProgramId()) {
         clear_has_u16ProgramId();
        _u16ProgramId = 0u;
     }
}

inline bool T_DAB_TmcInfo::hasU16ProgramId () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_DAB_TmcInfo::getU16ProgramId () const {
    return _u16ProgramId;
}

inline void T_DAB_TmcInfo::setU16ProgramId (uint16 u16ProgramId_) {
    set_has_u16ProgramId();
    this->_u16ProgramId = u16ProgramId_;
}

inline void T_DAB_TmcInfo::clearDabEncryption() {
    if (hasDabEncryption()) {
         clear_has_DabEncryption();
        _DabEncryption.clear();
     }
}

inline bool T_DAB_TmcInfo::hasDabEncryption () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_DAB_Encryption& T_DAB_TmcInfo::getDabEncryption () const {
    return _DabEncryption;
}

inline T_DAB_Encryption& T_DAB_TmcInfo::getDabEncryptionMutable () {
    set_has_DabEncryption();
    return _DabEncryption;
}

inline void T_DAB_TmcInfo::setDabEncryption (const T_DAB_Encryption& DabEncryption_) {
    set_has_DabEncryption();
    this->_DabEncryption = DabEncryption_;
}

inline void T_DAB_TmcInfo::clearDabMsgSource() {
    if (hasDabMsgSource()) {
         clear_has_DabMsgSource();
        _DabMsgSource.clear();
     }
}

inline bool T_DAB_TmcInfo::hasDabMsgSource () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_DAB_MsgSource& T_DAB_TmcInfo::getDabMsgSource () const {
    return _DabMsgSource;
}

inline T_DAB_MsgSource& T_DAB_TmcInfo::getDabMsgSourceMutable () {
    set_has_DabMsgSource();
    return _DabMsgSource;
}

inline void T_DAB_TmcInfo::setDabMsgSource (const T_DAB_MsgSource& DabMsgSource_) {
    set_has_DabMsgSource();
    this->_DabMsgSource = DabMsgSource_;
}

inline void T_DAB_TmcInfo::clearSProgramServiceName() {
    if (hasSProgramServiceName()) {
         clear_has_sProgramServiceName();
        _sProgramServiceName.clear();
     }
}

inline bool T_DAB_TmcInfo::hasSProgramServiceName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_DAB_TmcInfo::getSProgramServiceName () const {
    return _sProgramServiceName;
}

inline ::std::string& T_DAB_TmcInfo::getSProgramServiceNameMutable () {
    set_has_sProgramServiceName();
    return _sProgramServiceName;
}

inline void T_DAB_TmcInfo::setSProgramServiceName (const ::std::string& sProgramServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sProgramServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sProgramServiceName();
    this->_sProgramServiceName = sProgramServiceName_;
}

inline void T_DAB_TmcInfo::setSProgramServiceName (const char* sProgramServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sProgramServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sProgramServiceName();
    this->_sProgramServiceName.assign(sProgramServiceName_);
}

inline void T_DAB_TmcInfo::setSProgramServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sProgramServiceName();
    this->_sProgramServiceName.assign(value, size);
}

inline void T_DAB_TmcInfo::clearSServiceProviderName() {
    if (hasSServiceProviderName()) {
         clear_has_sServiceProviderName();
        _sServiceProviderName.clear();
     }
}

inline bool T_DAB_TmcInfo::hasSServiceProviderName () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_DAB_TmcInfo::getSServiceProviderName () const {
    return _sServiceProviderName;
}

inline ::std::string& T_DAB_TmcInfo::getSServiceProviderNameMutable () {
    set_has_sServiceProviderName();
    return _sServiceProviderName;
}

inline void T_DAB_TmcInfo::setSServiceProviderName (const ::std::string& sServiceProviderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sServiceProviderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sServiceProviderName();
    this->_sServiceProviderName = sServiceProviderName_;
}

inline void T_DAB_TmcInfo::setSServiceProviderName (const char* sServiceProviderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sServiceProviderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sServiceProviderName();
    this->_sServiceProviderName.assign(sServiceProviderName_);
}

inline void T_DAB_TmcInfo::setSServiceProviderName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sServiceProviderName();
    this->_sServiceProviderName.assign(value, size);
}

inline void T_DAB_TmcInfo::set_has_RdbId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_TmcInfo::clear_has_RdbId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_TmcInfo::set_has_s16Ecc () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_TmcInfo::clear_has_s16Ecc () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_TmcInfo::set_has_u16Aid () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_TmcInfo::clear_has_u16Aid () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_TmcInfo::set_has_TmcData () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_TmcInfo::clear_has_TmcData () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DAB_TmcInfo::set_has_u16ProgramId () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DAB_TmcInfo::clear_has_u16ProgramId () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DAB_TmcInfo::set_has_DabEncryption () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DAB_TmcInfo::clear_has_DabEncryption () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DAB_TmcInfo::set_has_DabMsgSource () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DAB_TmcInfo::clear_has_DabMsgSource () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DAB_TmcInfo::set_has_sProgramServiceName () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DAB_TmcInfo::clear_has_sProgramServiceName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DAB_TmcInfo::set_has_sServiceProviderName () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DAB_TmcInfo::clear_has_sServiceProviderName () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_DAB_EnsembleTmcInfo::T_DAB_EnsembleTmcInfo ()  :
    _u32EnsembleId (0u),
    _u8Quality (0u),
    _u8NumberOfRdbIds (0u),
    _RdbIdList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_EnsembleTmcInfo::T_DAB_EnsembleTmcInfo (const T_DAB_EnsembleTmcInfo &rhs)  :
    _u32EnsembleId (0u),
    _u8Quality (0u),
    _u8NumberOfRdbIds (0u),
    _RdbIdList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_EnsembleTmcInfo::T_DAB_EnsembleTmcInfo (uint32 u32EnsembleId_, uint8 u8Quality_, uint8 u8NumberOfRdbIds_, const ::std::vector< T_DAB_RdbId >& RdbIdList_)  :
    _u32EnsembleId (u32EnsembleId_),
    _u8Quality (u8Quality_),
    _u8NumberOfRdbIds (u8NumberOfRdbIds_),
    _RdbIdList (RdbIdList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_EnsembleTmcInfo::~T_DAB_EnsembleTmcInfo() {
}

inline T_DAB_EnsembleTmcInfo& T_DAB_EnsembleTmcInfo::operator = (const T_DAB_EnsembleTmcInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32EnsembleId()) {
            setU32EnsembleId(rhs.getU32EnsembleId());
        } else {
            clearU32EnsembleId();
        }
        if (rhs.hasU8Quality()) {
            setU8Quality(rhs.getU8Quality());
        } else {
            clearU8Quality();
        }
        if (rhs.hasU8NumberOfRdbIds()) {
            setU8NumberOfRdbIds(rhs.getU8NumberOfRdbIds());
        } else {
            clearU8NumberOfRdbIds();
        }
        if (rhs.hasRdbIdList()) {
            setRdbIdList(rhs.getRdbIdList());
        } else {
            clearRdbIdList();
        }
    }
    return *this;
}

inline bool T_DAB_EnsembleTmcInfo::operator == (const T_DAB_EnsembleTmcInfo& rhs) const {
    return (((!hasU32EnsembleId() && !rhs.hasU32EnsembleId()) || getU32EnsembleId() == rhs.getU32EnsembleId()) &&
        ((!hasU8Quality() && !rhs.hasU8Quality()) || getU8Quality() == rhs.getU8Quality()) &&
        ((!hasU8NumberOfRdbIds() && !rhs.hasU8NumberOfRdbIds()) || getU8NumberOfRdbIds() == rhs.getU8NumberOfRdbIds()) &&
        ((!hasRdbIdList() && !rhs.hasRdbIdList()) || getRdbIdList() == rhs.getRdbIdList()));
}

inline bool T_DAB_EnsembleTmcInfo::operator != (const T_DAB_EnsembleTmcInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_EnsembleTmcInfo::operator < (const T_DAB_EnsembleTmcInfo& rhs) const {
    if (hasU32EnsembleId() || rhs.hasU32EnsembleId()) {
        if (getU32EnsembleId() < rhs.getU32EnsembleId()) return true;
        if (getU32EnsembleId() > rhs.getU32EnsembleId()) return false;
    }
    if (hasU8Quality() || rhs.hasU8Quality()) {
        if (getU8Quality() < rhs.getU8Quality()) return true;
        if (getU8Quality() > rhs.getU8Quality()) return false;
    }
    if (hasU8NumberOfRdbIds() || rhs.hasU8NumberOfRdbIds()) {
        if (getU8NumberOfRdbIds() < rhs.getU8NumberOfRdbIds()) return true;
        if (getU8NumberOfRdbIds() > rhs.getU8NumberOfRdbIds()) return false;
    }
    if (hasRdbIdList() || rhs.hasRdbIdList()) {
        if (getRdbIdList() < rhs.getRdbIdList()) return true;
        if (getRdbIdList() > rhs.getRdbIdList()) return false;
    }
    return false;
}

inline bool T_DAB_EnsembleTmcInfo::operator > (const T_DAB_EnsembleTmcInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_EnsembleTmcInfo::clear() {
    clearU32EnsembleId();
    clearU8Quality();
    clearU8NumberOfRdbIds();
    clearRdbIdList();
}

inline void T_DAB_EnsembleTmcInfo::clearU32EnsembleId() {
    if (hasU32EnsembleId()) {
         clear_has_u32EnsembleId();
        _u32EnsembleId = 0u;
     }
}

inline bool T_DAB_EnsembleTmcInfo::hasU32EnsembleId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DAB_EnsembleTmcInfo::getU32EnsembleId () const {
    return _u32EnsembleId;
}

inline void T_DAB_EnsembleTmcInfo::setU32EnsembleId (uint32 u32EnsembleId_) {
    set_has_u32EnsembleId();
    this->_u32EnsembleId = u32EnsembleId_;
}

inline void T_DAB_EnsembleTmcInfo::clearU8Quality() {
    if (hasU8Quality()) {
         clear_has_u8Quality();
        _u8Quality = 0u;
     }
}

inline bool T_DAB_EnsembleTmcInfo::hasU8Quality () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_DAB_EnsembleTmcInfo::getU8Quality () const {
    return _u8Quality;
}

inline void T_DAB_EnsembleTmcInfo::setU8Quality (uint8 u8Quality_) {
    set_has_u8Quality();
    this->_u8Quality = u8Quality_;
}

inline void T_DAB_EnsembleTmcInfo::clearU8NumberOfRdbIds() {
    if (hasU8NumberOfRdbIds()) {
         clear_has_u8NumberOfRdbIds();
        _u8NumberOfRdbIds = 0u;
     }
}

inline bool T_DAB_EnsembleTmcInfo::hasU8NumberOfRdbIds () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_DAB_EnsembleTmcInfo::getU8NumberOfRdbIds () const {
    return _u8NumberOfRdbIds;
}

inline void T_DAB_EnsembleTmcInfo::setU8NumberOfRdbIds (uint8 u8NumberOfRdbIds_) {
    set_has_u8NumberOfRdbIds();
    this->_u8NumberOfRdbIds = u8NumberOfRdbIds_;
}

inline void T_DAB_EnsembleTmcInfo::clearRdbIdList() {
    if (hasRdbIdList()) {
         clear_has_RdbIdList();
        _RdbIdList.clear();
     }
}

inline bool T_DAB_EnsembleTmcInfo::hasRdbIdList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< T_DAB_RdbId >& T_DAB_EnsembleTmcInfo::getRdbIdList () const {
    return _RdbIdList;
}

inline ::std::vector< T_DAB_RdbId >& T_DAB_EnsembleTmcInfo::getRdbIdListMutable () {
    set_has_RdbIdList();
    return _RdbIdList;
}

inline void T_DAB_EnsembleTmcInfo::setRdbIdList (const ::std::vector< T_DAB_RdbId >& RdbIdList_) {
    set_has_RdbIdList();
    this->_RdbIdList = RdbIdList_;
}

inline void T_DAB_EnsembleTmcInfo::set_has_u32EnsembleId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_EnsembleTmcInfo::clear_has_u32EnsembleId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_EnsembleTmcInfo::set_has_u8Quality () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_EnsembleTmcInfo::clear_has_u8Quality () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_EnsembleTmcInfo::set_has_u8NumberOfRdbIds () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_EnsembleTmcInfo::clear_has_u8NumberOfRdbIds () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DAB_EnsembleTmcInfo::set_has_RdbIdList () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DAB_EnsembleTmcInfo::clear_has_RdbIdList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_DAB_TpegUriChannel::T_DAB_TpegUriChannel ()  :
    _sTpegUriChn (),
    _DabUriSelectState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_OK),
    _bActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_TpegUriChannel::T_DAB_TpegUriChannel (const T_DAB_TpegUriChannel &rhs)  :
    _sTpegUriChn (),
    _DabUriSelectState (::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_OK),
    _bActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_TpegUriChannel::T_DAB_TpegUriChannel (const ::std::string& sTpegUriChn_, T_e8_DAB_UriSelectState DabUriSelectState_, bool bActive_)  :
    _sTpegUriChn (sTpegUriChn_),
    _DabUriSelectState (DabUriSelectState_),
    _bActive (bActive_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTpegUriChn_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_UriSelectState_IsValid(DabUriSelectState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DabUriSelectState_, "T_e8_DAB_UriSelectState", "DabUriSelectState", "T_DAB_TpegUriChannel");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_TpegUriChannel::~T_DAB_TpegUriChannel() {
}

inline T_DAB_TpegUriChannel& T_DAB_TpegUriChannel::operator = (const T_DAB_TpegUriChannel& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSTpegUriChn()) {
            setSTpegUriChn(rhs.getSTpegUriChn());
        } else {
            clearSTpegUriChn();
        }
        if (rhs.hasDabUriSelectState()) {
            setDabUriSelectState(rhs.getDabUriSelectState());
        } else {
            clearDabUriSelectState();
        }
        if (rhs.hasBActive()) {
            setBActive(rhs.getBActive());
        } else {
            clearBActive();
        }
    }
    return *this;
}

inline bool T_DAB_TpegUriChannel::operator == (const T_DAB_TpegUriChannel& rhs) const {
    return (((!hasSTpegUriChn() && !rhs.hasSTpegUriChn()) || getSTpegUriChn() == rhs.getSTpegUriChn()) &&
        ((!hasDabUriSelectState() && !rhs.hasDabUriSelectState()) || getDabUriSelectState() == rhs.getDabUriSelectState()) &&
        ((!hasBActive() && !rhs.hasBActive()) || getBActive() == rhs.getBActive()));
}

inline bool T_DAB_TpegUriChannel::operator != (const T_DAB_TpegUriChannel& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_TpegUriChannel::operator < (const T_DAB_TpegUriChannel& rhs) const {
    if (hasSTpegUriChn() || rhs.hasSTpegUriChn()) {
        if (getSTpegUriChn() < rhs.getSTpegUriChn()) return true;
        if (getSTpegUriChn() > rhs.getSTpegUriChn()) return false;
    }
    if (hasDabUriSelectState() || rhs.hasDabUriSelectState()) {
        if ((uint32)getDabUriSelectState() < (uint32)rhs.getDabUriSelectState()) return true;
        if ((uint32)getDabUriSelectState() > (uint32)rhs.getDabUriSelectState()) return false;
    }
    if (hasBActive() || rhs.hasBActive()) {
        if (getBActive() < rhs.getBActive()) return true;
        if (getBActive() > rhs.getBActive()) return false;
    }
    return false;
}

inline bool T_DAB_TpegUriChannel::operator > (const T_DAB_TpegUriChannel& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_TpegUriChannel::clear() {
    clearSTpegUriChn();
    clearDabUriSelectState();
    clearBActive();
}

inline void T_DAB_TpegUriChannel::clearSTpegUriChn() {
    if (hasSTpegUriChn()) {
         clear_has_sTpegUriChn();
        _sTpegUriChn.clear();
     }
}

inline bool T_DAB_TpegUriChannel::hasSTpegUriChn () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_DAB_TpegUriChannel::getSTpegUriChn () const {
    return _sTpegUriChn;
}

inline ::std::string& T_DAB_TpegUriChannel::getSTpegUriChnMutable () {
    set_has_sTpegUriChn();
    return _sTpegUriChn;
}

inline void T_DAB_TpegUriChannel::setSTpegUriChn (const ::std::string& sTpegUriChn_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTpegUriChn_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTpegUriChn();
    this->_sTpegUriChn = sTpegUriChn_;
}

inline void T_DAB_TpegUriChannel::setSTpegUriChn (const char* sTpegUriChn_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTpegUriChn_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTpegUriChn();
    this->_sTpegUriChn.assign(sTpegUriChn_);
}

inline void T_DAB_TpegUriChannel::setSTpegUriChn (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTpegUriChn();
    this->_sTpegUriChn.assign(value, size);
}

inline void T_DAB_TpegUriChannel::clearDabUriSelectState() {
    if (hasDabUriSelectState()) {
         clear_has_DabUriSelectState();
        _DabUriSelectState = ::com::dab::midw_ext_dabtuner_fi_types::T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_OK;
     }
}

inline bool T_DAB_TpegUriChannel::hasDabUriSelectState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_DAB_UriSelectState T_DAB_TpegUriChannel::getDabUriSelectState () const {
    return _DabUriSelectState;
}

inline void T_DAB_TpegUriChannel::setDabUriSelectState (T_e8_DAB_UriSelectState DabUriSelectState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_DAB_UriSelectState_IsValid(DabUriSelectState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DabUriSelectState_, "T_e8_DAB_UriSelectState", "DabUriSelectState", "T_DAB_TpegUriChannel");
    }
    set_has_DabUriSelectState();
    this->_DabUriSelectState = DabUriSelectState_;
}

inline void T_DAB_TpegUriChannel::clearBActive() {
    if (hasBActive()) {
         clear_has_bActive();
        _bActive = false;
     }
}

inline bool T_DAB_TpegUriChannel::hasBActive () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_DAB_TpegUriChannel::getBActive () const {
    return _bActive;
}

inline void T_DAB_TpegUriChannel::setBActive (bool bActive_) {
    set_has_bActive();
    this->_bActive = bActive_;
}

inline void T_DAB_TpegUriChannel::set_has_sTpegUriChn () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_TpegUriChannel::clear_has_sTpegUriChn () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_TpegUriChannel::set_has_DabUriSelectState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_TpegUriChannel::clear_has_DabUriSelectState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_TpegUriChannel::set_has_bActive () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_TpegUriChannel::clear_has_bActive () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace midw_ext_dabtuner_fi_types
} // namespace dab
} // namespace com

#endif // COM_DAB_MIDW_EXT_DABTUNER_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
