#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_TTS_FI_TYPES_H
#define SDS_TTS_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sds_sds2hmi_common_types.h"
#include "sds_speechdp_fi_types.h"
#include "sds_speechdp_fi_typesConst.h"
#include "sds_tts_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sds_tts_fi_types
 */

namespace sds_tts_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_Phoneme;

class T_SpeakProgress;

class T_FileLocation;

class T_BufferingProgress;

class T_TTSVersionInfo;

class T_TTSPhonemeResult;

class T_TTSTuningFile;

class T_TTSVoiceInfo;

// type definitions
/**
 * If the meaning of "T_AvailableTTSVoices" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::sds_speechdp_fi_types::T_VoiceType > T_AvailableTTSVoices;


/**
 * Structure type representing a word and a list of its phonemes.
 */
class T_Phoneme {
public:

    /**
     * Default constructor
     */
    inline  T_Phoneme ();

    /**
     * Copy constructor
     */
    inline  T_Phoneme (const T_Phoneme &rhs);

    /**
     * All fields constructor
     */
    inline  T_Phoneme (const ::std::string& Word_, const ::std::vector< ::std::string >& Phonemes_);

    /**
     * Destructor
     */
    inline  ~T_Phoneme();

    /**
     * Assignment operator
     */
    inline T_Phoneme& operator = (const T_Phoneme& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Phoneme& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Phoneme& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Phoneme& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Phoneme& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Word"

    static const int kWord = 0;

    /**
     * Clears the field "Word".
     *
     * The field will be set to its default value. The hasWord()
     * method will return false.
     */
    inline void clearWord();

    /**
     * Checks whether the field "Word" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWord()). Otherwise it will return false.
     */
    inline bool hasWord () const;

    /**
     * Returns the value of the member "Word".
     *
     * Word to convert to phonemes.
     *
     * @return The value of the field "Word"
     */
    inline const ::std::string& getWord () const;

    /**
     * Retrieves the value of the field "Word" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Word".
     */
    inline ::std::string& getWordMutable ();

    /**
     * Sets the value of the member "Word".
     *
     * Word to convert to phonemes.
     *
     * @param Word The value which will be set
     */
    inline void setWord (const ::std::string& Word_);

    /**
     * Sets the value of the member "Word".
     *
     * Word to convert to phonemes.
     *
     * @param Word The value which will be set
     */
    inline void setWord (const char* Word_);

    /**
     * Sets the value of the member "Word".
     *
     * Word to convert to phonemes.
     *
     * @param Word The value which will be set
     */
    inline void setWord (const char* value, size_t size);

    // API of field "Phonemes"

    static const int kPhonemes = 1;

    /**
     * Clears the field "Phonemes".
     *
     * The field will be set to its default value. The hasPhonemes()
     * method will return false.
     */
    inline void clearPhonemes();

    /**
     * Checks whether the field "Phonemes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemes()). Otherwise it will return false.
     */
    inline bool hasPhonemes () const;

    /**
     * Returns the value of the member "Phonemes".
     *
     * If the meaning of "Phonemes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Phonemes"
     */
    inline const ::std::vector< ::std::string >& getPhonemes () const;

    /**
     * Retrieves the value of the field "Phonemes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Phonemes".
     */
    inline ::std::vector< ::std::string >& getPhonemesMutable ();

    /**
     * Sets the value of the member "Phonemes".
     *
     * If the meaning of "Phonemes" isn't clear, then there should be a description here.
     *
     * @param Phonemes The value which will be set
     */
    inline void setPhonemes (const ::std::vector< ::std::string >& Phonemes_);

    static const T_Phoneme &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Word ();

    inline void clear_has_Word ();

    inline void set_has_Phonemes ();

    inline void clear_has_Phonemes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Word;

    ::std::vector< ::std::string > _Phonemes;

};

/**
 * Structure to inform the client about the progress of the job.
 */
class T_SpeakProgress {
public:

    /**
     * Default constructor
     */
    inline  T_SpeakProgress ();

    /**
     * Copy constructor
     */
    inline  T_SpeakProgress (const T_SpeakProgress &rhs);

    /**
     * All fields constructor
     */
    inline  T_SpeakProgress (uint16 Marker_, uint32 LastMarkerSrcPos_, uint16 TextUnit_, uint32 LastTextUnitSrcPos_, uint32 LastBookmarkID_, T_e8_JobStatus JobStatus_);

    /**
     * Destructor
     */
    inline  ~T_SpeakProgress();

    /**
     * Assignment operator
     */
    inline T_SpeakProgress& operator = (const T_SpeakProgress& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SpeakProgress& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SpeakProgress& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SpeakProgress& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SpeakProgress& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Marker"

    static const int kMarker = 0;

    /**
     * Clears the field "Marker".
     *
     * The field will be set to its default value. The hasMarker()
     * method will return false.
     */
    inline void clearMarker();

    /**
     * Checks whether the field "Marker" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMarker()). Otherwise it will return false.
     */
    inline bool hasMarker () const;

    /**
     * Returns the value of the member "Marker".
     *
     * N markers spoken. Only that marker type is considered which was configured in the StatusInfo of the SynthesizeSpeak method.
     *
     * @return The value of the field "Marker"
     */
    inline uint16 getMarker () const;

    /**
     * Sets the value of the member "Marker".
     *
     * N markers spoken. Only that marker type is considered which was configured in the StatusInfo of the SynthesizeSpeak method.
     *
     * @param Marker The value which will be set
     */
    inline void setMarker (uint16 Marker_);

    // API of field "LastMarkerSrcPos"

    static const int kLastMarkerSrcPos = 1;

    /**
     * Clears the field "LastMarkerSrcPos".
     *
     * The field will be set to its default value. The hasLastMarkerSrcPos()
     * method will return false.
     */
    inline void clearLastMarkerSrcPos();

    /**
     * Checks whether the field "LastMarkerSrcPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastMarkerSrcPos()). Otherwise it will return false.
     */
    inline bool hasLastMarkerSrcPos () const;

    /**
     * Returns the value of the member "LastMarkerSrcPos".
     *
     * Textposition of last seen marker.
     *
     * @return The value of the field "LastMarkerSrcPos"
     */
    inline uint32 getLastMarkerSrcPos () const;

    /**
     * Sets the value of the member "LastMarkerSrcPos".
     *
     * Textposition of last seen marker.
     *
     * @param LastMarkerSrcPos The value which will be set
     */
    inline void setLastMarkerSrcPos (uint32 LastMarkerSrcPos_);

    // API of field "TextUnit"

    static const int kTextUnit = 2;

    /**
     * Clears the field "TextUnit".
     *
     * The field will be set to its default value. The hasTextUnit()
     * method will return false.
     */
    inline void clearTextUnit();

    /**
     * Checks whether the field "TextUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextUnit()). Otherwise it will return false.
     */
    inline bool hasTextUnit () const;

    /**
     * Returns the value of the member "TextUnit".
     *
     * N text units spoken.
     *
     * @return The value of the field "TextUnit"
     */
    inline uint16 getTextUnit () const;

    /**
     * Sets the value of the member "TextUnit".
     *
     * N text units spoken.
     *
     * @param TextUnit The value which will be set
     */
    inline void setTextUnit (uint16 TextUnit_);

    // API of field "LastTextUnitSrcPos"

    static const int kLastTextUnitSrcPos = 3;

    /**
     * Clears the field "LastTextUnitSrcPos".
     *
     * The field will be set to its default value. The hasLastTextUnitSrcPos()
     * method will return false.
     */
    inline void clearLastTextUnitSrcPos();

    /**
     * Checks whether the field "LastTextUnitSrcPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastTextUnitSrcPos()). Otherwise it will return false.
     */
    inline bool hasLastTextUnitSrcPos () const;

    /**
     * Returns the value of the member "LastTextUnitSrcPos".
     *
     * Textposition of last seen text unit.
     *
     * @return The value of the field "LastTextUnitSrcPos"
     */
    inline uint32 getLastTextUnitSrcPos () const;

    /**
     * Sets the value of the member "LastTextUnitSrcPos".
     *
     * Textposition of last seen text unit.
     *
     * @param LastTextUnitSrcPos The value which will be set
     */
    inline void setLastTextUnitSrcPos (uint32 LastTextUnitSrcPos_);

    // API of field "LastBookmarkID"

    static const int kLastBookmarkID = 4;

    /**
     * Clears the field "LastBookmarkID".
     *
     * The field will be set to its default value. The hasLastBookmarkID()
     * method will return false.
     */
    inline void clearLastBookmarkID();

    /**
     * Checks whether the field "LastBookmarkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastBookmarkID()). Otherwise it will return false.
     */
    inline bool hasLastBookmarkID () const;

    /**
     * Returns the value of the member "LastBookmarkID".
     *
     * last seen Marker ID, which corresponds to the unsigned integer specified in the bookmark control sequence.
     *
     * @return The value of the field "LastBookmarkID"
     */
    inline uint32 getLastBookmarkID () const;

    /**
     * Sets the value of the member "LastBookmarkID".
     *
     * last seen Marker ID, which corresponds to the unsigned integer specified in the bookmark control sequence.
     *
     * @param LastBookmarkID The value which will be set
     */
    inline void setLastBookmarkID (uint32 LastBookmarkID_);

    // API of field "JobStatus"

    static const int kJobStatus = 5;

    /**
     * Clears the field "JobStatus".
     *
     * The field will be set to its default value. The hasJobStatus()
     * method will return false.
     */
    inline void clearJobStatus();

    /**
     * Checks whether the field "JobStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobStatus()). Otherwise it will return false.
     */
    inline bool hasJobStatus () const;

    /**
     * Returns the value of the member "JobStatus".
     *
     * Enum to inform about the job-status.
     *
     * @return The value of the field "JobStatus"
     */
    inline T_e8_JobStatus getJobStatus () const;

    /**
     * Sets the value of the member "JobStatus".
     *
     * Enum to inform about the job-status.
     *
     * @param JobStatus The value which will be set
     */
    inline void setJobStatus (T_e8_JobStatus JobStatus_);

    static const T_SpeakProgress &getDefaultInstance();

private:

    inline void set_has_Marker ();

    inline void clear_has_Marker ();

    inline void set_has_LastMarkerSrcPos ();

    inline void clear_has_LastMarkerSrcPos ();

    inline void set_has_TextUnit ();

    inline void clear_has_TextUnit ();

    inline void set_has_LastTextUnitSrcPos ();

    inline void clear_has_LastTextUnitSrcPos ();

    inline void set_has_LastBookmarkID ();

    inline void clear_has_LastBookmarkID ();

    inline void set_has_JobStatus ();

    inline void clear_has_JobStatus ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _Marker;

    uint32 _LastMarkerSrcPos;

    uint16 _TextUnit;

    uint32 _LastTextUnitSrcPos;

    uint32 _LastBookmarkID;

    T_e8_JobStatus _JobStatus;

};

/**
 * Structure to inform the client about the locations of the saved audio-files.
 */
class T_FileLocation {
public:

    /**
     * Default constructor
     */
    inline  T_FileLocation ();

    /**
     * Copy constructor
     */
    inline  T_FileLocation (const T_FileLocation &rhs);

    /**
     * All fields constructor
     */
    inline  T_FileLocation (uint8 SavedBlock_, uint8 PartOfBlock_, uint32 BlockID_, const ::std::string& FileLocation_, uint32 FileSize_);

    /**
     * Destructor
     */
    inline  ~T_FileLocation();

    /**
     * Assignment operator
     */
    inline T_FileLocation& operator = (const T_FileLocation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FileLocation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FileLocation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FileLocation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FileLocation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SavedBlock"

    static const int kSavedBlock = 0;

    /**
     * Clears the field "SavedBlock".
     *
     * The field will be set to its default value. The hasSavedBlock()
     * method will return false.
     */
    inline void clearSavedBlock();

    /**
     * Checks whether the field "SavedBlock" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSavedBlock()). Otherwise it will return false.
     */
    inline bool hasSavedBlock () const;

    /**
     * Returns the value of the member "SavedBlock".
     *
     * Nth block saved to shared memory.
     *
     * @return The value of the field "SavedBlock"
     */
    inline uint8 getSavedBlock () const;

    /**
     * Sets the value of the member "SavedBlock".
     *
     * Nth block saved to shared memory.
     *
     * @param SavedBlock The value which will be set
     */
    inline void setSavedBlock (uint8 SavedBlock_);

    // API of field "PartOfBlock"

    static const int kPartOfBlock = 1;

    /**
     * Clears the field "PartOfBlock".
     *
     * The field will be set to its default value. The hasPartOfBlock()
     * method will return false.
     */
    inline void clearPartOfBlock();

    /**
     * Checks whether the field "PartOfBlock" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPartOfBlock()). Otherwise it will return false.
     */
    inline bool hasPartOfBlock () const;

    /**
     * Returns the value of the member "PartOfBlock".
     *
     * Mth part of block N. Value "FF defines last part."
     *
     * @return The value of the field "PartOfBlock"
     */
    inline uint8 getPartOfBlock () const;

    /**
     * Sets the value of the member "PartOfBlock".
     *
     * Mth part of block N. Value "FF defines last part."
     *
     * @param PartOfBlock The value which will be set
     */
    inline void setPartOfBlock (uint8 PartOfBlock_);

    // API of field "BlockID"

    static const int kBlockID = 2;

    /**
     * Clears the field "BlockID".
     *
     * The field will be set to its default value. The hasBlockID()
     * method will return false.
     */
    inline void clearBlockID();

    /**
     * Checks whether the field "BlockID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlockID()). Otherwise it will return false.
     */
    inline bool hasBlockID () const;

    /**
     * Returns the value of the member "BlockID".
     *
     * Block-ID that has been sent by the client within the file-tag.
     *
     * @return The value of the field "BlockID"
     */
    inline uint32 getBlockID () const;

    /**
     * Sets the value of the member "BlockID".
     *
     * Block-ID that has been sent by the client within the file-tag.
     *
     * @param BlockID The value which will be set
     */
    inline void setBlockID (uint32 BlockID_);

    // API of field "FileLocation"

    static const int kFileLocation = 3;

    /**
     * Clears the field "FileLocation".
     *
     * The field will be set to its default value. The hasFileLocation()
     * method will return false.
     */
    inline void clearFileLocation();

    /**
     * Checks whether the field "FileLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFileLocation()). Otherwise it will return false.
     */
    inline bool hasFileLocation () const;

    /**
     * Returns the value of the member "FileLocation".
     *
     * Location of the saved audio-data of the Nth block in the shared memory.
     *
     * @return The value of the field "FileLocation"
     */
    inline const ::std::string& getFileLocation () const;

    /**
     * Retrieves the value of the field "FileLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FileLocation".
     */
    inline ::std::string& getFileLocationMutable ();

    /**
     * Sets the value of the member "FileLocation".
     *
     * Location of the saved audio-data of the Nth block in the shared memory.
     *
     * @param FileLocation The value which will be set
     */
    inline void setFileLocation (const ::std::string& FileLocation_);

    /**
     * Sets the value of the member "FileLocation".
     *
     * Location of the saved audio-data of the Nth block in the shared memory.
     *
     * @param FileLocation The value which will be set
     */
    inline void setFileLocation (const char* FileLocation_);

    /**
     * Sets the value of the member "FileLocation".
     *
     * Location of the saved audio-data of the Nth block in the shared memory.
     *
     * @param FileLocation The value which will be set
     */
    inline void setFileLocation (const char* value, size_t size);

    // API of field "FileSize"

    static const int kFileSize = 4;

    /**
     * Clears the field "FileSize".
     *
     * The field will be set to its default value. The hasFileSize()
     * method will return false.
     */
    inline void clearFileSize();

    /**
     * Checks whether the field "FileSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFileSize()). Otherwise it will return false.
     */
    inline bool hasFileSize () const;

    /**
     * Returns the value of the member "FileSize".
     *
     * Size of the transmitted shared memory.
     *
     * @return The value of the field "FileSize"
     */
    inline uint32 getFileSize () const;

    /**
     * Sets the value of the member "FileSize".
     *
     * Size of the transmitted shared memory.
     *
     * @param FileSize The value which will be set
     */
    inline void setFileSize (uint32 FileSize_);

    static const T_FileLocation &getDefaultInstance();

private:

    inline void set_has_SavedBlock ();

    inline void clear_has_SavedBlock ();

    inline void set_has_PartOfBlock ();

    inline void clear_has_PartOfBlock ();

    inline void set_has_BlockID ();

    inline void clear_has_BlockID ();

    inline void set_has_FileLocation ();

    inline void clear_has_FileLocation ();

    inline void set_has_FileSize ();

    inline void clear_has_FileSize ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _SavedBlock;

    uint8 _PartOfBlock;

    uint32 _BlockID;

    ::std::string _FileLocation;

    uint32 _FileSize;

};

/**
 * Structure to inform the client about the written audio-buffers.
 */
class T_BufferingProgress {
public:

    /**
     * Default constructor
     */
    inline  T_BufferingProgress ();

    /**
     * Copy constructor
     */
    inline  T_BufferingProgress (const T_BufferingProgress &rhs);

    /**
     * All fields constructor
     */
    inline  T_BufferingProgress (const T_FileLocation& FileLocation_, T_e8_JobStatus JobStatus_);

    /**
     * Destructor
     */
    inline  ~T_BufferingProgress();

    /**
     * Assignment operator
     */
    inline T_BufferingProgress& operator = (const T_BufferingProgress& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BufferingProgress& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BufferingProgress& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BufferingProgress& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BufferingProgress& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FileLocation"

    static const int kFileLocation = 0;

    /**
     * Clears the field "FileLocation".
     *
     * The field will be set to its default value. The hasFileLocation()
     * method will return false.
     */
    inline void clearFileLocation();

    /**
     * Checks whether the field "FileLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFileLocation()). Otherwise it will return false.
     */
    inline bool hasFileLocation () const;

    /**
     * Returns the value of the member "FileLocation".
     *
     * Information about the buffered audiostream.
     *
     * @return The value of the field "FileLocation"
     */
    inline const T_FileLocation& getFileLocation () const;

    /**
     * Retrieves the value of the field "FileLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FileLocation".
     */
    inline T_FileLocation& getFileLocationMutable ();

    /**
     * Sets the value of the member "FileLocation".
     *
     * Information about the buffered audiostream.
     *
     * @param FileLocation The value which will be set
     */
    inline void setFileLocation (const T_FileLocation& FileLocation_);

    // API of field "JobStatus"

    static const int kJobStatus = 1;

    /**
     * Clears the field "JobStatus".
     *
     * The field will be set to its default value. The hasJobStatus()
     * method will return false.
     */
    inline void clearJobStatus();

    /**
     * Checks whether the field "JobStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobStatus()). Otherwise it will return false.
     */
    inline bool hasJobStatus () const;

    /**
     * Returns the value of the member "JobStatus".
     *
     * Enum to inform about the job-status.
     *
     * @return The value of the field "JobStatus"
     */
    inline T_e8_JobStatus getJobStatus () const;

    /**
     * Sets the value of the member "JobStatus".
     *
     * Enum to inform about the job-status.
     *
     * @param JobStatus The value which will be set
     */
    inline void setJobStatus (T_e8_JobStatus JobStatus_);

    static const T_BufferingProgress &getDefaultInstance();

private:

    inline void set_has_FileLocation ();

    inline void clear_has_FileLocation ();

    inline void set_has_JobStatus ();

    inline void clear_has_JobStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_FileLocation _FileLocation;

    T_e8_JobStatus _JobStatus;

};

/**
 * Specifies the version number of the TTS product and the version of the FC TTS-module
 */
class T_TTSVersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TTSVersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_TTSVersionInfo (const T_TTSVersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TTSVersionInfo (const ::std::string& TTSEngineManufacturer_, const ::std::string& TTSEngineProductionDate_, const ::std::string& TTSEngineProductVersion_, const ::std::string& TTSModuleProductionDate_, const ::std::string& TTSModuleVersion_);

    /**
     * Destructor
     */
    inline  ~T_TTSVersionInfo();

    /**
     * Assignment operator
     */
    inline T_TTSVersionInfo& operator = (const T_TTSVersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TTSVersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TTSVersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TTSVersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TTSVersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TTSEngineManufacturer"

    static const int kTTSEngineManufacturer = 0;

    /**
     * Clears the field "TTSEngineManufacturer".
     *
     * The field will be set to its default value. The hasTTSEngineManufacturer()
     * method will return false.
     */
    inline void clearTTSEngineManufacturer();

    /**
     * Checks whether the field "TTSEngineManufacturer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSEngineManufacturer()). Otherwise it will return false.
     */
    inline bool hasTTSEngineManufacturer () const;

    /**
     * Returns the value of the member "TTSEngineManufacturer".
     *
     *
     *
     * @return The value of the field "TTSEngineManufacturer"
     */
    inline const ::std::string& getTTSEngineManufacturer () const;

    /**
     * Retrieves the value of the field "TTSEngineManufacturer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSEngineManufacturer".
     */
    inline ::std::string& getTTSEngineManufacturerMutable ();

    /**
     * Sets the value of the member "TTSEngineManufacturer".
     *
     *
     *
     * @param TTSEngineManufacturer The value which will be set
     */
    inline void setTTSEngineManufacturer (const ::std::string& TTSEngineManufacturer_);

    /**
     * Sets the value of the member "TTSEngineManufacturer".
     *
     *
     *
     * @param TTSEngineManufacturer The value which will be set
     */
    inline void setTTSEngineManufacturer (const char* TTSEngineManufacturer_);

    /**
     * Sets the value of the member "TTSEngineManufacturer".
     *
     *
     *
     * @param TTSEngineManufacturer The value which will be set
     */
    inline void setTTSEngineManufacturer (const char* value, size_t size);

    // API of field "TTSEngineProductionDate"

    static const int kTTSEngineProductionDate = 1;

    /**
     * Clears the field "TTSEngineProductionDate".
     *
     * The field will be set to its default value. The hasTTSEngineProductionDate()
     * method will return false.
     */
    inline void clearTTSEngineProductionDate();

    /**
     * Checks whether the field "TTSEngineProductionDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSEngineProductionDate()). Otherwise it will return false.
     */
    inline bool hasTTSEngineProductionDate () const;

    /**
     * Returns the value of the member "TTSEngineProductionDate".
     *
     *
     *
     * @return The value of the field "TTSEngineProductionDate"
     */
    inline const ::std::string& getTTSEngineProductionDate () const;

    /**
     * Retrieves the value of the field "TTSEngineProductionDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSEngineProductionDate".
     */
    inline ::std::string& getTTSEngineProductionDateMutable ();

    /**
     * Sets the value of the member "TTSEngineProductionDate".
     *
     *
     *
     * @param TTSEngineProductionDate The value which will be set
     */
    inline void setTTSEngineProductionDate (const ::std::string& TTSEngineProductionDate_);

    /**
     * Sets the value of the member "TTSEngineProductionDate".
     *
     *
     *
     * @param TTSEngineProductionDate The value which will be set
     */
    inline void setTTSEngineProductionDate (const char* TTSEngineProductionDate_);

    /**
     * Sets the value of the member "TTSEngineProductionDate".
     *
     *
     *
     * @param TTSEngineProductionDate The value which will be set
     */
    inline void setTTSEngineProductionDate (const char* value, size_t size);

    // API of field "TTSEngineProductVersion"

    static const int kTTSEngineProductVersion = 2;

    /**
     * Clears the field "TTSEngineProductVersion".
     *
     * The field will be set to its default value. The hasTTSEngineProductVersion()
     * method will return false.
     */
    inline void clearTTSEngineProductVersion();

    /**
     * Checks whether the field "TTSEngineProductVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSEngineProductVersion()). Otherwise it will return false.
     */
    inline bool hasTTSEngineProductVersion () const;

    /**
     * Returns the value of the member "TTSEngineProductVersion".
     *
     *
     *
     * @return The value of the field "TTSEngineProductVersion"
     */
    inline const ::std::string& getTTSEngineProductVersion () const;

    /**
     * Retrieves the value of the field "TTSEngineProductVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSEngineProductVersion".
     */
    inline ::std::string& getTTSEngineProductVersionMutable ();

    /**
     * Sets the value of the member "TTSEngineProductVersion".
     *
     *
     *
     * @param TTSEngineProductVersion The value which will be set
     */
    inline void setTTSEngineProductVersion (const ::std::string& TTSEngineProductVersion_);

    /**
     * Sets the value of the member "TTSEngineProductVersion".
     *
     *
     *
     * @param TTSEngineProductVersion The value which will be set
     */
    inline void setTTSEngineProductVersion (const char* TTSEngineProductVersion_);

    /**
     * Sets the value of the member "TTSEngineProductVersion".
     *
     *
     *
     * @param TTSEngineProductVersion The value which will be set
     */
    inline void setTTSEngineProductVersion (const char* value, size_t size);

    // API of field "TTSModuleProductionDate"

    static const int kTTSModuleProductionDate = 3;

    /**
     * Clears the field "TTSModuleProductionDate".
     *
     * The field will be set to its default value. The hasTTSModuleProductionDate()
     * method will return false.
     */
    inline void clearTTSModuleProductionDate();

    /**
     * Checks whether the field "TTSModuleProductionDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSModuleProductionDate()). Otherwise it will return false.
     */
    inline bool hasTTSModuleProductionDate () const;

    /**
     * Returns the value of the member "TTSModuleProductionDate".
     *
     *
     *
     * @return The value of the field "TTSModuleProductionDate"
     */
    inline const ::std::string& getTTSModuleProductionDate () const;

    /**
     * Retrieves the value of the field "TTSModuleProductionDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSModuleProductionDate".
     */
    inline ::std::string& getTTSModuleProductionDateMutable ();

    /**
     * Sets the value of the member "TTSModuleProductionDate".
     *
     *
     *
     * @param TTSModuleProductionDate The value which will be set
     */
    inline void setTTSModuleProductionDate (const ::std::string& TTSModuleProductionDate_);

    /**
     * Sets the value of the member "TTSModuleProductionDate".
     *
     *
     *
     * @param TTSModuleProductionDate The value which will be set
     */
    inline void setTTSModuleProductionDate (const char* TTSModuleProductionDate_);

    /**
     * Sets the value of the member "TTSModuleProductionDate".
     *
     *
     *
     * @param TTSModuleProductionDate The value which will be set
     */
    inline void setTTSModuleProductionDate (const char* value, size_t size);

    // API of field "TTSModuleVersion"

    static const int kTTSModuleVersion = 4;

    /**
     * Clears the field "TTSModuleVersion".
     *
     * The field will be set to its default value. The hasTTSModuleVersion()
     * method will return false.
     */
    inline void clearTTSModuleVersion();

    /**
     * Checks whether the field "TTSModuleVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSModuleVersion()). Otherwise it will return false.
     */
    inline bool hasTTSModuleVersion () const;

    /**
     * Returns the value of the member "TTSModuleVersion".
     *
     *
     *
     * @return The value of the field "TTSModuleVersion"
     */
    inline const ::std::string& getTTSModuleVersion () const;

    /**
     * Retrieves the value of the field "TTSModuleVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSModuleVersion".
     */
    inline ::std::string& getTTSModuleVersionMutable ();

    /**
     * Sets the value of the member "TTSModuleVersion".
     *
     *
     *
     * @param TTSModuleVersion The value which will be set
     */
    inline void setTTSModuleVersion (const ::std::string& TTSModuleVersion_);

    /**
     * Sets the value of the member "TTSModuleVersion".
     *
     *
     *
     * @param TTSModuleVersion The value which will be set
     */
    inline void setTTSModuleVersion (const char* TTSModuleVersion_);

    /**
     * Sets the value of the member "TTSModuleVersion".
     *
     *
     *
     * @param TTSModuleVersion The value which will be set
     */
    inline void setTTSModuleVersion (const char* value, size_t size);

    static const T_TTSVersionInfo &getDefaultInstance();

private:

    inline void set_has_TTSEngineManufacturer ();

    inline void clear_has_TTSEngineManufacturer ();

    inline void set_has_TTSEngineProductionDate ();

    inline void clear_has_TTSEngineProductionDate ();

    inline void set_has_TTSEngineProductVersion ();

    inline void clear_has_TTSEngineProductVersion ();

    inline void set_has_TTSModuleProductionDate ();

    inline void clear_has_TTSModuleProductionDate ();

    inline void set_has_TTSModuleVersion ();

    inline void clear_has_TTSModuleVersion ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _TTSEngineManufacturer;

    ::std::string _TTSEngineProductionDate;

    ::std::string _TTSEngineProductVersion;

    ::std::string _TTSModuleProductionDate;

    ::std::string _TTSModuleVersion;

};

/**
 * <p>Contains a phoneme substitution.</p>
 * <p>The flag CommError indicates if the phoneme request could not be fulfilled due to error condition (like timeout or general communication error).</p>
 * <p>The flag PhonemeAvailability indicates phoneme availablility.</p>
 * <p>If the phoneme was not available (also in timeout situations), the Phoneme entry contains the original string which was subject to
 * the phoneme substitution request but without tagging.</p>
 */
class T_TTSPhonemeResult {
public:

    /**
     * Default constructor
     */
    inline  T_TTSPhonemeResult ();

    /**
     * Copy constructor
     */
    inline  T_TTSPhonemeResult (const T_TTSPhonemeResult &rhs);

    /**
     * All fields constructor
     */
    inline  T_TTSPhonemeResult (uint16 ID_, const ::std::string& Phoneme_, bool CommError_, bool PhonemeAvailability_);

    /**
     * Destructor
     */
    inline  ~T_TTSPhonemeResult();

    /**
     * Assignment operator
     */
    inline T_TTSPhonemeResult& operator = (const T_TTSPhonemeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TTSPhonemeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TTSPhonemeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TTSPhonemeResult& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TTSPhonemeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * client specific ID which was specified with the phoneme request.
     *
     * @return The value of the field "ID"
     */
    inline uint16 getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * client specific ID which was specified with the phoneme request.
     *
     * @param ID The value which will be set
     */
    inline void setID (uint16 ID_);

    // API of field "Phoneme"

    static const int kPhoneme = 1;

    /**
     * Clears the field "Phoneme".
     *
     * The field will be set to its default value. The hasPhoneme()
     * method will return false.
     */
    inline void clearPhoneme();

    /**
     * Checks whether the field "Phoneme" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneme()). Otherwise it will return false.
     */
    inline bool hasPhoneme () const;

    /**
     * Returns the value of the member "Phoneme".
     *
     *
     *
     * @return The value of the field "Phoneme"
     */
    inline const ::std::string& getPhoneme () const;

    /**
     * Retrieves the value of the field "Phoneme" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Phoneme".
     */
    inline ::std::string& getPhonemeMutable ();

    /**
     * Sets the value of the member "Phoneme".
     *
     *
     *
     * @param Phoneme The value which will be set
     */
    inline void setPhoneme (const ::std::string& Phoneme_);

    /**
     * Sets the value of the member "Phoneme".
     *
     *
     *
     * @param Phoneme The value which will be set
     */
    inline void setPhoneme (const char* Phoneme_);

    /**
     * Sets the value of the member "Phoneme".
     *
     *
     *
     * @param Phoneme The value which will be set
     */
    inline void setPhoneme (const char* value, size_t size);

    // API of field "CommError"

    static const int kCommError = 2;

    /**
     * Clears the field "CommError".
     *
     * The field will be set to its default value. The hasCommError()
     * method will return false.
     */
    inline void clearCommError();

    /**
     * Checks whether the field "CommError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCommError()). Otherwise it will return false.
     */
    inline bool hasCommError () const;

    /**
     * Returns the value of the member "CommError".
     *
     *
     *
     * @return The value of the field "CommError"
     */
    inline bool getCommError () const;

    /**
     * Sets the value of the member "CommError".
     *
     *
     *
     * @param CommError The value which will be set
     */
    inline void setCommError (bool CommError_);

    // API of field "PhonemeAvailability"

    static const int kPhonemeAvailability = 3;

    /**
     * Clears the field "PhonemeAvailability".
     *
     * The field will be set to its default value. The hasPhonemeAvailability()
     * method will return false.
     */
    inline void clearPhonemeAvailability();

    /**
     * Checks whether the field "PhonemeAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemeAvailability()). Otherwise it will return false.
     */
    inline bool hasPhonemeAvailability () const;

    /**
     * Returns the value of the member "PhonemeAvailability".
     *
     *
     *
     * @return The value of the field "PhonemeAvailability"
     */
    inline bool getPhonemeAvailability () const;

    /**
     * Sets the value of the member "PhonemeAvailability".
     *
     *
     *
     * @param PhonemeAvailability The value which will be set
     */
    inline void setPhonemeAvailability (bool PhonemeAvailability_);

    static const T_TTSPhonemeResult &getDefaultInstance();

private:

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_Phoneme ();

    inline void clear_has_Phoneme ();

    inline void set_has_CommError ();

    inline void clear_has_CommError ();

    inline void set_has_PhonemeAvailability ();

    inline void clear_has_PhonemeAvailability ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _ID;

    ::std::string _Phoneme;

    bool _CommError;

    bool _PhonemeAvailability;

};

/**
 * Structure type representing the TTS tuning data.
 */
class T_TTSTuningFile {
public:

    /**
     * Default constructor
     */
    inline  T_TTSTuningFile ();

    /**
     * Copy constructor
     */
    inline  T_TTSTuningFile (const T_TTSTuningFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_TTSTuningFile (T_e8_TTSTunType Type_, T_e8_TunSrc SrcType_, const ::std::string& Filename_);

    /**
     * Destructor
     */
    inline  ~T_TTSTuningFile();

    /**
     * Assignment operator
     */
    inline T_TTSTuningFile& operator = (const T_TTSTuningFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TTSTuningFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TTSTuningFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TTSTuningFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TTSTuningFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * The type of the file.
     *
     * @return The value of the field "Type"
     */
    inline T_e8_TTSTunType getType () const;

    /**
     * Sets the value of the member "Type".
     *
     * The type of the file.
     *
     * @param Type The value which will be set
     */
    inline void setType (T_e8_TTSTunType Type_);

    // API of field "SrcType"

    static const int kSrcType = 1;

    /**
     * Clears the field "SrcType".
     *
     * The field will be set to its default value. The hasSrcType()
     * method will return false.
     */
    inline void clearSrcType();

    /**
     * Checks whether the field "SrcType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrcType()). Otherwise it will return false.
     */
    inline bool hasSrcType () const;

    /**
     * Returns the value of the member "SrcType".
     *
     * Tuning Source Type.
     *
     * @return The value of the field "SrcType"
     */
    inline T_e8_TunSrc getSrcType () const;

    /**
     * Sets the value of the member "SrcType".
     *
     * Tuning Source Type.
     *
     * @param SrcType The value which will be set
     */
    inline void setSrcType (T_e8_TunSrc SrcType_);

    // API of field "Filename"

    static const int kFilename = 2;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    static const T_TTSTuningFile &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    inline void set_has_SrcType ();

    inline void clear_has_SrcType ();

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_TTSTunType _Type;

    T_e8_TunSrc _SrcType;

    ::std::string _Filename;

};

/**
 * Structure type representing the language ID, the name and some additional information about the voice.
 */
class T_TTSVoiceInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TTSVoiceInfo ();

    /**
     * Copy constructor
     */
    inline  T_TTSVoiceInfo (const T_TTSVoiceInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TTSVoiceInfo (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, const ::std::string& VoiceName_, ::sds_speechdp_fi_types::T_e8_VoiceGender VoiceGender_, const ::std::string& Version_);

    /**
     * Destructor
     */
    inline  ~T_TTSVoiceInfo();

    /**
     * Assignment operator
     */
    inline T_TTSVoiceInfo& operator = (const T_TTSVoiceInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TTSVoiceInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TTSVoiceInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TTSVoiceInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TTSVoiceInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LanguageID"

    static const int kLanguageID = 0;

    /**
     * Clears the field "LanguageID".
     *
     * The field will be set to its default value. The hasLanguageID()
     * method will return false.
     */
    inline void clearLanguageID();

    /**
     * Checks whether the field "LanguageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageID()). Otherwise it will return false.
     */
    inline bool hasLanguageID () const;

    /**
     * Returns the value of the member "LanguageID".
     *
     * The LanguageCode and the CountryCode.
     *
     * @return The value of the field "LanguageID"
     */
    inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageID () const;

    /**
     * Retrieves the value of the field "LanguageID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LanguageID".
     */
    inline ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageIDMutable ();

    /**
     * Sets the value of the member "LanguageID".
     *
     * The LanguageCode and the CountryCode.
     *
     * @param LanguageID The value which will be set
     */
    inline void setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_);

    // API of field "VoiceName"

    static const int kVoiceName = 1;

    /**
     * Clears the field "VoiceName".
     *
     * The field will be set to its default value. The hasVoiceName()
     * method will return false.
     */
    inline void clearVoiceName();

    /**
     * Checks whether the field "VoiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceName()). Otherwise it will return false.
     */
    inline bool hasVoiceName () const;

    /**
     * Returns the value of the member "VoiceName".
     *
     * The name of the voice.
     *
     * @return The value of the field "VoiceName"
     */
    inline const ::std::string& getVoiceName () const;

    /**
     * Retrieves the value of the field "VoiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoiceName".
     */
    inline ::std::string& getVoiceNameMutable ();

    /**
     * Sets the value of the member "VoiceName".
     *
     * The name of the voice.
     *
     * @param VoiceName The value which will be set
     */
    inline void setVoiceName (const ::std::string& VoiceName_);

    /**
     * Sets the value of the member "VoiceName".
     *
     * The name of the voice.
     *
     * @param VoiceName The value which will be set
     */
    inline void setVoiceName (const char* VoiceName_);

    /**
     * Sets the value of the member "VoiceName".
     *
     * The name of the voice.
     *
     * @param VoiceName The value which will be set
     */
    inline void setVoiceName (const char* value, size_t size);

    // API of field "VoiceGender"

    static const int kVoiceGender = 2;

    /**
     * Clears the field "VoiceGender".
     *
     * The field will be set to its default value. The hasVoiceGender()
     * method will return false.
     */
    inline void clearVoiceGender();

    /**
     * Checks whether the field "VoiceGender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceGender()). Otherwise it will return false.
     */
    inline bool hasVoiceGender () const;

    /**
     * Returns the value of the member "VoiceGender".
     *
     * Some additional information about the voice.
     *
     * @return The value of the field "VoiceGender"
     */
    inline ::sds_speechdp_fi_types::T_e8_VoiceGender getVoiceGender () const;

    /**
     * Sets the value of the member "VoiceGender".
     *
     * Some additional information about the voice.
     *
     * @param VoiceGender The value which will be set
     */
    inline void setVoiceGender (::sds_speechdp_fi_types::T_e8_VoiceGender VoiceGender_);

    // API of field "Version"

    static const int kVersion = 3;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * Version of the voice.
     *
     * @return The value of the field "Version"
     */
    inline const ::std::string& getVersion () const;

    /**
     * Retrieves the value of the field "Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Version".
     */
    inline ::std::string& getVersionMutable ();

    /**
     * Sets the value of the member "Version".
     *
     * Version of the voice.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const ::std::string& Version_);

    /**
     * Sets the value of the member "Version".
     *
     * Version of the voice.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const char* Version_);

    /**
     * Sets the value of the member "Version".
     *
     * Version of the voice.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const char* value, size_t size);

    static const T_TTSVoiceInfo &getDefaultInstance();

private:

    inline void set_has_LanguageID ();

    inline void clear_has_LanguageID ();

    inline void set_has_VoiceName ();

    inline void clear_has_VoiceName ();

    inline void set_has_VoiceGender ();

    inline void clear_has_VoiceGender ();

    inline void set_has_Version ();

    inline void clear_has_Version ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::sds_sds2hmi_common_types::T_SDSLanguageID _LanguageID;

    ::std::string _VoiceName;

    ::sds_speechdp_fi_types::T_e8_VoiceGender _VoiceGender;

    ::std::string _Version;

};

inline  T_Phoneme::T_Phoneme ()  :
    _Word (),
    _Phonemes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Phoneme::T_Phoneme (const T_Phoneme &rhs)  :
    _Word (),
    _Phonemes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Phoneme::T_Phoneme (const ::std::string& Word_, const ::std::vector< ::std::string >& Phonemes_)  :
    _Word (Word_),
    _Phonemes (Phonemes_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Word_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Phoneme::~T_Phoneme() {
}

inline T_Phoneme& T_Phoneme::operator = (const T_Phoneme& rhs) {
    if( this != &rhs ) {
        if (rhs.hasWord()) {
            setWord(rhs.getWord());
        } else {
            clearWord();
        }
        if (rhs.hasPhonemes()) {
            setPhonemes(rhs.getPhonemes());
        } else {
            clearPhonemes();
        }
    }
    return *this;
}

inline bool T_Phoneme::operator == (const T_Phoneme& rhs) const {
    return (((!hasWord() && !rhs.hasWord()) || getWord() == rhs.getWord()) &&
        ((!hasPhonemes() && !rhs.hasPhonemes()) || getPhonemes() == rhs.getPhonemes()));
}

inline bool T_Phoneme::operator != (const T_Phoneme& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Phoneme::operator < (const T_Phoneme& rhs) const {
    if (hasWord() || rhs.hasWord()) {
        if (getWord() < rhs.getWord()) return true;
        if (getWord() > rhs.getWord()) return false;
    }
    if (hasPhonemes() || rhs.hasPhonemes()) {
        if (getPhonemes() < rhs.getPhonemes()) return true;
        if (getPhonemes() > rhs.getPhonemes()) return false;
    }
    return false;
}

inline bool T_Phoneme::operator > (const T_Phoneme& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Phoneme::clear() {
    clearWord();
    clearPhonemes();
}

inline void T_Phoneme::clearWord() {
    if (hasWord()) {
         clear_has_Word();
        _Word.clear();
     }
}

inline bool T_Phoneme::hasWord () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_Phoneme::getWord () const {
    return _Word;
}

inline ::std::string& T_Phoneme::getWordMutable () {
    set_has_Word();
    return _Word;
}

inline void T_Phoneme::setWord (const ::std::string& Word_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Word_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Word();
    this->_Word = Word_;
}

inline void T_Phoneme::setWord (const char* Word_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Word_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Word();
    this->_Word.assign(Word_);
}

inline void T_Phoneme::setWord (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Word();
    this->_Word.assign(value, size);
}

inline void T_Phoneme::clearPhonemes() {
    if (hasPhonemes()) {
         clear_has_Phonemes();
        _Phonemes.clear();
     }
}

inline bool T_Phoneme::hasPhonemes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& T_Phoneme::getPhonemes () const {
    return _Phonemes;
}

inline ::std::vector< ::std::string >& T_Phoneme::getPhonemesMutable () {
    set_has_Phonemes();
    return _Phonemes;
}

inline void T_Phoneme::setPhonemes (const ::std::vector< ::std::string >& Phonemes_) {
    set_has_Phonemes();
    this->_Phonemes = Phonemes_;
}

inline void T_Phoneme::set_has_Word () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Phoneme::clear_has_Word () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Phoneme::set_has_Phonemes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Phoneme::clear_has_Phonemes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SpeakProgress::T_SpeakProgress ()  :
    _Marker (0u),
    _LastMarkerSrcPos (0u),
    _TextUnit (0u),
    _LastTextUnitSrcPos (0u),
    _LastBookmarkID (0u),
    _JobStatus (::sds_tts_fi_types::T_e8_JobStatus__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SpeakProgress::T_SpeakProgress (const T_SpeakProgress &rhs)  :
    _Marker (0u),
    _LastMarkerSrcPos (0u),
    _TextUnit (0u),
    _LastTextUnitSrcPos (0u),
    _LastBookmarkID (0u),
    _JobStatus (::sds_tts_fi_types::T_e8_JobStatus__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SpeakProgress::T_SpeakProgress (uint16 Marker_, uint32 LastMarkerSrcPos_, uint16 TextUnit_, uint32 LastTextUnitSrcPos_, uint32 LastBookmarkID_, T_e8_JobStatus JobStatus_)  :
    _Marker (Marker_),
    _LastMarkerSrcPos (LastMarkerSrcPos_),
    _TextUnit (TextUnit_),
    _LastTextUnitSrcPos (LastTextUnitSrcPos_),
    _LastBookmarkID (LastBookmarkID_),
    _JobStatus (JobStatus_)
{
    #ifndef NDEBUG
    if (!(T_e8_JobStatus_IsValid(JobStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", JobStatus_, "T_e8_JobStatus", "JobStatus", "T_SpeakProgress");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SpeakProgress::~T_SpeakProgress() {
}

inline T_SpeakProgress& T_SpeakProgress::operator = (const T_SpeakProgress& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMarker()) {
            setMarker(rhs.getMarker());
        } else {
            clearMarker();
        }
        if (rhs.hasLastMarkerSrcPos()) {
            setLastMarkerSrcPos(rhs.getLastMarkerSrcPos());
        } else {
            clearLastMarkerSrcPos();
        }
        if (rhs.hasTextUnit()) {
            setTextUnit(rhs.getTextUnit());
        } else {
            clearTextUnit();
        }
        if (rhs.hasLastTextUnitSrcPos()) {
            setLastTextUnitSrcPos(rhs.getLastTextUnitSrcPos());
        } else {
            clearLastTextUnitSrcPos();
        }
        if (rhs.hasLastBookmarkID()) {
            setLastBookmarkID(rhs.getLastBookmarkID());
        } else {
            clearLastBookmarkID();
        }
        if (rhs.hasJobStatus()) {
            setJobStatus(rhs.getJobStatus());
        } else {
            clearJobStatus();
        }
    }
    return *this;
}

inline bool T_SpeakProgress::operator == (const T_SpeakProgress& rhs) const {
    return (((!hasMarker() && !rhs.hasMarker()) || getMarker() == rhs.getMarker()) &&
        ((!hasLastMarkerSrcPos() && !rhs.hasLastMarkerSrcPos()) || getLastMarkerSrcPos() == rhs.getLastMarkerSrcPos()) &&
        ((!hasTextUnit() && !rhs.hasTextUnit()) || getTextUnit() == rhs.getTextUnit()) &&
        ((!hasLastTextUnitSrcPos() && !rhs.hasLastTextUnitSrcPos()) || getLastTextUnitSrcPos() == rhs.getLastTextUnitSrcPos()) &&
        ((!hasLastBookmarkID() && !rhs.hasLastBookmarkID()) || getLastBookmarkID() == rhs.getLastBookmarkID()) &&
        ((!hasJobStatus() && !rhs.hasJobStatus()) || getJobStatus() == rhs.getJobStatus()));
}

inline bool T_SpeakProgress::operator != (const T_SpeakProgress& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SpeakProgress::operator < (const T_SpeakProgress& rhs) const {
    if (hasMarker() || rhs.hasMarker()) {
        if (getMarker() < rhs.getMarker()) return true;
        if (getMarker() > rhs.getMarker()) return false;
    }
    if (hasLastMarkerSrcPos() || rhs.hasLastMarkerSrcPos()) {
        if (getLastMarkerSrcPos() < rhs.getLastMarkerSrcPos()) return true;
        if (getLastMarkerSrcPos() > rhs.getLastMarkerSrcPos()) return false;
    }
    if (hasTextUnit() || rhs.hasTextUnit()) {
        if (getTextUnit() < rhs.getTextUnit()) return true;
        if (getTextUnit() > rhs.getTextUnit()) return false;
    }
    if (hasLastTextUnitSrcPos() || rhs.hasLastTextUnitSrcPos()) {
        if (getLastTextUnitSrcPos() < rhs.getLastTextUnitSrcPos()) return true;
        if (getLastTextUnitSrcPos() > rhs.getLastTextUnitSrcPos()) return false;
    }
    if (hasLastBookmarkID() || rhs.hasLastBookmarkID()) {
        if (getLastBookmarkID() < rhs.getLastBookmarkID()) return true;
        if (getLastBookmarkID() > rhs.getLastBookmarkID()) return false;
    }
    if (hasJobStatus() || rhs.hasJobStatus()) {
        if ((uint32)getJobStatus() < (uint32)rhs.getJobStatus()) return true;
        if ((uint32)getJobStatus() > (uint32)rhs.getJobStatus()) return false;
    }
    return false;
}

inline bool T_SpeakProgress::operator > (const T_SpeakProgress& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SpeakProgress::clear() {
    clearMarker();
    clearLastMarkerSrcPos();
    clearTextUnit();
    clearLastTextUnitSrcPos();
    clearLastBookmarkID();
    clearJobStatus();
}

inline void T_SpeakProgress::clearMarker() {
    if (hasMarker()) {
         clear_has_Marker();
        _Marker = 0u;
     }
}

inline bool T_SpeakProgress::hasMarker () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_SpeakProgress::getMarker () const {
    return _Marker;
}

inline void T_SpeakProgress::setMarker (uint16 Marker_) {
    set_has_Marker();
    this->_Marker = Marker_;
}

inline void T_SpeakProgress::clearLastMarkerSrcPos() {
    if (hasLastMarkerSrcPos()) {
         clear_has_LastMarkerSrcPos();
        _LastMarkerSrcPos = 0u;
     }
}

inline bool T_SpeakProgress::hasLastMarkerSrcPos () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SpeakProgress::getLastMarkerSrcPos () const {
    return _LastMarkerSrcPos;
}

inline void T_SpeakProgress::setLastMarkerSrcPos (uint32 LastMarkerSrcPos_) {
    set_has_LastMarkerSrcPos();
    this->_LastMarkerSrcPos = LastMarkerSrcPos_;
}

inline void T_SpeakProgress::clearTextUnit() {
    if (hasTextUnit()) {
         clear_has_TextUnit();
        _TextUnit = 0u;
     }
}

inline bool T_SpeakProgress::hasTextUnit () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_SpeakProgress::getTextUnit () const {
    return _TextUnit;
}

inline void T_SpeakProgress::setTextUnit (uint16 TextUnit_) {
    set_has_TextUnit();
    this->_TextUnit = TextUnit_;
}

inline void T_SpeakProgress::clearLastTextUnitSrcPos() {
    if (hasLastTextUnitSrcPos()) {
         clear_has_LastTextUnitSrcPos();
        _LastTextUnitSrcPos = 0u;
     }
}

inline bool T_SpeakProgress::hasLastTextUnitSrcPos () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_SpeakProgress::getLastTextUnitSrcPos () const {
    return _LastTextUnitSrcPos;
}

inline void T_SpeakProgress::setLastTextUnitSrcPos (uint32 LastTextUnitSrcPos_) {
    set_has_LastTextUnitSrcPos();
    this->_LastTextUnitSrcPos = LastTextUnitSrcPos_;
}

inline void T_SpeakProgress::clearLastBookmarkID() {
    if (hasLastBookmarkID()) {
         clear_has_LastBookmarkID();
        _LastBookmarkID = 0u;
     }
}

inline bool T_SpeakProgress::hasLastBookmarkID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_SpeakProgress::getLastBookmarkID () const {
    return _LastBookmarkID;
}

inline void T_SpeakProgress::setLastBookmarkID (uint32 LastBookmarkID_) {
    set_has_LastBookmarkID();
    this->_LastBookmarkID = LastBookmarkID_;
}

inline void T_SpeakProgress::clearJobStatus() {
    if (hasJobStatus()) {
         clear_has_JobStatus();
        _JobStatus = ::sds_tts_fi_types::T_e8_JobStatus__Unknown;
     }
}

inline bool T_SpeakProgress::hasJobStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_JobStatus T_SpeakProgress::getJobStatus () const {
    return _JobStatus;
}

inline void T_SpeakProgress::setJobStatus (T_e8_JobStatus JobStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_JobStatus_IsValid(JobStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", JobStatus_, "T_e8_JobStatus", "JobStatus", "T_SpeakProgress");
    }
    #endif
    set_has_JobStatus();
    this->_JobStatus = JobStatus_;
}

inline void T_SpeakProgress::set_has_Marker () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SpeakProgress::clear_has_Marker () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SpeakProgress::set_has_LastMarkerSrcPos () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SpeakProgress::clear_has_LastMarkerSrcPos () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SpeakProgress::set_has_TextUnit () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SpeakProgress::clear_has_TextUnit () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SpeakProgress::set_has_LastTextUnitSrcPos () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SpeakProgress::clear_has_LastTextUnitSrcPos () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SpeakProgress::set_has_LastBookmarkID () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SpeakProgress::clear_has_LastBookmarkID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SpeakProgress::set_has_JobStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SpeakProgress::clear_has_JobStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_FileLocation::T_FileLocation ()  :
    _SavedBlock (0u),
    _PartOfBlock (0u),
    _BlockID (0u),
    _FileLocation (),
    _FileSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FileLocation::T_FileLocation (const T_FileLocation &rhs)  :
    _SavedBlock (0u),
    _PartOfBlock (0u),
    _BlockID (0u),
    _FileLocation (),
    _FileSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FileLocation::T_FileLocation (uint8 SavedBlock_, uint8 PartOfBlock_, uint32 BlockID_, const ::std::string& FileLocation_, uint32 FileSize_)  :
    _SavedBlock (SavedBlock_),
    _PartOfBlock (PartOfBlock_),
    _BlockID (BlockID_),
    _FileLocation (FileLocation_),
    _FileSize (FileSize_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FileLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FileLocation::~T_FileLocation() {
}

inline T_FileLocation& T_FileLocation::operator = (const T_FileLocation& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSavedBlock()) {
            setSavedBlock(rhs.getSavedBlock());
        } else {
            clearSavedBlock();
        }
        if (rhs.hasPartOfBlock()) {
            setPartOfBlock(rhs.getPartOfBlock());
        } else {
            clearPartOfBlock();
        }
        if (rhs.hasBlockID()) {
            setBlockID(rhs.getBlockID());
        } else {
            clearBlockID();
        }
        if (rhs.hasFileLocation()) {
            setFileLocation(rhs.getFileLocation());
        } else {
            clearFileLocation();
        }
        if (rhs.hasFileSize()) {
            setFileSize(rhs.getFileSize());
        } else {
            clearFileSize();
        }
    }
    return *this;
}

inline bool T_FileLocation::operator == (const T_FileLocation& rhs) const {
    return (((!hasSavedBlock() && !rhs.hasSavedBlock()) || getSavedBlock() == rhs.getSavedBlock()) &&
        ((!hasPartOfBlock() && !rhs.hasPartOfBlock()) || getPartOfBlock() == rhs.getPartOfBlock()) &&
        ((!hasBlockID() && !rhs.hasBlockID()) || getBlockID() == rhs.getBlockID()) &&
        ((!hasFileLocation() && !rhs.hasFileLocation()) || getFileLocation() == rhs.getFileLocation()) &&
        ((!hasFileSize() && !rhs.hasFileSize()) || getFileSize() == rhs.getFileSize()));
}

inline bool T_FileLocation::operator != (const T_FileLocation& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FileLocation::operator < (const T_FileLocation& rhs) const {
    if (hasSavedBlock() || rhs.hasSavedBlock()) {
        if (getSavedBlock() < rhs.getSavedBlock()) return true;
        if (getSavedBlock() > rhs.getSavedBlock()) return false;
    }
    if (hasPartOfBlock() || rhs.hasPartOfBlock()) {
        if (getPartOfBlock() < rhs.getPartOfBlock()) return true;
        if (getPartOfBlock() > rhs.getPartOfBlock()) return false;
    }
    if (hasBlockID() || rhs.hasBlockID()) {
        if (getBlockID() < rhs.getBlockID()) return true;
        if (getBlockID() > rhs.getBlockID()) return false;
    }
    if (hasFileLocation() || rhs.hasFileLocation()) {
        if (getFileLocation() < rhs.getFileLocation()) return true;
        if (getFileLocation() > rhs.getFileLocation()) return false;
    }
    if (hasFileSize() || rhs.hasFileSize()) {
        if (getFileSize() < rhs.getFileSize()) return true;
        if (getFileSize() > rhs.getFileSize()) return false;
    }
    return false;
}

inline bool T_FileLocation::operator > (const T_FileLocation& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FileLocation::clear() {
    clearSavedBlock();
    clearPartOfBlock();
    clearBlockID();
    clearFileLocation();
    clearFileSize();
}

inline void T_FileLocation::clearSavedBlock() {
    if (hasSavedBlock()) {
         clear_has_SavedBlock();
        _SavedBlock = 0u;
     }
}

inline bool T_FileLocation::hasSavedBlock () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_FileLocation::getSavedBlock () const {
    return _SavedBlock;
}

inline void T_FileLocation::setSavedBlock (uint8 SavedBlock_) {
    set_has_SavedBlock();
    this->_SavedBlock = SavedBlock_;
}

inline void T_FileLocation::clearPartOfBlock() {
    if (hasPartOfBlock()) {
         clear_has_PartOfBlock();
        _PartOfBlock = 0u;
     }
}

inline bool T_FileLocation::hasPartOfBlock () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_FileLocation::getPartOfBlock () const {
    return _PartOfBlock;
}

inline void T_FileLocation::setPartOfBlock (uint8 PartOfBlock_) {
    set_has_PartOfBlock();
    this->_PartOfBlock = PartOfBlock_;
}

inline void T_FileLocation::clearBlockID() {
    if (hasBlockID()) {
         clear_has_BlockID();
        _BlockID = 0u;
     }
}

inline bool T_FileLocation::hasBlockID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_FileLocation::getBlockID () const {
    return _BlockID;
}

inline void T_FileLocation::setBlockID (uint32 BlockID_) {
    set_has_BlockID();
    this->_BlockID = BlockID_;
}

inline void T_FileLocation::clearFileLocation() {
    if (hasFileLocation()) {
         clear_has_FileLocation();
        _FileLocation.clear();
     }
}

inline bool T_FileLocation::hasFileLocation () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_FileLocation::getFileLocation () const {
    return _FileLocation;
}

inline ::std::string& T_FileLocation::getFileLocationMutable () {
    set_has_FileLocation();
    return _FileLocation;
}

inline void T_FileLocation::setFileLocation (const ::std::string& FileLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FileLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FileLocation();
    this->_FileLocation = FileLocation_;
}

inline void T_FileLocation::setFileLocation (const char* FileLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FileLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FileLocation();
    this->_FileLocation.assign(FileLocation_);
}

inline void T_FileLocation::setFileLocation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FileLocation();
    this->_FileLocation.assign(value, size);
}

inline void T_FileLocation::clearFileSize() {
    if (hasFileSize()) {
         clear_has_FileSize();
        _FileSize = 0u;
     }
}

inline bool T_FileLocation::hasFileSize () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_FileLocation::getFileSize () const {
    return _FileSize;
}

inline void T_FileLocation::setFileSize (uint32 FileSize_) {
    set_has_FileSize();
    this->_FileSize = FileSize_;
}

inline void T_FileLocation::set_has_SavedBlock () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FileLocation::clear_has_SavedBlock () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FileLocation::set_has_PartOfBlock () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FileLocation::clear_has_PartOfBlock () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FileLocation::set_has_BlockID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FileLocation::clear_has_BlockID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_FileLocation::set_has_FileLocation () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_FileLocation::clear_has_FileLocation () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_FileLocation::set_has_FileSize () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_FileLocation::clear_has_FileSize () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_BufferingProgress::T_BufferingProgress ()  :
    _FileLocation (),
    _JobStatus (::sds_tts_fi_types::T_e8_JobStatus__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BufferingProgress::T_BufferingProgress (const T_BufferingProgress &rhs)  :
    _FileLocation (),
    _JobStatus (::sds_tts_fi_types::T_e8_JobStatus__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BufferingProgress::T_BufferingProgress (const T_FileLocation& FileLocation_, T_e8_JobStatus JobStatus_)  :
    _FileLocation (FileLocation_),
    _JobStatus (JobStatus_)
{
    #ifndef NDEBUG
    if (!(T_e8_JobStatus_IsValid(JobStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", JobStatus_, "T_e8_JobStatus", "JobStatus", "T_BufferingProgress");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BufferingProgress::~T_BufferingProgress() {
}

inline T_BufferingProgress& T_BufferingProgress::operator = (const T_BufferingProgress& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFileLocation()) {
            setFileLocation(rhs.getFileLocation());
        } else {
            clearFileLocation();
        }
        if (rhs.hasJobStatus()) {
            setJobStatus(rhs.getJobStatus());
        } else {
            clearJobStatus();
        }
    }
    return *this;
}

inline bool T_BufferingProgress::operator == (const T_BufferingProgress& rhs) const {
    return (((!hasFileLocation() && !rhs.hasFileLocation()) || getFileLocation() == rhs.getFileLocation()) &&
        ((!hasJobStatus() && !rhs.hasJobStatus()) || getJobStatus() == rhs.getJobStatus()));
}

inline bool T_BufferingProgress::operator != (const T_BufferingProgress& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BufferingProgress::operator < (const T_BufferingProgress& rhs) const {
    if (hasFileLocation() || rhs.hasFileLocation()) {
        if (getFileLocation() < rhs.getFileLocation()) return true;
        if (getFileLocation() > rhs.getFileLocation()) return false;
    }
    if (hasJobStatus() || rhs.hasJobStatus()) {
        if ((uint32)getJobStatus() < (uint32)rhs.getJobStatus()) return true;
        if ((uint32)getJobStatus() > (uint32)rhs.getJobStatus()) return false;
    }
    return false;
}

inline bool T_BufferingProgress::operator > (const T_BufferingProgress& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BufferingProgress::clear() {
    clearFileLocation();
    clearJobStatus();
}

inline void T_BufferingProgress::clearFileLocation() {
    if (hasFileLocation()) {
         clear_has_FileLocation();
        _FileLocation.clear();
     }
}

inline bool T_BufferingProgress::hasFileLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_FileLocation& T_BufferingProgress::getFileLocation () const {
    return _FileLocation;
}

inline T_FileLocation& T_BufferingProgress::getFileLocationMutable () {
    set_has_FileLocation();
    return _FileLocation;
}

inline void T_BufferingProgress::setFileLocation (const T_FileLocation& FileLocation_) {
    set_has_FileLocation();
    this->_FileLocation = FileLocation_;
}

inline void T_BufferingProgress::clearJobStatus() {
    if (hasJobStatus()) {
         clear_has_JobStatus();
        _JobStatus = ::sds_tts_fi_types::T_e8_JobStatus__Unknown;
     }
}

inline bool T_BufferingProgress::hasJobStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_JobStatus T_BufferingProgress::getJobStatus () const {
    return _JobStatus;
}

inline void T_BufferingProgress::setJobStatus (T_e8_JobStatus JobStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_JobStatus_IsValid(JobStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", JobStatus_, "T_e8_JobStatus", "JobStatus", "T_BufferingProgress");
    }
    #endif
    set_has_JobStatus();
    this->_JobStatus = JobStatus_;
}

inline void T_BufferingProgress::set_has_FileLocation () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BufferingProgress::clear_has_FileLocation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BufferingProgress::set_has_JobStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BufferingProgress::clear_has_JobStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TTSVersionInfo::T_TTSVersionInfo ()  :
    _TTSEngineManufacturer (),
    _TTSEngineProductionDate (),
    _TTSEngineProductVersion (),
    _TTSModuleProductionDate (),
    _TTSModuleVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TTSVersionInfo::T_TTSVersionInfo (const T_TTSVersionInfo &rhs)  :
    _TTSEngineManufacturer (),
    _TTSEngineProductionDate (),
    _TTSEngineProductVersion (),
    _TTSModuleProductionDate (),
    _TTSModuleVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TTSVersionInfo::T_TTSVersionInfo (const ::std::string& TTSEngineManufacturer_, const ::std::string& TTSEngineProductionDate_, const ::std::string& TTSEngineProductVersion_, const ::std::string& TTSModuleProductionDate_, const ::std::string& TTSModuleVersion_)  :
    _TTSEngineManufacturer (TTSEngineManufacturer_),
    _TTSEngineProductionDate (TTSEngineProductionDate_),
    _TTSEngineProductVersion (TTSEngineProductVersion_),
    _TTSModuleProductionDate (TTSModuleProductionDate_),
    _TTSModuleVersion (TTSModuleVersion_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineManufacturer_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineProductionDate_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineProductVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSModuleProductionDate_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSModuleVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TTSVersionInfo::~T_TTSVersionInfo() {
}

inline T_TTSVersionInfo& T_TTSVersionInfo::operator = (const T_TTSVersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTTSEngineManufacturer()) {
            setTTSEngineManufacturer(rhs.getTTSEngineManufacturer());
        } else {
            clearTTSEngineManufacturer();
        }
        if (rhs.hasTTSEngineProductionDate()) {
            setTTSEngineProductionDate(rhs.getTTSEngineProductionDate());
        } else {
            clearTTSEngineProductionDate();
        }
        if (rhs.hasTTSEngineProductVersion()) {
            setTTSEngineProductVersion(rhs.getTTSEngineProductVersion());
        } else {
            clearTTSEngineProductVersion();
        }
        if (rhs.hasTTSModuleProductionDate()) {
            setTTSModuleProductionDate(rhs.getTTSModuleProductionDate());
        } else {
            clearTTSModuleProductionDate();
        }
        if (rhs.hasTTSModuleVersion()) {
            setTTSModuleVersion(rhs.getTTSModuleVersion());
        } else {
            clearTTSModuleVersion();
        }
    }
    return *this;
}

inline bool T_TTSVersionInfo::operator == (const T_TTSVersionInfo& rhs) const {
    return (((!hasTTSEngineManufacturer() && !rhs.hasTTSEngineManufacturer()) || getTTSEngineManufacturer() == rhs.getTTSEngineManufacturer()) &&
        ((!hasTTSEngineProductionDate() && !rhs.hasTTSEngineProductionDate()) || getTTSEngineProductionDate() == rhs.getTTSEngineProductionDate()) &&
        ((!hasTTSEngineProductVersion() && !rhs.hasTTSEngineProductVersion()) || getTTSEngineProductVersion() == rhs.getTTSEngineProductVersion()) &&
        ((!hasTTSModuleProductionDate() && !rhs.hasTTSModuleProductionDate()) || getTTSModuleProductionDate() == rhs.getTTSModuleProductionDate()) &&
        ((!hasTTSModuleVersion() && !rhs.hasTTSModuleVersion()) || getTTSModuleVersion() == rhs.getTTSModuleVersion()));
}

inline bool T_TTSVersionInfo::operator != (const T_TTSVersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TTSVersionInfo::operator < (const T_TTSVersionInfo& rhs) const {
    if (hasTTSEngineManufacturer() || rhs.hasTTSEngineManufacturer()) {
        if (getTTSEngineManufacturer() < rhs.getTTSEngineManufacturer()) return true;
        if (getTTSEngineManufacturer() > rhs.getTTSEngineManufacturer()) return false;
    }
    if (hasTTSEngineProductionDate() || rhs.hasTTSEngineProductionDate()) {
        if (getTTSEngineProductionDate() < rhs.getTTSEngineProductionDate()) return true;
        if (getTTSEngineProductionDate() > rhs.getTTSEngineProductionDate()) return false;
    }
    if (hasTTSEngineProductVersion() || rhs.hasTTSEngineProductVersion()) {
        if (getTTSEngineProductVersion() < rhs.getTTSEngineProductVersion()) return true;
        if (getTTSEngineProductVersion() > rhs.getTTSEngineProductVersion()) return false;
    }
    if (hasTTSModuleProductionDate() || rhs.hasTTSModuleProductionDate()) {
        if (getTTSModuleProductionDate() < rhs.getTTSModuleProductionDate()) return true;
        if (getTTSModuleProductionDate() > rhs.getTTSModuleProductionDate()) return false;
    }
    if (hasTTSModuleVersion() || rhs.hasTTSModuleVersion()) {
        if (getTTSModuleVersion() < rhs.getTTSModuleVersion()) return true;
        if (getTTSModuleVersion() > rhs.getTTSModuleVersion()) return false;
    }
    return false;
}

inline bool T_TTSVersionInfo::operator > (const T_TTSVersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TTSVersionInfo::clear() {
    clearTTSEngineManufacturer();
    clearTTSEngineProductionDate();
    clearTTSEngineProductVersion();
    clearTTSModuleProductionDate();
    clearTTSModuleVersion();
}

inline void T_TTSVersionInfo::clearTTSEngineManufacturer() {
    if (hasTTSEngineManufacturer()) {
         clear_has_TTSEngineManufacturer();
        _TTSEngineManufacturer.clear();
     }
}

inline bool T_TTSVersionInfo::hasTTSEngineManufacturer () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_TTSVersionInfo::getTTSEngineManufacturer () const {
    return _TTSEngineManufacturer;
}

inline ::std::string& T_TTSVersionInfo::getTTSEngineManufacturerMutable () {
    set_has_TTSEngineManufacturer();
    return _TTSEngineManufacturer;
}

inline void T_TTSVersionInfo::setTTSEngineManufacturer (const ::std::string& TTSEngineManufacturer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineManufacturer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineManufacturer();
    this->_TTSEngineManufacturer = TTSEngineManufacturer_;
}

inline void T_TTSVersionInfo::setTTSEngineManufacturer (const char* TTSEngineManufacturer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineManufacturer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineManufacturer();
    this->_TTSEngineManufacturer.assign(TTSEngineManufacturer_);
}

inline void T_TTSVersionInfo::setTTSEngineManufacturer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineManufacturer();
    this->_TTSEngineManufacturer.assign(value, size);
}

inline void T_TTSVersionInfo::clearTTSEngineProductionDate() {
    if (hasTTSEngineProductionDate()) {
         clear_has_TTSEngineProductionDate();
        _TTSEngineProductionDate.clear();
     }
}

inline bool T_TTSVersionInfo::hasTTSEngineProductionDate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TTSVersionInfo::getTTSEngineProductionDate () const {
    return _TTSEngineProductionDate;
}

inline ::std::string& T_TTSVersionInfo::getTTSEngineProductionDateMutable () {
    set_has_TTSEngineProductionDate();
    return _TTSEngineProductionDate;
}

inline void T_TTSVersionInfo::setTTSEngineProductionDate (const ::std::string& TTSEngineProductionDate_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineProductionDate_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineProductionDate();
    this->_TTSEngineProductionDate = TTSEngineProductionDate_;
}

inline void T_TTSVersionInfo::setTTSEngineProductionDate (const char* TTSEngineProductionDate_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineProductionDate_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineProductionDate();
    this->_TTSEngineProductionDate.assign(TTSEngineProductionDate_);
}

inline void T_TTSVersionInfo::setTTSEngineProductionDate (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineProductionDate();
    this->_TTSEngineProductionDate.assign(value, size);
}

inline void T_TTSVersionInfo::clearTTSEngineProductVersion() {
    if (hasTTSEngineProductVersion()) {
         clear_has_TTSEngineProductVersion();
        _TTSEngineProductVersion.clear();
     }
}

inline bool T_TTSVersionInfo::hasTTSEngineProductVersion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_TTSVersionInfo::getTTSEngineProductVersion () const {
    return _TTSEngineProductVersion;
}

inline ::std::string& T_TTSVersionInfo::getTTSEngineProductVersionMutable () {
    set_has_TTSEngineProductVersion();
    return _TTSEngineProductVersion;
}

inline void T_TTSVersionInfo::setTTSEngineProductVersion (const ::std::string& TTSEngineProductVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineProductVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineProductVersion();
    this->_TTSEngineProductVersion = TTSEngineProductVersion_;
}

inline void T_TTSVersionInfo::setTTSEngineProductVersion (const char* TTSEngineProductVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSEngineProductVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineProductVersion();
    this->_TTSEngineProductVersion.assign(TTSEngineProductVersion_);
}

inline void T_TTSVersionInfo::setTTSEngineProductVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSEngineProductVersion();
    this->_TTSEngineProductVersion.assign(value, size);
}

inline void T_TTSVersionInfo::clearTTSModuleProductionDate() {
    if (hasTTSModuleProductionDate()) {
         clear_has_TTSModuleProductionDate();
        _TTSModuleProductionDate.clear();
     }
}

inline bool T_TTSVersionInfo::hasTTSModuleProductionDate () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_TTSVersionInfo::getTTSModuleProductionDate () const {
    return _TTSModuleProductionDate;
}

inline ::std::string& T_TTSVersionInfo::getTTSModuleProductionDateMutable () {
    set_has_TTSModuleProductionDate();
    return _TTSModuleProductionDate;
}

inline void T_TTSVersionInfo::setTTSModuleProductionDate (const ::std::string& TTSModuleProductionDate_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSModuleProductionDate_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSModuleProductionDate();
    this->_TTSModuleProductionDate = TTSModuleProductionDate_;
}

inline void T_TTSVersionInfo::setTTSModuleProductionDate (const char* TTSModuleProductionDate_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSModuleProductionDate_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSModuleProductionDate();
    this->_TTSModuleProductionDate.assign(TTSModuleProductionDate_);
}

inline void T_TTSVersionInfo::setTTSModuleProductionDate (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSModuleProductionDate();
    this->_TTSModuleProductionDate.assign(value, size);
}

inline void T_TTSVersionInfo::clearTTSModuleVersion() {
    if (hasTTSModuleVersion()) {
         clear_has_TTSModuleVersion();
        _TTSModuleVersion.clear();
     }
}

inline bool T_TTSVersionInfo::hasTTSModuleVersion () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_TTSVersionInfo::getTTSModuleVersion () const {
    return _TTSModuleVersion;
}

inline ::std::string& T_TTSVersionInfo::getTTSModuleVersionMutable () {
    set_has_TTSModuleVersion();
    return _TTSModuleVersion;
}

inline void T_TTSVersionInfo::setTTSModuleVersion (const ::std::string& TTSModuleVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSModuleVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSModuleVersion();
    this->_TTSModuleVersion = TTSModuleVersion_;
}

inline void T_TTSVersionInfo::setTTSModuleVersion (const char* TTSModuleVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSModuleVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSModuleVersion();
    this->_TTSModuleVersion.assign(TTSModuleVersion_);
}

inline void T_TTSVersionInfo::setTTSModuleVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSModuleVersion();
    this->_TTSModuleVersion.assign(value, size);
}

inline void T_TTSVersionInfo::set_has_TTSEngineManufacturer () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TTSVersionInfo::clear_has_TTSEngineManufacturer () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TTSVersionInfo::set_has_TTSEngineProductionDate () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TTSVersionInfo::clear_has_TTSEngineProductionDate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TTSVersionInfo::set_has_TTSEngineProductVersion () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TTSVersionInfo::clear_has_TTSEngineProductVersion () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TTSVersionInfo::set_has_TTSModuleProductionDate () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TTSVersionInfo::clear_has_TTSModuleProductionDate () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TTSVersionInfo::set_has_TTSModuleVersion () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TTSVersionInfo::clear_has_TTSModuleVersion () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_TTSPhonemeResult::T_TTSPhonemeResult ()  :
    _ID (0u),
    _Phoneme (),
    _CommError (false),
    _PhonemeAvailability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TTSPhonemeResult::T_TTSPhonemeResult (const T_TTSPhonemeResult &rhs)  :
    _ID (0u),
    _Phoneme (),
    _CommError (false),
    _PhonemeAvailability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TTSPhonemeResult::T_TTSPhonemeResult (uint16 ID_, const ::std::string& Phoneme_, bool CommError_, bool PhonemeAvailability_)  :
    _ID (ID_),
    _Phoneme (Phoneme_),
    _CommError (CommError_),
    _PhonemeAvailability (PhonemeAvailability_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TTSPhonemeResult::~T_TTSPhonemeResult() {
}

inline T_TTSPhonemeResult& T_TTSPhonemeResult::operator = (const T_TTSPhonemeResult& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasPhoneme()) {
            setPhoneme(rhs.getPhoneme());
        } else {
            clearPhoneme();
        }
        if (rhs.hasCommError()) {
            setCommError(rhs.getCommError());
        } else {
            clearCommError();
        }
        if (rhs.hasPhonemeAvailability()) {
            setPhonemeAvailability(rhs.getPhonemeAvailability());
        } else {
            clearPhonemeAvailability();
        }
    }
    return *this;
}

inline bool T_TTSPhonemeResult::operator == (const T_TTSPhonemeResult& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasPhoneme() && !rhs.hasPhoneme()) || getPhoneme() == rhs.getPhoneme()) &&
        ((!hasCommError() && !rhs.hasCommError()) || getCommError() == rhs.getCommError()) &&
        ((!hasPhonemeAvailability() && !rhs.hasPhonemeAvailability()) || getPhonemeAvailability() == rhs.getPhonemeAvailability()));
}

inline bool T_TTSPhonemeResult::operator != (const T_TTSPhonemeResult& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TTSPhonemeResult::operator < (const T_TTSPhonemeResult& rhs) const {
    if (hasID() || rhs.hasID()) {
        if (getID() < rhs.getID()) return true;
        if (getID() > rhs.getID()) return false;
    }
    if (hasPhoneme() || rhs.hasPhoneme()) {
        if (getPhoneme() < rhs.getPhoneme()) return true;
        if (getPhoneme() > rhs.getPhoneme()) return false;
    }
    if (hasCommError() || rhs.hasCommError()) {
        if (getCommError() < rhs.getCommError()) return true;
        if (getCommError() > rhs.getCommError()) return false;
    }
    if (hasPhonemeAvailability() || rhs.hasPhonemeAvailability()) {
        if (getPhonemeAvailability() < rhs.getPhonemeAvailability()) return true;
        if (getPhonemeAvailability() > rhs.getPhonemeAvailability()) return false;
    }
    return false;
}

inline bool T_TTSPhonemeResult::operator > (const T_TTSPhonemeResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TTSPhonemeResult::clear() {
    clearID();
    clearPhoneme();
    clearCommError();
    clearPhonemeAvailability();
}

inline void T_TTSPhonemeResult::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = 0u;
     }
}

inline bool T_TTSPhonemeResult::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_TTSPhonemeResult::getID () const {
    return _ID;
}

inline void T_TTSPhonemeResult::setID (uint16 ID_) {
    set_has_ID();
    this->_ID = ID_;
}

inline void T_TTSPhonemeResult::clearPhoneme() {
    if (hasPhoneme()) {
         clear_has_Phoneme();
        _Phoneme.clear();
     }
}

inline bool T_TTSPhonemeResult::hasPhoneme () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TTSPhonemeResult::getPhoneme () const {
    return _Phoneme;
}

inline ::std::string& T_TTSPhonemeResult::getPhonemeMutable () {
    set_has_Phoneme();
    return _Phoneme;
}

inline void T_TTSPhonemeResult::setPhoneme (const ::std::string& Phoneme_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phoneme();
    this->_Phoneme = Phoneme_;
}

inline void T_TTSPhonemeResult::setPhoneme (const char* Phoneme_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phoneme();
    this->_Phoneme.assign(Phoneme_);
}

inline void T_TTSPhonemeResult::setPhoneme (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phoneme();
    this->_Phoneme.assign(value, size);
}

inline void T_TTSPhonemeResult::clearCommError() {
    if (hasCommError()) {
         clear_has_CommError();
        _CommError = false;
     }
}

inline bool T_TTSPhonemeResult::hasCommError () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_TTSPhonemeResult::getCommError () const {
    return _CommError;
}

inline void T_TTSPhonemeResult::setCommError (bool CommError_) {
    set_has_CommError();
    this->_CommError = CommError_;
}

inline void T_TTSPhonemeResult::clearPhonemeAvailability() {
    if (hasPhonemeAvailability()) {
         clear_has_PhonemeAvailability();
        _PhonemeAvailability = false;
     }
}

inline bool T_TTSPhonemeResult::hasPhonemeAvailability () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_TTSPhonemeResult::getPhonemeAvailability () const {
    return _PhonemeAvailability;
}

inline void T_TTSPhonemeResult::setPhonemeAvailability (bool PhonemeAvailability_) {
    set_has_PhonemeAvailability();
    this->_PhonemeAvailability = PhonemeAvailability_;
}

inline void T_TTSPhonemeResult::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TTSPhonemeResult::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TTSPhonemeResult::set_has_Phoneme () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TTSPhonemeResult::clear_has_Phoneme () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TTSPhonemeResult::set_has_CommError () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TTSPhonemeResult::clear_has_CommError () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TTSPhonemeResult::set_has_PhonemeAvailability () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TTSPhonemeResult::clear_has_PhonemeAvailability () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_TTSTuningFile::T_TTSTuningFile ()  :
    _Type (::sds_tts_fi_types::T_e8_TTSTunType__TunedPromptsDatabase),
    _SrcType (::sds_tts_fi_types::T_e8_TunSrc__System),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TTSTuningFile::T_TTSTuningFile (const T_TTSTuningFile &rhs)  :
    _Type (::sds_tts_fi_types::T_e8_TTSTunType__TunedPromptsDatabase),
    _SrcType (::sds_tts_fi_types::T_e8_TunSrc__System),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TTSTuningFile::T_TTSTuningFile (T_e8_TTSTunType Type_, T_e8_TunSrc SrcType_, const ::std::string& Filename_)  :
    _Type (Type_),
    _SrcType (SrcType_),
    _Filename (Filename_)
{
    #ifndef NDEBUG
    if (!(T_e8_TTSTunType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_TTSTunType", "Type", "T_TTSTuningFile");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TunSrc_IsValid(SrcType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SrcType_, "T_e8_TunSrc", "SrcType", "T_TTSTuningFile");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TTSTuningFile::~T_TTSTuningFile() {
}

inline T_TTSTuningFile& T_TTSTuningFile::operator = (const T_TTSTuningFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasSrcType()) {
            setSrcType(rhs.getSrcType());
        } else {
            clearSrcType();
        }
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
    }
    return *this;
}

inline bool T_TTSTuningFile::operator == (const T_TTSTuningFile& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasSrcType() && !rhs.hasSrcType()) || getSrcType() == rhs.getSrcType()) &&
        ((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()));
}

inline bool T_TTSTuningFile::operator != (const T_TTSTuningFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TTSTuningFile::operator < (const T_TTSTuningFile& rhs) const {
    if (hasType() || rhs.hasType()) {
        if ((uint32)getType() < (uint32)rhs.getType()) return true;
        if ((uint32)getType() > (uint32)rhs.getType()) return false;
    }
    if (hasSrcType() || rhs.hasSrcType()) {
        if ((uint32)getSrcType() < (uint32)rhs.getSrcType()) return true;
        if ((uint32)getSrcType() > (uint32)rhs.getSrcType()) return false;
    }
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    return false;
}

inline bool T_TTSTuningFile::operator > (const T_TTSTuningFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TTSTuningFile::clear() {
    clearType();
    clearSrcType();
    clearFilename();
}

inline void T_TTSTuningFile::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type = ::sds_tts_fi_types::T_e8_TTSTunType__TunedPromptsDatabase;
     }
}

inline bool T_TTSTuningFile::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TTSTunType T_TTSTuningFile::getType () const {
    return _Type;
}

inline void T_TTSTuningFile::setType (T_e8_TTSTunType Type_) {
    #ifndef NDEBUG
    if (!(T_e8_TTSTunType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_TTSTunType", "Type", "T_TTSTuningFile");
    }
    #endif
    set_has_Type();
    this->_Type = Type_;
}

inline void T_TTSTuningFile::clearSrcType() {
    if (hasSrcType()) {
         clear_has_SrcType();
        _SrcType = ::sds_tts_fi_types::T_e8_TunSrc__System;
     }
}

inline bool T_TTSTuningFile::hasSrcType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TunSrc T_TTSTuningFile::getSrcType () const {
    return _SrcType;
}

inline void T_TTSTuningFile::setSrcType (T_e8_TunSrc SrcType_) {
    #ifndef NDEBUG
    if (!(T_e8_TunSrc_IsValid(SrcType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SrcType_, "T_e8_TunSrc", "SrcType", "T_TTSTuningFile");
    }
    #endif
    set_has_SrcType();
    this->_SrcType = SrcType_;
}

inline void T_TTSTuningFile::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool T_TTSTuningFile::hasFilename () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_TTSTuningFile::getFilename () const {
    return _Filename;
}

inline ::std::string& T_TTSTuningFile::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void T_TTSTuningFile::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void T_TTSTuningFile::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void T_TTSTuningFile::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void T_TTSTuningFile::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TTSTuningFile::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TTSTuningFile::set_has_SrcType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TTSTuningFile::clear_has_SrcType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TTSTuningFile::set_has_Filename () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TTSTuningFile::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TTSVoiceInfo::T_TTSVoiceInfo ()  :
    _LanguageID (),
    _VoiceName (),
    _VoiceGender (::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown),
    _Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TTSVoiceInfo::T_TTSVoiceInfo (const T_TTSVoiceInfo &rhs)  :
    _LanguageID (),
    _VoiceName (),
    _VoiceGender (::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown),
    _Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TTSVoiceInfo::T_TTSVoiceInfo (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, const ::std::string& VoiceName_, ::sds_speechdp_fi_types::T_e8_VoiceGender VoiceGender_, const ::std::string& Version_)  :
    _LanguageID (LanguageID_),
    _VoiceName (VoiceName_),
    _VoiceGender (VoiceGender_),
    _Version (Version_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VoiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_speechdp_fi_types::T_e8_VoiceGender_IsValid(VoiceGender_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoiceGender_, "T_e8_VoiceGender", "VoiceGender", "T_TTSVoiceInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Version_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TTSVoiceInfo::~T_TTSVoiceInfo() {
}

inline T_TTSVoiceInfo& T_TTSVoiceInfo::operator = (const T_TTSVoiceInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageID()) {
            setLanguageID(rhs.getLanguageID());
        } else {
            clearLanguageID();
        }
        if (rhs.hasVoiceName()) {
            setVoiceName(rhs.getVoiceName());
        } else {
            clearVoiceName();
        }
        if (rhs.hasVoiceGender()) {
            setVoiceGender(rhs.getVoiceGender());
        } else {
            clearVoiceGender();
        }
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
    }
    return *this;
}

inline bool T_TTSVoiceInfo::operator == (const T_TTSVoiceInfo& rhs) const {
    return (((!hasLanguageID() && !rhs.hasLanguageID()) || getLanguageID() == rhs.getLanguageID()) &&
        ((!hasVoiceName() && !rhs.hasVoiceName()) || getVoiceName() == rhs.getVoiceName()) &&
        ((!hasVoiceGender() && !rhs.hasVoiceGender()) || getVoiceGender() == rhs.getVoiceGender()) &&
        ((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()));
}

inline bool T_TTSVoiceInfo::operator != (const T_TTSVoiceInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TTSVoiceInfo::operator < (const T_TTSVoiceInfo& rhs) const {
    if (hasLanguageID() || rhs.hasLanguageID()) {
        if (getLanguageID() < rhs.getLanguageID()) return true;
        if (getLanguageID() > rhs.getLanguageID()) return false;
    }
    if (hasVoiceName() || rhs.hasVoiceName()) {
        if (getVoiceName() < rhs.getVoiceName()) return true;
        if (getVoiceName() > rhs.getVoiceName()) return false;
    }
    if (hasVoiceGender() || rhs.hasVoiceGender()) {
        if ((uint32)getVoiceGender() < (uint32)rhs.getVoiceGender()) return true;
        if ((uint32)getVoiceGender() > (uint32)rhs.getVoiceGender()) return false;
    }
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    return false;
}

inline bool T_TTSVoiceInfo::operator > (const T_TTSVoiceInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TTSVoiceInfo::clear() {
    clearLanguageID();
    clearVoiceName();
    clearVoiceGender();
    clearVersion();
}

inline void T_TTSVoiceInfo::clearLanguageID() {
    if (hasLanguageID()) {
         clear_has_LanguageID();
        _LanguageID.clear();
     }
}

inline bool T_TTSVoiceInfo::hasLanguageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& T_TTSVoiceInfo::getLanguageID () const {
    return _LanguageID;
}

inline ::sds_sds2hmi_common_types::T_SDSLanguageID& T_TTSVoiceInfo::getLanguageIDMutable () {
    set_has_LanguageID();
    return _LanguageID;
}

inline void T_TTSVoiceInfo::setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_) {
    set_has_LanguageID();
    this->_LanguageID = LanguageID_;
}

inline void T_TTSVoiceInfo::clearVoiceName() {
    if (hasVoiceName()) {
         clear_has_VoiceName();
        _VoiceName.clear();
     }
}

inline bool T_TTSVoiceInfo::hasVoiceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TTSVoiceInfo::getVoiceName () const {
    return _VoiceName;
}

inline ::std::string& T_TTSVoiceInfo::getVoiceNameMutable () {
    set_has_VoiceName();
    return _VoiceName;
}

inline void T_TTSVoiceInfo::setVoiceName (const ::std::string& VoiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VoiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VoiceName();
    this->_VoiceName = VoiceName_;
}

inline void T_TTSVoiceInfo::setVoiceName (const char* VoiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VoiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VoiceName();
    this->_VoiceName.assign(VoiceName_);
}

inline void T_TTSVoiceInfo::setVoiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VoiceName();
    this->_VoiceName.assign(value, size);
}

inline void T_TTSVoiceInfo::clearVoiceGender() {
    if (hasVoiceGender()) {
         clear_has_VoiceGender();
        _VoiceGender = ::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown;
     }
}

inline bool T_TTSVoiceInfo::hasVoiceGender () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::sds_speechdp_fi_types::T_e8_VoiceGender T_TTSVoiceInfo::getVoiceGender () const {
    return _VoiceGender;
}

inline void T_TTSVoiceInfo::setVoiceGender (::sds_speechdp_fi_types::T_e8_VoiceGender VoiceGender_) {
    #ifndef NDEBUG
    if (!(::sds_speechdp_fi_types::T_e8_VoiceGender_IsValid(VoiceGender_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoiceGender_, "T_e8_VoiceGender", "VoiceGender", "T_TTSVoiceInfo");
    }
    #endif
    set_has_VoiceGender();
    this->_VoiceGender = VoiceGender_;
}

inline void T_TTSVoiceInfo::clearVersion() {
    if (hasVersion()) {
         clear_has_Version();
        _Version.clear();
     }
}

inline bool T_TTSVoiceInfo::hasVersion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_TTSVoiceInfo::getVersion () const {
    return _Version;
}

inline ::std::string& T_TTSVoiceInfo::getVersionMutable () {
    set_has_Version();
    return _Version;
}

inline void T_TTSVoiceInfo::setVersion (const ::std::string& Version_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Version_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Version();
    this->_Version = Version_;
}

inline void T_TTSVoiceInfo::setVersion (const char* Version_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Version_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Version();
    this->_Version.assign(Version_);
}

inline void T_TTSVoiceInfo::setVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Version();
    this->_Version.assign(value, size);
}

inline void T_TTSVoiceInfo::set_has_LanguageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TTSVoiceInfo::clear_has_LanguageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TTSVoiceInfo::set_has_VoiceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TTSVoiceInfo::clear_has_VoiceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TTSVoiceInfo::set_has_VoiceGender () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TTSVoiceInfo::clear_has_VoiceGender () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TTSVoiceInfo::set_has_Version () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TTSVoiceInfo::clear_has_Version () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace sds_tts_fi_types

#endif // SDS_TTS_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
