/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_TTS_FIPROXY_H
#define SDS_TTS_FIPROXY_H

#include "SDS_TTS_FI.h"
#include "acr_fi_types.h"
#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sds_sds2hmi_common_types.h"
#include "sds_speechdp_fi_types.h"
#include "sds_tts_fi_types.h"
#include "sds_tts_fi_typesConst.h"
#include <string>
#include <vector>

namespace SDS_TTS_FI {

class SDS_TTS_FIProxy;

class AbortPromptCallbackIF {
public:
    virtual ~AbortPromptCallbackIF() {}

    virtual void onAbortPromptError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< AbortPromptError >& error) = 0;

    virtual void onAbortPromptResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< AbortPromptResult >& result) = 0;
};

class AbortPromptWithExtensionCallbackIF {
public:
    virtual ~AbortPromptWithExtensionCallbackIF() {}

    virtual void onAbortPromptWithExtensionError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< AbortPromptWithExtensionError >& error) = 0;

    virtual void onAbortPromptWithExtensionResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< AbortPromptWithExtensionResult >& result) = 0;
};

class AvailableVoicesCallbackIF {
public:
    virtual ~AvailableVoicesCallbackIF() {}

    virtual void onAvailableVoicesError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< AvailableVoicesError >& error) = 0;

    virtual void onAvailableVoicesStatus(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< AvailableVoicesStatus >& status) = 0;
};

class ContinuePromptCallbackIF {
public:
    virtual ~ContinuePromptCallbackIF() {}

    virtual void onContinuePromptError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< ContinuePromptError >& error) = 0;

    virtual void onContinuePromptResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< ContinuePromptResult >& result) = 0;
};

class ContinuePromptWithExtensionCallbackIF {
public:
    virtual ~ContinuePromptWithExtensionCallbackIF() {}

    virtual void onContinuePromptWithExtensionError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< ContinuePromptWithExtensionError >& error) = 0;

    virtual void onContinuePromptWithExtensionResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< ContinuePromptWithExtensionResult >& result) = 0;
};

class DoAudioOutputSpeakCallbackIF {
public:
    virtual ~DoAudioOutputSpeakCallbackIF() {}

    virtual void onDoAudioOutputSpeakError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputSpeakError >& error) = 0;

    virtual void onDoAudioOutputSpeakResultFirst(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputSpeakResultFirst >& result) = 0;

    virtual void onDoAudioOutputSpeakResultLast(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputSpeakResultLast >& result) = 0;

    virtual void onDoAudioOutputSpeakResultMiddle(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputSpeakResultMiddle >& result) = 0;
};

class DoAudioOutputSpeakWithExtensionCallbackIF {
public:
    virtual ~DoAudioOutputSpeakWithExtensionCallbackIF() {}

    virtual void onDoAudioOutputSpeakWithExtensionError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputSpeakWithExtensionError >& error) = 0;

    virtual void onDoAudioOutputSpeakWithExtensionResultFirst(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputSpeakWithExtensionResultFirst >& result) = 0;

    virtual void onDoAudioOutputSpeakWithExtensionResultLast(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputSpeakWithExtensionResultLast >& result) = 0;

    virtual void onDoAudioOutputSpeakWithExtensionResultMiddle(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputSpeakWithExtensionResultMiddle >& result) = 0;
};

class DoAudioOutputWriteCallbackIF {
public:
    virtual ~DoAudioOutputWriteCallbackIF() {}

    virtual void onDoAudioOutputWriteError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputWriteError >& error) = 0;

    virtual void onDoAudioOutputWriteResultFirst(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputWriteResultFirst >& result) = 0;

    virtual void onDoAudioOutputWriteResultLast(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputWriteResultLast >& result) = 0;

    virtual void onDoAudioOutputWriteResultMiddle(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoAudioOutputWriteResultMiddle >& result) = 0;
};

class DoPrepareAudioOutputCallbackIF {
public:
    virtual ~DoPrepareAudioOutputCallbackIF() {}

    virtual void onDoPrepareAudioOutputError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoPrepareAudioOutputError >& error) = 0;

    virtual void onDoPrepareAudioOutputResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoPrepareAudioOutputResult >& result) = 0;
};

class DoReleaseAudioDeviceCallbackIF {
public:
    virtual ~DoReleaseAudioDeviceCallbackIF() {}

    virtual void onDoReleaseAudioDeviceError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoReleaseAudioDeviceError >& error) = 0;

    virtual void onDoReleaseAudioDeviceResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoReleaseAudioDeviceResult >& result) = 0;
};

class DoReleaseDataCallbackIF {
public:
    virtual ~DoReleaseDataCallbackIF() {}

    virtual void onDoReleaseDataError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoReleaseDataError >& error) = 0;

    virtual void onDoReleaseDataResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoReleaseDataResult >& result) = 0;
};

class DoRequestPhonemeCallbackIF {
public:
    virtual ~DoRequestPhonemeCallbackIF() {}

    virtual void onDoRequestPhonemeError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoRequestPhonemeError >& error) = 0;

    virtual void onDoRequestPhonemeResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoRequestPhonemeResult >& result) = 0;
};

class DoSynthesisForSpeakCallbackIF {
public:
    virtual ~DoSynthesisForSpeakCallbackIF() {}

    virtual void onDoSynthesisForSpeakError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoSynthesisForSpeakError >& error) = 0;

    virtual void onDoSynthesisForSpeakResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoSynthesisForSpeakResult >& result) = 0;
};

class DoSynthesisForSpeakWithExtentionCallbackIF {
public:
    virtual ~DoSynthesisForSpeakWithExtentionCallbackIF() {}

    virtual void onDoSynthesisForSpeakWithExtentionError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoSynthesisForSpeakWithExtentionError >& error) = 0;

    virtual void onDoSynthesisForSpeakWithExtentionResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoSynthesisForSpeakWithExtentionResult >& result) = 0;
};

class DoSynthesisForWriteCallbackIF {
public:
    virtual ~DoSynthesisForWriteCallbackIF() {}

    virtual void onDoSynthesisForWriteError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoSynthesisForWriteError >& error) = 0;

    virtual void onDoSynthesisForWriteResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoSynthesisForWriteResult >& result) = 0;
};

class DoUpRegToPropertiesCallbackIF {
public:
    virtual ~DoUpRegToPropertiesCallbackIF() {}

    virtual void onDoUpRegToPropertiesError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoUpRegToPropertiesError >& error) = 0;

    virtual void onDoUpRegToPropertiesResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DoUpRegToPropertiesResult >& result) = 0;
};

class DownloadCompleteCallbackIF {
public:
    virtual ~DownloadCompleteCallbackIF() {}

    virtual void onDownloadCompleteError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DownloadCompleteError >& error) = 0;

    virtual void onDownloadCompleteStatus(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< DownloadCompleteStatus >& status) = 0;
};

class LoadTuningFilesCallbackIF {
public:
    virtual ~LoadTuningFilesCallbackIF() {}

    virtual void onLoadTuningFilesError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< LoadTuningFilesError >& error) = 0;

    virtual void onLoadTuningFilesResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< LoadTuningFilesResult >& result) = 0;
};

class PausePromptCallbackIF {
public:
    virtual ~PausePromptCallbackIF() {}

    virtual void onPausePromptError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< PausePromptError >& error) = 0;

    virtual void onPausePromptResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< PausePromptResult >& result) = 0;
};

class PausePromptWithExtensionCallbackIF {
public:
    virtual ~PausePromptWithExtensionCallbackIF() {}

    virtual void onPausePromptWithExtensionError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< PausePromptWithExtensionError >& error) = 0;

    virtual void onPausePromptWithExtensionResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< PausePromptWithExtensionResult >& result) = 0;
};

class PrepareVoiceOutputCallbackIF {
public:
    virtual ~PrepareVoiceOutputCallbackIF() {}

    virtual void onPrepareVoiceOutputError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< PrepareVoiceOutputError >& error) = 0;

    virtual void onPrepareVoiceOutputResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< PrepareVoiceOutputResult >& result) = 0;
};

class ReleaseDataCallbackIF {
public:
    virtual ~ReleaseDataCallbackIF() {}

    virtual void onReleaseDataError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< ReleaseDataError >& error) = 0;

    virtual void onReleaseDataResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< ReleaseDataResult >& result) = 0;
};

class RequestPhonemeCallbackIF {
public:
    virtual ~RequestPhonemeCallbackIF() {}

    virtual void onRequestPhonemeError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< RequestPhonemeError >& error) = 0;

    virtual void onRequestPhonemeResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< RequestPhonemeResult >& result) = 0;
};

class SetDefaultSpeechRateCallbackIF {
public:
    virtual ~SetDefaultSpeechRateCallbackIF() {}

    virtual void onSetDefaultSpeechRateError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SetDefaultSpeechRateError >& error) = 0;

    virtual void onSetDefaultSpeechRateResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SetDefaultSpeechRateResult >& result) = 0;
};

class SetVoiceCallbackIF {
public:
    virtual ~SetVoiceCallbackIF() {}

    virtual void onSetVoiceError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SetVoiceError >& error) = 0;

    virtual void onSetVoiceResult(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SetVoiceResult >& result) = 0;
};

class SynthesizeSpeakCallbackIF {
public:
    virtual ~SynthesizeSpeakCallbackIF() {}

    virtual void onSynthesizeSpeakError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakError >& error) = 0;

    virtual void onSynthesizeSpeakResultFirst(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakResultFirst >& result) = 0;

    virtual void onSynthesizeSpeakResultLast(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakResultLast >& result) = 0;

    virtual void onSynthesizeSpeakResultMiddle(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakResultMiddle >& result) = 0;
};

class SynthesizeSpeakWithExtensionCallbackIF {
public:
    virtual ~SynthesizeSpeakWithExtensionCallbackIF() {}

    virtual void onSynthesizeSpeakWithExtensionError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakWithExtensionError >& error) = 0;

    virtual void onSynthesizeSpeakWithExtensionResultFirst(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakWithExtensionResultFirst >& result) = 0;

    virtual void onSynthesizeSpeakWithExtensionResultLast(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakWithExtensionResultLast >& result) = 0;

    virtual void onSynthesizeSpeakWithExtensionResultMiddle(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakWithExtensionResultMiddle >& result) = 0;
};

class SynthesizeWriteCallbackIF {
public:
    virtual ~SynthesizeWriteCallbackIF() {}

    virtual void onSynthesizeWriteError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeWriteError >& error) = 0;

    virtual void onSynthesizeWriteResultFirst(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeWriteResultFirst >& result) = 0;

    virtual void onSynthesizeWriteResultLast(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeWriteResultLast >& result) = 0;

    virtual void onSynthesizeWriteResultMiddle(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< SynthesizeWriteResultMiddle >& result) = 0;
};

class TTSPlaybackSpacingCallbackIF {
public:
    virtual ~TTSPlaybackSpacingCallbackIF() {}

    virtual void onTTSPlaybackSpacingError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< TTSPlaybackSpacingError >& error) = 0;

    virtual void onTTSPlaybackSpacingStatus(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< TTSPlaybackSpacingStatus >& status) = 0;
};

class TTSStatusCallbackIF {
public:
    virtual ~TTSStatusCallbackIF() {}

    virtual void onTTSStatusError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< TTSStatusError >& error) = 0;

    virtual void onTTSStatusStatus(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< TTSStatusStatus >& status) = 0;
};

class TTSVersionInfoCallbackIF {
public:
    virtual ~TTSVersionInfoCallbackIF() {}

    virtual void onTTSVersionInfoError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< TTSVersionInfoError >& error) = 0;

    virtual void onTTSVersionInfoStatus(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< TTSVersionInfoStatus >& status) = 0;
};

class VoiceCallbackIF {
public:
    virtual ~VoiceCallbackIF() {}

    virtual void onVoiceError(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< VoiceError >& error) = 0;

    virtual void onVoiceStatus(const ::boost::shared_ptr< SDS_TTS_FIProxy >& proxy, const ::boost::shared_ptr< VoiceStatus >& status) = 0;
};

class SDS_TTS_FIProxyCallback;

/**
 * SDS_TTS_FIProxy is the client side representation of the CCA Functional
 * Interface 'SDS_TTS_FI' (specified in file sds_tts_fi.xml).
 *
 * CCA Functional Interface 'SDS_TTS_FI'
 *
 * Fullname: TTS Functional Interface
 *
 * Version: $Revision:$
 *
 * Author: Joachim Schneider, Chethan R
 *
 * Date: $Date:22.06.2016$
 *
 * Department: Bosch SoftTec / PJ-CF44
 *
 * Title: TTS_FI
 *
 * <b>Description of 'SDS_TTS_FI':</b>
 *
 * This document defines the functional interface of the FC_TTS including further specifications of the FC_TTS.
 */
class SDS_TTS_FIProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of SDS_TTS_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< SDS_TTS_FIProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of SDS_TTS_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< SDS_TTS_FIProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of SDS_TTS_FIProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< SDS_TTS_FIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of SDS_TTS_FIProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~SDS_TTS_FIProxy();

    // Method 'SynthesizeSpeak'

    /**
     * Call the method 'SynthesizeSpeak'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SynthesizeSpeak'</b>:
     *
     * <p>This method is used to synthesize text. The synthesised data
     * is played via the audiomanagement with the available dev/acousticout.
     * For every incoming job, the property "ChannelRequest" from the ACR_FI
     * is used to request the audiochannel from the AudioManagement. If the
     * AudioManagement sends back the method "VoiceAdvice" for the
     * corresponding job, the synthesis will be executed.</p>
     * Test requirement : "partly test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @param TextStyle <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @param AudioOutputLocation <p>This parameter can be used to define the outputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.</p>
     * Test requirement : "no test"
     *
     * @param StatusInfo <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     * Test requirement : "full test"
     *
     * @param ExpDate <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted
     * from the queue and the client will be informed.</p>
     * <p>If a client uses the possibility to transmit jobs/strings in
     * multiple packages, only the exp. date of the first job will
     * be examined, as the expiration date referres to the start
     * of a job.</p>
     * Test requirement : "full test"
     *
     * @param LastPackage <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     * Test requirement : "no test"
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSynthesizeSpeakStart(SynthesizeSpeakCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle, const ::acr_fi_types::T_b8_AudioOutputLocation& audioOutputLocation, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, uint32 expDate, bool lastPackage);

    // Method 'SynthesizeWrite'

    /**
     * Call the method 'SynthesizeWrite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SynthesizeWrite'</b>:
     *
     * <p>This method is used to synthesize text and to write it into buffers.
     * The buffers will be written to shared memory and the path is transmitted to the client.
     * The jobs are listed in a queue without any priority (at the moment).
     * The jobs in the list will be synthesized in FIFO fashion.</p>
     * Test requirement : "partly test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags <p>In addition to the design of this string and the rate,vol and dict tags described in the SynthesizeSpeak-Method,
     * this method has one more tag <file>
     * The  tag <file id=...>Text</file> indicates, what parts of the string must be synthesized and saved to shared memory.
     * Only the Text between the <file id=...>Text</file> will be synthesized.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * Test requirement : "full test"
     *
     * @param TextStyle <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @param Buffering <p>Defines the mode, how the client wants a file-block to be transmitted. At the time, two different
     * options are designed: Write one file-block to one buffer or write one file-block to multiple buffers of a defined size.
     * The size of this buffer is defined in the registry.</p>
     * Test requirement : "partly test"
     *
     * @param ExpDate <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted from the queue and the client will be informed.</p>
     * Test requirement : "no test"
     *
     * @param LastPackage <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue.</p>
     * Test requirement : "no test"
     *
     * @param Compression <p>Kind of audio format to be used.</p>
     * Test requirement : "full test"
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSynthesizeWriteStart(SynthesizeWriteCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle, ::sds_tts_fi_types::T_e8_BufferingOption buffering, uint32 expDate, bool lastPackage, const ::acr_fi_types::T_b8_AudioFormat& compression);

    // Method 'SynthesizeSpeakWithExtension'

    /**
     * Call the method 'SynthesizeSpeakWithExtension'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SynthesizeSpeakWithExtension'</b>:
     *
     * <p>This method is used to synthesize text. The synthesised data
     * is played via the audiomanagement with the available dev/acousticout.
     * SDS will request the audio channel from the AudioManagement. In case that AM
     * doesn't assign the channel , an error will be returned</p>
     * Test requirement : "partly test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @param TextStyle <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @param LanguageID <p>The languagecode which text presents.The method re-
     * turns error if the language code is not identical with the
     * one which SDS uses.</p>
     *
     * @param AudioOutputLocation <p>This parameter can be used to define the outputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.</p>
     * Test requirement : "no test"
     *
     * @param StatusInfo <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     * Test requirement : "full test"
     *
     * @param ExpDate <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted
     * from the queue and the client will be informed.</p>
     * <p>If a client uses the possibility to transmit jobs/strings in
     * multiple packages, only the exp. date of the first job will
     * be examined, as the expiration date referres to the start
     * of a job.</p>
     * Test requirement : "full test"
     *
     * @param LastPackage <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     * Test requirement : "no test"
     *
     * @param Index <p>inform TTS how many times the request has been sent for the particular text string.</p>
     *
     * @param SpeechSequence <p>The parameter SpeechSequence defines when the sentence should be spoken.</p>
     * <p>FC_TTS uses the sequence inform to sort the incoming requests in the queue</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSynthesizeSpeakWithExtensionStart(SynthesizeSpeakWithExtensionCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_AudioSourceID textStyle, const ::sds_sds2hmi_common_types::T_SDSLanguageID& languageID, const ::acr_fi_types::T_b8_AudioOutputLocation& audioOutputLocation, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, uint32 expDate, bool lastPackage, uint8 index, ::sds_tts_fi_types::T_e8SequenceCategory speechSequence);

    // Method 'PrepareVoiceOutput'

    /**
     * Call the method 'PrepareVoiceOutput'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'PrepareVoiceOutput'</b>:
     *
     * <p>Method will be called by client to let the FC TTS prepare the audio
     * device in advance of a synthesis. As a result of this method, the
     * FC TTS will request the audiomanagement for the audio channel via
     * ACR_FI ChannelRequest. if VoiceAdvice is received by FC TTS, the
     * audio device will be opened and the parameters set accordingly.
     * if this is done completely and the Method is answered by the
     * Methodresult, the client may then send the SynthesizeSpeak-Method.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Device <p>Parameter contains actual / configured AcousticOut Device Path.
     * If this parameter is empty, default path /dev/acousticout/speech
     * shall be used by TTS for speechoutput.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPrepareVoiceOutputStart(PrepareVoiceOutputCallbackIF& cb, const ::std::string& device);

    // Method 'ReleaseData'

    /**
     * Call the method 'ReleaseData'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'ReleaseData'</b>:
     *
     * <p>All language-dependent software and memory must be unitialized and
     * released as a preparative action befor an upload of a language afterwards.
     * All data/dictionaries will be unloaded and devices closed.
     * A running job will be aborted and the job-queue deleted.</p>
     * Test requirement : "in progress"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ReleaseType The type of data, which will not be needed any more/will be changed.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReleaseDataStart(ReleaseDataCallbackIF& cb, ::sds_tts_fi_types::T_e8_ReleaseTypeTTS releaseType);

    // Method 'SetVoice'

    /**
     * Call the method 'SetVoice'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SetVoice'</b>:
     *
     * <p>Changes the voice of the TTS within the used language.</p>
     * Test requirement : "in progress"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TTSVoice Parameter contains all information about the voice to be loaded.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetVoiceStart(SetVoiceCallbackIF& cb, const ::sds_speechdp_fi_types::T_VoiceType& tTSVoice);

    // Method 'AbortPrompt'

    /**
     * Call the method 'AbortPrompt'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AbortPrompt'</b>:
     *
     * <p>This Method provides an opportunity for the prompter, to stop the synthesis at a given point.
     * The job will be aborted and not continued at any time. The client will be informed.
     * If he want the synthesis to be done again, he has to start a new job.</p>
     * Test requirement : "partly test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AbortPromptOption Test requirement : "partly test"
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbortPromptStart(AbortPromptCallbackIF& cb, ::sds_tts_fi_types::T_e8_PromptAbortOption abortPromptOption);

    // Method 'PausePrompt'

    /**
     * Call the method 'PausePrompt'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'PausePrompt'</b>:
     *
     * <p>This Method provides an opportunity for the prompter, to pause the synthesis at a given point.
     * The job will be continued at the same point it has stopped, when the Method "ContinuePrompt" is used.</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param PausePromptOption If the meaning of "PausePromptOption" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPausePromptStart(PausePromptCallbackIF& cb, ::sds_tts_fi_types::T_e8_PromptAbortOption pausePromptOption);

    // Method 'ContinuePrompt'

    /**
     * Call the method 'ContinuePrompt'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ContinuePrompt'</b>:
     *
     * <p>This Method is the corresponding one to the "PausePrompt"-Method
     * and to "AbortPrompt". The FC TTS will not do any synthesis, until
     * this method is used after an "AbortPromot" or "PausePrompt".</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Dummy If the meaning of "Dummy" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendContinuePromptStart(ContinuePromptCallbackIF& cb, uint8 dummy);

    // Method 'AbortPromptWithExtension'

    /**
     * Call the method 'AbortPromptWithExtension'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AbortPromptWithExtension'</b>:
     *
     * <p>This Method provides an opportunity for the prompter, to stop the synthesis at a given point.
     * The job will be aborted and not continued at any time. The client will be informed.
     * If he want the synthesis to be done again, he has to start a new job.</p>
     * Abort prompt which is started by SynthesizeSpeakWithExtension.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AbortPromptOption Test requirement : "partly test"
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbortPromptWithExtensionStart(AbortPromptWithExtensionCallbackIF& cb, ::sds_tts_fi_types::T_e8_PromptAbortOption abortPromptOption);

    // Method 'PausePromptWithExtension'

    /**
     * Call the method 'PausePromptWithExtension'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'PausePromptWithExtension'</b>:
     *
     * <p>This Method provides an opportunity for the prompter, to pause the synthesis at a given point.
     * The job will be continued at the same point it has stopped, when the Method "ContinuePrompt" is used.</p>
     * Pause prompt which is started by SynthesizeSpeakWithExtension.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param PausePromptOption If the meaning of "PausePromptOption" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPausePromptWithExtensionStart(PausePromptWithExtensionCallbackIF& cb, ::sds_tts_fi_types::T_e8_PromptAbortOption pausePromptOption);

    // Method 'ContinuePromptWithExtension'

    /**
     * Call the method 'ContinuePromptWithExtension'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ContinuePromptWithExtension'</b>:
     *
     * <p>This Method is the corresponding one to the "PausePromptWithExtension"-Method.
     * The FC TTS will not do any synthesis, until "PausePromptWithExtension".</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Dummy If the meaning of "Dummy" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendContinuePromptWithExtensionStart(ContinuePromptWithExtensionCallbackIF& cb, uint8 dummy);

    // Method 'RequestPhoneme'

    /**
     * Call the method 'RequestPhoneme'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RequestPhoneme'</b>:
     *
     * <p>This Method is used to request a phoneme representation for the
     * given SourceText by means of database request (e.g. via FC_SDP)
     * according to the provided tagging (<dict>). The result combines the provided FileID (<file id=...>) with the phoneme representation in the PhonemeList</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @param TextStyle This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestPhonemeStart(RequestPhonemeCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle);

    // Method 'LoadTuningFiles'

    /**
     * Call the method 'LoadTuningFiles'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'LoadTuningFiles'</b>:
     *
     * <p>This method is used by the client to request TTS to load the tuning for a particular domain by providing it.</p>
     * <p>On this request TTS shall only buffer the file paths and actual loading of these tuning files will be done only when the</p>
     * <p>SynthesizeSpeak request is received with correct domain</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TTSTunFiles List of TTS Tuning data files for the current system language.
     *
     * @param TTSDomain Domain related to the TTS Tuning files.
     *
     * @param TTSVersion TTS Engine version to which the tuning files are compatible.
     * Expected format is EngineType Version (Major Num).(Minor Num).
     * e.g. "VAUTO 5.4" or "VE 1.3".
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoadTuningFilesStart(LoadTuningFilesCallbackIF& cb, const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& tTSTunFiles, ::sds_tts_fi_types::T_e8_TTSDomain tTSDomain, const ::std::string& tTSVersion);

    // Method 'SetDefaultSpeechRate'

    /**
     * Call the method 'SetDefaultSpeechRate'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetDefaultSpeechRate'</b>:
     *
     * <p>Changes the speech rate of the Vocalizer Engine.</p>
     * <p>This method is internal to SDS only and should not be called by any external TTS clients !!</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Rate <p>Parameter defines / contains Speech rate value.</p>
     * <p>The value can be in the range [50..400] where 50 being 2x slower and 400 being 4x faster of the normal speech.</p>
     * <p>Default value : 100</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDefaultSpeechRateStart(SetDefaultSpeechRateCallbackIF& cb, uint16 rate);

    // Method 'DoSynthesisForSpeak'

    /**
     * Call the method 'DoSynthesisForSpeak'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoSynthesisForSpeak'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * The used parameters are identical to those of the method SynthesizeSpeak
     * (except of the 2 not used parameters AudioOutputLocation and ExpDate).</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @param TextStyle This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @param StatusInfo <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @param LastPackage <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoSynthesisForSpeakStart(DoSynthesisForSpeakCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, bool lastPackage);

    // Method 'DoPrepareAudioOutput'

    /**
     * Call the method 'DoPrepareAudioOutput'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoPrepareAudioOutput'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * This method is used to initiate all necessary steps to do an audio
     * output with the Audio output device (e.g. Open Device...).</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceName <p>Devicename given by VoiceAdvice-Method by Audiomanagement
     * will be forwarded to the AudioOutputThread.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoPrepareAudioOutputStart(DoPrepareAudioOutputCallbackIF& cb, const ::std::string& deviceName);

    // Method 'DoAudioOutputSpeak'

    /**
     * Call the method 'DoAudioOutputSpeak'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoAudioOutputSpeak'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * The used parameters are identical to those of the method SynthesizeSpeak
     * (except of not used parameters).</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param StatusInfo <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @param AudioOutputLocation This parameter can be used to define the ouputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoAudioOutputSpeakStart(DoAudioOutputSpeakCallbackIF& cb, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, const ::acr_fi_types::T_b8_AudioOutputLocation& audioOutputLocation);

    // Method 'DoUpRegToProperties'

    /**
     * Call the method 'DoUpRegToProperties'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoUpRegToProperties'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * This method is used to inform all (work-)threads, that the
     * application is gone to normal. At this point, every Thread
     * has to register on the TTS-Properties, as they are organized
     * as membervariables of the MsgControlThread.</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoUpRegToPropertiesStart(DoUpRegToPropertiesCallbackIF& cb);

    // Method 'DoSynthesisForWrite'

    /**
     * Call the method 'DoSynthesisForWrite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoSynthesisForWrite'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * The used parameters are identical to those of the method SynthesizeWrite
     * (except of not used parameter ExpDate).</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags In addition to the design of this string and the dic-tag described in the SynthesizeSpeak-Method,
     * this method has one more tag. Thus, this method provides two tags, which are <dict> and <file>:
     * The dict-tag is used in the same way as with SynthesizeSpeak.
     * The second tag <file>Text</file> indicates, what parts of the string must be saved to shared memory.
     *
     * @param TextStyle This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @param LastPackage <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoSynthesisForWriteStart(DoSynthesisForWriteCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle, bool lastPackage);

    // Method 'DoAudioOutputWrite'

    /**
     * Call the method 'DoAudioOutputWrite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoAudioOutputWrite'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * The used parameters are identical to those of the method SynthesizeWrite
     * (except of not used parameters).</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Buffering Defines the mode, how the client wants a file-block to be transmitted. At the time, two different
     * options are designed: Write one file-block to one buffer or write one file-block to multiple buffers of a defined size.
     * The size of this buffer is defined in the registry.
     *
     * @param Compression Kind of audio format to be used.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoAudioOutputWriteStart(DoAudioOutputWriteCallbackIF& cb, ::sds_tts_fi_types::T_e8_BufferingOption buffering, const ::acr_fi_types::T_b8_AudioFormat& compression);

    // Method 'DoSynthesisForSpeakWithExtention'

    /**
     * Call the method 'DoSynthesisForSpeakWithExtention'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DoSynthesisForSpeakWithExtention'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * The used parameters are identical to those of the method SynthesizeSpeak
     * (except of the 2 not used parameters AudioOutputLocation and ExpDate).</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @param TextStyle This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @param StatusInfo <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @param LastPackage <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoSynthesisForSpeakWithExtentionStart(DoSynthesisForSpeakWithExtentionCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_AudioSourceID textStyle, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, bool lastPackage);

    // Method 'DoReleaseData'

    /**
     * Call the method 'DoReleaseData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoReleaseData'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * The used parameters are identical to those of the method ReleaseData.</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ReleaseType The type of data, which will not be needed any more/will be changed.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoReleaseDataStart(DoReleaseDataCallbackIF& cb, ::sds_tts_fi_types::T_e8_ReleaseTypeTTS releaseType);

    // Method 'DoReleaseAudioDevice'

    /**
     * Call the method 'DoReleaseAudioDevice'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoReleaseAudioDevice'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is called, if the audiodevice has already been opened and
     * set up for audio output and a PromptAbort came to the FC TTS in
     * the meantime.</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoReleaseAudioDeviceStart(DoReleaseAudioDeviceCallbackIF& cb);

    // Method 'DoRequestPhoneme'

    /**
     * Call the method 'DoRequestPhoneme'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DoRequestPhoneme'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * The used parameters are identical to those of the method ReleaseData.</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @param TextStyle This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoRequestPhonemeStart(DoRequestPhonemeCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle);

    // Method 'DoAudioOutputSpeakWithExtension'

    /**
     * Call the method 'DoAudioOutputSpeakWithExtension'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DoAudioOutputSpeakWithExtension'</b>:
     *
     * <p>Method for internal communication of FC TTS.
     * This method is for internal use only!
     * The used parameters are identical to those of the method SynthesizeSpeak
     * (except of not used parameters).</p>
     * Test requirement : "no test"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param StatusInfo <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @param AudioOutputLocation This parameter can be used to define the ouputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoAudioOutputSpeakWithExtensionStart(DoAudioOutputSpeakWithExtensionCallbackIF& cb, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, const ::acr_fi_types::T_b8_AudioOutputLocation& audioOutputLocation);

    // Property 'Voice'

    /**
     * Notify on the property 'Voice'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'Voice'</b>:
     *
     * <p>This property can be used to check, which voice is currently used. The type is defined by the
     * Speech Data Provider and contains information about language, country, gender and name of the voice.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVoiceUpReg(VoiceCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Voice'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Voice'</b>:
     *
     * <p>This property can be used to check, which voice is currently used. The type is defined by the
     * Speech Data Provider and contains information about language, country, gender and name of the voice.</p>
     * Test requirement : "full test"
     *
     * @param act The act which was previously returned by the
     * sendVoiceUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVoiceRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Voice'.
     */
    void sendVoiceRelUpRegAll ();

    /**
     * Returns the current value of the property 'Voice' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVoice()
     * returns true.
     *
     * @return the previously received value of the property 'Voice'.
     */
    const VoiceStatus& getVoice() const;

    /**
     * Determines whether a status message for the property 'Voice' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVoice() const;

    /**
     * Request the value of the property 'Voice' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Voice'</b>:
     *
     * <p>This property can be used to check, which voice is currently used. The type is defined by the
     * Speech Data Provider and contains information about language, country, gender and name of the voice.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVoiceGet(VoiceCallbackIF& cb);

    // Property 'AvailableVoices'

    /**
     * Notify on the property 'AvailableVoices'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AvailableVoices'</b>:
     *
     * <p>This property can be used to check, which different voices are available for the used language</p>
     * Test requirement : "partly test"
     * This property will currenty only be filled with the content "0 voices available",
     * although the implementation of the property is complete (by concept).
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvailableVoicesUpReg(AvailableVoicesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AvailableVoices'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AvailableVoices'</b>:
     *
     * <p>This property can be used to check, which different voices are available for the used language</p>
     * Test requirement : "partly test"
     * This property will currenty only be filled with the content "0 voices available",
     * although the implementation of the property is complete (by concept).
     *
     * @param act The act which was previously returned by the
     * sendAvailableVoicesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAvailableVoicesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AvailableVoices'.
     */
    void sendAvailableVoicesRelUpRegAll ();

    /**
     * Returns the current value of the property 'AvailableVoices' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAvailableVoices() returns true.
     *
     * @return the previously received value of the property 'AvailableVoices'.
     */
    const AvailableVoicesStatus& getAvailableVoices() const;

    /**
     * Determines whether a status message for the property 'AvailableVoices' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAvailableVoices() const;

    /**
     * Request the value of the property 'AvailableVoices' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AvailableVoices'</b>:
     *
     * <p>This property can be used to check, which different voices are available for the used language</p>
     * Test requirement : "partly test"
     * This property will currenty only be filled with the content "0 voices available",
     * although the implementation of the property is complete (by concept).
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvailableVoicesGet(AvailableVoicesCallbackIF& cb);

    // Property 'TTSVersionInfo'

    /**
     * Notify on the property 'TTSVersionInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'TTSVersionInfo'</b>:
     *
     * <p>This property can be used to check, which tts-engine and which version of the tts-module is currently used/running.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTTSVersionInfoUpReg(TTSVersionInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TTSVersionInfo'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TTSVersionInfo'</b>:
     *
     * <p>This property can be used to check, which tts-engine and which version of the tts-module is currently used/running.</p>
     * Test requirement : "full test"
     *
     * @param act The act which was previously returned by the
     * sendTTSVersionInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTTSVersionInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TTSVersionInfo'.
     */
    void sendTTSVersionInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'TTSVersionInfo' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTTSVersionInfo() returns true.
     *
     * @return the previously received value of the property 'TTSVersionInfo'.
     */
    const TTSVersionInfoStatus& getTTSVersionInfo() const;

    /**
     * Determines whether a status message for the property 'TTSVersionInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTTSVersionInfo() const;

    /**
     * Request the value of the property 'TTSVersionInfo' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TTSVersionInfo'</b>:
     *
     * <p>This property can be used to check, which tts-engine and which version of the tts-module is currently used/running.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTTSVersionInfoGet(TTSVersionInfoCallbackIF& cb);

    // Property 'TTSStatus'

    /**
     * Notify on the property 'TTSStatus'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'TTSStatus'</b>:
     *
     * <p>This property can be used to check, in which status the tts-synthesis is.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTTSStatusUpReg(TTSStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TTSStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TTSStatus'</b>:
     *
     * <p>This property can be used to check, in which status the tts-synthesis is.</p>
     * Test requirement : "full test"
     *
     * @param act The act which was previously returned by the
     * sendTTSStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTTSStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TTSStatus'.
     */
    void sendTTSStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'TTSStatus' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTTSStatus()
     * returns true.
     *
     * @return the previously received value of the property 'TTSStatus'.
     */
    const TTSStatusStatus& getTTSStatus() const;

    /**
     * Determines whether a status message for the property 'TTSStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTTSStatus() const;

    /**
     * Request the value of the property 'TTSStatus' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TTSStatus'</b>:
     *
     * <p>This property can be used to check, in which status the tts-synthesis is.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTTSStatusGet(TTSStatusCallbackIF& cb);

    // Property 'DownloadComplete'

    /**
     * Notify on the property 'DownloadComplete'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DownloadComplete'</b>:
     *
     * <p>The client is informed by this property about finishing of download.
     * After receiving ReleaseData for language change the FC TTS sets this property to FALSE.
     * FC VoiceControl forces the SDP via DownloadSDSLanguage to copy the new data from media (e.g. DVD or CD-ROM)
     * into  flash. After download complete and successfull the FC TTS sets this property to TRUE.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadCompleteUpReg(DownloadCompleteCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DownloadComplete'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DownloadComplete'</b>:
     *
     * <p>The client is informed by this property about finishing of download.
     * After receiving ReleaseData for language change the FC TTS sets this property to FALSE.
     * FC VoiceControl forces the SDP via DownloadSDSLanguage to copy the new data from media (e.g. DVD or CD-ROM)
     * into  flash. After download complete and successfull the FC TTS sets this property to TRUE.</p>
     * Test requirement : "full test"
     *
     * @param act The act which was previously returned by the
     * sendDownloadCompleteUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDownloadCompleteRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DownloadComplete'.
     */
    void sendDownloadCompleteRelUpRegAll ();

    /**
     * Returns the current value of the property 'DownloadComplete' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDownloadComplete() returns true.
     *
     * @return the previously received value of the property 'DownloadComplete'.
     */
    const DownloadCompleteStatus& getDownloadComplete() const;

    /**
     * Determines whether a status message for the property 'DownloadComplete' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDownloadComplete() const;

    /**
     * Request the value of the property 'DownloadComplete' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DownloadComplete'</b>:
     *
     * <p>The client is informed by this property about finishing of download.
     * After receiving ReleaseData for language change the FC TTS sets this property to FALSE.
     * FC VoiceControl forces the SDP via DownloadSDSLanguage to copy the new data from media (e.g. DVD or CD-ROM)
     * into  flash. After download complete and successfull the FC TTS sets this property to TRUE.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadCompleteGet(DownloadCompleteCallbackIF& cb);

    // Property 'TTSPlaybackSpacing'

    /**
     * Notify on the property 'TTSPlaybackSpacing'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'TTSPlaybackSpacing'</b>:
     *
     * <p>This property can be used to change the playback spacing.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTTSPlaybackSpacingUpReg(TTSPlaybackSpacingCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TTSPlaybackSpacing'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TTSPlaybackSpacing'</b>:
     *
     * <p>This property can be used to change the playback spacing.</p>
     * Test requirement : "full test"
     *
     * @param act The act which was previously returned by the
     * sendTTSPlaybackSpacingUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTTSPlaybackSpacingRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TTSPlaybackSpacing'.
     */
    void sendTTSPlaybackSpacingRelUpRegAll ();

    /**
     * Returns the current value of the property 'TTSPlaybackSpacing' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasTTSPlaybackSpacing() returns true.
     *
     * @return the previously received value of the property 'TTSPlaybackSpacing'.
     */
    const TTSPlaybackSpacingStatus& getTTSPlaybackSpacing() const;

    /**
     * Determines whether a status message for the property 'TTSPlaybackSpacing' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTTSPlaybackSpacing() const;

    /**
     * Set the value of the property 'TTSPlaybackSpacing'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'TTSPlaybackSpacing'</b>:
     *
     * <p>This property can be used to change the playback spacing.</p>
     * Test requirement : "full test"
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param PlaybackSpacing Wait period inserted between two text units (e.g. sentences), on a
     * scale from 0 to 9. Each unit is equivalent to 200ms of silence.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTTSPlaybackSpacingSet(TTSPlaybackSpacingCallbackIF& cb, uint8 playbackSpacing);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    SDS_TTS_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'Voice'

    ::asf::core::nullable< VoiceStatus > _voice;

    // Property 'AvailableVoices'

    ::asf::core::nullable< AvailableVoicesStatus > _availableVoices;

    // Property 'TTSVersionInfo'

    ::asf::core::nullable< TTSVersionInfoStatus > _tTSVersionInfo;

    // Property 'TTSStatus'

    ::asf::core::nullable< TTSStatusStatus > _tTSStatus;

    // Property 'DownloadComplete'

    ::asf::core::nullable< DownloadCompleteStatus > _downloadComplete;

    // Property 'TTSPlaybackSpacing'

    ::asf::core::nullable< TTSPlaybackSpacingStatus > _tTSPlaybackSpacing;

    DECLARE_CLASS_LOGGER();

    friend class SDS_TTS_FIProxyCallback;
};

} // namespace SDS_TTS_FI

#endif // SDS_TTS_FIPROXY_H
