/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "SDS_TTS_FIConst.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/stream/json.h"
#include <cstddef>
#include <cstdlib>

/**
 * CCA Functional Interface 'SDS_TTS_FI'
 *
 * Fullname: TTS Functional Interface
 *
 * Version: $Revision:$
 *
 * Author: Joachim Schneider, Chethan R
 *
 * Date: $Date:22.06.2016$
 *
 * Department: Bosch SoftTec / PJ-CF44
 *
 * Title: TTS_FI
 *
 * <b>Description of 'SDS_TTS_FI':</b>
 *
 * This document defines the functional interface of the FC_TTS including further specifications of the FC_TTS.
 */

using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

bool SynthesizeSpeakErrorCode_Parse (const char *str, size_t length, SynthesizeSpeakErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {10,"JOBABORTED", 24593U},
        {10,"JOBEXPIRED", 24589U},
        {13,"MEMORYCORRUPT", 24587U},
        {17,"DICTIONARYCORRUPT", 24577U},
        {18,"AUDIODEVICENOTOPEN", 24597U},
        {19,"LANGUAGENOTONMEMORY", 24584U},
        {20,"LANGUAGENOTAVAILABLE", 24583U},
        {23,"NOSHAREDMEMORYAVAILABLE", 24580U},
        {23,"TRANSMITTEDSTRINGTOOBIG", 24579U},
        {24,"INVALIDCOMPRESSIONFORMAT", 24585U},
        {24,"NOTENOUGHMEMORYAVAILABLE", 24578U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* SynthesizeSpeakErrorCode_Name (SynthesizeSpeakErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "DictionaryCorrupt",
        "NotEnoughMemoryAvailable",
        "TransmittedStringTooBig",
        "NoSharedMemoryAvailable",
        "LanguageNotAvailable",
        "LanguageNotOnMemory",
        "InvalidCompressionFormat",
        "MemoryCorrupt",
        "JobExpired",
        "JobAborted",
        "AudioDeviceNotOpen",
    };

    static unsigned int enumerationValues[] = {
        24577U,
        24578U,
        24579U,
        24580U,
        24583U,
        24584U,
        24585U,
        24587U,
        24589U,
        24593U,
        24597U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 11, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool SynthesizeSpeakErrorCode_IsValid (SynthesizeSpeakErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case SynthesizeSpeakErrorCode__DictionaryCorrupt:
    case SynthesizeSpeakErrorCode__NotEnoughMemoryAvailable:
    case SynthesizeSpeakErrorCode__TransmittedStringTooBig:
    case SynthesizeSpeakErrorCode__NoSharedMemoryAvailable:
    case SynthesizeSpeakErrorCode__LanguageNotAvailable:
    case SynthesizeSpeakErrorCode__LanguageNotOnMemory:
    case SynthesizeSpeakErrorCode__InvalidCompressionFormat:
    case SynthesizeSpeakErrorCode__MemoryCorrupt:
    case SynthesizeSpeakErrorCode__JobExpired:
    case SynthesizeSpeakErrorCode__JobAborted:
    case SynthesizeSpeakErrorCode__AudioDeviceNotOpen:
        return true;
    default:
        return false;
    }
}

bool SynthesizeWriteErrorCode_Parse (const char *str, size_t length, SynthesizeWriteErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {10,"JOBEXPIRED", 24589U},
        {13,"MEMORYCORRUPT", 24587U},
        {17,"DICTIONARYCORRUPT", 24577U},
        {19,"LANGUAGENOTONMEMORY", 24584U},
        {20,"LANGUAGENOTAVAILABLE", 24583U},
        {23,"NOSHAREDMEMORYAVAILABLE", 24580U},
        {23,"TRANSMITTEDSTRINGTOOBIG", 24579U},
        {24,"INVALIDCOMPRESSIONFORMAT", 24585U},
        {24,"NOTENOUGHMEMORYAVAILABLE", 24578U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* SynthesizeWriteErrorCode_Name (SynthesizeWriteErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "DictionaryCorrupt",
        "NotEnoughMemoryAvailable",
        "TransmittedStringTooBig",
        "NoSharedMemoryAvailable",
        "LanguageNotAvailable",
        "LanguageNotOnMemory",
        "InvalidCompressionFormat",
        "MemoryCorrupt",
        "JobExpired",
    };

    static unsigned int enumerationValues[] = {
        24577U,
        24578U,
        24579U,
        24580U,
        24583U,
        24584U,
        24585U,
        24587U,
        24589U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 9, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool SynthesizeWriteErrorCode_IsValid (SynthesizeWriteErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case SynthesizeWriteErrorCode__DictionaryCorrupt:
    case SynthesizeWriteErrorCode__NotEnoughMemoryAvailable:
    case SynthesizeWriteErrorCode__TransmittedStringTooBig:
    case SynthesizeWriteErrorCode__NoSharedMemoryAvailable:
    case SynthesizeWriteErrorCode__LanguageNotAvailable:
    case SynthesizeWriteErrorCode__LanguageNotOnMemory:
    case SynthesizeWriteErrorCode__InvalidCompressionFormat:
    case SynthesizeWriteErrorCode__MemoryCorrupt:
    case SynthesizeWriteErrorCode__JobExpired:
        return true;
    default:
        return false;
    }
}

bool SynthesizeSpeakWithExtensionErrorCode_Parse (const char *str, size_t length, SynthesizeSpeakWithExtensionErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {10,"JOBABORTED", 24593U},
        {10,"JOBEXPIRED", 24589U},
        {13,"MEMORYCORRUPT", 24587U},
        {17,"DICTIONARYCORRUPT", 24577U},
        {18,"AUDIODEVICENOTOPEN", 24597U},
        {19,"LANGUAGENOTONMEMORY", 24584U},
        {20,"LANGUAGENOTAVAILABLE", 24583U},
        {22,"LANGUAGECODENOTCORRECT", 24604U},
        {22,"NOAUDIOCHANNELASSIGNED", 24603U},
        {23,"NOSHAREDMEMORYAVAILABLE", 24580U},
        {23,"TRANSMITTEDSTRINGTOOBIG", 24579U},
        {24,"INVALIDCOMPRESSIONFORMAT", 24585U},
        {24,"NOTENOUGHMEMORYAVAILABLE", 24578U},
    };

    return lookupInStringEntryTable (str, length, entries, 13, (unsigned int&) value);
}

const char* SynthesizeSpeakWithExtensionErrorCode_Name (SynthesizeSpeakWithExtensionErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "DictionaryCorrupt",
        "NotEnoughMemoryAvailable",
        "TransmittedStringTooBig",
        "NoSharedMemoryAvailable",
        "LanguageNotAvailable",
        "LanguageNotOnMemory",
        "InvalidCompressionFormat",
        "MemoryCorrupt",
        "JobExpired",
        "JobAborted",
        "AudioDeviceNotOpen",
        "NoAudioChannelAssigned",
        "LanguageCodeNotCorrect",
    };

    static unsigned int enumerationValues[] = {
        24577U,
        24578U,
        24579U,
        24580U,
        24583U,
        24584U,
        24585U,
        24587U,
        24589U,
        24593U,
        24597U,
        24603U,
        24604U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 13, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool SynthesizeSpeakWithExtensionErrorCode_IsValid (SynthesizeSpeakWithExtensionErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case SynthesizeSpeakWithExtensionErrorCode__DictionaryCorrupt:
    case SynthesizeSpeakWithExtensionErrorCode__NotEnoughMemoryAvailable:
    case SynthesizeSpeakWithExtensionErrorCode__TransmittedStringTooBig:
    case SynthesizeSpeakWithExtensionErrorCode__NoSharedMemoryAvailable:
    case SynthesizeSpeakWithExtensionErrorCode__LanguageNotAvailable:
    case SynthesizeSpeakWithExtensionErrorCode__LanguageNotOnMemory:
    case SynthesizeSpeakWithExtensionErrorCode__InvalidCompressionFormat:
    case SynthesizeSpeakWithExtensionErrorCode__MemoryCorrupt:
    case SynthesizeSpeakWithExtensionErrorCode__JobExpired:
    case SynthesizeSpeakWithExtensionErrorCode__JobAborted:
    case SynthesizeSpeakWithExtensionErrorCode__AudioDeviceNotOpen:
    case SynthesizeSpeakWithExtensionErrorCode__NoAudioChannelAssigned:
    case SynthesizeSpeakWithExtensionErrorCode__LanguageCodeNotCorrect:
        return true;
    default:
        return false;
    }
}

bool PrepareVoiceOutputErrorCode_Parse (const char *str, size_t length, PrepareVoiceOutputErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {10,"JOBABORTED", 24593U},
        {15,"AUDIODEVICEBUSY", 24592U},
        {20,"ENGINENOTINITIALIZED", 24599U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* PrepareVoiceOutputErrorCode_Name (PrepareVoiceOutputErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "AudioDeviceBusy",
        "JobAborted",
        "EngineNotInitialized",
    };

    static unsigned int enumerationValues[] = {
        24592U,
        24593U,
        24599U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool PrepareVoiceOutputErrorCode_IsValid (PrepareVoiceOutputErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case PrepareVoiceOutputErrorCode__AudioDeviceBusy:
    case PrepareVoiceOutputErrorCode__JobAborted:
    case PrepareVoiceOutputErrorCode__EngineNotInitialized:
        return true;
    default:
        return false;
    }
}

bool ReleaseDataErrorCode_Parse (const char *str, size_t length, ReleaseDataErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {14,"TTSNOTRELEASED", 24591U},
        {17,"INVALIDLANGUAGEID", 261U},
        {19,"LANGUAGENOTONMEMORY", 24584U},
        {20,"LANGUAGENOTAVAILABLE", 24583U},
        {21,"CURRENTLYSYNTHESIZING", 24596U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* ReleaseDataErrorCode_Name (ReleaseDataErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "InvalidLanguageID",
        "LanguageNotAvailable",
        "LanguageNotOnMemory",
        "TTSNotReleased",
        "CurrentlySynthesizing",
    };

    static unsigned int enumerationValues[] = {
        261U,
        24583U,
        24584U,
        24591U,
        24596U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool ReleaseDataErrorCode_IsValid (ReleaseDataErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case ReleaseDataErrorCode__InvalidLanguageID:
    case ReleaseDataErrorCode__LanguageNotAvailable:
    case ReleaseDataErrorCode__LanguageNotOnMemory:
    case ReleaseDataErrorCode__TTSNotReleased:
    case ReleaseDataErrorCode__CurrentlySynthesizing:
        return true;
    default:
        return false;
    }
}

bool SetVoiceErrorCode_Parse (const char *str, size_t length, SetVoiceErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {14,"TTSNOTRELEASED", 24591U},
        {16,"VOICENOTONMEMORY", 24582U},
        {17,"VOICENOTAVAILABLE", 24581U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* SetVoiceErrorCode_Name (SetVoiceErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "VoiceNotAvailable",
        "VoiceNotOnMemory",
        "TTSNotReleased",
    };

    static unsigned int enumerationValues[] = {
        24581U,
        24582U,
        24591U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool SetVoiceErrorCode_IsValid (SetVoiceErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case SetVoiceErrorCode__VoiceNotAvailable:
    case SetVoiceErrorCode__VoiceNotOnMemory:
    case SetVoiceErrorCode__TTSNotReleased:
        return true;
    default:
        return false;
    }
}

bool AbortPromptErrorCode_Parse (const char *str, size_t length, AbortPromptErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {12,"NOJOBRUNNING", 24594U},
        {13,"MEMORYCORRUPT", 24587U},
        {16,"TOOMUCHINPUTDATA", 257U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* AbortPromptErrorCode_Name (AbortPromptErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "TooMuchInputData",
        "MemoryCorrupt",
        "NoJobRunning",
    };

    static unsigned int enumerationValues[] = {
        257U,
        24587U,
        24594U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool AbortPromptErrorCode_IsValid (AbortPromptErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case AbortPromptErrorCode__TooMuchInputData:
    case AbortPromptErrorCode__MemoryCorrupt:
    case AbortPromptErrorCode__NoJobRunning:
        return true;
    default:
        return false;
    }
}

bool PausePromptErrorCode_Parse (const char *str, size_t length, PausePromptErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {13,"MEMORYCORRUPT", 24587U},
        {16,"TOOMUCHINPUTDATA", 257U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* PausePromptErrorCode_Name (PausePromptErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "TooMuchInputData",
        "MemoryCorrupt",
    };

    static unsigned int enumerationValues[] = {
        257U,
        24587U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 2, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool PausePromptErrorCode_IsValid (PausePromptErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case PausePromptErrorCode__TooMuchInputData:
    case PausePromptErrorCode__MemoryCorrupt:
        return true;
    default:
        return false;
    }
}

bool ContinuePromptErrorCode_Parse (const char *str, size_t length, ContinuePromptErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {13,"MEMORYCORRUPT", 24587U},
        {16,"TOOMUCHINPUTDATA", 257U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* ContinuePromptErrorCode_Name (ContinuePromptErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "TooMuchInputData",
        "MemoryCorrupt",
    };

    static unsigned int enumerationValues[] = {
        257U,
        24587U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 2, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool ContinuePromptErrorCode_IsValid (ContinuePromptErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case ContinuePromptErrorCode__TooMuchInputData:
    case ContinuePromptErrorCode__MemoryCorrupt:
        return true;
    default:
        return false;
    }
}

bool AbortPromptWithExtensionErrorCode_Parse (const char *str, size_t length, AbortPromptWithExtensionErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {12,"NOJOBRUNNING", 24594U},
        {13,"MEMORYCORRUPT", 24587U},
        {16,"TOOMUCHINPUTDATA", 257U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* AbortPromptWithExtensionErrorCode_Name (AbortPromptWithExtensionErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "TooMuchInputData",
        "MemoryCorrupt",
        "NoJobRunning",
    };

    static unsigned int enumerationValues[] = {
        257U,
        24587U,
        24594U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool AbortPromptWithExtensionErrorCode_IsValid (AbortPromptWithExtensionErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case AbortPromptWithExtensionErrorCode__TooMuchInputData:
    case AbortPromptWithExtensionErrorCode__MemoryCorrupt:
    case AbortPromptWithExtensionErrorCode__NoJobRunning:
        return true;
    default:
        return false;
    }
}

bool PausePromptWithExtensionErrorCode_Parse (const char *str, size_t length, PausePromptWithExtensionErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {13,"MEMORYCORRUPT", 24587U},
        {16,"TOOMUCHINPUTDATA", 257U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* PausePromptWithExtensionErrorCode_Name (PausePromptWithExtensionErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "TooMuchInputData",
        "MemoryCorrupt",
    };

    static unsigned int enumerationValues[] = {
        257U,
        24587U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 2, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool PausePromptWithExtensionErrorCode_IsValid (PausePromptWithExtensionErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case PausePromptWithExtensionErrorCode__TooMuchInputData:
    case PausePromptWithExtensionErrorCode__MemoryCorrupt:
        return true;
    default:
        return false;
    }
}

bool ContinuePromptWithExtensionErrorCode_Parse (const char *str, size_t length, ContinuePromptWithExtensionErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {13,"MEMORYCORRUPT", 24587U},
        {16,"TOOMUCHINPUTDATA", 257U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* ContinuePromptWithExtensionErrorCode_Name (ContinuePromptWithExtensionErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "TooMuchInputData",
        "MemoryCorrupt",
    };

    static unsigned int enumerationValues[] = {
        257U,
        24587U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 2, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool ContinuePromptWithExtensionErrorCode_IsValid (ContinuePromptWithExtensionErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case ContinuePromptWithExtensionErrorCode__TooMuchInputData:
    case ContinuePromptWithExtensionErrorCode__MemoryCorrupt:
        return true;
    default:
        return false;
    }
}

bool RequestPhonemeErrorCode_Parse (const char *str, size_t length, RequestPhonemeErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {17,"DICTIONARYCORRUPT", 24577U},
        {19,"LANGUAGENOTONMEMORY", 24584U},
        {19,"PHONEMENOTAVAILABLE", 24600U},
        {20,"LANGUAGENOTAVAILABLE", 24583U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* RequestPhonemeErrorCode_Name (RequestPhonemeErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "DictionaryCorrupt",
        "LanguageNotAvailable",
        "LanguageNotOnMemory",
        "PhonemeNotAvailable",
    };

    static unsigned int enumerationValues[] = {
        24577U,
        24583U,
        24584U,
        24600U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool RequestPhonemeErrorCode_IsValid (RequestPhonemeErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case RequestPhonemeErrorCode__DictionaryCorrupt:
    case RequestPhonemeErrorCode__LanguageNotAvailable:
    case RequestPhonemeErrorCode__LanguageNotOnMemory:
    case RequestPhonemeErrorCode__PhonemeNotAvailable:
        return true;
    default:
        return false;
    }
}

bool LoadTuningFilesErrorCode_Parse (const char *str, size_t length, LoadTuningFilesErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {18,"DOMAINNOTAVAILABLE", 24602U},
        {24,"TUNINGFILESNOTCOMPATIBLE", 24601U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* LoadTuningFilesErrorCode_Name (LoadTuningFilesErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "TuningFilesNotCompatible",
        "DomainNotAvailable",
    };

    static unsigned int enumerationValues[] = {
        24601U,
        24602U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 2, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool LoadTuningFilesErrorCode_IsValid (LoadTuningFilesErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case LoadTuningFilesErrorCode__TuningFilesNotCompatible:
    case LoadTuningFilesErrorCode__DomainNotAvailable:
        return true;
    default:
        return false;
    }
}

bool DoPrepareAudioOutputErrorCode_Parse (const char *str, size_t length, DoPrepareAudioOutputErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {15,"AUDIODEVICEBUSY", 24592U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* DoPrepareAudioOutputErrorCode_Name (DoPrepareAudioOutputErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "AudioDeviceBusy",
    };

    static unsigned int enumerationValues[] = {
        24592U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 1, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool DoPrepareAudioOutputErrorCode_IsValid (DoPrepareAudioOutputErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case DoPrepareAudioOutputErrorCode__AudioDeviceBusy:
        return true;
    default:
        return false;
    }
}

bool DoReleaseDataErrorCode_Parse (const char *str, size_t length, DoReleaseDataErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {14,"TTSNOTRELEASED", 24591U},
        {21,"CURRENTLYSYNTHESIZING", 24596U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* DoReleaseDataErrorCode_Name (DoReleaseDataErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "TTSNotReleased",
        "CurrentlySynthesizing",
    };

    static unsigned int enumerationValues[] = {
        24591U,
        24596U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 2, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool DoReleaseDataErrorCode_IsValid (DoReleaseDataErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case DoReleaseDataErrorCode__TTSNotReleased:
    case DoReleaseDataErrorCode__CurrentlySynthesizing:
        return true;
    default:
        return false;
    }
}

bool DoRequestPhonemeErrorCode_Parse (const char *str, size_t length, DoRequestPhonemeErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {17,"DICTIONARYCORRUPT", 24577U},
        {19,"LANGUAGENOTONMEMORY", 24584U},
        {19,"PHONEMENOTAVAILABLE", 24600U},
        {20,"LANGUAGENOTAVAILABLE", 24583U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* DoRequestPhonemeErrorCode_Name (DoRequestPhonemeErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "DictionaryCorrupt",
        "LanguageNotAvailable",
        "LanguageNotOnMemory",
        "PhonemeNotAvailable",
    };

    static unsigned int enumerationValues[] = {
        24577U,
        24583U,
        24584U,
        24600U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool DoRequestPhonemeErrorCode_IsValid (DoRequestPhonemeErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case DoRequestPhonemeErrorCode__DictionaryCorrupt:
    case DoRequestPhonemeErrorCode__LanguageNotAvailable:
    case DoRequestPhonemeErrorCode__LanguageNotOnMemory:
    case DoRequestPhonemeErrorCode__PhonemeNotAvailable:
        return true;
    default:
        return false;
    }
}

bool DownloadCompleteErrorCode_Parse (const char *str, size_t length, DownloadCompleteErrorCode &value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_Parse (str, length, (::asf::cca::CcaTypes::CcaErrorCode&) value)) return true;

    static stringEntry entries[] = {
        {23,"INFORMATIONNOTAVAILABLE", 24595U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* DownloadCompleteErrorCode_Name (DownloadCompleteErrorCode value)
{
    const char* name;
    name = ::asf::cca::CcaTypes::CcaErrorCode_Name ((::asf::cca::CcaTypes::CcaErrorCode) value);
    if (name != NULL) return name;

    static const char* enumerationLiterals[] = {
        "InformationNotAvailable",
    };

    static unsigned int enumerationValues[] = {
        24595U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 1, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool DownloadCompleteErrorCode_IsValid (DownloadCompleteErrorCode value)
{
    if (::asf::cca::CcaTypes::CcaErrorCode_IsValid ((::asf::cca::CcaTypes::CcaErrorCode) value)) return true;
    switch (value) {
    case DownloadCompleteErrorCode__InformationNotAvailable:
        return true;
    default:
        return false;
    }
}

} // namespace SDS_TTS_FI
