#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef AUX_MAIN_FI_TYPES_H
#define AUX_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "aux_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types aux_main_fi_types
 */

namespace aux_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_AUX_State;

class T_AUX_States;


/**
 * status of all configured auxilary inputs
 */
class T_AUX_State {
public:

    /**
     * Default constructor
     */
    inline  T_AUX_State ();

    /**
     * Copy constructor
     */
    inline  T_AUX_State (const T_AUX_State &rhs);

    /**
     * All fields constructor
     */
    inline  T_AUX_State (uint8 u8AuxNumber_, T_e8_AUXAvailabilityState eAuxAvailState_, T_e8_AUXSwitchState eAuxSwitchState_, T_e8_AUXConnectionState eAuxConState_);

    /**
     * Destructor
     */
    inline  ~T_AUX_State();

    /**
     * Assignment operator
     */
    inline T_AUX_State& operator = (const T_AUX_State& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AUX_State& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AUX_State& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AUX_State& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AUX_State& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8AuxNumber"

    static const int kU8AuxNumber = 0;

    /**
     * Clears the field "u8AuxNumber".
     *
     * The field will be set to its default value. The hasU8AuxNumber()
     * method will return false.
     */
    inline void clearU8AuxNumber();

    /**
     * Checks whether the field "u8AuxNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AuxNumber()). Otherwise it will return false.
     */
    inline bool hasU8AuxNumber () const;

    /**
     * Returns the value of the member "u8AuxNumber".
     *
     * number of auxilary input
     *
     * @return The value of the field "u8AuxNumber"
     */
    inline uint8 getU8AuxNumber () const;

    /**
     * Sets the value of the member "u8AuxNumber".
     *
     * number of auxilary input
     *
     * @param u8AuxNumber The value which will be set
     */
    inline void setU8AuxNumber (uint8 u8AuxNumber_);

    // API of field "eAuxAvailState"

    static const int kEAuxAvailState = 1;

    /**
     * Clears the field "eAuxAvailState".
     *
     * The field will be set to its default value. The hasEAuxAvailState()
     * method will return false.
     */
    inline void clearEAuxAvailState();

    /**
     * Checks whether the field "eAuxAvailState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEAuxAvailState()). Otherwise it will return false.
     */
    inline bool hasEAuxAvailState () const;

    /**
     * Returns the value of the member "eAuxAvailState".
     *
     * availibility of auxilary input
     *
     * @return The value of the field "eAuxAvailState"
     */
    inline T_e8_AUXAvailabilityState getEAuxAvailState () const;

    /**
     * Sets the value of the member "eAuxAvailState".
     *
     * availibility of auxilary input
     *
     * @param eAuxAvailState The value which will be set
     */
    inline void setEAuxAvailState (T_e8_AUXAvailabilityState eAuxAvailState_);

    // API of field "eAuxSwitchState"

    static const int kEAuxSwitchState = 2;

    /**
     * Clears the field "eAuxSwitchState".
     *
     * The field will be set to its default value. The hasEAuxSwitchState()
     * method will return false.
     */
    inline void clearEAuxSwitchState();

    /**
     * Checks whether the field "eAuxSwitchState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEAuxSwitchState()). Otherwise it will return false.
     */
    inline bool hasEAuxSwitchState () const;

    /**
     * Returns the value of the member "eAuxSwitchState".
     *
     * status of auxilary input detection switch
     *
     * @return The value of the field "eAuxSwitchState"
     */
    inline T_e8_AUXSwitchState getEAuxSwitchState () const;

    /**
     * Sets the value of the member "eAuxSwitchState".
     *
     * status of auxilary input detection switch
     *
     * @param eAuxSwitchState The value which will be set
     */
    inline void setEAuxSwitchState (T_e8_AUXSwitchState eAuxSwitchState_);

    // API of field "eAuxConState"

    static const int kEAuxConState = 3;

    /**
     * Clears the field "eAuxConState".
     *
     * The field will be set to its default value. The hasEAuxConState()
     * method will return false.
     */
    inline void clearEAuxConState();

    /**
     * Checks whether the field "eAuxConState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEAuxConState()). Otherwise it will return false.
     */
    inline bool hasEAuxConState () const;

    /**
     * Returns the value of the member "eAuxConState".
     *
     * status of auxilary input
     *
     * @return The value of the field "eAuxConState"
     */
    inline T_e8_AUXConnectionState getEAuxConState () const;

    /**
     * Sets the value of the member "eAuxConState".
     *
     * status of auxilary input
     *
     * @param eAuxConState The value which will be set
     */
    inline void setEAuxConState (T_e8_AUXConnectionState eAuxConState_);

    static const T_AUX_State &getDefaultInstance();

private:

    inline void set_has_u8AuxNumber ();

    inline void clear_has_u8AuxNumber ();

    inline void set_has_eAuxAvailState ();

    inline void clear_has_eAuxAvailState ();

    inline void set_has_eAuxSwitchState ();

    inline void clear_has_eAuxSwitchState ();

    inline void set_has_eAuxConState ();

    inline void clear_has_eAuxConState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8AuxNumber;

    T_e8_AUXAvailabilityState _eAuxAvailState;

    T_e8_AUXSwitchState _eAuxSwitchState;

    T_e8_AUXConnectionState _eAuxConState;

};

/**
 * All information necessary to retrieve and play a given media object, including all meta-data for that object
 */
class T_AUX_States {
public:

    /**
     * Default constructor
     */
    inline  T_AUX_States ();

    /**
     * Copy constructor
     */
    inline  T_AUX_States (const T_AUX_States &rhs);

    /**
     * All fields constructor
     */
    inline  T_AUX_States (uint8 u8Count_, const ::std::vector< T_AUX_State >& oItems_);

    /**
     * Destructor
     */
    inline  ~T_AUX_States();

    /**
     * Assignment operator
     */
    inline T_AUX_States& operator = (const T_AUX_States& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AUX_States& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AUX_States& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AUX_States& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AUX_States& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Count"

    static const int kU8Count = 0;

    /**
     * Clears the field "u8Count".
     *
     * The field will be set to its default value. The hasU8Count()
     * method will return false.
     */
    inline void clearU8Count();

    /**
     * Checks whether the field "u8Count" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Count()). Otherwise it will return false.
     */
    inline bool hasU8Count () const;

    /**
     * Returns the value of the member "u8Count".
     *
     * number of auxilary input
     *
     * @return The value of the field "u8Count"
     */
    inline uint8 getU8Count () const;

    /**
     * Sets the value of the member "u8Count".
     *
     * number of auxilary input
     *
     * @param u8Count The value which will be set
     */
    inline void setU8Count (uint8 u8Count_);

    // API of field "oItems"

    static const int kOItems = 1;

    /**
     * Clears the field "oItems".
     *
     * The field will be set to its default value. The hasOItems()
     * method will return false.
     */
    inline void clearOItems();

    /**
     * Checks whether the field "oItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOItems()). Otherwise it will return false.
     */
    inline bool hasOItems () const;

    /**
     * Returns the value of the member "oItems".
     *
     * If the meaning of "oItems" isn't clear, then there should be a description here.
     *
     * @return The value of the field "oItems"
     */
    inline const ::std::vector< T_AUX_State >& getOItems () const;

    /**
     * Retrieves the value of the field "oItems" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oItems".
     */
    inline ::std::vector< T_AUX_State >& getOItemsMutable ();

    /**
     * Sets the value of the member "oItems".
     *
     * If the meaning of "oItems" isn't clear, then there should be a description here.
     *
     * @param oItems The value which will be set
     */
    inline void setOItems (const ::std::vector< T_AUX_State >& oItems_);

    static const T_AUX_States &getDefaultInstance();

private:

    static const ::std::vector< T_AUX_State >& getT_AUX_StateList_DefaultInstance ();

    inline void set_has_u8Count ();

    inline void clear_has_u8Count ();

    inline void set_has_oItems ();

    inline void clear_has_oItems ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Count;

    ::std::vector< T_AUX_State > _oItems;

};

inline  T_AUX_State::T_AUX_State ()  :
    _u8AuxNumber (0u),
    _eAuxAvailState (::aux_main_fi_types::T_e8_AUXAvailabilityState__AUX_AVAIL),
    _eAuxSwitchState (::aux_main_fi_types::T_e8_AUXSwitchState__AUX_UNKNOWN),
    _eAuxConState (::aux_main_fi_types::T_e8_AUXConnectionState__AUX_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AUX_State::T_AUX_State (const T_AUX_State &rhs)  :
    _u8AuxNumber (0u),
    _eAuxAvailState (::aux_main_fi_types::T_e8_AUXAvailabilityState__AUX_AVAIL),
    _eAuxSwitchState (::aux_main_fi_types::T_e8_AUXSwitchState__AUX_UNKNOWN),
    _eAuxConState (::aux_main_fi_types::T_e8_AUXConnectionState__AUX_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AUX_State::T_AUX_State (uint8 u8AuxNumber_, T_e8_AUXAvailabilityState eAuxAvailState_, T_e8_AUXSwitchState eAuxSwitchState_, T_e8_AUXConnectionState eAuxConState_)  :
    _u8AuxNumber (u8AuxNumber_),
    _eAuxAvailState (eAuxAvailState_),
    _eAuxSwitchState (eAuxSwitchState_),
    _eAuxConState (eAuxConState_)
{
    #ifndef NDEBUG
    if (!(T_e8_AUXAvailabilityState_IsValid(eAuxAvailState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eAuxAvailState_, "T_e8_AUXAvailabilityState", "eAuxAvailState", "T_AUX_State");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AUXSwitchState_IsValid(eAuxSwitchState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eAuxSwitchState_, "T_e8_AUXSwitchState", "eAuxSwitchState", "T_AUX_State");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AUXConnectionState_IsValid(eAuxConState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eAuxConState_, "T_e8_AUXConnectionState", "eAuxConState", "T_AUX_State");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AUX_State::~T_AUX_State() {
}

inline T_AUX_State& T_AUX_State::operator = (const T_AUX_State& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8AuxNumber()) {
            setU8AuxNumber(rhs.getU8AuxNumber());
        } else {
            clearU8AuxNumber();
        }
        if (rhs.hasEAuxAvailState()) {
            setEAuxAvailState(rhs.getEAuxAvailState());
        } else {
            clearEAuxAvailState();
        }
        if (rhs.hasEAuxSwitchState()) {
            setEAuxSwitchState(rhs.getEAuxSwitchState());
        } else {
            clearEAuxSwitchState();
        }
        if (rhs.hasEAuxConState()) {
            setEAuxConState(rhs.getEAuxConState());
        } else {
            clearEAuxConState();
        }
    }
    return *this;
}

inline bool T_AUX_State::operator == (const T_AUX_State& rhs) const {
    return (((!hasU8AuxNumber() && !rhs.hasU8AuxNumber()) || getU8AuxNumber() == rhs.getU8AuxNumber()) &&
        ((!hasEAuxAvailState() && !rhs.hasEAuxAvailState()) || getEAuxAvailState() == rhs.getEAuxAvailState()) &&
        ((!hasEAuxSwitchState() && !rhs.hasEAuxSwitchState()) || getEAuxSwitchState() == rhs.getEAuxSwitchState()) &&
        ((!hasEAuxConState() && !rhs.hasEAuxConState()) || getEAuxConState() == rhs.getEAuxConState()));
}

inline bool T_AUX_State::operator != (const T_AUX_State& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AUX_State::operator < (const T_AUX_State& rhs) const {
    if (hasU8AuxNumber() || rhs.hasU8AuxNumber()) {
        if (getU8AuxNumber() < rhs.getU8AuxNumber()) return true;
        if (getU8AuxNumber() > rhs.getU8AuxNumber()) return false;
    }
    if (hasEAuxAvailState() || rhs.hasEAuxAvailState()) {
        if ((uint32)getEAuxAvailState() < (uint32)rhs.getEAuxAvailState()) return true;
        if ((uint32)getEAuxAvailState() > (uint32)rhs.getEAuxAvailState()) return false;
    }
    if (hasEAuxSwitchState() || rhs.hasEAuxSwitchState()) {
        if ((uint32)getEAuxSwitchState() < (uint32)rhs.getEAuxSwitchState()) return true;
        if ((uint32)getEAuxSwitchState() > (uint32)rhs.getEAuxSwitchState()) return false;
    }
    if (hasEAuxConState() || rhs.hasEAuxConState()) {
        if ((uint32)getEAuxConState() < (uint32)rhs.getEAuxConState()) return true;
        if ((uint32)getEAuxConState() > (uint32)rhs.getEAuxConState()) return false;
    }
    return false;
}

inline bool T_AUX_State::operator > (const T_AUX_State& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AUX_State::clear() {
    clearU8AuxNumber();
    clearEAuxAvailState();
    clearEAuxSwitchState();
    clearEAuxConState();
}

inline void T_AUX_State::clearU8AuxNumber() {
    if (hasU8AuxNumber()) {
         clear_has_u8AuxNumber();
        _u8AuxNumber = 0u;
     }
}

inline bool T_AUX_State::hasU8AuxNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_AUX_State::getU8AuxNumber () const {
    return _u8AuxNumber;
}

inline void T_AUX_State::setU8AuxNumber (uint8 u8AuxNumber_) {
    set_has_u8AuxNumber();
    this->_u8AuxNumber = u8AuxNumber_;
}

inline void T_AUX_State::clearEAuxAvailState() {
    if (hasEAuxAvailState()) {
         clear_has_eAuxAvailState();
        _eAuxAvailState = ::aux_main_fi_types::T_e8_AUXAvailabilityState__AUX_AVAIL;
     }
}

inline bool T_AUX_State::hasEAuxAvailState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AUXAvailabilityState T_AUX_State::getEAuxAvailState () const {
    return _eAuxAvailState;
}

inline void T_AUX_State::setEAuxAvailState (T_e8_AUXAvailabilityState eAuxAvailState_) {
    #ifndef NDEBUG
    if (!(T_e8_AUXAvailabilityState_IsValid(eAuxAvailState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eAuxAvailState_, "T_e8_AUXAvailabilityState", "eAuxAvailState", "T_AUX_State");
    }
    #endif
    set_has_eAuxAvailState();
    this->_eAuxAvailState = eAuxAvailState_;
}

inline void T_AUX_State::clearEAuxSwitchState() {
    if (hasEAuxSwitchState()) {
         clear_has_eAuxSwitchState();
        _eAuxSwitchState = ::aux_main_fi_types::T_e8_AUXSwitchState__AUX_UNKNOWN;
     }
}

inline bool T_AUX_State::hasEAuxSwitchState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_AUXSwitchState T_AUX_State::getEAuxSwitchState () const {
    return _eAuxSwitchState;
}

inline void T_AUX_State::setEAuxSwitchState (T_e8_AUXSwitchState eAuxSwitchState_) {
    #ifndef NDEBUG
    if (!(T_e8_AUXSwitchState_IsValid(eAuxSwitchState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eAuxSwitchState_, "T_e8_AUXSwitchState", "eAuxSwitchState", "T_AUX_State");
    }
    #endif
    set_has_eAuxSwitchState();
    this->_eAuxSwitchState = eAuxSwitchState_;
}

inline void T_AUX_State::clearEAuxConState() {
    if (hasEAuxConState()) {
         clear_has_eAuxConState();
        _eAuxConState = ::aux_main_fi_types::T_e8_AUXConnectionState__AUX_UNKNOWN;
     }
}

inline bool T_AUX_State::hasEAuxConState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_AUXConnectionState T_AUX_State::getEAuxConState () const {
    return _eAuxConState;
}

inline void T_AUX_State::setEAuxConState (T_e8_AUXConnectionState eAuxConState_) {
    #ifndef NDEBUG
    if (!(T_e8_AUXConnectionState_IsValid(eAuxConState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eAuxConState_, "T_e8_AUXConnectionState", "eAuxConState", "T_AUX_State");
    }
    #endif
    set_has_eAuxConState();
    this->_eAuxConState = eAuxConState_;
}

inline void T_AUX_State::set_has_u8AuxNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AUX_State::clear_has_u8AuxNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AUX_State::set_has_eAuxAvailState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AUX_State::clear_has_eAuxAvailState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AUX_State::set_has_eAuxSwitchState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AUX_State::clear_has_eAuxSwitchState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AUX_State::set_has_eAuxConState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AUX_State::clear_has_eAuxConState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_AUX_States::T_AUX_States ()  :
    _u8Count (0u),
    _oItems ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AUX_States::T_AUX_States (const T_AUX_States &rhs)  :
    _u8Count (0u),
    _oItems ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AUX_States::T_AUX_States (uint8 u8Count_, const ::std::vector< T_AUX_State >& oItems_)  :
    _u8Count (u8Count_),
    _oItems (oItems_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AUX_States::~T_AUX_States() {
}

inline T_AUX_States& T_AUX_States::operator = (const T_AUX_States& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Count()) {
            setU8Count(rhs.getU8Count());
        } else {
            clearU8Count();
        }
        if (rhs.hasOItems()) {
            setOItems(rhs.getOItems());
        } else {
            clearOItems();
        }
    }
    return *this;
}

inline bool T_AUX_States::operator == (const T_AUX_States& rhs) const {
    return (((!hasU8Count() && !rhs.hasU8Count()) || getU8Count() == rhs.getU8Count()) &&
        ((!hasOItems() && !rhs.hasOItems()) || getOItems() == rhs.getOItems()));
}

inline bool T_AUX_States::operator != (const T_AUX_States& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AUX_States::operator < (const T_AUX_States& rhs) const {
    if (hasU8Count() || rhs.hasU8Count()) {
        if (getU8Count() < rhs.getU8Count()) return true;
        if (getU8Count() > rhs.getU8Count()) return false;
    }
    if (hasOItems() || rhs.hasOItems()) {
        if (getOItems() < rhs.getOItems()) return true;
        if (getOItems() > rhs.getOItems()) return false;
    }
    return false;
}

inline bool T_AUX_States::operator > (const T_AUX_States& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AUX_States::clear() {
    clearU8Count();
    clearOItems();
}

inline void T_AUX_States::clearU8Count() {
    if (hasU8Count()) {
         clear_has_u8Count();
        _u8Count = 0u;
     }
}

inline bool T_AUX_States::hasU8Count () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_AUX_States::getU8Count () const {
    return _u8Count;
}

inline void T_AUX_States::setU8Count (uint8 u8Count_) {
    set_has_u8Count();
    this->_u8Count = u8Count_;
}

inline void T_AUX_States::clearOItems() {
    if (hasOItems()) {
         clear_has_oItems();
        _oItems.clear();
     }
}

inline bool T_AUX_States::hasOItems () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_AUX_State >& T_AUX_States::getOItems () const {
    return _oItems;
}

inline ::std::vector< T_AUX_State >& T_AUX_States::getOItemsMutable () {
    set_has_oItems();
    return _oItems;
}

inline void T_AUX_States::setOItems (const ::std::vector< T_AUX_State >& oItems_) {
    set_has_oItems();
    this->_oItems = oItems_;
}

inline void T_AUX_States::set_has_u8Count () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AUX_States::clear_has_u8Count () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AUX_States::set_has_oItems () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AUX_States::clear_has_oItems () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace aux_main_fi_types

#endif // AUX_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
