/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Manager.h"
#include "org/bosch/wapdman/ManagerDBus.h"
#include "org/bosch/wapdman/ManagerJson.h"
#include "org/bosch/wapdman/ManagerProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace Manager {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/Manager/org/bosch/wapdman/Manager", ManagerProxy);

class ManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ManagerProxy >& proxyShared = ::boost::static_pointer_cast< ManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_AccessPointAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AccessPointAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AccessPointAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AccessPointAddedSignal> payload = ::boost::static_pointer_cast<AccessPointAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AccessPointAddedCallbackIF*) _callback)->onAccessPointAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AccessPointRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AccessPointRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AccessPointRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AccessPointRemovedSignal> payload = ::boost::static_pointer_cast<AccessPointRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AccessPointRemovedCallbackIF*) _callback)->onAccessPointRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FindAccessPoint:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), FindAccessPointError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FindAccessPoint", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FindAccessPointError> payload = ::boost::static_pointer_cast<FindAccessPointError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FindAccessPointCallbackIF*) _callback)->onFindAccessPointError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FindAccessPointResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "FindAccessPoint", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FindAccessPointResponse> payload = ::boost::static_pointer_cast<FindAccessPointResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FindAccessPointCallbackIF*) _callback)->onFindAccessPointResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RegisterAgent:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterAgentError> payload = ::boost::static_pointer_cast<RegisterAgentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterAgentResponse> payload = ::boost::static_pointer_cast<RegisterAgentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnregisterAgent:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterAgentError> payload = ::boost::static_pointer_cast<UnregisterAgentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterAgentResponse> payload = ::boost::static_pointer_cast<UnregisterAgentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetAccessPoints:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetAccessPointsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAccessPoints", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAccessPointsError> payload = ::boost::static_pointer_cast<GetAccessPointsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAccessPointsCallbackIF*) _callback)->onGetAccessPointsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAccessPointsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAccessPoints", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAccessPointsResponse> payload = ::boost::static_pointer_cast<GetAccessPointsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAccessPointsCallbackIF*) _callback)->onGetAccessPointsResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_AccessPointAdded: {
                ::boost::shared_ptr< AccessPointAddedError > payload = ::boost::shared_ptr< AccessPointAddedError >
                (new AccessPointAddedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AccessPointAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AccessPointAddedCallbackIF*) _callback)->onAccessPointAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AccessPointRemoved: {
                ::boost::shared_ptr< AccessPointRemovedError > payload = ::boost::shared_ptr< AccessPointRemovedError >
                (new AccessPointRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AccessPointRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AccessPointRemovedCallbackIF*) _callback)->onAccessPointRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FindAccessPoint: {
                ::boost::shared_ptr< FindAccessPointError > payload = ::boost::shared_ptr< FindAccessPointError >
                (new FindAccessPointError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FindAccessPoint", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FindAccessPointCallbackIF*) _callback)->onFindAccessPointError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RegisterAgent: {
                ::boost::shared_ptr< RegisterAgentError > payload = ::boost::shared_ptr< RegisterAgentError >
                (new RegisterAgentError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnregisterAgent: {
                ::boost::shared_ptr< UnregisterAgentError > payload = ::boost::shared_ptr< UnregisterAgentError >
                (new UnregisterAgentError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetAccessPoints: {
                ::boost::shared_ptr< GetAccessPointsError > payload = ::boost::shared_ptr< GetAccessPointsError >
                (new GetAccessPointsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetAccessPoints", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetAccessPointsCallbackIF*) _callback)->onGetAccessPointsError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ManagerProxyCallback::_logger (ManagerProxy::_logger);

ManagerProxy::ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.wapdman.Manager", serviceAvailable, _logger) {
}

ManagerProxy::~ManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ManagerProxy > ManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t ManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ManagerProxyCallback* callback = new ManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ManagerProxyCallback* callback = new ManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void ManagerProxy::sendDeregisterAll () const
{
    sendAccessPointAddedDeregisterAll();
    sendAccessPointRemovedDeregisterAll();
}

act_t ManagerProxy::sendAccessPointAddedRegister(AccessPointAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AccessPointAdded");
    act_t act = addSignalCallback(ID_AccessPointAdded, "AccessPointAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AccessPointAdded", &cb, act);
    return act;
}

bool ManagerProxy::sendAccessPointAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AccessPointAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AccessPointAdded", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendAccessPointAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AccessPointAdded");
    _dbusProxyDelegate->deregisterSignalCallback("AccessPointAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendAccessPointRemovedRegister(AccessPointRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AccessPointRemoved");
    act_t act = addSignalCallback(ID_AccessPointRemoved, "AccessPointRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AccessPointRemoved", &cb, act);
    return act;
}

bool ManagerProxy::sendAccessPointRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AccessPointRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AccessPointRemoved", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendAccessPointRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AccessPointRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("AccessPointRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendFindAccessPointRequest(FindAccessPointCallbackIF& cb, const ::std::string& pattern) const {
    FindAccessPointRequest* payload = new FindAccessPointRequest();
    CHECK_ALLOCATION(payload);
    payload->setPattern(pattern);
    DBUS_MESSAGE_CALL(dbusMessage, "FindAccessPoint", FindAccessPointRequest, payload, true)
    act_t act = addMethodCallback(ID_FindAccessPoint, dbusMessage.getUniqueSerial(), "FindAccessPoint", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "FindAccessPoint", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendRegisterAgentRequest(RegisterAgentCallbackIF& cb, const ::std::string& path) const {
    RegisterAgentRequest* payload = new RegisterAgentRequest();
    CHECK_ALLOCATION(payload);
    payload->setPath(path);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterAgent", RegisterAgentRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterAgent, dbusMessage.getUniqueSerial(), "RegisterAgent", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterAgent", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendUnregisterAgentRequest(UnregisterAgentCallbackIF& cb, const ::std::string& path) const {
    UnregisterAgentRequest* payload = new UnregisterAgentRequest();
    CHECK_ALLOCATION(payload);
    payload->setPath(path);
    DBUS_MESSAGE_CALL(dbusMessage, "UnregisterAgent", UnregisterAgentRequest, payload, true)
    act_t act = addMethodCallback(ID_UnregisterAgent, dbusMessage.getUniqueSerial(), "UnregisterAgent", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnregisterAgent", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendGetAccessPointsRequest(GetAccessPointsCallbackIF& cb) const {
    GetAccessPointsRequest* payload = new GetAccessPointsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetAccessPoints", GetAccessPointsRequest, payload, true)
    act_t act = addMethodCallback(ID_GetAccessPoints, dbusMessage.getUniqueSerial(), "GetAccessPoints", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetAccessPoints", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Manager
} // namespace wapdman
} // namespace bosch
} // namespace org
