#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WAPDMAN_MANAGER_H
#define ORG_BOSCH_WAPDMAN_MANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "Manager" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace wapdman {
namespace Manager {

// method IDs
static const uint16 ID_FindAccessPoint = 0;
static const uint16 ID_RegisterAgent = 1;
static const uint16 ID_UnregisterAgent = 2;
static const uint16 ID_GetAccessPoints = 3;

// signal IDs
static const uint16 ID_AccessPointAdded = 4;
static const uint16 ID_AccessPointRemoved = 5;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class FindAccessPointRequest;

class FindAccessPointResponse;

class RegisterAgentRequest;

class UnregisterAgentRequest;

class GetAccessPointsResponseAccesspointsStruct;

class GetAccessPointsResponse;

class AccessPointAddedSignal;

class AccessPointRemovedSignal;

// type definitions
/**
 * If the meaning of "FindAccessPointError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FindAccessPointError;

/**
 * If the meaning of "RegisterAgentResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RegisterAgentResponse;

/**
 * If the meaning of "RegisterAgentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterAgentError;

/**
 * If the meaning of "UnregisterAgentResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnregisterAgentResponse;

/**
 * If the meaning of "UnregisterAgentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnregisterAgentError;

/**
 * If the meaning of "GetAccessPointsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetAccessPointsRequest;

/**
 * If the meaning of "GetAccessPointsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetAccessPointsError;

/**
 * If the meaning of "AccessPointAddedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AccessPointAddedError;

/**
 * If the meaning of "AccessPointRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AccessPointRemovedError;


/**
 * If the meaning of "FindAccessPointRequest" isn't clear, then there should be a description here.
 */
class FindAccessPointRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FindAccessPointRequest ();

    /**
     * Copy constructor
     */
    inline  FindAccessPointRequest (const FindAccessPointRequest &rhs);

    /**
     * All fields constructor
     */
    inline  FindAccessPointRequest (const ::std::string& pattern_);

    /**
     * Destructor
     */
    inline virtual  ~FindAccessPointRequest();

    /**
     * Assignment operator
     */
    inline FindAccessPointRequest& operator = (const FindAccessPointRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FindAccessPointRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FindAccessPointRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FindAccessPointRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FindAccessPointRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pattern"

    static const int kPattern = 0;

    /**
     * Clears the field "pattern".
     *
     * The field will be set to its default value. The hasPattern()
     * method will return false.
     */
    inline void clearPattern();

    /**
     * Checks whether the field "pattern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPattern()). Otherwise it will return false.
     */
    inline bool hasPattern () const;

    /**
     * Returns the value of the member "pattern".
     *
     * If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pattern"
     */
    inline const ::std::string& getPattern () const;

    /**
     * Retrieves the value of the field "pattern" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "pattern".
     */
    inline ::std::string& getPatternMutable ();

    /**
     * Sets the value of the member "pattern".
     *
     * If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @param pattern The value which will be set
     */
    inline void setPattern (const ::std::string& pattern_);

    /**
     * Sets the value of the member "pattern".
     *
     * If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @param pattern The value which will be set
     */
    inline void setPattern (const char* pattern_);

    /**
     * Sets the value of the member "pattern".
     *
     * If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @param pattern The value which will be set
     */
    inline void setPattern (const char* value, size_t size);

    static const FindAccessPointRequest &getDefaultInstance();

private:

    inline void set_has_pattern ();

    inline void clear_has_pattern ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _pattern;

};

/**
 * If the meaning of "FindAccessPointResponse" isn't clear, then there should be a description here.
 */
class FindAccessPointResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FindAccessPointResponse ();

    /**
     * Copy constructor
     */
    inline  FindAccessPointResponse (const FindAccessPointResponse &rhs);

    /**
     * All fields constructor
     */
    inline  FindAccessPointResponse (const ::std::string& accesspoint_);

    /**
     * Destructor
     */
    inline virtual  ~FindAccessPointResponse();

    /**
     * Assignment operator
     */
    inline FindAccessPointResponse& operator = (const FindAccessPointResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FindAccessPointResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FindAccessPointResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FindAccessPointResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FindAccessPointResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "accesspoint"

    static const int kAccesspoint = 0;

    /**
     * Clears the field "accesspoint".
     *
     * The field will be set to its default value. The hasAccesspoint()
     * method will return false.
     */
    inline void clearAccesspoint();

    /**
     * Checks whether the field "accesspoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccesspoint()). Otherwise it will return false.
     */
    inline bool hasAccesspoint () const;

    /**
     * Returns the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @return The value of the field "accesspoint"
     */
    inline const ::std::string& getAccesspoint () const;

    /**
     * Retrieves the value of the field "accesspoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "accesspoint".
     */
    inline ::std::string& getAccesspointMutable ();

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const ::std::string& accesspoint_);

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const char* accesspoint_);

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const char* value, size_t size);

    static const FindAccessPointResponse &getDefaultInstance();

private:

    inline void set_has_accesspoint ();

    inline void clear_has_accesspoint ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _accesspoint;

};

/**
 * If the meaning of "RegisterAgentRequest" isn't clear, then there should be a description here.
 */
class RegisterAgentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterAgentRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterAgentRequest (const RegisterAgentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterAgentRequest (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterAgentRequest();

    /**
     * Assignment operator
     */
    inline RegisterAgentRequest& operator = (const RegisterAgentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterAgentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterAgentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterAgentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterAgentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const RegisterAgentRequest &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "UnregisterAgentRequest" isn't clear, then there should be a description here.
 */
class UnregisterAgentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnregisterAgentRequest ();

    /**
     * Copy constructor
     */
    inline  UnregisterAgentRequest (const UnregisterAgentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnregisterAgentRequest (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~UnregisterAgentRequest();

    /**
     * Assignment operator
     */
    inline UnregisterAgentRequest& operator = (const UnregisterAgentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnregisterAgentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnregisterAgentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnregisterAgentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnregisterAgentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const UnregisterAgentRequest &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "GetAccessPointsResponseAccesspointsStruct" isn't clear, then there should be a description here.
 */
class GetAccessPointsResponseAccesspointsStruct {
public:

    /**
     * Default constructor
     */
    inline  GetAccessPointsResponseAccesspointsStruct ();

    /**
     * Copy constructor
     */
    inline  GetAccessPointsResponseAccesspointsStruct (const GetAccessPointsResponseAccesspointsStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetAccessPointsResponseAccesspointsStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~GetAccessPointsResponseAccesspointsStruct();

    /**
     * Assignment operator
     */
    inline GetAccessPointsResponseAccesspointsStruct& operator = (const GetAccessPointsResponseAccesspointsStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAccessPointsResponseAccesspointsStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAccessPointsResponseAccesspointsStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAccessPointsResponseAccesspointsStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAccessPointsResponseAccesspointsStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const GetAccessPointsResponseAccesspointsStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "GetAccessPointsResponse" isn't clear, then there should be a description here.
 */
class GetAccessPointsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAccessPointsResponse ();

    /**
     * Copy constructor
     */
    inline  GetAccessPointsResponse (const GetAccessPointsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetAccessPointsResponse (const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& accesspoints_);

    /**
     * Destructor
     */
    inline virtual  ~GetAccessPointsResponse();

    /**
     * Assignment operator
     */
    inline GetAccessPointsResponse& operator = (const GetAccessPointsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAccessPointsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAccessPointsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAccessPointsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAccessPointsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "accesspoints"

    static const int kAccesspoints = 0;

    /**
     * Clears the field "accesspoints".
     *
     * The field will be set to its default value. The hasAccesspoints()
     * method will return false.
     */
    inline void clearAccesspoints();

    /**
     * Checks whether the field "accesspoints" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccesspoints()). Otherwise it will return false.
     */
    inline bool hasAccesspoints () const;

    /**
     * Returns the value of the member "accesspoints".
     *
     * If the meaning of "accesspoints" isn't clear, then there should be a description here.
     *
     * @return The value of the field "accesspoints"
     */
    inline const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& getAccesspoints () const;

    /**
     * Retrieves the value of the field "accesspoints" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "accesspoints".
     */
    inline ::std::vector< GetAccessPointsResponseAccesspointsStruct >& getAccesspointsMutable ();

    /**
     * Sets the value of the member "accesspoints".
     *
     * If the meaning of "accesspoints" isn't clear, then there should be a description here.
     *
     * @param accesspoints The value which will be set
     */
    inline void setAccesspoints (const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& accesspoints_);

    static const GetAccessPointsResponse &getDefaultInstance();

private:

    static const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& getGetAccessPointsResponseAccesspointsStructList_DefaultInstance ();

    inline void set_has_accesspoints ();

    inline void clear_has_accesspoints ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< GetAccessPointsResponseAccesspointsStruct > _accesspoints;

};

/**
 * If the meaning of "AccessPointAddedSignal" isn't clear, then there should be a description here.
 */
class AccessPointAddedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccessPointAddedSignal ();

    /**
     * Copy constructor
     */
    inline  AccessPointAddedSignal (const AccessPointAddedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AccessPointAddedSignal (const ::std::string& accesspoint_);

    /**
     * Destructor
     */
    inline virtual  ~AccessPointAddedSignal();

    /**
     * Assignment operator
     */
    inline AccessPointAddedSignal& operator = (const AccessPointAddedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccessPointAddedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccessPointAddedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccessPointAddedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccessPointAddedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "accesspoint"

    static const int kAccesspoint = 0;

    /**
     * Clears the field "accesspoint".
     *
     * The field will be set to its default value. The hasAccesspoint()
     * method will return false.
     */
    inline void clearAccesspoint();

    /**
     * Checks whether the field "accesspoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccesspoint()). Otherwise it will return false.
     */
    inline bool hasAccesspoint () const;

    /**
     * Returns the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @return The value of the field "accesspoint"
     */
    inline const ::std::string& getAccesspoint () const;

    /**
     * Retrieves the value of the field "accesspoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "accesspoint".
     */
    inline ::std::string& getAccesspointMutable ();

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const ::std::string& accesspoint_);

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const char* accesspoint_);

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const char* value, size_t size);

    static const AccessPointAddedSignal &getDefaultInstance();

private:

    inline void set_has_accesspoint ();

    inline void clear_has_accesspoint ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _accesspoint;

};

/**
 * If the meaning of "AccessPointRemovedSignal" isn't clear, then there should be a description here.
 */
class AccessPointRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccessPointRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  AccessPointRemovedSignal (const AccessPointRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AccessPointRemovedSignal (const ::std::string& accesspoint_);

    /**
     * Destructor
     */
    inline virtual  ~AccessPointRemovedSignal();

    /**
     * Assignment operator
     */
    inline AccessPointRemovedSignal& operator = (const AccessPointRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccessPointRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccessPointRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccessPointRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccessPointRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "accesspoint"

    static const int kAccesspoint = 0;

    /**
     * Clears the field "accesspoint".
     *
     * The field will be set to its default value. The hasAccesspoint()
     * method will return false.
     */
    inline void clearAccesspoint();

    /**
     * Checks whether the field "accesspoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccesspoint()). Otherwise it will return false.
     */
    inline bool hasAccesspoint () const;

    /**
     * Returns the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @return The value of the field "accesspoint"
     */
    inline const ::std::string& getAccesspoint () const;

    /**
     * Retrieves the value of the field "accesspoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "accesspoint".
     */
    inline ::std::string& getAccesspointMutable ();

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const ::std::string& accesspoint_);

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const char* accesspoint_);

    /**
     * Sets the value of the member "accesspoint".
     *
     * If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint The value which will be set
     */
    inline void setAccesspoint (const char* value, size_t size);

    static const AccessPointRemovedSignal &getDefaultInstance();

private:

    inline void set_has_accesspoint ();

    inline void clear_has_accesspoint ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _accesspoint;

};

inline  FindAccessPointRequest::FindAccessPointRequest ()  :
    _pattern ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FindAccessPointRequest::FindAccessPointRequest (const FindAccessPointRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pattern ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FindAccessPointRequest::FindAccessPointRequest (const ::std::string& pattern_)  :
    _pattern (pattern_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pattern_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FindAccessPointRequest::~FindAccessPointRequest() {
}

inline FindAccessPointRequest& FindAccessPointRequest::operator = (const FindAccessPointRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPattern()) {
            setPattern(rhs.getPattern());
        } else {
            clearPattern();
        }
    }
    return *this;
}

inline bool FindAccessPointRequest::operator == (const FindAccessPointRequest& rhs) const {
    return (((!hasPattern() && !rhs.hasPattern()) || getPattern() == rhs.getPattern()));
}

inline bool FindAccessPointRequest::operator != (const FindAccessPointRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool FindAccessPointRequest::operator < (const FindAccessPointRequest& rhs) const {
    if (hasPattern() || rhs.hasPattern()) {
        if (getPattern() < rhs.getPattern()) return true;
        if (getPattern() > rhs.getPattern()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FindAccessPointRequest::clone() {
    return new FindAccessPointRequest(*this);
}

inline bool FindAccessPointRequest::operator > (const FindAccessPointRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FindAccessPointRequest::clear() {
    clearPattern();
}

inline void FindAccessPointRequest::clearPattern() {
    if (hasPattern()) {
         clear_has_pattern();
        _pattern.clear();
     }
}

inline bool FindAccessPointRequest::hasPattern () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FindAccessPointRequest::getPattern () const {
    return _pattern;
}

inline ::std::string& FindAccessPointRequest::getPatternMutable () {
    set_has_pattern();
    return _pattern;
}

inline void FindAccessPointRequest::setPattern (const ::std::string& pattern_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pattern_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pattern();
    this->_pattern = pattern_;
}

inline void FindAccessPointRequest::setPattern (const char* pattern_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pattern_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pattern();
    this->_pattern.assign(pattern_);
}

inline void FindAccessPointRequest::setPattern (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pattern();
    this->_pattern.assign(value, size);
}

inline void FindAccessPointRequest::set_has_pattern () {
    _has_bits_[0] |= 1u << 0;
}

inline void FindAccessPointRequest::clear_has_pattern () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FindAccessPointResponse::FindAccessPointResponse ()  :
    _accesspoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FindAccessPointResponse::FindAccessPointResponse (const FindAccessPointResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _accesspoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FindAccessPointResponse::FindAccessPointResponse (const ::std::string& accesspoint_)  :
    _accesspoint (accesspoint_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FindAccessPointResponse::~FindAccessPointResponse() {
}

inline FindAccessPointResponse& FindAccessPointResponse::operator = (const FindAccessPointResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAccesspoint()) {
            setAccesspoint(rhs.getAccesspoint());
        } else {
            clearAccesspoint();
        }
    }
    return *this;
}

inline bool FindAccessPointResponse::operator == (const FindAccessPointResponse& rhs) const {
    return (((!hasAccesspoint() && !rhs.hasAccesspoint()) || getAccesspoint() == rhs.getAccesspoint()));
}

inline bool FindAccessPointResponse::operator != (const FindAccessPointResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool FindAccessPointResponse::operator < (const FindAccessPointResponse& rhs) const {
    if (hasAccesspoint() || rhs.hasAccesspoint()) {
        if (getAccesspoint() < rhs.getAccesspoint()) return true;
        if (getAccesspoint() > rhs.getAccesspoint()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FindAccessPointResponse::clone() {
    return new FindAccessPointResponse(*this);
}

inline bool FindAccessPointResponse::operator > (const FindAccessPointResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FindAccessPointResponse::clear() {
    clearAccesspoint();
}

inline void FindAccessPointResponse::clearAccesspoint() {
    if (hasAccesspoint()) {
         clear_has_accesspoint();
        _accesspoint.clear();
     }
}

inline bool FindAccessPointResponse::hasAccesspoint () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FindAccessPointResponse::getAccesspoint () const {
    return _accesspoint;
}

inline ::std::string& FindAccessPointResponse::getAccesspointMutable () {
    set_has_accesspoint();
    return _accesspoint;
}

inline void FindAccessPointResponse::setAccesspoint (const ::std::string& accesspoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint = accesspoint_;
}

inline void FindAccessPointResponse::setAccesspoint (const char* accesspoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint.assign(accesspoint_);
}

inline void FindAccessPointResponse::setAccesspoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint.assign(value, size);
}

inline void FindAccessPointResponse::set_has_accesspoint () {
    _has_bits_[0] |= 1u << 0;
}

inline void FindAccessPointResponse::clear_has_accesspoint () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RegisterAgentRequest::RegisterAgentRequest ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterAgentRequest::RegisterAgentRequest (const RegisterAgentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterAgentRequest::RegisterAgentRequest (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterAgentRequest::~RegisterAgentRequest() {
}

inline RegisterAgentRequest& RegisterAgentRequest::operator = (const RegisterAgentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool RegisterAgentRequest::operator == (const RegisterAgentRequest& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool RegisterAgentRequest::operator != (const RegisterAgentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterAgentRequest::operator < (const RegisterAgentRequest& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterAgentRequest::clone() {
    return new RegisterAgentRequest(*this);
}

inline bool RegisterAgentRequest::operator > (const RegisterAgentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterAgentRequest::clear() {
    clearPath();
}

inline void RegisterAgentRequest::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool RegisterAgentRequest::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterAgentRequest::getPath () const {
    return _path;
}

inline ::std::string& RegisterAgentRequest::getPathMutable () {
    set_has_path();
    return _path;
}

inline void RegisterAgentRequest::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void RegisterAgentRequest::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void RegisterAgentRequest::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void RegisterAgentRequest::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterAgentRequest::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnregisterAgentRequest::UnregisterAgentRequest ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnregisterAgentRequest::UnregisterAgentRequest (const UnregisterAgentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnregisterAgentRequest::UnregisterAgentRequest (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnregisterAgentRequest::~UnregisterAgentRequest() {
}

inline UnregisterAgentRequest& UnregisterAgentRequest::operator = (const UnregisterAgentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool UnregisterAgentRequest::operator == (const UnregisterAgentRequest& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool UnregisterAgentRequest::operator != (const UnregisterAgentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnregisterAgentRequest::operator < (const UnregisterAgentRequest& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnregisterAgentRequest::clone() {
    return new UnregisterAgentRequest(*this);
}

inline bool UnregisterAgentRequest::operator > (const UnregisterAgentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnregisterAgentRequest::clear() {
    clearPath();
}

inline void UnregisterAgentRequest::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool UnregisterAgentRequest::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnregisterAgentRequest::getPath () const {
    return _path;
}

inline ::std::string& UnregisterAgentRequest::getPathMutable () {
    set_has_path();
    return _path;
}

inline void UnregisterAgentRequest::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void UnregisterAgentRequest::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void UnregisterAgentRequest::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void UnregisterAgentRequest::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnregisterAgentRequest::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAccessPointsResponseAccesspointsStruct::GetAccessPointsResponseAccesspointsStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAccessPointsResponseAccesspointsStruct::GetAccessPointsResponseAccesspointsStruct (const GetAccessPointsResponseAccesspointsStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAccessPointsResponseAccesspointsStruct::GetAccessPointsResponseAccesspointsStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAccessPointsResponseAccesspointsStruct::~GetAccessPointsResponseAccesspointsStruct() {
}

inline GetAccessPointsResponseAccesspointsStruct& GetAccessPointsResponseAccesspointsStruct::operator = (const GetAccessPointsResponseAccesspointsStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetAccessPointsResponseAccesspointsStruct::operator == (const GetAccessPointsResponseAccesspointsStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetAccessPointsResponseAccesspointsStruct::operator != (const GetAccessPointsResponseAccesspointsStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAccessPointsResponseAccesspointsStruct::operator < (const GetAccessPointsResponseAccesspointsStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetAccessPointsResponseAccesspointsStruct::operator > (const GetAccessPointsResponseAccesspointsStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAccessPointsResponseAccesspointsStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetAccessPointsResponseAccesspointsStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool GetAccessPointsResponseAccesspointsStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetAccessPointsResponseAccesspointsStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& GetAccessPointsResponseAccesspointsStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void GetAccessPointsResponseAccesspointsStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetAccessPointsResponseAccesspointsStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void GetAccessPointsResponseAccesspointsStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void GetAccessPointsResponseAccesspointsStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetAccessPointsResponseAccesspointsStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetAccessPointsResponseAccesspointsStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetAccessPointsResponseAccesspointsStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetAccessPointsResponseAccesspointsStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetAccessPointsResponseAccesspointsStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAccessPointsResponseAccesspointsStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetAccessPointsResponseAccesspointsStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetAccessPointsResponseAccesspointsStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetAccessPointsResponse::GetAccessPointsResponse ()  :
    _accesspoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAccessPointsResponse::GetAccessPointsResponse (const GetAccessPointsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _accesspoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAccessPointsResponse::GetAccessPointsResponse (const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& accesspoints_)  :
    _accesspoints (accesspoints_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAccessPointsResponse::~GetAccessPointsResponse() {
}

inline GetAccessPointsResponse& GetAccessPointsResponse::operator = (const GetAccessPointsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAccesspoints()) {
            setAccesspoints(rhs.getAccesspoints());
        } else {
            clearAccesspoints();
        }
    }
    return *this;
}

inline bool GetAccessPointsResponse::operator == (const GetAccessPointsResponse& rhs) const {
    return (((!hasAccesspoints() && !rhs.hasAccesspoints()) || getAccesspoints() == rhs.getAccesspoints()));
}

inline bool GetAccessPointsResponse::operator != (const GetAccessPointsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAccessPointsResponse::operator < (const GetAccessPointsResponse& rhs) const {
    if (hasAccesspoints() || rhs.hasAccesspoints()) {
        if (getAccesspoints() < rhs.getAccesspoints()) return true;
        if (getAccesspoints() > rhs.getAccesspoints()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAccessPointsResponse::clone() {
    return new GetAccessPointsResponse(*this);
}

inline bool GetAccessPointsResponse::operator > (const GetAccessPointsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAccessPointsResponse::clear() {
    clearAccesspoints();
}

inline void GetAccessPointsResponse::clearAccesspoints() {
    if (hasAccesspoints()) {
         clear_has_accesspoints();
        _accesspoints.clear();
     }
}

inline bool GetAccessPointsResponse::hasAccesspoints () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& GetAccessPointsResponse::getAccesspoints () const {
    return _accesspoints;
}

inline ::std::vector< GetAccessPointsResponseAccesspointsStruct >& GetAccessPointsResponse::getAccesspointsMutable () {
    set_has_accesspoints();
    return _accesspoints;
}

inline void GetAccessPointsResponse::setAccesspoints (const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& accesspoints_) {
    set_has_accesspoints();
    this->_accesspoints = accesspoints_;
}

inline void GetAccessPointsResponse::set_has_accesspoints () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAccessPointsResponse::clear_has_accesspoints () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AccessPointAddedSignal::AccessPointAddedSignal ()  :
    _accesspoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AccessPointAddedSignal::AccessPointAddedSignal (const AccessPointAddedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _accesspoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AccessPointAddedSignal::AccessPointAddedSignal (const ::std::string& accesspoint_)  :
    _accesspoint (accesspoint_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AccessPointAddedSignal::~AccessPointAddedSignal() {
}

inline AccessPointAddedSignal& AccessPointAddedSignal::operator = (const AccessPointAddedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAccesspoint()) {
            setAccesspoint(rhs.getAccesspoint());
        } else {
            clearAccesspoint();
        }
    }
    return *this;
}

inline bool AccessPointAddedSignal::operator == (const AccessPointAddedSignal& rhs) const {
    return (((!hasAccesspoint() && !rhs.hasAccesspoint()) || getAccesspoint() == rhs.getAccesspoint()));
}

inline bool AccessPointAddedSignal::operator != (const AccessPointAddedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AccessPointAddedSignal::operator < (const AccessPointAddedSignal& rhs) const {
    if (hasAccesspoint() || rhs.hasAccesspoint()) {
        if (getAccesspoint() < rhs.getAccesspoint()) return true;
        if (getAccesspoint() > rhs.getAccesspoint()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AccessPointAddedSignal::clone() {
    return new AccessPointAddedSignal(*this);
}

inline bool AccessPointAddedSignal::operator > (const AccessPointAddedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AccessPointAddedSignal::clear() {
    clearAccesspoint();
}

inline void AccessPointAddedSignal::clearAccesspoint() {
    if (hasAccesspoint()) {
         clear_has_accesspoint();
        _accesspoint.clear();
     }
}

inline bool AccessPointAddedSignal::hasAccesspoint () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AccessPointAddedSignal::getAccesspoint () const {
    return _accesspoint;
}

inline ::std::string& AccessPointAddedSignal::getAccesspointMutable () {
    set_has_accesspoint();
    return _accesspoint;
}

inline void AccessPointAddedSignal::setAccesspoint (const ::std::string& accesspoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint = accesspoint_;
}

inline void AccessPointAddedSignal::setAccesspoint (const char* accesspoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint.assign(accesspoint_);
}

inline void AccessPointAddedSignal::setAccesspoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint.assign(value, size);
}

inline void AccessPointAddedSignal::set_has_accesspoint () {
    _has_bits_[0] |= 1u << 0;
}

inline void AccessPointAddedSignal::clear_has_accesspoint () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AccessPointRemovedSignal::AccessPointRemovedSignal ()  :
    _accesspoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AccessPointRemovedSignal::AccessPointRemovedSignal (const AccessPointRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _accesspoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AccessPointRemovedSignal::AccessPointRemovedSignal (const ::std::string& accesspoint_)  :
    _accesspoint (accesspoint_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AccessPointRemovedSignal::~AccessPointRemovedSignal() {
}

inline AccessPointRemovedSignal& AccessPointRemovedSignal::operator = (const AccessPointRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAccesspoint()) {
            setAccesspoint(rhs.getAccesspoint());
        } else {
            clearAccesspoint();
        }
    }
    return *this;
}

inline bool AccessPointRemovedSignal::operator == (const AccessPointRemovedSignal& rhs) const {
    return (((!hasAccesspoint() && !rhs.hasAccesspoint()) || getAccesspoint() == rhs.getAccesspoint()));
}

inline bool AccessPointRemovedSignal::operator != (const AccessPointRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AccessPointRemovedSignal::operator < (const AccessPointRemovedSignal& rhs) const {
    if (hasAccesspoint() || rhs.hasAccesspoint()) {
        if (getAccesspoint() < rhs.getAccesspoint()) return true;
        if (getAccesspoint() > rhs.getAccesspoint()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AccessPointRemovedSignal::clone() {
    return new AccessPointRemovedSignal(*this);
}

inline bool AccessPointRemovedSignal::operator > (const AccessPointRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AccessPointRemovedSignal::clear() {
    clearAccesspoint();
}

inline void AccessPointRemovedSignal::clearAccesspoint() {
    if (hasAccesspoint()) {
         clear_has_accesspoint();
        _accesspoint.clear();
     }
}

inline bool AccessPointRemovedSignal::hasAccesspoint () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AccessPointRemovedSignal::getAccesspoint () const {
    return _accesspoint;
}

inline ::std::string& AccessPointRemovedSignal::getAccesspointMutable () {
    set_has_accesspoint();
    return _accesspoint;
}

inline void AccessPointRemovedSignal::setAccesspoint (const ::std::string& accesspoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint = accesspoint_;
}

inline void AccessPointRemovedSignal::setAccesspoint (const char* accesspoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accesspoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint.assign(accesspoint_);
}

inline void AccessPointRemovedSignal::setAccesspoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accesspoint();
    this->_accesspoint.assign(value, size);
}

inline void AccessPointRemovedSignal::set_has_accesspoint () {
    _has_bits_[0] |= 1u << 0;
}

inline void AccessPointRemovedSignal::clear_has_accesspoint () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace Manager
} // namespace wapdman
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WAPDMAN_MANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
