/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusVariantDBus.h"
#include "org/bosch/wapdman/Accesspoint.h"
#include "org/bosch/wapdman/AccesspointDBus.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of SetSSIDRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SetSSIDRequest& in, DBusMessageIter* out) {
    DBusMessageIter o0ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o0ArrayIter));
    const ::std::vector< uint8 >* o1 = &in.getSsid();
    ::std::vector< uint8 >::const_iterator o2 = o1->end();
    for (::std::vector< uint8 >::const_iterator o3 = o1->begin(); o3 != o2; ++o3) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0ArrayIter, DBUS_TYPE_BYTE, &(*o3)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o0ArrayIter));
    dbus_bool_t o4 = in.getUtf_ssid() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o4));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SetSSIDRequest& out) {
    {
        ::std::vector< uint8 > ssidValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o5ArrayIter;
            dbus_message_iter_recurse (in, &o5ArrayIter);

            if(dbus_message_iter_get_arg_type(&o5ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o6;
                    dbus_message_iter_get_basic(&o5ArrayIter, &o6);
                    ssidValue.push_back(o6);
                } while (dbus_message_iter_next(&o5ArrayIter));
            }
        }
        out.setSsid(ssidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool utf_ssidValue;
        bool &utf_ssidTmpValue = utf_ssidValue;
        {
            dbus_bool_t o7;
            dbus_message_iter_get_basic(in, &o7);
            utf_ssidTmpValue = o7 ? true : false;
        }
        out.setUtf_ssid(utf_ssidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeAuthenticateStationRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationRequest& in, DBusMessageIter* out) {
    const char* o8 = in.getAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o8));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationRequest& out) {
    {
        ::std::string addressValue;
        ::std::string &addressTmpValue = addressValue;
        {
            char* o9 = 0;
            dbus_message_iter_get_basic(in, &o9);
            addressTmpValue.assign (o9);
        }
        out.setAddress(addressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlacklistStationRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::BlacklistStationRequest& in, DBusMessageIter* out) {
    const char* o10 = in.getAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o10));
    dbus_bool_t o11 = in.getAllow() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o11));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::BlacklistStationRequest& out) {
    {
        ::std::string addressValue;
        ::std::string &addressTmpValue = addressValue;
        {
            char* o12 = 0;
            dbus_message_iter_get_basic(in, &o12);
            addressTmpValue.assign (o12);
        }
        out.setAddress(addressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool allowValue;
        bool &allowTmpValue = allowValue;
        {
            dbus_bool_t o13;
            dbus_message_iter_get_basic(in, &o13);
            allowTmpValue = o13 ? true : false;
        }
        out.setAllow(allowValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetOperatingChannelsRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsRequest& in, DBusMessageIter* out) {
    DBusMessageIter o14ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "q", &o14ArrayIter));
    const ::std::vector< uint16 >* o15 = &in.getChannels();
    ::std::vector< uint16 >::const_iterator o16 = o15->end();
    for (::std::vector< uint16 >::const_iterator o17 = o15->begin(); o17 != o16; ++o17) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14ArrayIter, DBUS_TYPE_UINT16, &(*o17)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o14ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsRequest& out) {
    {
        ::std::vector< uint16 > channelsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o18ArrayIter;
            dbus_message_iter_recurse (in, &o18ArrayIter);

            if(dbus_message_iter_get_arg_type(&o18ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint16 o19;
                    dbus_message_iter_get_basic(&o18ArrayIter, &o19);
                    channelsValue.push_back(o19);
                } while (dbus_message_iter_next(&o18ArrayIter));
            }
        }
        out.setChannels(channelsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetAssociatedStationsResponse

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o20ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(oa{sv})", &o20ArrayIter));
    const ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct >* o21 = &in.getAssociatedstations();
    ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct >::const_iterator o22 = o21->end();
    for (::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct >::const_iterator o23 = o21->begin(); o23 != o22; ++o23) {
        {
            DBusMessageIter o24Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o20ArrayIter, DBUS_TYPE_STRUCT, 0, &o24Struct));
            serializeDBus((*o23), &o24Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o20ArrayIter, &o24Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o20ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse& out) {
    {
        ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct > associatedstationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o25ArrayIter;
            dbus_message_iter_recurse (in, &o25ArrayIter);

            if(dbus_message_iter_get_arg_type(&o25ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct o26;
                    {
                        DBusMessageIter o27;
                        char* signature = dbus_message_iter_get_signature(&o25ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o25ArrayIter)) {
                                dbus_message_iter_recurse (&o25ArrayIter, &o27);

                                if (!deserializeDBus(&o27, o26)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    associatedstationsValue.push_back(o26);
                } while (dbus_message_iter_next(&o25ArrayIter));
            }
        }
        out.setAssociatedstations(associatedstationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RegisterVendorServiceRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceRequest& in, DBusMessageIter* out) {
    DBusMessageIter o28ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "ay", &o28ArrayIter));
    const ::std::vector< ::std::vector< uint8 > >* o29 = &in.getIEs();
    ::std::vector< ::std::vector< uint8 > >::const_iterator o30 = o29->end();
    for (::std::vector< ::std::vector< uint8 > >::const_iterator o31 = o29->begin(); o31 != o30; ++o31) {
        DBusMessageIter o32ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o28ArrayIter, DBUS_TYPE_ARRAY, "y", &o32ArrayIter));
        const ::std::vector< uint8 >* o33 = &(*o31);
        ::std::vector< uint8 >::const_iterator o34 = o33->end();
        for (::std::vector< uint8 >::const_iterator o35 = o33->begin(); o35 != o34; ++o35) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o32ArrayIter, DBUS_TYPE_BYTE, &(*o35)));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o28ArrayIter, &o32ArrayIter));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o28ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceRequest& out) {
    {
        ::std::vector< ::std::vector< uint8 > > IEsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o36ArrayIter;
            dbus_message_iter_recurse (in, &o36ArrayIter);

            if(dbus_message_iter_get_arg_type(&o36ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::vector< uint8 > o37;

                    if (dbus_message_iter_get_arg_type(&o36ArrayIter) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o38ArrayIter;
                        dbus_message_iter_recurse (&o36ArrayIter, &o38ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o38ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                uint8 o39;
                                dbus_message_iter_get_basic(&o38ArrayIter, &o39);
                                o37.push_back(o39);
                            } while (dbus_message_iter_next(&o38ArrayIter));
                        }
                    }
                    IEsValue.push_back(o37);
                } while (dbus_message_iter_next(&o36ArrayIter));
            }
        }
        out.setIEs(IEsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnregisterVendorServiceRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceRequest& in, DBusMessageIter* out) {
    DBusMessageIter o40ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "ay", &o40ArrayIter));
    const ::std::vector< ::std::vector< uint8 > >* o41 = &in.getIEs();
    ::std::vector< ::std::vector< uint8 > >::const_iterator o42 = o41->end();
    for (::std::vector< ::std::vector< uint8 > >::const_iterator o43 = o41->begin(); o43 != o42; ++o43) {
        DBusMessageIter o44ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o40ArrayIter, DBUS_TYPE_ARRAY, "y", &o44ArrayIter));
        const ::std::vector< uint8 >* o45 = &(*o43);
        ::std::vector< uint8 >::const_iterator o46 = o45->end();
        for (::std::vector< uint8 >::const_iterator o47 = o45->begin(); o47 != o46; ++o47) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o44ArrayIter, DBUS_TYPE_BYTE, &(*o47)));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o40ArrayIter, &o44ArrayIter));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o40ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceRequest& out) {
    {
        ::std::vector< ::std::vector< uint8 > > IEsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o48ArrayIter;
            dbus_message_iter_recurse (in, &o48ArrayIter);

            if(dbus_message_iter_get_arg_type(&o48ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::vector< uint8 > o49;

                    if (dbus_message_iter_get_arg_type(&o48ArrayIter) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o50ArrayIter;
                        dbus_message_iter_recurse (&o48ArrayIter, &o50ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o50ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                uint8 o51;
                                dbus_message_iter_get_basic(&o50ArrayIter, &o51);
                                o49.push_back(o51);
                            } while (dbus_message_iter_next(&o50ArrayIter));
                        }
                    }
                    IEsValue.push_back(o49);
                } while (dbus_message_iter_next(&o48ArrayIter));
            }
        }
        out.setIEs(IEsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetDnsDhcpConfResponse

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponse& in, DBusMessageIter* out) {
    {
        DBusMessageIter o52Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o52Struct));
        serializeDBus(in.getDnsdhcpserverconf(), &o52Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o52Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponse& out) {
    {
        ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct dnsdhcpserverconfValue;
        {
            DBusMessageIter o53;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o53);

                    if (!deserializeDBus(&o53, dnsdhcpserverconfValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setDnsdhcpserverconf(dnsdhcpserverconfValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SSIDUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SSIDUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o54ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o54ArrayIter));
    const ::std::vector< uint8 >* o55 = &in.getSSID();
    ::std::vector< uint8 >::const_iterator o56 = o55->end();
    for (::std::vector< uint8 >::const_iterator o57 = o55->begin(); o57 != o56; ++o57) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o54ArrayIter, DBUS_TYPE_BYTE, &(*o57)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o54ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SSIDUpdate& out) {
    {
        ::std::vector< uint8 > SSIDValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o58ArrayIter;
            dbus_message_iter_recurse (in, &o58ArrayIter);

            if(dbus_message_iter_get_arg_type(&o58ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o59;
                    dbus_message_iter_get_basic(&o58ArrayIter, &o59);
                    SSIDValue.push_back(o59);
                } while (dbus_message_iter_next(&o58ArrayIter));
            }
        }
        out.setSSID(SSIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SSIDRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SSIDRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::SSIDRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MacAddressUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::MacAddressUpdate& in, DBusMessageIter* out) {
    const char* o60 = in.getMacAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o60));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::MacAddressUpdate& out) {
    {
        ::std::string MacAddressValue;
        ::std::string &MacAddressTmpValue = MacAddressValue;
        {
            char* o61 = 0;
            dbus_message_iter_get_basic(in, &o61);
            MacAddressTmpValue.assign (o61);
        }
        out.setMacAddress(MacAddressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MacAddressRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::MacAddressRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::MacAddressRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InterfaceUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::InterfaceUpdate& in, DBusMessageIter* out) {
    const char* o62 = in.getInterface().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o62));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::InterfaceUpdate& out) {
    {
        ::std::string InterfaceValue;
        ::std::string &InterfaceTmpValue = InterfaceValue;
        {
            char* o63 = 0;
            dbus_message_iter_get_basic(in, &o63);
            InterfaceTmpValue.assign (o63);
        }
        out.setInterface(InterfaceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InterfaceRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::InterfaceRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::InterfaceRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BlackListedStationsUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::BlackListedStationsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o64ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o64ArrayIter));
    const ::std::vector< ::std::string >* o65 = &in.getBlackListedStations();
    ::std::vector< ::std::string >::const_iterator o66 = o65->end();
    for (::std::vector< ::std::string >::const_iterator o67 = o65->begin(); o67 != o66; ++o67) {
        const char* o68 = (*o67).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64ArrayIter, DBUS_TYPE_STRING, &o68));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o64ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::BlackListedStationsUpdate& out) {
    {
        ::std::vector< ::std::string > BlackListedStationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o69ArrayIter;
            dbus_message_iter_recurse (in, &o69ArrayIter);

            if(dbus_message_iter_get_arg_type(&o69ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o70;
                    {
                        char* o71 = 0;
                        dbus_message_iter_get_basic(&o69ArrayIter, &o71);
                        o70.assign (o71);
                    }
                    BlackListedStationsValue.push_back(o70);
                } while (dbus_message_iter_next(&o69ArrayIter));
            }
        }
        out.setBlackListedStations(BlackListedStationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlackListedStationsRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::BlackListedStationsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::BlackListedStationsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PoweredUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PoweredUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o72 = in.getPowered() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o72));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::PoweredUpdate& out) {
    {
        bool PoweredValue;
        bool &PoweredTmpValue = PoweredValue;
        {
            dbus_bool_t o73;
            dbus_message_iter_get_basic(in, &o73);
            PoweredTmpValue = o73 ? true : false;
        }
        out.setPowered(PoweredValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PoweredRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PoweredRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::PoweredRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of HiddenUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::HiddenUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o74 = in.getHidden() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o74));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::HiddenUpdate& out) {
    {
        bool HiddenValue;
        bool &HiddenTmpValue = HiddenValue;
        {
            dbus_bool_t o75;
            dbus_message_iter_get_basic(in, &o75);
            HiddenTmpValue = o75 ? true : false;
        }
        out.setHidden(HiddenValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HiddenRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::HiddenRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::HiddenRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SecurityUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SecurityUpdate& in, DBusMessageIter* out) {
    const char* o76 = in.getSecurity().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o76));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SecurityUpdate& out) {
    {
        ::std::string SecurityValue;
        ::std::string &SecurityTmpValue = SecurityValue;
        {
            char* o77 = 0;
            dbus_message_iter_get_basic(in, &o77);
            SecurityTmpValue.assign (o77);
        }
        out.setSecurity(SecurityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SecurityRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SecurityRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::SecurityRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PassphraseUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PassphraseUpdate& in, DBusMessageIter* out) {
    const char* o78 = in.getPassphrase().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o78));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::PassphraseUpdate& out) {
    {
        ::std::string PassphraseValue;
        ::std::string &PassphraseTmpValue = PassphraseValue;
        {
            char* o79 = 0;
            dbus_message_iter_get_basic(in, &o79);
            PassphraseTmpValue.assign (o79);
        }
        out.setPassphrase(PassphraseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PassphraseRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PassphraseRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::PassphraseRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MaximumStationsAllowedUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate& in, DBusMessageIter* out) {
    uint16 o80 = in.getMaximumStationsAllowed();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o80));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate& out) {
    {
        uint16 MaximumStationsAllowedValue;
        uint16 &MaximumStationsAllowedTmpValue = MaximumStationsAllowedValue;
        dbus_message_iter_get_basic(in, &MaximumStationsAllowedTmpValue);
        out.setMaximumStationsAllowed(MaximumStationsAllowedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MaximumStationsAllowedRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PowerStateUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PowerStateUpdate& in, DBusMessageIter* out) {
    const char* o81 = in.getPowerState().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o81));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::PowerStateUpdate& out) {
    {
        ::std::string PowerStateValue;
        ::std::string &PowerStateTmpValue = PowerStateValue;
        {
            char* o82 = 0;
            dbus_message_iter_get_basic(in, &o82);
            PowerStateTmpValue.assign (o82);
        }
        out.setPowerState(PowerStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PowerStateRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PowerStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::PowerStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PowerFailureReasonUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate& in, DBusMessageIter* out) {
    const char* o83 = in.getPowerFailureReason().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o83));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate& out) {
    {
        ::std::string PowerFailureReasonValue;
        ::std::string &PowerFailureReasonTmpValue = PowerFailureReasonValue;
        {
            char* o84 = 0;
            dbus_message_iter_get_basic(in, &o84);
            PowerFailureReasonTmpValue.assign (o84);
        }
        out.setPowerFailureReason(PowerFailureReasonValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PowerFailureReasonRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::PowerFailureReasonRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CurrentOperatingChannelUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate& in, DBusMessageIter* out) {
    uint16 o85 = in.getCurrentOperatingChannel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o85));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate& out) {
    {
        uint16 CurrentOperatingChannelValue;
        uint16 &CurrentOperatingChannelTmpValue = CurrentOperatingChannelValue;
        dbus_message_iter_get_basic(in, &CurrentOperatingChannelTmpValue);
        out.setCurrentOperatingChannel(CurrentOperatingChannelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CurrentOperatingChannelRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CurrentHwModeUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::CurrentHwModeUpdate& in, DBusMessageIter* out) {
    const char* o86 = in.getCurrentHwMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o86));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::CurrentHwModeUpdate& out) {
    {
        ::std::string CurrentHwModeValue;
        ::std::string &CurrentHwModeTmpValue = CurrentHwModeValue;
        {
            char* o87 = 0;
            dbus_message_iter_get_basic(in, &o87);
            CurrentHwModeTmpValue.assign (o87);
        }
        out.setCurrentHwMode(CurrentHwModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CurrentHwModeRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::CurrentHwModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::CurrentHwModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SupportedChannelsUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o88ArrayIter;
    DBusMessageIter o89DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o88ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o90 = &in.getSupportedChannels();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o91 = o90->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o92 = o90->begin(); o92 != o91; ++o92) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o88ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o89DictIter));
        const char* o93 = o92->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o89DictIter, DBUS_TYPE_STRING, &o93));
        serializeDBus(o92->second, &o89DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o88ArrayIter, &o89DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o88ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > SupportedChannelsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o94ArrayIter;
            DBusMessageIter o95DictIter;
            dbus_message_iter_recurse (in, &o94ArrayIter);

            if (dbus_message_iter_get_arg_type(&o94ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o96Key;
                    ::asf::dbus::DBusVariant o96Value;
                    dbus_message_iter_recurse (&o94ArrayIter, &o95DictIter);
                    {
                        char* o97 = 0;
                        dbus_message_iter_get_basic(&o95DictIter, &o97);
                        o96Key.assign (o97);
                    }
                    dbus_message_iter_next(&o95DictIter);
                    {
                        DBusMessageIter o98;
                        char* signature = dbus_message_iter_get_signature(&o95DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o95DictIter)) {
                                dbus_message_iter_recurse (&o95DictIter, &o98);

                                if (!deserializeDBus(&o98, o96Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    SupportedChannelsValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o96Key, o96Value));
                } while (dbus_message_iter_next(&o94ArrayIter));
            }
        }
        out.setSupportedChannels(SupportedChannelsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SupportedChannelsRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SupportedChannelsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::SupportedChannelsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of HWFeaturesUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o99ArrayIter;
    DBusMessageIter o100DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o99ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o101 = &in.getHWFeatures();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o102 = o101->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o103 = o101->begin(); o103 != o102; ++o103) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o99ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o100DictIter));
        const char* o104 = o103->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o100DictIter, DBUS_TYPE_STRING, &o104));
        serializeDBus(o103->second, &o100DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o99ArrayIter, &o100DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o99ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > HWFeaturesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o105ArrayIter;
            DBusMessageIter o106DictIter;
            dbus_message_iter_recurse (in, &o105ArrayIter);

            if (dbus_message_iter_get_arg_type(&o105ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o107Key;
                    ::asf::dbus::DBusVariant o107Value;
                    dbus_message_iter_recurse (&o105ArrayIter, &o106DictIter);
                    {
                        char* o108 = 0;
                        dbus_message_iter_get_basic(&o106DictIter, &o108);
                        o107Key.assign (o108);
                    }
                    dbus_message_iter_next(&o106DictIter);
                    {
                        DBusMessageIter o109;
                        char* signature = dbus_message_iter_get_signature(&o106DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o106DictIter)) {
                                dbus_message_iter_recurse (&o106DictIter, &o109);

                                if (!deserializeDBus(&o109, o107Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    HWFeaturesValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o107Key, o107Value));
                } while (dbus_message_iter_next(&o105ArrayIter));
            }
        }
        out.setHWFeatures(HWFeaturesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HWFeaturesRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::HWFeaturesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::HWFeaturesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of VendorIEsUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::VendorIEsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o110ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(a(y))", &o110ArrayIter));
    const ::std::vector< ::org::bosch::wapdman::Accesspoint::VendorIEsStruct >* o111 = &in.getVendorIEs();
    ::std::vector< ::org::bosch::wapdman::Accesspoint::VendorIEsStruct >::const_iterator o112 = o111->end();
    for (::std::vector< ::org::bosch::wapdman::Accesspoint::VendorIEsStruct >::const_iterator o113 = o111->begin(); o113 != o112; ++o113) {
        {
            DBusMessageIter o114Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o110ArrayIter, DBUS_TYPE_STRUCT, 0, &o114Struct));
            serializeDBus((*o113), &o114Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o110ArrayIter, &o114Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o110ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::VendorIEsUpdate& out) {
    {
        ::std::vector< ::org::bosch::wapdman::Accesspoint::VendorIEsStruct > VendorIEsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o115ArrayIter;
            dbus_message_iter_recurse (in, &o115ArrayIter);

            if(dbus_message_iter_get_arg_type(&o115ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::wapdman::Accesspoint::VendorIEsStruct o116;
                    {
                        DBusMessageIter o117;
                        char* signature = dbus_message_iter_get_signature(&o115ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o115ArrayIter)) {
                                dbus_message_iter_recurse (&o115ArrayIter, &o117);

                                if (!deserializeDBus(&o117, o116)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    VendorIEsValue.push_back(o116);
                } while (dbus_message_iter_next(&o115ArrayIter));
            }
        }
        out.setVendorIEs(VendorIEsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VendorIEsRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::VendorIEsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::VendorIEsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AssociatedStationsChangedSignal

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal& in, DBusMessageIter* out) {
    DBusMessageIter o118ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(oa{sv})", &o118ArrayIter));
    const ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct >* o119 = &in.getChangedstations();
    ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct >::const_iterator o120 = o119->end();
    for (::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct >::const_iterator o121 = o119->begin(); o121 != o120; ++o121) {
        {
            DBusMessageIter o122Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o118ArrayIter, DBUS_TYPE_STRUCT, 0, &o122Struct));
            serializeDBus((*o121), &o122Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o118ArrayIter, &o122Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o118ArrayIter));
    DBusMessageIter o123ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "o", &o123ArrayIter));
    const ::std::vector< ::std::string >* o124 = &in.getRemovedstations();
    ::std::vector< ::std::string >::const_iterator o125 = o124->end();
    for (::std::vector< ::std::string >::const_iterator o126 = o124->begin(); o126 != o125; ++o126) {
        DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string((*o126))));
        DBUS_ASSERT(dbus_message_iter_append_basic(&o123ArrayIter, DBUS_TYPE_OBJECT_PATH, &(*o126)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o123ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal& out) {
    {
        ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct > changedstationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o127ArrayIter;
            dbus_message_iter_recurse (in, &o127ArrayIter);

            if(dbus_message_iter_get_arg_type(&o127ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct o128;
                    {
                        DBusMessageIter o129;
                        char* signature = dbus_message_iter_get_signature(&o127ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o127ArrayIter)) {
                                dbus_message_iter_recurse (&o127ArrayIter, &o129);

                                if (!deserializeDBus(&o129, o128)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    changedstationsValue.push_back(o128);
                } while (dbus_message_iter_next(&o127ArrayIter));
            }
        }
        out.setChangedstations(changedstationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > removedstationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o130ArrayIter;
            dbus_message_iter_recurse (in, &o130ArrayIter);

            if(dbus_message_iter_get_arg_type(&o130ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o131;
                    {
                        char* o132 = 0;
                        dbus_message_iter_get_basic(&o130ArrayIter, &o132);
                        o131.assign (o132);
                    }
                    removedstationsValue.push_back(o131);
                } while (dbus_message_iter_next(&o130ArrayIter));
            }
        }
        out.setRemovedstations(removedstationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AssociationRequestRejectedSignal

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedSignal& in, DBusMessageIter* out) {
    DBusMessageIter o133ArrayIter;
    DBusMessageIter o134DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o133ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o135 = &in.getStation();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o136 = o135->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o137 = o135->begin(); o137 != o136; ++o137) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o133ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o134DictIter));
        const char* o138 = o137->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o134DictIter, DBUS_TYPE_STRING, &o138));
        serializeDBus(o137->second, &o134DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o133ArrayIter, &o134DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o133ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedSignal& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > stationValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o139ArrayIter;
            DBusMessageIter o140DictIter;
            dbus_message_iter_recurse (in, &o139ArrayIter);

            if (dbus_message_iter_get_arg_type(&o139ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o141Key;
                    ::asf::dbus::DBusVariant o141Value;
                    dbus_message_iter_recurse (&o139ArrayIter, &o140DictIter);
                    {
                        char* o142 = 0;
                        dbus_message_iter_get_basic(&o140DictIter, &o142);
                        o141Key.assign (o142);
                    }
                    dbus_message_iter_next(&o140DictIter);
                    {
                        DBusMessageIter o143;
                        char* signature = dbus_message_iter_get_signature(&o140DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o140DictIter)) {
                                dbus_message_iter_recurse (&o140DictIter, &o143);

                                if (!deserializeDBus(&o143, o141Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    stationValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o141Key, o141Value));
                } while (dbus_message_iter_next(&o139ArrayIter));
            }
        }
        out.setStation(stationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetAssociatedStationsResponseAssociatedstationsStruct

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o144ArrayIter;
    DBusMessageIter o145DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o144ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o146 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o147 = o146->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o148 = o146->begin(); o148 != o147; ++o148) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o144ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o145DictIter));
        const char* o149 = o148->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o145DictIter, DBUS_TYPE_STRING, &o149));
        serializeDBus(o148->second, &o145DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o144ArrayIter, &o145DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o144ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o150 = 0;
            dbus_message_iter_get_basic(in, &o150);
            elem1TmpValue.assign (o150);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o151ArrayIter;
            DBusMessageIter o152DictIter;
            dbus_message_iter_recurse (in, &o151ArrayIter);

            if (dbus_message_iter_get_arg_type(&o151ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o153Key;
                    ::asf::dbus::DBusVariant o153Value;
                    dbus_message_iter_recurse (&o151ArrayIter, &o152DictIter);
                    {
                        char* o154 = 0;
                        dbus_message_iter_get_basic(&o152DictIter, &o154);
                        o153Key.assign (o154);
                    }
                    dbus_message_iter_next(&o152DictIter);
                    {
                        DBusMessageIter o155;
                        char* signature = dbus_message_iter_get_signature(&o152DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o152DictIter)) {
                                dbus_message_iter_recurse (&o152DictIter, &o155);

                                if (!deserializeDBus(&o155, o153Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o153Key, o153Value));
                } while (dbus_message_iter_next(&o151ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetDnsDhcpConfResponseDnsdhcpserverconfStruct

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o156ArrayIter;
    DBusMessageIter o157DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o156ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o158 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o159 = o158->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o160 = o158->begin(); o160 != o159; ++o160) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o156ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o157DictIter));
        const char* o161 = o160->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o157DictIter, DBUS_TYPE_STRING, &o161));
        serializeDBus(o160->second, &o157DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o156ArrayIter, &o157DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o156ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o162 = 0;
            dbus_message_iter_get_basic(in, &o162);
            elem1TmpValue.assign (o162);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o163ArrayIter;
            DBusMessageIter o164DictIter;
            dbus_message_iter_recurse (in, &o163ArrayIter);

            if (dbus_message_iter_get_arg_type(&o163ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o165Key;
                    ::asf::dbus::DBusVariant o165Value;
                    dbus_message_iter_recurse (&o163ArrayIter, &o164DictIter);
                    {
                        char* o166 = 0;
                        dbus_message_iter_get_basic(&o164DictIter, &o166);
                        o165Key.assign (o166);
                    }
                    dbus_message_iter_next(&o164DictIter);
                    {
                        DBusMessageIter o167;
                        char* signature = dbus_message_iter_get_signature(&o164DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o164DictIter)) {
                                dbus_message_iter_recurse (&o164DictIter, &o167);

                                if (!deserializeDBus(&o167, o165Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o165Key, o165Value));
                } while (dbus_message_iter_next(&o163ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VendorIEsElem1Struct

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::VendorIEsElem1Struct& in, DBusMessageIter* out) {
    uint8 o168 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o168));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::VendorIEsElem1Struct& out) {
    {
        uint8 elem1Value;
        uint8 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VendorIEsStruct

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::VendorIEsStruct& in, DBusMessageIter* out) {
    DBusMessageIter o169ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(y)", &o169ArrayIter));
    const ::std::vector< ::org::bosch::wapdman::Accesspoint::VendorIEsElem1Struct >* o170 = &in.getElem1();
    ::std::vector< ::org::bosch::wapdman::Accesspoint::VendorIEsElem1Struct >::const_iterator o171 = o170->end();
    for (::std::vector< ::org::bosch::wapdman::Accesspoint::VendorIEsElem1Struct >::const_iterator o172 = o170->begin(); o172 != o171; ++o172) {
        {
            DBusMessageIter o173Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o169ArrayIter, DBUS_TYPE_STRUCT, 0, &o173Struct));
            serializeDBus((*o172), &o173Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o169ArrayIter, &o173Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o169ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::VendorIEsStruct& out) {
    {
        ::std::vector< ::org::bosch::wapdman::Accesspoint::VendorIEsElem1Struct > elem1Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o174ArrayIter;
            dbus_message_iter_recurse (in, &o174ArrayIter);

            if(dbus_message_iter_get_arg_type(&o174ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::wapdman::Accesspoint::VendorIEsElem1Struct o175;
                    {
                        DBusMessageIter o176;
                        char* signature = dbus_message_iter_get_signature(&o174ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o174ArrayIter)) {
                                dbus_message_iter_recurse (&o174ArrayIter, &o176);

                                if (!deserializeDBus(&o176, o175)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem1Value.push_back(o175);
                } while (dbus_message_iter_next(&o174ArrayIter));
            }
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AssociatedStationsChangedSignalChangedstationsStruct

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o177ArrayIter;
    DBusMessageIter o178DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o177ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o179 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o180 = o179->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o181 = o179->begin(); o181 != o180; ++o181) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o177ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o178DictIter));
        const char* o182 = o181->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o178DictIter, DBUS_TYPE_STRING, &o182));
        serializeDBus(o181->second, &o178DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o177ArrayIter, &o178DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o177ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o183 = 0;
            dbus_message_iter_get_basic(in, &o183);
            elem1TmpValue.assign (o183);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o184ArrayIter;
            DBusMessageIter o185DictIter;
            dbus_message_iter_recurse (in, &o184ArrayIter);

            if (dbus_message_iter_get_arg_type(&o184ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o186Key;
                    ::asf::dbus::DBusVariant o186Value;
                    dbus_message_iter_recurse (&o184ArrayIter, &o185DictIter);
                    {
                        char* o187 = 0;
                        dbus_message_iter_get_basic(&o185DictIter, &o187);
                        o186Key.assign (o187);
                    }
                    dbus_message_iter_next(&o185DictIter);
                    {
                        DBusMessageIter o188;
                        char* signature = dbus_message_iter_get_signature(&o185DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o185DictIter)) {
                                dbus_message_iter_recurse (&o185DictIter, &o188);

                                if (!deserializeDBus(&o188, o186Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o186Key, o186Value));
                } while (dbus_message_iter_next(&o184ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

