/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WAPDMAN_ACCESSPOINT_TETHERINGSETTINGSPROXY_H
#define ORG_BOSCH_WAPDMAN_ACCESSPOINT_TETHERINGSETTINGSPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettings.h"
#include <dbus/dbus.h>

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {
namespace TetheringSettings {

class TetheringSettingsProxy;

class TetheringCallbackIF {
public:
    virtual ~TetheringCallbackIF() {}

    virtual void onTetheringError(const ::boost::shared_ptr< TetheringSettingsProxy >& proxy, const ::boost::shared_ptr< TetheringError >& error) = 0;

    virtual void onTetheringUpdate(const ::boost::shared_ptr< TetheringSettingsProxy >& proxy, const ::boost::shared_ptr< TetheringUpdate >& update) = 0;
};


/**
 * TetheringSettingsProxy is the client side representation of the D-Bus
 * service interface 'org.bosch.wapdman.Accesspoint.TetheringSettings'
 * (specified in file org-bosch-wapdmgr-accesspoint-introspection.xml).
 *
 * If the meaning of "org.bosch.wapdman.Accesspoint.TetheringSettings" isn't clear, then there should be a description here.
 */
class TetheringSettingsProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of TetheringSettingsProxy.
     */
    static ::boost::shared_ptr< TetheringSettingsProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of TetheringSettingsProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< TetheringSettingsProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of TetheringSettingsProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< TetheringSettingsProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< TetheringSettingsProxy > proxyNew(new TetheringSettingsProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~TetheringSettingsProxy ();



    // Property 'Tethering'

    /**
     * Notify on the property 'Tethering'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTetheringRegister(TetheringCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Tethering'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTetheringRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTetheringDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Tethering'.
     */
    void sendTetheringDeregisterAll() const;

    /**
     * Request the value of the property 'Tethering' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTetheringGet(TetheringCallbackIF& cb);

    /**
     * Set the value of the property 'Tethering'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendTetheringSet(TetheringCallbackIF& cb, bool
     * tethering) method instead.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     */
    void sendTetheringSet(bool tethering);

    /**
     * Set the value of the property 'Tethering'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTetheringSet(TetheringCallbackIF& cb, bool tethering);

    /**
     * Returns the current value of the property 'Tethering' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTethering()
     * returns true.
     *
     * @return the previously received value of the property 'Tethering'.
     */
    bool getTethering() const;

    /**
     * Determines whether a status message for the property 'Tethering' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTethering() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    TetheringSettingsProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Tethering'

    ::asf::core::nullable< TetheringUpdate > _tethering;

    DECLARE_CLASS_LOGGER();

    friend class TetheringSettingsProxyCallback;
};

} // namespace TetheringSettings
} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WAPDMAN_ACCESSPOINT_TETHERINGSETTINGSPROXY_H
