/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WAPDMAN_ACCESSPOINT_DHCPDNSCONFIGURATIONPROXY_H
#define ORG_BOSCH_WAPDMAN_ACCESSPOINT_DHCPDNSCONFIGURATIONPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/wapdman/Accesspoint/DHCPDNSConfiguration.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {
namespace DHCPDNSConfiguration {

class DHCPDNSConfigurationProxy;

class IPv4PoolCallbackIF {
public:
    virtual ~IPv4PoolCallbackIF() {}

    virtual void onIPv4PoolError(const ::boost::shared_ptr< DHCPDNSConfigurationProxy >& proxy, const ::boost::shared_ptr< IPv4PoolError >& error) = 0;

    virtual void onIPv4PoolUpdate(const ::boost::shared_ptr< DHCPDNSConfigurationProxy >& proxy, const ::boost::shared_ptr< IPv4PoolUpdate >& update) = 0;
};


/**
 * DHCPDNSConfigurationProxy is the client side representation of the
 * D-Bus service interface
 * 'org.bosch.wapdman.Accesspoint.DHCPDNSConfiguration' (specified in file
 * org-bosch-wapdmgr-accesspoint-introspection.xml).
 *
 * If the meaning of "org.bosch.wapdman.Accesspoint.DHCPDNSConfiguration" isn't clear, then there should be a description here.
 */
class DHCPDNSConfigurationProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DHCPDNSConfigurationProxy.
     */
    static ::boost::shared_ptr< DHCPDNSConfigurationProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DHCPDNSConfigurationProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DHCPDNSConfigurationProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DHCPDNSConfigurationProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DHCPDNSConfigurationProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DHCPDNSConfigurationProxy > proxyNew(new DHCPDNSConfigurationProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~DHCPDNSConfigurationProxy ();



    // Property 'IPv4Pool'

    /**
     * Notify on the property 'IPv4Pool'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'IPv4Pool'</b>:
     *
     * If the meaning of "IPv4Pool" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPv4PoolRegister(IPv4PoolCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'IPv4Pool'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'IPv4Pool'</b>:
     *
     * If the meaning of "IPv4Pool" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendIPv4PoolRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIPv4PoolDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'IPv4Pool'.
     */
    void sendIPv4PoolDeregisterAll() const;

    /**
     * Request the value of the property 'IPv4Pool' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'IPv4Pool'</b>:
     *
     * If the meaning of "IPv4Pool" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPv4PoolGet(IPv4PoolCallbackIF& cb);


    /**
     * Returns the current value of the property 'IPv4Pool' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasIPv4Pool()
     * returns true.
     *
     * @return the previously received value of the property 'IPv4Pool'.
     */
    const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getIPv4Pool() const;

    /**
     * Determines whether a status message for the property 'IPv4Pool' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPv4Pool() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    DHCPDNSConfigurationProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'IPv4Pool'

    ::asf::core::nullable< IPv4PoolUpdate > _iPv4Pool;

    DECLARE_CLASS_LOGGER();

    friend class DHCPDNSConfigurationProxyCallback;
};

} // namespace DHCPDNSConfiguration
} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WAPDMAN_ACCESSPOINT_DHCPDNSCONFIGURATIONPROXY_H
