/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROLSTUB_H
#define ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROLSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include "org/genivi/NodeStateManager/LifecycleControl.h"

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifecycleControl {

class LifecycleControlStubDelegate;

class LifecycleControlStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the LifecycleControlStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    LifecycleControlStub (const std::string& portName);

    /**
     * Create an instance of the LifecycleControlStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    LifecycleControlStub (const std::string& portName, const std::string& objectPath);

    virtual ~LifecycleControlStub();

    // method 'RequestNodeRestart'

    /**
     * The method onRequestNodeRestart() is called by ASF when a client
     * invokes the method 'RequestNodeRestart'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestNodeRestart() or sendRequestNodeRestartError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'RequestNodeRestart'</b>:
     *
     * RequestNodeRestart:
     *     	RestartReason: The passed value will be based upon the enum NsmRestartReason_e.
     *     	RestartType:   This is the type of restart that is required, i.e. during Coding process it is normal for a fast shutdown to be	requested
     *     				   whereas other Diagnosis restart requests would be normal.
     *     	               Possible values are NSM_SHUTDOWNTYPE_FAST and NSM_SHUTDOWNTYPE_NORMAL.
     *     	ErrorCode:     Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to request a restart of the node.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestNodeRestartRequest (const ::boost::shared_ptr< RequestNodeRestartRequest >& request) = 0;

    /**
     * The method sendRequestNodeRestartResponse() sends a response of a
     * previous method invocation of 'RequestNodeRestart' back to the client.
     *
     * <b>Documentation of 'RequestNodeRestart'</b>:
     *
     * RequestNodeRestart:
     *     	RestartReason: The passed value will be based upon the enum NsmRestartReason_e.
     *     	RestartType:   This is the type of restart that is required, i.e. during Coding process it is normal for a fast shutdown to be	requested
     *     				   whereas other Diagnosis restart requests would be normal.
     *     	               Possible values are NSM_SHUTDOWNTYPE_FAST and NSM_SHUTDOWNTYPE_NORMAL.
     *     	ErrorCode:     Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to request a restart of the node.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestNodeRestart(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestNodeRestartResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendRequestNodeRestartError() sends an error response of a
     * previous method invocation of 'RequestNodeRestart' back to the client.
     *
     * <b>Documentation of 'RequestNodeRestart'</b>:
     *
     * RequestNodeRestart:
     *     	RestartReason: The passed value will be based upon the enum NsmRestartReason_e.
     *     	RestartType:   This is the type of restart that is required, i.e. during Coding process it is normal for a fast shutdown to be	requested
     *     				   whereas other Diagnosis restart requests would be normal.
     *     	               Possible values are NSM_SHUTDOWNTYPE_FAST and NSM_SHUTDOWNTYPE_NORMAL.
     *     	ErrorCode:     Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to request a restart of the node.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestNodeRestart().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestNodeRestartError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetApplicationMode'

    /**
     * The method onSetApplicationMode() is called by ASF when a client
     * invokes the method 'SetApplicationMode'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetApplicationMode() or sendSetApplicationModeError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'SetApplicationMode'</b>:
     *
     * SetApplicationMode:
     *     	ApplicationModeId: This parameter will be based upon the NsmNodeApplicationMode_e.
     *     	ErrorCode:         Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to set the application mode.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetApplicationModeRequest (const ::boost::shared_ptr< SetApplicationModeRequest >& request) = 0;

    /**
     * The method sendSetApplicationModeResponse() sends a response of a
     * previous method invocation of 'SetApplicationMode' back to the client.
     *
     * <b>Documentation of 'SetApplicationMode'</b>:
     *
     * SetApplicationMode:
     *     	ApplicationModeId: This parameter will be based upon the NsmNodeApplicationMode_e.
     *     	ErrorCode:         Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to set the application mode.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetApplicationMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetApplicationModeResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendSetApplicationModeError() sends an error response of a
     * previous method invocation of 'SetApplicationMode' back to the client.
     *
     * <b>Documentation of 'SetApplicationMode'</b>:
     *
     * SetApplicationMode:
     *     	ApplicationModeId: This parameter will be based upon the NsmNodeApplicationMode_e.
     *     	ErrorCode:         Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to set the application mode.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetApplicationMode().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetApplicationModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetNodeState'

    /**
     * The method onSetNodeState() is called by ASF when a client invokes the
     * method 'SetNodeState'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetNodeState() or
     * sendSetNodeStateError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetNodeState'</b>:
     *
     * SetNodeState:
     *     	NodeStateId: The passed value will be based upon the enum NsmNodeState_e.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to set the NodeState.
     *     	When this method is called to change the current NodeState a signal will be sent to notify registered consumers of the new state.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetNodeStateRequest (const ::boost::shared_ptr< SetNodeStateRequest >& request) = 0;

    /**
     * The method sendSetNodeStateResponse() sends a response of a previous
     * method invocation of 'SetNodeState' back to the client.
     *
     * <b>Documentation of 'SetNodeState'</b>:
     *
     * SetNodeState:
     *     	NodeStateId: The passed value will be based upon the enum NsmNodeState_e.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to set the NodeState.
     *     	When this method is called to change the current NodeState a signal will be sent to notify registered consumers of the new state.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetNodeState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetNodeStateResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendSetNodeStateError() sends an error response of a
     * previous method invocation of 'SetNodeState' back to the client.
     *
     * <b>Documentation of 'SetNodeState'</b>:
     *
     * SetNodeState:
     *     	NodeStateId: The passed value will be based upon the enum NsmNodeState_e.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to set the NodeState.
     *     	When this method is called to change the current NodeState a signal will be sent to notify registered consumers of the new state.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetNodeState(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetNodeStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetBootMode'

    /**
     * The method onSetBootMode() is called by ASF when a client invokes the
     * method 'SetBootMode'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetBootMode() or
     * sendSetBootModeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetBootMode'</b>:
     *
     * SetBootMode:
     *     	BootMode:    New BootMode to be set. The values will be defined by a third party header, which has not been delivered yet.
     *     	             The description needs to be updated as soon as the header is available.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method has been introduced, because the property "BootMode" can only be read by other applications.
     *     	Nevertheless there are some exceptions where the property should be set by a restricted set of applications which will be handled within this method.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetBootModeRequest (const ::boost::shared_ptr< SetBootModeRequest >& request) = 0;

    /**
     * The method sendSetBootModeResponse() sends a response of a previous
     * method invocation of 'SetBootMode' back to the client.
     *
     * <b>Documentation of 'SetBootMode'</b>:
     *
     * SetBootMode:
     *     	BootMode:    New BootMode to be set. The values will be defined by a third party header, which has not been delivered yet.
     *     	             The description needs to be updated as soon as the header is available.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method has been introduced, because the property "BootMode" can only be read by other applications.
     *     	Nevertheless there are some exceptions where the property should be set by a restricted set of applications which will be handled within this method.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetBootMode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetBootModeResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendSetBootModeError() sends an error response of a previous
     * method invocation of 'SetBootMode' back to the client.
     *
     * <b>Documentation of 'SetBootMode'</b>:
     *
     * SetBootMode:
     *     	BootMode:    New BootMode to be set. The values will be defined by a third party header, which has not been delivered yet.
     *     	             The description needs to be updated as soon as the header is available.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method has been introduced, because the property "BootMode" can only be read by other applications.
     *     	Nevertheless there are some exceptions where the property should be set by a restricted set of applications which will be handled within this method.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetBootMode(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetBootModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetAppHealthStatus'

    /**
     * The method onSetAppHealthStatus() is called by ASF when a client
     * invokes the method 'SetAppHealthStatus'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetAppHealthStatus() or sendSetAppHealthStatusError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'SetAppHealthStatus'</b>:
     *
     * SetAppHealthStatus:
     *     	AppName:     This parameter can be used to give the name of the application that has failed (this must be the applications systemd unit name).
     *     	AppRunning:  The AppState will be FALSE for failed and TRUE for running.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	This method will be used by the Node Health Monitor to report to the NSM if an application has failed and if it is running again.
     *     	Internally the NSM will use this information to keep a count of the number of failed applications within the current lifecycle.
     *     	Additionally it will unset any sessions that the failing application may have had active. It will also be possible for the product
     *     	node state machine to make a decision on what to do with this information,
     *     	i.e. even reset the node or reset the node if too many applications have failed.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetAppHealthStatusRequest (const ::boost::shared_ptr< SetAppHealthStatusRequest >& request) = 0;

    /**
     * The method sendSetAppHealthStatusResponse() sends a response of a
     * previous method invocation of 'SetAppHealthStatus' back to the client.
     *
     * <b>Documentation of 'SetAppHealthStatus'</b>:
     *
     * SetAppHealthStatus:
     *     	AppName:     This parameter can be used to give the name of the application that has failed (this must be the applications systemd unit name).
     *     	AppRunning:  The AppState will be FALSE for failed and TRUE for running.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	This method will be used by the Node Health Monitor to report to the NSM if an application has failed and if it is running again.
     *     	Internally the NSM will use this information to keep a count of the number of failed applications within the current lifecycle.
     *     	Additionally it will unset any sessions that the failing application may have had active. It will also be possible for the product
     *     	node state machine to make a decision on what to do with this information,
     *     	i.e. even reset the node or reset the node if too many applications have failed.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetAppHealthStatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetAppHealthStatusResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendSetAppHealthStatusError() sends an error response of a
     * previous method invocation of 'SetAppHealthStatus' back to the client.
     *
     * <b>Documentation of 'SetAppHealthStatus'</b>:
     *
     * SetAppHealthStatus:
     *     	AppName:     This parameter can be used to give the name of the application that has failed (this must be the applications systemd unit name).
     *     	AppRunning:  The AppState will be FALSE for failed and TRUE for running.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	This method will be used by the Node Health Monitor to report to the NSM if an application has failed and if it is running again.
     *     	Internally the NSM will use this information to keep a count of the number of failed applications within the current lifecycle.
     *     	Additionally it will unset any sessions that the failing application may have had active. It will also be possible for the product
     *     	node state machine to make a decision on what to do with this information,
     *     	i.e. even reset the node or reset the node if too many applications have failed.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetAppHealthStatus().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetAppHealthStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CheckLucRequired'

    /**
     * The method onCheckLucRequired() is called by ASF when a client invokes
     * the method 'CheckLucRequired'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendCheckLucRequired() or sendCheckLucRequiredError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'CheckLucRequired'</b>:
     *
     * CheckLucRequired:
     *     	LucWanted:   This will be a simple TRUE or FALSE to define whether the LUC is wanted in the current Lifecycle.
     *
     *     	This method will be called exclusivley by the Boot Manager to find out whether the LUC Applications should be started in the current Lifecycle.
     *     	This is required whilst in certain Node Application Modes (i.e. Transport, Factory) we do not want the LUC Applications started.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCheckLucRequiredRequest (const ::boost::shared_ptr< CheckLucRequiredRequest >& request) = 0;

    /**
     * The method sendCheckLucRequiredResponse() sends a response of a
     * previous method invocation of 'CheckLucRequired' back to the client.
     *
     * <b>Documentation of 'CheckLucRequired'</b>:
     *
     * CheckLucRequired:
     *     	LucWanted:   This will be a simple TRUE or FALSE to define whether the LUC is wanted in the current Lifecycle.
     *
     *     	This method will be called exclusivley by the Boot Manager to find out whether the LUC Applications should be started in the current Lifecycle.
     *     	This is required whilst in certain Node Application Modes (i.e. Transport, Factory) we do not want the LUC Applications started.
     *
     * @param LucWanted If the meaning of "LucWanted" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCheckLucRequired(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCheckLucRequiredResponse (bool lucWanted, act_t act = 0);

    /**
     * The method sendCheckLucRequiredError() sends an error response of a
     * previous method invocation of 'CheckLucRequired' back to the client.
     *
     * <b>Documentation of 'CheckLucRequired'</b>:
     *
     * CheckLucRequired:
     *     	LucWanted:   This will be a simple TRUE or FALSE to define whether the LUC is wanted in the current Lifecycle.
     *
     *     	This method will be called exclusivley by the Boot Manager to find out whether the LUC Applications should be started in the current Lifecycle.
     *     	This is required whilst in certain Node Application Modes (i.e. Transport, Factory) we do not want the LUC Applications started.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCheckLucRequired(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCheckLucRequiredError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class LifecycleControlStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace LifecycleControl
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROLSTUB_H
