/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"
#include "org/genivi/NodeStateManager/LifecycleControl.h"
#include "org/genivi/NodeStateManager/LifecycleControlDBus.h"
#include "org/genivi/NodeStateManager/LifecycleControlJson.h"
#include "org/genivi/NodeStateManager/LifecycleControlProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifecycleControl {

DEFINE_CLASS_LOGGER("/org/genivi/NodeStateManager/org/genivi/NodeStateManager/LifecycleControl", LifecycleControlProxy);

class LifecycleControlProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    LifecycleControlProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< LifecycleControlProxy >& proxyShared = ::boost::static_pointer_cast< LifecycleControlProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_RequestNodeRestart:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestNodeRestartError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestNodeRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestNodeRestartError> payload = ::boost::static_pointer_cast<RequestNodeRestartError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestNodeRestartCallbackIF*) _callback)->onRequestNodeRestartError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestNodeRestartResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestNodeRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestNodeRestartResponse> payload = ::boost::static_pointer_cast<RequestNodeRestartResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestNodeRestartCallbackIF*) _callback)->onRequestNodeRestartResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetApplicationMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetApplicationModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetApplicationMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetApplicationModeError> payload = ::boost::static_pointer_cast<SetApplicationModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetApplicationModeCallbackIF*) _callback)->onSetApplicationModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetApplicationModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetApplicationMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetApplicationModeResponse> payload = ::boost::static_pointer_cast<SetApplicationModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetApplicationModeCallbackIF*) _callback)->onSetApplicationModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetNodeState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetNodeStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetNodeState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetNodeStateError> payload = ::boost::static_pointer_cast<SetNodeStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetNodeStateCallbackIF*) _callback)->onSetNodeStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetNodeStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetNodeState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetNodeStateResponse> payload = ::boost::static_pointer_cast<SetNodeStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetNodeStateCallbackIF*) _callback)->onSetNodeStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetBootMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetBootModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetBootMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetBootModeError> payload = ::boost::static_pointer_cast<SetBootModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetBootModeCallbackIF*) _callback)->onSetBootModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetBootModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetBootMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetBootModeResponse> payload = ::boost::static_pointer_cast<SetBootModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetBootModeCallbackIF*) _callback)->onSetBootModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetAppHealthStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetAppHealthStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAppHealthStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetAppHealthStatusError> payload = ::boost::static_pointer_cast<SetAppHealthStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetAppHealthStatusCallbackIF*) _callback)->onSetAppHealthStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetAppHealthStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAppHealthStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetAppHealthStatusResponse> payload = ::boost::static_pointer_cast<SetAppHealthStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetAppHealthStatusCallbackIF*) _callback)->onSetAppHealthStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CheckLucRequired:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CheckLucRequiredError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CheckLucRequired", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CheckLucRequiredError> payload = ::boost::static_pointer_cast<CheckLucRequiredError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CheckLucRequiredCallbackIF*) _callback)->onCheckLucRequiredError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CheckLucRequiredResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CheckLucRequired", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CheckLucRequiredResponse> payload = ::boost::static_pointer_cast<CheckLucRequiredResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CheckLucRequiredCallbackIF*) _callback)->onCheckLucRequiredResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_RequestNodeRestart: {
                ::boost::shared_ptr< RequestNodeRestartError > payload = ::boost::shared_ptr< RequestNodeRestartError >
                (new RequestNodeRestartError(DBUS_ERROR_NO_SERVER, "The DBus service LifecycleControl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestNodeRestart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifecycleControlProxy> proxyShared = ::boost::static_pointer_cast<LifecycleControlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestNodeRestartCallbackIF*) _callback)->onRequestNodeRestartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetApplicationMode: {
                ::boost::shared_ptr< SetApplicationModeError > payload = ::boost::shared_ptr< SetApplicationModeError >
                (new SetApplicationModeError(DBUS_ERROR_NO_SERVER, "The DBus service LifecycleControl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetApplicationMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifecycleControlProxy> proxyShared = ::boost::static_pointer_cast<LifecycleControlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetApplicationModeCallbackIF*) _callback)->onSetApplicationModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetNodeState: {
                ::boost::shared_ptr< SetNodeStateError > payload = ::boost::shared_ptr< SetNodeStateError >
                (new SetNodeStateError(DBUS_ERROR_NO_SERVER, "The DBus service LifecycleControl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetNodeState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifecycleControlProxy> proxyShared = ::boost::static_pointer_cast<LifecycleControlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetNodeStateCallbackIF*) _callback)->onSetNodeStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetBootMode: {
                ::boost::shared_ptr< SetBootModeError > payload = ::boost::shared_ptr< SetBootModeError >
                (new SetBootModeError(DBUS_ERROR_NO_SERVER, "The DBus service LifecycleControl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetBootMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifecycleControlProxy> proxyShared = ::boost::static_pointer_cast<LifecycleControlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetBootModeCallbackIF*) _callback)->onSetBootModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetAppHealthStatus: {
                ::boost::shared_ptr< SetAppHealthStatusError > payload = ::boost::shared_ptr< SetAppHealthStatusError >
                (new SetAppHealthStatusError(DBUS_ERROR_NO_SERVER, "The DBus service LifecycleControl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetAppHealthStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifecycleControlProxy> proxyShared = ::boost::static_pointer_cast<LifecycleControlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetAppHealthStatusCallbackIF*) _callback)->onSetAppHealthStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CheckLucRequired: {
                ::boost::shared_ptr< CheckLucRequiredError > payload = ::boost::shared_ptr< CheckLucRequiredError >
                (new CheckLucRequiredError(DBUS_ERROR_NO_SERVER, "The DBus service LifecycleControl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CheckLucRequired", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifecycleControlProxy> proxyShared = ::boost::static_pointer_cast<LifecycleControlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CheckLucRequiredCallbackIF*) _callback)->onCheckLucRequiredError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& LifecycleControlProxyCallback::_logger (LifecycleControlProxy::_logger);

LifecycleControlProxy::LifecycleControlProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.genivi.NodeStateManager.LifecycleControl", serviceAvailable, _logger) {
}

LifecycleControlProxy::~LifecycleControlProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< LifecycleControlProxy > LifecycleControlProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<LifecycleControlProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< LifecycleControlProxy > proxyNew(new LifecycleControlProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t LifecycleControlProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    LifecycleControlProxyCallback* callback = new LifecycleControlProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t LifecycleControlProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    LifecycleControlProxyCallback* callback = new LifecycleControlProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t LifecycleControlProxy::sendRequestNodeRestartRequest(RequestNodeRestartCallbackIF& cb, ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e restartReason, uint32 restartType) const {
    RequestNodeRestartRequest* payload = new RequestNodeRestartRequest();
    CHECK_ALLOCATION(payload);
    payload->setRestartReason(restartReason);
    payload->setRestartType(restartType);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestNodeRestart", RequestNodeRestartRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestNodeRestart, dbusMessage.getUniqueSerial(), "RequestNodeRestart", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestNodeRestart", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LifecycleControlProxy::sendSetApplicationModeRequest(SetApplicationModeCallbackIF& cb, ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e applicationModeId) const {
    SetApplicationModeRequest* payload = new SetApplicationModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setApplicationModeId(applicationModeId);
    DBUS_MESSAGE_CALL(dbusMessage, "SetApplicationMode", SetApplicationModeRequest, payload, true)
    act_t act = addMethodCallback(ID_SetApplicationMode, dbusMessage.getUniqueSerial(), "SetApplicationMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetApplicationMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LifecycleControlProxy::sendSetNodeStateRequest(SetNodeStateCallbackIF& cb, ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e nodeStateId) const {
    SetNodeStateRequest* payload = new SetNodeStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setNodeStateId(nodeStateId);
    DBUS_MESSAGE_CALL(dbusMessage, "SetNodeState", SetNodeStateRequest, payload, true)
    act_t act = addMethodCallback(ID_SetNodeState, dbusMessage.getUniqueSerial(), "SetNodeState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetNodeState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LifecycleControlProxy::sendSetBootModeRequest(SetBootModeCallbackIF& cb, int32 bootMode) const {
    SetBootModeRequest* payload = new SetBootModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setBootMode(bootMode);
    DBUS_MESSAGE_CALL(dbusMessage, "SetBootMode", SetBootModeRequest, payload, true)
    act_t act = addMethodCallback(ID_SetBootMode, dbusMessage.getUniqueSerial(), "SetBootMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetBootMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LifecycleControlProxy::sendSetAppHealthStatusRequest(SetAppHealthStatusCallbackIF& cb, const ::std::string& appName, bool appRunning) const {
    SetAppHealthStatusRequest* payload = new SetAppHealthStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setAppName(appName);
    payload->setAppRunning(appRunning);
    DBUS_MESSAGE_CALL(dbusMessage, "SetAppHealthStatus", SetAppHealthStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_SetAppHealthStatus, dbusMessage.getUniqueSerial(), "SetAppHealthStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetAppHealthStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LifecycleControlProxy::sendCheckLucRequiredRequest(CheckLucRequiredCallbackIF& cb) const {
    CheckLucRequiredRequest* payload = new CheckLucRequiredRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "CheckLucRequired", CheckLucRequiredRequest, payload, true)
    act_t act = addMethodCallback(ID_CheckLucRequired, dbusMessage.getUniqueSerial(), "CheckLucRequired", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CheckLucRequired", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace LifecycleControl
} // namespace NodeStateManager
} // namespace genivi
} // namespace org
