/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumer.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumerDBus.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumerJson.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumerStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifeCycleConsumer {

DEFINE_CLASS_LOGGER("/org/genivi/NodeStateManager/org/genivi/NodeStateManager/LifeCycleConsumer", LifeCycleConsumerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 16, "LifecycleRequest", 0 },
};


class LifeCycleConsumerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    LifeCycleConsumerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    LifeCycleConsumerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    LifeCycleConsumerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.genivi.NodeStateManager.LifeCycleConsumer"),
          _logger(logger) {}

    virtual ~LifeCycleConsumerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void LifeCycleConsumerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'LifecycleRequest'

            LOG_DEBUG_STUB("process method '%s'", "LifecycleRequest");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "LifecycleRequest", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< LifecycleRequestRequest > payload = ::boost::static_pointer_cast<LifecycleRequestRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifeCycleConsumerStub*>(getStub())->onLifecycleRequestRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* LifeCycleConsumerStubDelegate::introspect() const {
    return     "<interface name=\"org.genivi.NodeStateManager.LifeCycleConsumer\">\n"
            "    <method name=\"LifecycleRequest\">\n"
            "      <doc>\n"
            "        <line>LifecycleRequest = LifecycleRequest:</line>\n"
            "        <line>Request:     The type of the life cycle request. Can be NSM_SHUTDOWNTYPE_RUNUP, NSM_SHUTDOWNTYPE_NORMAL or NSM_SHUTDOWNTYPE_FAST.</line>\n"
            "        <line>RequestId:   The Id of the client (current request). This Id needs to be passed to the NSM again via the interface &quot;LifecycleRequestComplete&quot;,</line>\n"
            "        <line>when the client has processed the &quot;LifecycleRequest&quot;.</line>\n"
            "        <line>ErrorCode:   Client's return value, passed to the NodeStateManager. Based upon NsmErrorStatus_e. NsmErrorStatus_Ok:</line>\n"
            "        <line>Request was successfully processed. NsmErrorStatus_ResponsePending: Processing of request started.</line>\n"
            "        <line>LifecycleRequestComplete will be called to pass the status after completion. NsmErrorStatus_Error: An error occured, the request could not be processed.</line>\n"
            "        <line></line>\n"
            "        <line>The method has to be implemented by every life cycle client and is called by the NodeStateManager,</line>\n"
            "        <line>when the node is shutting down (fast or normal) or an ongoing shutdown is cancelled (run up)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Request\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Request = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"RequestId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>RequestId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void LifeCycleConsumerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<LifeCycleConsumerStub*>(getStub()))->onGetAll (properties);
}

void LifeCycleConsumerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void LifeCycleConsumerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

LifeCycleConsumerStub::LifeCycleConsumerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LifeCycleConsumerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LifeCycleConsumerStub::LifeCycleConsumerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LifeCycleConsumerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LifeCycleConsumerStub::~LifeCycleConsumerStub() {
    delete _stubDelegate;
}

void  LifeCycleConsumerStub::sendLifecycleRequestResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    LifecycleRequestResponse* payload = new LifecycleRequestResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "LifecycleRequest", LifecycleRequestResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "LifecycleRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifeCycleConsumerStub::sendLifecycleRequestError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    LifecycleRequestError* payload = new LifecycleRequestError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "LifecycleRequest", LifecycleRequestError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "LifecycleRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void LifeCycleConsumerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace LifeCycleConsumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org
