/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_LCMBASICTYPESCONST_H
#define ORG_GENIVI_NODESTATEMANAGER_LCMBASICTYPESCONST_H

#include <cstddef>

/**
 * org.genivi.NodeStateManager.LCMBasicTypes:
 *
 *                     short_description: LCM Type collection for the NodeStateManager.
 */

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LcmBasicTypes {

/**
 * The enumeration defines the different node states
 */
enum _NsmNodeState_e {

    /**
     * Initial state when node state is not set
     */
    _NsmNodeState_e__NsmNodeState_NotSet,
    /**
     * Basic system is starting up
     */
    _NsmNodeState_e__NsmNodeState_StartUp,
    /**
     * Basic system components have been started
     */
    _NsmNodeState_e__NsmNodeState_BaseRunning,
    /**
     * All 'Last user context' components have been started
     */
    _NsmNodeState_e__NsmNodeState_LucRunning,
    /**
     * All 'foreground' components have been started
     */
    _NsmNodeState_e__NsmNodeState_FullyRunning,
    /**
     * All components have been started
     */
    _NsmNodeState_e__NsmNodeState_FullyOperational,
    /**
     * The system is shutting down
     */
    _NsmNodeState_e__NsmNodeState_ShuttingDown,
    /**
     * Shutdown request active. System will shutdown soon
     */
    _NsmNodeState_e__NsmNodeState_ShutdownDelay,
    /**
     * Fast shutdown active
     */
    _NsmNodeState_e__NsmNodeState_FastShutdown,
    /**
     * Node is in degraded power state
     */
    _NsmNodeState_e__NsmNodeState_DegradedPower,
    /**
     * Node is completely shut down
     */
    _NsmNodeState_e__NsmNodeState_Shutdown,
    /**
     * Last valid entry to identify valid node states
     */
    _NsmNodeState_e__NsmNodeState_Last

};

bool _NsmNodeState_e_Parse (const char *str, size_t length, _NsmNodeState_e &value);

const char* _NsmNodeState_e_Name (_NsmNodeState_e value);

bool _NsmNodeState_e_IsValid (_NsmNodeState_e value);

/**
 * Possible application modes of the node.
 */
enum _NsmApplicationMode_e {

    /**
     * Initial state
     */
    _NsmApplicationMode_e__NsmApplicationMode_NotSet,
    /**
     * Parking mode
     */
    _NsmApplicationMode_e__NsmApplicationMode_Parking,
    /**
     * Factory mode
     */
    _NsmApplicationMode_e__NsmApplicationMode_Factory,
    /**
     * Transport  mode
     */
    _NsmApplicationMode_e__NsmApplicationMode_Transport,
    /**
     * Normal  mode
     */
    _NsmApplicationMode_e__NsmApplicationMode_Normal,
    /**
     * Software loading mode
     */
    _NsmApplicationMode_e__NsmApplicationMode_Swl,
    /**
     * Last value to identify valid values
     */
    _NsmApplicationMode_e__NsmApplicationMode_Last

};

bool _NsmApplicationMode_e_Parse (const char *str, size_t length, _NsmApplicationMode_e &value);

const char* _NsmApplicationMode_e_Name (_NsmApplicationMode_e value);

bool _NsmApplicationMode_e_IsValid (_NsmApplicationMode_e value);

/**
 * The enumeration defines the different restart reasons.
 */
enum _NsmRestartReason_e {

    /**
     * Initial value when reset reason is not set
     */
    _NsmRestartReason_e__NsmRestartReason_NotSet,
    /**
     * Reset was requested by System Health Mon.
     */
    _NsmRestartReason_e__NsmRestartReason_ApplicationFailure,
    /**
     * Reset was requested by diagnosis
     */
    _NsmRestartReason_e__NsmRestartReason_Diagnosis,
    /**
     * Reset was requested by the SWL application
     */
    _NsmRestartReason_e__NsmRestartReason_Swl,
    /**
     * Reset was requested by an user application
     */
    _NsmRestartReason_e__NsmRestartReason_User,
    /**
     * Last value to identify valid reset reasons
     */
    _NsmRestartReason_e__NsmRestartReason_Last

};

bool _NsmRestartReason_e_Parse (const char *str, size_t length, _NsmRestartReason_e &value);

const char* _NsmRestartReason_e_Name (_NsmRestartReason_e value);

bool _NsmRestartReason_e_IsValid (_NsmRestartReason_e value);

/**
 * The enumeration defines the different shutdown reasons.
 */
enum _NsmShutdownReason_e {

    /**
     * Initial value when ShutdownReason not set
     */
    _NsmShutdownReason_e__NsmShutdownReason_NotSet,
    /**
     * A normal shutdown has been performed
     */
    _NsmShutdownReason_e__NsmShutdownReason_Normal,
    /**
     * Shutdown because of bad supply
     */
    _NsmShutdownReason_e__NsmShutdownReason_SupplyBad,
    /**
     * Shutdown because of poor supply
     */
    _NsmShutdownReason_e__NsmShutdownReason_SupplyPoor,
    /**
     * Shutdown because of bad thermal state
     */
    _NsmShutdownReason_e__NsmShutdownReason_ThermalBad,
    /**
     * Shutdown because of poor thermal state
     */
    _NsmShutdownReason_e__NsmShutdownReason_ThermalPoor,
    /**
     * Shutdown after software loading
     */
    _NsmShutdownReason_e__NsmShutdownReason_SwlNotActive,
    /**
     * Last value. Identify valid ShutdownReasons
     */
    _NsmShutdownReason_e__NsmShutdownReason_Last

};

bool _NsmShutdownReason_e_Parse (const char *str, size_t length, _NsmShutdownReason_e &value);

const char* _NsmShutdownReason_e_Name (_NsmShutdownReason_e value);

bool _NsmShutdownReason_e_IsValid (_NsmShutdownReason_e value);

/**
 * The enumeration defines the different start or wake up reasons.
 */
enum _NsmRunningReason_e {

    /**
     * Initial value when reason is not set.
     */
    _NsmRunningReason_e__NsmRunningReason_NotSet,
    /**
     * Wake up because of CAN activity
     */
    _NsmRunningReason_e__NsmRunningReason_WakeupCan,
    /**
     * Wake up because of 'Eject' button
     */
    _NsmRunningReason_e__NsmRunningReason_WakeupMediaEject,
    /**
     * Wake up because of media insertion
     */
    _NsmRunningReason_e__NsmRunningReason_WakeupMediaInsertion,
    /**
     * Wake up because of user uses the HEVAC unit in the car.
     *         Even if the HEVAC actually causes activity on the CAN bus a different wakeup reason is required as it could result in a
     *         different level of functionality being started
     */
    _NsmRunningReason_e__NsmRunningReason_WakeupHevac,
    /**
     * Wake up because of a phone call being received.
     *                Even if this is passed as a CAN event a different wakeup reason  is required as it could result in a different level of
     *                functionality being started
     */
    _NsmRunningReason_e__NsmRunningReason_WakeupPhone,
    /**
     * Startup because user presses the "Power ON" button in the car.
     *                 Even if this is passed as a CAN event a different wakeup reason  is required as it could result in a different level of
     *                 functionality being started
     */
    _NsmRunningReason_e__NsmRunningReason_WakeupPowerOnButton,
    /**
     * System was started due to a first switch to power
     */
    _NsmRunningReason_e__NsmRunningReason_StartupFstp,
    /**
     * System was switched to power
     */
    _NsmRunningReason_e__NsmRunningReason_StartupSwitchToPower,
    /**
     * System was restarted due to an internal SW Request
     *                                                         (i.e. SWL or Diagnosis)
     */
    _NsmRunningReason_e__NsmRunningReason_RestartSwRequest,
    /**
     * System was restarted due to an internal health problem
     */
    _NsmRunningReason_e__NsmRunningReason_RestartInternalHealth,
    /**
     * System was restarted due to an external health problem
     *                                                         (i.e. external wdog believed node was in failure)
     */
    _NsmRunningReason_e__NsmRunningReason_RestartExternalHealth,
    /**
     * System was restarted due to an unexpected kernel restart.
     *                            This will be the default catch when no other reason is known
     */
    _NsmRunningReason_e__NsmRunningReason_RestartUnexpected,
    /**
     * Target was reset due to user action (i.e user 3 finger press)
     */
    _NsmRunningReason_e__NsmRunningReason_RestartUser,
    /**
     * Last value (127) to identify where the platform defines end
     *                              (product will start from here on)
     */
    _NsmRunningReason_e__NsmRunningReason_PlatformEnd = 127u,
    /**
     * product will start from here with index 0
     *             NsmRunningReason_ProductOffset = "NsmRunningReason_PlatformEnd  + 1"
     * 			ASF generation error so changed it to 0x80 .
     */
    _NsmRunningReason_e__NsmRunningReason_ProductOffset = 128u

};

bool _NsmRunningReason_e_Parse (const char *str, size_t length, _NsmRunningReason_e &value);

const char* _NsmRunningReason_e_Name (_NsmRunningReason_e value);

bool _NsmRunningReason_e_IsValid (_NsmRunningReason_e value);

/**
 * _Nsm_Shutdown_Type_e
 */
enum _Nsm_Shutdown_Type_e {

    /**
     * Client not registered for any shutdown
     */
    _Nsm_Shutdown_Type_e__Nsm_Shutdown_Type_Not = 0u,
    /**
     * Client registered for normal shutdown
     */
    _Nsm_Shutdown_Type_e__Nsm_Shutdown_Type_Normal = 1u,
    /**
     * Client registered for fast shutdown
     */
    _Nsm_Shutdown_Type_e__NSM_Shutdown_Type_Fast = 2u,
    /**
     * The shutdown type "run up" can not be used for
     *              registration. Clients which are registered and have been shut down, will automatically be
     *              informed about the "run up", when the shut down is canceled.
     */
    _Nsm_Shutdown_Type_e__NSM_Shutdown_Type_Runup = 2147483648u

};

bool _Nsm_Shutdown_Type_e_Parse (const char *str, size_t length, _Nsm_Shutdown_Type_e &value);

const char* _Nsm_Shutdown_Type_e_Name (_Nsm_Shutdown_Type_e value);

bool _Nsm_Shutdown_Type_e_IsValid (_Nsm_Shutdown_Type_e value);

} // namespace LcmBasicTypes
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_LCMBASICTYPESCONST_H
