/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_CONSUMERSTUB_H
#define ORG_GENIVI_NODESTATEMANAGER_CONSUMERSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/Consumer.h"
#include "org/genivi/NodeStateManager/ConsumerConst.h"
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include <string>

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace Consumer {

class ConsumerStubDelegate;

class ConsumerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ConsumerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ConsumerStub (const std::string& portName);

    /**
     * Create an instance of the ConsumerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ConsumerStub (const std::string& portName, const std::string& objectPath);

    virtual ~ConsumerStub();

    // signal 'NodeState'

    /**
     * Raise the signal 'NodeState' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'NodeState'</b>:
     *
     * NodeState:
     * 	   NodeState: Numeric value for the current NodeState defined in NsmNodeState_e.
     *
     * 	   Clients can register for notifications when the NodeState is updated inside the NodeStateManager.
     * 	   This signal is sent to registered clients and will include the current NodeState as a parameter.
     *
     * @param NodeState If the meaning of "NodeState" isn't clear, then there should be a description here.
     */
    void sendNodeStateSignal(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e nodeState);

    // signal 'NodeApplicationMode'

    /**
     * Raise the signal 'NodeApplicationMode' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'NodeApplicationMode'</b>:
     *
     * NodeApplicationMode:
     * 	   ApplicationModeId: Numeric value for the current ApplicationMode defined in NsmAplicationMode_e.
     *
     * 	   Clients can register for notifications when the NodeApplicationMode is updated inside the NodeStateManager.
     * 	   This signal is sent to registered clients and will include the current NodeApplicationMode as a parameter.
     *
     * @param ApplicationModeId If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     */
    void sendNodeApplicationModeSignal(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e applicationModeId);

    // signal 'SessionStateChanged'

    /**
     * Raise the signal 'SessionStateChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SessionStateChanged'</b>:
     *
     * SessionStateChanged:
     *     	SessionStateName: The SessionName will be based upon either the pre-defined platform SessionNames or using a newly added product defined session name.
     *     	SeatID:           This parameter will be based upon the enum NsmSeat_e.
     *     	SessionState:     This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     	                  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
     *
     *     	This signal is sent to registered clients when a particular session is state is changed.
     *     	The client can register for notification about a specific session through the use of the SessionName as a "match rule".
     *
     * @param SessionStateName If the meaning of "SessionStateName" isn't clear, then there should be a description here.
     *
     * @param SeatID If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @param SessionState If the meaning of "SessionState" isn't clear, then there should be a description here.
     */
    void sendSessionStateChangedSignal(const ::std::string& sessionStateName, _NsmSeat_e seatID, _NsmSessionState_e sessionState);

    // property 'RestartReason'

    /**
     * The method onRestartReasonGet() is called by ASF when a client invokes
     * the read method for the property 'RestartReason'. The
     * onRestartReasonGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RestartReason'</b>:
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     */
    virtual void onRestartReasonGet(const ::boost::shared_ptr< RestartReasonGet >& payload);

    /**
     * Sends back the update to a previous onRestartReasonGet().
     *
     * <b>Documentation of 'RestartReason'</b>:
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     *
     * @param act Identifies a previous invocation of onRestartReasonGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRestartReasonGetUpdate(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e restartReason, act_t act = 0);

    /**
     * Set the value of the property 'RestartReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RestartReason'</b>:
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     */
    void setRestartReason(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e restartReason);

    /**
     * Returns the current value of the property 'RestartReason'.
     *
     * <b>Documentation of 'RestartReason'</b>:
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     */
    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e getRestartReason() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRestartReasonUpdate().
     *
     * <b>Documentation of 'RestartReason'</b>:
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     */
    void sendRestartReasonUpdate();

    // property 'ShutdownReason'

    /**
     * The method onShutdownReasonGet() is called by ASF when a client invokes
     * the read method for the property 'ShutdownReason'. The
     * onShutdownReasonGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ShutdownReason'</b>:
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     */
    virtual void onShutdownReasonGet(const ::boost::shared_ptr< ShutdownReasonGet >& payload);

    /**
     * Sends back the update to a previous onShutdownReasonGet().
     *
     * <b>Documentation of 'ShutdownReason'</b>:
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     *
     * @param act Identifies a previous invocation of onShutdownReasonGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendShutdownReasonGetUpdate(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e shutdownReason, act_t act = 0);

    /**
     * Set the value of the property 'ShutdownReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ShutdownReason'</b>:
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     */
    void setShutdownReason(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e shutdownReason);

    /**
     * Returns the current value of the property 'ShutdownReason'.
     *
     * <b>Documentation of 'ShutdownReason'</b>:
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     */
    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e getShutdownReason() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendShutdownReasonUpdate().
     *
     * <b>Documentation of 'ShutdownReason'</b>:
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     */
    void sendShutdownReasonUpdate();

    // property 'WakeUpReason'

    /**
     * The method onWakeUpReasonGet() is called by ASF when a client invokes
     * the read method for the property 'WakeUpReason'. The
     * onWakeUpReasonGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'WakeUpReason'</b>:
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     */
    virtual void onWakeUpReasonGet(const ::boost::shared_ptr< WakeUpReasonGet >& payload);

    /**
     * Sends back the update to a previous onWakeUpReasonGet().
     *
     * <b>Documentation of 'WakeUpReason'</b>:
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     *
     * @param act Identifies a previous invocation of onWakeUpReasonGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWakeUpReasonGetUpdate(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e wakeUpReason, act_t act = 0);

    /**
     * Set the value of the property 'WakeUpReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WakeUpReason'</b>:
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     */
    void setWakeUpReason(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e wakeUpReason);

    /**
     * Returns the current value of the property 'WakeUpReason'.
     *
     * <b>Documentation of 'WakeUpReason'</b>:
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     */
    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e getWakeUpReason() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWakeUpReasonUpdate().
     *
     * <b>Documentation of 'WakeUpReason'</b>:
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     */
    void sendWakeUpReasonUpdate();

    // property 'BootMode'

    /**
     * The method onBootModeGet() is called by ASF when a client invokes the
     * read method for the property 'BootMode'. The onBootModeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'BootMode'</b>:
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     */
    virtual void onBootModeGet(const ::boost::shared_ptr< BootModeGet >& payload);

    /**
     * Sends back the update to a previous onBootModeGet().
     *
     * <b>Documentation of 'BootMode'</b>:
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     *
     * @param act Identifies a previous invocation of onBootModeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendBootModeGetUpdate(int32 bootMode, act_t act = 0);

    /**
     * Set the value of the property 'BootMode' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'BootMode'</b>:
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     */
    void setBootMode(int32 bootMode);

    /**
     * Returns the current value of the property 'BootMode'.
     *
     * <b>Documentation of 'BootMode'</b>:
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     */
    int32 getBootMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBootModeUpdate().
     *
     * <b>Documentation of 'BootMode'</b>:
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     */
    void sendBootModeUpdate();

    // method 'GetNodeState'

    /**
     * The method onGetNodeState() is called by ASF when a client invokes the
     * method 'GetNodeState'. A subclass has to implement this method and send
     * back a response to the client either with the sendGetNodeState() or
     * sendGetNodeStateError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetNodeState'</b>:
     *
     * GetNodeState:
     *     	NodeStateId: Will be based on the NsmNodeState_e.
     *     	ErrorCode:   Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to get the NodeState without the need of registration to the signal.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetNodeStateRequest (const ::boost::shared_ptr< GetNodeStateRequest >& request) = 0;

    /**
     * The method sendGetNodeStateResponse() sends a response of a previous
     * method invocation of 'GetNodeState' back to the client.
     *
     * <b>Documentation of 'GetNodeState'</b>:
     *
     * GetNodeState:
     *     	NodeStateId: Will be based on the NsmNodeState_e.
     *     	ErrorCode:   Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to get the NodeState without the need of registration to the signal.
     *
     * @param NodeStateId If the meaning of "NodeStateId" isn't clear, then there should be a description here.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetNodeState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetNodeStateResponse (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e nodeStateId, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendGetNodeStateError() sends an error response of a
     * previous method invocation of 'GetNodeState' back to the client.
     *
     * <b>Documentation of 'GetNodeState'</b>:
     *
     * GetNodeState:
     *     	NodeStateId: Will be based on the NsmNodeState_e.
     *     	ErrorCode:   Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to get the NodeState without the need of registration to the signal.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetNodeState(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetNodeStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetSessionState'

    /**
     * The method onSetSessionState() is called by ASF when a client invokes
     * the method 'SetSessionState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetSessionState() or sendSetSessionStateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'SetSessionState'</b>:
     *
     * SetSessionState:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform SessionNames (see NSM content page) or using a newly added product defined session name.
     *     	SessionOwner: This parameter defines the name of the application that is setting the state of the session. This must be the applications systemd unit filename.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by applications to set the state of a session.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetSessionStateRequest (const ::boost::shared_ptr< SetSessionStateRequest >& request) = 0;

    /**
     * The method sendSetSessionStateResponse() sends a response of a previous
     * method invocation of 'SetSessionState' back to the client.
     *
     * <b>Documentation of 'SetSessionState'</b>:
     *
     * SetSessionState:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform SessionNames (see NSM content page) or using a newly added product defined session name.
     *     	SessionOwner: This parameter defines the name of the application that is setting the state of the session. This must be the applications systemd unit filename.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by applications to set the state of a session.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetSessionState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetSessionStateResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendSetSessionStateError() sends an error response of a
     * previous method invocation of 'SetSessionState' back to the client.
     *
     * <b>Documentation of 'SetSessionState'</b>:
     *
     * SetSessionState:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform SessionNames (see NSM content page) or using a newly added product defined session name.
     *     	SessionOwner: This parameter defines the name of the application that is setting the state of the session. This must be the applications systemd unit filename.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by applications to set the state of a session.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetSessionState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetSessionStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetSessionState'

    /**
     * The method onGetSessionState() is called by ASF when a client invokes
     * the method 'GetSessionState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetSessionState() or sendGetSessionStateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'GetSessionState'</b>:
     *
     * GetSessionState:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by applications to get the state of a session.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetSessionStateRequest (const ::boost::shared_ptr< GetSessionStateRequest >& request) = 0;

    /**
     * The method sendGetSessionStateResponse() sends a response of a previous
     * method invocation of 'GetSessionState' back to the client.
     *
     * <b>Documentation of 'GetSessionState'</b>:
     *
     * GetSessionState:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by applications to get the state of a session.
     *
     * @param SessionState If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetSessionState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetSessionStateResponse (_NsmSessionState_e sessionState, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendGetSessionStateError() sends an error response of a
     * previous method invocation of 'GetSessionState' back to the client.
     *
     * <b>Documentation of 'GetSessionState'</b>:
     *
     * GetSessionState:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by applications to get the state of a session.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetSessionState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetSessionStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetApplicationMode'

    /**
     * The method onGetApplicationMode() is called by ASF when a client
     * invokes the method 'GetApplicationMode'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetApplicationMode() or sendGetApplicationModeError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'GetApplicationMode'</b>:
     *
     * GetApplicationMode:
     * 	    ApplicationModeId:This parameter will be based upon the NsmNodeApplicationMode_e.
     * 	    ErrorCode:        Return value passed to the caller based upon NsmErrorStatus_e.
     *
     * 	The method is used by other applications to get the application mode.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetApplicationModeRequest (const ::boost::shared_ptr< GetApplicationModeRequest >& request) = 0;

    /**
     * The method sendGetApplicationModeResponse() sends a response of a
     * previous method invocation of 'GetApplicationMode' back to the client.
     *
     * <b>Documentation of 'GetApplicationMode'</b>:
     *
     * GetApplicationMode:
     * 	    ApplicationModeId:This parameter will be based upon the NsmNodeApplicationMode_e.
     * 	    ErrorCode:        Return value passed to the caller based upon NsmErrorStatus_e.
     *
     * 	The method is used by other applications to get the application mode.
     *
     * @param ApplicationModeId If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetApplicationMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetApplicationModeResponse (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e applicationModeId, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendGetApplicationModeError() sends an error response of a
     * previous method invocation of 'GetApplicationMode' back to the client.
     *
     * <b>Documentation of 'GetApplicationMode'</b>:
     *
     * GetApplicationMode:
     * 	    ApplicationModeId:This parameter will be based upon the NsmNodeApplicationMode_e.
     * 	    ErrorCode:        Return value passed to the caller based upon NsmErrorStatus_e.
     *
     * 	The method is used by other applications to get the application mode.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetApplicationMode().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetApplicationModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RegisterShutdownClient'

    /**
     * The method onRegisterShutdownClient() is called by ASF when a client
     * invokes the method 'RegisterShutdownClient'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendRegisterShutdownClient() or
     * sendRegisterShutdownClientError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'RegisterShutdownClient'</b>:
     *
     * RegisterShutdownClient:
     *     	BusName:      Bus name of remote application.
     *     	ObjName:      Object name of remote object that provides the shutdown interface.
     *     	ShutdownMode: Shutdown mode for which client wants to be informed (i.e normal fast etc).
     *     	TimeoutMs:    Max. Timeout to wait for response from shutdown client in ms.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to register themselves as shutdown client.
     *     	Any client that registers must provide a method in their D-Bus object called "LifecycleRequest".
     *     	This method will take one parameter which is the RequestType (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
     *     	For an example of the required client interface please see the BootManager component who will be a client of the NSM.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterShutdownClientRequest (const ::boost::shared_ptr< RegisterShutdownClientRequest >& request) = 0;

    /**
     * The method sendRegisterShutdownClientResponse() sends a response of a
     * previous method invocation of 'RegisterShutdownClient' back to the
     * client.
     *
     * <b>Documentation of 'RegisterShutdownClient'</b>:
     *
     * RegisterShutdownClient:
     *     	BusName:      Bus name of remote application.
     *     	ObjName:      Object name of remote object that provides the shutdown interface.
     *     	ShutdownMode: Shutdown mode for which client wants to be informed (i.e normal fast etc).
     *     	TimeoutMs:    Max. Timeout to wait for response from shutdown client in ms.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to register themselves as shutdown client.
     *     	Any client that registers must provide a method in their D-Bus object called "LifecycleRequest".
     *     	This method will take one parameter which is the RequestType (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
     *     	For an example of the required client interface please see the BootManager component who will be a client of the NSM.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterShutdownClient(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRegisterShutdownClientResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendRegisterShutdownClientError() sends an error response of
     * a previous method invocation of 'RegisterShutdownClient' back to the
     * client.
     *
     * <b>Documentation of 'RegisterShutdownClient'</b>:
     *
     * RegisterShutdownClient:
     *     	BusName:      Bus name of remote application.
     *     	ObjName:      Object name of remote object that provides the shutdown interface.
     *     	ShutdownMode: Shutdown mode for which client wants to be informed (i.e normal fast etc).
     *     	TimeoutMs:    Max. Timeout to wait for response from shutdown client in ms.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to register themselves as shutdown client.
     *     	Any client that registers must provide a method in their D-Bus object called "LifecycleRequest".
     *     	This method will take one parameter which is the RequestType (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
     *     	For an example of the required client interface please see the BootManager component who will be a client of the NSM.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRegisterShutdownClient(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRegisterShutdownClientError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnRegisterShutdownClient'

    /**
     * The method onUnRegisterShutdownClient() is called by ASF when a client
     * invokes the method 'UnRegisterShutdownClient'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendUnRegisterShutdownClient() or
     * sendUnRegisterShutdownClientError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'UnRegisterShutdownClient'</b>:
     *
     * UnRegisterShutdownClient:
     *     	BusName:      Bus name of remote application.
     *     	ObjName:      Object name of remote object that provides the shutdown interface.
     *     	ShutdownMode: Shutdown mode for which client wants to unregister (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to unregister themselves as shutdown client.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnRegisterShutdownClientRequest (const ::boost::shared_ptr< UnRegisterShutdownClientRequest >& request) = 0;

    /**
     * The method sendUnRegisterShutdownClientResponse() sends a response of a
     * previous method invocation of 'UnRegisterShutdownClient' back to the
     * client.
     *
     * <b>Documentation of 'UnRegisterShutdownClient'</b>:
     *
     * UnRegisterShutdownClient:
     *     	BusName:      Bus name of remote application.
     *     	ObjName:      Object name of remote object that provides the shutdown interface.
     *     	ShutdownMode: Shutdown mode for which client wants to unregister (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to unregister themselves as shutdown client.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnRegisterShutdownClient(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnRegisterShutdownClientResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendUnRegisterShutdownClientError() sends an error response
     * of a previous method invocation of 'UnRegisterShutdownClient' back to
     * the client.
     *
     * <b>Documentation of 'UnRegisterShutdownClient'</b>:
     *
     * UnRegisterShutdownClient:
     *     	BusName:      Bus name of remote application.
     *     	ObjName:      Object name of remote object that provides the shutdown interface.
     *     	ShutdownMode: Shutdown mode for which client wants to unregister (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to unregister themselves as shutdown client.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onUnRegisterShutdownClient(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnRegisterShutdownClientError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RegisterSession'

    /**
     * The method onRegisterSession() is called by ASF when a client invokes
     * the method 'RegisterSession'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRegisterSession() or sendRegisterSessionError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'RegisterSession'</b>:
     *
     * RegisterSession:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SessionOwner: This is the name of the application that is registering the new session (this must be the applications systemd unit filename).
     *     	SeatID:       This parameter will be based upon the enum NsmSeatId_e
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     	              The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to register a new session whose state should be observed and distributed by the NSM..
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterSessionRequest (const ::boost::shared_ptr< RegisterSessionRequest >& request) = 0;

    /**
     * The method sendRegisterSessionResponse() sends a response of a previous
     * method invocation of 'RegisterSession' back to the client.
     *
     * <b>Documentation of 'RegisterSession'</b>:
     *
     * RegisterSession:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SessionOwner: This is the name of the application that is registering the new session (this must be the applications systemd unit filename).
     *     	SeatID:       This parameter will be based upon the enum NsmSeatId_e
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     	              The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to register a new session whose state should be observed and distributed by the NSM..
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRegisterSessionResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendRegisterSessionError() sends an error response of a
     * previous method invocation of 'RegisterSession' back to the client.
     *
     * <b>Documentation of 'RegisterSession'</b>:
     *
     * RegisterSession:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SessionOwner: This is the name of the application that is registering the new session (this must be the applications systemd unit filename).
     *     	SeatID:       This parameter will be based upon the enum NsmSeatId_e
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     	              The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to register a new session whose state should be observed and distributed by the NSM..
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegisterSession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRegisterSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnRegisterSession'

    /**
     * The method onUnRegisterSession() is called by ASF when a client invokes
     * the method 'UnRegisterSession'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendUnRegisterSession() or sendUnRegisterSessionError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'UnRegisterSession'</b>:
     *
     * UnRegisterSession:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SessionOwner: This is the name of the application that originally registered the session.
     *     	              It will be validated that this value matches the stored value from the registration.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to remove a new session from the session list hosted by NSM.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnRegisterSessionRequest (const ::boost::shared_ptr< UnRegisterSessionRequest >& request) = 0;

    /**
     * The method sendUnRegisterSessionResponse() sends a response of a
     * previous method invocation of 'UnRegisterSession' back to the client.
     *
     * <b>Documentation of 'UnRegisterSession'</b>:
     *
     * UnRegisterSession:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SessionOwner: This is the name of the application that originally registered the session.
     *     	              It will be validated that this value matches the stored value from the registration.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to remove a new session from the session list hosted by NSM.
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnRegisterSession(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnRegisterSessionResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendUnRegisterSessionError() sends an error response of a
     * previous method invocation of 'UnRegisterSession' back to the client.
     *
     * <b>Documentation of 'UnRegisterSession'</b>:
     *
     * UnRegisterSession:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SessionOwner: This is the name of the application that originally registered the session.
     *     	              It will be validated that this value matches the stored value from the registration.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to remove a new session from the session list hosted by NSM.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnRegisterSession().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnRegisterSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetAppHealthCount'

    /**
     * The method onGetAppHealthCount() is called by ASF when a client invokes
     * the method 'GetAppHealthCount'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetAppHealthCount() or sendGetAppHealthCountError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'GetAppHealthCount'</b>:
     *
     * GetAppHealthCount:
     *     	Count:        Return value passed to the caller. Number of applications that crashed or terminated accidentally.
     *
     *     	The method returns the number of applications that crashed or terminated accidentally within the current life cycle. It can be used to observe the system state.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetAppHealthCountRequest (const ::boost::shared_ptr< GetAppHealthCountRequest >& request) = 0;

    /**
     * The method sendGetAppHealthCountResponse() sends a response of a
     * previous method invocation of 'GetAppHealthCount' back to the client.
     *
     * <b>Documentation of 'GetAppHealthCount'</b>:
     *
     * GetAppHealthCount:
     *     	Count:        Return value passed to the caller. Number of applications that crashed or terminated accidentally.
     *
     *     	The method returns the number of applications that crashed or terminated accidentally within the current life cycle. It can be used to observe the system state.
     *
     * @param Count If the meaning of "Count" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetAppHealthCount(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetAppHealthCountResponse (uint32 count, act_t act = 0);

    /**
     * The method sendGetAppHealthCountError() sends an error response of a
     * previous method invocation of 'GetAppHealthCount' back to the client.
     *
     * <b>Documentation of 'GetAppHealthCount'</b>:
     *
     * GetAppHealthCount:
     *     	Count:        Return value passed to the caller. Number of applications that crashed or terminated accidentally.
     *
     *     	The method returns the number of applications that crashed or terminated accidentally within the current life cycle. It can be used to observe the system state.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetAppHealthCount().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetAppHealthCountError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetInterfaceVersion'

    /**
     * The method onGetInterfaceVersion() is called by ASF when a client
     * invokes the method 'GetInterfaceVersion'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetInterfaceVersion() or sendGetInterfaceVersionError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'GetInterfaceVersion'</b>:
     *
     * GetInterfaceVersion:
     *     	Version:      Unsigned integer that represents the version number of the Node State Manager.
     *
     *     	The method returns the version number of the Node State Manager. The number is organized in four bytes:
     *
     *     	Version: VVV.RRR.PPP.BBB
     *
     *     	<literallayout>
     *     		VVV => Version  [1..255]
     *     		RRR => Release  [0..255]
     *     		PPP => Patch    [0..255]
     *     		BBB => Build    [0..255]
     *     	</literallayout>
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetInterfaceVersionRequest (const ::boost::shared_ptr< GetInterfaceVersionRequest >& request) = 0;

    /**
     * The method sendGetInterfaceVersionResponse() sends a response of a
     * previous method invocation of 'GetInterfaceVersion' back to the client.
     *
     * <b>Documentation of 'GetInterfaceVersion'</b>:
     *
     * GetInterfaceVersion:
     *     	Version:      Unsigned integer that represents the version number of the Node State Manager.
     *
     *     	The method returns the version number of the Node State Manager. The number is organized in four bytes:
     *
     *     	Version: VVV.RRR.PPP.BBB
     *
     *     	<literallayout>
     *     		VVV => Version  [1..255]
     *     		RRR => Release  [0..255]
     *     		PPP => Patch    [0..255]
     *     		BBB => Build    [0..255]
     *     	</literallayout>
     *
     * @param Version If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetInterfaceVersion(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetInterfaceVersionResponse (uint32 version, act_t act = 0);

    /**
     * The method sendGetInterfaceVersionError() sends an error response of a
     * previous method invocation of 'GetInterfaceVersion' back to the client.
     *
     * <b>Documentation of 'GetInterfaceVersion'</b>:
     *
     * GetInterfaceVersion:
     *     	Version:      Unsigned integer that represents the version number of the Node State Manager.
     *
     *     	The method returns the version number of the Node State Manager. The number is organized in four bytes:
     *
     *     	Version: VVV.RRR.PPP.BBB
     *
     *     	<literallayout>
     *     		VVV => Version  [1..255]
     *     		RRR => Release  [0..255]
     *     		PPP => Patch    [0..255]
     *     		BBB => Build    [0..255]
     *     	</literallayout>
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetInterfaceVersion().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetInterfaceVersionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'LifecycleRequestComplete'

    /**
     * The method onLifecycleRequestComplete() is called by ASF when a client
     * invokes the method 'LifecycleRequestComplete'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendLifecycleRequestComplete() or
     * sendLifecycleRequestCompleteError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'LifecycleRequestComplete'</b>:
     *
     * LifecycleRequestComplete:
     *         RequestId:    The request Id of the called life cycle client. The value has been passed when "LifecycleRequest" was called.
     *         Status:       The result of the call to "LifecycleRequest". NsmErrorStatus_Ok: Request successfully processed. NsmErrorStatus_Error:
     *                       An error occured while processing the "LifecycleRequest".
     *         ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *         The function has to be called by a "asynchrounous" lifecycle client when he processed the "LifecycleRequest".
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onLifecycleRequestCompleteRequest (const ::boost::shared_ptr< LifecycleRequestCompleteRequest >& request) = 0;

    /**
     * The method sendLifecycleRequestCompleteResponse() sends a response of a
     * previous method invocation of 'LifecycleRequestComplete' back to the
     * client.
     *
     * <b>Documentation of 'LifecycleRequestComplete'</b>:
     *
     * LifecycleRequestComplete:
     *         RequestId:    The request Id of the called life cycle client. The value has been passed when "LifecycleRequest" was called.
     *         Status:       The result of the call to "LifecycleRequest". NsmErrorStatus_Ok: Request successfully processed. NsmErrorStatus_Error:
     *                       An error occured while processing the "LifecycleRequest".
     *         ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *         The function has to be called by a "asynchrounous" lifecycle client when he processed the "LifecycleRequest".
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onLifecycleRequestComplete(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLifecycleRequestCompleteResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendLifecycleRequestCompleteError() sends an error response
     * of a previous method invocation of 'LifecycleRequestComplete' back to
     * the client.
     *
     * <b>Documentation of 'LifecycleRequestComplete'</b>:
     *
     * LifecycleRequestComplete:
     *         RequestId:    The request Id of the called life cycle client. The value has been passed when "LifecycleRequest" was called.
     *         Status:       The result of the call to "LifecycleRequest". NsmErrorStatus_Ok: Request successfully processed. NsmErrorStatus_Error:
     *                       An error occured while processing the "LifecycleRequest".
     *         ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *         The function has to be called by a "asynchrounous" lifecycle client when he processed the "LifecycleRequest".
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onLifecycleRequestComplete(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLifecycleRequestCompleteError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    RestartReasonUpdate _RestartReasonProperty;

    ShutdownReasonUpdate _ShutdownReasonProperty;

    WakeUpReasonUpdate _WakeUpReasonProperty;

    BootModeUpdate _BootModeProperty;

    friend class ConsumerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Consumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_CONSUMERSTUB_H
