/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/Consumer.h"
#include "org/genivi/NodeStateManager/ConsumerConst.h"
#include "org/genivi/NodeStateManager/ConsumerDBus.h"
#include "org/genivi/NodeStateManager/ConsumerJson.h"
#include "org/genivi/NodeStateManager/ConsumerStub.h"
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace Consumer {

DEFINE_CLASS_LOGGER("/org/genivi/NodeStateManager/org/genivi/NodeStateManager/Consumer", ConsumerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 12, "GetNodeState", 0 },
    { 15, "GetSessionState", 2 },
    { 15, "RegisterSession", 6 },
    { 15, "SetSessionState", 1 },
    { 17, "GetAppHealthCount", 8 },
    { 17, "UnRegisterSession", 7 },
    { 18, "GetApplicationMode", 3 },
    { 19, "GetInterfaceVersion", 9 },
    { 22, "RegisterShutdownClient", 4 },
    { 24, "LifecycleRequestComplete", 10 },
    { 24, "UnRegisterShutdownClient", 5 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 8, "BootMode", 3 },
    { 12, "WakeUpReason", 2 },
    { 13, "RestartReason", 0 },
    { 14, "ShutdownReason", 1 },
};

class ConsumerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ConsumerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ConsumerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ConsumerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.genivi.NodeStateManager.Consumer"),
          _logger(logger) {}

    virtual ~ConsumerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ConsumerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 11, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetNodeState'

            LOG_DEBUG_STUB("process method '%s'", "GetNodeState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNodeStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetNodeState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetNodeStateRequest > payload = ::boost::static_pointer_cast<GetNodeStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onGetNodeStateRequest(payload);
            return;
        }
        case 1: {

            // method 'SetSessionState'

            LOG_DEBUG_STUB("process method '%s'", "SetSessionState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSessionStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetSessionState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetSessionStateRequest > payload = ::boost::static_pointer_cast<SetSessionStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onSetSessionStateRequest(payload);
            return;
        }
        case 2: {

            // method 'GetSessionState'

            LOG_DEBUG_STUB("process method '%s'", "GetSessionState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetSessionStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetSessionState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetSessionStateRequest > payload = ::boost::static_pointer_cast<GetSessionStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onGetSessionStateRequest(payload);
            return;
        }
        case 3: {

            // method 'GetApplicationMode'

            LOG_DEBUG_STUB("process method '%s'", "GetApplicationMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetApplicationModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetApplicationMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetApplicationModeRequest > payload = ::boost::static_pointer_cast<GetApplicationModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onGetApplicationModeRequest(payload);
            return;
        }
        case 4: {

            // method 'RegisterShutdownClient'

            LOG_DEBUG_STUB("process method '%s'", "RegisterShutdownClient");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterShutdownClientRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterShutdownClient", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterShutdownClientRequest > payload = ::boost::static_pointer_cast<RegisterShutdownClientRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onRegisterShutdownClientRequest(payload);
            return;
        }
        case 5: {

            // method 'UnRegisterShutdownClient'

            LOG_DEBUG_STUB("process method '%s'", "UnRegisterShutdownClient");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnRegisterShutdownClientRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnRegisterShutdownClient", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnRegisterShutdownClientRequest > payload = ::boost::static_pointer_cast<UnRegisterShutdownClientRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onUnRegisterShutdownClientRequest(payload);
            return;
        }
        case 6: {

            // method 'RegisterSession'

            LOG_DEBUG_STUB("process method '%s'", "RegisterSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterSessionRequest > payload = ::boost::static_pointer_cast<RegisterSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onRegisterSessionRequest(payload);
            return;
        }
        case 7: {

            // method 'UnRegisterSession'

            LOG_DEBUG_STUB("process method '%s'", "UnRegisterSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnRegisterSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnRegisterSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnRegisterSessionRequest > payload = ::boost::static_pointer_cast<UnRegisterSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onUnRegisterSessionRequest(payload);
            return;
        }
        case 8: {

            // method 'GetAppHealthCount'

            LOG_DEBUG_STUB("process method '%s'", "GetAppHealthCount");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAppHealthCountRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetAppHealthCount", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetAppHealthCountRequest > payload = ::boost::static_pointer_cast<GetAppHealthCountRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onGetAppHealthCountRequest(payload);
            return;
        }
        case 9: {

            // method 'GetInterfaceVersion'

            LOG_DEBUG_STUB("process method '%s'", "GetInterfaceVersion");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetInterfaceVersionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetInterfaceVersion", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetInterfaceVersionRequest > payload = ::boost::static_pointer_cast<GetInterfaceVersionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onGetInterfaceVersionRequest(payload);
            return;
        }
        case 10: {

            // method 'LifecycleRequestComplete'

            LOG_DEBUG_STUB("process method '%s'", "LifecycleRequestComplete");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestCompleteRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "LifecycleRequestComplete", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< LifecycleRequestCompleteRequest > payload = ::boost::static_pointer_cast<LifecycleRequestCompleteRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConsumerStub*>(getStub())->onLifecycleRequestCompleteRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ConsumerStubDelegate::introspect() const {
    return     "<interface name=\"org.genivi.NodeStateManager.Consumer\">\n"
            "    <property access=\"read\" name=\"RestartReason\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ShutdownReason\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"WakeUpReason\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"BootMode\" type=\"i\"/>\n"
            "    <method name=\"GetNodeState\">\n"
            "      <doc>\n"
            "        <line>GetNodeState = GetNodeState:</line>\n"
            "        <line>NodeStateId: Will be based on the NsmNodeState_e.</line>\n"
            "        <line>ErrorCode:   Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to get the NodeState without the need of registration to the signal.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"NodeStateId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>NodeStateId (of type _NsmNodeState_e) = Description missing</line>\n"
            "          <line>enum[NsmNodeState_NotSet (null), NsmNodeState_StartUp (null), NsmNodeState_BaseRunning (null), NsmNodeState_LucRunning (null), NsmNodeState_FullyRunning (null), NsmNodeState_FullyOperational (null), NsmNodeState_ShuttingDown (null), NsmNodeState_ShutdownDelay (null), NsmNodeState_FastShutdown (null), NsmNodeState_DegradedPower (null), NsmNodeState_Shutdown (null), NsmNodeState_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetSessionState\">\n"
            "      <doc>\n"
            "        <line>SetSessionState = SetSessionState:</line>\n"
            "        <line>SessionName:  The SessionName will be based upon either the pre-defined platform SessionNames (see NSM content page) or using a newly added product defined session name.</line>\n"
            "        <line>SessionOwner: This parameter defines the name of the application that is setting the state of the session. This must be the applications systemd unit filename.</line>\n"
            "        <line>SeatID:       This parameter will be based upon the enum NsmSeat_e</line>\n"
            "        <line>SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.</line>\n"
            "        <line>The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.</line>\n"
            "        <line>ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by applications to set the state of a session.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"SessionName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>SessionName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SessionOwner\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>SessionOwner = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SeatID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SeatID (of type _NsmSeat_e) = Description missing</line>\n"
            "          <line>enum[NsmSeat_NotSet (null), NsmSeat_Driver (null), NsmSeat_CoDriver (null), NsmSeat_Rear1 (null), NsmSeat_Rear2 (null), NsmSeat_Rear3 (null), NsmSeat_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SessionState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SessionState (of type _NsmSessionState_e) = Description missing</line>\n"
            "          <line>enum[NsmSessionState_Unregistered (null), NsmSessionState_Inactive (null), NsmSessionState_Active (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetSessionState\">\n"
            "      <doc>\n"
            "        <line>GetSessionState = GetSessionState:</line>\n"
            "        <line>SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly</line>\n"
            "        <line>added product defined SessionName.</line>\n"
            "        <line>SeatID:       This parameter will be based upon the enum NsmSeat_e.</line>\n"
            "        <line>SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.</line>\n"
            "        <line>The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.</line>\n"
            "        <line>ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by applications to get the state of a session.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"SessionName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>SessionName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SeatID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SeatID (of type _NsmSeat_e) = Description missing</line>\n"
            "          <line>enum[NsmSeat_NotSet (null), NsmSeat_Driver (null), NsmSeat_CoDriver (null), NsmSeat_Rear1 (null), NsmSeat_Rear2 (null), NsmSeat_Rear3 (null), NsmSeat_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"SessionState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SessionState (of type _NsmSessionState_e) = Description missing</line>\n"
            "          <line>enum[NsmSessionState_Unregistered (null), NsmSessionState_Inactive (null), NsmSessionState_Active (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetApplicationMode\">\n"
            "      <doc>\n"
            "        <line>GetApplicationMode = GetApplicationMode:</line>\n"
            "        <line>ApplicationModeId:This parameter will be based upon the NsmNodeApplicationMode_e.</line>\n"
            "        <line>ErrorCode:        Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to get the application mode.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"ApplicationModeId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ApplicationModeId (of type _NsmApplicationMode_e) = Description missing</line>\n"
            "          <line>enum[NsmApplicationMode_NotSet (null), NsmApplicationMode_Parking (null), NsmApplicationMode_Factory (null), NsmApplicationMode_Transport (null), NsmApplicationMode_Normal (null), NsmApplicationMode_Swl (null), NsmApplicationMode_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RegisterShutdownClient\">\n"
            "      <doc>\n"
            "        <line>RegisterShutdownClient = RegisterShutdownClient:</line>\n"
            "        <line>BusName:      Bus name of remote application.</line>\n"
            "        <line>ObjName:      Object name of remote object that provides the shutdown interface.</line>\n"
            "        <line>ShutdownMode: Shutdown mode for which client wants to be informed (i.e normal fast etc).</line>\n"
            "        <line>TimeoutMs:    Max. Timeout to wait for response from shutdown client in ms.</line>\n"
            "        <line>ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to register themselves as shutdown client.</line>\n"
            "        <line>Any client that registers must provide a method in their D-Bus object called &quot;LifecycleRequest&quot;.</line>\n"
            "        <line>This method will take one parameter which is the RequestType (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).</line>\n"
            "        <line>For an example of the required client interface please see the BootManager component who will be a client of the NSM.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"BusName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>BusName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"ObjName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ObjName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"ShutdownMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ShutdownMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"TimeoutMs\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>TimeoutMs = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UnRegisterShutdownClient\">\n"
            "      <doc>\n"
            "        <line>UnRegisterShutdownClient = UnRegisterShutdownClient:</line>\n"
            "        <line>BusName:      Bus name of remote application.</line>\n"
            "        <line>ObjName:      Object name of remote object that provides the shutdown interface.</line>\n"
            "        <line>ShutdownMode: Shutdown mode for which client wants to unregister (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).</line>\n"
            "        <line>ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to unregister themselves as shutdown client.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"BusName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>BusName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"ObjName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ObjName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"ShutdownMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ShutdownMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RegisterSession\">\n"
            "      <doc>\n"
            "        <line>RegisterSession = RegisterSession:</line>\n"
            "        <line>SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly</line>\n"
            "        <line>added product defined SessionName.</line>\n"
            "        <line>SessionOwner: This is the name of the application that is registering the new session (this must be the applications systemd unit filename).</line>\n"
            "        <line>SeatID:       This parameter will be based upon the enum NsmSeatId_e</line>\n"
            "        <line>SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.</line>\n"
            "        <line>The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.</line>\n"
            "        <line>ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to register a new session whose state should be observed and distributed by the NSM..</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"SessionName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>SessionName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SessionOwner\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>SessionOwner = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SeatID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SeatID (of type _NsmSeat_e) = Description missing</line>\n"
            "          <line>enum[NsmSeat_NotSet (null), NsmSeat_Driver (null), NsmSeat_CoDriver (null), NsmSeat_Rear1 (null), NsmSeat_Rear2 (null), NsmSeat_Rear3 (null), NsmSeat_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SessionState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SessionState (of type _NsmSessionState_e) = Description missing</line>\n"
            "          <line>enum[NsmSessionState_Unregistered (null), NsmSessionState_Inactive (null), NsmSessionState_Active (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UnRegisterSession\">\n"
            "      <doc>\n"
            "        <line>UnRegisterSession = UnRegisterSession:</line>\n"
            "        <line>SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly</line>\n"
            "        <line>added product defined SessionName.</line>\n"
            "        <line>SessionOwner: This is the name of the application that originally registered the session.</line>\n"
            "        <line>It will be validated that this value matches the stored value from the registration.</line>\n"
            "        <line>SeatID:       This parameter will be based upon the enum NsmSeat_e.</line>\n"
            "        <line>ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to remove a new session from the session list hosted by NSM.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"SessionName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>SessionName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SessionOwner\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>SessionOwner = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SeatID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SeatID (of type _NsmSeat_e) = Description missing</line>\n"
            "          <line>enum[NsmSeat_NotSet (null), NsmSeat_Driver (null), NsmSeat_CoDriver (null), NsmSeat_Rear1 (null), NsmSeat_Rear2 (null), NsmSeat_Rear3 (null), NsmSeat_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetAppHealthCount\">\n"
            "      <doc>\n"
            "        <line>GetAppHealthCount = GetAppHealthCount:</line>\n"
            "        <line>Count:        Return value passed to the caller. Number of applications that crashed or terminated accidentally.</line>\n"
            "        <line></line>\n"
            "        <line>The method returns the number of applications that crashed or terminated accidentally within the current life cycle. It can be used to observe the system state.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Count\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Count = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetInterfaceVersion\">\n"
            "      <doc>\n"
            "        <line>GetInterfaceVersion = GetInterfaceVersion:</line>\n"
            "        <line>Version:      Unsigned integer that represents the version number of the Node State Manager.</line>\n"
            "        <line></line>\n"
            "        <line>The method returns the version number of the Node State Manager. The number is organized in four bytes:</line>\n"
            "        <line></line>\n"
            "        <line>Version: VVV.RRR.PPP.BBB</line>\n"
            "        <line></line>\n"
            "        <line>&lt;literallayout></line>\n"
            "        <line>VVV => Version  [1..255]</line>\n"
            "        <line>RRR => Release  [0..255]</line>\n"
            "        <line>PPP => Patch    [0..255]</line>\n"
            "        <line>BBB => Build    [0..255]</line>\n"
            "        <line>&lt;/literallayout></line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Version\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Version = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"LifecycleRequestComplete\">\n"
            "      <doc>\n"
            "        <line>LifecycleRequestComplete = LifecycleRequestComplete:</line>\n"
            "        <line>RequestId:    The request Id of the called life cycle client. The value has been passed when &quot;LifecycleRequest&quot; was called.</line>\n"
            "        <line>Status:       The result of the call to &quot;LifecycleRequest&quot;. NsmErrorStatus_Ok: Request successfully processed. NsmErrorStatus_Error:</line>\n"
            "        <line>An error occured while processing the &quot;LifecycleRequest&quot;.</line>\n"
            "        <line>ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The function has to be called by a &quot;asynchrounous&quot; lifecycle client when he processed the &quot;LifecycleRequest&quot;.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"RequestId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>RequestId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Status (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"NodeState\">\n"
            "      <doc>\n"
            "        <line>NodeState = NodeState:</line>\n"
            "        <line>NodeState: Numeric value for the current NodeState defined in NsmNodeState_e.</line>\n"
            "        <line></line>\n"
            "        <line>Clients can register for notifications when the NodeState is updated inside the NodeStateManager.</line>\n"
            "        <line>This signal is sent to registered clients and will include the current NodeState as a parameter.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"NodeState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>NodeState (of type _NsmNodeState_e) = Description missing</line>\n"
            "          <line>enum[NsmNodeState_NotSet (null), NsmNodeState_StartUp (null), NsmNodeState_BaseRunning (null), NsmNodeState_LucRunning (null), NsmNodeState_FullyRunning (null), NsmNodeState_FullyOperational (null), NsmNodeState_ShuttingDown (null), NsmNodeState_ShutdownDelay (null), NsmNodeState_FastShutdown (null), NsmNodeState_DegradedPower (null), NsmNodeState_Shutdown (null), NsmNodeState_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"NodeApplicationMode\">\n"
            "      <doc>\n"
            "        <line>NodeApplicationMode = NodeApplicationMode:</line>\n"
            "        <line>ApplicationModeId: Numeric value for the current ApplicationMode defined in NsmAplicationMode_e.</line>\n"
            "        <line></line>\n"
            "        <line>Clients can register for notifications when the NodeApplicationMode is updated inside the NodeStateManager.</line>\n"
            "        <line>This signal is sent to registered clients and will include the current NodeApplicationMode as a parameter.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"ApplicationModeId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ApplicationModeId (of type _NsmApplicationMode_e) = Description missing</line>\n"
            "          <line>enum[NsmApplicationMode_NotSet (null), NsmApplicationMode_Parking (null), NsmApplicationMode_Factory (null), NsmApplicationMode_Transport (null), NsmApplicationMode_Normal (null), NsmApplicationMode_Swl (null), NsmApplicationMode_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SessionStateChanged\">\n"
            "      <doc>\n"
            "        <line>SessionStateChanged = SessionStateChanged:</line>\n"
            "        <line>SessionStateName: The SessionName will be based upon either the pre-defined platform SessionNames or using a newly added product defined session name.</line>\n"
            "        <line>SeatID:           This parameter will be based upon the enum NsmSeat_e.</line>\n"
            "        <line>SessionState:     This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.</line>\n"
            "        <line>The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.</line>\n"
            "        <line></line>\n"
            "        <line>This signal is sent to registered clients when a particular session is state is changed.</line>\n"
            "        <line>The client can register for notification about a specific session through the use of the SessionName as a &quot;match rule&quot;.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"SessionStateName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>SessionStateName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"SeatID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SeatID (of type _NsmSeat_e) = Description missing</line>\n"
            "          <line>enum[NsmSeat_NotSet (null), NsmSeat_Driver (null), NsmSeat_CoDriver (null), NsmSeat_Rear1 (null), NsmSeat_Rear2 (null), NsmSeat_Rear3 (null), NsmSeat_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"SessionState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SessionState (of type _NsmSessionState_e) = Description missing</line>\n"
            "          <line>enum[NsmSessionState_Unregistered (null), NsmSessionState_Inactive (null), NsmSessionState_Active (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void ConsumerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ConsumerStub*>(getStub()))->onGetAll (properties);
}

void ConsumerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "RestartReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "ShutdownReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "WakeUpReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "BootMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ConsumerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "RestartReason");
            ::boost::shared_ptr< RestartReasonGet > payload(new RestartReasonGet());
            payload->setAct(act);
            static_cast<ConsumerStub*>(getStub())->onRestartReasonGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "ShutdownReason");
            ::boost::shared_ptr< ShutdownReasonGet > payload(new ShutdownReasonGet());
            payload->setAct(act);
            static_cast<ConsumerStub*>(getStub())->onShutdownReasonGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "WakeUpReason");
            ::boost::shared_ptr< WakeUpReasonGet > payload(new WakeUpReasonGet());
            payload->setAct(act);
            static_cast<ConsumerStub*>(getStub())->onWakeUpReasonGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "BootMode");
            ::boost::shared_ptr< BootModeGet > payload(new BootModeGet());
            payload->setAct(act);
            static_cast<ConsumerStub*>(getStub())->onBootModeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ConsumerStub::ConsumerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ConsumerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ConsumerStub::ConsumerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ConsumerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ConsumerStub::~ConsumerStub() {
    delete _stubDelegate;
}

void ConsumerStub::sendNodeStateSignal(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e nodeState) {
    if (_stubDelegate->isConnected()) {
        NodeStateSignal* payload = new NodeStateSignal(nodeState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NodeState", NodeStateSignal, payload)
        LOG_INFO ("-> send%sSignal", "NodeState");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NodeState");
    }
}

void ConsumerStub::sendNodeApplicationModeSignal(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e applicationModeId) {
    if (_stubDelegate->isConnected()) {
        NodeApplicationModeSignal* payload = new NodeApplicationModeSignal(applicationModeId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NodeApplicationMode", NodeApplicationModeSignal, payload)
        LOG_INFO ("-> send%sSignal", "NodeApplicationMode");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NodeApplicationMode");
    }
}

void ConsumerStub::sendSessionStateChangedSignal(const ::std::string& sessionStateName, _NsmSeat_e seatID, _NsmSessionState_e sessionState) {
    if (_stubDelegate->isConnected()) {
        SessionStateChangedSignal* payload = new SessionStateChangedSignal(sessionStateName, seatID, sessionState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SessionStateChanged", SessionStateChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SessionStateChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SessionStateChanged");
    }
}

void ConsumerStub::sendRestartReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RestartReasonUpdate payload(_RestartReasonProperty);

        LOG_INFO ("-> send%s", "RestartReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RestartReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.genivi.NodeStateManager.Consumer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RestartReasonUpdate");
    }
}

void ConsumerStub::onRestartReasonGet(const ::boost::shared_ptr< RestartReasonGet >& restartReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RestartReasonGet", restartReason->getAct());
    sendRestartReasonGetUpdate(_RestartReasonProperty.getRestartReason(), restartReason->getAct());
}

void ConsumerStub::sendRestartReasonGetUpdate(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e restartReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RestartReasonGet payload(restartReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RestartReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ConsumerStub::setRestartReason(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e restartReason) {
    if(restartReason!=_RestartReasonProperty.getRestartReason()) {
        _RestartReasonProperty.setRestartReason(restartReason);
        sendRestartReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e ConsumerStub::getRestartReason() const {
    return _RestartReasonProperty.getRestartReason();
}

void ConsumerStub::sendShutdownReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ShutdownReasonUpdate payload(_ShutdownReasonProperty);

        LOG_INFO ("-> send%s", "ShutdownReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ShutdownReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.genivi.NodeStateManager.Consumer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ShutdownReasonUpdate");
    }
}

void ConsumerStub::onShutdownReasonGet(const ::boost::shared_ptr< ShutdownReasonGet >& shutdownReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ShutdownReasonGet", shutdownReason->getAct());
    sendShutdownReasonGetUpdate(_ShutdownReasonProperty.getShutdownReason(), shutdownReason->getAct());
}

void ConsumerStub::sendShutdownReasonGetUpdate(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e shutdownReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ShutdownReasonGet payload(shutdownReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ShutdownReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ConsumerStub::setShutdownReason(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e shutdownReason) {
    if(shutdownReason!=_ShutdownReasonProperty.getShutdownReason()) {
        _ShutdownReasonProperty.setShutdownReason(shutdownReason);
        sendShutdownReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e ConsumerStub::getShutdownReason() const {
    return _ShutdownReasonProperty.getShutdownReason();
}

void ConsumerStub::sendWakeUpReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WakeUpReasonUpdate payload(_WakeUpReasonProperty);

        LOG_INFO ("-> send%s", "WakeUpReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WakeUpReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.genivi.NodeStateManager.Consumer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WakeUpReasonUpdate");
    }
}

void ConsumerStub::onWakeUpReasonGet(const ::boost::shared_ptr< WakeUpReasonGet >& wakeUpReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WakeUpReasonGet", wakeUpReason->getAct());
    sendWakeUpReasonGetUpdate(_WakeUpReasonProperty.getWakeUpReason(), wakeUpReason->getAct());
}

void ConsumerStub::sendWakeUpReasonGetUpdate(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e wakeUpReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WakeUpReasonGet payload(wakeUpReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WakeUpReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ConsumerStub::setWakeUpReason(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e wakeUpReason) {
    if(wakeUpReason!=_WakeUpReasonProperty.getWakeUpReason()) {
        _WakeUpReasonProperty.setWakeUpReason(wakeUpReason);
        sendWakeUpReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e ConsumerStub::getWakeUpReason() const {
    return _WakeUpReasonProperty.getWakeUpReason();
}

void ConsumerStub::sendBootModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BootModeUpdate payload(_BootModeProperty);

        LOG_INFO ("-> send%s", "BootModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BootMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.genivi.NodeStateManager.Consumer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BootModeUpdate");
    }
}

void ConsumerStub::onBootModeGet(const ::boost::shared_ptr< BootModeGet >& bootMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BootModeGet", bootMode->getAct());
    sendBootModeGetUpdate(_BootModeProperty.getBootMode(), bootMode->getAct());
}

void ConsumerStub::sendBootModeGetUpdate(int32 bootMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BootModeGet payload(bootMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BootModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ConsumerStub::setBootMode(int32 bootMode) {
    if(bootMode!=_BootModeProperty.getBootMode()) {
        _BootModeProperty.setBootMode(bootMode);
        sendBootModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ConsumerStub::getBootMode() const {
    return _BootModeProperty.getBootMode();
}

void  ConsumerStub::sendGetNodeStateResponse (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e nodeStateId, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    GetNodeStateResponse* payload = new GetNodeStateResponse(nodeStateId, errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetNodeState", GetNodeStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetNodeState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetNodeStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetNodeStateError* payload = new GetNodeStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetNodeState", GetNodeStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetNodeState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendSetSessionStateResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    SetSessionStateResponse* payload = new SetSessionStateResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetSessionState", SetSessionStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetSessionState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendSetSessionStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetSessionStateError* payload = new SetSessionStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetSessionState", SetSessionStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetSessionState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetSessionStateResponse (_NsmSessionState_e sessionState, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    GetSessionStateResponse* payload = new GetSessionStateResponse(sessionState, errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetSessionState", GetSessionStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetSessionState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetSessionStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetSessionStateError* payload = new GetSessionStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetSessionState", GetSessionStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetSessionState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetApplicationModeResponse (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e applicationModeId, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    GetApplicationModeResponse* payload = new GetApplicationModeResponse(applicationModeId, errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetApplicationMode", GetApplicationModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetApplicationMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetApplicationModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetApplicationModeError* payload = new GetApplicationModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetApplicationMode", GetApplicationModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetApplicationMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendRegisterShutdownClientResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    RegisterShutdownClientResponse* payload = new RegisterShutdownClientResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterShutdownClient", RegisterShutdownClientResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterShutdownClient", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendRegisterShutdownClientError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterShutdownClientError* payload = new RegisterShutdownClientError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterShutdownClient", RegisterShutdownClientError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterShutdownClient", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendUnRegisterShutdownClientResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    UnRegisterShutdownClientResponse* payload = new UnRegisterShutdownClientResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "UnRegisterShutdownClient", UnRegisterShutdownClientResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnRegisterShutdownClient", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendUnRegisterShutdownClientError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnRegisterShutdownClientError* payload = new UnRegisterShutdownClientError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnRegisterShutdownClient", UnRegisterShutdownClientError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnRegisterShutdownClient", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendRegisterSessionResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    RegisterSessionResponse* payload = new RegisterSessionResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterSession", RegisterSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendRegisterSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterSessionError* payload = new RegisterSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterSession", RegisterSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendUnRegisterSessionResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    UnRegisterSessionResponse* payload = new UnRegisterSessionResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "UnRegisterSession", UnRegisterSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnRegisterSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendUnRegisterSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnRegisterSessionError* payload = new UnRegisterSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnRegisterSession", UnRegisterSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnRegisterSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetAppHealthCountResponse (uint32 count, act_t act) {
    GetAppHealthCountResponse* payload = new GetAppHealthCountResponse(count);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetAppHealthCount", GetAppHealthCountResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetAppHealthCount", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetAppHealthCountError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetAppHealthCountError* payload = new GetAppHealthCountError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetAppHealthCount", GetAppHealthCountError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetAppHealthCount", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetInterfaceVersionResponse (uint32 version, act_t act) {
    GetInterfaceVersionResponse* payload = new GetInterfaceVersionResponse(version);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetInterfaceVersion", GetInterfaceVersionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetInterfaceVersion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendGetInterfaceVersionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetInterfaceVersionError* payload = new GetInterfaceVersionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetInterfaceVersion", GetInterfaceVersionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetInterfaceVersion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendLifecycleRequestCompleteResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    LifecycleRequestCompleteResponse* payload = new LifecycleRequestCompleteResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "LifecycleRequestComplete", LifecycleRequestCompleteResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "LifecycleRequestComplete", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConsumerStub::sendLifecycleRequestCompleteError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    LifecycleRequestCompleteError* payload = new LifecycleRequestCompleteError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "LifecycleRequestComplete", LifecycleRequestCompleteError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "LifecycleRequestComplete", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ConsumerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'RestartReason'
    {
        ::asf::dbus::DBusVariant variant;
        RestartReasonGet payload(_RestartReasonProperty.getRestartReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RestartReason", variant));
    }

    //property 'ShutdownReason'
    {
        ::asf::dbus::DBusVariant variant;
        ShutdownReasonGet payload(_ShutdownReasonProperty.getShutdownReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ShutdownReason", variant));
    }

    //property 'WakeUpReason'
    {
        ::asf::dbus::DBusVariant variant;
        WakeUpReasonGet payload(_WakeUpReasonProperty.getWakeUpReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WakeUpReason", variant));
    }

    //property 'BootMode'
    {
        ::asf::dbus::DBusVariant variant;
        BootModeGet payload(_BootModeProperty.getBootMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BootMode", variant));
    }
}

} // namespace Consumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org
