/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_CONSUMERCONST_H
#define ORG_GENIVI_NODESTATEMANAGER_CONSUMERCONST_H

#include <cstddef>

/**
 * org.genivi.NodeStateManager.Consumer:
 *
 *                     short_description: "Consumer" interface of the NodeStateManager.
 *
 * 	                This interface contains functions which are not safety critical and can be accessed by "every" client without further restrictions.
 */

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace Consumer {

/**
 * _NsmDataType_e
 *          The enumeration defines the different types of data that can be exchanged between the NodeStateManager (NSM)
 *     	 and the NodeStateMachine (NSMC). Based on this value the setter and getter functions of the NSM and NSMC will
 *     	 interpret data behind the passed byte pointer.
 */
enum _NsmDataType_e {

    /**
     * An ApplicationMode should be set or get
     */
    _NsmDataType_e__NsmDataType_AppMode,
    /**
     * A NodeState should be set or get
     */
    _NsmDataType_e__NsmDataType_NodeState,
    /**
     * A RestartReason should be set or get
     */
    _NsmDataType_e__NsmDataType_RestartReason,
    /**
     * A SessionState should be set or get
     */
    _NsmDataType_e__NsmDataType_SessionState,
    /**
     * A ShutdownReason should be set or get
     */
    _NsmDataType_e__NsmDataType_ShutdownReason,
    /**
     * A BootMode should be set or get
     */
    _NsmDataType_e__NsmDataType_BootMode,
    /**
     * A RunningReason should be set or get
     */
    _NsmDataType_e__NsmDataType_RunningReason

};

bool _NsmDataType_e_Parse (const char *str, size_t length, _NsmDataType_e &value);

const char* _NsmDataType_e_Name (_NsmDataType_e value);

bool _NsmDataType_e_IsValid (_NsmDataType_e value);

/**
 * Session can be enabled seat depended.
 */
enum _NsmSeat_e {

    /**
     * Initial state
     */
    _NsmSeat_e__NsmSeat_NotSet,
    /**
     * Driver seat
     */
    _NsmSeat_e__NsmSeat_Driver,
    /**
     * CoDriver seat
     */
    _NsmSeat_e__NsmSeat_CoDriver,
    /**
     * Rear 1
     */
    _NsmSeat_e__NsmSeat_Rear1,
    /**
     * Rear 2
     */
    _NsmSeat_e__NsmSeat_Rear2,
    /**
     * Rear 3
     */
    _NsmSeat_e__NsmSeat_Rear3,
    /**
     * Last valid state
     */
    _NsmSeat_e__NsmSeat_Last

};

bool _NsmSeat_e_Parse (const char *str, size_t length, _NsmSeat_e &value);

const char* _NsmSeat_e_Name (_NsmSeat_e value);

bool _NsmSeat_e_IsValid (_NsmSeat_e value);

/**
 * The enumeration defines the different wake up reasons.
 */
enum _NsmSessionState_e {

    /**
     * Initial state equals "not set"
     */
    _NsmSessionState_e__NsmSessionState_Unregistered,
    /**
     * Session is inactive
     */
    _NsmSessionState_e__NsmSessionState_Inactive,
    /**
     * Session is active
     */
    _NsmSessionState_e__NsmSessionState_Active

};

bool _NsmSessionState_e_Parse (const char *str, size_t length, _NsmSessionState_e &value);

const char* _NsmSessionState_e_Name (_NsmSessionState_e value);

bool _NsmSessionState_e_IsValid (_NsmSessionState_e value);

} // namespace Consumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_CONSUMERCONST_H
