#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_CONSUMER_H
#define ORG_GENIVI_NODESTATEMANAGER_CONSUMER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/genivi/NodeStateManager/ConsumerConst.h"
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * org.genivi.NodeStateManager.Consumer:
 *
 *                     short_description: "Consumer" interface of the NodeStateManager.
 *
 * 	                This interface contains functions which are not safety critical and can be accessed by "every" client without further restrictions.
 */

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace Consumer {

// method IDs
static const uint16 ID_GetNodeState = 0;
static const uint16 ID_SetSessionState = 1;
static const uint16 ID_GetSessionState = 2;
static const uint16 ID_GetApplicationMode = 3;
static const uint16 ID_RegisterShutdownClient = 4;
static const uint16 ID_UnRegisterShutdownClient = 5;
static const uint16 ID_RegisterSession = 6;
static const uint16 ID_UnRegisterSession = 7;
static const uint16 ID_GetAppHealthCount = 8;
static const uint16 ID_GetInterfaceVersion = 9;
static const uint16 ID_LifecycleRequestComplete = 10;

// signal IDs
static const uint16 ID_NodeState = 11;
static const uint16 ID_NodeApplicationMode = 12;
static const uint16 ID_SessionStateChanged = 13;

// property IDs
static const uint16 ID_RestartReason = 14;
static const uint16 ID_ShutdownReason = 15;
static const uint16 ID_WakeUpReason = 16;
static const uint16 ID_BootMode = 17;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class GetNodeStateResponse;

class SetSessionStateRequest;

class SetSessionStateResponse;

class GetSessionStateRequest;

class GetSessionStateResponse;

class GetApplicationModeResponse;

class RegisterShutdownClientRequest;

class RegisterShutdownClientResponse;

class UnRegisterShutdownClientRequest;

class UnRegisterShutdownClientResponse;

class RegisterSessionRequest;

class RegisterSessionResponse;

class UnRegisterSessionRequest;

class UnRegisterSessionResponse;

class GetAppHealthCountResponse;

class GetInterfaceVersionResponse;

class LifecycleRequestCompleteRequest;

class LifecycleRequestCompleteResponse;

class RestartReasonUpdate;

class RestartReasonRegister;

class ShutdownReasonUpdate;

class ShutdownReasonRegister;

class WakeUpReasonUpdate;

class WakeUpReasonRegister;

class BootModeUpdate;

class BootModeRegister;

class NodeStateSignal;

class NodeApplicationModeSignal;

class SessionStateChangedSignal;

// type definitions
/**
 * GetNodeState:
 *     	NodeStateId: Will be based on the NsmNodeState_e.
 *     	ErrorCode:   Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to get the NodeState without the need of registration to the signal.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetNodeStateRequest;

/**
 * If the meaning of "GetNodeStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetNodeStateError;

/**
 * If the meaning of "SetSessionStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetSessionStateError;

/**
 * If the meaning of "GetSessionStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetSessionStateError;

/**
 * GetApplicationMode:
 * 	    ApplicationModeId:This parameter will be based upon the NsmNodeApplicationMode_e.
 * 	    ErrorCode:        Return value passed to the caller based upon NsmErrorStatus_e.
 *
 * 	The method is used by other applications to get the application mode.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetApplicationModeRequest;

/**
 * If the meaning of "GetApplicationModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetApplicationModeError;

/**
 * If the meaning of "RegisterShutdownClientError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterShutdownClientError;

/**
 * If the meaning of "UnRegisterShutdownClientError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnRegisterShutdownClientError;

/**
 * If the meaning of "RegisterSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterSessionError;

/**
 * If the meaning of "UnRegisterSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnRegisterSessionError;

/**
 * GetAppHealthCount:
 *     	Count:        Return value passed to the caller. Number of applications that crashed or terminated accidentally.
 *
 *     	The method returns the number of applications that crashed or terminated accidentally within the current life cycle. It can be used to observe the system state.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetAppHealthCountRequest;

/**
 * If the meaning of "GetAppHealthCountError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetAppHealthCountError;

/**
 * GetInterfaceVersion:
 *     	Version:      Unsigned integer that represents the version number of the Node State Manager.
 *
 *     	The method returns the version number of the Node State Manager. The number is organized in four bytes:
 *
 *     	Version: VVV.RRR.PPP.BBB
 *
 *     	<literallayout>
 *     		VVV => Version  [1..255]
 *     		RRR => Release  [0..255]
 *     		PPP => Patch    [0..255]
 *     		BBB => Build    [0..255]
 *     	</literallayout>
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetInterfaceVersionRequest;

/**
 * If the meaning of "GetInterfaceVersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetInterfaceVersionError;

/**
 * If the meaning of "LifecycleRequestCompleteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LifecycleRequestCompleteError;

/**
 * RestartReason: This property informs clients about the reason for the last restart.
 *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
 */
typedef RestartReasonUpdate RestartReasonSet;

/**
 * RestartReason: This property informs clients about the reason for the last restart.
 *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
 */
typedef RestartReasonUpdate RestartReasonGet;

/**
 * If the meaning of "RestartReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestartReasonError;

/**
 * ShutdownReason: This property informs clients about the reason for the last shutdown.
 *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
 */
typedef ShutdownReasonUpdate ShutdownReasonSet;

/**
 * ShutdownReason: This property informs clients about the reason for the last shutdown.
 *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
 */
typedef ShutdownReasonUpdate ShutdownReasonGet;

/**
 * If the meaning of "ShutdownReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShutdownReasonError;

/**
 * WakeUpReason: This property informs clients about the recent reason for waking up the target.
 *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
 */
typedef WakeUpReasonUpdate WakeUpReasonSet;

/**
 * WakeUpReason: This property informs clients about the recent reason for waking up the target.
 *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
 */
typedef WakeUpReasonUpdate WakeUpReasonGet;

/**
 * If the meaning of "WakeUpReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WakeUpReasonError;

/**
 * BootMode: This property informs clients about the recent BootMode of the target.
 *                       The values will be defined by a third party header which has not been delivered yet.
 *                       The description needs to be updated as soon as the header is available.
 */
typedef BootModeUpdate BootModeSet;

/**
 * BootMode: This property informs clients about the recent BootMode of the target.
 *                       The values will be defined by a third party header which has not been delivered yet.
 *                       The description needs to be updated as soon as the header is available.
 */
typedef BootModeUpdate BootModeGet;

/**
 * If the meaning of "BootModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BootModeError;

/**
 * If the meaning of "NodeStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NodeStateError;

/**
 * If the meaning of "NodeApplicationModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NodeApplicationModeError;

/**
 * If the meaning of "SessionStateChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SessionStateChangedError;


/**
 * GetNodeState:
 *     	NodeStateId: Will be based on the NsmNodeState_e.
 *     	ErrorCode:   Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to get the NodeState without the need of registration to the signal.
 */
class GetNodeStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNodeStateResponse ();

    /**
     * Copy constructor
     */
    inline  GetNodeStateResponse (const GetNodeStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetNodeStateResponse (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateId_, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~GetNodeStateResponse();

    /**
     * Assignment operator
     */
    inline GetNodeStateResponse& operator = (const GetNodeStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNodeStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNodeStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNodeStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNodeStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NodeStateId"

    static const int kNodeStateId = 0;

    /**
     * Clears the field "NodeStateId".
     *
     * The field will be set to its default value. The hasNodeStateId()
     * method will return false.
     */
    inline void clearNodeStateId();

    /**
     * Checks whether the field "NodeStateId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNodeStateId()). Otherwise it will return false.
     */
    inline bool hasNodeStateId () const;

    /**
     * Returns the value of the member "NodeStateId".
     *
     * If the meaning of "NodeStateId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "NodeStateId"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e getNodeStateId () const;

    /**
     * Sets the value of the member "NodeStateId".
     *
     * If the meaning of "NodeStateId" isn't clear, then there should be a description here.
     *
     * @param NodeStateId The value which will be set
     */
    inline void setNodeStateId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateId_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const GetNodeStateResponse &getDefaultInstance();

private:

    inline void set_has_NodeStateId ();

    inline void clear_has_NodeStateId ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e _NodeStateId;

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * SetSessionState:
 *     	SessionName:  The SessionName will be based upon either the pre-defined platform SessionNames (see NSM content page) or using a newly added product defined session name.
 *     	SessionOwner: This parameter defines the name of the application that is setting the state of the session. This must be the applications systemd unit filename.
 *     	SeatID:       This parameter will be based upon the enum NsmSeat_e
 *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
 *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by applications to set the state of a session.
 */
class SetSessionStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSessionStateRequest ();

    /**
     * Copy constructor
     */
    inline  SetSessionStateRequest (const SetSessionStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetSessionStateRequest (const ::std::string& SessionName_, const ::std::string& SessionOwner_, _NsmSeat_e SeatID_, _NsmSessionState_e SessionState_);

    /**
     * Destructor
     */
    inline virtual  ~SetSessionStateRequest();

    /**
     * Assignment operator
     */
    inline SetSessionStateRequest& operator = (const SetSessionStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSessionStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSessionStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSessionStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSessionStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionName"

    static const int kSessionName = 0;

    /**
     * Clears the field "SessionName".
     *
     * The field will be set to its default value. The hasSessionName()
     * method will return false.
     */
    inline void clearSessionName();

    /**
     * Checks whether the field "SessionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionName()). Otherwise it will return false.
     */
    inline bool hasSessionName () const;

    /**
     * Returns the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionName"
     */
    inline const ::std::string& getSessionName () const;

    /**
     * Retrieves the value of the field "SessionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SessionName".
     */
    inline ::std::string& getSessionNameMutable ();

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const ::std::string& SessionName_);

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const char* SessionName_);

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const char* value, size_t size);

    // API of field "SessionOwner"

    static const int kSessionOwner = 1;

    /**
     * Clears the field "SessionOwner".
     *
     * The field will be set to its default value. The hasSessionOwner()
     * method will return false.
     */
    inline void clearSessionOwner();

    /**
     * Checks whether the field "SessionOwner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionOwner()). Otherwise it will return false.
     */
    inline bool hasSessionOwner () const;

    /**
     * Returns the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionOwner"
     */
    inline const ::std::string& getSessionOwner () const;

    /**
     * Retrieves the value of the field "SessionOwner" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SessionOwner".
     */
    inline ::std::string& getSessionOwnerMutable ();

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const ::std::string& SessionOwner_);

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const char* SessionOwner_);

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const char* value, size_t size);

    // API of field "SeatID"

    static const int kSeatID = 2;

    /**
     * Clears the field "SeatID".
     *
     * The field will be set to its default value. The hasSeatID()
     * method will return false.
     */
    inline void clearSeatID();

    /**
     * Checks whether the field "SeatID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSeatID()). Otherwise it will return false.
     */
    inline bool hasSeatID () const;

    /**
     * Returns the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SeatID"
     */
    inline _NsmSeat_e getSeatID () const;

    /**
     * Sets the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @param SeatID The value which will be set
     */
    inline void setSeatID (_NsmSeat_e SeatID_);

    // API of field "SessionState"

    static const int kSessionState = 3;

    /**
     * Clears the field "SessionState".
     *
     * The field will be set to its default value. The hasSessionState()
     * method will return false.
     */
    inline void clearSessionState();

    /**
     * Checks whether the field "SessionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionState()). Otherwise it will return false.
     */
    inline bool hasSessionState () const;

    /**
     * Returns the value of the member "SessionState".
     *
     * If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionState"
     */
    inline _NsmSessionState_e getSessionState () const;

    /**
     * Sets the value of the member "SessionState".
     *
     * If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @param SessionState The value which will be set
     */
    inline void setSessionState (_NsmSessionState_e SessionState_);

    static const SetSessionStateRequest &getDefaultInstance();

private:

    inline void set_has_SessionName ();

    inline void clear_has_SessionName ();

    inline void set_has_SessionOwner ();

    inline void clear_has_SessionOwner ();

    inline void set_has_SeatID ();

    inline void clear_has_SeatID ();

    inline void set_has_SessionState ();

    inline void clear_has_SessionState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _SessionName;

    ::std::string _SessionOwner;

    _NsmSeat_e _SeatID;

    _NsmSessionState_e _SessionState;

};

/**
 * SetSessionState:
 *     	SessionName:  The SessionName will be based upon either the pre-defined platform SessionNames (see NSM content page) or using a newly added product defined session name.
 *     	SessionOwner: This parameter defines the name of the application that is setting the state of the session. This must be the applications systemd unit filename.
 *     	SeatID:       This parameter will be based upon the enum NsmSeat_e
 *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
 *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by applications to set the state of a session.
 */
class SetSessionStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSessionStateResponse ();

    /**
     * Copy constructor
     */
    inline  SetSessionStateResponse (const SetSessionStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetSessionStateResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetSessionStateResponse();

    /**
     * Assignment operator
     */
    inline SetSessionStateResponse& operator = (const SetSessionStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSessionStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSessionStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSessionStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSessionStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const SetSessionStateResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * GetSessionState:
 *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
 *     				  added product defined SessionName.
 *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
 *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
 *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by applications to get the state of a session.
 */
class GetSessionStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSessionStateRequest ();

    /**
     * Copy constructor
     */
    inline  GetSessionStateRequest (const GetSessionStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetSessionStateRequest (const ::std::string& SessionName_, _NsmSeat_e SeatID_);

    /**
     * Destructor
     */
    inline virtual  ~GetSessionStateRequest();

    /**
     * Assignment operator
     */
    inline GetSessionStateRequest& operator = (const GetSessionStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSessionStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSessionStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSessionStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSessionStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionName"

    static const int kSessionName = 0;

    /**
     * Clears the field "SessionName".
     *
     * The field will be set to its default value. The hasSessionName()
     * method will return false.
     */
    inline void clearSessionName();

    /**
     * Checks whether the field "SessionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionName()). Otherwise it will return false.
     */
    inline bool hasSessionName () const;

    /**
     * Returns the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionName"
     */
    inline const ::std::string& getSessionName () const;

    /**
     * Retrieves the value of the field "SessionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SessionName".
     */
    inline ::std::string& getSessionNameMutable ();

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const ::std::string& SessionName_);

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const char* SessionName_);

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const char* value, size_t size);

    // API of field "SeatID"

    static const int kSeatID = 1;

    /**
     * Clears the field "SeatID".
     *
     * The field will be set to its default value. The hasSeatID()
     * method will return false.
     */
    inline void clearSeatID();

    /**
     * Checks whether the field "SeatID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSeatID()). Otherwise it will return false.
     */
    inline bool hasSeatID () const;

    /**
     * Returns the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SeatID"
     */
    inline _NsmSeat_e getSeatID () const;

    /**
     * Sets the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @param SeatID The value which will be set
     */
    inline void setSeatID (_NsmSeat_e SeatID_);

    static const GetSessionStateRequest &getDefaultInstance();

private:

    inline void set_has_SessionName ();

    inline void clear_has_SessionName ();

    inline void set_has_SeatID ();

    inline void clear_has_SeatID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _SessionName;

    _NsmSeat_e _SeatID;

};

/**
 * GetSessionState:
 *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
 *     				  added product defined SessionName.
 *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
 *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
 *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by applications to get the state of a session.
 */
class GetSessionStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSessionStateResponse ();

    /**
     * Copy constructor
     */
    inline  GetSessionStateResponse (const GetSessionStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetSessionStateResponse (_NsmSessionState_e SessionState_, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~GetSessionStateResponse();

    /**
     * Assignment operator
     */
    inline GetSessionStateResponse& operator = (const GetSessionStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSessionStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSessionStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSessionStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSessionStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionState"

    static const int kSessionState = 0;

    /**
     * Clears the field "SessionState".
     *
     * The field will be set to its default value. The hasSessionState()
     * method will return false.
     */
    inline void clearSessionState();

    /**
     * Checks whether the field "SessionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionState()). Otherwise it will return false.
     */
    inline bool hasSessionState () const;

    /**
     * Returns the value of the member "SessionState".
     *
     * If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionState"
     */
    inline _NsmSessionState_e getSessionState () const;

    /**
     * Sets the value of the member "SessionState".
     *
     * If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @param SessionState The value which will be set
     */
    inline void setSessionState (_NsmSessionState_e SessionState_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const GetSessionStateResponse &getDefaultInstance();

private:

    inline void set_has_SessionState ();

    inline void clear_has_SessionState ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    _NsmSessionState_e _SessionState;

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * GetApplicationMode:
 * 	    ApplicationModeId:This parameter will be based upon the NsmNodeApplicationMode_e.
 * 	    ErrorCode:        Return value passed to the caller based upon NsmErrorStatus_e.
 *
 * 	The method is used by other applications to get the application mode.
 */
class GetApplicationModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetApplicationModeResponse ();

    /**
     * Copy constructor
     */
    inline  GetApplicationModeResponse (const GetApplicationModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetApplicationModeResponse (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~GetApplicationModeResponse();

    /**
     * Assignment operator
     */
    inline GetApplicationModeResponse& operator = (const GetApplicationModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetApplicationModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetApplicationModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetApplicationModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetApplicationModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ApplicationModeId"

    static const int kApplicationModeId = 0;

    /**
     * Clears the field "ApplicationModeId".
     *
     * The field will be set to its default value. The hasApplicationModeId()
     * method will return false.
     */
    inline void clearApplicationModeId();

    /**
     * Checks whether the field "ApplicationModeId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationModeId()). Otherwise it will return false.
     */
    inline bool hasApplicationModeId () const;

    /**
     * Returns the value of the member "ApplicationModeId".
     *
     * If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ApplicationModeId"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e getApplicationModeId () const;

    /**
     * Sets the value of the member "ApplicationModeId".
     *
     * If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     *
     * @param ApplicationModeId The value which will be set
     */
    inline void setApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const GetApplicationModeResponse &getDefaultInstance();

private:

    inline void set_has_ApplicationModeId ();

    inline void clear_has_ApplicationModeId ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e _ApplicationModeId;

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * RegisterShutdownClient:
 *     	BusName:      Bus name of remote application.
 *     	ObjName:      Object name of remote object that provides the shutdown interface.
 *     	ShutdownMode: Shutdown mode for which client wants to be informed (i.e normal fast etc).
 *     	TimeoutMs:    Max. Timeout to wait for response from shutdown client in ms.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to register themselves as shutdown client.
 *     	Any client that registers must provide a method in their D-Bus object called "LifecycleRequest".
 *     	This method will take one parameter which is the RequestType (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
 *     	For an example of the required client interface please see the BootManager component who will be a client of the NSM.
 */
class RegisterShutdownClientRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterShutdownClientRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterShutdownClientRequest (const RegisterShutdownClientRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterShutdownClientRequest (const ::std::string& BusName_, const ::std::string& ObjName_, uint32 ShutdownMode_, uint32 TimeoutMs_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterShutdownClientRequest();

    /**
     * Assignment operator
     */
    inline RegisterShutdownClientRequest& operator = (const RegisterShutdownClientRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterShutdownClientRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterShutdownClientRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterShutdownClientRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterShutdownClientRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BusName"

    static const int kBusName = 0;

    /**
     * Clears the field "BusName".
     *
     * The field will be set to its default value. The hasBusName()
     * method will return false.
     */
    inline void clearBusName();

    /**
     * Checks whether the field "BusName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBusName()). Otherwise it will return false.
     */
    inline bool hasBusName () const;

    /**
     * Returns the value of the member "BusName".
     *
     * If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BusName"
     */
    inline const ::std::string& getBusName () const;

    /**
     * Retrieves the value of the field "BusName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BusName".
     */
    inline ::std::string& getBusNameMutable ();

    /**
     * Sets the value of the member "BusName".
     *
     * If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @param BusName The value which will be set
     */
    inline void setBusName (const ::std::string& BusName_);

    /**
     * Sets the value of the member "BusName".
     *
     * If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @param BusName The value which will be set
     */
    inline void setBusName (const char* BusName_);

    /**
     * Sets the value of the member "BusName".
     *
     * If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @param BusName The value which will be set
     */
    inline void setBusName (const char* value, size_t size);

    // API of field "ObjName"

    static const int kObjName = 1;

    /**
     * Clears the field "ObjName".
     *
     * The field will be set to its default value. The hasObjName()
     * method will return false.
     */
    inline void clearObjName();

    /**
     * Checks whether the field "ObjName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObjName()). Otherwise it will return false.
     */
    inline bool hasObjName () const;

    /**
     * Returns the value of the member "ObjName".
     *
     * If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ObjName"
     */
    inline const ::std::string& getObjName () const;

    /**
     * Retrieves the value of the field "ObjName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ObjName".
     */
    inline ::std::string& getObjNameMutable ();

    /**
     * Sets the value of the member "ObjName".
     *
     * If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @param ObjName The value which will be set
     */
    inline void setObjName (const ::std::string& ObjName_);

    /**
     * Sets the value of the member "ObjName".
     *
     * If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @param ObjName The value which will be set
     */
    inline void setObjName (const char* ObjName_);

    /**
     * Sets the value of the member "ObjName".
     *
     * If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @param ObjName The value which will be set
     */
    inline void setObjName (const char* value, size_t size);

    // API of field "ShutdownMode"

    static const int kShutdownMode = 2;

    /**
     * Clears the field "ShutdownMode".
     *
     * The field will be set to its default value. The hasShutdownMode()
     * method will return false.
     */
    inline void clearShutdownMode();

    /**
     * Checks whether the field "ShutdownMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShutdownMode()). Otherwise it will return false.
     */
    inline bool hasShutdownMode () const;

    /**
     * Returns the value of the member "ShutdownMode".
     *
     * If the meaning of "ShutdownMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ShutdownMode"
     */
    inline uint32 getShutdownMode () const;

    /**
     * Sets the value of the member "ShutdownMode".
     *
     * If the meaning of "ShutdownMode" isn't clear, then there should be a description here.
     *
     * @param ShutdownMode The value which will be set
     */
    inline void setShutdownMode (uint32 ShutdownMode_);

    // API of field "TimeoutMs"

    static const int kTimeoutMs = 3;

    /**
     * Clears the field "TimeoutMs".
     *
     * The field will be set to its default value. The hasTimeoutMs()
     * method will return false.
     */
    inline void clearTimeoutMs();

    /**
     * Checks whether the field "TimeoutMs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeoutMs()). Otherwise it will return false.
     */
    inline bool hasTimeoutMs () const;

    /**
     * Returns the value of the member "TimeoutMs".
     *
     * If the meaning of "TimeoutMs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TimeoutMs"
     */
    inline uint32 getTimeoutMs () const;

    /**
     * Sets the value of the member "TimeoutMs".
     *
     * If the meaning of "TimeoutMs" isn't clear, then there should be a description here.
     *
     * @param TimeoutMs The value which will be set
     */
    inline void setTimeoutMs (uint32 TimeoutMs_);

    static const RegisterShutdownClientRequest &getDefaultInstance();

private:

    inline void set_has_BusName ();

    inline void clear_has_BusName ();

    inline void set_has_ObjName ();

    inline void clear_has_ObjName ();

    inline void set_has_ShutdownMode ();

    inline void clear_has_ShutdownMode ();

    inline void set_has_TimeoutMs ();

    inline void clear_has_TimeoutMs ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _BusName;

    ::std::string _ObjName;

    uint32 _ShutdownMode;

    uint32 _TimeoutMs;

};

/**
 * RegisterShutdownClient:
 *     	BusName:      Bus name of remote application.
 *     	ObjName:      Object name of remote object that provides the shutdown interface.
 *     	ShutdownMode: Shutdown mode for which client wants to be informed (i.e normal fast etc).
 *     	TimeoutMs:    Max. Timeout to wait for response from shutdown client in ms.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to register themselves as shutdown client.
 *     	Any client that registers must provide a method in their D-Bus object called "LifecycleRequest".
 *     	This method will take one parameter which is the RequestType (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
 *     	For an example of the required client interface please see the BootManager component who will be a client of the NSM.
 */
class RegisterShutdownClientResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterShutdownClientResponse ();

    /**
     * Copy constructor
     */
    inline  RegisterShutdownClientResponse (const RegisterShutdownClientResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterShutdownClientResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterShutdownClientResponse();

    /**
     * Assignment operator
     */
    inline RegisterShutdownClientResponse& operator = (const RegisterShutdownClientResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterShutdownClientResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterShutdownClientResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterShutdownClientResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterShutdownClientResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const RegisterShutdownClientResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * UnRegisterShutdownClient:
 *     	BusName:      Bus name of remote application.
 *     	ObjName:      Object name of remote object that provides the shutdown interface.
 *     	ShutdownMode: Shutdown mode for which client wants to unregister (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to unregister themselves as shutdown client.
 */
class UnRegisterShutdownClientRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnRegisterShutdownClientRequest ();

    /**
     * Copy constructor
     */
    inline  UnRegisterShutdownClientRequest (const UnRegisterShutdownClientRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnRegisterShutdownClientRequest (const ::std::string& BusName_, const ::std::string& ObjName_, uint32 ShutdownMode_);

    /**
     * Destructor
     */
    inline virtual  ~UnRegisterShutdownClientRequest();

    /**
     * Assignment operator
     */
    inline UnRegisterShutdownClientRequest& operator = (const UnRegisterShutdownClientRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnRegisterShutdownClientRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnRegisterShutdownClientRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnRegisterShutdownClientRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnRegisterShutdownClientRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BusName"

    static const int kBusName = 0;

    /**
     * Clears the field "BusName".
     *
     * The field will be set to its default value. The hasBusName()
     * method will return false.
     */
    inline void clearBusName();

    /**
     * Checks whether the field "BusName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBusName()). Otherwise it will return false.
     */
    inline bool hasBusName () const;

    /**
     * Returns the value of the member "BusName".
     *
     * If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BusName"
     */
    inline const ::std::string& getBusName () const;

    /**
     * Retrieves the value of the field "BusName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BusName".
     */
    inline ::std::string& getBusNameMutable ();

    /**
     * Sets the value of the member "BusName".
     *
     * If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @param BusName The value which will be set
     */
    inline void setBusName (const ::std::string& BusName_);

    /**
     * Sets the value of the member "BusName".
     *
     * If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @param BusName The value which will be set
     */
    inline void setBusName (const char* BusName_);

    /**
     * Sets the value of the member "BusName".
     *
     * If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @param BusName The value which will be set
     */
    inline void setBusName (const char* value, size_t size);

    // API of field "ObjName"

    static const int kObjName = 1;

    /**
     * Clears the field "ObjName".
     *
     * The field will be set to its default value. The hasObjName()
     * method will return false.
     */
    inline void clearObjName();

    /**
     * Checks whether the field "ObjName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObjName()). Otherwise it will return false.
     */
    inline bool hasObjName () const;

    /**
     * Returns the value of the member "ObjName".
     *
     * If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ObjName"
     */
    inline const ::std::string& getObjName () const;

    /**
     * Retrieves the value of the field "ObjName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ObjName".
     */
    inline ::std::string& getObjNameMutable ();

    /**
     * Sets the value of the member "ObjName".
     *
     * If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @param ObjName The value which will be set
     */
    inline void setObjName (const ::std::string& ObjName_);

    /**
     * Sets the value of the member "ObjName".
     *
     * If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @param ObjName The value which will be set
     */
    inline void setObjName (const char* ObjName_);

    /**
     * Sets the value of the member "ObjName".
     *
     * If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @param ObjName The value which will be set
     */
    inline void setObjName (const char* value, size_t size);

    // API of field "ShutdownMode"

    static const int kShutdownMode = 2;

    /**
     * Clears the field "ShutdownMode".
     *
     * The field will be set to its default value. The hasShutdownMode()
     * method will return false.
     */
    inline void clearShutdownMode();

    /**
     * Checks whether the field "ShutdownMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShutdownMode()). Otherwise it will return false.
     */
    inline bool hasShutdownMode () const;

    /**
     * Returns the value of the member "ShutdownMode".
     *
     * If the meaning of "ShutdownMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ShutdownMode"
     */
    inline uint32 getShutdownMode () const;

    /**
     * Sets the value of the member "ShutdownMode".
     *
     * If the meaning of "ShutdownMode" isn't clear, then there should be a description here.
     *
     * @param ShutdownMode The value which will be set
     */
    inline void setShutdownMode (uint32 ShutdownMode_);

    static const UnRegisterShutdownClientRequest &getDefaultInstance();

private:

    inline void set_has_BusName ();

    inline void clear_has_BusName ();

    inline void set_has_ObjName ();

    inline void clear_has_ObjName ();

    inline void set_has_ShutdownMode ();

    inline void clear_has_ShutdownMode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _BusName;

    ::std::string _ObjName;

    uint32 _ShutdownMode;

};

/**
 * UnRegisterShutdownClient:
 *     	BusName:      Bus name of remote application.
 *     	ObjName:      Object name of remote object that provides the shutdown interface.
 *     	ShutdownMode: Shutdown mode for which client wants to unregister (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to unregister themselves as shutdown client.
 */
class UnRegisterShutdownClientResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnRegisterShutdownClientResponse ();

    /**
     * Copy constructor
     */
    inline  UnRegisterShutdownClientResponse (const UnRegisterShutdownClientResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UnRegisterShutdownClientResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~UnRegisterShutdownClientResponse();

    /**
     * Assignment operator
     */
    inline UnRegisterShutdownClientResponse& operator = (const UnRegisterShutdownClientResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnRegisterShutdownClientResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnRegisterShutdownClientResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnRegisterShutdownClientResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnRegisterShutdownClientResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const UnRegisterShutdownClientResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * RegisterSession:
 *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
 *     				  added product defined SessionName.
 *     	SessionOwner: This is the name of the application that is registering the new session (this must be the applications systemd unit filename).
 *     	SeatID:       This parameter will be based upon the enum NsmSeatId_e
 *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
 *     	              The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to register a new session whose state should be observed and distributed by the NSM..
 */
class RegisterSessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterSessionRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterSessionRequest (const RegisterSessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterSessionRequest (const ::std::string& SessionName_, const ::std::string& SessionOwner_, _NsmSeat_e SeatID_, _NsmSessionState_e SessionState_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterSessionRequest();

    /**
     * Assignment operator
     */
    inline RegisterSessionRequest& operator = (const RegisterSessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterSessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterSessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterSessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterSessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionName"

    static const int kSessionName = 0;

    /**
     * Clears the field "SessionName".
     *
     * The field will be set to its default value. The hasSessionName()
     * method will return false.
     */
    inline void clearSessionName();

    /**
     * Checks whether the field "SessionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionName()). Otherwise it will return false.
     */
    inline bool hasSessionName () const;

    /**
     * Returns the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionName"
     */
    inline const ::std::string& getSessionName () const;

    /**
     * Retrieves the value of the field "SessionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SessionName".
     */
    inline ::std::string& getSessionNameMutable ();

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const ::std::string& SessionName_);

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const char* SessionName_);

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const char* value, size_t size);

    // API of field "SessionOwner"

    static const int kSessionOwner = 1;

    /**
     * Clears the field "SessionOwner".
     *
     * The field will be set to its default value. The hasSessionOwner()
     * method will return false.
     */
    inline void clearSessionOwner();

    /**
     * Checks whether the field "SessionOwner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionOwner()). Otherwise it will return false.
     */
    inline bool hasSessionOwner () const;

    /**
     * Returns the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionOwner"
     */
    inline const ::std::string& getSessionOwner () const;

    /**
     * Retrieves the value of the field "SessionOwner" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SessionOwner".
     */
    inline ::std::string& getSessionOwnerMutable ();

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const ::std::string& SessionOwner_);

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const char* SessionOwner_);

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const char* value, size_t size);

    // API of field "SeatID"

    static const int kSeatID = 2;

    /**
     * Clears the field "SeatID".
     *
     * The field will be set to its default value. The hasSeatID()
     * method will return false.
     */
    inline void clearSeatID();

    /**
     * Checks whether the field "SeatID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSeatID()). Otherwise it will return false.
     */
    inline bool hasSeatID () const;

    /**
     * Returns the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SeatID"
     */
    inline _NsmSeat_e getSeatID () const;

    /**
     * Sets the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @param SeatID The value which will be set
     */
    inline void setSeatID (_NsmSeat_e SeatID_);

    // API of field "SessionState"

    static const int kSessionState = 3;

    /**
     * Clears the field "SessionState".
     *
     * The field will be set to its default value. The hasSessionState()
     * method will return false.
     */
    inline void clearSessionState();

    /**
     * Checks whether the field "SessionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionState()). Otherwise it will return false.
     */
    inline bool hasSessionState () const;

    /**
     * Returns the value of the member "SessionState".
     *
     * If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionState"
     */
    inline _NsmSessionState_e getSessionState () const;

    /**
     * Sets the value of the member "SessionState".
     *
     * If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @param SessionState The value which will be set
     */
    inline void setSessionState (_NsmSessionState_e SessionState_);

    static const RegisterSessionRequest &getDefaultInstance();

private:

    inline void set_has_SessionName ();

    inline void clear_has_SessionName ();

    inline void set_has_SessionOwner ();

    inline void clear_has_SessionOwner ();

    inline void set_has_SeatID ();

    inline void clear_has_SeatID ();

    inline void set_has_SessionState ();

    inline void clear_has_SessionState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _SessionName;

    ::std::string _SessionOwner;

    _NsmSeat_e _SeatID;

    _NsmSessionState_e _SessionState;

};

/**
 * RegisterSession:
 *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
 *     				  added product defined SessionName.
 *     	SessionOwner: This is the name of the application that is registering the new session (this must be the applications systemd unit filename).
 *     	SeatID:       This parameter will be based upon the enum NsmSeatId_e
 *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
 *     	              The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to register a new session whose state should be observed and distributed by the NSM..
 */
class RegisterSessionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterSessionResponse ();

    /**
     * Copy constructor
     */
    inline  RegisterSessionResponse (const RegisterSessionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterSessionResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterSessionResponse();

    /**
     * Assignment operator
     */
    inline RegisterSessionResponse& operator = (const RegisterSessionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterSessionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterSessionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterSessionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterSessionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const RegisterSessionResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * UnRegisterSession:
 *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
 *     				  added product defined SessionName.
 *     	SessionOwner: This is the name of the application that originally registered the session.
 *     	              It will be validated that this value matches the stored value from the registration.
 *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to remove a new session from the session list hosted by NSM.
 */
class UnRegisterSessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnRegisterSessionRequest ();

    /**
     * Copy constructor
     */
    inline  UnRegisterSessionRequest (const UnRegisterSessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnRegisterSessionRequest (const ::std::string& SessionName_, const ::std::string& SessionOwner_, _NsmSeat_e SeatID_);

    /**
     * Destructor
     */
    inline virtual  ~UnRegisterSessionRequest();

    /**
     * Assignment operator
     */
    inline UnRegisterSessionRequest& operator = (const UnRegisterSessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnRegisterSessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnRegisterSessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnRegisterSessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnRegisterSessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionName"

    static const int kSessionName = 0;

    /**
     * Clears the field "SessionName".
     *
     * The field will be set to its default value. The hasSessionName()
     * method will return false.
     */
    inline void clearSessionName();

    /**
     * Checks whether the field "SessionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionName()). Otherwise it will return false.
     */
    inline bool hasSessionName () const;

    /**
     * Returns the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionName"
     */
    inline const ::std::string& getSessionName () const;

    /**
     * Retrieves the value of the field "SessionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SessionName".
     */
    inline ::std::string& getSessionNameMutable ();

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const ::std::string& SessionName_);

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const char* SessionName_);

    /**
     * Sets the value of the member "SessionName".
     *
     * If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionName The value which will be set
     */
    inline void setSessionName (const char* value, size_t size);

    // API of field "SessionOwner"

    static const int kSessionOwner = 1;

    /**
     * Clears the field "SessionOwner".
     *
     * The field will be set to its default value. The hasSessionOwner()
     * method will return false.
     */
    inline void clearSessionOwner();

    /**
     * Checks whether the field "SessionOwner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionOwner()). Otherwise it will return false.
     */
    inline bool hasSessionOwner () const;

    /**
     * Returns the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionOwner"
     */
    inline const ::std::string& getSessionOwner () const;

    /**
     * Retrieves the value of the field "SessionOwner" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SessionOwner".
     */
    inline ::std::string& getSessionOwnerMutable ();

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const ::std::string& SessionOwner_);

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const char* SessionOwner_);

    /**
     * Sets the value of the member "SessionOwner".
     *
     * If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SessionOwner The value which will be set
     */
    inline void setSessionOwner (const char* value, size_t size);

    // API of field "SeatID"

    static const int kSeatID = 2;

    /**
     * Clears the field "SeatID".
     *
     * The field will be set to its default value. The hasSeatID()
     * method will return false.
     */
    inline void clearSeatID();

    /**
     * Checks whether the field "SeatID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSeatID()). Otherwise it will return false.
     */
    inline bool hasSeatID () const;

    /**
     * Returns the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SeatID"
     */
    inline _NsmSeat_e getSeatID () const;

    /**
     * Sets the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @param SeatID The value which will be set
     */
    inline void setSeatID (_NsmSeat_e SeatID_);

    static const UnRegisterSessionRequest &getDefaultInstance();

private:

    inline void set_has_SessionName ();

    inline void clear_has_SessionName ();

    inline void set_has_SessionOwner ();

    inline void clear_has_SessionOwner ();

    inline void set_has_SeatID ();

    inline void clear_has_SeatID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _SessionName;

    ::std::string _SessionOwner;

    _NsmSeat_e _SeatID;

};

/**
 * UnRegisterSession:
 *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
 *     				  added product defined SessionName.
 *     	SessionOwner: This is the name of the application that originally registered the session.
 *     	              It will be validated that this value matches the stored value from the registration.
 *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
 *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to remove a new session from the session list hosted by NSM.
 */
class UnRegisterSessionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnRegisterSessionResponse ();

    /**
     * Copy constructor
     */
    inline  UnRegisterSessionResponse (const UnRegisterSessionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UnRegisterSessionResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~UnRegisterSessionResponse();

    /**
     * Assignment operator
     */
    inline UnRegisterSessionResponse& operator = (const UnRegisterSessionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnRegisterSessionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnRegisterSessionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnRegisterSessionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnRegisterSessionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const UnRegisterSessionResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * GetAppHealthCount:
 *     	Count:        Return value passed to the caller. Number of applications that crashed or terminated accidentally.
 *
 *     	The method returns the number of applications that crashed or terminated accidentally within the current life cycle. It can be used to observe the system state.
 */
class GetAppHealthCountResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAppHealthCountResponse ();

    /**
     * Copy constructor
     */
    inline  GetAppHealthCountResponse (const GetAppHealthCountResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetAppHealthCountResponse (uint32 Count_);

    /**
     * Destructor
     */
    inline virtual  ~GetAppHealthCountResponse();

    /**
     * Assignment operator
     */
    inline GetAppHealthCountResponse& operator = (const GetAppHealthCountResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAppHealthCountResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAppHealthCountResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAppHealthCountResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAppHealthCountResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Count"

    static const int kCount = 0;

    /**
     * Clears the field "Count".
     *
     * The field will be set to its default value. The hasCount()
     * method will return false.
     */
    inline void clearCount();

    /**
     * Checks whether the field "Count" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCount()). Otherwise it will return false.
     */
    inline bool hasCount () const;

    /**
     * Returns the value of the member "Count".
     *
     * If the meaning of "Count" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Count"
     */
    inline uint32 getCount () const;

    /**
     * Sets the value of the member "Count".
     *
     * If the meaning of "Count" isn't clear, then there should be a description here.
     *
     * @param Count The value which will be set
     */
    inline void setCount (uint32 Count_);

    static const GetAppHealthCountResponse &getDefaultInstance();

private:

    inline void set_has_Count ();

    inline void clear_has_Count ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Count;

};

/**
 * GetInterfaceVersion:
 *     	Version:      Unsigned integer that represents the version number of the Node State Manager.
 *
 *     	The method returns the version number of the Node State Manager. The number is organized in four bytes:
 *
 *     	Version: VVV.RRR.PPP.BBB
 *
 *     	<literallayout>
 *     		VVV => Version  [1..255]
 *     		RRR => Release  [0..255]
 *     		PPP => Patch    [0..255]
 *     		BBB => Build    [0..255]
 *     	</literallayout>
 */
class GetInterfaceVersionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetInterfaceVersionResponse ();

    /**
     * Copy constructor
     */
    inline  GetInterfaceVersionResponse (const GetInterfaceVersionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetInterfaceVersionResponse (uint32 Version_);

    /**
     * Destructor
     */
    inline virtual  ~GetInterfaceVersionResponse();

    /**
     * Assignment operator
     */
    inline GetInterfaceVersionResponse& operator = (const GetInterfaceVersionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetInterfaceVersionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetInterfaceVersionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetInterfaceVersionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetInterfaceVersionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Version"

    static const int kVersion = 0;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Version"
     */
    inline uint32 getVersion () const;

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (uint32 Version_);

    static const GetInterfaceVersionResponse &getDefaultInstance();

private:

    inline void set_has_Version ();

    inline void clear_has_Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Version;

};

/**
 * LifecycleRequestComplete:
 *         RequestId:    The request Id of the called life cycle client. The value has been passed when "LifecycleRequest" was called.
 *         Status:       The result of the call to "LifecycleRequest". NsmErrorStatus_Ok: Request successfully processed. NsmErrorStatus_Error:
 *                       An error occured while processing the "LifecycleRequest".
 *         ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *         The function has to be called by a "asynchrounous" lifecycle client when he processed the "LifecycleRequest".
 */
class LifecycleRequestCompleteRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifecycleRequestCompleteRequest ();

    /**
     * Copy constructor
     */
    inline  LifecycleRequestCompleteRequest (const LifecycleRequestCompleteRequest &rhs);

    /**
     * All fields constructor
     */
    inline  LifecycleRequestCompleteRequest (uint32 RequestId_, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e Status_);

    /**
     * Destructor
     */
    inline virtual  ~LifecycleRequestCompleteRequest();

    /**
     * Assignment operator
     */
    inline LifecycleRequestCompleteRequest& operator = (const LifecycleRequestCompleteRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifecycleRequestCompleteRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifecycleRequestCompleteRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifecycleRequestCompleteRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifecycleRequestCompleteRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequestId"

    static const int kRequestId = 0;

    /**
     * Clears the field "RequestId".
     *
     * The field will be set to its default value. The hasRequestId()
     * method will return false.
     */
    inline void clearRequestId();

    /**
     * Checks whether the field "RequestId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestId()). Otherwise it will return false.
     */
    inline bool hasRequestId () const;

    /**
     * Returns the value of the member "RequestId".
     *
     * If the meaning of "RequestId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RequestId"
     */
    inline uint32 getRequestId () const;

    /**
     * Sets the value of the member "RequestId".
     *
     * If the meaning of "RequestId" isn't clear, then there should be a description here.
     *
     * @param RequestId The value which will be set
     */
    inline void setRequestId (uint32 RequestId_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Status"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e Status_);

    static const LifecycleRequestCompleteRequest &getDefaultInstance();

private:

    inline void set_has_RequestId ();

    inline void clear_has_RequestId ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _RequestId;

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _Status;

};

/**
 * LifecycleRequestComplete:
 *         RequestId:    The request Id of the called life cycle client. The value has been passed when "LifecycleRequest" was called.
 *         Status:       The result of the call to "LifecycleRequest". NsmErrorStatus_Ok: Request successfully processed. NsmErrorStatus_Error:
 *                       An error occured while processing the "LifecycleRequest".
 *         ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
 *
 *         The function has to be called by a "asynchrounous" lifecycle client when he processed the "LifecycleRequest".
 */
class LifecycleRequestCompleteResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifecycleRequestCompleteResponse ();

    /**
     * Copy constructor
     */
    inline  LifecycleRequestCompleteResponse (const LifecycleRequestCompleteResponse &rhs);

    /**
     * All fields constructor
     */
    inline  LifecycleRequestCompleteResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~LifecycleRequestCompleteResponse();

    /**
     * Assignment operator
     */
    inline LifecycleRequestCompleteResponse& operator = (const LifecycleRequestCompleteResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifecycleRequestCompleteResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifecycleRequestCompleteResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifecycleRequestCompleteResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifecycleRequestCompleteResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const LifecycleRequestCompleteResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * RestartReason: This property informs clients about the reason for the last restart.
 *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
 */
class RestartReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  RestartReasonUpdate (const RestartReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RestartReasonUpdate (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReason_);

    /**
     * Destructor
     */
    inline virtual  ~RestartReasonUpdate();

    /**
     * Assignment operator
     */
    inline RestartReasonUpdate& operator = (const RestartReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RestartReason"

    static const int kRestartReason = 0;

    /**
     * Clears the field "RestartReason".
     *
     * The field will be set to its default value. The hasRestartReason()
     * method will return false.
     */
    inline void clearRestartReason();

    /**
     * Checks whether the field "RestartReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestartReason()). Otherwise it will return false.
     */
    inline bool hasRestartReason () const;

    /**
     * Returns the value of the member "RestartReason".
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     *
     * @return The value of the field "RestartReason"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e getRestartReason () const;

    /**
     * Sets the value of the member "RestartReason".
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     *
     * @param RestartReason The value which will be set
     */
    inline void setRestartReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReason_);

    static const RestartReasonUpdate &getDefaultInstance();

private:

    inline void set_has_RestartReason ();

    inline void clear_has_RestartReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e _RestartReason;

};

/**
 * RestartReason: This property informs clients about the reason for the last restart.
 *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
 */
class RestartReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartReasonRegister ();

    /**
     * Copy constructor
     */
    inline  RestartReasonRegister (const RestartReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RestartReasonRegister();

    /**
     * Assignment operator
     */
    inline RestartReasonRegister& operator = (const RestartReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RestartReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ShutdownReason: This property informs clients about the reason for the last shutdown.
 *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
 */
class ShutdownReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShutdownReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  ShutdownReasonUpdate (const ShutdownReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ShutdownReasonUpdate (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e ShutdownReason_);

    /**
     * Destructor
     */
    inline virtual  ~ShutdownReasonUpdate();

    /**
     * Assignment operator
     */
    inline ShutdownReasonUpdate& operator = (const ShutdownReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShutdownReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShutdownReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShutdownReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShutdownReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ShutdownReason"

    static const int kShutdownReason = 0;

    /**
     * Clears the field "ShutdownReason".
     *
     * The field will be set to its default value. The hasShutdownReason()
     * method will return false.
     */
    inline void clearShutdownReason();

    /**
     * Checks whether the field "ShutdownReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShutdownReason()). Otherwise it will return false.
     */
    inline bool hasShutdownReason () const;

    /**
     * Returns the value of the member "ShutdownReason".
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     *
     * @return The value of the field "ShutdownReason"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e getShutdownReason () const;

    /**
     * Sets the value of the member "ShutdownReason".
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     *
     * @param ShutdownReason The value which will be set
     */
    inline void setShutdownReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e ShutdownReason_);

    static const ShutdownReasonUpdate &getDefaultInstance();

private:

    inline void set_has_ShutdownReason ();

    inline void clear_has_ShutdownReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e _ShutdownReason;

};

/**
 * ShutdownReason: This property informs clients about the reason for the last shutdown.
 *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
 */
class ShutdownReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShutdownReasonRegister ();

    /**
     * Copy constructor
     */
    inline  ShutdownReasonRegister (const ShutdownReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ShutdownReasonRegister();

    /**
     * Assignment operator
     */
    inline ShutdownReasonRegister& operator = (const ShutdownReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShutdownReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShutdownReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShutdownReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShutdownReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ShutdownReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * WakeUpReason: This property informs clients about the recent reason for waking up the target.
 *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
 */
class WakeUpReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeUpReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  WakeUpReasonUpdate (const WakeUpReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WakeUpReasonUpdate (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e WakeUpReason_);

    /**
     * Destructor
     */
    inline virtual  ~WakeUpReasonUpdate();

    /**
     * Assignment operator
     */
    inline WakeUpReasonUpdate& operator = (const WakeUpReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeUpReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeUpReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeUpReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeUpReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeUpReason"

    static const int kWakeUpReason = 0;

    /**
     * Clears the field "WakeUpReason".
     *
     * The field will be set to its default value. The hasWakeUpReason()
     * method will return false.
     */
    inline void clearWakeUpReason();

    /**
     * Checks whether the field "WakeUpReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason () const;

    /**
     * Returns the value of the member "WakeUpReason".
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     *
     * @return The value of the field "WakeUpReason"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e getWakeUpReason () const;

    /**
     * Sets the value of the member "WakeUpReason".
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     *
     * @param WakeUpReason The value which will be set
     */
    inline void setWakeUpReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e WakeUpReason_);

    static const WakeUpReasonUpdate &getDefaultInstance();

private:

    inline void set_has_WakeUpReason ();

    inline void clear_has_WakeUpReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e _WakeUpReason;

};

/**
 * WakeUpReason: This property informs clients about the recent reason for waking up the target.
 *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
 */
class WakeUpReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeUpReasonRegister ();

    /**
     * Copy constructor
     */
    inline  WakeUpReasonRegister (const WakeUpReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WakeUpReasonRegister();

    /**
     * Assignment operator
     */
    inline WakeUpReasonRegister& operator = (const WakeUpReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeUpReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeUpReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeUpReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeUpReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WakeUpReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * BootMode: This property informs clients about the recent BootMode of the target.
 *                       The values will be defined by a third party header which has not been delivered yet.
 *                       The description needs to be updated as soon as the header is available.
 */
class BootModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BootModeUpdate ();

    /**
     * Copy constructor
     */
    inline  BootModeUpdate (const BootModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BootModeUpdate (int32 BootMode_);

    /**
     * Destructor
     */
    inline virtual  ~BootModeUpdate();

    /**
     * Assignment operator
     */
    inline BootModeUpdate& operator = (const BootModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BootModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BootModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BootModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BootModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BootMode"

    static const int kBootMode = 0;

    /**
     * Clears the field "BootMode".
     *
     * The field will be set to its default value. The hasBootMode()
     * method will return false.
     */
    inline void clearBootMode();

    /**
     * Checks whether the field "BootMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBootMode()). Otherwise it will return false.
     */
    inline bool hasBootMode () const;

    /**
     * Returns the value of the member "BootMode".
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     *
     * @return The value of the field "BootMode"
     */
    inline int32 getBootMode () const;

    /**
     * Sets the value of the member "BootMode".
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     *
     * @param BootMode The value which will be set
     */
    inline void setBootMode (int32 BootMode_);

    static const BootModeUpdate &getDefaultInstance();

private:

    inline void set_has_BootMode ();

    inline void clear_has_BootMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _BootMode;

};

/**
 * BootMode: This property informs clients about the recent BootMode of the target.
 *                       The values will be defined by a third party header which has not been delivered yet.
 *                       The description needs to be updated as soon as the header is available.
 */
class BootModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BootModeRegister ();

    /**
     * Copy constructor
     */
    inline  BootModeRegister (const BootModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BootModeRegister();

    /**
     * Assignment operator
     */
    inline BootModeRegister& operator = (const BootModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BootModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BootModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BootModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BootModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BootModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * NodeState:
 * 	   NodeState: Numeric value for the current NodeState defined in NsmNodeState_e.
 *
 * 	   Clients can register for notifications when the NodeState is updated inside the NodeStateManager.
 * 	   This signal is sent to registered clients and will include the current NodeState as a parameter.
 */
class NodeStateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NodeStateSignal ();

    /**
     * Copy constructor
     */
    inline  NodeStateSignal (const NodeStateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  NodeStateSignal (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeState_);

    /**
     * Destructor
     */
    inline virtual  ~NodeStateSignal();

    /**
     * Assignment operator
     */
    inline NodeStateSignal& operator = (const NodeStateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NodeStateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NodeStateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NodeStateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NodeStateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NodeState"

    static const int kNodeState = 0;

    /**
     * Clears the field "NodeState".
     *
     * The field will be set to its default value. The hasNodeState()
     * method will return false.
     */
    inline void clearNodeState();

    /**
     * Checks whether the field "NodeState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNodeState()). Otherwise it will return false.
     */
    inline bool hasNodeState () const;

    /**
     * Returns the value of the member "NodeState".
     *
     * If the meaning of "NodeState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "NodeState"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e getNodeState () const;

    /**
     * Sets the value of the member "NodeState".
     *
     * If the meaning of "NodeState" isn't clear, then there should be a description here.
     *
     * @param NodeState The value which will be set
     */
    inline void setNodeState (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeState_);

    static const NodeStateSignal &getDefaultInstance();

private:

    inline void set_has_NodeState ();

    inline void clear_has_NodeState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e _NodeState;

};

/**
 * NodeApplicationMode:
 * 	   ApplicationModeId: Numeric value for the current ApplicationMode defined in NsmAplicationMode_e.
 *
 * 	   Clients can register for notifications when the NodeApplicationMode is updated inside the NodeStateManager.
 * 	   This signal is sent to registered clients and will include the current NodeApplicationMode as a parameter.
 */
class NodeApplicationModeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NodeApplicationModeSignal ();

    /**
     * Copy constructor
     */
    inline  NodeApplicationModeSignal (const NodeApplicationModeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  NodeApplicationModeSignal (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_);

    /**
     * Destructor
     */
    inline virtual  ~NodeApplicationModeSignal();

    /**
     * Assignment operator
     */
    inline NodeApplicationModeSignal& operator = (const NodeApplicationModeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NodeApplicationModeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NodeApplicationModeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NodeApplicationModeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NodeApplicationModeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ApplicationModeId"

    static const int kApplicationModeId = 0;

    /**
     * Clears the field "ApplicationModeId".
     *
     * The field will be set to its default value. The hasApplicationModeId()
     * method will return false.
     */
    inline void clearApplicationModeId();

    /**
     * Checks whether the field "ApplicationModeId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationModeId()). Otherwise it will return false.
     */
    inline bool hasApplicationModeId () const;

    /**
     * Returns the value of the member "ApplicationModeId".
     *
     * If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ApplicationModeId"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e getApplicationModeId () const;

    /**
     * Sets the value of the member "ApplicationModeId".
     *
     * If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     *
     * @param ApplicationModeId The value which will be set
     */
    inline void setApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_);

    static const NodeApplicationModeSignal &getDefaultInstance();

private:

    inline void set_has_ApplicationModeId ();

    inline void clear_has_ApplicationModeId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e _ApplicationModeId;

};

/**
 * SessionStateChanged:
 *     	SessionStateName: The SessionName will be based upon either the pre-defined platform SessionNames or using a newly added product defined session name.
 *     	SeatID:           This parameter will be based upon the enum NsmSeat_e.
 *     	SessionState:     This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
 *     	                  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
 *
 *     	This signal is sent to registered clients when a particular session is state is changed.
 *     	The client can register for notification about a specific session through the use of the SessionName as a "match rule".
 */
class SessionStateChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SessionStateChangedSignal ();

    /**
     * Copy constructor
     */
    inline  SessionStateChangedSignal (const SessionStateChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SessionStateChangedSignal (const ::std::string& SessionStateName_, _NsmSeat_e SeatID_, _NsmSessionState_e SessionState_);

    /**
     * Destructor
     */
    inline virtual  ~SessionStateChangedSignal();

    /**
     * Assignment operator
     */
    inline SessionStateChangedSignal& operator = (const SessionStateChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SessionStateChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SessionStateChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SessionStateChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SessionStateChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionStateName"

    static const int kSessionStateName = 0;

    /**
     * Clears the field "SessionStateName".
     *
     * The field will be set to its default value. The hasSessionStateName()
     * method will return false.
     */
    inline void clearSessionStateName();

    /**
     * Checks whether the field "SessionStateName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionStateName()). Otherwise it will return false.
     */
    inline bool hasSessionStateName () const;

    /**
     * Returns the value of the member "SessionStateName".
     *
     * If the meaning of "SessionStateName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionStateName"
     */
    inline const ::std::string& getSessionStateName () const;

    /**
     * Retrieves the value of the field "SessionStateName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SessionStateName".
     */
    inline ::std::string& getSessionStateNameMutable ();

    /**
     * Sets the value of the member "SessionStateName".
     *
     * If the meaning of "SessionStateName" isn't clear, then there should be a description here.
     *
     * @param SessionStateName The value which will be set
     */
    inline void setSessionStateName (const ::std::string& SessionStateName_);

    /**
     * Sets the value of the member "SessionStateName".
     *
     * If the meaning of "SessionStateName" isn't clear, then there should be a description here.
     *
     * @param SessionStateName The value which will be set
     */
    inline void setSessionStateName (const char* SessionStateName_);

    /**
     * Sets the value of the member "SessionStateName".
     *
     * If the meaning of "SessionStateName" isn't clear, then there should be a description here.
     *
     * @param SessionStateName The value which will be set
     */
    inline void setSessionStateName (const char* value, size_t size);

    // API of field "SeatID"

    static const int kSeatID = 1;

    /**
     * Clears the field "SeatID".
     *
     * The field will be set to its default value. The hasSeatID()
     * method will return false.
     */
    inline void clearSeatID();

    /**
     * Checks whether the field "SeatID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSeatID()). Otherwise it will return false.
     */
    inline bool hasSeatID () const;

    /**
     * Returns the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SeatID"
     */
    inline _NsmSeat_e getSeatID () const;

    /**
     * Sets the value of the member "SeatID".
     *
     * If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @param SeatID The value which will be set
     */
    inline void setSeatID (_NsmSeat_e SeatID_);

    // API of field "SessionState"

    static const int kSessionState = 2;

    /**
     * Clears the field "SessionState".
     *
     * The field will be set to its default value. The hasSessionState()
     * method will return false.
     */
    inline void clearSessionState();

    /**
     * Checks whether the field "SessionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionState()). Otherwise it will return false.
     */
    inline bool hasSessionState () const;

    /**
     * Returns the value of the member "SessionState".
     *
     * If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SessionState"
     */
    inline _NsmSessionState_e getSessionState () const;

    /**
     * Sets the value of the member "SessionState".
     *
     * If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @param SessionState The value which will be set
     */
    inline void setSessionState (_NsmSessionState_e SessionState_);

    static const SessionStateChangedSignal &getDefaultInstance();

private:

    inline void set_has_SessionStateName ();

    inline void clear_has_SessionStateName ();

    inline void set_has_SeatID ();

    inline void clear_has_SeatID ();

    inline void set_has_SessionState ();

    inline void clear_has_SessionState ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _SessionStateName;

    _NsmSeat_e _SeatID;

    _NsmSessionState_e _SessionState;

};

inline  GetNodeStateResponse::GetNodeStateResponse ()  :
    _NodeStateId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNodeStateResponse::GetNodeStateResponse (const GetNodeStateResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _NodeStateId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNodeStateResponse::GetNodeStateResponse (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateId_, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _NodeStateId (NodeStateId_),
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e_IsValid(NodeStateId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", NodeStateId_, "_NsmNodeState_e", "NodeStateId", "GetNodeStateResponse");
    }
    #endif
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "GetNodeStateResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNodeStateResponse::~GetNodeStateResponse() {
}

inline GetNodeStateResponse& GetNodeStateResponse::operator = (const GetNodeStateResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNodeStateId()) {
            setNodeStateId(rhs.getNodeStateId());
        } else {
            clearNodeStateId();
        }
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetNodeStateResponse::operator == (const GetNodeStateResponse& rhs) const {
    return (((!hasNodeStateId() && !rhs.hasNodeStateId()) || getNodeStateId() == rhs.getNodeStateId()) &&
        ((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetNodeStateResponse::operator != (const GetNodeStateResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNodeStateResponse::operator < (const GetNodeStateResponse& rhs) const {
    if (hasNodeStateId() || rhs.hasNodeStateId()) {
        if ((uint32)getNodeStateId() < (uint32)rhs.getNodeStateId()) return true;
        if ((uint32)getNodeStateId() > (uint32)rhs.getNodeStateId()) return false;
    }
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNodeStateResponse::clone() {
    return new GetNodeStateResponse(*this);
}

inline bool GetNodeStateResponse::operator > (const GetNodeStateResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNodeStateResponse::clear() {
    clearNodeStateId();
    clearErrorCode();
}

inline void GetNodeStateResponse::clearNodeStateId() {
    if (hasNodeStateId()) {
         clear_has_NodeStateId();
        _NodeStateId = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet;
     }
}

inline bool GetNodeStateResponse::hasNodeStateId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e GetNodeStateResponse::getNodeStateId () const {
    return _NodeStateId;
}

inline void GetNodeStateResponse::setNodeStateId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateId_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e_IsValid(NodeStateId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", NodeStateId_, "_NsmNodeState_e", "NodeStateId", "GetNodeStateResponse");
    }
    #endif
    set_has_NodeStateId();
    this->_NodeStateId = NodeStateId_;
}

inline void GetNodeStateResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool GetNodeStateResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e GetNodeStateResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void GetNodeStateResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "GetNodeStateResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetNodeStateResponse::set_has_NodeStateId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNodeStateResponse::clear_has_NodeStateId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetNodeStateResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetNodeStateResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetSessionStateRequest::SetSessionStateRequest ()  :
    _SessionName (),
    _SessionOwner (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet),
    _SessionState (::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSessionStateRequest::SetSessionStateRequest (const SetSessionStateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionName (),
    _SessionOwner (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet),
    _SessionState (::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSessionStateRequest::SetSessionStateRequest (const ::std::string& SessionName_, const ::std::string& SessionOwner_, _NsmSeat_e SeatID_, _NsmSessionState_e SessionState_)  :
    _SessionName (SessionName_),
    _SessionOwner (SessionOwner_),
    _SeatID (SeatID_),
    _SessionState (SessionState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "SetSessionStateRequest");
    }
    #endif
    #ifndef NDEBUG
    if (!(_NsmSessionState_e_IsValid(SessionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SessionState_, "_NsmSessionState_e", "SessionState", "SetSessionStateRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSessionStateRequest::~SetSessionStateRequest() {
}

inline SetSessionStateRequest& SetSessionStateRequest::operator = (const SetSessionStateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionName()) {
            setSessionName(rhs.getSessionName());
        } else {
            clearSessionName();
        }
        if (rhs.hasSessionOwner()) {
            setSessionOwner(rhs.getSessionOwner());
        } else {
            clearSessionOwner();
        }
        if (rhs.hasSeatID()) {
            setSeatID(rhs.getSeatID());
        } else {
            clearSeatID();
        }
        if (rhs.hasSessionState()) {
            setSessionState(rhs.getSessionState());
        } else {
            clearSessionState();
        }
    }
    return *this;
}

inline bool SetSessionStateRequest::operator == (const SetSessionStateRequest& rhs) const {
    return (((!hasSessionName() && !rhs.hasSessionName()) || getSessionName() == rhs.getSessionName()) &&
        ((!hasSessionOwner() && !rhs.hasSessionOwner()) || getSessionOwner() == rhs.getSessionOwner()) &&
        ((!hasSeatID() && !rhs.hasSeatID()) || getSeatID() == rhs.getSeatID()) &&
        ((!hasSessionState() && !rhs.hasSessionState()) || getSessionState() == rhs.getSessionState()));
}

inline bool SetSessionStateRequest::operator != (const SetSessionStateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSessionStateRequest::operator < (const SetSessionStateRequest& rhs) const {
    if (hasSessionName() || rhs.hasSessionName()) {
        if (getSessionName() < rhs.getSessionName()) return true;
        if (getSessionName() > rhs.getSessionName()) return false;
    }
    if (hasSessionOwner() || rhs.hasSessionOwner()) {
        if (getSessionOwner() < rhs.getSessionOwner()) return true;
        if (getSessionOwner() > rhs.getSessionOwner()) return false;
    }
    if (hasSeatID() || rhs.hasSeatID()) {
        if ((uint32)getSeatID() < (uint32)rhs.getSeatID()) return true;
        if ((uint32)getSeatID() > (uint32)rhs.getSeatID()) return false;
    }
    if (hasSessionState() || rhs.hasSessionState()) {
        if ((uint32)getSessionState() < (uint32)rhs.getSessionState()) return true;
        if ((uint32)getSessionState() > (uint32)rhs.getSessionState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetSessionStateRequest::clone() {
    return new SetSessionStateRequest(*this);
}

inline bool SetSessionStateRequest::operator > (const SetSessionStateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSessionStateRequest::clear() {
    clearSessionName();
    clearSessionOwner();
    clearSeatID();
    clearSessionState();
}

inline void SetSessionStateRequest::clearSessionName() {
    if (hasSessionName()) {
         clear_has_SessionName();
        _SessionName.clear();
     }
}

inline bool SetSessionStateRequest::hasSessionName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetSessionStateRequest::getSessionName () const {
    return _SessionName;
}

inline ::std::string& SetSessionStateRequest::getSessionNameMutable () {
    set_has_SessionName();
    return _SessionName;
}

inline void SetSessionStateRequest::setSessionName (const ::std::string& SessionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName = SessionName_;
}

inline void SetSessionStateRequest::setSessionName (const char* SessionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName.assign(SessionName_);
}

inline void SetSessionStateRequest::setSessionName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName.assign(value, size);
}

inline void SetSessionStateRequest::clearSessionOwner() {
    if (hasSessionOwner()) {
         clear_has_SessionOwner();
        _SessionOwner.clear();
     }
}

inline bool SetSessionStateRequest::hasSessionOwner () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SetSessionStateRequest::getSessionOwner () const {
    return _SessionOwner;
}

inline ::std::string& SetSessionStateRequest::getSessionOwnerMutable () {
    set_has_SessionOwner();
    return _SessionOwner;
}

inline void SetSessionStateRequest::setSessionOwner (const ::std::string& SessionOwner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner = SessionOwner_;
}

inline void SetSessionStateRequest::setSessionOwner (const char* SessionOwner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner.assign(SessionOwner_);
}

inline void SetSessionStateRequest::setSessionOwner (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner.assign(value, size);
}

inline void SetSessionStateRequest::clearSeatID() {
    if (hasSeatID()) {
         clear_has_SeatID();
        _SeatID = ::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet;
     }
}

inline bool SetSessionStateRequest::hasSeatID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline _NsmSeat_e SetSessionStateRequest::getSeatID () const {
    return _SeatID;
}

inline void SetSessionStateRequest::setSeatID (_NsmSeat_e SeatID_) {
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "SetSessionStateRequest");
    }
    #endif
    set_has_SeatID();
    this->_SeatID = SeatID_;
}

inline void SetSessionStateRequest::clearSessionState() {
    if (hasSessionState()) {
         clear_has_SessionState();
        _SessionState = ::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered;
     }
}

inline bool SetSessionStateRequest::hasSessionState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline _NsmSessionState_e SetSessionStateRequest::getSessionState () const {
    return _SessionState;
}

inline void SetSessionStateRequest::setSessionState (_NsmSessionState_e SessionState_) {
    #ifndef NDEBUG
    if (!(_NsmSessionState_e_IsValid(SessionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SessionState_, "_NsmSessionState_e", "SessionState", "SetSessionStateRequest");
    }
    #endif
    set_has_SessionState();
    this->_SessionState = SessionState_;
}

inline void SetSessionStateRequest::set_has_SessionName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSessionStateRequest::clear_has_SessionName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetSessionStateRequest::set_has_SessionOwner () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetSessionStateRequest::clear_has_SessionOwner () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetSessionStateRequest::set_has_SeatID () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetSessionStateRequest::clear_has_SeatID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetSessionStateRequest::set_has_SessionState () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetSessionStateRequest::clear_has_SessionState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SetSessionStateResponse::SetSessionStateResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSessionStateResponse::SetSessionStateResponse (const SetSessionStateResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSessionStateResponse::SetSessionStateResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetSessionStateResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSessionStateResponse::~SetSessionStateResponse() {
}

inline SetSessionStateResponse& SetSessionStateResponse::operator = (const SetSessionStateResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetSessionStateResponse::operator == (const SetSessionStateResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetSessionStateResponse::operator != (const SetSessionStateResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSessionStateResponse::operator < (const SetSessionStateResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetSessionStateResponse::clone() {
    return new SetSessionStateResponse(*this);
}

inline bool SetSessionStateResponse::operator > (const SetSessionStateResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSessionStateResponse::clear() {
    clearErrorCode();
}

inline void SetSessionStateResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool SetSessionStateResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e SetSessionStateResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void SetSessionStateResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetSessionStateResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetSessionStateResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSessionStateResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSessionStateRequest::GetSessionStateRequest ()  :
    _SessionName (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSessionStateRequest::GetSessionStateRequest (const GetSessionStateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionName (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSessionStateRequest::GetSessionStateRequest (const ::std::string& SessionName_, _NsmSeat_e SeatID_)  :
    _SessionName (SessionName_),
    _SeatID (SeatID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "GetSessionStateRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSessionStateRequest::~GetSessionStateRequest() {
}

inline GetSessionStateRequest& GetSessionStateRequest::operator = (const GetSessionStateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionName()) {
            setSessionName(rhs.getSessionName());
        } else {
            clearSessionName();
        }
        if (rhs.hasSeatID()) {
            setSeatID(rhs.getSeatID());
        } else {
            clearSeatID();
        }
    }
    return *this;
}

inline bool GetSessionStateRequest::operator == (const GetSessionStateRequest& rhs) const {
    return (((!hasSessionName() && !rhs.hasSessionName()) || getSessionName() == rhs.getSessionName()) &&
        ((!hasSeatID() && !rhs.hasSeatID()) || getSeatID() == rhs.getSeatID()));
}

inline bool GetSessionStateRequest::operator != (const GetSessionStateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSessionStateRequest::operator < (const GetSessionStateRequest& rhs) const {
    if (hasSessionName() || rhs.hasSessionName()) {
        if (getSessionName() < rhs.getSessionName()) return true;
        if (getSessionName() > rhs.getSessionName()) return false;
    }
    if (hasSeatID() || rhs.hasSeatID()) {
        if ((uint32)getSeatID() < (uint32)rhs.getSeatID()) return true;
        if ((uint32)getSeatID() > (uint32)rhs.getSeatID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSessionStateRequest::clone() {
    return new GetSessionStateRequest(*this);
}

inline bool GetSessionStateRequest::operator > (const GetSessionStateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSessionStateRequest::clear() {
    clearSessionName();
    clearSeatID();
}

inline void GetSessionStateRequest::clearSessionName() {
    if (hasSessionName()) {
         clear_has_SessionName();
        _SessionName.clear();
     }
}

inline bool GetSessionStateRequest::hasSessionName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetSessionStateRequest::getSessionName () const {
    return _SessionName;
}

inline ::std::string& GetSessionStateRequest::getSessionNameMutable () {
    set_has_SessionName();
    return _SessionName;
}

inline void GetSessionStateRequest::setSessionName (const ::std::string& SessionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName = SessionName_;
}

inline void GetSessionStateRequest::setSessionName (const char* SessionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName.assign(SessionName_);
}

inline void GetSessionStateRequest::setSessionName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName.assign(value, size);
}

inline void GetSessionStateRequest::clearSeatID() {
    if (hasSeatID()) {
         clear_has_SeatID();
        _SeatID = ::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet;
     }
}

inline bool GetSessionStateRequest::hasSeatID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline _NsmSeat_e GetSessionStateRequest::getSeatID () const {
    return _SeatID;
}

inline void GetSessionStateRequest::setSeatID (_NsmSeat_e SeatID_) {
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "GetSessionStateRequest");
    }
    #endif
    set_has_SeatID();
    this->_SeatID = SeatID_;
}

inline void GetSessionStateRequest::set_has_SessionName () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSessionStateRequest::clear_has_SessionName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetSessionStateRequest::set_has_SeatID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetSessionStateRequest::clear_has_SeatID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetSessionStateResponse::GetSessionStateResponse ()  :
    _SessionState (::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSessionStateResponse::GetSessionStateResponse (const GetSessionStateResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionState (::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSessionStateResponse::GetSessionStateResponse (_NsmSessionState_e SessionState_, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _SessionState (SessionState_),
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(_NsmSessionState_e_IsValid(SessionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SessionState_, "_NsmSessionState_e", "SessionState", "GetSessionStateResponse");
    }
    #endif
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "GetSessionStateResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSessionStateResponse::~GetSessionStateResponse() {
}

inline GetSessionStateResponse& GetSessionStateResponse::operator = (const GetSessionStateResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionState()) {
            setSessionState(rhs.getSessionState());
        } else {
            clearSessionState();
        }
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetSessionStateResponse::operator == (const GetSessionStateResponse& rhs) const {
    return (((!hasSessionState() && !rhs.hasSessionState()) || getSessionState() == rhs.getSessionState()) &&
        ((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetSessionStateResponse::operator != (const GetSessionStateResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSessionStateResponse::operator < (const GetSessionStateResponse& rhs) const {
    if (hasSessionState() || rhs.hasSessionState()) {
        if ((uint32)getSessionState() < (uint32)rhs.getSessionState()) return true;
        if ((uint32)getSessionState() > (uint32)rhs.getSessionState()) return false;
    }
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSessionStateResponse::clone() {
    return new GetSessionStateResponse(*this);
}

inline bool GetSessionStateResponse::operator > (const GetSessionStateResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSessionStateResponse::clear() {
    clearSessionState();
    clearErrorCode();
}

inline void GetSessionStateResponse::clearSessionState() {
    if (hasSessionState()) {
         clear_has_SessionState();
        _SessionState = ::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered;
     }
}

inline bool GetSessionStateResponse::hasSessionState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline _NsmSessionState_e GetSessionStateResponse::getSessionState () const {
    return _SessionState;
}

inline void GetSessionStateResponse::setSessionState (_NsmSessionState_e SessionState_) {
    #ifndef NDEBUG
    if (!(_NsmSessionState_e_IsValid(SessionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SessionState_, "_NsmSessionState_e", "SessionState", "GetSessionStateResponse");
    }
    #endif
    set_has_SessionState();
    this->_SessionState = SessionState_;
}

inline void GetSessionStateResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool GetSessionStateResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e GetSessionStateResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void GetSessionStateResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "GetSessionStateResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetSessionStateResponse::set_has_SessionState () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSessionStateResponse::clear_has_SessionState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetSessionStateResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetSessionStateResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetApplicationModeResponse::GetApplicationModeResponse ()  :
    _ApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetApplicationModeResponse::GetApplicationModeResponse (const GetApplicationModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetApplicationModeResponse::GetApplicationModeResponse (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ApplicationModeId (ApplicationModeId_),
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e_IsValid(ApplicationModeId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ApplicationModeId_, "_NsmApplicationMode_e", "ApplicationModeId", "GetApplicationModeResponse");
    }
    #endif
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "GetApplicationModeResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetApplicationModeResponse::~GetApplicationModeResponse() {
}

inline GetApplicationModeResponse& GetApplicationModeResponse::operator = (const GetApplicationModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasApplicationModeId()) {
            setApplicationModeId(rhs.getApplicationModeId());
        } else {
            clearApplicationModeId();
        }
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetApplicationModeResponse::operator == (const GetApplicationModeResponse& rhs) const {
    return (((!hasApplicationModeId() && !rhs.hasApplicationModeId()) || getApplicationModeId() == rhs.getApplicationModeId()) &&
        ((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetApplicationModeResponse::operator != (const GetApplicationModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetApplicationModeResponse::operator < (const GetApplicationModeResponse& rhs) const {
    if (hasApplicationModeId() || rhs.hasApplicationModeId()) {
        if ((uint32)getApplicationModeId() < (uint32)rhs.getApplicationModeId()) return true;
        if ((uint32)getApplicationModeId() > (uint32)rhs.getApplicationModeId()) return false;
    }
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetApplicationModeResponse::clone() {
    return new GetApplicationModeResponse(*this);
}

inline bool GetApplicationModeResponse::operator > (const GetApplicationModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetApplicationModeResponse::clear() {
    clearApplicationModeId();
    clearErrorCode();
}

inline void GetApplicationModeResponse::clearApplicationModeId() {
    if (hasApplicationModeId()) {
         clear_has_ApplicationModeId();
        _ApplicationModeId = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet;
     }
}

inline bool GetApplicationModeResponse::hasApplicationModeId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e GetApplicationModeResponse::getApplicationModeId () const {
    return _ApplicationModeId;
}

inline void GetApplicationModeResponse::setApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e_IsValid(ApplicationModeId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ApplicationModeId_, "_NsmApplicationMode_e", "ApplicationModeId", "GetApplicationModeResponse");
    }
    #endif
    set_has_ApplicationModeId();
    this->_ApplicationModeId = ApplicationModeId_;
}

inline void GetApplicationModeResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool GetApplicationModeResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e GetApplicationModeResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void GetApplicationModeResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "GetApplicationModeResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetApplicationModeResponse::set_has_ApplicationModeId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetApplicationModeResponse::clear_has_ApplicationModeId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetApplicationModeResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetApplicationModeResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RegisterShutdownClientRequest::RegisterShutdownClientRequest ()  :
    _BusName (),
    _ObjName (),
    _ShutdownMode (0u),
    _TimeoutMs (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterShutdownClientRequest::RegisterShutdownClientRequest (const RegisterShutdownClientRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _BusName (),
    _ObjName (),
    _ShutdownMode (0u),
    _TimeoutMs (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterShutdownClientRequest::RegisterShutdownClientRequest (const ::std::string& BusName_, const ::std::string& ObjName_, uint32 ShutdownMode_, uint32 TimeoutMs_)  :
    _BusName (BusName_),
    _ObjName (ObjName_),
    _ShutdownMode (ShutdownMode_),
    _TimeoutMs (TimeoutMs_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BusName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterShutdownClientRequest::~RegisterShutdownClientRequest() {
}

inline RegisterShutdownClientRequest& RegisterShutdownClientRequest::operator = (const RegisterShutdownClientRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBusName()) {
            setBusName(rhs.getBusName());
        } else {
            clearBusName();
        }
        if (rhs.hasObjName()) {
            setObjName(rhs.getObjName());
        } else {
            clearObjName();
        }
        if (rhs.hasShutdownMode()) {
            setShutdownMode(rhs.getShutdownMode());
        } else {
            clearShutdownMode();
        }
        if (rhs.hasTimeoutMs()) {
            setTimeoutMs(rhs.getTimeoutMs());
        } else {
            clearTimeoutMs();
        }
    }
    return *this;
}

inline bool RegisterShutdownClientRequest::operator == (const RegisterShutdownClientRequest& rhs) const {
    return (((!hasBusName() && !rhs.hasBusName()) || getBusName() == rhs.getBusName()) &&
        ((!hasObjName() && !rhs.hasObjName()) || getObjName() == rhs.getObjName()) &&
        ((!hasShutdownMode() && !rhs.hasShutdownMode()) || getShutdownMode() == rhs.getShutdownMode()) &&
        ((!hasTimeoutMs() && !rhs.hasTimeoutMs()) || getTimeoutMs() == rhs.getTimeoutMs()));
}

inline bool RegisterShutdownClientRequest::operator != (const RegisterShutdownClientRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterShutdownClientRequest::operator < (const RegisterShutdownClientRequest& rhs) const {
    if (hasBusName() || rhs.hasBusName()) {
        if (getBusName() < rhs.getBusName()) return true;
        if (getBusName() > rhs.getBusName()) return false;
    }
    if (hasObjName() || rhs.hasObjName()) {
        if (getObjName() < rhs.getObjName()) return true;
        if (getObjName() > rhs.getObjName()) return false;
    }
    if (hasShutdownMode() || rhs.hasShutdownMode()) {
        if (getShutdownMode() < rhs.getShutdownMode()) return true;
        if (getShutdownMode() > rhs.getShutdownMode()) return false;
    }
    if (hasTimeoutMs() || rhs.hasTimeoutMs()) {
        if (getTimeoutMs() < rhs.getTimeoutMs()) return true;
        if (getTimeoutMs() > rhs.getTimeoutMs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterShutdownClientRequest::clone() {
    return new RegisterShutdownClientRequest(*this);
}

inline bool RegisterShutdownClientRequest::operator > (const RegisterShutdownClientRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterShutdownClientRequest::clear() {
    clearBusName();
    clearObjName();
    clearShutdownMode();
    clearTimeoutMs();
}

inline void RegisterShutdownClientRequest::clearBusName() {
    if (hasBusName()) {
         clear_has_BusName();
        _BusName.clear();
     }
}

inline bool RegisterShutdownClientRequest::hasBusName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterShutdownClientRequest::getBusName () const {
    return _BusName;
}

inline ::std::string& RegisterShutdownClientRequest::getBusNameMutable () {
    set_has_BusName();
    return _BusName;
}

inline void RegisterShutdownClientRequest::setBusName (const ::std::string& BusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BusName();
    this->_BusName = BusName_;
}

inline void RegisterShutdownClientRequest::setBusName (const char* BusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BusName();
    this->_BusName.assign(BusName_);
}

inline void RegisterShutdownClientRequest::setBusName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BusName();
    this->_BusName.assign(value, size);
}

inline void RegisterShutdownClientRequest::clearObjName() {
    if (hasObjName()) {
         clear_has_ObjName();
        _ObjName.clear();
     }
}

inline bool RegisterShutdownClientRequest::hasObjName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RegisterShutdownClientRequest::getObjName () const {
    return _ObjName;
}

inline ::std::string& RegisterShutdownClientRequest::getObjNameMutable () {
    set_has_ObjName();
    return _ObjName;
}

inline void RegisterShutdownClientRequest::setObjName (const ::std::string& ObjName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjName();
    this->_ObjName = ObjName_;
}

inline void RegisterShutdownClientRequest::setObjName (const char* ObjName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjName();
    this->_ObjName.assign(ObjName_);
}

inline void RegisterShutdownClientRequest::setObjName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjName();
    this->_ObjName.assign(value, size);
}

inline void RegisterShutdownClientRequest::clearShutdownMode() {
    if (hasShutdownMode()) {
         clear_has_ShutdownMode();
        _ShutdownMode = 0u;
     }
}

inline bool RegisterShutdownClientRequest::hasShutdownMode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RegisterShutdownClientRequest::getShutdownMode () const {
    return _ShutdownMode;
}

inline void RegisterShutdownClientRequest::setShutdownMode (uint32 ShutdownMode_) {
    set_has_ShutdownMode();
    this->_ShutdownMode = ShutdownMode_;
}

inline void RegisterShutdownClientRequest::clearTimeoutMs() {
    if (hasTimeoutMs()) {
         clear_has_TimeoutMs();
        _TimeoutMs = 0u;
     }
}

inline bool RegisterShutdownClientRequest::hasTimeoutMs () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 RegisterShutdownClientRequest::getTimeoutMs () const {
    return _TimeoutMs;
}

inline void RegisterShutdownClientRequest::setTimeoutMs (uint32 TimeoutMs_) {
    set_has_TimeoutMs();
    this->_TimeoutMs = TimeoutMs_;
}

inline void RegisterShutdownClientRequest::set_has_BusName () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterShutdownClientRequest::clear_has_BusName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterShutdownClientRequest::set_has_ObjName () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterShutdownClientRequest::clear_has_ObjName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RegisterShutdownClientRequest::set_has_ShutdownMode () {
    _has_bits_[0] |= 1u << 2;
}

inline void RegisterShutdownClientRequest::clear_has_ShutdownMode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RegisterShutdownClientRequest::set_has_TimeoutMs () {
    _has_bits_[0] |= 1u << 3;
}

inline void RegisterShutdownClientRequest::clear_has_TimeoutMs () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RegisterShutdownClientResponse::RegisterShutdownClientResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterShutdownClientResponse::RegisterShutdownClientResponse (const RegisterShutdownClientResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterShutdownClientResponse::RegisterShutdownClientResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "RegisterShutdownClientResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterShutdownClientResponse::~RegisterShutdownClientResponse() {
}

inline RegisterShutdownClientResponse& RegisterShutdownClientResponse::operator = (const RegisterShutdownClientResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool RegisterShutdownClientResponse::operator == (const RegisterShutdownClientResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool RegisterShutdownClientResponse::operator != (const RegisterShutdownClientResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterShutdownClientResponse::operator < (const RegisterShutdownClientResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterShutdownClientResponse::clone() {
    return new RegisterShutdownClientResponse(*this);
}

inline bool RegisterShutdownClientResponse::operator > (const RegisterShutdownClientResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterShutdownClientResponse::clear() {
    clearErrorCode();
}

inline void RegisterShutdownClientResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool RegisterShutdownClientResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e RegisterShutdownClientResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void RegisterShutdownClientResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "RegisterShutdownClientResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void RegisterShutdownClientResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterShutdownClientResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnRegisterShutdownClientRequest::UnRegisterShutdownClientRequest ()  :
    _BusName (),
    _ObjName (),
    _ShutdownMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnRegisterShutdownClientRequest::UnRegisterShutdownClientRequest (const UnRegisterShutdownClientRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _BusName (),
    _ObjName (),
    _ShutdownMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnRegisterShutdownClientRequest::UnRegisterShutdownClientRequest (const ::std::string& BusName_, const ::std::string& ObjName_, uint32 ShutdownMode_)  :
    _BusName (BusName_),
    _ObjName (ObjName_),
    _ShutdownMode (ShutdownMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BusName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnRegisterShutdownClientRequest::~UnRegisterShutdownClientRequest() {
}

inline UnRegisterShutdownClientRequest& UnRegisterShutdownClientRequest::operator = (const UnRegisterShutdownClientRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBusName()) {
            setBusName(rhs.getBusName());
        } else {
            clearBusName();
        }
        if (rhs.hasObjName()) {
            setObjName(rhs.getObjName());
        } else {
            clearObjName();
        }
        if (rhs.hasShutdownMode()) {
            setShutdownMode(rhs.getShutdownMode());
        } else {
            clearShutdownMode();
        }
    }
    return *this;
}

inline bool UnRegisterShutdownClientRequest::operator == (const UnRegisterShutdownClientRequest& rhs) const {
    return (((!hasBusName() && !rhs.hasBusName()) || getBusName() == rhs.getBusName()) &&
        ((!hasObjName() && !rhs.hasObjName()) || getObjName() == rhs.getObjName()) &&
        ((!hasShutdownMode() && !rhs.hasShutdownMode()) || getShutdownMode() == rhs.getShutdownMode()));
}

inline bool UnRegisterShutdownClientRequest::operator != (const UnRegisterShutdownClientRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnRegisterShutdownClientRequest::operator < (const UnRegisterShutdownClientRequest& rhs) const {
    if (hasBusName() || rhs.hasBusName()) {
        if (getBusName() < rhs.getBusName()) return true;
        if (getBusName() > rhs.getBusName()) return false;
    }
    if (hasObjName() || rhs.hasObjName()) {
        if (getObjName() < rhs.getObjName()) return true;
        if (getObjName() > rhs.getObjName()) return false;
    }
    if (hasShutdownMode() || rhs.hasShutdownMode()) {
        if (getShutdownMode() < rhs.getShutdownMode()) return true;
        if (getShutdownMode() > rhs.getShutdownMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnRegisterShutdownClientRequest::clone() {
    return new UnRegisterShutdownClientRequest(*this);
}

inline bool UnRegisterShutdownClientRequest::operator > (const UnRegisterShutdownClientRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnRegisterShutdownClientRequest::clear() {
    clearBusName();
    clearObjName();
    clearShutdownMode();
}

inline void UnRegisterShutdownClientRequest::clearBusName() {
    if (hasBusName()) {
         clear_has_BusName();
        _BusName.clear();
     }
}

inline bool UnRegisterShutdownClientRequest::hasBusName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnRegisterShutdownClientRequest::getBusName () const {
    return _BusName;
}

inline ::std::string& UnRegisterShutdownClientRequest::getBusNameMutable () {
    set_has_BusName();
    return _BusName;
}

inline void UnRegisterShutdownClientRequest::setBusName (const ::std::string& BusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BusName();
    this->_BusName = BusName_;
}

inline void UnRegisterShutdownClientRequest::setBusName (const char* BusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BusName();
    this->_BusName.assign(BusName_);
}

inline void UnRegisterShutdownClientRequest::setBusName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BusName();
    this->_BusName.assign(value, size);
}

inline void UnRegisterShutdownClientRequest::clearObjName() {
    if (hasObjName()) {
         clear_has_ObjName();
        _ObjName.clear();
     }
}

inline bool UnRegisterShutdownClientRequest::hasObjName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& UnRegisterShutdownClientRequest::getObjName () const {
    return _ObjName;
}

inline ::std::string& UnRegisterShutdownClientRequest::getObjNameMutable () {
    set_has_ObjName();
    return _ObjName;
}

inline void UnRegisterShutdownClientRequest::setObjName (const ::std::string& ObjName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjName();
    this->_ObjName = ObjName_;
}

inline void UnRegisterShutdownClientRequest::setObjName (const char* ObjName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjName();
    this->_ObjName.assign(ObjName_);
}

inline void UnRegisterShutdownClientRequest::setObjName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjName();
    this->_ObjName.assign(value, size);
}

inline void UnRegisterShutdownClientRequest::clearShutdownMode() {
    if (hasShutdownMode()) {
         clear_has_ShutdownMode();
        _ShutdownMode = 0u;
     }
}

inline bool UnRegisterShutdownClientRequest::hasShutdownMode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 UnRegisterShutdownClientRequest::getShutdownMode () const {
    return _ShutdownMode;
}

inline void UnRegisterShutdownClientRequest::setShutdownMode (uint32 ShutdownMode_) {
    set_has_ShutdownMode();
    this->_ShutdownMode = ShutdownMode_;
}

inline void UnRegisterShutdownClientRequest::set_has_BusName () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnRegisterShutdownClientRequest::clear_has_BusName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UnRegisterShutdownClientRequest::set_has_ObjName () {
    _has_bits_[0] |= 1u << 1;
}

inline void UnRegisterShutdownClientRequest::clear_has_ObjName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UnRegisterShutdownClientRequest::set_has_ShutdownMode () {
    _has_bits_[0] |= 1u << 2;
}

inline void UnRegisterShutdownClientRequest::clear_has_ShutdownMode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  UnRegisterShutdownClientResponse::UnRegisterShutdownClientResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnRegisterShutdownClientResponse::UnRegisterShutdownClientResponse (const UnRegisterShutdownClientResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnRegisterShutdownClientResponse::UnRegisterShutdownClientResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "UnRegisterShutdownClientResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnRegisterShutdownClientResponse::~UnRegisterShutdownClientResponse() {
}

inline UnRegisterShutdownClientResponse& UnRegisterShutdownClientResponse::operator = (const UnRegisterShutdownClientResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool UnRegisterShutdownClientResponse::operator == (const UnRegisterShutdownClientResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool UnRegisterShutdownClientResponse::operator != (const UnRegisterShutdownClientResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UnRegisterShutdownClientResponse::operator < (const UnRegisterShutdownClientResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnRegisterShutdownClientResponse::clone() {
    return new UnRegisterShutdownClientResponse(*this);
}

inline bool UnRegisterShutdownClientResponse::operator > (const UnRegisterShutdownClientResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnRegisterShutdownClientResponse::clear() {
    clearErrorCode();
}

inline void UnRegisterShutdownClientResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool UnRegisterShutdownClientResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e UnRegisterShutdownClientResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void UnRegisterShutdownClientResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "UnRegisterShutdownClientResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void UnRegisterShutdownClientResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnRegisterShutdownClientResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RegisterSessionRequest::RegisterSessionRequest ()  :
    _SessionName (),
    _SessionOwner (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet),
    _SessionState (::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterSessionRequest::RegisterSessionRequest (const RegisterSessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionName (),
    _SessionOwner (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet),
    _SessionState (::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterSessionRequest::RegisterSessionRequest (const ::std::string& SessionName_, const ::std::string& SessionOwner_, _NsmSeat_e SeatID_, _NsmSessionState_e SessionState_)  :
    _SessionName (SessionName_),
    _SessionOwner (SessionOwner_),
    _SeatID (SeatID_),
    _SessionState (SessionState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "RegisterSessionRequest");
    }
    #endif
    #ifndef NDEBUG
    if (!(_NsmSessionState_e_IsValid(SessionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SessionState_, "_NsmSessionState_e", "SessionState", "RegisterSessionRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterSessionRequest::~RegisterSessionRequest() {
}

inline RegisterSessionRequest& RegisterSessionRequest::operator = (const RegisterSessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionName()) {
            setSessionName(rhs.getSessionName());
        } else {
            clearSessionName();
        }
        if (rhs.hasSessionOwner()) {
            setSessionOwner(rhs.getSessionOwner());
        } else {
            clearSessionOwner();
        }
        if (rhs.hasSeatID()) {
            setSeatID(rhs.getSeatID());
        } else {
            clearSeatID();
        }
        if (rhs.hasSessionState()) {
            setSessionState(rhs.getSessionState());
        } else {
            clearSessionState();
        }
    }
    return *this;
}

inline bool RegisterSessionRequest::operator == (const RegisterSessionRequest& rhs) const {
    return (((!hasSessionName() && !rhs.hasSessionName()) || getSessionName() == rhs.getSessionName()) &&
        ((!hasSessionOwner() && !rhs.hasSessionOwner()) || getSessionOwner() == rhs.getSessionOwner()) &&
        ((!hasSeatID() && !rhs.hasSeatID()) || getSeatID() == rhs.getSeatID()) &&
        ((!hasSessionState() && !rhs.hasSessionState()) || getSessionState() == rhs.getSessionState()));
}

inline bool RegisterSessionRequest::operator != (const RegisterSessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterSessionRequest::operator < (const RegisterSessionRequest& rhs) const {
    if (hasSessionName() || rhs.hasSessionName()) {
        if (getSessionName() < rhs.getSessionName()) return true;
        if (getSessionName() > rhs.getSessionName()) return false;
    }
    if (hasSessionOwner() || rhs.hasSessionOwner()) {
        if (getSessionOwner() < rhs.getSessionOwner()) return true;
        if (getSessionOwner() > rhs.getSessionOwner()) return false;
    }
    if (hasSeatID() || rhs.hasSeatID()) {
        if ((uint32)getSeatID() < (uint32)rhs.getSeatID()) return true;
        if ((uint32)getSeatID() > (uint32)rhs.getSeatID()) return false;
    }
    if (hasSessionState() || rhs.hasSessionState()) {
        if ((uint32)getSessionState() < (uint32)rhs.getSessionState()) return true;
        if ((uint32)getSessionState() > (uint32)rhs.getSessionState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterSessionRequest::clone() {
    return new RegisterSessionRequest(*this);
}

inline bool RegisterSessionRequest::operator > (const RegisterSessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterSessionRequest::clear() {
    clearSessionName();
    clearSessionOwner();
    clearSeatID();
    clearSessionState();
}

inline void RegisterSessionRequest::clearSessionName() {
    if (hasSessionName()) {
         clear_has_SessionName();
        _SessionName.clear();
     }
}

inline bool RegisterSessionRequest::hasSessionName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterSessionRequest::getSessionName () const {
    return _SessionName;
}

inline ::std::string& RegisterSessionRequest::getSessionNameMutable () {
    set_has_SessionName();
    return _SessionName;
}

inline void RegisterSessionRequest::setSessionName (const ::std::string& SessionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName = SessionName_;
}

inline void RegisterSessionRequest::setSessionName (const char* SessionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName.assign(SessionName_);
}

inline void RegisterSessionRequest::setSessionName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName.assign(value, size);
}

inline void RegisterSessionRequest::clearSessionOwner() {
    if (hasSessionOwner()) {
         clear_has_SessionOwner();
        _SessionOwner.clear();
     }
}

inline bool RegisterSessionRequest::hasSessionOwner () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RegisterSessionRequest::getSessionOwner () const {
    return _SessionOwner;
}

inline ::std::string& RegisterSessionRequest::getSessionOwnerMutable () {
    set_has_SessionOwner();
    return _SessionOwner;
}

inline void RegisterSessionRequest::setSessionOwner (const ::std::string& SessionOwner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner = SessionOwner_;
}

inline void RegisterSessionRequest::setSessionOwner (const char* SessionOwner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner.assign(SessionOwner_);
}

inline void RegisterSessionRequest::setSessionOwner (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner.assign(value, size);
}

inline void RegisterSessionRequest::clearSeatID() {
    if (hasSeatID()) {
         clear_has_SeatID();
        _SeatID = ::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet;
     }
}

inline bool RegisterSessionRequest::hasSeatID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline _NsmSeat_e RegisterSessionRequest::getSeatID () const {
    return _SeatID;
}

inline void RegisterSessionRequest::setSeatID (_NsmSeat_e SeatID_) {
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "RegisterSessionRequest");
    }
    #endif
    set_has_SeatID();
    this->_SeatID = SeatID_;
}

inline void RegisterSessionRequest::clearSessionState() {
    if (hasSessionState()) {
         clear_has_SessionState();
        _SessionState = ::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered;
     }
}

inline bool RegisterSessionRequest::hasSessionState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline _NsmSessionState_e RegisterSessionRequest::getSessionState () const {
    return _SessionState;
}

inline void RegisterSessionRequest::setSessionState (_NsmSessionState_e SessionState_) {
    #ifndef NDEBUG
    if (!(_NsmSessionState_e_IsValid(SessionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SessionState_, "_NsmSessionState_e", "SessionState", "RegisterSessionRequest");
    }
    #endif
    set_has_SessionState();
    this->_SessionState = SessionState_;
}

inline void RegisterSessionRequest::set_has_SessionName () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterSessionRequest::clear_has_SessionName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterSessionRequest::set_has_SessionOwner () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterSessionRequest::clear_has_SessionOwner () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RegisterSessionRequest::set_has_SeatID () {
    _has_bits_[0] |= 1u << 2;
}

inline void RegisterSessionRequest::clear_has_SeatID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RegisterSessionRequest::set_has_SessionState () {
    _has_bits_[0] |= 1u << 3;
}

inline void RegisterSessionRequest::clear_has_SessionState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RegisterSessionResponse::RegisterSessionResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterSessionResponse::RegisterSessionResponse (const RegisterSessionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterSessionResponse::RegisterSessionResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "RegisterSessionResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterSessionResponse::~RegisterSessionResponse() {
}

inline RegisterSessionResponse& RegisterSessionResponse::operator = (const RegisterSessionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool RegisterSessionResponse::operator == (const RegisterSessionResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool RegisterSessionResponse::operator != (const RegisterSessionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterSessionResponse::operator < (const RegisterSessionResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterSessionResponse::clone() {
    return new RegisterSessionResponse(*this);
}

inline bool RegisterSessionResponse::operator > (const RegisterSessionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterSessionResponse::clear() {
    clearErrorCode();
}

inline void RegisterSessionResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool RegisterSessionResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e RegisterSessionResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void RegisterSessionResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "RegisterSessionResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void RegisterSessionResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterSessionResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnRegisterSessionRequest::UnRegisterSessionRequest ()  :
    _SessionName (),
    _SessionOwner (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnRegisterSessionRequest::UnRegisterSessionRequest (const UnRegisterSessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionName (),
    _SessionOwner (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnRegisterSessionRequest::UnRegisterSessionRequest (const ::std::string& SessionName_, const ::std::string& SessionOwner_, _NsmSeat_e SeatID_)  :
    _SessionName (SessionName_),
    _SessionOwner (SessionOwner_),
    _SeatID (SeatID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "UnRegisterSessionRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnRegisterSessionRequest::~UnRegisterSessionRequest() {
}

inline UnRegisterSessionRequest& UnRegisterSessionRequest::operator = (const UnRegisterSessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionName()) {
            setSessionName(rhs.getSessionName());
        } else {
            clearSessionName();
        }
        if (rhs.hasSessionOwner()) {
            setSessionOwner(rhs.getSessionOwner());
        } else {
            clearSessionOwner();
        }
        if (rhs.hasSeatID()) {
            setSeatID(rhs.getSeatID());
        } else {
            clearSeatID();
        }
    }
    return *this;
}

inline bool UnRegisterSessionRequest::operator == (const UnRegisterSessionRequest& rhs) const {
    return (((!hasSessionName() && !rhs.hasSessionName()) || getSessionName() == rhs.getSessionName()) &&
        ((!hasSessionOwner() && !rhs.hasSessionOwner()) || getSessionOwner() == rhs.getSessionOwner()) &&
        ((!hasSeatID() && !rhs.hasSeatID()) || getSeatID() == rhs.getSeatID()));
}

inline bool UnRegisterSessionRequest::operator != (const UnRegisterSessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnRegisterSessionRequest::operator < (const UnRegisterSessionRequest& rhs) const {
    if (hasSessionName() || rhs.hasSessionName()) {
        if (getSessionName() < rhs.getSessionName()) return true;
        if (getSessionName() > rhs.getSessionName()) return false;
    }
    if (hasSessionOwner() || rhs.hasSessionOwner()) {
        if (getSessionOwner() < rhs.getSessionOwner()) return true;
        if (getSessionOwner() > rhs.getSessionOwner()) return false;
    }
    if (hasSeatID() || rhs.hasSeatID()) {
        if ((uint32)getSeatID() < (uint32)rhs.getSeatID()) return true;
        if ((uint32)getSeatID() > (uint32)rhs.getSeatID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnRegisterSessionRequest::clone() {
    return new UnRegisterSessionRequest(*this);
}

inline bool UnRegisterSessionRequest::operator > (const UnRegisterSessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnRegisterSessionRequest::clear() {
    clearSessionName();
    clearSessionOwner();
    clearSeatID();
}

inline void UnRegisterSessionRequest::clearSessionName() {
    if (hasSessionName()) {
         clear_has_SessionName();
        _SessionName.clear();
     }
}

inline bool UnRegisterSessionRequest::hasSessionName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnRegisterSessionRequest::getSessionName () const {
    return _SessionName;
}

inline ::std::string& UnRegisterSessionRequest::getSessionNameMutable () {
    set_has_SessionName();
    return _SessionName;
}

inline void UnRegisterSessionRequest::setSessionName (const ::std::string& SessionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName = SessionName_;
}

inline void UnRegisterSessionRequest::setSessionName (const char* SessionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName.assign(SessionName_);
}

inline void UnRegisterSessionRequest::setSessionName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionName();
    this->_SessionName.assign(value, size);
}

inline void UnRegisterSessionRequest::clearSessionOwner() {
    if (hasSessionOwner()) {
         clear_has_SessionOwner();
        _SessionOwner.clear();
     }
}

inline bool UnRegisterSessionRequest::hasSessionOwner () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& UnRegisterSessionRequest::getSessionOwner () const {
    return _SessionOwner;
}

inline ::std::string& UnRegisterSessionRequest::getSessionOwnerMutable () {
    set_has_SessionOwner();
    return _SessionOwner;
}

inline void UnRegisterSessionRequest::setSessionOwner (const ::std::string& SessionOwner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner = SessionOwner_;
}

inline void UnRegisterSessionRequest::setSessionOwner (const char* SessionOwner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionOwner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner.assign(SessionOwner_);
}

inline void UnRegisterSessionRequest::setSessionOwner (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionOwner();
    this->_SessionOwner.assign(value, size);
}

inline void UnRegisterSessionRequest::clearSeatID() {
    if (hasSeatID()) {
         clear_has_SeatID();
        _SeatID = ::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet;
     }
}

inline bool UnRegisterSessionRequest::hasSeatID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline _NsmSeat_e UnRegisterSessionRequest::getSeatID () const {
    return _SeatID;
}

inline void UnRegisterSessionRequest::setSeatID (_NsmSeat_e SeatID_) {
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "UnRegisterSessionRequest");
    }
    #endif
    set_has_SeatID();
    this->_SeatID = SeatID_;
}

inline void UnRegisterSessionRequest::set_has_SessionName () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnRegisterSessionRequest::clear_has_SessionName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UnRegisterSessionRequest::set_has_SessionOwner () {
    _has_bits_[0] |= 1u << 1;
}

inline void UnRegisterSessionRequest::clear_has_SessionOwner () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UnRegisterSessionRequest::set_has_SeatID () {
    _has_bits_[0] |= 1u << 2;
}

inline void UnRegisterSessionRequest::clear_has_SeatID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  UnRegisterSessionResponse::UnRegisterSessionResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnRegisterSessionResponse::UnRegisterSessionResponse (const UnRegisterSessionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnRegisterSessionResponse::UnRegisterSessionResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "UnRegisterSessionResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnRegisterSessionResponse::~UnRegisterSessionResponse() {
}

inline UnRegisterSessionResponse& UnRegisterSessionResponse::operator = (const UnRegisterSessionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool UnRegisterSessionResponse::operator == (const UnRegisterSessionResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool UnRegisterSessionResponse::operator != (const UnRegisterSessionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UnRegisterSessionResponse::operator < (const UnRegisterSessionResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnRegisterSessionResponse::clone() {
    return new UnRegisterSessionResponse(*this);
}

inline bool UnRegisterSessionResponse::operator > (const UnRegisterSessionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnRegisterSessionResponse::clear() {
    clearErrorCode();
}

inline void UnRegisterSessionResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool UnRegisterSessionResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e UnRegisterSessionResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void UnRegisterSessionResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "UnRegisterSessionResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void UnRegisterSessionResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnRegisterSessionResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAppHealthCountResponse::GetAppHealthCountResponse ()  :
    _Count (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAppHealthCountResponse::GetAppHealthCountResponse (const GetAppHealthCountResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Count (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAppHealthCountResponse::GetAppHealthCountResponse (uint32 Count_)  :
    _Count (Count_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAppHealthCountResponse::~GetAppHealthCountResponse() {
}

inline GetAppHealthCountResponse& GetAppHealthCountResponse::operator = (const GetAppHealthCountResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCount()) {
            setCount(rhs.getCount());
        } else {
            clearCount();
        }
    }
    return *this;
}

inline bool GetAppHealthCountResponse::operator == (const GetAppHealthCountResponse& rhs) const {
    return (((!hasCount() && !rhs.hasCount()) || getCount() == rhs.getCount()));
}

inline bool GetAppHealthCountResponse::operator != (const GetAppHealthCountResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAppHealthCountResponse::operator < (const GetAppHealthCountResponse& rhs) const {
    if (hasCount() || rhs.hasCount()) {
        if (getCount() < rhs.getCount()) return true;
        if (getCount() > rhs.getCount()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAppHealthCountResponse::clone() {
    return new GetAppHealthCountResponse(*this);
}

inline bool GetAppHealthCountResponse::operator > (const GetAppHealthCountResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAppHealthCountResponse::clear() {
    clearCount();
}

inline void GetAppHealthCountResponse::clearCount() {
    if (hasCount()) {
         clear_has_Count();
        _Count = 0u;
     }
}

inline bool GetAppHealthCountResponse::hasCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetAppHealthCountResponse::getCount () const {
    return _Count;
}

inline void GetAppHealthCountResponse::setCount (uint32 Count_) {
    set_has_Count();
    this->_Count = Count_;
}

inline void GetAppHealthCountResponse::set_has_Count () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAppHealthCountResponse::clear_has_Count () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetInterfaceVersionResponse::GetInterfaceVersionResponse ()  :
    _Version (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetInterfaceVersionResponse::GetInterfaceVersionResponse (const GetInterfaceVersionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Version (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetInterfaceVersionResponse::GetInterfaceVersionResponse (uint32 Version_)  :
    _Version (Version_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetInterfaceVersionResponse::~GetInterfaceVersionResponse() {
}

inline GetInterfaceVersionResponse& GetInterfaceVersionResponse::operator = (const GetInterfaceVersionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
    }
    return *this;
}

inline bool GetInterfaceVersionResponse::operator == (const GetInterfaceVersionResponse& rhs) const {
    return (((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()));
}

inline bool GetInterfaceVersionResponse::operator != (const GetInterfaceVersionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetInterfaceVersionResponse::operator < (const GetInterfaceVersionResponse& rhs) const {
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetInterfaceVersionResponse::clone() {
    return new GetInterfaceVersionResponse(*this);
}

inline bool GetInterfaceVersionResponse::operator > (const GetInterfaceVersionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetInterfaceVersionResponse::clear() {
    clearVersion();
}

inline void GetInterfaceVersionResponse::clearVersion() {
    if (hasVersion()) {
         clear_has_Version();
        _Version = 0u;
     }
}

inline bool GetInterfaceVersionResponse::hasVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetInterfaceVersionResponse::getVersion () const {
    return _Version;
}

inline void GetInterfaceVersionResponse::setVersion (uint32 Version_) {
    set_has_Version();
    this->_Version = Version_;
}

inline void GetInterfaceVersionResponse::set_has_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetInterfaceVersionResponse::clear_has_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LifecycleRequestCompleteRequest::LifecycleRequestCompleteRequest ()  :
    _RequestId (0u),
    _Status (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LifecycleRequestCompleteRequest::LifecycleRequestCompleteRequest (const LifecycleRequestCompleteRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _RequestId (0u),
    _Status (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LifecycleRequestCompleteRequest::LifecycleRequestCompleteRequest (uint32 RequestId_, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e Status_)  :
    _RequestId (RequestId_),
    _Status (Status_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "_NsmErrorStatus_e", "Status", "LifecycleRequestCompleteRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LifecycleRequestCompleteRequest::~LifecycleRequestCompleteRequest() {
}

inline LifecycleRequestCompleteRequest& LifecycleRequestCompleteRequest::operator = (const LifecycleRequestCompleteRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequestId()) {
            setRequestId(rhs.getRequestId());
        } else {
            clearRequestId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool LifecycleRequestCompleteRequest::operator == (const LifecycleRequestCompleteRequest& rhs) const {
    return (((!hasRequestId() && !rhs.hasRequestId()) || getRequestId() == rhs.getRequestId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool LifecycleRequestCompleteRequest::operator != (const LifecycleRequestCompleteRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool LifecycleRequestCompleteRequest::operator < (const LifecycleRequestCompleteRequest& rhs) const {
    if (hasRequestId() || rhs.hasRequestId()) {
        if (getRequestId() < rhs.getRequestId()) return true;
        if (getRequestId() > rhs.getRequestId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LifecycleRequestCompleteRequest::clone() {
    return new LifecycleRequestCompleteRequest(*this);
}

inline bool LifecycleRequestCompleteRequest::operator > (const LifecycleRequestCompleteRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LifecycleRequestCompleteRequest::clear() {
    clearRequestId();
    clearStatus();
}

inline void LifecycleRequestCompleteRequest::clearRequestId() {
    if (hasRequestId()) {
         clear_has_RequestId();
        _RequestId = 0u;
     }
}

inline bool LifecycleRequestCompleteRequest::hasRequestId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 LifecycleRequestCompleteRequest::getRequestId () const {
    return _RequestId;
}

inline void LifecycleRequestCompleteRequest::setRequestId (uint32 RequestId_) {
    set_has_RequestId();
    this->_RequestId = RequestId_;
}

inline void LifecycleRequestCompleteRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool LifecycleRequestCompleteRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e LifecycleRequestCompleteRequest::getStatus () const {
    return _Status;
}

inline void LifecycleRequestCompleteRequest::setStatus (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e Status_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "_NsmErrorStatus_e", "Status", "LifecycleRequestCompleteRequest");
    }
    #endif
    set_has_Status();
    this->_Status = Status_;
}

inline void LifecycleRequestCompleteRequest::set_has_RequestId () {
    _has_bits_[0] |= 1u << 0;
}

inline void LifecycleRequestCompleteRequest::clear_has_RequestId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LifecycleRequestCompleteRequest::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void LifecycleRequestCompleteRequest::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  LifecycleRequestCompleteResponse::LifecycleRequestCompleteResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LifecycleRequestCompleteResponse::LifecycleRequestCompleteResponse (const LifecycleRequestCompleteResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LifecycleRequestCompleteResponse::LifecycleRequestCompleteResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "LifecycleRequestCompleteResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LifecycleRequestCompleteResponse::~LifecycleRequestCompleteResponse() {
}

inline LifecycleRequestCompleteResponse& LifecycleRequestCompleteResponse::operator = (const LifecycleRequestCompleteResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool LifecycleRequestCompleteResponse::operator == (const LifecycleRequestCompleteResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool LifecycleRequestCompleteResponse::operator != (const LifecycleRequestCompleteResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool LifecycleRequestCompleteResponse::operator < (const LifecycleRequestCompleteResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LifecycleRequestCompleteResponse::clone() {
    return new LifecycleRequestCompleteResponse(*this);
}

inline bool LifecycleRequestCompleteResponse::operator > (const LifecycleRequestCompleteResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LifecycleRequestCompleteResponse::clear() {
    clearErrorCode();
}

inline void LifecycleRequestCompleteResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool LifecycleRequestCompleteResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e LifecycleRequestCompleteResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void LifecycleRequestCompleteResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "LifecycleRequestCompleteResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void LifecycleRequestCompleteResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void LifecycleRequestCompleteResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestartReasonUpdate::RestartReasonUpdate ()  :
    _RestartReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e__NsmRestartReason_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestartReasonUpdate::RestartReasonUpdate (const RestartReasonUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RestartReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e__NsmRestartReason_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestartReasonUpdate::RestartReasonUpdate (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReason_)  :
    _RestartReason (RestartReason_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e_IsValid(RestartReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RestartReason_, "_NsmRestartReason_e", "RestartReason", "RestartReasonUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestartReasonUpdate::~RestartReasonUpdate() {
}

inline RestartReasonUpdate& RestartReasonUpdate::operator = (const RestartReasonUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRestartReason()) {
            setRestartReason(rhs.getRestartReason());
        } else {
            clearRestartReason();
        }
    }
    return *this;
}

inline bool RestartReasonUpdate::operator == (const RestartReasonUpdate& rhs) const {
    return (((!hasRestartReason() && !rhs.hasRestartReason()) || getRestartReason() == rhs.getRestartReason()));
}

inline bool RestartReasonUpdate::operator != (const RestartReasonUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RestartReasonUpdate::operator < (const RestartReasonUpdate& rhs) const {
    if (hasRestartReason() || rhs.hasRestartReason()) {
        if ((uint32)getRestartReason() < (uint32)rhs.getRestartReason()) return true;
        if ((uint32)getRestartReason() > (uint32)rhs.getRestartReason()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestartReasonUpdate::clone() {
    return new RestartReasonUpdate(*this);
}

inline bool RestartReasonUpdate::operator > (const RestartReasonUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestartReasonUpdate::clear() {
    clearRestartReason();
}

inline void RestartReasonUpdate::clearRestartReason() {
    if (hasRestartReason()) {
         clear_has_RestartReason();
        _RestartReason = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e__NsmRestartReason_NotSet;
     }
}

inline bool RestartReasonUpdate::hasRestartReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReasonUpdate::getRestartReason () const {
    return _RestartReason;
}

inline void RestartReasonUpdate::setRestartReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReason_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e_IsValid(RestartReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RestartReason_, "_NsmRestartReason_e", "RestartReason", "RestartReasonUpdate");
    }
    #endif
    set_has_RestartReason();
    this->_RestartReason = RestartReason_;
}

inline void RestartReasonUpdate::set_has_RestartReason () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestartReasonUpdate::clear_has_RestartReason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestartReasonRegister::RestartReasonRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestartReasonRegister::RestartReasonRegister (const RestartReasonRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestartReasonRegister::~RestartReasonRegister() {
}

inline RestartReasonRegister& RestartReasonRegister::operator = (const RestartReasonRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RestartReasonRegister::operator == (const RestartReasonRegister& ) const {
    return true;
}

inline bool RestartReasonRegister::operator != (const RestartReasonRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RestartReasonRegister::operator < (const RestartReasonRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RestartReasonRegister::clone() {
    return new RestartReasonRegister(*this);
}

inline bool RestartReasonRegister::operator > (const RestartReasonRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestartReasonRegister::clear() {
}

inline  ShutdownReasonUpdate::ShutdownReasonUpdate ()  :
    _ShutdownReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e__NsmShutdownReason_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ShutdownReasonUpdate::ShutdownReasonUpdate (const ShutdownReasonUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ShutdownReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e__NsmShutdownReason_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ShutdownReasonUpdate::ShutdownReasonUpdate (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e ShutdownReason_)  :
    _ShutdownReason (ShutdownReason_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e_IsValid(ShutdownReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ShutdownReason_, "_NsmShutdownReason_e", "ShutdownReason", "ShutdownReasonUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ShutdownReasonUpdate::~ShutdownReasonUpdate() {
}

inline ShutdownReasonUpdate& ShutdownReasonUpdate::operator = (const ShutdownReasonUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasShutdownReason()) {
            setShutdownReason(rhs.getShutdownReason());
        } else {
            clearShutdownReason();
        }
    }
    return *this;
}

inline bool ShutdownReasonUpdate::operator == (const ShutdownReasonUpdate& rhs) const {
    return (((!hasShutdownReason() && !rhs.hasShutdownReason()) || getShutdownReason() == rhs.getShutdownReason()));
}

inline bool ShutdownReasonUpdate::operator != (const ShutdownReasonUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ShutdownReasonUpdate::operator < (const ShutdownReasonUpdate& rhs) const {
    if (hasShutdownReason() || rhs.hasShutdownReason()) {
        if ((uint32)getShutdownReason() < (uint32)rhs.getShutdownReason()) return true;
        if ((uint32)getShutdownReason() > (uint32)rhs.getShutdownReason()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ShutdownReasonUpdate::clone() {
    return new ShutdownReasonUpdate(*this);
}

inline bool ShutdownReasonUpdate::operator > (const ShutdownReasonUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ShutdownReasonUpdate::clear() {
    clearShutdownReason();
}

inline void ShutdownReasonUpdate::clearShutdownReason() {
    if (hasShutdownReason()) {
         clear_has_ShutdownReason();
        _ShutdownReason = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e__NsmShutdownReason_NotSet;
     }
}

inline bool ShutdownReasonUpdate::hasShutdownReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e ShutdownReasonUpdate::getShutdownReason () const {
    return _ShutdownReason;
}

inline void ShutdownReasonUpdate::setShutdownReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e ShutdownReason_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e_IsValid(ShutdownReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ShutdownReason_, "_NsmShutdownReason_e", "ShutdownReason", "ShutdownReasonUpdate");
    }
    #endif
    set_has_ShutdownReason();
    this->_ShutdownReason = ShutdownReason_;
}

inline void ShutdownReasonUpdate::set_has_ShutdownReason () {
    _has_bits_[0] |= 1u << 0;
}

inline void ShutdownReasonUpdate::clear_has_ShutdownReason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ShutdownReasonRegister::ShutdownReasonRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ShutdownReasonRegister::ShutdownReasonRegister (const ShutdownReasonRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ShutdownReasonRegister::~ShutdownReasonRegister() {
}

inline ShutdownReasonRegister& ShutdownReasonRegister::operator = (const ShutdownReasonRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ShutdownReasonRegister::operator == (const ShutdownReasonRegister& ) const {
    return true;
}

inline bool ShutdownReasonRegister::operator != (const ShutdownReasonRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ShutdownReasonRegister::operator < (const ShutdownReasonRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ShutdownReasonRegister::clone() {
    return new ShutdownReasonRegister(*this);
}

inline bool ShutdownReasonRegister::operator > (const ShutdownReasonRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ShutdownReasonRegister::clear() {
}

inline  WakeUpReasonUpdate::WakeUpReasonUpdate ()  :
    _WakeUpReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e__NsmRunningReason_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WakeUpReasonUpdate::WakeUpReasonUpdate (const WakeUpReasonUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _WakeUpReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e__NsmRunningReason_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WakeUpReasonUpdate::WakeUpReasonUpdate (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e WakeUpReason_)  :
    _WakeUpReason (WakeUpReason_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e_IsValid(WakeUpReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WakeUpReason_, "_NsmRunningReason_e", "WakeUpReason", "WakeUpReasonUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WakeUpReasonUpdate::~WakeUpReasonUpdate() {
}

inline WakeUpReasonUpdate& WakeUpReasonUpdate::operator = (const WakeUpReasonUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWakeUpReason()) {
            setWakeUpReason(rhs.getWakeUpReason());
        } else {
            clearWakeUpReason();
        }
    }
    return *this;
}

inline bool WakeUpReasonUpdate::operator == (const WakeUpReasonUpdate& rhs) const {
    return (((!hasWakeUpReason() && !rhs.hasWakeUpReason()) || getWakeUpReason() == rhs.getWakeUpReason()));
}

inline bool WakeUpReasonUpdate::operator != (const WakeUpReasonUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool WakeUpReasonUpdate::operator < (const WakeUpReasonUpdate& rhs) const {
    if (hasWakeUpReason() || rhs.hasWakeUpReason()) {
        if ((uint32)getWakeUpReason() < (uint32)rhs.getWakeUpReason()) return true;
        if ((uint32)getWakeUpReason() > (uint32)rhs.getWakeUpReason()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WakeUpReasonUpdate::clone() {
    return new WakeUpReasonUpdate(*this);
}

inline bool WakeUpReasonUpdate::operator > (const WakeUpReasonUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WakeUpReasonUpdate::clear() {
    clearWakeUpReason();
}

inline void WakeUpReasonUpdate::clearWakeUpReason() {
    if (hasWakeUpReason()) {
         clear_has_WakeUpReason();
        _WakeUpReason = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e__NsmRunningReason_NotSet;
     }
}

inline bool WakeUpReasonUpdate::hasWakeUpReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e WakeUpReasonUpdate::getWakeUpReason () const {
    return _WakeUpReason;
}

inline void WakeUpReasonUpdate::setWakeUpReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e WakeUpReason_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e_IsValid(WakeUpReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WakeUpReason_, "_NsmRunningReason_e", "WakeUpReason", "WakeUpReasonUpdate");
    }
    #endif
    set_has_WakeUpReason();
    this->_WakeUpReason = WakeUpReason_;
}

inline void WakeUpReasonUpdate::set_has_WakeUpReason () {
    _has_bits_[0] |= 1u << 0;
}

inline void WakeUpReasonUpdate::clear_has_WakeUpReason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WakeUpReasonRegister::WakeUpReasonRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WakeUpReasonRegister::WakeUpReasonRegister (const WakeUpReasonRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WakeUpReasonRegister::~WakeUpReasonRegister() {
}

inline WakeUpReasonRegister& WakeUpReasonRegister::operator = (const WakeUpReasonRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool WakeUpReasonRegister::operator == (const WakeUpReasonRegister& ) const {
    return true;
}

inline bool WakeUpReasonRegister::operator != (const WakeUpReasonRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool WakeUpReasonRegister::operator < (const WakeUpReasonRegister& ) const {
    return false;
}

inline ::asf::core::Payload* WakeUpReasonRegister::clone() {
    return new WakeUpReasonRegister(*this);
}

inline bool WakeUpReasonRegister::operator > (const WakeUpReasonRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WakeUpReasonRegister::clear() {
}

inline  BootModeUpdate::BootModeUpdate ()  :
    _BootMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BootModeUpdate::BootModeUpdate (const BootModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _BootMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BootModeUpdate::BootModeUpdate (int32 BootMode_)  :
    _BootMode (BootMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BootModeUpdate::~BootModeUpdate() {
}

inline BootModeUpdate& BootModeUpdate::operator = (const BootModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBootMode()) {
            setBootMode(rhs.getBootMode());
        } else {
            clearBootMode();
        }
    }
    return *this;
}

inline bool BootModeUpdate::operator == (const BootModeUpdate& rhs) const {
    return (((!hasBootMode() && !rhs.hasBootMode()) || getBootMode() == rhs.getBootMode()));
}

inline bool BootModeUpdate::operator != (const BootModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BootModeUpdate::operator < (const BootModeUpdate& rhs) const {
    if (hasBootMode() || rhs.hasBootMode()) {
        if (getBootMode() < rhs.getBootMode()) return true;
        if (getBootMode() > rhs.getBootMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BootModeUpdate::clone() {
    return new BootModeUpdate(*this);
}

inline bool BootModeUpdate::operator > (const BootModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BootModeUpdate::clear() {
    clearBootMode();
}

inline void BootModeUpdate::clearBootMode() {
    if (hasBootMode()) {
         clear_has_BootMode();
        _BootMode = 0;
     }
}

inline bool BootModeUpdate::hasBootMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 BootModeUpdate::getBootMode () const {
    return _BootMode;
}

inline void BootModeUpdate::setBootMode (int32 BootMode_) {
    set_has_BootMode();
    this->_BootMode = BootMode_;
}

inline void BootModeUpdate::set_has_BootMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void BootModeUpdate::clear_has_BootMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BootModeRegister::BootModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BootModeRegister::BootModeRegister (const BootModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BootModeRegister::~BootModeRegister() {
}

inline BootModeRegister& BootModeRegister::operator = (const BootModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BootModeRegister::operator == (const BootModeRegister& ) const {
    return true;
}

inline bool BootModeRegister::operator != (const BootModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BootModeRegister::operator < (const BootModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BootModeRegister::clone() {
    return new BootModeRegister(*this);
}

inline bool BootModeRegister::operator > (const BootModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BootModeRegister::clear() {
}

inline  NodeStateSignal::NodeStateSignal ()  :
    _NodeState (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NodeStateSignal::NodeStateSignal (const NodeStateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _NodeState (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NodeStateSignal::NodeStateSignal (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeState_)  :
    _NodeState (NodeState_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e_IsValid(NodeState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", NodeState_, "_NsmNodeState_e", "NodeState", "NodeStateSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NodeStateSignal::~NodeStateSignal() {
}

inline NodeStateSignal& NodeStateSignal::operator = (const NodeStateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNodeState()) {
            setNodeState(rhs.getNodeState());
        } else {
            clearNodeState();
        }
    }
    return *this;
}

inline bool NodeStateSignal::operator == (const NodeStateSignal& rhs) const {
    return (((!hasNodeState() && !rhs.hasNodeState()) || getNodeState() == rhs.getNodeState()));
}

inline bool NodeStateSignal::operator != (const NodeStateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool NodeStateSignal::operator < (const NodeStateSignal& rhs) const {
    if (hasNodeState() || rhs.hasNodeState()) {
        if ((uint32)getNodeState() < (uint32)rhs.getNodeState()) return true;
        if ((uint32)getNodeState() > (uint32)rhs.getNodeState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NodeStateSignal::clone() {
    return new NodeStateSignal(*this);
}

inline bool NodeStateSignal::operator > (const NodeStateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NodeStateSignal::clear() {
    clearNodeState();
}

inline void NodeStateSignal::clearNodeState() {
    if (hasNodeState()) {
         clear_has_NodeState();
        _NodeState = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet;
     }
}

inline bool NodeStateSignal::hasNodeState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateSignal::getNodeState () const {
    return _NodeState;
}

inline void NodeStateSignal::setNodeState (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeState_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e_IsValid(NodeState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", NodeState_, "_NsmNodeState_e", "NodeState", "NodeStateSignal");
    }
    #endif
    set_has_NodeState();
    this->_NodeState = NodeState_;
}

inline void NodeStateSignal::set_has_NodeState () {
    _has_bits_[0] |= 1u << 0;
}

inline void NodeStateSignal::clear_has_NodeState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NodeApplicationModeSignal::NodeApplicationModeSignal ()  :
    _ApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NodeApplicationModeSignal::NodeApplicationModeSignal (const NodeApplicationModeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _ApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NodeApplicationModeSignal::NodeApplicationModeSignal (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_)  :
    _ApplicationModeId (ApplicationModeId_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e_IsValid(ApplicationModeId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ApplicationModeId_, "_NsmApplicationMode_e", "ApplicationModeId", "NodeApplicationModeSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NodeApplicationModeSignal::~NodeApplicationModeSignal() {
}

inline NodeApplicationModeSignal& NodeApplicationModeSignal::operator = (const NodeApplicationModeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasApplicationModeId()) {
            setApplicationModeId(rhs.getApplicationModeId());
        } else {
            clearApplicationModeId();
        }
    }
    return *this;
}

inline bool NodeApplicationModeSignal::operator == (const NodeApplicationModeSignal& rhs) const {
    return (((!hasApplicationModeId() && !rhs.hasApplicationModeId()) || getApplicationModeId() == rhs.getApplicationModeId()));
}

inline bool NodeApplicationModeSignal::operator != (const NodeApplicationModeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool NodeApplicationModeSignal::operator < (const NodeApplicationModeSignal& rhs) const {
    if (hasApplicationModeId() || rhs.hasApplicationModeId()) {
        if ((uint32)getApplicationModeId() < (uint32)rhs.getApplicationModeId()) return true;
        if ((uint32)getApplicationModeId() > (uint32)rhs.getApplicationModeId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NodeApplicationModeSignal::clone() {
    return new NodeApplicationModeSignal(*this);
}

inline bool NodeApplicationModeSignal::operator > (const NodeApplicationModeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NodeApplicationModeSignal::clear() {
    clearApplicationModeId();
}

inline void NodeApplicationModeSignal::clearApplicationModeId() {
    if (hasApplicationModeId()) {
         clear_has_ApplicationModeId();
        _ApplicationModeId = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet;
     }
}

inline bool NodeApplicationModeSignal::hasApplicationModeId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e NodeApplicationModeSignal::getApplicationModeId () const {
    return _ApplicationModeId;
}

inline void NodeApplicationModeSignal::setApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e_IsValid(ApplicationModeId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ApplicationModeId_, "_NsmApplicationMode_e", "ApplicationModeId", "NodeApplicationModeSignal");
    }
    #endif
    set_has_ApplicationModeId();
    this->_ApplicationModeId = ApplicationModeId_;
}

inline void NodeApplicationModeSignal::set_has_ApplicationModeId () {
    _has_bits_[0] |= 1u << 0;
}

inline void NodeApplicationModeSignal::clear_has_ApplicationModeId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SessionStateChangedSignal::SessionStateChangedSignal ()  :
    _SessionStateName (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet),
    _SessionState (::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SessionStateChangedSignal::SessionStateChangedSignal (const SessionStateChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionStateName (),
    _SeatID (::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet),
    _SessionState (::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SessionStateChangedSignal::SessionStateChangedSignal (const ::std::string& SessionStateName_, _NsmSeat_e SeatID_, _NsmSessionState_e SessionState_)  :
    _SessionStateName (SessionStateName_),
    _SeatID (SeatID_),
    _SessionState (SessionState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionStateName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "SessionStateChangedSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(_NsmSessionState_e_IsValid(SessionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SessionState_, "_NsmSessionState_e", "SessionState", "SessionStateChangedSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SessionStateChangedSignal::~SessionStateChangedSignal() {
}

inline SessionStateChangedSignal& SessionStateChangedSignal::operator = (const SessionStateChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionStateName()) {
            setSessionStateName(rhs.getSessionStateName());
        } else {
            clearSessionStateName();
        }
        if (rhs.hasSeatID()) {
            setSeatID(rhs.getSeatID());
        } else {
            clearSeatID();
        }
        if (rhs.hasSessionState()) {
            setSessionState(rhs.getSessionState());
        } else {
            clearSessionState();
        }
    }
    return *this;
}

inline bool SessionStateChangedSignal::operator == (const SessionStateChangedSignal& rhs) const {
    return (((!hasSessionStateName() && !rhs.hasSessionStateName()) || getSessionStateName() == rhs.getSessionStateName()) &&
        ((!hasSeatID() && !rhs.hasSeatID()) || getSeatID() == rhs.getSeatID()) &&
        ((!hasSessionState() && !rhs.hasSessionState()) || getSessionState() == rhs.getSessionState()));
}

inline bool SessionStateChangedSignal::operator != (const SessionStateChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SessionStateChangedSignal::operator < (const SessionStateChangedSignal& rhs) const {
    if (hasSessionStateName() || rhs.hasSessionStateName()) {
        if (getSessionStateName() < rhs.getSessionStateName()) return true;
        if (getSessionStateName() > rhs.getSessionStateName()) return false;
    }
    if (hasSeatID() || rhs.hasSeatID()) {
        if ((uint32)getSeatID() < (uint32)rhs.getSeatID()) return true;
        if ((uint32)getSeatID() > (uint32)rhs.getSeatID()) return false;
    }
    if (hasSessionState() || rhs.hasSessionState()) {
        if ((uint32)getSessionState() < (uint32)rhs.getSessionState()) return true;
        if ((uint32)getSessionState() > (uint32)rhs.getSessionState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SessionStateChangedSignal::clone() {
    return new SessionStateChangedSignal(*this);
}

inline bool SessionStateChangedSignal::operator > (const SessionStateChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SessionStateChangedSignal::clear() {
    clearSessionStateName();
    clearSeatID();
    clearSessionState();
}

inline void SessionStateChangedSignal::clearSessionStateName() {
    if (hasSessionStateName()) {
         clear_has_SessionStateName();
        _SessionStateName.clear();
     }
}

inline bool SessionStateChangedSignal::hasSessionStateName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SessionStateChangedSignal::getSessionStateName () const {
    return _SessionStateName;
}

inline ::std::string& SessionStateChangedSignal::getSessionStateNameMutable () {
    set_has_SessionStateName();
    return _SessionStateName;
}

inline void SessionStateChangedSignal::setSessionStateName (const ::std::string& SessionStateName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionStateName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionStateName();
    this->_SessionStateName = SessionStateName_;
}

inline void SessionStateChangedSignal::setSessionStateName (const char* SessionStateName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SessionStateName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionStateName();
    this->_SessionStateName.assign(SessionStateName_);
}

inline void SessionStateChangedSignal::setSessionStateName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SessionStateName();
    this->_SessionStateName.assign(value, size);
}

inline void SessionStateChangedSignal::clearSeatID() {
    if (hasSeatID()) {
         clear_has_SeatID();
        _SeatID = ::org::genivi::NodeStateManager::Consumer::_NsmSeat_e__NsmSeat_NotSet;
     }
}

inline bool SessionStateChangedSignal::hasSeatID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline _NsmSeat_e SessionStateChangedSignal::getSeatID () const {
    return _SeatID;
}

inline void SessionStateChangedSignal::setSeatID (_NsmSeat_e SeatID_) {
    #ifndef NDEBUG
    if (!(_NsmSeat_e_IsValid(SeatID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SeatID_, "_NsmSeat_e", "SeatID", "SessionStateChangedSignal");
    }
    #endif
    set_has_SeatID();
    this->_SeatID = SeatID_;
}

inline void SessionStateChangedSignal::clearSessionState() {
    if (hasSessionState()) {
         clear_has_SessionState();
        _SessionState = ::org::genivi::NodeStateManager::Consumer::_NsmSessionState_e__NsmSessionState_Unregistered;
     }
}

inline bool SessionStateChangedSignal::hasSessionState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline _NsmSessionState_e SessionStateChangedSignal::getSessionState () const {
    return _SessionState;
}

inline void SessionStateChangedSignal::setSessionState (_NsmSessionState_e SessionState_) {
    #ifndef NDEBUG
    if (!(_NsmSessionState_e_IsValid(SessionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SessionState_, "_NsmSessionState_e", "SessionState", "SessionStateChangedSignal");
    }
    #endif
    set_has_SessionState();
    this->_SessionState = SessionState_;
}

inline void SessionStateChangedSignal::set_has_SessionStateName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SessionStateChangedSignal::clear_has_SessionStateName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SessionStateChangedSignal::set_has_SeatID () {
    _has_bits_[0] |= 1u << 1;
}

inline void SessionStateChangedSignal::clear_has_SeatID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SessionStateChangedSignal::set_has_SessionState () {
    _has_bits_[0] |= 1u << 2;
}

inline void SessionStateChangedSignal::clear_has_SessionState () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace Consumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_CONSUMER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
