/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/lcm/Generic_RecoveryClient.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientConst.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientDBus.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientJson.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace Generic_RecoveryClient {

DEFINE_CLASS_LOGGER("/org/bosch/cm/lcm/org/bosch/cm/lcm/Generic_RecoveryClient", Generic_RecoveryClientProxy);

class Generic_RecoveryClientProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    Generic_RecoveryClientProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxyShared = ::boost::static_pointer_cast< Generic_RecoveryClientProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_FI_Version:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FI_VersionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FI_Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FI_VersionError> payload = ::boost::static_pointer_cast<FI_VersionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FI_VersionCallbackIF*) _callback)->onFI_VersionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FI_VersionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FI_Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FI_VersionUpdate> payload = ::boost::static_pointer_cast<FI_VersionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FI_VersionCallbackIF*) _callback)->onFI_VersionUpdate(proxyShared, payload);
                        proxyShared->_fI_Version = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FailedServiceName:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FailedServiceNameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FailedServiceName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FailedServiceNameError> payload = ::boost::static_pointer_cast<FailedServiceNameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FailedServiceNameCallbackIF*) _callback)->onFailedServiceNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FailedServiceNameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FailedServiceName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FailedServiceNameUpdate> payload = ::boost::static_pointer_cast<FailedServiceNameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FailedServiceNameCallbackIF*) _callback)->onFailedServiceNameUpdate(proxyShared, payload);
                        proxyShared->_failedServiceName = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FailedServiceStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FailedServiceStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FailedServiceStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FailedServiceStatusError> payload = ::boost::static_pointer_cast<FailedServiceStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FailedServiceStatusCallbackIF*) _callback)->onFailedServiceStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FailedServiceStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FailedServiceStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FailedServiceStatusUpdate> payload = ::boost::static_pointer_cast<FailedServiceStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FailedServiceStatusCallbackIF*) _callback)->onFailedServiceStatusUpdate(proxyShared, payload);
                        proxyShared->_failedServiceStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CallStackRequestCounter:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CallStackRequestCounterError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CallStackRequestCounter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CallStackRequestCounterError> payload = ::boost::static_pointer_cast<CallStackRequestCounterError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CallStackRequestCounterCallbackIF*) _callback)->onCallStackRequestCounterError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CallStackRequestCounterUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CallStackRequestCounter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CallStackRequestCounterUpdate> payload = ::boost::static_pointer_cast<CallStackRequestCounterUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CallStackRequestCounterCallbackIF*) _callback)->onCallStackRequestCounterUpdate(proxyShared, payload);
                        proxyShared->_callStackRequestCounter = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ActionRequest:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActionRequestError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActionRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActionRequestError> payload = ::boost::static_pointer_cast<ActionRequestError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActionRequestCallbackIF*) _callback)->onActionRequestError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActionRequestUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActionRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActionRequestUpdate> payload = ::boost::static_pointer_cast<ActionRequestUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActionRequestCallbackIF*) _callback)->onActionRequestUpdate(proxyShared, payload);
                        proxyShared->_actionRequest = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RequestPermissionRequest:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPermissionRequestError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequestPermissionRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestPermissionRequestError> payload = ::boost::static_pointer_cast<RequestPermissionRequestError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequestPermissionRequestCallbackIF*) _callback)->onRequestPermissionRequestError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPermissionRequestUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequestPermissionRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestPermissionRequestUpdate> payload = ::boost::static_pointer_cast<RequestPermissionRequestUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequestPermissionRequestCallbackIF*) _callback)->onRequestPermissionRequestUpdate(proxyShared, payload);
                        proxyShared->_requestPermissionRequest = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_setFailedServiceName:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetFailedServiceNameError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFailedServiceName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetFailedServiceNameError> payload = ::boost::static_pointer_cast<SetFailedServiceNameError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetFailedServiceNameCallbackIF*) _callback)->onSetFailedServiceNameError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFailedServiceNameResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFailedServiceName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetFailedServiceNameResponse> payload = ::boost::static_pointer_cast<SetFailedServiceNameResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetFailedServiceNameCallbackIF*) _callback)->onSetFailedServiceNameResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setFailedServiceStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetFailedServiceStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFailedServiceStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetFailedServiceStatusError> payload = ::boost::static_pointer_cast<SetFailedServiceStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetFailedServiceStatusCallbackIF*) _callback)->onSetFailedServiceStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFailedServiceStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFailedServiceStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetFailedServiceStatusResponse> payload = ::boost::static_pointer_cast<SetFailedServiceStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetFailedServiceStatusCallbackIF*) _callback)->onSetFailedServiceStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setCallStackRequestCounter:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetCallStackRequestCounterError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCallStackRequestCounter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCallStackRequestCounterError> payload = ::boost::static_pointer_cast<SetCallStackRequestCounterError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCallStackRequestCounterCallbackIF*) _callback)->onSetCallStackRequestCounterError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCallStackRequestCounterResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCallStackRequestCounter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCallStackRequestCounterResponse> payload = ::boost::static_pointer_cast<SetCallStackRequestCounterResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCallStackRequestCounterCallbackIF*) _callback)->onSetCallStackRequestCounterResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_checkResetCondition:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CheckResetConditionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CheckResetCondition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CheckResetConditionError> payload = ::boost::static_pointer_cast<CheckResetConditionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CheckResetConditionCallbackIF*) _callback)->onCheckResetConditionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CheckResetConditionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CheckResetCondition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CheckResetConditionResponse> payload = ::boost::static_pointer_cast<CheckResetConditionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CheckResetConditionCallbackIF*) _callback)->onCheckResetConditionResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_FI_Version: {
                ::boost::shared_ptr< FI_VersionError > payload = ::boost::shared_ptr< FI_VersionError >
                (new FI_VersionError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FI_Version", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FI_VersionCallbackIF*) _callback)->onFI_VersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FailedServiceName: {
                ::boost::shared_ptr< FailedServiceNameError > payload = ::boost::shared_ptr< FailedServiceNameError >
                (new FailedServiceNameError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FailedServiceName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FailedServiceNameCallbackIF*) _callback)->onFailedServiceNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FailedServiceStatus: {
                ::boost::shared_ptr< FailedServiceStatusError > payload = ::boost::shared_ptr< FailedServiceStatusError >
                (new FailedServiceStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FailedServiceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FailedServiceStatusCallbackIF*) _callback)->onFailedServiceStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CallStackRequestCounter: {
                ::boost::shared_ptr< CallStackRequestCounterError > payload = ::boost::shared_ptr< CallStackRequestCounterError >
                (new CallStackRequestCounterError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CallStackRequestCounter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CallStackRequestCounterCallbackIF*) _callback)->onCallStackRequestCounterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActionRequest: {
                ::boost::shared_ptr< ActionRequestError > payload = ::boost::shared_ptr< ActionRequestError >
                (new ActionRequestError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActionRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActionRequestCallbackIF*) _callback)->onActionRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestPermissionRequest: {
                ::boost::shared_ptr< RequestPermissionRequestError > payload = ::boost::shared_ptr< RequestPermissionRequestError >
                (new RequestPermissionRequestError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestPermissionRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestPermissionRequestCallbackIF*) _callback)->onRequestPermissionRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setFailedServiceName: {
                ::boost::shared_ptr< SetFailedServiceNameError > payload = ::boost::shared_ptr< SetFailedServiceNameError >
                (new SetFailedServiceNameError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetFailedServiceName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetFailedServiceNameCallbackIF*) _callback)->onSetFailedServiceNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setFailedServiceStatus: {
                ::boost::shared_ptr< SetFailedServiceStatusError > payload = ::boost::shared_ptr< SetFailedServiceStatusError >
                (new SetFailedServiceStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetFailedServiceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetFailedServiceStatusCallbackIF*) _callback)->onSetFailedServiceStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setCallStackRequestCounter: {
                ::boost::shared_ptr< SetCallStackRequestCounterError > payload = ::boost::shared_ptr< SetCallStackRequestCounterError >
                (new SetCallStackRequestCounterError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetCallStackRequestCounter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetCallStackRequestCounterCallbackIF*) _callback)->onSetCallStackRequestCounterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_checkResetCondition: {
                ::boost::shared_ptr< CheckResetConditionError > payload = ::boost::shared_ptr< CheckResetConditionError >
                (new CheckResetConditionError(DBUS_ERROR_NO_SERVER, "The DBus service Generic_RecoveryClient is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CheckResetCondition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Generic_RecoveryClientProxy> proxyShared = ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CheckResetConditionCallbackIF*) _callback)->onCheckResetConditionError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Generic_RecoveryClientProxyCallback::_logger (Generic_RecoveryClientProxy::_logger);

Generic_RecoveryClientProxy::Generic_RecoveryClientProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.lcm.Generic_RecoveryClient", serviceAvailable, _logger) {
}

Generic_RecoveryClientProxy::~Generic_RecoveryClientProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< Generic_RecoveryClientProxy > Generic_RecoveryClientProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<Generic_RecoveryClientProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< Generic_RecoveryClientProxy > proxyNew(new Generic_RecoveryClientProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t Generic_RecoveryClientProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t Generic_RecoveryClientProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Generic_RecoveryClientProxy::clearAllProperties ()
{
    _fI_Version = ::asf::core::nullable< FI_VersionUpdate >();
    _failedServiceName = ::asf::core::nullable< FailedServiceNameUpdate >();
    _failedServiceStatus = ::asf::core::nullable< FailedServiceStatusUpdate >();
    _callStackRequestCounter = ::asf::core::nullable< CallStackRequestCounterUpdate >();
    _actionRequest = ::asf::core::nullable< ActionRequestUpdate >();
    _requestPermissionRequest = ::asf::core::nullable< RequestPermissionRequestUpdate >();
}

void Generic_RecoveryClientProxy::sendDeregisterAll () const
{
    sendFI_VersionDeregisterAll();
    sendFailedServiceNameDeregisterAll();
    sendFailedServiceStatusDeregisterAll();
    sendCallStackRequestCounterDeregisterAll();
    sendActionRequestDeregisterAll();
    sendRequestPermissionRequestDeregisterAll();
}

act_t Generic_RecoveryClientProxy::sendFI_VersionRegister(FI_VersionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FI_Version, "FI_Version", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FI_Version", &cb, act);
    return act;
}

bool Generic_RecoveryClientProxy::sendFI_VersionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FI_Version", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FI_Version", act, static_cast<int>(rv));
    return rv;
}

act_t Generic_RecoveryClientProxy::sendFI_VersionGet(FI_VersionCallbackIF& cb) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_FI_Version, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FI_Version", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FI_Version", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Generic_RecoveryClientProxy::sendFI_VersionSet(const ::std::string& fI_Version) {
    FI_VersionSet parameter(fI_Version);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "FI_Version");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "FI_Version", propertyContent);
}

act_t Generic_RecoveryClientProxy::sendFI_VersionSet(FI_VersionCallbackIF& cb, const ::std::string& fI_Version) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_FI_Version, &cb);
    FI_VersionSet parameter(fI_Version);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "FI_Version", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "FI_Version", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& Generic_RecoveryClientProxy::getFI_Version() const {
    return _fI_Version.get().getFI_Version();
}

bool Generic_RecoveryClientProxy::hasFI_Version() const {
    return _fI_Version.hasValue();
}

void Generic_RecoveryClientProxy::sendFI_VersionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FI_Version");
    _dbusProxyDelegate->deregisterSignalCallback("FI_Version", 0, _dbusDaemonProxy.get(), true);
}

act_t Generic_RecoveryClientProxy::sendFailedServiceNameRegister(FailedServiceNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FailedServiceName, "FailedServiceName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FailedServiceName", &cb, act);
    return act;
}

bool Generic_RecoveryClientProxy::sendFailedServiceNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FailedServiceName", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FailedServiceName", act, static_cast<int>(rv));
    return rv;
}

act_t Generic_RecoveryClientProxy::sendFailedServiceNameGet(FailedServiceNameCallbackIF& cb) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_FailedServiceName, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FailedServiceName", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FailedServiceName", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Generic_RecoveryClientProxy::sendFailedServiceNameSet(const ::std::string& failedServiceName) {
    FailedServiceNameSet parameter(failedServiceName);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "FailedServiceName");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "FailedServiceName", propertyContent);
}

act_t Generic_RecoveryClientProxy::sendFailedServiceNameSet(FailedServiceNameCallbackIF& cb, const ::std::string& failedServiceName) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_FailedServiceName, &cb);
    FailedServiceNameSet parameter(failedServiceName);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "FailedServiceName", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "FailedServiceName", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& Generic_RecoveryClientProxy::getFailedServiceName() const {
    return _failedServiceName.get().getFailedServiceName();
}

bool Generic_RecoveryClientProxy::hasFailedServiceName() const {
    return _failedServiceName.hasValue();
}

void Generic_RecoveryClientProxy::sendFailedServiceNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FailedServiceName");
    _dbusProxyDelegate->deregisterSignalCallback("FailedServiceName", 0, _dbusDaemonProxy.get(), true);
}

act_t Generic_RecoveryClientProxy::sendFailedServiceStatusRegister(FailedServiceStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FailedServiceStatus, "FailedServiceStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FailedServiceStatus", &cb, act);
    return act;
}

bool Generic_RecoveryClientProxy::sendFailedServiceStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FailedServiceStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FailedServiceStatus", act, static_cast<int>(rv));
    return rv;
}

act_t Generic_RecoveryClientProxy::sendFailedServiceStatusGet(FailedServiceStatusCallbackIF& cb) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_FailedServiceStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FailedServiceStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FailedServiceStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Generic_RecoveryClientProxy::sendFailedServiceStatusSet(UnitStates failedServiceStatus) {
    FailedServiceStatusSet parameter(failedServiceStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "FailedServiceStatus");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "FailedServiceStatus", propertyContent);
}

act_t Generic_RecoveryClientProxy::sendFailedServiceStatusSet(FailedServiceStatusCallbackIF& cb, UnitStates failedServiceStatus) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_FailedServiceStatus, &cb);
    FailedServiceStatusSet parameter(failedServiceStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "FailedServiceStatus", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "FailedServiceStatus", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

UnitStates Generic_RecoveryClientProxy::getFailedServiceStatus() const {
    return _failedServiceStatus.get().getFailedServiceStatus();
}

bool Generic_RecoveryClientProxy::hasFailedServiceStatus() const {
    return _failedServiceStatus.hasValue();
}

void Generic_RecoveryClientProxy::sendFailedServiceStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FailedServiceStatus");
    _dbusProxyDelegate->deregisterSignalCallback("FailedServiceStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t Generic_RecoveryClientProxy::sendCallStackRequestCounterRegister(CallStackRequestCounterCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CallStackRequestCounter, "CallStackRequestCounter", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CallStackRequestCounter", &cb, act);
    return act;
}

bool Generic_RecoveryClientProxy::sendCallStackRequestCounterDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CallStackRequestCounter", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CallStackRequestCounter", act, static_cast<int>(rv));
    return rv;
}

act_t Generic_RecoveryClientProxy::sendCallStackRequestCounterGet(CallStackRequestCounterCallbackIF& cb) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_CallStackRequestCounter, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CallStackRequestCounter", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CallStackRequestCounter", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Generic_RecoveryClientProxy::sendCallStackRequestCounterSet(uint8 callStackRequestCounter) {
    CallStackRequestCounterSet parameter(callStackRequestCounter);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "CallStackRequestCounter");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "CallStackRequestCounter", propertyContent);
}

act_t Generic_RecoveryClientProxy::sendCallStackRequestCounterSet(CallStackRequestCounterCallbackIF& cb, uint8 callStackRequestCounter) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_CallStackRequestCounter, &cb);
    CallStackRequestCounterSet parameter(callStackRequestCounter);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "CallStackRequestCounter", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "CallStackRequestCounter", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint8 Generic_RecoveryClientProxy::getCallStackRequestCounter() const {
    return _callStackRequestCounter.get().getCallStackRequestCounter();
}

bool Generic_RecoveryClientProxy::hasCallStackRequestCounter() const {
    return _callStackRequestCounter.hasValue();
}

void Generic_RecoveryClientProxy::sendCallStackRequestCounterDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CallStackRequestCounter");
    _dbusProxyDelegate->deregisterSignalCallback("CallStackRequestCounter", 0, _dbusDaemonProxy.get(), true);
}

act_t Generic_RecoveryClientProxy::sendActionRequestRegister(ActionRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ActionRequest, "ActionRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActionRequest", &cb, act);
    return act;
}

bool Generic_RecoveryClientProxy::sendActionRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActionRequest", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActionRequest", act, static_cast<int>(rv));
    return rv;
}

act_t Generic_RecoveryClientProxy::sendActionRequestGet(ActionRequestCallbackIF& cb) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_ActionRequest, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActionRequest", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ActionRequest", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Generic_RecoveryClientProxy::sendActionRequestSet(UnitActions actionRequest) {
    ActionRequestSet parameter(actionRequest);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ActionRequest");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ActionRequest", propertyContent);
}

act_t Generic_RecoveryClientProxy::sendActionRequestSet(ActionRequestCallbackIF& cb, UnitActions actionRequest) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_ActionRequest, &cb);
    ActionRequestSet parameter(actionRequest);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ActionRequest", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ActionRequest", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

UnitActions Generic_RecoveryClientProxy::getActionRequest() const {
    return _actionRequest.get().getActionRequest();
}

bool Generic_RecoveryClientProxy::hasActionRequest() const {
    return _actionRequest.hasValue();
}

void Generic_RecoveryClientProxy::sendActionRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActionRequest");
    _dbusProxyDelegate->deregisterSignalCallback("ActionRequest", 0, _dbusDaemonProxy.get(), true);
}

act_t Generic_RecoveryClientProxy::sendRequestPermissionRequestRegister(RequestPermissionRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RequestPermissionRequest, "RequestPermissionRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequestPermissionRequest", &cb, act);
    return act;
}

bool Generic_RecoveryClientProxy::sendRequestPermissionRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RequestPermissionRequest", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequestPermissionRequest", act, static_cast<int>(rv));
    return rv;
}

act_t Generic_RecoveryClientProxy::sendRequestPermissionRequestGet(RequestPermissionRequestCallbackIF& cb) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_RequestPermissionRequest, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RequestPermissionRequest", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RequestPermissionRequest", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Generic_RecoveryClientProxy::sendRequestPermissionRequestSet(LcmResetAllowed requestPermissionRequest) {
    RequestPermissionRequestSet parameter(requestPermissionRequest);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "RequestPermissionRequest");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "RequestPermissionRequest", propertyContent);
}

act_t Generic_RecoveryClientProxy::sendRequestPermissionRequestSet(RequestPermissionRequestCallbackIF& cb, LcmResetAllowed requestPermissionRequest) {
    Generic_RecoveryClientProxyCallback* callback = new Generic_RecoveryClientProxyCallback(ID_RequestPermissionRequest, &cb);
    RequestPermissionRequestSet parameter(requestPermissionRequest);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "RequestPermissionRequest", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "RequestPermissionRequest", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

LcmResetAllowed Generic_RecoveryClientProxy::getRequestPermissionRequest() const {
    return _requestPermissionRequest.get().getRequestPermissionRequest();
}

bool Generic_RecoveryClientProxy::hasRequestPermissionRequest() const {
    return _requestPermissionRequest.hasValue();
}

void Generic_RecoveryClientProxy::sendRequestPermissionRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequestPermissionRequest");
    _dbusProxyDelegate->deregisterSignalCallback("RequestPermissionRequest", 0, _dbusDaemonProxy.get(), true);
}

act_t Generic_RecoveryClientProxy::sendSetFailedServiceNameRequest(SetFailedServiceNameCallbackIF& cb, const ::std::string& serviceName, UnitActions defaultAction) const {
    SetFailedServiceNameRequest* payload = new SetFailedServiceNameRequest();
    CHECK_ALLOCATION(payload);
    payload->setServiceName(serviceName);
    payload->setDefaultAction(defaultAction);
    DBUS_MESSAGE_CALL(dbusMessage, "setFailedServiceName", SetFailedServiceNameRequest, payload, true)
    act_t act = addMethodCallback(ID_setFailedServiceName, dbusMessage.getUniqueSerial(), "setFailedServiceName", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetFailedServiceName", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Generic_RecoveryClientProxy::sendSetFailedServiceStatusRequest(SetFailedServiceStatusCallbackIF& cb, const ::std::string& serviceName, UnitStates serviceState) const {
    SetFailedServiceStatusRequest* payload = new SetFailedServiceStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setServiceName(serviceName);
    payload->setServiceState(serviceState);
    DBUS_MESSAGE_CALL(dbusMessage, "setFailedServiceStatus", SetFailedServiceStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_setFailedServiceStatus, dbusMessage.getUniqueSerial(), "setFailedServiceStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetFailedServiceStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Generic_RecoveryClientProxy::sendSetCallStackRequestCounterRequest(SetCallStackRequestCounterCallbackIF& cb, const ::std::string& serviceName, uint8 callStackRequestCounter) const {
    SetCallStackRequestCounterRequest* payload = new SetCallStackRequestCounterRequest();
    CHECK_ALLOCATION(payload);
    payload->setServiceName(serviceName);
    payload->setCallStackRequestCounter(callStackRequestCounter);
    DBUS_MESSAGE_CALL(dbusMessage, "setCallStackRequestCounter", SetCallStackRequestCounterRequest, payload, true)
    act_t act = addMethodCallback(ID_setCallStackRequestCounter, dbusMessage.getUniqueSerial(), "setCallStackRequestCounter", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetCallStackRequestCounter", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Generic_RecoveryClientProxy::sendCheckResetConditionRequest(CheckResetConditionCallbackIF& cb, const ::std::string& serviceName) const {
    CheckResetConditionRequest* payload = new CheckResetConditionRequest();
    CHECK_ALLOCATION(payload);
    payload->setServiceName(serviceName);
    DBUS_MESSAGE_CALL(dbusMessage, "checkResetCondition", CheckResetConditionRequest, payload, true)
    act_t act = addMethodCallback(ID_checkResetCondition, dbusMessage.getUniqueSerial(), "checkResetCondition", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CheckResetCondition", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Generic_RecoveryClient
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org
