/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTCONST_H
#define ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTCONST_H

#include <cstddef>

/**
 * LCM Generic recovery client interface.
 * 	The recovery client is used to handle an unexpected state change of a systemd unit from
 * 	active to any other state
 *
 * 	The recovery client is started automatically by systemd
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace Generic_RecoveryClient {

/**
 * enumaration of possible states of the service file, see systemd documentation
 */
enum UnitStates {

    /**
     * UNIT_ACTIVE
     */
    UnitStates__UNIT_ACTIVE,
    /**
     * UNIT_RELOADING
     */
    UnitStates__UNIT_RELOADING,
    /**
     * UNIT_INACTIVE
     */
    UnitStates__UNIT_INACTIVE,
    /**
     * UNIT_FAILED
     */
    UnitStates__UNIT_FAILED,
    /**
     * UNIT_ACTIVATING
     */
    UnitStates__UNIT_ACTIVATING,
    /**
     * UNIT_DEACTIVATING
     */
    UnitStates__UNIT_DEACTIVATING,
    /**
     * _UNIT_ACTIVE_STATE_MAX
     */
    UnitStates___UNIT_ACTIVE_STATE_MAX,
    /**
     * _UNIT_ACTIVE_STATE_INVALID
     */
    UnitStates___UNIT_ACTIVE_STATE_INVALID = 255u

};

bool UnitStates_Parse (const char *str, size_t length, UnitStates &value);

const char* UnitStates_Name (UnitStates value);

bool UnitStates_IsValid (UnitStates value);

/**
 * enumaration of possible actions to take for this service file
 */
enum UnitActions {

    /**
     * UNIT_KILL
     */
    UnitActions__UNIT_KILL,
    /**
     * UNIT_STOP
     */
    UnitActions__UNIT_STOP,
    /**
     * UNIT_RELOAD
     */
    UnitActions__UNIT_RELOAD,
    /**
     * UNIT_REACTIVATE
     */
    UnitActions__UNIT_REACTIVATE

};

bool UnitActions_Parse (const char *str, size_t length, UnitActions &value);

const char* UnitActions_Name (UnitActions value);

bool UnitActions_IsValid (UnitActions value);

/**
 * enumaration of possible responses to given commands
 */
enum Response {

    /**
     * OK
     */
    Response__E_OK,
    /**
     * BUSY
     */
    Response__E_BUSY,
    /**
     * ALREADY_PRESENT
     */
    Response__E_ALREADY_PRESENT

};

bool Response_Parse (const char *str, size_t length, Response &value);

const char* Response_Name (Response value);

bool Response_IsValid (Response value);

/**
 * enumaration of reset permission
 */
enum LcmResetAllowed {

    /**
     * ALLOWED
     */
    LcmResetAllowed__ALLOW_TO_RESET,
    /**
     * NOT_ALLOWED
     */
    LcmResetAllowed__NOT_ALLOW_TO_RESET

};

bool LcmResetAllowed_Parse (const char *str, size_t length, LcmResetAllowed &value);

const char* LcmResetAllowed_Name (LcmResetAllowed value);

bool LcmResetAllowed_IsValid (LcmResetAllowed value);

} // namespace Generic_RecoveryClient
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTCONST_H
