/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * LCM Generic recovery client interface.
 * 	The recovery client is used to handle an unexpected state change of a systemd unit from
 * 	active to any other state
 *
 * 	The recovery client is started automatically by systemd
 */

using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace Generic_RecoveryClient {

bool UnitStates_Parse (const char *str, size_t length, UnitStates &value)
{
    static stringEntry entries[] = {
        {11,"UNIT_ACTIVE", 0U},
        {11,"UNIT_FAILED", 3U},
        {13,"UNIT_INACTIVE", 2U},
        {14,"UNIT_RELOADING", 1U},
        {15,"UNIT_ACTIVATING", 4U},
        {17,"UNIT_DEACTIVATING", 5U},
        {22,"_UNIT_ACTIVE_STATE_MAX", 6U},
        {26,"_UNIT_ACTIVE_STATE_INVALID", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* UnitStates_Name (UnitStates value)
{
    static const char* enumerationLiterals[] = {
        "UNIT_ACTIVE",
        "UNIT_RELOADING",
        "UNIT_INACTIVE",
        "UNIT_FAILED",
        "UNIT_ACTIVATING",
        "UNIT_DEACTIVATING",
        "_UNIT_ACTIVE_STATE_MAX",
        "_UNIT_ACTIVE_STATE_INVALID",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 8, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool UnitStates_IsValid (UnitStates value)
{
    switch (value) {
    case UnitStates__UNIT_ACTIVE:
    case UnitStates__UNIT_RELOADING:
    case UnitStates__UNIT_INACTIVE:
    case UnitStates__UNIT_FAILED:
    case UnitStates__UNIT_ACTIVATING:
    case UnitStates__UNIT_DEACTIVATING:
    case UnitStates___UNIT_ACTIVE_STATE_MAX:
    case UnitStates___UNIT_ACTIVE_STATE_INVALID:
        return true;
    default:
        return false;
    }
}

bool UnitActions_Parse (const char *str, size_t length, UnitActions &value)
{
    static stringEntry entries[] = {
        {9,"UNIT_KILL", 0U},
        {9,"UNIT_STOP", 1U},
        {11,"UNIT_RELOAD", 2U},
        {15,"UNIT_REACTIVATE", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* UnitActions_Name (UnitActions value)
{
    static const char* enumerationLiterals[] = {
        "UNIT_KILL",
        "UNIT_STOP",
        "UNIT_RELOAD",
        "UNIT_REACTIVATE",
    };

    if (UnitActions_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool UnitActions_IsValid (UnitActions value)
{
    switch (value) {
    case UnitActions__UNIT_KILL:
    case UnitActions__UNIT_STOP:
    case UnitActions__UNIT_RELOAD:
    case UnitActions__UNIT_REACTIVATE:
        return true;
    default:
        return false;
    }
}

bool Response_Parse (const char *str, size_t length, Response &value)
{
    static stringEntry entries[] = {
        {4,"E_OK", 0U},
        {6,"E_BUSY", 1U},
        {17,"E_ALREADY_PRESENT", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* Response_Name (Response value)
{
    static const char* enumerationLiterals[] = {
        "E_OK",
        "E_BUSY",
        "E_ALREADY_PRESENT",
    };

    if (Response_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool Response_IsValid (Response value)
{
    switch (value) {
    case Response__E_OK:
    case Response__E_BUSY:
    case Response__E_ALREADY_PRESENT:
        return true;
    default:
        return false;
    }
}

bool LcmResetAllowed_Parse (const char *str, size_t length, LcmResetAllowed &value)
{
    static stringEntry entries[] = {
        {14,"ALLOW_TO_RESET", 0U},
        {18,"NOT_ALLOW_TO_RESET", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* LcmResetAllowed_Name (LcmResetAllowed value)
{
    static const char* enumerationLiterals[] = {
        "ALLOW_TO_RESET",
        "NOT_ALLOW_TO_RESET",
    };

    if (LcmResetAllowed_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool LcmResetAllowed_IsValid (LcmResetAllowed value)
{
    switch (value) {
    case LcmResetAllowed__ALLOW_TO_RESET:
    case LcmResetAllowed__NOT_ALLOW_TO_RESET:
        return true;
    default:
        return false;
    }
}

} // namespace Generic_RecoveryClient
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org
