#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENT_H
#define ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENT_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * LCM Generic recovery client interface.
 * 	The recovery client is used to handle an unexpected state change of a systemd unit from
 * 	active to any other state
 *
 * 	The recovery client is started automatically by systemd
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace Generic_RecoveryClient {

// method IDs
static const uint16 ID_setFailedServiceName = 0;
static const uint16 ID_setFailedServiceStatus = 1;
static const uint16 ID_setCallStackRequestCounter = 2;
static const uint16 ID_checkResetCondition = 3;

// signal IDs

// property IDs
static const uint16 ID_FI_Version = 4;
static const uint16 ID_FailedServiceName = 5;
static const uint16 ID_FailedServiceStatus = 6;
static const uint16 ID_CallStackRequestCounter = 7;
static const uint16 ID_ActionRequest = 8;
static const uint16 ID_RequestPermissionRequest = 9;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class SetFailedServiceNameRequest;

class SetFailedServiceNameResponse;

class SetFailedServiceStatusRequest;

class SetFailedServiceStatusResponse;

class SetCallStackRequestCounterRequest;

class SetCallStackRequestCounterResponse;

class CheckResetConditionRequest;

class CheckResetConditionResponse;

class FI_VersionUpdate;

class FI_VersionRegister;

class FailedServiceNameUpdate;

class FailedServiceNameRegister;

class FailedServiceStatusUpdate;

class FailedServiceStatusRegister;

class CallStackRequestCounterUpdate;

class CallStackRequestCounterRegister;

class ActionRequestUpdate;

class ActionRequestRegister;

class RequestPermissionRequestUpdate;

class RequestPermissionRequestRegister;

// type definitions
/**
 * If the meaning of "SetFailedServiceNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetFailedServiceNameError;

/**
 * If the meaning of "SetFailedServiceStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetFailedServiceStatusError;

/**
 * If the meaning of "SetCallStackRequestCounterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetCallStackRequestCounterError;

/**
 * If the meaning of "CheckResetConditionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CheckResetConditionError;

/**
 * This encodes the version string of the running
 * 	    systemd instance.
 */
typedef FI_VersionUpdate FI_VersionSet;

/**
 * This encodes the version string of the running
 * 	    systemd instance.
 */
typedef FI_VersionUpdate FI_VersionGet;

/**
 * If the meaning of "FI_VersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FI_VersionError;

/**
 * This encodes the service name of the failed unit.
 */
typedef FailedServiceNameUpdate FailedServiceNameSet;

/**
 * This encodes the service name of the failed unit.
 */
typedef FailedServiceNameUpdate FailedServiceNameGet;

/**
 * If the meaning of "FailedServiceNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FailedServiceNameError;

/**
 * Status of the service this instance runs for
 */
typedef FailedServiceStatusUpdate FailedServiceStatusSet;

/**
 * Status of the service this instance runs for
 */
typedef FailedServiceStatusUpdate FailedServiceStatusGet;

/**
 * If the meaning of "FailedServiceStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FailedServiceStatusError;

/**
 * This encodes the number of trials that the callstack was requested to be dumped
 */
typedef CallStackRequestCounterUpdate CallStackRequestCounterSet;

/**
 * This encodes the number of trials that the callstack was requested to be dumped
 */
typedef CallStackRequestCounterUpdate CallStackRequestCounterGet;

/**
 * If the meaning of "CallStackRequestCounterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CallStackRequestCounterError;

/**
 * This encodes the action to be taken for the failed service
 */
typedef ActionRequestUpdate ActionRequestSet;

/**
 * This encodes the action to be taken for the failed service
 */
typedef ActionRequestUpdate ActionRequestGet;

/**
 * If the meaning of "ActionRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActionRequestError;

/**
 * Status of reset permission from LcmRecoveryClient
 */
typedef RequestPermissionRequestUpdate RequestPermissionRequestSet;

/**
 * Status of reset permission from LcmRecoveryClient
 */
typedef RequestPermissionRequestUpdate RequestPermissionRequestGet;

/**
 * If the meaning of "RequestPermissionRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestPermissionRequestError;


/**
 * set the name of the service again
 */
class SetFailedServiceNameRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFailedServiceNameRequest ();

    /**
     * Copy constructor
     */
    inline  SetFailedServiceNameRequest (const SetFailedServiceNameRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetFailedServiceNameRequest (const ::std::string& serviceName_, UnitActions defaultAction_);

    /**
     * Destructor
     */
    inline virtual  ~SetFailedServiceNameRequest();

    /**
     * Assignment operator
     */
    inline SetFailedServiceNameRequest& operator = (const SetFailedServiceNameRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFailedServiceNameRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFailedServiceNameRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFailedServiceNameRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFailedServiceNameRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceName"

    static const int kServiceName = 0;

    /**
     * Clears the field "serviceName".
     *
     * The field will be set to its default value. The hasServiceName()
     * method will return false.
     */
    inline void clearServiceName();

    /**
     * Checks whether the field "serviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceName()). Otherwise it will return false.
     */
    inline bool hasServiceName () const;

    /**
     * Returns the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @return The value of the field "serviceName"
     */
    inline const ::std::string& getServiceName () const;

    /**
     * Retrieves the value of the field "serviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "serviceName".
     */
    inline ::std::string& getServiceNameMutable ();

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const ::std::string& serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* value, size_t size);

    // API of field "defaultAction"

    static const int kDefaultAction = 1;

    /**
     * Clears the field "defaultAction".
     *
     * The field will be set to its default value. The hasDefaultAction()
     * method will return false.
     */
    inline void clearDefaultAction();

    /**
     * Checks whether the field "defaultAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultAction()). Otherwise it will return false.
     */
    inline bool hasDefaultAction () const;

    /**
     * Returns the value of the member "defaultAction".
     *
     * default action defined for this service file
     *
     * @return The value of the field "defaultAction"
     */
    inline UnitActions getDefaultAction () const;

    /**
     * Sets the value of the member "defaultAction".
     *
     * default action defined for this service file
     *
     * @param defaultAction The value which will be set
     */
    inline void setDefaultAction (UnitActions defaultAction_);

    static const SetFailedServiceNameRequest &getDefaultInstance();

private:

    inline void set_has_serviceName ();

    inline void clear_has_serviceName ();

    inline void set_has_defaultAction ();

    inline void clear_has_defaultAction ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _serviceName;

    UnitActions _defaultAction;

};

/**
 * set the name of the service again
 */
class SetFailedServiceNameResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFailedServiceNameResponse ();

    /**
     * Copy constructor
     */
    inline  SetFailedServiceNameResponse (const SetFailedServiceNameResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetFailedServiceNameResponse (Response response_);

    /**
     * Destructor
     */
    inline virtual  ~SetFailedServiceNameResponse();

    /**
     * Assignment operator
     */
    inline SetFailedServiceNameResponse& operator = (const SetFailedServiceNameResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFailedServiceNameResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFailedServiceNameResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFailedServiceNameResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFailedServiceNameResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * response to this command see enumeration
     *
     * @return The value of the field "response"
     */
    inline Response getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * response to this command see enumeration
     *
     * @param response The value which will be set
     */
    inline void setResponse (Response response_);

    static const SetFailedServiceNameResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Response _response;

};

/**
 * set the status of the service again
 */
class SetFailedServiceStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFailedServiceStatusRequest ();

    /**
     * Copy constructor
     */
    inline  SetFailedServiceStatusRequest (const SetFailedServiceStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetFailedServiceStatusRequest (const ::std::string& serviceName_, UnitStates serviceState_);

    /**
     * Destructor
     */
    inline virtual  ~SetFailedServiceStatusRequest();

    /**
     * Assignment operator
     */
    inline SetFailedServiceStatusRequest& operator = (const SetFailedServiceStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFailedServiceStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFailedServiceStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFailedServiceStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFailedServiceStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceName"

    static const int kServiceName = 0;

    /**
     * Clears the field "serviceName".
     *
     * The field will be set to its default value. The hasServiceName()
     * method will return false.
     */
    inline void clearServiceName();

    /**
     * Checks whether the field "serviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceName()). Otherwise it will return false.
     */
    inline bool hasServiceName () const;

    /**
     * Returns the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @return The value of the field "serviceName"
     */
    inline const ::std::string& getServiceName () const;

    /**
     * Retrieves the value of the field "serviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "serviceName".
     */
    inline ::std::string& getServiceNameMutable ();

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const ::std::string& serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* value, size_t size);

    // API of field "serviceState"

    static const int kServiceState = 1;

    /**
     * Clears the field "serviceState".
     *
     * The field will be set to its default value. The hasServiceState()
     * method will return false.
     */
    inline void clearServiceState();

    /**
     * Checks whether the field "serviceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceState()). Otherwise it will return false.
     */
    inline bool hasServiceState () const;

    /**
     * Returns the value of the member "serviceState".
     *
     * Status of the service this instance runs for
     *
     * @return The value of the field "serviceState"
     */
    inline UnitStates getServiceState () const;

    /**
     * Sets the value of the member "serviceState".
     *
     * Status of the service this instance runs for
     *
     * @param serviceState The value which will be set
     */
    inline void setServiceState (UnitStates serviceState_);

    static const SetFailedServiceStatusRequest &getDefaultInstance();

private:

    inline void set_has_serviceName ();

    inline void clear_has_serviceName ();

    inline void set_has_serviceState ();

    inline void clear_has_serviceState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _serviceName;

    UnitStates _serviceState;

};

/**
 * set the status of the service again
 */
class SetFailedServiceStatusResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFailedServiceStatusResponse ();

    /**
     * Copy constructor
     */
    inline  SetFailedServiceStatusResponse (const SetFailedServiceStatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetFailedServiceStatusResponse (Response response_);

    /**
     * Destructor
     */
    inline virtual  ~SetFailedServiceStatusResponse();

    /**
     * Assignment operator
     */
    inline SetFailedServiceStatusResponse& operator = (const SetFailedServiceStatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFailedServiceStatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFailedServiceStatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFailedServiceStatusResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFailedServiceStatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * response to this command see enumeration
     *
     * @return The value of the field "response"
     */
    inline Response getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * response to this command see enumeration
     *
     * @param response The value which will be set
     */
    inline void setResponse (Response response_);

    static const SetFailedServiceStatusResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Response _response;

};

/**
 * send the actual counter of SIGUSER2 signals send
 */
class SetCallStackRequestCounterRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCallStackRequestCounterRequest ();

    /**
     * Copy constructor
     */
    inline  SetCallStackRequestCounterRequest (const SetCallStackRequestCounterRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetCallStackRequestCounterRequest (const ::std::string& serviceName_, uint8 callStackRequestCounter_);

    /**
     * Destructor
     */
    inline virtual  ~SetCallStackRequestCounterRequest();

    /**
     * Assignment operator
     */
    inline SetCallStackRequestCounterRequest& operator = (const SetCallStackRequestCounterRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCallStackRequestCounterRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCallStackRequestCounterRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCallStackRequestCounterRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCallStackRequestCounterRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceName"

    static const int kServiceName = 0;

    /**
     * Clears the field "serviceName".
     *
     * The field will be set to its default value. The hasServiceName()
     * method will return false.
     */
    inline void clearServiceName();

    /**
     * Checks whether the field "serviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceName()). Otherwise it will return false.
     */
    inline bool hasServiceName () const;

    /**
     * Returns the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @return The value of the field "serviceName"
     */
    inline const ::std::string& getServiceName () const;

    /**
     * Retrieves the value of the field "serviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "serviceName".
     */
    inline ::std::string& getServiceNameMutable ();

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const ::std::string& serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* value, size_t size);

    // API of field "callStackRequestCounter"

    static const int kCallStackRequestCounter = 1;

    /**
     * Clears the field "callStackRequestCounter".
     *
     * The field will be set to its default value. The hasCallStackRequestCounter()
     * method will return false.
     */
    inline void clearCallStackRequestCounter();

    /**
     * Checks whether the field "callStackRequestCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallStackRequestCounter()). Otherwise it will return false.
     */
    inline bool hasCallStackRequestCounter () const;

    /**
     * Returns the value of the member "callStackRequestCounter".
     *
     * Status of the service this instance runs for
     *
     * @return The value of the field "callStackRequestCounter"
     */
    inline uint8 getCallStackRequestCounter () const;

    /**
     * Sets the value of the member "callStackRequestCounter".
     *
     * Status of the service this instance runs for
     *
     * @param callStackRequestCounter The value which will be set
     */
    inline void setCallStackRequestCounter (uint8 callStackRequestCounter_);

    static const SetCallStackRequestCounterRequest &getDefaultInstance();

private:

    inline void set_has_serviceName ();

    inline void clear_has_serviceName ();

    inline void set_has_callStackRequestCounter ();

    inline void clear_has_callStackRequestCounter ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _serviceName;

    uint8 _callStackRequestCounter;

};

/**
 * send the actual counter of SIGUSER2 signals send
 */
class SetCallStackRequestCounterResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCallStackRequestCounterResponse ();

    /**
     * Copy constructor
     */
    inline  SetCallStackRequestCounterResponse (const SetCallStackRequestCounterResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetCallStackRequestCounterResponse (Response response_);

    /**
     * Destructor
     */
    inline virtual  ~SetCallStackRequestCounterResponse();

    /**
     * Assignment operator
     */
    inline SetCallStackRequestCounterResponse& operator = (const SetCallStackRequestCounterResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCallStackRequestCounterResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCallStackRequestCounterResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCallStackRequestCounterResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCallStackRequestCounterResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * response to this command see enumeration
     *
     * @return The value of the field "response"
     */
    inline Response getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * response to this command see enumeration
     *
     * @param response The value which will be set
     */
    inline void setResponse (Response response_);

    static const SetCallStackRequestCounterResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Response _response;

};

/**
 * Send request to Lcm in order to know reset condition
 */
class CheckResetConditionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CheckResetConditionRequest ();

    /**
     * Copy constructor
     */
    inline  CheckResetConditionRequest (const CheckResetConditionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CheckResetConditionRequest (const ::std::string& serviceName_);

    /**
     * Destructor
     */
    inline virtual  ~CheckResetConditionRequest();

    /**
     * Assignment operator
     */
    inline CheckResetConditionRequest& operator = (const CheckResetConditionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CheckResetConditionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CheckResetConditionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CheckResetConditionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CheckResetConditionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceName"

    static const int kServiceName = 0;

    /**
     * Clears the field "serviceName".
     *
     * The field will be set to its default value. The hasServiceName()
     * method will return false.
     */
    inline void clearServiceName();

    /**
     * Checks whether the field "serviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceName()). Otherwise it will return false.
     */
    inline bool hasServiceName () const;

    /**
     * Returns the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @return The value of the field "serviceName"
     */
    inline const ::std::string& getServiceName () const;

    /**
     * Retrieves the value of the field "serviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "serviceName".
     */
    inline ::std::string& getServiceNameMutable ();

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const ::std::string& serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * Name of the service this instance runs for
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* value, size_t size);

    static const CheckResetConditionRequest &getDefaultInstance();

private:

    inline void set_has_serviceName ();

    inline void clear_has_serviceName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _serviceName;

};

/**
 * Send request to Lcm in order to know reset condition
 */
class CheckResetConditionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CheckResetConditionResponse ();

    /**
     * Copy constructor
     */
    inline  CheckResetConditionResponse (const CheckResetConditionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CheckResetConditionResponse (LcmResetAllowed isOKToReset_);

    /**
     * Destructor
     */
    inline virtual  ~CheckResetConditionResponse();

    /**
     * Assignment operator
     */
    inline CheckResetConditionResponse& operator = (const CheckResetConditionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CheckResetConditionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CheckResetConditionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CheckResetConditionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CheckResetConditionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isOKToReset"

    static const int kIsOKToReset = 0;

    /**
     * Clears the field "isOKToReset".
     *
     * The field will be set to its default value. The hasIsOKToReset()
     * method will return false.
     */
    inline void clearIsOKToReset();

    /**
     * Checks whether the field "isOKToReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsOKToReset()). Otherwise it will return false.
     */
    inline bool hasIsOKToReset () const;

    /**
     * Returns the value of the member "isOKToReset".
     *
     * Status of the service can be reset or not
     *
     * @return The value of the field "isOKToReset"
     */
    inline LcmResetAllowed getIsOKToReset () const;

    /**
     * Sets the value of the member "isOKToReset".
     *
     * Status of the service can be reset or not
     *
     * @param isOKToReset The value which will be set
     */
    inline void setIsOKToReset (LcmResetAllowed isOKToReset_);

    static const CheckResetConditionResponse &getDefaultInstance();

private:

    inline void set_has_isOKToReset ();

    inline void clear_has_isOKToReset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    LcmResetAllowed _isOKToReset;

};

/**
 * This encodes the version string of the running
 * 	    systemd instance.
 */
class FI_VersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FI_VersionUpdate ();

    /**
     * Copy constructor
     */
    inline  FI_VersionUpdate (const FI_VersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FI_VersionUpdate (const ::std::string& FI_Version_);

    /**
     * Destructor
     */
    inline virtual  ~FI_VersionUpdate();

    /**
     * Assignment operator
     */
    inline FI_VersionUpdate& operator = (const FI_VersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FI_VersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FI_VersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FI_VersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FI_VersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FI_Version"

    static const int kFI_Version = 0;

    /**
     * Clears the field "FI_Version".
     *
     * The field will be set to its default value. The hasFI_Version()
     * method will return false.
     */
    inline void clearFI_Version();

    /**
     * Checks whether the field "FI_Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFI_Version()). Otherwise it will return false.
     */
    inline bool hasFI_Version () const;

    /**
     * Returns the value of the member "FI_Version".
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @return The value of the field "FI_Version"
     */
    inline const ::std::string& getFI_Version () const;

    /**
     * Retrieves the value of the field "FI_Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FI_Version".
     */
    inline ::std::string& getFI_VersionMutable ();

    /**
     * Sets the value of the member "FI_Version".
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param FI_Version The value which will be set
     */
    inline void setFI_Version (const ::std::string& FI_Version_);

    /**
     * Sets the value of the member "FI_Version".
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param FI_Version The value which will be set
     */
    inline void setFI_Version (const char* FI_Version_);

    /**
     * Sets the value of the member "FI_Version".
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param FI_Version The value which will be set
     */
    inline void setFI_Version (const char* value, size_t size);

    static const FI_VersionUpdate &getDefaultInstance();

private:

    inline void set_has_FI_Version ();

    inline void clear_has_FI_Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _FI_Version;

};

/**
 * This encodes the version string of the running
 * 	    systemd instance.
 */
class FI_VersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FI_VersionRegister ();

    /**
     * Copy constructor
     */
    inline  FI_VersionRegister (const FI_VersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FI_VersionRegister();

    /**
     * Assignment operator
     */
    inline FI_VersionRegister& operator = (const FI_VersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FI_VersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FI_VersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FI_VersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FI_VersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FI_VersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * This encodes the service name of the failed unit.
 */
class FailedServiceNameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FailedServiceNameUpdate ();

    /**
     * Copy constructor
     */
    inline  FailedServiceNameUpdate (const FailedServiceNameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FailedServiceNameUpdate (const ::std::string& FailedServiceName_);

    /**
     * Destructor
     */
    inline virtual  ~FailedServiceNameUpdate();

    /**
     * Assignment operator
     */
    inline FailedServiceNameUpdate& operator = (const FailedServiceNameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FailedServiceNameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FailedServiceNameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FailedServiceNameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FailedServiceNameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FailedServiceName"

    static const int kFailedServiceName = 0;

    /**
     * Clears the field "FailedServiceName".
     *
     * The field will be set to its default value. The hasFailedServiceName()
     * method will return false.
     */
    inline void clearFailedServiceName();

    /**
     * Checks whether the field "FailedServiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFailedServiceName()). Otherwise it will return false.
     */
    inline bool hasFailedServiceName () const;

    /**
     * Returns the value of the member "FailedServiceName".
     *
     * This encodes the service name of the failed unit.
     *
     * @return The value of the field "FailedServiceName"
     */
    inline const ::std::string& getFailedServiceName () const;

    /**
     * Retrieves the value of the field "FailedServiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FailedServiceName".
     */
    inline ::std::string& getFailedServiceNameMutable ();

    /**
     * Sets the value of the member "FailedServiceName".
     *
     * This encodes the service name of the failed unit.
     *
     * @param FailedServiceName The value which will be set
     */
    inline void setFailedServiceName (const ::std::string& FailedServiceName_);

    /**
     * Sets the value of the member "FailedServiceName".
     *
     * This encodes the service name of the failed unit.
     *
     * @param FailedServiceName The value which will be set
     */
    inline void setFailedServiceName (const char* FailedServiceName_);

    /**
     * Sets the value of the member "FailedServiceName".
     *
     * This encodes the service name of the failed unit.
     *
     * @param FailedServiceName The value which will be set
     */
    inline void setFailedServiceName (const char* value, size_t size);

    static const FailedServiceNameUpdate &getDefaultInstance();

private:

    inline void set_has_FailedServiceName ();

    inline void clear_has_FailedServiceName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _FailedServiceName;

};

/**
 * This encodes the service name of the failed unit.
 */
class FailedServiceNameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FailedServiceNameRegister ();

    /**
     * Copy constructor
     */
    inline  FailedServiceNameRegister (const FailedServiceNameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FailedServiceNameRegister();

    /**
     * Assignment operator
     */
    inline FailedServiceNameRegister& operator = (const FailedServiceNameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FailedServiceNameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FailedServiceNameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FailedServiceNameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FailedServiceNameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FailedServiceNameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Status of the service this instance runs for
 */
class FailedServiceStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FailedServiceStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  FailedServiceStatusUpdate (const FailedServiceStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FailedServiceStatusUpdate (UnitStates FailedServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FailedServiceStatusUpdate();

    /**
     * Assignment operator
     */
    inline FailedServiceStatusUpdate& operator = (const FailedServiceStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FailedServiceStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FailedServiceStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FailedServiceStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FailedServiceStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FailedServiceStatus"

    static const int kFailedServiceStatus = 0;

    /**
     * Clears the field "FailedServiceStatus".
     *
     * The field will be set to its default value. The hasFailedServiceStatus()
     * method will return false.
     */
    inline void clearFailedServiceStatus();

    /**
     * Checks whether the field "FailedServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFailedServiceStatus()). Otherwise it will return false.
     */
    inline bool hasFailedServiceStatus () const;

    /**
     * Returns the value of the member "FailedServiceStatus".
     *
     * Status of the service this instance runs for
     *
     * @return The value of the field "FailedServiceStatus"
     */
    inline UnitStates getFailedServiceStatus () const;

    /**
     * Sets the value of the member "FailedServiceStatus".
     *
     * Status of the service this instance runs for
     *
     * @param FailedServiceStatus The value which will be set
     */
    inline void setFailedServiceStatus (UnitStates FailedServiceStatus_);

    static const FailedServiceStatusUpdate &getDefaultInstance();

private:

    inline void set_has_FailedServiceStatus ();

    inline void clear_has_FailedServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    UnitStates _FailedServiceStatus;

};

/**
 * Status of the service this instance runs for
 */
class FailedServiceStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FailedServiceStatusRegister ();

    /**
     * Copy constructor
     */
    inline  FailedServiceStatusRegister (const FailedServiceStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FailedServiceStatusRegister();

    /**
     * Assignment operator
     */
    inline FailedServiceStatusRegister& operator = (const FailedServiceStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FailedServiceStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FailedServiceStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FailedServiceStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FailedServiceStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FailedServiceStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * This encodes the number of trials that the callstack was requested to be dumped
 */
class CallStackRequestCounterUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallStackRequestCounterUpdate ();

    /**
     * Copy constructor
     */
    inline  CallStackRequestCounterUpdate (const CallStackRequestCounterUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CallStackRequestCounterUpdate (uint8 CallStackRequestCounter_);

    /**
     * Destructor
     */
    inline virtual  ~CallStackRequestCounterUpdate();

    /**
     * Assignment operator
     */
    inline CallStackRequestCounterUpdate& operator = (const CallStackRequestCounterUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallStackRequestCounterUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallStackRequestCounterUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallStackRequestCounterUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallStackRequestCounterUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallStackRequestCounter"

    static const int kCallStackRequestCounter = 0;

    /**
     * Clears the field "CallStackRequestCounter".
     *
     * The field will be set to its default value. The hasCallStackRequestCounter()
     * method will return false.
     */
    inline void clearCallStackRequestCounter();

    /**
     * Checks whether the field "CallStackRequestCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallStackRequestCounter()). Otherwise it will return false.
     */
    inline bool hasCallStackRequestCounter () const;

    /**
     * Returns the value of the member "CallStackRequestCounter".
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     *
     * @return The value of the field "CallStackRequestCounter"
     */
    inline uint8 getCallStackRequestCounter () const;

    /**
     * Sets the value of the member "CallStackRequestCounter".
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     *
     * @param CallStackRequestCounter The value which will be set
     */
    inline void setCallStackRequestCounter (uint8 CallStackRequestCounter_);

    static const CallStackRequestCounterUpdate &getDefaultInstance();

private:

    inline void set_has_CallStackRequestCounter ();

    inline void clear_has_CallStackRequestCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CallStackRequestCounter;

};

/**
 * This encodes the number of trials that the callstack was requested to be dumped
 */
class CallStackRequestCounterRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallStackRequestCounterRegister ();

    /**
     * Copy constructor
     */
    inline  CallStackRequestCounterRegister (const CallStackRequestCounterRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CallStackRequestCounterRegister();

    /**
     * Assignment operator
     */
    inline CallStackRequestCounterRegister& operator = (const CallStackRequestCounterRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallStackRequestCounterRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallStackRequestCounterRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallStackRequestCounterRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallStackRequestCounterRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CallStackRequestCounterRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * This encodes the action to be taken for the failed service
 */
class ActionRequestUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActionRequestUpdate ();

    /**
     * Copy constructor
     */
    inline  ActionRequestUpdate (const ActionRequestUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActionRequestUpdate (UnitActions ActionRequest_);

    /**
     * Destructor
     */
    inline virtual  ~ActionRequestUpdate();

    /**
     * Assignment operator
     */
    inline ActionRequestUpdate& operator = (const ActionRequestUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActionRequestUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActionRequestUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActionRequestUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActionRequestUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActionRequest"

    static const int kActionRequest = 0;

    /**
     * Clears the field "ActionRequest".
     *
     * The field will be set to its default value. The hasActionRequest()
     * method will return false.
     */
    inline void clearActionRequest();

    /**
     * Checks whether the field "ActionRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionRequest()). Otherwise it will return false.
     */
    inline bool hasActionRequest () const;

    /**
     * Returns the value of the member "ActionRequest".
     *
     * This encodes the action to be taken for the failed service
     *
     * @return The value of the field "ActionRequest"
     */
    inline UnitActions getActionRequest () const;

    /**
     * Sets the value of the member "ActionRequest".
     *
     * This encodes the action to be taken for the failed service
     *
     * @param ActionRequest The value which will be set
     */
    inline void setActionRequest (UnitActions ActionRequest_);

    static const ActionRequestUpdate &getDefaultInstance();

private:

    inline void set_has_ActionRequest ();

    inline void clear_has_ActionRequest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    UnitActions _ActionRequest;

};

/**
 * This encodes the action to be taken for the failed service
 */
class ActionRequestRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActionRequestRegister ();

    /**
     * Copy constructor
     */
    inline  ActionRequestRegister (const ActionRequestRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActionRequestRegister();

    /**
     * Assignment operator
     */
    inline ActionRequestRegister& operator = (const ActionRequestRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActionRequestRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActionRequestRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActionRequestRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActionRequestRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActionRequestRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Status of reset permission from LcmRecoveryClient
 */
class RequestPermissionRequestUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPermissionRequestUpdate ();

    /**
     * Copy constructor
     */
    inline  RequestPermissionRequestUpdate (const RequestPermissionRequestUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPermissionRequestUpdate (LcmResetAllowed RequestPermissionRequest_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPermissionRequestUpdate();

    /**
     * Assignment operator
     */
    inline RequestPermissionRequestUpdate& operator = (const RequestPermissionRequestUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPermissionRequestUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPermissionRequestUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPermissionRequestUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPermissionRequestUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequestPermissionRequest"

    static const int kRequestPermissionRequest = 0;

    /**
     * Clears the field "RequestPermissionRequest".
     *
     * The field will be set to its default value. The hasRequestPermissionRequest()
     * method will return false.
     */
    inline void clearRequestPermissionRequest();

    /**
     * Checks whether the field "RequestPermissionRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestPermissionRequest()). Otherwise it will return false.
     */
    inline bool hasRequestPermissionRequest () const;

    /**
     * Returns the value of the member "RequestPermissionRequest".
     *
     * Status of reset permission from LcmRecoveryClient
     *
     * @return The value of the field "RequestPermissionRequest"
     */
    inline LcmResetAllowed getRequestPermissionRequest () const;

    /**
     * Sets the value of the member "RequestPermissionRequest".
     *
     * Status of reset permission from LcmRecoveryClient
     *
     * @param RequestPermissionRequest The value which will be set
     */
    inline void setRequestPermissionRequest (LcmResetAllowed RequestPermissionRequest_);

    static const RequestPermissionRequestUpdate &getDefaultInstance();

private:

    inline void set_has_RequestPermissionRequest ();

    inline void clear_has_RequestPermissionRequest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    LcmResetAllowed _RequestPermissionRequest;

};

/**
 * Status of reset permission from LcmRecoveryClient
 */
class RequestPermissionRequestRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPermissionRequestRegister ();

    /**
     * Copy constructor
     */
    inline  RequestPermissionRequestRegister (const RequestPermissionRequestRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequestPermissionRequestRegister();

    /**
     * Assignment operator
     */
    inline RequestPermissionRequestRegister& operator = (const RequestPermissionRequestRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPermissionRequestRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPermissionRequestRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPermissionRequestRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPermissionRequestRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequestPermissionRequestRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  SetFailedServiceNameRequest::SetFailedServiceNameRequest ()  :
    _serviceName (),
    _defaultAction (::org::bosch::cm::lcm::Generic_RecoveryClient::UnitActions__UNIT_KILL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFailedServiceNameRequest::SetFailedServiceNameRequest (const SetFailedServiceNameRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _serviceName (),
    _defaultAction (::org::bosch::cm::lcm::Generic_RecoveryClient::UnitActions__UNIT_KILL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFailedServiceNameRequest::SetFailedServiceNameRequest (const ::std::string& serviceName_, UnitActions defaultAction_)  :
    _serviceName (serviceName_),
    _defaultAction (defaultAction_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(UnitActions_IsValid(defaultAction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", defaultAction_, "UnitActions", "defaultAction", "SetFailedServiceNameRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFailedServiceNameRequest::~SetFailedServiceNameRequest() {
}

inline SetFailedServiceNameRequest& SetFailedServiceNameRequest::operator = (const SetFailedServiceNameRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasServiceName()) {
            setServiceName(rhs.getServiceName());
        } else {
            clearServiceName();
        }
        if (rhs.hasDefaultAction()) {
            setDefaultAction(rhs.getDefaultAction());
        } else {
            clearDefaultAction();
        }
    }
    return *this;
}

inline bool SetFailedServiceNameRequest::operator == (const SetFailedServiceNameRequest& rhs) const {
    return (((!hasServiceName() && !rhs.hasServiceName()) || getServiceName() == rhs.getServiceName()) &&
        ((!hasDefaultAction() && !rhs.hasDefaultAction()) || getDefaultAction() == rhs.getDefaultAction()));
}

inline bool SetFailedServiceNameRequest::operator != (const SetFailedServiceNameRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFailedServiceNameRequest::operator < (const SetFailedServiceNameRequest& rhs) const {
    if (hasServiceName() || rhs.hasServiceName()) {
        if (getServiceName() < rhs.getServiceName()) return true;
        if (getServiceName() > rhs.getServiceName()) return false;
    }
    if (hasDefaultAction() || rhs.hasDefaultAction()) {
        if ((uint32)getDefaultAction() < (uint32)rhs.getDefaultAction()) return true;
        if ((uint32)getDefaultAction() > (uint32)rhs.getDefaultAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFailedServiceNameRequest::clone() {
    return new SetFailedServiceNameRequest(*this);
}

inline bool SetFailedServiceNameRequest::operator > (const SetFailedServiceNameRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFailedServiceNameRequest::clear() {
    clearServiceName();
    clearDefaultAction();
}

inline void SetFailedServiceNameRequest::clearServiceName() {
    if (hasServiceName()) {
         clear_has_serviceName();
        _serviceName.clear();
     }
}

inline bool SetFailedServiceNameRequest::hasServiceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetFailedServiceNameRequest::getServiceName () const {
    return _serviceName;
}

inline ::std::string& SetFailedServiceNameRequest::getServiceNameMutable () {
    set_has_serviceName();
    return _serviceName;
}

inline void SetFailedServiceNameRequest::setServiceName (const ::std::string& serviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName = serviceName_;
}

inline void SetFailedServiceNameRequest::setServiceName (const char* serviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName.assign(serviceName_);
}

inline void SetFailedServiceNameRequest::setServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName.assign(value, size);
}

inline void SetFailedServiceNameRequest::clearDefaultAction() {
    if (hasDefaultAction()) {
         clear_has_defaultAction();
        _defaultAction = ::org::bosch::cm::lcm::Generic_RecoveryClient::UnitActions__UNIT_KILL;
     }
}

inline bool SetFailedServiceNameRequest::hasDefaultAction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline UnitActions SetFailedServiceNameRequest::getDefaultAction () const {
    return _defaultAction;
}

inline void SetFailedServiceNameRequest::setDefaultAction (UnitActions defaultAction_) {
    #ifndef NDEBUG
    if (!(UnitActions_IsValid(defaultAction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", defaultAction_, "UnitActions", "defaultAction", "SetFailedServiceNameRequest");
    }
    #endif
    set_has_defaultAction();
    this->_defaultAction = defaultAction_;
}

inline void SetFailedServiceNameRequest::set_has_serviceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFailedServiceNameRequest::clear_has_serviceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFailedServiceNameRequest::set_has_defaultAction () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFailedServiceNameRequest::clear_has_defaultAction () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetFailedServiceNameResponse::SetFailedServiceNameResponse ()  :
    _response (::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFailedServiceNameResponse::SetFailedServiceNameResponse (const SetFailedServiceNameResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFailedServiceNameResponse::SetFailedServiceNameResponse (Response response_)  :
    _response (response_)
{
    #ifndef NDEBUG
    if (!(Response_IsValid(response_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", response_, "Response", "response", "SetFailedServiceNameResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFailedServiceNameResponse::~SetFailedServiceNameResponse() {
}

inline SetFailedServiceNameResponse& SetFailedServiceNameResponse::operator = (const SetFailedServiceNameResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool SetFailedServiceNameResponse::operator == (const SetFailedServiceNameResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool SetFailedServiceNameResponse::operator != (const SetFailedServiceNameResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFailedServiceNameResponse::operator < (const SetFailedServiceNameResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if ((uint32)getResponse() < (uint32)rhs.getResponse()) return true;
        if ((uint32)getResponse() > (uint32)rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFailedServiceNameResponse::clone() {
    return new SetFailedServiceNameResponse(*this);
}

inline bool SetFailedServiceNameResponse::operator > (const SetFailedServiceNameResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFailedServiceNameResponse::clear() {
    clearResponse();
}

inline void SetFailedServiceNameResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = ::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK;
     }
}

inline bool SetFailedServiceNameResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline Response SetFailedServiceNameResponse::getResponse () const {
    return _response;
}

inline void SetFailedServiceNameResponse::setResponse (Response response_) {
    #ifndef NDEBUG
    if (!(Response_IsValid(response_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", response_, "Response", "response", "SetFailedServiceNameResponse");
    }
    #endif
    set_has_response();
    this->_response = response_;
}

inline void SetFailedServiceNameResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFailedServiceNameResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetFailedServiceStatusRequest::SetFailedServiceStatusRequest ()  :
    _serviceName (),
    _serviceState (::org::bosch::cm::lcm::Generic_RecoveryClient::UnitStates__UNIT_ACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFailedServiceStatusRequest::SetFailedServiceStatusRequest (const SetFailedServiceStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _serviceName (),
    _serviceState (::org::bosch::cm::lcm::Generic_RecoveryClient::UnitStates__UNIT_ACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFailedServiceStatusRequest::SetFailedServiceStatusRequest (const ::std::string& serviceName_, UnitStates serviceState_)  :
    _serviceName (serviceName_),
    _serviceState (serviceState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(UnitStates_IsValid(serviceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", serviceState_, "UnitStates", "serviceState", "SetFailedServiceStatusRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFailedServiceStatusRequest::~SetFailedServiceStatusRequest() {
}

inline SetFailedServiceStatusRequest& SetFailedServiceStatusRequest::operator = (const SetFailedServiceStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasServiceName()) {
            setServiceName(rhs.getServiceName());
        } else {
            clearServiceName();
        }
        if (rhs.hasServiceState()) {
            setServiceState(rhs.getServiceState());
        } else {
            clearServiceState();
        }
    }
    return *this;
}

inline bool SetFailedServiceStatusRequest::operator == (const SetFailedServiceStatusRequest& rhs) const {
    return (((!hasServiceName() && !rhs.hasServiceName()) || getServiceName() == rhs.getServiceName()) &&
        ((!hasServiceState() && !rhs.hasServiceState()) || getServiceState() == rhs.getServiceState()));
}

inline bool SetFailedServiceStatusRequest::operator != (const SetFailedServiceStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFailedServiceStatusRequest::operator < (const SetFailedServiceStatusRequest& rhs) const {
    if (hasServiceName() || rhs.hasServiceName()) {
        if (getServiceName() < rhs.getServiceName()) return true;
        if (getServiceName() > rhs.getServiceName()) return false;
    }
    if (hasServiceState() || rhs.hasServiceState()) {
        if ((uint32)getServiceState() < (uint32)rhs.getServiceState()) return true;
        if ((uint32)getServiceState() > (uint32)rhs.getServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFailedServiceStatusRequest::clone() {
    return new SetFailedServiceStatusRequest(*this);
}

inline bool SetFailedServiceStatusRequest::operator > (const SetFailedServiceStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFailedServiceStatusRequest::clear() {
    clearServiceName();
    clearServiceState();
}

inline void SetFailedServiceStatusRequest::clearServiceName() {
    if (hasServiceName()) {
         clear_has_serviceName();
        _serviceName.clear();
     }
}

inline bool SetFailedServiceStatusRequest::hasServiceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetFailedServiceStatusRequest::getServiceName () const {
    return _serviceName;
}

inline ::std::string& SetFailedServiceStatusRequest::getServiceNameMutable () {
    set_has_serviceName();
    return _serviceName;
}

inline void SetFailedServiceStatusRequest::setServiceName (const ::std::string& serviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName = serviceName_;
}

inline void SetFailedServiceStatusRequest::setServiceName (const char* serviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName.assign(serviceName_);
}

inline void SetFailedServiceStatusRequest::setServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName.assign(value, size);
}

inline void SetFailedServiceStatusRequest::clearServiceState() {
    if (hasServiceState()) {
         clear_has_serviceState();
        _serviceState = ::org::bosch::cm::lcm::Generic_RecoveryClient::UnitStates__UNIT_ACTIVE;
     }
}

inline bool SetFailedServiceStatusRequest::hasServiceState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline UnitStates SetFailedServiceStatusRequest::getServiceState () const {
    return _serviceState;
}

inline void SetFailedServiceStatusRequest::setServiceState (UnitStates serviceState_) {
    #ifndef NDEBUG
    if (!(UnitStates_IsValid(serviceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", serviceState_, "UnitStates", "serviceState", "SetFailedServiceStatusRequest");
    }
    #endif
    set_has_serviceState();
    this->_serviceState = serviceState_;
}

inline void SetFailedServiceStatusRequest::set_has_serviceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFailedServiceStatusRequest::clear_has_serviceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFailedServiceStatusRequest::set_has_serviceState () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFailedServiceStatusRequest::clear_has_serviceState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetFailedServiceStatusResponse::SetFailedServiceStatusResponse ()  :
    _response (::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFailedServiceStatusResponse::SetFailedServiceStatusResponse (const SetFailedServiceStatusResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFailedServiceStatusResponse::SetFailedServiceStatusResponse (Response response_)  :
    _response (response_)
{
    #ifndef NDEBUG
    if (!(Response_IsValid(response_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", response_, "Response", "response", "SetFailedServiceStatusResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFailedServiceStatusResponse::~SetFailedServiceStatusResponse() {
}

inline SetFailedServiceStatusResponse& SetFailedServiceStatusResponse::operator = (const SetFailedServiceStatusResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool SetFailedServiceStatusResponse::operator == (const SetFailedServiceStatusResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool SetFailedServiceStatusResponse::operator != (const SetFailedServiceStatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFailedServiceStatusResponse::operator < (const SetFailedServiceStatusResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if ((uint32)getResponse() < (uint32)rhs.getResponse()) return true;
        if ((uint32)getResponse() > (uint32)rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFailedServiceStatusResponse::clone() {
    return new SetFailedServiceStatusResponse(*this);
}

inline bool SetFailedServiceStatusResponse::operator > (const SetFailedServiceStatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFailedServiceStatusResponse::clear() {
    clearResponse();
}

inline void SetFailedServiceStatusResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = ::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK;
     }
}

inline bool SetFailedServiceStatusResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline Response SetFailedServiceStatusResponse::getResponse () const {
    return _response;
}

inline void SetFailedServiceStatusResponse::setResponse (Response response_) {
    #ifndef NDEBUG
    if (!(Response_IsValid(response_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", response_, "Response", "response", "SetFailedServiceStatusResponse");
    }
    #endif
    set_has_response();
    this->_response = response_;
}

inline void SetFailedServiceStatusResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFailedServiceStatusResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetCallStackRequestCounterRequest::SetCallStackRequestCounterRequest ()  :
    _serviceName (),
    _callStackRequestCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetCallStackRequestCounterRequest::SetCallStackRequestCounterRequest (const SetCallStackRequestCounterRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _serviceName (),
    _callStackRequestCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetCallStackRequestCounterRequest::SetCallStackRequestCounterRequest (const ::std::string& serviceName_, uint8 callStackRequestCounter_)  :
    _serviceName (serviceName_),
    _callStackRequestCounter (callStackRequestCounter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetCallStackRequestCounterRequest::~SetCallStackRequestCounterRequest() {
}

inline SetCallStackRequestCounterRequest& SetCallStackRequestCounterRequest::operator = (const SetCallStackRequestCounterRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasServiceName()) {
            setServiceName(rhs.getServiceName());
        } else {
            clearServiceName();
        }
        if (rhs.hasCallStackRequestCounter()) {
            setCallStackRequestCounter(rhs.getCallStackRequestCounter());
        } else {
            clearCallStackRequestCounter();
        }
    }
    return *this;
}

inline bool SetCallStackRequestCounterRequest::operator == (const SetCallStackRequestCounterRequest& rhs) const {
    return (((!hasServiceName() && !rhs.hasServiceName()) || getServiceName() == rhs.getServiceName()) &&
        ((!hasCallStackRequestCounter() && !rhs.hasCallStackRequestCounter()) || getCallStackRequestCounter() == rhs.getCallStackRequestCounter()));
}

inline bool SetCallStackRequestCounterRequest::operator != (const SetCallStackRequestCounterRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetCallStackRequestCounterRequest::operator < (const SetCallStackRequestCounterRequest& rhs) const {
    if (hasServiceName() || rhs.hasServiceName()) {
        if (getServiceName() < rhs.getServiceName()) return true;
        if (getServiceName() > rhs.getServiceName()) return false;
    }
    if (hasCallStackRequestCounter() || rhs.hasCallStackRequestCounter()) {
        if (getCallStackRequestCounter() < rhs.getCallStackRequestCounter()) return true;
        if (getCallStackRequestCounter() > rhs.getCallStackRequestCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetCallStackRequestCounterRequest::clone() {
    return new SetCallStackRequestCounterRequest(*this);
}

inline bool SetCallStackRequestCounterRequest::operator > (const SetCallStackRequestCounterRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetCallStackRequestCounterRequest::clear() {
    clearServiceName();
    clearCallStackRequestCounter();
}

inline void SetCallStackRequestCounterRequest::clearServiceName() {
    if (hasServiceName()) {
         clear_has_serviceName();
        _serviceName.clear();
     }
}

inline bool SetCallStackRequestCounterRequest::hasServiceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetCallStackRequestCounterRequest::getServiceName () const {
    return _serviceName;
}

inline ::std::string& SetCallStackRequestCounterRequest::getServiceNameMutable () {
    set_has_serviceName();
    return _serviceName;
}

inline void SetCallStackRequestCounterRequest::setServiceName (const ::std::string& serviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName = serviceName_;
}

inline void SetCallStackRequestCounterRequest::setServiceName (const char* serviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName.assign(serviceName_);
}

inline void SetCallStackRequestCounterRequest::setServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName.assign(value, size);
}

inline void SetCallStackRequestCounterRequest::clearCallStackRequestCounter() {
    if (hasCallStackRequestCounter()) {
         clear_has_callStackRequestCounter();
        _callStackRequestCounter = 0u;
     }
}

inline bool SetCallStackRequestCounterRequest::hasCallStackRequestCounter () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SetCallStackRequestCounterRequest::getCallStackRequestCounter () const {
    return _callStackRequestCounter;
}

inline void SetCallStackRequestCounterRequest::setCallStackRequestCounter (uint8 callStackRequestCounter_) {
    set_has_callStackRequestCounter();
    this->_callStackRequestCounter = callStackRequestCounter_;
}

inline void SetCallStackRequestCounterRequest::set_has_serviceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetCallStackRequestCounterRequest::clear_has_serviceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetCallStackRequestCounterRequest::set_has_callStackRequestCounter () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetCallStackRequestCounterRequest::clear_has_callStackRequestCounter () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetCallStackRequestCounterResponse::SetCallStackRequestCounterResponse ()  :
    _response (::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetCallStackRequestCounterResponse::SetCallStackRequestCounterResponse (const SetCallStackRequestCounterResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetCallStackRequestCounterResponse::SetCallStackRequestCounterResponse (Response response_)  :
    _response (response_)
{
    #ifndef NDEBUG
    if (!(Response_IsValid(response_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", response_, "Response", "response", "SetCallStackRequestCounterResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetCallStackRequestCounterResponse::~SetCallStackRequestCounterResponse() {
}

inline SetCallStackRequestCounterResponse& SetCallStackRequestCounterResponse::operator = (const SetCallStackRequestCounterResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool SetCallStackRequestCounterResponse::operator == (const SetCallStackRequestCounterResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool SetCallStackRequestCounterResponse::operator != (const SetCallStackRequestCounterResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetCallStackRequestCounterResponse::operator < (const SetCallStackRequestCounterResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if ((uint32)getResponse() < (uint32)rhs.getResponse()) return true;
        if ((uint32)getResponse() > (uint32)rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetCallStackRequestCounterResponse::clone() {
    return new SetCallStackRequestCounterResponse(*this);
}

inline bool SetCallStackRequestCounterResponse::operator > (const SetCallStackRequestCounterResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetCallStackRequestCounterResponse::clear() {
    clearResponse();
}

inline void SetCallStackRequestCounterResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = ::org::bosch::cm::lcm::Generic_RecoveryClient::Response__E_OK;
     }
}

inline bool SetCallStackRequestCounterResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline Response SetCallStackRequestCounterResponse::getResponse () const {
    return _response;
}

inline void SetCallStackRequestCounterResponse::setResponse (Response response_) {
    #ifndef NDEBUG
    if (!(Response_IsValid(response_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", response_, "Response", "response", "SetCallStackRequestCounterResponse");
    }
    #endif
    set_has_response();
    this->_response = response_;
}

inline void SetCallStackRequestCounterResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetCallStackRequestCounterResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CheckResetConditionRequest::CheckResetConditionRequest ()  :
    _serviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CheckResetConditionRequest::CheckResetConditionRequest (const CheckResetConditionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _serviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CheckResetConditionRequest::CheckResetConditionRequest (const ::std::string& serviceName_)  :
    _serviceName (serviceName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CheckResetConditionRequest::~CheckResetConditionRequest() {
}

inline CheckResetConditionRequest& CheckResetConditionRequest::operator = (const CheckResetConditionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasServiceName()) {
            setServiceName(rhs.getServiceName());
        } else {
            clearServiceName();
        }
    }
    return *this;
}

inline bool CheckResetConditionRequest::operator == (const CheckResetConditionRequest& rhs) const {
    return (((!hasServiceName() && !rhs.hasServiceName()) || getServiceName() == rhs.getServiceName()));
}

inline bool CheckResetConditionRequest::operator != (const CheckResetConditionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CheckResetConditionRequest::operator < (const CheckResetConditionRequest& rhs) const {
    if (hasServiceName() || rhs.hasServiceName()) {
        if (getServiceName() < rhs.getServiceName()) return true;
        if (getServiceName() > rhs.getServiceName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CheckResetConditionRequest::clone() {
    return new CheckResetConditionRequest(*this);
}

inline bool CheckResetConditionRequest::operator > (const CheckResetConditionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CheckResetConditionRequest::clear() {
    clearServiceName();
}

inline void CheckResetConditionRequest::clearServiceName() {
    if (hasServiceName()) {
         clear_has_serviceName();
        _serviceName.clear();
     }
}

inline bool CheckResetConditionRequest::hasServiceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CheckResetConditionRequest::getServiceName () const {
    return _serviceName;
}

inline ::std::string& CheckResetConditionRequest::getServiceNameMutable () {
    set_has_serviceName();
    return _serviceName;
}

inline void CheckResetConditionRequest::setServiceName (const ::std::string& serviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName = serviceName_;
}

inline void CheckResetConditionRequest::setServiceName (const char* serviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName.assign(serviceName_);
}

inline void CheckResetConditionRequest::setServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceName();
    this->_serviceName.assign(value, size);
}

inline void CheckResetConditionRequest::set_has_serviceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void CheckResetConditionRequest::clear_has_serviceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CheckResetConditionResponse::CheckResetConditionResponse ()  :
    _isOKToReset (::org::bosch::cm::lcm::Generic_RecoveryClient::LcmResetAllowed__ALLOW_TO_RESET)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CheckResetConditionResponse::CheckResetConditionResponse (const CheckResetConditionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _isOKToReset (::org::bosch::cm::lcm::Generic_RecoveryClient::LcmResetAllowed__ALLOW_TO_RESET)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CheckResetConditionResponse::CheckResetConditionResponse (LcmResetAllowed isOKToReset_)  :
    _isOKToReset (isOKToReset_)
{
    #ifndef NDEBUG
    if (!(LcmResetAllowed_IsValid(isOKToReset_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", isOKToReset_, "LcmResetAllowed", "isOKToReset", "CheckResetConditionResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CheckResetConditionResponse::~CheckResetConditionResponse() {
}

inline CheckResetConditionResponse& CheckResetConditionResponse::operator = (const CheckResetConditionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIsOKToReset()) {
            setIsOKToReset(rhs.getIsOKToReset());
        } else {
            clearIsOKToReset();
        }
    }
    return *this;
}

inline bool CheckResetConditionResponse::operator == (const CheckResetConditionResponse& rhs) const {
    return (((!hasIsOKToReset() && !rhs.hasIsOKToReset()) || getIsOKToReset() == rhs.getIsOKToReset()));
}

inline bool CheckResetConditionResponse::operator != (const CheckResetConditionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CheckResetConditionResponse::operator < (const CheckResetConditionResponse& rhs) const {
    if (hasIsOKToReset() || rhs.hasIsOKToReset()) {
        if ((uint32)getIsOKToReset() < (uint32)rhs.getIsOKToReset()) return true;
        if ((uint32)getIsOKToReset() > (uint32)rhs.getIsOKToReset()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CheckResetConditionResponse::clone() {
    return new CheckResetConditionResponse(*this);
}

inline bool CheckResetConditionResponse::operator > (const CheckResetConditionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CheckResetConditionResponse::clear() {
    clearIsOKToReset();
}

inline void CheckResetConditionResponse::clearIsOKToReset() {
    if (hasIsOKToReset()) {
         clear_has_isOKToReset();
        _isOKToReset = ::org::bosch::cm::lcm::Generic_RecoveryClient::LcmResetAllowed__ALLOW_TO_RESET;
     }
}

inline bool CheckResetConditionResponse::hasIsOKToReset () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline LcmResetAllowed CheckResetConditionResponse::getIsOKToReset () const {
    return _isOKToReset;
}

inline void CheckResetConditionResponse::setIsOKToReset (LcmResetAllowed isOKToReset_) {
    #ifndef NDEBUG
    if (!(LcmResetAllowed_IsValid(isOKToReset_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", isOKToReset_, "LcmResetAllowed", "isOKToReset", "CheckResetConditionResponse");
    }
    #endif
    set_has_isOKToReset();
    this->_isOKToReset = isOKToReset_;
}

inline void CheckResetConditionResponse::set_has_isOKToReset () {
    _has_bits_[0] |= 1u << 0;
}

inline void CheckResetConditionResponse::clear_has_isOKToReset () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FI_VersionUpdate::FI_VersionUpdate ()  :
    _FI_Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FI_VersionUpdate::FI_VersionUpdate (const FI_VersionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _FI_Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FI_VersionUpdate::FI_VersionUpdate (const ::std::string& FI_Version_)  :
    _FI_Version (FI_Version_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FI_Version_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FI_VersionUpdate::~FI_VersionUpdate() {
}

inline FI_VersionUpdate& FI_VersionUpdate::operator = (const FI_VersionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFI_Version()) {
            setFI_Version(rhs.getFI_Version());
        } else {
            clearFI_Version();
        }
    }
    return *this;
}

inline bool FI_VersionUpdate::operator == (const FI_VersionUpdate& rhs) const {
    return (((!hasFI_Version() && !rhs.hasFI_Version()) || getFI_Version() == rhs.getFI_Version()));
}

inline bool FI_VersionUpdate::operator != (const FI_VersionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FI_VersionUpdate::operator < (const FI_VersionUpdate& rhs) const {
    if (hasFI_Version() || rhs.hasFI_Version()) {
        if (getFI_Version() < rhs.getFI_Version()) return true;
        if (getFI_Version() > rhs.getFI_Version()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FI_VersionUpdate::clone() {
    return new FI_VersionUpdate(*this);
}

inline bool FI_VersionUpdate::operator > (const FI_VersionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FI_VersionUpdate::clear() {
    clearFI_Version();
}

inline void FI_VersionUpdate::clearFI_Version() {
    if (hasFI_Version()) {
         clear_has_FI_Version();
        _FI_Version.clear();
     }
}

inline bool FI_VersionUpdate::hasFI_Version () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FI_VersionUpdate::getFI_Version () const {
    return _FI_Version;
}

inline ::std::string& FI_VersionUpdate::getFI_VersionMutable () {
    set_has_FI_Version();
    return _FI_Version;
}

inline void FI_VersionUpdate::setFI_Version (const ::std::string& FI_Version_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FI_Version_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FI_Version();
    this->_FI_Version = FI_Version_;
}

inline void FI_VersionUpdate::setFI_Version (const char* FI_Version_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FI_Version_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FI_Version();
    this->_FI_Version.assign(FI_Version_);
}

inline void FI_VersionUpdate::setFI_Version (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FI_Version();
    this->_FI_Version.assign(value, size);
}

inline void FI_VersionUpdate::set_has_FI_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void FI_VersionUpdate::clear_has_FI_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FI_VersionRegister::FI_VersionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FI_VersionRegister::FI_VersionRegister (const FI_VersionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FI_VersionRegister::~FI_VersionRegister() {
}

inline FI_VersionRegister& FI_VersionRegister::operator = (const FI_VersionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FI_VersionRegister::operator == (const FI_VersionRegister& ) const {
    return true;
}

inline bool FI_VersionRegister::operator != (const FI_VersionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FI_VersionRegister::operator < (const FI_VersionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FI_VersionRegister::clone() {
    return new FI_VersionRegister(*this);
}

inline bool FI_VersionRegister::operator > (const FI_VersionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FI_VersionRegister::clear() {
}

inline  FailedServiceNameUpdate::FailedServiceNameUpdate ()  :
    _FailedServiceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FailedServiceNameUpdate::FailedServiceNameUpdate (const FailedServiceNameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _FailedServiceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FailedServiceNameUpdate::FailedServiceNameUpdate (const ::std::string& FailedServiceName_)  :
    _FailedServiceName (FailedServiceName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FailedServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FailedServiceNameUpdate::~FailedServiceNameUpdate() {
}

inline FailedServiceNameUpdate& FailedServiceNameUpdate::operator = (const FailedServiceNameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFailedServiceName()) {
            setFailedServiceName(rhs.getFailedServiceName());
        } else {
            clearFailedServiceName();
        }
    }
    return *this;
}

inline bool FailedServiceNameUpdate::operator == (const FailedServiceNameUpdate& rhs) const {
    return (((!hasFailedServiceName() && !rhs.hasFailedServiceName()) || getFailedServiceName() == rhs.getFailedServiceName()));
}

inline bool FailedServiceNameUpdate::operator != (const FailedServiceNameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FailedServiceNameUpdate::operator < (const FailedServiceNameUpdate& rhs) const {
    if (hasFailedServiceName() || rhs.hasFailedServiceName()) {
        if (getFailedServiceName() < rhs.getFailedServiceName()) return true;
        if (getFailedServiceName() > rhs.getFailedServiceName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FailedServiceNameUpdate::clone() {
    return new FailedServiceNameUpdate(*this);
}

inline bool FailedServiceNameUpdate::operator > (const FailedServiceNameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FailedServiceNameUpdate::clear() {
    clearFailedServiceName();
}

inline void FailedServiceNameUpdate::clearFailedServiceName() {
    if (hasFailedServiceName()) {
         clear_has_FailedServiceName();
        _FailedServiceName.clear();
     }
}

inline bool FailedServiceNameUpdate::hasFailedServiceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FailedServiceNameUpdate::getFailedServiceName () const {
    return _FailedServiceName;
}

inline ::std::string& FailedServiceNameUpdate::getFailedServiceNameMutable () {
    set_has_FailedServiceName();
    return _FailedServiceName;
}

inline void FailedServiceNameUpdate::setFailedServiceName (const ::std::string& FailedServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FailedServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FailedServiceName();
    this->_FailedServiceName = FailedServiceName_;
}

inline void FailedServiceNameUpdate::setFailedServiceName (const char* FailedServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FailedServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FailedServiceName();
    this->_FailedServiceName.assign(FailedServiceName_);
}

inline void FailedServiceNameUpdate::setFailedServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FailedServiceName();
    this->_FailedServiceName.assign(value, size);
}

inline void FailedServiceNameUpdate::set_has_FailedServiceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void FailedServiceNameUpdate::clear_has_FailedServiceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FailedServiceNameRegister::FailedServiceNameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FailedServiceNameRegister::FailedServiceNameRegister (const FailedServiceNameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FailedServiceNameRegister::~FailedServiceNameRegister() {
}

inline FailedServiceNameRegister& FailedServiceNameRegister::operator = (const FailedServiceNameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FailedServiceNameRegister::operator == (const FailedServiceNameRegister& ) const {
    return true;
}

inline bool FailedServiceNameRegister::operator != (const FailedServiceNameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FailedServiceNameRegister::operator < (const FailedServiceNameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FailedServiceNameRegister::clone() {
    return new FailedServiceNameRegister(*this);
}

inline bool FailedServiceNameRegister::operator > (const FailedServiceNameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FailedServiceNameRegister::clear() {
}

inline  FailedServiceStatusUpdate::FailedServiceStatusUpdate ()  :
    _FailedServiceStatus (::org::bosch::cm::lcm::Generic_RecoveryClient::UnitStates__UNIT_ACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FailedServiceStatusUpdate::FailedServiceStatusUpdate (const FailedServiceStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _FailedServiceStatus (::org::bosch::cm::lcm::Generic_RecoveryClient::UnitStates__UNIT_ACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FailedServiceStatusUpdate::FailedServiceStatusUpdate (UnitStates FailedServiceStatus_)  :
    _FailedServiceStatus (FailedServiceStatus_)
{
    #ifndef NDEBUG
    if (!(UnitStates_IsValid(FailedServiceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FailedServiceStatus_, "UnitStates", "FailedServiceStatus", "FailedServiceStatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FailedServiceStatusUpdate::~FailedServiceStatusUpdate() {
}

inline FailedServiceStatusUpdate& FailedServiceStatusUpdate::operator = (const FailedServiceStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFailedServiceStatus()) {
            setFailedServiceStatus(rhs.getFailedServiceStatus());
        } else {
            clearFailedServiceStatus();
        }
    }
    return *this;
}

inline bool FailedServiceStatusUpdate::operator == (const FailedServiceStatusUpdate& rhs) const {
    return (((!hasFailedServiceStatus() && !rhs.hasFailedServiceStatus()) || getFailedServiceStatus() == rhs.getFailedServiceStatus()));
}

inline bool FailedServiceStatusUpdate::operator != (const FailedServiceStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FailedServiceStatusUpdate::operator < (const FailedServiceStatusUpdate& rhs) const {
    if (hasFailedServiceStatus() || rhs.hasFailedServiceStatus()) {
        if ((uint32)getFailedServiceStatus() < (uint32)rhs.getFailedServiceStatus()) return true;
        if ((uint32)getFailedServiceStatus() > (uint32)rhs.getFailedServiceStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FailedServiceStatusUpdate::clone() {
    return new FailedServiceStatusUpdate(*this);
}

inline bool FailedServiceStatusUpdate::operator > (const FailedServiceStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FailedServiceStatusUpdate::clear() {
    clearFailedServiceStatus();
}

inline void FailedServiceStatusUpdate::clearFailedServiceStatus() {
    if (hasFailedServiceStatus()) {
         clear_has_FailedServiceStatus();
        _FailedServiceStatus = ::org::bosch::cm::lcm::Generic_RecoveryClient::UnitStates__UNIT_ACTIVE;
     }
}

inline bool FailedServiceStatusUpdate::hasFailedServiceStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline UnitStates FailedServiceStatusUpdate::getFailedServiceStatus () const {
    return _FailedServiceStatus;
}

inline void FailedServiceStatusUpdate::setFailedServiceStatus (UnitStates FailedServiceStatus_) {
    #ifndef NDEBUG
    if (!(UnitStates_IsValid(FailedServiceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FailedServiceStatus_, "UnitStates", "FailedServiceStatus", "FailedServiceStatusUpdate");
    }
    #endif
    set_has_FailedServiceStatus();
    this->_FailedServiceStatus = FailedServiceStatus_;
}

inline void FailedServiceStatusUpdate::set_has_FailedServiceStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void FailedServiceStatusUpdate::clear_has_FailedServiceStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FailedServiceStatusRegister::FailedServiceStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FailedServiceStatusRegister::FailedServiceStatusRegister (const FailedServiceStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FailedServiceStatusRegister::~FailedServiceStatusRegister() {
}

inline FailedServiceStatusRegister& FailedServiceStatusRegister::operator = (const FailedServiceStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FailedServiceStatusRegister::operator == (const FailedServiceStatusRegister& ) const {
    return true;
}

inline bool FailedServiceStatusRegister::operator != (const FailedServiceStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FailedServiceStatusRegister::operator < (const FailedServiceStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FailedServiceStatusRegister::clone() {
    return new FailedServiceStatusRegister(*this);
}

inline bool FailedServiceStatusRegister::operator > (const FailedServiceStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FailedServiceStatusRegister::clear() {
}

inline  CallStackRequestCounterUpdate::CallStackRequestCounterUpdate ()  :
    _CallStackRequestCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CallStackRequestCounterUpdate::CallStackRequestCounterUpdate (const CallStackRequestCounterUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CallStackRequestCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CallStackRequestCounterUpdate::CallStackRequestCounterUpdate (uint8 CallStackRequestCounter_)  :
    _CallStackRequestCounter (CallStackRequestCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CallStackRequestCounterUpdate::~CallStackRequestCounterUpdate() {
}

inline CallStackRequestCounterUpdate& CallStackRequestCounterUpdate::operator = (const CallStackRequestCounterUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallStackRequestCounter()) {
            setCallStackRequestCounter(rhs.getCallStackRequestCounter());
        } else {
            clearCallStackRequestCounter();
        }
    }
    return *this;
}

inline bool CallStackRequestCounterUpdate::operator == (const CallStackRequestCounterUpdate& rhs) const {
    return (((!hasCallStackRequestCounter() && !rhs.hasCallStackRequestCounter()) || getCallStackRequestCounter() == rhs.getCallStackRequestCounter()));
}

inline bool CallStackRequestCounterUpdate::operator != (const CallStackRequestCounterUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CallStackRequestCounterUpdate::operator < (const CallStackRequestCounterUpdate& rhs) const {
    if (hasCallStackRequestCounter() || rhs.hasCallStackRequestCounter()) {
        if (getCallStackRequestCounter() < rhs.getCallStackRequestCounter()) return true;
        if (getCallStackRequestCounter() > rhs.getCallStackRequestCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CallStackRequestCounterUpdate::clone() {
    return new CallStackRequestCounterUpdate(*this);
}

inline bool CallStackRequestCounterUpdate::operator > (const CallStackRequestCounterUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CallStackRequestCounterUpdate::clear() {
    clearCallStackRequestCounter();
}

inline void CallStackRequestCounterUpdate::clearCallStackRequestCounter() {
    if (hasCallStackRequestCounter()) {
         clear_has_CallStackRequestCounter();
        _CallStackRequestCounter = 0u;
     }
}

inline bool CallStackRequestCounterUpdate::hasCallStackRequestCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 CallStackRequestCounterUpdate::getCallStackRequestCounter () const {
    return _CallStackRequestCounter;
}

inline void CallStackRequestCounterUpdate::setCallStackRequestCounter (uint8 CallStackRequestCounter_) {
    set_has_CallStackRequestCounter();
    this->_CallStackRequestCounter = CallStackRequestCounter_;
}

inline void CallStackRequestCounterUpdate::set_has_CallStackRequestCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void CallStackRequestCounterUpdate::clear_has_CallStackRequestCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CallStackRequestCounterRegister::CallStackRequestCounterRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CallStackRequestCounterRegister::CallStackRequestCounterRegister (const CallStackRequestCounterRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CallStackRequestCounterRegister::~CallStackRequestCounterRegister() {
}

inline CallStackRequestCounterRegister& CallStackRequestCounterRegister::operator = (const CallStackRequestCounterRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CallStackRequestCounterRegister::operator == (const CallStackRequestCounterRegister& ) const {
    return true;
}

inline bool CallStackRequestCounterRegister::operator != (const CallStackRequestCounterRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CallStackRequestCounterRegister::operator < (const CallStackRequestCounterRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CallStackRequestCounterRegister::clone() {
    return new CallStackRequestCounterRegister(*this);
}

inline bool CallStackRequestCounterRegister::operator > (const CallStackRequestCounterRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CallStackRequestCounterRegister::clear() {
}

inline  ActionRequestUpdate::ActionRequestUpdate ()  :
    _ActionRequest (::org::bosch::cm::lcm::Generic_RecoveryClient::UnitActions__UNIT_KILL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActionRequestUpdate::ActionRequestUpdate (const ActionRequestUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ActionRequest (::org::bosch::cm::lcm::Generic_RecoveryClient::UnitActions__UNIT_KILL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActionRequestUpdate::ActionRequestUpdate (UnitActions ActionRequest_)  :
    _ActionRequest (ActionRequest_)
{
    #ifndef NDEBUG
    if (!(UnitActions_IsValid(ActionRequest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ActionRequest_, "UnitActions", "ActionRequest", "ActionRequestUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActionRequestUpdate::~ActionRequestUpdate() {
}

inline ActionRequestUpdate& ActionRequestUpdate::operator = (const ActionRequestUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActionRequest()) {
            setActionRequest(rhs.getActionRequest());
        } else {
            clearActionRequest();
        }
    }
    return *this;
}

inline bool ActionRequestUpdate::operator == (const ActionRequestUpdate& rhs) const {
    return (((!hasActionRequest() && !rhs.hasActionRequest()) || getActionRequest() == rhs.getActionRequest()));
}

inline bool ActionRequestUpdate::operator != (const ActionRequestUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActionRequestUpdate::operator < (const ActionRequestUpdate& rhs) const {
    if (hasActionRequest() || rhs.hasActionRequest()) {
        if ((uint32)getActionRequest() < (uint32)rhs.getActionRequest()) return true;
        if ((uint32)getActionRequest() > (uint32)rhs.getActionRequest()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActionRequestUpdate::clone() {
    return new ActionRequestUpdate(*this);
}

inline bool ActionRequestUpdate::operator > (const ActionRequestUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActionRequestUpdate::clear() {
    clearActionRequest();
}

inline void ActionRequestUpdate::clearActionRequest() {
    if (hasActionRequest()) {
         clear_has_ActionRequest();
        _ActionRequest = ::org::bosch::cm::lcm::Generic_RecoveryClient::UnitActions__UNIT_KILL;
     }
}

inline bool ActionRequestUpdate::hasActionRequest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline UnitActions ActionRequestUpdate::getActionRequest () const {
    return _ActionRequest;
}

inline void ActionRequestUpdate::setActionRequest (UnitActions ActionRequest_) {
    #ifndef NDEBUG
    if (!(UnitActions_IsValid(ActionRequest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ActionRequest_, "UnitActions", "ActionRequest", "ActionRequestUpdate");
    }
    #endif
    set_has_ActionRequest();
    this->_ActionRequest = ActionRequest_;
}

inline void ActionRequestUpdate::set_has_ActionRequest () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActionRequestUpdate::clear_has_ActionRequest () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActionRequestRegister::ActionRequestRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActionRequestRegister::ActionRequestRegister (const ActionRequestRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActionRequestRegister::~ActionRequestRegister() {
}

inline ActionRequestRegister& ActionRequestRegister::operator = (const ActionRequestRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActionRequestRegister::operator == (const ActionRequestRegister& ) const {
    return true;
}

inline bool ActionRequestRegister::operator != (const ActionRequestRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActionRequestRegister::operator < (const ActionRequestRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActionRequestRegister::clone() {
    return new ActionRequestRegister(*this);
}

inline bool ActionRequestRegister::operator > (const ActionRequestRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActionRequestRegister::clear() {
}

inline  RequestPermissionRequestUpdate::RequestPermissionRequestUpdate ()  :
    _RequestPermissionRequest (::org::bosch::cm::lcm::Generic_RecoveryClient::LcmResetAllowed__ALLOW_TO_RESET)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPermissionRequestUpdate::RequestPermissionRequestUpdate (const RequestPermissionRequestUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RequestPermissionRequest (::org::bosch::cm::lcm::Generic_RecoveryClient::LcmResetAllowed__ALLOW_TO_RESET)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPermissionRequestUpdate::RequestPermissionRequestUpdate (LcmResetAllowed RequestPermissionRequest_)  :
    _RequestPermissionRequest (RequestPermissionRequest_)
{
    #ifndef NDEBUG
    if (!(LcmResetAllowed_IsValid(RequestPermissionRequest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RequestPermissionRequest_, "LcmResetAllowed", "RequestPermissionRequest", "RequestPermissionRequestUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestPermissionRequestUpdate::~RequestPermissionRequestUpdate() {
}

inline RequestPermissionRequestUpdate& RequestPermissionRequestUpdate::operator = (const RequestPermissionRequestUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequestPermissionRequest()) {
            setRequestPermissionRequest(rhs.getRequestPermissionRequest());
        } else {
            clearRequestPermissionRequest();
        }
    }
    return *this;
}

inline bool RequestPermissionRequestUpdate::operator == (const RequestPermissionRequestUpdate& rhs) const {
    return (((!hasRequestPermissionRequest() && !rhs.hasRequestPermissionRequest()) || getRequestPermissionRequest() == rhs.getRequestPermissionRequest()));
}

inline bool RequestPermissionRequestUpdate::operator != (const RequestPermissionRequestUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPermissionRequestUpdate::operator < (const RequestPermissionRequestUpdate& rhs) const {
    if (hasRequestPermissionRequest() || rhs.hasRequestPermissionRequest()) {
        if ((uint32)getRequestPermissionRequest() < (uint32)rhs.getRequestPermissionRequest()) return true;
        if ((uint32)getRequestPermissionRequest() > (uint32)rhs.getRequestPermissionRequest()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestPermissionRequestUpdate::clone() {
    return new RequestPermissionRequestUpdate(*this);
}

inline bool RequestPermissionRequestUpdate::operator > (const RequestPermissionRequestUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPermissionRequestUpdate::clear() {
    clearRequestPermissionRequest();
}

inline void RequestPermissionRequestUpdate::clearRequestPermissionRequest() {
    if (hasRequestPermissionRequest()) {
         clear_has_RequestPermissionRequest();
        _RequestPermissionRequest = ::org::bosch::cm::lcm::Generic_RecoveryClient::LcmResetAllowed__ALLOW_TO_RESET;
     }
}

inline bool RequestPermissionRequestUpdate::hasRequestPermissionRequest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline LcmResetAllowed RequestPermissionRequestUpdate::getRequestPermissionRequest () const {
    return _RequestPermissionRequest;
}

inline void RequestPermissionRequestUpdate::setRequestPermissionRequest (LcmResetAllowed RequestPermissionRequest_) {
    #ifndef NDEBUG
    if (!(LcmResetAllowed_IsValid(RequestPermissionRequest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RequestPermissionRequest_, "LcmResetAllowed", "RequestPermissionRequest", "RequestPermissionRequestUpdate");
    }
    #endif
    set_has_RequestPermissionRequest();
    this->_RequestPermissionRequest = RequestPermissionRequest_;
}

inline void RequestPermissionRequestUpdate::set_has_RequestPermissionRequest () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestPermissionRequestUpdate::clear_has_RequestPermissionRequest () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestPermissionRequestRegister::RequestPermissionRequestRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPermissionRequestRegister::RequestPermissionRequestRegister (const RequestPermissionRequestRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPermissionRequestRegister::~RequestPermissionRequestRegister() {
}

inline RequestPermissionRequestRegister& RequestPermissionRequestRegister::operator = (const RequestPermissionRequestRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequestPermissionRequestRegister::operator == (const RequestPermissionRequestRegister& ) const {
    return true;
}

inline bool RequestPermissionRequestRegister::operator != (const RequestPermissionRequestRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPermissionRequestRegister::operator < (const RequestPermissionRequestRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequestPermissionRequestRegister::clone() {
    return new RequestPermissionRequestRegister(*this);
}

inline bool RequestPermissionRequestRegister::operator > (const RequestPermissionRequestRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPermissionRequestRegister::clear() {
}

} // namespace Generic_RecoveryClient
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENT_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
