/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef EXAMPLE_ECHODBUS_ECHODBUSSERVICESTUB_H
#define EXAMPLE_ECHODBUS_ECHODBUSSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "example/echoDBus/EchoDBusService.h"
#include <string>

namespace example {
namespace echoDBus {
namespace EchoDBusService {

class EchoDBusServiceStubDelegate;

class EchoDBusServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the EchoDBusServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    EchoDBusServiceStub (const std::string& portName);

    /**
     * Create an instance of the EchoDBusServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    EchoDBusServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~EchoDBusServiceStub();

    // signal 'echoResponseSent'

    /**
     * Raise the signal 'echoResponseSent' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'echoResponseSent'</b>:
     *
     * If the meaning of "echoResponseSent" isn't clear, then there should be a description here.
     */
    void sendEchoResponseSentSignal(const ::std::string& message);

    // property 'echoCount'

    /**
     * The method onEchoCountGet() is called by ASF when a client invokes the
     * read method for the property 'echoCount'. The onEchoCountGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     */
    virtual void onEchoCountGet(const ::boost::shared_ptr< EchoCountGet >& payload);

    /**
     * Sends back the update to a previous onEchoCountGet().
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onEchoCountGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendEchoCountGetUpdate(int32 echoCount, act_t act = 0);

    /**
     * The method onEchoCountSet() is called by ASF when a client invokes the
     * write method for the property 'echoCount'. The onEchoCountSet() method
     * set property value to the given parameter echoCount by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     */
    virtual void onEchoCountSet(const ::boost::shared_ptr< EchoCountSet >& payload);

    /**
     * Sends back the update to a previous onEchoCountSet().
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onEchoCountSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendEchoCountSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'echoCount' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     */
    void setEchoCount(int32 echoCount);

    /**
     * Returns the current value of the property 'echoCount'.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     */
    int32 getEchoCount() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEchoCountUpdate().
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     */
    void sendEchoCountUpdate();

    // method 'echo'

    /**
     * The method onEcho() is called by ASF when a client invokes the method
     * 'echo'. A subclass has to implement this method and send back a
     * response to the client either with the sendEcho() or sendEchoError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'echo'</b>:
     *
     * If the meaning of "echo" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEchoRequest (const ::boost::shared_ptr< EchoRequest >& request) = 0;

    /**
     * The method sendEchoResponse() sends a response of a previous method
     * invocation of 'echo' back to the client.
     *
     * <b>Documentation of 'echo'</b>:
     *
     * If the meaning of "echo" isn't clear, then there should be a description here.
     *
     * @param message If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcho(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEchoResponse (const ::std::string& message, act_t act = 0);

    /**
     * The method sendEchoError() sends an error response of a previous method
     * invocation of 'echo' back to the client.
     *
     * <b>Documentation of 'echo'</b>:
     *
     * If the meaning of "echo" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcho(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendEchoError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    EchoCountUpdate _echoCountProperty;

    friend class EchoDBusServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace EchoDBusService
} // namespace echoDBus
} // namespace example

#endif // EXAMPLE_ECHODBUS_ECHODBUSSERVICESTUB_H
