/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef EXAMPLE_ECHODBUS_ECHODBUSSERVICEPROXY_H
#define EXAMPLE_ECHODBUS_ECHODBUSSERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "example/echoDBus/EchoDBusService.h"
#include <dbus/dbus.h>
#include <string>

namespace example {
namespace echoDBus {
namespace EchoDBusService {

class EchoDBusServiceProxy;

class EchoCallbackIF {
public:
    virtual ~EchoCallbackIF() {}

    virtual void onEchoError(const ::boost::shared_ptr< EchoDBusServiceProxy >& proxy, const ::boost::shared_ptr< EchoError >& error) = 0;

    virtual void onEchoResponse(const ::boost::shared_ptr< EchoDBusServiceProxy >& proxy, const ::boost::shared_ptr< EchoResponse >& response) = 0;
};

class EchoCountCallbackIF {
public:
    virtual ~EchoCountCallbackIF() {}

    virtual void onEchoCountError(const ::boost::shared_ptr< EchoDBusServiceProxy >& proxy, const ::boost::shared_ptr< EchoCountError >& error) = 0;

    virtual void onEchoCountUpdate(const ::boost::shared_ptr< EchoDBusServiceProxy >& proxy, const ::boost::shared_ptr< EchoCountUpdate >& update) = 0;
};

class EchoResponseSentCallbackIF {
public:
    virtual ~EchoResponseSentCallbackIF() {}

    virtual void onEchoResponseSentError(const ::boost::shared_ptr< EchoDBusServiceProxy >& proxy, const ::boost::shared_ptr< EchoResponseSentError >& error) = 0;

    virtual void onEchoResponseSentSignal(const ::boost::shared_ptr< EchoDBusServiceProxy >& proxy, const ::boost::shared_ptr< EchoResponseSentSignal >& signal) = 0;
};


/**
 * EchoDBusServiceProxy is the client side representation of the D-Bus
 * service interface 'example.echoDBus.EchoDBusService' (specified in file
 * EchoDBusService.xml).
 *
 * If the meaning of "example.echoDBus.EchoDBusService" isn't clear, then there should be a description here.
 */
class EchoDBusServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of EchoDBusServiceProxy.
     */
    static ::boost::shared_ptr< EchoDBusServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of EchoDBusServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< EchoDBusServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of EchoDBusServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< EchoDBusServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< EchoDBusServiceProxy > proxyNew(new EchoDBusServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~EchoDBusServiceProxy ();


    // Signal 'echoResponseSent'

    /**
     * Notify on the signal 'echoResponseSent'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'echoResponseSent'</b>:
     *
     * If the meaning of "echoResponseSent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEchoResponseSentRegister(EchoResponseSentCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'echoResponseSent'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'echoResponseSent'</b>:
     *
     * If the meaning of "echoResponseSent" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEchoResponseSentRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEchoResponseSentDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'echoResponseSent'.
     */
    void sendEchoResponseSentDeregisterAll () const;


    // Property 'echoCount'

    /**
     * Notify on the property 'echoCount'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEchoCountRegister(EchoCountCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'echoCount'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEchoCountRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEchoCountDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'echoCount'.
     */
    void sendEchoCountDeregisterAll() const;

    /**
     * Request the value of the property 'echoCount' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEchoCountGet(EchoCountCallbackIF& cb);

    /**
     * Set the value of the property 'echoCount'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendEchoCountSet(EchoCountCallbackIF& cb, int32
     * echoCount) method instead.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     */
    void sendEchoCountSet(int32 echoCount);

    /**
     * Set the value of the property 'echoCount'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEchoCountSet(EchoCountCallbackIF& cb, int32 echoCount);

    /**
     * Returns the current value of the property 'echoCount' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasEchoCount()
     * returns true.
     *
     * @return the previously received value of the property 'echoCount'.
     */
    int32 getEchoCount() const;

    /**
     * Determines whether a status message for the property 'echoCount' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEchoCount() const;


    // Method 'echo'

    /**
     * Call the method 'echo'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'echo'</b>:
     *
     * If the meaning of "echo" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param message If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEchoRequest(EchoCallbackIF& cb, const ::std::string& message) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    EchoDBusServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'echoCount'

    ::asf::core::nullable< EchoCountUpdate > _echoCount;

    DECLARE_CLASS_LOGGER();

    friend class EchoDBusServiceProxyCallback;
};

} // namespace EchoDBusService
} // namespace echoDBus
} // namespace example

#endif // EXAMPLE_ECHODBUS_ECHODBUSSERVICEPROXY_H
