#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef EXAMPLE_ECHODBUS_ECHODBUSSERVICE_H
#define EXAMPLE_ECHODBUS_ECHODBUSSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "EchoDBusService" isn't clear, then there should be a description here.
 */

namespace example {
namespace echoDBus {
namespace EchoDBusService {

// method IDs
static const uint16 ID_echo = 0;

// signal IDs
static const uint16 ID_echoResponseSent = 1;

// property IDs
static const uint16 ID_echoCount = 2;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class EchoRequest;

class EchoResponse;

class EchoCountUpdate;

class EchoCountRegister;

class EchoResponseSentSignal;

// type definitions
/**
 * If the meaning of "EchoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EchoError;

/**
 * If the meaning of "EchoCountSet" isn't clear, then there should be a description here.
 */
typedef EchoCountUpdate EchoCountSet;

/**
 * If the meaning of "EchoCountGet" isn't clear, then there should be a description here.
 */
typedef EchoCountUpdate EchoCountGet;

/**
 * If the meaning of "EchoCountError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EchoCountError;

/**
 * If the meaning of "EchoResponseSentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EchoResponseSentError;


/**
 * If the meaning of "EchoRequest" isn't clear, then there should be a description here.
 */
class EchoRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EchoRequest ();

    /**
     * Copy constructor
     */
    inline  EchoRequest (const EchoRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EchoRequest (const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~EchoRequest();

    /**
     * Assignment operator
     */
    inline EchoRequest& operator = (const EchoRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EchoRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EchoRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EchoRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EchoRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "message"

    static const int kMessage = 0;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    static const EchoRequest &getDefaultInstance();

private:

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _message;

};

/**
 * If the meaning of "EchoResponse" isn't clear, then there should be a description here.
 */
class EchoResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EchoResponse ();

    /**
     * Copy constructor
     */
    inline  EchoResponse (const EchoResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EchoResponse (const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~EchoResponse();

    /**
     * Assignment operator
     */
    inline EchoResponse& operator = (const EchoResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EchoResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EchoResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EchoResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EchoResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "message"

    static const int kMessage = 0;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    static const EchoResponse &getDefaultInstance();

private:

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _message;

};

/**
 * If the meaning of "EchoCountUpdate" isn't clear, then there should be a description here.
 */
class EchoCountUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EchoCountUpdate ();

    /**
     * Copy constructor
     */
    inline  EchoCountUpdate (const EchoCountUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EchoCountUpdate (int32 echoCount_);

    /**
     * Destructor
     */
    inline virtual  ~EchoCountUpdate();

    /**
     * Assignment operator
     */
    inline EchoCountUpdate& operator = (const EchoCountUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EchoCountUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EchoCountUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EchoCountUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EchoCountUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "echoCount"

    static const int kEchoCount = 0;

    /**
     * Clears the field "echoCount".
     *
     * The field will be set to its default value. The hasEchoCount()
     * method will return false.
     */
    inline void clearEchoCount();

    /**
     * Checks whether the field "echoCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEchoCount()). Otherwise it will return false.
     */
    inline bool hasEchoCount () const;

    /**
     * Returns the value of the member "echoCount".
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "echoCount"
     */
    inline int32 getEchoCount () const;

    /**
     * Sets the value of the member "echoCount".
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @param echoCount The value which will be set
     */
    inline void setEchoCount (int32 echoCount_);

    static const EchoCountUpdate &getDefaultInstance();

private:

    inline void set_has_echoCount ();

    inline void clear_has_echoCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _echoCount;

};

/**
 * If the meaning of "EchoCountRegister" isn't clear, then there should be a description here.
 */
class EchoCountRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EchoCountRegister ();

    /**
     * Copy constructor
     */
    inline  EchoCountRegister (const EchoCountRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EchoCountRegister();

    /**
     * Assignment operator
     */
    inline EchoCountRegister& operator = (const EchoCountRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EchoCountRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EchoCountRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EchoCountRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EchoCountRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EchoCountRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "EchoResponseSentSignal" isn't clear, then there should be a description here.
 */
class EchoResponseSentSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EchoResponseSentSignal ();

    /**
     * Copy constructor
     */
    inline  EchoResponseSentSignal (const EchoResponseSentSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EchoResponseSentSignal (const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~EchoResponseSentSignal();

    /**
     * Assignment operator
     */
    inline EchoResponseSentSignal& operator = (const EchoResponseSentSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EchoResponseSentSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EchoResponseSentSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EchoResponseSentSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EchoResponseSentSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "message"

    static const int kMessage = 0;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    static const EchoResponseSentSignal &getDefaultInstance();

private:

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _message;

};

inline  EchoRequest::EchoRequest ()  :
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EchoRequest::EchoRequest (const EchoRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EchoRequest::EchoRequest (const ::std::string& message_)  :
    _message (message_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EchoRequest::~EchoRequest() {
}

inline EchoRequest& EchoRequest::operator = (const EchoRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool EchoRequest::operator == (const EchoRequest& rhs) const {
    return (((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool EchoRequest::operator != (const EchoRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EchoRequest::operator < (const EchoRequest& rhs) const {
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EchoRequest::clone() {
    return new EchoRequest(*this);
}

inline bool EchoRequest::operator > (const EchoRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EchoRequest::clear() {
    clearMessage();
}

inline void EchoRequest::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        _message.clear();
     }
}

inline bool EchoRequest::hasMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EchoRequest::getMessage () const {
    return _message;
}

inline ::std::string& EchoRequest::getMessageMutable () {
    set_has_message();
    return _message;
}

inline void EchoRequest::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message = message_;
}

inline void EchoRequest::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(message_);
}

inline void EchoRequest::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(value, size);
}

inline void EchoRequest::set_has_message () {
    _has_bits_[0] |= 1u << 0;
}

inline void EchoRequest::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EchoResponse::EchoResponse ()  :
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EchoResponse::EchoResponse (const EchoResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EchoResponse::EchoResponse (const ::std::string& message_)  :
    _message (message_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EchoResponse::~EchoResponse() {
}

inline EchoResponse& EchoResponse::operator = (const EchoResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool EchoResponse::operator == (const EchoResponse& rhs) const {
    return (((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool EchoResponse::operator != (const EchoResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EchoResponse::operator < (const EchoResponse& rhs) const {
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EchoResponse::clone() {
    return new EchoResponse(*this);
}

inline bool EchoResponse::operator > (const EchoResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EchoResponse::clear() {
    clearMessage();
}

inline void EchoResponse::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        _message.clear();
     }
}

inline bool EchoResponse::hasMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EchoResponse::getMessage () const {
    return _message;
}

inline ::std::string& EchoResponse::getMessageMutable () {
    set_has_message();
    return _message;
}

inline void EchoResponse::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message = message_;
}

inline void EchoResponse::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(message_);
}

inline void EchoResponse::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(value, size);
}

inline void EchoResponse::set_has_message () {
    _has_bits_[0] |= 1u << 0;
}

inline void EchoResponse::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EchoCountUpdate::EchoCountUpdate ()  :
    _echoCount (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EchoCountUpdate::EchoCountUpdate (const EchoCountUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _echoCount (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EchoCountUpdate::EchoCountUpdate (int32 echoCount_)  :
    _echoCount (echoCount_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EchoCountUpdate::~EchoCountUpdate() {
}

inline EchoCountUpdate& EchoCountUpdate::operator = (const EchoCountUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEchoCount()) {
            setEchoCount(rhs.getEchoCount());
        } else {
            clearEchoCount();
        }
    }
    return *this;
}

inline bool EchoCountUpdate::operator == (const EchoCountUpdate& rhs) const {
    return (((!hasEchoCount() && !rhs.hasEchoCount()) || getEchoCount() == rhs.getEchoCount()));
}

inline bool EchoCountUpdate::operator != (const EchoCountUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EchoCountUpdate::operator < (const EchoCountUpdate& rhs) const {
    if (hasEchoCount() || rhs.hasEchoCount()) {
        if (getEchoCount() < rhs.getEchoCount()) return true;
        if (getEchoCount() > rhs.getEchoCount()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EchoCountUpdate::clone() {
    return new EchoCountUpdate(*this);
}

inline bool EchoCountUpdate::operator > (const EchoCountUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EchoCountUpdate::clear() {
    clearEchoCount();
}

inline void EchoCountUpdate::clearEchoCount() {
    if (hasEchoCount()) {
         clear_has_echoCount();
        _echoCount = 0;
     }
}

inline bool EchoCountUpdate::hasEchoCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EchoCountUpdate::getEchoCount () const {
    return _echoCount;
}

inline void EchoCountUpdate::setEchoCount (int32 echoCount_) {
    set_has_echoCount();
    this->_echoCount = echoCount_;
}

inline void EchoCountUpdate::set_has_echoCount () {
    _has_bits_[0] |= 1u << 0;
}

inline void EchoCountUpdate::clear_has_echoCount () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EchoCountRegister::EchoCountRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EchoCountRegister::EchoCountRegister (const EchoCountRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EchoCountRegister::~EchoCountRegister() {
}

inline EchoCountRegister& EchoCountRegister::operator = (const EchoCountRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EchoCountRegister::operator == (const EchoCountRegister& ) const {
    return true;
}

inline bool EchoCountRegister::operator != (const EchoCountRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EchoCountRegister::operator < (const EchoCountRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EchoCountRegister::clone() {
    return new EchoCountRegister(*this);
}

inline bool EchoCountRegister::operator > (const EchoCountRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EchoCountRegister::clear() {
}

inline  EchoResponseSentSignal::EchoResponseSentSignal ()  :
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EchoResponseSentSignal::EchoResponseSentSignal (const EchoResponseSentSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EchoResponseSentSignal::EchoResponseSentSignal (const ::std::string& message_)  :
    _message (message_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EchoResponseSentSignal::~EchoResponseSentSignal() {
}

inline EchoResponseSentSignal& EchoResponseSentSignal::operator = (const EchoResponseSentSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool EchoResponseSentSignal::operator == (const EchoResponseSentSignal& rhs) const {
    return (((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool EchoResponseSentSignal::operator != (const EchoResponseSentSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EchoResponseSentSignal::operator < (const EchoResponseSentSignal& rhs) const {
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EchoResponseSentSignal::clone() {
    return new EchoResponseSentSignal(*this);
}

inline bool EchoResponseSentSignal::operator > (const EchoResponseSentSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EchoResponseSentSignal::clear() {
    clearMessage();
}

inline void EchoResponseSentSignal::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        _message.clear();
     }
}

inline bool EchoResponseSentSignal::hasMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EchoResponseSentSignal::getMessage () const {
    return _message;
}

inline ::std::string& EchoResponseSentSignal::getMessageMutable () {
    set_has_message();
    return _message;
}

inline void EchoResponseSentSignal::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message = message_;
}

inline void EchoResponseSentSignal::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(message_);
}

inline void EchoResponseSentSignal::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(value, size);
}

inline void EchoResponseSentSignal::set_has_message () {
    _has_bits_[0] |= 1u << 0;
}

inline void EchoResponseSentSignal::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace EchoDBusService
} // namespace echoDBus
} // namespace example

#endif // EXAMPLE_ECHODBUS_ECHODBUSSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
