/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef EXAMPLE_ECHOCCA_ECHOFIPROXY_H
#define EXAMPLE_ECHOCCA_ECHOFIPROXY_H

#include "EchoFI.h"
#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include <string>

namespace example {
namespace echoCca {
namespace EchoFI {

class EchoFIProxy;

class EchoCallbackIF {
public:
    virtual ~EchoCallbackIF() {}

    virtual void onEchoError(const ::boost::shared_ptr< EchoFIProxy >& proxy, const ::boost::shared_ptr< EchoError >& error) = 0;

    virtual void onEchoResult(const ::boost::shared_ptr< EchoFIProxy >& proxy, const ::boost::shared_ptr< EchoResult >& result) = 0;
};

class EchoCountCallbackIF {
public:
    virtual ~EchoCountCallbackIF() {}

    virtual void onEchoCountError(const ::boost::shared_ptr< EchoFIProxy >& proxy, const ::boost::shared_ptr< EchoCountError >& error) = 0;

    virtual void onEchoCountStatus(const ::boost::shared_ptr< EchoFIProxy >& proxy, const ::boost::shared_ptr< EchoCountStatus >& status) = 0;
};

class EchoFIProxyCallback;

/**
 * EchoFIProxy is the client side representation of the CCA Functional
 * Interface 'EchoFI' (specified in file EchoFI_fi.xml).
 *
 * CCA Functional Interface 'EchoFI'
 *
 * Fullname: EchoFI
 */
class EchoFIProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of EchoFIProxy. The caller has to pass the port
     * name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< EchoFIProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of EchoFIProxy. The caller has to pass the port
     * name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< EchoFIProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of EchoFIProxy. The caller has to pass the port
     * name. The port name is defined in the "Car Multimedia Component" model.
     * With the help of the port name it is possible to address the concrete
     * proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< EchoFIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of EchoFIProxy. The destructor will send RelUpReg messages
     * for all property notifications and call the error callback of all
     * pending method invocations.
     */
    ~EchoFIProxy();

    // Method 'echo'

    /**
     * Call the method 'echo'. This method sends a MethodStart message to the
     * CCA server.
     *
     * <b>Documentation of 'echo'</b>:
     *
     * This is a method
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param message If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEchoStart(EchoCallbackIF& cb, const ::std::string& message);

    // Property 'echoCount'

    /**
     * Notify on the property 'echoCount'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * This is a property
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEchoCountUpReg(EchoCountCallbackIF& cb);

    /**
     * Remove the notifcation on property 'echoCount'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * This is a property
     *
     * @param act The act which was previously returned by the
     * sendEchoCountUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendEchoCountRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'echoCount'.
     */
    void sendEchoCountRelUpRegAll ();

    /**
     * Returns the current value of the property 'echoCount' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasEchoCount()
     * returns true.
     *
     * @return the previously received value of the property 'echoCount'.
     */
    const EchoCountStatus& getEchoCount() const;

    /**
     * Determines whether a status message for the property 'echoCount' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEchoCount() const;

    /**
     * Request the value of the property 'echoCount' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'echoCount'</b>:
     *
     * This is a property
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEchoCountGet(EchoCountCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    EchoFIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'echoCount'

    ::asf::core::nullable< EchoCountStatus > _echoCount;

    DECLARE_CLASS_LOGGER();

    friend class EchoFIProxyCallback;
};

} // namespace EchoFI
} // namespace echoCca
} // namespace example

#endif // EXAMPLE_ECHOCCA_ECHOFIPROXY_H
