/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGSTUB_H
#define ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/Diaglog.h"

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diaglog {

class DiaglogStubDelegate;

class DiaglogStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DiaglogStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DiaglogStub (const std::string& portName);

    /**
     * Create an instance of the DiaglogStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DiaglogStub (const std::string& portName, const std::string& objectPath);

    virtual ~DiaglogStub();

    // signal 'SendNextTestResult'

    /**
     * Raise the signal 'SendNextTestResult' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SendNextTestResult'</b>:
     *
     * Contains the reasons for the signal and a list of Trouble Codes. Refer T_SendNextTestResultStructure.
     *
     * @param NextTestResultStruct If the meaning of "NextTestResultStruct" isn't clear, then there should be a description here.
     */
    void sendSendNextTestResultSignal(const SendNextTestResultSignalNextTestResultStructStruct& nextTestResultStruct);

    // method 'SaveTestResult'

    /**
     * The method onSaveTestResult() is called by ASF when a client invokes
     * the method 'SaveTestResult'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSaveTestResult() or sendSaveTestResultError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'SaveTestResult'</b>:
     *
     * Indicates the validity of the method execution. Refer T_e8_MethodResultReply.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSaveTestResultRequest (const ::boost::shared_ptr< SaveTestResultRequest >& request) = 0;

    /**
     * The method sendSaveTestResultResponse() sends a response of a previous
     * method invocation of 'SaveTestResult' back to the client.
     *
     * <b>Documentation of 'SaveTestResult'</b>:
     *
     * Indicates the validity of the method execution. Refer T_e8_MethodResultReply.
     *
     * @param Status If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSaveTestResult(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSaveTestResultResponse (uint8 status, act_t act = 0);

    /**
     * The method sendSaveTestResultError() sends an error response of a
     * previous method invocation of 'SaveTestResult' back to the client.
     *
     * <b>Documentation of 'SaveTestResult'</b>:
     *
     * Indicates the validity of the method execution. Refer T_e8_MethodResultReply.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSaveTestResult(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSaveTestResultError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ClearDTC'

    /**
     * The method onClearDTC() is called by ASF when a client invokes the
     * method 'ClearDTC'. A subclass has to implement this method and send
     * back a response to the client either with the sendClearDTC() or
     * sendClearDTCError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ClearDTC'</b>:
     *
     * Indicates the validity of the method execution. Refer T_e8_MethodResultReply.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onClearDTCRequest (const ::boost::shared_ptr< ClearDTCRequest >& request) = 0;

    /**
     * The method sendClearDTCResponse() sends a response of a previous method
     * invocation of 'ClearDTC' back to the client.
     *
     * <b>Documentation of 'ClearDTC'</b>:
     *
     * Indicates the validity of the method execution. Refer T_e8_MethodResultReply.
     *
     * @param Status If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onClearDTC(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendClearDTCResponse (uint8 status, act_t act = 0);

    /**
     * The method sendClearDTCError() sends an error response of a previous
     * method invocation of 'ClearDTC' back to the client.
     *
     * <b>Documentation of 'ClearDTC'</b>:
     *
     * Indicates the validity of the method execution. Refer T_e8_MethodResultReply.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onClearDTC(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendClearDTCError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class DiaglogStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Diaglog
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGSTUB_H
