/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/Diaglog.h"
#include "org/bosch/cm/diagnosis/dbus/DiaglogDBus.h"
#include "org/bosch/cm/diagnosis/dbus/DiaglogJson.h"
#include "org/bosch/cm/diagnosis/dbus/DiaglogStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diaglog {

DEFINE_CLASS_LOGGER("/org/bosch/cm/diagnosis/dbus/Diaglog", DiaglogStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 8, "ClearDTC", 1 },
    { 14, "SaveTestResult", 0 },
};


class DiaglogStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DiaglogStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DiaglogStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DiaglogStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.diagnosis.dbus.Diaglog"),
          _logger(logger) {}

    virtual ~DiaglogStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DiaglogStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SaveTestResult'

            LOG_DEBUG_STUB("process method '%s'", "SaveTestResult");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SaveTestResultRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SaveTestResult", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SaveTestResultRequest > payload = ::boost::static_pointer_cast<SaveTestResultRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DiaglogStub*>(getStub())->onSaveTestResultRequest(payload);
            return;
        }
        case 1: {

            // method 'ClearDTC'

            LOG_DEBUG_STUB("process method '%s'", "ClearDTC");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearDTCRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ClearDTC", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ClearDTCRequest > payload = ::boost::static_pointer_cast<ClearDTCRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DiaglogStub*>(getStub())->onClearDTCRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DiaglogStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.diagnosis.dbus.Diaglog\">\n"
            "      <doc>\n"
            "        <line>Param 1: Type - Boolean: Status = false if this is a confirmation message from the Diaglog that the UpReg has been succesful. Status = true if client is required to send next test result to DiagLog.</line>\n"
            "        <line>Param 2: Type - T_e8_SendNextTestResReason: indicates the reason behind requesting the next test result: Either due a DTC Clearing or due to reset of the Blocking Mode of the DTC</line>\n"
            "        <line>Param 3: Type - array of ITCs: for these the next test result has to be sent. If the list is empty the client should report all the ITCs for which he is reponsible.</line>\n"
            "      </doc>\n"
            "      <method name=\"SaveTestResult\">\n"
            "        <doc>\n"
            "          <line>Indicates the validity of the method execution. Refer T_e8_MethodResultReply.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"TestResultList\" type=\"a(uy)\"/>\n"
            "        <arg direction=\"out\" name=\"Status\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ClearDTC\">\n"
            "        <doc>\n"
            "          <line>Indicates the validity of the method execution. Refer T_e8_MethodResultReply.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"Group\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"DTCMask\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"Status\" type=\"y\"/>\n"
            "      </method>\n"
            "      <signal name=\"SendNextTestResult\">\n"
            "        <doc>\n"
            "          <line>Contains the reasons for the signal and a list of Trouble Codes. Refer T_SendNextTestResultStructure.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"NextTestResultStruct\" type=\"(byaq)\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void DiaglogStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DiaglogStub*>(getStub()))->onGetAll (properties);
}

void DiaglogStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DiaglogStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DiaglogStub::DiaglogStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DiaglogStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DiaglogStub::DiaglogStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DiaglogStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DiaglogStub::~DiaglogStub() {
    delete _stubDelegate;
}

void DiaglogStub::sendSendNextTestResultSignal(const SendNextTestResultSignalNextTestResultStructStruct& nextTestResultStruct) {
    if (_stubDelegate->isConnected()) {
        SendNextTestResultSignal* payload = new SendNextTestResultSignal(nextTestResultStruct);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SendNextTestResult", SendNextTestResultSignal, payload)
        LOG_INFO ("-> send%sSignal", "SendNextTestResult");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SendNextTestResult");
    }
}

void  DiaglogStub::sendSaveTestResultResponse (uint8 status, act_t act) {
    SaveTestResultResponse* payload = new SaveTestResultResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "SaveTestResult", SaveTestResultResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SaveTestResult", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DiaglogStub::sendSaveTestResultError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SaveTestResultError* payload = new SaveTestResultError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SaveTestResult", SaveTestResultError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SaveTestResult", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DiaglogStub::sendClearDTCResponse (uint8 status, act_t act) {
    ClearDTCResponse* payload = new ClearDTCResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "ClearDTC", ClearDTCResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ClearDTC", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DiaglogStub::sendClearDTCError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ClearDTCError* payload = new ClearDTCError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ClearDTC", ClearDTCError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ClearDTC", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DiaglogStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Diaglog
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org
