/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/Diaglog.h"
#include "org/bosch/cm/diagnosis/dbus/DiaglogDBus.h"
#include "org/bosch/cm/diagnosis/dbus/DiaglogJson.h"
#include "org/bosch/cm/diagnosis/dbus/DiaglogProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diaglog {

DEFINE_CLASS_LOGGER("/org/bosch/cm/diagnosis/dbus/Diaglog", DiaglogProxy);

class DiaglogProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DiaglogProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DiaglogProxy >& proxyShared = ::boost::static_pointer_cast< DiaglogProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SendNextTestResult:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendNextTestResultSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SendNextTestResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SendNextTestResultSignal> payload = ::boost::static_pointer_cast<SendNextTestResultSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SendNextTestResultCallbackIF*) _callback)->onSendNextTestResultSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SaveTestResult:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SaveTestResultError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SaveTestResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SaveTestResultError> payload = ::boost::static_pointer_cast<SaveTestResultError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SaveTestResultCallbackIF*) _callback)->onSaveTestResultError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SaveTestResultResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SaveTestResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SaveTestResultResponse> payload = ::boost::static_pointer_cast<SaveTestResultResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SaveTestResultCallbackIF*) _callback)->onSaveTestResultResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ClearDTC:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ClearDTCError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearDTC", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClearDTCError> payload = ::boost::static_pointer_cast<ClearDTCError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ClearDTCCallbackIF*) _callback)->onClearDTCError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearDTCResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearDTC", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClearDTCResponse> payload = ::boost::static_pointer_cast<ClearDTCResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ClearDTCCallbackIF*) _callback)->onClearDTCResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SendNextTestResult: {
                ::boost::shared_ptr< SendNextTestResultError > payload = ::boost::shared_ptr< SendNextTestResultError >
                (new SendNextTestResultError(DBUS_ERROR_NO_SERVER, "The DBus service Diaglog is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendNextTestResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DiaglogProxy> proxyShared = ::boost::static_pointer_cast<DiaglogProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendNextTestResultCallbackIF*) _callback)->onSendNextTestResultError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SaveTestResult: {
                ::boost::shared_ptr< SaveTestResultError > payload = ::boost::shared_ptr< SaveTestResultError >
                (new SaveTestResultError(DBUS_ERROR_NO_SERVER, "The DBus service Diaglog is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SaveTestResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DiaglogProxy> proxyShared = ::boost::static_pointer_cast<DiaglogProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SaveTestResultCallbackIF*) _callback)->onSaveTestResultError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ClearDTC: {
                ::boost::shared_ptr< ClearDTCError > payload = ::boost::shared_ptr< ClearDTCError >
                (new ClearDTCError(DBUS_ERROR_NO_SERVER, "The DBus service Diaglog is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ClearDTC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DiaglogProxy> proxyShared = ::boost::static_pointer_cast<DiaglogProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ClearDTCCallbackIF*) _callback)->onClearDTCError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DiaglogProxyCallback::_logger (DiaglogProxy::_logger);

DiaglogProxy::DiaglogProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.diagnosis.dbus.Diaglog", serviceAvailable, _logger) {
}

DiaglogProxy::~DiaglogProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DiaglogProxy > DiaglogProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DiaglogProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DiaglogProxy > proxyNew(new DiaglogProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t DiaglogProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DiaglogProxyCallback* callback = new DiaglogProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DiaglogProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DiaglogProxyCallback* callback = new DiaglogProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void DiaglogProxy::sendDeregisterAll () const
{
    sendSendNextTestResultDeregisterAll();
}

act_t DiaglogProxy::sendSendNextTestResultRegister(SendNextTestResultCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SendNextTestResult");
    act_t act = addSignalCallback(ID_SendNextTestResult, "SendNextTestResult", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SendNextTestResult", &cb, act);
    return act;
}

bool DiaglogProxy::sendSendNextTestResultDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SendNextTestResult", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SendNextTestResult", act, static_cast<int>(rv));
    return rv;
}

void DiaglogProxy::sendSendNextTestResultDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SendNextTestResult");
    _dbusProxyDelegate->deregisterSignalCallback("SendNextTestResult", 0, _dbusDaemonProxy.get(), false);
}

act_t DiaglogProxy::sendSaveTestResultRequest(SaveTestResultCallbackIF& cb, const ::std::vector< SaveTestResultRequestTestResultListStruct >& testResultList) const {
    SaveTestResultRequest* payload = new SaveTestResultRequest();
    CHECK_ALLOCATION(payload);
    payload->setTestResultList(testResultList);
    DBUS_MESSAGE_CALL(dbusMessage, "SaveTestResult", SaveTestResultRequest, payload, true)
    act_t act = addMethodCallback(ID_SaveTestResult, dbusMessage.getUniqueSerial(), "SaveTestResult", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SaveTestResult", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DiaglogProxy::sendClearDTCRequest(ClearDTCCallbackIF& cb, uint8 group, uint32 dTCMask) const {
    ClearDTCRequest* payload = new ClearDTCRequest();
    CHECK_ALLOCATION(payload);
    payload->setGroup(group);
    payload->setDTCMask(dTCMask);
    DBUS_MESSAGE_CALL(dbusMessage, "ClearDTC", ClearDTCRequest, payload, true)
    act_t act = addMethodCallback(ID_ClearDTC, dbusMessage.getUniqueSerial(), "ClearDTC", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ClearDTC", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Diaglog
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org
