/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/audiomanager/CommandInterface.h"
#include "org/genivi/audiomanager/CommandInterfaceDBus.h"
#include "org/genivi/audiomanager/CommandInterfaceJson.h"
#include "org/genivi/audiomanager/CommandInterfaceProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace genivi {
namespace audiomanager {
namespace CommandInterface {

DEFINE_CLASS_LOGGER("/org/genivi/audiomanager/CommandInterface", CommandInterfaceProxy);

class CommandInterfaceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    CommandInterfaceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< CommandInterfaceProxy >& proxyShared = ::boost::static_pointer_cast< CommandInterfaceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_NumberOfMainConnectionsChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NumberOfMainConnectionsChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NumberOfMainConnectionsChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NumberOfMainConnectionsChangedSignal> payload = ::boost::static_pointer_cast<NumberOfMainConnectionsChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NumberOfMainConnectionsChangedCallbackIF*) _callback)->onNumberOfMainConnectionsChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SinkAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SinkAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SinkAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SinkAddedSignal> payload = ::boost::static_pointer_cast<SinkAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SinkAddedCallbackIF*) _callback)->onSinkAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SinkRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SinkRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SinkRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SinkRemovedSignal> payload = ::boost::static_pointer_cast<SinkRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SinkRemovedCallbackIF*) _callback)->onSinkRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SourceAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourceAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SourceAddedSignal> payload = ::boost::static_pointer_cast<SourceAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SourceAddedCallbackIF*) _callback)->onSourceAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SourceRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourceRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SourceRemovedSignal> payload = ::boost::static_pointer_cast<SourceRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SourceRemovedCallbackIF*) _callback)->onSourceRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_NumberOfSinkClassesChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NumberOfSinkClassesChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NumberOfSinkClassesChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NumberOfSinkClassesChangedSignal> payload = ::boost::static_pointer_cast<NumberOfSinkClassesChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NumberOfSinkClassesChangedCallbackIF*) _callback)->onNumberOfSinkClassesChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_NumberOfSourceClassesChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NumberOfSourceClassesChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NumberOfSourceClassesChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NumberOfSourceClassesChangedSignal> payload = ::boost::static_pointer_cast<NumberOfSourceClassesChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NumberOfSourceClassesChangedCallbackIF*) _callback)->onNumberOfSourceClassesChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_NewMainConnection:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NewMainConnectionSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NewMainConnection", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NewMainConnectionSignal> payload = ::boost::static_pointer_cast<NewMainConnectionSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NewMainConnectionCallbackIF*) _callback)->onNewMainConnectionSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RemovedMainConnection:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemovedMainConnectionSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemovedMainConnection", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RemovedMainConnectionSignal> payload = ::boost::static_pointer_cast<RemovedMainConnectionSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RemovedMainConnectionCallbackIF*) _callback)->onRemovedMainConnectionSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_MainConnectionStateChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MainConnectionStateChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MainConnectionStateChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<MainConnectionStateChangedSignal> payload = ::boost::static_pointer_cast<MainConnectionStateChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((MainConnectionStateChangedCallbackIF*) _callback)->onMainConnectionStateChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_MainSinkSoundPropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MainSinkSoundPropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MainSinkSoundPropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<MainSinkSoundPropertyChangedSignal> payload = ::boost::static_pointer_cast<MainSinkSoundPropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((MainSinkSoundPropertyChangedCallbackIF*) _callback)->onMainSinkSoundPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_MainSourceSoundPropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MainSourceSoundPropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MainSourceSoundPropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<MainSourceSoundPropertyChangedSignal> payload = ::boost::static_pointer_cast<MainSourceSoundPropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((MainSourceSoundPropertyChangedCallbackIF*) _callback)->onMainSourceSoundPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SinkAvailabilityChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SinkAvailabilityChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SinkAvailabilityChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SinkAvailabilityChangedSignal> payload = ::boost::static_pointer_cast<SinkAvailabilityChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SinkAvailabilityChangedCallbackIF*) _callback)->onSinkAvailabilityChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SourceAvailabilityChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceAvailabilityChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourceAvailabilityChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SourceAvailabilityChangedSignal> payload = ::boost::static_pointer_cast<SourceAvailabilityChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SourceAvailabilityChangedCallbackIF*) _callback)->onSourceAvailabilityChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_VolumeChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VolumeChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VolumeChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<VolumeChangedSignal> payload = ::boost::static_pointer_cast<VolumeChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((VolumeChangedCallbackIF*) _callback)->onVolumeChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SinkMuteStateChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SinkMuteStateChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SinkMuteStateChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SinkMuteStateChangedSignal> payload = ::boost::static_pointer_cast<SinkMuteStateChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SinkMuteStateChangedCallbackIF*) _callback)->onSinkMuteStateChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SystemPropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemPropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemPropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SystemPropertyChangedSignal> payload = ::boost::static_pointer_cast<SystemPropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SystemPropertyChangedCallbackIF*) _callback)->onSystemPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_TimingInformationChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimingInformationChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimingInformationChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<TimingInformationChangedSignal> payload = ::boost::static_pointer_cast<TimingInformationChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((TimingInformationChangedCallbackIF*) _callback)->onTimingInformationChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Connect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ConnectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Connect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectError> payload = ::boost::static_pointer_cast<ConnectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ConnectCallbackIF*) _callback)->onConnectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Connect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectResponse> payload = ::boost::static_pointer_cast<ConnectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ConnectCallbackIF*) _callback)->onConnectResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Disconnect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectError> payload = ::boost::static_pointer_cast<DisconnectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectResponse> payload = ::boost::static_pointer_cast<DisconnectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetVolume:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetVolumeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetVolume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetVolumeError> payload = ::boost::static_pointer_cast<SetVolumeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetVolumeCallbackIF*) _callback)->onSetVolumeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetVolumeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetVolume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetVolumeResponse> payload = ::boost::static_pointer_cast<SetVolumeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetVolumeCallbackIF*) _callback)->onSetVolumeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_VolumeStep:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), VolumeStepError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VolumeStep", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VolumeStepError> payload = ::boost::static_pointer_cast<VolumeStepError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((VolumeStepCallbackIF*) _callback)->onVolumeStepError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VolumeStepResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "VolumeStep", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VolumeStepResponse> payload = ::boost::static_pointer_cast<VolumeStepResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((VolumeStepCallbackIF*) _callback)->onVolumeStepResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetSinkMuteState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetSinkMuteStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSinkMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSinkMuteStateError> payload = ::boost::static_pointer_cast<SetSinkMuteStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSinkMuteStateCallbackIF*) _callback)->onSetSinkMuteStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSinkMuteStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSinkMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSinkMuteStateResponse> payload = ::boost::static_pointer_cast<SetSinkMuteStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSinkMuteStateCallbackIF*) _callback)->onSetSinkMuteStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetMainSinkSoundProperty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSinkSoundPropertyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMainSinkSoundProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMainSinkSoundPropertyError> payload = ::boost::static_pointer_cast<SetMainSinkSoundPropertyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMainSinkSoundPropertyCallbackIF*) _callback)->onSetMainSinkSoundPropertyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSinkSoundPropertyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMainSinkSoundProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMainSinkSoundPropertyResponse> payload = ::boost::static_pointer_cast<SetMainSinkSoundPropertyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMainSinkSoundPropertyCallbackIF*) _callback)->onSetMainSinkSoundPropertyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetMainSourceSoundProperty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSourceSoundPropertyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMainSourceSoundProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMainSourceSoundPropertyError> payload = ::boost::static_pointer_cast<SetMainSourceSoundPropertyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMainSourceSoundPropertyCallbackIF*) _callback)->onSetMainSourceSoundPropertyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSourceSoundPropertyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMainSourceSoundProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMainSourceSoundPropertyResponse> payload = ::boost::static_pointer_cast<SetMainSourceSoundPropertyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMainSourceSoundPropertyCallbackIF*) _callback)->onSetMainSourceSoundPropertyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetSystemProperty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetSystemPropertyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSystemProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSystemPropertyError> payload = ::boost::static_pointer_cast<SetSystemPropertyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSystemPropertyCallbackIF*) _callback)->onSetSystemPropertyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSystemPropertyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSystemProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSystemPropertyResponse> payload = ::boost::static_pointer_cast<SetSystemPropertyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSystemPropertyCallbackIF*) _callback)->onSetSystemPropertyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetListMainConnections:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainConnectionsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainConnections", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainConnectionsError> payload = ::boost::static_pointer_cast<GetListMainConnectionsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainConnectionsCallbackIF*) _callback)->onGetListMainConnectionsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainConnectionsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainConnections", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainConnectionsResponse> payload = ::boost::static_pointer_cast<GetListMainConnectionsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainConnectionsCallbackIF*) _callback)->onGetListMainConnectionsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetListMainSinks:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSinksError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainSinks", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainSinksError> payload = ::boost::static_pointer_cast<GetListMainSinksError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainSinksCallbackIF*) _callback)->onGetListMainSinksError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSinksResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainSinks", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainSinksResponse> payload = ::boost::static_pointer_cast<GetListMainSinksResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainSinksCallbackIF*) _callback)->onGetListMainSinksResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetListMainSources:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSourcesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainSources", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainSourcesError> payload = ::boost::static_pointer_cast<GetListMainSourcesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainSourcesCallbackIF*) _callback)->onGetListMainSourcesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSourcesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainSources", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainSourcesResponse> payload = ::boost::static_pointer_cast<GetListMainSourcesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainSourcesCallbackIF*) _callback)->onGetListMainSourcesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetListMainSinkSoundProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSinkSoundPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainSinkSoundProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainSinkSoundPropertiesError> payload = ::boost::static_pointer_cast<GetListMainSinkSoundPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainSinkSoundPropertiesCallbackIF*) _callback)->onGetListMainSinkSoundPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSinkSoundPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainSinkSoundProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainSinkSoundPropertiesResponse> payload = ::boost::static_pointer_cast<GetListMainSinkSoundPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainSinkSoundPropertiesCallbackIF*) _callback)->onGetListMainSinkSoundPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetListMainSourceSoundProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSourceSoundPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainSourceSoundProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainSourceSoundPropertiesError> payload = ::boost::static_pointer_cast<GetListMainSourceSoundPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainSourceSoundPropertiesCallbackIF*) _callback)->onGetListMainSourceSoundPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSourceSoundPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListMainSourceSoundProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListMainSourceSoundPropertiesResponse> payload = ::boost::static_pointer_cast<GetListMainSourceSoundPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListMainSourceSoundPropertiesCallbackIF*) _callback)->onGetListMainSourceSoundPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetListSourceClasses:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetListSourceClassesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListSourceClasses", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListSourceClassesError> payload = ::boost::static_pointer_cast<GetListSourceClassesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListSourceClassesCallbackIF*) _callback)->onGetListSourceClassesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListSourceClassesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListSourceClasses", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListSourceClassesResponse> payload = ::boost::static_pointer_cast<GetListSourceClassesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListSourceClassesCallbackIF*) _callback)->onGetListSourceClassesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetListSinkClasses:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetListSinkClassesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListSinkClasses", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListSinkClassesError> payload = ::boost::static_pointer_cast<GetListSinkClassesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListSinkClassesCallbackIF*) _callback)->onGetListSinkClassesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListSinkClassesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListSinkClasses", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListSinkClassesResponse> payload = ::boost::static_pointer_cast<GetListSinkClassesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListSinkClassesCallbackIF*) _callback)->onGetListSinkClassesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetListSystemProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetListSystemPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListSystemProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListSystemPropertiesError> payload = ::boost::static_pointer_cast<GetListSystemPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListSystemPropertiesCallbackIF*) _callback)->onGetListSystemPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListSystemPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetListSystemProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetListSystemPropertiesResponse> payload = ::boost::static_pointer_cast<GetListSystemPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetListSystemPropertiesCallbackIF*) _callback)->onGetListSystemPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetTimingInformation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetTimingInformationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTimingInformation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetTimingInformationError> payload = ::boost::static_pointer_cast<GetTimingInformationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetTimingInformationCallbackIF*) _callback)->onGetTimingInformationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetTimingInformationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTimingInformation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetTimingInformationResponse> payload = ::boost::static_pointer_cast<GetTimingInformationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetTimingInformationCallbackIF*) _callback)->onGetTimingInformationResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_NumberOfMainConnectionsChanged: {
                ::boost::shared_ptr< NumberOfMainConnectionsChangedError > payload = ::boost::shared_ptr< NumberOfMainConnectionsChangedError >
                (new NumberOfMainConnectionsChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NumberOfMainConnectionsChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NumberOfMainConnectionsChangedCallbackIF*) _callback)->onNumberOfMainConnectionsChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SinkAdded: {
                ::boost::shared_ptr< SinkAddedError > payload = ::boost::shared_ptr< SinkAddedError >
                (new SinkAddedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SinkAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SinkAddedCallbackIF*) _callback)->onSinkAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SinkRemoved: {
                ::boost::shared_ptr< SinkRemovedError > payload = ::boost::shared_ptr< SinkRemovedError >
                (new SinkRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SinkRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SinkRemovedCallbackIF*) _callback)->onSinkRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SourceAdded: {
                ::boost::shared_ptr< SourceAddedError > payload = ::boost::shared_ptr< SourceAddedError >
                (new SourceAddedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceAddedCallbackIF*) _callback)->onSourceAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SourceRemoved: {
                ::boost::shared_ptr< SourceRemovedError > payload = ::boost::shared_ptr< SourceRemovedError >
                (new SourceRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceRemovedCallbackIF*) _callback)->onSourceRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NumberOfSinkClassesChanged: {
                ::boost::shared_ptr< NumberOfSinkClassesChangedError > payload = ::boost::shared_ptr< NumberOfSinkClassesChangedError >
                (new NumberOfSinkClassesChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NumberOfSinkClassesChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NumberOfSinkClassesChangedCallbackIF*) _callback)->onNumberOfSinkClassesChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NumberOfSourceClassesChanged: {
                ::boost::shared_ptr< NumberOfSourceClassesChangedError > payload = ::boost::shared_ptr< NumberOfSourceClassesChangedError >
                (new NumberOfSourceClassesChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NumberOfSourceClassesChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NumberOfSourceClassesChangedCallbackIF*) _callback)->onNumberOfSourceClassesChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NewMainConnection: {
                ::boost::shared_ptr< NewMainConnectionError > payload = ::boost::shared_ptr< NewMainConnectionError >
                (new NewMainConnectionError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NewMainConnection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NewMainConnectionCallbackIF*) _callback)->onNewMainConnectionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemovedMainConnection: {
                ::boost::shared_ptr< RemovedMainConnectionError > payload = ::boost::shared_ptr< RemovedMainConnectionError >
                (new RemovedMainConnectionError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemovedMainConnection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemovedMainConnectionCallbackIF*) _callback)->onRemovedMainConnectionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MainConnectionStateChanged: {
                ::boost::shared_ptr< MainConnectionStateChangedError > payload = ::boost::shared_ptr< MainConnectionStateChangedError >
                (new MainConnectionStateChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MainConnectionStateChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MainConnectionStateChangedCallbackIF*) _callback)->onMainConnectionStateChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MainSinkSoundPropertyChanged: {
                ::boost::shared_ptr< MainSinkSoundPropertyChangedError > payload = ::boost::shared_ptr< MainSinkSoundPropertyChangedError >
                (new MainSinkSoundPropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MainSinkSoundPropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MainSinkSoundPropertyChangedCallbackIF*) _callback)->onMainSinkSoundPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MainSourceSoundPropertyChanged: {
                ::boost::shared_ptr< MainSourceSoundPropertyChangedError > payload = ::boost::shared_ptr< MainSourceSoundPropertyChangedError >
                (new MainSourceSoundPropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MainSourceSoundPropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MainSourceSoundPropertyChangedCallbackIF*) _callback)->onMainSourceSoundPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SinkAvailabilityChanged: {
                ::boost::shared_ptr< SinkAvailabilityChangedError > payload = ::boost::shared_ptr< SinkAvailabilityChangedError >
                (new SinkAvailabilityChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SinkAvailabilityChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SinkAvailabilityChangedCallbackIF*) _callback)->onSinkAvailabilityChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SourceAvailabilityChanged: {
                ::boost::shared_ptr< SourceAvailabilityChangedError > payload = ::boost::shared_ptr< SourceAvailabilityChangedError >
                (new SourceAvailabilityChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceAvailabilityChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceAvailabilityChangedCallbackIF*) _callback)->onSourceAvailabilityChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VolumeChanged: {
                ::boost::shared_ptr< VolumeChangedError > payload = ::boost::shared_ptr< VolumeChangedError >
                (new VolumeChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VolumeChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VolumeChangedCallbackIF*) _callback)->onVolumeChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SinkMuteStateChanged: {
                ::boost::shared_ptr< SinkMuteStateChangedError > payload = ::boost::shared_ptr< SinkMuteStateChangedError >
                (new SinkMuteStateChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SinkMuteStateChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SinkMuteStateChangedCallbackIF*) _callback)->onSinkMuteStateChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SystemPropertyChanged: {
                ::boost::shared_ptr< SystemPropertyChangedError > payload = ::boost::shared_ptr< SystemPropertyChangedError >
                (new SystemPropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SystemPropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SystemPropertyChangedCallbackIF*) _callback)->onSystemPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TimingInformationChanged: {
                ::boost::shared_ptr< TimingInformationChangedError > payload = ::boost::shared_ptr< TimingInformationChangedError >
                (new TimingInformationChangedError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TimingInformationChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TimingInformationChangedCallbackIF*) _callback)->onTimingInformationChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Connect: {
                ::boost::shared_ptr< ConnectError > payload = ::boost::shared_ptr< ConnectError >
                (new ConnectError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Connect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConnectCallbackIF*) _callback)->onConnectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Disconnect: {
                ::boost::shared_ptr< DisconnectError > payload = ::boost::shared_ptr< DisconnectError >
                (new DisconnectError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Disconnect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetVolume: {
                ::boost::shared_ptr< SetVolumeError > payload = ::boost::shared_ptr< SetVolumeError >
                (new SetVolumeError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetVolumeCallbackIF*) _callback)->onSetVolumeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VolumeStep: {
                ::boost::shared_ptr< VolumeStepError > payload = ::boost::shared_ptr< VolumeStepError >
                (new VolumeStepError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VolumeStep", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VolumeStepCallbackIF*) _callback)->onVolumeStepError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetSinkMuteState: {
                ::boost::shared_ptr< SetSinkMuteStateError > payload = ::boost::shared_ptr< SetSinkMuteStateError >
                (new SetSinkMuteStateError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetSinkMuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetSinkMuteStateCallbackIF*) _callback)->onSetSinkMuteStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetMainSinkSoundProperty: {
                ::boost::shared_ptr< SetMainSinkSoundPropertyError > payload = ::boost::shared_ptr< SetMainSinkSoundPropertyError >
                (new SetMainSinkSoundPropertyError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetMainSinkSoundProperty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetMainSinkSoundPropertyCallbackIF*) _callback)->onSetMainSinkSoundPropertyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetMainSourceSoundProperty: {
                ::boost::shared_ptr< SetMainSourceSoundPropertyError > payload = ::boost::shared_ptr< SetMainSourceSoundPropertyError >
                (new SetMainSourceSoundPropertyError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetMainSourceSoundProperty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetMainSourceSoundPropertyCallbackIF*) _callback)->onSetMainSourceSoundPropertyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetSystemProperty: {
                ::boost::shared_ptr< SetSystemPropertyError > payload = ::boost::shared_ptr< SetSystemPropertyError >
                (new SetSystemPropertyError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetSystemProperty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetSystemPropertyCallbackIF*) _callback)->onSetSystemPropertyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetListMainConnections: {
                ::boost::shared_ptr< GetListMainConnectionsError > payload = ::boost::shared_ptr< GetListMainConnectionsError >
                (new GetListMainConnectionsError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetListMainConnections", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetListMainConnectionsCallbackIF*) _callback)->onGetListMainConnectionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetListMainSinks: {
                ::boost::shared_ptr< GetListMainSinksError > payload = ::boost::shared_ptr< GetListMainSinksError >
                (new GetListMainSinksError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetListMainSinks", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetListMainSinksCallbackIF*) _callback)->onGetListMainSinksError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetListMainSources: {
                ::boost::shared_ptr< GetListMainSourcesError > payload = ::boost::shared_ptr< GetListMainSourcesError >
                (new GetListMainSourcesError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetListMainSources", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetListMainSourcesCallbackIF*) _callback)->onGetListMainSourcesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetListMainSinkSoundProperties: {
                ::boost::shared_ptr< GetListMainSinkSoundPropertiesError > payload = ::boost::shared_ptr< GetListMainSinkSoundPropertiesError >
                (new GetListMainSinkSoundPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetListMainSinkSoundProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetListMainSinkSoundPropertiesCallbackIF*) _callback)->onGetListMainSinkSoundPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetListMainSourceSoundProperties: {
                ::boost::shared_ptr< GetListMainSourceSoundPropertiesError > payload = ::boost::shared_ptr< GetListMainSourceSoundPropertiesError >
                (new GetListMainSourceSoundPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetListMainSourceSoundProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetListMainSourceSoundPropertiesCallbackIF*) _callback)->onGetListMainSourceSoundPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetListSourceClasses: {
                ::boost::shared_ptr< GetListSourceClassesError > payload = ::boost::shared_ptr< GetListSourceClassesError >
                (new GetListSourceClassesError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetListSourceClasses", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetListSourceClassesCallbackIF*) _callback)->onGetListSourceClassesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetListSinkClasses: {
                ::boost::shared_ptr< GetListSinkClassesError > payload = ::boost::shared_ptr< GetListSinkClassesError >
                (new GetListSinkClassesError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetListSinkClasses", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetListSinkClassesCallbackIF*) _callback)->onGetListSinkClassesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetListSystemProperties: {
                ::boost::shared_ptr< GetListSystemPropertiesError > payload = ::boost::shared_ptr< GetListSystemPropertiesError >
                (new GetListSystemPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetListSystemProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetListSystemPropertiesCallbackIF*) _callback)->onGetListSystemPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetTimingInformation: {
                ::boost::shared_ptr< GetTimingInformationError > payload = ::boost::shared_ptr< GetTimingInformationError >
                (new GetTimingInformationError(DBUS_ERROR_NO_SERVER, "The DBus service CommandInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetTimingInformation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandInterfaceProxy> proxyShared = ::boost::static_pointer_cast<CommandInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetTimingInformationCallbackIF*) _callback)->onGetTimingInformationError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& CommandInterfaceProxyCallback::_logger (CommandInterfaceProxy::_logger);

CommandInterfaceProxy::CommandInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.genivi.audiomanager.CommandInterface", serviceAvailable, _logger) {
}

CommandInterfaceProxy::~CommandInterfaceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< CommandInterfaceProxy > CommandInterfaceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<CommandInterfaceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< CommandInterfaceProxy > proxyNew(new CommandInterfaceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t CommandInterfaceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    CommandInterfaceProxyCallback* callback = new CommandInterfaceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t CommandInterfaceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    CommandInterfaceProxyCallback* callback = new CommandInterfaceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void CommandInterfaceProxy::sendDeregisterAll () const
{
    sendNumberOfMainConnectionsChangedDeregisterAll();
    sendSinkAddedDeregisterAll();
    sendSinkRemovedDeregisterAll();
    sendSourceAddedDeregisterAll();
    sendSourceRemovedDeregisterAll();
    sendNumberOfSinkClassesChangedDeregisterAll();
    sendNumberOfSourceClassesChangedDeregisterAll();
    sendNewMainConnectionDeregisterAll();
    sendRemovedMainConnectionDeregisterAll();
    sendMainConnectionStateChangedDeregisterAll();
    sendMainSinkSoundPropertyChangedDeregisterAll();
    sendMainSourceSoundPropertyChangedDeregisterAll();
    sendSinkAvailabilityChangedDeregisterAll();
    sendSourceAvailabilityChangedDeregisterAll();
    sendVolumeChangedDeregisterAll();
    sendSinkMuteStateChangedDeregisterAll();
    sendSystemPropertyChangedDeregisterAll();
    sendTimingInformationChangedDeregisterAll();
}

act_t CommandInterfaceProxy::sendNumberOfMainConnectionsChangedRegister(NumberOfMainConnectionsChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NumberOfMainConnectionsChanged");
    act_t act = addSignalCallback(ID_NumberOfMainConnectionsChanged, "NumberOfMainConnectionsChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NumberOfMainConnectionsChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendNumberOfMainConnectionsChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NumberOfMainConnectionsChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NumberOfMainConnectionsChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendNumberOfMainConnectionsChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NumberOfMainConnectionsChanged");
    _dbusProxyDelegate->deregisterSignalCallback("NumberOfMainConnectionsChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendSinkAddedRegister(SinkAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SinkAdded");
    act_t act = addSignalCallback(ID_SinkAdded, "SinkAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SinkAdded", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendSinkAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SinkAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SinkAdded", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendSinkAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SinkAdded");
    _dbusProxyDelegate->deregisterSignalCallback("SinkAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendSinkRemovedRegister(SinkRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SinkRemoved");
    act_t act = addSignalCallback(ID_SinkRemoved, "SinkRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SinkRemoved", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendSinkRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SinkRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SinkRemoved", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendSinkRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SinkRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("SinkRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendSourceAddedRegister(SourceAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SourceAdded");
    act_t act = addSignalCallback(ID_SourceAdded, "SourceAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SourceAdded", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendSourceAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SourceAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SourceAdded", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendSourceAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SourceAdded");
    _dbusProxyDelegate->deregisterSignalCallback("SourceAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendSourceRemovedRegister(SourceRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SourceRemoved");
    act_t act = addSignalCallback(ID_SourceRemoved, "SourceRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SourceRemoved", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendSourceRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SourceRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SourceRemoved", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendSourceRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SourceRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("SourceRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendNumberOfSinkClassesChangedRegister(NumberOfSinkClassesChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NumberOfSinkClassesChanged");
    act_t act = addSignalCallback(ID_NumberOfSinkClassesChanged, "NumberOfSinkClassesChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NumberOfSinkClassesChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendNumberOfSinkClassesChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NumberOfSinkClassesChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NumberOfSinkClassesChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendNumberOfSinkClassesChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NumberOfSinkClassesChanged");
    _dbusProxyDelegate->deregisterSignalCallback("NumberOfSinkClassesChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendNumberOfSourceClassesChangedRegister(NumberOfSourceClassesChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NumberOfSourceClassesChanged");
    act_t act = addSignalCallback(ID_NumberOfSourceClassesChanged, "NumberOfSourceClassesChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NumberOfSourceClassesChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendNumberOfSourceClassesChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NumberOfSourceClassesChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NumberOfSourceClassesChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendNumberOfSourceClassesChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NumberOfSourceClassesChanged");
    _dbusProxyDelegate->deregisterSignalCallback("NumberOfSourceClassesChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendNewMainConnectionRegister(NewMainConnectionCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NewMainConnection");
    act_t act = addSignalCallback(ID_NewMainConnection, "NewMainConnection", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NewMainConnection", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendNewMainConnectionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NewMainConnection", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NewMainConnection", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendNewMainConnectionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NewMainConnection");
    _dbusProxyDelegate->deregisterSignalCallback("NewMainConnection", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendRemovedMainConnectionRegister(RemovedMainConnectionCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "RemovedMainConnection");
    act_t act = addSignalCallback(ID_RemovedMainConnection, "RemovedMainConnection", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RemovedMainConnection", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendRemovedMainConnectionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RemovedMainConnection", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RemovedMainConnection", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendRemovedMainConnectionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RemovedMainConnection");
    _dbusProxyDelegate->deregisterSignalCallback("RemovedMainConnection", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendMainConnectionStateChangedRegister(MainConnectionStateChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "MainConnectionStateChanged");
    act_t act = addSignalCallback(ID_MainConnectionStateChanged, "MainConnectionStateChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MainConnectionStateChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendMainConnectionStateChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MainConnectionStateChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MainConnectionStateChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendMainConnectionStateChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MainConnectionStateChanged");
    _dbusProxyDelegate->deregisterSignalCallback("MainConnectionStateChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendMainSinkSoundPropertyChangedRegister(MainSinkSoundPropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "MainSinkSoundPropertyChanged");
    act_t act = addSignalCallback(ID_MainSinkSoundPropertyChanged, "MainSinkSoundPropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MainSinkSoundPropertyChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendMainSinkSoundPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MainSinkSoundPropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MainSinkSoundPropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendMainSinkSoundPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MainSinkSoundPropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("MainSinkSoundPropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendMainSourceSoundPropertyChangedRegister(MainSourceSoundPropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "MainSourceSoundPropertyChanged");
    act_t act = addSignalCallback(ID_MainSourceSoundPropertyChanged, "MainSourceSoundPropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MainSourceSoundPropertyChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendMainSourceSoundPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MainSourceSoundPropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MainSourceSoundPropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendMainSourceSoundPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MainSourceSoundPropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("MainSourceSoundPropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendSinkAvailabilityChangedRegister(SinkAvailabilityChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SinkAvailabilityChanged");
    act_t act = addSignalCallback(ID_SinkAvailabilityChanged, "SinkAvailabilityChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SinkAvailabilityChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendSinkAvailabilityChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SinkAvailabilityChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SinkAvailabilityChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendSinkAvailabilityChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SinkAvailabilityChanged");
    _dbusProxyDelegate->deregisterSignalCallback("SinkAvailabilityChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendSourceAvailabilityChangedRegister(SourceAvailabilityChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SourceAvailabilityChanged");
    act_t act = addSignalCallback(ID_SourceAvailabilityChanged, "SourceAvailabilityChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SourceAvailabilityChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendSourceAvailabilityChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SourceAvailabilityChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SourceAvailabilityChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendSourceAvailabilityChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SourceAvailabilityChanged");
    _dbusProxyDelegate->deregisterSignalCallback("SourceAvailabilityChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendVolumeChangedRegister(VolumeChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "VolumeChanged");
    act_t act = addSignalCallback(ID_VolumeChanged, "VolumeChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VolumeChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendVolumeChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("VolumeChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VolumeChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendVolumeChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VolumeChanged");
    _dbusProxyDelegate->deregisterSignalCallback("VolumeChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendSinkMuteStateChangedRegister(SinkMuteStateChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SinkMuteStateChanged");
    act_t act = addSignalCallback(ID_SinkMuteStateChanged, "SinkMuteStateChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SinkMuteStateChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendSinkMuteStateChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SinkMuteStateChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SinkMuteStateChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendSinkMuteStateChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SinkMuteStateChanged");
    _dbusProxyDelegate->deregisterSignalCallback("SinkMuteStateChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendSystemPropertyChangedRegister(SystemPropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SystemPropertyChanged");
    act_t act = addSignalCallback(ID_SystemPropertyChanged, "SystemPropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SystemPropertyChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendSystemPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SystemPropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SystemPropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendSystemPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SystemPropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("SystemPropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendTimingInformationChangedRegister(TimingInformationChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "TimingInformationChanged");
    act_t act = addSignalCallback(ID_TimingInformationChanged, "TimingInformationChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TimingInformationChanged", &cb, act);
    return act;
}

bool CommandInterfaceProxy::sendTimingInformationChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TimingInformationChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TimingInformationChanged", act, static_cast<int>(rv));
    return rv;
}

void CommandInterfaceProxy::sendTimingInformationChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TimingInformationChanged");
    _dbusProxyDelegate->deregisterSignalCallback("TimingInformationChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandInterfaceProxy::sendConnectRequest(ConnectCallbackIF& cb, uint16 sourceID, uint16 sinkID) const {
    ConnectRequest* payload = new ConnectRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceID(sourceID);
    payload->setSinkID(sinkID);
    DBUS_MESSAGE_CALL(dbusMessage, "Connect", ConnectRequest, payload, true)
    act_t act = addMethodCallback(ID_Connect, dbusMessage.getUniqueSerial(), "Connect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Connect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendDisconnectRequest(DisconnectCallbackIF& cb, uint16 mainConnectionID) const {
    DisconnectRequest* payload = new DisconnectRequest();
    CHECK_ALLOCATION(payload);
    payload->setMainConnectionID(mainConnectionID);
    DBUS_MESSAGE_CALL(dbusMessage, "Disconnect", DisconnectRequest, payload, true)
    act_t act = addMethodCallback(ID_Disconnect, dbusMessage.getUniqueSerial(), "Disconnect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Disconnect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendSetVolumeRequest(SetVolumeCallbackIF& cb, uint16 sinkID, uint16 mode, int16 value) const {
    SetVolumeRequest* payload = new SetVolumeRequest();
    CHECK_ALLOCATION(payload);
    payload->setSinkID(sinkID);
    payload->setMode(mode);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "SetVolume", SetVolumeRequest, payload, true)
    act_t act = addMethodCallback(ID_SetVolume, dbusMessage.getUniqueSerial(), "SetVolume", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetVolume", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendVolumeStepRequest(VolumeStepCallbackIF& cb, uint16 sinkID, int16 volumeStep) const {
    VolumeStepRequest* payload = new VolumeStepRequest();
    CHECK_ALLOCATION(payload);
    payload->setSinkID(sinkID);
    payload->setVolumeStep(volumeStep);
    DBUS_MESSAGE_CALL(dbusMessage, "VolumeStep", VolumeStepRequest, payload, true)
    act_t act = addMethodCallback(ID_VolumeStep, dbusMessage.getUniqueSerial(), "VolumeStep", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "VolumeStep", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendSetSinkMuteStateRequest(SetSinkMuteStateCallbackIF& cb, uint16 sinkID, int16 muteState) const {
    SetSinkMuteStateRequest* payload = new SetSinkMuteStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setSinkID(sinkID);
    payload->setMuteState(muteState);
    DBUS_MESSAGE_CALL(dbusMessage, "SetSinkMuteState", SetSinkMuteStateRequest, payload, true)
    act_t act = addMethodCallback(ID_SetSinkMuteState, dbusMessage.getUniqueSerial(), "SetSinkMuteState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetSinkMuteState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendSetMainSinkSoundPropertyRequest(SetMainSinkSoundPropertyCallbackIF& cb, uint16 sinkID, const SetMainSinkSoundPropertyRequestSoundPropertyStruct& soundProperty) const {
    SetMainSinkSoundPropertyRequest* payload = new SetMainSinkSoundPropertyRequest();
    CHECK_ALLOCATION(payload);
    payload->setSinkID(sinkID);
    payload->setSoundProperty(soundProperty);
    DBUS_MESSAGE_CALL(dbusMessage, "SetMainSinkSoundProperty", SetMainSinkSoundPropertyRequest, payload, true)
    act_t act = addMethodCallback(ID_SetMainSinkSoundProperty, dbusMessage.getUniqueSerial(), "SetMainSinkSoundProperty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetMainSinkSoundProperty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendSetMainSourceSoundPropertyRequest(SetMainSourceSoundPropertyCallbackIF& cb, uint16 sourceID, const SetMainSourceSoundPropertyRequestSoundPropertyStruct& soundProperty) const {
    SetMainSourceSoundPropertyRequest* payload = new SetMainSourceSoundPropertyRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceID(sourceID);
    payload->setSoundProperty(soundProperty);
    DBUS_MESSAGE_CALL(dbusMessage, "SetMainSourceSoundProperty", SetMainSourceSoundPropertyRequest, payload, true)
    act_t act = addMethodCallback(ID_SetMainSourceSoundProperty, dbusMessage.getUniqueSerial(), "SetMainSourceSoundProperty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetMainSourceSoundProperty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendSetSystemPropertyRequest(SetSystemPropertyCallbackIF& cb, const SetSystemPropertyRequestPropertyStruct& property) const {
    SetSystemPropertyRequest* payload = new SetSystemPropertyRequest();
    CHECK_ALLOCATION(payload);
    payload->setProperty(property);
    DBUS_MESSAGE_CALL(dbusMessage, "SetSystemProperty", SetSystemPropertyRequest, payload, true)
    act_t act = addMethodCallback(ID_SetSystemProperty, dbusMessage.getUniqueSerial(), "SetSystemProperty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetSystemProperty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetListMainConnectionsRequest(GetListMainConnectionsCallbackIF& cb) const {
    GetListMainConnectionsRequest* payload = new GetListMainConnectionsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetListMainConnections", GetListMainConnectionsRequest, payload, true)
    act_t act = addMethodCallback(ID_GetListMainConnections, dbusMessage.getUniqueSerial(), "GetListMainConnections", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetListMainConnections", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetListMainSinksRequest(GetListMainSinksCallbackIF& cb) const {
    GetListMainSinksRequest* payload = new GetListMainSinksRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetListMainSinks", GetListMainSinksRequest, payload, true)
    act_t act = addMethodCallback(ID_GetListMainSinks, dbusMessage.getUniqueSerial(), "GetListMainSinks", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetListMainSinks", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetListMainSourcesRequest(GetListMainSourcesCallbackIF& cb) const {
    GetListMainSourcesRequest* payload = new GetListMainSourcesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetListMainSources", GetListMainSourcesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetListMainSources, dbusMessage.getUniqueSerial(), "GetListMainSources", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetListMainSources", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetListMainSinkSoundPropertiesRequest(GetListMainSinkSoundPropertiesCallbackIF& cb, uint16 sinkID) const {
    GetListMainSinkSoundPropertiesRequest* payload = new GetListMainSinkSoundPropertiesRequest();
    CHECK_ALLOCATION(payload);
    payload->setSinkID(sinkID);
    DBUS_MESSAGE_CALL(dbusMessage, "GetListMainSinkSoundProperties", GetListMainSinkSoundPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetListMainSinkSoundProperties, dbusMessage.getUniqueSerial(), "GetListMainSinkSoundProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetListMainSinkSoundProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetListMainSourceSoundPropertiesRequest(GetListMainSourceSoundPropertiesCallbackIF& cb, uint16 sourceID) const {
    GetListMainSourceSoundPropertiesRequest* payload = new GetListMainSourceSoundPropertiesRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceID(sourceID);
    DBUS_MESSAGE_CALL(dbusMessage, "GetListMainSourceSoundProperties", GetListMainSourceSoundPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetListMainSourceSoundProperties, dbusMessage.getUniqueSerial(), "GetListMainSourceSoundProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetListMainSourceSoundProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetListSourceClassesRequest(GetListSourceClassesCallbackIF& cb) const {
    GetListSourceClassesRequest* payload = new GetListSourceClassesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetListSourceClasses", GetListSourceClassesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetListSourceClasses, dbusMessage.getUniqueSerial(), "GetListSourceClasses", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetListSourceClasses", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetListSinkClassesRequest(GetListSinkClassesCallbackIF& cb) const {
    GetListSinkClassesRequest* payload = new GetListSinkClassesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetListSinkClasses", GetListSinkClassesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetListSinkClasses, dbusMessage.getUniqueSerial(), "GetListSinkClasses", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetListSinkClasses", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetListSystemPropertiesRequest(GetListSystemPropertiesCallbackIF& cb) const {
    GetListSystemPropertiesRequest* payload = new GetListSystemPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetListSystemProperties", GetListSystemPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetListSystemProperties, dbusMessage.getUniqueSerial(), "GetListSystemProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetListSystemProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t CommandInterfaceProxy::sendGetTimingInformationRequest(GetTimingInformationCallbackIF& cb, uint16 mainConnectionID) const {
    GetTimingInformationRequest* payload = new GetTimingInformationRequest();
    CHECK_ALLOCATION(payload);
    payload->setMainConnectionID(mainConnectionID);
    DBUS_MESSAGE_CALL(dbusMessage, "GetTimingInformation", GetTimingInformationRequest, payload, true)
    act_t act = addMethodCallback(ID_GetTimingInformation, dbusMessage.getUniqueSerial(), "GetTimingInformation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetTimingInformation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace CommandInterface
} // namespace audiomanager
} // namespace genivi
} // namespace org
