/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Logger.h"
#include "asf/stream/json.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "org/bosch/WBLRegulatoryTypes.h"
#include "org/bosch/WBLRegulatoryTypesJson.h"
#include "org/bosch/WBLRegulatoryTypesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstdlib>
#include <cstring>
#include <string>

using namespace ::asf::stream::json;


static ParserStatus parserNetworkInterfacePointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2);


static ParserStatus parserWifiChannelPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2);


static ParserStatus parserWifiRadioPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2);

static ParserStatus parserNetworkInterfacePointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT,
        WAIT_FOR_RETURN
    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::NetworkInterface > *object = (::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::NetworkInterface >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, WAIT_FOR_RETURN);
                ::org::bosch::WBLRegulatoryTypes::NetworkInterface *o = new ::org::bosch::WBLRegulatoryTypes::NetworkInterface();
                CHECK_ALLOCATION(o);
                callParser (context, "parserNetworkInterface", jsonParser__org__bosch__WBLRegulatoryTypes__NetworkInterface, &*o);
                return PARSER_STATUS__OK;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            {
                ::org::bosch::WBLRegulatoryTypes::NetworkInterface *o = (::org::bosch::WBLRegulatoryTypes::NetworkInterface *) p1;
                object->push_back (o);
                setState (context, INIT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
    break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}


static ParserStatus parserWifiChannelPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT,
        WAIT_FOR_RETURN
    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiChannel > *object = (::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiChannel >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, WAIT_FOR_RETURN);
                ::org::bosch::WBLRegulatoryTypes::WifiChannel *o = new ::org::bosch::WBLRegulatoryTypes::WifiChannel();
                CHECK_ALLOCATION(o);
                callParser (context, "parserWifiChannel", jsonParser__org__bosch__WBLRegulatoryTypes__WifiChannel, &*o);
                return PARSER_STATUS__OK;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            {
                ::org::bosch::WBLRegulatoryTypes::WifiChannel *o = (::org::bosch::WBLRegulatoryTypes::WifiChannel *) p1;
                object->push_back (o);
                setState (context, INIT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
    break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}


static ParserStatus parserWifiRadioPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT,
        WAIT_FOR_RETURN
    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiRadio > *object = (::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiRadio >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, WAIT_FOR_RETURN);
                ::org::bosch::WBLRegulatoryTypes::WifiRadio *o = new ::org::bosch::WBLRegulatoryTypes::WifiRadio();
                CHECK_ALLOCATION(o);
                callParser (context, "parserWifiRadio", jsonParser__org__bosch__WBLRegulatoryTypes__WifiRadio, &*o);
                return PARSER_STATUS__OK;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            {
                ::org::bosch::WBLRegulatoryTypes::WifiRadio *o = (::org::bosch::WBLRegulatoryTypes::WifiRadio *) p1;
                object->push_back (o);
                setState (context, INIT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
    break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "WifiChannel"

void serializeJson (const ::org::bosch::WBLRegulatoryTypes::WifiChannel& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannel()) {
        yajl_gen_string(g, (const unsigned char*)  "channel" , 7);
        yajl_gen_integer(g, (long long)value.getChannel());
    }
    if (!isSparse || value.hasFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "frequency" , 9);
        yajl_gen_integer(g, (long long)value.getFrequency());
    }
    if (!isSparse || value.hasFlags()) {
        yajl_gen_string(g, (const unsigned char*)  "flags" , 5);
        yajl_gen_integer(g, (long long)value.getFlags());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::WBLRegulatoryTypes::WifiChannel& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::org::bosch::WBLRegulatoryTypes::WifiChannel& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserWifiChannel", jsonParser__org__bosch__WBLRegulatoryTypes__WifiChannel, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForWifiChannel (char *s, size_t length)
{
    static stringEntry entries[] = {
        {5,"FLAGS", 5},
        {7,"CHANNEL", 1},
        {9,"FREQUENCY", 3},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 3, value))
        return (int)value;
    else
        return 6;
}

static int processMapKeyForWifiChannel (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForWifiChannel(s, length);
    if (i != 6 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__org__bosch__WBLRegulatoryTypes__WifiChannel(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_CHANNEL,
        KEY_CHANNEL,
        INIT_KEY_FREQUENCY,
        KEY_FREQUENCY,
        INIT_KEY_FLAGS,
        KEY_FLAGS,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_CHANNEL:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiChannel (context, (char*) p1, (size_t) p2, "channel", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNEL:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::WifiChannel*) parser.object)->setChannel(t);
                    setState (context, INIT_KEY_FREQUENCY);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_FREQUENCY:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiChannel (context, (char*) p1, (size_t) p2, "frequency", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_FREQUENCY:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::WifiChannel*) parser.object)->setFrequency(t);
                    setState (context, INIT_KEY_FLAGS);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_FLAGS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiChannel (context, (char*) p1, (size_t) p2, "flags", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_FLAGS:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::WifiChannel*) parser.object)->setFlags(t);
                    setState (context, INIT_KEY_CHANNEL);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_CHANNEL);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_CHANNEL);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "NetworkInterface"

void serializeJson (const ::org::bosch::WBLRegulatoryTypes::NetworkInterface& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "index" , 5);
        yajl_gen_integer(g, (long long)value.getIndex());
    }
    if (!isSparse || value.hasMacaddress()) {
        yajl_gen_string(g, (const unsigned char*)  "macaddress" , 10);
        const char *s = value.getMacaddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIfname()) {
        yajl_gen_string(g, (const unsigned char*)  "ifname" , 6);
        const char *s = value.getIfname().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::WBLRegulatoryTypes::NetworkInterface& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::org::bosch::WBLRegulatoryTypes::NetworkInterface& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserNetworkInterface", jsonParser__org__bosch__WBLRegulatoryTypes__NetworkInterface, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForNetworkInterface (char *s, size_t length)
{
    static stringEntry entries[] = {
        {5,"INDEX", 1},
        {6,"IFNAME", 5},
        {10,"MACADDRESS", 3},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 3, value))
        return (int)value;
    else
        return 6;
}

static int processMapKeyForNetworkInterface (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForNetworkInterface(s, length);
    if (i != 6 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__org__bosch__WBLRegulatoryTypes__NetworkInterface(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_INDEX,
        KEY_INDEX,
        INIT_KEY_MACADDRESS,
        KEY_MACADDRESS,
        INIT_KEY_IFNAME,
        KEY_IFNAME,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_INDEX:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForNetworkInterface (context, (char*) p1, (size_t) p2, "index", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INDEX:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::NetworkInterface*) parser.object)->setIndex(t);
                    setState (context, INIT_KEY_MACADDRESS);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_MACADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForNetworkInterface (context, (char*) p1, (size_t) p2, "macaddress", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MACADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::org::bosch::WBLRegulatoryTypes::NetworkInterface*) parser.object)->replaceMacaddress(t);
                setState (context, INIT_KEY_IFNAME);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IFNAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForNetworkInterface (context, (char*) p1, (size_t) p2, "ifname", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IFNAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::org::bosch::WBLRegulatoryTypes::NetworkInterface*) parser.object)->replaceIfname(t);
                setState (context, INIT_KEY_INDEX);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_INDEX);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_INDEX);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "WifiRadio"

void serializeJson (const ::org::bosch::WBLRegulatoryTypes::WifiRadio& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRadio()) {
        yajl_gen_string(g, (const unsigned char*)  "radio" , 5);
        const char *s = value.getRadio().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRegDomain()) {
        yajl_gen_string(g, (const unsigned char*)  "regDomain" , 9);
        const char *s = value.getRegDomain().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasInitiator()) {
        yajl_gen_string(g, (const unsigned char*)  "initiator" , 9);
        yajl_gen_integer(g, (long long)value.getInitiator());
    }
    if (!isSparse || value.hasRegtype()) {
        yajl_gen_string(g, (const unsigned char*)  "regtype" , 7);
        yajl_gen_integer(g, (long long)value.getRegtype());
    }
    if (!isSparse || value.hasSelfManaged()) {
        yajl_gen_string(g, (const unsigned char*)  "selfManaged" , 11);
        yajl_gen_integer(g, (long long)value.getSelfManaged());
    }
    if (!isSparse || value.hasIeee80211index()) {
        yajl_gen_string(g, (const unsigned char*)  "ieee80211index" , 14);
        yajl_gen_integer(g, (long long)value.getIeee80211index());
    }
    if (!isSparse || value.hasNetdevices()) {
        yajl_gen_string(g, (const unsigned char*)  "netdevices" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::NetworkInterface >& o1 = value.getNetdevices();
        {
            ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::NetworkInterface >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasChannelsinfo()) {
        yajl_gen_string(g, (const unsigned char*)  "channelsinfo" , 12);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiChannel >& o3 = value.getChannelsinfo();
        {
            ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiChannel >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::WBLRegulatoryTypes::WifiRadio& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::org::bosch::WBLRegulatoryTypes::WifiRadio& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserWifiRadio", jsonParser__org__bosch__WBLRegulatoryTypes__WifiRadio, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForWifiRadio (char *s, size_t length)
{
    static stringEntry entries[] = {
        {5,"RADIO", 1},
        {7,"REGTYPE", 7},
        {9,"INITIATOR", 5},
        {9,"REGDOMAIN", 3},
        {10,"NETDEVICES", 13},
        {11,"SELFMANAGED", 9},
        {12,"CHANNELSINFO", 16},
        {14,"IEEE80211INDEX", 11},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 8, value))
        return (int)value;
    else
        return 18;
}

static int processMapKeyForWifiRadio (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForWifiRadio(s, length);
    if (i != 18 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__org__bosch__WBLRegulatoryTypes__WifiRadio(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_RADIO,
        KEY_RADIO,
        INIT_KEY_REGDOMAIN,
        KEY_REGDOMAIN,
        INIT_KEY_INITIATOR,
        KEY_INITIATOR,
        INIT_KEY_REGTYPE,
        KEY_REGTYPE,
        INIT_KEY_SELFMANAGED,
        KEY_SELFMANAGED,
        INIT_KEY_IEEE80211INDEX,
        KEY_IEEE80211INDEX,
        INIT_KEY_NETDEVICES,
        KEY_NETDEVICES,
        KEY_NETDEVICES_WAIT_FOR_RETURN,
        INIT_KEY_CHANNELSINFO,
        KEY_CHANNELSINFO,
        KEY_CHANNELSINFO_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_RADIO:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiRadio (context, (char*) p1, (size_t) p2, "radio", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_RADIO:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::org::bosch::WBLRegulatoryTypes::WifiRadio*) parser.object)->replaceRadio(t);
                setState (context, INIT_KEY_REGDOMAIN);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_REGDOMAIN:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiRadio (context, (char*) p1, (size_t) p2, "regDomain", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_REGDOMAIN:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::org::bosch::WBLRegulatoryTypes::WifiRadio*) parser.object)->replaceRegDomain(t);
                setState (context, INIT_KEY_INITIATOR);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_INITIATOR:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiRadio (context, (char*) p1, (size_t) p2, "initiator", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INITIATOR:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint8 t = (uint8) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::WifiRadio*) parser.object)->setInitiator(t);
                    setState (context, INIT_KEY_REGTYPE);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_REGTYPE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiRadio (context, (char*) p1, (size_t) p2, "regtype", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_REGTYPE:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint8 t = (uint8) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::WifiRadio*) parser.object)->setRegtype(t);
                    setState (context, INIT_KEY_SELFMANAGED);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_SELFMANAGED:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiRadio (context, (char*) p1, (size_t) p2, "selfManaged", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_SELFMANAGED:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                int32 t = (int32) strtol ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::WifiRadio*) parser.object)->setSelfManaged(t);
                    setState (context, INIT_KEY_IEEE80211INDEX);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IEEE80211INDEX:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiRadio (context, (char*) p1, (size_t) p2, "ieee80211index", 11) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IEEE80211INDEX:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                int32 t = (int32) strtol ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::WifiRadio*) parser.object)->setIeee80211index(t);
                    setState (context, INIT_KEY_NETDEVICES);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_NETDEVICES:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiRadio (context, (char*) p1, (size_t) p2, "netdevices", 13) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_NETDEVICES:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_NETDEVICES_WAIT_FOR_RETURN);
                callParser (context, "parserNetworkInterfacePointerList_", parserNetworkInterfacePointerList_, &((::org::bosch::WBLRegulatoryTypes::WifiRadio*) parser.object)->getNetdevicesMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_NETDEVICES_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_CHANNELSINFO);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELSINFO:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForWifiRadio (context, (char*) p1, (size_t) p2, "channelsinfo", 16) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELSINFO:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_CHANNELSINFO_WAIT_FOR_RETURN);
                callParser (context, "parserWifiChannelPointerList_", parserWifiChannelPointerList_, &((::org::bosch::WBLRegulatoryTypes::WifiRadio*) parser.object)->getChannelsinfoMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_CHANNELSINFO_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_RADIO);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_RADIO);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_RADIO);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "RegulatoryUpdate"

void serializeJson (const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInitiator()) {
        yajl_gen_string(g, (const unsigned char*)  "initiator" , 9);
        yajl_gen_integer(g, (long long)value.getInitiator());
    }
    if (!isSparse || value.hasRegtype()) {
        yajl_gen_string(g, (const unsigned char*)  "regtype" , 7);
        yajl_gen_integer(g, (long long)value.getRegtype());
    }
    if (!isSparse || value.hasGlobal()) {
        yajl_gen_string(g, (const unsigned char*)  "global" , 6);
        yajl_gen_integer(g, (long long)value.getGlobal());
    }
    if (!isSparse || value.hasCountry()) {
        yajl_gen_string(g, (const unsigned char*)  "country" , 7);
        const char *s = value.getCountry().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRadios()) {
        yajl_gen_string(g, (const unsigned char*)  "radios" , 6);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiRadio >& o5 = value.getRadios();
        {
            ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiRadio >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserRegulatoryUpdate", jsonParser__org__bosch__WBLRegulatoryTypes__RegulatoryUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForRegulatoryUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {6,"GLOBAL", 5},
        {6,"RADIOS", 9},
        {7,"COUNTRY", 7},
        {7,"REGTYPE", 3},
        {9,"INITIATOR", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 5, value))
        return (int)value;
    else
        return 11;
}

static int processMapKeyForRegulatoryUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForRegulatoryUpdate(s, length);
    if (i != 11 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__org__bosch__WBLRegulatoryTypes__RegulatoryUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_INITIATOR,
        KEY_INITIATOR,
        INIT_KEY_REGTYPE,
        KEY_REGTYPE,
        INIT_KEY_GLOBAL,
        KEY_GLOBAL,
        INIT_KEY_COUNTRY,
        KEY_COUNTRY,
        INIT_KEY_RADIOS,
        KEY_RADIOS,
        KEY_RADIOS_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_INITIATOR:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegulatoryUpdate (context, (char*) p1, (size_t) p2, "initiator", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INITIATOR:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint8 t = (uint8) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate*) parser.object)->setInitiator(t);
                    setState (context, INIT_KEY_REGTYPE);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_REGTYPE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegulatoryUpdate (context, (char*) p1, (size_t) p2, "regtype", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_REGTYPE:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint8 t = (uint8) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate*) parser.object)->setRegtype(t);
                    setState (context, INIT_KEY_GLOBAL);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_GLOBAL:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegulatoryUpdate (context, (char*) p1, (size_t) p2, "global", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_GLOBAL:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint8 t = (uint8) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate*) parser.object)->setGlobal(t);
                    setState (context, INIT_KEY_COUNTRY);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_COUNTRY:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegulatoryUpdate (context, (char*) p1, (size_t) p2, "country", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_COUNTRY:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate*) parser.object)->replaceCountry(t);
                setState (context, INIT_KEY_RADIOS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_RADIOS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegulatoryUpdate (context, (char*) p1, (size_t) p2, "radios", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_RADIOS:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_RADIOS_WAIT_FOR_RETURN);
                callParser (context, "parserWifiRadioPointerList_", parserWifiRadioPointerList_, &((::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate*) parser.object)->getRadiosMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_RADIOS_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_INITIATOR);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_INITIATOR);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_INITIATOR);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace WBLRegulatoryTypes {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::WBLRegulatoryTypes::WifiChannel& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WBLRegulatoryTypes
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace WBLRegulatoryTypes {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::WBLRegulatoryTypes::NetworkInterface& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WBLRegulatoryTypes
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace WBLRegulatoryTypes {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::WBLRegulatoryTypes::WifiRadio& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WBLRegulatoryTypes
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace WBLRegulatoryTypes {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WBLRegulatoryTypes
} // namespace bosch
} // namespace org

