/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/PrimitivesReader.h"
#include "asf/stream/PrimitivesWriter.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "org/bosch/WBLRegulatoryTypes.h"
#include "org/bosch/WBLRegulatoryTypesCmsBin.h"


// CmsBin serialize and deserialize function of structure WifiChannel

void serializeCmsBin (const ::org::bosch::WBLRegulatoryTypes::WifiChannel& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getChannel();
    out << in.getFrequency();
    out << in.getFlags();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::org::bosch::WBLRegulatoryTypes::WifiChannel& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint16 channelValue;
    if (!(in >> channelValue)) {
        return false;
    }
    out.setChannel(channelValue);

    uint16 frequencyValue;
    if (!(in >> frequencyValue)) {
        return false;
    }
    out.setFrequency(frequencyValue);

    uint32 flagsValue;
    if (!(in >> flagsValue)) {
        return false;
    }
    out.setFlags(flagsValue);

    return true;
}

// CmsBin serialize and deserialize function of structure NetworkInterface

void serializeCmsBin (const ::org::bosch::WBLRegulatoryTypes::NetworkInterface& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getIndex();
    out << in.getMacaddress();
    out << in.getIfname();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::org::bosch::WBLRegulatoryTypes::NetworkInterface& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 indexValue;
    if (!(in >> indexValue)) {
        return false;
    }
    out.setIndex(indexValue);

    if (!(in >> out.getMacaddressMutable())) {
        return false;
    }

    if (!(in >> out.getIfnameMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure WifiRadio

void serializeCmsBin (const ::org::bosch::WBLRegulatoryTypes::WifiRadio& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getRadio();
    out << in.getRegDomain();
    out << in.getInitiator();
    out << in.getRegtype();
    out << in.getSelfManaged();
    out << in.getIeee80211index();
    const ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::NetworkInterface >* o0 = &in.getNetdevices();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o0->size() <= UINT32_MAX );
        out << static_cast<uint32>(o0->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::NetworkInterface >::const_iterator o1 = o0->end();
    for (::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::NetworkInterface >::const_iterator o2 = o0->begin(); o2 != o1; o2++){
        serializeCmsBin((*o2), out);
    }
    const ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiChannel >* o3 = &in.getChannelsinfo();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o3->size() <= UINT32_MAX );
        out << static_cast<uint32>(o3->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiChannel >::const_iterator o4 = o3->end();
    for (::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiChannel >::const_iterator o5 = o3->begin(); o5 != o4; o5++){
        serializeCmsBin((*o5), out);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::org::bosch::WBLRegulatoryTypes::WifiRadio& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getRadioMutable())) {
        return false;
    }

    if (!(in >> out.getRegDomainMutable())) {
        return false;
    }

    uint8 initiatorValue;
    if (!(in >> initiatorValue)) {
        return false;
    }
    out.setInitiator(initiatorValue);

    uint8 regtypeValue;
    if (!(in >> regtypeValue)) {
        return false;
    }
    out.setRegtype(regtypeValue);

    int32 selfManagedValue;
    if (!(in >> selfManagedValue)) {
        return false;
    }
    out.setSelfManaged(selfManagedValue);

    int32 ieee80211indexValue;
    if (!(in >> ieee80211indexValue)) {
        return false;
    }
    out.setIeee80211index(ieee80211indexValue);

    uint32 o6;
    if (!(in >> o6)) {
        return false;
    }

    // increase capacity of list
    out.getNetdevicesMutable().reserve(o6);
    for (uint32 index_o6 = 0; index_o6 < o6; index_o6++) {
        ::org::bosch::WBLRegulatoryTypes::NetworkInterface* o7 = new ::org::bosch::WBLRegulatoryTypes::NetworkInterface();
        CHECK_ALLOCATION(o7);
        if (!::deserializeCmsBin(in, (*o7))) {
            delete o7;
            return false;
        }
        out.getNetdevicesMutable().push_back(o7);
    }

    uint32 o8;
    if (!(in >> o8)) {
        return false;
    }

    // increase capacity of list
    out.getChannelsinfoMutable().reserve(o8);
    for (uint32 index_o8 = 0; index_o8 < o8; index_o8++) {
        ::org::bosch::WBLRegulatoryTypes::WifiChannel* o9 = new ::org::bosch::WBLRegulatoryTypes::WifiChannel();
        CHECK_ALLOCATION(o9);
        if (!::deserializeCmsBin(in, (*o9))) {
            delete o9;
            return false;
        }
        out.getChannelsinfoMutable().push_back(o9);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure RegulatoryUpdate

void serializeCmsBin (const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getInitiator();
    out << in.getRegtype();
    out << in.getGlobal();
    out << in.getCountry();
    const ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiRadio >* o10 = &in.getRadios();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o10->size() <= UINT32_MAX );
        out << static_cast<uint32>(o10->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiRadio >::const_iterator o11 = o10->end();
    for (::boost::ptr_vector< ::org::bosch::WBLRegulatoryTypes::WifiRadio >::const_iterator o12 = o10->begin(); o12 != o11; o12++){
        serializeCmsBin((*o12), out);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint8 initiatorValue;
    if (!(in >> initiatorValue)) {
        return false;
    }
    out.setInitiator(initiatorValue);

    uint8 regtypeValue;
    if (!(in >> regtypeValue)) {
        return false;
    }
    out.setRegtype(regtypeValue);

    uint8 globalValue;
    if (!(in >> globalValue)) {
        return false;
    }
    out.setGlobal(globalValue);

    if (!(in >> out.getCountryMutable())) {
        return false;
    }

    uint32 o13;
    if (!(in >> o13)) {
        return false;
    }

    // increase capacity of list
    out.getRadiosMutable().reserve(o13);
    for (uint32 index_o13 = 0; index_o13 < o13; index_o13++) {
        ::org::bosch::WBLRegulatoryTypes::WifiRadio* o14 = new ::org::bosch::WBLRegulatoryTypes::WifiRadio();
        CHECK_ALLOCATION(o14);
        if (!::deserializeCmsBin(in, (*o14))) {
            delete o14;
            return false;
        }
        out.getRadiosMutable().push_back(o14);
    }

    return true;
}

