#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBLMLMETYPES_H
#define ORG_BOSCH_WBLMLMETYPES_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "WBLMlmeTypes" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace WBLMlmeTypes {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class MlmeEventConnect;

class MlmeEventDisconnect;


/**
 * If the meaning of "MlmeEventConnect" isn't clear, then there should be a description here.
 */
class MlmeEventConnect {
public:

    /**
     * Default constructor
     */
    inline  MlmeEventConnect ();

    /**
     * Copy constructor
     */
    inline  MlmeEventConnect (const MlmeEventConnect &rhs);

    /**
     * All fields constructor
     */
    inline  MlmeEventConnect (uint32 ieee80211index_, uint32 ifindex_, const ::std::string& bssid_, uint16 statuscode_, bool timedout_, const ::std::string& ifname_);

    /**
     * Destructor
     */
    inline  ~MlmeEventConnect();

    /**
     * Assignment operator
     */
    inline MlmeEventConnect& operator = (const MlmeEventConnect& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MlmeEventConnect& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MlmeEventConnect& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MlmeEventConnect& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MlmeEventConnect& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ieee80211index"

    static const int kIeee80211index = 0;

    /**
     * Clears the field "ieee80211index".
     *
     * The field will be set to its default value. The hasIeee80211index()
     * method will return false.
     */
    inline void clearIeee80211index();

    /**
     * Checks whether the field "ieee80211index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIeee80211index()). Otherwise it will return false.
     */
    inline bool hasIeee80211index () const;

    /**
     * Returns the value of the member "ieee80211index".
     *
     * If the meaning of "ieee80211index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ieee80211index"
     */
    inline uint32 getIeee80211index () const;

    /**
     * Sets the value of the member "ieee80211index".
     *
     * If the meaning of "ieee80211index" isn't clear, then there should be a description here.
     *
     * @param ieee80211index The value which will be set
     */
    inline void setIeee80211index (uint32 ieee80211index_);

    // API of field "ifindex"

    static const int kIfindex = 1;

    /**
     * Clears the field "ifindex".
     *
     * The field will be set to its default value. The hasIfindex()
     * method will return false.
     */
    inline void clearIfindex();

    /**
     * Checks whether the field "ifindex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIfindex()). Otherwise it will return false.
     */
    inline bool hasIfindex () const;

    /**
     * Returns the value of the member "ifindex".
     *
     * If the meaning of "ifindex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ifindex"
     */
    inline uint32 getIfindex () const;

    /**
     * Sets the value of the member "ifindex".
     *
     * If the meaning of "ifindex" isn't clear, then there should be a description here.
     *
     * @param ifindex The value which will be set
     */
    inline void setIfindex (uint32 ifindex_);

    // API of field "bssid"

    static const int kBssid = 2;

    /**
     * Clears the field "bssid".
     *
     * The field will be set to its default value. The hasBssid()
     * method will return false.
     */
    inline void clearBssid();

    /**
     * Checks whether the field "bssid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBssid()). Otherwise it will return false.
     */
    inline bool hasBssid () const;

    /**
     * Returns the value of the member "bssid".
     *
     * If the meaning of "bssid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bssid"
     */
    inline const ::std::string& getBssid () const;

    /**
     * Retrieves the value of the field "bssid" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "bssid".
     */
    inline ::std::string& getBssidMutable ();

    /**
     * Sets the value of the member "bssid".
     *
     * If the meaning of "bssid" isn't clear, then there should be a description here.
     *
     * @param bssid The value which will be set
     */
    inline void setBssid (const ::std::string& bssid_);

    /**
     * Sets the value of the member "bssid".
     *
     * If the meaning of "bssid" isn't clear, then there should be a description here.
     *
     * @param bssid The value which will be set
     */
    inline void setBssid (const char* bssid_);

    /**
     * Sets the value of the member "bssid".
     *
     * If the meaning of "bssid" isn't clear, then there should be a description here.
     *
     * @param bssid The value which will be set
     */
    inline void setBssid (const char* value, size_t size);

    /**
     * Release the object stored in the field "bssid".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "bssid"
     */
    inline ::std::string* releaseBssid();

    /**
     * Replace the field "bssid".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceBssid (::std::string* bssid_);

    // API of field "statuscode"

    static const int kStatuscode = 3;

    /**
     * Clears the field "statuscode".
     *
     * The field will be set to its default value. The hasStatuscode()
     * method will return false.
     */
    inline void clearStatuscode();

    /**
     * Checks whether the field "statuscode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatuscode()). Otherwise it will return false.
     */
    inline bool hasStatuscode () const;

    /**
     * Returns the value of the member "statuscode".
     *
     * If the meaning of "statuscode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "statuscode"
     */
    inline uint16 getStatuscode () const;

    /**
     * Sets the value of the member "statuscode".
     *
     * If the meaning of "statuscode" isn't clear, then there should be a description here.
     *
     * @param statuscode The value which will be set
     */
    inline void setStatuscode (uint16 statuscode_);

    // API of field "timedout"

    static const int kTimedout = 4;

    /**
     * Clears the field "timedout".
     *
     * The field will be set to its default value. The hasTimedout()
     * method will return false.
     */
    inline void clearTimedout();

    /**
     * Checks whether the field "timedout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimedout()). Otherwise it will return false.
     */
    inline bool hasTimedout () const;

    /**
     * Returns the value of the member "timedout".
     *
     * If the meaning of "timedout" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timedout"
     */
    inline bool getTimedout () const;

    /**
     * Sets the value of the member "timedout".
     *
     * If the meaning of "timedout" isn't clear, then there should be a description here.
     *
     * @param timedout The value which will be set
     */
    inline void setTimedout (bool timedout_);

    // API of field "ifname"

    static const int kIfname = 5;

    /**
     * Clears the field "ifname".
     *
     * The field will be set to its default value. The hasIfname()
     * method will return false.
     */
    inline void clearIfname();

    /**
     * Checks whether the field "ifname" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIfname()). Otherwise it will return false.
     */
    inline bool hasIfname () const;

    /**
     * Returns the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ifname"
     */
    inline const ::std::string& getIfname () const;

    /**
     * Retrieves the value of the field "ifname" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ifname".
     */
    inline ::std::string& getIfnameMutable ();

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const ::std::string& ifname_);

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const char* ifname_);

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const char* value, size_t size);

    /**
     * Release the object stored in the field "ifname".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ifname"
     */
    inline ::std::string* releaseIfname();

    /**
     * Replace the field "ifname".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceIfname (::std::string* ifname_);

    static const MlmeEventConnect &getDefaultInstance();

private:

    inline void set_has_ieee80211index ();

    inline void clear_has_ieee80211index ();

    inline void set_has_ifindex ();

    inline void clear_has_ifindex ();

    inline void set_has_bssid ();

    inline void clear_has_bssid ();

    inline void set_has_statuscode ();

    inline void clear_has_statuscode ();

    inline void set_has_timedout ();

    inline void clear_has_timedout ();

    inline void set_has_ifname ();

    inline void clear_has_ifname ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _ieee80211index;

    uint32 _ifindex;

    ::std::string* _bssid;

    uint16 _statuscode;

    bool _timedout;

    ::std::string* _ifname;

};

/**
 * If the meaning of "MlmeEventDisconnect" isn't clear, then there should be a description here.
 */
class MlmeEventDisconnect {
public:

    /**
     * Default constructor
     */
    inline  MlmeEventDisconnect ();

    /**
     * Copy constructor
     */
    inline  MlmeEventDisconnect (const MlmeEventDisconnect &rhs);

    /**
     * All fields constructor
     */
    inline  MlmeEventDisconnect (uint32 ieee80211index_, uint32 ifindex_, bool disconnectedbyap_, uint16 reason_, const ::std::string& ifname_);

    /**
     * Destructor
     */
    inline  ~MlmeEventDisconnect();

    /**
     * Assignment operator
     */
    inline MlmeEventDisconnect& operator = (const MlmeEventDisconnect& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MlmeEventDisconnect& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MlmeEventDisconnect& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MlmeEventDisconnect& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MlmeEventDisconnect& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ieee80211index"

    static const int kIeee80211index = 0;

    /**
     * Clears the field "ieee80211index".
     *
     * The field will be set to its default value. The hasIeee80211index()
     * method will return false.
     */
    inline void clearIeee80211index();

    /**
     * Checks whether the field "ieee80211index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIeee80211index()). Otherwise it will return false.
     */
    inline bool hasIeee80211index () const;

    /**
     * Returns the value of the member "ieee80211index".
     *
     * If the meaning of "ieee80211index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ieee80211index"
     */
    inline uint32 getIeee80211index () const;

    /**
     * Sets the value of the member "ieee80211index".
     *
     * If the meaning of "ieee80211index" isn't clear, then there should be a description here.
     *
     * @param ieee80211index The value which will be set
     */
    inline void setIeee80211index (uint32 ieee80211index_);

    // API of field "ifindex"

    static const int kIfindex = 1;

    /**
     * Clears the field "ifindex".
     *
     * The field will be set to its default value. The hasIfindex()
     * method will return false.
     */
    inline void clearIfindex();

    /**
     * Checks whether the field "ifindex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIfindex()). Otherwise it will return false.
     */
    inline bool hasIfindex () const;

    /**
     * Returns the value of the member "ifindex".
     *
     * If the meaning of "ifindex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ifindex"
     */
    inline uint32 getIfindex () const;

    /**
     * Sets the value of the member "ifindex".
     *
     * If the meaning of "ifindex" isn't clear, then there should be a description here.
     *
     * @param ifindex The value which will be set
     */
    inline void setIfindex (uint32 ifindex_);

    // API of field "disconnectedbyap"

    static const int kDisconnectedbyap = 2;

    /**
     * Clears the field "disconnectedbyap".
     *
     * The field will be set to its default value. The hasDisconnectedbyap()
     * method will return false.
     */
    inline void clearDisconnectedbyap();

    /**
     * Checks whether the field "disconnectedbyap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisconnectedbyap()). Otherwise it will return false.
     */
    inline bool hasDisconnectedbyap () const;

    /**
     * Returns the value of the member "disconnectedbyap".
     *
     * If the meaning of "disconnectedbyap" isn't clear, then there should be a description here.
     *
     * @return The value of the field "disconnectedbyap"
     */
    inline bool getDisconnectedbyap () const;

    /**
     * Sets the value of the member "disconnectedbyap".
     *
     * If the meaning of "disconnectedbyap" isn't clear, then there should be a description here.
     *
     * @param disconnectedbyap The value which will be set
     */
    inline void setDisconnectedbyap (bool disconnectedbyap_);

    // API of field "reason"

    static const int kReason = 3;

    /**
     * Clears the field "reason".
     *
     * The field will be set to its default value. The hasReason()
     * method will return false.
     */
    inline void clearReason();

    /**
     * Checks whether the field "reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReason()). Otherwise it will return false.
     */
    inline bool hasReason () const;

    /**
     * Returns the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reason"
     */
    inline uint16 getReason () const;

    /**
     * Sets the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @param reason The value which will be set
     */
    inline void setReason (uint16 reason_);

    // API of field "ifname"

    static const int kIfname = 4;

    /**
     * Clears the field "ifname".
     *
     * The field will be set to its default value. The hasIfname()
     * method will return false.
     */
    inline void clearIfname();

    /**
     * Checks whether the field "ifname" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIfname()). Otherwise it will return false.
     */
    inline bool hasIfname () const;

    /**
     * Returns the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ifname"
     */
    inline const ::std::string& getIfname () const;

    /**
     * Retrieves the value of the field "ifname" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ifname".
     */
    inline ::std::string& getIfnameMutable ();

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const ::std::string& ifname_);

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const char* ifname_);

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const char* value, size_t size);

    /**
     * Release the object stored in the field "ifname".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ifname"
     */
    inline ::std::string* releaseIfname();

    /**
     * Replace the field "ifname".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceIfname (::std::string* ifname_);

    static const MlmeEventDisconnect &getDefaultInstance();

private:

    inline void set_has_ieee80211index ();

    inline void clear_has_ieee80211index ();

    inline void set_has_ifindex ();

    inline void clear_has_ifindex ();

    inline void set_has_disconnectedbyap ();

    inline void clear_has_disconnectedbyap ();

    inline void set_has_reason ();

    inline void clear_has_reason ();

    inline void set_has_ifname ();

    inline void clear_has_ifname ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _ieee80211index;

    uint32 _ifindex;

    bool _disconnectedbyap;

    uint16 _reason;

    ::std::string* _ifname;

};

inline  MlmeEventConnect::MlmeEventConnect ()  :
    _ieee80211index (0u),
    _ifindex (0u),
    _bssid (NULL),
    _statuscode (0u),
    _timedout (false),
    _ifname (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MlmeEventConnect::MlmeEventConnect (const MlmeEventConnect &rhs)  :
    _ieee80211index (0u),
    _ifindex (0u),
    _bssid (NULL),
    _statuscode (0u),
    _timedout (false),
    _ifname (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MlmeEventConnect::MlmeEventConnect (uint32 ieee80211index_, uint32 ifindex_, const ::std::string& bssid_, uint16 statuscode_, bool timedout_, const ::std::string& ifname_)  :
    _ieee80211index (ieee80211index_),
    _ifindex (ifindex_),
    _bssid (new ::std::string(bssid_)),
    _statuscode (statuscode_),
    _timedout (timedout_),
    _ifname (new ::std::string(ifname_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bssid_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MlmeEventConnect::~MlmeEventConnect() {
    delete _bssid;
    delete _ifname;
}

inline MlmeEventConnect& MlmeEventConnect::operator = (const MlmeEventConnect& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIeee80211index()) {
            setIeee80211index(rhs.getIeee80211index());
        } else {
            clearIeee80211index();
        }
        if (rhs.hasIfindex()) {
            setIfindex(rhs.getIfindex());
        } else {
            clearIfindex();
        }
        if (rhs.hasBssid()) {
            setBssid(rhs.getBssid());
        } else {
            clearBssid();
        }
        if (rhs.hasStatuscode()) {
            setStatuscode(rhs.getStatuscode());
        } else {
            clearStatuscode();
        }
        if (rhs.hasTimedout()) {
            setTimedout(rhs.getTimedout());
        } else {
            clearTimedout();
        }
        if (rhs.hasIfname()) {
            setIfname(rhs.getIfname());
        } else {
            clearIfname();
        }
    }
    return *this;
}

inline bool MlmeEventConnect::operator == (const MlmeEventConnect& rhs) const {
    return (((!hasIeee80211index() && !rhs.hasIeee80211index()) || getIeee80211index() == rhs.getIeee80211index()) &&
        ((!hasIfindex() && !rhs.hasIfindex()) || getIfindex() == rhs.getIfindex()) &&
        ((!hasBssid() && !rhs.hasBssid()) || getBssid() == rhs.getBssid()) &&
        ((!hasStatuscode() && !rhs.hasStatuscode()) || getStatuscode() == rhs.getStatuscode()) &&
        ((!hasTimedout() && !rhs.hasTimedout()) || getTimedout() == rhs.getTimedout()) &&
        ((!hasIfname() && !rhs.hasIfname()) || getIfname() == rhs.getIfname()));
}

inline bool MlmeEventConnect::operator != (const MlmeEventConnect& rhs) const {
    return ! (*this == rhs);
}

inline bool MlmeEventConnect::operator < (const MlmeEventConnect& rhs) const {
    if (hasIeee80211index() || rhs.hasIeee80211index()) {
        if (getIeee80211index() < rhs.getIeee80211index()) return true;
        if (getIeee80211index() > rhs.getIeee80211index()) return false;
    }
    if (hasIfindex() || rhs.hasIfindex()) {
        if (getIfindex() < rhs.getIfindex()) return true;
        if (getIfindex() > rhs.getIfindex()) return false;
    }
    if (hasBssid() || rhs.hasBssid()) {
        if (getBssid() < rhs.getBssid()) return true;
        if (getBssid() > rhs.getBssid()) return false;
    }
    if (hasStatuscode() || rhs.hasStatuscode()) {
        if (getStatuscode() < rhs.getStatuscode()) return true;
        if (getStatuscode() > rhs.getStatuscode()) return false;
    }
    if (hasTimedout() || rhs.hasTimedout()) {
        if (getTimedout() < rhs.getTimedout()) return true;
        if (getTimedout() > rhs.getTimedout()) return false;
    }
    if (hasIfname() || rhs.hasIfname()) {
        if (getIfname() < rhs.getIfname()) return true;
        if (getIfname() > rhs.getIfname()) return false;
    }
    return false;
}

inline bool MlmeEventConnect::operator > (const MlmeEventConnect& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MlmeEventConnect::clear() {
    clearIeee80211index();
    clearIfindex();
    clearBssid();
    clearStatuscode();
    clearTimedout();
    clearIfname();
}

inline void MlmeEventConnect::clearIeee80211index() {
    if (hasIeee80211index()) {
         clear_has_ieee80211index();
        _ieee80211index = 0u;
     }
}

inline bool MlmeEventConnect::hasIeee80211index () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 MlmeEventConnect::getIeee80211index () const {
    return _ieee80211index;
}

inline void MlmeEventConnect::setIeee80211index (uint32 ieee80211index_) {
    set_has_ieee80211index();
    this->_ieee80211index = ieee80211index_;
}

inline void MlmeEventConnect::clearIfindex() {
    if (hasIfindex()) {
         clear_has_ifindex();
        _ifindex = 0u;
     }
}

inline bool MlmeEventConnect::hasIfindex () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 MlmeEventConnect::getIfindex () const {
    return _ifindex;
}

inline void MlmeEventConnect::setIfindex (uint32 ifindex_) {
    set_has_ifindex();
    this->_ifindex = ifindex_;
}

inline void MlmeEventConnect::clearBssid() {
    if (hasBssid()) {
         clear_has_bssid();
        if (_bssid != NULL) {
            _bssid->clear();
        }
     }
}

inline bool MlmeEventConnect::hasBssid () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& MlmeEventConnect::getBssid () const {
    if (_bssid == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_bssid;
}

inline ::std::string& MlmeEventConnect::getBssidMutable () {
    set_has_bssid();
    if (_bssid == NULL) {
        _bssid = new ::std::string ();
        CHECK_ALLOCATION( _bssid );
    }
    return *_bssid;
}

inline void MlmeEventConnect::setBssid (const ::std::string& bssid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bssid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bssid();
    if (this->_bssid == NULL) {
        this->_bssid = new ::std::string (bssid_);
        CHECK_ALLOCATION( this->_bssid );
    } else {
        *this->_bssid = bssid_;
    }
}

inline void MlmeEventConnect::setBssid (const char* bssid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bssid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bssid();
    if (this->_bssid == NULL) {
        this->_bssid = new ::std::string (bssid_);
        CHECK_ALLOCATION( this->_bssid );
    } else {
        this->_bssid->assign(bssid_);
    }
}

inline void MlmeEventConnect::setBssid (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bssid();
    if (this->_bssid == NULL) {
        this->_bssid = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_bssid );
    } else {
        this->_bssid->assign(value, size);
    }
}

inline ::std::string* MlmeEventConnect::releaseBssid() {
    clear_has_bssid();
    ::std::string* temp = _bssid;
    this->_bssid = NULL;
    return temp;
}

inline void MlmeEventConnect::replaceBssid (::std::string* bssid_) {
    set_has_bssid();
    if (this->_bssid != bssid_) {
        if (this->_bssid != NULL) {
            delete this->_bssid;
        }
        this->_bssid = bssid_;
    }
}

inline void MlmeEventConnect::clearStatuscode() {
    if (hasStatuscode()) {
         clear_has_statuscode();
        _statuscode = 0u;
     }
}

inline bool MlmeEventConnect::hasStatuscode () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 MlmeEventConnect::getStatuscode () const {
    return _statuscode;
}

inline void MlmeEventConnect::setStatuscode (uint16 statuscode_) {
    set_has_statuscode();
    this->_statuscode = statuscode_;
}

inline void MlmeEventConnect::clearTimedout() {
    if (hasTimedout()) {
         clear_has_timedout();
        _timedout = false;
     }
}

inline bool MlmeEventConnect::hasTimedout () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool MlmeEventConnect::getTimedout () const {
    return _timedout;
}

inline void MlmeEventConnect::setTimedout (bool timedout_) {
    set_has_timedout();
    this->_timedout = timedout_;
}

inline void MlmeEventConnect::clearIfname() {
    if (hasIfname()) {
         clear_has_ifname();
        if (_ifname != NULL) {
            _ifname->clear();
        }
     }
}

inline bool MlmeEventConnect::hasIfname () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& MlmeEventConnect::getIfname () const {
    if (_ifname == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_ifname;
}

inline ::std::string& MlmeEventConnect::getIfnameMutable () {
    set_has_ifname();
    if (_ifname == NULL) {
        _ifname = new ::std::string ();
        CHECK_ALLOCATION( _ifname );
    }
    return *_ifname;
}

inline void MlmeEventConnect::setIfname (const ::std::string& ifname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (ifname_);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        *this->_ifname = ifname_;
    }
}

inline void MlmeEventConnect::setIfname (const char* ifname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (ifname_);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        this->_ifname->assign(ifname_);
    }
}

inline void MlmeEventConnect::setIfname (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        this->_ifname->assign(value, size);
    }
}

inline ::std::string* MlmeEventConnect::releaseIfname() {
    clear_has_ifname();
    ::std::string* temp = _ifname;
    this->_ifname = NULL;
    return temp;
}

inline void MlmeEventConnect::replaceIfname (::std::string* ifname_) {
    set_has_ifname();
    if (this->_ifname != ifname_) {
        if (this->_ifname != NULL) {
            delete this->_ifname;
        }
        this->_ifname = ifname_;
    }
}

inline void MlmeEventConnect::set_has_ieee80211index () {
    _has_bits_[0] |= 1u << 0;
}

inline void MlmeEventConnect::clear_has_ieee80211index () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MlmeEventConnect::set_has_ifindex () {
    _has_bits_[0] |= 1u << 1;
}

inline void MlmeEventConnect::clear_has_ifindex () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void MlmeEventConnect::set_has_bssid () {
    _has_bits_[0] |= 1u << 2;
}

inline void MlmeEventConnect::clear_has_bssid () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void MlmeEventConnect::set_has_statuscode () {
    _has_bits_[0] |= 1u << 3;
}

inline void MlmeEventConnect::clear_has_statuscode () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void MlmeEventConnect::set_has_timedout () {
    _has_bits_[0] |= 1u << 4;
}

inline void MlmeEventConnect::clear_has_timedout () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void MlmeEventConnect::set_has_ifname () {
    _has_bits_[0] |= 1u << 5;
}

inline void MlmeEventConnect::clear_has_ifname () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  MlmeEventDisconnect::MlmeEventDisconnect ()  :
    _ieee80211index (0u),
    _ifindex (0u),
    _disconnectedbyap (false),
    _reason (0u),
    _ifname (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MlmeEventDisconnect::MlmeEventDisconnect (const MlmeEventDisconnect &rhs)  :
    _ieee80211index (0u),
    _ifindex (0u),
    _disconnectedbyap (false),
    _reason (0u),
    _ifname (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MlmeEventDisconnect::MlmeEventDisconnect (uint32 ieee80211index_, uint32 ifindex_, bool disconnectedbyap_, uint16 reason_, const ::std::string& ifname_)  :
    _ieee80211index (ieee80211index_),
    _ifindex (ifindex_),
    _disconnectedbyap (disconnectedbyap_),
    _reason (reason_),
    _ifname (new ::std::string(ifname_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MlmeEventDisconnect::~MlmeEventDisconnect() {
    delete _ifname;
}

inline MlmeEventDisconnect& MlmeEventDisconnect::operator = (const MlmeEventDisconnect& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIeee80211index()) {
            setIeee80211index(rhs.getIeee80211index());
        } else {
            clearIeee80211index();
        }
        if (rhs.hasIfindex()) {
            setIfindex(rhs.getIfindex());
        } else {
            clearIfindex();
        }
        if (rhs.hasDisconnectedbyap()) {
            setDisconnectedbyap(rhs.getDisconnectedbyap());
        } else {
            clearDisconnectedbyap();
        }
        if (rhs.hasReason()) {
            setReason(rhs.getReason());
        } else {
            clearReason();
        }
        if (rhs.hasIfname()) {
            setIfname(rhs.getIfname());
        } else {
            clearIfname();
        }
    }
    return *this;
}

inline bool MlmeEventDisconnect::operator == (const MlmeEventDisconnect& rhs) const {
    return (((!hasIeee80211index() && !rhs.hasIeee80211index()) || getIeee80211index() == rhs.getIeee80211index()) &&
        ((!hasIfindex() && !rhs.hasIfindex()) || getIfindex() == rhs.getIfindex()) &&
        ((!hasDisconnectedbyap() && !rhs.hasDisconnectedbyap()) || getDisconnectedbyap() == rhs.getDisconnectedbyap()) &&
        ((!hasReason() && !rhs.hasReason()) || getReason() == rhs.getReason()) &&
        ((!hasIfname() && !rhs.hasIfname()) || getIfname() == rhs.getIfname()));
}

inline bool MlmeEventDisconnect::operator != (const MlmeEventDisconnect& rhs) const {
    return ! (*this == rhs);
}

inline bool MlmeEventDisconnect::operator < (const MlmeEventDisconnect& rhs) const {
    if (hasIeee80211index() || rhs.hasIeee80211index()) {
        if (getIeee80211index() < rhs.getIeee80211index()) return true;
        if (getIeee80211index() > rhs.getIeee80211index()) return false;
    }
    if (hasIfindex() || rhs.hasIfindex()) {
        if (getIfindex() < rhs.getIfindex()) return true;
        if (getIfindex() > rhs.getIfindex()) return false;
    }
    if (hasDisconnectedbyap() || rhs.hasDisconnectedbyap()) {
        if (getDisconnectedbyap() < rhs.getDisconnectedbyap()) return true;
        if (getDisconnectedbyap() > rhs.getDisconnectedbyap()) return false;
    }
    if (hasReason() || rhs.hasReason()) {
        if (getReason() < rhs.getReason()) return true;
        if (getReason() > rhs.getReason()) return false;
    }
    if (hasIfname() || rhs.hasIfname()) {
        if (getIfname() < rhs.getIfname()) return true;
        if (getIfname() > rhs.getIfname()) return false;
    }
    return false;
}

inline bool MlmeEventDisconnect::operator > (const MlmeEventDisconnect& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MlmeEventDisconnect::clear() {
    clearIeee80211index();
    clearIfindex();
    clearDisconnectedbyap();
    clearReason();
    clearIfname();
}

inline void MlmeEventDisconnect::clearIeee80211index() {
    if (hasIeee80211index()) {
         clear_has_ieee80211index();
        _ieee80211index = 0u;
     }
}

inline bool MlmeEventDisconnect::hasIeee80211index () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 MlmeEventDisconnect::getIeee80211index () const {
    return _ieee80211index;
}

inline void MlmeEventDisconnect::setIeee80211index (uint32 ieee80211index_) {
    set_has_ieee80211index();
    this->_ieee80211index = ieee80211index_;
}

inline void MlmeEventDisconnect::clearIfindex() {
    if (hasIfindex()) {
         clear_has_ifindex();
        _ifindex = 0u;
     }
}

inline bool MlmeEventDisconnect::hasIfindex () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 MlmeEventDisconnect::getIfindex () const {
    return _ifindex;
}

inline void MlmeEventDisconnect::setIfindex (uint32 ifindex_) {
    set_has_ifindex();
    this->_ifindex = ifindex_;
}

inline void MlmeEventDisconnect::clearDisconnectedbyap() {
    if (hasDisconnectedbyap()) {
         clear_has_disconnectedbyap();
        _disconnectedbyap = false;
     }
}

inline bool MlmeEventDisconnect::hasDisconnectedbyap () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool MlmeEventDisconnect::getDisconnectedbyap () const {
    return _disconnectedbyap;
}

inline void MlmeEventDisconnect::setDisconnectedbyap (bool disconnectedbyap_) {
    set_has_disconnectedbyap();
    this->_disconnectedbyap = disconnectedbyap_;
}

inline void MlmeEventDisconnect::clearReason() {
    if (hasReason()) {
         clear_has_reason();
        _reason = 0u;
     }
}

inline bool MlmeEventDisconnect::hasReason () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 MlmeEventDisconnect::getReason () const {
    return _reason;
}

inline void MlmeEventDisconnect::setReason (uint16 reason_) {
    set_has_reason();
    this->_reason = reason_;
}

inline void MlmeEventDisconnect::clearIfname() {
    if (hasIfname()) {
         clear_has_ifname();
        if (_ifname != NULL) {
            _ifname->clear();
        }
     }
}

inline bool MlmeEventDisconnect::hasIfname () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& MlmeEventDisconnect::getIfname () const {
    if (_ifname == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_ifname;
}

inline ::std::string& MlmeEventDisconnect::getIfnameMutable () {
    set_has_ifname();
    if (_ifname == NULL) {
        _ifname = new ::std::string ();
        CHECK_ALLOCATION( _ifname );
    }
    return *_ifname;
}

inline void MlmeEventDisconnect::setIfname (const ::std::string& ifname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (ifname_);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        *this->_ifname = ifname_;
    }
}

inline void MlmeEventDisconnect::setIfname (const char* ifname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (ifname_);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        this->_ifname->assign(ifname_);
    }
}

inline void MlmeEventDisconnect::setIfname (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        this->_ifname->assign(value, size);
    }
}

inline ::std::string* MlmeEventDisconnect::releaseIfname() {
    clear_has_ifname();
    ::std::string* temp = _ifname;
    this->_ifname = NULL;
    return temp;
}

inline void MlmeEventDisconnect::replaceIfname (::std::string* ifname_) {
    set_has_ifname();
    if (this->_ifname != ifname_) {
        if (this->_ifname != NULL) {
            delete this->_ifname;
        }
        this->_ifname = ifname_;
    }
}

inline void MlmeEventDisconnect::set_has_ieee80211index () {
    _has_bits_[0] |= 1u << 0;
}

inline void MlmeEventDisconnect::clear_has_ieee80211index () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MlmeEventDisconnect::set_has_ifindex () {
    _has_bits_[0] |= 1u << 1;
}

inline void MlmeEventDisconnect::clear_has_ifindex () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void MlmeEventDisconnect::set_has_disconnectedbyap () {
    _has_bits_[0] |= 1u << 2;
}

inline void MlmeEventDisconnect::clear_has_disconnectedbyap () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void MlmeEventDisconnect::set_has_reason () {
    _has_bits_[0] |= 1u << 3;
}

inline void MlmeEventDisconnect::clear_has_reason () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void MlmeEventDisconnect::set_has_ifname () {
    _has_bits_[0] |= 1u << 4;
}

inline void MlmeEventDisconnect::clear_has_ifname () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace WBLMlmeTypes
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBLMLMETYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
