/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBLASFSERVICESTUBCONNECTOR_H
#define ORG_BOSCH_WBLASFSERVICESTUBCONNECTOR_H

#include "asf/cms/CmsServiceConnector.h"
#include "asf/cms/CmsTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/WBLASFService.h"
#include "org/bosch/WBLASFServiceJson.h"
#include "org/bosch/WBLASFServiceStub.h"

namespace org {
namespace bosch {
namespace WBLASFService {

// Declaration of symbol '...' hides symbol

class WBLASFServiceStubConnector : public ::asf::cms::CmsServiceConnector
{
public:

    WBLASFServiceStubConnector () {
        initialize();
    }

    virtual ~WBLASFServiceStubConnector() {}


    void onStarteventloopRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< StarteventloopRequest >  payload = ::boost::static_pointer_cast< StarteventloopRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new StarteventloopRequest());
        }
        payload->setAct(msg.getAct());
        WBLASFServiceStub* pStub = static_cast<WBLASFServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "Starteventloop", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onStarteventloopRequest (payload);
    }


    void onSetpropertyRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< SetpropertyRequest >  payload = ::boost::static_pointer_cast< SetpropertyRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new SetpropertyRequest());
        }
        payload->setAct(msg.getAct());
        WBLASFServiceStub* pStub = static_cast<WBLASFServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "Setproperty", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onSetpropertyRequest (payload);
    }

    void onCurrentRegSettingsGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< CurrentRegSettingsGet >  payload = ::boost::static_pointer_cast< CurrentRegSettingsGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new CurrentRegSettingsGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "CurrentRegSettings", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WBLASFServiceStub*>(_stub)->onCurrentRegSettingsGet(payload);
    }

    void onCurrentRegSettingsRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "CurrentRegSettings", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WBLASFServiceStub*>(_stub)->onCurrentRegSettingsRegister(isFirst, msg.getAct());
    }

    void onCurrentRegSettingsDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "CurrentRegSettings", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WBLASFServiceStub*>(_stub)->onCurrentRegSettingsDeregister(isLast, msg.getAct());
    }

    void onMediaConnectedGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< MediaConnectedGet >  payload = ::boost::static_pointer_cast< MediaConnectedGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new MediaConnectedGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "MediaConnected", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WBLASFServiceStub*>(_stub)->onMediaConnectedGet(payload);
    }

    void onMediaConnectedRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "MediaConnected", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WBLASFServiceStub*>(_stub)->onMediaConnectedRegister(isFirst, msg.getAct());
    }

    void onMediaConnectedDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "MediaConnected", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WBLASFServiceStub*>(_stub)->onMediaConnectedDeregister(isLast, msg.getAct());
    }

    void onMediaDisconnectedGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< MediaDisconnectedGet >  payload = ::boost::static_pointer_cast< MediaDisconnectedGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new MediaDisconnectedGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "MediaDisconnected", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WBLASFServiceStub*>(_stub)->onMediaDisconnectedGet(payload);
    }

    void onMediaDisconnectedRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "MediaDisconnected", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WBLASFServiceStub*>(_stub)->onMediaDisconnectedRegister(isFirst, msg.getAct());
    }

    void onMediaDisconnectedDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WBLASFServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "MediaDisconnected", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WBLASFServiceStub*>(_stub)->onMediaDisconnectedDeregister(isLast, msg.getAct());
    }

    void initialize () {
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "starteventloop", (MsgFunction) &WBLASFServiceStubConnector::onStarteventloopRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "setproperty", (MsgFunction) &WBLASFServiceStubConnector::onSetpropertyRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "currentRegSettings", (MsgFunction) &WBLASFServiceStubConnector::onCurrentRegSettingsGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "currentRegSettings", (MsgFunction) &WBLASFServiceStubConnector::onCurrentRegSettingsRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "currentRegSettings", (MsgFunction) &WBLASFServiceStubConnector::onCurrentRegSettingsDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "mediaConnected", (MsgFunction) &WBLASFServiceStubConnector::onMediaConnectedGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "mediaConnected", (MsgFunction) &WBLASFServiceStubConnector::onMediaConnectedRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "mediaConnected", (MsgFunction) &WBLASFServiceStubConnector::onMediaConnectedDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "mediaDisconnected", (MsgFunction) &WBLASFServiceStubConnector::onMediaDisconnectedGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "mediaDisconnected", (MsgFunction) &WBLASFServiceStubConnector::onMediaDisconnectedRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "mediaDisconnected", (MsgFunction) &WBLASFServiceStubConnector::onMediaDisconnectedDeregister);
    }

};

} // namespace WBLASFService
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBLASFSERVICESTUBCONNECTOR_H
