/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBLASFSERVICESTUB_H
#define ORG_BOSCH_WBLASFSERVICESTUB_H

#include "asf/cms/CmsStubDelegate.h"
#include "asf/core/Logger.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/WBLASFService.h"
#include "org/bosch/WBLMlmeTypes.h"
#include "org/bosch/WBLRegulatoryTypes.h"

namespace org {
namespace bosch {
namespace WBLASFService {

/**
 * If the meaning of "WBLASFService" isn't clear, then there should be a description here.
 */

class WBLASFServiceStubConnector;

/**
 * The WBLASFServiceStub is the hook to implement the WBLASFService. It is
 * necessary to derive from this class and implement the pure virtual
 * functions. That's the way to add the functionality to the service.
 */
class WBLASFServiceStub : public ::asf::core::Stub
{
public:
    /**
     * The derived class has to pass the port name to the WBLASFServiceStub.
     * The port name is defined in the "Car Multimedia Component" model.
     */
    WBLASFServiceStub (const std::string& portName);

    virtual ~WBLASFServiceStub();

    // request starteventloop

    /**
     * This function will be called if the component receives the client
     * request "starteventloopRequest". The service implementation has to
     * process the request and send the response with
     * sendStarteventloopResponse().
     *
     * <b>Documentation of 'starteventloop'</b>:
     *
     * If the meaning of "starteventloop" isn't clear, then there should be a description here.
     */
    virtual void onStarteventloopRequest (const ::boost::shared_ptr< StarteventloopRequest >& starteventloop) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onStarteventloopRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'starteventloop'</b>:
     *
     * If the meaning of "starteventloop" isn't clear, then there should be a description here.
     */
    void sendStarteventloopResponse (act_t act = 0);

    // request setproperty

    /**
     * This function will be called if the component receives the client
     * request "setpropertyRequest". The service implementation has to process
     * the request and send the response with sendSetpropertyResponse().
     *
     * <b>Documentation of 'setproperty'</b>:
     *
     * If the meaning of "setproperty" isn't clear, then there should be a description here.
     */
    virtual void onSetpropertyRequest (const ::boost::shared_ptr< SetpropertyRequest >& setproperty) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onSetpropertyRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'setproperty'</b>:
     *
     * If the meaning of "setproperty" isn't clear, then there should be a description here.
     */
    void sendSetpropertyResponse (bool data, act_t act = 0);

    // property currentRegSettings

    /**
     * This function will be called if the component receives a "registration"
     * message for the property CurrentRegSettings. The default implementation
     * sends back a notification message  with the current content of the
     * property. It is possible to override the function, if the user wants to
     * react on the registration event of the property. In this case it is
     * necessary to send the notification manually. Use the function
     * sendCurrentRegSettingsUpdate(). The parameter isFirst is true if the
     * count of the registered clients is one otherwise the parameter is
     * false.
     *
     * <b>Documentation of 'currentRegSettings'</b>:
     *
     * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onCurrentRegSettingsRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property CurrentRegSettings.  The
     * default implementation does nothing. It is possible to override the
     * function, if the user wants to react on the deregistration. The
     * parameter isLast is false if no client is registered anymore, otherwise
     * it's true.
     *
     * <b>Documentation of 'currentRegSettings'</b>:
     *
     * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onCurrentRegSettingsDeregister(bool /*isLast*/, act_t act);

    void sendCurrentRegSettingsUpdate(const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data, act_t act);

    void sendCurrentRegSettingsGetUpdate(const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'currentRegSettings'</b>:
     *
     * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onCurrentRegSettingsGet(const ::boost::shared_ptr< CurrentRegSettingsGet >& currentRegSettings);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'currentRegSettings'</b>:
     *
     * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setCurrentRegSettings(const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data);

    const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& getCurrentRegSettings() const;

    ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& getCurrentRegSettingsMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property CurrentRegSettings.
     *
     * <b>Documentation of 'currentRegSettings'</b>:
     *
     * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
     */
    void sendCurrentRegSettingsNotification();

    // property mediaConnected

    /**
     * This function will be called if the component receives a "registration"
     * message for the property MediaConnected. The default implementation
     * sends back a notification message  with the current content of the
     * property. It is possible to override the function, if the user wants to
     * react on the registration event of the property. In this case it is
     * necessary to send the notification manually. Use the function
     * sendMediaConnectedUpdate(). The parameter isFirst is true if the count
     * of the registered clients is one otherwise the parameter is false.
     *
     * <b>Documentation of 'mediaConnected'</b>:
     *
     * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onMediaConnectedRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property MediaConnected.  The default
     * implementation does nothing. It is possible to override the function,
     * if the user wants to react on the deregistration. The parameter isLast
     * is false if no client is registered anymore, otherwise it's true.
     *
     * <b>Documentation of 'mediaConnected'</b>:
     *
     * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onMediaConnectedDeregister(bool /*isLast*/, act_t act);

    void sendMediaConnectedUpdate(const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data, act_t act);

    void sendMediaConnectedGetUpdate(const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'mediaConnected'</b>:
     *
     * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onMediaConnectedGet(const ::boost::shared_ptr< MediaConnectedGet >& mediaConnected);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'mediaConnected'</b>:
     *
     * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setMediaConnected(const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data);

    const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& getMediaConnected() const;

    ::org::bosch::WBLMlmeTypes::MlmeEventConnect& getMediaConnectedMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property MediaConnected.
     *
     * <b>Documentation of 'mediaConnected'</b>:
     *
     * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
     */
    void sendMediaConnectedNotification();

    // property mediaDisconnected

    /**
     * This function will be called if the component receives a "registration"
     * message for the property MediaDisconnected. The default implementation
     * sends back a notification message  with the current content of the
     * property. It is possible to override the function, if the user wants to
     * react on the registration event of the property. In this case it is
     * necessary to send the notification manually. Use the function
     * sendMediaDisconnectedUpdate(). The parameter isFirst is true if the
     * count of the registered clients is one otherwise the parameter is
     * false.
     *
     * <b>Documentation of 'mediaDisconnected'</b>:
     *
     * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onMediaDisconnectedRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property MediaDisconnected.  The
     * default implementation does nothing. It is possible to override the
     * function, if the user wants to react on the deregistration. The
     * parameter isLast is false if no client is registered anymore, otherwise
     * it's true.
     *
     * <b>Documentation of 'mediaDisconnected'</b>:
     *
     * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onMediaDisconnectedDeregister(bool /*isLast*/, act_t act);

    void sendMediaDisconnectedUpdate(const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data, act_t act);

    void sendMediaDisconnectedGetUpdate(const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'mediaDisconnected'</b>:
     *
     * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onMediaDisconnectedGet(const ::boost::shared_ptr< MediaDisconnectedGet >& mediaDisconnected);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'mediaDisconnected'</b>:
     *
     * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setMediaDisconnected(const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data);

    const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& getMediaDisconnected() const;

    ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& getMediaDisconnectedMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property MediaDisconnected.
     *
     * <b>Documentation of 'mediaDisconnected'</b>:
     *
     * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
     */
    void sendMediaDisconnectedNotification();

private:
    WBLASFServiceStub(const WBLASFServiceStub&);

    WBLASFServiceStub& operator=(const WBLASFServiceStub&);




    CurrentRegSettingsUpdate _currentRegSettingsProperty;


    MediaConnectedUpdate _mediaConnectedProperty;


    MediaDisconnectedUpdate _mediaDisconnectedProperty;

    WBLASFServiceStubConnector* _stubConnector;

    ::asf::cms::CmsStubDelegate* _cmsStubDelegate;

    DECLARE_CLASS_LOGGER();

    friend class WBLASFServiceStubConnector;
};

} // namespace WBLASFService
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBLASFSERVICESTUB_H
