/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "org/bosch/WBLASFComponent.h"
#include "org/bosch/WBLASFServiceComponent.h"
#include "org/bosch/Wbl.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "Wbl" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {

DEFINE_LOGGER_AND_LEVEL (_logger, "/org/bosch/Wbl", Info);

/* static */ const char* Wbl::wblASFComponent = "wblASFComponent";
/* static */ const char* Wbl::wblASFServiceComponent = "wblASFServiceComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool Wbl_enabledASFSignalHandler = false;

void importWbl() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach Wbl, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'WBLThread'

    ::asf::core::ComponentContainerSharedPtr WBLThread(new ::asf::core::ComponentContainer("WBLThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (WBLThread);

        // Component 'WBLASFComponent wblASFComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::bosch::WBLASFComponent > > wblASFComponentFactory(new ::asf::core::ComponentFactory< ::org::bosch::WBLASFComponent >);
        ::asf::core::ComponentDescriptionSharedPtr wblASFComponentDescription(new ::asf::core::ComponentDescription(1, "wblASFComponent", /* immediate = */ true, /* threadBridge = */ false, wblASFComponentFactory));
        WBLThread->addComponentDescription(wblASFComponentDescription);

            // Port 'objectMgrPort'

            ::asf::core::ProvidedPort& wblASFComponent_objectMgrPort = wblASFComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.freedesktop.DBus.ObjectManager", "objectMgrPort", false, false));
            (void)wblASFComponent_objectMgrPort; // prevent unused variable warning

            // Port 'conflictmgrPort'

            ::asf::core::ProvidedPort& wblASFComponent_conflictmgrPort = wblASFComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.wbl.conflictmanagement", "conflictmgrPort", false, false));
            (void)wblASFComponent_conflictmgrPort; // prevent unused variable warning

            // Port 'lastintendedmodePort'

            ::asf::core::ProvidedPort& wblASFComponent_lastintendedmodePort = wblASFComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.wbl.LastIntendedMode", "lastintendedmodePort", false, false));
            (void)wblASFComponent_lastintendedmodePort; // prevent unused variable warning

            // Port 'wifisetupAPPort'

            ::asf::core::ProvidedPort& wblASFComponent_wifisetupAPPort = wblASFComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.wbl.wifisetup", "wifisetupAPPort", false, false));
            (void)wblASFComponent_wifisetupAPPort; // prevent unused variable warning

            // Port 'wifisetupSTAPort'

            ::asf::core::ProvidedPort& wblASFComponent_wifisetupSTAPort = wblASFComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.wbl.wifisetup", "wifisetupSTAPort", false, false));
            (void)wblASFComponent_wifisetupSTAPort; // prevent unused variable warning

            // Port 'regCCInfoPort'

            ::asf::core::ProvidedPort& wblASFComponent_regCCInfoPort = wblASFComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.wbl.Regulations", "regCCInfoPort", false, false));
            (void)wblASFComponent_regCCInfoPort; // prevent unused variable warning

            // Port 'connmanMgrPort'

            ::asf::core::RequiredPort& wblASFComponent_connmanMgrPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Manager", "connmanMgrPort"));
            (void)wblASFComponent_connmanMgrPort; // prevent unused variable warning

            // Port 'connmanTechPort'

            ::asf::core::RequiredPort& wblASFComponent_connmanTechPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Technology", "connmanTechPort", /* wired at runtime */ true));
            (void)wblASFComponent_connmanTechPort; // prevent unused variable warning

            // Port 'wapdmanMgrPort'

            ::asf::core::RequiredPort& wblASFComponent_wapdmanMgrPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.Manager", "wapdmanMgrPort"));
            (void)wblASFComponent_wapdmanMgrPort; // prevent unused variable warning

            // Port 'wapdmanAccesspointPort'

            ::asf::core::RequiredPort& wblASFComponent_wapdmanAccesspointPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.Accesspoint", "wapdmanAccesspointPort", /* wired at runtime */ true));
            (void)wblASFComponent_wapdmanAccesspointPort; // prevent unused variable warning

            // Port 'wapdmanDHCPDNSConfigurationPort'

            ::asf::core::RequiredPort& wblASFComponent_wapdmanDHCPDNSConfigurationPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.Accesspoint.DHCPDNSConfiguration", "wapdmanDHCPDNSConfigurationPort", /* wired at runtime */ true));
            (void)wblASFComponent_wapdmanDHCPDNSConfigurationPort; // prevent unused variable warning

            // Port 'wapdmanTetheringSettingsPort'

            ::asf::core::RequiredPort& wblASFComponent_wapdmanTetheringSettingsPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.Accesspoint.TetheringSettings", "wapdmanTetheringSettingsPort", /* wired at runtime */ true));
            (void)wblASFComponent_wapdmanTetheringSettingsPort; // prevent unused variable warning

            // Port 'wapdmanAssociatedStnPort'

            ::asf::core::RequiredPort& wblASFComponent_wapdmanAssociatedStnPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.AssociatedStation", "wapdmanAssociatedStnPort", /* wired at runtime */ true));
            (void)wblASFComponent_wapdmanAssociatedStnPort; // prevent unused variable warning

            // Port 'bluezAdapterPort'

            ::asf::core::RequiredPort& wblASFComponent_bluezAdapterPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.Adapter1", "bluezAdapterPort"));
            (void)wblASFComponent_bluezAdapterPort; // prevent unused variable warning

            // Port 'wpa_supplicant_port'

            ::asf::core::RequiredPort& wblASFComponent_wpa_supplicant_port = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("fi.w1.wpa_supplicant1", "wpa_supplicant_port"));
            (void)wblASFComponent_wpa_supplicant_port; // prevent unused variable warning

            // Port 'wpa_supplicant_iface_port'

            ::asf::core::RequiredPort& wblASFComponent_wpa_supplicant_iface_port = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("fi.w1.wpa_supplicant1.Interface", "wpa_supplicant_iface_port", /* wired at runtime */ true));
            (void)wblASFComponent_wpa_supplicant_iface_port; // prevent unused variable warning

            // Port 'connmanServicePort'

            ::asf::core::RequiredPort& wblASFComponent_connmanServicePort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Service", "connmanServicePort", /* wired at runtime */ true));
            (void)wblASFComponent_connmanServicePort; // prevent unused variable warning

            // Port 'wpa_supplicant_bss_port'

            ::asf::core::RequiredPort& wblASFComponent_wpa_supplicant_bss_port = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("fi.w1.wpa_supplicant1.BSS", "wpa_supplicant_bss_port", /* wired at runtime */ true));
            (void)wblASFComponent_wpa_supplicant_bss_port; // prevent unused variable warning

            // Port 'WBLServicePort'

            ::asf::core::RequiredPort& wblASFComponent_WBLServicePort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.WBLASFService", "WBLServicePort"));
            (void)wblASFComponent_WBLServicePort; // prevent unused variable warning

            // Port 'LCMPort'

            ::asf::core::RequiredPort& wblASFComponent_LCMPort = wblASFComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", "LCMPort"));
            (void)wblASFComponent_LCMPort; // prevent unused variable warning

    // Thread 'WBLServiceThread'

    ::asf::core::ComponentContainerSharedPtr WBLServiceThread(new ::asf::core::ComponentContainer("WBLServiceThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (WBLServiceThread);

        // Component 'WBLASFServiceComponent wblASFServiceComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::bosch::WBLASFServiceComponent > > wblASFServiceComponentFactory(new ::asf::core::ComponentFactory< ::org::bosch::WBLASFServiceComponent >);
        ::asf::core::ComponentDescriptionSharedPtr wblASFServiceComponentDescription(new ::asf::core::ComponentDescription(2, "wblASFServiceComponent", /* immediate = */ false, /* threadBridge = */ false, wblASFServiceComponentFactory));
        WBLServiceThread->addComponentDescription(wblASFServiceComponentDescription);

            // Port 'WBLServicePort'

            ::asf::core::ProvidedPort& wblASFServiceComponent_WBLServicePort = wblASFServiceComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.WBLASFService", "WBLServicePort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)wblASFServiceComponent_WBLServicePort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& connmanmgrService = dbusSystemConnector_->importByName (::std::string("net.connman"), ::std::string("/"));
    connmanmgrService.setServiceName("net.connman.Manager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (wblASFComponent_connmanMgrPort, connmanmgrService);

    // Expression

    ::asf::dbus::DBusImportedPort& wapdmanmgrService = dbusSystemConnector_->importByName (::std::string("org.bosch.wapdman"), ::std::string("/org/bosch/wapdman/Manager"));
    wapdmanmgrService.setServiceName("org.bosch.wapdman.Manager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (wblASFComponent_wapdmanMgrPort, wapdmanmgrService);

    // Expression

    ::asf::dbus::DBusImportedPort& bluezAdapterService = dbusSystemConnector_->importByName (::std::string("org.bluez"), ::std::string("/org/bluez/hci1"));
    bluezAdapterService.setServiceName("org.bluez.Adapter1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (wblASFComponent_bluezAdapterPort, bluezAdapterService);

    // Expression

    ::asf::dbus::DBusImportedPort& wpa_supplicant_service = dbusSystemConnector_->importByName (::std::string("fi.w1.wpa_supplicant1"), ::std::string("/fi/w1/wpa_supplicant1"));
    wpa_supplicant_service.setServiceName("fi.w1.wpa_supplicant1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (wblASFComponent_wpa_supplicant_port, wpa_supplicant_service);

    // Expression

    ::asf::dbus::DBusImportedPort& LCMService = dbusSystemConnector_->importByName (::std::string("org.bosch.cm.lcmccadbusgw.LcmccadbusgwAsf"), ::std::string("/com/bosch/cm/lcmccadbusgw/server/LcmDbusFi"));
    LCMService.setServiceName("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (wblASFComponent_LCMPort, LCMService);

    // Expression

    dbusSystemConnector_->exportByName (wblASFComponent_objectMgrPort, ::std::string("/"));

    // Expression

    dbusSystemConnector_->exportByName (wblASFComponent_conflictmgrPort, ::std::string("/org/bosch/wbl/conflictmanagement"));

    // Expression

    dbusSystemConnector_->exportByName (wblASFComponent_lastintendedmodePort, ::std::string("/org/bosch/wbl/LastIntendedMode"));

    // Expression

    dbusSystemConnector_->exportByName (wblASFComponent_wifisetupAPPort, ::std::string("/org/bosch/wbl/wlan1/wifisetup/AP"));

    // Expression

    dbusSystemConnector_->exportByName (wblASFComponent_wifisetupSTAPort, ::std::string("/org/bosch/wbl/wlan0/wifisetup/STA"));

    // Expression

    dbusSystemConnector_->exportByName (wblASFComponent_regCCInfoPort, ::std::string("/org/bosch/wbl/Regulations"));

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (wblASFComponent_WBLServicePort, wblASFServiceComponent_WBLServicePort);


    LOG_INFO_STATIC("Starting application 'Wbl' version 1.0.0");

    app->start();
}

int executeWbl(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("org.bosch", "Wbl");
    } else {
        ::asf::core::Logger::setupLogging ("org.bosch", "Wbl", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", Wbl_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("org.bosch", "Wbl", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create Wbl");

    app->enableExceptionHandler(false);

    importWbl();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace bosch
} // namespace org

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::org::bosch::executeWbl(argc, argv);
}

