/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef STUB_WAPDMANSERVICESTUBCONNECTOR_H
#define STUB_WAPDMANSERVICESTUBCONNECTOR_H

#include "Stub/WapdmanService.h"
#include "Stub/WapdmanServiceJson.h"
#include "Stub/WapdmanServiceStub.h"
#include "asf/cms/CmsServiceConnector.h"
#include "asf/cms/CmsTypesJson.h"
#include "boost/shared_ptr.hpp"

namespace Stub {
namespace WapdmanService {

// Declaration of symbol '...' hides symbol

class WapdmanServiceStubConnector : public ::asf::cms::CmsServiceConnector
{
public:

    WapdmanServiceStubConnector () {
        initialize();
    }

    virtual ~WapdmanServiceStubConnector() {}


    void onSetSSIDRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< SetSSIDRequest >  payload = ::boost::static_pointer_cast< SetSSIDRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new SetSSIDRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "SetSSID", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onSetSSIDRequest (payload);
    }


    void onDeAuthenticateStationRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< DeAuthenticateStationRequest >  payload = ::boost::static_pointer_cast< DeAuthenticateStationRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new DeAuthenticateStationRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "DeAuthenticateStation", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onDeAuthenticateStationRequest (payload);
    }


    void onBlacklistStationRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< BlacklistStationRequest >  payload = ::boost::static_pointer_cast< BlacklistStationRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new BlacklistStationRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "BlacklistStation", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onBlacklistStationRequest (payload);
    }


    void onSetOperatingChannelsRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< SetOperatingChannelsRequest >  payload = ::boost::static_pointer_cast< SetOperatingChannelsRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new SetOperatingChannelsRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "SetOperatingChannels", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onSetOperatingChannelsRequest (payload);
    }


    void onStartWPSPushButtonRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< StartWPSPushButtonRequest >  payload = ::boost::static_pointer_cast< StartWPSPushButtonRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new StartWPSPushButtonRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "StartWPSPushButton", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onStartWPSPushButtonRequest (payload);
    }


    void onCancelWPSRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< CancelWPSRequest >  payload = ::boost::static_pointer_cast< CancelWPSRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new CancelWPSRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "CancelWPS", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onCancelWPSRequest (payload);
    }


    void onRegisterVendorServiceRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< RegisterVendorServiceRequest >  payload = ::boost::static_pointer_cast< RegisterVendorServiceRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new RegisterVendorServiceRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "RegisterVendorService", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onRegisterVendorServiceRequest (payload);
    }


    void onUnregisterVendorServiceRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< UnregisterVendorServiceRequest >  payload = ::boost::static_pointer_cast< UnregisterVendorServiceRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new UnregisterVendorServiceRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "UnregisterVendorService", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onUnregisterVendorServiceRequest (payload);
    }


    void onGetAssociatedStationsRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< GetAssociatedStationsRequest >  payload = ::boost::static_pointer_cast< GetAssociatedStationsRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new GetAssociatedStationsRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "GetAssociatedStations", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onGetAssociatedStationsRequest (payload);
    }


    void onGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< GetRequest >  payload = ::boost::static_pointer_cast< GetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new GetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "Get", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onGetRequest (payload);
    }


    void onSSIDGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< SSIDGetRequest >  payload = ::boost::static_pointer_cast< SSIDGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new SSIDGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "SSIDGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onSSIDGetRequest (payload);
    }


    void onSecurityRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< SecurityRequest >  payload = ::boost::static_pointer_cast< SecurityRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new SecurityRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "Security", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onSecurityRequest (payload);
    }


    void onMacAddressGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< MacAddressGetRequest >  payload = ::boost::static_pointer_cast< MacAddressGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new MacAddressGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "MacAddressGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onMacAddressGetRequest (payload);
    }


    void onInterfaceGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< InterfaceGetRequest >  payload = ::boost::static_pointer_cast< InterfaceGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new InterfaceGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "InterfaceGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onInterfaceGetRequest (payload);
    }


    void onPassphraseGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< PassphraseGetRequest >  payload = ::boost::static_pointer_cast< PassphraseGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new PassphraseGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "PassphraseGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onPassphraseGetRequest (payload);
    }


    void onPoweredGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< PoweredGetRequest >  payload = ::boost::static_pointer_cast< PoweredGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new PoweredGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "PoweredGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onPoweredGetRequest (payload);
    }


    void onHiddenGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< HiddenGetRequest >  payload = ::boost::static_pointer_cast< HiddenGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new HiddenGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "HiddenGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onHiddenGetRequest (payload);
    }


    void onCurrentOperatingChannelGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< CurrentOperatingChannelGetRequest >  payload = ::boost::static_pointer_cast< CurrentOperatingChannelGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new CurrentOperatingChannelGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "CurrentOperatingChannelGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onCurrentOperatingChannelGetRequest (payload);
    }


    void onVendorIEsGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< VendorIEsGetRequest >  payload = ::boost::static_pointer_cast< VendorIEsGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new VendorIEsGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "VendorIEsGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onVendorIEsGetRequest (payload);
    }


    void onPoweredSetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< PoweredSetRequest >  payload = ::boost::static_pointer_cast< PoweredSetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new PoweredSetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "PoweredSet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onPoweredSetRequest (payload);
    }


    void onHiddenSetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< HiddenSetRequest >  payload = ::boost::static_pointer_cast< HiddenSetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new HiddenSetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "HiddenSet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onHiddenSetRequest (payload);
    }


    void onPassphraseSetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< PassphraseSetRequest >  payload = ::boost::static_pointer_cast< PassphraseSetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new PassphraseSetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "PassphraseSet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onPassphraseSetRequest (payload);
    }


    void onTetheringSetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< TetheringSetRequest >  payload = ::boost::static_pointer_cast< TetheringSetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new TetheringSetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "TetheringSet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onTetheringSetRequest (payload);
    }

    void onPowerStateGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< PowerStateGet >  payload = ::boost::static_pointer_cast< PowerStateGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new PowerStateGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "PowerState", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WapdmanServiceStub*>(_stub)->onPowerStateGet(payload);
    }

    void onPowerStateRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "PowerState", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onPowerStateRegister(isFirst, msg.getAct());
    }

    void onPowerStateDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "PowerState", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onPowerStateDeregister(isLast, msg.getAct());
    }

    void onPowerFailureReasonGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< PowerFailureReasonGet >  payload = ::boost::static_pointer_cast< PowerFailureReasonGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new PowerFailureReasonGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "PowerFailureReason", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WapdmanServiceStub*>(_stub)->onPowerFailureReasonGet(payload);
    }

    void onPowerFailureReasonRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "PowerFailureReason", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onPowerFailureReasonRegister(isFirst, msg.getAct());
    }

    void onPowerFailureReasonDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "PowerFailureReason", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onPowerFailureReasonDeregister(isLast, msg.getAct());
    }

    void onCurrentHwModeGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< CurrentHwModeGet >  payload = ::boost::static_pointer_cast< CurrentHwModeGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new CurrentHwModeGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "CurrentHwMode", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WapdmanServiceStub*>(_stub)->onCurrentHwModeGet(payload);
    }

    void onCurrentHwModeRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "CurrentHwMode", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onCurrentHwModeRegister(isFirst, msg.getAct());
    }

    void onCurrentHwModeDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "CurrentHwMode", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onCurrentHwModeDeregister(isLast, msg.getAct());
    }

    void onMaximumStationsAllowedGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< MaximumStationsAllowedGet >  payload = ::boost::static_pointer_cast< MaximumStationsAllowedGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new MaximumStationsAllowedGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "MaximumStationsAllowed", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WapdmanServiceStub*>(_stub)->onMaximumStationsAllowedGet(payload);
    }

    void onMaximumStationsAllowedRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "MaximumStationsAllowed", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onMaximumStationsAllowedRegister(isFirst, msg.getAct());
    }

    void onMaximumStationsAllowedDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "MaximumStationsAllowed", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onMaximumStationsAllowedDeregister(isLast, msg.getAct());
    }

    void onSupportedChannelsGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< SupportedChannelsGet >  payload = ::boost::static_pointer_cast< SupportedChannelsGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new SupportedChannelsGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "SupportedChannels", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WapdmanServiceStub*>(_stub)->onSupportedChannelsGet(payload);
    }

    void onSupportedChannelsRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "SupportedChannels", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onSupportedChannelsRegister(isFirst, msg.getAct());
    }

    void onSupportedChannelsDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "SupportedChannels", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onSupportedChannelsDeregister(isLast, msg.getAct());
    }

    void onHWFeaturesGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< HWFeaturesGet >  payload = ::boost::static_pointer_cast< HWFeaturesGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new HWFeaturesGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "HWFeatures", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WapdmanServiceStub*>(_stub)->onHWFeaturesGet(payload);
    }

    void onHWFeaturesRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "HWFeatures", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onHWFeaturesRegister(isFirst, msg.getAct());
    }

    void onHWFeaturesDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "HWFeatures", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onHWFeaturesDeregister(isLast, msg.getAct());
    }

    void onTetheringGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< TetheringGet >  payload = ::boost::static_pointer_cast< TetheringGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new TetheringGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "Tethering", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WapdmanServiceStub*>(_stub)->onTetheringGet(payload);
    }

    void onTetheringRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "Tethering", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onTetheringRegister(isFirst, msg.getAct());
    }

    void onTetheringDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "Tethering", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onTetheringDeregister(isLast, msg.getAct());
    }

    void onIPv4PoolGet (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< IPv4PoolGet >  payload = ::boost::static_pointer_cast< IPv4PoolGet >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new IPv4PoolGet());
        }
        payload->setAct(msg.getAct());
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sGet, act=%" PRIuPTR ", stub=%p", "IPv4Pool", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        static_cast<WapdmanServiceStub*>(_stub)->onIPv4PoolGet(payload);
    }

    void onIPv4PoolRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister, isFirst=%s, act=%d, stub=%p", "IPv4Pool", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onIPv4PoolRegister(isFirst, msg.getAct());
    }

    void onIPv4PoolDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast = (msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister, isLast=%s, act=%d, stub=%p", "IPv4Pool", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onIPv4PoolDeregister(isLast, msg.getAct());
    }


    void onGetAccessPointsRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< GetAccessPointsRequest >  payload = ::boost::static_pointer_cast< GetAccessPointsRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new GetAccessPointsRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "GetAccessPoints", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onGetAccessPointsRequest (payload);
    }


    void onRegisterAgentRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< RegisterAgentRequest >  payload = ::boost::static_pointer_cast< RegisterAgentRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new RegisterAgentRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "RegisterAgent", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onRegisterAgentRequest (payload);
    }


    void onUnregisterAgentRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< UnregisterAgentRequest >  payload = ::boost::static_pointer_cast< UnregisterAgentRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new UnregisterAgentRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "UnregisterAgent", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onUnregisterAgentRequest (payload);
    }


    void onFindAccessPointRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< FindAccessPointRequest >  payload = ::boost::static_pointer_cast< FindAccessPointRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new FindAccessPointRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "FindAccessPoint", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onFindAccessPointRequest (payload);
    }


    void onMacAddressAsGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< MacAddressAsGetRequest >  payload = ::boost::static_pointer_cast< MacAddressAsGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new MacAddressAsGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "MacAddressAsGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onMacAddressAsGetRequest (payload);
    }


    void onAccesspointAsGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< AccesspointAsGetRequest >  payload = ::boost::static_pointer_cast< AccesspointAsGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new AccesspointAsGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "AccesspointAsGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onAccesspointAsGetRequest (payload);
    }


    void onInterfaceAsGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< InterfaceAsGetRequest >  payload = ::boost::static_pointer_cast< InterfaceAsGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new InterfaceAsGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "InterfaceAsGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onInterfaceAsGetRequest (payload);
    }


    void onIPAddressAsGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< IPAddressAsGetRequest >  payload = ::boost::static_pointer_cast< IPAddressAsGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new IPAddressAsGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "IPAddressAsGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onIPAddressAsGetRequest (payload);
    }


    void onHostnameAsGetRequest (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        ::boost::shared_ptr< HostnameAsGetRequest >  payload = ::boost::static_pointer_cast< HostnameAsGetRequest >(msg.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (payload == 0) {
            payload.reset (new HostnameAsGetRequest());
        }
        payload->setAct(msg.getAct());
        WapdmanServiceStub* pStub = static_cast<WapdmanServiceStub*>(_stub);
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO ("<- on%sRequest, act=%" PRIuPTR ", stub=%p", "HostnameAsGet", payload->getAct(), _stub);
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        pStub->onHostnameAsGetRequest (payload);
    }

    void onAccessPointAddedRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst=(msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister isFirst=%s, act=%d, stub=%p", "AccessPointAdded", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onAccessPointAddedRegister(isFirst, msg.getAct());
    }

    void onAccessPointAddedDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast=(msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister isLast=%s, act=%d, stub=%p", "AccessPointAdded", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onAccessPointAddedDeregister(isLast, msg.getAct());
    }

    void onAccessPointRemovedRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst=(msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister isFirst=%s, act=%d, stub=%p", "AccessPointRemoved", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onAccessPointRemovedRegister(isFirst, msg.getAct());
    }

    void onAccessPointRemovedDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast=(msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister isLast=%s, act=%d, stub=%p", "AccessPointRemoved", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onAccessPointRemovedDeregister(isLast, msg.getAct());
    }

    void onAssociatedStationsChangedRegister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isFirst=(msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sRegister isFirst=%s, act=%d, stub=%p", "AssociatedStationsChanged", isFirst ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onAssociatedStationsChangedRegister(isFirst, msg.getAct());
    }

    void onAssociatedStationsChangedDeregister (::asf::cms::CmsMessage &msg) {
        SET_LOGGER (WapdmanServiceStub::_logger);
        LOG_ASSERT_FATAL(_stub);
        bool isLast=(msg.getRegistrationCount()==1);
        LOG_INFO ("<- on%sDeregister isLast=%s, act=%d, stub=%p", "AssociatedStationsChanged", isLast ? "true" : "false", msg.getAct(), _stub);
        static_cast<WapdmanServiceStub*>(_stub)->onAssociatedStationsChangedDeregister(isLast, msg.getAct());
    }

    void initialize () {
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "setSSID", (MsgFunction) &WapdmanServiceStubConnector::onSetSSIDRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "DeAuthenticateStation", (MsgFunction) &WapdmanServiceStubConnector::onDeAuthenticateStationRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "BlacklistStation", (MsgFunction) &WapdmanServiceStubConnector::onBlacklistStationRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "SetOperatingChannels", (MsgFunction) &WapdmanServiceStubConnector::onSetOperatingChannelsRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "StartWPSPushButton", (MsgFunction) &WapdmanServiceStubConnector::onStartWPSPushButtonRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "CancelWPS", (MsgFunction) &WapdmanServiceStubConnector::onCancelWPSRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "RegisterVendorService", (MsgFunction) &WapdmanServiceStubConnector::onRegisterVendorServiceRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "UnregisterVendorService", (MsgFunction) &WapdmanServiceStubConnector::onUnregisterVendorServiceRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "GetAssociatedStations", (MsgFunction) &WapdmanServiceStubConnector::onGetAssociatedStationsRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "Get", (MsgFunction) &WapdmanServiceStubConnector::onGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "SSIDGet", (MsgFunction) &WapdmanServiceStubConnector::onSSIDGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "Security", (MsgFunction) &WapdmanServiceStubConnector::onSecurityRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "MacAddressGet", (MsgFunction) &WapdmanServiceStubConnector::onMacAddressGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "InterfaceGet", (MsgFunction) &WapdmanServiceStubConnector::onInterfaceGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "PassphraseGet", (MsgFunction) &WapdmanServiceStubConnector::onPassphraseGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "PoweredGet", (MsgFunction) &WapdmanServiceStubConnector::onPoweredGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "HiddenGet", (MsgFunction) &WapdmanServiceStubConnector::onHiddenGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "CurrentOperatingChannelGet", (MsgFunction) &WapdmanServiceStubConnector::onCurrentOperatingChannelGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "VendorIEsGet", (MsgFunction) &WapdmanServiceStubConnector::onVendorIEsGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "PoweredSet", (MsgFunction) &WapdmanServiceStubConnector::onPoweredSetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "HiddenSet", (MsgFunction) &WapdmanServiceStubConnector::onHiddenSetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "PassphraseSet", (MsgFunction) &WapdmanServiceStubConnector::onPassphraseSetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "TetheringSet", (MsgFunction) &WapdmanServiceStubConnector::onTetheringSetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "PowerState", (MsgFunction) &WapdmanServiceStubConnector::onPowerStateGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "PowerState", (MsgFunction) &WapdmanServiceStubConnector::onPowerStateRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "PowerState", (MsgFunction) &WapdmanServiceStubConnector::onPowerStateDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "PowerFailureReason", (MsgFunction) &WapdmanServiceStubConnector::onPowerFailureReasonGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "PowerFailureReason", (MsgFunction) &WapdmanServiceStubConnector::onPowerFailureReasonRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "PowerFailureReason", (MsgFunction) &WapdmanServiceStubConnector::onPowerFailureReasonDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "CurrentHwMode", (MsgFunction) &WapdmanServiceStubConnector::onCurrentHwModeGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "CurrentHwMode", (MsgFunction) &WapdmanServiceStubConnector::onCurrentHwModeRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "CurrentHwMode", (MsgFunction) &WapdmanServiceStubConnector::onCurrentHwModeDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "MaximumStationsAllowed", (MsgFunction) &WapdmanServiceStubConnector::onMaximumStationsAllowedGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "MaximumStationsAllowed", (MsgFunction) &WapdmanServiceStubConnector::onMaximumStationsAllowedRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "MaximumStationsAllowed", (MsgFunction) &WapdmanServiceStubConnector::onMaximumStationsAllowedDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "SupportedChannels", (MsgFunction) &WapdmanServiceStubConnector::onSupportedChannelsGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "SupportedChannels", (MsgFunction) &WapdmanServiceStubConnector::onSupportedChannelsRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "SupportedChannels", (MsgFunction) &WapdmanServiceStubConnector::onSupportedChannelsDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "HWFeatures", (MsgFunction) &WapdmanServiceStubConnector::onHWFeaturesGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "HWFeatures", (MsgFunction) &WapdmanServiceStubConnector::onHWFeaturesRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "HWFeatures", (MsgFunction) &WapdmanServiceStubConnector::onHWFeaturesDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "Tethering", (MsgFunction) &WapdmanServiceStubConnector::onTetheringGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "Tethering", (MsgFunction) &WapdmanServiceStubConnector::onTetheringRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "Tethering", (MsgFunction) &WapdmanServiceStubConnector::onTetheringDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get, "IPv4Pool", (MsgFunction) &WapdmanServiceStubConnector::onIPv4PoolGet);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "IPv4Pool", (MsgFunction) &WapdmanServiceStubConnector::onIPv4PoolRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "IPv4Pool", (MsgFunction) &WapdmanServiceStubConnector::onIPv4PoolDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "GetAccessPoints", (MsgFunction) &WapdmanServiceStubConnector::onGetAccessPointsRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "RegisterAgent", (MsgFunction) &WapdmanServiceStubConnector::onRegisterAgentRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "UnregisterAgent", (MsgFunction) &WapdmanServiceStubConnector::onUnregisterAgentRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "FindAccessPoint", (MsgFunction) &WapdmanServiceStubConnector::onFindAccessPointRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "MacAddressAsGet", (MsgFunction) &WapdmanServiceStubConnector::onMacAddressAsGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "AccesspointAsGet", (MsgFunction) &WapdmanServiceStubConnector::onAccesspointAsGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "InterfaceAsGet", (MsgFunction) &WapdmanServiceStubConnector::onInterfaceAsGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "IPAddressAsGet", (MsgFunction) &WapdmanServiceStubConnector::onIPAddressAsGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request, "HostnameAsGet", (MsgFunction) &WapdmanServiceStubConnector::onHostnameAsGetRequest);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "AccessPointAdded", (MsgFunction) &WapdmanServiceStubConnector::onAccessPointAddedRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "AccessPointAdded", (MsgFunction) &WapdmanServiceStubConnector::onAccessPointAddedDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "AccessPointRemoved", (MsgFunction) &WapdmanServiceStubConnector::onAccessPointRemovedRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "AccessPointRemoved", (MsgFunction) &WapdmanServiceStubConnector::onAccessPointRemovedDeregister);

        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register, "AssociatedStationsChanged", (MsgFunction) &WapdmanServiceStubConnector::onAssociatedStationsChangedRegister);
        addFunction (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister, "AssociatedStationsChanged", (MsgFunction) &WapdmanServiceStubConnector::onAssociatedStationsChangedDeregister);
    }

};

} // namespace WapdmanService
} // namespace Stub

#endif // STUB_WAPDMANSERVICESTUBCONNECTOR_H
