/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "Stub/WapdmanService.h"
#include "Stub/WapdmanServiceJson.h"
#include "Stub/WapdmanServiceStub.h"
#include "Stub/WapdmanServiceStubConnector.h"
#include "Stub/WapdmanServiceTypes.h"
#include "asf/cms/CmsStubDelegate.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "boost/shared_ptr.hpp"
#include <string>
#include <vector>

/**
 * If the meaning of "WapdmanService" isn't clear, then there should be a description here.
 */

namespace Stub {
namespace WapdmanService {

DEFINE_CLASS_LOGGER("/Stub/WapdmanService", WapdmanServiceStub);

WapdmanServiceStub::WapdmanServiceStub(const std::string& portName) :
    Stub(portName),
    _PowerStateProperty(),
    _PowerFailureReasonProperty(),
    _CurrentHwModeProperty(),
    _MaximumStationsAllowedProperty(),
    _SupportedChannelsProperty(),
    _HWFeaturesProperty(),
    _TetheringProperty(),
    _IPv4PoolProperty(),
    _AccessPointAddedEvent(),
    _AccessPointRemovedEvent(),
    _AssociatedStationsChangedEvent(),
    _stubConnector(new WapdmanServiceStubConnector()),
    _cmsStubDelegate(new ::asf::cms::CmsStubDelegate( "WapdmanService", this, _stubConnector)) {
        CHECK_ALLOCATION(_stubConnector);
        CHECK_ALLOCATION(_cmsStubDelegate);
}

WapdmanServiceStub::~WapdmanServiceStub() {
    delete _stubConnector;
    delete _cmsStubDelegate;
}

// request setSSID

void WapdmanServiceStub::sendSetSSIDResponse (act_t act) {
    ::boost::shared_ptr< SetSSIDResponse > obj(new SetSSIDResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "SetSSID", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("setSSID", obj, act);
}

// request DeAuthenticateStation

void WapdmanServiceStub::sendDeAuthenticateStationResponse (act_t act) {
    ::boost::shared_ptr< DeAuthenticateStationResponse > obj(new DeAuthenticateStationResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "DeAuthenticateStation", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("DeAuthenticateStation", obj, act);
}

// request BlacklistStation

void WapdmanServiceStub::sendBlacklistStationResponse (act_t act) {
    ::boost::shared_ptr< BlacklistStationResponse > obj(new BlacklistStationResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "BlacklistStation", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("BlacklistStation", obj, act);
}

// request SetOperatingChannels

void WapdmanServiceStub::sendSetOperatingChannelsResponse (act_t act) {
    ::boost::shared_ptr< SetOperatingChannelsResponse > obj(new SetOperatingChannelsResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "SetOperatingChannels", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("SetOperatingChannels", obj, act);
}

// request StartWPSPushButton

void WapdmanServiceStub::sendStartWPSPushButtonResponse (act_t act) {
    ::boost::shared_ptr< StartWPSPushButtonResponse > obj(new StartWPSPushButtonResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "StartWPSPushButton", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("StartWPSPushButton", obj, act);
}

// request CancelWPS

void WapdmanServiceStub::sendCancelWPSResponse (act_t act) {
    ::boost::shared_ptr< CancelWPSResponse > obj(new CancelWPSResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "CancelWPS", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("CancelWPS", obj, act);
}

// request RegisterVendorService

void WapdmanServiceStub::sendRegisterVendorServiceResponse (act_t act) {
    ::boost::shared_ptr< RegisterVendorServiceResponse > obj(new RegisterVendorServiceResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "RegisterVendorService", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("RegisterVendorService", obj, act);
}

// request UnregisterVendorService

void WapdmanServiceStub::sendUnregisterVendorServiceResponse (act_t act) {
    ::boost::shared_ptr< UnregisterVendorServiceResponse > obj(new UnregisterVendorServiceResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "UnregisterVendorService", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("UnregisterVendorService", obj, act);
}

// request GetAssociatedStations

void WapdmanServiceStub::sendGetAssociatedStationsResponse (const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList >& associatedstations, act_t act) {
    ::boost::shared_ptr< GetAssociatedStationsResponse > obj(new GetAssociatedStationsResponse(associatedstations));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "GetAssociatedStations", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("GetAssociatedStations", obj, act);
}

// request Get

void WapdmanServiceStub::sendGetResponse (const ::std::string& value, act_t act) {
    ::boost::shared_ptr< GetResponse > obj(new GetResponse(value));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "Get", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("Get", obj, act);
}

// request SSIDGet

void WapdmanServiceStub::sendSSIDGetResponse (const ::std::vector< uint8 >& ssid, act_t act) {
    ::boost::shared_ptr< SSIDGetResponse > obj(new SSIDGetResponse(ssid));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "SSIDGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("SSIDGet", obj, act);
}

// request Security

void WapdmanServiceStub::sendSecurityResponse (const ::std::string& security, act_t act) {
    ::boost::shared_ptr< SecurityResponse > obj(new SecurityResponse(security));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "Security", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("Security", obj, act);
}

// request MacAddressGet

void WapdmanServiceStub::sendMacAddressGetResponse (const ::std::string& macaddress, act_t act) {
    ::boost::shared_ptr< MacAddressGetResponse > obj(new MacAddressGetResponse(macaddress));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "MacAddressGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("MacAddressGet", obj, act);
}

// request InterfaceGet

void WapdmanServiceStub::sendInterfaceGetResponse (const ::std::string& interface, act_t act) {
    ::boost::shared_ptr< InterfaceGetResponse > obj(new InterfaceGetResponse(interface));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "InterfaceGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("InterfaceGet", obj, act);
}

// request PassphraseGet

void WapdmanServiceStub::sendPassphraseGetResponse (const ::std::string& passphrase, act_t act) {
    ::boost::shared_ptr< PassphraseGetResponse > obj(new PassphraseGetResponse(passphrase));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "PassphraseGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("PassphraseGet", obj, act);
}

// request PoweredGet

void WapdmanServiceStub::sendPoweredGetResponse (bool powered, act_t act) {
    ::boost::shared_ptr< PoweredGetResponse > obj(new PoweredGetResponse(powered));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "PoweredGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("PoweredGet", obj, act);
}

// request HiddenGet

void WapdmanServiceStub::sendHiddenGetResponse (bool hidden, act_t act) {
    ::boost::shared_ptr< HiddenGetResponse > obj(new HiddenGetResponse(hidden));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "HiddenGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("HiddenGet", obj, act);
}

// request CurrentOperatingChannelGet

void WapdmanServiceStub::sendCurrentOperatingChannelGetResponse (uint16 currentoperatingchannel, act_t act) {
    ::boost::shared_ptr< CurrentOperatingChannelGetResponse > obj(new CurrentOperatingChannelGetResponse(currentoperatingchannel));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "CurrentOperatingChannelGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("CurrentOperatingChannelGet", obj, act);
}

// request VendorIEsGet

void WapdmanServiceStub::sendVendorIEsGetResponse (const ::std::vector< uint16 >& vendorIEs, act_t act) {
    ::boost::shared_ptr< VendorIEsGetResponse > obj(new VendorIEsGetResponse(vendorIEs));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "VendorIEsGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("VendorIEsGet", obj, act);
}

// request PoweredSet

void WapdmanServiceStub::sendPoweredSetResponse (act_t act) {
    ::boost::shared_ptr< PoweredSetResponse > obj(new PoweredSetResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "PoweredSet", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("PoweredSet", obj, act);
}

// request HiddenSet

void WapdmanServiceStub::sendHiddenSetResponse (act_t act) {
    ::boost::shared_ptr< HiddenSetResponse > obj(new HiddenSetResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "HiddenSet", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("HiddenSet", obj, act);
}

// request PassphraseSet

void WapdmanServiceStub::sendPassphraseSetResponse (act_t act) {
    ::boost::shared_ptr< PassphraseSetResponse > obj(new PassphraseSetResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "PassphraseSet", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("PassphraseSet", obj, act);
}

// request TetheringSet

void WapdmanServiceStub::sendTetheringSetResponse (act_t act) {
    ::boost::shared_ptr< TetheringSetResponse > obj(new TetheringSetResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "TetheringSet", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("TetheringSet", obj, act);
}

// property PowerState

void WapdmanServiceStub::onPowerStateRegister(bool /*isFirst*/, act_t act) {
    sendPowerStateUpdate(getPowerState(), act);
}

void WapdmanServiceStub::onPowerStateDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WapdmanServiceStub::sendPowerStateUpdate(const ::std::string& data, act_t act) {
    ::boost::shared_ptr< PowerStateUpdate > obj(new PowerStateUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "PowerState", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("PowerState", obj, act);
}

void WapdmanServiceStub::sendPowerStateGetUpdate(const ::std::string& data, act_t act) {
    ::boost::shared_ptr< PowerStateUpdate > obj(new PowerStateUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "PowerState", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("PowerState", obj, act);
}

void WapdmanServiceStub::onPowerStateGet(const ::boost::shared_ptr< PowerStateGet >& powerState) {
    sendPowerStateGetUpdate(getPowerState(), powerState->getAct());
}

void WapdmanServiceStub::setPowerState(const ::std::string& data) {
    if(data!=_PowerStateProperty.getData()) {
        {
            LOG_SYSTEM_LOGGER();
            LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data), "Detected invalid utf8 string (see above error messages)");
        }
        _PowerStateProperty.setData(data);
        ::boost::shared_ptr< PowerStateUpdate > obj(new PowerStateUpdate(_PowerStateProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "PowerState", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("PowerState", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "PowerState", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_PowerStateProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::std::string& WapdmanServiceStub::getPowerState() const {
    return _PowerStateProperty.getData();
}


::std::string& WapdmanServiceStub::getPowerStateMutable() {
    return _PowerStateProperty.getDataMutable();
}

void WapdmanServiceStub::sendPowerStateNotification() {
    ::boost::shared_ptr< PowerStateUpdate > obj(new PowerStateUpdate(_PowerStateProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "PowerState", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("PowerState", obj);
}

// property PowerFailureReason

void WapdmanServiceStub::onPowerFailureReasonRegister(bool /*isFirst*/, act_t act) {
    sendPowerFailureReasonUpdate(getPowerFailureReason(), act);
}

void WapdmanServiceStub::onPowerFailureReasonDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WapdmanServiceStub::sendPowerFailureReasonUpdate(const ::std::string& data, act_t act) {
    ::boost::shared_ptr< PowerFailureReasonUpdate > obj(new PowerFailureReasonUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "PowerFailureReason", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("PowerFailureReason", obj, act);
}

void WapdmanServiceStub::sendPowerFailureReasonGetUpdate(const ::std::string& data, act_t act) {
    ::boost::shared_ptr< PowerFailureReasonUpdate > obj(new PowerFailureReasonUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "PowerFailureReason", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("PowerFailureReason", obj, act);
}

void WapdmanServiceStub::onPowerFailureReasonGet(const ::boost::shared_ptr< PowerFailureReasonGet >& powerFailureReason) {
    sendPowerFailureReasonGetUpdate(getPowerFailureReason(), powerFailureReason->getAct());
}

void WapdmanServiceStub::setPowerFailureReason(const ::std::string& data) {
    if(data!=_PowerFailureReasonProperty.getData()) {
        {
            LOG_SYSTEM_LOGGER();
            LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data), "Detected invalid utf8 string (see above error messages)");
        }
        _PowerFailureReasonProperty.setData(data);
        ::boost::shared_ptr< PowerFailureReasonUpdate > obj(new PowerFailureReasonUpdate(_PowerFailureReasonProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "PowerFailureReason", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("PowerFailureReason", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "PowerFailureReason", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_PowerFailureReasonProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::std::string& WapdmanServiceStub::getPowerFailureReason() const {
    return _PowerFailureReasonProperty.getData();
}


::std::string& WapdmanServiceStub::getPowerFailureReasonMutable() {
    return _PowerFailureReasonProperty.getDataMutable();
}

void WapdmanServiceStub::sendPowerFailureReasonNotification() {
    ::boost::shared_ptr< PowerFailureReasonUpdate > obj(new PowerFailureReasonUpdate(_PowerFailureReasonProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "PowerFailureReason", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("PowerFailureReason", obj);
}

// property CurrentHwMode

void WapdmanServiceStub::onCurrentHwModeRegister(bool /*isFirst*/, act_t act) {
    sendCurrentHwModeUpdate(getCurrentHwMode(), act);
}

void WapdmanServiceStub::onCurrentHwModeDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WapdmanServiceStub::sendCurrentHwModeUpdate(const ::std::string& data, act_t act) {
    ::boost::shared_ptr< CurrentHwModeUpdate > obj(new CurrentHwModeUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "CurrentHwMode", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("CurrentHwMode", obj, act);
}

void WapdmanServiceStub::sendCurrentHwModeGetUpdate(const ::std::string& data, act_t act) {
    ::boost::shared_ptr< CurrentHwModeUpdate > obj(new CurrentHwModeUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "CurrentHwMode", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("CurrentHwMode", obj, act);
}

void WapdmanServiceStub::onCurrentHwModeGet(const ::boost::shared_ptr< CurrentHwModeGet >& currentHwMode) {
    sendCurrentHwModeGetUpdate(getCurrentHwMode(), currentHwMode->getAct());
}

void WapdmanServiceStub::setCurrentHwMode(const ::std::string& data) {
    if(data!=_CurrentHwModeProperty.getData()) {
        {
            LOG_SYSTEM_LOGGER();
            LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data), "Detected invalid utf8 string (see above error messages)");
        }
        _CurrentHwModeProperty.setData(data);
        ::boost::shared_ptr< CurrentHwModeUpdate > obj(new CurrentHwModeUpdate(_CurrentHwModeProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "CurrentHwMode", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("CurrentHwMode", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "CurrentHwMode", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_CurrentHwModeProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::std::string& WapdmanServiceStub::getCurrentHwMode() const {
    return _CurrentHwModeProperty.getData();
}


::std::string& WapdmanServiceStub::getCurrentHwModeMutable() {
    return _CurrentHwModeProperty.getDataMutable();
}

void WapdmanServiceStub::sendCurrentHwModeNotification() {
    ::boost::shared_ptr< CurrentHwModeUpdate > obj(new CurrentHwModeUpdate(_CurrentHwModeProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "CurrentHwMode", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("CurrentHwMode", obj);
}

// property MaximumStationsAllowed

void WapdmanServiceStub::onMaximumStationsAllowedRegister(bool /*isFirst*/, act_t act) {
    sendMaximumStationsAllowedUpdate(getMaximumStationsAllowed(), act);
}

void WapdmanServiceStub::onMaximumStationsAllowedDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WapdmanServiceStub::sendMaximumStationsAllowedUpdate(uint16 data, act_t act) {
    ::boost::shared_ptr< MaximumStationsAllowedUpdate > obj(new MaximumStationsAllowedUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "MaximumStationsAllowed", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("MaximumStationsAllowed", obj, act);
}

void WapdmanServiceStub::sendMaximumStationsAllowedGetUpdate(uint16 data, act_t act) {
    ::boost::shared_ptr< MaximumStationsAllowedUpdate > obj(new MaximumStationsAllowedUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "MaximumStationsAllowed", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("MaximumStationsAllowed", obj, act);
}

void WapdmanServiceStub::onMaximumStationsAllowedGet(const ::boost::shared_ptr< MaximumStationsAllowedGet >& maximumStationsAllowed) {
    sendMaximumStationsAllowedGetUpdate(getMaximumStationsAllowed(), maximumStationsAllowed->getAct());
}

void WapdmanServiceStub::setMaximumStationsAllowed(uint16 data) {
    if(data!=_MaximumStationsAllowedProperty.getData()) {
        _MaximumStationsAllowedProperty.setData(data);
        ::boost::shared_ptr< MaximumStationsAllowedUpdate > obj(new MaximumStationsAllowedUpdate(_MaximumStationsAllowedProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "MaximumStationsAllowed", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("MaximumStationsAllowed", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "MaximumStationsAllowed", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_MaximumStationsAllowedProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

uint16 WapdmanServiceStub::getMaximumStationsAllowed() const {
    return _MaximumStationsAllowedProperty.getData();
}


// property SupportedChannels

void WapdmanServiceStub::onSupportedChannelsRegister(bool /*isFirst*/, act_t act) {
    sendSupportedChannelsUpdate(getSupportedChannels(), act);
}

void WapdmanServiceStub::onSupportedChannelsDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WapdmanServiceStub::sendSupportedChannelsUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& data, act_t act) {
    ::boost::shared_ptr< SupportedChannelsUpdate > obj(new SupportedChannelsUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "SupportedChannels", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("SupportedChannels", obj, act);
}

void WapdmanServiceStub::sendSupportedChannelsGetUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& data, act_t act) {
    ::boost::shared_ptr< SupportedChannelsUpdate > obj(new SupportedChannelsUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "SupportedChannels", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("SupportedChannels", obj, act);
}

void WapdmanServiceStub::onSupportedChannelsGet(const ::boost::shared_ptr< SupportedChannelsGet >& supportedChannels) {
    sendSupportedChannelsGetUpdate(getSupportedChannels(), supportedChannels->getAct());
}

void WapdmanServiceStub::setSupportedChannels(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& data) {
    if(data!=_SupportedChannelsProperty.getData()) {
        _SupportedChannelsProperty.setData(data);
        ::boost::shared_ptr< SupportedChannelsUpdate > obj(new SupportedChannelsUpdate(_SupportedChannelsProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "SupportedChannels", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("SupportedChannels", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "SupportedChannels", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_SupportedChannelsProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& WapdmanServiceStub::getSupportedChannels() const {
    return _SupportedChannelsProperty.getData();
}


::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& WapdmanServiceStub::getSupportedChannelsMutable() {
    return _SupportedChannelsProperty.getDataMutable();
}

void WapdmanServiceStub::sendSupportedChannelsNotification() {
    ::boost::shared_ptr< SupportedChannelsUpdate > obj(new SupportedChannelsUpdate(_SupportedChannelsProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "SupportedChannels", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("SupportedChannels", obj);
}

// property HWFeatures

void WapdmanServiceStub::onHWFeaturesRegister(bool /*isFirst*/, act_t act) {
    sendHWFeaturesUpdate(getHWFeatures(), act);
}

void WapdmanServiceStub::onHWFeaturesDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WapdmanServiceStub::sendHWFeaturesUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& data, act_t act) {
    ::boost::shared_ptr< HWFeaturesUpdate > obj(new HWFeaturesUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "HWFeatures", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("HWFeatures", obj, act);
}

void WapdmanServiceStub::sendHWFeaturesGetUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& data, act_t act) {
    ::boost::shared_ptr< HWFeaturesUpdate > obj(new HWFeaturesUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "HWFeatures", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("HWFeatures", obj, act);
}

void WapdmanServiceStub::onHWFeaturesGet(const ::boost::shared_ptr< HWFeaturesGet >& hWFeatures) {
    sendHWFeaturesGetUpdate(getHWFeatures(), hWFeatures->getAct());
}

void WapdmanServiceStub::setHWFeatures(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& data) {
    if(data!=_HWFeaturesProperty.getData()) {
        _HWFeaturesProperty.setData(data);
        ::boost::shared_ptr< HWFeaturesUpdate > obj(new HWFeaturesUpdate(_HWFeaturesProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "HWFeatures", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("HWFeatures", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "HWFeatures", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_HWFeaturesProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& WapdmanServiceStub::getHWFeatures() const {
    return _HWFeaturesProperty.getData();
}


::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& WapdmanServiceStub::getHWFeaturesMutable() {
    return _HWFeaturesProperty.getDataMutable();
}

void WapdmanServiceStub::sendHWFeaturesNotification() {
    ::boost::shared_ptr< HWFeaturesUpdate > obj(new HWFeaturesUpdate(_HWFeaturesProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "HWFeatures", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("HWFeatures", obj);
}

// property Tethering

void WapdmanServiceStub::onTetheringRegister(bool /*isFirst*/, act_t act) {
    sendTetheringUpdate(getTethering(), act);
}

void WapdmanServiceStub::onTetheringDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WapdmanServiceStub::sendTetheringUpdate(bool data, act_t act) {
    ::boost::shared_ptr< TetheringUpdate > obj(new TetheringUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "Tethering", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("Tethering", obj, act);
}

void WapdmanServiceStub::sendTetheringGetUpdate(bool data, act_t act) {
    ::boost::shared_ptr< TetheringUpdate > obj(new TetheringUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "Tethering", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("Tethering", obj, act);
}

void WapdmanServiceStub::onTetheringGet(const ::boost::shared_ptr< TetheringGet >& tethering) {
    sendTetheringGetUpdate(getTethering(), tethering->getAct());
}

void WapdmanServiceStub::setTethering(bool data) {
    if(data!=_TetheringProperty.getData()) {
        _TetheringProperty.setData(data);
        ::boost::shared_ptr< TetheringUpdate > obj(new TetheringUpdate(_TetheringProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "Tethering", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("Tethering", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "Tethering", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_TetheringProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

bool WapdmanServiceStub::getTethering() const {
    return _TetheringProperty.getData();
}


// property IPv4Pool

void WapdmanServiceStub::onIPv4PoolRegister(bool /*isFirst*/, act_t act) {
    sendIPv4PoolUpdate(getIPv4Pool(), act);
}

void WapdmanServiceStub::onIPv4PoolDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WapdmanServiceStub::sendIPv4PoolUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& data, act_t act) {
    ::boost::shared_ptr< IPv4PoolUpdate > obj(new IPv4PoolUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "IPv4Pool", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("IPv4Pool", obj, act);
}

void WapdmanServiceStub::sendIPv4PoolGetUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& data, act_t act) {
    ::boost::shared_ptr< IPv4PoolUpdate > obj(new IPv4PoolUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "IPv4Pool", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("IPv4Pool", obj, act);
}

void WapdmanServiceStub::onIPv4PoolGet(const ::boost::shared_ptr< IPv4PoolGet >& iPv4Pool) {
    sendIPv4PoolGetUpdate(getIPv4Pool(), iPv4Pool->getAct());
}

void WapdmanServiceStub::setIPv4Pool(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& data) {
    if(data!=_IPv4PoolProperty.getData()) {
        _IPv4PoolProperty.setData(data);
        ::boost::shared_ptr< IPv4PoolUpdate > obj(new IPv4PoolUpdate(_IPv4PoolProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "IPv4Pool", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("IPv4Pool", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "IPv4Pool", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_IPv4PoolProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& WapdmanServiceStub::getIPv4Pool() const {
    return _IPv4PoolProperty.getData();
}


::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& WapdmanServiceStub::getIPv4PoolMutable() {
    return _IPv4PoolProperty.getDataMutable();
}

void WapdmanServiceStub::sendIPv4PoolNotification() {
    ::boost::shared_ptr< IPv4PoolUpdate > obj(new IPv4PoolUpdate(_IPv4PoolProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "IPv4Pool", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("IPv4Pool", obj);
}

// request GetAccessPoints

void WapdmanServiceStub::sendGetAccessPointsResponse (const ::Stub::WapdmanServiceTypes::StructAPList& accesspoints, act_t act) {
    ::boost::shared_ptr< GetAccessPointsResponse > obj(new GetAccessPointsResponse(accesspoints));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "GetAccessPoints", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("GetAccessPoints", obj, act);
}

// request RegisterAgent

void WapdmanServiceStub::sendRegisterAgentResponse (act_t act) {
    ::boost::shared_ptr< RegisterAgentResponse > obj(new RegisterAgentResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "RegisterAgent", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("RegisterAgent", obj, act);
}

// request UnregisterAgent

void WapdmanServiceStub::sendUnregisterAgentResponse (act_t act) {
    ::boost::shared_ptr< UnregisterAgentResponse > obj(new UnregisterAgentResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "UnregisterAgent", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("UnregisterAgent", obj, act);
}

// request FindAccessPoint

void WapdmanServiceStub::sendFindAccessPointResponse (const ::std::string& accesspoint, act_t act) {
    ::boost::shared_ptr< FindAccessPointResponse > obj(new FindAccessPointResponse(accesspoint));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "FindAccessPoint", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("FindAccessPoint", obj, act);
}

// request MacAddressAsGet

void WapdmanServiceStub::sendMacAddressAsGetResponse (const ::std::string& macaddressasget, act_t act) {
    ::boost::shared_ptr< MacAddressAsGetResponse > obj(new MacAddressAsGetResponse(macaddressasget));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "MacAddressAsGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("MacAddressAsGet", obj, act);
}

// request AccesspointAsGet

void WapdmanServiceStub::sendAccesspointAsGetResponse (const ::std::string& accesspointobjpath, act_t act) {
    ::boost::shared_ptr< AccesspointAsGetResponse > obj(new AccesspointAsGetResponse(accesspointobjpath));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "AccesspointAsGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("AccesspointAsGet", obj, act);
}

// request InterfaceAsGet

void WapdmanServiceStub::sendInterfaceAsGetResponse (const ::std::string& interfaceasget, act_t act) {
    ::boost::shared_ptr< InterfaceAsGetResponse > obj(new InterfaceAsGetResponse(interfaceasget));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "InterfaceAsGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("InterfaceAsGet", obj, act);
}

// request IPAddressAsGet

void WapdmanServiceStub::sendIPAddressAsGetResponse (const ::std::string& ipaddressasget, act_t act) {
    ::boost::shared_ptr< IPAddressAsGetResponse > obj(new IPAddressAsGetResponse(ipaddressasget));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "IPAddressAsGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("IPAddressAsGet", obj, act);
}

// request HostnameAsGet

void WapdmanServiceStub::sendHostnameAsGetResponse (const ::std::string& hostnameasget, act_t act) {
    ::boost::shared_ptr< HostnameAsGetResponse > obj(new HostnameAsGetResponse(hostnameasget));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "HostnameAsGet", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("HostnameAsGet", obj, act);
}

// event AccessPointAdded

void WapdmanServiceStub::onAccessPointAddedRegister(bool /*isFirst*/, act_t act) {
    sendAccessPointAddedRegisterConfirmation(act);
}

void WapdmanServiceStub::onAccessPointAddedDeregister(bool /*isLast*/, act_t /*act*/) {
}


void WapdmanServiceStub::sendAccessPointAddedEvent(const ::std::string& data) {
    ::boost::shared_ptr< AccessPointAddedEvent > obj(new AccessPointAddedEvent(data));
    _AccessPointAddedEvent = *obj;
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sEvent, stub=%p", "AccessPointAdded", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("AccessPointAdded", obj);
}

void WapdmanServiceStub::sendAccessPointAddedRegisterConfirmation(act_t act) {
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sRegisterConfirmation, act=%" PRIuPTR ", stub=%p", "AccessPointAdded", act, _cmsStubDelegate->getStub());
    }
    _cmsStubDelegate->sendRegisterConfirmation("AccessPointAdded", act);
}


// event AccessPointRemoved

void WapdmanServiceStub::onAccessPointRemovedRegister(bool /*isFirst*/, act_t act) {
    sendAccessPointRemovedRegisterConfirmation(act);
}

void WapdmanServiceStub::onAccessPointRemovedDeregister(bool /*isLast*/, act_t /*act*/) {
}


void WapdmanServiceStub::sendAccessPointRemovedEvent(const ::std::string& data) {
    ::boost::shared_ptr< AccessPointRemovedEvent > obj(new AccessPointRemovedEvent(data));
    _AccessPointRemovedEvent = *obj;
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sEvent, stub=%p", "AccessPointRemoved", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("AccessPointRemoved", obj);
}

void WapdmanServiceStub::sendAccessPointRemovedRegisterConfirmation(act_t act) {
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sRegisterConfirmation, act=%" PRIuPTR ", stub=%p", "AccessPointRemoved", act, _cmsStubDelegate->getStub());
    }
    _cmsStubDelegate->sendRegisterConfirmation("AccessPointRemoved", act);
}


// event AssociatedStationsChanged

void WapdmanServiceStub::onAssociatedStationsChangedRegister(bool /*isFirst*/, act_t act) {
    sendAssociatedStationsChangedRegisterConfirmation(act);
}

void WapdmanServiceStub::onAssociatedStationsChangedDeregister(bool /*isLast*/, act_t /*act*/) {
}


void WapdmanServiceStub::sendAssociatedStationsChangedEvent(const ::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged& data) {
    ::boost::shared_ptr< AssociatedStationsChangedEvent > obj(new AssociatedStationsChangedEvent(data));
    _AssociatedStationsChangedEvent = *obj;
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sEvent, stub=%p", "AssociatedStationsChanged", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("AssociatedStationsChanged", obj);
}

void WapdmanServiceStub::sendAssociatedStationsChangedRegisterConfirmation(act_t act) {
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sRegisterConfirmation, act=%" PRIuPTR ", stub=%p", "AssociatedStationsChanged", act, _cmsStubDelegate->getStub());
    }
    _cmsStubDelegate->sendRegisterConfirmation("AssociatedStationsChanged", act);
}

} // namespace WapdmanService
} // namespace Stub
