/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "Stub/WapdmanService.h"
#include "Stub/WapdmanServiceJson.h"
#include "Stub/WapdmanServiceJsonPrivate.h"
#include "Stub/WapdmanServiceTypes.h"
#include "Stub/WapdmanServiceTypesJsonPrivate.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstdlib>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


static ParserStatus parserUint8List_ (ParserEvent event, ParserContext *context, void *p1, void *p2);


static ParserStatus parserUint16List_ (ParserEvent event, ParserContext *context, void *p1, void *p2);


static ParserStatus parserUint8List_PointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2);


static ParserStatus parserStructASListPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2);


static ParserStatus parserSupportedChannelsListPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2);


static ParserStatus parserStructHWFeaturesListPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2);


static ParserStatus parserStructIPv4ListPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2);

static ParserStatus parserUint8List_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::std::vector< uint8 > *object = (::std::vector< uint8 >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint8 t = (uint8) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    object->push_back (t);
                    setState (context, INIT);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}


static ParserStatus parserUint16List_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::std::vector< uint16 > *object = (::std::vector< uint16 >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    object->push_back (t);
                    setState (context, INIT);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}


static ParserStatus parserUint8List_PointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT,
        WAIT_FOR_RETURN
    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::boost::ptr_vector< ::std::vector< uint8 > > *object = (::boost::ptr_vector< ::std::vector< uint8 > >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, WAIT_FOR_RETURN);
                ::std::vector< uint8 > *o = new ::std::vector< uint8 >();
                CHECK_ALLOCATION(o);
                callParser (context, "parserUint8List_", parserUint8List_, &*o);
                return PARSER_STATUS__OK;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            {
                ::std::vector< uint8 > *o = (::std::vector< uint8 > *) p1;
                object->push_back (o);
                setState (context, INIT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
    break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}


static ParserStatus parserStructASListPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT,
        WAIT_FOR_RETURN
    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList > *object = (::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, WAIT_FOR_RETURN);
                ::Stub::WapdmanServiceTypes::StructASList *o = new ::Stub::WapdmanServiceTypes::StructASList();
                CHECK_ALLOCATION(o);
                callParser (context, "parserStructASList", jsonParser__Stub__WapdmanServiceTypes__StructASList, &*o);
                return PARSER_STATUS__OK;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            {
                ::Stub::WapdmanServiceTypes::StructASList *o = (::Stub::WapdmanServiceTypes::StructASList *) p1;
                object->push_back (o);
                setState (context, INIT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
    break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}


static ParserStatus parserSupportedChannelsListPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT,
        WAIT_FOR_RETURN
    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList > *object = (::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, WAIT_FOR_RETURN);
                ::Stub::WapdmanServiceTypes::SupportedChannelsList *o = new ::Stub::WapdmanServiceTypes::SupportedChannelsList();
                CHECK_ALLOCATION(o);
                callParser (context, "parserSupportedChannelsList", jsonParser__Stub__WapdmanServiceTypes__SupportedChannelsList, &*o);
                return PARSER_STATUS__OK;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            {
                ::Stub::WapdmanServiceTypes::SupportedChannelsList *o = (::Stub::WapdmanServiceTypes::SupportedChannelsList *) p1;
                object->push_back (o);
                setState (context, INIT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
    break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}


static ParserStatus parserStructHWFeaturesListPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT,
        WAIT_FOR_RETURN
    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList > *object = (::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, WAIT_FOR_RETURN);
                ::Stub::WapdmanServiceTypes::StructHWFeaturesList *o = new ::Stub::WapdmanServiceTypes::StructHWFeaturesList();
                CHECK_ALLOCATION(o);
                callParser (context, "parserStructHWFeaturesList", jsonParser__Stub__WapdmanServiceTypes__StructHWFeaturesList, &*o);
                return PARSER_STATUS__OK;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            {
                ::Stub::WapdmanServiceTypes::StructHWFeaturesList *o = (::Stub::WapdmanServiceTypes::StructHWFeaturesList *) p1;
                object->push_back (o);
                setState (context, INIT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
    break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}


static ParserStatus parserStructIPv4ListPointerList_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT,
        WAIT_FOR_RETURN
    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List > *object = (::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, WAIT_FOR_RETURN);
                ::Stub::WapdmanServiceTypes::StructIPv4List *o = new ::Stub::WapdmanServiceTypes::StructIPv4List();
                CHECK_ALLOCATION(o);
                callParser (context, "parserStructIPv4List", jsonParser__Stub__WapdmanServiceTypes__StructIPv4List, &*o);
                return PARSER_STATUS__OK;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            {
                ::Stub::WapdmanServiceTypes::StructIPv4List *o = (::Stub::WapdmanServiceTypes::StructIPv4List *) p1;
                object->push_back (o);
                setState (context, INIT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
    break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "SetSSIDRequest"

void serializeJson (const ::Stub::WapdmanService::SetSSIDRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSsid()) {
        yajl_gen_string(g, (const unsigned char*)  "ssid" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o1 = value.getSsid();
        {
            ::std::vector< uint8 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasUtf_ssid()) {
        yajl_gen_string(g, (const unsigned char*)  "utf_ssid" , 8);
        yajl_gen_bool(g, (bool)value.getUtf_ssid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::SetSSIDRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::SetSSIDRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserSetSSIDRequest", jsonParser__Stub__WapdmanService__SetSSIDRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForSetSSIDRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"SSID", 1},
        {8,"UTF_SSID", 4},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 2, value))
        return (int)value;
    else
        return 5;
}

static int processMapKeyForSetSSIDRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForSetSSIDRequest(s, length);
    if (i != 5 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__SetSSIDRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_SSID,
        KEY_SSID,
        KEY_SSID_WAIT_FOR_RETURN,
        INIT_KEY_UTF_SSID,
        KEY_UTF_SSID,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_SSID:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSetSSIDRequest (context, (char*) p1, (size_t) p2, "ssid", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_SSID:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_SSID_WAIT_FOR_RETURN);
                callParser (context, "parserUint8List_", parserUint8List_, &((::Stub::WapdmanService::SetSSIDRequest*) parser.object)->getSsidMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_SSID_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_UTF_SSID);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case INIT_KEY_UTF_SSID:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSetSSIDRequest (context, (char*) p1, (size_t) p2, "utf_ssid", 4) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_UTF_SSID:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanService::SetSSIDRequest*) parser.object)->setUtf_ssid(t);
                setState (context, INIT_KEY_SSID);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_SSID);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_SSID);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "DeAuthenticateStationRequest"

void serializeJson (const ::Stub::WapdmanService::DeAuthenticateStationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::DeAuthenticateStationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::DeAuthenticateStationRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserDeAuthenticateStationRequest", jsonParser__Stub__WapdmanService__DeAuthenticateStationRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForDeAuthenticateStationRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {7,"ADDRESS", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForDeAuthenticateStationRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForDeAuthenticateStationRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__DeAuthenticateStationRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_ADDRESS,
        KEY_ADDRESS,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_ADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForDeAuthenticateStationRequest (context, (char*) p1, (size_t) p2, "address", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::DeAuthenticateStationRequest*) parser.object)->replaceAddress(t);
                setState (context, INIT_KEY_ADDRESS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_ADDRESS);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_ADDRESS);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "BlacklistStationRequest"

void serializeJson (const ::Stub::WapdmanService::BlacklistStationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAllow()) {
        yajl_gen_string(g, (const unsigned char*)  "allow" , 5);
        yajl_gen_bool(g, (bool)value.getAllow());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::BlacklistStationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::BlacklistStationRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserBlacklistStationRequest", jsonParser__Stub__WapdmanService__BlacklistStationRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForBlacklistStationRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {5,"ALLOW", 3},
        {7,"ADDRESS", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 2, value))
        return (int)value;
    else
        return 4;
}

static int processMapKeyForBlacklistStationRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForBlacklistStationRequest(s, length);
    if (i != 4 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__BlacklistStationRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_ADDRESS,
        KEY_ADDRESS,
        INIT_KEY_ALLOW,
        KEY_ALLOW,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_ADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForBlacklistStationRequest (context, (char*) p1, (size_t) p2, "address", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::BlacklistStationRequest*) parser.object)->replaceAddress(t);
                setState (context, INIT_KEY_ALLOW);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_ALLOW:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForBlacklistStationRequest (context, (char*) p1, (size_t) p2, "allow", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ALLOW:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanService::BlacklistStationRequest*) parser.object)->setAllow(t);
                setState (context, INIT_KEY_ADDRESS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_ADDRESS);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_ADDRESS);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "SetOperatingChannelsRequest"

void serializeJson (const ::Stub::WapdmanService::SetOperatingChannelsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannels()) {
        yajl_gen_string(g, (const unsigned char*)  "channels" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o3 = value.getChannels();
        {
            ::std::vector< uint16 >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                yajl_gen_integer(g, (long long)(*o2));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::SetOperatingChannelsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::SetOperatingChannelsRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserSetOperatingChannelsRequest", jsonParser__Stub__WapdmanService__SetOperatingChannelsRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForSetOperatingChannelsRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {8,"CHANNELS", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForSetOperatingChannelsRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForSetOperatingChannelsRequest(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__SetOperatingChannelsRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_CHANNELS,
        KEY_CHANNELS,
        KEY_CHANNELS_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_CHANNELS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSetOperatingChannelsRequest (context, (char*) p1, (size_t) p2, "channels", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_CHANNELS_WAIT_FOR_RETURN);
                callParser (context, "parserUint16List_", parserUint16List_, &((::Stub::WapdmanService::SetOperatingChannelsRequest*) parser.object)->getChannelsMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_CHANNELS_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_CHANNELS);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_CHANNELS);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_CHANNELS);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "RegisterVendorServiceRequest"

void serializeJson (const ::Stub::WapdmanService::RegisterVendorServiceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIEs()) {
        yajl_gen_string(g, (const unsigned char*)  "IEs" , 3);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::std::vector< uint8 > >& o5 = value.getIEs();
        {
            ::boost::ptr_vector< ::std::vector< uint8 > >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                yajl_gen_array_open(g);
                const ::std::vector< uint8 >& o7 = (*o4);
                {
                    ::std::vector< uint8 >::const_iterator o6;
                    for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                        yajl_gen_integer(g, (long long)(*o6));
                    }
                }
                yajl_gen_array_close(g);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::RegisterVendorServiceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::RegisterVendorServiceRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserRegisterVendorServiceRequest", jsonParser__Stub__WapdmanService__RegisterVendorServiceRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForRegisterVendorServiceRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {3,"IES", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForRegisterVendorServiceRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForRegisterVendorServiceRequest(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__RegisterVendorServiceRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_IES,
        KEY_IES,
        KEY_IES_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_IES:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegisterVendorServiceRequest (context, (char*) p1, (size_t) p2, "IEs", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IES:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_IES_WAIT_FOR_RETURN);
                callParser (context, "parserUint8List_PointerList_", parserUint8List_PointerList_, &((::Stub::WapdmanService::RegisterVendorServiceRequest*) parser.object)->getIEsMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_IES_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_IES);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_IES);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_IES);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "UnregisterVendorServiceRequest"

void serializeJson (const ::Stub::WapdmanService::UnregisterVendorServiceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIEs()) {
        yajl_gen_string(g, (const unsigned char*)  "IEs" , 3);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::std::vector< uint8 > >& o9 = value.getIEs();
        {
            ::boost::ptr_vector< ::std::vector< uint8 > >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                yajl_gen_array_open(g);
                const ::std::vector< uint8 >& o11 = (*o8);
                {
                    ::std::vector< uint8 >::const_iterator o10;
                    for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                        yajl_gen_integer(g, (long long)(*o10));
                    }
                }
                yajl_gen_array_close(g);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::UnregisterVendorServiceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::UnregisterVendorServiceRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserUnregisterVendorServiceRequest", jsonParser__Stub__WapdmanService__UnregisterVendorServiceRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForUnregisterVendorServiceRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {3,"IES", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForUnregisterVendorServiceRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForUnregisterVendorServiceRequest(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__UnregisterVendorServiceRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_IES,
        KEY_IES,
        KEY_IES_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_IES:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForUnregisterVendorServiceRequest (context, (char*) p1, (size_t) p2, "IEs", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IES:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_IES_WAIT_FOR_RETURN);
                callParser (context, "parserUint8List_PointerList_", parserUint8List_PointerList_, &((::Stub::WapdmanService::UnregisterVendorServiceRequest*) parser.object)->getIEsMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_IES_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_IES);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_IES);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_IES);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "GetAssociatedStationsResponse"

void serializeJson (const ::Stub::WapdmanService::GetAssociatedStationsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAssociatedstations()) {
        yajl_gen_string(g, (const unsigned char*)  "associatedstations" , 18);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList >& o13 = value.getAssociatedstations();
        {
            ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::GetAssociatedStationsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::GetAssociatedStationsResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserGetAssociatedStationsResponse", jsonParser__Stub__WapdmanService__GetAssociatedStationsResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForGetAssociatedStationsResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {18,"ASSOCIATEDSTATIONS", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForGetAssociatedStationsResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForGetAssociatedStationsResponse(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__GetAssociatedStationsResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_ASSOCIATEDSTATIONS,
        KEY_ASSOCIATEDSTATIONS,
        KEY_ASSOCIATEDSTATIONS_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_ASSOCIATEDSTATIONS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForGetAssociatedStationsResponse (context, (char*) p1, (size_t) p2, "associatedstations", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ASSOCIATEDSTATIONS:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_ASSOCIATEDSTATIONS_WAIT_FOR_RETURN);
                callParser (context, "parserStructASListPointerList_", parserStructASListPointerList_, &((::Stub::WapdmanService::GetAssociatedStationsResponse*) parser.object)->getAssociatedstationsMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_ASSOCIATEDSTATIONS_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_ASSOCIATEDSTATIONS);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_ASSOCIATEDSTATIONS);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_ASSOCIATEDSTATIONS);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "GetRequest"

void serializeJson (const ::Stub::WapdmanService::GetRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInterface_name()) {
        yajl_gen_string(g, (const unsigned char*)  "interface_name" , 14);
        const char *s = value.getInterface_name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasProperty_name()) {
        yajl_gen_string(g, (const unsigned char*)  "property_name" , 13);
        const char *s = value.getProperty_name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::GetRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::GetRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserGetRequest", jsonParser__Stub__WapdmanService__GetRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForGetRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {13,"PROPERTY_NAME", 3},
        {14,"INTERFACE_NAME", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 2, value))
        return (int)value;
    else
        return 4;
}

static int processMapKeyForGetRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForGetRequest(s, length);
    if (i != 4 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__GetRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_INTERFACE_NAME,
        KEY_INTERFACE_NAME,
        INIT_KEY_PROPERTY_NAME,
        KEY_PROPERTY_NAME,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_INTERFACE_NAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForGetRequest (context, (char*) p1, (size_t) p2, "interface_name", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INTERFACE_NAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::GetRequest*) parser.object)->replaceInterface_name(t);
                setState (context, INIT_KEY_PROPERTY_NAME);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_PROPERTY_NAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForGetRequest (context, (char*) p1, (size_t) p2, "property_name", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_PROPERTY_NAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::GetRequest*) parser.object)->replaceProperty_name(t);
                setState (context, INIT_KEY_INTERFACE_NAME);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_INTERFACE_NAME);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_INTERFACE_NAME);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "GetResponse"

void serializeJson (const ::Stub::WapdmanService::GetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "value" , 5);
        const char *s = value.getValue().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::GetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::GetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserGetResponse", jsonParser__Stub__WapdmanService__GetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {5,"VALUE", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__GetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_VALUE,
        KEY_VALUE,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_VALUE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForGetResponse (context, (char*) p1, (size_t) p2, "value", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_VALUE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::GetResponse*) parser.object)->replaceValue(t);
                setState (context, INIT_KEY_VALUE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_VALUE);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_VALUE);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "SSIDGetResponse"

void serializeJson (const ::Stub::WapdmanService::SSIDGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSsid()) {
        yajl_gen_string(g, (const unsigned char*)  "ssid" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o15 = value.getSsid();
        {
            ::std::vector< uint8 >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                yajl_gen_integer(g, (long long)(*o14));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::SSIDGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::SSIDGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserSSIDGetResponse", jsonParser__Stub__WapdmanService__SSIDGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForSSIDGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"SSID", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForSSIDGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForSSIDGetResponse(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__SSIDGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_SSID,
        KEY_SSID,
        KEY_SSID_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_SSID:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSSIDGetResponse (context, (char*) p1, (size_t) p2, "ssid", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_SSID:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_SSID_WAIT_FOR_RETURN);
                callParser (context, "parserUint8List_", parserUint8List_, &((::Stub::WapdmanService::SSIDGetResponse*) parser.object)->getSsidMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_SSID_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_SSID);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_SSID);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_SSID);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "SecurityRequest"

void serializeJson (const ::Stub::WapdmanService::SecurityRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSecurity()) {
        yajl_gen_string(g, (const unsigned char*)  "security" , 8);
        const char *s = value.getSecurity().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::SecurityRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::SecurityRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserSecurityRequest", jsonParser__Stub__WapdmanService__SecurityRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForSecurityRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {8,"SECURITY", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForSecurityRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForSecurityRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__SecurityRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_SECURITY,
        KEY_SECURITY,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_SECURITY:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSecurityRequest (context, (char*) p1, (size_t) p2, "security", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_SECURITY:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::SecurityRequest*) parser.object)->replaceSecurity(t);
                setState (context, INIT_KEY_SECURITY);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_SECURITY);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_SECURITY);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "SecurityResponse"

void serializeJson (const ::Stub::WapdmanService::SecurityResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSecurity()) {
        yajl_gen_string(g, (const unsigned char*)  "security" , 8);
        const char *s = value.getSecurity().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::SecurityResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::SecurityResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserSecurityResponse", jsonParser__Stub__WapdmanService__SecurityResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForSecurityResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {8,"SECURITY", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForSecurityResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForSecurityResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__SecurityResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_SECURITY,
        KEY_SECURITY,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_SECURITY:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSecurityResponse (context, (char*) p1, (size_t) p2, "security", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_SECURITY:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::SecurityResponse*) parser.object)->replaceSecurity(t);
                setState (context, INIT_KEY_SECURITY);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_SECURITY);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_SECURITY);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "MacAddressGetResponse"

void serializeJson (const ::Stub::WapdmanService::MacAddressGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMacaddress()) {
        yajl_gen_string(g, (const unsigned char*)  "macaddress" , 10);
        const char *s = value.getMacaddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::MacAddressGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::MacAddressGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserMacAddressGetResponse", jsonParser__Stub__WapdmanService__MacAddressGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForMacAddressGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {10,"MACADDRESS", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForMacAddressGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForMacAddressGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__MacAddressGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_MACADDRESS,
        KEY_MACADDRESS,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_MACADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMacAddressGetResponse (context, (char*) p1, (size_t) p2, "macaddress", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MACADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::MacAddressGetResponse*) parser.object)->replaceMacaddress(t);
                setState (context, INIT_KEY_MACADDRESS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_MACADDRESS);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_MACADDRESS);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "InterfaceGetResponse"

void serializeJson (const ::Stub::WapdmanService::InterfaceGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInterface()) {
        yajl_gen_string(g, (const unsigned char*)  "interface" , 9);
        const char *s = value.getInterface().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::InterfaceGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::InterfaceGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserInterfaceGetResponse", jsonParser__Stub__WapdmanService__InterfaceGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForInterfaceGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {9,"INTERFACE", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForInterfaceGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForInterfaceGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__InterfaceGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_INTERFACE,
        KEY_INTERFACE,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_INTERFACE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForInterfaceGetResponse (context, (char*) p1, (size_t) p2, "interface", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INTERFACE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::InterfaceGetResponse*) parser.object)->replaceInterface(t);
                setState (context, INIT_KEY_INTERFACE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_INTERFACE);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_INTERFACE);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "PassphraseGetResponse"

void serializeJson (const ::Stub::WapdmanService::PassphraseGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPassphrase()) {
        yajl_gen_string(g, (const unsigned char*)  "passphrase" , 10);
        const char *s = value.getPassphrase().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::PassphraseGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::PassphraseGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserPassphraseGetResponse", jsonParser__Stub__WapdmanService__PassphraseGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForPassphraseGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {10,"PASSPHRASE", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForPassphraseGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForPassphraseGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__PassphraseGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_PASSPHRASE,
        KEY_PASSPHRASE,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_PASSPHRASE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForPassphraseGetResponse (context, (char*) p1, (size_t) p2, "passphrase", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_PASSPHRASE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::PassphraseGetResponse*) parser.object)->replacePassphrase(t);
                setState (context, INIT_KEY_PASSPHRASE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_PASSPHRASE);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_PASSPHRASE);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "PoweredGetResponse"

void serializeJson (const ::Stub::WapdmanService::PoweredGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPowered()) {
        yajl_gen_string(g, (const unsigned char*)  "powered" , 7);
        yajl_gen_bool(g, (bool)value.getPowered());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::PoweredGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::PoweredGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserPoweredGetResponse", jsonParser__Stub__WapdmanService__PoweredGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForPoweredGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {7,"POWERED", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForPoweredGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForPoweredGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__PoweredGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_POWERED,
        KEY_POWERED,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_POWERED:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForPoweredGetResponse (context, (char*) p1, (size_t) p2, "powered", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_POWERED:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanService::PoweredGetResponse*) parser.object)->setPowered(t);
                setState (context, INIT_KEY_POWERED);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_POWERED);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_POWERED);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "HiddenGetResponse"

void serializeJson (const ::Stub::WapdmanService::HiddenGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHidden()) {
        yajl_gen_string(g, (const unsigned char*)  "hidden" , 6);
        yajl_gen_bool(g, (bool)value.getHidden());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::HiddenGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::HiddenGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserHiddenGetResponse", jsonParser__Stub__WapdmanService__HiddenGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForHiddenGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {6,"HIDDEN", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForHiddenGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForHiddenGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__HiddenGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_HIDDEN,
        KEY_HIDDEN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_HIDDEN:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForHiddenGetResponse (context, (char*) p1, (size_t) p2, "hidden", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_HIDDEN:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanService::HiddenGetResponse*) parser.object)->setHidden(t);
                setState (context, INIT_KEY_HIDDEN);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_HIDDEN);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_HIDDEN);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "CurrentOperatingChannelGetResponse"

void serializeJson (const ::Stub::WapdmanService::CurrentOperatingChannelGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCurrentoperatingchannel()) {
        yajl_gen_string(g, (const unsigned char*)  "currentoperatingchannel" , 23);
        yajl_gen_integer(g, (long long)value.getCurrentoperatingchannel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::CurrentOperatingChannelGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::CurrentOperatingChannelGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserCurrentOperatingChannelGetResponse", jsonParser__Stub__WapdmanService__CurrentOperatingChannelGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForCurrentOperatingChannelGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {23,"CURRENTOPERATINGCHANNEL", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForCurrentOperatingChannelGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForCurrentOperatingChannelGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__CurrentOperatingChannelGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_CURRENTOPERATINGCHANNEL,
        KEY_CURRENTOPERATINGCHANNEL,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_CURRENTOPERATINGCHANNEL:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForCurrentOperatingChannelGetResponse (context, (char*) p1, (size_t) p2, "currentoperatingchannel", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CURRENTOPERATINGCHANNEL:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanService::CurrentOperatingChannelGetResponse*) parser.object)->setCurrentoperatingchannel(t);
                    setState (context, INIT_KEY_CURRENTOPERATINGCHANNEL);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_CURRENTOPERATINGCHANNEL);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_CURRENTOPERATINGCHANNEL);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "VendorIEsGetResponse"

void serializeJson (const ::Stub::WapdmanService::VendorIEsGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVendorIEs()) {
        yajl_gen_string(g, (const unsigned char*)  "vendorIEs" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o17 = value.getVendorIEs();
        {
            ::std::vector< uint16 >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                yajl_gen_integer(g, (long long)(*o16));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::VendorIEsGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::VendorIEsGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserVendorIEsGetResponse", jsonParser__Stub__WapdmanService__VendorIEsGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForVendorIEsGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {9,"VENDORIES", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForVendorIEsGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForVendorIEsGetResponse(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__VendorIEsGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_VENDORIES,
        KEY_VENDORIES,
        KEY_VENDORIES_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_VENDORIES:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForVendorIEsGetResponse (context, (char*) p1, (size_t) p2, "vendorIEs", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_VENDORIES:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_VENDORIES_WAIT_FOR_RETURN);
                callParser (context, "parserUint16List_", parserUint16List_, &((::Stub::WapdmanService::VendorIEsGetResponse*) parser.object)->getVendorIEsMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_VENDORIES_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_VENDORIES);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_VENDORIES);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_VENDORIES);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "PoweredSetRequest"

void serializeJson (const ::Stub::WapdmanService::PoweredSetRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPowered()) {
        yajl_gen_string(g, (const unsigned char*)  "powered" , 7);
        yajl_gen_bool(g, (bool)value.getPowered());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::PoweredSetRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::PoweredSetRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserPoweredSetRequest", jsonParser__Stub__WapdmanService__PoweredSetRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForPoweredSetRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {7,"POWERED", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForPoweredSetRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForPoweredSetRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__PoweredSetRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_POWERED,
        KEY_POWERED,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_POWERED:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForPoweredSetRequest (context, (char*) p1, (size_t) p2, "powered", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_POWERED:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanService::PoweredSetRequest*) parser.object)->setPowered(t);
                setState (context, INIT_KEY_POWERED);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_POWERED);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_POWERED);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "HiddenSetRequest"

void serializeJson (const ::Stub::WapdmanService::HiddenSetRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHidden()) {
        yajl_gen_string(g, (const unsigned char*)  "hidden" , 6);
        yajl_gen_bool(g, (bool)value.getHidden());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::HiddenSetRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::HiddenSetRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserHiddenSetRequest", jsonParser__Stub__WapdmanService__HiddenSetRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForHiddenSetRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {6,"HIDDEN", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForHiddenSetRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForHiddenSetRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__HiddenSetRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_HIDDEN,
        KEY_HIDDEN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_HIDDEN:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForHiddenSetRequest (context, (char*) p1, (size_t) p2, "hidden", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_HIDDEN:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanService::HiddenSetRequest*) parser.object)->setHidden(t);
                setState (context, INIT_KEY_HIDDEN);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_HIDDEN);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_HIDDEN);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "PassphraseSetRequest"

void serializeJson (const ::Stub::WapdmanService::PassphraseSetRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPassphrase()) {
        yajl_gen_string(g, (const unsigned char*)  "passphrase" , 10);
        const char *s = value.getPassphrase().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::PassphraseSetRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::PassphraseSetRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserPassphraseSetRequest", jsonParser__Stub__WapdmanService__PassphraseSetRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForPassphraseSetRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {10,"PASSPHRASE", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForPassphraseSetRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForPassphraseSetRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__PassphraseSetRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_PASSPHRASE,
        KEY_PASSPHRASE,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_PASSPHRASE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForPassphraseSetRequest (context, (char*) p1, (size_t) p2, "passphrase", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_PASSPHRASE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::PassphraseSetRequest*) parser.object)->replacePassphrase(t);
                setState (context, INIT_KEY_PASSPHRASE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_PASSPHRASE);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_PASSPHRASE);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "TetheringSetRequest"

void serializeJson (const ::Stub::WapdmanService::TetheringSetRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTethering()) {
        yajl_gen_string(g, (const unsigned char*)  "tethering" , 9);
        yajl_gen_bool(g, (bool)value.getTethering());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::TetheringSetRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::TetheringSetRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserTetheringSetRequest", jsonParser__Stub__WapdmanService__TetheringSetRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForTetheringSetRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {9,"TETHERING", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForTetheringSetRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForTetheringSetRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__TetheringSetRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_TETHERING,
        KEY_TETHERING,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_TETHERING:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForTetheringSetRequest (context, (char*) p1, (size_t) p2, "tethering", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_TETHERING:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanService::TetheringSetRequest*) parser.object)->setTethering(t);
                setState (context, INIT_KEY_TETHERING);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_TETHERING);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_TETHERING);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "PowerStateUpdate"

void serializeJson (const ::Stub::WapdmanService::PowerStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        const char *s = value.getData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::PowerStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::PowerStateUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserPowerStateUpdate", jsonParser__Stub__WapdmanService__PowerStateUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForPowerStateUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForPowerStateUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForPowerStateUpdate(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__PowerStateUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForPowerStateUpdate (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::PowerStateUpdate*) parser.object)->replaceData(t);
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "PowerFailureReasonUpdate"

void serializeJson (const ::Stub::WapdmanService::PowerFailureReasonUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        const char *s = value.getData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::PowerFailureReasonUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::PowerFailureReasonUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserPowerFailureReasonUpdate", jsonParser__Stub__WapdmanService__PowerFailureReasonUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForPowerFailureReasonUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForPowerFailureReasonUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForPowerFailureReasonUpdate(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__PowerFailureReasonUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForPowerFailureReasonUpdate (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::PowerFailureReasonUpdate*) parser.object)->replaceData(t);
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "CurrentHwModeUpdate"

void serializeJson (const ::Stub::WapdmanService::CurrentHwModeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        const char *s = value.getData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::CurrentHwModeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::CurrentHwModeUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserCurrentHwModeUpdate", jsonParser__Stub__WapdmanService__CurrentHwModeUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForCurrentHwModeUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForCurrentHwModeUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForCurrentHwModeUpdate(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__CurrentHwModeUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForCurrentHwModeUpdate (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::CurrentHwModeUpdate*) parser.object)->replaceData(t);
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "MaximumStationsAllowedUpdate"

void serializeJson (const ::Stub::WapdmanService::MaximumStationsAllowedUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        yajl_gen_integer(g, (long long)value.getData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::MaximumStationsAllowedUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::MaximumStationsAllowedUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserMaximumStationsAllowedUpdate", jsonParser__Stub__WapdmanService__MaximumStationsAllowedUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForMaximumStationsAllowedUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForMaximumStationsAllowedUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForMaximumStationsAllowedUpdate(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__MaximumStationsAllowedUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMaximumStationsAllowedUpdate (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanService::MaximumStationsAllowedUpdate*) parser.object)->setData(t);
                    setState (context, INIT_KEY_DATA);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "SupportedChannelsUpdate"

void serializeJson (const ::Stub::WapdmanService::SupportedChannelsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& o19 = value.getData();
        {
            ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                serializeJson((*o18), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::SupportedChannelsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::SupportedChannelsUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserSupportedChannelsUpdate", jsonParser__Stub__WapdmanService__SupportedChannelsUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForSupportedChannelsUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForSupportedChannelsUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForSupportedChannelsUpdate(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__SupportedChannelsUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY_DATA_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsUpdate (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_DATA_WAIT_FOR_RETURN);
                callParser (context, "parserSupportedChannelsListPointerList_", parserSupportedChannelsListPointerList_, &((::Stub::WapdmanService::SupportedChannelsUpdate*) parser.object)->getDataMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_DATA_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_DATA);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "HWFeaturesUpdate"

void serializeJson (const ::Stub::WapdmanService::HWFeaturesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& o21 = value.getData();
        {
            ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                serializeJson((*o20), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::HWFeaturesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::HWFeaturesUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserHWFeaturesUpdate", jsonParser__Stub__WapdmanService__HWFeaturesUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForHWFeaturesUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForHWFeaturesUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForHWFeaturesUpdate(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__HWFeaturesUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY_DATA_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForHWFeaturesUpdate (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_DATA_WAIT_FOR_RETURN);
                callParser (context, "parserStructHWFeaturesListPointerList_", parserStructHWFeaturesListPointerList_, &((::Stub::WapdmanService::HWFeaturesUpdate*) parser.object)->getDataMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_DATA_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_DATA);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "TetheringUpdate"

void serializeJson (const ::Stub::WapdmanService::TetheringUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        yajl_gen_bool(g, (bool)value.getData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::TetheringUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::TetheringUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserTetheringUpdate", jsonParser__Stub__WapdmanService__TetheringUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForTetheringUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForTetheringUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForTetheringUpdate(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__TetheringUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForTetheringUpdate (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanService::TetheringUpdate*) parser.object)->setData(t);
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "IPv4PoolUpdate"

void serializeJson (const ::Stub::WapdmanService::IPv4PoolUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& o23 = value.getData();
        {
            ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                serializeJson((*o22), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::IPv4PoolUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::IPv4PoolUpdate& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserIPv4PoolUpdate", jsonParser__Stub__WapdmanService__IPv4PoolUpdate, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForIPv4PoolUpdate (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForIPv4PoolUpdate (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForIPv4PoolUpdate(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__IPv4PoolUpdate(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY_DATA_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForIPv4PoolUpdate (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_DATA_WAIT_FOR_RETURN);
                callParser (context, "parserStructIPv4ListPointerList_", parserStructIPv4ListPointerList_, &((::Stub::WapdmanService::IPv4PoolUpdate*) parser.object)->getDataMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_DATA_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_DATA);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "GetAccessPointsResponse"

void serializeJson (const ::Stub::WapdmanService::GetAccessPointsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAccesspoints()) {
        yajl_gen_string(g, (const unsigned char*)  "accesspoints" , 12);
        serializeJson(value.getAccesspoints(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::GetAccessPointsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::GetAccessPointsResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserGetAccessPointsResponse", jsonParser__Stub__WapdmanService__GetAccessPointsResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForGetAccessPointsResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {12,"ACCESSPOINTS", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForGetAccessPointsResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForGetAccessPointsResponse(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__GetAccessPointsResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_ACCESSPOINTS,
        KEY_ACCESSPOINTS,
        KEY_ACCESSPOINTS_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_ACCESSPOINTS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForGetAccessPointsResponse (context, (char*) p1, (size_t) p2, "accesspoints", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ACCESSPOINTS:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, KEY_ACCESSPOINTS_WAIT_FOR_RETURN);
                callParser (context, "parserStructAPList", jsonParser__Stub__WapdmanServiceTypes__StructAPList, &((::Stub::WapdmanService::GetAccessPointsResponse*) parser.object)->getAccesspointsMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_ACCESSPOINTS_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_ACCESSPOINTS);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_ACCESSPOINTS);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_ACCESSPOINTS);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "RegisterAgentRequest"

void serializeJson (const ::Stub::WapdmanService::RegisterAgentRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPath()) {
        yajl_gen_string(g, (const unsigned char*)  "path" , 4);
        const char *s = value.getPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::RegisterAgentRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::RegisterAgentRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserRegisterAgentRequest", jsonParser__Stub__WapdmanService__RegisterAgentRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForRegisterAgentRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"PATH", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForRegisterAgentRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForRegisterAgentRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__RegisterAgentRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_PATH,
        KEY_PATH,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_PATH:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegisterAgentRequest (context, (char*) p1, (size_t) p2, "path", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_PATH:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::RegisterAgentRequest*) parser.object)->replacePath(t);
                setState (context, INIT_KEY_PATH);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_PATH);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_PATH);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "UnregisterAgentRequest"

void serializeJson (const ::Stub::WapdmanService::UnregisterAgentRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPath()) {
        yajl_gen_string(g, (const unsigned char*)  "path" , 4);
        const char *s = value.getPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::UnregisterAgentRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::UnregisterAgentRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserUnregisterAgentRequest", jsonParser__Stub__WapdmanService__UnregisterAgentRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForUnregisterAgentRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"PATH", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForUnregisterAgentRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForUnregisterAgentRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__UnregisterAgentRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_PATH,
        KEY_PATH,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_PATH:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForUnregisterAgentRequest (context, (char*) p1, (size_t) p2, "path", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_PATH:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::UnregisterAgentRequest*) parser.object)->replacePath(t);
                setState (context, INIT_KEY_PATH);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_PATH);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_PATH);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "FindAccessPointRequest"

void serializeJson (const ::Stub::WapdmanService::FindAccessPointRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPattern()) {
        yajl_gen_string(g, (const unsigned char*)  "pattern" , 7);
        const char *s = value.getPattern().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::FindAccessPointRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::FindAccessPointRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserFindAccessPointRequest", jsonParser__Stub__WapdmanService__FindAccessPointRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForFindAccessPointRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {7,"PATTERN", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForFindAccessPointRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForFindAccessPointRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__FindAccessPointRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_PATTERN,
        KEY_PATTERN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_PATTERN:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForFindAccessPointRequest (context, (char*) p1, (size_t) p2, "pattern", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_PATTERN:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::FindAccessPointRequest*) parser.object)->replacePattern(t);
                setState (context, INIT_KEY_PATTERN);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_PATTERN);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_PATTERN);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "FindAccessPointResponse"

void serializeJson (const ::Stub::WapdmanService::FindAccessPointResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAccesspoint()) {
        yajl_gen_string(g, (const unsigned char*)  "accesspoint" , 11);
        const char *s = value.getAccesspoint().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::FindAccessPointResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::FindAccessPointResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserFindAccessPointResponse", jsonParser__Stub__WapdmanService__FindAccessPointResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForFindAccessPointResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {11,"ACCESSPOINT", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForFindAccessPointResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForFindAccessPointResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__FindAccessPointResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_ACCESSPOINT,
        KEY_ACCESSPOINT,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_ACCESSPOINT:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForFindAccessPointResponse (context, (char*) p1, (size_t) p2, "accesspoint", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ACCESSPOINT:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::FindAccessPointResponse*) parser.object)->replaceAccesspoint(t);
                setState (context, INIT_KEY_ACCESSPOINT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_ACCESSPOINT);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_ACCESSPOINT);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "MacAddressAsGetResponse"

void serializeJson (const ::Stub::WapdmanService::MacAddressAsGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMacaddressasget()) {
        yajl_gen_string(g, (const unsigned char*)  "macaddressasget" , 15);
        const char *s = value.getMacaddressasget().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::MacAddressAsGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::MacAddressAsGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserMacAddressAsGetResponse", jsonParser__Stub__WapdmanService__MacAddressAsGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForMacAddressAsGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {15,"MACADDRESSASGET", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForMacAddressAsGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForMacAddressAsGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__MacAddressAsGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_MACADDRESSASGET,
        KEY_MACADDRESSASGET,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_MACADDRESSASGET:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMacAddressAsGetResponse (context, (char*) p1, (size_t) p2, "macaddressasget", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MACADDRESSASGET:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::MacAddressAsGetResponse*) parser.object)->replaceMacaddressasget(t);
                setState (context, INIT_KEY_MACADDRESSASGET);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_MACADDRESSASGET);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_MACADDRESSASGET);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "AccesspointAsGetResponse"

void serializeJson (const ::Stub::WapdmanService::AccesspointAsGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAccesspointobjpath()) {
        yajl_gen_string(g, (const unsigned char*)  "accesspointobjpath" , 18);
        const char *s = value.getAccesspointobjpath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::AccesspointAsGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::AccesspointAsGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserAccesspointAsGetResponse", jsonParser__Stub__WapdmanService__AccesspointAsGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForAccesspointAsGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {18,"ACCESSPOINTOBJPATH", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForAccesspointAsGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForAccesspointAsGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__AccesspointAsGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_ACCESSPOINTOBJPATH,
        KEY_ACCESSPOINTOBJPATH,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_ACCESSPOINTOBJPATH:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForAccesspointAsGetResponse (context, (char*) p1, (size_t) p2, "accesspointobjpath", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ACCESSPOINTOBJPATH:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::AccesspointAsGetResponse*) parser.object)->replaceAccesspointobjpath(t);
                setState (context, INIT_KEY_ACCESSPOINTOBJPATH);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_ACCESSPOINTOBJPATH);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_ACCESSPOINTOBJPATH);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "InterfaceAsGetResponse"

void serializeJson (const ::Stub::WapdmanService::InterfaceAsGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInterfaceasget()) {
        yajl_gen_string(g, (const unsigned char*)  "interfaceasget" , 14);
        const char *s = value.getInterfaceasget().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::InterfaceAsGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::InterfaceAsGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserInterfaceAsGetResponse", jsonParser__Stub__WapdmanService__InterfaceAsGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForInterfaceAsGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {14,"INTERFACEASGET", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForInterfaceAsGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForInterfaceAsGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__InterfaceAsGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_INTERFACEASGET,
        KEY_INTERFACEASGET,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_INTERFACEASGET:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForInterfaceAsGetResponse (context, (char*) p1, (size_t) p2, "interfaceasget", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INTERFACEASGET:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::InterfaceAsGetResponse*) parser.object)->replaceInterfaceasget(t);
                setState (context, INIT_KEY_INTERFACEASGET);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_INTERFACEASGET);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_INTERFACEASGET);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "IPAddressAsGetResponse"

void serializeJson (const ::Stub::WapdmanService::IPAddressAsGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIpaddressasget()) {
        yajl_gen_string(g, (const unsigned char*)  "ipaddressasget" , 14);
        const char *s = value.getIpaddressasget().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::IPAddressAsGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::IPAddressAsGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserIPAddressAsGetResponse", jsonParser__Stub__WapdmanService__IPAddressAsGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForIPAddressAsGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {14,"IPADDRESSASGET", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForIPAddressAsGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForIPAddressAsGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__IPAddressAsGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_IPADDRESSASGET,
        KEY_IPADDRESSASGET,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_IPADDRESSASGET:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForIPAddressAsGetResponse (context, (char*) p1, (size_t) p2, "ipaddressasget", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IPADDRESSASGET:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::IPAddressAsGetResponse*) parser.object)->replaceIpaddressasget(t);
                setState (context, INIT_KEY_IPADDRESSASGET);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_IPADDRESSASGET);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_IPADDRESSASGET);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "HostnameAsGetResponse"

void serializeJson (const ::Stub::WapdmanService::HostnameAsGetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHostnameasget()) {
        yajl_gen_string(g, (const unsigned char*)  "hostnameasget" , 13);
        const char *s = value.getHostnameasget().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::HostnameAsGetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::HostnameAsGetResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserHostnameAsGetResponse", jsonParser__Stub__WapdmanService__HostnameAsGetResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForHostnameAsGetResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {13,"HOSTNAMEASGET", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForHostnameAsGetResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForHostnameAsGetResponse(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__HostnameAsGetResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_HOSTNAMEASGET,
        KEY_HOSTNAMEASGET,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_HOSTNAMEASGET:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForHostnameAsGetResponse (context, (char*) p1, (size_t) p2, "hostnameasget", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_HOSTNAMEASGET:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::HostnameAsGetResponse*) parser.object)->replaceHostnameasget(t);
                setState (context, INIT_KEY_HOSTNAMEASGET);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_HOSTNAMEASGET);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_HOSTNAMEASGET);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "AccessPointAddedEvent"

void serializeJson (const ::Stub::WapdmanService::AccessPointAddedEvent& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        const char *s = value.getData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::AccessPointAddedEvent& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::AccessPointAddedEvent& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserAccessPointAddedEvent", jsonParser__Stub__WapdmanService__AccessPointAddedEvent, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForAccessPointAddedEvent (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForAccessPointAddedEvent (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForAccessPointAddedEvent(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__AccessPointAddedEvent(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForAccessPointAddedEvent (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::AccessPointAddedEvent*) parser.object)->replaceData(t);
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "AccessPointRemovedEvent"

void serializeJson (const ::Stub::WapdmanService::AccessPointRemovedEvent& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        const char *s = value.getData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::AccessPointRemovedEvent& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::AccessPointRemovedEvent& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserAccessPointRemovedEvent", jsonParser__Stub__WapdmanService__AccessPointRemovedEvent, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForAccessPointRemovedEvent (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForAccessPointRemovedEvent (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForAccessPointRemovedEvent(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__AccessPointRemovedEvent(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForAccessPointRemovedEvent (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanService::AccessPointRemovedEvent*) parser.object)->replaceData(t);
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "AssociatedStationsChangedEvent"

void serializeJson (const ::Stub::WapdmanService::AssociatedStationsChangedEvent& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanService::AssociatedStationsChangedEvent& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanService::AssociatedStationsChangedEvent& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserAssociatedStationsChangedEvent", jsonParser__Stub__WapdmanService__AssociatedStationsChangedEvent, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForAssociatedStationsChangedEvent (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"DATA", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 3;
}

static int processMapKeyForAssociatedStationsChangedEvent (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForAssociatedStationsChangedEvent(s, length);
    if (i != 3 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanService__AssociatedStationsChangedEvent(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_DATA,
        KEY_DATA,
        KEY_DATA_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_DATA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForAssociatedStationsChangedEvent (context, (char*) p1, (size_t) p2, "data", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DATA:
        switch (event) {
        case PARSER_EVENT__START_MAP:
            {
                setState (context, KEY_DATA_WAIT_FOR_RETURN);
                callParser (context, "parserStructAssociatedStationsChanged", jsonParser__Stub__WapdmanServiceTypes__StructAssociatedStationsChanged, &((::Stub::WapdmanService::AssociatedStationsChangedEvent*) parser.object)->getDataMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_DATA_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_DATA);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_DATA);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::SetSSIDRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::DeAuthenticateStationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::BlacklistStationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::SetOperatingChannelsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::RegisterVendorServiceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::UnregisterVendorServiceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::GetAssociatedStationsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::GetRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::GetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::SSIDGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::SecurityRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::SecurityResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::MacAddressGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::InterfaceGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::PassphraseGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::PoweredGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::HiddenGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::CurrentOperatingChannelGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::VendorIEsGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::PoweredSetRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::HiddenSetRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::PassphraseSetRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::TetheringSetRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::PowerStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::PowerFailureReasonUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::CurrentHwModeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::MaximumStationsAllowedUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::SupportedChannelsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::HWFeaturesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::TetheringUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::IPv4PoolUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::GetAccessPointsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::RegisterAgentRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::UnregisterAgentRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::FindAccessPointRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::FindAccessPointResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::MacAddressAsGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::AccesspointAsGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::InterfaceAsGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::IPAddressAsGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::HostnameAsGetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::AccessPointAddedEvent& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::AccessPointRemovedEvent& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanService {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanService::AssociatedStationsChangedEvent& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanService
} // namespace Stub

