/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "Stub/WapdmanService.h"
#include "Stub/WapdmanServiceTypes.h"
#include "Stub/WapdmanServiceTypesCmsBin.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/PrimitivesReader.h"
#include "asf/stream/PrimitivesWriter.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include <vector>


// CmsBin serialize and deserialize function of structure SetSSIDRequest

void serializeCmsBin (const ::Stub::WapdmanService::SetSSIDRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::std::vector< uint8 >* o0 = &in.getSsid();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o0->size() <= UINT32_MAX );
        out << static_cast<uint32>(o0->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::std::vector< uint8 >::const_iterator o1 = o0->end();
    for (::std::vector< uint8 >::const_iterator o2 = o0->begin(); o2 != o1; o2++){
        out << (*o2);
    }
    out << in.getUtf_ssid();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::SetSSIDRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o3;
    if (!(in >> o3)) {
        return false;
    }

    uint8 o4;
    // increase capacity of list
    out.getSsidMutable().reserve(o3);
    for (uint32 index_o3 = 0; index_o3 < o3; index_o3++) {
        if (!(in >> o4)) {
            return false;
        }
        out.getSsidMutable().push_back(o4);
    }

    bool utf_ssidValue;
    if (!(in >> utf_ssidValue)) {
        return false;
    }
    out.setUtf_ssid(utf_ssidValue);

    return true;
}

// CmsBin serialize and deserialize function of structure DeAuthenticateStationRequest

void serializeCmsBin (const ::Stub::WapdmanService::DeAuthenticateStationRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getAddress();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::DeAuthenticateStationRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getAddressMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure BlacklistStationRequest

void serializeCmsBin (const ::Stub::WapdmanService::BlacklistStationRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getAddress();
    out << in.getAllow();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::BlacklistStationRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getAddressMutable())) {
        return false;
    }

    bool allowValue;
    if (!(in >> allowValue)) {
        return false;
    }
    out.setAllow(allowValue);

    return true;
}

// CmsBin serialize and deserialize function of structure SetOperatingChannelsRequest

void serializeCmsBin (const ::Stub::WapdmanService::SetOperatingChannelsRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::std::vector< uint16 >* o5 = &in.getChannels();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o5->size() <= UINT32_MAX );
        out << static_cast<uint32>(o5->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::std::vector< uint16 >::const_iterator o6 = o5->end();
    for (::std::vector< uint16 >::const_iterator o7 = o5->begin(); o7 != o6; o7++){
        out << (*o7);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::SetOperatingChannelsRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o8;
    if (!(in >> o8)) {
        return false;
    }

    uint16 o9;
    // increase capacity of list
    out.getChannelsMutable().reserve(o8);
    for (uint32 index_o8 = 0; index_o8 < o8; index_o8++) {
        if (!(in >> o9)) {
            return false;
        }
        out.getChannelsMutable().push_back(o9);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure RegisterVendorServiceRequest

void serializeCmsBin (const ::Stub::WapdmanService::RegisterVendorServiceRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::boost::ptr_vector< ::std::vector< uint8 > >* o10 = &in.getIEs();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o10->size() <= UINT32_MAX );
        out << static_cast<uint32>(o10->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::std::vector< uint8 > >::const_iterator o11 = o10->end();
    for (::boost::ptr_vector< ::std::vector< uint8 > >::const_iterator o12 = o10->begin(); o12 != o11; o12++){
        const ::std::vector< uint8 >* o13 = &(*o12);

        // list length
        {
            LOG_SYSTEM_LOGGER();
            LOG_ASSERT_STATIC(o13->size() <= UINT32_MAX );
            out << static_cast<uint32>(o13->size());
             // the size is encoded as a 32 bit value in cmsbin format
        }

        // list content
        ::std::vector< uint8 >::const_iterator o14 = o13->end();
        for (::std::vector< uint8 >::const_iterator o15 = o13->begin(); o15 != o14; o15++){
            out << (*o15);
        }
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::RegisterVendorServiceRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o16;
    if (!(in >> o16)) {
        return false;
    }

    // increase capacity of list
    out.getIEsMutable().reserve(o16);
    for (uint32 index_o16 = 0; index_o16 < o16; index_o16++) {
        ::std::vector< uint8 >* o17 = new ::std::vector< uint8 >();
        CHECK_ALLOCATION(o17);
        uint32 o18;
        if (!(in >> o18)) {
            delete o17;
            return false;
        }

        uint8 o19;
        // increase capacity of list
        (*o17).reserve(o18);
        for (uint32 index_o18 = 0; index_o18 < o18; index_o18++) {
            if (!(in >> o19)) {
                delete o17;
                return false;
            }
            (*o17).push_back(o19);
        }
        out.getIEsMutable().push_back(o17);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure UnregisterVendorServiceRequest

void serializeCmsBin (const ::Stub::WapdmanService::UnregisterVendorServiceRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::boost::ptr_vector< ::std::vector< uint8 > >* o20 = &in.getIEs();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o20->size() <= UINT32_MAX );
        out << static_cast<uint32>(o20->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::std::vector< uint8 > >::const_iterator o21 = o20->end();
    for (::boost::ptr_vector< ::std::vector< uint8 > >::const_iterator o22 = o20->begin(); o22 != o21; o22++){
        const ::std::vector< uint8 >* o23 = &(*o22);

        // list length
        {
            LOG_SYSTEM_LOGGER();
            LOG_ASSERT_STATIC(o23->size() <= UINT32_MAX );
            out << static_cast<uint32>(o23->size());
             // the size is encoded as a 32 bit value in cmsbin format
        }

        // list content
        ::std::vector< uint8 >::const_iterator o24 = o23->end();
        for (::std::vector< uint8 >::const_iterator o25 = o23->begin(); o25 != o24; o25++){
            out << (*o25);
        }
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::UnregisterVendorServiceRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o26;
    if (!(in >> o26)) {
        return false;
    }

    // increase capacity of list
    out.getIEsMutable().reserve(o26);
    for (uint32 index_o26 = 0; index_o26 < o26; index_o26++) {
        ::std::vector< uint8 >* o27 = new ::std::vector< uint8 >();
        CHECK_ALLOCATION(o27);
        uint32 o28;
        if (!(in >> o28)) {
            delete o27;
            return false;
        }

        uint8 o29;
        // increase capacity of list
        (*o27).reserve(o28);
        for (uint32 index_o28 = 0; index_o28 < o28; index_o28++) {
            if (!(in >> o29)) {
                delete o27;
                return false;
            }
            (*o27).push_back(o29);
        }
        out.getIEsMutable().push_back(o27);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure GetAssociatedStationsResponse

void serializeCmsBin (const ::Stub::WapdmanService::GetAssociatedStationsResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList >* o30 = &in.getAssociatedstations();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o30->size() <= UINT32_MAX );
        out << static_cast<uint32>(o30->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList >::const_iterator o31 = o30->end();
    for (::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList >::const_iterator o32 = o30->begin(); o32 != o31; o32++){
        serializeCmsBin((*o32), out);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::GetAssociatedStationsResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o33;
    if (!(in >> o33)) {
        return false;
    }

    // increase capacity of list
    out.getAssociatedstationsMutable().reserve(o33);
    for (uint32 index_o33 = 0; index_o33 < o33; index_o33++) {
        ::Stub::WapdmanServiceTypes::StructASList* o34 = new ::Stub::WapdmanServiceTypes::StructASList();
        CHECK_ALLOCATION(o34);
        if (!::deserializeCmsBin(in, (*o34))) {
            delete o34;
            return false;
        }
        out.getAssociatedstationsMutable().push_back(o34);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure GetRequest

void serializeCmsBin (const ::Stub::WapdmanService::GetRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getInterface_name();
    out << in.getProperty_name();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::GetRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getInterface_nameMutable())) {
        return false;
    }

    if (!(in >> out.getProperty_nameMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure GetResponse

void serializeCmsBin (const ::Stub::WapdmanService::GetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getValue();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::GetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getValueMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure SSIDGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::SSIDGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::std::vector< uint8 >* o35 = &in.getSsid();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o35->size() <= UINT32_MAX );
        out << static_cast<uint32>(o35->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::std::vector< uint8 >::const_iterator o36 = o35->end();
    for (::std::vector< uint8 >::const_iterator o37 = o35->begin(); o37 != o36; o37++){
        out << (*o37);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::SSIDGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o38;
    if (!(in >> o38)) {
        return false;
    }

    uint8 o39;
    // increase capacity of list
    out.getSsidMutable().reserve(o38);
    for (uint32 index_o38 = 0; index_o38 < o38; index_o38++) {
        if (!(in >> o39)) {
            return false;
        }
        out.getSsidMutable().push_back(o39);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure SecurityRequest

void serializeCmsBin (const ::Stub::WapdmanService::SecurityRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getSecurity();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::SecurityRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getSecurityMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure SecurityResponse

void serializeCmsBin (const ::Stub::WapdmanService::SecurityResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getSecurity();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::SecurityResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getSecurityMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure MacAddressGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::MacAddressGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getMacaddress();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::MacAddressGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getMacaddressMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure InterfaceGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::InterfaceGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getInterface();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::InterfaceGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getInterfaceMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure PassphraseGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::PassphraseGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getPassphrase();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::PassphraseGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getPassphraseMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure PoweredGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::PoweredGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getPowered();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::PoweredGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    bool poweredValue;
    if (!(in >> poweredValue)) {
        return false;
    }
    out.setPowered(poweredValue);

    return true;
}

// CmsBin serialize and deserialize function of structure HiddenGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::HiddenGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getHidden();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::HiddenGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    bool hiddenValue;
    if (!(in >> hiddenValue)) {
        return false;
    }
    out.setHidden(hiddenValue);

    return true;
}

// CmsBin serialize and deserialize function of structure CurrentOperatingChannelGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::CurrentOperatingChannelGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getCurrentoperatingchannel();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::CurrentOperatingChannelGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint16 currentoperatingchannelValue;
    if (!(in >> currentoperatingchannelValue)) {
        return false;
    }
    out.setCurrentoperatingchannel(currentoperatingchannelValue);

    return true;
}

// CmsBin serialize and deserialize function of structure VendorIEsGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::VendorIEsGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::std::vector< uint16 >* o40 = &in.getVendorIEs();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o40->size() <= UINT32_MAX );
        out << static_cast<uint32>(o40->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::std::vector< uint16 >::const_iterator o41 = o40->end();
    for (::std::vector< uint16 >::const_iterator o42 = o40->begin(); o42 != o41; o42++){
        out << (*o42);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::VendorIEsGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o43;
    if (!(in >> o43)) {
        return false;
    }

    uint16 o44;
    // increase capacity of list
    out.getVendorIEsMutable().reserve(o43);
    for (uint32 index_o43 = 0; index_o43 < o43; index_o43++) {
        if (!(in >> o44)) {
            return false;
        }
        out.getVendorIEsMutable().push_back(o44);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure PoweredSetRequest

void serializeCmsBin (const ::Stub::WapdmanService::PoweredSetRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getPowered();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::PoweredSetRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    bool poweredValue;
    if (!(in >> poweredValue)) {
        return false;
    }
    out.setPowered(poweredValue);

    return true;
}

// CmsBin serialize and deserialize function of structure HiddenSetRequest

void serializeCmsBin (const ::Stub::WapdmanService::HiddenSetRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getHidden();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::HiddenSetRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    bool hiddenValue;
    if (!(in >> hiddenValue)) {
        return false;
    }
    out.setHidden(hiddenValue);

    return true;
}

// CmsBin serialize and deserialize function of structure PassphraseSetRequest

void serializeCmsBin (const ::Stub::WapdmanService::PassphraseSetRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getPassphrase();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::PassphraseSetRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getPassphraseMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure TetheringSetRequest

void serializeCmsBin (const ::Stub::WapdmanService::TetheringSetRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getTethering();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::TetheringSetRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    bool tetheringValue;
    if (!(in >> tetheringValue)) {
        return false;
    }
    out.setTethering(tetheringValue);

    return true;
}

// CmsBin serialize and deserialize function of structure PowerStateUpdate

void serializeCmsBin (const ::Stub::WapdmanService::PowerStateUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getData();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::PowerStateUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getDataMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure PowerFailureReasonUpdate

void serializeCmsBin (const ::Stub::WapdmanService::PowerFailureReasonUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getData();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::PowerFailureReasonUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getDataMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure CurrentHwModeUpdate

void serializeCmsBin (const ::Stub::WapdmanService::CurrentHwModeUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getData();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::CurrentHwModeUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getDataMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure MaximumStationsAllowedUpdate

void serializeCmsBin (const ::Stub::WapdmanService::MaximumStationsAllowedUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getData();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::MaximumStationsAllowedUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint16 dataValue;
    if (!(in >> dataValue)) {
        return false;
    }
    out.setData(dataValue);

    return true;
}

// CmsBin serialize and deserialize function of structure SupportedChannelsUpdate

void serializeCmsBin (const ::Stub::WapdmanService::SupportedChannelsUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >* o45 = &in.getData();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o45->size() <= UINT32_MAX );
        out << static_cast<uint32>(o45->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >::const_iterator o46 = o45->end();
    for (::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >::const_iterator o47 = o45->begin(); o47 != o46; o47++){
        serializeCmsBin((*o47), out);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::SupportedChannelsUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o48;
    if (!(in >> o48)) {
        return false;
    }

    // increase capacity of list
    out.getDataMutable().reserve(o48);
    for (uint32 index_o48 = 0; index_o48 < o48; index_o48++) {
        ::Stub::WapdmanServiceTypes::SupportedChannelsList* o49 = new ::Stub::WapdmanServiceTypes::SupportedChannelsList();
        CHECK_ALLOCATION(o49);
        if (!::deserializeCmsBin(in, (*o49))) {
            delete o49;
            return false;
        }
        out.getDataMutable().push_back(o49);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure HWFeaturesUpdate

void serializeCmsBin (const ::Stub::WapdmanService::HWFeaturesUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >* o50 = &in.getData();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o50->size() <= UINT32_MAX );
        out << static_cast<uint32>(o50->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >::const_iterator o51 = o50->end();
    for (::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >::const_iterator o52 = o50->begin(); o52 != o51; o52++){
        serializeCmsBin((*o52), out);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::HWFeaturesUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o53;
    if (!(in >> o53)) {
        return false;
    }

    // increase capacity of list
    out.getDataMutable().reserve(o53);
    for (uint32 index_o53 = 0; index_o53 < o53; index_o53++) {
        ::Stub::WapdmanServiceTypes::StructHWFeaturesList* o54 = new ::Stub::WapdmanServiceTypes::StructHWFeaturesList();
        CHECK_ALLOCATION(o54);
        if (!::deserializeCmsBin(in, (*o54))) {
            delete o54;
            return false;
        }
        out.getDataMutable().push_back(o54);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure TetheringUpdate

void serializeCmsBin (const ::Stub::WapdmanService::TetheringUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getData();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::TetheringUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    bool dataValue;
    if (!(in >> dataValue)) {
        return false;
    }
    out.setData(dataValue);

    return true;
}

// CmsBin serialize and deserialize function of structure IPv4PoolUpdate

void serializeCmsBin (const ::Stub::WapdmanService::IPv4PoolUpdate& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >* o55 = &in.getData();

    // list length
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_STATIC(o55->size() <= UINT32_MAX );
        out << static_cast<uint32>(o55->size());
         // the size is encoded as a 32 bit value in cmsbin format
    }

    // list content
    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >::const_iterator o56 = o55->end();
    for (::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >::const_iterator o57 = o55->begin(); o57 != o56; o57++){
        serializeCmsBin((*o57), out);
    }
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::IPv4PoolUpdate& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    uint32 o58;
    if (!(in >> o58)) {
        return false;
    }

    // increase capacity of list
    out.getDataMutable().reserve(o58);
    for (uint32 index_o58 = 0; index_o58 < o58; index_o58++) {
        ::Stub::WapdmanServiceTypes::StructIPv4List* o59 = new ::Stub::WapdmanServiceTypes::StructIPv4List();
        CHECK_ALLOCATION(o59);
        if (!::deserializeCmsBin(in, (*o59))) {
            delete o59;
            return false;
        }
        out.getDataMutable().push_back(o59);
    }

    return true;
}

// CmsBin serialize and deserialize function of structure GetAccessPointsResponse

void serializeCmsBin (const ::Stub::WapdmanService::GetAccessPointsResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    serializeCmsBin(in.getAccesspoints(), out);
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::GetAccessPointsResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!::deserializeCmsBin(in, out.getAccesspointsMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure RegisterAgentRequest

void serializeCmsBin (const ::Stub::WapdmanService::RegisterAgentRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getPath();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::RegisterAgentRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getPathMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure UnregisterAgentRequest

void serializeCmsBin (const ::Stub::WapdmanService::UnregisterAgentRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getPath();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::UnregisterAgentRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getPathMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure FindAccessPointRequest

void serializeCmsBin (const ::Stub::WapdmanService::FindAccessPointRequest& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getPattern();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::FindAccessPointRequest& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getPatternMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure FindAccessPointResponse

void serializeCmsBin (const ::Stub::WapdmanService::FindAccessPointResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getAccesspoint();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::FindAccessPointResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getAccesspointMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure MacAddressAsGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::MacAddressAsGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getMacaddressasget();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::MacAddressAsGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getMacaddressasgetMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure AccesspointAsGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::AccesspointAsGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getAccesspointobjpath();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::AccesspointAsGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getAccesspointobjpathMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure InterfaceAsGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::InterfaceAsGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getInterfaceasget();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::InterfaceAsGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getInterfaceasgetMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure IPAddressAsGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::IPAddressAsGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getIpaddressasget();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::IPAddressAsGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getIpaddressasgetMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure HostnameAsGetResponse

void serializeCmsBin (const ::Stub::WapdmanService::HostnameAsGetResponse& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getHostnameasget();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::HostnameAsGetResponse& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getHostnameasgetMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure AccessPointAddedEvent

void serializeCmsBin (const ::Stub::WapdmanService::AccessPointAddedEvent& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getData();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::AccessPointAddedEvent& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getDataMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure AccessPointRemovedEvent

void serializeCmsBin (const ::Stub::WapdmanService::AccessPointRemovedEvent& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    out << in.getData();
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::AccessPointRemovedEvent& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!(in >> out.getDataMutable())) {
        return false;
    }

    return true;
}

// CmsBin serialize and deserialize function of structure AssociatedStationsChangedEvent

void serializeCmsBin (const ::Stub::WapdmanService::AssociatedStationsChangedEvent& in, ::asf::stream::PrimitivesWriter& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    serializeCmsBin(in.getData(), out);
}

bool deserializeCmsBin (::asf::stream::PrimitivesReader& in, ::Stub::WapdmanService::AssociatedStationsChangedEvent& out) {
    (void)in; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)out; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    if (!::deserializeCmsBin(in, out.getDataMutable())) {
        return false;
    }

    return true;
}

