/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "Proxy/client/WapdmanClientComponent.h"
#include "Stub/WapdmanServiceStubStreamerFactory.h"
#include "Stub/server/WapdmanServerComponent.h"
#include "Stub/server/WapdmanTA.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/cms/CmsSocketServerConnector.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cms/Connectors.h"
#include "com/bosch/cm/asf/lang/cms/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "WapdmanTA" isn't clear, then there should be a description here.
 */

namespace Stub {
namespace server {

DEFINE_LOGGER_AND_LEVEL (_logger, "/Stub/server/WapdmanTA", Info);

/* static */ const char* WapdmanTA::StubComponent = "StubComponent";
/* static */ const char* WapdmanTA::ProxyComponent = "ProxyComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool WapdmanTA_enabledASFSignalHandler = false;

void importWapdmanTA() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach WapdmanTA, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::cms::Connectors::CmsSocketServerConnector connectorCmsJson;
    {
        ::com::bosch::cm::asf::lang::cms::Connectors::CmsSocketServerConnector __expression0;
        {
            __expression0.setEncoding(::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json);
            __expression0.setPortNumber(12334);
        }
        connectorCmsJson = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (connectorCmsJson, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "connectorCmsJson", "CmsSocketServerConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cms::CmsSocketServerConnector > connectorCmsJson_(new ::asf::cms::CmsSocketServerConnector(*app, connectorCmsJson));
    app->addStarter(connectorCmsJson_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Thread 'th_WapdmanTA'

    ::asf::core::ComponentContainerSharedPtr Th_WapdmanTA(new ::asf::core::ComponentContainer("th_WapdmanTA", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Th_WapdmanTA);

        // Component 'WapdmanServerComponent StubComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::Stub::server::WapdmanServerComponent > > stubComponentFactory(new ::asf::core::ComponentFactory< ::Stub::server::WapdmanServerComponent >);
        ::asf::core::ComponentDescriptionSharedPtr stubComponentDescription(new ::asf::core::ComponentDescription(1, "StubComponent", /* immediate = */ true, /* threadBridge = */ false, stubComponentFactory));
        Th_WapdmanTA->addComponentDescription(stubComponentDescription);

            // Port 'wapdmanservice'

            ::asf::core::ProvidedPort& StubComponent_wapdmanservice = stubComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("Stub.WapdmanService", "wapdmanservice", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)StubComponent_wapdmanservice; // prevent unused variable warning

        // Component 'WapdmanClientComponent ProxyComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::Proxy::client::WapdmanClientComponent > > proxyComponentFactory(new ::asf::core::ComponentFactory< ::Proxy::client::WapdmanClientComponent >);
        ::asf::core::ComponentDescriptionSharedPtr proxyComponentDescription(new ::asf::core::ComponentDescription(2, "ProxyComponent", /* immediate = */ true, /* threadBridge = */ false, proxyComponentFactory));
        Th_WapdmanTA->addComponentDescription(proxyComponentDescription);

            // Port 'mgrPort'

            ::asf::core::RequiredPort& ProxyComponent_mgrPort = proxyComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.Manager", "mgrPort"));
            (void)ProxyComponent_mgrPort; // prevent unused variable warning

            // Port 'tsPort'

            ::asf::core::RequiredPort& ProxyComponent_tsPort = proxyComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.Accesspoint.TetheringSettings", "tsPort"));
            (void)ProxyComponent_tsPort; // prevent unused variable warning

            // Port 'dhcpdnsPort'

            ::asf::core::RequiredPort& ProxyComponent_dhcpdnsPort = proxyComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.Accesspoint.DHCPDNSConfiguration", "dhcpdnsPort"));
            (void)ProxyComponent_dhcpdnsPort; // prevent unused variable warning

            // Port 'apPort'

            ::asf::core::RequiredPort& ProxyComponent_apPort = proxyComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.Accesspoint", "apPort", /* wired at runtime */ true));
            (void)ProxyComponent_apPort; // prevent unused variable warning

            // Port 'asPort'

            ::asf::core::RequiredPort& ProxyComponent_asPort = proxyComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wapdman.AssociatedStation", "asPort", /* wired at runtime */ true));
            (void)ProxyComponent_asPort; // prevent unused variable warning

            // Port 'propertiesPort'

            ::asf::core::RequiredPort& ProxyComponent_propertiesPort = proxyComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.DBus.Properties", "propertiesPort", /* wired at runtime */ true));
            (void)ProxyComponent_propertiesPort; // prevent unused variable warning

    // Expression

    ::boost::shared_ptr< ::asf::cms::CmsServiceStreamer > _streamer_0 = ::Stub::WapdmanService::WapdmanServiceStubStreamerFactory::getStreamer(connectorCmsJson.getEncoding());
    LOG_ASSERT_FATAL_STATIC (_streamer_0);
    connectorCmsJson_->exportByName (StubComponent_wapdmanservice, ::std::string("WapdmanService")).setStreamer(_streamer_0);

    // Expression

    ::asf::dbus::DBusImportedPort& managerPort = dbusSystemConnector_->importByName (::std::string("org.bosch.wapdman"), ::std::string("/org/bosch/wapdman/Manager"));
    managerPort.setServiceName("org.bosch.wapdman.Manager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ProxyComponent_mgrPort, managerPort);

    // Expression

    ::asf::dbus::DBusImportedPort& tetheringsettingsPort = dbusSystemConnector_->importByName (::std::string("org.bosch.wapdman"), ::std::string("/org/bosch/wapdman/wlan1/AccessPoint_34_c7_31_ff_c9_34"));
    tetheringsettingsPort.setServiceName("org.bosch.wapdman.Accesspoint.TetheringSettings");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ProxyComponent_tsPort, tetheringsettingsPort);

    // Expression

    ::asf::dbus::DBusImportedPort& dhcpdnsconfigurationPort = dbusSystemConnector_->importByName (::std::string("org.bosch.wapdman"), ::std::string("/org/bosch/wapdman/wlan1/AccessPoint_34_c7_31_ff_c9_34"));
    dhcpdnsconfigurationPort.setServiceName("org.bosch.wapdman.Accesspoint.DHCPDNSConfiguration");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ProxyComponent_dhcpdnsPort, dhcpdnsconfigurationPort);


    LOG_INFO_STATIC("Starting application 'WapdmanTA' version 1.0.0");

    app->start();
}

int executeWapdmanTA(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("Stub.server", "WapdmanTA");
    } else {
        ::asf::core::Logger::setupLogging ("Stub.server", "WapdmanTA", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", WapdmanTA_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("Stub.server", "WapdmanTA", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create WapdmanTA");

    app->enableExceptionHandler(true);

    importWapdmanTA();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace server
} // namespace Stub

int main(int argc, char* argv[]) {
    ::Stub::server::WapdmanTA_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::Stub::server::executeWapdmanTA(argc, argv);
}

