/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/TestComponent.h"
#include "com/bosch/TestContainerApplication.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "TestContainerApplication" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {

DEFINE_LOGGER_AND_LEVEL (_logger, "/com/bosch/TestContainerApplication", Info);

/* static */ const char* TestContainerApplication::testComponent = "testComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool TestContainerApplication_enabledASFSignalHandler = false;

void importTestContainerApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach TestContainerApplication, because no Application is instantiated");

    // Expression

    cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'Thread1'

    ::asf::core::ComponentContainerSharedPtr Thread1(new ::asf::core::ComponentContainer("Thread1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Thread1);

        // Component 'TestComponent testComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::com::bosch::TestComponent > > testComponentFactory(new ::asf::core::ComponentFactory< ::com::bosch::TestComponent >);
        ::asf::core::ComponentDescriptionSharedPtr testComponentDescription(new ::asf::core::ComponentDescription(1, "testComponent", /* immediate = */ true, /* threadBridge = */ false, testComponentFactory));
        Thread1->addComponentDescription(testComponentDescription);

            // Port 'NativeService1Port'

            ::asf::core::RequiredPort& testComponent_NativeService1Port = testComponentDescription->addRequiredPort (::asf::core::RequiredPort ("com.bosch.NativeService1", "NativeService1Port"));
            (void)testComponent_NativeService1Port; // prevent unused variable warning

            // Port 'NativeService2Port'

            ::asf::core::RequiredPort& testComponent_NativeService2Port = testComponentDescription->addRequiredPort (::asf::core::RequiredPort ("com.bosch.NativeService2", "NativeService2Port"));
            (void)testComponent_NativeService2Port; // prevent unused variable warning

            // Port 'cManagerPort'

            ::asf::core::RequiredPort& testComponent_cManagerPort = testComponentDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Manager", "cManagerPort"));
            (void)testComponent_cManagerPort; // prevent unused variable warning

            // Port 'cSessionPort'

            ::asf::core::RequiredPort& testComponent_cSessionPort = testComponentDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Session", "cSessionPort"));
            (void)testComponent_cSessionPort; // prevent unused variable warning

            // Port 'LCMProxyPort'

            ::asf::core::RequiredPort& testComponent_LCMProxyPort = testComponentDescription->addRequiredPort (::asf::core::RequiredPort ("com.bosch.AutomotiveProxy.LifeCycleManager", "LCMProxyPort"));
            (void)testComponent_LCMProxyPort; // prevent unused variable warning

            // Port 'AMProxyPort'

            ::asf::core::RequiredPort& testComponent_AMProxyPort = testComponentDescription->addRequiredPort (::asf::core::RequiredPort ("com.bosch.AutomotiveProxy.AudioManager", "AMProxyPort"));
            (void)testComponent_AMProxyPort; // prevent unused variable warning

            // Port 'cNotificationPort'

            ::asf::core::ProvidedPort& testComponent_cNotificationPort = testComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("net.connman.Notification", "cNotificationPort", false, false));
            (void)testComponent_cNotificationPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& nativeService1 = dbusConnector_->importByName (::std::string("com.bosch.NativeTestApplication"), ::std::string("/org/bosch/cm/ai_security/NativeService1"));
    nativeService1.setServiceName("com.bosch.NativeService1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testComponent_NativeService1Port, nativeService1);

    // Expression

    ::asf::dbus::DBusImportedPort& nativeService2 = dbusConnector_->importByName (::std::string("com.bosch.NativeTestApplication"), ::std::string("/org/bosch/cm/ai_security/NativeService2"));
    nativeService2.setServiceName("com.bosch.NativeService2");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testComponent_NativeService2Port, nativeService2);

    // Expression

    ::asf::dbus::DBusImportedPort& connmanManagerImport = dbusConnector_->importByName (::std::string("net.connman"), ::std::string("/"));
    connmanManagerImport.setServiceName("net.connman.Manager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testComponent_cManagerPort, connmanManagerImport);

    // Expression

    ::asf::dbus::DBusImportedPort& connmanSessionImport = dbusConnector_->importByName (::std::string("net.connman"), ::std::string("net.connman.session"));
    connmanSessionImport.setServiceName("net.connman.Session");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testComponent_cSessionPort, connmanSessionImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LCMProxyImport = dbusConnector_->importByName (::std::string("com.bosch.AutomotiveProxy"), ::std::string("/com/bosch/AutomotiveProxy/LifeCycleManager"));
    LCMProxyImport.setServiceName("com.bosch.AutomotiveProxy.LifeCycleManager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testComponent_LCMProxyPort, LCMProxyImport);

    // Expression

    ::asf::dbus::DBusImportedPort& AMProxyImport = dbusConnector_->importByName (::std::string("com.bosch.AutomotiveProxy"), ::std::string("/com/bosch/AutomotiveProxy/AudioManager"));
    AMProxyImport.setServiceName("com.bosch.AutomotiveProxy.AudioManager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testComponent_AMProxyPort, AMProxyImport);

    // Expression

    dbusConnector_->exportByName (testComponent_cNotificationPort, ::std::string("/org/bosch/cm/ai_security/TestContainerComponentNotification"));


    LOG_INFO_STATIC("Starting application 'TestContainerApplication' version 0.1.0");

    app->start();
}

int executeTestContainerApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("com.bosch", "TestContainerApplication");
    } else {
        ::asf::core::Logger::setupLogging ("com.bosch", "TestContainerApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", TestContainerApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("com.bosch", "TestContainerApplication", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create TestContainerApplication");

    app->enableExceptionHandler(true);

    importTestContainerApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace bosch
} // namespace com

int main(int argc, char* argv[]) {
    ::com::bosch::TestContainerApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::com::bosch::executeTestContainerApplication(argc, argv);
}

