/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "org/bosch/cm/lcm/startupcontroller/StartupController.h"
#include "org/bosch/cm/lcm/startupcontroller/StartupControllerComponent.h"
#include <cstdio>
#include <string>

/**
 * Application StartupController
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace startupcontroller {

DEFINE_LOGGER_AND_LEVEL (_logger, "/org/bosch/cm/lcm/startupcontroller/StartupController", Info);

/* static */ const char* StartupController::startupController = "startupController";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool StartupController_enabledASFSignalHandler = false;

void importStartupController() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach StartupController, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Thread 'StartupControllerThread'

    ::asf::core::ComponentContainerSharedPtr StartupControllerThread(new ::asf::core::ComponentContainer("StartupControllerThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (StartupControllerThread);

        // Component 'StartupControllerComponent startupController'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::bosch::cm::lcm::startupcontroller::StartupControllerComponent > > startupControllerFactory(new ::asf::core::ComponentFactory< ::org::bosch::cm::lcm::startupcontroller::StartupControllerComponent >);
        ::asf::core::ComponentDescriptionSharedPtr startupControllerDescription(new ::asf::core::ComponentDescription(1, "startupController", /* immediate = */ true, /* threadBridge = */ false, startupControllerFactory));
        StartupControllerThread->addComponentDescription(startupControllerDescription);

            // Port 'StartupControllerPort'

            ::asf::core::ProvidedPort& startupController_StartupControllerPort = startupControllerDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.lcm.startupcontroller", "StartupControllerPort", false, false));
            (void)startupController_StartupControllerPort; // prevent unused variable warning

            // Port 'DBusServiceClientPort'

            ::asf::core::RequiredPort& startupController_DBusServiceClientPort = startupControllerDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.systemd1.Service", "DBusServiceClientPort", /* wired at runtime */ true));
            (void)startupController_DBusServiceClientPort; // prevent unused variable warning

    // Expression

    dbusSystemConnector_->exportByName (startupController_StartupControllerPort, ::std::string("/org/bosch/cm/lcm/StartupController"));


    LOG_INFO_STATIC("Starting application 'StartupController' version 1.0.0");

    app->start();
}

int executeStartupController(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.lcm.startupcontroller", "StartupController");
    } else {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.lcm.startupcontroller", "StartupController", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", StartupController_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("org.bosch.cm.lcm.startupcontroller", "StartupController", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create StartupController");

    app->enableExceptionHandler(false);

    importStartupController();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace startupcontroller
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::org::bosch::cm::lcm::startupcontroller::executeStartupController(argc, argv);
}

