/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/ArgumentsJsonPrivate.h"
#include "bosch/cm/ai/hmi/screenbroker/Service.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceJson.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "ClientTerminationRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClientTerminationResponse"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDisplayIdRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::GetDisplayIdRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasScreenAreaId()) {
        yajl_gen_string(g, (const unsigned char*)  "screenAreaId" , 12);
        yajl_gen_integer(g, (long long)value.getScreenAreaId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::GetDisplayIdRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetPreferredDimensionsRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::GetPreferredDimensionsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasScreenAreaId()) {
        yajl_gen_string(g, (const unsigned char*)  "screenAreaId" , 12);
        yajl_gen_integer(g, (long long)value.getScreenAreaId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::GetPreferredDimensionsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegisterSurfaceRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::RegisterSurfaceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasScreenAreaId()) {
        yajl_gen_string(g, (const unsigned char*)  "screenAreaId" , 12);
        yajl_gen_integer(g, (long long)value.getScreenAreaId());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::RegisterSurfaceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeregisterSurfaceRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::DeregisterSurfaceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasSendToIlm()) {
        yajl_gen_string(g, (const unsigned char*)  "sendToIlm" , 9);
        yajl_gen_bool(g, (bool)value.getSendToIlm());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::DeregisterSurfaceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActivateApplicationRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ActivateApplicationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasEntryCustomAnimationType()) {
        yajl_gen_string(g, (const unsigned char*)  "entryCustomAnimationType" , 24);
        yajl_gen_integer(g, (long long)value.getEntryCustomAnimationType());
    }
    if (!isSparse || value.hasExitCustomAnimationType()) {
        yajl_gen_string(g, (const unsigned char*)  "exitCustomAnimationType" , 23);
        yajl_gen_integer(g, (long long)value.getExitCustomAnimationType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ActivateApplicationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartAnimationRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::StartAnimationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasAnimationType()) {
        yajl_gen_string(g, (const unsigned char*)  "animationType" , 13);
        yajl_gen_integer(g, (long long)value.getAnimationType());
    }
    if (!isSparse || value.hasHint()) {
        yajl_gen_string(g, (const unsigned char*)  "hint" , 4);
        yajl_gen_integer(g, (long long)value.getHint());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::StartAnimationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AttachandAnimateLayerRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::AttachandAnimateLayerRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasLayerID()) {
        yajl_gen_string(g, (const unsigned char*)  "layerID" , 7);
        yajl_gen_integer(g, (long long)value.getLayerID());
    }
    if (!isSparse || value.hasSurfaceID()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceID" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o1 = value.getSurfaceID();
        {
            ::std::vector< uint32 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasAnimationType()) {
        yajl_gen_string(g, (const unsigned char*)  "animationType" , 13);
        yajl_gen_integer(g, (long long)value.getAnimationType());
    }
    if (!isSparse || value.hasHint()) {
        yajl_gen_string(g, (const unsigned char*)  "hint" , 4);
        yajl_gen_integer(g, (long long)value.getHint());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::AttachandAnimateLayerRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowPopupRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ShowPopupRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasPopupPresentationArg()) {
        yajl_gen_string(g, (const unsigned char*)  "popupPresentationArg" , 20);
        serializeJson(value.getPopupPresentationArg(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ShowPopupRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HidePopupRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::HidePopupRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::HidePopupRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CloseOnExternalTouchRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::CloseOnExternalTouchRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::CloseOnExternalTouchRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPopupFilterRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::SetPopupFilterRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasDisableAll()) {
        yajl_gen_string(g, (const unsigned char*)  "disableAll" , 10);
        yajl_gen_bool(g, (bool)value.getDisableAll());
    }
    if (!isSparse || value.hasPopupPresentationArg()) {
        yajl_gen_string(g, (const unsigned char*)  "popupPresentationArg" , 20);
        serializeJson(value.getPopupPresentationArg(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::SetPopupFilterRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearPopupFilterRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ClearPopupFilterRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ClearPopupFilterRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KeyFeedbackRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::KeyFeedbackRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    if (!isSparse || value.hasKeyCode()) {
        yajl_gen_string(g, (const unsigned char*)  "keyCode" , 7);
        yajl_gen_integer(g, (long long)value.getKeyCode());
    }
    if (!isSparse || value.hasKeyState()) {
        yajl_gen_string(g, (const unsigned char*)  "keyState" , 8);
        const char* s = ::bosch::cm::ai::hmi::screenbroker::Types::KeyState_Name(value.getKeyState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getKeyState());
    }
    if (!isSparse || value.hasConsumed()) {
        yajl_gen_string(g, (const unsigned char*)  "consumed" , 8);
        yajl_gen_bool(g, (bool)value.getConsumed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::KeyFeedbackRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActionRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ActionRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasActionId()) {
        yajl_gen_string(g, (const unsigned char*)  "actionId" , 8);
        yajl_gen_integer(g, (long long)value.getActionId());
    }
    if (!isSparse || value.hasActionData()) {
        yajl_gen_string(g, (const unsigned char*)  "actionData" , 10);
        yajl_gen_integer(g, (long long)value.getActionData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::ActionRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetInputFocusRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::SetInputFocusRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasKeyboardFocus()) {
        yajl_gen_string(g, (const unsigned char*)  "keyboardFocus" , 13);
        yajl_gen_bool(g, (bool)value.getKeyboardFocus());
    }
    if (!isSparse || value.hasPointerFocus()) {
        yajl_gen_string(g, (const unsigned char*)  "pointerFocus" , 12);
        yajl_gen_bool(g, (bool)value.getPointerFocus());
    }
    if (!isSparse || value.hasPriority()) {
        yajl_gen_string(g, (const unsigned char*)  "priority" , 8);
        yajl_gen_integer(g, (long long)value.getPriority());
    }
    if (!isSparse || value.hasFocusData()) {
        yajl_gen_string(g, (const unsigned char*)  "focusData" , 9);
        yajl_gen_integer(g, (long long)value.getFocusData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::SetInputFocusRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestCurrentStatusRequest"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::RequestCurrentStatusRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestId()) {
        yajl_gen_string(g, (const unsigned char*)  "requestId" , 9);
        yajl_gen_integer(g, (long long)value.getRequestId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::RequestCurrentStatusRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VersionUpdate"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::VersionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "Version" , 7);
        const char *s = value.getVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::VersionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VersionRegister"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::VersionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::VersionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BuildInLayersUpdate"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBuildInLayers()) {
        yajl_gen_string(g, (const unsigned char*)  "BuildInLayers" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& o3 = value.getBuildInLayers();
        {
            ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BuildInLayersRegister"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnGetDisplayIdSignal"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnGetDisplayIdSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasDisplayId()) {
        yajl_gen_string(g, (const unsigned char*)  "displayId" , 9);
        yajl_gen_integer(g, (long long)value.getDisplayId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnGetDisplayIdSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnGetPreferredDimensionsSignal"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnGetPreferredDimensionsSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasDimensionArg()) {
        yajl_gen_string(g, (const unsigned char*)  "dimensionArg" , 12);
        serializeJson(value.getDimensionArg(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnGetPreferredDimensionsSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnSurfaceStateChangedSignal"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnSurfaceStateChangedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasDisplayId()) {
        yajl_gen_string(g, (const unsigned char*)  "displayId" , 9);
        yajl_gen_integer(g, (long long)value.getDisplayId());
    }
    if (!isSparse || value.hasDisplayAlias()) {
        yajl_gen_string(g, (const unsigned char*)  "displayAlias" , 12);
        yajl_gen_integer(g, (long long)value.getDisplayAlias());
    }
    if (!isSparse || value.hasSurfaceState()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceState" , 12);
        const char* s = ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState_Name(value.getSurfaceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSurfaceState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnSurfaceStateChangedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnErrorSignal"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnErrorSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestArg()) {
        yajl_gen_string(g, (const unsigned char*)  "requestArg" , 10);
        serializeJson(value.getRequestArg(), g, options);
    }
    if (!isSparse || value.hasSystemErrno()) {
        yajl_gen_string(g, (const unsigned char*)  "systemErrno" , 11);
        yajl_gen_integer(g, (long long)value.getSystemErrno());
    }
    if (!isSparse || value.hasPresentationErrno()) {
        yajl_gen_string(g, (const unsigned char*)  "presentationErrno" , 17);
        yajl_gen_integer(g, (long long)value.getPresentationErrno());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnErrorSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnKeyEventSignal"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnKeyEventSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasKeyCode()) {
        yajl_gen_string(g, (const unsigned char*)  "keyCode" , 7);
        yajl_gen_integer(g, (long long)value.getKeyCode());
    }
    if (!isSparse || value.hasKeyState()) {
        yajl_gen_string(g, (const unsigned char*)  "keyState" , 8);
        const char* s = ::bosch::cm::ai::hmi::screenbroker::Types::KeyState_Name(value.getKeyState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getKeyState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnKeyEventSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnCurrentStatusSignal"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnCurrentStatusSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestId()) {
        yajl_gen_string(g, (const unsigned char*)  "requestId" , 9);
        yajl_gen_integer(g, (long long)value.getRequestId());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnCurrentStatusSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnCloseOnExternalTouchSignal"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnCloseOnExternalTouchSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnCloseOnExternalTouchSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnLayerStateChangedSignal"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnLayerStateChangedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientId()) {
        yajl_gen_string(g, (const unsigned char*)  "clientId" , 8);
        const char *s = value.getClientId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRequestId()) {
        yajl_gen_string(g, (const unsigned char*)  "requestId" , 9);
        yajl_gen_integer(g, (long long)value.getRequestId());
    }
    if (!isSparse || value.hasLayerID()) {
        yajl_gen_string(g, (const unsigned char*)  "layerID" , 7);
        yajl_gen_integer(g, (long long)value.getLayerID());
    }
    if (!isSparse || value.hasLayerState()) {
        yajl_gen_string(g, (const unsigned char*)  "layerState" , 10);
        const char* s = ::bosch::cm::ai::hmi::screenbroker::Types::LayerState_Name(value.getLayerState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLayerState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Service::OnLayerStateChangedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::GetDisplayIdRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::GetPreferredDimensionsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::RegisterSurfaceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::DeregisterSurfaceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::ActivateApplicationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::StartAnimationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::AttachandAnimateLayerRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::ShowPopupRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::HidePopupRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::CloseOnExternalTouchRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::SetPopupFilterRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::ClearPopupFilterRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::KeyFeedbackRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::ActionRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::SetInputFocusRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::RequestCurrentStatusRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::VersionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::VersionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::OnGetDisplayIdSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::OnGetPreferredDimensionsSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::OnSurfaceStateChangedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::OnErrorSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::OnKeyEventSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::OnCurrentStatusSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::OnCloseOnExternalTouchSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Service::OnLayerStateChangedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

